# yum install rubygem-i18n html2text wget
require "i18n"

WNAME = 'heisenbug'
WNAME_FULL = 'Heisenbug'

# load authors' info from prepared file
authors = {}
file = File.new("authors.list", "r")
while (line = file.gets)
  tmp = line.chomp.split(", ")
  authors[tmp[0]] = tmp[1]
end
file.close

# load themes' info from prepared file
theme = {}
licences = {}
themes = []

file = File.new("themes.list", "r")
while (line = file.gets)
  tmp = line.chomp.sub(/ by /,', ').split(", ")
  theme[:name] = tmp[0]
  theme[:filename] = I18n.transliterate(tmp[0].downcase.gsub(' ','-'))
  theme[:author] = tmp[1]
  theme[:fas] = authors[theme[:author]]
  theme[:mail] = "#{theme[:fas]} AT fedoraproject DOT org"
  theme[:licence] = tmp[2]
  licence = theme[:licence].sub('CC0','publicdomain/zero').sub('CC-','licences/').split(' ').join('/').downcase
  url = "http://creativecommons.org/#{licence}/legalcode"
  licences[theme[:licence]] = url
  theme[:ext] = tmp[3]
  theme[:filename] << ".#{theme[:ext]}"
  themes << theme.dup
end
file.close

# generate licence files
licences.each do |name, url|
  filename = name.sub(' ','-')
  unless File.exists?("../#{filename}")
    cmd = "wget #{url}"
    system(cmd)
    cmd = "mv legalcode '#{filename}.html'"
    system(cmd)
    cmd = "html2text -utf8 '#{filename}.html' >> '../#{filename}' && rm -f '#{filename}.html'"
    system(cmd)
  end
end

# generate attribution, xmls and .desktops
f_attribution = File.new('../Attribution-Extras', 'w')

f_slideshow_xml = File.new("#{WNAME}-extras.xml", 'w')
f_slideshow_xml.puts <<EOF
<background>
  <starttime>
    <year>2013</year>
    <month>05</month>
    <day>16</day>
    <hour>00</hour>
    <minute>00</minute>
    <second>00</second>
  </starttime>

EOF
f_gnome_xml = File.new("gnome-backgrounds-#{WNAME}-extras.xml", 'w')
f_gnome_xml.puts <<-EOF
<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE wallpapers SYSTEM "gnome-wp-list.dtd">
<wallpapers>
EOF

f_mate_xml = File.new("mate-backgrounds-#{WNAME}-extras.xml", 'w')
f_mate_xml.puts <<-EOF
<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE wallpapers SYSTEM "mate-wp-list.dtd">
<wallpapers>
EOF

wallpaper = <<-EOF
    <wallpaper deleted="false">
        <name>#{WNAME_FULL} Supplemental Wallpapers Slideshow</name>
        <filename>/usr/share/backgrounds/#{WNAME}/extras/#{WNAME}-extras.xml</filename>
        <options>zoom</options>
    </wallpaper>

EOF
f_gnome_xml.puts wallpaper
f_mate_xml.puts wallpaper

themes.each do |theme|
  heading = "**** #{theme[:name]} ****"
  filename = "/usr/share/backgrounds/#{WNAME}/extras/#{theme[:filename]}"
  f_attribution.puts <<-EOF
#{heading}
#{heading.gsub(/.?/,'=').chop}
File:    #{filename}
Author:  #{theme[:author]}
Contact: #{theme[:mail]}
Licence: #{theme[:licence]}

  EOF

  f_slideshow_xml.puts <<-EOF
  <static>
    <duration>1800.0</duration>
    <file>#{filename}</file>
  </static>

  EOF

  wallpaper = <<-EOF
    <wallpaper deleted="false">
        <name>#{theme[:name]} (#{WNAME_FULL} Supplemental)</name>
        <filename>#{filename}</filename>
        <options>zoom</options>

        <author>#{theme[:author]}</author>
        <email>design-team@lists.fedoraproject.org</email>
        <license>#{theme[:licence]}</license>
    </wallpaper>

  EOF
  f_gnome_xml.puts wallpaper
  f_mate_xml.puts wallpaper

  f_desktop = File.new("#{theme[:filename].gsub(/\..*/,".desktop")}", "w")
  f_desktop.puts <<-EOF
[Desktop Entry]
Name=#{theme[:name]} (#{WNAME_FULL} Supplemental)
X-KDE-PluginInfo-Name=#{theme[:name]} (#{WNAME_FULL} Supplemental)
X-KDE-PluginInfo-Author=#{theme[:author]}
X-KDE-PluginInfo-Email=fedora-design@lists.fedoraproject.org
X-KDE-PluginInfo-License=#{theme[:licence]}
  EOF
  f_desktop.close
end

f_mate_xml.puts "</wallpapers>"
f_gnome_xml.puts "</wallpapers>"
f_mate_xml.close
f_gnome_xml.close

f_slideshow_xml.puts "</background>"
f_slideshow_xml.close

f_attribution.close

def prepare_image(orig, new)
  if File.exists?(orig)
    system "mv '#{orig}' '#{new}'"
  elsif !File.exists?(new)
    puts "Could not find image #{orig} or #{new}!"
  end
end

if File.exists?('img-orig')
  themes.each do |theme|
    prepare_image("img-orig/#{theme[:name]}.#{theme[:ext]}",theme[:filename])
  end
  system('rm -rf img-orig')
end

puts "Done"
