/* This file has been generated by the Perl script `afblue.pl', */
/* using data from file `afblue.dat'.                           */

/***************************************************************************/
/*                                                                         */
/*  afblue.h                                                               */
/*                                                                         */
/*    Auto-fitter data for blue strings (specification).                   */
/*                                                                         */
/*  Copyright 2013-2016 by                                                 */
/*  David Turner, Robert Wilhelm, and Werner Lemberg.                      */
/*                                                                         */
/*  This file is part of the FreeType project, and may only be used,       */
/*  modified, and distributed under the terms of the FreeType project      */
/*  license, LICENSE.TXT.  By continuing to use, modify, or distribute     */
/*  this file you indicate that you have read the license and              */
/*  understand and accept it fully.                                        */
/*                                                                         */
/***************************************************************************/


#ifndef AFBLUE_H_
#define AFBLUE_H_


FT_BEGIN_HEADER


  /* an auxiliary macro to decode a UTF-8 character -- since we only use */
  /* hard-coded, self-converted data, no error checking is performed     */
#define GET_UTF8_CHAR( ch, p )                      \
          do                                        \
          {                                         \
            ch = (unsigned char)*p++;               \
            if ( ch >= 0x80 )                       \
            {                                       \
              FT_UInt  len_;                        \
                                                    \
                                                    \
              if ( ch < 0xE0 )                      \
              {                                     \
                len_ = 1;                           \
                ch  &= 0x1F;                        \
              }                                     \
              else if ( ch < 0xF0 )                 \
              {                                     \
                len_ = 2;                           \
                ch  &= 0x0F;                        \
              }                                     \
              else                                  \
              {                                     \
                len_ = 3;                           \
                ch  &= 0x07;                        \
              }                                     \
                                                    \
              for ( ; len_ > 0; len_-- )            \
                ch = ( ch << 6 ) | ( *p++ & 0x3F ); \
            }                                       \
          } while ( 0 )


  /*************************************************************************/
  /*************************************************************************/
  /*****                                                               *****/
  /*****                    B L U E   S T R I N G S                    *****/
  /*****                                                               *****/
  /*************************************************************************/
  /*************************************************************************/

  /* At the bottommost level, we define strings for finding blue zones. */


#define AF_BLUE_STRING_MAX_LEN  51

  /* The AF_Blue_String enumeration values are offsets into the */
  /* `af_blue_strings' array.                                   */

  typedef enum  AF_Blue_String_
  {
    AF_BLUE_STRING_ARABIC_TOP = 0,
    AF_BLUE_STRING_ARABIC_BOTTOM = 18,
    AF_BLUE_STRING_ARABIC_JOIN = 33,
    AF_BLUE_STRING_ARMENIAN_CAPITAL_TOP = 36,
    AF_BLUE_STRING_ARMENIAN_CAPITAL_BOTTOM = 60,
    AF_BLUE_STRING_ARMENIAN_SMALL_ASCENDER = 84,
    AF_BLUE_STRING_ARMENIAN_SMALL_TOP = 108,
    AF_BLUE_STRING_ARMENIAN_SMALL_BOTTOM = 132,
    AF_BLUE_STRING_ARMENIAN_SMALL_DESCENDER = 156,
    AF_BLUE_STRING_BENGALI_BASE = 180,
    AF_BLUE_STRING_BENGALI_TOP = 212,
    AF_BLUE_STRING_BENGALI_HEAD = 240,
    AF_BLUE_STRING_CHEROKEE_CAPITAL = 272,
    AF_BLUE_STRING_CHEROKEE_SMALL_ASCENDER = 304,
    AF_BLUE_STRING_CHEROKEE_SMALL = 336,
    AF_BLUE_STRING_CHEROKEE_SMALL_DESCENDER = 368,
    AF_BLUE_STRING_CYRILLIC_CAPITAL_TOP = 384,
    AF_BLUE_STRING_CYRILLIC_CAPITAL_BOTTOM = 408,
    AF_BLUE_STRING_CYRILLIC_SMALL = 432,
    AF_BLUE_STRING_CYRILLIC_SMALL_DESCENDER = 456,
    AF_BLUE_STRING_DEVANAGARI_BASE = 465,
    AF_BLUE_STRING_DEVANAGARI_TOP = 497,
    AF_BLUE_STRING_DEVANAGARI_HEAD = 529,
    AF_BLUE_STRING_DEVANAGARI_BOTTOM = 561,
    AF_BLUE_STRING_ETHIOPIC_TOP = 569,
    AF_BLUE_STRING_ETHIOPIC_BOTTOM = 601,
    AF_BLUE_STRING_GEORGIAN_MKHEDRULI_TOP = 633,
    AF_BLUE_STRING_GEORGIAN_MKHEDRULI_BOTTOM = 665,
    AF_BLUE_STRING_GEORGIAN_MKHEDRULI_ASCENDER = 697,
    AF_BLUE_STRING_GEORGIAN_MKHEDRULI_DESCENDER = 729,
    AF_BLUE_STRING_GEORGIAN_ASOMTAVRULI_TOP = 761,
    AF_BLUE_STRING_GEORGIAN_ASOMTAVRULI_BOTTOM = 793,
    AF_BLUE_STRING_GEORGIAN_NUSKHURI_TOP = 825,
    AF_BLUE_STRING_GEORGIAN_NUSKHURI_BOTTOM = 857,
    AF_BLUE_STRING_GEORGIAN_NUSKHURI_ASCENDER = 889,
    AF_BLUE_STRING_GEORGIAN_NUSKHURI_DESCENDER = 921,
    AF_BLUE_STRING_GREEK_CAPITAL_TOP = 953,
    AF_BLUE_STRING_GREEK_CAPITAL_BOTTOM = 974,
    AF_BLUE_STRING_GREEK_SMALL_BETA_TOP = 992,
    AF_BLUE_STRING_GREEK_SMALL = 1010,
    AF_BLUE_STRING_GREEK_SMALL_DESCENDER = 1034,
    AF_BLUE_STRING_GUJARATI_TOP = 1058,
    AF_BLUE_STRING_GUJARATI_BOTTOM = 1090,
    AF_BLUE_STRING_GUJARATI_ASCENDER = 1122,
    AF_BLUE_STRING_GUJARATI_DESCENDER = 1172,
    AF_BLUE_STRING_GUJARATI_DIGIT_TOP = 1205,
    AF_BLUE_STRING_GURMUKHI_BASE = 1225,
    AF_BLUE_STRING_GURMUKHI_HEAD = 1257,
    AF_BLUE_STRING_GURMUKHI_TOP = 1289,
    AF_BLUE_STRING_GURMUKHI_BOTTOM = 1321,
    AF_BLUE_STRING_GURMUKHI_DIGIT_TOP = 1353,
    AF_BLUE_STRING_HEBREW_TOP = 1373,
    AF_BLUE_STRING_HEBREW_BOTTOM = 1397,
    AF_BLUE_STRING_HEBREW_DESCENDER = 1415,
    AF_BLUE_STRING_KANNADA_TOP = 1430,
    AF_BLUE_STRING_KANNADA_BOTTOM = 1474,
    AF_BLUE_STRING_KHMER_TOP = 1506,
    AF_BLUE_STRING_KHMER_SUBSCRIPT_TOP = 1530,
    AF_BLUE_STRING_KHMER_BOTTOM = 1570,
    AF_BLUE_STRING_KHMER_DESCENDER = 1602,
    AF_BLUE_STRING_KHMER_LARGE_DESCENDER = 1636,
    AF_BLUE_STRING_KHMER_SYMBOLS_WAXING_TOP = 1723,
    AF_BLUE_STRING_KHMER_SYMBOLS_WANING_BOTTOM = 1731,
    AF_BLUE_STRING_LAO_TOP = 1739,
    AF_BLUE_STRING_LAO_BOTTOM = 1771,
    AF_BLUE_STRING_LAO_ASCENDER = 1803,
    AF_BLUE_STRING_LAO_LARGE_ASCENDER = 1819,
    AF_BLUE_STRING_LAO_DESCENDER = 1831,
    AF_BLUE_STRING_LATIN_CAPITAL_TOP = 1855,
    AF_BLUE_STRING_LATIN_CAPITAL_BOTTOM = 1871,
    AF_BLUE_STRING_LATIN_SMALL_F_TOP = 1887,
    AF_BLUE_STRING_LATIN_SMALL = 1901,
    AF_BLUE_STRING_LATIN_SMALL_DESCENDER = 1915,
    AF_BLUE_STRING_LATIN_SUBS_CAPITAL_TOP = 1925,
    AF_BLUE_STRING_LATIN_SUBS_CAPITAL_BOTTOM = 1945,
    AF_BLUE_STRING_LATIN_SUBS_SMALL_F_TOP = 1965,
    AF_BLUE_STRING_LATIN_SUBS_SMALL = 1985,
    AF_BLUE_STRING_LATIN_SUBS_SMALL_DESCENDER = 2021,
    AF_BLUE_STRING_LATIN_SUPS_CAPITAL_TOP = 2041,
    AF_BLUE_STRING_LATIN_SUPS_CAPITAL_BOTTOM = 2072,
    AF_BLUE_STRING_LATIN_SUPS_SMALL_F_TOP = 2101,
    AF_BLUE_STRING_LATIN_SUPS_SMALL = 2127,
    AF_BLUE_STRING_LATIN_SUPS_SMALL_DESCENDER = 2152,
    AF_BLUE_STRING_MALAYALAM_TOP = 2163,
    AF_BLUE_STRING_MALAYALAM_BOTTOM = 2207,
    AF_BLUE_STRING_MYANMAR_TOP = 2239,
    AF_BLUE_STRING_MYANMAR_BOTTOM = 2271,
    AF_BLUE_STRING_MYANMAR_ASCENDER = 2303,
    AF_BLUE_STRING_MYANMAR_DESCENDER = 2331,
    AF_BLUE_STRING_SINHALA_TOP = 2363,
    AF_BLUE_STRING_SINHALA_BOTTOM = 2395,
    AF_BLUE_STRING_SINHALA_DESCENDER = 2427,
    AF_BLUE_STRING_TAMIL_TOP = 2471,
    AF_BLUE_STRING_TAMIL_BOTTOM = 2503,
    AF_BLUE_STRING_TELUGU_TOP = 2535,
    AF_BLUE_STRING_TELUGU_BOTTOM = 2563,
    AF_BLUE_STRING_THAI_TOP = 2591,
    AF_BLUE_STRING_THAI_BOTTOM = 2615,
    AF_BLUE_STRING_THAI_ASCENDER = 2643,
    AF_BLUE_STRING_THAI_LARGE_ASCENDER = 2655,
    AF_BLUE_STRING_THAI_DESCENDER = 2667,
    AF_BLUE_STRING_THAI_LARGE_DESCENDER = 2683,
    AF_BLUE_STRING_THAI_DIGIT_TOP = 2691,
    af_blue_1_1 = 2702,
#ifdef AF_CONFIG_OPTION_CJK
    AF_BLUE_STRING_CJK_TOP = af_blue_1_1 + 1,
    AF_BLUE_STRING_CJK_BOTTOM = af_blue_1_1 + 203,
    af_blue_1_1_1 = af_blue_1_1 + 404,
#ifdef AF_CONFIG_OPTION_CJK_BLUE_HANI_VERT
    AF_BLUE_STRING_CJK_LEFT = af_blue_1_1_1 + 1,
    AF_BLUE_STRING_CJK_RIGHT = af_blue_1_1_1 + 204,
    af_blue_1_1_2 = af_blue_1_1_1 + 405,
#else
    af_blue_1_1_2 = af_blue_1_1_1 + 0,
#endif /* AF_CONFIG_OPTION_CJK_BLUE_HANI_VERT */
    af_blue_1_2 = af_blue_1_1_2 + 0,
#else
    af_blue_1_2 = af_blue_1_1 + 0,
#endif /* AF_CONFIG_OPTION_CJK                */


    AF_BLUE_STRING_MAX   /* do not remove */

  } AF_Blue_String;


  FT_LOCAL_ARRAY( char )
  af_blue_strings[];


  /*************************************************************************/
  /*************************************************************************/
  /*****                                                               *****/
  /*****                 B L U E   S T R I N G S E T S                 *****/
  /*****                                                               *****/
  /*************************************************************************/
  /*************************************************************************/

  /* The next level is to group blue strings into style-specific sets. */


  /* Properties are specific to a writing system.  We assume that a given  */
  /* blue string can't be used in more than a single writing system, which */
  /* is a safe bet.                                                        */
#define AF_BLUE_PROPERTY_LATIN_TOP       ( 1U << 0 )  /* must have value 1 */
#define AF_BLUE_PROPERTY_LATIN_SUB_TOP   ( 1U << 1 )
#define AF_BLUE_PROPERTY_LATIN_NEUTRAL   ( 1U << 2 )
#define AF_BLUE_PROPERTY_LATIN_X_HEIGHT  ( 1U << 3 )
#define AF_BLUE_PROPERTY_LATIN_LONG      ( 1U << 4 )

#define AF_BLUE_PROPERTY_CJK_TOP    ( 1U << 0 )       /* must have value 1 */
#define AF_BLUE_PROPERTY_CJK_HORIZ  ( 1U << 1 )       /* must have value 2 */
#define AF_BLUE_PROPERTY_CJK_RIGHT  AF_BLUE_PROPERTY_CJK_TOP


#define AF_BLUE_STRINGSET_MAX_LEN  8

  /* The AF_Blue_Stringset enumeration values are offsets into the */
  /* `af_blue_stringsets' array.                                   */

  typedef enum  AF_Blue_Stringset_
  {
    AF_BLUE_STRINGSET_ARAB = 0,
    AF_BLUE_STRINGSET_ARMN = 4,
    AF_BLUE_STRINGSET_BENG = 11,
    AF_BLUE_STRINGSET_CHER = 16,
    AF_BLUE_STRINGSET_CYRL = 23,
    AF_BLUE_STRINGSET_DEVA = 29,
    AF_BLUE_STRINGSET_ETHI = 35,
    AF_BLUE_STRINGSET_GEOR = 38,
    AF_BLUE_STRINGSET_GEOK = 43,
    AF_BLUE_STRINGSET_GREK = 50,
    AF_BLUE_STRINGSET_GUJR = 57,
    AF_BLUE_STRINGSET_GURU = 63,
    AF_BLUE_STRINGSET_HEBR = 69,
    AF_BLUE_STRINGSET_KNDA = 73,
    AF_BLUE_STRINGSET_KHMR = 76,
    AF_BLUE_STRINGSET_KHMS = 82,
    AF_BLUE_STRINGSET_LAO = 85,
    AF_BLUE_STRINGSET_LATN = 91,
    AF_BLUE_STRINGSET_LATB = 98,
    AF_BLUE_STRINGSET_LATP = 105,
    AF_BLUE_STRINGSET_MLYM = 112,
    AF_BLUE_STRINGSET_MYMR = 115,
    AF_BLUE_STRINGSET_NONE = 120,
    AF_BLUE_STRINGSET_SINH = 121,
    AF_BLUE_STRINGSET_TAML = 125,
    AF_BLUE_STRINGSET_TELU = 128,
    AF_BLUE_STRINGSET_THAI = 131,
    af_blue_2_1 = 139,
#ifdef AF_CONFIG_OPTION_CJK
    AF_BLUE_STRINGSET_HANI = af_blue_2_1 + 0,
    af_blue_2_1_1 = af_blue_2_1 + 2,
#ifdef AF_CONFIG_OPTION_CJK_BLUE_HANI_VERT
    af_blue_2_1_2 = af_blue_2_1_1 + 2,
#else
    af_blue_2_1_2 = af_blue_2_1_1 + 0,
#endif /* AF_CONFIG_OPTION_CJK_BLUE_HANI_VERT */
    af_blue_2_2 = af_blue_2_1_2 + 1,
#else
    af_blue_2_2 = af_blue_2_1 + 0,
#endif /* AF_CONFIG_OPTION_CJK                */


    AF_BLUE_STRINGSET_MAX   /* do not remove */

  } AF_Blue_Stringset;


  typedef struct  AF_Blue_StringRec_
  {
    AF_Blue_String  string;
    FT_UShort       properties;

  } AF_Blue_StringRec;


  FT_LOCAL_ARRAY( AF_Blue_StringRec )
  af_blue_stringsets[];

/* */

FT_END_HEADER


#endif /* AFBLUE_H_ */


/* END */
