/* baobab-location-list.c generated by valac 0.38.1.8-0ab50-dirty, the Vala compiler
 * generated from baobab-location-list.vala, do not modify */

/* -*- tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/* Baobab - disk usage analyzer
 *
 * Copyright (C) 2012  Paolo Borelli <pborelli@gnome.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <pango/pango.h>
#include <glib/gi18n-lib.h>


#define BAOBAB_TYPE_LOCATION_ROW (baobab_location_row_get_type ())
#define BAOBAB_LOCATION_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BAOBAB_TYPE_LOCATION_ROW, BaobabLocationRow))
#define BAOBAB_LOCATION_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BAOBAB_TYPE_LOCATION_ROW, BaobabLocationRowClass))
#define BAOBAB_IS_LOCATION_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BAOBAB_TYPE_LOCATION_ROW))
#define BAOBAB_IS_LOCATION_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BAOBAB_TYPE_LOCATION_ROW))
#define BAOBAB_LOCATION_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BAOBAB_TYPE_LOCATION_ROW, BaobabLocationRowClass))

typedef struct _BaobabLocationRow BaobabLocationRow;
typedef struct _BaobabLocationRowClass BaobabLocationRowClass;
typedef struct _BaobabLocationRowPrivate BaobabLocationRowPrivate;

#define BAOBAB_TYPE_LOCATION (baobab_location_get_type ())
#define BAOBAB_LOCATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BAOBAB_TYPE_LOCATION, BaobabLocation))
#define BAOBAB_LOCATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BAOBAB_TYPE_LOCATION, BaobabLocationClass))
#define BAOBAB_IS_LOCATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BAOBAB_TYPE_LOCATION))
#define BAOBAB_IS_LOCATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BAOBAB_TYPE_LOCATION))
#define BAOBAB_LOCATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BAOBAB_TYPE_LOCATION, BaobabLocationClass))

typedef struct _BaobabLocation BaobabLocation;
typedef struct _BaobabLocationClass BaobabLocationClass;
enum  {
	BAOBAB_LOCATION_ROW_DUMMY_PROPERTY,
	BAOBAB_LOCATION_ROW_LOCATION_PROPERTY,
	BAOBAB_LOCATION_ROW_LAST_PROPERTY
};
static GParamSpec* baobab_location_row_properties[BAOBAB_LOCATION_ROW_LAST_PROPERTY];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _baobab_location_unref0(var) ((var == NULL) ? NULL : (var = (baobab_location_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define BAOBAB_TYPE_LOCATION_LIST (baobab_location_list_get_type ())
#define BAOBAB_LOCATION_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BAOBAB_TYPE_LOCATION_LIST, BaobabLocationList))
#define BAOBAB_LOCATION_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BAOBAB_TYPE_LOCATION_LIST, BaobabLocationListClass))
#define BAOBAB_IS_LOCATION_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BAOBAB_TYPE_LOCATION_LIST))
#define BAOBAB_IS_LOCATION_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BAOBAB_TYPE_LOCATION_LIST))
#define BAOBAB_LOCATION_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BAOBAB_TYPE_LOCATION_LIST, BaobabLocationListClass))

typedef struct _BaobabLocationList BaobabLocationList;
typedef struct _BaobabLocationListClass BaobabLocationListClass;
typedef struct _BaobabLocationListPrivate BaobabLocationListPrivate;
enum  {
	BAOBAB_LOCATION_LIST_DUMMY_PROPERTY,
	BAOBAB_LOCATION_LIST_LAST_PROPERTY
};
static GParamSpec* baobab_location_list_properties[BAOBAB_LOCATION_LIST_LAST_PROPERTY];
#define __g_list_free__baobab_location_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__baobab_location_unref0_ (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define __g_list_free__gtk_recent_info_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__gtk_recent_info_unref0_ (var), NULL)))
#define _gtk_recent_info_unref0(var) ((var == NULL) ? NULL : (var = (gtk_recent_info_unref (var), NULL)))

struct _BaobabLocationRow {
	GtkListBoxRow parent_instance;
	BaobabLocationRowPrivate * priv;
};

struct _BaobabLocationRowClass {
	GtkListBoxRowClass parent_class;
};

struct _BaobabLocationRowPrivate {
	GtkImage* image;
	GtkLabel* name_label;
	GtkLabel* path_label;
	GtkLabel* available_label;
	GtkLabel* total_size_label;
	GtkLevelBar* usage_bar;
	BaobabLocation* _location;
};

struct _BaobabLocationList {
	GtkBox parent_instance;
	BaobabLocationListPrivate * priv;
};

struct _BaobabLocationListClass {
	GtkBoxClass parent_class;
};

typedef void (*BaobabLocationListLocationAction) (BaobabLocation* l, void* user_data);
struct _BaobabLocationListPrivate {
	GtkListBox* local_list_box;
	GtkListBox* remote_list_box;
	GtkBox* remote_box;
	BaobabLocationListLocationAction location_action;
	gpointer location_action_target;
	GDestroyNotify location_action_target_destroy_notify;
	GVolumeMonitor* monitor;
	GList* locations;
};


static gpointer baobab_location_row_parent_class = NULL;
static gpointer baobab_location_list_parent_class = NULL;

GType baobab_location_row_get_type (void) G_GNUC_CONST;
gpointer baobab_location_ref (gpointer instance);
void baobab_location_unref (gpointer instance);
GParamSpec* baobab_param_spec_location (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void baobab_value_set_location (GValue* value, gpointer v_object);
void baobab_value_take_location (GValue* value, gpointer v_object);
gpointer baobab_value_get_location (const GValue* value);
GType baobab_location_get_type (void) G_GNUC_CONST;
#define BAOBAB_LOCATION_ROW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), BAOBAB_TYPE_LOCATION_ROW, BaobabLocationRowPrivate))
BaobabLocationRow* baobab_location_row_new (BaobabLocation* l);
BaobabLocationRow* baobab_location_row_construct (GType object_type, BaobabLocation* l);
static void baobab_location_row_set_location (BaobabLocationRow* self, BaobabLocation* value);
BaobabLocation* baobab_location_row_get_location (BaobabLocationRow* self);
GIcon* baobab_location_get_icon (BaobabLocation* self);
const gchar* baobab_location_get_name (BaobabLocation* self);
GFile* baobab_location_get_file (BaobabLocation* self);
gboolean baobab_location_get_is_remote (BaobabLocation* self);
gboolean baobab_location_get_is_volume (BaobabLocation* self);
gboolean baobab_location_get_is_main_volume (BaobabLocation* self);
guint64* baobab_location_get_size (BaobabLocation* self);
guint64* baobab_location_get_used (BaobabLocation* self);
static void baobab_location_row_finalize (GObject * obj);
static void _vala_baobab_location_row_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_baobab_location_row_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType baobab_location_list_get_type (void) G_GNUC_CONST;
#define BAOBAB_LOCATION_LIST_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), BAOBAB_TYPE_LOCATION_LIST, BaobabLocationListPrivate))
static void _baobab_location_unref0_ (gpointer var);
static inline void _g_list_free__baobab_location_unref0_ (GList* self);
#define BAOBAB_LOCATION_LIST_MAX_RECENT_LOCATIONS 5
static gboolean baobab_location_list_already_present (BaobabLocationList* self, GFile* file);
static void baobab_location_list_volume_changed (BaobabLocationList* self, GVolume* volume);
void baobab_location_list_update (BaobabLocationList* self);
static void baobab_location_list_volume_removed (BaobabLocationList* self, GVolume* volume);
GVolume* baobab_location_get_volume (BaobabLocation* self);
static void baobab_location_list_volume_added (BaobabLocationList* self, GVolume* volume);
BaobabLocation* baobab_location_new_from_volume (GVolume* volume_);
BaobabLocation* baobab_location_construct_from_volume (GType object_type, GVolume* volume_);
static void baobab_location_list_mount_changed (BaobabLocationList* self, GMount* mount);
static void baobab_location_list_mount_removed (BaobabLocationList* self, GMount* mount);
GMount* baobab_location_get_mount (BaobabLocation* self);
static void baobab_location_list_mount_added (BaobabLocationList* self, GMount* mount);
BaobabLocation* baobab_location_new_from_mount (GMount* mount_);
BaobabLocation* baobab_location_construct_from_mount (GType object_type, GMount* mount_);
void baobab_location_update (BaobabLocation* self);
static void baobab_location_list_populate (BaobabLocationList* self);
BaobabLocation* baobab_location_new_for_home_folder (void);
BaobabLocation* baobab_location_construct_for_home_folder (GType object_type);
BaobabLocation* baobab_location_new_for_main_volume (void);
BaobabLocation* baobab_location_construct_for_main_volume (GType object_type);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void baobab_location_list_populate_recent (BaobabLocationList* self);
static gint __lambda8_ (GtkRecentInfo* a, GtkRecentInfo* b);
static gint ___lambda8__gcompare_func (gconstpointer a, gconstpointer b);
static void _gtk_recent_info_unref0_ (gpointer var);
static inline void _g_list_free__gtk_recent_info_unref0_ (GList* self);
BaobabLocation* baobab_location_new_for_recent_info (GtkRecentInfo* recent_info);
BaobabLocation* baobab_location_construct_for_recent_info (GType object_type, GtkRecentInfo* recent_info);
static void baobab_location_list_update_header (BaobabLocationList* self, GtkListBoxRow* row, GtkListBoxRow* before_row);
static void baobab_location_list_row_activated (BaobabLocationList* self, GtkListBoxRow* row);
void baobab_location_list_set_action (BaobabLocationList* self, BaobabLocationListLocationAction action, void* action_target, GDestroyNotify action_target_destroy_notify);
static void __lambda6_ (BaobabLocationList* self, GtkWidget* widget);
static void ___lambda6__gtk_callback (GtkWidget* widget, gpointer self);
static void __lambda7_ (BaobabLocationList* self, GtkWidget* widget);
static void ___lambda7__gtk_callback (GtkWidget* widget, gpointer self);
void baobab_location_list_add_location (BaobabLocationList* self, BaobabLocation* location);
static gchar** _vala_array_dup1 (gchar** self, int length);
gboolean baobab_location_get_is_recent (BaobabLocation* self);
static void gtk_recent_data_destroy (GtkRecentData * self);
BaobabLocationList* baobab_location_list_new (void);
BaobabLocationList* baobab_location_list_construct (GType object_type);
static GObject * baobab_location_list_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void _baobab_location_list_mount_changed_g_volume_monitor_mount_changed (GVolumeMonitor* _sender, GMount* mount, gpointer self);
static void _baobab_location_list_mount_removed_g_volume_monitor_mount_removed (GVolumeMonitor* _sender, GMount* mount, gpointer self);
static void _baobab_location_list_mount_added_g_volume_monitor_mount_added (GVolumeMonitor* _sender, GMount* mount, gpointer self);
static void _baobab_location_list_volume_changed_g_volume_monitor_volume_changed (GVolumeMonitor* _sender, GVolume* volume, gpointer self);
static void _baobab_location_list_volume_removed_g_volume_monitor_volume_removed (GVolumeMonitor* _sender, GVolume* volume, gpointer self);
static void _baobab_location_list_volume_added_g_volume_monitor_volume_added (GVolumeMonitor* _sender, GVolume* volume, gpointer self);
static void _baobab_location_list_update_header_gtk_list_box_update_header_func (GtkListBoxRow* row, GtkListBoxRow* before, gpointer self);
static void _baobab_location_list_row_activated_gtk_list_box_row_activated (GtkListBox* _sender, GtkListBoxRow* row, gpointer self);
static void baobab_location_list_finalize (GObject * obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


BaobabLocationRow* baobab_location_row_construct (GType object_type, BaobabLocation* l) {
	BaobabLocationRow * self = NULL;
	BaobabLocation* _tmp0_;
	GtkImage* _tmp1_;
	BaobabLocation* _tmp2_;
	GIcon* _tmp3_;
	GIcon* _tmp4_;
	gchar* escaped = NULL;
	BaobabLocation* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	GtkLabel* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_ = NULL;
	BaobabLocation* _tmp14_;
	GFile* _tmp15_;
	GFile* _tmp16_;
	gchar* _tmp24_;
	GtkLabel* _tmp25_;
	const gchar* _tmp26_;
	PangoEllipsizeMode _tmp27_ = 0;
	BaobabLocation* _tmp28_;
	gboolean _tmp29_;
	gboolean _tmp30_;
	GtkLabel* _tmp31_;
	gboolean _tmp32_ = FALSE;
	BaobabLocation* _tmp33_;
	gboolean _tmp34_;
	gboolean _tmp35_;
	g_return_val_if_fail (l != NULL, NULL);
	self = (BaobabLocationRow*) g_object_new (object_type, NULL);
	_tmp0_ = l;
	baobab_location_row_set_location (self, _tmp0_);
	_tmp1_ = self->priv->image;
	_tmp2_ = self->priv->_location;
	_tmp3_ = baobab_location_get_icon (_tmp2_);
	_tmp4_ = _tmp3_;
	g_object_set (_tmp1_, "gicon", _tmp4_, NULL);
	_tmp5_ = self->priv->_location;
	_tmp6_ = baobab_location_get_name (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_markup_escape_text (_tmp7_, (gssize) -1);
	escaped = _tmp8_;
	_tmp9_ = self->priv->name_label;
	_tmp10_ = escaped;
	_tmp11_ = g_strdup_printf ("<b>%s</b>", _tmp10_);
	_tmp12_ = _tmp11_;
	gtk_label_set_label (_tmp9_, _tmp12_);
	_g_free0 (_tmp12_);
	_tmp14_ = self->priv->_location;
	_tmp15_ = baobab_location_get_file (_tmp14_);
	_tmp16_ = _tmp15_;
	if (_tmp16_ != NULL) {
		BaobabLocation* _tmp17_;
		GFile* _tmp18_;
		GFile* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		_tmp17_ = self->priv->_location;
		_tmp18_ = baobab_location_get_file (_tmp17_);
		_tmp19_ = _tmp18_;
		_tmp20_ = g_file_get_parse_name (_tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = g_markup_escape_text (_tmp21_, (gssize) -1);
		_g_free0 (_tmp13_);
		_tmp13_ = _tmp22_;
		_g_free0 (_tmp21_);
	} else {
		gchar* _tmp23_;
		_tmp23_ = g_strdup ("");
		_g_free0 (_tmp13_);
		_tmp13_ = _tmp23_;
	}
	_tmp24_ = g_strdup (_tmp13_);
	_g_free0 (escaped);
	escaped = _tmp24_;
	_tmp25_ = self->priv->path_label;
	_tmp26_ = escaped;
	gtk_label_set_label (_tmp25_, _tmp26_);
	_tmp28_ = self->priv->_location;
	_tmp29_ = baobab_location_get_is_remote (_tmp28_);
	_tmp30_ = _tmp29_;
	if (_tmp30_) {
		_tmp27_ = PANGO_ELLIPSIZE_END;
	} else {
		_tmp27_ = PANGO_ELLIPSIZE_START;
	}
	_tmp31_ = self->priv->path_label;
	gtk_label_set_ellipsize (_tmp31_, _tmp27_);
	_tmp33_ = self->priv->_location;
	_tmp34_ = baobab_location_get_is_volume (_tmp33_);
	_tmp35_ = _tmp34_;
	if (_tmp35_) {
		_tmp32_ = TRUE;
	} else {
		BaobabLocation* _tmp36_;
		gboolean _tmp37_;
		gboolean _tmp38_;
		_tmp36_ = self->priv->_location;
		_tmp37_ = baobab_location_get_is_main_volume (_tmp36_);
		_tmp38_ = _tmp37_;
		_tmp32_ = _tmp38_;
	}
	if (_tmp32_) {
		BaobabLocation* _tmp39_;
		guint64* _tmp40_;
		guint64* _tmp41_;
		_tmp39_ = self->priv->_location;
		_tmp40_ = baobab_location_get_size (_tmp39_);
		_tmp41_ = _tmp40_;
		if (_tmp41_ != NULL) {
			GtkLabel* _tmp42_;
			BaobabLocation* _tmp43_;
			guint64* _tmp44_;
			guint64* _tmp45_;
			gchar* _tmp46_;
			gchar* _tmp47_;
			gchar* _tmp48_;
			gchar* _tmp49_;
			BaobabLocation* _tmp50_;
			guint64* _tmp51_;
			guint64* _tmp52_;
			_tmp42_ = self->priv->total_size_label;
			_tmp43_ = self->priv->_location;
			_tmp44_ = baobab_location_get_size (_tmp43_);
			_tmp45_ = _tmp44_;
			_tmp46_ = g_format_size_full (*_tmp45_, G_FORMAT_SIZE_DEFAULT);
			_tmp47_ = _tmp46_;
			_tmp48_ = g_strdup_printf (_ ("%s Total"), _tmp47_);
			_tmp49_ = _tmp48_;
			gtk_label_set_label (_tmp42_, _tmp49_);
			_g_free0 (_tmp49_);
			_g_free0 (_tmp47_);
			_tmp50_ = self->priv->_location;
			_tmp51_ = baobab_location_get_used (_tmp50_);
			_tmp52_ = _tmp51_;
			if (_tmp52_ != NULL) {
				GtkLabel* _tmp53_;
				BaobabLocation* _tmp54_;
				guint64* _tmp55_;
				guint64* _tmp56_;
				BaobabLocation* _tmp57_;
				guint64* _tmp58_;
				guint64* _tmp59_;
				gchar* _tmp60_;
				gchar* _tmp61_;
				gchar* _tmp62_;
				gchar* _tmp63_;
				GtkLevelBar* _tmp64_;
				BaobabLocation* _tmp65_;
				guint64* _tmp66_;
				guint64* _tmp67_;
				GtkLevelBar* _tmp68_;
				BaobabLocation* _tmp69_;
				guint64* _tmp70_;
				guint64* _tmp71_;
				GtkLevelBar* _tmp72_;
				BaobabLocation* _tmp73_;
				guint64* _tmp74_;
				guint64* _tmp75_;
				GtkLevelBar* _tmp76_;
				_tmp53_ = self->priv->available_label;
				_tmp54_ = self->priv->_location;
				_tmp55_ = baobab_location_get_size (_tmp54_);
				_tmp56_ = _tmp55_;
				_tmp57_ = self->priv->_location;
				_tmp58_ = baobab_location_get_used (_tmp57_);
				_tmp59_ = _tmp58_;
				_tmp60_ = g_format_size_full ((*_tmp56_) - (*_tmp59_), G_FORMAT_SIZE_DEFAULT);
				_tmp61_ = _tmp60_;
				_tmp62_ = g_strdup_printf (_ ("%s Available"), _tmp61_);
				_tmp63_ = _tmp62_;
				gtk_label_set_label (_tmp53_, _tmp63_);
				_g_free0 (_tmp63_);
				_g_free0 (_tmp61_);
				_tmp64_ = self->priv->usage_bar;
				_tmp65_ = self->priv->_location;
				_tmp66_ = baobab_location_get_size (_tmp65_);
				_tmp67_ = _tmp66_;
				gtk_level_bar_set_max_value (_tmp64_, *_tmp67_);
				_tmp68_ = self->priv->usage_bar;
				_tmp69_ = self->priv->_location;
				_tmp70_ = baobab_location_get_size (_tmp69_);
				_tmp71_ = _tmp70_;
				gtk_level_bar_add_offset_value (_tmp68_, GTK_LEVEL_BAR_OFFSET_LOW, 0.9 * (*_tmp71_));
				_tmp72_ = self->priv->usage_bar;
				_tmp73_ = self->priv->_location;
				_tmp74_ = baobab_location_get_used (_tmp73_);
				_tmp75_ = _tmp74_;
				gtk_level_bar_set_value (_tmp72_, *_tmp75_);
				_tmp76_ = self->priv->usage_bar;
				gtk_widget_show ((GtkWidget*) _tmp76_);
			} else {
				GtkLabel* _tmp77_;
				_tmp77_ = self->priv->available_label;
				gtk_label_set_label (_tmp77_, _ ("Unknown"));
			}
		} else {
			BaobabLocation* _tmp78_;
			guint64* _tmp79_;
			guint64* _tmp80_;
			_tmp78_ = self->priv->_location;
			_tmp79_ = baobab_location_get_used (_tmp78_);
			_tmp80_ = _tmp79_;
			if (_tmp80_ != NULL) {
				GtkLabel* _tmp81_;
				BaobabLocation* _tmp82_;
				guint64* _tmp83_;
				guint64* _tmp84_;
				gchar* _tmp85_;
				gchar* _tmp86_;
				gchar* _tmp87_;
				gchar* _tmp88_;
				_tmp81_ = self->priv->available_label;
				_tmp82_ = self->priv->_location;
				_tmp83_ = baobab_location_get_used (_tmp82_);
				_tmp84_ = _tmp83_;
				_tmp85_ = g_format_size_full (*_tmp84_, G_FORMAT_SIZE_DEFAULT);
				_tmp86_ = _tmp85_;
				_tmp87_ = g_strdup_printf (_ ("%s Used"), _tmp86_);
				_tmp88_ = _tmp87_;
				gtk_label_set_label (_tmp81_, _tmp88_);
				_g_free0 (_tmp88_);
				_g_free0 (_tmp86_);
			}
		}
	}
	_g_free0 (_tmp13_);
	_g_free0 (escaped);
	return self;
}


BaobabLocationRow* baobab_location_row_new (BaobabLocation* l) {
	return baobab_location_row_construct (BAOBAB_TYPE_LOCATION_ROW, l);
}


BaobabLocation* baobab_location_row_get_location (BaobabLocationRow* self) {
	BaobabLocation* result;
	BaobabLocation* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_location;
	result = _tmp0_;
	return result;
}


static gpointer _baobab_location_ref0 (gpointer self) {
	return self ? baobab_location_ref (self) : NULL;
}


static void baobab_location_row_set_location (BaobabLocationRow* self, BaobabLocation* value) {
	g_return_if_fail (self != NULL);
	if (baobab_location_row_get_location (self) != value) {
		BaobabLocation* _tmp0_;
		BaobabLocation* _tmp1_;
		_tmp0_ = value;
		_tmp1_ = _baobab_location_ref0 (_tmp0_);
		_baobab_location_unref0 (self->priv->_location);
		self->priv->_location = _tmp1_;
		g_object_notify_by_pspec ((GObject *) self, baobab_location_row_properties[BAOBAB_LOCATION_ROW_LOCATION_PROPERTY]);
	}
}


static void baobab_location_row_class_init (BaobabLocationRowClass * klass) {
	gint BaobabLocationRow_private_offset;
	baobab_location_row_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (BaobabLocationRowPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_baobab_location_row_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_baobab_location_row_set_property;
	G_OBJECT_CLASS (klass)->finalize = baobab_location_row_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BAOBAB_LOCATION_ROW_LOCATION_PROPERTY, baobab_location_row_properties[BAOBAB_LOCATION_ROW_LOCATION_PROPERTY] = baobab_param_spec_location ("location", "location", "location", BAOBAB_TYPE_LOCATION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	BaobabLocationRow_private_offset = g_type_class_get_instance_private_offset (klass);
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/baobab/ui/baobab-location-row.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "image", FALSE, BaobabLocationRow_private_offset + G_STRUCT_OFFSET (BaobabLocationRowPrivate, image));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "name_label", FALSE, BaobabLocationRow_private_offset + G_STRUCT_OFFSET (BaobabLocationRowPrivate, name_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "path_label", FALSE, BaobabLocationRow_private_offset + G_STRUCT_OFFSET (BaobabLocationRowPrivate, path_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "available_label", FALSE, BaobabLocationRow_private_offset + G_STRUCT_OFFSET (BaobabLocationRowPrivate, available_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "total_size_label", FALSE, BaobabLocationRow_private_offset + G_STRUCT_OFFSET (BaobabLocationRowPrivate, total_size_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "usage_bar", FALSE, BaobabLocationRow_private_offset + G_STRUCT_OFFSET (BaobabLocationRowPrivate, usage_bar));
}


static void baobab_location_row_instance_init (BaobabLocationRow * self) {
	self->priv = BAOBAB_LOCATION_ROW_GET_PRIVATE (self);
	gtk_widget_init_template (GTK_WIDGET (self));
}


static void baobab_location_row_finalize (GObject * obj) {
	BaobabLocationRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BAOBAB_TYPE_LOCATION_ROW, BaobabLocationRow);
	_g_object_unref0 (self->priv->image);
	_g_object_unref0 (self->priv->name_label);
	_g_object_unref0 (self->priv->path_label);
	_g_object_unref0 (self->priv->available_label);
	_g_object_unref0 (self->priv->total_size_label);
	_g_object_unref0 (self->priv->usage_bar);
	_baobab_location_unref0 (self->priv->_location);
	G_OBJECT_CLASS (baobab_location_row_parent_class)->finalize (obj);
}


GType baobab_location_row_get_type (void) {
	static volatile gsize baobab_location_row_type_id__volatile = 0;
	if (g_once_init_enter (&baobab_location_row_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BaobabLocationRowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) baobab_location_row_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BaobabLocationRow), 0, (GInstanceInitFunc) baobab_location_row_instance_init, NULL };
		GType baobab_location_row_type_id;
		baobab_location_row_type_id = g_type_register_static (gtk_list_box_row_get_type (), "BaobabLocationRow", &g_define_type_info, 0);
		g_once_init_leave (&baobab_location_row_type_id__volatile, baobab_location_row_type_id);
	}
	return baobab_location_row_type_id__volatile;
}


static void _vala_baobab_location_row_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	BaobabLocationRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BAOBAB_TYPE_LOCATION_ROW, BaobabLocationRow);
	switch (property_id) {
		case BAOBAB_LOCATION_ROW_LOCATION_PROPERTY:
		baobab_value_set_location (value, baobab_location_row_get_location (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_baobab_location_row_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	BaobabLocationRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BAOBAB_TYPE_LOCATION_ROW, BaobabLocationRow);
	switch (property_id) {
		case BAOBAB_LOCATION_ROW_LOCATION_PROPERTY:
		baobab_location_row_set_location (self, baobab_value_get_location (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _baobab_location_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (baobab_location_unref (var), NULL));
}


static inline void _g_list_free__baobab_location_unref0_ (GList* self) {
	g_list_free_full (self, (GDestroyNotify) _baobab_location_unref0_);
}


static gboolean baobab_location_list_already_present (BaobabLocationList* self, GFile* file) {
	gboolean result = FALSE;
	GList* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (file != NULL, FALSE);
	_tmp0_ = self->priv->locations;
	{
		GList* l_collection = NULL;
		GList* l_it = NULL;
		l_collection = _tmp0_;
		for (l_it = l_collection; l_it != NULL; l_it = l_it->next) {
			BaobabLocation* _tmp1_;
			BaobabLocation* l = NULL;
			_tmp1_ = _baobab_location_ref0 ((BaobabLocation*) l_it->data);
			l = _tmp1_;
			{
				gboolean _tmp2_ = FALSE;
				BaobabLocation* _tmp3_;
				GFile* _tmp4_;
				GFile* _tmp5_;
				_tmp3_ = l;
				_tmp4_ = baobab_location_get_file (_tmp3_);
				_tmp5_ = _tmp4_;
				if (_tmp5_ != NULL) {
					BaobabLocation* _tmp6_;
					GFile* _tmp7_;
					GFile* _tmp8_;
					GFile* _tmp9_;
					gboolean _tmp10_;
					_tmp6_ = l;
					_tmp7_ = baobab_location_get_file (_tmp6_);
					_tmp8_ = _tmp7_;
					_tmp9_ = file;
					_tmp10_ = g_file_equal (_tmp8_, _tmp9_);
					_tmp2_ = _tmp10_;
				} else {
					_tmp2_ = FALSE;
				}
				if (_tmp2_) {
					result = TRUE;
					_baobab_location_unref0 (l);
					return result;
				}
				_baobab_location_unref0 (l);
			}
		}
	}
	result = FALSE;
	return result;
}


static void baobab_location_list_volume_changed (BaobabLocationList* self, GVolume* volume) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (volume != NULL);
	baobab_location_list_update (self);
}


static void baobab_location_list_volume_removed (BaobabLocationList* self, GVolume* volume) {
	GList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (volume != NULL);
	_tmp0_ = self->priv->locations;
	{
		GList* location_collection = NULL;
		GList* location_it = NULL;
		location_collection = _tmp0_;
		for (location_it = location_collection; location_it != NULL; location_it = location_it->next) {
			BaobabLocation* _tmp1_;
			BaobabLocation* location = NULL;
			_tmp1_ = _baobab_location_ref0 ((BaobabLocation*) location_it->data);
			location = _tmp1_;
			{
				BaobabLocation* _tmp2_;
				GVolume* _tmp3_;
				GVolume* _tmp4_;
				GVolume* _tmp5_;
				_tmp2_ = location;
				_tmp3_ = baobab_location_get_volume (_tmp2_);
				_tmp4_ = _tmp3_;
				_tmp5_ = volume;
				if (_tmp4_ == _tmp5_) {
					BaobabLocation* _tmp6_;
					_tmp6_ = location;
					self->priv->locations = g_list_remove (self->priv->locations, _tmp6_);
					_baobab_location_unref0 (location);
					break;
				}
				_baobab_location_unref0 (location);
			}
		}
	}
	baobab_location_list_update (self);
}


static void baobab_location_list_volume_added (BaobabLocationList* self, GVolume* volume) {
	GVolume* _tmp0_;
	BaobabLocation* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (volume != NULL);
	_tmp0_ = volume;
	_tmp1_ = baobab_location_new_from_volume (_tmp0_);
	self->priv->locations = g_list_append (self->priv->locations, _tmp1_);
	baobab_location_list_update (self);
}


static void baobab_location_list_mount_changed (BaobabLocationList* self, GMount* mount) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (mount != NULL);
}


static void baobab_location_list_mount_removed (BaobabLocationList* self, GMount* mount) {
	GList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (mount != NULL);
	_tmp0_ = self->priv->locations;
	{
		GList* location_collection = NULL;
		GList* location_it = NULL;
		location_collection = _tmp0_;
		for (location_it = location_collection; location_it != NULL; location_it = location_it->next) {
			BaobabLocation* _tmp1_;
			BaobabLocation* location = NULL;
			_tmp1_ = _baobab_location_ref0 ((BaobabLocation*) location_it->data);
			location = _tmp1_;
			{
				BaobabLocation* _tmp2_;
				GMount* _tmp3_;
				GMount* _tmp4_;
				GMount* _tmp5_;
				_tmp2_ = location;
				_tmp3_ = baobab_location_get_mount (_tmp2_);
				_tmp4_ = _tmp3_;
				_tmp5_ = mount;
				if (_tmp4_ == _tmp5_) {
					BaobabLocation* _tmp6_;
					_tmp6_ = location;
					self->priv->locations = g_list_remove (self->priv->locations, _tmp6_);
					_baobab_location_unref0 (location);
					break;
				}
				_baobab_location_unref0 (location);
			}
		}
	}
	baobab_location_list_update (self);
}


static void baobab_location_list_mount_added (BaobabLocationList* self, GMount* mount) {
	GVolume* volume = NULL;
	GMount* _tmp0_;
	GVolume* _tmp1_;
	GVolume* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (mount != NULL);
	_tmp0_ = mount;
	_tmp1_ = g_mount_get_volume (_tmp0_);
	volume = _tmp1_;
	_tmp2_ = volume;
	if (_tmp2_ == NULL) {
		GMount* _tmp3_;
		GFile* _tmp4_;
		GFile* _tmp5_;
		gboolean _tmp6_;
		gboolean _tmp7_;
		_tmp3_ = mount;
		_tmp4_ = g_mount_get_root (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = baobab_location_list_already_present (self, _tmp5_);
		_tmp7_ = !_tmp6_;
		_g_object_unref0 (_tmp5_);
		if (_tmp7_) {
			GMount* _tmp8_;
			BaobabLocation* _tmp9_;
			_tmp8_ = mount;
			_tmp9_ = baobab_location_new_from_mount (_tmp8_);
			self->priv->locations = g_list_append (self->priv->locations, _tmp9_);
		}
	} else {
		GList* _tmp10_;
		_tmp10_ = self->priv->locations;
		{
			GList* location_collection = NULL;
			GList* location_it = NULL;
			location_collection = _tmp10_;
			for (location_it = location_collection; location_it != NULL; location_it = location_it->next) {
				BaobabLocation* _tmp11_;
				BaobabLocation* location = NULL;
				_tmp11_ = _baobab_location_ref0 ((BaobabLocation*) location_it->data);
				location = _tmp11_;
				{
					BaobabLocation* _tmp12_;
					GVolume* _tmp13_;
					GVolume* _tmp14_;
					GVolume* _tmp15_;
					_tmp12_ = location;
					_tmp13_ = baobab_location_get_volume (_tmp12_);
					_tmp14_ = _tmp13_;
					_tmp15_ = volume;
					if (_tmp14_ == _tmp15_) {
						BaobabLocation* _tmp16_;
						_tmp16_ = location;
						baobab_location_update (_tmp16_);
						_baobab_location_unref0 (location);
						break;
					}
					_baobab_location_unref0 (location);
				}
			}
		}
	}
	baobab_location_list_update (self);
	_g_object_unref0 (volume);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static inline void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}


static void baobab_location_list_populate (BaobabLocationList* self) {
	BaobabLocation* _tmp0_;
	BaobabLocation* _tmp1_;
	GVolumeMonitor* _tmp2_;
	GList* _tmp3_;
	GVolumeMonitor* _tmp6_;
	GList* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = baobab_location_new_for_home_folder ();
	self->priv->locations = g_list_append (self->priv->locations, _tmp0_);
	_tmp1_ = baobab_location_new_for_main_volume ();
	self->priv->locations = g_list_append (self->priv->locations, _tmp1_);
	_tmp2_ = self->priv->monitor;
	_tmp3_ = g_volume_monitor_get_volumes (_tmp2_);
	{
		GList* volume_collection = NULL;
		GList* volume_it = NULL;
		volume_collection = _tmp3_;
		for (volume_it = volume_collection; volume_it != NULL; volume_it = volume_it->next) {
			GVolume* _tmp4_;
			GVolume* volume = NULL;
			_tmp4_ = _g_object_ref0 ((GVolume*) volume_it->data);
			volume = _tmp4_;
			{
				GVolume* _tmp5_;
				_tmp5_ = volume;
				baobab_location_list_volume_added (self, _tmp5_);
				_g_object_unref0 (volume);
			}
		}
		__g_list_free__g_object_unref0_0 (volume_collection);
	}
	_tmp6_ = self->priv->monitor;
	_tmp7_ = g_volume_monitor_get_mounts (_tmp6_);
	{
		GList* mount_collection = NULL;
		GList* mount_it = NULL;
		mount_collection = _tmp7_;
		for (mount_it = mount_collection; mount_it != NULL; mount_it = mount_it->next) {
			GMount* _tmp8_;
			GMount* mount = NULL;
			_tmp8_ = _g_object_ref0 ((GMount*) mount_it->data);
			mount = _tmp8_;
			{
				GMount* _tmp9_;
				_tmp9_ = mount;
				baobab_location_list_mount_added (self, _tmp9_);
				_g_object_unref0 (mount);
			}
		}
		__g_list_free__g_object_unref0_0 (mount_collection);
	}
	baobab_location_list_populate_recent (self);
	baobab_location_list_update (self);
}


static gint __lambda8_ (GtkRecentInfo* a, GtkRecentInfo* b) {
	gint result = 0;
	GtkRecentInfo* _tmp0_;
	gulong _tmp1_;
	GtkRecentInfo* _tmp2_;
	gulong _tmp3_;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = b;
	_tmp1_ = gtk_recent_info_get_modified (_tmp0_);
	_tmp2_ = a;
	_tmp3_ = gtk_recent_info_get_modified (_tmp2_);
	result = (gint) (_tmp1_ - _tmp3_);
	return result;
}


static gint ___lambda8__gcompare_func (gconstpointer a, gconstpointer b) {
	gint result;
	result = __lambda8_ ((GtkRecentInfo*) a, (GtkRecentInfo*) b);
	return result;
}


static void _gtk_recent_info_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (gtk_recent_info_unref (var), NULL));
}


static inline void _g_list_free__gtk_recent_info_unref0_ (GList* self) {
	g_list_free_full (self, (GDestroyNotify) _gtk_recent_info_unref0_);
}


static gpointer _gtk_recent_info_ref0 (gpointer self) {
	return self ? gtk_recent_info_ref (self) : NULL;
}


static void baobab_location_list_populate_recent (BaobabLocationList* self) {
	GtkRecentManager* recent_manager = NULL;
	GtkRecentManager* _tmp0_;
	GtkRecentManager* _tmp1_;
	GList* recent_items = NULL;
	GtkRecentManager* _tmp2_;
	GList* _tmp3_;
	GList* iter = NULL;
	GList* _tmp4_;
	GList* last = NULL;
	GList* _tmp24_;
	GList* _tmp25_;
	GList* _tmp26_;
	GList* _tmp28_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_recent_manager_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	recent_manager = _tmp1_;
	_tmp2_ = recent_manager;
	_tmp3_ = gtk_recent_manager_get_items (_tmp2_);
	recent_items = _tmp3_;
	_tmp4_ = recent_items;
	iter = _tmp4_;
	while (TRUE) {
		GList* _tmp5_;
		GList* next = NULL;
		GList* _tmp6_;
		GList* _tmp7_;
		gboolean _tmp8_ = FALSE;
		gboolean _tmp9_ = FALSE;
		GList* _tmp10_;
		gconstpointer _tmp11_;
		gboolean _tmp12_;
		GList* _tmp23_;
		_tmp5_ = iter;
		if (!(_tmp5_ != NULL)) {
			break;
		}
		_tmp6_ = iter;
		_tmp7_ = _tmp6_->next;
		next = _tmp7_;
		_tmp10_ = iter;
		_tmp11_ = _tmp10_->data;
		_tmp12_ = gtk_recent_info_has_group ((GtkRecentInfo*) _tmp11_, "baobab");
		if (!_tmp12_) {
			_tmp9_ = TRUE;
		} else {
			GList* _tmp13_;
			gconstpointer _tmp14_;
			gboolean _tmp15_;
			_tmp13_ = iter;
			_tmp14_ = _tmp13_->data;
			_tmp15_ = gtk_recent_info_exists ((GtkRecentInfo*) _tmp14_);
			_tmp9_ = !_tmp15_;
		}
		if (_tmp9_) {
			_tmp8_ = TRUE;
		} else {
			GList* _tmp16_;
			gconstpointer _tmp17_;
			const gchar* _tmp18_;
			GFile* _tmp19_;
			GFile* _tmp20_;
			gboolean _tmp21_;
			_tmp16_ = iter;
			_tmp17_ = _tmp16_->data;
			_tmp18_ = gtk_recent_info_get_uri ((GtkRecentInfo*) _tmp17_);
			_tmp19_ = g_file_new_for_uri (_tmp18_);
			_tmp20_ = _tmp19_;
			_tmp21_ = baobab_location_list_already_present (self, _tmp20_);
			_tmp8_ = _tmp21_;
			_g_object_unref0 (_tmp20_);
		}
		if (_tmp8_) {
			GList* _tmp22_;
			_tmp22_ = iter;
			recent_items = g_list_remove_link (recent_items, _tmp22_);
		}
		_tmp23_ = next;
		iter = _tmp23_;
	}
	recent_items = g_list_sort (recent_items, ___lambda8__gcompare_func);
	_tmp24_ = recent_items;
	_tmp25_ = g_list_nth (_tmp24_, (guint) (BAOBAB_LOCATION_LIST_MAX_RECENT_LOCATIONS - 1));
	last = _tmp25_;
	_tmp26_ = last;
	if (_tmp26_ != NULL) {
		GList* _tmp27_;
		_tmp27_ = last;
		__g_list_free__gtk_recent_info_unref0_0 (_tmp27_->next);
		_tmp27_->next = NULL;
	}
	recent_items = g_list_reverse (recent_items);
	_tmp28_ = recent_items;
	{
		GList* info_collection = NULL;
		GList* info_it = NULL;
		info_collection = _tmp28_;
		for (info_it = info_collection; info_it != NULL; info_it = info_it->next) {
			GtkRecentInfo* _tmp29_;
			GtkRecentInfo* info = NULL;
			_tmp29_ = _gtk_recent_info_ref0 ((GtkRecentInfo*) info_it->data);
			info = _tmp29_;
			{
				GtkRecentInfo* _tmp30_;
				BaobabLocation* _tmp31_;
				_tmp30_ = info;
				_tmp31_ = baobab_location_new_for_recent_info (_tmp30_);
				self->priv->locations = g_list_append (self->priv->locations, _tmp31_);
				_gtk_recent_info_unref0 (info);
			}
		}
	}
	__g_list_free__gtk_recent_info_unref0_0 (recent_items);
	_g_object_unref0 (recent_manager);
}


static void baobab_location_list_update_header (BaobabLocationList* self, GtkListBoxRow* row, GtkListBoxRow* before_row) {
	gboolean _tmp0_ = FALSE;
	GtkListBoxRow* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (row != NULL);
	_tmp1_ = before_row;
	if (_tmp1_ != NULL) {
		GtkListBoxRow* _tmp2_;
		GtkWidget* _tmp3_;
		_tmp2_ = row;
		_tmp3_ = gtk_list_box_row_get_header (_tmp2_);
		_tmp0_ = _tmp3_ == NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GtkListBoxRow* _tmp4_;
		GtkSeparator* _tmp5_;
		GtkSeparator* _tmp6_;
		_tmp4_ = row;
		_tmp5_ = (GtkSeparator*) gtk_separator_new (GTK_ORIENTATION_HORIZONTAL);
		g_object_ref_sink (_tmp5_);
		_tmp6_ = _tmp5_;
		gtk_list_box_row_set_header (_tmp4_, (GtkWidget*) _tmp6_);
		_g_object_unref0 (_tmp6_);
	} else {
		GtkListBoxRow* _tmp7_;
		_tmp7_ = row;
		gtk_list_box_row_set_header (_tmp7_, NULL);
	}
}


static void baobab_location_list_row_activated (BaobabLocationList* self, GtkListBoxRow* row) {
	BaobabLocationListLocationAction _tmp0_;
	void* _tmp0__target;
	g_return_if_fail (self != NULL);
	g_return_if_fail (row != NULL);
	_tmp0_ = self->priv->location_action;
	_tmp0__target = self->priv->location_action_target;
	if (_tmp0_ != NULL) {
		BaobabLocationRow* location_widget = NULL;
		GtkListBoxRow* _tmp1_;
		BaobabLocationRow* _tmp2_;
		BaobabLocationListLocationAction _tmp3_;
		void* _tmp3__target;
		BaobabLocationRow* _tmp4_;
		BaobabLocation* _tmp5_;
		BaobabLocation* _tmp6_;
		_tmp1_ = row;
		_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, BAOBAB_TYPE_LOCATION_ROW) ? ((BaobabLocationRow*) _tmp1_) : NULL);
		location_widget = _tmp2_;
		_tmp3_ = self->priv->location_action;
		_tmp3__target = self->priv->location_action_target;
		_tmp4_ = location_widget;
		_tmp5_ = baobab_location_row_get_location (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp3_ (_tmp6_, _tmp3__target);
		_g_object_unref0 (location_widget);
	}
}


void baobab_location_list_set_action (BaobabLocationList* self, BaobabLocationListLocationAction action, void* action_target, GDestroyNotify action_target_destroy_notify) {
	BaobabLocationListLocationAction _tmp0_;
	void* _tmp0__target;
	GDestroyNotify _tmp0__target_destroy_notify;
	g_return_if_fail (self != NULL);
	_tmp0_ = action;
	_tmp0__target = action_target;
	_tmp0__target_destroy_notify = action_target_destroy_notify;
	action = NULL;
	action_target = NULL;
	action_target_destroy_notify = NULL;
	(self->priv->location_action_target_destroy_notify == NULL) ? NULL : (self->priv->location_action_target_destroy_notify (self->priv->location_action_target), NULL);
	self->priv->location_action = NULL;
	self->priv->location_action_target = NULL;
	self->priv->location_action_target_destroy_notify = NULL;
	self->priv->location_action = _tmp0_;
	self->priv->location_action_target = _tmp0__target;
	self->priv->location_action_target_destroy_notify = _tmp0__target_destroy_notify;
	(action_target_destroy_notify == NULL) ? NULL : (action_target_destroy_notify (action_target), NULL);
	action = NULL;
	action_target = NULL;
	action_target_destroy_notify = NULL;
}


static void __lambda6_ (BaobabLocationList* self, GtkWidget* widget) {
	GtkWidget* _tmp0_;
	g_return_if_fail (widget != NULL);
	_tmp0_ = widget;
	gtk_widget_destroy (_tmp0_);
}


static void ___lambda6__gtk_callback (GtkWidget* widget, gpointer self) {
	__lambda6_ ((BaobabLocationList*) self, widget);
}


static void __lambda7_ (BaobabLocationList* self, GtkWidget* widget) {
	GtkWidget* _tmp0_;
	g_return_if_fail (widget != NULL);
	_tmp0_ = widget;
	gtk_widget_destroy (_tmp0_);
}


static void ___lambda7__gtk_callback (GtkWidget* widget, gpointer self) {
	__lambda7_ ((BaobabLocationList*) self, widget);
}


void baobab_location_list_update (BaobabLocationList* self) {
	GtkListBox* _tmp0_;
	GtkListBox* _tmp1_;
	GtkBox* _tmp2_;
	GList* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->local_list_box;
	gtk_container_foreach ((GtkContainer*) _tmp0_, ___lambda6__gtk_callback, self);
	_tmp1_ = self->priv->remote_list_box;
	gtk_container_foreach ((GtkContainer*) _tmp1_, ___lambda7__gtk_callback, self);
	_tmp2_ = self->priv->remote_box;
	gtk_widget_set_visible ((GtkWidget*) _tmp2_, FALSE);
	_tmp3_ = self->priv->locations;
	{
		GList* location_collection = NULL;
		GList* location_it = NULL;
		location_collection = _tmp3_;
		for (location_it = location_collection; location_it != NULL; location_it = location_it->next) {
			BaobabLocation* _tmp4_;
			BaobabLocation* location = NULL;
			_tmp4_ = _baobab_location_ref0 ((BaobabLocation*) location_it->data);
			location = _tmp4_;
			{
				BaobabLocation* _tmp5_;
				gboolean _tmp6_;
				gboolean _tmp7_;
				_tmp5_ = location;
				_tmp6_ = baobab_location_get_is_remote (_tmp5_);
				_tmp7_ = _tmp6_;
				if (_tmp7_) {
					GtkListBox* _tmp8_;
					BaobabLocation* _tmp9_;
					BaobabLocationRow* _tmp10_;
					BaobabLocationRow* _tmp11_;
					GtkBox* _tmp12_;
					_tmp8_ = self->priv->remote_list_box;
					_tmp9_ = location;
					_tmp10_ = baobab_location_row_new (_tmp9_);
					g_object_ref_sink (_tmp10_);
					_tmp11_ = _tmp10_;
					gtk_container_add ((GtkContainer*) _tmp8_, (GtkWidget*) _tmp11_);
					_g_object_unref0 (_tmp11_);
					_tmp12_ = self->priv->remote_box;
					gtk_widget_set_visible ((GtkWidget*) _tmp12_, TRUE);
				} else {
					GtkListBox* _tmp13_;
					BaobabLocation* _tmp14_;
					BaobabLocationRow* _tmp15_;
					BaobabLocationRow* _tmp16_;
					_tmp13_ = self->priv->local_list_box;
					_tmp14_ = location;
					_tmp15_ = baobab_location_row_new (_tmp14_);
					g_object_ref_sink (_tmp15_);
					_tmp16_ = _tmp15_;
					gtk_container_add ((GtkContainer*) _tmp13_, (GtkWidget*) _tmp16_);
					_g_object_unref0 (_tmp16_);
				}
				_baobab_location_unref0 (location);
			}
		}
	}
}


static gchar** _vala_array_dup1 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static void gtk_recent_data_destroy (GtkRecentData * self) {
	_g_free0 ((*self).display_name);
	_g_free0 ((*self).description);
	_g_free0 ((*self).mime_type);
	_g_free0 ((*self).app_name);
	_g_free0 ((*self).app_exec);
	(*self).groups = (_vala_array_free ((*self).groups, _vala_array_length ((*self).groups), (GDestroyNotify) g_free), NULL);
}


void baobab_location_list_add_location (BaobabLocationList* self, BaobabLocation* location) {
	BaobabLocation* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	GtkRecentData data = {0};
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar** groups = NULL;
	gchar** _tmp8_;
	gint groups_length1;
	gint _groups_size_;
	gchar** _tmp9_;
	gint _tmp9__length1;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar** _tmp12_;
	gint _tmp12__length1;
	gchar* _tmp13_;
	gchar** _tmp14_;
	gint _tmp14__length1;
	gchar** _tmp15_;
	gint _tmp15__length1;
	GtkRecentManager* _tmp16_;
	BaobabLocation* _tmp17_;
	GFile* _tmp18_;
	GFile* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	GtkRecentData _tmp22_;
	GList* iter = NULL;
	GList* _tmp23_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (location != NULL);
	_tmp0_ = location;
	_tmp1_ = baobab_location_get_file (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == NULL) {
		return;
	}
	memset (&data, 0, sizeof (GtkRecentData));
	_g_free0 (data.display_name);
	data.display_name = NULL;
	_g_free0 (data.description);
	data.description = NULL;
	_tmp3_ = g_strdup ("inode/directory");
	_g_free0 (data.mime_type);
	data.mime_type = _tmp3_;
	_tmp4_ = g_get_application_name ();
	_tmp5_ = g_strdup (_tmp4_);
	_g_free0 (data.app_name);
	data.app_name = _tmp5_;
	_tmp6_ = g_get_prgname ();
	_tmp7_ = g_strdup_printf ("%s %%u", _tmp6_);
	_g_free0 (data.app_exec);
	data.app_exec = _tmp7_;
	_tmp8_ = g_new0 (gchar*, 2 + 1);
	groups = _tmp8_;
	groups_length1 = 2;
	_groups_size_ = groups_length1;
	_tmp9_ = groups;
	_tmp9__length1 = groups_length1;
	_tmp10_ = g_strdup ("baobab");
	_g_free0 (_tmp9_[0]);
	_tmp9_[0] = _tmp10_;
	_tmp11_ = _tmp9_[0];
	_tmp12_ = groups;
	_tmp12__length1 = groups_length1;
	_g_free0 (_tmp12_[1]);
	_tmp12_[1] = NULL;
	_tmp13_ = _tmp12_[1];
	_tmp14_ = groups;
	_tmp14__length1 = groups_length1;
	_tmp15_ = (_tmp14_ != NULL) ? _vala_array_dup1 (_tmp14_, _tmp14__length1) : ((gpointer) _tmp14_);
	_tmp15__length1 = _tmp14__length1;
	data.groups = (_vala_array_free (data.groups, _vala_array_length (data.groups), (GDestroyNotify) g_free), NULL);
	data.groups = _tmp15_;
	_tmp16_ = gtk_recent_manager_get_default ();
	_tmp17_ = location;
	_tmp18_ = baobab_location_get_file (_tmp17_);
	_tmp19_ = _tmp18_;
	_tmp20_ = g_file_get_uri (_tmp19_);
	_tmp21_ = _tmp20_;
	_tmp22_ = data;
	gtk_recent_manager_add_full (_tmp16_, _tmp21_, &_tmp22_);
	_g_free0 (_tmp21_);
	_tmp23_ = self->priv->locations;
	iter = _tmp23_;
	while (TRUE) {
		GList* _tmp24_;
		GList* next = NULL;
		GList* _tmp25_;
		GList* _tmp26_;
		GList* _tmp27_;
		gconstpointer _tmp28_;
		gboolean _tmp29_;
		gboolean _tmp30_;
		GList* _tmp32_;
		_tmp24_ = iter;
		if (!(_tmp24_ != NULL)) {
			break;
		}
		_tmp25_ = iter;
		_tmp26_ = _tmp25_->next;
		next = _tmp26_;
		_tmp27_ = iter;
		_tmp28_ = _tmp27_->data;
		_tmp29_ = baobab_location_get_is_recent ((BaobabLocation*) _tmp28_);
		_tmp30_ = _tmp29_;
		if (_tmp30_) {
			GList* _tmp31_;
			_tmp31_ = iter;
			self->priv->locations = g_list_remove_link (self->priv->locations, _tmp31_);
		}
		_tmp32_ = next;
		iter = _tmp32_;
	}
	baobab_location_list_populate_recent (self);
	baobab_location_list_update (self);
	groups = (_vala_array_free (groups, groups_length1, (GDestroyNotify) g_free), NULL);
	gtk_recent_data_destroy (&data);
}


BaobabLocationList* baobab_location_list_construct (GType object_type) {
	BaobabLocationList * self = NULL;
	self = (BaobabLocationList*) g_object_new (object_type, NULL);
	return self;
}


BaobabLocationList* baobab_location_list_new (void) {
	return baobab_location_list_construct (BAOBAB_TYPE_LOCATION_LIST);
}


static void _baobab_location_list_mount_changed_g_volume_monitor_mount_changed (GVolumeMonitor* _sender, GMount* mount, gpointer self) {
	baobab_location_list_mount_changed ((BaobabLocationList*) self, mount);
}


static void _baobab_location_list_mount_removed_g_volume_monitor_mount_removed (GVolumeMonitor* _sender, GMount* mount, gpointer self) {
	baobab_location_list_mount_removed ((BaobabLocationList*) self, mount);
}


static void _baobab_location_list_mount_added_g_volume_monitor_mount_added (GVolumeMonitor* _sender, GMount* mount, gpointer self) {
	baobab_location_list_mount_added ((BaobabLocationList*) self, mount);
}


static void _baobab_location_list_volume_changed_g_volume_monitor_volume_changed (GVolumeMonitor* _sender, GVolume* volume, gpointer self) {
	baobab_location_list_volume_changed ((BaobabLocationList*) self, volume);
}


static void _baobab_location_list_volume_removed_g_volume_monitor_volume_removed (GVolumeMonitor* _sender, GVolume* volume, gpointer self) {
	baobab_location_list_volume_removed ((BaobabLocationList*) self, volume);
}


static void _baobab_location_list_volume_added_g_volume_monitor_volume_added (GVolumeMonitor* _sender, GVolume* volume, gpointer self) {
	baobab_location_list_volume_added ((BaobabLocationList*) self, volume);
}


static void _baobab_location_list_update_header_gtk_list_box_update_header_func (GtkListBoxRow* row, GtkListBoxRow* before, gpointer self) {
	baobab_location_list_update_header ((BaobabLocationList*) self, row, before);
}


static void _baobab_location_list_row_activated_gtk_list_box_row_activated (GtkListBox* _sender, GtkListBoxRow* row, gpointer self) {
	baobab_location_list_row_activated ((BaobabLocationList*) self, row);
}


static GObject * baobab_location_list_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	BaobabLocationList * self;
	GVolumeMonitor* _tmp0_;
	GVolumeMonitor* _tmp1_;
	GVolumeMonitor* _tmp2_;
	GVolumeMonitor* _tmp3_;
	GVolumeMonitor* _tmp4_;
	GVolumeMonitor* _tmp5_;
	GVolumeMonitor* _tmp6_;
	GtkListBox* _tmp7_;
	GtkListBox* _tmp8_;
	GtkListBox* _tmp9_;
	GtkListBox* _tmp10_;
	parent_class = G_OBJECT_CLASS (baobab_location_list_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BAOBAB_TYPE_LOCATION_LIST, BaobabLocationList);
	_tmp0_ = g_volume_monitor_get ();
	_g_object_unref0 (self->priv->monitor);
	self->priv->monitor = _tmp0_;
	_tmp1_ = self->priv->monitor;
	g_signal_connect_object (_tmp1_, "mount-changed", (GCallback) _baobab_location_list_mount_changed_g_volume_monitor_mount_changed, self, 0);
	_tmp2_ = self->priv->monitor;
	g_signal_connect_object (_tmp2_, "mount-removed", (GCallback) _baobab_location_list_mount_removed_g_volume_monitor_mount_removed, self, 0);
	_tmp3_ = self->priv->monitor;
	g_signal_connect_object (_tmp3_, "mount-added", (GCallback) _baobab_location_list_mount_added_g_volume_monitor_mount_added, self, 0);
	_tmp4_ = self->priv->monitor;
	g_signal_connect_object (_tmp4_, "volume-changed", (GCallback) _baobab_location_list_volume_changed_g_volume_monitor_volume_changed, self, 0);
	_tmp5_ = self->priv->monitor;
	g_signal_connect_object (_tmp5_, "volume-removed", (GCallback) _baobab_location_list_volume_removed_g_volume_monitor_volume_removed, self, 0);
	_tmp6_ = self->priv->monitor;
	g_signal_connect_object (_tmp6_, "volume-added", (GCallback) _baobab_location_list_volume_added_g_volume_monitor_volume_added, self, 0);
	_tmp7_ = self->priv->local_list_box;
	gtk_list_box_set_header_func (_tmp7_, _baobab_location_list_update_header_gtk_list_box_update_header_func, g_object_ref (self), g_object_unref);
	_tmp8_ = self->priv->local_list_box;
	g_signal_connect_object (_tmp8_, "row-activated", (GCallback) _baobab_location_list_row_activated_gtk_list_box_row_activated, self, 0);
	_tmp9_ = self->priv->remote_list_box;
	gtk_list_box_set_header_func (_tmp9_, _baobab_location_list_update_header_gtk_list_box_update_header_func, g_object_ref (self), g_object_unref);
	_tmp10_ = self->priv->remote_list_box;
	g_signal_connect_object (_tmp10_, "row-activated", (GCallback) _baobab_location_list_row_activated_gtk_list_box_row_activated, self, 0);
	baobab_location_list_populate (self);
	return obj;
}


static void baobab_location_list_class_init (BaobabLocationListClass * klass) {
	gint BaobabLocationList_private_offset;
	baobab_location_list_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (BaobabLocationListPrivate));
	G_OBJECT_CLASS (klass)->constructor = baobab_location_list_constructor;
	G_OBJECT_CLASS (klass)->finalize = baobab_location_list_finalize;
	BaobabLocationList_private_offset = g_type_class_get_instance_private_offset (klass);
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/baobab/ui/baobab-location-list.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "local_list_box", FALSE, BaobabLocationList_private_offset + G_STRUCT_OFFSET (BaobabLocationListPrivate, local_list_box));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "remote_list_box", FALSE, BaobabLocationList_private_offset + G_STRUCT_OFFSET (BaobabLocationListPrivate, remote_list_box));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "remote_box", FALSE, BaobabLocationList_private_offset + G_STRUCT_OFFSET (BaobabLocationListPrivate, remote_box));
}


static void baobab_location_list_instance_init (BaobabLocationList * self) {
	self->priv = BAOBAB_LOCATION_LIST_GET_PRIVATE (self);
	self->priv->locations = NULL;
	gtk_widget_init_template (GTK_WIDGET (self));
}


static void baobab_location_list_finalize (GObject * obj) {
	BaobabLocationList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BAOBAB_TYPE_LOCATION_LIST, BaobabLocationList);
	_g_object_unref0 (self->priv->local_list_box);
	_g_object_unref0 (self->priv->remote_list_box);
	_g_object_unref0 (self->priv->remote_box);
	(self->priv->location_action_target_destroy_notify == NULL) ? NULL : (self->priv->location_action_target_destroy_notify (self->priv->location_action_target), NULL);
	self->priv->location_action = NULL;
	self->priv->location_action_target = NULL;
	self->priv->location_action_target_destroy_notify = NULL;
	_g_object_unref0 (self->priv->monitor);
	__g_list_free__baobab_location_unref0_0 (self->priv->locations);
	G_OBJECT_CLASS (baobab_location_list_parent_class)->finalize (obj);
}


GType baobab_location_list_get_type (void) {
	static volatile gsize baobab_location_list_type_id__volatile = 0;
	if (g_once_init_enter (&baobab_location_list_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BaobabLocationListClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) baobab_location_list_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BaobabLocationList), 0, (GInstanceInitFunc) baobab_location_list_instance_init, NULL };
		GType baobab_location_list_type_id;
		baobab_location_list_type_id = g_type_register_static (gtk_box_get_type (), "BaobabLocationList", &g_define_type_info, 0);
		g_once_init_leave (&baobab_location_list_type_id__volatile, baobab_location_list_type_id);
	}
	return baobab_location_list_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



