; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 2
; RUN: llc < %s -mtriple=i686-apple-darwin | FileCheck -check-prefix=DARWIN %s
; RUN: opt < %s -O2 | llc -mtriple=x86_64-apple-darwin | FileCheck -check-prefix=DARWIN-OPT %s

define i64 @or_and_fold(i64 %x, i64 %y) {
; DARWIN-LABEL: or_and_fold:
; DARWIN:       ## %bb.0:
; DARWIN-NEXT:    movl {{[0-9]+}}(%esp), %eax
; DARWIN-NEXT:    movl {{[0-9]+}}(%esp), %edx
; DARWIN-NEXT:    retl
;
; DARWIN-OPT-LABEL: or_and_fold:
; DARWIN-OPT:       ## %bb.0:
; DARWIN-OPT-NEXT:    movq %rdi, %rax
; DARWIN-OPT-NEXT:    retq
  %and = and i64 %x, %y
  %or = or i64 %x, %and
  ret i64 %or
}

define i32 @or_and_trunc_fold(i64 %x, i64 %y) {
; DARWIN-LABEL: or_and_trunc_fold:
; DARWIN:       ## %bb.0:
; DARWIN-NEXT:    movl {{[0-9]+}}(%esp), %eax
; DARWIN-NEXT:    retl
;
; DARWIN-OPT-LABEL: or_and_trunc_fold:
; DARWIN-OPT:       ## %bb.0:
; DARWIN-OPT-NEXT:    movq %rdi, %rax
; DARWIN-OPT-NEXT:    ## kill: def $eax killed $eax killed $rax
; DARWIN-OPT-NEXT:    retq
  %tx = trunc i64 %x to i32
  %and = and i64 %x, %y
  %tand = trunc i64 %and to i32
  %or = or i32 %tx, %tand
  ret i32 %or
}

; The dag combiner should fold together (x&127)|(y&16711680) -> (x|y)&c1
; in this case.

define i32 @test1(i32 %x, i16 %y) {
; DARWIN-LABEL: test1:
; DARWIN:       ## %bb.0:
; DARWIN-NEXT:    movzwl {{[0-9]+}}(%esp), %ecx
; DARWIN-NEXT:    movl {{[0-9]+}}(%esp), %eax
; DARWIN-NEXT:    shll $16, %eax
; DARWIN-NEXT:    orl %ecx, %eax
; DARWIN-NEXT:    andl $16711807, %eax ## imm = 0xFF007F
; DARWIN-NEXT:    retl
;
; DARWIN-OPT-LABEL: test1:
; DARWIN-OPT:       ## %bb.0:
; DARWIN-OPT-NEXT:    andl $127, %esi
; DARWIN-OPT-NEXT:    movzbl %dil, %eax
; DARWIN-OPT-NEXT:    shll $16, %eax
; DARWIN-OPT-NEXT:    orl %esi, %eax
; DARWIN-OPT-NEXT:    retq
  %tmp1 = zext i16 %y to i32
  %tmp2 = and i32 %tmp1, 127
  %tmp4 = shl i32 %x, 16
  %tmp5 = and i32 %tmp4, 16711680
  %tmp6 = or i32 %tmp2, %tmp5
  ret i32 %tmp6
}

; <rdar://problem/7529774> The optimizer shouldn't fold this into (and (or, C),  D)
; if (C & D) == 0
define i64 @test2(i64 %x) nounwind readnone ssp {
; DARWIN-LABEL: test2:
; DARWIN:       ## %bb.0: ## %entry
; DARWIN-NEXT:    movl {{[0-9]+}}(%esp), %eax
; DARWIN-NEXT:    orl $3, %eax
; DARWIN-NEXT:    andl $123127, %eax ## imm = 0x1E0F7
; DARWIN-NEXT:    xorl %edx, %edx
; DARWIN-NEXT:    retl
;
; DARWIN-OPT-LABEL: test2:
; DARWIN-OPT:       ## %bb.0: ## %entry
; DARWIN-OPT-NEXT:    andl $123124, %edi ## imm = 0x1E0F4
; DARWIN-OPT-NEXT:    leaq 3(%rdi), %rax
; DARWIN-OPT-NEXT:    retq
entry:
  %tmp1 = and i64 %x, 123127
  %tmp2 = or i64 %tmp1, 3
  ret i64 %tmp2
}
