// RUN: not llvm-mc -triple=amdgcn -mcpu=gfx1100 -mattr=+wavefrontsize32,-real-true16 -show-encoding %s | FileCheck --check-prefixes=GFX11,W32 %s
// RUN: not llvm-mc -triple=amdgcn -mcpu=gfx1100 -mattr=+wavefrontsize64,-real-true16 -show-encoding %s | FileCheck --check-prefixes=GFX11,W64 %s
// RUN: not llvm-mc -triple=amdgcn -mcpu=gfx1100 -mattr=+wavefrontsize32,-real-true16 -filetype=null %s 2>&1 | FileCheck --check-prefix=W32-ERR --implicit-check-not=error: %s
// RUN: not llvm-mc -triple=amdgcn -mcpu=gfx1100 -mattr=+wavefrontsize64,-real-true16 -filetype=null %s 2>&1 | FileCheck --check-prefix=W64-ERR --implicit-check-not=error: %s

v_add_co_ci_u32_e32 v5, vcc_lo, v1, v2, vcc_lo
// W32: encoding: [0x01,0x05,0x0a,0x40]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_add_co_ci_u32 v5, vcc_lo, v255, v2, vcc_lo
// W32: encoding: [0xff,0x05,0x0a,0x40]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_add_co_ci_u32 v5, vcc_lo, s1, v2, vcc_lo
// W32: encoding: [0x01,0x04,0x0a,0x40]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_add_co_ci_u32 v5, vcc_lo, s105, v2, vcc_lo
// W32: encoding: [0x69,0x04,0x0a,0x40]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_add_co_ci_u32 v5, vcc_lo, vcc_lo, v2, vcc_lo
// W32: encoding: [0x6a,0x04,0x0a,0x40]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_add_co_ci_u32 v5, vcc_lo, vcc_hi, v2, vcc_lo
// W32: encoding: [0x6b,0x04,0x0a,0x40]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_add_co_ci_u32 v5, vcc_lo, ttmp15, v2, vcc_lo
// W32: encoding: [0x7b,0x04,0x0a,0x40]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_add_co_ci_u32 v5, vcc_lo, m0, v2, vcc_lo
// W32: encoding: [0x7d,0x04,0x0a,0x40]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_add_co_ci_u32 v5, vcc_lo, exec_lo, v2, vcc_lo
// W32: encoding: [0x7e,0x04,0x0a,0x40]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_add_co_ci_u32 v5, vcc_lo, exec_hi, v2, vcc_lo
// W32: encoding: [0x7f,0x04,0x0a,0x40]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_add_co_ci_u32 v5, vcc_lo, null, v2, vcc_lo
// W32: encoding: [0x7c,0x04,0x0a,0x40]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_add_co_ci_u32 v5, vcc_lo, -1, v2, vcc_lo
// W32: encoding: [0xc1,0x04,0x0a,0x40]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_add_co_ci_u32 v5, vcc_lo, 0.5, v2, vcc_lo
// W32: encoding: [0xf0,0x04,0x0a,0x40]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_add_co_ci_u32 v5, vcc_lo, src_scc, v2, vcc_lo
// W32: encoding: [0xfd,0x04,0x0a,0x40]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_add_co_ci_u32 v255, vcc_lo, 0xaf123456, v255, vcc_lo
// W32: encoding: [0xff,0xfe,0xff,0x41,0x56,0x34,0x12,0xaf]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_add_co_ci_u32 v5, vcc, v1, v2, vcc
// W64: encoding: [0x01,0x05,0x0a,0x40]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_add_co_ci_u32 v5, vcc, v255, v2, vcc
// W64: encoding: [0xff,0x05,0x0a,0x40]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_add_co_ci_u32 v5, vcc, s1, v2, vcc
// W64: encoding: [0x01,0x04,0x0a,0x40]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_add_co_ci_u32 v5, vcc, s105, v2, vcc
// W64: encoding: [0x69,0x04,0x0a,0x40]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_add_co_ci_u32 v5, vcc, vcc_lo, v2, vcc
// W64: encoding: [0x6a,0x04,0x0a,0x40]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_add_co_ci_u32 v5, vcc, vcc_hi, v2, vcc
// W64: encoding: [0x6b,0x04,0x0a,0x40]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_add_co_ci_u32 v5, vcc, ttmp15, v2, vcc
// W64: encoding: [0x7b,0x04,0x0a,0x40]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_add_co_ci_u32 v5, vcc, m0, v2, vcc
// W64: encoding: [0x7d,0x04,0x0a,0x40]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_add_co_ci_u32 v5, vcc, exec_lo, v2, vcc
// W64: encoding: [0x7e,0x04,0x0a,0x40]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_add_co_ci_u32 v5, vcc, exec_hi, v2, vcc
// W64: encoding: [0x7f,0x04,0x0a,0x40]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_add_co_ci_u32 v5, vcc, null, v2, vcc
// W64: encoding: [0x7c,0x04,0x0a,0x40]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_add_co_ci_u32 v5, vcc, -1, v2, vcc
// W64: encoding: [0xc1,0x04,0x0a,0x40]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_add_co_ci_u32 v5, vcc, 0.5, v2, vcc
// W64: encoding: [0xf0,0x04,0x0a,0x40]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_add_co_ci_u32 v5, vcc, src_scc, v2, vcc
// W64: encoding: [0xfd,0x04,0x0a,0x40]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_add_co_ci_u32 v255, vcc, 0xaf123456, v255, vcc
// W64: encoding: [0xff,0xfe,0xff,0x41,0x56,0x34,0x12,0xaf]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_add_f16 v5, v1, v2
// GFX11: encoding: [0x01,0x05,0x0a,0x64]

v_add_f16 v5, v127, v2
// GFX11: encoding: [0x7f,0x05,0x0a,0x64]

v_add_f16 v5, s1, v2
// GFX11: encoding: [0x01,0x04,0x0a,0x64]

v_add_f16 v5, s105, v2
// GFX11: encoding: [0x69,0x04,0x0a,0x64]

v_add_f16 v5, vcc_lo, v2
// GFX11: encoding: [0x6a,0x04,0x0a,0x64]

v_add_f16 v5, vcc_hi, v2
// GFX11: encoding: [0x6b,0x04,0x0a,0x64]

v_add_f16 v5, ttmp15, v2
// GFX11: encoding: [0x7b,0x04,0x0a,0x64]

v_add_f16 v5, m0, v2
// GFX11: encoding: [0x7d,0x04,0x0a,0x64]

v_add_f16 v5, exec_lo, v2
// GFX11: encoding: [0x7e,0x04,0x0a,0x64]

v_add_f16 v5, exec_hi, v2
// GFX11: encoding: [0x7f,0x04,0x0a,0x64]

v_add_f16 v5, null, v2
// GFX11: encoding: [0x7c,0x04,0x0a,0x64]

v_add_f16 v5, -1, v2
// GFX11: encoding: [0xc1,0x04,0x0a,0x64]

v_add_f16 v5, 0.5, v2
// GFX11: encoding: [0xf0,0x04,0x0a,0x64]

v_add_f16 v5, src_scc, v2
// GFX11: encoding: [0xfd,0x04,0x0a,0x64]

v_add_f16 v127, 0xfe0b, v127
// GFX11: encoding: [0xff,0xfe,0xfe,0x64,0x0b,0xfe,0x00,0x00]

v_add_f32 v5, v1, v2
// GFX11: encoding: [0x01,0x05,0x0a,0x06]

v_add_f32 v5, v255, v2
// GFX11: encoding: [0xff,0x05,0x0a,0x06]

v_add_f32 v5, s1, v2
// GFX11: encoding: [0x01,0x04,0x0a,0x06]

v_add_f32 v5, s105, v2
// GFX11: encoding: [0x69,0x04,0x0a,0x06]

v_add_f32 v5, vcc_lo, v2
// GFX11: encoding: [0x6a,0x04,0x0a,0x06]

v_add_f32 v5, vcc_hi, v2
// GFX11: encoding: [0x6b,0x04,0x0a,0x06]

v_add_f32 v5, ttmp15, v2
// GFX11: encoding: [0x7b,0x04,0x0a,0x06]

v_add_f32 v5, m0, v2
// GFX11: encoding: [0x7d,0x04,0x0a,0x06]

v_add_f32 v5, exec_lo, v2
// GFX11: encoding: [0x7e,0x04,0x0a,0x06]

v_add_f32 v5, exec_hi, v2
// GFX11: encoding: [0x7f,0x04,0x0a,0x06]

v_add_f32 v5, null, v2
// GFX11: encoding: [0x7c,0x04,0x0a,0x06]

v_add_f32 v5, -1, v2
// GFX11: encoding: [0xc1,0x04,0x0a,0x06]

v_add_f32 v5, 0.5, v2
// GFX11: encoding: [0xf0,0x04,0x0a,0x06]

v_add_f32 v5, src_scc, v2
// GFX11: encoding: [0xfd,0x04,0x0a,0x06]

v_add_f32 v255, 0xaf123456, v255
// GFX11: encoding: [0xff,0xfe,0xff,0x07,0x56,0x34,0x12,0xaf]

v_add_nc_u32 v5, v1, v2
// GFX11: encoding: [0x01,0x05,0x0a,0x4a]

v_add_nc_u32 v5, v255, v2
// GFX11: encoding: [0xff,0x05,0x0a,0x4a]

v_add_nc_u32 v5, s1, v2
// GFX11: encoding: [0x01,0x04,0x0a,0x4a]

v_add_nc_u32 v5, s105, v2
// GFX11: encoding: [0x69,0x04,0x0a,0x4a]

v_add_nc_u32 v5, vcc_lo, v2
// GFX11: encoding: [0x6a,0x04,0x0a,0x4a]

v_add_nc_u32 v5, vcc_hi, v2
// GFX11: encoding: [0x6b,0x04,0x0a,0x4a]

v_add_nc_u32 v5, ttmp15, v2
// GFX11: encoding: [0x7b,0x04,0x0a,0x4a]

v_add_nc_u32 v5, m0, v2
// GFX11: encoding: [0x7d,0x04,0x0a,0x4a]

v_add_nc_u32 v5, exec_lo, v2
// GFX11: encoding: [0x7e,0x04,0x0a,0x4a]

v_add_nc_u32 v5, exec_hi, v2
// GFX11: encoding: [0x7f,0x04,0x0a,0x4a]

v_add_nc_u32 v5, null, v2
// GFX11: encoding: [0x7c,0x04,0x0a,0x4a]

v_add_nc_u32 v5, -1, v2
// GFX11: encoding: [0xc1,0x04,0x0a,0x4a]

v_add_nc_u32 v5, 0.5, v2
// GFX11: encoding: [0xf0,0x04,0x0a,0x4a]

v_add_nc_u32 v5, src_scc, v2
// GFX11: encoding: [0xfd,0x04,0x0a,0x4a]

v_add_nc_u32 v255, 0xaf123456, v255
// GFX11: encoding: [0xff,0xfe,0xff,0x4b,0x56,0x34,0x12,0xaf]

v_and_b32 v5, v1, v2
// GFX11: encoding: [0x01,0x05,0x0a,0x36]

v_and_b32 v5, v255, v2
// GFX11: encoding: [0xff,0x05,0x0a,0x36]

v_and_b32 v5, s1, v2
// GFX11: encoding: [0x01,0x04,0x0a,0x36]

v_and_b32 v5, s105, v2
// GFX11: encoding: [0x69,0x04,0x0a,0x36]

v_and_b32 v5, vcc_lo, v2
// GFX11: encoding: [0x6a,0x04,0x0a,0x36]

v_and_b32 v5, vcc_hi, v2
// GFX11: encoding: [0x6b,0x04,0x0a,0x36]

v_and_b32 v5, ttmp15, v2
// GFX11: encoding: [0x7b,0x04,0x0a,0x36]

v_and_b32 v5, m0, v2
// GFX11: encoding: [0x7d,0x04,0x0a,0x36]

v_and_b32 v5, exec_lo, v2
// GFX11: encoding: [0x7e,0x04,0x0a,0x36]

v_and_b32 v5, exec_hi, v2
// GFX11: encoding: [0x7f,0x04,0x0a,0x36]

v_and_b32 v5, null, v2
// GFX11: encoding: [0x7c,0x04,0x0a,0x36]

v_and_b32 v5, -1, v2
// GFX11: encoding: [0xc1,0x04,0x0a,0x36]

v_and_b32 v5, 0.5, v2
// GFX11: encoding: [0xf0,0x04,0x0a,0x36]

v_and_b32 v5, src_scc, v2
// GFX11: encoding: [0xfd,0x04,0x0a,0x36]

v_and_b32 v255, 0xaf123456, v255
// GFX11: encoding: [0xff,0xfe,0xff,0x37,0x56,0x34,0x12,0xaf]

v_ashrrev_i32 v5, v1, v2
// GFX11: encoding: [0x01,0x05,0x0a,0x34]

v_ashrrev_i32 v5, v255, v2
// GFX11: encoding: [0xff,0x05,0x0a,0x34]

v_ashrrev_i32 v5, s1, v2
// GFX11: encoding: [0x01,0x04,0x0a,0x34]

v_ashrrev_i32 v5, s105, v2
// GFX11: encoding: [0x69,0x04,0x0a,0x34]

v_ashrrev_i32 v5, vcc_lo, v2
// GFX11: encoding: [0x6a,0x04,0x0a,0x34]

v_ashrrev_i32 v5, vcc_hi, v2
// GFX11: encoding: [0x6b,0x04,0x0a,0x34]

v_ashrrev_i32 v5, ttmp15, v2
// GFX11: encoding: [0x7b,0x04,0x0a,0x34]

v_ashrrev_i32 v5, m0, v2
// GFX11: encoding: [0x7d,0x04,0x0a,0x34]

v_ashrrev_i32 v5, exec_lo, v2
// GFX11: encoding: [0x7e,0x04,0x0a,0x34]

v_ashrrev_i32 v5, exec_hi, v2
// GFX11: encoding: [0x7f,0x04,0x0a,0x34]

v_ashrrev_i32 v5, null, v2
// GFX11: encoding: [0x7c,0x04,0x0a,0x34]

v_ashrrev_i32 v5, -1, v2
// GFX11: encoding: [0xc1,0x04,0x0a,0x34]

v_ashrrev_i32 v5, 0.5, v2
// GFX11: encoding: [0xf0,0x04,0x0a,0x34]

v_ashrrev_i32 v5, src_scc, v2
// GFX11: encoding: [0xfd,0x04,0x0a,0x34]

v_ashrrev_i32 v255, 0xaf123456, v255
// GFX11: encoding: [0xff,0xfe,0xff,0x35,0x56,0x34,0x12,0xaf]

v_cndmask_b32 v5, v1, v2, vcc_lo
// W32: encoding: [0x01,0x05,0x0a,0x02]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_cndmask_b32 v5, v255, v2, vcc_lo
// W32: encoding: [0xff,0x05,0x0a,0x02]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_cndmask_b32 v5, s1, v2, vcc_lo
// W32: encoding: [0x01,0x04,0x0a,0x02]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_cndmask_b32 v5, s105, v2, vcc_lo
// W32: encoding: [0x69,0x04,0x0a,0x02]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_cndmask_b32 v5, vcc_lo, v2, vcc_lo
// W32: encoding: [0x6a,0x04,0x0a,0x02]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_cndmask_b32 v5, vcc_hi, v2, vcc_lo
// W32: encoding: [0x6b,0x04,0x0a,0x02]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_cndmask_b32 v5, ttmp15, v2, vcc_lo
// W32: encoding: [0x7b,0x04,0x0a,0x02]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_cndmask_b32 v5, m0, v2, vcc_lo
// W32: encoding: [0x7d,0x04,0x0a,0x02]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_cndmask_b32 v5, exec_lo, v2, vcc_lo
// W32: encoding: [0x7e,0x04,0x0a,0x02]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_cndmask_b32 v5, exec_hi, v2, vcc_lo
// W32: encoding: [0x7f,0x04,0x0a,0x02]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_cndmask_b32 v5, null, v2, vcc_lo
// W32: encoding: [0x7c,0x04,0x0a,0x02]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_cndmask_b32 v5, -1, v2, vcc_lo
// W32: encoding: [0xc1,0x04,0x0a,0x02]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_cndmask_b32 v5, 0.5, v2, vcc_lo
// W32: encoding: [0xf0,0x04,0x0a,0x02]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_cndmask_b32 v5, src_scc, v2, vcc_lo
// W32: encoding: [0xfd,0x04,0x0a,0x02]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_cndmask_b32 v255, 0xaf123456, v255, vcc_lo
// W32: encoding: [0xff,0xfe,0xff,0x03,0x56,0x34,0x12,0xaf]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_cndmask_b32 v5, v1, v2, vcc
// W64: encoding: [0x01,0x05,0x0a,0x02]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_cndmask_b32 v5, v255, v2, vcc
// W64: encoding: [0xff,0x05,0x0a,0x02]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_cndmask_b32 v5, s1, v2, vcc
// W64: encoding: [0x01,0x04,0x0a,0x02]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_cndmask_b32 v5, s105, v2, vcc
// W64: encoding: [0x69,0x04,0x0a,0x02]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_cndmask_b32 v5, vcc_lo, v2, vcc
// W64: encoding: [0x6a,0x04,0x0a,0x02]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_cndmask_b32 v5, vcc_hi, v2, vcc
// W64: encoding: [0x6b,0x04,0x0a,0x02]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_cndmask_b32 v5, ttmp15, v2, vcc
// W64: encoding: [0x7b,0x04,0x0a,0x02]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_cndmask_b32 v5, m0, v2, vcc
// W64: encoding: [0x7d,0x04,0x0a,0x02]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_cndmask_b32 v5, exec_lo, v2, vcc
// W64: encoding: [0x7e,0x04,0x0a,0x02]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_cndmask_b32 v5, exec_hi, v2, vcc
// W64: encoding: [0x7f,0x04,0x0a,0x02]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_cndmask_b32 v5, null, v2, vcc
// W64: encoding: [0x7c,0x04,0x0a,0x02]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_cndmask_b32 v5, -1, v2, vcc
// W64: encoding: [0xc1,0x04,0x0a,0x02]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_cndmask_b32 v5, 0.5, v2, vcc
// W64: encoding: [0xf0,0x04,0x0a,0x02]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_cndmask_b32 v5, src_scc, v2, vcc
// W64: encoding: [0xfd,0x04,0x0a,0x02]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_cndmask_b32 v255, 0xaf123456, v255, vcc
// W64: encoding: [0xff,0xfe,0xff,0x03,0x56,0x34,0x12,0xaf]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_cvt_pk_rtz_f16_f32 v5, v1, v2
// GFX11: encoding: [0x01,0x05,0x0a,0x5e]

v_cvt_pk_rtz_f16_f32 v5, v255, v2
// GFX11: encoding: [0xff,0x05,0x0a,0x5e]

v_cvt_pk_rtz_f16_f32 v5, s1, v2
// GFX11: encoding: [0x01,0x04,0x0a,0x5e]

v_cvt_pk_rtz_f16_f32 v5, s105, v2
// GFX11: encoding: [0x69,0x04,0x0a,0x5e]

v_cvt_pk_rtz_f16_f32 v5, vcc_lo, v2
// GFX11: encoding: [0x6a,0x04,0x0a,0x5e]

v_cvt_pk_rtz_f16_f32 v5, vcc_hi, v2
// GFX11: encoding: [0x6b,0x04,0x0a,0x5e]

v_cvt_pk_rtz_f16_f32 v5, ttmp15, v2
// GFX11: encoding: [0x7b,0x04,0x0a,0x5e]

v_cvt_pk_rtz_f16_f32 v5, m0, v2
// GFX11: encoding: [0x7d,0x04,0x0a,0x5e]

v_cvt_pk_rtz_f16_f32 v5, exec_lo, v2
// GFX11: encoding: [0x7e,0x04,0x0a,0x5e]

v_cvt_pk_rtz_f16_f32 v5, exec_hi, v2
// GFX11: encoding: [0x7f,0x04,0x0a,0x5e]

v_cvt_pk_rtz_f16_f32 v5, null, v2
// GFX11: encoding: [0x7c,0x04,0x0a,0x5e]

v_cvt_pk_rtz_f16_f32 v5, -1, v2
// GFX11: encoding: [0xc1,0x04,0x0a,0x5e]

v_cvt_pk_rtz_f16_f32 v5, 0.5, v2
// GFX11: encoding: [0xf0,0x04,0x0a,0x5e]

v_cvt_pk_rtz_f16_f32 v5, src_scc, v2
// GFX11: encoding: [0xfd,0x04,0x0a,0x5e]

v_cvt_pk_rtz_f16_f32 v255, 0xaf123456, v255
// GFX11: encoding: [0xff,0xfe,0xff,0x5f,0x56,0x34,0x12,0xaf]

v_cvt_pkrtz_f16_f32 v5, v1, v2
// GFX11: encoding: [0x01,0x05,0x0a,0x5e]

v_cvt_pkrtz_f16_f32 v5, v255, v2
// GFX11: encoding: [0xff,0x05,0x0a,0x5e]

v_cvt_pkrtz_f16_f32 v5, s1, v2
// GFX11: encoding: [0x01,0x04,0x0a,0x5e]

v_cvt_pkrtz_f16_f32 v5, s105, v2
// GFX11: encoding: [0x69,0x04,0x0a,0x5e]

v_cvt_pkrtz_f16_f32 v5, vcc_lo, v2
// GFX11: encoding: [0x6a,0x04,0x0a,0x5e]

v_cvt_pkrtz_f16_f32 v5, vcc_hi, v2
// GFX11: encoding: [0x6b,0x04,0x0a,0x5e]

v_cvt_pkrtz_f16_f32 v5, ttmp15, v2
// GFX11: encoding: [0x7b,0x04,0x0a,0x5e]

v_cvt_pkrtz_f16_f32 v5, m0, v2
// GFX11: encoding: [0x7d,0x04,0x0a,0x5e]

v_cvt_pkrtz_f16_f32 v5, exec_lo, v2
// GFX11: encoding: [0x7e,0x04,0x0a,0x5e]

v_cvt_pkrtz_f16_f32 v5, exec_hi, v2
// GFX11: encoding: [0x7f,0x04,0x0a,0x5e]

v_cvt_pkrtz_f16_f32 v5, null, v2
// GFX11: encoding: [0x7c,0x04,0x0a,0x5e]

v_cvt_pkrtz_f16_f32 v5, -1, v2
// GFX11: encoding: [0xc1,0x04,0x0a,0x5e]

v_cvt_pkrtz_f16_f32 v5, 0.5, v2
// GFX11: encoding: [0xf0,0x04,0x0a,0x5e]

v_cvt_pkrtz_f16_f32 v5, src_scc, v2
// GFX11: encoding: [0xfd,0x04,0x0a,0x5e]

v_cvt_pkrtz_f16_f32 v255, 0xaf123456, v255
// GFX11: encoding: [0xff,0xfe,0xff,0x5f,0x56,0x34,0x12,0xaf]

v_dot2acc_f32_f16 v5, v1, v2
// GFX11: encoding: [0x01,0x05,0x0a,0x04]

v_dot2acc_f32_f16 v5, v255, v2
// GFX11: encoding: [0xff,0x05,0x0a,0x04]

v_dot2acc_f32_f16 v5, s1, v2
// GFX11: encoding: [0x01,0x04,0x0a,0x04]

v_dot2acc_f32_f16 v5, s105, v2
// GFX11: encoding: [0x69,0x04,0x0a,0x04]

v_dot2acc_f32_f16 v5, vcc_lo, v2
// GFX11: encoding: [0x6a,0x04,0x0a,0x04]

v_dot2acc_f32_f16 v5, vcc_hi, v2
// GFX11: encoding: [0x6b,0x04,0x0a,0x04]

v_dot2acc_f32_f16 v5, ttmp15, v2
// GFX11: encoding: [0x7b,0x04,0x0a,0x04]

v_dot2acc_f32_f16 v5, m0, v2
// GFX11: encoding: [0x7d,0x04,0x0a,0x04]

v_dot2acc_f32_f16 v5, exec_lo, v2
// GFX11: encoding: [0x7e,0x04,0x0a,0x04]

v_dot2acc_f32_f16 v5, exec_hi, v2
// GFX11: encoding: [0x7f,0x04,0x0a,0x04]

v_dot2acc_f32_f16 v5, null, v2
// GFX11: encoding: [0x7c,0x04,0x0a,0x04]

v_dot2acc_f32_f16 v5, -1, v2
// GFX11: encoding: [0xc1,0x04,0x0a,0x04]

v_dot2acc_f32_f16 v5, 0.5, v2
// GFX11: encoding: [0xf0,0x04,0x0a,0x04]

v_dot2acc_f32_f16 v5, src_scc, v2
// GFX11: encoding: [0xfd,0x04,0x0a,0x04]

v_dot2acc_f32_f16 v255, 0xfe0b, v255
// GFX11: encoding: [0xff,0xfe,0xff,0x05,0x0b,0xfe,0x00,0x00]

v_dot2c_f32_f16 v5, v1, v2
// GFX11: encoding: [0x01,0x05,0x0a,0x04]

v_dot2c_f32_f16 v5, v255, v2
// GFX11: encoding: [0xff,0x05,0x0a,0x04]

v_dot2c_f32_f16 v5, s1, v2
// GFX11: encoding: [0x01,0x04,0x0a,0x04]

v_dot2c_f32_f16 v5, s105, v2
// GFX11: encoding: [0x69,0x04,0x0a,0x04]

v_dot2c_f32_f16 v5, vcc_lo, v2
// GFX11: encoding: [0x6a,0x04,0x0a,0x04]

v_dot2c_f32_f16 v5, vcc_hi, v2
// GFX11: encoding: [0x6b,0x04,0x0a,0x04]

v_dot2c_f32_f16 v5, ttmp15, v2
// GFX11: encoding: [0x7b,0x04,0x0a,0x04]

v_dot2c_f32_f16 v5, m0, v2
// GFX11: encoding: [0x7d,0x04,0x0a,0x04]

v_dot2c_f32_f16 v5, exec_lo, v2
// GFX11: encoding: [0x7e,0x04,0x0a,0x04]

v_dot2c_f32_f16 v5, exec_hi, v2
// GFX11: encoding: [0x7f,0x04,0x0a,0x04]

v_dot2c_f32_f16 v5, null, v2
// GFX11: encoding: [0x7c,0x04,0x0a,0x04]

v_dot2c_f32_f16 v5, -1, v2
// GFX11: encoding: [0xc1,0x04,0x0a,0x04]

v_dot2c_f32_f16 v5, 0.5, v2
// GFX11: encoding: [0xf0,0x04,0x0a,0x04]

v_dot2c_f32_f16 v5, src_scc, v2
// GFX11: encoding: [0xfd,0x04,0x0a,0x04]

v_dot2c_f32_f16 v255, 0xfe0b, v255
// GFX11: encoding: [0xff,0xfe,0xff,0x05,0x0b,0xfe,0x00,0x00]

v_fmaak_f16 v5, v1, v2, 0xfe0b
// GFX11: encoding: [0x01,0x05,0x0a,0x70,0x0b,0xfe,0x00,0x00]

v_fmaak_f16 v5, v127, v2, 0xfe0b
// GFX11: encoding: [0x7f,0x05,0x0a,0x70,0x0b,0xfe,0x00,0x00]

v_fmaak_f16 v5, s1, v2, 0xfe0b
// GFX11: encoding: [0x01,0x04,0x0a,0x70,0x0b,0xfe,0x00,0x00]

v_fmaak_f16 v5, s105, v2, 0xfe0b
// GFX11: encoding: [0x69,0x04,0x0a,0x70,0x0b,0xfe,0x00,0x00]

v_fmaak_f16 v5, vcc_lo, v2, 0xfe0b
// GFX11: encoding: [0x6a,0x04,0x0a,0x70,0x0b,0xfe,0x00,0x00]

v_fmaak_f16 v5, vcc_hi, v2, 0xfe0b
// GFX11: encoding: [0x6b,0x04,0x0a,0x70,0x0b,0xfe,0x00,0x00]

v_fmaak_f16 v5, ttmp15, v2, 0xfe0b
// GFX11: encoding: [0x7b,0x04,0x0a,0x70,0x0b,0xfe,0x00,0x00]

v_fmaak_f16 v5, m0, v2, 0xfe0b
// GFX11: encoding: [0x7d,0x04,0x0a,0x70,0x0b,0xfe,0x00,0x00]

v_fmaak_f16 v5, exec_lo, v2, 0xfe0b
// GFX11: encoding: [0x7e,0x04,0x0a,0x70,0x0b,0xfe,0x00,0x00]

v_fmaak_f16 v5, exec_hi, v2, 0xfe0b
// GFX11: encoding: [0x7f,0x04,0x0a,0x70,0x0b,0xfe,0x00,0x00]

v_fmaak_f16 v5, null, v2, 0xfe0b
// GFX11: encoding: [0x7c,0x04,0x0a,0x70,0x0b,0xfe,0x00,0x00]

v_fmaak_f16 v5, -1, v2, 0xfe0b
// GFX11: encoding: [0xc1,0x04,0x0a,0x70,0x0b,0xfe,0x00,0x00]

v_fmaak_f16 v5, 0.5, v2, 0xfe0b
// GFX11: encoding: [0xf0,0x04,0x0a,0x70,0x0b,0xfe,0x00,0x00]

v_fmaak_f16 v5, src_scc, v2, 0xfe0b
// GFX11: encoding: [0xfd,0x04,0x0a,0x70,0x0b,0xfe,0x00,0x00]

v_fmaak_f16 v127, 0xfe0b, v127, 0xfe0b
// GFX11: encoding: [0xff,0xfe,0xfe,0x70,0x0b,0xfe,0x00,0x00]

v_fmaak_f32 v5, v1, v2, 0xaf123456
// GFX11: encoding: [0x01,0x05,0x0a,0x5a,0x56,0x34,0x12,0xaf]

v_fmaak_f32 v5, v255, v2, 0xaf123456
// GFX11: encoding: [0xff,0x05,0x0a,0x5a,0x56,0x34,0x12,0xaf]

v_fmaak_f32 v5, s1, v2, 0xaf123456
// GFX11: encoding: [0x01,0x04,0x0a,0x5a,0x56,0x34,0x12,0xaf]

v_fmaak_f32 v5, s105, v2, 0xaf123456
// GFX11: encoding: [0x69,0x04,0x0a,0x5a,0x56,0x34,0x12,0xaf]

v_fmaak_f32 v5, vcc_lo, v2, 0xaf123456
// GFX11: encoding: [0x6a,0x04,0x0a,0x5a,0x56,0x34,0x12,0xaf]

v_fmaak_f32 v5, vcc_hi, v2, 0xaf123456
// GFX11: encoding: [0x6b,0x04,0x0a,0x5a,0x56,0x34,0x12,0xaf]

v_fmaak_f32 v5, ttmp15, v2, 0xaf123456
// GFX11: encoding: [0x7b,0x04,0x0a,0x5a,0x56,0x34,0x12,0xaf]

v_fmaak_f32 v5, m0, v2, 0xaf123456
// GFX11: encoding: [0x7d,0x04,0x0a,0x5a,0x56,0x34,0x12,0xaf]

v_fmaak_f32 v5, exec_lo, v2, 0xaf123456
// GFX11: encoding: [0x7e,0x04,0x0a,0x5a,0x56,0x34,0x12,0xaf]

v_fmaak_f32 v5, exec_hi, v2, 0xaf123456
// GFX11: encoding: [0x7f,0x04,0x0a,0x5a,0x56,0x34,0x12,0xaf]

v_fmaak_f32 v5, null, v2, 0xaf123456
// GFX11: encoding: [0x7c,0x04,0x0a,0x5a,0x56,0x34,0x12,0xaf]

v_fmaak_f32 v5, -1, v2, 0xaf123456
// GFX11: encoding: [0xc1,0x04,0x0a,0x5a,0x56,0x34,0x12,0xaf]

v_fmaak_f32 v5, 0.5, v2, 0xaf123456
// GFX11: encoding: [0xf0,0x04,0x0a,0x5a,0x56,0x34,0x12,0xaf]

v_fmaak_f32 v5, src_scc, v2, 0xaf123456
// GFX11: encoding: [0xfd,0x04,0x0a,0x5a,0x56,0x34,0x12,0xaf]

v_fmaak_f32 v255, 0xaf123456, v255, 0xaf123456
// GFX11: encoding: [0xff,0xfe,0xff,0x5b,0x56,0x34,0x12,0xaf]

v_fmac_dx9_zero_f32 v5, v1, v2
// GFX11: encoding: [0x01,0x05,0x0a,0x0c]

v_fmac_dx9_zero_f32 v5, v255, v2
// GFX11: encoding: [0xff,0x05,0x0a,0x0c]

v_fmac_dx9_zero_f32 v5, s1, v2
// GFX11: encoding: [0x01,0x04,0x0a,0x0c]

v_fmac_dx9_zero_f32 v5, s105, v2
// GFX11: encoding: [0x69,0x04,0x0a,0x0c]

v_fmac_dx9_zero_f32 v5, vcc_lo, v2
// GFX11: encoding: [0x6a,0x04,0x0a,0x0c]

v_fmac_dx9_zero_f32 v5, vcc_hi, v2
// GFX11: encoding: [0x6b,0x04,0x0a,0x0c]

v_fmac_dx9_zero_f32 v5, ttmp15, v2
// GFX11: encoding: [0x7b,0x04,0x0a,0x0c]

v_fmac_dx9_zero_f32 v5, m0, v2
// GFX11: encoding: [0x7d,0x04,0x0a,0x0c]

v_fmac_dx9_zero_f32 v5, exec_lo, v2
// GFX11: encoding: [0x7e,0x04,0x0a,0x0c]

v_fmac_dx9_zero_f32 v5, exec_hi, v2
// GFX11: encoding: [0x7f,0x04,0x0a,0x0c]

v_fmac_dx9_zero_f32 v5, null, v2
// GFX11: encoding: [0x7c,0x04,0x0a,0x0c]

v_fmac_dx9_zero_f32 v5, -1, v2
// GFX11: encoding: [0xc1,0x04,0x0a,0x0c]

v_fmac_dx9_zero_f32 v5, 0.5, v2
// GFX11: encoding: [0xf0,0x04,0x0a,0x0c]

v_fmac_dx9_zero_f32 v5, src_scc, v2
// GFX11: encoding: [0xfd,0x04,0x0a,0x0c]

v_fmac_dx9_zero_f32 v255, 0xaf123456, v255
// GFX11: encoding: [0xff,0xfe,0xff,0x0d,0x56,0x34,0x12,0xaf]

v_fmac_f16 v5, v1, v2
// GFX11: encoding: [0x01,0x05,0x0a,0x6c]

v_fmac_f16 v5, v127, v2
// GFX11: encoding: [0x7f,0x05,0x0a,0x6c]

v_fmac_f16 v5, s1, v2
// GFX11: encoding: [0x01,0x04,0x0a,0x6c]

v_fmac_f16 v5, s105, v2
// GFX11: encoding: [0x69,0x04,0x0a,0x6c]

v_fmac_f16 v5, vcc_lo, v2
// GFX11: encoding: [0x6a,0x04,0x0a,0x6c]

v_fmac_f16 v5, vcc_hi, v2
// GFX11: encoding: [0x6b,0x04,0x0a,0x6c]

v_fmac_f16 v5, ttmp15, v2
// GFX11: encoding: [0x7b,0x04,0x0a,0x6c]

v_fmac_f16 v5, m0, v2
// GFX11: encoding: [0x7d,0x04,0x0a,0x6c]

v_fmac_f16 v5, exec_lo, v2
// GFX11: encoding: [0x7e,0x04,0x0a,0x6c]

v_fmac_f16 v5, exec_hi, v2
// GFX11: encoding: [0x7f,0x04,0x0a,0x6c]

v_fmac_f16 v5, null, v2
// GFX11: encoding: [0x7c,0x04,0x0a,0x6c]

v_fmac_f16 v5, -1, v2
// GFX11: encoding: [0xc1,0x04,0x0a,0x6c]

v_fmac_f16 v5, 0.5, v2
// GFX11: encoding: [0xf0,0x04,0x0a,0x6c]

v_fmac_f16 v5, src_scc, v2
// GFX11: encoding: [0xfd,0x04,0x0a,0x6c]

v_fmac_f16 v127, 0xfe0b, v127
// GFX11: encoding: [0xff,0xfe,0xfe,0x6c,0x0b,0xfe,0x00,0x00]

v_fmac_f32 v5, v1, v2
// GFX11: encoding: [0x01,0x05,0x0a,0x56]

v_fmac_f32 v5, v255, v2
// GFX11: encoding: [0xff,0x05,0x0a,0x56]

v_fmac_f32 v5, s1, v2
// GFX11: encoding: [0x01,0x04,0x0a,0x56]

v_fmac_f32 v5, s105, v2
// GFX11: encoding: [0x69,0x04,0x0a,0x56]

v_fmac_f32 v5, vcc_lo, v2
// GFX11: encoding: [0x6a,0x04,0x0a,0x56]

v_fmac_f32 v5, vcc_hi, v2
// GFX11: encoding: [0x6b,0x04,0x0a,0x56]

v_fmac_f32 v5, ttmp15, v2
// GFX11: encoding: [0x7b,0x04,0x0a,0x56]

v_fmac_f32 v5, m0, v2
// GFX11: encoding: [0x7d,0x04,0x0a,0x56]

v_fmac_f32 v5, exec_lo, v2
// GFX11: encoding: [0x7e,0x04,0x0a,0x56]

v_fmac_f32 v5, exec_hi, v2
// GFX11: encoding: [0x7f,0x04,0x0a,0x56]

v_fmac_f32 v5, null, v2
// GFX11: encoding: [0x7c,0x04,0x0a,0x56]

v_fmac_f32 v5, -1, v2
// GFX11: encoding: [0xc1,0x04,0x0a,0x56]

v_fmac_f32 v5, 0.5, v2
// GFX11: encoding: [0xf0,0x04,0x0a,0x56]

v_fmac_f32 v5, src_scc, v2
// GFX11: encoding: [0xfd,0x04,0x0a,0x56]

v_fmac_f32 v255, 0xaf123456, v255
// GFX11: encoding: [0xff,0xfe,0xff,0x57,0x56,0x34,0x12,0xaf]

v_fmac_legacy_f32 v5, v1, v2
// GFX11: encoding: [0x01,0x05,0x0a,0x0c]

v_fmac_legacy_f32 v5, v255, v2
// GFX11: encoding: [0xff,0x05,0x0a,0x0c]

v_fmac_legacy_f32 v5, s1, v2
// GFX11: encoding: [0x01,0x04,0x0a,0x0c]

v_fmac_legacy_f32 v5, s105, v2
// GFX11: encoding: [0x69,0x04,0x0a,0x0c]

v_fmac_legacy_f32 v5, vcc_lo, v2
// GFX11: encoding: [0x6a,0x04,0x0a,0x0c]

v_fmac_legacy_f32 v5, vcc_hi, v2
// GFX11: encoding: [0x6b,0x04,0x0a,0x0c]

v_fmac_legacy_f32 v5, ttmp15, v2
// GFX11: encoding: [0x7b,0x04,0x0a,0x0c]

v_fmac_legacy_f32 v5, m0, v2
// GFX11: encoding: [0x7d,0x04,0x0a,0x0c]

v_fmac_legacy_f32 v5, exec_lo, v2
// GFX11: encoding: [0x7e,0x04,0x0a,0x0c]

v_fmac_legacy_f32 v5, exec_hi, v2
// GFX11: encoding: [0x7f,0x04,0x0a,0x0c]

v_fmac_legacy_f32 v5, null, v2
// GFX11: encoding: [0x7c,0x04,0x0a,0x0c]

v_fmac_legacy_f32 v5, -1, v2
// GFX11: encoding: [0xc1,0x04,0x0a,0x0c]

v_fmac_legacy_f32 v5, 0.5, v2
// GFX11: encoding: [0xf0,0x04,0x0a,0x0c]

v_fmac_legacy_f32 v5, src_scc, v2
// GFX11: encoding: [0xfd,0x04,0x0a,0x0c]

v_fmac_legacy_f32 v255, 0xaf123456, v255
// GFX11: encoding: [0xff,0xfe,0xff,0x0d,0x56,0x34,0x12,0xaf]

v_fmamk_f16 v5, v1, 0xfe0b, v3
// GFX11: encoding: [0x01,0x07,0x0a,0x6e,0x0b,0xfe,0x00,0x00]

v_fmamk_f16 v5, v127, 0xfe0b, v3
// GFX11: encoding: [0x7f,0x07,0x0a,0x6e,0x0b,0xfe,0x00,0x00]

v_fmamk_f16 v5, s1, 0xfe0b, v3
// GFX11: encoding: [0x01,0x06,0x0a,0x6e,0x0b,0xfe,0x00,0x00]

v_fmamk_f16 v5, s105, 0xfe0b, v3
// GFX11: encoding: [0x69,0x06,0x0a,0x6e,0x0b,0xfe,0x00,0x00]

v_fmamk_f16 v5, vcc_lo, 0xfe0b, v3
// GFX11: encoding: [0x6a,0x06,0x0a,0x6e,0x0b,0xfe,0x00,0x00]

v_fmamk_f16 v5, vcc_hi, 0xfe0b, v3
// GFX11: encoding: [0x6b,0x06,0x0a,0x6e,0x0b,0xfe,0x00,0x00]

v_fmamk_f16 v5, ttmp15, 0xfe0b, v3
// GFX11: encoding: [0x7b,0x06,0x0a,0x6e,0x0b,0xfe,0x00,0x00]

v_fmamk_f16 v5, m0, 0xfe0b, v3
// GFX11: encoding: [0x7d,0x06,0x0a,0x6e,0x0b,0xfe,0x00,0x00]

v_fmamk_f16 v5, exec_lo, 0xfe0b, v3
// GFX11: encoding: [0x7e,0x06,0x0a,0x6e,0x0b,0xfe,0x00,0x00]

v_fmamk_f16 v5, exec_hi, 0xfe0b, v3
// GFX11: encoding: [0x7f,0x06,0x0a,0x6e,0x0b,0xfe,0x00,0x00]

v_fmamk_f16 v5, null, 0xfe0b, v3
// GFX11: encoding: [0x7c,0x06,0x0a,0x6e,0x0b,0xfe,0x00,0x00]

v_fmamk_f16 v5, -1, 0xfe0b, v3
// GFX11: encoding: [0xc1,0x06,0x0a,0x6e,0x0b,0xfe,0x00,0x00]

v_fmamk_f16 v5, 0.5, 0xfe0b, v3
// GFX11: encoding: [0xf0,0x06,0x0a,0x6e,0x0b,0xfe,0x00,0x00]

v_fmamk_f16 v5, src_scc, 0xfe0b, v3
// GFX11: encoding: [0xfd,0x06,0x0a,0x6e,0x0b,0xfe,0x00,0x00]

v_fmamk_f16 v127, 0xfe0b, 0xfe0b, v127
// GFX11: encoding: [0xff,0xfe,0xfe,0x6e,0x0b,0xfe,0x00,0x00]

v_fmamk_f32 v5, v1, 0xaf123456, v3
// GFX11: encoding: [0x01,0x07,0x0a,0x58,0x56,0x34,0x12,0xaf]

v_fmamk_f32 v5, v255, 0xaf123456, v3
// GFX11: encoding: [0xff,0x07,0x0a,0x58,0x56,0x34,0x12,0xaf]

v_fmamk_f32 v5, s1, 0xaf123456, v3
// GFX11: encoding: [0x01,0x06,0x0a,0x58,0x56,0x34,0x12,0xaf]

v_fmamk_f32 v5, s105, 0xaf123456, v3
// GFX11: encoding: [0x69,0x06,0x0a,0x58,0x56,0x34,0x12,0xaf]

v_fmamk_f32 v5, vcc_lo, 0xaf123456, v3
// GFX11: encoding: [0x6a,0x06,0x0a,0x58,0x56,0x34,0x12,0xaf]

v_fmamk_f32 v5, vcc_hi, 0xaf123456, v3
// GFX11: encoding: [0x6b,0x06,0x0a,0x58,0x56,0x34,0x12,0xaf]

v_fmamk_f32 v5, ttmp15, 0xaf123456, v3
// GFX11: encoding: [0x7b,0x06,0x0a,0x58,0x56,0x34,0x12,0xaf]

v_fmamk_f32 v5, m0, 0xaf123456, v3
// GFX11: encoding: [0x7d,0x06,0x0a,0x58,0x56,0x34,0x12,0xaf]

v_fmamk_f32 v5, exec_lo, 0xaf123456, v3
// GFX11: encoding: [0x7e,0x06,0x0a,0x58,0x56,0x34,0x12,0xaf]

v_fmamk_f32 v5, exec_hi, 0xaf123456, v3
// GFX11: encoding: [0x7f,0x06,0x0a,0x58,0x56,0x34,0x12,0xaf]

v_fmamk_f32 v5, null, 0xaf123456, v3
// GFX11: encoding: [0x7c,0x06,0x0a,0x58,0x56,0x34,0x12,0xaf]

v_fmamk_f32 v5, -1, 0xaf123456, v3
// GFX11: encoding: [0xc1,0x06,0x0a,0x58,0x56,0x34,0x12,0xaf]

v_fmamk_f32 v5, 0.5, 0xaf123456, v3
// GFX11: encoding: [0xf0,0x06,0x0a,0x58,0x56,0x34,0x12,0xaf]

v_fmamk_f32 v5, src_scc, 0xaf123456, v3
// GFX11: encoding: [0xfd,0x06,0x0a,0x58,0x56,0x34,0x12,0xaf]

v_fmamk_f32 v255, 0xaf123456, 0xaf123456, v255
// GFX11: encoding: [0xff,0xfe,0xff,0x59,0x56,0x34,0x12,0xaf]

v_ldexp_f16 v5, v1, v2
// GFX11: encoding: [0x01,0x05,0x0a,0x76]

v_ldexp_f16 v5, v127, v2
// GFX11: encoding: [0x7f,0x05,0x0a,0x76]

v_ldexp_f16 v5, s1, v2
// GFX11: encoding: [0x01,0x04,0x0a,0x76]

v_ldexp_f16 v5, s105, v2
// GFX11: encoding: [0x69,0x04,0x0a,0x76]

v_ldexp_f16 v5, vcc_lo, v2
// GFX11: encoding: [0x6a,0x04,0x0a,0x76]

v_ldexp_f16 v5, vcc_hi, v2
// GFX11: encoding: [0x6b,0x04,0x0a,0x76]

v_ldexp_f16 v5, ttmp15, v2
// GFX11: encoding: [0x7b,0x04,0x0a,0x76]

v_ldexp_f16 v5, m0, v2
// GFX11: encoding: [0x7d,0x04,0x0a,0x76]

v_ldexp_f16 v5, exec_lo, v2
// GFX11: encoding: [0x7e,0x04,0x0a,0x76]

v_ldexp_f16 v5, exec_hi, v2
// GFX11: encoding: [0x7f,0x04,0x0a,0x76]

v_ldexp_f16 v5, null, v2
// GFX11: encoding: [0x7c,0x04,0x0a,0x76]

v_ldexp_f16 v5, -1, v2
// GFX11: encoding: [0xc1,0x04,0x0a,0x76]

v_ldexp_f16 v5, 0.5, v2
// GFX11: encoding: [0xf0,0x04,0x0a,0x76]

v_ldexp_f16 v5, src_scc, v2
// GFX11: encoding: [0xfd,0x04,0x0a,0x76]

v_ldexp_f16 v127, 0xfe0b, v127
// GFX11: encoding: [0xff,0xfe,0xfe,0x76,0x0b,0xfe,0x00,0x00]

v_lshlrev_b32 v5, v1, v2
// GFX11: encoding: [0x01,0x05,0x0a,0x30]

v_lshlrev_b32 v5, v255, v2
// GFX11: encoding: [0xff,0x05,0x0a,0x30]

v_lshlrev_b32 v5, s1, v2
// GFX11: encoding: [0x01,0x04,0x0a,0x30]

v_lshlrev_b32 v5, s105, v2
// GFX11: encoding: [0x69,0x04,0x0a,0x30]

v_lshlrev_b32 v5, vcc_lo, v2
// GFX11: encoding: [0x6a,0x04,0x0a,0x30]

v_lshlrev_b32 v5, vcc_hi, v2
// GFX11: encoding: [0x6b,0x04,0x0a,0x30]

v_lshlrev_b32 v5, ttmp15, v2
// GFX11: encoding: [0x7b,0x04,0x0a,0x30]

v_lshlrev_b32 v5, m0, v2
// GFX11: encoding: [0x7d,0x04,0x0a,0x30]

v_lshlrev_b32 v5, exec_lo, v2
// GFX11: encoding: [0x7e,0x04,0x0a,0x30]

v_lshlrev_b32 v5, exec_hi, v2
// GFX11: encoding: [0x7f,0x04,0x0a,0x30]

v_lshlrev_b32 v5, null, v2
// GFX11: encoding: [0x7c,0x04,0x0a,0x30]

v_lshlrev_b32 v5, -1, v2
// GFX11: encoding: [0xc1,0x04,0x0a,0x30]

v_lshlrev_b32 v5, 0.5, v2
// GFX11: encoding: [0xf0,0x04,0x0a,0x30]

v_lshlrev_b32 v5, src_scc, v2
// GFX11: encoding: [0xfd,0x04,0x0a,0x30]

v_lshlrev_b32 v255, 0xaf123456, v255
// GFX11: encoding: [0xff,0xfe,0xff,0x31,0x56,0x34,0x12,0xaf]

v_lshrrev_b32 v5, v1, v2
// GFX11: encoding: [0x01,0x05,0x0a,0x32]

v_lshrrev_b32 v5, v255, v2
// GFX11: encoding: [0xff,0x05,0x0a,0x32]

v_lshrrev_b32 v5, s1, v2
// GFX11: encoding: [0x01,0x04,0x0a,0x32]

v_lshrrev_b32 v5, s105, v2
// GFX11: encoding: [0x69,0x04,0x0a,0x32]

v_lshrrev_b32 v5, vcc_lo, v2
// GFX11: encoding: [0x6a,0x04,0x0a,0x32]

v_lshrrev_b32 v5, vcc_hi, v2
// GFX11: encoding: [0x6b,0x04,0x0a,0x32]

v_lshrrev_b32 v5, ttmp15, v2
// GFX11: encoding: [0x7b,0x04,0x0a,0x32]

v_lshrrev_b32 v5, m0, v2
// GFX11: encoding: [0x7d,0x04,0x0a,0x32]

v_lshrrev_b32 v5, exec_lo, v2
// GFX11: encoding: [0x7e,0x04,0x0a,0x32]

v_lshrrev_b32 v5, exec_hi, v2
// GFX11: encoding: [0x7f,0x04,0x0a,0x32]

v_lshrrev_b32 v5, null, v2
// GFX11: encoding: [0x7c,0x04,0x0a,0x32]

v_lshrrev_b32 v5, -1, v2
// GFX11: encoding: [0xc1,0x04,0x0a,0x32]

v_lshrrev_b32 v5, 0.5, v2
// GFX11: encoding: [0xf0,0x04,0x0a,0x32]

v_lshrrev_b32 v5, src_scc, v2
// GFX11: encoding: [0xfd,0x04,0x0a,0x32]

v_lshrrev_b32 v255, 0xaf123456, v255
// GFX11: encoding: [0xff,0xfe,0xff,0x33,0x56,0x34,0x12,0xaf]

v_max_f16 v5, v1, v2
// GFX11: encoding: [0x01,0x05,0x0a,0x72]

v_max_f16 v5, v127, v2
// GFX11: encoding: [0x7f,0x05,0x0a,0x72]

v_max_f16 v5, s1, v2
// GFX11: encoding: [0x01,0x04,0x0a,0x72]

v_max_f16 v5, s105, v2
// GFX11: encoding: [0x69,0x04,0x0a,0x72]

v_max_f16 v5, vcc_lo, v2
// GFX11: encoding: [0x6a,0x04,0x0a,0x72]

v_max_f16 v5, vcc_hi, v2
// GFX11: encoding: [0x6b,0x04,0x0a,0x72]

v_max_f16 v5, ttmp15, v2
// GFX11: encoding: [0x7b,0x04,0x0a,0x72]

v_max_f16 v5, m0, v2
// GFX11: encoding: [0x7d,0x04,0x0a,0x72]

v_max_f16 v5, exec_lo, v2
// GFX11: encoding: [0x7e,0x04,0x0a,0x72]

v_max_f16 v5, exec_hi, v2
// GFX11: encoding: [0x7f,0x04,0x0a,0x72]

v_max_f16 v5, null, v2
// GFX11: encoding: [0x7c,0x04,0x0a,0x72]

v_max_f16 v5, -1, v2
// GFX11: encoding: [0xc1,0x04,0x0a,0x72]

v_max_f16 v5, 0.5, v2
// GFX11: encoding: [0xf0,0x04,0x0a,0x72]

v_max_f16 v5, src_scc, v2
// GFX11: encoding: [0xfd,0x04,0x0a,0x72]

v_max_f16 v127, 0xfe0b, v127
// GFX11: encoding: [0xff,0xfe,0xfe,0x72,0x0b,0xfe,0x00,0x00]

v_max_f32 v5, v1, v2
// GFX11: encoding: [0x01,0x05,0x0a,0x20]

v_max_f32 v5, v255, v2
// GFX11: encoding: [0xff,0x05,0x0a,0x20]

v_max_f32 v5, s1, v2
// GFX11: encoding: [0x01,0x04,0x0a,0x20]

v_max_f32 v5, s105, v2
// GFX11: encoding: [0x69,0x04,0x0a,0x20]

v_max_f32 v5, vcc_lo, v2
// GFX11: encoding: [0x6a,0x04,0x0a,0x20]

v_max_f32 v5, vcc_hi, v2
// GFX11: encoding: [0x6b,0x04,0x0a,0x20]

v_max_f32 v5, ttmp15, v2
// GFX11: encoding: [0x7b,0x04,0x0a,0x20]

v_max_f32 v5, m0, v2
// GFX11: encoding: [0x7d,0x04,0x0a,0x20]

v_max_f32 v5, exec_lo, v2
// GFX11: encoding: [0x7e,0x04,0x0a,0x20]

v_max_f32 v5, exec_hi, v2
// GFX11: encoding: [0x7f,0x04,0x0a,0x20]

v_max_f32 v5, null, v2
// GFX11: encoding: [0x7c,0x04,0x0a,0x20]

v_max_f32 v5, -1, v2
// GFX11: encoding: [0xc1,0x04,0x0a,0x20]

v_max_f32 v5, 0.5, v2
// GFX11: encoding: [0xf0,0x04,0x0a,0x20]

v_max_f32 v5, src_scc, v2
// GFX11: encoding: [0xfd,0x04,0x0a,0x20]

v_max_f32 v255, 0xaf123456, v255
// GFX11: encoding: [0xff,0xfe,0xff,0x21,0x56,0x34,0x12,0xaf]

v_max_i32 v5, v1, v2
// GFX11: encoding: [0x01,0x05,0x0a,0x24]

v_max_i32 v5, v255, v2
// GFX11: encoding: [0xff,0x05,0x0a,0x24]

v_max_i32 v5, s1, v2
// GFX11: encoding: [0x01,0x04,0x0a,0x24]

v_max_i32 v5, s105, v2
// GFX11: encoding: [0x69,0x04,0x0a,0x24]

v_max_i32 v5, vcc_lo, v2
// GFX11: encoding: [0x6a,0x04,0x0a,0x24]

v_max_i32 v5, vcc_hi, v2
// GFX11: encoding: [0x6b,0x04,0x0a,0x24]

v_max_i32 v5, ttmp15, v2
// GFX11: encoding: [0x7b,0x04,0x0a,0x24]

v_max_i32 v5, m0, v2
// GFX11: encoding: [0x7d,0x04,0x0a,0x24]

v_max_i32 v5, exec_lo, v2
// GFX11: encoding: [0x7e,0x04,0x0a,0x24]

v_max_i32 v5, exec_hi, v2
// GFX11: encoding: [0x7f,0x04,0x0a,0x24]

v_max_i32 v5, null, v2
// GFX11: encoding: [0x7c,0x04,0x0a,0x24]

v_max_i32 v5, -1, v2
// GFX11: encoding: [0xc1,0x04,0x0a,0x24]

v_max_i32 v5, 0.5, v2
// GFX11: encoding: [0xf0,0x04,0x0a,0x24]

v_max_i32 v5, src_scc, v2
// GFX11: encoding: [0xfd,0x04,0x0a,0x24]

v_max_i32 v255, 0xaf123456, v255
// GFX11: encoding: [0xff,0xfe,0xff,0x25,0x56,0x34,0x12,0xaf]

v_max_u32 v5, v1, v2
// GFX11: encoding: [0x01,0x05,0x0a,0x28]

v_max_u32 v5, v255, v2
// GFX11: encoding: [0xff,0x05,0x0a,0x28]

v_max_u32 v5, s1, v2
// GFX11: encoding: [0x01,0x04,0x0a,0x28]

v_max_u32 v5, s105, v2
// GFX11: encoding: [0x69,0x04,0x0a,0x28]

v_max_u32 v5, vcc_lo, v2
// GFX11: encoding: [0x6a,0x04,0x0a,0x28]

v_max_u32 v5, vcc_hi, v2
// GFX11: encoding: [0x6b,0x04,0x0a,0x28]

v_max_u32 v5, ttmp15, v2
// GFX11: encoding: [0x7b,0x04,0x0a,0x28]

v_max_u32 v5, m0, v2
// GFX11: encoding: [0x7d,0x04,0x0a,0x28]

v_max_u32 v5, exec_lo, v2
// GFX11: encoding: [0x7e,0x04,0x0a,0x28]

v_max_u32 v5, exec_hi, v2
// GFX11: encoding: [0x7f,0x04,0x0a,0x28]

v_max_u32 v5, null, v2
// GFX11: encoding: [0x7c,0x04,0x0a,0x28]

v_max_u32 v5, -1, v2
// GFX11: encoding: [0xc1,0x04,0x0a,0x28]

v_max_u32 v5, 0.5, v2
// GFX11: encoding: [0xf0,0x04,0x0a,0x28]

v_max_u32 v5, src_scc, v2
// GFX11: encoding: [0xfd,0x04,0x0a,0x28]

v_max_u32 v255, 0xaf123456, v255
// GFX11: encoding: [0xff,0xfe,0xff,0x29,0x56,0x34,0x12,0xaf]

v_min_f16 v5, v1, v2
// GFX11: encoding: [0x01,0x05,0x0a,0x74]

v_min_f16 v5, v127, v2
// GFX11: encoding: [0x7f,0x05,0x0a,0x74]

v_min_f16 v5, s1, v2
// GFX11: encoding: [0x01,0x04,0x0a,0x74]

v_min_f16 v5, s105, v2
// GFX11: encoding: [0x69,0x04,0x0a,0x74]

v_min_f16 v5, vcc_lo, v2
// GFX11: encoding: [0x6a,0x04,0x0a,0x74]

v_min_f16 v5, vcc_hi, v2
// GFX11: encoding: [0x6b,0x04,0x0a,0x74]

v_min_f16 v5, ttmp15, v2
// GFX11: encoding: [0x7b,0x04,0x0a,0x74]

v_min_f16 v5, m0, v2
// GFX11: encoding: [0x7d,0x04,0x0a,0x74]

v_min_f16 v5, exec_lo, v2
// GFX11: encoding: [0x7e,0x04,0x0a,0x74]

v_min_f16 v5, exec_hi, v2
// GFX11: encoding: [0x7f,0x04,0x0a,0x74]

v_min_f16 v5, null, v2
// GFX11: encoding: [0x7c,0x04,0x0a,0x74]

v_min_f16 v5, -1, v2
// GFX11: encoding: [0xc1,0x04,0x0a,0x74]

v_min_f16 v5, 0.5, v2
// GFX11: encoding: [0xf0,0x04,0x0a,0x74]

v_min_f16 v5, src_scc, v2
// GFX11: encoding: [0xfd,0x04,0x0a,0x74]

v_min_f16 v127, 0xfe0b, v127
// GFX11: encoding: [0xff,0xfe,0xfe,0x74,0x0b,0xfe,0x00,0x00]

v_min_f32 v5, v1, v2
// GFX11: encoding: [0x01,0x05,0x0a,0x1e]

v_min_f32 v5, v255, v2
// GFX11: encoding: [0xff,0x05,0x0a,0x1e]

v_min_f32 v5, s1, v2
// GFX11: encoding: [0x01,0x04,0x0a,0x1e]

v_min_f32 v5, s105, v2
// GFX11: encoding: [0x69,0x04,0x0a,0x1e]

v_min_f32 v5, vcc_lo, v2
// GFX11: encoding: [0x6a,0x04,0x0a,0x1e]

v_min_f32 v5, vcc_hi, v2
// GFX11: encoding: [0x6b,0x04,0x0a,0x1e]

v_min_f32 v5, ttmp15, v2
// GFX11: encoding: [0x7b,0x04,0x0a,0x1e]

v_min_f32 v5, m0, v2
// GFX11: encoding: [0x7d,0x04,0x0a,0x1e]

v_min_f32 v5, exec_lo, v2
// GFX11: encoding: [0x7e,0x04,0x0a,0x1e]

v_min_f32 v5, exec_hi, v2
// GFX11: encoding: [0x7f,0x04,0x0a,0x1e]

v_min_f32 v5, null, v2
// GFX11: encoding: [0x7c,0x04,0x0a,0x1e]

v_min_f32 v5, -1, v2
// GFX11: encoding: [0xc1,0x04,0x0a,0x1e]

v_min_f32 v5, 0.5, v2
// GFX11: encoding: [0xf0,0x04,0x0a,0x1e]

v_min_f32 v5, src_scc, v2
// GFX11: encoding: [0xfd,0x04,0x0a,0x1e]

v_min_f32 v255, 0xaf123456, v255
// GFX11: encoding: [0xff,0xfe,0xff,0x1f,0x56,0x34,0x12,0xaf]

v_min_i32 v5, v1, v2
// GFX11: encoding: [0x01,0x05,0x0a,0x22]

v_min_i32 v5, v255, v2
// GFX11: encoding: [0xff,0x05,0x0a,0x22]

v_min_i32 v5, s1, v2
// GFX11: encoding: [0x01,0x04,0x0a,0x22]

v_min_i32 v5, s105, v2
// GFX11: encoding: [0x69,0x04,0x0a,0x22]

v_min_i32 v5, vcc_lo, v2
// GFX11: encoding: [0x6a,0x04,0x0a,0x22]

v_min_i32 v5, vcc_hi, v2
// GFX11: encoding: [0x6b,0x04,0x0a,0x22]

v_min_i32 v5, ttmp15, v2
// GFX11: encoding: [0x7b,0x04,0x0a,0x22]

v_min_i32 v5, m0, v2
// GFX11: encoding: [0x7d,0x04,0x0a,0x22]

v_min_i32 v5, exec_lo, v2
// GFX11: encoding: [0x7e,0x04,0x0a,0x22]

v_min_i32 v5, exec_hi, v2
// GFX11: encoding: [0x7f,0x04,0x0a,0x22]

v_min_i32 v5, null, v2
// GFX11: encoding: [0x7c,0x04,0x0a,0x22]

v_min_i32 v5, -1, v2
// GFX11: encoding: [0xc1,0x04,0x0a,0x22]

v_min_i32 v5, 0.5, v2
// GFX11: encoding: [0xf0,0x04,0x0a,0x22]

v_min_i32 v5, src_scc, v2
// GFX11: encoding: [0xfd,0x04,0x0a,0x22]

v_min_i32 v255, 0xaf123456, v255
// GFX11: encoding: [0xff,0xfe,0xff,0x23,0x56,0x34,0x12,0xaf]

v_min_u32 v5, v1, v2
// GFX11: encoding: [0x01,0x05,0x0a,0x26]

v_min_u32 v5, v255, v2
// GFX11: encoding: [0xff,0x05,0x0a,0x26]

v_min_u32 v5, s1, v2
// GFX11: encoding: [0x01,0x04,0x0a,0x26]

v_min_u32 v5, s105, v2
// GFX11: encoding: [0x69,0x04,0x0a,0x26]

v_min_u32 v5, vcc_lo, v2
// GFX11: encoding: [0x6a,0x04,0x0a,0x26]

v_min_u32 v5, vcc_hi, v2
// GFX11: encoding: [0x6b,0x04,0x0a,0x26]

v_min_u32 v5, ttmp15, v2
// GFX11: encoding: [0x7b,0x04,0x0a,0x26]

v_min_u32 v5, m0, v2
// GFX11: encoding: [0x7d,0x04,0x0a,0x26]

v_min_u32 v5, exec_lo, v2
// GFX11: encoding: [0x7e,0x04,0x0a,0x26]

v_min_u32 v5, exec_hi, v2
// GFX11: encoding: [0x7f,0x04,0x0a,0x26]

v_min_u32 v5, null, v2
// GFX11: encoding: [0x7c,0x04,0x0a,0x26]

v_min_u32 v5, -1, v2
// GFX11: encoding: [0xc1,0x04,0x0a,0x26]

v_min_u32 v5, 0.5, v2
// GFX11: encoding: [0xf0,0x04,0x0a,0x26]

v_min_u32 v5, src_scc, v2
// GFX11: encoding: [0xfd,0x04,0x0a,0x26]

v_min_u32 v255, 0xaf123456, v255
// GFX11: encoding: [0xff,0xfe,0xff,0x27,0x56,0x34,0x12,0xaf]

v_mul_dx9_zero_f32 v5, v1, v2
// GFX11: encoding: [0x01,0x05,0x0a,0x0e]

v_mul_dx9_zero_f32 v5, v255, v2
// GFX11: encoding: [0xff,0x05,0x0a,0x0e]

v_mul_dx9_zero_f32 v5, s1, v2
// GFX11: encoding: [0x01,0x04,0x0a,0x0e]

v_mul_dx9_zero_f32 v5, s105, v2
// GFX11: encoding: [0x69,0x04,0x0a,0x0e]

v_mul_dx9_zero_f32 v5, vcc_lo, v2
// GFX11: encoding: [0x6a,0x04,0x0a,0x0e]

v_mul_dx9_zero_f32 v5, vcc_hi, v2
// GFX11: encoding: [0x6b,0x04,0x0a,0x0e]

v_mul_dx9_zero_f32 v5, ttmp15, v2
// GFX11: encoding: [0x7b,0x04,0x0a,0x0e]

v_mul_dx9_zero_f32 v5, m0, v2
// GFX11: encoding: [0x7d,0x04,0x0a,0x0e]

v_mul_dx9_zero_f32 v5, exec_lo, v2
// GFX11: encoding: [0x7e,0x04,0x0a,0x0e]

v_mul_dx9_zero_f32 v5, exec_hi, v2
// GFX11: encoding: [0x7f,0x04,0x0a,0x0e]

v_mul_dx9_zero_f32 v5, null, v2
// GFX11: encoding: [0x7c,0x04,0x0a,0x0e]

v_mul_dx9_zero_f32 v5, -1, v2
// GFX11: encoding: [0xc1,0x04,0x0a,0x0e]

v_mul_dx9_zero_f32 v5, 0.5, v2
// GFX11: encoding: [0xf0,0x04,0x0a,0x0e]

v_mul_dx9_zero_f32 v5, src_scc, v2
// GFX11: encoding: [0xfd,0x04,0x0a,0x0e]

v_mul_dx9_zero_f32 v255, 0xaf123456, v255
// GFX11: encoding: [0xff,0xfe,0xff,0x0f,0x56,0x34,0x12,0xaf]

v_mul_f16 v5, v1, v2
// GFX11: encoding: [0x01,0x05,0x0a,0x6a]

v_mul_f16 v5, v127, v2
// GFX11: encoding: [0x7f,0x05,0x0a,0x6a]

v_mul_f16 v5, s1, v2
// GFX11: encoding: [0x01,0x04,0x0a,0x6a]

v_mul_f16 v5, s105, v2
// GFX11: encoding: [0x69,0x04,0x0a,0x6a]

v_mul_f16 v5, vcc_lo, v2
// GFX11: encoding: [0x6a,0x04,0x0a,0x6a]

v_mul_f16 v5, vcc_hi, v2
// GFX11: encoding: [0x6b,0x04,0x0a,0x6a]

v_mul_f16 v5, ttmp15, v2
// GFX11: encoding: [0x7b,0x04,0x0a,0x6a]

v_mul_f16 v5, m0, v2
// GFX11: encoding: [0x7d,0x04,0x0a,0x6a]

v_mul_f16 v5, exec_lo, v2
// GFX11: encoding: [0x7e,0x04,0x0a,0x6a]

v_mul_f16 v5, exec_hi, v2
// GFX11: encoding: [0x7f,0x04,0x0a,0x6a]

v_mul_f16 v5, null, v2
// GFX11: encoding: [0x7c,0x04,0x0a,0x6a]

v_mul_f16 v5, -1, v2
// GFX11: encoding: [0xc1,0x04,0x0a,0x6a]

v_mul_f16 v5, 0.5, v2
// GFX11: encoding: [0xf0,0x04,0x0a,0x6a]

v_mul_f16 v5, src_scc, v2
// GFX11: encoding: [0xfd,0x04,0x0a,0x6a]

v_mul_f16 v127, 0xfe0b, v127
// GFX11: encoding: [0xff,0xfe,0xfe,0x6a,0x0b,0xfe,0x00,0x00]

v_mul_f32 v5, v1, v2
// GFX11: encoding: [0x01,0x05,0x0a,0x10]

v_mul_f32 v5, v255, v2
// GFX11: encoding: [0xff,0x05,0x0a,0x10]

v_mul_f32 v5, s1, v2
// GFX11: encoding: [0x01,0x04,0x0a,0x10]

v_mul_f32 v5, s105, v2
// GFX11: encoding: [0x69,0x04,0x0a,0x10]

v_mul_f32 v5, vcc_lo, v2
// GFX11: encoding: [0x6a,0x04,0x0a,0x10]

v_mul_f32 v5, vcc_hi, v2
// GFX11: encoding: [0x6b,0x04,0x0a,0x10]

v_mul_f32 v5, ttmp15, v2
// GFX11: encoding: [0x7b,0x04,0x0a,0x10]

v_mul_f32 v5, m0, v2
// GFX11: encoding: [0x7d,0x04,0x0a,0x10]

v_mul_f32 v5, exec_lo, v2
// GFX11: encoding: [0x7e,0x04,0x0a,0x10]

v_mul_f32 v5, exec_hi, v2
// GFX11: encoding: [0x7f,0x04,0x0a,0x10]

v_mul_f32 v5, null, v2
// GFX11: encoding: [0x7c,0x04,0x0a,0x10]

v_mul_f32 v5, -1, v2
// GFX11: encoding: [0xc1,0x04,0x0a,0x10]

v_mul_f32 v5, 0.5, v2
// GFX11: encoding: [0xf0,0x04,0x0a,0x10]

v_mul_f32 v5, src_scc, v2
// GFX11: encoding: [0xfd,0x04,0x0a,0x10]

v_mul_f32 v255, 0xaf123456, v255
// GFX11: encoding: [0xff,0xfe,0xff,0x11,0x56,0x34,0x12,0xaf]

v_mul_hi_i32_i24 v5, v1, v2
// GFX11: encoding: [0x01,0x05,0x0a,0x14]

v_mul_hi_i32_i24 v5, v255, v2
// GFX11: encoding: [0xff,0x05,0x0a,0x14]

v_mul_hi_i32_i24 v5, s1, v2
// GFX11: encoding: [0x01,0x04,0x0a,0x14]

v_mul_hi_i32_i24 v5, s105, v2
// GFX11: encoding: [0x69,0x04,0x0a,0x14]

v_mul_hi_i32_i24 v5, vcc_lo, v2
// GFX11: encoding: [0x6a,0x04,0x0a,0x14]

v_mul_hi_i32_i24 v5, vcc_hi, v2
// GFX11: encoding: [0x6b,0x04,0x0a,0x14]

v_mul_hi_i32_i24 v5, ttmp15, v2
// GFX11: encoding: [0x7b,0x04,0x0a,0x14]

v_mul_hi_i32_i24 v5, m0, v2
// GFX11: encoding: [0x7d,0x04,0x0a,0x14]

v_mul_hi_i32_i24 v5, exec_lo, v2
// GFX11: encoding: [0x7e,0x04,0x0a,0x14]

v_mul_hi_i32_i24 v5, exec_hi, v2
// GFX11: encoding: [0x7f,0x04,0x0a,0x14]

v_mul_hi_i32_i24 v5, null, v2
// GFX11: encoding: [0x7c,0x04,0x0a,0x14]

v_mul_hi_i32_i24 v5, -1, v2
// GFX11: encoding: [0xc1,0x04,0x0a,0x14]

v_mul_hi_i32_i24 v5, 0.5, v2
// GFX11: encoding: [0xf0,0x04,0x0a,0x14]

v_mul_hi_i32_i24 v5, src_scc, v2
// GFX11: encoding: [0xfd,0x04,0x0a,0x14]

v_mul_hi_i32_i24 v255, 0xaf123456, v255
// GFX11: encoding: [0xff,0xfe,0xff,0x15,0x56,0x34,0x12,0xaf]

v_mul_hi_u32_u24 v5, v1, v2
// GFX11: encoding: [0x01,0x05,0x0a,0x18]

v_mul_hi_u32_u24 v5, v255, v2
// GFX11: encoding: [0xff,0x05,0x0a,0x18]

v_mul_hi_u32_u24 v5, s1, v2
// GFX11: encoding: [0x01,0x04,0x0a,0x18]

v_mul_hi_u32_u24 v5, s105, v2
// GFX11: encoding: [0x69,0x04,0x0a,0x18]

v_mul_hi_u32_u24 v5, vcc_lo, v2
// GFX11: encoding: [0x6a,0x04,0x0a,0x18]

v_mul_hi_u32_u24 v5, vcc_hi, v2
// GFX11: encoding: [0x6b,0x04,0x0a,0x18]

v_mul_hi_u32_u24 v5, ttmp15, v2
// GFX11: encoding: [0x7b,0x04,0x0a,0x18]

v_mul_hi_u32_u24 v5, m0, v2
// GFX11: encoding: [0x7d,0x04,0x0a,0x18]

v_mul_hi_u32_u24 v5, exec_lo, v2
// GFX11: encoding: [0x7e,0x04,0x0a,0x18]

v_mul_hi_u32_u24 v5, exec_hi, v2
// GFX11: encoding: [0x7f,0x04,0x0a,0x18]

v_mul_hi_u32_u24 v5, null, v2
// GFX11: encoding: [0x7c,0x04,0x0a,0x18]

v_mul_hi_u32_u24 v5, -1, v2
// GFX11: encoding: [0xc1,0x04,0x0a,0x18]

v_mul_hi_u32_u24 v5, 0.5, v2
// GFX11: encoding: [0xf0,0x04,0x0a,0x18]

v_mul_hi_u32_u24 v5, src_scc, v2
// GFX11: encoding: [0xfd,0x04,0x0a,0x18]

v_mul_hi_u32_u24 v255, 0xaf123456, v255
// GFX11: encoding: [0xff,0xfe,0xff,0x19,0x56,0x34,0x12,0xaf]

v_mul_i32_i24 v5, v1, v2
// GFX11: encoding: [0x01,0x05,0x0a,0x12]

v_mul_i32_i24 v5, v255, v2
// GFX11: encoding: [0xff,0x05,0x0a,0x12]

v_mul_i32_i24 v5, s1, v2
// GFX11: encoding: [0x01,0x04,0x0a,0x12]

v_mul_i32_i24 v5, s105, v2
// GFX11: encoding: [0x69,0x04,0x0a,0x12]

v_mul_i32_i24 v5, vcc_lo, v2
// GFX11: encoding: [0x6a,0x04,0x0a,0x12]

v_mul_i32_i24 v5, vcc_hi, v2
// GFX11: encoding: [0x6b,0x04,0x0a,0x12]

v_mul_i32_i24 v5, ttmp15, v2
// GFX11: encoding: [0x7b,0x04,0x0a,0x12]

v_mul_i32_i24 v5, m0, v2
// GFX11: encoding: [0x7d,0x04,0x0a,0x12]

v_mul_i32_i24 v5, exec_lo, v2
// GFX11: encoding: [0x7e,0x04,0x0a,0x12]

v_mul_i32_i24 v5, exec_hi, v2
// GFX11: encoding: [0x7f,0x04,0x0a,0x12]

v_mul_i32_i24 v5, null, v2
// GFX11: encoding: [0x7c,0x04,0x0a,0x12]

v_mul_i32_i24 v5, -1, v2
// GFX11: encoding: [0xc1,0x04,0x0a,0x12]

v_mul_i32_i24 v5, 0.5, v2
// GFX11: encoding: [0xf0,0x04,0x0a,0x12]

v_mul_i32_i24 v5, src_scc, v2
// GFX11: encoding: [0xfd,0x04,0x0a,0x12]

v_mul_i32_i24 v255, 0xaf123456, v255
// GFX11: encoding: [0xff,0xfe,0xff,0x13,0x56,0x34,0x12,0xaf]

v_mul_legacy_f32 v5, v1, v2
// GFX11: encoding: [0x01,0x05,0x0a,0x0e]

v_mul_legacy_f32 v5, v255, v2
// GFX11: encoding: [0xff,0x05,0x0a,0x0e]

v_mul_legacy_f32 v5, s1, v2
// GFX11: encoding: [0x01,0x04,0x0a,0x0e]

v_mul_legacy_f32 v5, s105, v2
// GFX11: encoding: [0x69,0x04,0x0a,0x0e]

v_mul_legacy_f32 v5, vcc_lo, v2
// GFX11: encoding: [0x6a,0x04,0x0a,0x0e]

v_mul_legacy_f32 v5, vcc_hi, v2
// GFX11: encoding: [0x6b,0x04,0x0a,0x0e]

v_mul_legacy_f32 v5, ttmp15, v2
// GFX11: encoding: [0x7b,0x04,0x0a,0x0e]

v_mul_legacy_f32 v5, m0, v2
// GFX11: encoding: [0x7d,0x04,0x0a,0x0e]

v_mul_legacy_f32 v5, exec_lo, v2
// GFX11: encoding: [0x7e,0x04,0x0a,0x0e]

v_mul_legacy_f32 v5, exec_hi, v2
// GFX11: encoding: [0x7f,0x04,0x0a,0x0e]

v_mul_legacy_f32 v5, null, v2
// GFX11: encoding: [0x7c,0x04,0x0a,0x0e]

v_mul_legacy_f32 v5, -1, v2
// GFX11: encoding: [0xc1,0x04,0x0a,0x0e]

v_mul_legacy_f32 v5, 0.5, v2
// GFX11: encoding: [0xf0,0x04,0x0a,0x0e]

v_mul_legacy_f32 v5, src_scc, v2
// GFX11: encoding: [0xfd,0x04,0x0a,0x0e]

v_mul_legacy_f32 v255, 0xaf123456, v255
// GFX11: encoding: [0xff,0xfe,0xff,0x0f,0x56,0x34,0x12,0xaf]

v_mul_u32_u24 v5, v1, v2
// GFX11: encoding: [0x01,0x05,0x0a,0x16]

v_mul_u32_u24 v5, v255, v2
// GFX11: encoding: [0xff,0x05,0x0a,0x16]

v_mul_u32_u24 v5, s1, v2
// GFX11: encoding: [0x01,0x04,0x0a,0x16]

v_mul_u32_u24 v5, s105, v2
// GFX11: encoding: [0x69,0x04,0x0a,0x16]

v_mul_u32_u24 v5, vcc_lo, v2
// GFX11: encoding: [0x6a,0x04,0x0a,0x16]

v_mul_u32_u24 v5, vcc_hi, v2
// GFX11: encoding: [0x6b,0x04,0x0a,0x16]

v_mul_u32_u24 v5, ttmp15, v2
// GFX11: encoding: [0x7b,0x04,0x0a,0x16]

v_mul_u32_u24 v5, m0, v2
// GFX11: encoding: [0x7d,0x04,0x0a,0x16]

v_mul_u32_u24 v5, exec_lo, v2
// GFX11: encoding: [0x7e,0x04,0x0a,0x16]

v_mul_u32_u24 v5, exec_hi, v2
// GFX11: encoding: [0x7f,0x04,0x0a,0x16]

v_mul_u32_u24 v5, null, v2
// GFX11: encoding: [0x7c,0x04,0x0a,0x16]

v_mul_u32_u24 v5, -1, v2
// GFX11: encoding: [0xc1,0x04,0x0a,0x16]

v_mul_u32_u24 v5, 0.5, v2
// GFX11: encoding: [0xf0,0x04,0x0a,0x16]

v_mul_u32_u24 v5, src_scc, v2
// GFX11: encoding: [0xfd,0x04,0x0a,0x16]

v_mul_u32_u24 v255, 0xaf123456, v255
// GFX11: encoding: [0xff,0xfe,0xff,0x17,0x56,0x34,0x12,0xaf]

v_or_b32 v5, v1, v2
// GFX11: encoding: [0x01,0x05,0x0a,0x38]

v_or_b32 v5, v255, v2
// GFX11: encoding: [0xff,0x05,0x0a,0x38]

v_or_b32 v5, s1, v2
// GFX11: encoding: [0x01,0x04,0x0a,0x38]

v_or_b32 v5, s105, v2
// GFX11: encoding: [0x69,0x04,0x0a,0x38]

v_or_b32 v5, vcc_lo, v2
// GFX11: encoding: [0x6a,0x04,0x0a,0x38]

v_or_b32 v5, vcc_hi, v2
// GFX11: encoding: [0x6b,0x04,0x0a,0x38]

v_or_b32 v5, ttmp15, v2
// GFX11: encoding: [0x7b,0x04,0x0a,0x38]

v_or_b32 v5, m0, v2
// GFX11: encoding: [0x7d,0x04,0x0a,0x38]

v_or_b32 v5, exec_lo, v2
// GFX11: encoding: [0x7e,0x04,0x0a,0x38]

v_or_b32 v5, exec_hi, v2
// GFX11: encoding: [0x7f,0x04,0x0a,0x38]

v_or_b32 v5, null, v2
// GFX11: encoding: [0x7c,0x04,0x0a,0x38]

v_or_b32 v5, -1, v2
// GFX11: encoding: [0xc1,0x04,0x0a,0x38]

v_or_b32 v5, 0.5, v2
// GFX11: encoding: [0xf0,0x04,0x0a,0x38]

v_or_b32 v5, src_scc, v2
// GFX11: encoding: [0xfd,0x04,0x0a,0x38]

v_or_b32 v255, 0xaf123456, v255
// GFX11: encoding: [0xff,0xfe,0xff,0x39,0x56,0x34,0x12,0xaf]

v_pk_fmac_f16 v5, v1, v2
// GFX11: encoding: [0x01,0x05,0x0a,0x78]

v_pk_fmac_f16 v5, v255, v2
// GFX11: encoding: [0xff,0x05,0x0a,0x78]

v_pk_fmac_f16 v5, s1, v2
// GFX11: encoding: [0x01,0x04,0x0a,0x78]

v_pk_fmac_f16 v5, s105, v2
// GFX11: encoding: [0x69,0x04,0x0a,0x78]

v_pk_fmac_f16 v5, vcc_lo, v2
// GFX11: encoding: [0x6a,0x04,0x0a,0x78]

v_pk_fmac_f16 v5, vcc_hi, v2
// GFX11: encoding: [0x6b,0x04,0x0a,0x78]

v_pk_fmac_f16 v5, ttmp15, v2
// GFX11: encoding: [0x7b,0x04,0x0a,0x78]

v_pk_fmac_f16 v5, m0, v2
// GFX11: encoding: [0x7d,0x04,0x0a,0x78]

v_pk_fmac_f16 v5, exec_lo, v2
// GFX11: encoding: [0x7e,0x04,0x0a,0x78]

v_pk_fmac_f16 v5, exec_hi, v2
// GFX11: encoding: [0x7f,0x04,0x0a,0x78]

v_pk_fmac_f16 v5, null, v2
// GFX11: encoding: [0x7c,0x04,0x0a,0x78]

v_pk_fmac_f16 v5, -1, v2
// GFX11: encoding: [0xc1,0x04,0x0a,0x78]

v_pk_fmac_f16 v5, 0.5, v2
// GFX11: encoding: [0xf0,0x04,0x0a,0x78]

v_pk_fmac_f16 v5, src_scc, v2
// GFX11: encoding: [0xfd,0x04,0x0a,0x78]

v_pk_fmac_f16 v255, 0xfe0b, v255
// GFX11: encoding: [0xff,0xfe,0xff,0x79,0x0b,0xfe,0x00,0x00]

v_sub_co_ci_u32 v5, vcc_lo, v1, v2, vcc_lo
// W32: encoding: [0x01,0x05,0x0a,0x42]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_sub_co_ci_u32 v5, vcc_lo, v255, v2, vcc_lo
// W32: encoding: [0xff,0x05,0x0a,0x42]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_sub_co_ci_u32 v5, vcc_lo, s1, v2, vcc_lo
// W32: encoding: [0x01,0x04,0x0a,0x42]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_sub_co_ci_u32 v5, vcc_lo, s105, v2, vcc_lo
// W32: encoding: [0x69,0x04,0x0a,0x42]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_sub_co_ci_u32 v5, vcc_lo, vcc_lo, v2, vcc_lo
// W32: encoding: [0x6a,0x04,0x0a,0x42]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_sub_co_ci_u32 v5, vcc_lo, vcc_hi, v2, vcc_lo
// W32: encoding: [0x6b,0x04,0x0a,0x42]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_sub_co_ci_u32 v5, vcc_lo, ttmp15, v2, vcc_lo
// W32: encoding: [0x7b,0x04,0x0a,0x42]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_sub_co_ci_u32 v5, vcc_lo, m0, v2, vcc_lo
// W32: encoding: [0x7d,0x04,0x0a,0x42]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_sub_co_ci_u32 v5, vcc_lo, exec_lo, v2, vcc_lo
// W32: encoding: [0x7e,0x04,0x0a,0x42]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_sub_co_ci_u32 v5, vcc_lo, exec_hi, v2, vcc_lo
// W32: encoding: [0x7f,0x04,0x0a,0x42]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_sub_co_ci_u32 v5, vcc_lo, null, v2, vcc_lo
// W32: encoding: [0x7c,0x04,0x0a,0x42]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_sub_co_ci_u32 v5, vcc_lo, -1, v2, vcc_lo
// W32: encoding: [0xc1,0x04,0x0a,0x42]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_sub_co_ci_u32 v5, vcc_lo, 0.5, v2, vcc_lo
// W32: encoding: [0xf0,0x04,0x0a,0x42]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_sub_co_ci_u32 v5, vcc_lo, src_scc, v2, vcc_lo
// W32: encoding: [0xfd,0x04,0x0a,0x42]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_sub_co_ci_u32 v255, vcc_lo, 0xaf123456, v255, vcc_lo
// W32: encoding: [0xff,0xfe,0xff,0x43,0x56,0x34,0x12,0xaf]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_sub_co_ci_u32 v5, vcc, v1, v2, vcc
// W64: encoding: [0x01,0x05,0x0a,0x42]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_sub_co_ci_u32 v5, vcc, v255, v2, vcc
// W64: encoding: [0xff,0x05,0x0a,0x42]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_sub_co_ci_u32 v5, vcc, s1, v2, vcc
// W64: encoding: [0x01,0x04,0x0a,0x42]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_sub_co_ci_u32 v5, vcc, s105, v2, vcc
// W64: encoding: [0x69,0x04,0x0a,0x42]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_sub_co_ci_u32 v5, vcc, vcc_lo, v2, vcc
// W64: encoding: [0x6a,0x04,0x0a,0x42]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_sub_co_ci_u32 v5, vcc, vcc_hi, v2, vcc
// W64: encoding: [0x6b,0x04,0x0a,0x42]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_sub_co_ci_u32 v5, vcc, ttmp15, v2, vcc
// W64: encoding: [0x7b,0x04,0x0a,0x42]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_sub_co_ci_u32 v5, vcc, m0, v2, vcc
// W64: encoding: [0x7d,0x04,0x0a,0x42]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_sub_co_ci_u32 v5, vcc, exec_lo, v2, vcc
// W64: encoding: [0x7e,0x04,0x0a,0x42]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_sub_co_ci_u32 v5, vcc, exec_hi, v2, vcc
// W64: encoding: [0x7f,0x04,0x0a,0x42]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_sub_co_ci_u32 v5, vcc, null, v2, vcc
// W64: encoding: [0x7c,0x04,0x0a,0x42]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_sub_co_ci_u32 v5, vcc, -1, v2, vcc
// W64: encoding: [0xc1,0x04,0x0a,0x42]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_sub_co_ci_u32 v5, vcc, 0.5, v2, vcc
// W64: encoding: [0xf0,0x04,0x0a,0x42]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_sub_co_ci_u32 v5, vcc, src_scc, v2, vcc
// W64: encoding: [0xfd,0x04,0x0a,0x42]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_sub_co_ci_u32 v255, vcc, 0xaf123456, v255, vcc
// W64: encoding: [0xff,0xfe,0xff,0x43,0x56,0x34,0x12,0xaf]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_sub_f16 v5, v1, v2
// GFX11: encoding: [0x01,0x05,0x0a,0x66]

v_sub_f16 v5, v127, v2
// GFX11: encoding: [0x7f,0x05,0x0a,0x66]

v_sub_f16 v5, s1, v2
// GFX11: encoding: [0x01,0x04,0x0a,0x66]

v_sub_f16 v5, s105, v2
// GFX11: encoding: [0x69,0x04,0x0a,0x66]

v_sub_f16 v5, vcc_lo, v2
// GFX11: encoding: [0x6a,0x04,0x0a,0x66]

v_sub_f16 v5, vcc_hi, v2
// GFX11: encoding: [0x6b,0x04,0x0a,0x66]

v_sub_f16 v5, ttmp15, v2
// GFX11: encoding: [0x7b,0x04,0x0a,0x66]

v_sub_f16 v5, m0, v2
// GFX11: encoding: [0x7d,0x04,0x0a,0x66]

v_sub_f16 v5, exec_lo, v2
// GFX11: encoding: [0x7e,0x04,0x0a,0x66]

v_sub_f16 v5, exec_hi, v2
// GFX11: encoding: [0x7f,0x04,0x0a,0x66]

v_sub_f16 v5, null, v2
// GFX11: encoding: [0x7c,0x04,0x0a,0x66]

v_sub_f16 v5, -1, v2
// GFX11: encoding: [0xc1,0x04,0x0a,0x66]

v_sub_f16 v5, 0.5, v2
// GFX11: encoding: [0xf0,0x04,0x0a,0x66]

v_sub_f16 v5, src_scc, v2
// GFX11: encoding: [0xfd,0x04,0x0a,0x66]

v_sub_f16 v127, 0xfe0b, v127
// GFX11: encoding: [0xff,0xfe,0xfe,0x66,0x0b,0xfe,0x00,0x00]

v_sub_f32 v5, v1, v2
// GFX11: encoding: [0x01,0x05,0x0a,0x08]

v_sub_f32 v5, v255, v2
// GFX11: encoding: [0xff,0x05,0x0a,0x08]

v_sub_f32 v5, s1, v2
// GFX11: encoding: [0x01,0x04,0x0a,0x08]

v_sub_f32 v5, s105, v2
// GFX11: encoding: [0x69,0x04,0x0a,0x08]

v_sub_f32 v5, vcc_lo, v2
// GFX11: encoding: [0x6a,0x04,0x0a,0x08]

v_sub_f32 v5, vcc_hi, v2
// GFX11: encoding: [0x6b,0x04,0x0a,0x08]

v_sub_f32 v5, ttmp15, v2
// GFX11: encoding: [0x7b,0x04,0x0a,0x08]

v_sub_f32 v5, m0, v2
// GFX11: encoding: [0x7d,0x04,0x0a,0x08]

v_sub_f32 v5, exec_lo, v2
// GFX11: encoding: [0x7e,0x04,0x0a,0x08]

v_sub_f32 v5, exec_hi, v2
// GFX11: encoding: [0x7f,0x04,0x0a,0x08]

v_sub_f32 v5, null, v2
// GFX11: encoding: [0x7c,0x04,0x0a,0x08]

v_sub_f32 v5, -1, v2
// GFX11: encoding: [0xc1,0x04,0x0a,0x08]

v_sub_f32 v5, 0.5, v2
// GFX11: encoding: [0xf0,0x04,0x0a,0x08]

v_sub_f32 v5, src_scc, v2
// GFX11: encoding: [0xfd,0x04,0x0a,0x08]

v_sub_f32 v255, 0xaf123456, v255
// GFX11: encoding: [0xff,0xfe,0xff,0x09,0x56,0x34,0x12,0xaf]

v_sub_nc_u32 v5, v1, v2
// GFX11: encoding: [0x01,0x05,0x0a,0x4c]

v_sub_nc_u32 v5, v255, v2
// GFX11: encoding: [0xff,0x05,0x0a,0x4c]

v_sub_nc_u32 v5, s1, v2
// GFX11: encoding: [0x01,0x04,0x0a,0x4c]

v_sub_nc_u32 v5, s105, v2
// GFX11: encoding: [0x69,0x04,0x0a,0x4c]

v_sub_nc_u32 v5, vcc_lo, v2
// GFX11: encoding: [0x6a,0x04,0x0a,0x4c]

v_sub_nc_u32 v5, vcc_hi, v2
// GFX11: encoding: [0x6b,0x04,0x0a,0x4c]

v_sub_nc_u32 v5, ttmp15, v2
// GFX11: encoding: [0x7b,0x04,0x0a,0x4c]

v_sub_nc_u32 v5, m0, v2
// GFX11: encoding: [0x7d,0x04,0x0a,0x4c]

v_sub_nc_u32 v5, exec_lo, v2
// GFX11: encoding: [0x7e,0x04,0x0a,0x4c]

v_sub_nc_u32 v5, exec_hi, v2
// GFX11: encoding: [0x7f,0x04,0x0a,0x4c]

v_sub_nc_u32 v5, null, v2
// GFX11: encoding: [0x7c,0x04,0x0a,0x4c]

v_sub_nc_u32 v5, -1, v2
// GFX11: encoding: [0xc1,0x04,0x0a,0x4c]

v_sub_nc_u32 v5, 0.5, v2
// GFX11: encoding: [0xf0,0x04,0x0a,0x4c]

v_sub_nc_u32 v5, src_scc, v2
// GFX11: encoding: [0xfd,0x04,0x0a,0x4c]

v_sub_nc_u32 v255, 0xaf123456, v255
// GFX11: encoding: [0xff,0xfe,0xff,0x4d,0x56,0x34,0x12,0xaf]

v_subrev_co_ci_u32 v5, vcc_lo, v1, v2, vcc_lo
// W32: encoding: [0x01,0x05,0x0a,0x44]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_subrev_co_ci_u32 v5, vcc_lo, v255, v2, vcc_lo
// W32: encoding: [0xff,0x05,0x0a,0x44]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_subrev_co_ci_u32 v5, vcc_lo, s1, v2, vcc_lo
// W32: encoding: [0x01,0x04,0x0a,0x44]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_subrev_co_ci_u32 v5, vcc_lo, s105, v2, vcc_lo
// W32: encoding: [0x69,0x04,0x0a,0x44]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_subrev_co_ci_u32 v5, vcc_lo, vcc_lo, v2, vcc_lo
// W32: encoding: [0x6a,0x04,0x0a,0x44]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_subrev_co_ci_u32 v5, vcc_lo, vcc_hi, v2, vcc_lo
// W32: encoding: [0x6b,0x04,0x0a,0x44]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_subrev_co_ci_u32 v5, vcc_lo, ttmp15, v2, vcc_lo
// W32: encoding: [0x7b,0x04,0x0a,0x44]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_subrev_co_ci_u32 v5, vcc_lo, m0, v2, vcc_lo
// W32: encoding: [0x7d,0x04,0x0a,0x44]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_subrev_co_ci_u32 v5, vcc_lo, exec_lo, v2, vcc_lo
// W32: encoding: [0x7e,0x04,0x0a,0x44]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_subrev_co_ci_u32 v5, vcc_lo, exec_hi, v2, vcc_lo
// W32: encoding: [0x7f,0x04,0x0a,0x44]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_subrev_co_ci_u32 v5, vcc_lo, null, v2, vcc_lo
// W32: encoding: [0x7c,0x04,0x0a,0x44]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_subrev_co_ci_u32 v5, vcc_lo, -1, v2, vcc_lo
// W32: encoding: [0xc1,0x04,0x0a,0x44]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_subrev_co_ci_u32 v5, vcc_lo, 0.5, v2, vcc_lo
// W32: encoding: [0xf0,0x04,0x0a,0x44]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_subrev_co_ci_u32 v5, vcc_lo, src_scc, v2, vcc_lo
// W32: encoding: [0xfd,0x04,0x0a,0x44]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_subrev_co_ci_u32 v255, vcc_lo, 0xaf123456, v255, vcc_lo
// W32: encoding: [0xff,0xfe,0xff,0x45,0x56,0x34,0x12,0xaf]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_subrev_co_ci_u32 v5, vcc, v1, v2, vcc
// W64: encoding: [0x01,0x05,0x0a,0x44]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_subrev_co_ci_u32 v5, vcc, v255, v2, vcc
// W64: encoding: [0xff,0x05,0x0a,0x44]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_subrev_co_ci_u32 v5, vcc, s1, v2, vcc
// W64: encoding: [0x01,0x04,0x0a,0x44]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_subrev_co_ci_u32 v5, vcc, s105, v2, vcc
// W64: encoding: [0x69,0x04,0x0a,0x44]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_subrev_co_ci_u32 v5, vcc, vcc_lo, v2, vcc
// W64: encoding: [0x6a,0x04,0x0a,0x44]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_subrev_co_ci_u32 v5, vcc, vcc_hi, v2, vcc
// W64: encoding: [0x6b,0x04,0x0a,0x44]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_subrev_co_ci_u32 v5, vcc, ttmp15, v2, vcc
// W64: encoding: [0x7b,0x04,0x0a,0x44]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_subrev_co_ci_u32 v5, vcc, m0, v2, vcc
// W64: encoding: [0x7d,0x04,0x0a,0x44]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_subrev_co_ci_u32 v5, vcc, exec_lo, v2, vcc
// W64: encoding: [0x7e,0x04,0x0a,0x44]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_subrev_co_ci_u32 v5, vcc, exec_hi, v2, vcc
// W64: encoding: [0x7f,0x04,0x0a,0x44]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_subrev_co_ci_u32 v5, vcc, null, v2, vcc
// W64: encoding: [0x7c,0x04,0x0a,0x44]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_subrev_co_ci_u32 v5, vcc, -1, v2, vcc
// W64: encoding: [0xc1,0x04,0x0a,0x44]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_subrev_co_ci_u32 v5, vcc, 0.5, v2, vcc
// W64: encoding: [0xf0,0x04,0x0a,0x44]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_subrev_co_ci_u32 v5, vcc, src_scc, v2, vcc
// W64: encoding: [0xfd,0x04,0x0a,0x44]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_subrev_co_ci_u32 v255, vcc, 0xaf123456, v255, vcc
// W64: encoding: [0xff,0xfe,0xff,0x45,0x56,0x34,0x12,0xaf]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_subrev_f16 v5, v1, v2
// GFX11: encoding: [0x01,0x05,0x0a,0x68]

v_subrev_f16 v5, v127, v2
// GFX11: encoding: [0x7f,0x05,0x0a,0x68]

v_subrev_f16 v5, s1, v2
// GFX11: encoding: [0x01,0x04,0x0a,0x68]

v_subrev_f16 v5, s105, v2
// GFX11: encoding: [0x69,0x04,0x0a,0x68]

v_subrev_f16 v5, vcc_lo, v2
// GFX11: encoding: [0x6a,0x04,0x0a,0x68]

v_subrev_f16 v5, vcc_hi, v2
// GFX11: encoding: [0x6b,0x04,0x0a,0x68]

v_subrev_f16 v5, ttmp15, v2
// GFX11: encoding: [0x7b,0x04,0x0a,0x68]

v_subrev_f16 v5, m0, v2
// GFX11: encoding: [0x7d,0x04,0x0a,0x68]

v_subrev_f16 v5, exec_lo, v2
// GFX11: encoding: [0x7e,0x04,0x0a,0x68]

v_subrev_f16 v5, exec_hi, v2
// GFX11: encoding: [0x7f,0x04,0x0a,0x68]

v_subrev_f16 v5, null, v2
// GFX11: encoding: [0x7c,0x04,0x0a,0x68]

v_subrev_f16 v5, -1, v2
// GFX11: encoding: [0xc1,0x04,0x0a,0x68]

v_subrev_f16 v5, 0.5, v2
// GFX11: encoding: [0xf0,0x04,0x0a,0x68]

v_subrev_f16 v5, src_scc, v2
// GFX11: encoding: [0xfd,0x04,0x0a,0x68]

v_subrev_f16 v127, 0xfe0b, v127
// GFX11: encoding: [0xff,0xfe,0xfe,0x68,0x0b,0xfe,0x00,0x00]

v_subrev_f32 v5, v1, v2
// GFX11: encoding: [0x01,0x05,0x0a,0x0a]

v_subrev_f32 v5, v255, v2
// GFX11: encoding: [0xff,0x05,0x0a,0x0a]

v_subrev_f32 v5, s1, v2
// GFX11: encoding: [0x01,0x04,0x0a,0x0a]

v_subrev_f32 v5, s105, v2
// GFX11: encoding: [0x69,0x04,0x0a,0x0a]

v_subrev_f32 v5, vcc_lo, v2
// GFX11: encoding: [0x6a,0x04,0x0a,0x0a]

v_subrev_f32 v5, vcc_hi, v2
// GFX11: encoding: [0x6b,0x04,0x0a,0x0a]

v_subrev_f32 v5, ttmp15, v2
// GFX11: encoding: [0x7b,0x04,0x0a,0x0a]

v_subrev_f32 v5, m0, v2
// GFX11: encoding: [0x7d,0x04,0x0a,0x0a]

v_subrev_f32 v5, exec_lo, v2
// GFX11: encoding: [0x7e,0x04,0x0a,0x0a]

v_subrev_f32 v5, exec_hi, v2
// GFX11: encoding: [0x7f,0x04,0x0a,0x0a]

v_subrev_f32 v5, null, v2
// GFX11: encoding: [0x7c,0x04,0x0a,0x0a]

v_subrev_f32 v5, -1, v2
// GFX11: encoding: [0xc1,0x04,0x0a,0x0a]

v_subrev_f32 v5, 0.5, v2
// GFX11: encoding: [0xf0,0x04,0x0a,0x0a]

v_subrev_f32 v5, src_scc, v2
// GFX11: encoding: [0xfd,0x04,0x0a,0x0a]

v_subrev_f32 v255, 0xaf123456, v255
// GFX11: encoding: [0xff,0xfe,0xff,0x0b,0x56,0x34,0x12,0xaf]

v_subrev_nc_u32 v5, v1, v2
// GFX11: encoding: [0x01,0x05,0x0a,0x4e]

v_subrev_nc_u32 v5, v255, v2
// GFX11: encoding: [0xff,0x05,0x0a,0x4e]

v_subrev_nc_u32 v5, s1, v2
// GFX11: encoding: [0x01,0x04,0x0a,0x4e]

v_subrev_nc_u32 v5, s105, v2
// GFX11: encoding: [0x69,0x04,0x0a,0x4e]

v_subrev_nc_u32 v5, vcc_lo, v2
// GFX11: encoding: [0x6a,0x04,0x0a,0x4e]

v_subrev_nc_u32 v5, vcc_hi, v2
// GFX11: encoding: [0x6b,0x04,0x0a,0x4e]

v_subrev_nc_u32 v5, ttmp15, v2
// GFX11: encoding: [0x7b,0x04,0x0a,0x4e]

v_subrev_nc_u32 v5, m0, v2
// GFX11: encoding: [0x7d,0x04,0x0a,0x4e]

v_subrev_nc_u32 v5, exec_lo, v2
// GFX11: encoding: [0x7e,0x04,0x0a,0x4e]

v_subrev_nc_u32 v5, exec_hi, v2
// GFX11: encoding: [0x7f,0x04,0x0a,0x4e]

v_subrev_nc_u32 v5, null, v2
// GFX11: encoding: [0x7c,0x04,0x0a,0x4e]

v_subrev_nc_u32 v5, -1, v2
// GFX11: encoding: [0xc1,0x04,0x0a,0x4e]

v_subrev_nc_u32 v5, 0.5, v2
// GFX11: encoding: [0xf0,0x04,0x0a,0x4e]

v_subrev_nc_u32 v5, src_scc, v2
// GFX11: encoding: [0xfd,0x04,0x0a,0x4e]

v_subrev_nc_u32 v255, 0xaf123456, v255
// GFX11: encoding: [0xff,0xfe,0xff,0x4f,0x56,0x34,0x12,0xaf]

v_xnor_b32 v5, v1, v2
// GFX11: encoding: [0x01,0x05,0x0a,0x3c]

v_xnor_b32 v5, v255, v2
// GFX11: encoding: [0xff,0x05,0x0a,0x3c]

v_xnor_b32 v5, s1, v2
// GFX11: encoding: [0x01,0x04,0x0a,0x3c]

v_xnor_b32 v5, s105, v2
// GFX11: encoding: [0x69,0x04,0x0a,0x3c]

v_xnor_b32 v5, vcc_lo, v2
// GFX11: encoding: [0x6a,0x04,0x0a,0x3c]

v_xnor_b32 v5, vcc_hi, v2
// GFX11: encoding: [0x6b,0x04,0x0a,0x3c]

v_xnor_b32 v5, ttmp15, v2
// GFX11: encoding: [0x7b,0x04,0x0a,0x3c]

v_xnor_b32 v5, m0, v2
// GFX11: encoding: [0x7d,0x04,0x0a,0x3c]

v_xnor_b32 v5, exec_lo, v2
// GFX11: encoding: [0x7e,0x04,0x0a,0x3c]

v_xnor_b32 v5, exec_hi, v2
// GFX11: encoding: [0x7f,0x04,0x0a,0x3c]

v_xnor_b32 v5, null, v2
// GFX11: encoding: [0x7c,0x04,0x0a,0x3c]

v_xnor_b32 v5, -1, v2
// GFX11: encoding: [0xc1,0x04,0x0a,0x3c]

v_xnor_b32 v5, 0.5, v2
// GFX11: encoding: [0xf0,0x04,0x0a,0x3c]

v_xnor_b32 v5, src_scc, v2
// GFX11: encoding: [0xfd,0x04,0x0a,0x3c]

v_xnor_b32 v255, 0xaf123456, v255
// GFX11: encoding: [0xff,0xfe,0xff,0x3d,0x56,0x34,0x12,0xaf]

v_xor_b32 v5, v1, v2
// GFX11: encoding: [0x01,0x05,0x0a,0x3a]

v_xor_b32 v5, v255, v2
// GFX11: encoding: [0xff,0x05,0x0a,0x3a]

v_xor_b32 v5, s1, v2
// GFX11: encoding: [0x01,0x04,0x0a,0x3a]

v_xor_b32 v5, s105, v2
// GFX11: encoding: [0x69,0x04,0x0a,0x3a]

v_xor_b32 v5, vcc_lo, v2
// GFX11: encoding: [0x6a,0x04,0x0a,0x3a]

v_xor_b32 v5, vcc_hi, v2
// GFX11: encoding: [0x6b,0x04,0x0a,0x3a]

v_xor_b32 v5, ttmp15, v2
// GFX11: encoding: [0x7b,0x04,0x0a,0x3a]

v_xor_b32 v5, m0, v2
// GFX11: encoding: [0x7d,0x04,0x0a,0x3a]

v_xor_b32 v5, exec_lo, v2
// GFX11: encoding: [0x7e,0x04,0x0a,0x3a]

v_xor_b32 v5, exec_hi, v2
// GFX11: encoding: [0x7f,0x04,0x0a,0x3a]

v_xor_b32 v5, null, v2
// GFX11: encoding: [0x7c,0x04,0x0a,0x3a]

v_xor_b32 v5, -1, v2
// GFX11: encoding: [0xc1,0x04,0x0a,0x3a]

v_xor_b32 v5, 0.5, v2
// GFX11: encoding: [0xf0,0x04,0x0a,0x3a]

v_xor_b32 v5, src_scc, v2
// GFX11: encoding: [0xfd,0x04,0x0a,0x3a]

v_xor_b32 v255, 0xaf123456, v255
// GFX11: encoding: [0xff,0xfe,0xff,0x3b,0x56,0x34,0x12,0xaf]
