/* MainWidget.c generated by valac 0.34.6, the Vala compiler
 * generated from MainWidget.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <json-glib/json-glib.h>
#include <rest/oauth-proxy.h>
#include "CbUserCounter.h"
#include "CbFilter.h"
#include <gio/gio.h>


#define TYPE_MAIN_WIDGET (main_widget_get_type ())
#define MAIN_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WIDGET, MainWidget))
#define MAIN_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WIDGET, MainWidgetClass))
#define IS_MAIN_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WIDGET))
#define IS_MAIN_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WIDGET))
#define MAIN_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WIDGET, MainWidgetClass))

typedef struct _MainWidget MainWidget;
typedef struct _MainWidgetClass MainWidgetClass;
typedef struct _MainWidgetPrivate MainWidgetPrivate;

#define TYPE_ACCOUNT (account_get_type ())
#define ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ACCOUNT, Account))
#define ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ACCOUNT, AccountClass))
#define IS_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ACCOUNT))
#define IS_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ACCOUNT))
#define ACCOUNT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ACCOUNT, AccountClass))

typedef struct _Account Account;
typedef struct _AccountClass AccountClass;

#define TYPE_IPAGE (ipage_get_type ())
#define IPAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IPAGE, IPage))
#define IS_IPAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IPAGE))
#define IPAGE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_IPAGE, IPageIface))

typedef struct _IPage IPage;
typedef struct _IPageIface IPageIface;

#define TYPE_BUNDLE (bundle_get_type ())
#define BUNDLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUNDLE, Bundle))
#define BUNDLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUNDLE, BundleClass))
#define IS_BUNDLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUNDLE))
#define IS_BUNDLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUNDLE))
#define BUNDLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUNDLE, BundleClass))

typedef struct _Bundle Bundle;
typedef struct _BundleClass BundleClass;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;

#define TYPE_BUNDLE_HISTORY (bundle_history_get_type ())
#define BUNDLE_HISTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUNDLE_HISTORY, BundleHistory))
#define BUNDLE_HISTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUNDLE_HISTORY, BundleHistoryClass))
#define IS_BUNDLE_HISTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUNDLE_HISTORY))
#define IS_BUNDLE_HISTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUNDLE_HISTORY))
#define BUNDLE_HISTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUNDLE_HISTORY, BundleHistoryClass))

typedef struct _BundleHistory BundleHistory;
typedef struct _BundleHistoryClass BundleHistoryClass;

#define TYPE_DELTA_UPDATER (delta_updater_get_type ())
#define DELTA_UPDATER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DELTA_UPDATER, DeltaUpdater))
#define DELTA_UPDATER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DELTA_UPDATER, DeltaUpdaterClass))
#define IS_DELTA_UPDATER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DELTA_UPDATER))
#define IS_DELTA_UPDATER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DELTA_UPDATER))
#define DELTA_UPDATER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DELTA_UPDATER, DeltaUpdaterClass))

typedef struct _DeltaUpdater DeltaUpdater;
typedef struct _DeltaUpdaterClass DeltaUpdaterClass;

#define TYPE_IMPOSTOR_WIDGET (impostor_widget_get_type ())
#define IMPOSTOR_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IMPOSTOR_WIDGET, ImpostorWidget))
#define IMPOSTOR_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_IMPOSTOR_WIDGET, ImpostorWidgetClass))
#define IS_IMPOSTOR_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IMPOSTOR_WIDGET))
#define IS_IMPOSTOR_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_IMPOSTOR_WIDGET))
#define IMPOSTOR_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_IMPOSTOR_WIDGET, ImpostorWidgetClass))

typedef struct _ImpostorWidget ImpostorWidget;
typedef struct _ImpostorWidgetClass ImpostorWidgetClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _bundle_history_unref0(var) ((var == NULL) ? NULL : (var = (bundle_history_unref (var), NULL)))

#define TYPE_COREBIRD (corebird_get_type ())
#define COREBIRD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COREBIRD, Corebird))
#define COREBIRD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COREBIRD, CorebirdClass))
#define IS_COREBIRD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COREBIRD))
#define IS_COREBIRD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COREBIRD))
#define COREBIRD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COREBIRD, CorebirdClass))

typedef struct _Corebird Corebird;
typedef struct _CorebirdClass CorebirdClass;

#define TYPE_PAGE (page_get_type ())

#define TYPE_SCROLL_WIDGET (scroll_widget_get_type ())
#define SCROLL_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCROLL_WIDGET, ScrollWidget))
#define SCROLL_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCROLL_WIDGET, ScrollWidgetClass))
#define IS_SCROLL_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCROLL_WIDGET))
#define IS_SCROLL_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCROLL_WIDGET))
#define SCROLL_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCROLL_WIDGET, ScrollWidgetClass))

typedef struct _ScrollWidget ScrollWidget;
typedef struct _ScrollWidgetClass ScrollWidgetClass;

#define TYPE_DEFAULT_TIMELINE (default_timeline_get_type ())
#define DEFAULT_TIMELINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DEFAULT_TIMELINE, DefaultTimeline))
#define DEFAULT_TIMELINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DEFAULT_TIMELINE, DefaultTimelineClass))
#define IS_DEFAULT_TIMELINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DEFAULT_TIMELINE))
#define IS_DEFAULT_TIMELINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DEFAULT_TIMELINE))
#define DEFAULT_TIMELINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DEFAULT_TIMELINE, DefaultTimelineClass))

typedef struct _DefaultTimeline DefaultTimeline;
typedef struct _DefaultTimelineClass DefaultTimelineClass;

#define TYPE_HOME_TIMELINE (home_timeline_get_type ())
#define HOME_TIMELINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HOME_TIMELINE, HomeTimeline))
#define HOME_TIMELINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HOME_TIMELINE, HomeTimelineClass))
#define IS_HOME_TIMELINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HOME_TIMELINE))
#define IS_HOME_TIMELINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HOME_TIMELINE))
#define HOME_TIMELINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HOME_TIMELINE, HomeTimelineClass))

typedef struct _HomeTimeline HomeTimeline;
typedef struct _HomeTimelineClass HomeTimelineClass;

#define TYPE_MENTIONS_TIMELINE (mentions_timeline_get_type ())
#define MENTIONS_TIMELINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MENTIONS_TIMELINE, MentionsTimeline))
#define MENTIONS_TIMELINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MENTIONS_TIMELINE, MentionsTimelineClass))
#define IS_MENTIONS_TIMELINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MENTIONS_TIMELINE))
#define IS_MENTIONS_TIMELINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MENTIONS_TIMELINE))
#define MENTIONS_TIMELINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MENTIONS_TIMELINE, MentionsTimelineClass))

typedef struct _MentionsTimeline MentionsTimeline;
typedef struct _MentionsTimelineClass MentionsTimelineClass;

#define TYPE_FAVORITES_TIMELINE (favorites_timeline_get_type ())
#define FAVORITES_TIMELINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FAVORITES_TIMELINE, FavoritesTimeline))
#define FAVORITES_TIMELINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FAVORITES_TIMELINE, FavoritesTimelineClass))
#define IS_FAVORITES_TIMELINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FAVORITES_TIMELINE))
#define IS_FAVORITES_TIMELINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FAVORITES_TIMELINE))
#define FAVORITES_TIMELINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FAVORITES_TIMELINE, FavoritesTimelineClass))

typedef struct _FavoritesTimeline FavoritesTimeline;
typedef struct _FavoritesTimelineClass FavoritesTimelineClass;

#define TYPE_DM_THREADS_PAGE (dm_threads_page_get_type ())
#define DM_THREADS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DM_THREADS_PAGE, DMThreadsPage))
#define DM_THREADS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DM_THREADS_PAGE, DMThreadsPageClass))
#define IS_DM_THREADS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DM_THREADS_PAGE))
#define IS_DM_THREADS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DM_THREADS_PAGE))
#define DM_THREADS_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DM_THREADS_PAGE, DMThreadsPageClass))

typedef struct _DMThreadsPage DMThreadsPage;
typedef struct _DMThreadsPageClass DMThreadsPageClass;

#define TYPE_LISTS_PAGE (lists_page_get_type ())
#define LISTS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LISTS_PAGE, ListsPage))
#define LISTS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LISTS_PAGE, ListsPageClass))
#define IS_LISTS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LISTS_PAGE))
#define IS_LISTS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LISTS_PAGE))
#define LISTS_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LISTS_PAGE, ListsPageClass))

typedef struct _ListsPage ListsPage;
typedef struct _ListsPageClass ListsPageClass;

#define TYPE_FILTER_PAGE (filter_page_get_type ())
#define FILTER_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FILTER_PAGE, FilterPage))
#define FILTER_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FILTER_PAGE, FilterPageClass))
#define IS_FILTER_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FILTER_PAGE))
#define IS_FILTER_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FILTER_PAGE))
#define FILTER_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FILTER_PAGE, FilterPageClass))

typedef struct _FilterPage FilterPage;
typedef struct _FilterPageClass FilterPageClass;

#define TYPE_SEARCH_PAGE (search_page_get_type ())
#define SEARCH_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SEARCH_PAGE, SearchPage))
#define SEARCH_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SEARCH_PAGE, SearchPageClass))
#define IS_SEARCH_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SEARCH_PAGE))
#define IS_SEARCH_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SEARCH_PAGE))
#define SEARCH_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SEARCH_PAGE, SearchPageClass))

typedef struct _SearchPage SearchPage;
typedef struct _SearchPageClass SearchPageClass;

#define TYPE_PROFILE_PAGE (profile_page_get_type ())
#define PROFILE_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROFILE_PAGE, ProfilePage))
#define PROFILE_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROFILE_PAGE, ProfilePageClass))
#define IS_PROFILE_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROFILE_PAGE))
#define IS_PROFILE_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROFILE_PAGE))
#define PROFILE_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROFILE_PAGE, ProfilePageClass))

typedef struct _ProfilePage ProfilePage;
typedef struct _ProfilePageClass ProfilePageClass;

#define TYPE_TWEET_INFO_PAGE (tweet_info_page_get_type ())
#define TWEET_INFO_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWEET_INFO_PAGE, TweetInfoPage))
#define TWEET_INFO_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWEET_INFO_PAGE, TweetInfoPageClass))
#define IS_TWEET_INFO_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWEET_INFO_PAGE))
#define IS_TWEET_INFO_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWEET_INFO_PAGE))
#define TWEET_INFO_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWEET_INFO_PAGE, TweetInfoPageClass))

typedef struct _TweetInfoPage TweetInfoPage;
typedef struct _TweetInfoPageClass TweetInfoPageClass;

#define TYPE_DM_PAGE (dm_page_get_type ())
#define DM_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DM_PAGE, DMPage))
#define DM_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DM_PAGE, DMPageClass))
#define IS_DM_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DM_PAGE))
#define IS_DM_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DM_PAGE))
#define DM_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DM_PAGE, DMPageClass))

typedef struct _DMPage DMPage;
typedef struct _DMPageClass DMPageClass;

#define TYPE_LIST_STATUSES_PAGE (list_statuses_page_get_type ())
#define LIST_STATUSES_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LIST_STATUSES_PAGE, ListStatusesPage))
#define LIST_STATUSES_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LIST_STATUSES_PAGE, ListStatusesPageClass))
#define IS_LIST_STATUSES_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LIST_STATUSES_PAGE))
#define IS_LIST_STATUSES_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LIST_STATUSES_PAGE))
#define LIST_STATUSES_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LIST_STATUSES_PAGE, ListStatusesPageClass))

typedef struct _ListStatusesPage ListStatusesPage;
typedef struct _ListStatusesPageClass ListStatusesPageClass;
typedef struct _Block2Data Block2Data;

#define TYPE_IMESSAGE_RECEIVER (imessage_receiver_get_type ())
#define IMESSAGE_RECEIVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IMESSAGE_RECEIVER, IMessageReceiver))
#define IS_IMESSAGE_RECEIVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IMESSAGE_RECEIVER))
#define IMESSAGE_RECEIVER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_IMESSAGE_RECEIVER, IMessageReceiverIface))

typedef struct _IMessageReceiver IMessageReceiver;
typedef struct _IMessageReceiverIface IMessageReceiverIface;

#define TYPE_STREAM_MESSAGE_TYPE (stream_message_type_get_type ())
typedef struct _AccountPrivate AccountPrivate;

#define SQL_TYPE_DATABASE (sql_database_get_type ())
#define SQL_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SQL_TYPE_DATABASE, SqlDatabase))
#define SQL_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SQL_TYPE_DATABASE, SqlDatabaseClass))
#define SQL_IS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SQL_TYPE_DATABASE))
#define SQL_IS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SQL_TYPE_DATABASE))
#define SQL_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SQL_TYPE_DATABASE, SqlDatabaseClass))

typedef struct _SqlDatabase SqlDatabase;
typedef struct _SqlDatabaseClass SqlDatabaseClass;

#define TYPE_USER_STREAM (user_stream_get_type ())
#define USER_STREAM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_USER_STREAM, UserStream))
#define USER_STREAM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_USER_STREAM, UserStreamClass))
#define IS_USER_STREAM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_USER_STREAM))
#define IS_USER_STREAM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_USER_STREAM))
#define USER_STREAM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_USER_STREAM, UserStreamClass))

typedef struct _UserStream UserStream;
typedef struct _UserStreamClass UserStreamClass;

#define TYPE_NOTIFICATION_MANAGER (notification_manager_get_type ())
#define NOTIFICATION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFICATION_MANAGER, NotificationManager))
#define NOTIFICATION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFICATION_MANAGER, NotificationManagerClass))
#define IS_NOTIFICATION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFICATION_MANAGER))
#define IS_NOTIFICATION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFICATION_MANAGER))
#define NOTIFICATION_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFICATION_MANAGER, NotificationManagerClass))

typedef struct _NotificationManager NotificationManager;
typedef struct _NotificationManagerClass NotificationManagerClass;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _MainWindowPrivate MainWindowPrivate;

struct _MainWidget {
	GtkBox parent_instance;
	MainWidgetPrivate * priv;
};

struct _MainWidgetClass {
	GtkBoxClass parent_class;
};

struct _IPageIface {
	GTypeInterface parent_iface;
	void (*on_join) (IPage* self, gint page_id, Bundle* args);
	void (*on_leave) (IPage* self);
	void (*create_radio_button) (IPage* self, GtkRadioButton* group);
	GtkRadioButton* (*get_radio_button) (IPage* self);
	gchar* (*get_title) (IPage* self);
	gboolean (*handles_double_open) (IPage* self);
	void (*double_open) (IPage* self);
	gint (*get_id) (IPage* self);
	void (*set_id) (IPage* self, gint value);
	void (*set_window) (IPage* self, MainWindow* value);
};

struct _MainWidgetPrivate {
	Account* account;
	GtkRadioButton* dummy_button;
	IPage** pages;
	gint pages_length1;
	gint _pages_size_;
	BundleHistory* history;
	DeltaUpdater* delta_updater;
	gboolean page_switch_lock;
	ImpostorWidget* stack_impostor;
	GtkBox* top_box;
	GtkStack* stack;
	GtkRevealer* sidebar_revealer;
};

typedef enum  {
	PAGE_STREAM = 0,
	PAGE_MENTIONS,
	PAGE_FAVORITES,
	PAGE_DM_THREADS,
	PAGE_LISTS,
	PAGE_FILTERS,
	PAGE_SEARCH,
	PAGE_PROFILE,
	PAGE_TWEET_INFO,
	PAGE_DM,
	PAGE_LIST_STATUSES,
	PAGE_PREVIOUS = 1024,
	PAGE_NEXT = 2048
} Page;

struct _Block2Data {
	int _ref_count_;
	MainWidget* self;
	IPage* page;
};

typedef enum  {
	STREAM_MESSAGE_TYPE_UNSUPPORTED,
	STREAM_MESSAGE_TYPE_DELETE,
	STREAM_MESSAGE_TYPE_SCRUB_GEO,
	STREAM_MESSAGE_TYPE_LIMIT,
	STREAM_MESSAGE_TYPE_DISCONNECT,
	STREAM_MESSAGE_TYPE_FRIENDS,
	STREAM_MESSAGE_TYPE_EVENT,
	STREAM_MESSAGE_TYPE_WARNING,
	STREAM_MESSAGE_TYPE_DIRECT_MESSAGE,
	STREAM_MESSAGE_TYPE_TWEET,
	STREAM_MESSAGE_TYPE_EVENT_LIST_CREATED,
	STREAM_MESSAGE_TYPE_EVENT_LIST_DESTROYED,
	STREAM_MESSAGE_TYPE_EVENT_LIST_UPDATED,
	STREAM_MESSAGE_TYPE_EVENT_LIST_UNSUBSCRIBED,
	STREAM_MESSAGE_TYPE_EVENT_LIST_SUBSCRIBED,
	STREAM_MESSAGE_TYPE_EVENT_LIST_MEMBER_ADDED,
	STREAM_MESSAGE_TYPE_EVENT_LIST_MEMBER_REMOVED,
	STREAM_MESSAGE_TYPE_EVENT_FAVORITE,
	STREAM_MESSAGE_TYPE_EVENT_UNFAVORITE,
	STREAM_MESSAGE_TYPE_EVENT_FOLLOW,
	STREAM_MESSAGE_TYPE_EVENT_UNFOLLOW,
	STREAM_MESSAGE_TYPE_EVENT_BLOCK,
	STREAM_MESSAGE_TYPE_EVENT_UNBLOCK,
	STREAM_MESSAGE_TYPE_EVENT_MUTE,
	STREAM_MESSAGE_TYPE_EVENT_UNMUTE,
	STREAM_MESSAGE_TYPE_EVENT_USER_UPDATE,
	STREAM_MESSAGE_TYPE_EVENT_QUOTED_TWEET
} StreamMessageType;

struct _IMessageReceiverIface {
	GTypeInterface parent_iface;
	void (*stream_message_received) (IMessageReceiver* self, StreamMessageType type, JsonNode* root_node);
};

struct _Account {
	GObject parent_instance;
	AccountPrivate * priv;
	gint64 id;
	SqlDatabase* db;
	OAuthProxy* proxy;
	UserStream* user_stream;
	CbUserCounter* user_counter;
	NotificationManager* notifications;
	gint64* friends;
	gint friends_length1;
	gint64* blocked;
	gint blocked_length1;
	gint64* muted;
	gint muted_length1;
	gint64* disabled_rts;
	gint disabled_rts_length1;
	GPtrArray* filters;
};

struct _AccountClass {
	GObjectClass parent_class;
};

struct _MainWindow {
	GtkApplicationWindow parent_instance;
	MainWindowPrivate * priv;
	GtkButton* back_button;
	GtkToggleButton* compose_tweet_button;
	MainWidget* main_widget;
	Account* account;
};

struct _MainWindowClass {
	GtkApplicationWindowClass parent_class;
};


static gpointer main_widget_parent_class = NULL;

GType main_widget_get_type (void) G_GNUC_CONST;
GType account_get_type (void) G_GNUC_CONST;
GType bundle_get_type (void) G_GNUC_CONST;
GType main_window_get_type (void) G_GNUC_CONST;
GType ipage_get_type (void) G_GNUC_CONST;
gpointer bundle_history_ref (gpointer instance);
void bundle_history_unref (gpointer instance);
GParamSpec* param_spec_bundle_history (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_bundle_history (GValue* value, gpointer v_object);
void value_take_bundle_history (GValue* value, gpointer v_object);
gpointer value_get_bundle_history (const GValue* value);
GType bundle_history_get_type (void) G_GNUC_CONST;
GType delta_updater_get_type (void) G_GNUC_CONST;
GType impostor_widget_get_type (void) G_GNUC_CONST;
#define MAIN_WIDGET_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_MAIN_WIDGET, MainWidgetPrivate))
enum  {
	MAIN_WIDGET_DUMMY_PROPERTY,
	MAIN_WIDGET_CUR_PAGE_ID
};
BundleHistory* bundle_history_new (gint size);
BundleHistory* bundle_history_construct (GType object_type, gint size);
DeltaUpdater* delta_updater_new (void);
DeltaUpdater* delta_updater_construct (GType object_type);
ImpostorWidget* impostor_widget_new (void);
ImpostorWidget* impostor_widget_construct (GType object_type);
GType corebird_get_type (void) G_GNUC_CONST;
MainWidget* main_widget_new (Account* account, MainWindow* parent, Corebird* app);
MainWidget* main_widget_construct (GType object_type, Account* account, MainWindow* parent, Corebird* app);
void corebird_start_account (Corebird* self, Account* acc);
GType page_get_type (void) G_GNUC_CONST;
HomeTimeline* home_timeline_new (gint id, Account* account);
HomeTimeline* home_timeline_construct (GType object_type, gint id, Account* account);
GType scroll_widget_get_type (void) G_GNUC_CONST;
GType default_timeline_get_type (void) G_GNUC_CONST;
GType home_timeline_get_type (void) G_GNUC_CONST;
MentionsTimeline* mentions_timeline_new (gint id, Account* account);
MentionsTimeline* mentions_timeline_construct (GType object_type, gint id, Account* account);
GType mentions_timeline_get_type (void) G_GNUC_CONST;
FavoritesTimeline* favorites_timeline_new (gint id, Account* account);
FavoritesTimeline* favorites_timeline_construct (GType object_type, gint id, Account* account);
GType favorites_timeline_get_type (void) G_GNUC_CONST;
DMThreadsPage* dm_threads_page_new (gint id, Account* account, DeltaUpdater* delta_updater);
DMThreadsPage* dm_threads_page_construct (GType object_type, gint id, Account* account, DeltaUpdater* delta_updater);
GType dm_threads_page_get_type (void) G_GNUC_CONST;
ListsPage* lists_page_new (gint id, Account* account);
ListsPage* lists_page_construct (GType object_type, gint id, Account* account);
GType lists_page_get_type (void) G_GNUC_CONST;
FilterPage* filter_page_new (gint id, Account* account);
FilterPage* filter_page_construct (GType object_type, gint id, Account* account);
GType filter_page_get_type (void) G_GNUC_CONST;
SearchPage* search_page_new (gint id, Account* account, DeltaUpdater* delta_updater);
SearchPage* search_page_construct (GType object_type, gint id, Account* account, DeltaUpdater* delta_updater);
GType search_page_get_type (void) G_GNUC_CONST;
ProfilePage* profile_page_new (gint id, Account* account, DeltaUpdater* delta_updater);
ProfilePage* profile_page_construct (GType object_type, gint id, Account* account, DeltaUpdater* delta_updater);
GType profile_page_get_type (void) G_GNUC_CONST;
TweetInfoPage* tweet_info_page_new (gint id, Account* account, DeltaUpdater* delta_updater);
TweetInfoPage* tweet_info_page_construct (GType object_type, gint id, Account* account, DeltaUpdater* delta_updater);
GType tweet_info_page_get_type (void) G_GNUC_CONST;
DMPage* dm_page_new (gint id, Account* account, DeltaUpdater* delta_updater);
DMPage* dm_page_construct (GType object_type, gint id, Account* account, DeltaUpdater* delta_updater);
GType dm_page_get_type (void) G_GNUC_CONST;
ListStatusesPage* list_statuses_page_new (gint id, Account* account, DeltaUpdater* delta_updater);
ListStatusesPage* list_statuses_page_construct (GType object_type, gint id, Account* account, DeltaUpdater* delta_updater);
GType list_statuses_page_get_type (void) G_GNUC_CONST;
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
void ipage_set_window (IPage* self, MainWindow* value);
GType stream_message_type_get_type (void) G_GNUC_CONST;
GType imessage_receiver_get_type (void) G_GNUC_CONST;
GType sql_database_get_type (void) G_GNUC_CONST;
GType user_stream_get_type (void) G_GNUC_CONST;
GType notification_manager_get_type (void) G_GNUC_CONST;
void user_stream_register (UserStream* self, IMessageReceiver* receiver);
void ipage_create_radio_button (IPage* self, GtkRadioButton* group);
GtkRadioButton* ipage_get_radio_button (IPage* self);
static void ______lambda183_ (Block2Data* _data2_);
void main_widget_switch_page (MainWidget* self, gint page_id, Bundle* args);
gint ipage_get_id (IPage* self);
static void _______lambda183__gtk_button_clicked (GtkButton* _sender, gpointer self);
void default_timeline_set_delta_updater (DefaultTimeline* self, DeltaUpdater* value);
GSettings* settings_get (void);
gint bundle_history_get_current (BundleHistory* self);
gboolean ipage_handles_double_open (IPage* self);
void ipage_double_open (IPage* self);
Bundle* bundle_history_get_current_bundle (BundleHistory* self);
gboolean bundle_equals (Bundle* self, Bundle* other);
gboolean bundle_history_at_start (BundleHistory* self);
gint bundle_history_back (BundleHistory* self);
gboolean bundle_history_at_end (BundleHistory* self);
gint bundle_history_forward (BundleHistory* self);
void impostor_widget_clone (ImpostorWidget* self, GtkWidget* widget);
void ipage_on_leave (IPage* self);
void bundle_history_push (BundleHistory* self, gint v, Bundle* b);
void ipage_on_join (IPage* self, gint page_id, Bundle* args);
void main_window_set_window_title (MainWindow* self, const gchar* title, GtkStackTransitionType transition_type);
gchar* ipage_get_title (IPage* self);
void main_widget_remove_current_page (MainWidget* self);
void bundle_history_remove_current (BundleHistory* self);
IPage* main_widget_get_page (MainWidget* self, gint page_id);
void main_widget_stop (MainWidget* self);
void user_stream_unregister (UserStream* self, IMessageReceiver* receiver);
void corebird_stop_account (Corebird* self, Account* acc);
gint main_widget_get_cur_page_id (MainWidget* self);
static void main_widget_finalize (GObject* obj);
static void _vala_main_widget_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static Block2Data* block2_data_ref (Block2Data* _data2_) {
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}


static void block2_data_unref (void * _userdata_) {
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		MainWidget* self;
		self = _data2_->self;
		_g_object_unref0 (_data2_->page);
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void ______lambda183_ (Block2Data* _data2_) {
	MainWidget* self;
	gboolean _tmp0_ = FALSE;
	IPage* _tmp1_ = NULL;
	GtkRadioButton* _tmp2_ = NULL;
	GtkRadioButton* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	self = _data2_->self;
	_tmp1_ = _data2_->page;
	_tmp2_ = ipage_get_radio_button (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = gtk_toggle_button_get_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_toggle_button_get_type (), GtkToggleButton));
	_tmp5_ = _tmp4_;
	_tmp6_ = _tmp5_;
	_g_object_unref0 (_tmp3_);
	if (_tmp6_) {
		gboolean _tmp7_ = FALSE;
		_tmp7_ = self->priv->page_switch_lock;
		_tmp0_ = !_tmp7_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		IPage* _tmp8_ = NULL;
		gint _tmp9_ = 0;
		gint _tmp10_ = 0;
		_tmp8_ = _data2_->page;
		_tmp9_ = ipage_get_id (_tmp8_);
		_tmp10_ = _tmp9_;
		main_widget_switch_page (self, _tmp10_, NULL);
	}
}


static void _______lambda183__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	______lambda183_ (self);
}


MainWidget* main_widget_construct (GType object_type, Account* account, MainWindow* parent, Corebird* app) {
	MainWidget * self = NULL;
	Account* _tmp0_ = NULL;
	Corebird* _tmp1_ = NULL;
	Account* _tmp2_ = NULL;
	GtkStack* _tmp3_ = NULL;
	ImpostorWidget* _tmp4_ = NULL;
	IPage** _tmp5_ = NULL;
	IPage** _tmp6_ = NULL;
	gint _tmp6__length1 = 0;
	Account* _tmp7_ = NULL;
	HomeTimeline* _tmp8_ = NULL;
	IPage* _tmp9_ = NULL;
	IPage** _tmp10_ = NULL;
	gint _tmp10__length1 = 0;
	Account* _tmp11_ = NULL;
	MentionsTimeline* _tmp12_ = NULL;
	IPage* _tmp13_ = NULL;
	IPage** _tmp14_ = NULL;
	gint _tmp14__length1 = 0;
	Account* _tmp15_ = NULL;
	FavoritesTimeline* _tmp16_ = NULL;
	IPage* _tmp17_ = NULL;
	IPage** _tmp18_ = NULL;
	gint _tmp18__length1 = 0;
	Account* _tmp19_ = NULL;
	DeltaUpdater* _tmp20_ = NULL;
	DMThreadsPage* _tmp21_ = NULL;
	IPage* _tmp22_ = NULL;
	IPage** _tmp23_ = NULL;
	gint _tmp23__length1 = 0;
	Account* _tmp24_ = NULL;
	ListsPage* _tmp25_ = NULL;
	IPage* _tmp26_ = NULL;
	IPage** _tmp27_ = NULL;
	gint _tmp27__length1 = 0;
	Account* _tmp28_ = NULL;
	FilterPage* _tmp29_ = NULL;
	IPage* _tmp30_ = NULL;
	IPage** _tmp31_ = NULL;
	gint _tmp31__length1 = 0;
	Account* _tmp32_ = NULL;
	DeltaUpdater* _tmp33_ = NULL;
	SearchPage* _tmp34_ = NULL;
	IPage* _tmp35_ = NULL;
	IPage** _tmp36_ = NULL;
	gint _tmp36__length1 = 0;
	Account* _tmp37_ = NULL;
	DeltaUpdater* _tmp38_ = NULL;
	ProfilePage* _tmp39_ = NULL;
	IPage* _tmp40_ = NULL;
	IPage** _tmp41_ = NULL;
	gint _tmp41__length1 = 0;
	Account* _tmp42_ = NULL;
	DeltaUpdater* _tmp43_ = NULL;
	TweetInfoPage* _tmp44_ = NULL;
	IPage* _tmp45_ = NULL;
	IPage** _tmp46_ = NULL;
	gint _tmp46__length1 = 0;
	Account* _tmp47_ = NULL;
	DeltaUpdater* _tmp48_ = NULL;
	DMPage* _tmp49_ = NULL;
	IPage* _tmp50_ = NULL;
	IPage** _tmp51_ = NULL;
	gint _tmp51__length1 = 0;
	Account* _tmp52_ = NULL;
	DeltaUpdater* _tmp53_ = NULL;
	ListStatusesPage* _tmp54_ = NULL;
	IPage* _tmp55_ = NULL;
	GSettings* _tmp90_ = NULL;
	GSettings* _tmp91_ = NULL;
	GtkRevealer* _tmp92_ = NULL;
	g_return_val_if_fail (IS_ACCOUNT (account), NULL);
	g_return_val_if_fail (IS_MAIN_WINDOW (parent), NULL);
	g_return_val_if_fail (IS_COREBIRD (app), NULL);
	self = (MainWidget*) g_object_new (object_type, NULL);
	_tmp0_ = account;
	self->priv->account = _tmp0_;
	_tmp1_ = app;
	_tmp2_ = account;
	corebird_start_account (_tmp1_, _tmp2_);
	_tmp3_ = self->priv->stack;
	_tmp4_ = self->priv->stack_impostor;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_widget_get_type (), GtkWidget));
	_tmp5_ = g_new0 (IPage*, 11 + 1);
	self->priv->pages = (_vala_array_free (self->priv->pages, self->priv->pages_length1, (GDestroyNotify) g_object_unref), NULL);
	self->priv->pages = _tmp5_;
	self->priv->pages_length1 = 11;
	self->priv->_pages_size_ = self->priv->pages_length1;
	_tmp6_ = self->priv->pages;
	_tmp6__length1 = self->priv->pages_length1;
	_tmp7_ = account;
	_tmp8_ = home_timeline_new ((gint) PAGE_STREAM, _tmp7_);
	g_object_ref_sink (_tmp8_);
	_g_object_unref0 (_tmp6_[0]);
	_tmp6_[0] = G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, TYPE_IPAGE, IPage);
	_tmp9_ = _tmp6_[0];
	_tmp10_ = self->priv->pages;
	_tmp10__length1 = self->priv->pages_length1;
	_tmp11_ = account;
	_tmp12_ = mentions_timeline_new ((gint) PAGE_MENTIONS, _tmp11_);
	g_object_ref_sink (_tmp12_);
	_g_object_unref0 (_tmp10_[1]);
	_tmp10_[1] = G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, TYPE_IPAGE, IPage);
	_tmp13_ = _tmp10_[1];
	_tmp14_ = self->priv->pages;
	_tmp14__length1 = self->priv->pages_length1;
	_tmp15_ = account;
	_tmp16_ = favorites_timeline_new ((gint) PAGE_FAVORITES, _tmp15_);
	g_object_ref_sink (_tmp16_);
	_g_object_unref0 (_tmp14_[2]);
	_tmp14_[2] = G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, TYPE_IPAGE, IPage);
	_tmp17_ = _tmp14_[2];
	_tmp18_ = self->priv->pages;
	_tmp18__length1 = self->priv->pages_length1;
	_tmp19_ = account;
	_tmp20_ = self->priv->delta_updater;
	_tmp21_ = dm_threads_page_new ((gint) PAGE_DM_THREADS, _tmp19_, _tmp20_);
	g_object_ref_sink (_tmp21_);
	_g_object_unref0 (_tmp18_[3]);
	_tmp18_[3] = G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, TYPE_IPAGE, IPage);
	_tmp22_ = _tmp18_[3];
	_tmp23_ = self->priv->pages;
	_tmp23__length1 = self->priv->pages_length1;
	_tmp24_ = account;
	_tmp25_ = lists_page_new ((gint) PAGE_LISTS, _tmp24_);
	g_object_ref_sink (_tmp25_);
	_g_object_unref0 (_tmp23_[4]);
	_tmp23_[4] = G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, TYPE_IPAGE, IPage);
	_tmp26_ = _tmp23_[4];
	_tmp27_ = self->priv->pages;
	_tmp27__length1 = self->priv->pages_length1;
	_tmp28_ = account;
	_tmp29_ = filter_page_new ((gint) PAGE_FILTERS, _tmp28_);
	g_object_ref_sink (_tmp29_);
	_g_object_unref0 (_tmp27_[5]);
	_tmp27_[5] = G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, TYPE_IPAGE, IPage);
	_tmp30_ = _tmp27_[5];
	_tmp31_ = self->priv->pages;
	_tmp31__length1 = self->priv->pages_length1;
	_tmp32_ = account;
	_tmp33_ = self->priv->delta_updater;
	_tmp34_ = search_page_new ((gint) PAGE_SEARCH, _tmp32_, _tmp33_);
	g_object_ref_sink (_tmp34_);
	_g_object_unref0 (_tmp31_[6]);
	_tmp31_[6] = G_TYPE_CHECK_INSTANCE_CAST (_tmp34_, TYPE_IPAGE, IPage);
	_tmp35_ = _tmp31_[6];
	_tmp36_ = self->priv->pages;
	_tmp36__length1 = self->priv->pages_length1;
	_tmp37_ = account;
	_tmp38_ = self->priv->delta_updater;
	_tmp39_ = profile_page_new ((gint) PAGE_PROFILE, _tmp37_, _tmp38_);
	g_object_ref_sink (_tmp39_);
	_g_object_unref0 (_tmp36_[7]);
	_tmp36_[7] = G_TYPE_CHECK_INSTANCE_CAST (_tmp39_, TYPE_IPAGE, IPage);
	_tmp40_ = _tmp36_[7];
	_tmp41_ = self->priv->pages;
	_tmp41__length1 = self->priv->pages_length1;
	_tmp42_ = account;
	_tmp43_ = self->priv->delta_updater;
	_tmp44_ = tweet_info_page_new ((gint) PAGE_TWEET_INFO, _tmp42_, _tmp43_);
	g_object_ref_sink (_tmp44_);
	_g_object_unref0 (_tmp41_[8]);
	_tmp41_[8] = G_TYPE_CHECK_INSTANCE_CAST (_tmp44_, TYPE_IPAGE, IPage);
	_tmp45_ = _tmp41_[8];
	_tmp46_ = self->priv->pages;
	_tmp46__length1 = self->priv->pages_length1;
	_tmp47_ = account;
	_tmp48_ = self->priv->delta_updater;
	_tmp49_ = dm_page_new ((gint) PAGE_DM, _tmp47_, _tmp48_);
	g_object_ref_sink (_tmp49_);
	_g_object_unref0 (_tmp46_[9]);
	_tmp46_[9] = G_TYPE_CHECK_INSTANCE_CAST (_tmp49_, TYPE_IPAGE, IPage);
	_tmp50_ = _tmp46_[9];
	_tmp51_ = self->priv->pages;
	_tmp51__length1 = self->priv->pages_length1;
	_tmp52_ = account;
	_tmp53_ = self->priv->delta_updater;
	_tmp54_ = list_statuses_page_new ((gint) PAGE_LIST_STATUSES, _tmp52_, _tmp53_);
	g_object_ref_sink (_tmp54_);
	_g_object_unref0 (_tmp51_[10]);
	_tmp51_[10] = G_TYPE_CHECK_INSTANCE_CAST (_tmp54_, TYPE_IPAGE, IPage);
	_tmp55_ = _tmp51_[10];
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp56_ = FALSE;
			_tmp56_ = TRUE;
			while (TRUE) {
				Block2Data* _data2_;
				gint _tmp58_ = 0;
				IPage** _tmp59_ = NULL;
				gint _tmp59__length1 = 0;
				IPage** _tmp60_ = NULL;
				gint _tmp60__length1 = 0;
				gint _tmp61_ = 0;
				IPage* _tmp62_ = NULL;
				IPage* _tmp63_ = NULL;
				IPage* _tmp64_ = NULL;
				MainWindow* _tmp65_ = NULL;
				IPage* _tmp66_ = NULL;
				IPage* _tmp70_ = NULL;
				GtkRadioButton* _tmp71_ = NULL;
				GtkStack* _tmp72_ = NULL;
				IPage* _tmp73_ = NULL;
				IPage* _tmp74_ = NULL;
				GtkRadioButton* _tmp75_ = NULL;
				GtkRadioButton* _tmp76_ = NULL;
				gboolean _tmp77_ = FALSE;
				IPage* _tmp85_ = NULL;
				DefaultTimeline* tl = NULL;
				IPage* _tmp86_ = NULL;
				DefaultTimeline* _tmp87_ = NULL;
				DefaultTimeline* _tmp88_ = NULL;
				DeltaUpdater* _tmp89_ = NULL;
				_data2_ = g_slice_new0 (Block2Data);
				_data2_->_ref_count_ = 1;
				_data2_->self = g_object_ref (self);
				if (!_tmp56_) {
					gint _tmp57_ = 0;
					_tmp57_ = i;
					i = _tmp57_ + 1;
				}
				_tmp56_ = FALSE;
				_tmp58_ = i;
				_tmp59_ = self->priv->pages;
				_tmp59__length1 = self->priv->pages_length1;
				if (!(_tmp58_ < _tmp59__length1)) {
					block2_data_unref (_data2_);
					_data2_ = NULL;
					break;
				}
				_tmp60_ = self->priv->pages;
				_tmp60__length1 = self->priv->pages_length1;
				_tmp61_ = i;
				_tmp62_ = _tmp60_[_tmp61_];
				_tmp63_ = _g_object_ref0 (_tmp62_);
				_data2_->page = _tmp63_;
				_tmp64_ = _data2_->page;
				_tmp65_ = parent;
				ipage_set_window (_tmp64_, _tmp65_);
				_tmp66_ = _data2_->page;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp66_, TYPE_IMESSAGE_RECEIVER)) {
					Account* _tmp67_ = NULL;
					UserStream* _tmp68_ = NULL;
					IPage* _tmp69_ = NULL;
					_tmp67_ = account;
					_tmp68_ = _tmp67_->user_stream;
					_tmp69_ = _data2_->page;
					user_stream_register (_tmp68_, G_TYPE_CHECK_INSTANCE_CAST (_tmp69_, TYPE_IMESSAGE_RECEIVER, IMessageReceiver));
				}
				_tmp70_ = _data2_->page;
				_tmp71_ = self->priv->dummy_button;
				ipage_create_radio_button (_tmp70_, _tmp71_);
				_tmp72_ = self->priv->stack;
				_tmp73_ = _data2_->page;
				gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp72_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp73_, gtk_widget_get_type (), GtkWidget));
				_tmp74_ = _data2_->page;
				_tmp75_ = ipage_get_radio_button (_tmp74_);
				_tmp76_ = _tmp75_;
				_tmp77_ = _tmp76_ != NULL;
				_g_object_unref0 (_tmp76_);
				if (_tmp77_) {
					GtkBox* _tmp78_ = NULL;
					IPage* _tmp79_ = NULL;
					GtkRadioButton* _tmp80_ = NULL;
					GtkRadioButton* _tmp81_ = NULL;
					IPage* _tmp82_ = NULL;
					GtkRadioButton* _tmp83_ = NULL;
					GtkRadioButton* _tmp84_ = NULL;
					_tmp78_ = self->priv->top_box;
					_tmp79_ = _data2_->page;
					_tmp80_ = ipage_get_radio_button (_tmp79_);
					_tmp81_ = _tmp80_;
					gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp78_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp81_, gtk_widget_get_type (), GtkWidget));
					_g_object_unref0 (_tmp81_);
					_tmp82_ = _data2_->page;
					_tmp83_ = ipage_get_radio_button (_tmp82_);
					_tmp84_ = _tmp83_;
					g_signal_connect_data (G_TYPE_CHECK_INSTANCE_CAST (_tmp84_, gtk_button_get_type (), GtkButton), "clicked", (GCallback) _______lambda183__gtk_button_clicked, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
					_g_object_unref0 (_tmp84_);
				}
				_tmp85_ = _data2_->page;
				if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp85_, TYPE_DEFAULT_TIMELINE)) {
					block2_data_unref (_data2_);
					_data2_ = NULL;
					continue;
				}
				_tmp86_ = _data2_->page;
				_tmp87_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp86_, TYPE_DEFAULT_TIMELINE, DefaultTimeline));
				tl = _tmp87_;
				_tmp88_ = tl;
				_tmp89_ = self->priv->delta_updater;
				default_timeline_set_delta_updater (_tmp88_, _tmp89_);
				_g_object_unref0 (tl);
				block2_data_unref (_data2_);
				_data2_ = NULL;
			}
		}
	}
	_tmp90_ = settings_get ();
	_tmp91_ = _tmp90_;
	_tmp92_ = self->priv->sidebar_revealer;
	g_settings_bind (_tmp91_, "sidebar-visible", G_TYPE_CHECK_INSTANCE_CAST (_tmp92_, G_TYPE_OBJECT, GObject), "reveal-child", G_SETTINGS_BIND_DEFAULT);
	_g_object_unref0 (_tmp91_);
	return self;
}


MainWidget* main_widget_new (Account* account, MainWindow* parent, Corebird* app) {
	return main_widget_construct (TYPE_MAIN_WIDGET, account, parent, app);
}


/**
   * Switches the window's main notebook to the given page.
   *
   * @param page_id The id of the page to switch to.
   *                See the Page.* constants.
   *
   */
void main_widget_switch_page (MainWidget* self, gint page_id, Bundle* args) {
	gint _tmp0_ = 0;
	BundleHistory* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gboolean push = FALSE;
	gboolean _tmp25_ = FALSE;
	gint _tmp26_ = 0;
	gint current_page = 0;
	BundleHistory* _tmp39_ = NULL;
	gint _tmp40_ = 0;
	gint _tmp41_ = 0;
	gint _tmp42_ = 0;
	gint _tmp58_ = 0;
	gint _tmp59_ = 0;
	gint _tmp72_ = 0;
	gboolean _tmp76_ = FALSE;
	IPage* page = NULL;
	IPage** _tmp80_ = NULL;
	gint _tmp80__length1 = 0;
	gint _tmp81_ = 0;
	IPage* _tmp82_ = NULL;
	IPage* _tmp83_ = NULL;
	GtkToggleButton* button = NULL;
	IPage* _tmp84_ = NULL;
	GtkRadioButton* _tmp85_ = NULL;
	GtkToggleButton* _tmp86_ = NULL;
	IPage* _tmp89_ = NULL;
	gint _tmp90_ = 0;
	Bundle* _tmp91_ = NULL;
	GtkStack* _tmp92_ = NULL;
	IPage** _tmp93_ = NULL;
	gint _tmp93__length1 = 0;
	gint _tmp94_ = 0;
	IPage* _tmp95_ = NULL;
	GtkContainer* _tmp96_ = NULL;
	GtkContainer* _tmp97_ = NULL;
	IPage* _tmp98_ = NULL;
	gchar* _tmp99_ = NULL;
	gchar* _tmp100_ = NULL;
	GtkStack* _tmp101_ = NULL;
	GtkStackTransitionType _tmp102_ = 0;
	GtkStackTransitionType _tmp103_ = 0;
	GtkContainer* _tmp104_ = NULL;
	GtkContainer* _tmp105_ = NULL;
	GtkButton* _tmp106_ = NULL;
	BundleHistory* _tmp107_ = NULL;
	gboolean _tmp108_ = FALSE;
	g_return_if_fail (IS_MAIN_WIDGET (self));
	g_return_if_fail ((args == NULL) || IS_BUNDLE (args));
	_tmp0_ = page_id;
	_tmp1_ = self->priv->history;
	_tmp2_ = bundle_history_get_current (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp0_ == _tmp3_) {
		IPage** _tmp4_ = NULL;
		gint _tmp4__length1 = 0;
		gint _tmp5_ = 0;
		IPage* _tmp6_ = NULL;
		gboolean _tmp7_ = FALSE;
		gboolean _tmp11_ = FALSE;
		gboolean _tmp12_ = FALSE;
		BundleHistory* _tmp13_ = NULL;
		Bundle* _tmp14_ = NULL;
		Bundle* _tmp15_ = NULL;
		_tmp4_ = self->priv->pages;
		_tmp4__length1 = self->priv->pages_length1;
		_tmp5_ = page_id;
		_tmp6_ = _tmp4_[_tmp5_];
		_tmp7_ = ipage_handles_double_open (_tmp6_);
		if (_tmp7_) {
			IPage** _tmp8_ = NULL;
			gint _tmp8__length1 = 0;
			gint _tmp9_ = 0;
			IPage* _tmp10_ = NULL;
			_tmp8_ = self->priv->pages;
			_tmp8__length1 = self->priv->pages_length1;
			_tmp9_ = page_id;
			_tmp10_ = _tmp8_[_tmp9_];
			ipage_double_open (_tmp10_);
		}
		_tmp13_ = self->priv->history;
		_tmp14_ = bundle_history_get_current_bundle (_tmp13_);
		_tmp15_ = _tmp14_;
		if (_tmp15_ != NULL) {
			BundleHistory* _tmp16_ = NULL;
			Bundle* _tmp17_ = NULL;
			Bundle* _tmp18_ = NULL;
			Bundle* _tmp19_ = NULL;
			gboolean _tmp20_ = FALSE;
			_tmp16_ = self->priv->history;
			_tmp17_ = bundle_history_get_current_bundle (_tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = args;
			_tmp20_ = bundle_equals (_tmp18_, _tmp19_);
			_tmp12_ = _tmp20_;
		} else {
			_tmp12_ = FALSE;
		}
		if (_tmp12_) {
			_tmp11_ = TRUE;
		} else {
			BundleHistory* _tmp21_ = NULL;
			Bundle* _tmp22_ = NULL;
			Bundle* _tmp23_ = NULL;
			Bundle* _tmp24_ = NULL;
			_tmp21_ = self->priv->history;
			_tmp22_ = bundle_history_get_current_bundle (_tmp21_);
			_tmp23_ = _tmp22_;
			_tmp24_ = args;
			_tmp11_ = _tmp23_ == _tmp24_;
		}
		if (_tmp11_) {
			return;
		}
	}
	push = TRUE;
	_tmp26_ = page_id;
	if (_tmp26_ == ((gint) PAGE_PREVIOUS)) {
		_tmp25_ = TRUE;
	} else {
		gint _tmp27_ = 0;
		BundleHistory* _tmp28_ = NULL;
		gint _tmp29_ = 0;
		gint _tmp30_ = 0;
		_tmp27_ = page_id;
		_tmp28_ = self->priv->history;
		_tmp29_ = bundle_history_get_current (_tmp28_);
		_tmp30_ = _tmp29_;
		_tmp25_ = _tmp27_ < _tmp30_;
	}
	if (_tmp25_) {
		GtkStack* _tmp31_ = NULL;
		_tmp31_ = self->priv->stack;
		gtk_stack_set_transition_type (_tmp31_, GTK_STACK_TRANSITION_TYPE_SLIDE_RIGHT);
	} else {
		gboolean _tmp32_ = FALSE;
		gint _tmp33_ = 0;
		_tmp33_ = page_id;
		if (_tmp33_ == ((gint) PAGE_NEXT)) {
			_tmp32_ = TRUE;
		} else {
			gint _tmp34_ = 0;
			BundleHistory* _tmp35_ = NULL;
			gint _tmp36_ = 0;
			gint _tmp37_ = 0;
			_tmp34_ = page_id;
			_tmp35_ = self->priv->history;
			_tmp36_ = bundle_history_get_current (_tmp35_);
			_tmp37_ = _tmp36_;
			_tmp32_ = _tmp34_ > _tmp37_;
		}
		if (_tmp32_) {
			GtkStack* _tmp38_ = NULL;
			_tmp38_ = self->priv->stack;
			gtk_stack_set_transition_type (_tmp38_, GTK_STACK_TRANSITION_TYPE_SLIDE_LEFT);
		}
	}
	_tmp39_ = self->priv->history;
	_tmp40_ = bundle_history_get_current (_tmp39_);
	_tmp41_ = _tmp40_;
	current_page = _tmp41_;
	_tmp42_ = page_id;
	if (_tmp42_ == ((gint) PAGE_PREVIOUS)) {
		BundleHistory* _tmp43_ = NULL;
		gboolean _tmp44_ = FALSE;
		BundleHistory* _tmp45_ = NULL;
		gint _tmp46_ = 0;
		BundleHistory* _tmp47_ = NULL;
		Bundle* _tmp48_ = NULL;
		Bundle* _tmp49_ = NULL;
		_tmp43_ = self->priv->history;
		_tmp44_ = bundle_history_at_start (_tmp43_);
		if (_tmp44_) {
			return;
		}
		push = FALSE;
		_tmp45_ = self->priv->history;
		_tmp46_ = bundle_history_back (_tmp45_);
		page_id = _tmp46_;
		_tmp47_ = self->priv->history;
		_tmp48_ = bundle_history_get_current_bundle (_tmp47_);
		_tmp49_ = _tmp48_;
		args = _tmp49_;
	} else {
		gint _tmp50_ = 0;
		_tmp50_ = page_id;
		if (_tmp50_ == ((gint) PAGE_NEXT)) {
			BundleHistory* _tmp51_ = NULL;
			gboolean _tmp52_ = FALSE;
			BundleHistory* _tmp53_ = NULL;
			gint _tmp54_ = 0;
			BundleHistory* _tmp55_ = NULL;
			Bundle* _tmp56_ = NULL;
			Bundle* _tmp57_ = NULL;
			_tmp51_ = self->priv->history;
			_tmp52_ = bundle_history_at_end (_tmp51_);
			if (_tmp52_) {
				return;
			}
			push = FALSE;
			_tmp53_ = self->priv->history;
			_tmp54_ = bundle_history_forward (_tmp53_);
			page_id = _tmp54_;
			_tmp55_ = self->priv->history;
			_tmp56_ = bundle_history_get_current_bundle (_tmp55_);
			_tmp57_ = _tmp56_;
			args = _tmp57_;
		}
	}
	_tmp58_ = page_id;
	_tmp59_ = current_page;
	if (_tmp58_ == _tmp59_) {
		ImpostorWidget* _tmp60_ = NULL;
		IPage** _tmp61_ = NULL;
		gint _tmp61__length1 = 0;
		gint _tmp62_ = 0;
		IPage* _tmp63_ = NULL;
		GtkStackTransitionType transition_type = 0;
		GtkStack* _tmp64_ = NULL;
		GtkStackTransitionType _tmp65_ = 0;
		GtkStackTransitionType _tmp66_ = 0;
		GtkStack* _tmp67_ = NULL;
		GtkStack* _tmp68_ = NULL;
		ImpostorWidget* _tmp69_ = NULL;
		GtkStack* _tmp70_ = NULL;
		GtkStackTransitionType _tmp71_ = 0;
		_tmp60_ = self->priv->stack_impostor;
		_tmp61_ = self->priv->pages;
		_tmp61__length1 = self->priv->pages_length1;
		_tmp62_ = page_id;
		_tmp63_ = _tmp61_[_tmp62_];
		impostor_widget_clone (_tmp60_, G_TYPE_CHECK_INSTANCE_CAST (_tmp63_, gtk_widget_get_type (), GtkWidget));
		_tmp64_ = self->priv->stack;
		_tmp65_ = gtk_stack_get_transition_type (_tmp64_);
		_tmp66_ = _tmp65_;
		transition_type = _tmp66_;
		_tmp67_ = self->priv->stack;
		gtk_stack_set_transition_type (_tmp67_, GTK_STACK_TRANSITION_TYPE_NONE);
		_tmp68_ = self->priv->stack;
		_tmp69_ = self->priv->stack_impostor;
		gtk_stack_set_visible_child (_tmp68_, G_TYPE_CHECK_INSTANCE_CAST (_tmp69_, gtk_widget_get_type (), GtkWidget));
		_tmp70_ = self->priv->stack;
		_tmp71_ = transition_type;
		gtk_stack_set_transition_type (_tmp70_, _tmp71_);
	}
	_tmp72_ = current_page;
	if (_tmp72_ != -1) {
		IPage** _tmp73_ = NULL;
		gint _tmp73__length1 = 0;
		gint _tmp74_ = 0;
		IPage* _tmp75_ = NULL;
		_tmp73_ = self->priv->pages;
		_tmp73__length1 = self->priv->pages_length1;
		_tmp74_ = current_page;
		_tmp75_ = _tmp73_[_tmp74_];
		ipage_on_leave (_tmp75_);
	}
	_tmp76_ = push;
	if (_tmp76_) {
		BundleHistory* _tmp77_ = NULL;
		gint _tmp78_ = 0;
		Bundle* _tmp79_ = NULL;
		_tmp77_ = self->priv->history;
		_tmp78_ = page_id;
		_tmp79_ = args;
		bundle_history_push (_tmp77_, _tmp78_, _tmp79_);
	}
	_tmp80_ = self->priv->pages;
	_tmp80__length1 = self->priv->pages_length1;
	_tmp81_ = page_id;
	_tmp82_ = _tmp80_[_tmp81_];
	_tmp83_ = _g_object_ref0 (_tmp82_);
	page = _tmp83_;
	_tmp84_ = page;
	_tmp85_ = ipage_get_radio_button (_tmp84_);
	button = G_TYPE_CHECK_INSTANCE_CAST (_tmp85_, gtk_toggle_button_get_type (), GtkToggleButton);
	self->priv->page_switch_lock = TRUE;
	_tmp86_ = button;
	if (_tmp86_ != NULL) {
		GtkToggleButton* _tmp87_ = NULL;
		_tmp87_ = button;
		gtk_toggle_button_set_active (_tmp87_, TRUE);
	} else {
		GtkRadioButton* _tmp88_ = NULL;
		_tmp88_ = self->priv->dummy_button;
		gtk_toggle_button_set_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp88_, gtk_toggle_button_get_type (), GtkToggleButton), TRUE);
	}
	_tmp89_ = page;
	_tmp90_ = page_id;
	_tmp91_ = args;
	ipage_on_join (_tmp89_, _tmp90_, _tmp91_);
	_tmp92_ = self->priv->stack;
	_tmp93_ = self->priv->pages;
	_tmp93__length1 = self->priv->pages_length1;
	_tmp94_ = page_id;
	_tmp95_ = _tmp93_[_tmp94_];
	gtk_stack_set_visible_child (_tmp92_, G_TYPE_CHECK_INSTANCE_CAST (_tmp95_, gtk_widget_get_type (), GtkWidget));
	_tmp96_ = gtk_widget_get_parent (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	_tmp97_ = _tmp96_;
	_tmp98_ = page;
	_tmp99_ = ipage_get_title (_tmp98_);
	_tmp100_ = _tmp99_;
	_tmp101_ = self->priv->stack;
	_tmp102_ = gtk_stack_get_transition_type (_tmp101_);
	_tmp103_ = _tmp102_;
	main_window_set_window_title (G_TYPE_CHECK_INSTANCE_CAST (_tmp97_, TYPE_MAIN_WINDOW, MainWindow), _tmp100_, _tmp103_);
	_g_free0 (_tmp100_);
	self->priv->page_switch_lock = FALSE;
	_tmp104_ = gtk_widget_get_parent (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	_tmp105_ = _tmp104_;
	_tmp106_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp105_, TYPE_MAIN_WINDOW, MainWindow)->back_button;
	_tmp107_ = self->priv->history;
	_tmp108_ = bundle_history_at_start (_tmp107_);
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp106_, gtk_widget_get_type (), GtkWidget), !_tmp108_);
	_g_object_unref0 (button);
	_g_object_unref0 (page);
}


void main_widget_remove_current_page (MainWidget* self) {
	BundleHistory* _tmp0_ = NULL;
	g_return_if_fail (IS_MAIN_WIDGET (self));
	_tmp0_ = self->priv->history;
	bundle_history_remove_current (_tmp0_);
	main_widget_switch_page (self, (gint) PAGE_PREVIOUS, NULL);
}


IPage* main_widget_get_page (MainWidget* self, gint page_id) {
	IPage* result = NULL;
	IPage** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gint _tmp1_ = 0;
	IPage* _tmp2_ = NULL;
	IPage* _tmp3_ = NULL;
	g_return_val_if_fail (IS_MAIN_WIDGET (self), NULL);
	_tmp0_ = self->priv->pages;
	_tmp0__length1 = self->priv->pages_length1;
	_tmp1_ = page_id;
	_tmp2_ = _tmp0_[_tmp1_];
	_tmp3_ = _g_object_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}


void main_widget_stop (MainWidget* self) {
	GApplication* _tmp12_ = NULL;
	Account* _tmp13_ = NULL;
	g_return_if_fail (IS_MAIN_WIDGET (self));
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_ = 0;
				IPage** _tmp3_ = NULL;
				gint _tmp3__length1 = 0;
				IPage* page = NULL;
				IPage** _tmp4_ = NULL;
				gint _tmp4__length1 = 0;
				gint _tmp5_ = 0;
				IPage* _tmp6_ = NULL;
				IPage* _tmp7_ = NULL;
				IPage* _tmp8_ = NULL;
				if (!_tmp0_) {
					gint _tmp1_ = 0;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				_tmp3_ = self->priv->pages;
				_tmp3__length1 = self->priv->pages_length1;
				if (!(_tmp2_ < _tmp3__length1)) {
					break;
				}
				_tmp4_ = self->priv->pages;
				_tmp4__length1 = self->priv->pages_length1;
				_tmp5_ = i;
				_tmp6_ = _tmp4_[_tmp5_];
				_tmp7_ = _g_object_ref0 (_tmp6_);
				page = _tmp7_;
				_tmp8_ = page;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, TYPE_IMESSAGE_RECEIVER)) {
					Account* _tmp9_ = NULL;
					UserStream* _tmp10_ = NULL;
					IPage* _tmp11_ = NULL;
					_tmp9_ = self->priv->account;
					_tmp10_ = _tmp9_->user_stream;
					_tmp11_ = page;
					user_stream_unregister (_tmp10_, G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, TYPE_IMESSAGE_RECEIVER, IMessageReceiver));
				}
				_g_object_unref0 (page);
			}
		}
	}
	_tmp12_ = g_application_get_default ();
	_tmp13_ = self->priv->account;
	corebird_stop_account (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, TYPE_COREBIRD, Corebird), _tmp13_);
}


gint main_widget_get_cur_page_id (MainWidget* self) {
	gint result;
	BundleHistory* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	g_return_val_if_fail (IS_MAIN_WIDGET (self), 0);
	_tmp0_ = self->priv->history;
	_tmp1_ = bundle_history_get_current (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}


static void main_widget_class_init (MainWidgetClass * klass) {
	gint MainWidget_private_offset;
	main_widget_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (MainWidgetPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_main_widget_get_property;
	G_OBJECT_CLASS (klass)->finalize = main_widget_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAIN_WIDGET_CUR_PAGE_ID, g_param_spec_int ("cur-page-id", "cur-page-id", "cur-page-id", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	MainWidget_private_offset = g_type_class_get_instance_private_offset (klass);
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/baedert/corebird/ui/main-widget.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "top_box", FALSE, MainWidget_private_offset + G_STRUCT_OFFSET (MainWidgetPrivate, top_box));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "stack", FALSE, MainWidget_private_offset + G_STRUCT_OFFSET (MainWidgetPrivate, stack));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "sidebar_revealer", FALSE, MainWidget_private_offset + G_STRUCT_OFFSET (MainWidgetPrivate, sidebar_revealer));
}


static void main_widget_instance_init (MainWidget * self) {
	GtkRadioButton* _tmp0_ = NULL;
	BundleHistory* _tmp1_ = NULL;
	DeltaUpdater* _tmp2_ = NULL;
	ImpostorWidget* _tmp3_ = NULL;
	self->priv = MAIN_WIDGET_GET_PRIVATE (self);
	_tmp0_ = (GtkRadioButton*) gtk_radio_button_new (NULL);
	g_object_ref_sink (_tmp0_);
	self->priv->dummy_button = _tmp0_;
	_tmp1_ = bundle_history_new (5);
	self->priv->history = _tmp1_;
	_tmp2_ = delta_updater_new ();
	self->priv->delta_updater = _tmp2_;
	self->priv->page_switch_lock = FALSE;
	_tmp3_ = impostor_widget_new ();
	g_object_ref_sink (_tmp3_);
	self->priv->stack_impostor = _tmp3_;
	gtk_widget_init_template (GTK_WIDGET (self));
}


static void main_widget_finalize (GObject* obj) {
	MainWidget * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MAIN_WIDGET, MainWidget);
	_g_object_unref0 (self->priv->dummy_button);
	self->priv->pages = (_vala_array_free (self->priv->pages, self->priv->pages_length1, (GDestroyNotify) g_object_unref), NULL);
	_bundle_history_unref0 (self->priv->history);
	_g_object_unref0 (self->priv->delta_updater);
	_g_object_unref0 (self->priv->stack_impostor);
	_g_object_unref0 (self->priv->top_box);
	_g_object_unref0 (self->priv->stack);
	_g_object_unref0 (self->priv->sidebar_revealer);
	G_OBJECT_CLASS (main_widget_parent_class)->finalize (obj);
}


GType main_widget_get_type (void) {
	static volatile gsize main_widget_type_id__volatile = 0;
	if (g_once_init_enter (&main_widget_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MainWidgetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) main_widget_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MainWidget), 0, (GInstanceInitFunc) main_widget_instance_init, NULL };
		GType main_widget_type_id;
		main_widget_type_id = g_type_register_static (gtk_box_get_type (), "MainWidget", &g_define_type_info, 0);
		g_once_init_leave (&main_widget_type_id__volatile, main_widget_type_id);
	}
	return main_widget_type_id__volatile;
}


static void _vala_main_widget_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	MainWidget * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_MAIN_WIDGET, MainWidget);
	switch (property_id) {
		case MAIN_WIDGET_CUR_PAGE_ID:
		g_value_set_int (value, main_widget_get_cur_page_id (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



