/* ComposeJob.c generated by valac 0.34.6, the Vala compiler
 * generated from ComposeJob.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include "CbTweet.h"
#include <gio/gio.h>
#include <rest/rest-proxy.h>
#include <rest/rest-proxy-call.h>
#include <rest/rest-param.h>
#include <json-glib/json-glib.h>
#include <rest/oauth-proxy.h>
#include "CbUserCounter.h"
#include "CbFilter.h"
#include "CbTypes.h"
#include <gtk/gtk.h>


#define TYPE_COMPOSE_JOB (compose_job_get_type ())
#define COMPOSE_JOB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPOSE_JOB, ComposeJob))
#define COMPOSE_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPOSE_JOB, ComposeJobClass))
#define IS_COMPOSE_JOB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPOSE_JOB))
#define IS_COMPOSE_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPOSE_JOB))
#define COMPOSE_JOB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPOSE_JOB, ComposeJobClass))

typedef struct _ComposeJob ComposeJob;
typedef struct _ComposeJobClass ComposeJobClass;
typedef struct _ComposeJobPrivate ComposeJobPrivate;

#define TYPE_ACCOUNT (account_get_type ())
#define ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ACCOUNT, Account))
#define ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ACCOUNT, AccountClass))
#define IS_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ACCOUNT))
#define IS_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ACCOUNT))
#define ACCOUNT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ACCOUNT, AccountClass))

typedef struct _Account Account;
typedef struct _AccountClass AccountClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
#define _rest_param_unref0(var) ((var == NULL) ? NULL : (var = (rest_param_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _json_object_unref0(var) ((var == NULL) ? NULL : (var = (json_object_unref (var), NULL)))
typedef struct _ComposeJobUploadImageData ComposeJobUploadImageData;

#define TYPE_COLLECT (collect_get_type ())
#define COLLECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COLLECT, Collect))
#define COLLECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COLLECT, CollectClass))
#define IS_COLLECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COLLECT))
#define IS_COLLECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COLLECT))
#define COLLECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COLLECT, CollectClass))

typedef struct _Collect Collect;
typedef struct _CollectClass CollectClass;
typedef struct _Block82Data Block82Data;
typedef struct _AccountPrivate AccountPrivate;

#define SQL_TYPE_DATABASE (sql_database_get_type ())
#define SQL_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SQL_TYPE_DATABASE, SqlDatabase))
#define SQL_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SQL_TYPE_DATABASE, SqlDatabaseClass))
#define SQL_IS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SQL_TYPE_DATABASE))
#define SQL_IS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SQL_TYPE_DATABASE))
#define SQL_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SQL_TYPE_DATABASE, SqlDatabaseClass))

typedef struct _SqlDatabase SqlDatabase;
typedef struct _SqlDatabaseClass SqlDatabaseClass;

#define TYPE_USER_STREAM (user_stream_get_type ())
#define USER_STREAM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_USER_STREAM, UserStream))
#define USER_STREAM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_USER_STREAM, UserStreamClass))
#define IS_USER_STREAM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_USER_STREAM))
#define IS_USER_STREAM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_USER_STREAM))
#define USER_STREAM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_USER_STREAM, UserStreamClass))

typedef struct _UserStream UserStream;
typedef struct _UserStreamClass UserStreamClass;

#define TYPE_NOTIFICATION_MANAGER (notification_manager_get_type ())
#define NOTIFICATION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFICATION_MANAGER, NotificationManager))
#define NOTIFICATION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFICATION_MANAGER, NotificationManagerClass))
#define IS_NOTIFICATION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFICATION_MANAGER))
#define IS_NOTIFICATION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFICATION_MANAGER))
#define NOTIFICATION_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFICATION_MANAGER, NotificationManagerClass))

typedef struct _NotificationManager NotificationManager;
typedef struct _NotificationManagerClass NotificationManagerClass;
typedef struct _Block83Data Block83Data;
typedef struct _ComposeJobUploadImagesData ComposeJobUploadImagesData;
typedef struct _Block84Data Block84Data;
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
typedef struct _ComposeJobSendTweetData ComposeJobSendTweetData;
typedef struct _ComposeJobStartData ComposeJobStartData;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ComposeJob {
	GObject parent_instance;
	ComposeJobPrivate * priv;
	gchar* text;
	CbTweet* quoted_tweet;
	gint64* reply_id;
};

struct _ComposeJobClass {
	GObjectClass parent_class;
};

struct _ComposeJobPrivate {
	Account* account;
	GPtrArray* image_paths;
};

struct _ComposeJobUploadImageData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	ComposeJob* self;
	gchar* path;
	RestProxy* proxy;
	GCancellable* cancellable;
	gint64 result;
	RestProxyCall* call;
	RestProxy* _tmp0_;
	RestProxyCall* _tmp1_;
	RestProxyCall* _tmp2_;
	RestProxyCall* _tmp3_;
	guint8* file_contents;
	gint file_contents_length1;
	gint _file_contents_size_;
	GFile* media_file;
	const gchar* _tmp4_;
	GFile* _tmp5_;
	GFile* _tmp6_;
	guint8* _tmp7_;
	gsize _tmp8_;
	RestParam* param;
	guint8* _tmp9_;
	gint _tmp9__length1;
	const gchar* _tmp10_;
	RestParam* _tmp11_;
	RestProxyCall* _tmp12_;
	RestParam* _tmp13_;
	RestParam* _tmp14_;
	RestProxyCall* _tmp15_;
	GCancellable* _tmp16_;
	JsonParser* parser;
	JsonParser* _tmp17_;
	JsonParser* _tmp18_;
	RestProxyCall* _tmp19_;
	const gchar* _tmp20_;
	GError* e;
	GError* _tmp21_;
	const gchar* _tmp22_;
	GCancellable* _tmp23_;
	gboolean _tmp24_;
	JsonObject* root;
	JsonParser* _tmp25_;
	JsonNode* _tmp26_;
	JsonObject* _tmp27_;
	JsonObject* _tmp28_;
	JsonObject* _tmp29_;
	gint64 _tmp30_;
	GError * _inner_error_;
};

struct _Block82Data {
	int _ref_count_;
	ComposeJob* self;
	gint64* ids;
	gint ids_length1;
	gint _ids_size_;
	Collect* collect_obj;
	gpointer _async_data_;
};

struct _Account {
	GObject parent_instance;
	AccountPrivate * priv;
	gint64 id;
	SqlDatabase* db;
	OAuthProxy* proxy;
	UserStream* user_stream;
	CbUserCounter* user_counter;
	NotificationManager* notifications;
	gint64* friends;
	gint friends_length1;
	gint64* blocked;
	gint blocked_length1;
	gint64* muted;
	gint muted_length1;
	gint64* disabled_rts;
	gint disabled_rts_length1;
	GPtrArray* filters;
};

struct _AccountClass {
	GObjectClass parent_class;
};

struct _Block83Data {
	int _ref_count_;
	Block82Data * _data82_;
	gchar* path;
	gint index;
};

struct _ComposeJobUploadImagesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	ComposeJob* self;
	GCancellable* cancellable;
	gint64* result;
	gint result_length1;
	Block82Data* _data82_;
	GPtrArray* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	OAuthProxy* proxy;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	OAuthProxy* _tmp7_;
	OAuthProxy* _tmp8_;
	OAuthProxy* _tmp9_;
	Account* _tmp10_;
	OAuthProxy* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	OAuthProxy* _tmp14_;
	Account* _tmp15_;
	OAuthProxy* _tmp16_;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	GPtrArray* _tmp19_;
	gint _tmp20_;
	gint _tmp21_;
	gint64* _tmp22_;
	GPtrArray* _tmp23_;
	gint _tmp24_;
	gint _tmp25_;
	Collect* _tmp26_;
	Collect* _tmp27_;
	gint i;
	gboolean _tmp28_;
	Block83Data* _data83_;
	gint _tmp29_;
	gint _tmp30_;
	GPtrArray* _tmp31_;
	gint _tmp32_;
	gint _tmp33_;
	GPtrArray* _tmp34_;
	gint _tmp35_;
	gconstpointer _tmp36_;
	gchar* _tmp37_;
	const gchar* _tmp38_;
	const gchar* _tmp39_;
	gint _tmp40_;
	gint _tmp41_;
	const gchar* _tmp42_;
	OAuthProxy* _tmp43_;
	GCancellable* _tmp44_;
	GCancellable* _tmp45_;
	gboolean _tmp46_;
	gint64* _tmp47_;
	gint _tmp47__length1;
	gint64* _tmp48_;
	gint _tmp48__length1;
	gint64* _tmp49_;
	gint _tmp49__length1;
};

struct _Block84Data {
	int _ref_count_;
	ComposeJob* self;
	gboolean success;
	RestProxyCall* call;
	gpointer _async_data_;
};

struct _ComposeJobSendTweetData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	ComposeJob* self;
	gint64* media_ids;
	gint media_ids_length1;
	GCancellable* cancellable;
	gboolean result;
	Block84Data* _data84_;
	Account* _tmp0_;
	OAuthProxy* _tmp1_;
	RestProxyCall* _tmp2_;
	RestProxyCall* _tmp3_;
	RestProxyCall* _tmp4_;
	gint64* _tmp5_;
	RestProxyCall* _tmp6_;
	gint64* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	CbTweet* _tmp10_;
	CbMiniTweet* _tmp11_;
	CbTweet* _tmp12_;
	CbMiniTweet* _tmp13_;
	CbTweet* _tmp14_;
	CbMiniTweet _tmp15_;
	CbMiniTweet mt;
	CbMiniTweet _tmp16_;
	gchar* quoted_url;
	CbMiniTweet _tmp17_;
	CbUserIdentity _tmp18_;
	const gchar* _tmp19_;
	CbMiniTweet _tmp20_;
	gint64 _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	RestProxyCall* _tmp26_;
	const gchar* _tmp27_;
	RestProxyCall* _tmp28_;
	const gchar* _tmp29_;
	gboolean _tmp30_;
	gint64* _tmp31_;
	gint _tmp31__length1;
	gint64* _tmp32_;
	gint _tmp32__length1;
	GString* sb;
	GString* _tmp33_;
	GString* _tmp34_;
	gint64* _tmp35_;
	gint _tmp35__length1;
	gint64 _tmp36_;
	gchar* _tmp37_;
	gchar* _tmp38_;
	gint i;
	gboolean _tmp39_;
	gint _tmp40_;
	gint _tmp41_;
	gint64* _tmp42_;
	gint _tmp42__length1;
	GString* _tmp43_;
	GString* _tmp44_;
	gint64* _tmp45_;
	gint _tmp45__length1;
	gint _tmp46_;
	gint64 _tmp47_;
	gchar* _tmp48_;
	gchar* _tmp49_;
	GString* _tmp50_;
	const gchar* _tmp51_;
	RestProxyCall* _tmp52_;
	GString* _tmp53_;
	const gchar* _tmp54_;
	RestProxyCall* _tmp55_;
	GCancellable* _tmp56_;
	gboolean _tmp57_;
};

struct _ComposeJobStartData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	ComposeJob* self;
	GCancellable* cancellable;
	gboolean result;
	gint64* media_ids;
	gint media_ids_length1;
	gint _media_ids_size_;
	GPtrArray* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	GPtrArray* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	GCancellable* _tmp6_;
	gint _tmp7_;
	gint64* _tmp8_;
	gint64* _tmp9_;
	gint _tmp9__length1;
	gint64 _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	GCancellable* _tmp13_;
	gboolean _tmp14_;
	gboolean success;
	gint64* _tmp15_;
	gint _tmp15__length1;
	GCancellable* _tmp16_;
	gboolean _tmp17_;
};


static gpointer compose_job_parent_class = NULL;

GType compose_job_get_type (void) G_GNUC_CONST;
GType account_get_type (void) G_GNUC_CONST;
#define COMPOSE_JOB_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_COMPOSE_JOB, ComposeJobPrivate))
enum  {
	COMPOSE_JOB_DUMMY_PROPERTY
};
static void _g_free0_ (gpointer var);
ComposeJob* compose_job_new (Account* account);
ComposeJob* compose_job_construct (GType object_type, Account* account);
void compose_job_add_image (ComposeJob* self, const gchar* path);
static void compose_job_upload_image_data_free (gpointer _data);
static void compose_job_upload_image (ComposeJob* self, const gchar* path, RestProxy* proxy, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gint64 compose_job_upload_image_finish (ComposeJob* self, GAsyncResult* _res_, GError** error);
static gboolean compose_job_upload_image_co (ComposeJobUploadImageData* _data_);
static void compose_job_upload_image_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void compose_job_upload_images_data_free (gpointer _data);
static void compose_job_upload_images (ComposeJob* self, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gint64* compose_job_upload_images_finish (ComposeJob* self, GAsyncResult* _res_, int* result_length1);
static gboolean compose_job_upload_images_co (ComposeJobUploadImagesData* _data_);
GType collect_get_type (void) G_GNUC_CONST;
static Block82Data* block82_data_ref (Block82Data* _data82_);
static void block82_data_unref (void * _userdata_);
gchar* settings_get_consumer_key (void);
gchar* settings_get_consumer_secret (void);
GType sql_database_get_type (void) G_GNUC_CONST;
GType user_stream_get_type (void) G_GNUC_CONST;
GType notification_manager_get_type (void) G_GNUC_CONST;
Collect* collect_new (gint max);
Collect* collect_construct (GType object_type, gint max);
static void __lambda45_ (Block82Data* _data82_);
static void ___lambda45__collect_finished (Collect* _sender, GError* _error_, gpointer self);
static Block83Data* block83_data_ref (Block83Data* _data83_);
static void block83_data_unref (void * _userdata_);
static void _____lambda46_ (Block83Data* _data83_, GObject* obj, GAsyncResult* res);
void collect_emit (Collect* self, GError* _error_);
static void ______lambda46__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static gint64* _vala_array_dup8 (gint64* self, int length);
static void compose_job_send_tweet_data_free (gpointer _data);
static void compose_job_send_tweet (ComposeJob* self, gint64* media_ids, int media_ids_length1, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean compose_job_send_tweet_finish (ComposeJob* self, GAsyncResult* _res_);
static gboolean compose_job_send_tweet_co (ComposeJobSendTweetData* _data_);
static Block84Data* block84_data_ref (Block84Data* _data84_);
static void block84_data_unref (void * _userdata_);
static void __lambda47_ (Block84Data* _data84_, GObject* obj, GAsyncResult* res);
void utils_show_error_object (const gchar* json_data, const gchar* alternative, gint line, const gchar* file, GtkWindow* transient_for);
static void ___lambda47__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void compose_job_start_data_free (gpointer _data);
void compose_job_start (ComposeJob* self, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
gboolean compose_job_start_finish (ComposeJob* self, GAsyncResult* _res_);
static gboolean compose_job_start_co (ComposeJobStartData* _data_);
static void compose_job_start_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void g_cclosure_user_marshal_VOID__STRING_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void compose_job_finalize (GObject* obj);


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


ComposeJob* compose_job_construct (GType object_type, Account* account) {
	ComposeJob * self = NULL;
	Account* _tmp0_ = NULL;
	g_return_val_if_fail (IS_ACCOUNT (account), NULL);
	self = (ComposeJob*) g_object_new (object_type, NULL);
	_tmp0_ = account;
	self->priv->account = _tmp0_;
	return self;
}


ComposeJob* compose_job_new (Account* account) {
	return compose_job_construct (TYPE_COMPOSE_JOB, account);
}


void compose_job_add_image (ComposeJob* self, const gchar* path) {
	GPtrArray* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	g_return_if_fail (IS_COMPOSE_JOB (self));
	g_return_if_fail (path != NULL);
	_tmp0_ = self->priv->image_paths;
	_tmp1_ = path;
	_tmp2_ = g_strdup (_tmp1_);
	g_ptr_array_add (_tmp0_, _tmp2_);
}


static void compose_job_upload_image_data_free (gpointer _data) {
	ComposeJobUploadImageData* _data_;
	_data_ = _data;
	_g_free0 (_data_->path);
	_g_object_unref0 (_data_->proxy);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (ComposeJobUploadImageData, _data_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void compose_job_upload_image (ComposeJob* self, const gchar* path, RestProxy* proxy, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	ComposeJobUploadImageData* _data_;
	ComposeJob* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	RestProxy* _tmp3_ = NULL;
	RestProxy* _tmp4_ = NULL;
	GCancellable* _tmp5_ = NULL;
	GCancellable* _tmp6_ = NULL;
	_data_ = g_slice_new0 (ComposeJobUploadImageData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, compose_job_upload_image);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, compose_job_upload_image_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = path;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (_data_->path);
	_data_->path = _tmp2_;
	_tmp3_ = proxy;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 (_data_->proxy);
	_data_->proxy = _tmp4_;
	_tmp5_ = cancellable;
	_tmp6_ = _g_object_ref0 (_tmp5_);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp6_;
	compose_job_upload_image_co (_data_);
}


static gint64 compose_job_upload_image_finish (ComposeJob* self, GAsyncResult* _res_, GError** error) {
	gint64 result;
	ComposeJobUploadImageData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		gint64 _tmp0_ = 0LL;
		return _tmp0_;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	return result;
}


static gpointer _rest_param_ref0 (gpointer self) {
	return self ? rest_param_ref (self) : NULL;
}


static void compose_job_upload_image_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	ComposeJobUploadImageData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	compose_job_upload_image_co (_data_);
}


static gpointer _json_object_ref0 (gpointer self) {
	return self ? json_object_ref (self) : NULL;
}


static gboolean compose_job_upload_image_co (ComposeJobUploadImageData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->proxy;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = rest_proxy_new_call (_data_->_tmp0_);
	_data_->call = _data_->_tmp1_;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = _data_->call;
	rest_proxy_call_set_function (_data_->_tmp2_, "1.1/media/upload.json");
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = _data_->call;
	rest_proxy_call_set_method (_data_->_tmp3_, "POST");
	_data_->file_contents_length1 = 0;
	_data_->_file_contents_size_ = 0;
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = _data_->path;
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = g_file_new_for_path (_data_->_tmp4_);
	_data_->media_file = _data_->_tmp5_;
	_data_->_tmp6_ = NULL;
	_data_->_tmp6_ = _data_->media_file;
	_data_->_tmp7_ = NULL;
	memset (&_data_->_tmp8_, 0, sizeof (gsize));
	g_file_load_contents (_data_->_tmp6_, NULL, &_data_->_tmp7_, &_data_->_tmp8_, NULL, &_data_->_inner_error_);
	_data_->file_contents = (g_free (_data_->file_contents), NULL);
	_data_->file_contents = _data_->_tmp7_;
	_data_->file_contents_length1 = _data_->_tmp8_;
	_data_->_file_contents_size_ = _data_->file_contents_length1;
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		_g_object_unref0 (_data_->media_file);
		_data_->file_contents = (g_free (_data_->file_contents), NULL);
		_g_object_unref0 (_data_->call);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp9_ = NULL;
	_data_->_tmp9__length1 = 0;
	_data_->_tmp9_ = _data_->file_contents;
	_data_->_tmp9__length1 = _data_->file_contents_length1;
	_data_->_tmp10_ = NULL;
	_data_->_tmp10_ = _data_->path;
	_data_->_tmp11_ = NULL;
	_data_->_tmp11_ = rest_param_new_full ("media", REST_MEMORY_COPY, _data_->_tmp9_, _data_->_tmp9__length1, "multipart/form-data", _data_->_tmp10_);
	_data_->param = _data_->_tmp11_;
	_data_->_tmp12_ = NULL;
	_data_->_tmp12_ = _data_->call;
	_data_->_tmp13_ = NULL;
	_data_->_tmp13_ = _data_->param;
	_data_->_tmp14_ = NULL;
	_data_->_tmp14_ = _rest_param_ref0 (_data_->_tmp13_);
	rest_proxy_call_add_param_full (_data_->_tmp12_, _data_->_tmp14_);
	_data_->_tmp15_ = NULL;
	_data_->_tmp15_ = _data_->call;
	_data_->_tmp16_ = NULL;
	_data_->_tmp16_ = _data_->cancellable;
	_data_->_state_ = 1;
	rest_proxy_call_invoke_async (_data_->_tmp15_, _data_->_tmp16_, compose_job_upload_image_ready, _data_);
	return FALSE;
	_state_1:
	rest_proxy_call_invoke_finish (_data_->_tmp15_, _data_->_res_, &_data_->_inner_error_);
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		_rest_param_unref0 (_data_->param);
		_g_object_unref0 (_data_->media_file);
		_data_->file_contents = (g_free (_data_->file_contents), NULL);
		_g_object_unref0 (_data_->call);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp17_ = NULL;
	_data_->_tmp17_ = json_parser_new ();
	_data_->parser = _data_->_tmp17_;
	{
		_data_->_tmp18_ = NULL;
		_data_->_tmp18_ = _data_->parser;
		_data_->_tmp19_ = NULL;
		_data_->_tmp19_ = _data_->call;
		_data_->_tmp20_ = NULL;
		_data_->_tmp20_ = rest_proxy_call_get_payload (_data_->_tmp19_);
		json_parser_load_from_data (_data_->_tmp18_, _data_->_tmp20_, (gssize) -1, &_data_->_inner_error_);
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			goto __catch96_g_error;
		}
	}
	goto __finally96;
	__catch96_g_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp21_ = NULL;
		_data_->_tmp21_ = _data_->e;
		_data_->_tmp22_ = NULL;
		_data_->_tmp22_ = _data_->_tmp21_->message;
		g_warning ("ComposeJob.vala:58: %s", _data_->_tmp22_);
		_data_->result = (gint64) -1;
		_g_error_free0 (_data_->e);
		_g_object_unref0 (_data_->parser);
		_rest_param_unref0 (_data_->param);
		_g_object_unref0 (_data_->media_file);
		_data_->file_contents = (g_free (_data_->file_contents), NULL);
		_g_object_unref0 (_data_->call);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally96:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		_g_object_unref0 (_data_->parser);
		_rest_param_unref0 (_data_->param);
		_g_object_unref0 (_data_->media_file);
		_data_->file_contents = (g_free (_data_->file_contents), NULL);
		_g_object_unref0 (_data_->call);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp23_ = NULL;
	_data_->_tmp23_ = _data_->cancellable;
	_data_->_tmp24_ = FALSE;
	_data_->_tmp24_ = g_cancellable_is_cancelled (_data_->_tmp23_);
	if (_data_->_tmp24_) {
		_data_->result = (gint64) 0;
		_g_object_unref0 (_data_->parser);
		_rest_param_unref0 (_data_->param);
		_g_object_unref0 (_data_->media_file);
		_data_->file_contents = (g_free (_data_->file_contents), NULL);
		_g_object_unref0 (_data_->call);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp25_ = NULL;
	_data_->_tmp25_ = _data_->parser;
	_data_->_tmp26_ = NULL;
	_data_->_tmp26_ = json_parser_get_root (_data_->_tmp25_);
	_data_->_tmp27_ = NULL;
	_data_->_tmp27_ = json_node_get_object (_data_->_tmp26_);
	_data_->_tmp28_ = NULL;
	_data_->_tmp28_ = _json_object_ref0 (_data_->_tmp27_);
	_data_->root = _data_->_tmp28_;
	_data_->_tmp29_ = NULL;
	_data_->_tmp29_ = _data_->root;
	_data_->_tmp30_ = 0LL;
	_data_->_tmp30_ = json_object_get_int_member (_data_->_tmp29_, "media_id");
	_data_->result = _data_->_tmp30_;
	_json_object_unref0 (_data_->root);
	_g_object_unref0 (_data_->parser);
	_rest_param_unref0 (_data_->param);
	_g_object_unref0 (_data_->media_file);
	_data_->file_contents = (g_free (_data_->file_contents), NULL);
	_g_object_unref0 (_data_->call);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	_json_object_unref0 (_data_->root);
	_g_object_unref0 (_data_->parser);
	_rest_param_unref0 (_data_->param);
	_g_object_unref0 (_data_->media_file);
	_data_->file_contents = (g_free (_data_->file_contents), NULL);
	_g_object_unref0 (_data_->call);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void compose_job_upload_images_data_free (gpointer _data) {
	ComposeJobUploadImagesData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_data_->result = (g_free (_data_->result), NULL);
	_g_object_unref0 (_data_->self);
	g_slice_free (ComposeJobUploadImagesData, _data_);
}


static void compose_job_upload_images (ComposeJob* self, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	ComposeJobUploadImagesData* _data_;
	ComposeJob* _tmp0_ = NULL;
	GCancellable* _tmp1_ = NULL;
	GCancellable* _tmp2_ = NULL;
	_data_ = g_slice_new0 (ComposeJobUploadImagesData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, compose_job_upload_images);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, compose_job_upload_images_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = cancellable;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	compose_job_upload_images_co (_data_);
}


static gint64* compose_job_upload_images_finish (ComposeJob* self, GAsyncResult* _res_, int* result_length1) {
	gint64* result;
	ComposeJobUploadImagesData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	*result_length1 = _data_->result_length1;
	_data_->result = NULL;
	return result;
}


static Block82Data* block82_data_ref (Block82Data* _data82_) {
	g_atomic_int_inc (&_data82_->_ref_count_);
	return _data82_;
}


static void block82_data_unref (void * _userdata_) {
	Block82Data* _data82_;
	_data82_ = (Block82Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data82_->_ref_count_)) {
		ComposeJob* self;
		self = _data82_->self;
		_g_object_unref0 (_data82_->collect_obj);
		_data82_->ids = (g_free (_data82_->ids), NULL);
		_g_object_unref0 (self);
		g_slice_free (Block82Data, _data82_);
	}
}


static gint g_ptr_array_get_length (GPtrArray* self) {
	gint result;
	guint _tmp0_ = 0U;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->len;
	result = (gint) _tmp0_;
	return result;
}


static void g_ptr_array_set_length (GPtrArray* self, gint value) {
	gint _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	g_ptr_array_set_size (self, _tmp0_);
}


static void __lambda45_ (Block82Data* _data82_) {
	ComposeJob* self;
	self = _data82_->self;
	g_debug ("ComposeJob.vala:82: Calling the callback...");
	compose_job_upload_images_co (_data82_->_async_data_);
}


static void ___lambda45__collect_finished (Collect* _sender, GError* _error_, gpointer self) {
	__lambda45_ (self);
}


static Block83Data* block83_data_ref (Block83Data* _data83_) {
	g_atomic_int_inc (&_data83_->_ref_count_);
	return _data83_;
}


static void block83_data_unref (void * _userdata_) {
	Block83Data* _data83_;
	_data83_ = (Block83Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data83_->_ref_count_)) {
		ComposeJob* self;
		self = _data83_->_data82_->self;
		_g_free0 (_data83_->path);
		block82_data_unref (_data83_->_data82_);
		_data83_->_data82_ = NULL;
		g_slice_free (Block83Data, _data83_);
	}
}


static void _____lambda46_ (Block83Data* _data83_, GObject* obj, GAsyncResult* res) {
	Block82Data* _data82_;
	ComposeJob* self;
	gint64 id = 0LL;
	const gchar* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	gint64 _tmp12_ = 0LL;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	gint64* _tmp15_ = NULL;
	gint _tmp15__length1 = 0;
	gint _tmp16_ = 0;
	gint64 _tmp17_ = 0LL;
	gint64 _tmp18_ = 0LL;
	const gchar* _tmp19_ = NULL;
	Collect* _tmp20_ = NULL;
	GError * _inner_error_ = NULL;
	_data82_ = _data83_->_data82_;
	self = _data82_->self;
	g_return_if_fail ((obj == NULL) || G_IS_OBJECT (obj));
	g_return_if_fail (G_IS_ASYNC_RESULT (res));
	{
		gint64 _tmp0_ = 0LL;
		GAsyncResult* _tmp1_ = NULL;
		gint64 _tmp2_ = 0LL;
		_tmp1_ = res;
		_tmp2_ = compose_job_upload_image_finish (self, _tmp1_, &_inner_error_);
		_tmp0_ = _tmp2_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch97_g_error;
		}
		id = _tmp0_;
	}
	goto __finally97;
	__catch97_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		GError* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		Collect* _tmp8_ = NULL;
		GError* _tmp9_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_warning ("ComposeJob.vala:96: %s", _tmp4_);
		_tmp5_ = _data83_->path;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		g_signal_emit_by_name (self, "image-upload-finished", _tmp5_, _tmp7_);
		_tmp8_ = _data82_->collect_obj;
		_tmp9_ = e;
		collect_emit (_tmp8_, _tmp9_);
		_g_error_free0 (e);
		return;
	}
	__finally97:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp10_ = _data83_->path;
	_tmp11_ = _data83_->index;
	_tmp12_ = id;
	_tmp13_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp12_);
	_tmp14_ = _tmp13_;
	g_debug ("ComposeJob.vala:102: id for %s (%d): %s", _tmp10_, _tmp11_, _tmp14_);
	_g_free0 (_tmp14_);
	_tmp15_ = _data82_->ids;
	_tmp15__length1 = _data82_->ids_length1;
	_tmp16_ = _data83_->index;
	_tmp17_ = id;
	_tmp15_[_tmp16_] = _tmp17_;
	_tmp18_ = _tmp15_[_tmp16_];
	_tmp19_ = _data83_->path;
	g_signal_emit_by_name (self, "image-upload-finished", _tmp19_, NULL);
	_tmp20_ = _data82_->collect_obj;
	collect_emit (_tmp20_, NULL);
}


static void ______lambda46__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	_____lambda46_ (self, source_object, res);
	block83_data_unref (self);
}


static gint64* _vala_array_dup8 (gint64* self, int length) {
	return g_memdup (self, length * sizeof (gint64));
}


static gboolean compose_job_upload_images_co (ComposeJobUploadImagesData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data82_ = g_slice_new0 (Block82Data);
	_data_->_data82_->_ref_count_ = 1;
	_data_->_data82_->self = g_object_ref (_data_->self);
	_data_->_data82_->_async_data_ = _data_;
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->self->priv->image_paths;
	_data_->_tmp1_ = 0;
	_data_->_tmp1_ = g_ptr_array_get_length (_data_->_tmp0_);
	_data_->_tmp2_ = 0;
	_data_->_tmp2_ = _data_->_tmp1_;
	_vala_assert (_data_->_tmp2_ > 0, "this.image_paths.length > 0");
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = settings_get_consumer_key ();
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = _data_->_tmp3_;
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = settings_get_consumer_secret ();
	_data_->_tmp6_ = NULL;
	_data_->_tmp6_ = _data_->_tmp5_;
	_data_->_tmp7_ = NULL;
	_data_->_tmp7_ = (OAuthProxy*) oauth_proxy_new (_data_->_tmp4_, _data_->_tmp6_, "https://upload.twitter.com/", FALSE);
	_data_->_tmp8_ = NULL;
	_data_->_tmp8_ = _data_->_tmp7_;
	_g_free0 (_data_->_tmp6_);
	_g_free0 (_data_->_tmp4_);
	_data_->proxy = _data_->_tmp8_;
	_data_->_tmp9_ = NULL;
	_data_->_tmp9_ = _data_->proxy;
	_data_->_tmp10_ = NULL;
	_data_->_tmp10_ = _data_->self->priv->account;
	_data_->_tmp11_ = NULL;
	_data_->_tmp11_ = _data_->_tmp10_->proxy;
	_data_->_tmp12_ = NULL;
	_data_->_tmp12_ = oauth_proxy_get_token (_data_->_tmp11_);
	_data_->_tmp13_ = NULL;
	_data_->_tmp13_ = _data_->_tmp12_;
	oauth_proxy_set_token (_data_->_tmp9_, _data_->_tmp13_);
	_data_->_tmp14_ = NULL;
	_data_->_tmp14_ = _data_->proxy;
	_data_->_tmp15_ = NULL;
	_data_->_tmp15_ = _data_->self->priv->account;
	_data_->_tmp16_ = NULL;
	_data_->_tmp16_ = _data_->_tmp15_->proxy;
	_data_->_tmp17_ = NULL;
	_data_->_tmp17_ = oauth_proxy_get_token_secret (_data_->_tmp16_);
	_data_->_tmp18_ = NULL;
	_data_->_tmp18_ = _data_->_tmp17_;
	oauth_proxy_set_token_secret (_data_->_tmp14_, _data_->_tmp18_);
	_data_->_tmp19_ = NULL;
	_data_->_tmp19_ = _data_->self->priv->image_paths;
	_data_->_tmp20_ = 0;
	_data_->_tmp20_ = g_ptr_array_get_length (_data_->_tmp19_);
	_data_->_tmp21_ = 0;
	_data_->_tmp21_ = _data_->_tmp20_;
	_data_->_tmp22_ = NULL;
	_data_->_tmp22_ = g_new0 (gint64, _data_->_tmp21_);
	_data_->_data82_->ids = _data_->_tmp22_;
	_data_->_data82_->ids_length1 = _data_->_tmp21_;
	_data_->_data82_->_ids_size_ = _data_->_data82_->ids_length1;
	_data_->_tmp23_ = NULL;
	_data_->_tmp23_ = _data_->self->priv->image_paths;
	_data_->_tmp24_ = 0;
	_data_->_tmp24_ = g_ptr_array_get_length (_data_->_tmp23_);
	_data_->_tmp25_ = 0;
	_data_->_tmp25_ = _data_->_tmp24_;
	_data_->_tmp26_ = NULL;
	_data_->_tmp26_ = collect_new (_data_->_tmp25_);
	_data_->_data82_->collect_obj = _data_->_tmp26_;
	_data_->_tmp27_ = NULL;
	_data_->_tmp27_ = _data_->_data82_->collect_obj;
	g_signal_connect_data (_data_->_tmp27_, "finished", (GCallback) ___lambda45__collect_finished, block82_data_ref (_data_->_data82_), (GClosureNotify) block82_data_unref, 0);
	{
		_data_->i = 0;
		{
			_data_->_tmp28_ = TRUE;
			while (TRUE) {
				_data_->_data83_ = g_slice_new0 (Block83Data);
				_data_->_data83_->_ref_count_ = 1;
				_data_->_data83_->_data82_ = block82_data_ref (_data_->_data82_);
				if (!_data_->_tmp28_) {
					_data_->_tmp29_ = 0;
					_data_->_tmp29_ = _data_->i;
					_data_->i = _data_->_tmp29_ + 1;
				}
				_data_->_tmp28_ = FALSE;
				_data_->_tmp30_ = 0;
				_data_->_tmp30_ = _data_->i;
				_data_->_tmp31_ = NULL;
				_data_->_tmp31_ = _data_->self->priv->image_paths;
				_data_->_tmp32_ = 0;
				_data_->_tmp32_ = g_ptr_array_get_length (_data_->_tmp31_);
				_data_->_tmp33_ = 0;
				_data_->_tmp33_ = _data_->_tmp32_;
				if (!(_data_->_tmp30_ < _data_->_tmp33_)) {
					block83_data_unref (_data_->_data83_);
					_data_->_data83_ = NULL;
					break;
				}
				_data_->_tmp34_ = NULL;
				_data_->_tmp34_ = _data_->self->priv->image_paths;
				_data_->_tmp35_ = 0;
				_data_->_tmp35_ = _data_->i;
				_data_->_tmp36_ = NULL;
				_data_->_tmp36_ = g_ptr_array_index (_data_->_tmp34_, (guint) _data_->_tmp35_);
				_data_->_tmp37_ = NULL;
				_data_->_tmp37_ = g_strdup ((const gchar*) _data_->_tmp36_);
				_data_->_data83_->path = _data_->_tmp37_;
				_data_->_tmp38_ = NULL;
				_data_->_tmp38_ = _data_->_data83_->path;
				g_signal_emit_by_name (_data_->self, "image-upload-started", _data_->_tmp38_);
				_data_->_tmp39_ = NULL;
				_data_->_tmp39_ = _data_->_data83_->path;
				_data_->_tmp40_ = 0;
				_data_->_tmp40_ = _data_->i;
				g_debug ("ComposeJob.vala:89: Starting upload of %s (%d)", _data_->_tmp39_, _data_->_tmp40_);
				_data_->_tmp41_ = 0;
				_data_->_tmp41_ = _data_->i;
				_data_->_data83_->index = _data_->_tmp41_;
				_data_->_tmp42_ = NULL;
				_data_->_tmp42_ = _data_->_data83_->path;
				_data_->_tmp43_ = NULL;
				_data_->_tmp43_ = _data_->proxy;
				_data_->_tmp44_ = NULL;
				_data_->_tmp44_ = _data_->cancellable;
				compose_job_upload_image (_data_->self, _data_->_tmp42_, G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp43_, rest_proxy_get_type (), RestProxy), _data_->_tmp44_, ______lambda46__gasync_ready_callback, block83_data_ref (_data_->_data83_));
				_data_->_tmp45_ = NULL;
				_data_->_tmp45_ = _data_->cancellable;
				_data_->_tmp46_ = FALSE;
				_data_->_tmp46_ = g_cancellable_is_cancelled (_data_->_tmp45_);
				if (_data_->_tmp46_) {
					block83_data_unref (_data_->_data83_);
					_data_->_data83_ = NULL;
					break;
				}
				block83_data_unref (_data_->_data83_);
				_data_->_data83_ = NULL;
			}
		}
	}
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	_data_->_tmp47_ = NULL;
	_data_->_tmp47__length1 = 0;
	_data_->_tmp47_ = _data_->_data82_->ids;
	_data_->_tmp47__length1 = _data_->_data82_->ids_length1;
	_data_->_tmp48_ = NULL;
	_data_->_tmp48__length1 = 0;
	_data_->_tmp48_ = (_data_->_tmp47_ != NULL) ? _vala_array_dup8 (_data_->_tmp47_, _data_->_tmp47__length1) : ((gpointer) _data_->_tmp47_);
	_data_->_tmp48__length1 = _data_->_tmp47__length1;
	_data_->_tmp49_ = NULL;
	_data_->_tmp49__length1 = 0;
	_data_->_tmp49_ = _data_->_tmp48_;
	_data_->_tmp49__length1 = _data_->_tmp48__length1;
	_data_->result_length1 = _data_->_tmp49__length1;
	_data_->result = _data_->_tmp49_;
	_g_object_unref0 (_data_->proxy);
	block82_data_unref (_data_->_data82_);
	_data_->_data82_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	_g_object_unref0 (_data_->proxy);
	block82_data_unref (_data_->_data82_);
	_data_->_data82_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void compose_job_send_tweet_data_free (gpointer _data) {
	ComposeJobSendTweetData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (ComposeJobSendTweetData, _data_);
}


static void compose_job_send_tweet (ComposeJob* self, gint64* media_ids, int media_ids_length1, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	ComposeJobSendTweetData* _data_;
	ComposeJob* _tmp0_ = NULL;
	gint64* _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	GCancellable* _tmp2_ = NULL;
	GCancellable* _tmp3_ = NULL;
	_data_ = g_slice_new0 (ComposeJobSendTweetData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, compose_job_send_tweet);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, compose_job_send_tweet_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = media_ids;
	_tmp1__length1 = media_ids_length1;
	_data_->media_ids = _tmp1_;
	_data_->media_ids_length1 = _tmp1__length1;
	_tmp2_ = cancellable;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp3_;
	compose_job_send_tweet_co (_data_);
}


static gboolean compose_job_send_tweet_finish (ComposeJob* self, GAsyncResult* _res_) {
	gboolean result;
	ComposeJobSendTweetData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	return result;
}


static Block84Data* block84_data_ref (Block84Data* _data84_) {
	g_atomic_int_inc (&_data84_->_ref_count_);
	return _data84_;
}


static void block84_data_unref (void * _userdata_) {
	Block84Data* _data84_;
	_data84_ = (Block84Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data84_->_ref_count_)) {
		ComposeJob* self;
		self = _data84_->self;
		_g_object_unref0 (_data84_->call);
		_g_object_unref0 (self);
		g_slice_free (Block84Data, _data84_);
	}
}


static void __lambda47_ (Block84Data* _data84_, GObject* obj, GAsyncResult* res) {
	ComposeJob* self;
	GError * _inner_error_ = NULL;
	self = _data84_->self;
	g_return_if_fail ((obj == NULL) || G_IS_OBJECT (obj));
	g_return_if_fail (G_IS_ASYNC_RESULT (res));
	{
		RestProxyCall* _tmp0_ = NULL;
		GAsyncResult* _tmp1_ = NULL;
		_tmp0_ = _data84_->call;
		_tmp1_ = res;
		rest_proxy_call_invoke_finish (_tmp0_, _tmp1_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch98_g_error;
		}
	}
	goto __finally98;
	__catch98_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		RestProxyCall* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		GError* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		g_warning ("ComposeJob.vala:147: %s", _tmp3_);
		_tmp4_ = _data84_->call;
		_tmp5_ = rest_proxy_call_get_payload (_tmp4_);
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		utils_show_error_object (_tmp5_, _tmp7_, 149, "ComposeJob.vala", NULL);
		_data84_->success = FALSE;
		_g_error_free0 (e);
	}
	__finally98:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	compose_job_send_tweet_co (_data84_->_async_data_);
}


static void ___lambda47__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda47_ (self, source_object, res);
	block84_data_unref (self);
}


static gboolean compose_job_send_tweet_co (ComposeJobSendTweetData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data84_ = g_slice_new0 (Block84Data);
	_data_->_data84_->_ref_count_ = 1;
	_data_->_data84_->self = g_object_ref (_data_->self);
	_data_->_data84_->_async_data_ = _data_;
	_data_->_data84_->success = TRUE;
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->self->priv->account;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = _data_->_tmp0_->proxy;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp1_, rest_proxy_get_type (), RestProxy));
	_data_->_data84_->call = _data_->_tmp2_;
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = _data_->_data84_->call;
	rest_proxy_call_set_method (_data_->_tmp3_, "POST");
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = _data_->_data84_->call;
	rest_proxy_call_set_function (_data_->_tmp4_, "1.1/statuses/update.json");
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = _data_->self->reply_id;
	if (_data_->_tmp5_ != NULL) {
		_data_->_tmp6_ = NULL;
		_data_->_tmp6_ = _data_->_data84_->call;
		_data_->_tmp7_ = NULL;
		_data_->_tmp7_ = _data_->self->reply_id;
		_data_->_tmp8_ = NULL;
		_data_->_tmp8_ = g_strdup_printf ("%" G_GINT64_FORMAT, *_data_->_tmp7_);
		_data_->_tmp9_ = NULL;
		_data_->_tmp9_ = _data_->_tmp8_;
		rest_proxy_call_add_param (_data_->_tmp6_, "in_reply_to_status_id", _data_->_tmp9_);
		_g_free0 (_data_->_tmp9_);
	} else {
		_data_->_tmp10_ = NULL;
		_data_->_tmp10_ = _data_->self->quoted_tweet;
		if (_data_->_tmp10_ != NULL) {
			_data_->_tmp12_ = NULL;
			_data_->_tmp12_ = _data_->self->quoted_tweet;
			_data_->_tmp13_ = NULL;
			_data_->_tmp13_ = _data_->_tmp12_->retweeted_tweet;
			_data_->_tmp11_ = _data_->_tmp13_;
			if (_data_->_tmp11_ == NULL) {
				_data_->_tmp14_ = NULL;
				_data_->_tmp14_ = _data_->self->quoted_tweet;
				memset (&_data_->_tmp15_, 0, sizeof (CbMiniTweet));
				_data_->_tmp15_ = _data_->_tmp14_->source_tweet;
				_data_->_tmp11_ = &_data_->_tmp15_;
			}
			memset (&_data_->_tmp16_, 0, sizeof (CbMiniTweet));
			cb_mini_tweet_copy (_data_->_tmp11_, &_data_->_tmp16_);
			_data_->mt = _data_->_tmp16_;
			memset (&_data_->_tmp17_, 0, sizeof (CbMiniTweet));
			_data_->_tmp17_ = _data_->mt;
			memset (&_data_->_tmp18_, 0, sizeof (CbUserIdentity));
			_data_->_tmp18_ = _data_->_tmp17_.author;
			_data_->_tmp19_ = NULL;
			_data_->_tmp19_ = _data_->_tmp18_.screen_name;
			memset (&_data_->_tmp20_, 0, sizeof (CbMiniTweet));
			_data_->_tmp20_ = _data_->mt;
			_data_->_tmp21_ = 0LL;
			_data_->_tmp21_ = _data_->_tmp20_.id;
			_data_->_tmp22_ = NULL;
			_data_->_tmp22_ = g_strdup_printf ("%" G_GINT64_FORMAT, _data_->_tmp21_);
			_data_->_tmp23_ = NULL;
			_data_->_tmp23_ = _data_->_tmp22_;
			_data_->_tmp24_ = NULL;
			_data_->_tmp24_ = g_strdup_printf ("https://twitter.com/%s/status/%s", _data_->_tmp19_, _data_->_tmp23_);
			_data_->_tmp25_ = NULL;
			_data_->_tmp25_ = _data_->_tmp24_;
			_g_free0 (_data_->_tmp23_);
			_data_->quoted_url = _data_->_tmp25_;
			_data_->_tmp26_ = NULL;
			_data_->_tmp26_ = _data_->_data84_->call;
			_data_->_tmp27_ = NULL;
			_data_->_tmp27_ = _data_->quoted_url;
			rest_proxy_call_add_param (_data_->_tmp26_, "attachment_url", _data_->_tmp27_);
			_g_free0 (_data_->quoted_url);
			cb_mini_tweet_free (&_data_->mt);
		}
	}
	_data_->_tmp28_ = NULL;
	_data_->_tmp28_ = _data_->_data84_->call;
	_data_->_tmp29_ = NULL;
	_data_->_tmp29_ = _data_->self->text;
	rest_proxy_call_add_param (_data_->_tmp28_, "status", _data_->_tmp29_);
	_data_->_tmp31_ = NULL;
	_data_->_tmp31__length1 = 0;
	_data_->_tmp31_ = _data_->media_ids;
	_data_->_tmp31__length1 = _data_->media_ids_length1;
	if (_data_->_tmp31_ != NULL) {
		_data_->_tmp32_ = NULL;
		_data_->_tmp32__length1 = 0;
		_data_->_tmp32_ = _data_->media_ids;
		_data_->_tmp32__length1 = _data_->media_ids_length1;
		_data_->_tmp30_ = _data_->_tmp32__length1 > 0;
	} else {
		_data_->_tmp30_ = FALSE;
	}
	if (_data_->_tmp30_) {
		_data_->_tmp33_ = NULL;
		_data_->_tmp33_ = g_string_new ("");
		_data_->sb = _data_->_tmp33_;
		_data_->_tmp34_ = NULL;
		_data_->_tmp34_ = _data_->sb;
		_data_->_tmp35_ = NULL;
		_data_->_tmp35__length1 = 0;
		_data_->_tmp35_ = _data_->media_ids;
		_data_->_tmp35__length1 = _data_->media_ids_length1;
		_data_->_tmp36_ = 0LL;
		_data_->_tmp36_ = _data_->_tmp35_[0];
		_data_->_tmp37_ = NULL;
		_data_->_tmp37_ = g_strdup_printf ("%" G_GINT64_FORMAT, _data_->_tmp36_);
		_data_->_tmp38_ = NULL;
		_data_->_tmp38_ = _data_->_tmp37_;
		g_string_append (_data_->_tmp34_, _data_->_tmp38_);
		_g_free0 (_data_->_tmp38_);
		{
			_data_->i = 1;
			{
				_data_->_tmp39_ = TRUE;
				while (TRUE) {
					if (!_data_->_tmp39_) {
						_data_->_tmp40_ = 0;
						_data_->_tmp40_ = _data_->i;
						_data_->i = _data_->_tmp40_ + 1;
					}
					_data_->_tmp39_ = FALSE;
					_data_->_tmp41_ = 0;
					_data_->_tmp41_ = _data_->i;
					_data_->_tmp42_ = NULL;
					_data_->_tmp42__length1 = 0;
					_data_->_tmp42_ = _data_->media_ids;
					_data_->_tmp42__length1 = _data_->media_ids_length1;
					if (!(_data_->_tmp41_ < _data_->_tmp42__length1)) {
						break;
					}
					_data_->_tmp43_ = NULL;
					_data_->_tmp43_ = _data_->sb;
					_data_->_tmp44_ = NULL;
					_data_->_tmp44_ = g_string_append (_data_->_tmp43_, ",");
					_data_->_tmp45_ = NULL;
					_data_->_tmp45__length1 = 0;
					_data_->_tmp45_ = _data_->media_ids;
					_data_->_tmp45__length1 = _data_->media_ids_length1;
					_data_->_tmp46_ = 0;
					_data_->_tmp46_ = _data_->i;
					_data_->_tmp47_ = 0LL;
					_data_->_tmp47_ = _data_->_tmp45_[_data_->_tmp46_];
					_data_->_tmp48_ = NULL;
					_data_->_tmp48_ = g_strdup_printf ("%" G_GINT64_FORMAT, _data_->_tmp47_);
					_data_->_tmp49_ = NULL;
					_data_->_tmp49_ = _data_->_tmp48_;
					g_string_append (_data_->_tmp44_, _data_->_tmp49_);
					_g_free0 (_data_->_tmp49_);
				}
			}
		}
		_data_->_tmp50_ = NULL;
		_data_->_tmp50_ = _data_->sb;
		_data_->_tmp51_ = NULL;
		_data_->_tmp51_ = _data_->_tmp50_->str;
		g_debug ("ComposeJob.vala:139: id param: %s", _data_->_tmp51_);
		_data_->_tmp52_ = NULL;
		_data_->_tmp52_ = _data_->_data84_->call;
		_data_->_tmp53_ = NULL;
		_data_->_tmp53_ = _data_->sb;
		_data_->_tmp54_ = NULL;
		_data_->_tmp54_ = _data_->_tmp53_->str;
		rest_proxy_call_add_param (_data_->_tmp52_, "media_ids", _data_->_tmp54_);
		_g_string_free0 (_data_->sb);
	}
	_data_->_tmp55_ = NULL;
	_data_->_tmp55_ = _data_->_data84_->call;
	_data_->_tmp56_ = NULL;
	_data_->_tmp56_ = _data_->cancellable;
	rest_proxy_call_invoke_async (_data_->_tmp55_, _data_->_tmp56_, ___lambda47__gasync_ready_callback, block84_data_ref (_data_->_data84_));
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	_data_->_tmp57_ = FALSE;
	_data_->_tmp57_ = _data_->_data84_->success;
	_data_->result = _data_->_tmp57_;
	block84_data_unref (_data_->_data84_);
	_data_->_data84_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	block84_data_unref (_data_->_data84_);
	_data_->_data84_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void compose_job_start_data_free (gpointer _data) {
	ComposeJobStartData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (ComposeJobStartData, _data_);
}


void compose_job_start (ComposeJob* self, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	ComposeJobStartData* _data_;
	ComposeJob* _tmp0_ = NULL;
	GCancellable* _tmp1_ = NULL;
	GCancellable* _tmp2_ = NULL;
	_data_ = g_slice_new0 (ComposeJobStartData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, compose_job_start);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, compose_job_start_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = cancellable;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	compose_job_start_co (_data_);
}


gboolean compose_job_start_finish (ComposeJob* self, GAsyncResult* _res_) {
	gboolean result;
	ComposeJobStartData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	return result;
}


static void compose_job_start_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	ComposeJobStartData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	compose_job_start_co (_data_);
}


static gboolean compose_job_start_co (ComposeJobStartData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->media_ids_length1 = 0;
	_data_->_media_ids_size_ = 0;
	_data_->media_ids = NULL;
	_data_->media_ids_length1 = 0;
	_data_->_media_ids_size_ = _data_->media_ids_length1;
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->self->priv->image_paths;
	_data_->_tmp1_ = 0;
	_data_->_tmp1_ = g_ptr_array_get_length (_data_->_tmp0_);
	_data_->_tmp2_ = 0;
	_data_->_tmp2_ = _data_->_tmp1_;
	if (_data_->_tmp2_ > 0) {
		_data_->_tmp3_ = NULL;
		_data_->_tmp3_ = _data_->self->priv->image_paths;
		_data_->_tmp4_ = 0;
		_data_->_tmp4_ = g_ptr_array_get_length (_data_->_tmp3_);
		_data_->_tmp5_ = 0;
		_data_->_tmp5_ = _data_->_tmp4_;
		g_debug ("ComposeJob.vala:170: Uploading %d images first...", _data_->_tmp5_);
		_data_->_tmp6_ = NULL;
		_data_->_tmp6_ = _data_->cancellable;
		_data_->_tmp7_ = 0;
		_data_->_state_ = 1;
		compose_job_upload_images (_data_->self, _data_->_tmp6_, compose_job_start_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp8_ = NULL;
		_data_->_tmp8_ = compose_job_upload_images_finish (_data_->self, _data_->_res_, &_data_->_tmp7_);
		_data_->media_ids = (g_free (_data_->media_ids), NULL);
		_data_->media_ids = _data_->_tmp8_;
		_data_->media_ids_length1 = _data_->_tmp7_;
		_data_->_media_ids_size_ = _data_->media_ids_length1;
		_data_->_tmp9_ = NULL;
		_data_->_tmp9__length1 = 0;
		_data_->_tmp9_ = _data_->media_ids;
		_data_->_tmp9__length1 = _data_->media_ids_length1;
		_data_->_tmp10_ = 0LL;
		_data_->_tmp10_ = _data_->_tmp9_[0];
		_data_->_tmp11_ = NULL;
		_data_->_tmp11_ = g_strdup_printf ("%" G_GINT64_FORMAT, _data_->_tmp10_);
		_data_->_tmp12_ = NULL;
		_data_->_tmp12_ = _data_->_tmp11_;
		g_debug ("ComposeJob.vala:172: media_ids[0]: %s", _data_->_tmp12_);
		_g_free0 (_data_->_tmp12_);
	}
	_data_->_tmp13_ = NULL;
	_data_->_tmp13_ = _data_->cancellable;
	_data_->_tmp14_ = FALSE;
	_data_->_tmp14_ = g_cancellable_is_cancelled (_data_->_tmp13_);
	if (_data_->_tmp14_) {
		_data_->result = FALSE;
		_data_->media_ids = (g_free (_data_->media_ids), NULL);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp15_ = NULL;
	_data_->_tmp15__length1 = 0;
	_data_->_tmp15_ = _data_->media_ids;
	_data_->_tmp15__length1 = _data_->media_ids_length1;
	_data_->_tmp16_ = NULL;
	_data_->_tmp16_ = _data_->cancellable;
	_data_->_state_ = 2;
	compose_job_send_tweet (_data_->self, _data_->_tmp15_, _data_->_tmp15__length1, _data_->_tmp16_, compose_job_start_ready, _data_);
	return FALSE;
	_state_2:
	_data_->_tmp17_ = FALSE;
	_data_->_tmp17_ = compose_job_send_tweet_finish (_data_->self, _data_->_res_);
	_data_->success = _data_->_tmp17_;
	_data_->result = _data_->success;
	_data_->media_ids = (g_free (_data_->media_ids), NULL);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	_data_->media_ids = (g_free (_data_->media_ids), NULL);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void g_cclosure_user_marshal_VOID__STRING_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__STRING_STRING) (gpointer data1, const char* arg_1, const char* arg_2, gpointer data2);
	register GMarshalFunc_VOID__STRING_STRING callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_STRING) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_string (param_values + 2), data2);
}


static void compose_job_class_init (ComposeJobClass * klass) {
	compose_job_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ComposeJobPrivate));
	G_OBJECT_CLASS (klass)->finalize = compose_job_finalize;
	g_signal_new ("image_upload_started", TYPE_COMPOSE_JOB, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	g_signal_new ("image_upload_finished", TYPE_COMPOSE_JOB, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_STRING, G_TYPE_NONE, 2, G_TYPE_STRING, G_TYPE_STRING);
}


static void compose_job_instance_init (ComposeJob * self) {
	GPtrArray* _tmp0_ = NULL;
	self->priv = COMPOSE_JOB_GET_PRIVATE (self);
	self->reply_id = NULL;
	_tmp0_ = g_ptr_array_new_full ((guint) 0, _g_free0_);
	self->priv->image_paths = _tmp0_;
}


static void compose_job_finalize (GObject* obj) {
	ComposeJob * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_COMPOSE_JOB, ComposeJob);
	_g_free0 (self->text);
	_g_object_unref0 (self->quoted_tweet);
	_g_free0 (self->reply_id);
	_g_ptr_array_unref0 (self->priv->image_paths);
	G_OBJECT_CLASS (compose_job_parent_class)->finalize (obj);
}


GType compose_job_get_type (void) {
	static volatile gsize compose_job_type_id__volatile = 0;
	if (g_once_init_enter (&compose_job_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ComposeJobClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) compose_job_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ComposeJob), 0, (GInstanceInitFunc) compose_job_instance_init, NULL };
		GType compose_job_type_id;
		compose_job_type_id = g_type_register_static (G_TYPE_OBJECT, "ComposeJob", &g_define_type_info, 0);
		g_once_init_leave (&compose_job_type_id__volatile, compose_job_type_id);
	}
	return compose_job_type_id__volatile;
}



