/* Database.c generated by valac 0.34.6, the Vala compiler
 * generated from Database.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <sqlite3.h>
#include <gio/gio.h>


#define SQL_TYPE_DATABASE (sql_database_get_type ())
#define SQL_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SQL_TYPE_DATABASE, SqlDatabase))
#define SQL_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SQL_TYPE_DATABASE, SqlDatabaseClass))
#define SQL_IS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SQL_TYPE_DATABASE))
#define SQL_IS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SQL_TYPE_DATABASE))
#define SQL_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SQL_TYPE_DATABASE, SqlDatabaseClass))

typedef struct _SqlDatabase SqlDatabase;
typedef struct _SqlDatabaseClass SqlDatabaseClass;
typedef struct _SqlDatabasePrivate SqlDatabasePrivate;
#define _sqlite3_close0(var) ((var == NULL) ? NULL : (var = (sqlite3_close (var), NULL)))
typedef struct _Block79Data Block79Data;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_bytes_unref0(var) ((var == NULL) ? NULL : (var = (g_bytes_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define SQL_TYPE_INSERT_STATEMENT (sql_insert_statement_get_type ())
#define SQL_INSERT_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SQL_TYPE_INSERT_STATEMENT, SqlInsertStatement))
#define SQL_INSERT_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SQL_TYPE_INSERT_STATEMENT, SqlInsertStatementClass))
#define SQL_IS_INSERT_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SQL_TYPE_INSERT_STATEMENT))
#define SQL_IS_INSERT_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SQL_TYPE_INSERT_STATEMENT))
#define SQL_INSERT_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SQL_TYPE_INSERT_STATEMENT, SqlInsertStatementClass))

typedef struct _SqlInsertStatement SqlInsertStatement;
typedef struct _SqlInsertStatementClass SqlInsertStatementClass;
typedef struct _SqlInsertStatementPrivate SqlInsertStatementPrivate;

#define SQL_TYPE_SELECT_STATEMENT (sql_select_statement_get_type ())
#define SQL_SELECT_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SQL_TYPE_SELECT_STATEMENT, SqlSelectStatement))
#define SQL_SELECT_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SQL_TYPE_SELECT_STATEMENT, SqlSelectStatementClass))
#define SQL_IS_SELECT_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SQL_TYPE_SELECT_STATEMENT))
#define SQL_IS_SELECT_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SQL_TYPE_SELECT_STATEMENT))
#define SQL_SELECT_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SQL_TYPE_SELECT_STATEMENT, SqlSelectStatementClass))

typedef struct _SqlSelectStatement SqlSelectStatement;
typedef struct _SqlSelectStatementClass SqlSelectStatementClass;
typedef struct _SqlSelectStatementPrivate SqlSelectStatementPrivate;

#define SQL_TYPE_UPDATE_STATEMENT (sql_update_statement_get_type ())
#define SQL_UPDATE_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SQL_TYPE_UPDATE_STATEMENT, SqlUpdateStatement))
#define SQL_UPDATE_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SQL_TYPE_UPDATE_STATEMENT, SqlUpdateStatementClass))
#define SQL_IS_UPDATE_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SQL_TYPE_UPDATE_STATEMENT))
#define SQL_IS_UPDATE_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SQL_TYPE_UPDATE_STATEMENT))
#define SQL_UPDATE_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SQL_TYPE_UPDATE_STATEMENT, SqlUpdateStatementClass))

typedef struct _SqlUpdateStatement SqlUpdateStatement;
typedef struct _SqlUpdateStatementClass SqlUpdateStatementClass;
typedef struct _SqlUpdateStatementPrivate SqlUpdateStatementPrivate;

struct _SqlDatabase {
	GObject parent_instance;
	SqlDatabasePrivate * priv;
};

struct _SqlDatabaseClass {
	GObjectClass parent_class;
};

struct _SqlDatabasePrivate {
	sqlite3* db;
};

struct _Block79Data {
	int _ref_count_;
	SqlDatabase* self;
	gint user_version;
};

struct _SqlInsertStatement {
	GObject parent_instance;
	SqlInsertStatementPrivate * priv;
	sqlite3* db;
};

struct _SqlInsertStatementClass {
	GObjectClass parent_class;
};

struct _SqlSelectStatement {
	GObject parent_instance;
	SqlSelectStatementPrivate * priv;
	sqlite3* db;
};

struct _SqlSelectStatementClass {
	GObjectClass parent_class;
};

struct _SqlUpdateStatement {
	GObject parent_instance;
	SqlUpdateStatementPrivate * priv;
	sqlite3* db;
};

struct _SqlUpdateStatementClass {
	GObjectClass parent_class;
};


static gpointer sql_database_parent_class = NULL;

#define SQL_COREBIRD_SQL_VERSION 2
#define SQL_COREBIRD_INIT_FILE "/org/baedert/corebird/sql/init/Create.%d.sql"
#define SQL_ACCOUNTS_SQL_VERSION 3
#define SQL_ACCOUNTS_INIT_FILE "/org/baedert/corebird/sql/accounts/Create.%d.sql"
#define SQL_STOP -1
#define SQL_CONTINUE 0
GType sql_database_get_type (void) G_GNUC_CONST;
#define SQL_DATABASE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SQL_TYPE_DATABASE, SqlDatabasePrivate))
enum  {
	SQL_DATABASE_DUMMY_PROPERTY
};
SqlDatabase* sql_database_new (const gchar* filename, const gchar* init_file, gint max_version);
SqlDatabase* sql_database_construct (GType object_type, const gchar* filename, const gchar* init_file, gint max_version);
static Block79Data* block79_data_ref (Block79Data* _data79_);
static void block79_data_unref (void * _userdata_);
void sql_database_exec (SqlDatabase* self, const gchar* sql, sqlite3_callback callback, void* callback_target);
static gint __lambda4_ (Block79Data* _data79_, gint n_cols, gchar** vals, int vals_length1);
static gint ___lambda4__sqlite3_callback (gpointer self, gint n_columns, gchar** values, gchar** column_names);
GType sql_insert_statement_get_type (void) G_GNUC_CONST;
SqlInsertStatement* sql_database_insert (SqlDatabase* self, const gchar* table_name);
SqlInsertStatement* sql_insert_statement_new (const gchar* table_name, gboolean replace);
SqlInsertStatement* sql_insert_statement_construct (GType object_type, const gchar* table_name, gboolean replace);
SqlInsertStatement* sql_database_replace (SqlDatabase* self, const gchar* table_name);
GType sql_select_statement_get_type (void) G_GNUC_CONST;
SqlSelectStatement* sql_database_select (SqlDatabase* self, const gchar* table_name);
SqlSelectStatement* sql_select_statement_new (const gchar* table_name);
SqlSelectStatement* sql_select_statement_construct (GType object_type, const gchar* table_name);
GType sql_update_statement_get_type (void) G_GNUC_CONST;
SqlUpdateStatement* sql_database_update (SqlDatabase* self, const gchar* table_name);
SqlUpdateStatement* sql_update_statement_new (const gchar* table_name);
SqlUpdateStatement* sql_update_statement_construct (GType object_type, const gchar* table_name);
void sql_database_begin_transaction (SqlDatabase* self);
void sql_database_end_transaction (SqlDatabase* self);
sqlite3* sql_database_get_sqlite_db (SqlDatabase* self);
static void sql_database_finalize (GObject* obj);


static Block79Data* block79_data_ref (Block79Data* _data79_) {
	g_atomic_int_inc (&_data79_->_ref_count_);
	return _data79_;
}


static void block79_data_unref (void * _userdata_) {
	Block79Data* _data79_;
	_data79_ = (Block79Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data79_->_ref_count_)) {
		SqlDatabase* self;
		self = _data79_->self;
		_g_object_unref0 (self);
		g_slice_free (Block79Data, _data79_);
	}
}


static gint __lambda4_ (Block79Data* _data79_, gint n_cols, gchar** vals, int vals_length1) {
	SqlDatabase* self;
	gint result = 0;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	const gchar* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	self = _data79_->self;
	_tmp0_ = vals;
	_tmp0__length1 = vals_length1;
	_tmp1_ = _tmp0_[0];
	_tmp2_ = atoi (_tmp1_);
	_data79_->user_version = _tmp2_;
	result = SQL_STOP;
	return result;
}


static gint ___lambda4__sqlite3_callback (gpointer self, gint n_columns, gchar** values, gchar** column_names) {
	gint result;
	result = __lambda4_ (self, n_columns, values, -1);
	return result;
}


static gint _sqlite3_exec (sqlite3* self, const gchar* sql, sqlite3_callback callback, void* callback_target, gchar** errmsg) {
	gchar* _vala_errmsg = NULL;
	gint result = 0;
	const gchar* sqlite_errmsg = NULL;
	gint ec = 0;
	const gchar* _tmp0_ = NULL;
	sqlite3_callback _tmp1_ = NULL;
	void* _tmp1__target = NULL;
	const gchar* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	const gchar* _tmp6_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (sql != NULL, 0);
	_tmp0_ = sql;
	_tmp1_ = callback;
	_tmp1__target = callback_target;
	_tmp3_ = sqlite3_exec (self, _tmp0_, _tmp1_, _tmp1__target, (char**) (&_tmp2_));
	sqlite_errmsg = _tmp2_;
	ec = _tmp3_;
	if ((&_vala_errmsg) != NULL) {
		const gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		_tmp4_ = sqlite_errmsg;
		_tmp5_ = g_strdup (_tmp4_);
		_g_free0 (_vala_errmsg);
		_vala_errmsg = _tmp5_;
	}
	_tmp6_ = sqlite_errmsg;
	sqlite3_free ((void*) _tmp6_);
	result = ec;
	if (errmsg) {
		*errmsg = _vala_errmsg;
	} else {
		_g_free0 (_vala_errmsg);
	}
	return result;
}


SqlDatabase* sql_database_construct (GType object_type, const gchar* filename, const gchar* init_file, gint max_version) {
	SqlDatabase * self = NULL;
	Block79Data* _data79_;
	gint err = 0;
	const gchar* _tmp0_ = NULL;
	sqlite3* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (filename != NULL, NULL);
	g_return_val_if_fail (init_file != NULL, NULL);
	_data79_ = g_slice_new0 (Block79Data);
	_data79_->_ref_count_ = 1;
	self = (SqlDatabase*) g_object_new (object_type, NULL);
	_data79_->self = g_object_ref (self);
	_tmp0_ = filename;
	_tmp2_ = sqlite3_open (_tmp0_, &_tmp1_);
	_sqlite3_close0 (self->priv->db);
	self->priv->db = _tmp1_;
	err = _tmp2_;
	_tmp3_ = err;
	if (_tmp3_ != 0) {
		const gchar* _tmp4_ = NULL;
		sqlite3* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		_tmp4_ = filename;
		_tmp5_ = self->priv->db;
		_tmp6_ = sqlite3_errmsg (_tmp5_);
		g_critical ("Database.vala:34: Error when opening the database '%s': %s", _tmp4_, _tmp6_);
	}
	sql_database_exec (self, "PRAGMA journal_mode = MEMORY;", NULL, NULL);
	_data79_->user_version = 0;
	sql_database_exec (self, "pragma user_version;", ___lambda4__sqlite3_callback, _data79_);
	{
		gint cur_version = 0;
		gint _tmp7_ = 0;
		_tmp7_ = _data79_->user_version;
		cur_version = _tmp7_ + 1;
		{
			gboolean _tmp8_ = FALSE;
			_tmp8_ = TRUE;
			while (TRUE) {
				gint _tmp10_ = 0;
				gint _tmp11_ = 0;
				if (!_tmp8_) {
					gint _tmp9_ = 0;
					_tmp9_ = cur_version;
					cur_version = _tmp9_ + 1;
				}
				_tmp8_ = FALSE;
				_tmp10_ = cur_version;
				_tmp11_ = max_version;
				if (!(_tmp10_ <= _tmp11_)) {
					break;
				}
				{
					GBytes* data = NULL;
					const gchar* _tmp12_ = NULL;
					gint _tmp13_ = 0;
					gchar* _tmp14_ = NULL;
					gchar* _tmp15_ = NULL;
					GBytes* _tmp16_ = NULL;
					GBytes* _tmp17_ = NULL;
					const gchar* sql_str = NULL;
					GBytes* _tmp18_ = NULL;
					gsize _tmp19_;
					guint8* _tmp20_ = NULL;
					const gchar* _tmp21_ = NULL;
					gint _tmp22_ = 0;
					sqlite3* _tmp23_ = NULL;
					const gchar* _tmp24_ = NULL;
					_tmp12_ = init_file;
					_tmp13_ = cur_version;
					_tmp14_ = g_strdup_printf (_tmp12_, _tmp13_);
					_tmp15_ = _tmp14_;
					_tmp16_ = g_resources_lookup_data (_tmp15_, 0, &_inner_error_);
					_tmp17_ = _tmp16_;
					_g_free0 (_tmp15_);
					data = _tmp17_;
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						goto __catch95_g_error;
					}
					_tmp18_ = data;
					_tmp20_ = g_bytes_get_data (_tmp18_, &_tmp19_);
					sql_str = (const gchar*) _tmp20_;
					_tmp21_ = init_file;
					_tmp22_ = cur_version;
					g_debug ("Database.vala:47: Executing %s for %d", _tmp21_, _tmp22_);
					_tmp23_ = self->priv->db;
					_tmp24_ = sql_str;
					_sqlite3_exec (_tmp23_, _tmp24_, NULL, NULL, NULL);
					_g_bytes_unref0 (data);
				}
				goto __finally95;
				__catch95_g_error:
				{
					GError* e = NULL;
					GError* _tmp25_ = NULL;
					const gchar* _tmp26_ = NULL;
					e = _inner_error_;
					_inner_error_ = NULL;
					_tmp25_ = e;
					_tmp26_ = _tmp25_->message;
					g_critical ("Database.vala:50: %s", _tmp26_);
					_g_error_free0 (e);
					break;
				}
				__finally95:
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					block79_data_unref (_data79_);
					_data79_ = NULL;
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
		}
	}
	block79_data_unref (_data79_);
	_data79_ = NULL;
	return self;
}


SqlDatabase* sql_database_new (const gchar* filename, const gchar* init_file, gint max_version) {
	return sql_database_construct (SQL_TYPE_DATABASE, filename, init_file, max_version);
}


void sql_database_exec (SqlDatabase* self, const gchar* sql, sqlite3_callback callback, void* callback_target) {
	sqlite3* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	sqlite3_callback _tmp2_ = NULL;
	void* _tmp2__target = NULL;
	g_return_if_fail (SQL_IS_DATABASE (self));
	g_return_if_fail (sql != NULL);
	_tmp0_ = self->priv->db;
	_tmp1_ = sql;
	_tmp2_ = callback;
	_tmp2__target = callback_target;
	_sqlite3_exec (_tmp0_, _tmp1_, _tmp2_, _tmp2__target, NULL);
}


SqlInsertStatement* sql_database_insert (SqlDatabase* self, const gchar* table_name) {
	SqlInsertStatement* result = NULL;
	SqlInsertStatement* stmt = NULL;
	const gchar* _tmp0_ = NULL;
	SqlInsertStatement* _tmp1_ = NULL;
	sqlite3* _tmp2_ = NULL;
	g_return_val_if_fail (SQL_IS_DATABASE (self), NULL);
	g_return_val_if_fail (table_name != NULL, NULL);
	_tmp0_ = table_name;
	_tmp1_ = sql_insert_statement_new (_tmp0_, FALSE);
	stmt = _tmp1_;
	_tmp2_ = self->priv->db;
	stmt->db = _tmp2_;
	result = stmt;
	return result;
}


SqlInsertStatement* sql_database_replace (SqlDatabase* self, const gchar* table_name) {
	SqlInsertStatement* result = NULL;
	SqlInsertStatement* stmt = NULL;
	const gchar* _tmp0_ = NULL;
	SqlInsertStatement* _tmp1_ = NULL;
	sqlite3* _tmp2_ = NULL;
	g_return_val_if_fail (SQL_IS_DATABASE (self), NULL);
	g_return_val_if_fail (table_name != NULL, NULL);
	_tmp0_ = table_name;
	_tmp1_ = sql_insert_statement_new (_tmp0_, TRUE);
	stmt = _tmp1_;
	_tmp2_ = self->priv->db;
	stmt->db = _tmp2_;
	result = stmt;
	return result;
}


SqlSelectStatement* sql_database_select (SqlDatabase* self, const gchar* table_name) {
	SqlSelectStatement* result = NULL;
	SqlSelectStatement* stmt = NULL;
	const gchar* _tmp0_ = NULL;
	SqlSelectStatement* _tmp1_ = NULL;
	sqlite3* _tmp2_ = NULL;
	g_return_val_if_fail (SQL_IS_DATABASE (self), NULL);
	g_return_val_if_fail (table_name != NULL, NULL);
	_tmp0_ = table_name;
	_tmp1_ = sql_select_statement_new (_tmp0_);
	stmt = _tmp1_;
	_tmp2_ = self->priv->db;
	stmt->db = _tmp2_;
	result = stmt;
	return result;
}


SqlUpdateStatement* sql_database_update (SqlDatabase* self, const gchar* table_name) {
	SqlUpdateStatement* result = NULL;
	SqlUpdateStatement* stmt = NULL;
	const gchar* _tmp0_ = NULL;
	SqlUpdateStatement* _tmp1_ = NULL;
	sqlite3* _tmp2_ = NULL;
	g_return_val_if_fail (SQL_IS_DATABASE (self), NULL);
	g_return_val_if_fail (table_name != NULL, NULL);
	_tmp0_ = table_name;
	_tmp1_ = sql_update_statement_new (_tmp0_);
	stmt = _tmp1_;
	_tmp2_ = self->priv->db;
	stmt->db = _tmp2_;
	result = stmt;
	return result;
}


void sql_database_begin_transaction (SqlDatabase* self) {
	sqlite3* _tmp0_ = NULL;
	g_return_if_fail (SQL_IS_DATABASE (self));
	_tmp0_ = self->priv->db;
	_sqlite3_exec (_tmp0_, "BEGIN TRANSACTION;", NULL, NULL, NULL);
}


void sql_database_end_transaction (SqlDatabase* self) {
	sqlite3* _tmp0_ = NULL;
	g_return_if_fail (SQL_IS_DATABASE (self));
	_tmp0_ = self->priv->db;
	_sqlite3_exec (_tmp0_, "END TRANSACTION;", NULL, NULL, NULL);
}


sqlite3* sql_database_get_sqlite_db (SqlDatabase* self) {
	sqlite3* result = NULL;
	sqlite3* _tmp0_ = NULL;
	g_return_val_if_fail (SQL_IS_DATABASE (self), NULL);
	_tmp0_ = self->priv->db;
	result = _tmp0_;
	return result;
}


static void sql_database_class_init (SqlDatabaseClass * klass) {
	sql_database_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SqlDatabasePrivate));
	G_OBJECT_CLASS (klass)->finalize = sql_database_finalize;
}


static void sql_database_instance_init (SqlDatabase * self) {
	self->priv = SQL_DATABASE_GET_PRIVATE (self);
}


static void sql_database_finalize (GObject* obj) {
	SqlDatabase * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SQL_TYPE_DATABASE, SqlDatabase);
	_sqlite3_close0 (self->priv->db);
	G_OBJECT_CLASS (sql_database_parent_class)->finalize (obj);
}


GType sql_database_get_type (void) {
	static volatile gsize sql_database_type_id__volatile = 0;
	if (g_once_init_enter (&sql_database_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SqlDatabaseClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sql_database_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SqlDatabase), 0, (GInstanceInitFunc) sql_database_instance_init, NULL };
		GType sql_database_type_id;
		sql_database_type_id = g_type_register_static (G_TYPE_OBJECT, "SqlDatabase", &g_define_type_info, 0);
		g_once_init_leave (&sql_database_type_id__volatile, sql_database_type_id);
	}
	return sql_database_type_id__volatile;
}



