/* ComposeImageManager.c generated by valac 0.34.6, the Vala compiler
 * generated from ComposeImageManager.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <cairo.h>
#include <gdk/gdk.h>
#include <stdlib.h>
#include <string.h>
#include <gdk-pixbuf/gdk-pixbuf.h>


#define TYPE_COMPOSE_IMAGE_MANAGER (compose_image_manager_get_type ())
#define COMPOSE_IMAGE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPOSE_IMAGE_MANAGER, ComposeImageManager))
#define COMPOSE_IMAGE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPOSE_IMAGE_MANAGER, ComposeImageManagerClass))
#define IS_COMPOSE_IMAGE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPOSE_IMAGE_MANAGER))
#define IS_COMPOSE_IMAGE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPOSE_IMAGE_MANAGER))
#define COMPOSE_IMAGE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPOSE_IMAGE_MANAGER, ComposeImageManagerClass))

typedef struct _ComposeImageManager ComposeImageManager;
typedef struct _ComposeImageManagerClass ComposeImageManagerClass;
typedef struct _ComposeImageManagerPrivate ComposeImageManagerPrivate;

#define TYPE_ADD_IMAGE_BUTTON (add_image_button_get_type ())
#define ADD_IMAGE_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ADD_IMAGE_BUTTON, AddImageButton))
#define ADD_IMAGE_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ADD_IMAGE_BUTTON, AddImageButtonClass))
#define IS_ADD_IMAGE_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ADD_IMAGE_BUTTON))
#define IS_ADD_IMAGE_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ADD_IMAGE_BUTTON))
#define ADD_IMAGE_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ADD_IMAGE_BUTTON, AddImageButtonClass))

typedef struct _AddImageButton AddImageButton;
typedef struct _AddImageButtonClass AddImageButtonClass;
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
typedef struct _Block51Data Block51Data;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
typedef struct _AddImageButtonPrivate AddImageButtonPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ComposeImageManager {
	GtkContainer parent_instance;
	ComposeImageManagerPrivate * priv;
};

struct _ComposeImageManagerClass {
	GtkContainerClass parent_class;
};

struct _ComposeImageManagerPrivate {
	GPtrArray* buttons;
	GPtrArray* close_buttons;
};

struct _Block51Data {
	int _ref_count_;
	ComposeImageManager* self;
	gint index;
};

struct _AddImageButton {
	GtkWidget parent_instance;
	AddImageButtonPrivate * priv;
	gchar* image_path;
	cairo_surface_t* surface;
};

struct _AddImageButtonClass {
	GtkWidgetClass parent_class;
};


static gpointer compose_image_manager_parent_class = NULL;

GType compose_image_manager_get_type (void) G_GNUC_CONST;
GType add_image_button_get_type (void) G_GNUC_CONST;
#define COMPOSE_IMAGE_MANAGER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_COMPOSE_IMAGE_MANAGER, ComposeImageManagerPrivate))
enum  {
	COMPOSE_IMAGE_MANAGER_DUMMY_PROPERTY,
	COMPOSE_IMAGE_MANAGER_N_IMAGES
};
#define COMPOSE_IMAGE_MANAGER_BUTTON_DELTA 10
#define COMPOSE_IMAGE_MANAGER_BUTTON_SPACING 12
static void compose_image_manager_remove_clicked_cb (ComposeImageManager* self, GtkButton* source);
static Block51Data* block51_data_ref (Block51Data* _data51_);
static void block51_data_unref (void * _userdata_);
static void __lambda42_ (Block51Data* _data51_);
static void ___lambda42__add_image_button_deleted (AddImageButton* _sender, gpointer self);
void add_image_button_start_remove (AddImageButton* self);
static void compose_image_manager_real_forall_internal (GtkContainer* base, gboolean include_internals, GtkCallback cb, void* cb_target);
static void compose_image_manager_real_add (GtkContainer* base, GtkWidget* widget);
static void _compose_image_manager_remove_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void compose_image_manager_real_remove (GtkContainer* base, GtkWidget* widget);
static GtkSizeRequestMode compose_image_manager_real_get_request_mode (GtkWidget* base);
static void compose_image_manager_real_size_allocate (GtkWidget* base, GtkAllocation* allocation);
static void compose_image_manager_real_get_preferred_height_for_width (GtkWidget* base, gint width, gint* minimum, gint* natural);
static void compose_image_manager_real_get_preferred_height (GtkWidget* base, gint* minimum, gint* natural);
static void compose_image_manager_real_get_preferred_width (GtkWidget* base, gint* minimum, gint* natural);
static gboolean compose_image_manager_real_draw (GtkWidget* base, cairo_t* ct);
void compose_image_manager_load_image (ComposeImageManager* self, const gchar* path, GdkPixbuf* image);
cairo_surface_t* load_surface (const gchar* path);
AddImageButton* add_image_button_new (void);
AddImageButton* add_image_button_construct (GType object_type);
gchar** compose_image_manager_get_image_paths (ComposeImageManager* self, int* result_length1);
void compose_image_manager_start_progress (ComposeImageManager* self, const gchar* image_path);
void compose_image_manager_end_progress (ComposeImageManager* self, const gchar* image_path, const gchar* error_message);
ComposeImageManager* compose_image_manager_new (void);
ComposeImageManager* compose_image_manager_construct (GType object_type);
gint compose_image_manager_get_n_images (ComposeImageManager* self);
static GObject * compose_image_manager_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void _g_object_unref0_ (gpointer var);
static void compose_image_manager_finalize (GObject* obj);
static void _vala_compose_image_manager_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static Block51Data* block51_data_ref (Block51Data* _data51_) {
	g_atomic_int_inc (&_data51_->_ref_count_);
	return _data51_;
}


static void block51_data_unref (void * _userdata_) {
	Block51Data* _data51_;
	_data51_ = (Block51Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data51_->_ref_count_)) {
		ComposeImageManager* self;
		self = _data51_->self;
		_g_object_unref0 (self);
		g_slice_free (Block51Data, _data51_);
	}
}


static gint g_ptr_array_get_length (GPtrArray* self) {
	gint result;
	guint _tmp0_ = 0U;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->len;
	result = (gint) _tmp0_;
	return result;
}


static void g_ptr_array_set_length (GPtrArray* self, gint value) {
	gint _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	g_ptr_array_set_size (self, _tmp0_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void __lambda42_ (Block51Data* _data51_) {
	ComposeImageManager* self;
	GPtrArray* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	GPtrArray* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	self = _data51_->self;
	_tmp0_ = self->priv->buttons;
	_tmp1_ = _data51_->index;
	g_ptr_array_remove_index (_tmp0_, (guint) _tmp1_);
	_tmp2_ = self->priv->close_buttons;
	_tmp3_ = _data51_->index;
	g_ptr_array_remove_index (_tmp2_, (guint) _tmp3_);
	g_signal_emit_by_name (self, "image-removed");
	gtk_widget_queue_draw (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
}


static void ___lambda42__add_image_button_deleted (AddImageButton* _sender, gpointer self) {
	__lambda42_ (self);
}


static void compose_image_manager_remove_clicked_cb (ComposeImageManager* self, GtkButton* source) {
	Block51Data* _data51_;
	gint _tmp11_ = 0;
	GPtrArray* _tmp12_ = NULL;
	gint _tmp13_ = 0;
	gconstpointer _tmp14_ = NULL;
	AddImageButton* aib = NULL;
	GPtrArray* _tmp15_ = NULL;
	gint _tmp16_ = 0;
	gconstpointer _tmp17_ = NULL;
	AddImageButton* _tmp18_ = NULL;
	g_return_if_fail (IS_COMPOSE_IMAGE_MANAGER (self));
	g_return_if_fail (GTK_IS_BUTTON (source));
	_data51_ = g_slice_new0 (Block51Data);
	_data51_->_ref_count_ = 1;
	_data51_->self = g_object_ref (self);
	_data51_->index = -1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_ = 0;
				GPtrArray* _tmp3_ = NULL;
				gint _tmp4_ = 0;
				gint _tmp5_ = 0;
				GPtrArray* _tmp6_ = NULL;
				gint _tmp7_ = 0;
				gconstpointer _tmp8_ = NULL;
				GtkButton* _tmp9_ = NULL;
				if (!_tmp0_) {
					gint _tmp1_ = 0;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				_tmp3_ = self->priv->close_buttons;
				_tmp4_ = g_ptr_array_get_length (_tmp3_);
				_tmp5_ = _tmp4_;
				if (!(_tmp2_ < _tmp5_)) {
					break;
				}
				_tmp6_ = self->priv->close_buttons;
				_tmp7_ = i;
				_tmp8_ = g_ptr_array_index (_tmp6_, (guint) _tmp7_);
				_tmp9_ = source;
				if (((GtkButton*) _tmp8_) == _tmp9_) {
					gint _tmp10_ = 0;
					_tmp10_ = i;
					_data51_->index = _tmp10_;
					break;
				}
			}
		}
	}
	_tmp11_ = _data51_->index;
	_vala_assert (_tmp11_ >= 0, "index >= 0");
	_tmp12_ = self->priv->close_buttons;
	_tmp13_ = _data51_->index;
	_tmp14_ = g_ptr_array_index (_tmp12_, (guint) _tmp13_);
	gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST ((GtkButton*) _tmp14_, gtk_widget_get_type (), GtkWidget));
	_tmp15_ = self->priv->buttons;
	_tmp16_ = _data51_->index;
	_tmp17_ = g_ptr_array_index (_tmp15_, (guint) _tmp16_);
	_tmp18_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST ((AddImageButton*) _tmp17_, TYPE_ADD_IMAGE_BUTTON, AddImageButton));
	aib = _tmp18_;
	g_signal_connect_data (aib, "deleted", (GCallback) ___lambda42__add_image_button_deleted, block51_data_ref (_data51_), (GClosureNotify) block51_data_unref, 0);
	add_image_button_start_remove (aib);
	_g_object_unref0 (aib);
	block51_data_unref (_data51_);
	_data51_ = NULL;
}


static void compose_image_manager_real_forall_internal (GtkContainer* base, gboolean include_internals, GtkCallback cb, void* cb_target) {
	ComposeImageManager * self;
	GPtrArray* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	GPtrArray* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_COMPOSE_IMAGE_MANAGER, ComposeImageManager);
	_tmp0_ = self->priv->buttons;
	_tmp1_ = g_ptr_array_get_length (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->close_buttons;
	_tmp4_ = g_ptr_array_get_length (_tmp3_);
	_tmp5_ = _tmp4_;
	_vala_assert (_tmp2_ == _tmp5_, "buttons.length == close_buttons.length");
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp6_ = FALSE;
			_tmp6_ = TRUE;
			while (TRUE) {
				gint _tmp7_ = 0;
				GPtrArray* _tmp8_ = NULL;
				gint _tmp9_ = 0;
				gint _tmp10_ = 0;
				gint size_before = 0;
				GPtrArray* _tmp11_ = NULL;
				gint _tmp12_ = 0;
				gint _tmp13_ = 0;
				GtkCallback _tmp14_ = NULL;
				void* _tmp14__target = NULL;
				GPtrArray* _tmp15_ = NULL;
				gint _tmp16_ = 0;
				gconstpointer _tmp17_ = NULL;
				gint _tmp18_ = 0;
				GPtrArray* _tmp19_ = NULL;
				gint _tmp20_ = 0;
				gint _tmp21_ = 0;
				gint _tmp22_ = 0;
				if (!_tmp6_) {
				}
				_tmp6_ = FALSE;
				_tmp7_ = i;
				_tmp8_ = self->priv->close_buttons;
				_tmp9_ = g_ptr_array_get_length (_tmp8_);
				_tmp10_ = _tmp9_;
				if (!(_tmp7_ < _tmp10_)) {
					break;
				}
				_tmp11_ = self->priv->close_buttons;
				_tmp12_ = g_ptr_array_get_length (_tmp11_);
				_tmp13_ = _tmp12_;
				size_before = _tmp13_;
				_tmp14_ = cb;
				_tmp14__target = cb_target;
				_tmp15_ = self->priv->close_buttons;
				_tmp16_ = i;
				_tmp17_ = g_ptr_array_index (_tmp15_, (guint) _tmp16_);
				_tmp14_ (G_TYPE_CHECK_INSTANCE_CAST ((GtkButton*) _tmp17_, gtk_widget_get_type (), GtkWidget), _tmp14__target);
				_tmp18_ = i;
				_tmp19_ = self->priv->close_buttons;
				_tmp20_ = g_ptr_array_get_length (_tmp19_);
				_tmp21_ = _tmp20_;
				_tmp22_ = size_before;
				i = _tmp18_ + ((_tmp21_ - _tmp22_) + 1);
			}
		}
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp23_ = FALSE;
			_tmp23_ = TRUE;
			while (TRUE) {
				gint _tmp24_ = 0;
				GPtrArray* _tmp25_ = NULL;
				gint _tmp26_ = 0;
				gint _tmp27_ = 0;
				gint size_before = 0;
				GPtrArray* _tmp28_ = NULL;
				gint _tmp29_ = 0;
				gint _tmp30_ = 0;
				GtkCallback _tmp31_ = NULL;
				void* _tmp31__target = NULL;
				GPtrArray* _tmp32_ = NULL;
				gint _tmp33_ = 0;
				gconstpointer _tmp34_ = NULL;
				gint _tmp35_ = 0;
				GPtrArray* _tmp36_ = NULL;
				gint _tmp37_ = 0;
				gint _tmp38_ = 0;
				gint _tmp39_ = 0;
				if (!_tmp23_) {
				}
				_tmp23_ = FALSE;
				_tmp24_ = i;
				_tmp25_ = self->priv->buttons;
				_tmp26_ = g_ptr_array_get_length (_tmp25_);
				_tmp27_ = _tmp26_;
				if (!(_tmp24_ < _tmp27_)) {
					break;
				}
				_tmp28_ = self->priv->buttons;
				_tmp29_ = g_ptr_array_get_length (_tmp28_);
				_tmp30_ = _tmp29_;
				size_before = _tmp30_;
				_tmp31_ = cb;
				_tmp31__target = cb_target;
				_tmp32_ = self->priv->buttons;
				_tmp33_ = i;
				_tmp34_ = g_ptr_array_index (_tmp32_, (guint) _tmp33_);
				_tmp31_ (G_TYPE_CHECK_INSTANCE_CAST ((AddImageButton*) _tmp34_, gtk_widget_get_type (), GtkWidget), _tmp31__target);
				_tmp35_ = i;
				_tmp36_ = self->priv->buttons;
				_tmp37_ = g_ptr_array_get_length (_tmp36_);
				_tmp38_ = _tmp37_;
				_tmp39_ = size_before;
				i = _tmp35_ + ((_tmp38_ - _tmp39_) + 1);
			}
		}
	}
}


static void _compose_image_manager_remove_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	compose_image_manager_remove_clicked_cb ((ComposeImageManager*) self, _sender);
}


static void compose_image_manager_real_add (GtkContainer* base, GtkWidget* widget) {
	ComposeImageManager * self;
	GtkWidget* _tmp0_ = NULL;
	GPtrArray* _tmp1_ = NULL;
	GtkWidget* _tmp2_ = NULL;
	AddImageButton* _tmp3_ = NULL;
	GtkButton* btn = NULL;
	GtkButton* _tmp4_ = NULL;
	GtkStyleContext* _tmp5_ = NULL;
	GtkStyleContext* _tmp6_ = NULL;
	GPtrArray* _tmp7_ = NULL;
	GtkButton* _tmp8_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_COMPOSE_IMAGE_MANAGER, ComposeImageManager);
	g_return_if_fail (GTK_IS_WIDGET (widget));
	_tmp0_ = widget;
	gtk_widget_set_parent (_tmp0_, (GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_container_get_type (), GtkContainer));
	_tmp1_ = self->priv->buttons;
	_tmp2_ = widget;
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_ADD_IMAGE_BUTTON, AddImageButton));
	g_ptr_array_add (_tmp1_, _tmp3_);
	_tmp4_ = (GtkButton*) gtk_button_new_from_icon_name ("window-close-symbolic", GTK_ICON_SIZE_BUTTON);
	g_object_ref_sink (_tmp4_);
	btn = _tmp4_;
	gtk_widget_set_parent (G_TYPE_CHECK_INSTANCE_CAST (btn, gtk_widget_get_type (), GtkWidget), (GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_container_get_type (), GtkContainer));
	_tmp5_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (btn, gtk_widget_get_type (), GtkWidget));
	gtk_style_context_add_class (_tmp5_, "image-button");
	_tmp6_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (btn, gtk_widget_get_type (), GtkWidget));
	gtk_style_context_add_class (_tmp6_, "close-button");
	g_signal_connect_object (btn, "clicked", (GCallback) _compose_image_manager_remove_clicked_cb_gtk_button_clicked, self, 0);
	gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (btn, gtk_widget_get_type (), GtkWidget));
	_tmp7_ = self->priv->close_buttons;
	_tmp8_ = _g_object_ref0 (btn);
	g_ptr_array_add (_tmp7_, _tmp8_);
	_g_object_unref0 (btn);
}


static void compose_image_manager_real_remove (GtkContainer* base, GtkWidget* widget) {
	ComposeImageManager * self;
	GtkWidget* _tmp0_ = NULL;
	GtkWidget* _tmp1_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_COMPOSE_IMAGE_MANAGER, ComposeImageManager);
	g_return_if_fail (GTK_IS_WIDGET (widget));
	_tmp0_ = widget;
	gtk_widget_unparent (_tmp0_);
	_tmp1_ = widget;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, TYPE_ADD_IMAGE_BUTTON)) {
		GPtrArray* _tmp2_ = NULL;
		GtkWidget* _tmp3_ = NULL;
		_tmp2_ = self->priv->buttons;
		_tmp3_ = widget;
		g_ptr_array_remove (_tmp2_, G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, TYPE_ADD_IMAGE_BUTTON, AddImageButton));
	} else {
		GPtrArray* _tmp4_ = NULL;
		GtkWidget* _tmp5_ = NULL;
		_tmp4_ = self->priv->close_buttons;
		_tmp5_ = widget;
		g_ptr_array_remove (_tmp4_, G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_button_get_type (), GtkButton));
	}
}


static GtkSizeRequestMode compose_image_manager_real_get_request_mode (GtkWidget* base) {
	ComposeImageManager * self;
	GtkSizeRequestMode result = 0;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_COMPOSE_IMAGE_MANAGER, ComposeImageManager);
	result = GTK_SIZE_REQUEST_HEIGHT_FOR_WIDTH;
	return result;
}


static void compose_image_manager_real_size_allocate (GtkWidget* base, GtkAllocation* allocation) {
	ComposeImageManager * self;
	GtkAllocation _tmp0_ = {0};
	GtkAllocation child_allocation = {0};
	GtkAllocation _tmp1_ = {0};
	GPtrArray* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint default_button_width = 0;
	GtkAllocation _tmp5_ = {0};
	gint _tmp6_ = 0;
	GPtrArray* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	GPtrArray* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
	GtkAllocation _tmp13_ = {0};
	gint _tmp14_ = 0;
	GtkAllocation _tmp15_ = {0};
	gint _tmp16_ = 0;
	GtkAllocation _tmp17_ = {0};
	gint _tmp18_ = 0;
	gint _tmp19_ = 0;
	GtkAllocation close_allocation = {0};
	GtkAllocation _tmp20_ = {0};
	GtkAllocation _tmp21_ = {0};
	gint _tmp22_ = 0;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_COMPOSE_IMAGE_MANAGER, ComposeImageManager);
	g_return_if_fail (allocation != NULL);
	_tmp0_ = *allocation;
	GTK_WIDGET_CLASS (compose_image_manager_parent_class)->size_allocate (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_container_get_type (), GtkContainer), gtk_widget_get_type (), GtkWidget), &_tmp0_);
	child_allocation = _tmp1_;
	_tmp2_ = self->priv->buttons;
	_tmp3_ = g_ptr_array_get_length (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ == 0) {
		return;
	}
	_tmp5_ = *allocation;
	_tmp6_ = _tmp5_.width;
	_tmp7_ = self->priv->buttons;
	_tmp8_ = g_ptr_array_get_length (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = self->priv->buttons;
	_tmp11_ = g_ptr_array_get_length (_tmp10_);
	_tmp12_ = _tmp11_;
	default_button_width = (_tmp6_ - (_tmp9_ * COMPOSE_IMAGE_MANAGER_BUTTON_SPACING)) / _tmp12_;
	_tmp13_ = *allocation;
	_tmp14_ = _tmp13_.x;
	child_allocation.x = _tmp14_;
	_tmp15_ = *allocation;
	_tmp16_ = _tmp15_.y;
	child_allocation.y = _tmp16_ + COMPOSE_IMAGE_MANAGER_BUTTON_DELTA;
	_tmp17_ = *allocation;
	_tmp18_ = _tmp17_.height;
	_tmp19_ = MAX (_tmp18_ - COMPOSE_IMAGE_MANAGER_BUTTON_DELTA, 0);
	child_allocation.height = _tmp19_;
	close_allocation = _tmp20_;
	_tmp21_ = *allocation;
	_tmp22_ = _tmp21_.y;
	close_allocation.y = _tmp22_;
	{
		gint i = 0;
		gint p = 0;
		GPtrArray* _tmp23_ = NULL;
		gint _tmp24_ = 0;
		gint _tmp25_ = 0;
		i = 0;
		_tmp23_ = self->priv->buttons;
		_tmp24_ = g_ptr_array_get_length (_tmp23_);
		_tmp25_ = _tmp24_;
		p = _tmp25_;
		{
			gboolean _tmp26_ = FALSE;
			_tmp26_ = TRUE;
			while (TRUE) {
				gint _tmp28_ = 0;
				gint _tmp29_ = 0;
				gint min = 0;
				gint nat = 0;
				AddImageButton* aib = NULL;
				GPtrArray* _tmp30_ = NULL;
				gint _tmp31_ = 0;
				gconstpointer _tmp32_ = NULL;
				AddImageButton* _tmp33_ = NULL;
				AddImageButton* _tmp34_ = NULL;
				GtkAllocation _tmp35_ = {0};
				gint _tmp36_ = 0;
				gint _tmp37_ = 0;
				gint _tmp38_ = 0;
				gint _tmp39_ = 0;
				gint _tmp40_ = 0;
				gint _tmp41_ = 0;
				AddImageButton* _tmp42_ = NULL;
				GtkAllocation _tmp43_ = {0};
				gint n = 0;
				GtkWidget* btn = NULL;
				GPtrArray* _tmp44_ = NULL;
				gint _tmp45_ = 0;
				gconstpointer _tmp46_ = NULL;
				GtkWidget* _tmp47_ = NULL;
				GtkWidget* _tmp48_ = NULL;
				gint _tmp49_ = 0;
				gint _tmp50_ = 0;
				GtkWidget* _tmp51_ = NULL;
				gint _tmp52_ = 0;
				gint _tmp53_ = 0;
				GtkAllocation _tmp54_ = {0};
				gint _tmp55_ = 0;
				GtkAllocation _tmp56_ = {0};
				gint _tmp57_ = 0;
				GtkAllocation _tmp58_ = {0};
				gint _tmp59_ = 0;
				GtkWidget* _tmp60_ = NULL;
				GtkAllocation _tmp61_ = {0};
				gint _tmp62_ = 0;
				GtkAllocation _tmp63_ = {0};
				gint _tmp64_ = 0;
				if (!_tmp26_) {
					gint _tmp27_ = 0;
					_tmp27_ = i;
					i = _tmp27_ + 1;
				}
				_tmp26_ = FALSE;
				_tmp28_ = i;
				_tmp29_ = p;
				if (!(_tmp28_ < _tmp29_)) {
					break;
				}
				_tmp30_ = self->priv->buttons;
				_tmp31_ = i;
				_tmp32_ = g_ptr_array_index (_tmp30_, (guint) _tmp31_);
				_tmp33_ = _g_object_ref0 ((AddImageButton*) _tmp32_);
				aib = _tmp33_;
				_tmp34_ = aib;
				_tmp35_ = child_allocation;
				_tmp36_ = _tmp35_.height;
				gtk_widget_get_preferred_width_for_height (G_TYPE_CHECK_INSTANCE_CAST (_tmp34_, gtk_widget_get_type (), GtkWidget), _tmp36_, &_tmp37_, &_tmp38_);
				min = _tmp37_;
				nat = _tmp38_;
				_tmp39_ = default_button_width;
				_tmp40_ = nat;
				_tmp41_ = MIN (_tmp39_, _tmp40_);
				child_allocation.width = _tmp41_;
				_tmp42_ = aib;
				_tmp43_ = child_allocation;
				gtk_widget_size_allocate (G_TYPE_CHECK_INSTANCE_CAST (_tmp42_, gtk_widget_get_type (), GtkWidget), &_tmp43_);
				_tmp44_ = self->priv->close_buttons;
				_tmp45_ = i;
				_tmp46_ = g_ptr_array_index (_tmp44_, (guint) _tmp45_);
				_tmp47_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST ((GtkButton*) _tmp46_, gtk_widget_get_type (), GtkWidget));
				btn = _tmp47_;
				_tmp48_ = btn;
				gtk_widget_get_preferred_width (_tmp48_, &_tmp49_, &_tmp50_);
				close_allocation.width = _tmp49_;
				n = _tmp50_;
				_tmp51_ = btn;
				gtk_widget_get_preferred_height (_tmp51_, &_tmp52_, &_tmp53_);
				close_allocation.height = _tmp52_;
				n = _tmp53_;
				_tmp54_ = child_allocation;
				_tmp55_ = _tmp54_.x;
				_tmp56_ = child_allocation;
				_tmp57_ = _tmp56_.width;
				_tmp58_ = close_allocation;
				_tmp59_ = _tmp58_.width;
				close_allocation.x = ((_tmp55_ + _tmp57_) - _tmp59_) + COMPOSE_IMAGE_MANAGER_BUTTON_DELTA;
				_tmp60_ = btn;
				_tmp61_ = close_allocation;
				gtk_widget_size_allocate (_tmp60_, &_tmp61_);
				_tmp62_ = child_allocation.x;
				_tmp63_ = child_allocation;
				_tmp64_ = _tmp63_.width;
				child_allocation.x = _tmp62_ + (_tmp64_ + COMPOSE_IMAGE_MANAGER_BUTTON_SPACING);
				_g_object_unref0 (btn);
				_g_object_unref0 (aib);
			}
		}
	}
}


static void compose_image_manager_real_get_preferred_height_for_width (GtkWidget* base, gint width, gint* minimum, gint* natural) {
	ComposeImageManager * self;
	gint _vala_minimum = 0;
	gint _vala_natural = 0;
	gint min = 0;
	gint nat = 0;
	gint _tmp20_ = 0;
	gint _tmp21_ = 0;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_COMPOSE_IMAGE_MANAGER, ComposeImageManager);
	min = 0;
	nat = 0;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_ = 0;
				GPtrArray* _tmp3_ = NULL;
				gint _tmp4_ = 0;
				gint _tmp5_ = 0;
				AddImageButton* btn = NULL;
				GPtrArray* _tmp6_ = NULL;
				gint _tmp7_ = 0;
				gconstpointer _tmp8_ = NULL;
				AddImageButton* _tmp9_ = NULL;
				gint m = 0;
				gint n = 0;
				AddImageButton* _tmp10_ = NULL;
				gint _tmp11_ = 0;
				gint _tmp12_ = 0;
				gint _tmp13_ = 0;
				gint _tmp14_ = 0;
				gint _tmp15_ = 0;
				gint _tmp16_ = 0;
				gint _tmp17_ = 0;
				gint _tmp18_ = 0;
				gint _tmp19_ = 0;
				if (!_tmp0_) {
					gint _tmp1_ = 0;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				_tmp3_ = self->priv->buttons;
				_tmp4_ = g_ptr_array_get_length (_tmp3_);
				_tmp5_ = _tmp4_;
				if (!(_tmp2_ < _tmp5_)) {
					break;
				}
				_tmp6_ = self->priv->buttons;
				_tmp7_ = i;
				_tmp8_ = g_ptr_array_index (_tmp6_, (guint) _tmp7_);
				_tmp9_ = _g_object_ref0 ((AddImageButton*) _tmp8_);
				btn = _tmp9_;
				_tmp10_ = btn;
				_tmp11_ = width;
				gtk_widget_get_preferred_height_for_width (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gtk_widget_get_type (), GtkWidget), _tmp11_, &_tmp12_, &_tmp13_);
				m = _tmp12_;
				n = _tmp13_;
				_tmp14_ = m;
				_tmp15_ = min;
				_tmp16_ = MAX (_tmp14_, _tmp15_);
				min = _tmp16_;
				_tmp17_ = n;
				_tmp18_ = nat;
				_tmp19_ = MAX (_tmp17_, _tmp18_);
				nat = _tmp19_;
				_g_object_unref0 (btn);
			}
		}
	}
	_tmp20_ = min;
	_vala_minimum = _tmp20_ + COMPOSE_IMAGE_MANAGER_BUTTON_DELTA;
	_tmp21_ = nat;
	_vala_natural = _tmp21_ + COMPOSE_IMAGE_MANAGER_BUTTON_DELTA;
	if (minimum) {
		*minimum = _vala_minimum;
	}
	if (natural) {
		*natural = _vala_natural;
	}
}


static void compose_image_manager_real_get_preferred_height (GtkWidget* base, gint* minimum, gint* natural) {
	ComposeImageManager * self;
	gint _vala_minimum = 0;
	gint _vala_natural = 0;
	gint min = 0;
	gint nat = 0;
	gint _tmp19_ = 0;
	gint _tmp20_ = 0;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_COMPOSE_IMAGE_MANAGER, ComposeImageManager);
	min = 0;
	nat = 0;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_ = 0;
				GPtrArray* _tmp3_ = NULL;
				gint _tmp4_ = 0;
				gint _tmp5_ = 0;
				AddImageButton* btn = NULL;
				GPtrArray* _tmp6_ = NULL;
				gint _tmp7_ = 0;
				gconstpointer _tmp8_ = NULL;
				AddImageButton* _tmp9_ = NULL;
				gint m = 0;
				gint n = 0;
				AddImageButton* _tmp10_ = NULL;
				gint _tmp11_ = 0;
				gint _tmp12_ = 0;
				gint _tmp13_ = 0;
				gint _tmp14_ = 0;
				gint _tmp15_ = 0;
				gint _tmp16_ = 0;
				gint _tmp17_ = 0;
				gint _tmp18_ = 0;
				if (!_tmp0_) {
					gint _tmp1_ = 0;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				_tmp3_ = self->priv->buttons;
				_tmp4_ = g_ptr_array_get_length (_tmp3_);
				_tmp5_ = _tmp4_;
				if (!(_tmp2_ < _tmp5_)) {
					break;
				}
				_tmp6_ = self->priv->buttons;
				_tmp7_ = i;
				_tmp8_ = g_ptr_array_index (_tmp6_, (guint) _tmp7_);
				_tmp9_ = _g_object_ref0 ((AddImageButton*) _tmp8_);
				btn = _tmp9_;
				_tmp10_ = btn;
				gtk_widget_get_preferred_height (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gtk_widget_get_type (), GtkWidget), &_tmp11_, &_tmp12_);
				m = _tmp11_;
				n = _tmp12_;
				_tmp13_ = m;
				_tmp14_ = min;
				_tmp15_ = MAX (_tmp13_, _tmp14_);
				min = _tmp15_;
				_tmp16_ = n;
				_tmp17_ = nat;
				_tmp18_ = MAX (_tmp16_, _tmp17_);
				nat = _tmp18_;
				_g_object_unref0 (btn);
			}
		}
	}
	_tmp19_ = min;
	_vala_minimum = _tmp19_ + COMPOSE_IMAGE_MANAGER_BUTTON_DELTA;
	_tmp20_ = nat;
	_vala_natural = _tmp20_ + COMPOSE_IMAGE_MANAGER_BUTTON_DELTA;
	if (minimum) {
		*minimum = _vala_minimum;
	}
	if (natural) {
		*natural = _vala_natural;
	}
}


static void compose_image_manager_real_get_preferred_width (GtkWidget* base, gint* minimum, gint* natural) {
	ComposeImageManager * self;
	gint _vala_minimum = 0;
	gint _vala_natural = 0;
	gint min = 0;
	gint nat = 0;
	gint _tmp17_ = 0;
	GPtrArray* _tmp18_ = NULL;
	gint _tmp19_ = 0;
	gint _tmp20_ = 0;
	gint _tmp21_ = 0;
	GPtrArray* _tmp22_ = NULL;
	gint _tmp23_ = 0;
	gint _tmp24_ = 0;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_COMPOSE_IMAGE_MANAGER, ComposeImageManager);
	min = 0;
	nat = 0;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_ = 0;
				GPtrArray* _tmp3_ = NULL;
				gint _tmp4_ = 0;
				gint _tmp5_ = 0;
				AddImageButton* btn = NULL;
				GPtrArray* _tmp6_ = NULL;
				gint _tmp7_ = 0;
				gconstpointer _tmp8_ = NULL;
				AddImageButton* _tmp9_ = NULL;
				gint m = 0;
				gint n = 0;
				AddImageButton* _tmp10_ = NULL;
				gint _tmp11_ = 0;
				gint _tmp12_ = 0;
				gint _tmp13_ = 0;
				gint _tmp14_ = 0;
				gint _tmp15_ = 0;
				gint _tmp16_ = 0;
				if (!_tmp0_) {
					gint _tmp1_ = 0;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				_tmp3_ = self->priv->buttons;
				_tmp4_ = g_ptr_array_get_length (_tmp3_);
				_tmp5_ = _tmp4_;
				if (!(_tmp2_ < _tmp5_)) {
					break;
				}
				_tmp6_ = self->priv->buttons;
				_tmp7_ = i;
				_tmp8_ = g_ptr_array_index (_tmp6_, (guint) _tmp7_);
				_tmp9_ = _g_object_ref0 ((AddImageButton*) _tmp8_);
				btn = _tmp9_;
				_tmp10_ = btn;
				gtk_widget_get_preferred_width (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gtk_widget_get_type (), GtkWidget), &_tmp11_, &_tmp12_);
				m = _tmp11_;
				n = _tmp12_;
				_tmp13_ = min;
				_tmp14_ = m;
				min = _tmp13_ + _tmp14_;
				_tmp15_ = nat;
				_tmp16_ = n;
				nat = _tmp15_ + _tmp16_;
				_g_object_unref0 (btn);
			}
		}
	}
	_tmp17_ = min;
	_tmp18_ = self->priv->buttons;
	_tmp19_ = g_ptr_array_get_length (_tmp18_);
	_tmp20_ = _tmp19_;
	_vala_minimum = _tmp17_ + (_tmp20_ * COMPOSE_IMAGE_MANAGER_BUTTON_SPACING);
	_tmp21_ = nat;
	_tmp22_ = self->priv->buttons;
	_tmp23_ = g_ptr_array_get_length (_tmp22_);
	_tmp24_ = _tmp23_;
	_vala_natural = _tmp21_ + (_tmp24_ * COMPOSE_IMAGE_MANAGER_BUTTON_SPACING);
	if (minimum) {
		*minimum = _vala_minimum;
	}
	if (natural) {
		*natural = _vala_natural;
	}
}


static gboolean compose_image_manager_real_draw (GtkWidget* base, cairo_t* ct) {
	ComposeImageManager * self;
	gboolean result = FALSE;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_COMPOSE_IMAGE_MANAGER, ComposeImageManager);
	g_return_val_if_fail (ct != NULL, FALSE);
	{
		gint i = 0;
		gint p = 0;
		GPtrArray* _tmp0_ = NULL;
		gint _tmp1_ = 0;
		gint _tmp2_ = 0;
		i = 0;
		_tmp0_ = self->priv->buttons;
		_tmp1_ = g_ptr_array_get_length (_tmp0_);
		_tmp2_ = _tmp1_;
		p = _tmp2_;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				gint _tmp5_ = 0;
				gint _tmp6_ = 0;
				GtkWidget* btn = NULL;
				GPtrArray* _tmp7_ = NULL;
				gint _tmp8_ = 0;
				gconstpointer _tmp9_ = NULL;
				GtkWidget* _tmp10_ = NULL;
				GtkWidget* _tmp11_ = NULL;
				cairo_t* _tmp12_ = NULL;
				if (!_tmp3_) {
					gint _tmp4_ = 0;
					_tmp4_ = i;
					i = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp5_ = i;
				_tmp6_ = p;
				if (!(_tmp5_ < _tmp6_)) {
					break;
				}
				_tmp7_ = self->priv->buttons;
				_tmp8_ = i;
				_tmp9_ = g_ptr_array_index (_tmp7_, (guint) _tmp8_);
				_tmp10_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST ((AddImageButton*) _tmp9_, gtk_widget_get_type (), GtkWidget));
				btn = _tmp10_;
				_tmp11_ = btn;
				_tmp12_ = ct;
				gtk_container_propagate_draw (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_container_get_type (), GtkContainer), _tmp11_, _tmp12_);
				_g_object_unref0 (btn);
			}
		}
	}
	{
		gint i = 0;
		gint p = 0;
		GPtrArray* _tmp13_ = NULL;
		gint _tmp14_ = 0;
		gint _tmp15_ = 0;
		i = 0;
		_tmp13_ = self->priv->close_buttons;
		_tmp14_ = g_ptr_array_get_length (_tmp13_);
		_tmp15_ = _tmp14_;
		p = _tmp15_;
		{
			gboolean _tmp16_ = FALSE;
			_tmp16_ = TRUE;
			while (TRUE) {
				gint _tmp18_ = 0;
				gint _tmp19_ = 0;
				GtkButton* btn = NULL;
				GPtrArray* _tmp20_ = NULL;
				gint _tmp21_ = 0;
				gconstpointer _tmp22_ = NULL;
				GtkButton* _tmp23_ = NULL;
				GtkButton* _tmp24_ = NULL;
				cairo_t* _tmp25_ = NULL;
				if (!_tmp16_) {
					gint _tmp17_ = 0;
					_tmp17_ = i;
					i = _tmp17_ + 1;
				}
				_tmp16_ = FALSE;
				_tmp18_ = i;
				_tmp19_ = p;
				if (!(_tmp18_ < _tmp19_)) {
					break;
				}
				_tmp20_ = self->priv->close_buttons;
				_tmp21_ = i;
				_tmp22_ = g_ptr_array_index (_tmp20_, (guint) _tmp21_);
				_tmp23_ = _g_object_ref0 ((GtkButton*) _tmp22_);
				btn = _tmp23_;
				_tmp24_ = btn;
				_tmp25_ = ct;
				gtk_container_propagate_draw (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, gtk_widget_get_type (), GtkWidget), _tmp25_);
				_g_object_unref0 (btn);
			}
		}
	}
	result = GDK_EVENT_PROPAGATE;
	return result;
}


static gpointer _cairo_surface_reference0 (gpointer self) {
	return self ? cairo_surface_reference (self) : NULL;
}


void compose_image_manager_load_image (ComposeImageManager* self, const gchar* path, GdkPixbuf* image) {
	cairo_surface_t* surface = NULL;
	GdkPixbuf* _tmp0_ = NULL;
	AddImageButton* button = NULL;
	AddImageButton* _tmp7_ = NULL;
	cairo_surface_t* _tmp8_ = NULL;
	cairo_surface_t* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	g_return_if_fail (IS_COMPOSE_IMAGE_MANAGER (self));
	g_return_if_fail (path != NULL);
	g_return_if_fail ((image == NULL) || GDK_IS_PIXBUF (image));
	_tmp0_ = image;
	if (_tmp0_ == NULL) {
		const gchar* _tmp1_ = NULL;
		cairo_surface_t* _tmp2_ = NULL;
		_tmp1_ = path;
		_tmp2_ = load_surface (_tmp1_);
		_cairo_surface_destroy0 (surface);
		surface = (cairo_surface_t*) _tmp2_;
	} else {
		GdkPixbuf* _tmp3_ = NULL;
		gint _tmp4_ = 0;
		GdkWindow* _tmp5_ = NULL;
		cairo_surface_t* _tmp6_ = NULL;
		_tmp3_ = image;
		_tmp4_ = gtk_widget_get_scale_factor (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
		_tmp5_ = gtk_widget_get_window (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
		_tmp6_ = gdk_cairo_surface_create_from_pixbuf (_tmp3_, _tmp4_, _tmp5_);
		_cairo_surface_destroy0 (surface);
		surface = (cairo_surface_t*) _tmp6_;
	}
	_tmp7_ = add_image_button_new ();
	g_object_ref_sink (_tmp7_);
	button = _tmp7_;
	_tmp8_ = surface;
	_tmp9_ = _cairo_surface_reference0 (_tmp8_);
	_cairo_surface_destroy0 (button->surface);
	button->surface = _tmp9_;
	_tmp10_ = path;
	_tmp11_ = g_strdup (_tmp10_);
	_g_free0 (button->image_path);
	button->image_path = _tmp11_;
	gtk_widget_set_hexpand (G_TYPE_CHECK_INSTANCE_CAST (button, gtk_widget_get_type (), GtkWidget), FALSE);
	gtk_widget_set_halign (G_TYPE_CHECK_INSTANCE_CAST (button, gtk_widget_get_type (), GtkWidget), GTK_ALIGN_START);
	gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (button, gtk_widget_get_type (), GtkWidget));
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (button, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (button);
	_cairo_surface_destroy0 (surface);
}


gchar** compose_image_manager_get_image_paths (ComposeImageManager* self, int* result_length1) {
	gchar** result = NULL;
	gchar** paths = NULL;
	GPtrArray* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gchar** _tmp3_ = NULL;
	gint paths_length1 = 0;
	gint _paths_size_ = 0;
	gchar** _tmp20_ = NULL;
	gint _tmp20__length1 = 0;
	g_return_val_if_fail (IS_COMPOSE_IMAGE_MANAGER (self), NULL);
	_tmp0_ = self->priv->buttons;
	_tmp1_ = g_ptr_array_get_length (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_new0 (gchar*, _tmp2_ + 1);
	paths = _tmp3_;
	paths_length1 = _tmp2_;
	_paths_size_ = paths_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				gint _tmp6_ = 0;
				GPtrArray* _tmp7_ = NULL;
				gint _tmp8_ = 0;
				gint _tmp9_ = 0;
				AddImageButton* btn = NULL;
				GPtrArray* _tmp10_ = NULL;
				gint _tmp11_ = 0;
				gconstpointer _tmp12_ = NULL;
				AddImageButton* _tmp13_ = NULL;
				gchar** _tmp14_ = NULL;
				gint _tmp14__length1 = 0;
				gint _tmp15_ = 0;
				AddImageButton* _tmp16_ = NULL;
				const gchar* _tmp17_ = NULL;
				gchar* _tmp18_ = NULL;
				gchar* _tmp19_ = NULL;
				if (!_tmp4_) {
					gint _tmp5_ = 0;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				_tmp6_ = i;
				_tmp7_ = self->priv->buttons;
				_tmp8_ = g_ptr_array_get_length (_tmp7_);
				_tmp9_ = _tmp8_;
				if (!(_tmp6_ < _tmp9_)) {
					break;
				}
				_tmp10_ = self->priv->buttons;
				_tmp11_ = i;
				_tmp12_ = g_ptr_array_index (_tmp10_, (guint) _tmp11_);
				_tmp13_ = _g_object_ref0 ((AddImageButton*) _tmp12_);
				btn = _tmp13_;
				_tmp14_ = paths;
				_tmp14__length1 = paths_length1;
				_tmp15_ = i;
				_tmp16_ = btn;
				_tmp17_ = _tmp16_->image_path;
				_tmp18_ = g_strdup (_tmp17_);
				_g_free0 (_tmp14_[_tmp15_]);
				_tmp14_[_tmp15_] = _tmp18_;
				_tmp19_ = _tmp14_[_tmp15_];
				_g_object_unref0 (btn);
			}
		}
	}
	_tmp20_ = paths;
	_tmp20__length1 = paths_length1;
	if (result_length1) {
		*result_length1 = _tmp20__length1;
	}
	result = _tmp20_;
	return result;
}


void compose_image_manager_start_progress (ComposeImageManager* self, const gchar* image_path) {
	g_return_if_fail (IS_COMPOSE_IMAGE_MANAGER (self));
	g_return_if_fail (image_path != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_ = 0;
				GPtrArray* _tmp3_ = NULL;
				gint _tmp4_ = 0;
				gint _tmp5_ = 0;
				AddImageButton* btn = NULL;
				GPtrArray* _tmp6_ = NULL;
				gint _tmp7_ = 0;
				gconstpointer _tmp8_ = NULL;
				AddImageButton* _tmp9_ = NULL;
				AddImageButton* _tmp10_ = NULL;
				const gchar* _tmp11_ = NULL;
				const gchar* _tmp12_ = NULL;
				if (!_tmp0_) {
					gint _tmp1_ = 0;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				_tmp3_ = self->priv->buttons;
				_tmp4_ = g_ptr_array_get_length (_tmp3_);
				_tmp5_ = _tmp4_;
				if (!(_tmp2_ < _tmp5_)) {
					break;
				}
				_tmp6_ = self->priv->buttons;
				_tmp7_ = i;
				_tmp8_ = g_ptr_array_index (_tmp6_, (guint) _tmp7_);
				_tmp9_ = _g_object_ref0 ((AddImageButton*) _tmp8_);
				btn = _tmp9_;
				_tmp10_ = btn;
				_tmp11_ = _tmp10_->image_path;
				_tmp12_ = image_path;
				if (g_strcmp0 (_tmp11_, _tmp12_) == 0) {
					AddImageButton* _tmp13_ = NULL;
					GtkStyleContext* _tmp14_ = NULL;
					_tmp13_ = btn;
					_tmp14_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, gtk_widget_get_type (), GtkWidget));
					gtk_style_context_add_class (_tmp14_, "image-progress");
					_g_object_unref0 (btn);
					break;
				}
				_g_object_unref0 (btn);
			}
		}
	}
}


void compose_image_manager_end_progress (ComposeImageManager* self, const gchar* image_path, const gchar* error_message) {
	g_return_if_fail (IS_COMPOSE_IMAGE_MANAGER (self));
	g_return_if_fail (image_path != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_ = 0;
				GPtrArray* _tmp3_ = NULL;
				gint _tmp4_ = 0;
				gint _tmp5_ = 0;
				AddImageButton* btn = NULL;
				GPtrArray* _tmp6_ = NULL;
				gint _tmp7_ = 0;
				gconstpointer _tmp8_ = NULL;
				AddImageButton* _tmp9_ = NULL;
				AddImageButton* _tmp10_ = NULL;
				const gchar* _tmp11_ = NULL;
				const gchar* _tmp12_ = NULL;
				if (!_tmp0_) {
					gint _tmp1_ = 0;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				_tmp3_ = self->priv->buttons;
				_tmp4_ = g_ptr_array_get_length (_tmp3_);
				_tmp5_ = _tmp4_;
				if (!(_tmp2_ < _tmp5_)) {
					break;
				}
				_tmp6_ = self->priv->buttons;
				_tmp7_ = i;
				_tmp8_ = g_ptr_array_index (_tmp6_, (guint) _tmp7_);
				_tmp9_ = _g_object_ref0 ((AddImageButton*) _tmp8_);
				btn = _tmp9_;
				_tmp10_ = btn;
				_tmp11_ = _tmp10_->image_path;
				_tmp12_ = image_path;
				if (g_strcmp0 (_tmp11_, _tmp12_) == 0) {
					AddImageButton* _tmp13_ = NULL;
					GtkStyleContext* _tmp14_ = NULL;
					const gchar* _tmp15_ = NULL;
					_tmp13_ = btn;
					_tmp14_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, gtk_widget_get_type (), GtkWidget));
					gtk_style_context_remove_class (_tmp14_, "image-progress");
					_tmp15_ = error_message;
					if (_tmp15_ == NULL) {
						AddImageButton* _tmp16_ = NULL;
						GtkStyleContext* _tmp17_ = NULL;
						_tmp16_ = btn;
						_tmp17_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, gtk_widget_get_type (), GtkWidget));
						gtk_style_context_add_class (_tmp17_, "image-success");
					} else {
						const gchar* _tmp18_ = NULL;
						const gchar* _tmp19_ = NULL;
						AddImageButton* _tmp20_ = NULL;
						GtkStyleContext* _tmp21_ = NULL;
						_tmp18_ = image_path;
						_tmp19_ = error_message;
						g_warning ("ComposeImageManager.vala:261: %s: %s", _tmp18_, _tmp19_);
						_tmp20_ = btn;
						_tmp21_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, gtk_widget_get_type (), GtkWidget));
						gtk_style_context_add_class (_tmp21_, "image-error");
					}
					_g_object_unref0 (btn);
					break;
				}
				_g_object_unref0 (btn);
			}
		}
	}
}


ComposeImageManager* compose_image_manager_construct (GType object_type) {
	ComposeImageManager * self = NULL;
	self = (ComposeImageManager*) g_object_new (object_type, NULL);
	return self;
}


ComposeImageManager* compose_image_manager_new (void) {
	return compose_image_manager_construct (TYPE_COMPOSE_IMAGE_MANAGER);
}


gint compose_image_manager_get_n_images (ComposeImageManager* self) {
	gint result;
	GPtrArray* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	g_return_val_if_fail (IS_COMPOSE_IMAGE_MANAGER (self), 0);
	_tmp0_ = self->priv->buttons;
	_tmp1_ = g_ptr_array_get_length (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static GObject * compose_image_manager_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	ComposeImageManager * self;
	GPtrArray* _tmp0_ = NULL;
	GPtrArray* _tmp1_ = NULL;
	parent_class = G_OBJECT_CLASS (compose_image_manager_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_COMPOSE_IMAGE_MANAGER, ComposeImageManager);
	_tmp0_ = g_ptr_array_new_full ((guint) 0, _g_object_unref0_);
	_g_ptr_array_unref0 (self->priv->buttons);
	self->priv->buttons = _tmp0_;
	_tmp1_ = g_ptr_array_new_full ((guint) 0, _g_object_unref0_);
	_g_ptr_array_unref0 (self->priv->close_buttons);
	self->priv->close_buttons = _tmp1_;
	gtk_widget_set_has_window (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), FALSE);
	return obj;
}


static void compose_image_manager_class_init (ComposeImageManagerClass * klass) {
	compose_image_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ComposeImageManagerPrivate));
	((GtkContainerClass *) klass)->forall = (void (*)(GtkContainer*, gboolean, GtkCallback, void*)) compose_image_manager_real_forall_internal;
	((GtkContainerClass *) klass)->add = (void (*)(GtkContainer*, GtkWidget*)) compose_image_manager_real_add;
	((GtkContainerClass *) klass)->remove = (void (*)(GtkContainer*, GtkWidget*)) compose_image_manager_real_remove;
	((GtkWidgetClass *) klass)->get_request_mode = (GtkSizeRequestMode (*)(GtkWidget*)) compose_image_manager_real_get_request_mode;
	((GtkWidgetClass *) klass)->size_allocate = (void (*)(GtkWidget*, GtkAllocation*)) compose_image_manager_real_size_allocate;
	((GtkWidgetClass *) klass)->get_preferred_height_for_width = (void (*)(GtkWidget*, gint, gint*, gint*)) compose_image_manager_real_get_preferred_height_for_width;
	((GtkWidgetClass *) klass)->get_preferred_height = (void (*)(GtkWidget*, gint*, gint*)) compose_image_manager_real_get_preferred_height;
	((GtkWidgetClass *) klass)->get_preferred_width = (void (*)(GtkWidget*, gint*, gint*)) compose_image_manager_real_get_preferred_width;
	((GtkWidgetClass *) klass)->draw = (gboolean (*)(GtkWidget*, cairo_t*)) compose_image_manager_real_draw;
	G_OBJECT_CLASS (klass)->get_property = _vala_compose_image_manager_get_property;
	G_OBJECT_CLASS (klass)->constructor = compose_image_manager_constructor;
	G_OBJECT_CLASS (klass)->finalize = compose_image_manager_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), COMPOSE_IMAGE_MANAGER_N_IMAGES, g_param_spec_int ("n-images", "n-images", "n-images", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_signal_new ("image_removed", TYPE_COMPOSE_IMAGE_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void compose_image_manager_instance_init (ComposeImageManager * self) {
	self->priv = COMPOSE_IMAGE_MANAGER_GET_PRIVATE (self);
}


static void compose_image_manager_finalize (GObject* obj) {
	ComposeImageManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_COMPOSE_IMAGE_MANAGER, ComposeImageManager);
	_g_ptr_array_unref0 (self->priv->buttons);
	_g_ptr_array_unref0 (self->priv->close_buttons);
	G_OBJECT_CLASS (compose_image_manager_parent_class)->finalize (obj);
}


GType compose_image_manager_get_type (void) {
	static volatile gsize compose_image_manager_type_id__volatile = 0;
	if (g_once_init_enter (&compose_image_manager_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ComposeImageManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) compose_image_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ComposeImageManager), 0, (GInstanceInitFunc) compose_image_manager_instance_init, NULL };
		GType compose_image_manager_type_id;
		compose_image_manager_type_id = g_type_register_static (gtk_container_get_type (), "ComposeImageManager", &g_define_type_info, 0);
		g_once_init_leave (&compose_image_manager_type_id__volatile, compose_image_manager_type_id);
	}
	return compose_image_manager_type_id__volatile;
}


static void _vala_compose_image_manager_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ComposeImageManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_COMPOSE_IMAGE_MANAGER, ComposeImageManager);
	switch (property_id) {
		case COMPOSE_IMAGE_MANAGER_N_IMAGES:
		g_value_set_int (value, compose_image_manager_get_n_images (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



