/* Twitter.c generated by valac 0.38.7, the Vala compiler
 * generated from Twitter.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include "CbAvatarCache.h"
#include <cairo.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gdk/gdk.h>
#include <gio/gio.h>
#include "rest/rest-proxy-call.h"
#include <stdlib.h>
#include <string.h>
#include "rest/oauth-proxy.h"
#include "CbUserStream.h"
#include "CbUserCounter.h"
#include "CbFilter.h"
#include "rest/rest-proxy.h"
#include <json-glib/json-glib.h>
#include "CbUtils.h"
#include <gtk/gtk.h>


#define TYPE_TWITTER (twitter_get_type ())
#define TWITTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWITTER, Twitter))
#define TWITTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWITTER, TwitterClass))
#define IS_TWITTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWITTER))
#define IS_TWITTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWITTER))
#define TWITTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWITTER, TwitterClass))

typedef struct _Twitter Twitter;
typedef struct _TwitterClass TwitterClass;
typedef struct _TwitterPrivate TwitterPrivate;
enum  {
	TWITTER_0_PROPERTY,
	TWITTER_NUM_PROPERTIES
};
static GParamSpec* twitter_properties[TWITTER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_ACCOUNT (account_get_type ())
#define ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ACCOUNT, Account))
#define ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ACCOUNT, AccountClass))
#define IS_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ACCOUNT))
#define IS_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ACCOUNT))
#define ACCOUNT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ACCOUNT, AccountClass))

typedef struct _Account Account;
typedef struct _AccountClass AccountClass;
typedef struct _Block19Data Block19Data;
typedef struct _Block20Data Block20Data;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _AccountPrivate AccountPrivate;

#define SQL_TYPE_DATABASE (sql_database_get_type ())
#define SQL_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SQL_TYPE_DATABASE, SqlDatabase))
#define SQL_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SQL_TYPE_DATABASE, SqlDatabaseClass))
#define SQL_IS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SQL_TYPE_DATABASE))
#define SQL_IS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SQL_TYPE_DATABASE))
#define SQL_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SQL_TYPE_DATABASE, SqlDatabaseClass))

typedef struct _SqlDatabase SqlDatabase;
typedef struct _SqlDatabaseClass SqlDatabaseClass;

#define TYPE_NOTIFICATION_MANAGER (notification_manager_get_type ())
#define NOTIFICATION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFICATION_MANAGER, NotificationManager))
#define NOTIFICATION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFICATION_MANAGER, NotificationManagerClass))
#define IS_NOTIFICATION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFICATION_MANAGER))
#define IS_NOTIFICATION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFICATION_MANAGER))
#define NOTIFICATION_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFICATION_MANAGER, NotificationManagerClass))

typedef struct _NotificationManager NotificationManager;
typedef struct _NotificationManagerClass NotificationManagerClass;
#define __vala_JsonNode_free0(var) ((var == NULL) ? NULL : (var = (_vala_JsonNode_free (var), NULL)))
#define _json_object_unref0(var) ((var == NULL) ? NULL : (var = (json_object_unref (var), NULL)))
typedef struct _TwitterLoadAvatarForUserIdData TwitterLoadAvatarForUserIdData;

#define TYPE_AVATAR_WIDGET (avatar_widget_get_type ())
#define AVATAR_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_AVATAR_WIDGET, AvatarWidget))
#define AVATAR_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_AVATAR_WIDGET, AvatarWidgetClass))
#define IS_AVATAR_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_AVATAR_WIDGET))
#define IS_AVATAR_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_AVATAR_WIDGET))
#define AVATAR_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_AVATAR_WIDGET, AvatarWidgetClass))

typedef struct _AvatarWidget AvatarWidget;
typedef struct _AvatarWidgetClass AvatarWidgetClass;
typedef struct _TwitterGetAvatarData TwitterGetAvatarData;
typedef struct _Block21Data Block21Data;
typedef struct _Block22Data Block22Data;
typedef struct _TwitterGetSurfaceData TwitterGetSurfaceData;
enum  {
	TWITTER_AVATAR_DOWNLOADED_SIGNAL,
	TWITTER_NUM_SIGNALS
};
static guint twitter_signals[TWITTER_NUM_SIGNALS] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _Twitter {
	GObject parent_instance;
	TwitterPrivate * priv;
};

struct _TwitterClass {
	GObjectClass parent_class;
};

struct _TwitterPrivate {
	CbAvatarCache* avatar_cache;
};

struct _Block19Data {
	int _ref_count_;
	Twitter* self;
	cairo_surface_t* s;
	gpointer _async_data_;
};

struct _Block20Data {
	int _ref_count_;
	Block19Data * _data19_;
	gulong handler_id;
};

struct _Account {
	GObject parent_instance;
	AccountPrivate * priv;
	gint64 id;
	SqlDatabase* db;
	gchar* screen_name;
	gchar* name;
	gchar* avatar_url;
	gchar* banner_url;
	gchar* website;
	gchar* description;
	OAuthProxy* proxy;
	CbUserStream* user_stream;
	CbUserCounter* user_counter;
	NotificationManager* notifications;
	gint64* friends;
	gint friends_length1;
	gint64* blocked;
	gint blocked_length1;
	gint64* muted;
	gint muted_length1;
	gint64* disabled_rts;
	gint disabled_rts_length1;
	GPtrArray* filters;
};

struct _AccountClass {
	GObjectClass parent_class;
};

struct _TwitterLoadAvatarForUserIdData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	Twitter* self;
	Account* account;
	gint64 user_id;
	gint size;
	cairo_surface_t* result;
	Block19Data* _data19_;
	gboolean found;
	CbAvatarCache* _tmp0_;
	gint64 _tmp1_;
	gboolean _tmp2_;
	cairo_surface_t* _tmp3_;
	cairo_surface_t* _tmp4_;
	cairo_surface_t* _tmp5_;
	gboolean _tmp6_;
	cairo_surface_t* _tmp7_;
	cairo_surface_t* _tmp8_;
	gboolean _tmp9_;
	cairo_surface_t* _tmp10_;
	gboolean _tmp11_;
	Block20Data* _data20_;
	gint64 _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gulong _tmp16_;
	cairo_surface_t* _tmp17_;
	cairo_surface_t* _tmp18_;
	cairo_surface_t* _tmp19_;
	CbAvatarCache* _tmp20_;
	gint64 _tmp21_;
	RestProxyCall* call;
	Account* _tmp22_;
	OAuthProxy* _tmp23_;
	RestProxyCall* _tmp24_;
	RestProxyCall* _tmp25_;
	RestProxyCall* _tmp26_;
	RestProxyCall* _tmp27_;
	gint64 _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	RestProxyCall* _tmp31_;
	JsonNode* root;
	JsonNode* _tmp32_;
	RestProxyCall* _tmp33_;
	JsonNode* _tmp34_;
	JsonNode* _tmp35_;
	GError* e;
	GError* _tmp36_;
	const gchar* _tmp37_;
	JsonNode* _tmp38_;
	JsonObject* root_obj;
	JsonNode* _tmp39_;
	JsonObject* _tmp40_;
	JsonObject* _tmp41_;
	gchar* avatar_url;
	JsonObject* _tmp42_;
	const gchar* _tmp43_;
	gchar* _tmp44_;
	CbAvatarCache* _tmp45_;
	gint64 _tmp46_;
	const gchar* _tmp47_;
	gint64 _tmp48_;
	const gchar* _tmp49_;
	gint _tmp50_;
	cairo_surface_t* _tmp51_;
	cairo_surface_t* _tmp52_;
	cairo_surface_t* _tmp53_;
	cairo_surface_t* _tmp54_;
	cairo_surface_t* _tmp55_;
	cairo_surface_t* _tmp56_;
	GError * _inner_error_;
};

struct _TwitterGetAvatarData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	Twitter* self;
	gint64 user_id;
	gchar* url;
	AvatarWidget* dest_widget;
	gint size;
	gboolean force_download;
	AvatarWidget* _tmp0_;
	gint64 _tmp1_;
	const gchar* _tmp2_;
	gint _tmp3_;
	gboolean _tmp4_;
	cairo_surface_t* _tmp5_;
	cairo_surface_t* _tmp6_;
};

struct _Block21Data {
	int _ref_count_;
	Twitter* self;
	cairo_surface_t* a;
	gpointer _async_data_;
};

struct _Block22Data {
	int _ref_count_;
	Block21Data * _data21_;
	gulong handler_id;
};

struct _TwitterGetSurfaceData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	Twitter* self;
	gint64 user_id;
	gchar* url;
	gint size;
	gboolean force_download;
	cairo_surface_t* result;
	Block21Data* _data21_;
	gint64 _tmp0_;
	gboolean has_key;
	CbAvatarCache* _tmp1_;
	gint64 _tmp2_;
	gboolean _tmp3_;
	cairo_surface_t* _tmp4_;
	cairo_surface_t* _tmp5_;
	gboolean _tmp6_;
	cairo_surface_t* _tmp7_;
	cairo_surface_t* _tmp8_;
	const gchar* _tmp9_;
	CbAvatarCache* _tmp10_;
	gint64 _tmp11_;
	const gchar* _tmp12_;
	gboolean new_url;
	gboolean _tmp13_;
	cairo_surface_t* _tmp14_;
	gboolean _tmp15_;
	cairo_surface_t* _tmp16_;
	cairo_surface_t* _tmp17_;
	gboolean _tmp18_;
	gboolean _tmp19_;
	gboolean _tmp20_;
	gboolean _tmp21_;
	gboolean _tmp22_;
	Block22Data* _data22_;
	gint64 _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	gulong _tmp27_;
	cairo_surface_t* _tmp28_;
	cairo_surface_t* _tmp29_;
	CbAvatarCache* _tmp30_;
	gint64 _tmp31_;
	const gchar* _tmp32_;
	GdkPixbuf* avatar;
	GdkPixbuf* _tmp33_;
	const gchar* _tmp34_;
	gint _tmp35_;
	GdkPixbuf* _tmp36_;
	GdkPixbuf* _tmp37_;
	GError* e;
	GError* _tmp38_;
	const gchar* _tmp39_;
	const gchar* _tmp40_;
	cairo_surface_t* s;
	GdkPixbuf* _tmp41_;
	cairo_surface_t* _tmp42_;
	cairo_surface_t* _tmp43_;
	GdkPixbuf* _tmp44_;
	cairo_surface_t* _tmp45_;
	CbAvatarCache* _tmp46_;
	gint64 _tmp47_;
	cairo_surface_t* _tmp48_;
	const gchar* _tmp49_;
	gint64 _tmp50_;
	gchar* _tmp51_;
	gchar* _tmp52_;
	cairo_surface_t* _tmp53_;
	GError * _inner_error_;
};


static gpointer twitter_parent_class = NULL;
static Twitter* twitter_twitter;
static Twitter* twitter_twitter = NULL;
extern cairo_surface_t* twitter_no_avatar;
cairo_surface_t* twitter_no_avatar = NULL;
extern GdkPixbuf* twitter_no_banner;
GdkPixbuf* twitter_no_banner = NULL;

GType twitter_get_type (void) G_GNUC_CONST;
#define TWITTER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_TWITTER, TwitterPrivate))
#define TWITTER_MAX_BYTES_PER_IMAGE ((1024 * 1024) * 3)
#define TWITTER_short_url_length 23
#define TWITTER_max_media_per_upload 4
static Twitter* twitter_new (void);
static Twitter* twitter_construct (GType object_type);
Twitter* twitter_get (void);
void twitter_init (Twitter* self);
void twitter_ref_avatar (Twitter* self, cairo_surface_t* surface);
void twitter_unref_avatar (Twitter* self, cairo_surface_t* surface);
gboolean twitter_has_avatar (Twitter* self, gint64 user_id);
cairo_surface_t* twitter_get_cached_avatar (Twitter* self, gint64 user_id);
static void twitter_load_avatar_for_user_id_data_free (gpointer _data);
GType account_get_type (void) G_GNUC_CONST;
void twitter_load_avatar_for_user_id (Twitter* self, Account* account, gint64 user_id, gint size, GAsyncReadyCallback _callback_, gpointer _user_data_);
cairo_surface_t* twitter_load_avatar_for_user_id_finish (Twitter* self, GAsyncResult* _res_);
static gboolean twitter_load_avatar_for_user_id_co (TwitterLoadAvatarForUserIdData* _data_);
static Block19Data* block19_data_ref (Block19Data* _data19_);
static void block19_data_unref (void * _userdata_);
static Block20Data* block20_data_ref (Block20Data* _data20_);
static void block20_data_unref (void * _userdata_);
static void ___lambda184_ (Block20Data* _data20_, cairo_surface_t* ava);
static void ____lambda184__twitter_avatar_downloaded (Twitter* _sender, cairo_surface_t* avatar, gpointer self);
GType sql_database_get_type (void) G_GNUC_CONST;
GType notification_manager_get_type (void) G_GNUC_CONST;
static void twitter_load_avatar_for_user_id_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _vala_JsonNode_free (JsonNode* self);
static void twitter_get_surface (Twitter* self, gint64 user_id, const gchar* url, gint size, gboolean force_download, GAsyncReadyCallback _callback_, gpointer _user_data_);
static cairo_surface_t* twitter_get_surface_finish (Twitter* self, GAsyncResult* _res_);
static void twitter_get_avatar_data_free (gpointer _data);
GType avatar_widget_get_type (void) G_GNUC_CONST;
void twitter_get_avatar (Twitter* self, gint64 user_id, const gchar* url, AvatarWidget* dest_widget, gint size, gboolean force_download, GAsyncReadyCallback _callback_, gpointer _user_data_);
void twitter_get_avatar_finish (Twitter* self, GAsyncResult* _res_);
static gboolean twitter_get_avatar_co (TwitterGetAvatarData* _data_);
static void twitter_get_avatar_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void avatar_widget_set_surface (AvatarWidget* self, cairo_surface_t* value);
static void twitter_get_surface_data_free (gpointer _data);
static gboolean twitter_get_surface_co (TwitterGetSurfaceData* _data_);
static Block21Data* block21_data_ref (Block21Data* _data21_);
static void block21_data_unref (void * _userdata_);
static Block22Data* block22_data_ref (Block22Data* _data22_);
static void block22_data_unref (void * _userdata_);
static void ___lambda85_ (Block22Data* _data22_, cairo_surface_t* ava);
static void ____lambda85__twitter_avatar_downloaded (Twitter* _sender, cairo_surface_t* avatar, gpointer self);
void tweet_utils_download_avatar (const gchar* avatar_url, gint size, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
GdkPixbuf* tweet_utils_download_avatar_finish (GAsyncResult* _res_, GError** error);
static void twitter_get_surface_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void twitter_finalize (GObject * obj);


static Twitter* twitter_construct (GType object_type) {
	Twitter * self = NULL;
	self = (Twitter*) g_object_new (object_type, NULL);
	return self;
}


static Twitter* twitter_new (void) {
	return twitter_construct (TYPE_TWITTER);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


Twitter* twitter_get (void) {
	Twitter* result = NULL;
	Twitter* _tmp0_;
	Twitter* _tmp2_;
	Twitter* _tmp3_;
	_tmp0_ = twitter_twitter;
	if (_tmp0_ == NULL) {
		Twitter* _tmp1_;
		_tmp1_ = twitter_new ();
		_g_object_unref0 (twitter_twitter);
		twitter_twitter = _tmp1_;
	}
	_tmp2_ = twitter_twitter;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}


void twitter_init (Twitter* self) {
	CbAvatarCache* _tmp7_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (IS_TWITTER (self));
	{
		GdkPixbuf* _tmp0_ = NULL;
		GdkPixbuf* _tmp1_;
		cairo_surface_t* _tmp2_;
		GdkPixbuf* _tmp3_ = NULL;
		GdkPixbuf* _tmp4_;
		GdkPixbuf* _tmp5_;
		_tmp1_ = gdk_pixbuf_new_from_resource ("/org/baedert/corebird/data/no_avatar.png", &_inner_error_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch14_g_error;
		}
		_tmp2_ = gdk_cairo_surface_create_from_pixbuf (_tmp0_, 1, NULL);
		_cairo_surface_destroy0 (twitter_no_avatar);
		twitter_no_avatar = _tmp2_;
		_tmp4_ = gdk_pixbuf_new_from_resource ("/org/baedert/corebird/data/no_banner.png", &_inner_error_);
		_tmp3_ = _tmp4_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (_tmp0_);
			goto __catch14_g_error;
		}
		_tmp5_ = _tmp3_;
		_tmp3_ = NULL;
		_g_object_unref0 (twitter_no_banner);
		twitter_no_banner = _tmp5_;
		_g_object_unref0 (_tmp3_);
		_g_object_unref0 (_tmp0_);
	}
	goto __finally14;
	__catch14_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp6_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp6_ = e->message;
		g_error ("Twitter.vala:47: Error while loading assets: %s", _tmp6_);
		_g_error_free0 (e);
	}
	__finally14:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp7_ = cb_avatar_cache_new ();
	_g_object_unref0 (self->priv->avatar_cache);
	self->priv->avatar_cache = _tmp7_;
}


void twitter_ref_avatar (Twitter* self, cairo_surface_t* surface) {
	CbAvatarCache* _tmp0_;
	cairo_surface_t* _tmp1_;
	g_return_if_fail (IS_TWITTER (self));
	g_return_if_fail (surface != NULL);
	_tmp0_ = self->priv->avatar_cache;
	_tmp1_ = surface;
	cb_avatar_cache_increase_refcount_for_surface (_tmp0_, _tmp1_);
}


void twitter_unref_avatar (Twitter* self, cairo_surface_t* surface) {
	CbAvatarCache* _tmp0_;
	cairo_surface_t* _tmp1_;
	g_return_if_fail (IS_TWITTER (self));
	g_return_if_fail (surface != NULL);
	_tmp0_ = self->priv->avatar_cache;
	_tmp1_ = surface;
	cb_avatar_cache_decrease_refcount_for_surface (_tmp0_, _tmp1_);
}


gboolean twitter_has_avatar (Twitter* self, gint64 user_id) {
	gboolean result = FALSE;
	gint64 _tmp0_;
	cairo_surface_t* _tmp1_;
	cairo_surface_t* _tmp2_;
	cairo_surface_t* _tmp3_;
	gboolean _tmp4_;
	g_return_val_if_fail (IS_TWITTER (self), FALSE);
	_tmp0_ = user_id;
	_tmp1_ = twitter_get_cached_avatar (self, _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = twitter_no_avatar;
	_tmp4_ = _tmp2_ != _tmp3_;
	_cairo_surface_destroy0 (_tmp2_);
	result = _tmp4_;
	return result;
}


static gpointer _cairo_surface_reference0 (gpointer self) {
	return self ? cairo_surface_reference (self) : NULL;
}


cairo_surface_t* twitter_get_cached_avatar (Twitter* self, gint64 user_id) {
	cairo_surface_t* result = NULL;
	gboolean found = FALSE;
	cairo_surface_t* surface = NULL;
	CbAvatarCache* _tmp0_;
	gint64 _tmp1_;
	gboolean _tmp2_ = FALSE;
	cairo_surface_t* _tmp3_;
	cairo_surface_t* _tmp4_;
	cairo_surface_t* _tmp5_;
	g_return_val_if_fail (IS_TWITTER (self), NULL);
	_tmp0_ = self->priv->avatar_cache;
	_tmp1_ = user_id;
	_tmp3_ = cb_avatar_cache_get_surface_for_id (_tmp0_, _tmp1_, &_tmp2_);
	found = _tmp2_;
	_tmp4_ = _cairo_surface_reference0 (_tmp3_);
	surface = _tmp4_;
	_tmp5_ = surface;
	if (_tmp5_ == NULL) {
		cairo_surface_t* _tmp6_;
		cairo_surface_t* _tmp7_;
		_tmp6_ = twitter_no_avatar;
		_tmp7_ = _cairo_surface_reference0 (_tmp6_);
		result = _tmp7_;
		_cairo_surface_destroy0 (surface);
		return result;
	} else {
		result = surface;
		return result;
	}
	_cairo_surface_destroy0 (surface);
}


static void twitter_load_avatar_for_user_id_data_free (gpointer _data) {
	TwitterLoadAvatarForUserIdData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->account);
	_cairo_surface_destroy0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (TwitterLoadAvatarForUserIdData, _data_);
}


void twitter_load_avatar_for_user_id (Twitter* self, Account* account, gint64 user_id, gint size, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TwitterLoadAvatarForUserIdData* _data_;
	Twitter* _tmp0_;
	Account* _tmp1_;
	Account* _tmp2_;
	gint64 _tmp3_;
	gint _tmp4_;
	_data_ = g_slice_new0 (TwitterLoadAvatarForUserIdData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, twitter_load_avatar_for_user_id_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = account;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (_data_->account);
	_data_->account = _tmp2_;
	_tmp3_ = user_id;
	_data_->user_id = _tmp3_;
	_tmp4_ = size;
	_data_->size = _tmp4_;
	twitter_load_avatar_for_user_id_co (_data_);
}


cairo_surface_t* twitter_load_avatar_for_user_id_finish (Twitter* self, GAsyncResult* _res_) {
	cairo_surface_t* result;
	TwitterLoadAvatarForUserIdData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static Block19Data* block19_data_ref (Block19Data* _data19_) {
	g_atomic_int_inc (&_data19_->_ref_count_);
	return _data19_;
}


static void block19_data_unref (void * _userdata_) {
	Block19Data* _data19_;
	_data19_ = (Block19Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data19_->_ref_count_)) {
		Twitter* self;
		self = _data19_->self;
		_cairo_surface_destroy0 (_data19_->s);
		_g_object_unref0 (self);
		g_slice_free (Block19Data, _data19_);
	}
}


static Block20Data* block20_data_ref (Block20Data* _data20_) {
	g_atomic_int_inc (&_data20_->_ref_count_);
	return _data20_;
}


static void block20_data_unref (void * _userdata_) {
	Block20Data* _data20_;
	_data20_ = (Block20Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data20_->_ref_count_)) {
		Twitter* self;
		self = _data20_->_data19_->self;
		block19_data_unref (_data20_->_data19_);
		_data20_->_data19_ = NULL;
		g_slice_free (Block20Data, _data20_);
	}
}


static void ___lambda184_ (Block20Data* _data20_, cairo_surface_t* ava) {
	Block19Data* _data19_;
	Twitter* self;
	cairo_surface_t* _tmp0_;
	cairo_surface_t* _tmp1_;
	gulong _tmp2_;
	_data19_ = _data20_->_data19_;
	self = _data19_->self;
	g_return_if_fail (ava != NULL);
	_tmp0_ = ava;
	_tmp1_ = _cairo_surface_reference0 (_tmp0_);
	_cairo_surface_destroy0 (_data19_->s);
	_data19_->s = _tmp1_;
	_tmp2_ = _data20_->handler_id;
	g_signal_handler_disconnect (G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject), _tmp2_);
	twitter_load_avatar_for_user_id_co (_data19_->_async_data_);
}


static void ____lambda184__twitter_avatar_downloaded (Twitter* _sender, cairo_surface_t* avatar, gpointer self) {
	___lambda184_ (self, avatar);
}


static void twitter_load_avatar_for_user_id_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TwitterLoadAvatarForUserIdData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	twitter_load_avatar_for_user_id_co (_data_);
}


static void _vala_JsonNode_free (JsonNode* self) {
	g_boxed_free (json_node_get_type (), self);
}


static gpointer _json_object_ref0 (gpointer self) {
	return self ? json_object_ref (self) : NULL;
}


static gboolean twitter_load_avatar_for_user_id_co (TwitterLoadAvatarForUserIdData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		case 4:
		goto _state_4;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data19_ = g_slice_new0 (Block19Data);
	_data_->_data19_->_ref_count_ = 1;
	_data_->_data19_->self = g_object_ref (_data_->self);
	_data_->_data19_->_async_data_ = _data_;
	_data_->found = FALSE;
	_data_->_tmp0_ = _data_->self->priv->avatar_cache;
	_data_->_tmp1_ = _data_->user_id;
	_data_->_tmp2_ = FALSE;
	_data_->_tmp3_ = cb_avatar_cache_get_surface_for_id (_data_->_tmp0_, _data_->_tmp1_, &_data_->_tmp2_);
	_data_->found = _data_->_tmp2_;
	_data_->_tmp4_ = _cairo_surface_reference0 (_data_->_tmp3_);
	_cairo_surface_destroy0 (_data_->_data19_->s);
	_data_->_data19_->s = _data_->_tmp4_;
	_data_->_tmp5_ = _data_->_data19_->s;
	if (_data_->_tmp5_ != NULL) {
		_data_->_tmp6_ = _data_->found;
		_vala_assert (_data_->_tmp6_, "found");
		_data_->_tmp7_ = _data_->_data19_->s;
		_data_->_tmp8_ = _cairo_surface_reference0 (_data_->_tmp7_);
		_data_->result = _data_->_tmp8_;
		block19_data_unref (_data_->_data19_);
		_data_->_data19_ = NULL;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (g_task_get_completed (_data_->_async_result) != TRUE) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp10_ = _data_->_data19_->s;
	if (_data_->_tmp10_ == NULL) {
		_data_->_tmp11_ = _data_->found;
		_data_->_tmp9_ = _data_->_tmp11_;
	} else {
		_data_->_tmp9_ = FALSE;
	}
	if (_data_->_tmp9_) {
		_data_->_data20_ = g_slice_new0 (Block20Data);
		_data_->_data20_->_ref_count_ = 1;
		_data_->_data20_->_data19_ = block19_data_ref (_data_->_data19_);
		_data_->_data20_->handler_id = (gulong) 0;
		_data_->_tmp12_ = _data_->user_id;
		_data_->_tmp13_ = g_strdup_printf ("%" G_GINT64_FORMAT, _data_->_tmp12_);
		_data_->_tmp14_ = _data_->_tmp13_;
		_data_->_tmp15_ = g_strconcat ("avatar-downloaded::", _data_->_tmp14_, NULL);
		_data_->_tmp16_ = g_signal_connect_data (_data_->self, _data_->_tmp15_, (GCallback) ____lambda184__twitter_avatar_downloaded, block20_data_ref (_data_->_data20_), (GClosureNotify) block20_data_unref, 0);
		_data_->_data20_->handler_id = _data_->_tmp16_;
		_g_free0 (_data_->_tmp15_);
		_g_free0 (_data_->_tmp14_);
		_data_->_state_ = 1;
		return FALSE;
		_state_1:
		;
		_data_->_tmp17_ = _data_->_data19_->s;
		_vala_assert (_data_->_tmp17_ != NULL, "s != null");
		_data_->_tmp18_ = _data_->_data19_->s;
		_data_->_tmp19_ = _cairo_surface_reference0 (_data_->_tmp18_);
		_data_->result = _data_->_tmp19_;
		block20_data_unref (_data_->_data20_);
		_data_->_data20_ = NULL;
		block19_data_unref (_data_->_data19_);
		_data_->_data19_ = NULL;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (g_task_get_completed (_data_->_async_result) != TRUE) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp20_ = _data_->self->priv->avatar_cache;
	_data_->_tmp21_ = _data_->user_id;
	cb_avatar_cache_add (_data_->_tmp20_, _data_->_tmp21_, NULL, NULL);
	_data_->_tmp22_ = _data_->account;
	_data_->_tmp23_ = _data_->_tmp22_->proxy;
	_data_->_tmp24_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp23_, rest_proxy_get_type (), RestProxy));
	_data_->call = _data_->_tmp24_;
	_data_->_tmp25_ = _data_->call;
	rest_proxy_call_set_function (_data_->_tmp25_, "1.1/users/show.json");
	_data_->_tmp26_ = _data_->call;
	rest_proxy_call_set_method (_data_->_tmp26_, "GET");
	_data_->_tmp27_ = _data_->call;
	_data_->_tmp28_ = _data_->user_id;
	_data_->_tmp29_ = g_strdup_printf ("%" G_GINT64_FORMAT, _data_->_tmp28_);
	_data_->_tmp30_ = _data_->_tmp29_;
	rest_proxy_call_add_param (_data_->_tmp27_, "user_id", _data_->_tmp30_);
	_g_free0 (_data_->_tmp30_);
	_data_->_tmp31_ = _data_->call;
	rest_proxy_call_add_param (_data_->_tmp31_, "include_entities", "false");
	_data_->root = NULL;
	{
		_data_->_tmp33_ = _data_->call;
		_data_->_state_ = 2;
		cb_utils_load_threaded_async (_data_->_tmp33_, NULL, twitter_load_avatar_for_user_id_ready, _data_);
		return FALSE;
		_state_2:
		_data_->_tmp34_ = cb_utils_load_threaded_finish (_data_->_res_, &_data_->_inner_error_);
		_data_->_tmp32_ = _data_->_tmp34_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			goto __catch15_g_error;
		}
		_data_->_tmp35_ = _data_->_tmp32_;
		_data_->_tmp32_ = NULL;
		__vala_JsonNode_free0 (_data_->root);
		_data_->root = _data_->_tmp35_;
		__vala_JsonNode_free0 (_data_->_tmp32_);
	}
	goto __finally15;
	__catch15_g_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp36_ = _data_->e;
		_data_->_tmp37_ = _data_->_tmp36_->message;
		g_warning ("Twitter.vala:119: %s", _data_->_tmp37_);
		_data_->result = NULL;
		_g_error_free0 (_data_->e);
		__vala_JsonNode_free0 (_data_->root);
		_g_object_unref0 (_data_->call);
		block19_data_unref (_data_->_data19_);
		_data_->_data19_ = NULL;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (g_task_get_completed (_data_->_async_result) != TRUE) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally15:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		__vala_JsonNode_free0 (_data_->root);
		_g_object_unref0 (_data_->call);
		block19_data_unref (_data_->_data19_);
		_data_->_data19_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp38_ = _data_->root;
	if (_data_->_tmp38_ == NULL) {
		_data_->result = NULL;
		__vala_JsonNode_free0 (_data_->root);
		_g_object_unref0 (_data_->call);
		block19_data_unref (_data_->_data19_);
		_data_->_data19_ = NULL;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (g_task_get_completed (_data_->_async_result) != TRUE) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp39_ = _data_->root;
	_data_->_tmp40_ = json_node_get_object (_data_->_tmp39_);
	_data_->_tmp41_ = _json_object_ref0 (_data_->_tmp40_);
	_data_->root_obj = _data_->_tmp41_;
	_data_->_tmp42_ = _data_->root_obj;
	_data_->_tmp43_ = json_object_get_string_member (_data_->_tmp42_, "profile_image_url");
	_data_->_tmp44_ = g_strdup (_data_->_tmp43_);
	_data_->avatar_url = _data_->_tmp44_;
	_data_->_tmp45_ = _data_->self->priv->avatar_cache;
	_data_->_tmp46_ = _data_->user_id;
	_data_->_tmp47_ = _data_->avatar_url;
	cb_avatar_cache_set_url (_data_->_tmp45_, _data_->_tmp46_, _data_->_tmp47_);
	_data_->_tmp48_ = _data_->user_id;
	_data_->_tmp49_ = _data_->avatar_url;
	_data_->_tmp50_ = _data_->size;
	_data_->_state_ = 3;
	twitter_get_surface (_data_->self, _data_->_tmp48_, _data_->_tmp49_, _data_->_tmp50_, TRUE, twitter_load_avatar_for_user_id_ready, _data_);
	return FALSE;
	_state_3:
	_data_->_tmp51_ = twitter_get_surface_finish (_data_->self, _data_->_res_);
	_cairo_surface_destroy0 (_data_->_data19_->s);
	_data_->_data19_->s = _data_->_tmp51_;
	_data_->_tmp52_ = _data_->_data19_->s;
	if (_data_->_tmp52_ != NULL) {
		_data_->_tmp53_ = _data_->_data19_->s;
		_data_->_tmp54_ = _cairo_surface_reference0 (_data_->_tmp53_);
		_data_->result = _data_->_tmp54_;
		_g_free0 (_data_->avatar_url);
		_json_object_unref0 (_data_->root_obj);
		__vala_JsonNode_free0 (_data_->root);
		_g_object_unref0 (_data_->call);
		block19_data_unref (_data_->_data19_);
		_data_->_data19_ = NULL;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (g_task_get_completed (_data_->_async_result) != TRUE) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	} else {
		_data_->_state_ = 4;
		return FALSE;
		_state_4:
		;
	}
	_data_->_tmp55_ = _data_->_data19_->s;
	_data_->_tmp56_ = _cairo_surface_reference0 (_data_->_tmp55_);
	_data_->result = _data_->_tmp56_;
	_g_free0 (_data_->avatar_url);
	_json_object_unref0 (_data_->root_obj);
	__vala_JsonNode_free0 (_data_->root);
	_g_object_unref0 (_data_->call);
	block19_data_unref (_data_->_data19_);
	_data_->_data19_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (g_task_get_completed (_data_->_async_result) != TRUE) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void twitter_get_avatar_data_free (gpointer _data) {
	TwitterGetAvatarData* _data_;
	_data_ = _data;
	_g_free0 (_data_->url);
	_g_object_unref0 (_data_->dest_widget);
	_g_object_unref0 (_data_->self);
	g_slice_free (TwitterGetAvatarData, _data_);
}


void twitter_get_avatar (Twitter* self, gint64 user_id, const gchar* url, AvatarWidget* dest_widget, gint size, gboolean force_download, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TwitterGetAvatarData* _data_;
	Twitter* _tmp0_;
	gint64 _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	AvatarWidget* _tmp4_;
	AvatarWidget* _tmp5_;
	gint _tmp6_;
	gboolean _tmp7_;
	_data_ = g_slice_new0 (TwitterGetAvatarData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, twitter_get_avatar_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = user_id;
	_data_->user_id = _tmp1_;
	_tmp2_ = url;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 (_data_->url);
	_data_->url = _tmp3_;
	_tmp4_ = dest_widget;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	_g_object_unref0 (_data_->dest_widget);
	_data_->dest_widget = _tmp5_;
	_tmp6_ = size;
	_data_->size = _tmp6_;
	_tmp7_ = force_download;
	_data_->force_download = _tmp7_;
	twitter_get_avatar_co (_data_);
}


void twitter_get_avatar_finish (Twitter* self, GAsyncResult* _res_) {
	TwitterGetAvatarData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}


/**
   * Get the avatar with the given url. If the avatar exists on the
   * hard drive already, it is loaded and returned immediately. If
   * the avatar is in memory already, that version is returned.
   * If the avatar is neither on disk nor in memory, it will be downladed
   * first and set via the supplied `func`.
   */
static void twitter_get_avatar_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TwitterGetAvatarData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	twitter_get_avatar_co (_data_);
}


static gboolean twitter_get_avatar_co (TwitterGetAvatarData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->dest_widget;
	_data_->_tmp1_ = _data_->user_id;
	_data_->_tmp2_ = _data_->url;
	_data_->_tmp3_ = _data_->size;
	_data_->_tmp4_ = _data_->force_download;
	_data_->_state_ = 1;
	twitter_get_surface (_data_->self, _data_->_tmp1_, _data_->_tmp2_, _data_->_tmp3_, _data_->_tmp4_, twitter_get_avatar_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp5_ = twitter_get_surface_finish (_data_->self, _data_->_res_);
	_data_->_tmp6_ = _data_->_tmp5_;
	avatar_widget_set_surface (_data_->_tmp0_, _data_->_tmp6_);
	_cairo_surface_destroy0 (_data_->_tmp6_);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (g_task_get_completed (_data_->_async_result) != TRUE) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void twitter_get_surface_data_free (gpointer _data) {
	TwitterGetSurfaceData* _data_;
	_data_ = _data;
	_g_free0 (_data_->url);
	_cairo_surface_destroy0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (TwitterGetSurfaceData, _data_);
}


static void twitter_get_surface (Twitter* self, gint64 user_id, const gchar* url, gint size, gboolean force_download, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TwitterGetSurfaceData* _data_;
	Twitter* _tmp0_;
	gint64 _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gint _tmp4_;
	gboolean _tmp5_;
	_data_ = g_slice_new0 (TwitterGetSurfaceData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, twitter_get_surface_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = user_id;
	_data_->user_id = _tmp1_;
	_tmp2_ = url;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 (_data_->url);
	_data_->url = _tmp3_;
	_tmp4_ = size;
	_data_->size = _tmp4_;
	_tmp5_ = force_download;
	_data_->force_download = _tmp5_;
	twitter_get_surface_co (_data_);
}


static cairo_surface_t* twitter_get_surface_finish (Twitter* self, GAsyncResult* _res_) {
	cairo_surface_t* result;
	TwitterGetSurfaceData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static Block21Data* block21_data_ref (Block21Data* _data21_) {
	g_atomic_int_inc (&_data21_->_ref_count_);
	return _data21_;
}


static void block21_data_unref (void * _userdata_) {
	Block21Data* _data21_;
	_data21_ = (Block21Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data21_->_ref_count_)) {
		Twitter* self;
		self = _data21_->self;
		_cairo_surface_destroy0 (_data21_->a);
		_g_object_unref0 (self);
		g_slice_free (Block21Data, _data21_);
	}
}


static Block22Data* block22_data_ref (Block22Data* _data22_) {
	g_atomic_int_inc (&_data22_->_ref_count_);
	return _data22_;
}


static void block22_data_unref (void * _userdata_) {
	Block22Data* _data22_;
	_data22_ = (Block22Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data22_->_ref_count_)) {
		Twitter* self;
		self = _data22_->_data21_->self;
		block21_data_unref (_data22_->_data21_);
		_data22_->_data21_ = NULL;
		g_slice_free (Block22Data, _data22_);
	}
}


static void ___lambda85_ (Block22Data* _data22_, cairo_surface_t* ava) {
	Block21Data* _data21_;
	Twitter* self;
	gulong _tmp0_;
	cairo_surface_t* _tmp1_;
	cairo_surface_t* _tmp2_;
	_data21_ = _data22_->_data21_;
	self = _data21_->self;
	g_return_if_fail (ava != NULL);
	_tmp0_ = _data22_->handler_id;
	g_signal_handler_disconnect (G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject), _tmp0_);
	_tmp1_ = ava;
	_tmp2_ = _cairo_surface_reference0 (_tmp1_);
	_cairo_surface_destroy0 (_data21_->a);
	_data21_->a = _tmp2_;
	twitter_get_surface_co (_data21_->_async_data_);
}


static void ____lambda85__twitter_avatar_downloaded (Twitter* _sender, cairo_surface_t* avatar, gpointer self) {
	___lambda85_ (self, avatar);
}


static void twitter_get_surface_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TwitterGetSurfaceData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	twitter_get_surface_co (_data_);
}


static gboolean twitter_get_surface_co (TwitterGetSurfaceData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data21_ = g_slice_new0 (Block21Data);
	_data_->_data21_->_ref_count_ = 1;
	_data_->_data21_->self = g_object_ref (_data_->self);
	_data_->_data21_->_async_data_ = _data_;
	_data_->_tmp0_ = _data_->user_id;
	_vala_assert (_data_->_tmp0_ > ((gint64) 0), "user_id > 0");
	_data_->has_key = FALSE;
	_data_->_tmp1_ = _data_->self->priv->avatar_cache;
	_data_->_tmp2_ = _data_->user_id;
	_data_->_tmp3_ = FALSE;
	_data_->_tmp4_ = cb_avatar_cache_get_surface_for_id (_data_->_tmp1_, _data_->_tmp2_, &_data_->_tmp3_);
	_data_->has_key = _data_->_tmp3_;
	_data_->_tmp5_ = _cairo_surface_reference0 (_data_->_tmp4_);
	_data_->_data21_->a = _data_->_tmp5_;
	_data_->_tmp7_ = _data_->_data21_->a;
	_data_->_tmp8_ = twitter_no_avatar;
	if (_data_->_tmp7_ == _data_->_tmp8_) {
		_data_->_tmp9_ = _data_->url;
		_data_->_tmp10_ = _data_->self->priv->avatar_cache;
		_data_->_tmp11_ = _data_->user_id;
		_data_->_tmp12_ = cb_avatar_cache_get_url_for_id (_data_->_tmp10_, _data_->_tmp11_);
		_data_->_tmp6_ = g_strcmp0 (_data_->_tmp9_, _data_->_tmp12_) != 0;
	} else {
		_data_->_tmp6_ = FALSE;
	}
	_data_->new_url = _data_->_tmp6_;
	_data_->_tmp14_ = _data_->_data21_->a;
	if (_data_->_tmp14_ != NULL) {
		_data_->_tmp15_ = _data_->new_url;
		_data_->_tmp13_ = !_data_->_tmp15_;
	} else {
		_data_->_tmp13_ = FALSE;
	}
	if (_data_->_tmp13_) {
		_data_->_tmp16_ = _data_->_data21_->a;
		_data_->_tmp17_ = _cairo_surface_reference0 (_data_->_tmp16_);
		_data_->result = _data_->_tmp17_;
		block21_data_unref (_data_->_data21_);
		_data_->_data21_ = NULL;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (g_task_get_completed (_data_->_async_result) != TRUE) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp20_ = _data_->has_key;
	if (_data_->_tmp20_) {
		_data_->_tmp21_ = _data_->new_url;
		_data_->_tmp19_ = !_data_->_tmp21_;
	} else {
		_data_->_tmp19_ = FALSE;
	}
	if (_data_->_tmp19_) {
		_data_->_tmp22_ = _data_->force_download;
		_data_->_tmp18_ = !_data_->_tmp22_;
	} else {
		_data_->_tmp18_ = FALSE;
	}
	if (_data_->_tmp18_) {
		_data_->_data22_ = g_slice_new0 (Block22Data);
		_data_->_data22_->_ref_count_ = 1;
		_data_->_data22_->_data21_ = block21_data_ref (_data_->_data21_);
		_data_->_data22_->handler_id = (gulong) 0;
		_data_->_tmp23_ = _data_->user_id;
		_data_->_tmp24_ = g_strdup_printf ("%" G_GINT64_FORMAT, _data_->_tmp23_);
		_data_->_tmp25_ = _data_->_tmp24_;
		_data_->_tmp26_ = g_strconcat ("avatar-downloaded::", _data_->_tmp25_, NULL);
		_data_->_tmp27_ = g_signal_connect_data (_data_->self, _data_->_tmp26_, (GCallback) ____lambda85__twitter_avatar_downloaded, block22_data_ref (_data_->_data22_), (GClosureNotify) block22_data_unref, 0);
		_data_->_data22_->handler_id = _data_->_tmp27_;
		_g_free0 (_data_->_tmp26_);
		_g_free0 (_data_->_tmp25_);
		_data_->_state_ = 1;
		return FALSE;
		_state_1:
		;
		_data_->_tmp28_ = _data_->_data21_->a;
		_data_->_tmp29_ = _cairo_surface_reference0 (_data_->_tmp28_);
		_data_->result = _data_->_tmp29_;
		block22_data_unref (_data_->_data22_);
		_data_->_data22_ = NULL;
		block21_data_unref (_data_->_data21_);
		_data_->_data21_ = NULL;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (g_task_get_completed (_data_->_async_result) != TRUE) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	} else {
		_data_->_tmp30_ = _data_->self->priv->avatar_cache;
		_data_->_tmp31_ = _data_->user_id;
		_data_->_tmp32_ = _data_->url;
		cb_avatar_cache_add (_data_->_tmp30_, _data_->_tmp31_, NULL, _data_->_tmp32_);
		_data_->avatar = NULL;
		{
			_data_->_tmp34_ = _data_->url;
			_data_->_tmp35_ = _data_->size;
			_data_->_state_ = 2;
			tweet_utils_download_avatar (_data_->_tmp34_, _data_->_tmp35_, NULL, twitter_get_surface_ready, _data_);
			return FALSE;
			_state_2:
			_data_->_tmp36_ = tweet_utils_download_avatar_finish (_data_->_res_, &_data_->_inner_error_);
			_data_->_tmp33_ = _data_->_tmp36_;
			if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
				goto __catch16_g_error;
			}
			_data_->_tmp37_ = _data_->_tmp33_;
			_data_->_tmp33_ = NULL;
			_g_object_unref0 (_data_->avatar);
			_data_->avatar = _data_->_tmp37_;
			_g_object_unref0 (_data_->_tmp33_);
		}
		goto __finally16;
		__catch16_g_error:
		{
			_data_->e = _data_->_inner_error_;
			_data_->_inner_error_ = NULL;
			_data_->_tmp38_ = _data_->e;
			_data_->_tmp39_ = _data_->_tmp38_->message;
			_data_->_tmp40_ = _data_->url;
			g_warning ("Twitter.vala:189: %s for %s", _data_->_tmp39_, _data_->_tmp40_);
			_g_error_free0 (_data_->e);
		}
		__finally16:
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			_g_object_unref0 (_data_->avatar);
			block21_data_unref (_data_->_data21_);
			_data_->_data21_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp41_ = _data_->avatar;
		if (_data_->_tmp41_ == NULL) {
			_data_->_tmp42_ = twitter_no_avatar;
			_data_->_tmp43_ = _cairo_surface_reference0 (_data_->_tmp42_);
			_cairo_surface_destroy0 (_data_->s);
			_data_->s = _data_->_tmp43_;
		} else {
			_data_->_tmp44_ = _data_->avatar;
			_data_->_tmp45_ = gdk_cairo_surface_create_from_pixbuf (_data_->_tmp44_, 1, NULL);
			_cairo_surface_destroy0 (_data_->s);
			_data_->s = _data_->_tmp45_;
		}
		_data_->_tmp46_ = _data_->self->priv->avatar_cache;
		_data_->_tmp47_ = _data_->user_id;
		_data_->_tmp48_ = _data_->s;
		_data_->_tmp49_ = _data_->url;
		cb_avatar_cache_set_avatar (_data_->_tmp46_, _data_->_tmp47_, _data_->_tmp48_, _data_->_tmp49_);
		_data_->_tmp50_ = _data_->user_id;
		_data_->_tmp51_ = g_strdup_printf ("%" G_GINT64_FORMAT, _data_->_tmp50_);
		_data_->_tmp52_ = _data_->_tmp51_;
		_data_->_tmp53_ = _data_->s;
		g_signal_emit (_data_->self, twitter_signals[TWITTER_AVATAR_DOWNLOADED_SIGNAL], g_quark_from_string (_data_->_tmp52_), _data_->_tmp53_);
		_g_free0 (_data_->_tmp52_);
		_data_->result = _data_->s;
		_g_object_unref0 (_data_->avatar);
		block21_data_unref (_data_->_data21_);
		_data_->_data21_ = NULL;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (g_task_get_completed (_data_->_async_result) != TRUE) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	block21_data_unref (_data_->_data21_);
	_data_->_data21_ = NULL;
}


static void twitter_class_init (TwitterClass * klass) {
	twitter_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (TwitterPrivate));
	G_OBJECT_CLASS (klass)->finalize = twitter_finalize;
	twitter_signals[TWITTER_AVATAR_DOWNLOADED_SIGNAL] = g_signal_new ("avatar-downloaded", TYPE_TWITTER, G_SIGNAL_RUN_LAST | G_SIGNAL_DETAILED, 0, NULL, NULL, g_cclosure_marshal_VOID__POINTER, G_TYPE_NONE, 1, G_TYPE_POINTER);
}


static void twitter_instance_init (Twitter * self) {
	self->priv = TWITTER_GET_PRIVATE (self);
}


static void twitter_finalize (GObject * obj) {
	Twitter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_TWITTER, Twitter);
	_g_object_unref0 (self->priv->avatar_cache);
	G_OBJECT_CLASS (twitter_parent_class)->finalize (obj);
}


GType twitter_get_type (void) {
	static volatile gsize twitter_type_id__volatile = 0;
	if (g_once_init_enter (&twitter_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TwitterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) twitter_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Twitter), 0, (GInstanceInitFunc) twitter_instance_init, NULL };
		GType twitter_type_id;
		twitter_type_id = g_type_register_static (G_TYPE_OBJECT, "Twitter", &g_define_type_info, 0);
		g_once_init_leave (&twitter_type_id__volatile, twitter_type_id);
	}
	return twitter_type_id__volatile;
}



