/* A packrat parser generated by PackCC 1.8.0 */

#include "general.h"

#ifdef _MSC_VER
#undef _CRT_SECURE_NO_WARNINGS
#define _CRT_SECURE_NO_WARNINGS
#endif /* _MSC_VER */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifndef _MSC_VER
#if defined __GNUC__ && defined _WIN32 /* MinGW */
#ifndef PCC_USE_SYSTEM_STRNLEN
#define strnlen(str, maxlen) pcc_strnlen(str, maxlen)
static size_t pcc_strnlen(const char *str, size_t maxlen) {
    size_t i;
    for (i = 0; i < maxlen && str[i]; i++);
    return i;
}
#endif /* !PCC_USE_SYSTEM_STRNLEN */
#endif /* defined __GNUC__ && defined _WIN32 */
#endif /* !_MSC_VER */

#include "./peg/kotlin.h"

#include "kotlin_pre.h"
#if !defined __has_attribute || defined _MSC_VER
#define __attribute__(x)
#endif

#ifdef _MSC_VER
#define MARK_FUNC_AS_USED __pragma(warning(suppress:4505))
#else
#define MARK_FUNC_AS_USED __attribute__((__unused__))
#endif

#ifndef PCC_BUFFER_MIN_SIZE
#define PCC_BUFFER_MIN_SIZE 256
#endif /* !PCC_BUFFER_MIN_SIZE */

#ifndef PCC_ARRAY_MIN_SIZE
#define PCC_ARRAY_MIN_SIZE 2
#endif /* !PCC_ARRAY_MIN_SIZE */

#ifndef PCC_POOL_MIN_SIZE
#define PCC_POOL_MIN_SIZE 65536
#endif /* !PCC_POOL_MIN_SIZE */

#define PCC_DBG_EVALUATE 0
#define PCC_DBG_MATCH    1
#define PCC_DBG_NOMATCH  2

#define PCC_VOID_VALUE (~(size_t)0)

typedef enum pcc_bool_tag {
    PCC_FALSE = 0,
    PCC_TRUE
} pcc_bool_t;

typedef struct pcc_char_array_tag {
    char *buf;
    size_t max;
    size_t len;
} pcc_char_array_t;

typedef struct pcc_range_tag {
    size_t start;
    size_t end;
} pcc_range_t;

typedef int pcc_value_t;

typedef struct parserCtx *pcc_auxil_t;

typedef pkotlin_context_t pcc_context_t;

typedef struct pcc_value_table_tag {
    pcc_value_t *buf;
    size_t max;
    size_t len;
} pcc_value_table_t;

typedef struct pcc_value_refer_table_tag {
    pcc_value_t **buf;
    size_t max;
    size_t len;
} pcc_value_refer_table_t;

typedef struct pcc_capture_tag {
    pcc_range_t range;
    char *string; /* mutable */
} pcc_capture_t;

typedef struct pcc_capture_table_tag {
    pcc_capture_t *buf;
    size_t max;
    size_t len;
} pcc_capture_table_t;

typedef struct pcc_capture_const_table_tag {
    const pcc_capture_t **buf;
    size_t max;
    size_t len;
} pcc_capture_const_table_t;

typedef struct pcc_thunk_tag pcc_thunk_t;
typedef struct pcc_thunk_array_tag pcc_thunk_array_t;

typedef void (*pcc_action_t)(pcc_context_t *, pcc_thunk_t *, pcc_value_t *);

typedef enum pcc_thunk_type_tag {
    PCC_THUNK_LEAF,
    PCC_THUNK_NODE
} pcc_thunk_type_t;

typedef struct pcc_thunk_leaf_tag {
    pcc_value_refer_table_t values;
    pcc_capture_const_table_t capts;
    pcc_capture_t capt0;
    pcc_action_t action;
} pcc_thunk_leaf_t;

typedef struct pcc_thunk_node_tag {
    const pcc_thunk_array_t *thunks; /* just a reference */
    pcc_value_t *value; /* just a reference */
} pcc_thunk_node_t;

typedef union pcc_thunk_data_tag {
    pcc_thunk_leaf_t leaf;
    pcc_thunk_node_t node;
} pcc_thunk_data_t;

struct pcc_thunk_tag {
    pcc_thunk_type_t type;
    pcc_thunk_data_t data;
};

struct pcc_thunk_array_tag {
    pcc_thunk_t **buf;
    size_t max;
    size_t len;
};

typedef struct pcc_thunk_chunk_tag {
    pcc_value_table_t values;
    pcc_capture_table_t capts;
    pcc_thunk_array_t thunks;
    size_t pos; /* the starting position in the character buffer */
} pcc_thunk_chunk_t;

typedef struct pcc_lr_entry_tag pcc_lr_entry_t;

typedef enum pcc_lr_answer_type_tag {
    PCC_LR_ANSWER_LR,
    PCC_LR_ANSWER_CHUNK
} pcc_lr_answer_type_t;

typedef union pcc_lr_answer_data_tag {
    pcc_lr_entry_t *lr;
    pcc_thunk_chunk_t *chunk;
} pcc_lr_answer_data_t;

typedef struct pcc_lr_answer_tag pcc_lr_answer_t;

struct pcc_lr_answer_tag {
    pcc_lr_answer_type_t type;
    pcc_lr_answer_data_t data;
    size_t pos; /* the absolute position in the input */
    pcc_lr_answer_t *hold;
};

typedef pcc_thunk_chunk_t *(*pcc_rule_t)(pcc_context_t *);

typedef struct pcc_rule_set_tag {
    pcc_rule_t *buf;
    size_t max;
    size_t len;
} pcc_rule_set_t;

typedef struct pcc_lr_head_tag pcc_lr_head_t;

struct pcc_lr_head_tag {
    pcc_rule_t rule;
    pcc_rule_set_t invol;
    pcc_rule_set_t eval;
    pcc_lr_head_t *hold;
};

typedef struct pcc_lr_memo_tag {
    pcc_rule_t rule;
    pcc_lr_answer_t *answer;
} pcc_lr_memo_t;

typedef struct pcc_lr_memo_map_tag {
    pcc_lr_memo_t *buf;
    size_t max;
    size_t len;
} pcc_lr_memo_map_t;

typedef struct pcc_lr_table_entry_tag {
    pcc_lr_head_t *head; /* just a reference */
    pcc_lr_memo_map_t memos;
    pcc_lr_answer_t *hold_a;
    pcc_lr_head_t *hold_h;
} pcc_lr_table_entry_t;

typedef struct pcc_lr_table_tag {
    pcc_lr_table_entry_t **buf;
    size_t max;
    size_t len;
    size_t ofs;
} pcc_lr_table_t;

struct pcc_lr_entry_tag {
    pcc_rule_t rule;
    pcc_thunk_chunk_t *seed; /* just a reference */
    pcc_lr_head_t *head; /* just a reference */
};

typedef struct pcc_lr_stack_tag {
    pcc_lr_entry_t **buf;
    size_t max;
    size_t len;
} pcc_lr_stack_t;

typedef struct pcc_memory_entry_tag pcc_memory_entry_t;
typedef struct pcc_memory_pool_tag pcc_memory_pool_t;

struct pcc_memory_entry_tag {
    pcc_memory_entry_t *next;
};

struct pcc_memory_pool_tag {
    pcc_memory_pool_t *next;
    size_t allocated;
    size_t unused;
};

typedef struct pcc_memory_recycler_tag {
    pcc_memory_pool_t *pool_list;
    pcc_memory_entry_t *entry_list;
    size_t element_size;
} pcc_memory_recycler_t;

struct pkotlin_context_tag {
    size_t pos; /* the position in the input of the first character currently buffered */
    size_t cur; /* the current parsing position in the character buffer */
    size_t level;
    pcc_char_array_t buffer;
    pcc_lr_table_t lrtable;
    pcc_lr_stack_t lrstack;
    pcc_thunk_array_t thunks;
    pcc_auxil_t auxil;
    pcc_memory_recycler_t thunk_chunk_recycler;
    pcc_memory_recycler_t lr_head_recycler;
    pcc_memory_recycler_t lr_answer_recycler;
};

#ifndef PCC_ERROR
#define PCC_ERROR(auxil) pcc_error()
MARK_FUNC_AS_USED
static void pcc_error(void) {
    fprintf(stderr, "Syntax error\n");
    exit(1);
}
#endif /* !PCC_ERROR */

#ifndef PCC_GETCHAR
#define PCC_GETCHAR(auxil) getchar()
#endif /* !PCC_GETCHAR */

#ifndef PCC_MALLOC
#define PCC_MALLOC(auxil, size) pcc_malloc_e(size)
static void *pcc_malloc_e(size_t size) {
    void *const p = malloc(size);
    if (p == NULL) {
        fprintf(stderr, "Out of memory\n");
        exit(1);
    }
    return p;
}
#endif /* !PCC_MALLOC */

#ifndef PCC_REALLOC
#define PCC_REALLOC(auxil, ptr, size) pcc_realloc_e(ptr, size)
static void *pcc_realloc_e(void *ptr, size_t size) {
    void *const p = realloc(ptr, size);
    if (p == NULL) {
        fprintf(stderr, "Out of memory\n");
        exit(1);
    }
    return p;
}
#endif /* !PCC_REALLOC */

#ifndef PCC_FREE
#define PCC_FREE(auxil, ptr) free(ptr)
#endif /* !PCC_FREE */

#ifndef PCC_DEBUG
#define PCC_DEBUG(auxil, event, rule, level, pos, buffer, length) ((void)0)
#endif /* !PCC_DEBUG */

static char *pcc_strndup_e(pcc_auxil_t auxil, const char *str, size_t len) {
    const size_t m = strnlen(str, len);
    char *const s = (char *)PCC_MALLOC(auxil, m + 1);
    memcpy(s, str, m);
    s[m] = '\0';
    return s;
}

static void pcc_char_array__init(pcc_auxil_t auxil, pcc_char_array_t *array) {
    array->len = 0;
    array->max = 0;
    array->buf = NULL;
}

static void pcc_char_array__add(pcc_auxil_t auxil, pcc_char_array_t *array, char ch) {
    if (array->max <= array->len) {
        const size_t n = array->len + 1;
        size_t m = array->max;
        if (m == 0) m = PCC_BUFFER_MIN_SIZE;
        while (m < n && m != 0) m <<= 1;
        if (m == 0) m = n;
        array->buf = (char *)PCC_REALLOC(auxil, array->buf, m);
        array->max = m;
    }
    array->buf[array->len++] = ch;
}

static void pcc_char_array__term(pcc_auxil_t auxil, pcc_char_array_t *array) {
    PCC_FREE(auxil, array->buf);
}

static void pcc_value_table__init(pcc_auxil_t auxil, pcc_value_table_t *table) {
    table->len = 0;
    table->max = 0;
    table->buf = NULL;
}

MARK_FUNC_AS_USED
static void pcc_value_table__resize(pcc_auxil_t auxil, pcc_value_table_t *table, size_t len) {
    if (table->max < len) {
        size_t m = table->max;
        if (m == 0) m = PCC_ARRAY_MIN_SIZE;
        while (m < len && m != 0) m <<= 1;
        if (m == 0) m = len;
        table->buf = (pcc_value_t *)PCC_REALLOC(auxil, table->buf, sizeof(pcc_value_t) * m);
        table->max = m;
    }
    table->len = len;
}

MARK_FUNC_AS_USED
static void pcc_value_table__clear(pcc_auxil_t auxil, pcc_value_table_t *table) {
    memset(table->buf, 0, sizeof(pcc_value_t) * table->len);
}

static void pcc_value_table__term(pcc_auxil_t auxil, pcc_value_table_t *table) {
    PCC_FREE(auxil, table->buf);
}

static void pcc_value_refer_table__init(pcc_auxil_t auxil, pcc_value_refer_table_t *table) {
    table->len = 0;
    table->max = 0;
    table->buf = NULL;
}

static void pcc_value_refer_table__resize(pcc_auxil_t auxil, pcc_value_refer_table_t *table, size_t len) {
    size_t i;
    if (table->max < len) {
        size_t m = table->max;
        if (m == 0) m = PCC_ARRAY_MIN_SIZE;
        while (m < len && m != 0) m <<= 1;
        if (m == 0) m = len;
        table->buf = (pcc_value_t **)PCC_REALLOC(auxil, table->buf, sizeof(pcc_value_t *) * m);
        table->max = m;
    }
    for (i = table->len; i < len; i++) table->buf[i] = NULL;
    table->len = len;
}

static void pcc_value_refer_table__term(pcc_auxil_t auxil, pcc_value_refer_table_t *table) {
    PCC_FREE(auxil, table->buf);
}

static void pcc_capture_table__init(pcc_auxil_t auxil, pcc_capture_table_t *table) {
    table->len = 0;
    table->max = 0;
    table->buf = NULL;
}

MARK_FUNC_AS_USED
static void pcc_capture_table__resize(pcc_auxil_t auxil, pcc_capture_table_t *table, size_t len) {
    size_t i;
    for (i = len; i < table->len; i++) PCC_FREE(auxil, table->buf[i].string);
    if (table->max < len) {
        size_t m = table->max;
        if (m == 0) m = PCC_ARRAY_MIN_SIZE;
        while (m < len && m != 0) m <<= 1;
        if (m == 0) m = len;
        table->buf = (pcc_capture_t *)PCC_REALLOC(auxil, table->buf, sizeof(pcc_capture_t) * m);
        table->max = m;
    }
    for (i = table->len; i < len; i++) {
        table->buf[i].range.start = 0;
        table->buf[i].range.end = 0;
        table->buf[i].string = NULL;
    }
    table->len = len;
}

static void pcc_capture_table__term(pcc_auxil_t auxil, pcc_capture_table_t *table) {
    while (table->len > 0) {
        table->len--;
        PCC_FREE(auxil, table->buf[table->len].string);
    }
    PCC_FREE(auxil, table->buf);
}

static void pcc_capture_const_table__init(pcc_auxil_t auxil, pcc_capture_const_table_t *table) {
    table->len = 0;
    table->max = 0;
    table->buf = NULL;
}

static void pcc_capture_const_table__resize(pcc_auxil_t auxil, pcc_capture_const_table_t *table, size_t len) {
    size_t i;
    if (table->max < len) {
        size_t m = table->max;
        if (m == 0) m = PCC_ARRAY_MIN_SIZE;
        while (m < len && m != 0) m <<= 1;
        if (m == 0) m = len;
        table->buf = (const pcc_capture_t **)PCC_REALLOC(auxil, (pcc_capture_t **)table->buf, sizeof(const pcc_capture_t *) * m);
        table->max = m;
    }
    for (i = table->len; i < len; i++) table->buf[i] = NULL;
    table->len = len;
}

static void pcc_capture_const_table__term(pcc_auxil_t auxil, pcc_capture_const_table_t *table) {
    PCC_FREE(auxil, (void *)table->buf);
}

MARK_FUNC_AS_USED
static pcc_thunk_t *pcc_thunk__create_leaf(pcc_auxil_t auxil, pcc_action_t action, size_t valuec, size_t captc) {
    pcc_thunk_t *const thunk = (pcc_thunk_t *)PCC_MALLOC(auxil, sizeof(pcc_thunk_t));
    thunk->type = PCC_THUNK_LEAF;
    pcc_value_refer_table__init(auxil, &thunk->data.leaf.values);
    pcc_value_refer_table__resize(auxil, &thunk->data.leaf.values, valuec);
    pcc_capture_const_table__init(auxil, &thunk->data.leaf.capts);
    pcc_capture_const_table__resize(auxil, &thunk->data.leaf.capts, captc);
    thunk->data.leaf.capt0.range.start = 0;
    thunk->data.leaf.capt0.range.end = 0;
    thunk->data.leaf.capt0.string = NULL;
    thunk->data.leaf.action = action;
    return thunk;
}

static pcc_thunk_t *pcc_thunk__create_node(pcc_auxil_t auxil, const pcc_thunk_array_t *thunks, pcc_value_t *value) {
    pcc_thunk_t *const thunk = (pcc_thunk_t *)PCC_MALLOC(auxil, sizeof(pcc_thunk_t));
    thunk->type = PCC_THUNK_NODE;
    thunk->data.node.thunks = thunks;
    thunk->data.node.value = value;
    return thunk;
}

static void pcc_thunk__destroy(pcc_auxil_t auxil, pcc_thunk_t *thunk) {
    if (thunk == NULL) return;
    switch (thunk->type) {
    case PCC_THUNK_LEAF:
        PCC_FREE(auxil, thunk->data.leaf.capt0.string);
        pcc_capture_const_table__term(auxil, &thunk->data.leaf.capts);
        pcc_value_refer_table__term(auxil, &thunk->data.leaf.values);
        break;
    case PCC_THUNK_NODE:
        break;
    default: /* unknown */
        break;
    }
    PCC_FREE(auxil, thunk);
}

static void pcc_thunk_array__init(pcc_auxil_t auxil, pcc_thunk_array_t *array) {
    array->len = 0;
    array->max = 0;
    array->buf = NULL;
}

static void pcc_thunk_array__add(pcc_auxil_t auxil, pcc_thunk_array_t *array, pcc_thunk_t *thunk) {
    if (array->max <= array->len) {
        const size_t n = array->len + 1;
        size_t m = array->max;
        if (m == 0) m = PCC_ARRAY_MIN_SIZE;
        while (m < n && m != 0) m <<= 1;
        if (m == 0) m = n;
        array->buf = (pcc_thunk_t **)PCC_REALLOC(auxil, array->buf, sizeof(pcc_thunk_t *) * m);
        array->max = m;
    }
    array->buf[array->len++] = thunk;
}

static void pcc_thunk_array__revert(pcc_auxil_t auxil, pcc_thunk_array_t *array, size_t len) {
    while (array->len > len) {
        array->len--;
        pcc_thunk__destroy(auxil, array->buf[array->len]);
    }
}

static void pcc_thunk_array__term(pcc_auxil_t auxil, pcc_thunk_array_t *array) {
    while (array->len > 0) {
        array->len--;
        pcc_thunk__destroy(auxil, array->buf[array->len]);
    }
    PCC_FREE(auxil, array->buf);
}

static void pcc_memory_recycler__init(pcc_auxil_t auxil, pcc_memory_recycler_t *recycler, size_t element_size) {
    recycler->pool_list = NULL;
    recycler->entry_list = NULL;
    recycler->element_size = element_size;
}

static void *pcc_memory_recycler__supply(pcc_auxil_t auxil, pcc_memory_recycler_t *recycler) {
    if (recycler->entry_list) {
        pcc_memory_entry_t *const tmp = recycler->entry_list;
        recycler->entry_list = tmp->next;
        return tmp;
    }
    if (!recycler->pool_list || recycler->pool_list->unused == 0) {
        size_t size = PCC_POOL_MIN_SIZE;
        if (recycler->pool_list) {
            size = recycler->pool_list->allocated << 1;
            if (size == 0) size = recycler->pool_list->allocated;
        }
        {
            pcc_memory_pool_t *const pool = (pcc_memory_pool_t *)PCC_MALLOC(
                auxil, sizeof(pcc_memory_pool_t) + recycler->element_size * size
            );
            pool->allocated = size;
            pool->unused = size;
            pool->next = recycler->pool_list;
            recycler->pool_list = pool;
        }
    }
    recycler->pool_list->unused--;
    return (char *)recycler->pool_list + sizeof(pcc_memory_pool_t) + recycler->element_size * recycler->pool_list->unused;
}

static void pcc_memory_recycler__recycle(pcc_auxil_t auxil, pcc_memory_recycler_t *recycler, void *ptr) {
    pcc_memory_entry_t *const tmp = (pcc_memory_entry_t *)ptr;
    tmp->next = recycler->entry_list;
    recycler->entry_list = tmp;
}

static void pcc_memory_recycler__term(pcc_auxil_t auxil, pcc_memory_recycler_t *recycler) {
    while (recycler->pool_list) {
        pcc_memory_pool_t *const tmp = recycler->pool_list;
        recycler->pool_list = tmp->next;
        PCC_FREE(auxil, tmp);
    }
}

MARK_FUNC_AS_USED
static pcc_thunk_chunk_t *pcc_thunk_chunk__create(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = (pcc_thunk_chunk_t *)pcc_memory_recycler__supply(ctx->auxil, &ctx->thunk_chunk_recycler);
    pcc_value_table__init(ctx->auxil, &chunk->values);
    pcc_capture_table__init(ctx->auxil, &chunk->capts);
    pcc_thunk_array__init(ctx->auxil, &chunk->thunks);
    chunk->pos = 0;
    return chunk;
}

static void pcc_thunk_chunk__destroy(pcc_context_t *ctx, pcc_thunk_chunk_t *chunk) {
    if (chunk == NULL) return;
    pcc_thunk_array__term(ctx->auxil, &chunk->thunks);
    pcc_capture_table__term(ctx->auxil, &chunk->capts);
    pcc_value_table__term(ctx->auxil, &chunk->values);
    pcc_memory_recycler__recycle(ctx->auxil, &ctx->thunk_chunk_recycler, chunk);
}

static void pcc_rule_set__init(pcc_auxil_t auxil, pcc_rule_set_t *set) {
    set->len = 0;
    set->max = 0;
    set->buf = NULL;
}

static size_t pcc_rule_set__index(pcc_auxil_t auxil, const pcc_rule_set_t *set, pcc_rule_t rule) {
    size_t i;
    for (i = 0; i < set->len; i++) {
        if (set->buf[i] == rule) return i;
    }
    return PCC_VOID_VALUE;
}

static pcc_bool_t pcc_rule_set__add(pcc_auxil_t auxil, pcc_rule_set_t *set, pcc_rule_t rule) {
    const size_t i = pcc_rule_set__index(auxil, set, rule);
    if (i != PCC_VOID_VALUE) return PCC_FALSE;
    if (set->max <= set->len) {
        const size_t n = set->len + 1;
        size_t m = set->max;
        if (m == 0) m = PCC_ARRAY_MIN_SIZE;
        while (m < n && m != 0) m <<= 1;
        if (m == 0) m = n;
        set->buf = (pcc_rule_t *)PCC_REALLOC(auxil, set->buf, sizeof(pcc_rule_t) * m);
        set->max = m;
    }
    set->buf[set->len++] = rule;
    return PCC_TRUE;
}

static pcc_bool_t pcc_rule_set__remove(pcc_auxil_t auxil, pcc_rule_set_t *set, pcc_rule_t rule) {
    const size_t i = pcc_rule_set__index(auxil, set, rule);
    if (i == PCC_VOID_VALUE) return PCC_FALSE;
    memmove(set->buf + i, set->buf + (i + 1), sizeof(pcc_rule_t) * (set->len - (i + 1)));
    return PCC_TRUE;
}

static void pcc_rule_set__clear(pcc_auxil_t auxil, pcc_rule_set_t *set) {
    set->len = 0;
}

static void pcc_rule_set__copy(pcc_auxil_t auxil, pcc_rule_set_t *set, const pcc_rule_set_t *src) {
    size_t i;
    pcc_rule_set__clear(auxil, set);
    for (i = 0; i < src->len; i++) {
        pcc_rule_set__add(auxil, set, src->buf[i]);
    }
}

static void pcc_rule_set__term(pcc_auxil_t auxil, pcc_rule_set_t *set) {
    PCC_FREE(auxil, set->buf);
}

static pcc_lr_head_t *pcc_lr_head__create(pcc_context_t *ctx, pcc_rule_t rule) {
    pcc_lr_head_t *const head = (pcc_lr_head_t *)pcc_memory_recycler__supply(ctx->auxil, &ctx->lr_head_recycler);
    head->rule = rule;
    pcc_rule_set__init(ctx->auxil, &head->invol);
    pcc_rule_set__init(ctx->auxil, &head->eval);
    head->hold = NULL;
    return head;
}

static void pcc_lr_head__destroy(pcc_context_t *ctx, pcc_lr_head_t *head) {
    if (head == NULL) return;
    pcc_lr_head__destroy(ctx, head->hold);
    pcc_rule_set__term(ctx->auxil, &head->eval);
    pcc_rule_set__term(ctx->auxil, &head->invol);
    pcc_memory_recycler__recycle(ctx->auxil, &ctx->lr_head_recycler, head);
}

static void pcc_lr_entry__destroy(pcc_auxil_t auxil, pcc_lr_entry_t *lr);

static pcc_lr_answer_t *pcc_lr_answer__create(pcc_context_t *ctx, pcc_lr_answer_type_t type, size_t pos) {
    pcc_lr_answer_t *answer = (pcc_lr_answer_t *)pcc_memory_recycler__supply(ctx->auxil, &ctx->lr_answer_recycler);
    answer->type = type;
    answer->pos = pos;
    answer->hold = NULL;
    switch (answer->type) {
    case PCC_LR_ANSWER_LR:
        answer->data.lr = NULL;
        break;
    case PCC_LR_ANSWER_CHUNK:
        answer->data.chunk = NULL;
        break;
    default: /* unknown */
        PCC_FREE(ctx->auxil, answer);
        answer = NULL;
    }
    return answer;
}

static void pcc_lr_answer__set_chunk(pcc_context_t *ctx, pcc_lr_answer_t *answer, pcc_thunk_chunk_t *chunk) {
    pcc_lr_answer_t *const a = pcc_lr_answer__create(ctx, answer->type, answer->pos);
    switch (answer->type) {
    case PCC_LR_ANSWER_LR:
        a->data.lr = answer->data.lr;
        break;
    case PCC_LR_ANSWER_CHUNK:
        a->data.chunk = answer->data.chunk;
        break;
    default: /* unknown */
        break;
    }
    a->hold = answer->hold;
    answer->hold = a;
    answer->type = PCC_LR_ANSWER_CHUNK;
    answer->data.chunk = chunk;
}

static void pcc_lr_answer__destroy(pcc_context_t *ctx, pcc_lr_answer_t *answer) {
    while (answer != NULL) {
        pcc_lr_answer_t *const a = answer->hold;
        switch (answer->type) {
        case PCC_LR_ANSWER_LR:
            pcc_lr_entry__destroy(ctx->auxil, answer->data.lr);
            break;
        case PCC_LR_ANSWER_CHUNK:
            pcc_thunk_chunk__destroy(ctx, answer->data.chunk);
            break;
        default: /* unknown */
            break;
        }
        pcc_memory_recycler__recycle(ctx->auxil, &ctx->lr_answer_recycler, answer);
        answer = a;
    }
}

static void pcc_lr_memo_map__init(pcc_auxil_t auxil, pcc_lr_memo_map_t *map) {
    map->len = 0;
    map->max = 0;
    map->buf = NULL;
}

static size_t pcc_lr_memo_map__index(pcc_context_t *ctx, pcc_lr_memo_map_t *map, pcc_rule_t rule) {
    size_t i;
    for (i = 0; i < map->len; i++) {
        if (map->buf[i].rule == rule) return i;
    }
    return PCC_VOID_VALUE;
}

static void pcc_lr_memo_map__put(pcc_context_t *ctx, pcc_lr_memo_map_t *map, pcc_rule_t rule, pcc_lr_answer_t *answer) {
    const size_t i = pcc_lr_memo_map__index(ctx, map, rule);
    if (i != PCC_VOID_VALUE) {
        pcc_lr_answer__destroy(ctx, map->buf[i].answer);
        map->buf[i].answer = answer;
    }
    else {
        if (map->max <= map->len) {
            const size_t n = map->len + 1;
            size_t m = map->max;
            if (m == 0) m = PCC_ARRAY_MIN_SIZE;
            while (m < n && m != 0) m <<= 1;
            if (m == 0) m = n;
            map->buf = (pcc_lr_memo_t *)PCC_REALLOC(ctx->auxil, map->buf, sizeof(pcc_lr_memo_t) * m);
            map->max = m;
        }
        map->buf[map->len].rule = rule;
        map->buf[map->len].answer = answer;
        map->len++;
    }
}

static pcc_lr_answer_t *pcc_lr_memo_map__get(pcc_context_t *ctx, pcc_lr_memo_map_t *map, pcc_rule_t rule) {
    const size_t i = pcc_lr_memo_map__index(ctx, map, rule);
    return (i != PCC_VOID_VALUE) ? map->buf[i].answer : NULL;
}

static void pcc_lr_memo_map__term(pcc_context_t *ctx, pcc_lr_memo_map_t *map) {
    while (map->len > 0) {
        map->len--;
        pcc_lr_answer__destroy(ctx, map->buf[map->len].answer);
    }
    PCC_FREE(ctx->auxil, map->buf);
}

static pcc_lr_table_entry_t *pcc_lr_table_entry__create(pcc_context_t *ctx) {
    pcc_lr_table_entry_t *const entry = (pcc_lr_table_entry_t *)PCC_MALLOC(ctx->auxil, sizeof(pcc_lr_table_entry_t));
    entry->head = NULL;
    pcc_lr_memo_map__init(ctx->auxil, &entry->memos);
    entry->hold_a = NULL;
    entry->hold_h = NULL;
    return entry;
}

static void pcc_lr_table_entry__destroy(pcc_context_t *ctx, pcc_lr_table_entry_t *entry) {
    if (entry == NULL) return;
    pcc_lr_head__destroy(ctx, entry->hold_h);
    pcc_lr_answer__destroy(ctx, entry->hold_a);
    pcc_lr_memo_map__term(ctx, &entry->memos);
    PCC_FREE(ctx->auxil, entry);
}

static void pcc_lr_table__init(pcc_auxil_t auxil, pcc_lr_table_t *table) {
    table->ofs = 0;
    table->len = 0;
    table->max = 0;
    table->buf = NULL;
}

static void pcc_lr_table__resize(pcc_context_t *ctx, pcc_lr_table_t *table, size_t len) {
    size_t i;
    for (i = len; i < table->len; i++) pcc_lr_table_entry__destroy(ctx, table->buf[i]);
    if (table->max < len) {
        size_t m = table->max;
        if (m == 0) m = PCC_ARRAY_MIN_SIZE;
        while (m < len && m != 0) m <<= 1;
        if (m == 0) m = len;
        table->buf = (pcc_lr_table_entry_t **)PCC_REALLOC(ctx->auxil, table->buf, sizeof(pcc_lr_table_entry_t *) * m);
        table->max = m;
    }
    for (i = table->len; i < len; i++) table->buf[i] = NULL;
    table->len = len;
}

static void pcc_lr_table__set_head(pcc_context_t *ctx, pcc_lr_table_t *table, size_t index, pcc_lr_head_t *head) {
    index += table->ofs;
    if (index >= table->len) pcc_lr_table__resize(ctx, table, index + 1);
    if (table->buf[index] == NULL) table->buf[index] = pcc_lr_table_entry__create(ctx);
    table->buf[index]->head = head;
}

static void pcc_lr_table__hold_head(pcc_context_t *ctx, pcc_lr_table_t *table, size_t index, pcc_lr_head_t *head) {
    index += table->ofs;
    if (index >= table->len) pcc_lr_table__resize(ctx, table, index + 1);
    if (table->buf[index] == NULL) table->buf[index] = pcc_lr_table_entry__create(ctx);
    head->hold = table->buf[index]->hold_h;
    table->buf[index]->hold_h = head;
}

static void pcc_lr_table__set_answer(pcc_context_t *ctx, pcc_lr_table_t *table, size_t index, pcc_rule_t rule, pcc_lr_answer_t *answer) {
    index += table->ofs;
    if (index >= table->len) pcc_lr_table__resize(ctx, table, index + 1);
    if (table->buf[index] == NULL) table->buf[index] = pcc_lr_table_entry__create(ctx);
    pcc_lr_memo_map__put(ctx, &table->buf[index]->memos, rule, answer);
}

static void pcc_lr_table__hold_answer(pcc_context_t *ctx, pcc_lr_table_t *table, size_t index, pcc_lr_answer_t *answer) {
    index += table->ofs;
    if (index >= table->len) pcc_lr_table__resize(ctx, table, index + 1);
    if (table->buf[index] == NULL) table->buf[index] = pcc_lr_table_entry__create(ctx);
    answer->hold = table->buf[index]->hold_a;
    table->buf[index]->hold_a = answer;
}

static pcc_lr_head_t *pcc_lr_table__get_head(pcc_context_t *ctx, pcc_lr_table_t *table, size_t index) {
    index += table->ofs;
    if (index >= table->len || table->buf[index] == NULL) return NULL;
    return table->buf[index]->head;
}

static pcc_lr_answer_t *pcc_lr_table__get_answer(pcc_context_t *ctx, pcc_lr_table_t *table, size_t index, pcc_rule_t rule) {
    index += table->ofs;
    if (index >= table->len || table->buf[index] == NULL) return NULL;
    return pcc_lr_memo_map__get(ctx, &table->buf[index]->memos, rule);
}

static void pcc_lr_table__shift(pcc_context_t *ctx, pcc_lr_table_t *table, size_t count) {
    size_t i;
    if (count > table->len - table->ofs) count = table->len - table->ofs;
    for (i = 0; i < count; i++) pcc_lr_table_entry__destroy(ctx, table->buf[table->ofs++]);
    if (table->ofs > (table->max >> 1)) {
        memmove(table->buf, table->buf + table->ofs, sizeof(pcc_lr_table_entry_t *) * (table->len - table->ofs));
        table->len -= table->ofs;
        table->ofs = 0;
    }
}

static void pcc_lr_table__term(pcc_context_t *ctx, pcc_lr_table_t *table) {
    while (table->len > table->ofs) {
        table->len--;
        pcc_lr_table_entry__destroy(ctx, table->buf[table->len]);
    }
    PCC_FREE(ctx->auxil, table->buf);
}

static pcc_lr_entry_t *pcc_lr_entry__create(pcc_auxil_t auxil, pcc_rule_t rule) {
    pcc_lr_entry_t *const lr = (pcc_lr_entry_t *)PCC_MALLOC(auxil, sizeof(pcc_lr_entry_t));
    lr->rule = rule;
    lr->seed = NULL;
    lr->head = NULL;
    return lr;
}

static void pcc_lr_entry__destroy(pcc_auxil_t auxil, pcc_lr_entry_t *lr) {
    PCC_FREE(auxil, lr);
}

static void pcc_lr_stack__init(pcc_auxil_t auxil, pcc_lr_stack_t *stack) {
    stack->len = 0;
    stack->max = 0;
    stack->buf = NULL;
}

static void pcc_lr_stack__push(pcc_auxil_t auxil, pcc_lr_stack_t *stack, pcc_lr_entry_t *lr) {
    if (stack->max <= stack->len) {
        const size_t n = stack->len + 1;
        size_t m = stack->max;
        if (m == 0) m = PCC_ARRAY_MIN_SIZE;
        while (m < n && m != 0) m <<= 1;
        if (m == 0) m = n;
        stack->buf = (pcc_lr_entry_t **)PCC_REALLOC(auxil, stack->buf, sizeof(pcc_lr_entry_t *) * m);
        stack->max = m;
    }
    stack->buf[stack->len++] = lr;
}

static pcc_lr_entry_t *pcc_lr_stack__pop(pcc_auxil_t auxil, pcc_lr_stack_t *stack) {
    return stack->buf[--stack->len];
}

static void pcc_lr_stack__term(pcc_auxil_t auxil, pcc_lr_stack_t *stack) {
    PCC_FREE(auxil, stack->buf);
}

static pcc_context_t *pcc_context__create(pcc_auxil_t auxil) {
    pcc_context_t *const ctx = (pcc_context_t *)PCC_MALLOC(auxil, sizeof(pcc_context_t));
    ctx->pos = 0;
    ctx->cur = 0;
    ctx->level = 0;
    pcc_char_array__init(auxil, &ctx->buffer);
    pcc_lr_table__init(auxil, &ctx->lrtable);
    pcc_lr_stack__init(auxil, &ctx->lrstack);
    pcc_thunk_array__init(auxil, &ctx->thunks);
    pcc_memory_recycler__init(auxil, &ctx->thunk_chunk_recycler, sizeof(pcc_thunk_chunk_t));
    pcc_memory_recycler__init(auxil, &ctx->lr_head_recycler, sizeof(pcc_lr_head_t));
    pcc_memory_recycler__init(auxil, &ctx->lr_answer_recycler, sizeof(pcc_lr_answer_t));
    ctx->auxil = auxil;
    return ctx;
}

static void pcc_context__destroy(pcc_context_t *ctx) {
    if (ctx == NULL) return;
    pcc_thunk_array__term(ctx->auxil, &ctx->thunks);
    pcc_lr_stack__term(ctx->auxil, &ctx->lrstack);
    pcc_lr_table__term(ctx, &ctx->lrtable);
    pcc_char_array__term(ctx->auxil, &ctx->buffer);
    pcc_memory_recycler__term(ctx->auxil, &ctx->thunk_chunk_recycler);
    pcc_memory_recycler__term(ctx->auxil, &ctx->lr_head_recycler);
    pcc_memory_recycler__term(ctx->auxil, &ctx->lr_answer_recycler);
    PCC_FREE(ctx->auxil, ctx);
}

static size_t pcc_refill_buffer(pcc_context_t *ctx, size_t num) {
    if (ctx->buffer.len >= ctx->cur + num) return ctx->buffer.len - ctx->cur;
    while (ctx->buffer.len < ctx->cur + num) {
        const int c = PCC_GETCHAR(ctx->auxil);
        if (c < 0) break;
        pcc_char_array__add(ctx->auxil, &ctx->buffer, (char)c);
    }
    return ctx->buffer.len - ctx->cur;
}

MARK_FUNC_AS_USED
static void pcc_commit_buffer(pcc_context_t *ctx) {
    memmove(ctx->buffer.buf, ctx->buffer.buf + ctx->cur, ctx->buffer.len - ctx->cur);
    ctx->buffer.len -= ctx->cur;
    ctx->pos += ctx->cur;
    pcc_lr_table__shift(ctx, &ctx->lrtable, ctx->cur);
    ctx->cur = 0;
}

MARK_FUNC_AS_USED
static const char *pcc_get_capture_string(pcc_context_t *ctx, const pcc_capture_t *capt) {
    if (capt->string == NULL)
        ((pcc_capture_t *)capt)->string =
            pcc_strndup_e(ctx->auxil, ctx->buffer.buf + capt->range.start, capt->range.end - capt->range.start);
    return capt->string;
}

static size_t pcc_get_char_as_utf32(pcc_context_t *ctx, int *out) { /* with checking UTF-8 validity */
    int c, u;
    size_t n;
    if (pcc_refill_buffer(ctx, 1) < 1) return 0;
    c = (int)(unsigned char)ctx->buffer.buf[ctx->cur];
    n = (c < 0x80) ? 1 :
        ((c & 0xe0) == 0xc0) ? 2 :
        ((c & 0xf0) == 0xe0) ? 3 :
        ((c & 0xf8) == 0xf0) ? 4 : 0;
    if (n < 1) return 0;
    if (pcc_refill_buffer(ctx, n) < n) return 0;
    switch (n) {
    case 1:
        u = c;
        break;
    case 2:
        u = c & 0x1f;
        c = (int)(unsigned char)ctx->buffer.buf[ctx->cur + 1];
        if ((c & 0xc0) != 0x80) return 0;
        u <<= 6; u |= c & 0x3f;
        if (u < 0x80) return 0;
        break;
    case 3:
        u = c & 0x0f;
        c = (int)(unsigned char)ctx->buffer.buf[ctx->cur + 1];
        if ((c & 0xc0) != 0x80) return 0;
        u <<= 6; u |= c & 0x3f;
        c = (int)(unsigned char)ctx->buffer.buf[ctx->cur + 2];
        if ((c & 0xc0) != 0x80) return 0;
        u <<= 6; u |= c & 0x3f;
        if (u < 0x800) return 0;
        break;
    case 4:
        u = c & 0x07;
        c = (int)(unsigned char)ctx->buffer.buf[ctx->cur + 1];
        if ((c & 0xc0) != 0x80) return 0;
        u <<= 6; u |= c & 0x3f;
        c = (int)(unsigned char)ctx->buffer.buf[ctx->cur + 2];
        if ((c & 0xc0) != 0x80) return 0;
        u <<= 6; u |= c & 0x3f;
        c = (int)(unsigned char)ctx->buffer.buf[ctx->cur + 3];
        if ((c & 0xc0) != 0x80) return 0;
        u <<= 6; u |= c & 0x3f;
        if (u < 0x10000 || u > 0x10ffff) return 0;
        break;
    default:
        return 0;
    }
    if (out) *out = u;
    return n;
}

MARK_FUNC_AS_USED
static pcc_bool_t pcc_apply_rule(pcc_context_t *ctx, pcc_rule_t rule, pcc_thunk_array_t *thunks, pcc_value_t *value) {
    static pcc_value_t null;
    pcc_thunk_chunk_t *c = NULL;
    const size_t p = ctx->pos + ctx->cur;
    pcc_bool_t b = PCC_TRUE;
    pcc_lr_answer_t *a = pcc_lr_table__get_answer(ctx, &ctx->lrtable, p, rule);
    pcc_lr_head_t *h = pcc_lr_table__get_head(ctx, &ctx->lrtable, p);
    if (h != NULL) {
        if (a == NULL && rule != h->rule && pcc_rule_set__index(ctx->auxil, &h->invol, rule) == PCC_VOID_VALUE) {
            b = PCC_FALSE;
            c = NULL;
        }
        else if (pcc_rule_set__remove(ctx->auxil, &h->eval, rule)) {
            b = PCC_FALSE;
            c = rule(ctx);
            a = pcc_lr_answer__create(ctx, PCC_LR_ANSWER_CHUNK, ctx->pos + ctx->cur);
            a->data.chunk = c;
            pcc_lr_table__hold_answer(ctx, &ctx->lrtable, p, a);
        }
    }
    if (b) {
        if (a != NULL) {
            ctx->cur = a->pos - ctx->pos;
            switch (a->type) {
            case PCC_LR_ANSWER_LR:
                if (a->data.lr->head == NULL) {
                    a->data.lr->head = pcc_lr_head__create(ctx, rule);
                    pcc_lr_table__hold_head(ctx, &ctx->lrtable, p, a->data.lr->head);
                }
                {
                    size_t i = ctx->lrstack.len;
                    while (i > 0) {
                        i--;
                        if (ctx->lrstack.buf[i]->head == a->data.lr->head) break;
                        ctx->lrstack.buf[i]->head = a->data.lr->head;
                        pcc_rule_set__add(ctx->auxil, &a->data.lr->head->invol, ctx->lrstack.buf[i]->rule);
                    }
                }
                c = a->data.lr->seed;
                break;
            case PCC_LR_ANSWER_CHUNK:
                c = a->data.chunk;
                break;
            default: /* unknown */
                break;
            }
        }
        else {
            pcc_lr_entry_t *const e = pcc_lr_entry__create(ctx->auxil, rule);
            pcc_lr_stack__push(ctx->auxil, &ctx->lrstack, e);
            a = pcc_lr_answer__create(ctx, PCC_LR_ANSWER_LR, p);
            a->data.lr = e;
            pcc_lr_table__set_answer(ctx, &ctx->lrtable, p, rule, a);
            c = rule(ctx);
            pcc_lr_stack__pop(ctx->auxil, &ctx->lrstack);
            a->pos = ctx->pos + ctx->cur;
            if (e->head == NULL) {
                pcc_lr_answer__set_chunk(ctx, a, c);
            }
            else {
                e->seed = c;
                h = a->data.lr->head;
                if (h->rule != rule) {
                    c = a->data.lr->seed;
                    a = pcc_lr_answer__create(ctx, PCC_LR_ANSWER_CHUNK, ctx->pos + ctx->cur);
                    a->data.chunk = c;
                    pcc_lr_table__hold_answer(ctx, &ctx->lrtable, p, a);
                }
                else {
                    pcc_lr_answer__set_chunk(ctx, a, a->data.lr->seed);
                    if (a->data.chunk == NULL) {
                        c = NULL;
                    }
                    else {
                        pcc_lr_table__set_head(ctx, &ctx->lrtable, p, h);
                        for (;;) {
                            ctx->cur = p - ctx->pos;
                            pcc_rule_set__copy(ctx->auxil, &h->eval, &h->invol);
                            c = rule(ctx);
                            if (c == NULL || ctx->pos + ctx->cur <= a->pos) break;
                            pcc_lr_answer__set_chunk(ctx, a, c);
                            a->pos = ctx->pos + ctx->cur;
                        }
                        pcc_thunk_chunk__destroy(ctx, c);
                        pcc_lr_table__set_head(ctx, &ctx->lrtable, p, NULL);
                        ctx->cur = a->pos - ctx->pos;
                        c = a->data.chunk;
                    }
                }
            }
        }
    }
    if (c == NULL) return PCC_FALSE;
    if (value == NULL) value = &null;
    memset(value, 0, sizeof(pcc_value_t)); /* in case */
    pcc_thunk_array__add(ctx->auxil, thunks, pcc_thunk__create_node(ctx->auxil, &c->thunks, value));
    return PCC_TRUE;
}

MARK_FUNC_AS_USED
static void pcc_do_action(pcc_context_t *ctx, const pcc_thunk_array_t *thunks, pcc_value_t *value) {
    size_t i;
    for (i = 0; i < thunks->len; i++) {
        pcc_thunk_t *const thunk = thunks->buf[i];
        switch (thunk->type) {
        case PCC_THUNK_LEAF:
            thunk->data.leaf.action(ctx, thunk, value);
            break;
        case PCC_THUNK_NODE:
            pcc_do_action(ctx, thunk->data.node.thunks, thunk->data.node.value);
            break;
        default: /* unknown */
            break;
        }
    }
}

static void pcc_action_filePart_0(pkotlin_context_t *__pcc_ctx, pcc_thunk_t *__pcc_in, pcc_value_t *__pcc_out) {
#define auxil (__pcc_ctx->auxil)
#define __ (*__pcc_out)
#define _0 pcc_get_capture_string(__pcc_ctx, &__pcc_in->data.leaf.capt0)
#define _0s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.start))
#define _0e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.end))
    resetFailure(auxil, _0s);
#undef _0e
#undef _0s
#undef _0
#undef __
#undef auxil
}

static void pcc_action_unparsable_0(pkotlin_context_t *__pcc_ctx, pcc_thunk_t *__pcc_in, pcc_value_t *__pcc_out) {
#define auxil (__pcc_ctx->auxil)
#define __ (*__pcc_out)
#define _0 pcc_get_capture_string(__pcc_ctx, &__pcc_in->data.leaf.capt0)
#define _0s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.start))
#define _0e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.end))
    reportFailure(auxil, _0s);
#undef _0e
#undef _0s
#undef _0
#undef __
#undef auxil
}

static void pcc_action_packageHeader_0(pkotlin_context_t *__pcc_ctx, pcc_thunk_t *__pcc_in, pcc_value_t *__pcc_out) {
#define auxil (__pcc_ctx->auxil)
#define __ (*__pcc_out)
#define _0 pcc_get_capture_string(__pcc_ctx, &__pcc_in->data.leaf.capt0)
#define _0s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.start))
#define _0e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.end))
    PUSH_KIND(auxil, K_PACKAGE);
#undef _0e
#undef _0s
#undef _0
#undef __
#undef auxil
}

static void pcc_action_packageHeader_1(pkotlin_context_t *__pcc_ctx, pcc_thunk_t *__pcc_in, pcc_value_t *__pcc_out) {
#define auxil (__pcc_ctx->auxil)
#define __ (*__pcc_out)
#define _0 pcc_get_capture_string(__pcc_ctx, &__pcc_in->data.leaf.capt0)
#define _0s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.start))
#define _0e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.end))
#define _1 pcc_get_capture_string(__pcc_ctx, __pcc_in->data.leaf.capts.buf[0])
#define _1s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[0]->range.start))
#define _1e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[0]->range.end))
    makeKotlinTag(auxil, _1, _1s, true);
#undef _1e
#undef _1s
#undef _1
#undef _0e
#undef _0s
#undef _0
#undef __
#undef auxil
}

static void pcc_action_typeAlias_0(pkotlin_context_t *__pcc_ctx, pcc_thunk_t *__pcc_in, pcc_value_t *__pcc_out) {
#define auxil (__pcc_ctx->auxil)
#define __ (*__pcc_out)
#define _0 pcc_get_capture_string(__pcc_ctx, &__pcc_in->data.leaf.capt0)
#define _0s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.start))
#define _0e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.end))
    PUSH_KIND(auxil, K_TYPEALIAS);
#undef _0e
#undef _0s
#undef _0
#undef __
#undef auxil
}

static void pcc_action_typeAlias_1(pkotlin_context_t *__pcc_ctx, pcc_thunk_t *__pcc_in, pcc_value_t *__pcc_out) {
#define auxil (__pcc_ctx->auxil)
#define __ (*__pcc_out)
#define _0 pcc_get_capture_string(__pcc_ctx, &__pcc_in->data.leaf.capt0)
#define _0s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.start))
#define _0e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.end))
#define _1 pcc_get_capture_string(__pcc_ctx, __pcc_in->data.leaf.capts.buf[0])
#define _1s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[0]->range.start))
#define _1e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[0]->range.end))
    makeKotlinTag(auxil, _1, _1s, false);
#undef _1e
#undef _1s
#undef _1
#undef _0e
#undef _0s
#undef _0
#undef __
#undef auxil
}

static void pcc_action_classDeclaration_0(pkotlin_context_t *__pcc_ctx, pcc_thunk_t *__pcc_in, pcc_value_t *__pcc_out) {
#define auxil (__pcc_ctx->auxil)
#define __ (*__pcc_out)
#define _0 pcc_get_capture_string(__pcc_ctx, &__pcc_in->data.leaf.capt0)
#define _0s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.start))
#define _0e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.end))
    PUSH_KIND(auxil, K_CLASS);
#undef _0e
#undef _0s
#undef _0
#undef __
#undef auxil
}

static void pcc_action_classDeclaration_1(pkotlin_context_t *__pcc_ctx, pcc_thunk_t *__pcc_in, pcc_value_t *__pcc_out) {
#define auxil (__pcc_ctx->auxil)
#define __ (*__pcc_out)
#define _0 pcc_get_capture_string(__pcc_ctx, &__pcc_in->data.leaf.capt0)
#define _0s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.start))
#define _0e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.end))
    PUSH_KIND(auxil, K_INTERFACE);
#undef _0e
#undef _0s
#undef _0
#undef __
#undef auxil
}

static void pcc_action_classDeclaration_2(pkotlin_context_t *__pcc_ctx, pcc_thunk_t *__pcc_in, pcc_value_t *__pcc_out) {
#define auxil (__pcc_ctx->auxil)
#define __ (*__pcc_out)
#define _0 pcc_get_capture_string(__pcc_ctx, &__pcc_in->data.leaf.capt0)
#define _0s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.start))
#define _0e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.end))
#define _1 pcc_get_capture_string(__pcc_ctx, __pcc_in->data.leaf.capts.buf[0])
#define _1s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[0]->range.start))
#define _1e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[0]->range.end))
    makeKotlinTag(auxil, _1, _1s, true);
#undef _1e
#undef _1s
#undef _1
#undef _0e
#undef _0s
#undef _0
#undef __
#undef auxil
}

static void pcc_action_classDeclaration_3(pkotlin_context_t *__pcc_ctx, pcc_thunk_t *__pcc_in, pcc_value_t *__pcc_out) {
#define auxil (__pcc_ctx->auxil)
#define __ (*__pcc_out)
#define _0 pcc_get_capture_string(__pcc_ctx, &__pcc_in->data.leaf.capt0)
#define _0s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.start))
#define _0e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.end))
#define _1 pcc_get_capture_string(__pcc_ctx, __pcc_in->data.leaf.capts.buf[0])
#define _1s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[0]->range.start))
#define _1e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[0]->range.end))
    POP_SCOPE(auxil);
#undef _1e
#undef _1s
#undef _1
#undef _0e
#undef _0s
#undef _0
#undef __
#undef auxil
}

static void pcc_action_classParameter_0(pkotlin_context_t *__pcc_ctx, pcc_thunk_t *__pcc_in, pcc_value_t *__pcc_out) {
#define auxil (__pcc_ctx->auxil)
#define __ (*__pcc_out)
#define _0 pcc_get_capture_string(__pcc_ctx, &__pcc_in->data.leaf.capt0)
#define _0s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.start))
#define _0e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.end))
    PUSH_KIND(auxil, K_CONSTANT);
#undef _0e
#undef _0s
#undef _0
#undef __
#undef auxil
}

static void pcc_action_classParameter_1(pkotlin_context_t *__pcc_ctx, pcc_thunk_t *__pcc_in, pcc_value_t *__pcc_out) {
#define auxil (__pcc_ctx->auxil)
#define __ (*__pcc_out)
#define _0 pcc_get_capture_string(__pcc_ctx, &__pcc_in->data.leaf.capt0)
#define _0s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.start))
#define _0e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.end))
    PUSH_KIND(auxil, K_VARIABLE);
#undef _0e
#undef _0s
#undef _0
#undef __
#undef auxil
}

static void pcc_action_classParameter_2(pkotlin_context_t *__pcc_ctx, pcc_thunk_t *__pcc_in, pcc_value_t *__pcc_out) {
#define auxil (__pcc_ctx->auxil)
#define __ (*__pcc_out)
#define _0 pcc_get_capture_string(__pcc_ctx, &__pcc_in->data.leaf.capt0)
#define _0s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.start))
#define _0e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.end))
    PUSH_KIND(auxil, K_IGNORE);
#undef _0e
#undef _0s
#undef _0
#undef __
#undef auxil
}

static void pcc_action_classParameter_3(pkotlin_context_t *__pcc_ctx, pcc_thunk_t *__pcc_in, pcc_value_t *__pcc_out) {
#define auxil (__pcc_ctx->auxil)
#define __ (*__pcc_out)
#define _0 pcc_get_capture_string(__pcc_ctx, &__pcc_in->data.leaf.capt0)
#define _0s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.start))
#define _0e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.end))
#define _1 pcc_get_capture_string(__pcc_ctx, __pcc_in->data.leaf.capts.buf[0])
#define _1s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[0]->range.start))
#define _1e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[0]->range.end))
    makeKotlinTag(auxil, _1, _1s, true);
#undef _1e
#undef _1s
#undef _1
#undef _0e
#undef _0s
#undef _0
#undef __
#undef auxil
}

static void pcc_action_classParameter_4(pkotlin_context_t *__pcc_ctx, pcc_thunk_t *__pcc_in, pcc_value_t *__pcc_out) {
#define auxil (__pcc_ctx->auxil)
#define __ (*__pcc_out)
#define _0 pcc_get_capture_string(__pcc_ctx, &__pcc_in->data.leaf.capt0)
#define _0s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.start))
#define _0e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.end))
#define _1 pcc_get_capture_string(__pcc_ctx, __pcc_in->data.leaf.capts.buf[0])
#define _1s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[0]->range.start))
#define _1e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[0]->range.end))
    POP_SCOPE(auxil);
#undef _1e
#undef _1s
#undef _1
#undef _0e
#undef _0s
#undef _0
#undef __
#undef auxil
}

static void pcc_action_companionObject_0(pkotlin_context_t *__pcc_ctx, pcc_thunk_t *__pcc_in, pcc_value_t *__pcc_out) {
#define auxil (__pcc_ctx->auxil)
#define __ (*__pcc_out)
#define _0 pcc_get_capture_string(__pcc_ctx, &__pcc_in->data.leaf.capt0)
#define _0s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.start))
#define _0e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.end))
    PUSH_KIND(auxil, K_OBJECT);
#undef _0e
#undef _0s
#undef _0
#undef __
#undef auxil
}

static void pcc_action_companionObject_1(pkotlin_context_t *__pcc_ctx, pcc_thunk_t *__pcc_in, pcc_value_t *__pcc_out) {
#define auxil (__pcc_ctx->auxil)
#define __ (*__pcc_out)
#define _0 pcc_get_capture_string(__pcc_ctx, &__pcc_in->data.leaf.capt0)
#define _0s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.start))
#define _0e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.end))
#define _1 pcc_get_capture_string(__pcc_ctx, __pcc_in->data.leaf.capts.buf[0])
#define _1s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[0]->range.start))
#define _1e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[0]->range.end))
    makeKotlinTag(auxil, _1e-_1s != 0 ? _1 : "Companion", _1s, true);
#undef _1e
#undef _1s
#undef _1
#undef _0e
#undef _0s
#undef _0
#undef __
#undef auxil
}

static void pcc_action_companionObject_2(pkotlin_context_t *__pcc_ctx, pcc_thunk_t *__pcc_in, pcc_value_t *__pcc_out) {
#define auxil (__pcc_ctx->auxil)
#define __ (*__pcc_out)
#define _0 pcc_get_capture_string(__pcc_ctx, &__pcc_in->data.leaf.capt0)
#define _0s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.start))
#define _0e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.end))
#define _1 pcc_get_capture_string(__pcc_ctx, __pcc_in->data.leaf.capts.buf[0])
#define _1s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[0]->range.start))
#define _1e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[0]->range.end))
    POP_SCOPE(auxil);
#undef _1e
#undef _1s
#undef _1
#undef _0e
#undef _0s
#undef _0
#undef __
#undef auxil
}

static void pcc_action_functionDeclaration_0(pkotlin_context_t *__pcc_ctx, pcc_thunk_t *__pcc_in, pcc_value_t *__pcc_out) {
#define auxil (__pcc_ctx->auxil)
#define __ (*__pcc_out)
#define _0 pcc_get_capture_string(__pcc_ctx, &__pcc_in->data.leaf.capt0)
#define _0s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.start))
#define _0e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.end))
    PUSH_KIND(auxil, K_METHOD);
#undef _0e
#undef _0s
#undef _0
#undef __
#undef auxil
}

static void pcc_action_functionDeclaration_1(pkotlin_context_t *__pcc_ctx, pcc_thunk_t *__pcc_in, pcc_value_t *__pcc_out) {
#define auxil (__pcc_ctx->auxil)
#define __ (*__pcc_out)
#define _0 pcc_get_capture_string(__pcc_ctx, &__pcc_in->data.leaf.capt0)
#define _0s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.start))
#define _0e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.end))
#define _1 pcc_get_capture_string(__pcc_ctx, __pcc_in->data.leaf.capts.buf[0])
#define _1s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[0]->range.start))
#define _1e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[0]->range.end))
    makeKotlinTag(auxil, _1, _1s, true);
#undef _1e
#undef _1s
#undef _1
#undef _0e
#undef _0s
#undef _0
#undef __
#undef auxil
}

static void pcc_action_functionDeclaration_2(pkotlin_context_t *__pcc_ctx, pcc_thunk_t *__pcc_in, pcc_value_t *__pcc_out) {
#define auxil (__pcc_ctx->auxil)
#define __ (*__pcc_out)
#define _0 pcc_get_capture_string(__pcc_ctx, &__pcc_in->data.leaf.capt0)
#define _0s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.start))
#define _0e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.end))
#define _1 pcc_get_capture_string(__pcc_ctx, __pcc_in->data.leaf.capts.buf[0])
#define _1s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[0]->range.start))
#define _1e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[0]->range.end))
    POP_SCOPE(auxil);
#undef _1e
#undef _1s
#undef _1
#undef _0e
#undef _0s
#undef _0
#undef __
#undef auxil
}

static void pcc_action_variableDeclaration_0(pkotlin_context_t *__pcc_ctx, pcc_thunk_t *__pcc_in, pcc_value_t *__pcc_out) {
#define auxil (__pcc_ctx->auxil)
#define __ (*__pcc_out)
#define _0 pcc_get_capture_string(__pcc_ctx, &__pcc_in->data.leaf.capt0)
#define _0s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.start))
#define _0e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.end))
#define _1 pcc_get_capture_string(__pcc_ctx, __pcc_in->data.leaf.capts.buf[0])
#define _1s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[0]->range.start))
#define _1e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[0]->range.end))
    makeKotlinTag(auxil, _1, _1s, false);
#undef _1e
#undef _1s
#undef _1
#undef _0e
#undef _0s
#undef _0
#undef __
#undef auxil
}

static void pcc_action_propertyDeclaration_0(pkotlin_context_t *__pcc_ctx, pcc_thunk_t *__pcc_in, pcc_value_t *__pcc_out) {
#define auxil (__pcc_ctx->auxil)
#define __ (*__pcc_out)
#define _0 pcc_get_capture_string(__pcc_ctx, &__pcc_in->data.leaf.capt0)
#define _0s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.start))
#define _0e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.end))
    PUSH_KIND(auxil, K_CONSTANT);
#undef _0e
#undef _0s
#undef _0
#undef __
#undef auxil
}

static void pcc_action_propertyDeclaration_1(pkotlin_context_t *__pcc_ctx, pcc_thunk_t *__pcc_in, pcc_value_t *__pcc_out) {
#define auxil (__pcc_ctx->auxil)
#define __ (*__pcc_out)
#define _0 pcc_get_capture_string(__pcc_ctx, &__pcc_in->data.leaf.capt0)
#define _0s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.start))
#define _0e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.end))
    PUSH_KIND(auxil, K_VARIABLE);
#undef _0e
#undef _0s
#undef _0
#undef __
#undef auxil
}

static void pcc_action_objectDeclaration_0(pkotlin_context_t *__pcc_ctx, pcc_thunk_t *__pcc_in, pcc_value_t *__pcc_out) {
#define auxil (__pcc_ctx->auxil)
#define __ (*__pcc_out)
#define _0 pcc_get_capture_string(__pcc_ctx, &__pcc_in->data.leaf.capt0)
#define _0s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.start))
#define _0e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.end))
    PUSH_KIND(auxil, K_OBJECT);
#undef _0e
#undef _0s
#undef _0
#undef __
#undef auxil
}

static void pcc_action_objectDeclaration_1(pkotlin_context_t *__pcc_ctx, pcc_thunk_t *__pcc_in, pcc_value_t *__pcc_out) {
#define auxil (__pcc_ctx->auxil)
#define __ (*__pcc_out)
#define _0 pcc_get_capture_string(__pcc_ctx, &__pcc_in->data.leaf.capt0)
#define _0s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.start))
#define _0e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.end))
#define _1 pcc_get_capture_string(__pcc_ctx, __pcc_in->data.leaf.capts.buf[0])
#define _1s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[0]->range.start))
#define _1e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[0]->range.end))
    makeKotlinTag(auxil, _1, _1s, true);
#undef _1e
#undef _1s
#undef _1
#undef _0e
#undef _0s
#undef _0
#undef __
#undef auxil
}

static void pcc_action_objectDeclaration_2(pkotlin_context_t *__pcc_ctx, pcc_thunk_t *__pcc_in, pcc_value_t *__pcc_out) {
#define auxil (__pcc_ctx->auxil)
#define __ (*__pcc_out)
#define _0 pcc_get_capture_string(__pcc_ctx, &__pcc_in->data.leaf.capt0)
#define _0s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.start))
#define _0e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.end))
#define _1 pcc_get_capture_string(__pcc_ctx, __pcc_in->data.leaf.capts.buf[0])
#define _1s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[0]->range.start))
#define _1e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[0]->range.end))
    POP_SCOPE(auxil);
#undef _1e
#undef _1s
#undef _1
#undef _0e
#undef _0s
#undef _0
#undef __
#undef auxil
}

static void pcc_action_lambdaLiteral_0(pkotlin_context_t *__pcc_ctx, pcc_thunk_t *__pcc_in, pcc_value_t *__pcc_out) {
#define auxil (__pcc_ctx->auxil)
#define __ (*__pcc_out)
#define _0 pcc_get_capture_string(__pcc_ctx, &__pcc_in->data.leaf.capt0)
#define _0s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.start))
#define _0e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.end))
    PUSH_KIND(auxil, K_METHOD); makeKotlinTag(auxil, "<lambda>", _0s, true);
#undef _0e
#undef _0s
#undef _0
#undef __
#undef auxil
}

static void pcc_action_lambdaLiteral_1(pkotlin_context_t *__pcc_ctx, pcc_thunk_t *__pcc_in, pcc_value_t *__pcc_out) {
#define auxil (__pcc_ctx->auxil)
#define __ (*__pcc_out)
#define _0 pcc_get_capture_string(__pcc_ctx, &__pcc_in->data.leaf.capt0)
#define _0s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.start))
#define _0e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.end))
    POP_SCOPE(auxil);
#undef _0e
#undef _0s
#undef _0
#undef __
#undef auxil
}

static void pcc_action_lambdaLiteral_2(pkotlin_context_t *__pcc_ctx, pcc_thunk_t *__pcc_in, pcc_value_t *__pcc_out) {
#define auxil (__pcc_ctx->auxil)
#define __ (*__pcc_out)
#define _0 pcc_get_capture_string(__pcc_ctx, &__pcc_in->data.leaf.capt0)
#define _0s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.start))
#define _0e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.end))
    PUSH_KIND(auxil, K_METHOD); makeKotlinTag(auxil, "<lambda>", 8, true);
#undef _0e
#undef _0s
#undef _0
#undef __
#undef auxil
}

static void pcc_action_lambdaLiteral_3(pkotlin_context_t *__pcc_ctx, pcc_thunk_t *__pcc_in, pcc_value_t *__pcc_out) {
#define auxil (__pcc_ctx->auxil)
#define __ (*__pcc_out)
#define _0 pcc_get_capture_string(__pcc_ctx, &__pcc_in->data.leaf.capt0)
#define _0s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.start))
#define _0e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.end))
    POP_SCOPE(auxil);
#undef _0e
#undef _0s
#undef _0
#undef __
#undef auxil
}

static void pcc_action_anonymousFunction_0(pkotlin_context_t *__pcc_ctx, pcc_thunk_t *__pcc_in, pcc_value_t *__pcc_out) {
#define auxil (__pcc_ctx->auxil)
#define __ (*__pcc_out)
#define _0 pcc_get_capture_string(__pcc_ctx, &__pcc_in->data.leaf.capt0)
#define _0s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.start))
#define _0e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.end))
    PUSH_KIND(auxil, K_METHOD); makeKotlinTag(auxil, "<anonymous>", _0s, true);
#undef _0e
#undef _0s
#undef _0
#undef __
#undef auxil
}

static void pcc_action_anonymousFunction_1(pkotlin_context_t *__pcc_ctx, pcc_thunk_t *__pcc_in, pcc_value_t *__pcc_out) {
#define auxil (__pcc_ctx->auxil)
#define __ (*__pcc_out)
#define _0 pcc_get_capture_string(__pcc_ctx, &__pcc_in->data.leaf.capt0)
#define _0s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.start))
#define _0e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.end))
    POP_SCOPE(auxil);
#undef _0e
#undef _0s
#undef _0
#undef __
#undef auxil
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_file(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_filePart(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_unparsable(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_shebangLine(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_fileAnnotation(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_packageHeader(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_importList(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_importHeader(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_importAlias(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_topLevelObject(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_typeAlias(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_declaration(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_classDeclaration(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_primaryConstructor(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_classBody(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_classParameters(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_classParameter(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_delegationSpecifiers(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_delegationSpecifier(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_constructorInvocation(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_annotatedDelegationSpecifier(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_explicitDelegation(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_typeParameters(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_typeParameter(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_typeConstraints(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_typeConstraint(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_classMemberDeclarations(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_classMemberDeclaration(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_anonymousInitializer(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_companionObject(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_functionValueParameters(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_functionValueParameter(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_functionDeclaration(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_functionBody(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_variableDeclaration(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_multiVariableDeclaration(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_propertyDeclaration(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_propertyDelegate(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_getter(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_setter(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_parametersWithOptionalType(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_parameterWithOptionalType(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_parameter(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_objectDeclaration(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_secondaryConstructor(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_constructorDelegationCall(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_enumClassBody(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_enumEntries(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_enumEntry(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_type(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_typeReference(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_nullableType(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_quest(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_userType(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_simpleUserType(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_typeProjection(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_typeProjectionModifiers(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_typeProjectionModifier(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_functionType(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_functionTypeParameters(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_parenthesizedType(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_receiverType(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_receiverTypeAndDot(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_statements(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_statement(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_label(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_controlStructureBody(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_block(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_loopStatement(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_forStatement(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_whileStatement(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_doWhileStatement(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_assignment(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_semi(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_semis(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_expression(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_disjunction(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_conjunction(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_equality(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_comparison(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_genericCallLikeComparison(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_infixOperation(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_elvisExpression(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_elvis(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_infixFunctionCall(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_rangeExpression(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_additiveExpression(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_multiplicativeExpression(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_asExpression(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_prefixUnaryExpression(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_unaryPrefix(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_postfixUnaryExpression(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_postfixUnarySuffix(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_directlyAssignableExpression(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_parenthesizedDirectlyAssignableExpression(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_assignableExpression(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_parenthesizedAssignableExpression(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_assignableSuffix(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_indexingSuffix(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_navigationSuffix(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_callSuffix(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_annotatedLambda(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_typeArguments(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_valueArguments(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_primaryExpression(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_parenthesizedExpression(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_collectionLiteral(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_literalConstant(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_stringLiteral(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_lineStringLiteral(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_multiLineStringLiteral(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_lineStringContent(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_lineStringExpression(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_multiLineStringContent(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_multiLineStringExpression(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_inside_expression(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_inside_disjunction(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_inside_conjunction(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_inside_equality(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_inside_comparison(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_inside_genericCallLikeComparison(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_inside_infixOperation(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_inside_elvisExpression(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_inside_infixFunctionCall(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_inside_rangeExpression(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_inside_additiveExpression(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_inside_multiplicativeExpression(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_inside_asExpression(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_inside_prefixUnaryExpression(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_inside_unaryPrefix(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_inside_postfixUnaryExpression(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_inside_postfixUnarySuffix(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_inside_directlyAssignableExpression(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_inside_assignableExpression(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_inside_valueArgument(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_lambdaLiteral(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_lambdaParameters(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_lambdaParameter(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_anonymousFunction(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_functionLiteral(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_objectLiteral(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_thisExpression(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_superExpression(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_ifExpression(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_whenSubject(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_whenExpression(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_whenEntry(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_whenCondition(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_rangeTest(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_typeTest(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_tryExpression(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_catchBlock(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_finallyBlock(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_jumpExpression(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_callableReference(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_assignmentAndOperator(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_equalityOperator(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_comparisonOperator(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_inOperator(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_isOperator(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_additiveOperator(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_multiplicativeOperator(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_asOperator(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_prefixUnaryOperator(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_postfixUnaryOperator(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_excl(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_memberAccessOperator(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_safeNav(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_modifiers(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_parameterModifiers(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_modifier(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_typeModifiers(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_typeModifier(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_classModifier(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_memberModifier(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_visibilityModifier(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_varianceModifier(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_typeParameterModifiers(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_typeParameterModifier(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_functionModifier(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_propertyModifier(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_inheritanceModifier(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_parameterModifier(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_reificationModifier(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_platformModifier(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_annotation(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_singleAnnotation(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_multiAnnotation(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_annotationUseSiteTarget(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_unescapedAnnotation(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_simpleIdentifier(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_identifier(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_hardKeyword(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_ShebangLine(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_DelimitedComment(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_LineComment(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_Hidden(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_DOT(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_COMMA(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_LPAREN(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_RPAREN(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_LSQUARE(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_RSQUARE(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_LCURL(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_RCURL(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_MULT(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_MOD(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_DIV(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_ADD(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_SUB(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_INCR(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_DECR(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_CONJ(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_DISJ(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_EXCL_WS(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_EXCL_NO_WS(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_COLON(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_SEMICOLON(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_ASSIGNMENT(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_ADD_ASSIGNMENT(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_SUB_ASSIGNMENT(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_MULT_ASSIGNMENT(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_DIV_ASSIGNMENT(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_MOD_ASSIGNMENT(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_ARROW(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_RANGE(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_RANGE_UNTIL(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_COLONCOLON(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_AT_NO_WS(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_AT_POST_WS(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_AT_PRE_WS(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_QUEST_WS(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_QUEST_NO_WS(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_LANGLE(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_RANGLE(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_LE(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_GE(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_EXCL_EQ(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_EXCL_EQEQ(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_AS_SAFE(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_EQEQ(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_EQEQEQ(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_RETURN_AT(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_CONTINUE_AT(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_BREAK_AT(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_THIS_AT(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_SUPER_AT(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_FILE(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_FIELD(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_PROPERTY(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_GET(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_SET(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_RECEIVER(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_PARAM(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_SETPARAM(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_DELEGATE(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_PACKAGE(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_IMPORT(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_CLASS(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_INTERFACE(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_FUN(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_OBJECT(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_VAL(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_VAR(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_TYPE_ALIAS(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_CONSTRUCTOR(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_BY(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_COMPANION(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_INIT(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_THIS(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_SUPER(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_TYPEOF(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_WHERE(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_IF(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_ELSE(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_WHEN(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_TRY(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_CATCH(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_FINALLY(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_FOR(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_DO(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_WHILE(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_THROW(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_RETURN(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_CONTINUE(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_BREAK(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_AS(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_IS(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_IN(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_NOT_IS(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_NOT_IN(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_OUT(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_DYNAMIC(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_PUBLIC(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_PRIVATE(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_PROTECTED(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_INTERNAL(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_ENUM(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_SEALED(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_ANNOTATION(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_DATA(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_INNER(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_TAILREC(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_OPERATOR(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_INLINE(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_INFIX(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_EXTERNAL(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_SUSPEND(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_OVERRIDE(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_ABSTRACT(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_FINAL(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_OPEN(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_CONST(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_LATEINIT(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_VARARG(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_NOINLINE(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_CROSSINLINE(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_REIFIED(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_EXPECT(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_ACTUAL(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_DecDigit(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_DecDigitNoZero(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_DecDigitOrSeparator(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_DecDigits(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_DoubleExponent(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_RealLiteral(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_FloatLiteral(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_DoubleLiteral(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_IntegerLiteral(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_HexDigit(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_HexDigitOrSeparator(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_HexLiteral(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_BinDigit(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_BinDigitOrSeparator(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_BinLiteral(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_UnsignedLiteral(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_LongLiteral(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_BooleanLiteral(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_NullLiteral(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_CharacterLiteral(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_Identifier(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_IdentifierOrSoftKey(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_FieldIdentifier(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_UniCharacterLiteral(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_EscapedIdentifier(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_EscapeSeq(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_Letter(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_UnicodeDigit(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_QUOTE_OPEN(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_TRIPLE_QUOTE_OPEN(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_QUOTE_CLOSE(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_LineStrRef(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_LineStrText(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_LineStrEscapedChar(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_LineStrExprStart(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_TRIPLE_QUOTE_CLOSE(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_MultiLineStringQuote(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_MultiLineStrRef(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_MultiLineStrText(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_MultiLineStrExprStart(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule__(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule___(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_WS(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_NL(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_EOF(pcc_context_t *ctx);

static pcc_thunk_chunk_t *pcc_evaluate_rule_file(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "file", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_shebangLine, &chunk->thunks, NULL)) goto L0001;
        goto L0002;
    L0001:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0002:;
    }
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_NL, &chunk->thunks, NULL)) goto L0003;
            if (ctx->cur == p) break;
            continue;
        L0003:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_fileAnnotation, &chunk->thunks, NULL)) goto L0004;
            if (ctx->cur == p) break;
            continue;
        L0004:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0005;
            if (ctx->cur == p) break;
            continue;
        L0005:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_packageHeader, &chunk->thunks, NULL)) goto L0006;
            if (ctx->cur == p) break;
            continue;
        L0006:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0007;
            if (ctx->cur == p) break;
            continue;
        L0007:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_importList, &chunk->thunks, NULL)) goto L0008;
            if (ctx->cur == p) break;
            continue;
        L0008:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0009;
            if (ctx->cur == p) break;
            continue;
        L0009:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule_filePart, &chunk->thunks, NULL)) goto L0012;
                goto L0011;
            L0012:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0013;
                goto L0011;
            L0013:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule_unparsable, &chunk->thunks, NULL)) goto L0014;
                goto L0011;
            L0014:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                goto L0010;
            L0011:;
            }
            if (ctx->cur == p) break;
            continue;
        L0010:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_EOF, &chunk->thunks, NULL)) goto L0000;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "file", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "file", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_filePart(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "filePart", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_topLevelObject, &chunk->thunks, NULL)) goto L0002;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_statement, &chunk->thunks, NULL)) goto L0003;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0004;
                if (ctx->cur == p) break;
                continue;
            L0004:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_semi, &chunk->thunks, NULL)) goto L0003;
        goto L0001;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    {
        pcc_thunk_t *const thunk = pcc_thunk__create_leaf(ctx->auxil, pcc_action_filePart_0, 0, 0);
        thunk->data.leaf.capt0.range.start = chunk->pos;
        thunk->data.leaf.capt0.range.end = ctx->cur;
        pcc_thunk_array__add(ctx->auxil, &chunk->thunks, thunk);
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "filePart", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "filePart", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_unparsable(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "unparsable", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p0 = ctx->cur;
        const size_t n0 = chunk->thunks.len;
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            {
                int u;
                const size_t n = pcc_get_char_as_utf32(ctx, &u);
                if (n == 0) goto L0001;
                if (
                    u == 0x00000a
                ) goto L0001;
                ctx->cur += n;
            }
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
        if (i < 1) {
            ctx->cur = p0;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n0);
            goto L0000;
        }
    }
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_NL, &chunk->thunks, NULL)) goto L0002;
            if (ctx->cur == p) break;
            continue;
        L0002:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    {
        pcc_thunk_t *const thunk = pcc_thunk__create_leaf(ctx->auxil, pcc_action_unparsable_0, 0, 0);
        thunk->data.leaf.capt0.range.start = chunk->pos;
        thunk->data.leaf.capt0.range.end = ctx->cur;
        pcc_thunk_array__add(ctx->auxil, &chunk->thunks, thunk);
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "unparsable", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "unparsable", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_shebangLine(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "shebangLine", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_ShebangLine, &chunk->thunks, NULL)) goto L0000;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0001;
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    {
        const size_t p0 = ctx->cur;
        const size_t n0 = chunk->thunks.len;
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_NL, &chunk->thunks, NULL)) goto L0002;
            if (ctx->cur == p) break;
            continue;
        L0002:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
        if (i < 1) {
            ctx->cur = p0;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n0);
            goto L0000;
        }
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "shebangLine", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "shebangLine", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_fileAnnotation(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "fileAnnotation", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_AT_NO_WS, &chunk->thunks, NULL)) goto L0002;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_AT_PRE_WS, &chunk->thunks, NULL)) goto L0003;
        goto L0001;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_FILE, &chunk->thunks, NULL)) goto L0000;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_NL, &chunk->thunks, NULL)) goto L0004;
            if (ctx->cur == p) break;
            continue;
        L0004:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_COLON, &chunk->thunks, NULL)) goto L0000;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0005;
            if (ctx->cur == p) break;
            continue;
        L0005:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_NL, &chunk->thunks, NULL)) goto L0006;
            if (ctx->cur == p) break;
            continue;
        L0006:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_LSQUARE, &chunk->thunks, NULL)) goto L0008;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0009;
                if (ctx->cur == p) break;
                continue;
            L0009:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        {
            const size_t p0 = ctx->cur;
            const size_t n0 = chunk->thunks.len;
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule_unescapedAnnotation, &chunk->thunks, NULL)) goto L0010;
                if (ctx->cur == p) break;
                continue;
            L0010:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
            if (i < 1) {
                ctx->cur = p0;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n0);
                goto L0008;
            }
        }
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0011;
                if (ctx->cur == p) break;
                continue;
            L0011:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_RSQUARE, &chunk->thunks, NULL)) goto L0008;
        goto L0007;
    L0008:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_unescapedAnnotation, &chunk->thunks, NULL)) goto L0012;
        goto L0007;
    L0012:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0007:;
    }
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0013;
            if (ctx->cur == p) break;
            continue;
        L0013:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_NL, &chunk->thunks, NULL)) goto L0014;
            if (ctx->cur == p) break;
            continue;
        L0014:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "fileAnnotation", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "fileAnnotation", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_packageHeader(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "packageHeader", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    pcc_capture_table__resize(ctx->auxil, &chunk->capts, 1);
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_PACKAGE, &chunk->thunks, NULL)) goto L0000;
    {
        pcc_thunk_t *const thunk = pcc_thunk__create_leaf(ctx->auxil, pcc_action_packageHeader_0, 0, 1);
        thunk->data.leaf.capt0.range.start = chunk->pos;
        thunk->data.leaf.capt0.range.end = ctx->cur;
        pcc_thunk_array__add(ctx->auxil, &chunk->thunks, thunk);
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0000;
    {
        const size_t p = ctx->cur;
        size_t q;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_identifier, &chunk->thunks, NULL)) goto L0000;
        q = ctx->cur;
        chunk->capts.buf[0].range.start = p;
        chunk->capts.buf[0].range.end = q;
    }
    {
        pcc_thunk_t *const thunk = pcc_thunk__create_leaf(ctx->auxil, pcc_action_packageHeader_1, 0, 1);
        thunk->data.leaf.capts.buf[0] = &(chunk->capts.buf[0]);
        thunk->data.leaf.capt0.range.start = chunk->pos;
        thunk->data.leaf.capt0.range.end = ctx->cur;
        pcc_thunk_array__add(ctx->auxil, &chunk->thunks, thunk);
    }
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0001;
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_semi, &chunk->thunks, NULL)) goto L0002;
        goto L0003;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0003:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "packageHeader", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "packageHeader", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_importList(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "importList", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p0 = ctx->cur;
        const size_t n0 = chunk->thunks.len;
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_importHeader, &chunk->thunks, NULL)) goto L0001;
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
        if (i < 1) {
            ctx->cur = p0;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n0);
            goto L0000;
        }
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "importList", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "importList", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_importHeader(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "importHeader", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_IMPORT, &chunk->thunks, NULL)) goto L0000;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0000;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_identifier, &chunk->thunks, NULL)) goto L0000;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_DOT, &chunk->thunks, NULL)) goto L0003;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_MULT, &chunk->thunks, NULL)) goto L0003;
            goto L0002;
        L0003:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_importAlias, &chunk->thunks, NULL)) goto L0004;
            goto L0002;
        L0004:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            goto L0001;
        L0002:;
        }
        goto L0005;
    L0001:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0005:;
    }
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0006;
            if (ctx->cur == p) break;
            continue;
        L0006:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_semi, &chunk->thunks, NULL)) goto L0007;
        goto L0008;
    L0007:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0008:;
    }
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0009;
            if (ctx->cur == p) break;
            continue;
        L0009:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "importHeader", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "importHeader", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_importAlias(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "importAlias", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0000;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_AS, &chunk->thunks, NULL)) goto L0000;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0000;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_simpleIdentifier, &chunk->thunks, NULL)) goto L0000;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "importAlias", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "importAlias", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_topLevelObject(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "topLevelObject", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_declaration, &chunk->thunks, NULL)) goto L0000;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0001;
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_semis, &chunk->thunks, NULL)) goto L0002;
        goto L0003;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0003:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "topLevelObject", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "topLevelObject", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_typeAlias(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "typeAlias", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    pcc_capture_table__resize(ctx->auxil, &chunk->capts, 1);
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_modifiers, &chunk->thunks, NULL)) goto L0001;
        goto L0002;
    L0001:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0002:;
    }
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0003;
            if (ctx->cur == p) break;
            continue;
        L0003:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_TYPE_ALIAS, &chunk->thunks, NULL)) goto L0000;
    {
        pcc_thunk_t *const thunk = pcc_thunk__create_leaf(ctx->auxil, pcc_action_typeAlias_0, 0, 1);
        thunk->data.leaf.capt0.range.start = chunk->pos;
        thunk->data.leaf.capt0.range.end = ctx->cur;
        pcc_thunk_array__add(ctx->auxil, &chunk->thunks, thunk);
    }
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0006;
                goto L0005;
            L0006:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule_NL, &chunk->thunks, NULL)) goto L0007;
                goto L0005;
            L0007:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                goto L0004;
            L0005:;
            }
            if (ctx->cur == p) break;
            continue;
        L0004:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    {
        const size_t p = ctx->cur;
        size_t q;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_simpleIdentifier, &chunk->thunks, NULL)) goto L0000;
        q = ctx->cur;
        chunk->capts.buf[0].range.start = p;
        chunk->capts.buf[0].range.end = q;
    }
    {
        pcc_thunk_t *const thunk = pcc_thunk__create_leaf(ctx->auxil, pcc_action_typeAlias_1, 0, 1);
        thunk->data.leaf.capts.buf[0] = &(chunk->capts.buf[0]);
        thunk->data.leaf.capt0.range.start = chunk->pos;
        thunk->data.leaf.capt0.range.end = ctx->cur;
        pcc_thunk_array__add(ctx->auxil, &chunk->thunks, thunk);
    }
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0008;
            if (ctx->cur == p) break;
            continue;
        L0008:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0010;
                if (ctx->cur == p) break;
                continue;
            L0010:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_typeParameters, &chunk->thunks, NULL)) goto L0009;
        goto L0011;
    L0009:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0011:;
    }
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0012;
            if (ctx->cur == p) break;
            continue;
        L0012:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_ASSIGNMENT, &chunk->thunks, NULL)) goto L0000;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0013;
            if (ctx->cur == p) break;
            continue;
        L0013:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_type, &chunk->thunks, NULL)) goto L0000;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "typeAlias", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "typeAlias", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_declaration(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "declaration", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_classDeclaration, &chunk->thunks, NULL)) goto L0002;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_objectDeclaration, &chunk->thunks, NULL)) goto L0003;
        goto L0001;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_functionDeclaration, &chunk->thunks, NULL)) goto L0004;
        goto L0001;
    L0004:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_propertyDeclaration, &chunk->thunks, NULL)) goto L0005;
        goto L0001;
    L0005:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_typeAlias, &chunk->thunks, NULL)) goto L0006;
        goto L0001;
    L0006:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "declaration", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "declaration", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_classDeclaration(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "classDeclaration", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    pcc_capture_table__resize(ctx->auxil, &chunk->capts, 1);
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_modifiers, &chunk->thunks, NULL)) goto L0001;
        goto L0002;
    L0001:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0002:;
    }
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_CLASS, &chunk->thunks, NULL)) goto L0004;
        {
            pcc_thunk_t *const thunk = pcc_thunk__create_leaf(ctx->auxil, pcc_action_classDeclaration_0, 0, 1);
            thunk->data.leaf.capt0.range.start = chunk->pos;
            thunk->data.leaf.capt0.range.end = ctx->cur;
            pcc_thunk_array__add(ctx->auxil, &chunk->thunks, thunk);
        }
        goto L0003;
    L0004:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_FUN, &chunk->thunks, NULL)) goto L0006;
            {
                int i;
                for (i = 0;; i++) {
                    const size_t p = ctx->cur;
                    const size_t n = chunk->thunks.len;
                    if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0007;
                    if (ctx->cur == p) break;
                    continue;
                L0007:;
                    ctx->cur = p;
                    pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                    break;
                }
            }
            goto L0008;
        L0006:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        L0008:;
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_INTERFACE, &chunk->thunks, NULL)) goto L0005;
        {
            pcc_thunk_t *const thunk = pcc_thunk__create_leaf(ctx->auxil, pcc_action_classDeclaration_1, 0, 1);
            thunk->data.leaf.capt0.range.start = chunk->pos;
            thunk->data.leaf.capt0.range.end = ctx->cur;
            pcc_thunk_array__add(ctx->auxil, &chunk->thunks, thunk);
        }
        goto L0003;
    L0005:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0003:;
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0000;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_NL, &chunk->thunks, NULL)) goto L0009;
            if (ctx->cur == p) break;
            continue;
        L0009:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    {
        const size_t p = ctx->cur;
        size_t q;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_simpleIdentifier, &chunk->thunks, NULL)) goto L0000;
        q = ctx->cur;
        chunk->capts.buf[0].range.start = p;
        chunk->capts.buf[0].range.end = q;
    }
    {
        pcc_thunk_t *const thunk = pcc_thunk__create_leaf(ctx->auxil, pcc_action_classDeclaration_2, 0, 1);
        thunk->data.leaf.capts.buf[0] = &(chunk->capts.buf[0]);
        thunk->data.leaf.capt0.range.start = chunk->pos;
        thunk->data.leaf.capt0.range.end = ctx->cur;
        pcc_thunk_array__add(ctx->auxil, &chunk->thunks, thunk);
    }
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0011;
                if (ctx->cur == p) break;
                continue;
            L0011:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_typeParameters, &chunk->thunks, NULL)) goto L0010;
        goto L0012;
    L0010:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0012:;
    }
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0014;
                if (ctx->cur == p) break;
                continue;
            L0014:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_primaryConstructor, &chunk->thunks, NULL)) goto L0013;
        goto L0015;
    L0013:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0015:;
    }
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0017;
                if (ctx->cur == p) break;
                continue;
            L0017:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_COLON, &chunk->thunks, NULL)) goto L0016;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0018;
                if (ctx->cur == p) break;
                continue;
            L0018:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_delegationSpecifiers, &chunk->thunks, NULL)) goto L0016;
        goto L0019;
    L0016:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0019:;
    }
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0021;
                if (ctx->cur == p) break;
                continue;
            L0021:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_typeConstraints, &chunk->thunks, NULL)) goto L0020;
        goto L0022;
    L0020:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0022:;
    }
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            {
                int i;
                for (i = 0;; i++) {
                    const size_t p = ctx->cur;
                    const size_t n = chunk->thunks.len;
                    if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0026;
                    if (ctx->cur == p) break;
                    continue;
                L0026:;
                    ctx->cur = p;
                    pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                    break;
                }
            }
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_classBody, &chunk->thunks, NULL)) goto L0025;
            goto L0024;
        L0025:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            {
                int i;
                for (i = 0;; i++) {
                    const size_t p = ctx->cur;
                    const size_t n = chunk->thunks.len;
                    if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0028;
                    if (ctx->cur == p) break;
                    continue;
                L0028:;
                    ctx->cur = p;
                    pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                    break;
                }
            }
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_enumClassBody, &chunk->thunks, NULL)) goto L0027;
            goto L0024;
        L0027:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            goto L0023;
        L0024:;
        }
        goto L0029;
    L0023:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0029:;
    }
    {
        pcc_thunk_t *const thunk = pcc_thunk__create_leaf(ctx->auxil, pcc_action_classDeclaration_3, 0, 1);
        thunk->data.leaf.capts.buf[0] = &(chunk->capts.buf[0]);
        thunk->data.leaf.capt0.range.start = chunk->pos;
        thunk->data.leaf.capt0.range.end = ctx->cur;
        pcc_thunk_array__add(ctx->auxil, &chunk->thunks, thunk);
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "classDeclaration", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "classDeclaration", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_primaryConstructor(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "primaryConstructor", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_modifiers, &chunk->thunks, NULL)) goto L0002;
            goto L0003;
        L0002:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        L0003:;
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_CONSTRUCTOR, &chunk->thunks, NULL)) goto L0001;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0004;
                if (ctx->cur == p) break;
                continue;
            L0004:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        goto L0005;
    L0001:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0005:;
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_classParameters, &chunk->thunks, NULL)) goto L0000;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "primaryConstructor", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "primaryConstructor", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_classBody(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "classBody", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_LCURL, &chunk->thunks, NULL)) goto L0000;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0001;
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_classMemberDeclarations, &chunk->thunks, NULL)) goto L0000;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0002;
            if (ctx->cur == p) break;
            continue;
        L0002:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_RCURL, &chunk->thunks, NULL)) goto L0000;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "classBody", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "classBody", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_classParameters(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "classParameters", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_LPAREN, &chunk->thunks, NULL)) goto L0000;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0001;
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_classParameter, &chunk->thunks, NULL)) goto L0002;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                {
                    int i;
                    for (i = 0;; i++) {
                        const size_t p = ctx->cur;
                        const size_t n = chunk->thunks.len;
                        if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0004;
                        if (ctx->cur == p) break;
                        continue;
                    L0004:;
                        ctx->cur = p;
                        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                        break;
                    }
                }
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule_COMMA, &chunk->thunks, NULL)) goto L0003;
                {
                    int i;
                    for (i = 0;; i++) {
                        const size_t p = ctx->cur;
                        const size_t n = chunk->thunks.len;
                        if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0005;
                        if (ctx->cur == p) break;
                        continue;
                    L0005:;
                        ctx->cur = p;
                        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                        break;
                    }
                }
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule_classParameter, &chunk->thunks, NULL)) goto L0003;
                if (ctx->cur == p) break;
                continue;
            L0003:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            {
                int i;
                for (i = 0;; i++) {
                    const size_t p = ctx->cur;
                    const size_t n = chunk->thunks.len;
                    if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0007;
                    if (ctx->cur == p) break;
                    continue;
                L0007:;
                    ctx->cur = p;
                    pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                    break;
                }
            }
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_COMMA, &chunk->thunks, NULL)) goto L0006;
            goto L0008;
        L0006:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        L0008:;
        }
        goto L0009;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0009:;
    }
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0010;
            if (ctx->cur == p) break;
            continue;
        L0010:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_RPAREN, &chunk->thunks, NULL)) goto L0000;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "classParameters", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "classParameters", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_classParameter(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "classParameter", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    pcc_capture_table__resize(ctx->auxil, &chunk->capts, 1);
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule_modifiers, &chunk->thunks, NULL)) goto L0004;
                goto L0005;
            L0004:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            L0005:;
            }
            {
                int i;
                for (i = 0;; i++) {
                    const size_t p = ctx->cur;
                    const size_t n = chunk->thunks.len;
                    if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0006;
                    if (ctx->cur == p) break;
                    continue;
                L0006:;
                    ctx->cur = p;
                    pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                    break;
                }
            }
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_VAL, &chunk->thunks, NULL)) goto L0003;
            {
                pcc_thunk_t *const thunk = pcc_thunk__create_leaf(ctx->auxil, pcc_action_classParameter_0, 0, 1);
                thunk->data.leaf.capt0.range.start = chunk->pos;
                thunk->data.leaf.capt0.range.end = ctx->cur;
                pcc_thunk_array__add(ctx->auxil, &chunk->thunks, thunk);
            }
            goto L0002;
        L0003:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule_modifiers, &chunk->thunks, NULL)) goto L0008;
                goto L0009;
            L0008:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            L0009:;
            }
            {
                int i;
                for (i = 0;; i++) {
                    const size_t p = ctx->cur;
                    const size_t n = chunk->thunks.len;
                    if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0010;
                    if (ctx->cur == p) break;
                    continue;
                L0010:;
                    ctx->cur = p;
                    pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                    break;
                }
            }
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_VAR, &chunk->thunks, NULL)) goto L0007;
            {
                pcc_thunk_t *const thunk = pcc_thunk__create_leaf(ctx->auxil, pcc_action_classParameter_1, 0, 1);
                thunk->data.leaf.capt0.range.start = chunk->pos;
                thunk->data.leaf.capt0.range.end = ctx->cur;
                pcc_thunk_array__add(ctx->auxil, &chunk->thunks, thunk);
            }
            goto L0002;
        L0007:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule_modifiers, &chunk->thunks, NULL)) goto L0012;
                goto L0013;
            L0012:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            L0013:;
            }
            {
                pcc_thunk_t *const thunk = pcc_thunk__create_leaf(ctx->auxil, pcc_action_classParameter_2, 0, 1);
                thunk->data.leaf.capt0.range.start = chunk->pos;
                thunk->data.leaf.capt0.range.end = ctx->cur;
                pcc_thunk_array__add(ctx->auxil, &chunk->thunks, thunk);
            }
            {
                int i;
                for (i = 0;; i++) {
                    const size_t p = ctx->cur;
                    const size_t n = chunk->thunks.len;
                    if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0014;
                    if (ctx->cur == p) break;
                    continue;
                L0014:;
                    ctx->cur = p;
                    pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                    break;
                }
            }
        L0002:;
        }
    }
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0015;
            if (ctx->cur == p) break;
            continue;
        L0015:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    {
        const size_t p = ctx->cur;
        size_t q;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_simpleIdentifier, &chunk->thunks, NULL)) goto L0000;
        q = ctx->cur;
        chunk->capts.buf[0].range.start = p;
        chunk->capts.buf[0].range.end = q;
    }
    {
        pcc_thunk_t *const thunk = pcc_thunk__create_leaf(ctx->auxil, pcc_action_classParameter_3, 0, 1);
        thunk->data.leaf.capts.buf[0] = &(chunk->capts.buf[0]);
        thunk->data.leaf.capt0.range.start = chunk->pos;
        thunk->data.leaf.capt0.range.end = ctx->cur;
        pcc_thunk_array__add(ctx->auxil, &chunk->thunks, thunk);
    }
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0016;
            if (ctx->cur == p) break;
            continue;
        L0016:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_COLON, &chunk->thunks, NULL)) goto L0000;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0017;
            if (ctx->cur == p) break;
            continue;
        L0017:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_type, &chunk->thunks, NULL)) goto L0000;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0019;
                if (ctx->cur == p) break;
                continue;
            L0019:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_ASSIGNMENT, &chunk->thunks, NULL)) goto L0018;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0020;
                if (ctx->cur == p) break;
                continue;
            L0020:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_expression, &chunk->thunks, NULL)) goto L0018;
        goto L0021;
    L0018:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0021:;
    }
    {
        pcc_thunk_t *const thunk = pcc_thunk__create_leaf(ctx->auxil, pcc_action_classParameter_4, 0, 1);
        thunk->data.leaf.capts.buf[0] = &(chunk->capts.buf[0]);
        thunk->data.leaf.capt0.range.start = chunk->pos;
        thunk->data.leaf.capt0.range.end = ctx->cur;
        pcc_thunk_array__add(ctx->auxil, &chunk->thunks, thunk);
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "classParameter", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "classParameter", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_delegationSpecifiers(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "delegationSpecifiers", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_annotatedDelegationSpecifier, &chunk->thunks, NULL)) goto L0000;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            {
                int i;
                for (i = 0;; i++) {
                    const size_t p = ctx->cur;
                    const size_t n = chunk->thunks.len;
                    if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0002;
                    if (ctx->cur == p) break;
                    continue;
                L0002:;
                    ctx->cur = p;
                    pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                    break;
                }
            }
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_COMMA, &chunk->thunks, NULL)) goto L0001;
            {
                int i;
                for (i = 0;; i++) {
                    const size_t p = ctx->cur;
                    const size_t n = chunk->thunks.len;
                    if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0003;
                    if (ctx->cur == p) break;
                    continue;
                L0003:;
                    ctx->cur = p;
                    pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                    break;
                }
            }
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_annotatedDelegationSpecifier, &chunk->thunks, NULL)) goto L0001;
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "delegationSpecifiers", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "delegationSpecifiers", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_delegationSpecifier(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "delegationSpecifier", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_constructorInvocation, &chunk->thunks, NULL)) goto L0002;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_explicitDelegation, &chunk->thunks, NULL)) goto L0003;
        goto L0001;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_userType, &chunk->thunks, NULL)) goto L0004;
        goto L0001;
    L0004:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_functionType, &chunk->thunks, NULL)) goto L0005;
        goto L0001;
    L0005:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "delegationSpecifier", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "delegationSpecifier", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_constructorInvocation(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "constructorInvocation", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_userType, &chunk->thunks, NULL)) goto L0000;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0001;
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_valueArguments, &chunk->thunks, NULL)) goto L0000;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "constructorInvocation", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "constructorInvocation", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_annotatedDelegationSpecifier(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "annotatedDelegationSpecifier", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_annotation, &chunk->thunks, NULL)) goto L0001;
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0002;
            if (ctx->cur == p) break;
            continue;
        L0002:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_delegationSpecifier, &chunk->thunks, NULL)) goto L0000;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "annotatedDelegationSpecifier", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "annotatedDelegationSpecifier", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_explicitDelegation(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "explicitDelegation", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_userType, &chunk->thunks, NULL)) goto L0002;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_functionType, &chunk->thunks, NULL)) goto L0003;
        goto L0001;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0004;
            if (ctx->cur == p) break;
            continue;
        L0004:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_BY, &chunk->thunks, NULL)) goto L0000;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0005;
            if (ctx->cur == p) break;
            continue;
        L0005:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_expression, &chunk->thunks, NULL)) goto L0000;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "explicitDelegation", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "explicitDelegation", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_typeParameters(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "typeParameters", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_LANGLE, &chunk->thunks, NULL)) goto L0000;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0001;
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_typeParameter, &chunk->thunks, NULL)) goto L0000;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            {
                int i;
                for (i = 0;; i++) {
                    const size_t p = ctx->cur;
                    const size_t n = chunk->thunks.len;
                    if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0003;
                    if (ctx->cur == p) break;
                    continue;
                L0003:;
                    ctx->cur = p;
                    pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                    break;
                }
            }
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_COMMA, &chunk->thunks, NULL)) goto L0002;
            {
                int i;
                for (i = 0;; i++) {
                    const size_t p = ctx->cur;
                    const size_t n = chunk->thunks.len;
                    if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0004;
                    if (ctx->cur == p) break;
                    continue;
                L0004:;
                    ctx->cur = p;
                    pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                    break;
                }
            }
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_typeParameter, &chunk->thunks, NULL)) goto L0002;
            if (ctx->cur == p) break;
            continue;
        L0002:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0006;
                if (ctx->cur == p) break;
                continue;
            L0006:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_COMMA, &chunk->thunks, NULL)) goto L0005;
        goto L0007;
    L0005:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0007:;
    }
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0008;
            if (ctx->cur == p) break;
            continue;
        L0008:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_RANGLE, &chunk->thunks, NULL)) goto L0000;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "typeParameters", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "typeParameters", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_typeParameter(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "typeParameter", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_typeParameterModifiers, &chunk->thunks, NULL)) goto L0001;
        goto L0002;
    L0001:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0002:;
    }
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0003;
            if (ctx->cur == p) break;
            continue;
        L0003:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_simpleIdentifier, &chunk->thunks, NULL)) goto L0000;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0005;
                if (ctx->cur == p) break;
                continue;
            L0005:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_COLON, &chunk->thunks, NULL)) goto L0004;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0006;
                if (ctx->cur == p) break;
                continue;
            L0006:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_type, &chunk->thunks, NULL)) goto L0004;
        goto L0007;
    L0004:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0007:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "typeParameter", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "typeParameter", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_typeConstraints(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "typeConstraints", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_WHERE, &chunk->thunks, NULL)) goto L0000;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0001;
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_typeConstraint, &chunk->thunks, NULL)) goto L0000;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            {
                int i;
                for (i = 0;; i++) {
                    const size_t p = ctx->cur;
                    const size_t n = chunk->thunks.len;
                    if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0003;
                    if (ctx->cur == p) break;
                    continue;
                L0003:;
                    ctx->cur = p;
                    pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                    break;
                }
            }
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_COMMA, &chunk->thunks, NULL)) goto L0002;
            {
                int i;
                for (i = 0;; i++) {
                    const size_t p = ctx->cur;
                    const size_t n = chunk->thunks.len;
                    if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0004;
                    if (ctx->cur == p) break;
                    continue;
                L0004:;
                    ctx->cur = p;
                    pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                    break;
                }
            }
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_typeConstraint, &chunk->thunks, NULL)) goto L0002;
            if (ctx->cur == p) break;
            continue;
        L0002:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "typeConstraints", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "typeConstraints", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_typeConstraint(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "typeConstraint", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_annotation, &chunk->thunks, NULL)) goto L0001;
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_simpleIdentifier, &chunk->thunks, NULL)) goto L0000;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0002;
            if (ctx->cur == p) break;
            continue;
        L0002:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_COLON, &chunk->thunks, NULL)) goto L0000;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0003;
            if (ctx->cur == p) break;
            continue;
        L0003:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_type, &chunk->thunks, NULL)) goto L0000;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "typeConstraint", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "typeConstraint", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_classMemberDeclarations(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "classMemberDeclarations", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_classMemberDeclaration, &chunk->thunks, NULL)) goto L0001;
            {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule_semis, &chunk->thunks, NULL)) goto L0002;
                goto L0003;
            L0002:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            L0003:;
            }
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "classMemberDeclarations", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_classMemberDeclaration(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "classMemberDeclaration", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_secondaryConstructor, &chunk->thunks, NULL)) goto L0002;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_anonymousInitializer, &chunk->thunks, NULL)) goto L0003;
        goto L0001;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_companionObject, &chunk->thunks, NULL)) goto L0004;
        goto L0001;
    L0004:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_declaration, &chunk->thunks, NULL)) goto L0005;
        goto L0001;
    L0005:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "classMemberDeclaration", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "classMemberDeclaration", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_anonymousInitializer(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "anonymousInitializer", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_INIT, &chunk->thunks, NULL)) goto L0000;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0001;
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_block, &chunk->thunks, NULL)) goto L0000;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "anonymousInitializer", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "anonymousInitializer", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_companionObject(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "companionObject", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    pcc_capture_table__resize(ctx->auxil, &chunk->capts, 1);
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_modifiers, &chunk->thunks, NULL)) goto L0001;
        goto L0002;
    L0001:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0002:;
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_COMPANION, &chunk->thunks, NULL)) goto L0000;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0003;
            if (ctx->cur == p) break;
            continue;
        L0003:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_DATA, &chunk->thunks, NULL)) goto L0004;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0005;
                if (ctx->cur == p) break;
                continue;
            L0005:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        goto L0006;
    L0004:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0006:;
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_OBJECT, &chunk->thunks, NULL)) goto L0000;
    {
        pcc_thunk_t *const thunk = pcc_thunk__create_leaf(ctx->auxil, pcc_action_companionObject_0, 0, 1);
        thunk->data.leaf.capt0.range.start = chunk->pos;
        thunk->data.leaf.capt0.range.end = ctx->cur;
        pcc_thunk_array__add(ctx->auxil, &chunk->thunks, thunk);
    }
    {
        const size_t p = ctx->cur;
        size_t q;
        {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            {
                int i;
                for (i = 0;; i++) {
                    const size_t p = ctx->cur;
                    const size_t n = chunk->thunks.len;
                    if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0008;
                    if (ctx->cur == p) break;
                    continue;
                L0008:;
                    ctx->cur = p;
                    pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                    break;
                }
            }
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_simpleIdentifier, &chunk->thunks, NULL)) goto L0007;
            goto L0009;
        L0007:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        L0009:;
        }
        q = ctx->cur;
        chunk->capts.buf[0].range.start = p;
        chunk->capts.buf[0].range.end = q;
    }
    {
        pcc_thunk_t *const thunk = pcc_thunk__create_leaf(ctx->auxil, pcc_action_companionObject_1, 0, 1);
        thunk->data.leaf.capts.buf[0] = &(chunk->capts.buf[0]);
        thunk->data.leaf.capt0.range.start = chunk->pos;
        thunk->data.leaf.capt0.range.end = ctx->cur;
        pcc_thunk_array__add(ctx->auxil, &chunk->thunks, thunk);
    }
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0011;
                if (ctx->cur == p) break;
                continue;
            L0011:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_COLON, &chunk->thunks, NULL)) goto L0010;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0012;
                if (ctx->cur == p) break;
                continue;
            L0012:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_delegationSpecifiers, &chunk->thunks, NULL)) goto L0010;
        goto L0013;
    L0010:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0013:;
    }
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0015;
                if (ctx->cur == p) break;
                continue;
            L0015:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_classBody, &chunk->thunks, NULL)) goto L0014;
        goto L0016;
    L0014:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0016:;
    }
    {
        pcc_thunk_t *const thunk = pcc_thunk__create_leaf(ctx->auxil, pcc_action_companionObject_2, 0, 1);
        thunk->data.leaf.capts.buf[0] = &(chunk->capts.buf[0]);
        thunk->data.leaf.capt0.range.start = chunk->pos;
        thunk->data.leaf.capt0.range.end = ctx->cur;
        pcc_thunk_array__add(ctx->auxil, &chunk->thunks, thunk);
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "companionObject", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "companionObject", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_functionValueParameters(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "functionValueParameters", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_LPAREN, &chunk->thunks, NULL)) goto L0000;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0001;
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_functionValueParameter, &chunk->thunks, NULL)) goto L0002;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                {
                    int i;
                    for (i = 0;; i++) {
                        const size_t p = ctx->cur;
                        const size_t n = chunk->thunks.len;
                        if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0004;
                        if (ctx->cur == p) break;
                        continue;
                    L0004:;
                        ctx->cur = p;
                        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                        break;
                    }
                }
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule_COMMA, &chunk->thunks, NULL)) goto L0003;
                {
                    int i;
                    for (i = 0;; i++) {
                        const size_t p = ctx->cur;
                        const size_t n = chunk->thunks.len;
                        if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0005;
                        if (ctx->cur == p) break;
                        continue;
                    L0005:;
                        ctx->cur = p;
                        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                        break;
                    }
                }
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule_functionValueParameter, &chunk->thunks, NULL)) goto L0003;
                if (ctx->cur == p) break;
                continue;
            L0003:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            {
                int i;
                for (i = 0;; i++) {
                    const size_t p = ctx->cur;
                    const size_t n = chunk->thunks.len;
                    if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0007;
                    if (ctx->cur == p) break;
                    continue;
                L0007:;
                    ctx->cur = p;
                    pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                    break;
                }
            }
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_COMMA, &chunk->thunks, NULL)) goto L0006;
            goto L0008;
        L0006:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        L0008:;
        }
        goto L0009;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0009:;
    }
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0010;
            if (ctx->cur == p) break;
            continue;
        L0010:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_RPAREN, &chunk->thunks, NULL)) goto L0000;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "functionValueParameters", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "functionValueParameters", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_functionValueParameter(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "functionValueParameter", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_parameterModifiers, &chunk->thunks, NULL)) goto L0001;
        goto L0002;
    L0001:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0002:;
    }
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0003;
            if (ctx->cur == p) break;
            continue;
        L0003:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_parameter, &chunk->thunks, NULL)) goto L0000;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0005;
                if (ctx->cur == p) break;
                continue;
            L0005:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_ASSIGNMENT, &chunk->thunks, NULL)) goto L0004;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0006;
                if (ctx->cur == p) break;
                continue;
            L0006:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_expression, &chunk->thunks, NULL)) goto L0004;
        goto L0007;
    L0004:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0007:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "functionValueParameter", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "functionValueParameter", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_functionDeclaration(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "functionDeclaration", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    pcc_capture_table__resize(ctx->auxil, &chunk->capts, 1);
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_modifiers, &chunk->thunks, NULL)) goto L0001;
        goto L0002;
    L0001:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0002:;
    }
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0003;
            if (ctx->cur == p) break;
            continue;
        L0003:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_FUN, &chunk->thunks, NULL)) goto L0000;
    {
        pcc_thunk_t *const thunk = pcc_thunk__create_leaf(ctx->auxil, pcc_action_functionDeclaration_0, 0, 1);
        thunk->data.leaf.capt0.range.start = chunk->pos;
        thunk->data.leaf.capt0.range.end = ctx->cur;
        pcc_thunk_array__add(ctx->auxil, &chunk->thunks, thunk);
    }
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0004;
            if (ctx->cur == p) break;
            continue;
        L0004:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0006;
                if (ctx->cur == p) break;
                continue;
            L0006:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_typeParameters, &chunk->thunks, NULL)) goto L0005;
        goto L0007;
    L0005:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0007:;
    }
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0008;
            if (ctx->cur == p) break;
            continue;
        L0008:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0010;
                if (ctx->cur == p) break;
                continue;
            L0010:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_receiverTypeAndDot, &chunk->thunks, NULL)) goto L0009;
        goto L0011;
    L0009:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0011:;
    }
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0012;
            if (ctx->cur == p) break;
            continue;
        L0012:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    {
        const size_t p = ctx->cur;
        size_t q;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_simpleIdentifier, &chunk->thunks, NULL)) goto L0000;
        q = ctx->cur;
        chunk->capts.buf[0].range.start = p;
        chunk->capts.buf[0].range.end = q;
    }
    {
        pcc_thunk_t *const thunk = pcc_thunk__create_leaf(ctx->auxil, pcc_action_functionDeclaration_1, 0, 1);
        thunk->data.leaf.capts.buf[0] = &(chunk->capts.buf[0]);
        thunk->data.leaf.capt0.range.start = chunk->pos;
        thunk->data.leaf.capt0.range.end = ctx->cur;
        pcc_thunk_array__add(ctx->auxil, &chunk->thunks, thunk);
    }
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0013;
            if (ctx->cur == p) break;
            continue;
        L0013:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_functionValueParameters, &chunk->thunks, NULL)) goto L0000;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0014;
            if (ctx->cur == p) break;
            continue;
        L0014:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0016;
                if (ctx->cur == p) break;
                continue;
            L0016:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_COLON, &chunk->thunks, NULL)) goto L0015;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0017;
                if (ctx->cur == p) break;
                continue;
            L0017:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_type, &chunk->thunks, NULL)) goto L0015;
        goto L0018;
    L0015:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0018:;
    }
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0019;
            if (ctx->cur == p) break;
            continue;
        L0019:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0021;
                if (ctx->cur == p) break;
                continue;
            L0021:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_typeConstraints, &chunk->thunks, NULL)) goto L0020;
        goto L0022;
    L0020:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0022:;
    }
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0023;
            if (ctx->cur == p) break;
            continue;
        L0023:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0025;
                if (ctx->cur == p) break;
                continue;
            L0025:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_functionBody, &chunk->thunks, NULL)) goto L0024;
        goto L0026;
    L0024:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0026:;
    }
    {
        pcc_thunk_t *const thunk = pcc_thunk__create_leaf(ctx->auxil, pcc_action_functionDeclaration_2, 0, 1);
        thunk->data.leaf.capts.buf[0] = &(chunk->capts.buf[0]);
        thunk->data.leaf.capt0.range.start = chunk->pos;
        thunk->data.leaf.capt0.range.end = ctx->cur;
        pcc_thunk_array__add(ctx->auxil, &chunk->thunks, thunk);
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "functionDeclaration", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "functionDeclaration", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_functionBody(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "functionBody", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_block, &chunk->thunks, NULL)) goto L0002;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_ASSIGNMENT, &chunk->thunks, NULL)) goto L0003;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0004;
                if (ctx->cur == p) break;
                continue;
            L0004:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_expression, &chunk->thunks, NULL)) goto L0003;
        goto L0001;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "functionBody", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "functionBody", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_variableDeclaration(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "variableDeclaration", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    pcc_capture_table__resize(ctx->auxil, &chunk->capts, 1);
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_annotation, &chunk->thunks, NULL)) goto L0001;
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0002;
            if (ctx->cur == p) break;
            continue;
        L0002:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    {
        const size_t p = ctx->cur;
        size_t q;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_simpleIdentifier, &chunk->thunks, NULL)) goto L0000;
        q = ctx->cur;
        chunk->capts.buf[0].range.start = p;
        chunk->capts.buf[0].range.end = q;
    }
    {
        pcc_thunk_t *const thunk = pcc_thunk__create_leaf(ctx->auxil, pcc_action_variableDeclaration_0, 0, 1);
        thunk->data.leaf.capts.buf[0] = &(chunk->capts.buf[0]);
        thunk->data.leaf.capt0.range.start = chunk->pos;
        thunk->data.leaf.capt0.range.end = ctx->cur;
        pcc_thunk_array__add(ctx->auxil, &chunk->thunks, thunk);
    }
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0004;
                if (ctx->cur == p) break;
                continue;
            L0004:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_COLON, &chunk->thunks, NULL)) goto L0003;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0005;
                if (ctx->cur == p) break;
                continue;
            L0005:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_type, &chunk->thunks, NULL)) goto L0003;
        goto L0006;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0006:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "variableDeclaration", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "variableDeclaration", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_multiVariableDeclaration(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "multiVariableDeclaration", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_LPAREN, &chunk->thunks, NULL)) goto L0000;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0001;
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_variableDeclaration, &chunk->thunks, NULL)) goto L0000;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0002;
            if (ctx->cur == p) break;
            continue;
        L0002:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            {
                int i;
                for (i = 0;; i++) {
                    const size_t p = ctx->cur;
                    const size_t n = chunk->thunks.len;
                    if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0004;
                    if (ctx->cur == p) break;
                    continue;
                L0004:;
                    ctx->cur = p;
                    pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                    break;
                }
            }
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_COMMA, &chunk->thunks, NULL)) goto L0003;
            {
                int i;
                for (i = 0;; i++) {
                    const size_t p = ctx->cur;
                    const size_t n = chunk->thunks.len;
                    if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0005;
                    if (ctx->cur == p) break;
                    continue;
                L0005:;
                    ctx->cur = p;
                    pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                    break;
                }
            }
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_variableDeclaration, &chunk->thunks, NULL)) goto L0003;
            if (ctx->cur == p) break;
            continue;
        L0003:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0006;
            if (ctx->cur == p) break;
            continue;
        L0006:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0008;
                if (ctx->cur == p) break;
                continue;
            L0008:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_COMMA, &chunk->thunks, NULL)) goto L0007;
        goto L0009;
    L0007:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0009:;
    }
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0010;
            if (ctx->cur == p) break;
            continue;
        L0010:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_RPAREN, &chunk->thunks, NULL)) goto L0000;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "multiVariableDeclaration", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "multiVariableDeclaration", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_propertyDeclaration(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "propertyDeclaration", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_modifiers, &chunk->thunks, NULL)) goto L0001;
        goto L0002;
    L0001:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0002:;
    }
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0003;
            if (ctx->cur == p) break;
            continue;
        L0003:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_VAL, &chunk->thunks, NULL)) goto L0005;
        {
            pcc_thunk_t *const thunk = pcc_thunk__create_leaf(ctx->auxil, pcc_action_propertyDeclaration_0, 0, 0);
            thunk->data.leaf.capt0.range.start = chunk->pos;
            thunk->data.leaf.capt0.range.end = ctx->cur;
            pcc_thunk_array__add(ctx->auxil, &chunk->thunks, thunk);
        }
        goto L0004;
    L0005:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_VAR, &chunk->thunks, NULL)) goto L0006;
        {
            pcc_thunk_t *const thunk = pcc_thunk__create_leaf(ctx->auxil, pcc_action_propertyDeclaration_1, 0, 0);
            thunk->data.leaf.capt0.range.start = chunk->pos;
            thunk->data.leaf.capt0.range.end = ctx->cur;
            pcc_thunk_array__add(ctx->auxil, &chunk->thunks, thunk);
        }
        goto L0004;
    L0006:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0004:;
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0000;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0008;
                if (ctx->cur == p) break;
                continue;
            L0008:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_typeParameters, &chunk->thunks, NULL)) goto L0007;
        goto L0009;
    L0007:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0009:;
    }
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0011;
                if (ctx->cur == p) break;
                continue;
            L0011:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_receiverTypeAndDot, &chunk->thunks, NULL)) goto L0010;
        goto L0012;
    L0010:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0012:;
    }
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0013;
            if (ctx->cur == p) break;
            continue;
        L0013:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_multiVariableDeclaration, &chunk->thunks, NULL)) goto L0015;
        goto L0014;
    L0015:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_variableDeclaration, &chunk->thunks, NULL)) goto L0016;
        goto L0014;
    L0016:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0014:;
    }
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0018;
                if (ctx->cur == p) break;
                continue;
            L0018:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_typeConstraints, &chunk->thunks, NULL)) goto L0017;
        goto L0019;
    L0017:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0019:;
    }
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0021;
                if (ctx->cur == p) break;
                continue;
            L0021:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_ASSIGNMENT, &chunk->thunks, NULL)) goto L0023;
            {
                int i;
                for (i = 0;; i++) {
                    const size_t p = ctx->cur;
                    const size_t n = chunk->thunks.len;
                    if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0024;
                    if (ctx->cur == p) break;
                    continue;
                L0024:;
                    ctx->cur = p;
                    pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                    break;
                }
            }
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_expression, &chunk->thunks, NULL)) goto L0023;
            goto L0022;
        L0023:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_propertyDelegate, &chunk->thunks, NULL)) goto L0025;
            goto L0022;
        L0025:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            goto L0020;
        L0022:;
        }
        goto L0026;
    L0020:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0026:;
    }
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule_semi, &chunk->thunks, NULL)) goto L0030;
                goto L0031;
            L0030:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            L0031:;
            }
            {
                int i;
                for (i = 0;; i++) {
                    const size_t p = ctx->cur;
                    const size_t n = chunk->thunks.len;
                    if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0032;
                    if (ctx->cur == p) break;
                    continue;
                L0032:;
                    ctx->cur = p;
                    pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                    break;
                }
            }
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_setter, &chunk->thunks, NULL)) goto L0029;
            {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                {
                    int i;
                    for (i = 0;; i++) {
                        const size_t p = ctx->cur;
                        const size_t n = chunk->thunks.len;
                        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_NL, &chunk->thunks, NULL)) goto L0034;
                        if (ctx->cur == p) break;
                        continue;
                    L0034:;
                        ctx->cur = p;
                        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                        break;
                    }
                }
                {
                    const size_t p = ctx->cur;
                    const size_t n = chunk->thunks.len;
                    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_semi, &chunk->thunks, NULL)) goto L0035;
                    goto L0036;
                L0035:;
                    ctx->cur = p;
                    pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                L0036:;
                }
                {
                    int i;
                    for (i = 0;; i++) {
                        const size_t p = ctx->cur;
                        const size_t n = chunk->thunks.len;
                        if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0037;
                        if (ctx->cur == p) break;
                        continue;
                    L0037:;
                        ctx->cur = p;
                        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                        break;
                    }
                }
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule_getter, &chunk->thunks, NULL)) goto L0033;
                goto L0038;
            L0033:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            L0038:;
            }
            goto L0028;
        L0029:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule_semi, &chunk->thunks, NULL)) goto L0040;
                goto L0041;
            L0040:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            L0041:;
            }
            {
                int i;
                for (i = 0;; i++) {
                    const size_t p = ctx->cur;
                    const size_t n = chunk->thunks.len;
                    if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0042;
                    if (ctx->cur == p) break;
                    continue;
                L0042:;
                    ctx->cur = p;
                    pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                    break;
                }
            }
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_getter, &chunk->thunks, NULL)) goto L0039;
            {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                {
                    int i;
                    for (i = 0;; i++) {
                        const size_t p = ctx->cur;
                        const size_t n = chunk->thunks.len;
                        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_NL, &chunk->thunks, NULL)) goto L0044;
                        if (ctx->cur == p) break;
                        continue;
                    L0044:;
                        ctx->cur = p;
                        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                        break;
                    }
                }
                {
                    const size_t p = ctx->cur;
                    const size_t n = chunk->thunks.len;
                    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_semi, &chunk->thunks, NULL)) goto L0045;
                    goto L0046;
                L0045:;
                    ctx->cur = p;
                    pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                L0046:;
                }
                {
                    int i;
                    for (i = 0;; i++) {
                        const size_t p = ctx->cur;
                        const size_t n = chunk->thunks.len;
                        if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0047;
                        if (ctx->cur == p) break;
                        continue;
                    L0047:;
                        ctx->cur = p;
                        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                        break;
                    }
                }
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule_setter, &chunk->thunks, NULL)) goto L0043;
                goto L0048;
            L0043:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            L0048:;
            }
            goto L0028;
        L0039:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            goto L0027;
        L0028:;
        }
        goto L0049;
    L0027:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0049:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "propertyDeclaration", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "propertyDeclaration", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_propertyDelegate(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "propertyDelegate", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_BY, &chunk->thunks, NULL)) goto L0000;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0001;
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_expression, &chunk->thunks, NULL)) goto L0000;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "propertyDelegate", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "propertyDelegate", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_getter(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "getter", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_modifiers, &chunk->thunks, NULL)) goto L0003;
            {
                int i;
                for (i = 0;; i++) {
                    const size_t p = ctx->cur;
                    const size_t n = chunk->thunks.len;
                    if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0004;
                    if (ctx->cur == p) break;
                    continue;
                L0004:;
                    ctx->cur = p;
                    pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                    break;
                }
            }
            goto L0005;
        L0003:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        L0005:;
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_GET, &chunk->thunks, NULL)) goto L0002;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0006;
                if (ctx->cur == p) break;
                continue;
            L0006:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_LPAREN, &chunk->thunks, NULL)) goto L0002;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0007;
                if (ctx->cur == p) break;
                continue;
            L0007:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_RPAREN, &chunk->thunks, NULL)) goto L0002;
        {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            {
                int i;
                for (i = 0;; i++) {
                    const size_t p = ctx->cur;
                    const size_t n = chunk->thunks.len;
                    if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0009;
                    if (ctx->cur == p) break;
                    continue;
                L0009:;
                    ctx->cur = p;
                    pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                    break;
                }
            }
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_COLON, &chunk->thunks, NULL)) goto L0008;
            {
                int i;
                for (i = 0;; i++) {
                    const size_t p = ctx->cur;
                    const size_t n = chunk->thunks.len;
                    if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0010;
                    if (ctx->cur == p) break;
                    continue;
                L0010:;
                    ctx->cur = p;
                    pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                    break;
                }
            }
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_type, &chunk->thunks, NULL)) goto L0008;
            goto L0011;
        L0008:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        L0011:;
        }
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0012;
                if (ctx->cur == p) break;
                continue;
            L0012:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_functionBody, &chunk->thunks, NULL)) goto L0002;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_modifiers, &chunk->thunks, NULL)) goto L0014;
            {
                int i;
                for (i = 0;; i++) {
                    const size_t p = ctx->cur;
                    const size_t n = chunk->thunks.len;
                    if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0015;
                    if (ctx->cur == p) break;
                    continue;
                L0015:;
                    ctx->cur = p;
                    pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                    break;
                }
            }
            goto L0016;
        L0014:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        L0016:;
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_GET, &chunk->thunks, NULL)) goto L0013;
        {
            const size_t p = ctx->cur;
            {
                int i;
                for (i = 0;; i++) {
                    const size_t p = ctx->cur;
                    const size_t n = chunk->thunks.len;
                    if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0018;
                    if (ctx->cur == p) break;
                    continue;
                L0018:;
                    ctx->cur = p;
                    pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                    break;
                }
            }
            {
                int u;
                const size_t n = pcc_get_char_as_utf32(ctx, &u);
                if (n == 0) goto L0017;
                if (
                    u == 0x00003b ||
                    u == 0x00000d ||
                    u == 0x00000a
                ) goto L0017;
                ctx->cur += n;
            }
            ctx->cur = p;
            goto L0013;
        L0017:;
            ctx->cur = p;
        }
        goto L0001;
    L0013:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "getter", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "getter", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_setter(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "setter", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_modifiers, &chunk->thunks, NULL)) goto L0003;
            {
                int i;
                for (i = 0;; i++) {
                    const size_t p = ctx->cur;
                    const size_t n = chunk->thunks.len;
                    if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0004;
                    if (ctx->cur == p) break;
                    continue;
                L0004:;
                    ctx->cur = p;
                    pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                    break;
                }
            }
            goto L0005;
        L0003:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        L0005:;
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_SET, &chunk->thunks, NULL)) goto L0002;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0006;
                if (ctx->cur == p) break;
                continue;
            L0006:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_LPAREN, &chunk->thunks, NULL)) goto L0002;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0007;
                if (ctx->cur == p) break;
                continue;
            L0007:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_parameterWithOptionalType, &chunk->thunks, NULL)) goto L0002;
        {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            {
                int i;
                for (i = 0;; i++) {
                    const size_t p = ctx->cur;
                    const size_t n = chunk->thunks.len;
                    if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0009;
                    if (ctx->cur == p) break;
                    continue;
                L0009:;
                    ctx->cur = p;
                    pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                    break;
                }
            }
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_COMMA, &chunk->thunks, NULL)) goto L0008;
            goto L0010;
        L0008:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        L0010:;
        }
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0011;
                if (ctx->cur == p) break;
                continue;
            L0011:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_RPAREN, &chunk->thunks, NULL)) goto L0002;
        {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            {
                int i;
                for (i = 0;; i++) {
                    const size_t p = ctx->cur;
                    const size_t n = chunk->thunks.len;
                    if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0013;
                    if (ctx->cur == p) break;
                    continue;
                L0013:;
                    ctx->cur = p;
                    pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                    break;
                }
            }
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_COLON, &chunk->thunks, NULL)) goto L0012;
            {
                int i;
                for (i = 0;; i++) {
                    const size_t p = ctx->cur;
                    const size_t n = chunk->thunks.len;
                    if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0014;
                    if (ctx->cur == p) break;
                    continue;
                L0014:;
                    ctx->cur = p;
                    pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                    break;
                }
            }
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_type, &chunk->thunks, NULL)) goto L0012;
            goto L0015;
        L0012:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        L0015:;
        }
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0016;
                if (ctx->cur == p) break;
                continue;
            L0016:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_functionBody, &chunk->thunks, NULL)) goto L0002;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_modifiers, &chunk->thunks, NULL)) goto L0018;
            {
                int i;
                for (i = 0;; i++) {
                    const size_t p = ctx->cur;
                    const size_t n = chunk->thunks.len;
                    if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0019;
                    if (ctx->cur == p) break;
                    continue;
                L0019:;
                    ctx->cur = p;
                    pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                    break;
                }
            }
            goto L0020;
        L0018:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        L0020:;
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_SET, &chunk->thunks, NULL)) goto L0017;
        {
            const size_t p = ctx->cur;
            {
                int i;
                for (i = 0;; i++) {
                    const size_t p = ctx->cur;
                    const size_t n = chunk->thunks.len;
                    if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0022;
                    if (ctx->cur == p) break;
                    continue;
                L0022:;
                    ctx->cur = p;
                    pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                    break;
                }
            }
            {
                int u;
                const size_t n = pcc_get_char_as_utf32(ctx, &u);
                if (n == 0) goto L0021;
                if (
                    u == 0x00003b ||
                    u == 0x00000d ||
                    u == 0x00000a
                ) goto L0021;
                ctx->cur += n;
            }
            ctx->cur = p;
            goto L0017;
        L0021:;
            ctx->cur = p;
        }
        goto L0001;
    L0017:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "setter", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "setter", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_parametersWithOptionalType(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "parametersWithOptionalType", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_LPAREN, &chunk->thunks, NULL)) goto L0000;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0001;
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_parameterWithOptionalType, &chunk->thunks, NULL)) goto L0002;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                {
                    int i;
                    for (i = 0;; i++) {
                        const size_t p = ctx->cur;
                        const size_t n = chunk->thunks.len;
                        if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0004;
                        if (ctx->cur == p) break;
                        continue;
                    L0004:;
                        ctx->cur = p;
                        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                        break;
                    }
                }
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule_COMMA, &chunk->thunks, NULL)) goto L0003;
                {
                    int i;
                    for (i = 0;; i++) {
                        const size_t p = ctx->cur;
                        const size_t n = chunk->thunks.len;
                        if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0005;
                        if (ctx->cur == p) break;
                        continue;
                    L0005:;
                        ctx->cur = p;
                        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                        break;
                    }
                }
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule_parameterWithOptionalType, &chunk->thunks, NULL)) goto L0003;
                if (ctx->cur == p) break;
                continue;
            L0003:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            {
                int i;
                for (i = 0;; i++) {
                    const size_t p = ctx->cur;
                    const size_t n = chunk->thunks.len;
                    if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0007;
                    if (ctx->cur == p) break;
                    continue;
                L0007:;
                    ctx->cur = p;
                    pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                    break;
                }
            }
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_COMMA, &chunk->thunks, NULL)) goto L0006;
            goto L0008;
        L0006:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        L0008:;
        }
        goto L0009;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0009:;
    }
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0010;
            if (ctx->cur == p) break;
            continue;
        L0010:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_RPAREN, &chunk->thunks, NULL)) goto L0000;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "parametersWithOptionalType", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "parametersWithOptionalType", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_parameterWithOptionalType(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "parameterWithOptionalType", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_parameterModifiers, &chunk->thunks, NULL)) goto L0001;
        goto L0002;
    L0001:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0002:;
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_simpleIdentifier, &chunk->thunks, NULL)) goto L0000;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0003;
            if (ctx->cur == p) break;
            continue;
        L0003:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_COLON, &chunk->thunks, NULL)) goto L0004;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0005;
                if (ctx->cur == p) break;
                continue;
            L0005:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_type, &chunk->thunks, NULL)) goto L0004;
        goto L0006;
    L0004:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0006:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "parameterWithOptionalType", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "parameterWithOptionalType", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_parameter(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "parameter", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_simpleIdentifier, &chunk->thunks, NULL)) goto L0000;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0001;
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_COLON, &chunk->thunks, NULL)) goto L0000;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0002;
            if (ctx->cur == p) break;
            continue;
        L0002:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_type, &chunk->thunks, NULL)) goto L0000;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "parameter", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "parameter", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_objectDeclaration(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "objectDeclaration", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    pcc_capture_table__resize(ctx->auxil, &chunk->capts, 1);
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_modifiers, &chunk->thunks, NULL)) goto L0001;
        goto L0002;
    L0001:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0002:;
    }
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0003;
            if (ctx->cur == p) break;
            continue;
        L0003:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_OBJECT, &chunk->thunks, NULL)) goto L0000;
    {
        pcc_thunk_t *const thunk = pcc_thunk__create_leaf(ctx->auxil, pcc_action_objectDeclaration_0, 0, 1);
        thunk->data.leaf.capt0.range.start = chunk->pos;
        thunk->data.leaf.capt0.range.end = ctx->cur;
        pcc_thunk_array__add(ctx->auxil, &chunk->thunks, thunk);
    }
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0004;
            if (ctx->cur == p) break;
            continue;
        L0004:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    {
        const size_t p = ctx->cur;
        size_t q;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_simpleIdentifier, &chunk->thunks, NULL)) goto L0000;
        q = ctx->cur;
        chunk->capts.buf[0].range.start = p;
        chunk->capts.buf[0].range.end = q;
    }
    {
        pcc_thunk_t *const thunk = pcc_thunk__create_leaf(ctx->auxil, pcc_action_objectDeclaration_1, 0, 1);
        thunk->data.leaf.capts.buf[0] = &(chunk->capts.buf[0]);
        thunk->data.leaf.capt0.range.start = chunk->pos;
        thunk->data.leaf.capt0.range.end = ctx->cur;
        pcc_thunk_array__add(ctx->auxil, &chunk->thunks, thunk);
    }
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0006;
                if (ctx->cur == p) break;
                continue;
            L0006:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_COLON, &chunk->thunks, NULL)) goto L0005;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0007;
                if (ctx->cur == p) break;
                continue;
            L0007:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_delegationSpecifiers, &chunk->thunks, NULL)) goto L0005;
        goto L0008;
    L0005:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0008:;
    }
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0010;
                if (ctx->cur == p) break;
                continue;
            L0010:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_classBody, &chunk->thunks, NULL)) goto L0009;
        goto L0011;
    L0009:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0011:;
    }
    {
        pcc_thunk_t *const thunk = pcc_thunk__create_leaf(ctx->auxil, pcc_action_objectDeclaration_2, 0, 1);
        thunk->data.leaf.capts.buf[0] = &(chunk->capts.buf[0]);
        thunk->data.leaf.capt0.range.start = chunk->pos;
        thunk->data.leaf.capt0.range.end = ctx->cur;
        pcc_thunk_array__add(ctx->auxil, &chunk->thunks, thunk);
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "objectDeclaration", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "objectDeclaration", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_secondaryConstructor(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "secondaryConstructor", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_modifiers, &chunk->thunks, NULL)) goto L0001;
        goto L0002;
    L0001:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0002:;
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_CONSTRUCTOR, &chunk->thunks, NULL)) goto L0000;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0003;
            if (ctx->cur == p) break;
            continue;
        L0003:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_functionValueParameters, &chunk->thunks, NULL)) goto L0000;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0005;
                if (ctx->cur == p) break;
                continue;
            L0005:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_COLON, &chunk->thunks, NULL)) goto L0004;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0006;
                if (ctx->cur == p) break;
                continue;
            L0006:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_constructorDelegationCall, &chunk->thunks, NULL)) goto L0004;
        goto L0007;
    L0004:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0007:;
    }
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0008;
            if (ctx->cur == p) break;
            continue;
        L0008:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_block, &chunk->thunks, NULL)) goto L0009;
        goto L0010;
    L0009:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0010:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "secondaryConstructor", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "secondaryConstructor", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_constructorDelegationCall(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "constructorDelegationCall", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_THIS, &chunk->thunks, NULL)) goto L0002;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0003;
                if (ctx->cur == p) break;
                continue;
            L0003:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_valueArguments, &chunk->thunks, NULL)) goto L0002;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_SUPER, &chunk->thunks, NULL)) goto L0004;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0005;
                if (ctx->cur == p) break;
                continue;
            L0005:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_valueArguments, &chunk->thunks, NULL)) goto L0004;
        goto L0001;
    L0004:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "constructorDelegationCall", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "constructorDelegationCall", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_enumClassBody(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "enumClassBody", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_LCURL, &chunk->thunks, NULL)) goto L0000;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0001;
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_enumEntries, &chunk->thunks, NULL)) goto L0002;
        goto L0003;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0003:;
    }
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0005;
                if (ctx->cur == p) break;
                continue;
            L0005:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_SEMICOLON, &chunk->thunks, NULL)) goto L0004;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0006;
                if (ctx->cur == p) break;
                continue;
            L0006:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_classMemberDeclarations, &chunk->thunks, NULL)) goto L0004;
        goto L0007;
    L0004:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0007:;
    }
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0008;
            if (ctx->cur == p) break;
            continue;
        L0008:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_RCURL, &chunk->thunks, NULL)) goto L0000;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "enumClassBody", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "enumClassBody", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_enumEntries(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "enumEntries", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_enumEntry, &chunk->thunks, NULL)) goto L0000;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            {
                int i;
                for (i = 0;; i++) {
                    const size_t p = ctx->cur;
                    const size_t n = chunk->thunks.len;
                    if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0002;
                    if (ctx->cur == p) break;
                    continue;
                L0002:;
                    ctx->cur = p;
                    pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                    break;
                }
            }
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_COMMA, &chunk->thunks, NULL)) goto L0001;
            {
                int i;
                for (i = 0;; i++) {
                    const size_t p = ctx->cur;
                    const size_t n = chunk->thunks.len;
                    if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0003;
                    if (ctx->cur == p) break;
                    continue;
                L0003:;
                    ctx->cur = p;
                    pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                    break;
                }
            }
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_enumEntry, &chunk->thunks, NULL)) goto L0001;
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0004;
            if (ctx->cur == p) break;
            continue;
        L0004:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_COMMA, &chunk->thunks, NULL)) goto L0005;
        goto L0006;
    L0005:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0006:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "enumEntries", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "enumEntries", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_enumEntry(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "enumEntry", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_modifiers, &chunk->thunks, NULL)) goto L0001;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0002;
                if (ctx->cur == p) break;
                continue;
            L0002:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        goto L0003;
    L0001:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0003:;
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_simpleIdentifier, &chunk->thunks, NULL)) goto L0000;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0005;
                if (ctx->cur == p) break;
                continue;
            L0005:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_valueArguments, &chunk->thunks, NULL)) goto L0004;
        goto L0006;
    L0004:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0006:;
    }
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0008;
                if (ctx->cur == p) break;
                continue;
            L0008:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_classBody, &chunk->thunks, NULL)) goto L0007;
        goto L0009;
    L0007:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0009:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "enumEntry", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "enumEntry", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_type(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "type", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_typeModifiers, &chunk->thunks, NULL)) goto L0001;
        goto L0002;
    L0001:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0002:;
    }
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_functionType, &chunk->thunks, NULL)) goto L0004;
        goto L0003;
    L0004:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_nullableType, &chunk->thunks, NULL)) goto L0005;
        goto L0003;
    L0005:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_parenthesizedType, &chunk->thunks, NULL)) goto L0006;
        goto L0003;
    L0006:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_typeReference, &chunk->thunks, NULL)) goto L0007;
        goto L0003;
    L0007:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0003:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "type", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "type", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_typeReference(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "typeReference", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_userType, &chunk->thunks, NULL)) goto L0002;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_DYNAMIC, &chunk->thunks, NULL)) goto L0003;
        goto L0001;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "typeReference", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "typeReference", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_nullableType(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "nullableType", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_typeReference, &chunk->thunks, NULL)) goto L0002;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_parenthesizedType, &chunk->thunks, NULL)) goto L0003;
        goto L0001;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0004;
            if (ctx->cur == p) break;
            continue;
        L0004:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    {
        const size_t p0 = ctx->cur;
        const size_t n0 = chunk->thunks.len;
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_quest, &chunk->thunks, NULL)) goto L0005;
            if (ctx->cur == p) break;
            continue;
        L0005:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
        if (i < 1) {
            ctx->cur = p0;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n0);
            goto L0000;
        }
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "nullableType", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "nullableType", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_quest(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "quest", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_elvis, &chunk->thunks, NULL)) goto L0001;
        ctx->cur = p;
        goto L0000;
    L0001:;
        ctx->cur = p;
    }
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_QUEST_WS, &chunk->thunks, NULL)) goto L0003;
        goto L0002;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_QUEST_NO_WS, &chunk->thunks, NULL)) goto L0004;
        goto L0002;
    L0004:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0002:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "quest", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "quest", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_userType(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "userType", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_simpleUserType, &chunk->thunks, NULL)) goto L0000;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            {
                int i;
                for (i = 0;; i++) {
                    const size_t p = ctx->cur;
                    const size_t n = chunk->thunks.len;
                    if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0002;
                    if (ctx->cur == p) break;
                    continue;
                L0002:;
                    ctx->cur = p;
                    pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                    break;
                }
            }
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_DOT, &chunk->thunks, NULL)) goto L0001;
            {
                int i;
                for (i = 0;; i++) {
                    const size_t p = ctx->cur;
                    const size_t n = chunk->thunks.len;
                    if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0003;
                    if (ctx->cur == p) break;
                    continue;
                L0003:;
                    ctx->cur = p;
                    pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                    break;
                }
            }
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_simpleUserType, &chunk->thunks, NULL)) goto L0001;
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "userType", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "userType", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_simpleUserType(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "simpleUserType", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_simpleIdentifier, &chunk->thunks, NULL)) goto L0000;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0002;
                if (ctx->cur == p) break;
                continue;
            L0002:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_typeArguments, &chunk->thunks, NULL)) goto L0001;
        goto L0003;
    L0001:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0003:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "simpleUserType", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "simpleUserType", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_typeProjection(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "typeProjection", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_typeProjectionModifiers, &chunk->thunks, NULL)) goto L0003;
            goto L0004;
        L0003:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        L0004:;
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_type, &chunk->thunks, NULL)) goto L0002;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_MULT, &chunk->thunks, NULL)) goto L0005;
        goto L0001;
    L0005:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "typeProjection", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "typeProjection", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_typeProjectionModifiers(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "typeProjectionModifiers", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p0 = ctx->cur;
        const size_t n0 = chunk->thunks.len;
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_typeProjectionModifier, &chunk->thunks, NULL)) goto L0001;
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
        if (i < 1) {
            ctx->cur = p0;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n0);
            goto L0000;
        }
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "typeProjectionModifiers", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "typeProjectionModifiers", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_typeProjectionModifier(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "typeProjectionModifier", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_varianceModifier, &chunk->thunks, NULL)) goto L0002;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0003;
                if (ctx->cur == p) break;
                continue;
            L0003:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_annotation, &chunk->thunks, NULL)) goto L0004;
        goto L0001;
    L0004:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "typeProjectionModifier", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "typeProjectionModifier", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_functionType(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "functionType", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_receiverType, &chunk->thunks, NULL)) goto L0001;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0002;
                if (ctx->cur == p) break;
                continue;
            L0002:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_DOT, &chunk->thunks, NULL)) goto L0001;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0003;
                if (ctx->cur == p) break;
                continue;
            L0003:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        goto L0004;
    L0001:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0004:;
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_functionTypeParameters, &chunk->thunks, NULL)) goto L0000;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0005;
            if (ctx->cur == p) break;
            continue;
        L0005:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_ARROW, &chunk->thunks, NULL)) goto L0000;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0006;
            if (ctx->cur == p) break;
            continue;
        L0006:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_type, &chunk->thunks, NULL)) goto L0000;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "functionType", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "functionType", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_functionTypeParameters(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "functionTypeParameters", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_LPAREN, &chunk->thunks, NULL)) goto L0000;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0001;
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_parameter, &chunk->thunks, NULL)) goto L0004;
            goto L0003;
        L0004:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_type, &chunk->thunks, NULL)) goto L0005;
            goto L0003;
        L0005:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            goto L0002;
        L0003:;
        }
        goto L0006;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0006:;
    }
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0007;
            if (ctx->cur == p) break;
            continue;
        L0007:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            {
                int i;
                for (i = 0;; i++) {
                    const size_t p = ctx->cur;
                    const size_t n = chunk->thunks.len;
                    if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0009;
                    if (ctx->cur == p) break;
                    continue;
                L0009:;
                    ctx->cur = p;
                    pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                    break;
                }
            }
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_COMMA, &chunk->thunks, NULL)) goto L0008;
            {
                int i;
                for (i = 0;; i++) {
                    const size_t p = ctx->cur;
                    const size_t n = chunk->thunks.len;
                    if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0010;
                    if (ctx->cur == p) break;
                    continue;
                L0010:;
                    ctx->cur = p;
                    pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                    break;
                }
            }
            {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule_parameter, &chunk->thunks, NULL)) goto L0012;
                goto L0011;
            L0012:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule_type, &chunk->thunks, NULL)) goto L0013;
                goto L0011;
            L0013:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                goto L0008;
            L0011:;
            }
            if (ctx->cur == p) break;
            continue;
        L0008:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0014;
            if (ctx->cur == p) break;
            continue;
        L0014:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0016;
                if (ctx->cur == p) break;
                continue;
            L0016:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_COMMA, &chunk->thunks, NULL)) goto L0015;
        goto L0017;
    L0015:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0017:;
    }
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0018;
            if (ctx->cur == p) break;
            continue;
        L0018:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_RPAREN, &chunk->thunks, NULL)) goto L0000;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "functionTypeParameters", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "functionTypeParameters", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_parenthesizedType(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "parenthesizedType", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_LPAREN, &chunk->thunks, NULL)) goto L0000;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0001;
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_type, &chunk->thunks, NULL)) goto L0000;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0002;
            if (ctx->cur == p) break;
            continue;
        L0002:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_RPAREN, &chunk->thunks, NULL)) goto L0000;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "parenthesizedType", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "parenthesizedType", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_receiverType(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "receiverType", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_typeModifiers, &chunk->thunks, NULL)) goto L0001;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0002;
                if (ctx->cur == p) break;
                continue;
            L0002:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        goto L0003;
    L0001:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0003:;
    }
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_nullableType, &chunk->thunks, NULL)) goto L0005;
        goto L0004;
    L0005:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_parenthesizedType, &chunk->thunks, NULL)) goto L0006;
        goto L0004;
    L0006:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_typeReference, &chunk->thunks, NULL)) goto L0007;
        goto L0004;
    L0007:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0004:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "receiverType", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "receiverType", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_receiverTypeAndDot(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "receiverTypeAndDot", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_typeModifiers, &chunk->thunks, NULL)) goto L0001;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0002;
                if (ctx->cur == p) break;
                continue;
            L0002:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        goto L0003;
    L0001:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0003:;
    }
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_nullableType, &chunk->thunks, NULL)) goto L0005;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0006;
                if (ctx->cur == p) break;
                continue;
            L0006:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_DOT, &chunk->thunks, NULL)) goto L0005;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0007;
                if (ctx->cur == p) break;
                continue;
            L0007:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        goto L0004;
    L0005:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_parenthesizedType, &chunk->thunks, NULL)) goto L0008;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0009;
                if (ctx->cur == p) break;
                continue;
            L0009:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_DOT, &chunk->thunks, NULL)) goto L0008;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0010;
                if (ctx->cur == p) break;
                continue;
            L0010:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        goto L0004;
    L0008:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        {
            const size_t p0 = ctx->cur;
            const size_t n0 = chunk->thunks.len;
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule_simpleUserType, &chunk->thunks, NULL)) goto L0012;
                {
                    int i;
                    for (i = 0;; i++) {
                        const size_t p = ctx->cur;
                        const size_t n = chunk->thunks.len;
                        if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0013;
                        if (ctx->cur == p) break;
                        continue;
                    L0013:;
                        ctx->cur = p;
                        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                        break;
                    }
                }
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule_DOT, &chunk->thunks, NULL)) goto L0012;
                {
                    int i;
                    for (i = 0;; i++) {
                        const size_t p = ctx->cur;
                        const size_t n = chunk->thunks.len;
                        if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0014;
                        if (ctx->cur == p) break;
                        continue;
                    L0014:;
                        ctx->cur = p;
                        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                        break;
                    }
                }
                if (ctx->cur == p) break;
                continue;
            L0012:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
            if (i < 1) {
                ctx->cur = p0;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n0);
                goto L0011;
            }
        }
        goto L0004;
    L0011:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0004:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "receiverTypeAndDot", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "receiverTypeAndDot", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_statements(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "statements", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_statement, &chunk->thunks, NULL)) goto L0001;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0002;
                if (ctx->cur == p) break;
                continue;
            L0002:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule_semis, &chunk->thunks, NULL)) goto L0003;
                {
                    int i;
                    for (i = 0;; i++) {
                        const size_t p = ctx->cur;
                        const size_t n = chunk->thunks.len;
                        if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0004;
                        if (ctx->cur == p) break;
                        continue;
                    L0004:;
                        ctx->cur = p;
                        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                        break;
                    }
                }
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule_statement, &chunk->thunks, NULL)) goto L0003;
                {
                    int i;
                    for (i = 0;; i++) {
                        const size_t p = ctx->cur;
                        const size_t n = chunk->thunks.len;
                        if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0005;
                        if (ctx->cur == p) break;
                        continue;
                    L0005:;
                        ctx->cur = p;
                        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                        break;
                    }
                }
                if (ctx->cur == p) break;
                continue;
            L0003:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        goto L0006;
    L0001:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0006:;
    }
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0007;
            if (ctx->cur == p) break;
            continue;
        L0007:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_semis, &chunk->thunks, NULL)) goto L0008;
        goto L0009;
    L0008:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0009:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "statements", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_statement(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "statement", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule_label, &chunk->thunks, NULL)) goto L0003;
                goto L0002;
            L0003:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule_annotation, &chunk->thunks, NULL)) goto L0004;
                goto L0002;
            L0004:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                goto L0001;
            L0002:;
            }
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_declaration, &chunk->thunks, NULL)) goto L0006;
        goto L0005;
    L0006:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_assignment, &chunk->thunks, NULL)) goto L0007;
        goto L0005;
    L0007:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_loopStatement, &chunk->thunks, NULL)) goto L0008;
        goto L0005;
    L0008:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_expression, &chunk->thunks, NULL)) goto L0009;
        goto L0005;
    L0009:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0005:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "statement", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "statement", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_label(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "label", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_simpleIdentifier, &chunk->thunks, NULL)) goto L0000;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_AT_POST_WS, &chunk->thunks, NULL)) goto L0002;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_AT_NO_WS, &chunk->thunks, NULL)) goto L0003;
        goto L0001;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0004;
            if (ctx->cur == p) break;
            continue;
        L0004:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "label", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "label", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_controlStructureBody(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "controlStructureBody", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_block, &chunk->thunks, NULL)) goto L0002;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_statement, &chunk->thunks, NULL)) goto L0003;
        goto L0001;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "controlStructureBody", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "controlStructureBody", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_block(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "block", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_LCURL, &chunk->thunks, NULL)) goto L0000;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0001;
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_statements, &chunk->thunks, NULL)) goto L0000;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0002;
            if (ctx->cur == p) break;
            continue;
        L0002:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_RCURL, &chunk->thunks, NULL)) goto L0000;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "block", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "block", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_loopStatement(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "loopStatement", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_forStatement, &chunk->thunks, NULL)) goto L0002;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_whileStatement, &chunk->thunks, NULL)) goto L0003;
        goto L0001;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_doWhileStatement, &chunk->thunks, NULL)) goto L0004;
        goto L0001;
    L0004:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "loopStatement", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "loopStatement", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_forStatement(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "forStatement", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_FOR, &chunk->thunks, NULL)) goto L0000;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0001;
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_LPAREN, &chunk->thunks, NULL)) goto L0000;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0002;
            if (ctx->cur == p) break;
            continue;
        L0002:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_annotation, &chunk->thunks, NULL)) goto L0003;
            if (ctx->cur == p) break;
            continue;
        L0003:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0004;
            if (ctx->cur == p) break;
            continue;
        L0004:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_variableDeclaration, &chunk->thunks, NULL)) goto L0006;
        goto L0005;
    L0006:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_multiVariableDeclaration, &chunk->thunks, NULL)) goto L0007;
        goto L0005;
    L0007:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0005:;
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0000;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_IN, &chunk->thunks, NULL)) goto L0000;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0000;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_inside_expression, &chunk->thunks, NULL)) goto L0000;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0008;
            if (ctx->cur == p) break;
            continue;
        L0008:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_RPAREN, &chunk->thunks, NULL)) goto L0000;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0009;
            if (ctx->cur == p) break;
            continue;
        L0009:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_controlStructureBody, &chunk->thunks, NULL)) goto L0010;
        goto L0011;
    L0010:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0011:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "forStatement", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "forStatement", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_whileStatement(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "whileStatement", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_WHILE, &chunk->thunks, NULL)) goto L0002;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0003;
                if (ctx->cur == p) break;
                continue;
            L0003:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_LPAREN, &chunk->thunks, NULL)) goto L0002;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0004;
                if (ctx->cur == p) break;
                continue;
            L0004:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_inside_expression, &chunk->thunks, NULL)) goto L0002;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0005;
                if (ctx->cur == p) break;
                continue;
            L0005:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_RPAREN, &chunk->thunks, NULL)) goto L0002;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0006;
                if (ctx->cur == p) break;
                continue;
            L0006:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_controlStructureBody, &chunk->thunks, NULL)) goto L0002;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_WHILE, &chunk->thunks, NULL)) goto L0007;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0008;
                if (ctx->cur == p) break;
                continue;
            L0008:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_LPAREN, &chunk->thunks, NULL)) goto L0007;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0009;
                if (ctx->cur == p) break;
                continue;
            L0009:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_expression, &chunk->thunks, NULL)) goto L0007;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0010;
                if (ctx->cur == p) break;
                continue;
            L0010:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_RPAREN, &chunk->thunks, NULL)) goto L0007;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0011;
                if (ctx->cur == p) break;
                continue;
            L0011:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_SEMICOLON, &chunk->thunks, NULL)) goto L0007;
        goto L0001;
    L0007:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "whileStatement", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "whileStatement", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_doWhileStatement(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "doWhileStatement", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_DO, &chunk->thunks, NULL)) goto L0000;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0001;
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_controlStructureBody, &chunk->thunks, NULL)) goto L0002;
        goto L0003;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0003:;
    }
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0004;
            if (ctx->cur == p) break;
            continue;
        L0004:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_WHILE, &chunk->thunks, NULL)) goto L0000;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0005;
            if (ctx->cur == p) break;
            continue;
        L0005:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_LPAREN, &chunk->thunks, NULL)) goto L0000;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0006;
            if (ctx->cur == p) break;
            continue;
        L0006:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_expression, &chunk->thunks, NULL)) goto L0000;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0007;
            if (ctx->cur == p) break;
            continue;
        L0007:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_RPAREN, &chunk->thunks, NULL)) goto L0000;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "doWhileStatement", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "doWhileStatement", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_assignment(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "assignment", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_directlyAssignableExpression, &chunk->thunks, NULL)) goto L0002;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0003;
                if (ctx->cur == p) break;
                continue;
            L0003:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_ASSIGNMENT, &chunk->thunks, NULL)) goto L0002;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0004;
                if (ctx->cur == p) break;
                continue;
            L0004:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_expression, &chunk->thunks, NULL)) goto L0002;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_assignableExpression, &chunk->thunks, NULL)) goto L0005;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0006;
                if (ctx->cur == p) break;
                continue;
            L0006:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_assignmentAndOperator, &chunk->thunks, NULL)) goto L0005;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0007;
                if (ctx->cur == p) break;
                continue;
            L0007:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_expression, &chunk->thunks, NULL)) goto L0005;
        goto L0001;
    L0005:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "assignment", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "assignment", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_semi(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "semi", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0001;
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_SEMICOLON, &chunk->thunks, NULL)) goto L0003;
        goto L0002;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_NL, &chunk->thunks, NULL)) goto L0004;
        goto L0002;
    L0004:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0002:;
    }
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0005;
            if (ctx->cur == p) break;
            continue;
        L0005:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_NL, &chunk->thunks, NULL)) goto L0006;
            if (ctx->cur == p) break;
            continue;
        L0006:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "semi", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "semi", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_semis(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "semis", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p0 = ctx->cur;
        const size_t n0 = chunk->thunks.len;
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            {
                int i;
                for (i = 0;; i++) {
                    const size_t p = ctx->cur;
                    const size_t n = chunk->thunks.len;
                    if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0002;
                    if (ctx->cur == p) break;
                    continue;
                L0002:;
                    ctx->cur = p;
                    pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                    break;
                }
            }
            {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule_SEMICOLON, &chunk->thunks, NULL)) goto L0004;
                goto L0003;
            L0004:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule_NL, &chunk->thunks, NULL)) goto L0005;
                goto L0003;
            L0005:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                goto L0001;
            L0003:;
            }
            {
                int i;
                for (i = 0;; i++) {
                    const size_t p = ctx->cur;
                    const size_t n = chunk->thunks.len;
                    if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0006;
                    if (ctx->cur == p) break;
                    continue;
                L0006:;
                    ctx->cur = p;
                    pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                    break;
                }
            }
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
        if (i < 1) {
            ctx->cur = p0;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n0);
            goto L0000;
        }
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "semis", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "semis", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_expression(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "expression", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_disjunction, &chunk->thunks, NULL)) goto L0000;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "expression", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "expression", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_disjunction(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "disjunction", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_conjunction, &chunk->thunks, NULL)) goto L0000;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            {
                int i;
                for (i = 0;; i++) {
                    const size_t p = ctx->cur;
                    const size_t n = chunk->thunks.len;
                    if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0002;
                    if (ctx->cur == p) break;
                    continue;
                L0002:;
                    ctx->cur = p;
                    pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                    break;
                }
            }
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_DISJ, &chunk->thunks, NULL)) goto L0001;
            {
                int i;
                for (i = 0;; i++) {
                    const size_t p = ctx->cur;
                    const size_t n = chunk->thunks.len;
                    if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0003;
                    if (ctx->cur == p) break;
                    continue;
                L0003:;
                    ctx->cur = p;
                    pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                    break;
                }
            }
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_conjunction, &chunk->thunks, NULL)) goto L0001;
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "disjunction", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "disjunction", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_conjunction(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "conjunction", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_equality, &chunk->thunks, NULL)) goto L0000;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            {
                int i;
                for (i = 0;; i++) {
                    const size_t p = ctx->cur;
                    const size_t n = chunk->thunks.len;
                    if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0002;
                    if (ctx->cur == p) break;
                    continue;
                L0002:;
                    ctx->cur = p;
                    pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                    break;
                }
            }
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_CONJ, &chunk->thunks, NULL)) goto L0001;
            {
                int i;
                for (i = 0;; i++) {
                    const size_t p = ctx->cur;
                    const size_t n = chunk->thunks.len;
                    if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0003;
                    if (ctx->cur == p) break;
                    continue;
                L0003:;
                    ctx->cur = p;
                    pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                    break;
                }
            }
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_equality, &chunk->thunks, NULL)) goto L0001;
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "conjunction", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "conjunction", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_equality(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "equality", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_comparison, &chunk->thunks, NULL)) goto L0000;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            {
                int i;
                for (i = 0;; i++) {
                    const size_t p = ctx->cur;
                    const size_t n = chunk->thunks.len;
                    if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0002;
                    if (ctx->cur == p) break;
                    continue;
                L0002:;
                    ctx->cur = p;
                    pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                    break;
                }
            }
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_equalityOperator, &chunk->thunks, NULL)) goto L0001;
            {
                int i;
                for (i = 0;; i++) {
                    const size_t p = ctx->cur;
                    const size_t n = chunk->thunks.len;
                    if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0003;
                    if (ctx->cur == p) break;
                    continue;
                L0003:;
                    ctx->cur = p;
                    pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                    break;
                }
            }
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_comparison, &chunk->thunks, NULL)) goto L0001;
            {
                int i;
                for (i = 0;; i++) {
                    const size_t p = ctx->cur;
                    const size_t n = chunk->thunks.len;
                    if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0004;
                    if (ctx->cur == p) break;
                    continue;
                L0004:;
                    ctx->cur = p;
                    pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                    break;
                }
            }
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "equality", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "equality", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_comparison(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "comparison", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_genericCallLikeComparison, &chunk->thunks, NULL)) goto L0000;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            {
                int i;
                for (i = 0;; i++) {
                    const size_t p = ctx->cur;
                    const size_t n = chunk->thunks.len;
                    if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0002;
                    if (ctx->cur == p) break;
                    continue;
                L0002:;
                    ctx->cur = p;
                    pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                    break;
                }
            }
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_comparisonOperator, &chunk->thunks, NULL)) goto L0001;
            {
                int i;
                for (i = 0;; i++) {
                    const size_t p = ctx->cur;
                    const size_t n = chunk->thunks.len;
                    if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0003;
                    if (ctx->cur == p) break;
                    continue;
                L0003:;
                    ctx->cur = p;
                    pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                    break;
                }
            }
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_genericCallLikeComparison, &chunk->thunks, NULL)) goto L0001;
            {
                int i;
                for (i = 0;; i++) {
                    const size_t p = ctx->cur;
                    const size_t n = chunk->thunks.len;
                    if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0004;
                    if (ctx->cur == p) break;
                    continue;
                L0004:;
                    ctx->cur = p;
                    pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                    break;
                }
            }
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "comparison", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "comparison", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_genericCallLikeComparison(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "genericCallLikeComparison", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_infixOperation, &chunk->thunks, NULL)) goto L0000;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            {
                int i;
                for (i = 0;; i++) {
                    const size_t p = ctx->cur;
                    const size_t n = chunk->thunks.len;
                    if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0002;
                    if (ctx->cur == p) break;
                    continue;
                L0002:;
                    ctx->cur = p;
                    pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                    break;
                }
            }
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_callSuffix, &chunk->thunks, NULL)) goto L0001;
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "genericCallLikeComparison", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "genericCallLikeComparison", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_infixOperation(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "infixOperation", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_elvisExpression, &chunk->thunks, NULL)) goto L0000;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                {
                    int i;
                    for (i = 0;; i++) {
                        const size_t p = ctx->cur;
                        const size_t n = chunk->thunks.len;
                        if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0004;
                        if (ctx->cur == p) break;
                        continue;
                    L0004:;
                        ctx->cur = p;
                        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                        break;
                    }
                }
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule_inOperator, &chunk->thunks, NULL)) goto L0003;
                {
                    int i;
                    for (i = 0;; i++) {
                        const size_t p = ctx->cur;
                        const size_t n = chunk->thunks.len;
                        if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0005;
                        if (ctx->cur == p) break;
                        continue;
                    L0005:;
                        ctx->cur = p;
                        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                        break;
                    }
                }
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule_elvisExpression, &chunk->thunks, NULL)) goto L0003;
                goto L0002;
            L0003:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                {
                    int i;
                    for (i = 0;; i++) {
                        const size_t p = ctx->cur;
                        const size_t n = chunk->thunks.len;
                        if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0007;
                        if (ctx->cur == p) break;
                        continue;
                    L0007:;
                        ctx->cur = p;
                        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                        break;
                    }
                }
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule_isOperator, &chunk->thunks, NULL)) goto L0006;
                {
                    int i;
                    for (i = 0;; i++) {
                        const size_t p = ctx->cur;
                        const size_t n = chunk->thunks.len;
                        if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0008;
                        if (ctx->cur == p) break;
                        continue;
                    L0008:;
                        ctx->cur = p;
                        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                        break;
                    }
                }
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule_type, &chunk->thunks, NULL)) goto L0006;
                goto L0002;
            L0006:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                goto L0001;
            L0002:;
            }
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "infixOperation", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "infixOperation", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_elvisExpression(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "elvisExpression", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_infixFunctionCall, &chunk->thunks, NULL)) goto L0000;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            {
                int i;
                for (i = 0;; i++) {
                    const size_t p = ctx->cur;
                    const size_t n = chunk->thunks.len;
                    if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0002;
                    if (ctx->cur == p) break;
                    continue;
                L0002:;
                    ctx->cur = p;
                    pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                    break;
                }
            }
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_elvis, &chunk->thunks, NULL)) goto L0001;
            {
                int i;
                for (i = 0;; i++) {
                    const size_t p = ctx->cur;
                    const size_t n = chunk->thunks.len;
                    if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0003;
                    if (ctx->cur == p) break;
                    continue;
                L0003:;
                    ctx->cur = p;
                    pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                    break;
                }
            }
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_infixFunctionCall, &chunk->thunks, NULL)) goto L0001;
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "elvisExpression", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "elvisExpression", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_elvis(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "elvis", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_QUEST_NO_WS, &chunk->thunks, NULL)) goto L0000;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_COLON, &chunk->thunks, NULL)) goto L0000;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "elvis", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "elvis", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_infixFunctionCall(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "infixFunctionCall", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_rangeExpression, &chunk->thunks, NULL)) goto L0000;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            {
                int i;
                for (i = 0;; i++) {
                    const size_t p = ctx->cur;
                    const size_t n = chunk->thunks.len;
                    if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0002;
                    if (ctx->cur == p) break;
                    continue;
                L0002:;
                    ctx->cur = p;
                    pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                    break;
                }
            }
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_simpleIdentifier, &chunk->thunks, NULL)) goto L0001;
            {
                int i;
                for (i = 0;; i++) {
                    const size_t p = ctx->cur;
                    const size_t n = chunk->thunks.len;
                    if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0003;
                    if (ctx->cur == p) break;
                    continue;
                L0003:;
                    ctx->cur = p;
                    pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                    break;
                }
            }
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_rangeExpression, &chunk->thunks, NULL)) goto L0001;
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "infixFunctionCall", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "infixFunctionCall", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_rangeExpression(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "rangeExpression", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_additiveExpression, &chunk->thunks, NULL)) goto L0000;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            {
                int i;
                for (i = 0;; i++) {
                    const size_t p = ctx->cur;
                    const size_t n = chunk->thunks.len;
                    if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0002;
                    if (ctx->cur == p) break;
                    continue;
                L0002:;
                    ctx->cur = p;
                    pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                    break;
                }
            }
            {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule_RANGE_UNTIL, &chunk->thunks, NULL)) goto L0004;
                goto L0003;
            L0004:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule_RANGE, &chunk->thunks, NULL)) goto L0005;
                goto L0003;
            L0005:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                goto L0001;
            L0003:;
            }
            {
                int i;
                for (i = 0;; i++) {
                    const size_t p = ctx->cur;
                    const size_t n = chunk->thunks.len;
                    if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0006;
                    if (ctx->cur == p) break;
                    continue;
                L0006:;
                    ctx->cur = p;
                    pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                    break;
                }
            }
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_additiveExpression, &chunk->thunks, NULL)) goto L0001;
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "rangeExpression", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "rangeExpression", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_additiveExpression(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "additiveExpression", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_multiplicativeExpression, &chunk->thunks, NULL)) goto L0000;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            {
                int i;
                for (i = 0;; i++) {
                    const size_t p = ctx->cur;
                    const size_t n = chunk->thunks.len;
                    if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0002;
                    if (ctx->cur == p) break;
                    continue;
                L0002:;
                    ctx->cur = p;
                    pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                    break;
                }
            }
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_additiveOperator, &chunk->thunks, NULL)) goto L0001;
            {
                int i;
                for (i = 0;; i++) {
                    const size_t p = ctx->cur;
                    const size_t n = chunk->thunks.len;
                    if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0003;
                    if (ctx->cur == p) break;
                    continue;
                L0003:;
                    ctx->cur = p;
                    pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                    break;
                }
            }
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_multiplicativeExpression, &chunk->thunks, NULL)) goto L0001;
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "additiveExpression", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "additiveExpression", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_multiplicativeExpression(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "multiplicativeExpression", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_asExpression, &chunk->thunks, NULL)) goto L0000;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            {
                int i;
                for (i = 0;; i++) {
                    const size_t p = ctx->cur;
                    const size_t n = chunk->thunks.len;
                    if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0002;
                    if (ctx->cur == p) break;
                    continue;
                L0002:;
                    ctx->cur = p;
                    pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                    break;
                }
            }
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_multiplicativeOperator, &chunk->thunks, NULL)) goto L0001;
            {
                int i;
                for (i = 0;; i++) {
                    const size_t p = ctx->cur;
                    const size_t n = chunk->thunks.len;
                    if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0003;
                    if (ctx->cur == p) break;
                    continue;
                L0003:;
                    ctx->cur = p;
                    pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                    break;
                }
            }
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_asExpression, &chunk->thunks, NULL)) goto L0001;
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "multiplicativeExpression", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "multiplicativeExpression", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_asExpression(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "asExpression", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_prefixUnaryExpression, &chunk->thunks, NULL)) goto L0000;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            {
                int i;
                for (i = 0;; i++) {
                    const size_t p = ctx->cur;
                    const size_t n = chunk->thunks.len;
                    if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0002;
                    if (ctx->cur == p) break;
                    continue;
                L0002:;
                    ctx->cur = p;
                    pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                    break;
                }
            }
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_asOperator, &chunk->thunks, NULL)) goto L0001;
            {
                int i;
                for (i = 0;; i++) {
                    const size_t p = ctx->cur;
                    const size_t n = chunk->thunks.len;
                    if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0003;
                    if (ctx->cur == p) break;
                    continue;
                L0003:;
                    ctx->cur = p;
                    pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                    break;
                }
            }
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_type, &chunk->thunks, NULL)) goto L0001;
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "asExpression", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "asExpression", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_prefixUnaryExpression(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "prefixUnaryExpression", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_unaryPrefix, &chunk->thunks, NULL)) goto L0001;
            {
                int i;
                for (i = 0;; i++) {
                    const size_t p = ctx->cur;
                    const size_t n = chunk->thunks.len;
                    if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0002;
                    if (ctx->cur == p) break;
                    continue;
                L0002:;
                    ctx->cur = p;
                    pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                    break;
                }
            }
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_postfixUnaryExpression, &chunk->thunks, NULL)) goto L0000;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "prefixUnaryExpression", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "prefixUnaryExpression", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_unaryPrefix(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "unaryPrefix", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_annotation, &chunk->thunks, NULL)) goto L0002;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_label, &chunk->thunks, NULL)) goto L0003;
        goto L0001;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_prefixUnaryOperator, &chunk->thunks, NULL)) goto L0004;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0005;
                if (ctx->cur == p) break;
                continue;
            L0005:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        goto L0001;
    L0004:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "unaryPrefix", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "unaryPrefix", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_postfixUnaryExpression(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "postfixUnaryExpression", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_primaryExpression, &chunk->thunks, NULL)) goto L0002;
        {
            const size_t p0 = ctx->cur;
            const size_t n0 = chunk->thunks.len;
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                {
                    int i;
                    for (i = 0;; i++) {
                        const size_t p = ctx->cur;
                        const size_t n = chunk->thunks.len;
                        if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0004;
                        if (ctx->cur == p) break;
                        continue;
                    L0004:;
                        ctx->cur = p;
                        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                        break;
                    }
                }
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule_postfixUnarySuffix, &chunk->thunks, NULL)) goto L0003;
                if (ctx->cur == p) break;
                continue;
            L0003:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
            if (i < 1) {
                ctx->cur = p0;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n0);
                goto L0002;
            }
        }
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_primaryExpression, &chunk->thunks, NULL)) goto L0005;
        goto L0001;
    L0005:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "postfixUnaryExpression", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "postfixUnaryExpression", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_postfixUnarySuffix(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "postfixUnarySuffix", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_postfixUnaryOperator, &chunk->thunks, NULL)) goto L0002;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_typeArguments, &chunk->thunks, NULL)) goto L0003;
        goto L0001;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_callSuffix, &chunk->thunks, NULL)) goto L0004;
        goto L0001;
    L0004:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_indexingSuffix, &chunk->thunks, NULL)) goto L0005;
        goto L0001;
    L0005:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_navigationSuffix, &chunk->thunks, NULL)) goto L0006;
        goto L0001;
    L0006:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "postfixUnarySuffix", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "postfixUnarySuffix", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_directlyAssignableExpression(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "directlyAssignableExpression", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_postfixUnaryExpression, &chunk->thunks, NULL)) goto L0002;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0003;
                if (ctx->cur == p) break;
                continue;
            L0003:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_assignableSuffix, &chunk->thunks, NULL)) goto L0002;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_postfixUnaryExpression, &chunk->thunks, NULL)) goto L0004;
        goto L0001;
    L0004:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_simpleIdentifier, &chunk->thunks, NULL)) goto L0005;
        goto L0001;
    L0005:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_parenthesizedDirectlyAssignableExpression, &chunk->thunks, NULL)) goto L0006;
        goto L0001;
    L0006:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "directlyAssignableExpression", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "directlyAssignableExpression", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_parenthesizedDirectlyAssignableExpression(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "parenthesizedDirectlyAssignableExpression", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_LPAREN, &chunk->thunks, NULL)) goto L0000;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0001;
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_inside_directlyAssignableExpression, &chunk->thunks, NULL)) goto L0000;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0002;
            if (ctx->cur == p) break;
            continue;
        L0002:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_RPAREN, &chunk->thunks, NULL)) goto L0000;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "parenthesizedDirectlyAssignableExpression", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "parenthesizedDirectlyAssignableExpression", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_assignableExpression(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "assignableExpression", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_prefixUnaryExpression, &chunk->thunks, NULL)) goto L0002;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_parenthesizedAssignableExpression, &chunk->thunks, NULL)) goto L0003;
        goto L0001;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "assignableExpression", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "assignableExpression", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_parenthesizedAssignableExpression(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "parenthesizedAssignableExpression", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_LPAREN, &chunk->thunks, NULL)) goto L0000;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0001;
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_inside_assignableExpression, &chunk->thunks, NULL)) goto L0000;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0002;
            if (ctx->cur == p) break;
            continue;
        L0002:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_RPAREN, &chunk->thunks, NULL)) goto L0000;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "parenthesizedAssignableExpression", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "parenthesizedAssignableExpression", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_assignableSuffix(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "assignableSuffix", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_navigationSuffix, &chunk->thunks, NULL)) goto L0002;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_typeArguments, &chunk->thunks, NULL)) goto L0003;
        goto L0001;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_indexingSuffix, &chunk->thunks, NULL)) goto L0004;
        goto L0001;
    L0004:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "assignableSuffix", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "assignableSuffix", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_indexingSuffix(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "indexingSuffix", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_LSQUARE, &chunk->thunks, NULL)) goto L0000;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0001;
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_inside_expression, &chunk->thunks, NULL)) goto L0000;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            {
                int i;
                for (i = 0;; i++) {
                    const size_t p = ctx->cur;
                    const size_t n = chunk->thunks.len;
                    if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0003;
                    if (ctx->cur == p) break;
                    continue;
                L0003:;
                    ctx->cur = p;
                    pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                    break;
                }
            }
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_COMMA, &chunk->thunks, NULL)) goto L0002;
            {
                int i;
                for (i = 0;; i++) {
                    const size_t p = ctx->cur;
                    const size_t n = chunk->thunks.len;
                    if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0004;
                    if (ctx->cur == p) break;
                    continue;
                L0004:;
                    ctx->cur = p;
                    pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                    break;
                }
            }
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_inside_expression, &chunk->thunks, NULL)) goto L0002;
            if (ctx->cur == p) break;
            continue;
        L0002:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0006;
                if (ctx->cur == p) break;
                continue;
            L0006:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_COMMA, &chunk->thunks, NULL)) goto L0005;
        goto L0007;
    L0005:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0007:;
    }
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0008;
            if (ctx->cur == p) break;
            continue;
        L0008:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_RSQUARE, &chunk->thunks, NULL)) goto L0000;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "indexingSuffix", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "indexingSuffix", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_navigationSuffix(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "navigationSuffix", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0001;
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_memberAccessOperator, &chunk->thunks, NULL)) goto L0000;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0002;
            if (ctx->cur == p) break;
            continue;
        L0002:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_simpleIdentifier, &chunk->thunks, NULL)) goto L0004;
        goto L0003;
    L0004:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_parenthesizedExpression, &chunk->thunks, NULL)) goto L0005;
        goto L0003;
    L0005:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_CLASS, &chunk->thunks, NULL)) goto L0006;
        goto L0003;
    L0006:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0003:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "navigationSuffix", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "navigationSuffix", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_callSuffix(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "callSuffix", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_typeArguments, &chunk->thunks, NULL)) goto L0003;
            goto L0004;
        L0003:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        L0004:;
        }
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0005;
                if (ctx->cur == p) break;
                continue;
            L0005:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_valueArguments, &chunk->thunks, NULL)) goto L0006;
            goto L0007;
        L0006:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        L0007:;
        }
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0008;
                if (ctx->cur == p) break;
                continue;
            L0008:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_annotatedLambda, &chunk->thunks, NULL)) goto L0002;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_typeArguments, &chunk->thunks, NULL)) goto L0010;
            goto L0011;
        L0010:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        L0011:;
        }
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0012;
                if (ctx->cur == p) break;
                continue;
            L0012:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_valueArguments, &chunk->thunks, NULL)) goto L0009;
        goto L0001;
    L0009:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "callSuffix", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "callSuffix", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_annotatedLambda(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "annotatedLambda", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_annotation, &chunk->thunks, NULL)) goto L0001;
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0002;
            if (ctx->cur == p) break;
            continue;
        L0002:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_label, &chunk->thunks, NULL)) goto L0003;
        goto L0004;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0004:;
    }
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0005;
            if (ctx->cur == p) break;
            continue;
        L0005:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_lambdaLiteral, &chunk->thunks, NULL)) goto L0000;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "annotatedLambda", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "annotatedLambda", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_typeArguments(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "typeArguments", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_LANGLE, &chunk->thunks, NULL)) goto L0000;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0001;
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_typeProjection, &chunk->thunks, NULL)) goto L0000;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            {
                int i;
                for (i = 0;; i++) {
                    const size_t p = ctx->cur;
                    const size_t n = chunk->thunks.len;
                    if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0003;
                    if (ctx->cur == p) break;
                    continue;
                L0003:;
                    ctx->cur = p;
                    pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                    break;
                }
            }
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_COMMA, &chunk->thunks, NULL)) goto L0002;
            {
                int i;
                for (i = 0;; i++) {
                    const size_t p = ctx->cur;
                    const size_t n = chunk->thunks.len;
                    if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0004;
                    if (ctx->cur == p) break;
                    continue;
                L0004:;
                    ctx->cur = p;
                    pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                    break;
                }
            }
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_typeProjection, &chunk->thunks, NULL)) goto L0002;
            if (ctx->cur == p) break;
            continue;
        L0002:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0006;
                if (ctx->cur == p) break;
                continue;
            L0006:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_COMMA, &chunk->thunks, NULL)) goto L0005;
        goto L0007;
    L0005:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0007:;
    }
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0008;
            if (ctx->cur == p) break;
            continue;
        L0008:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_RANGLE, &chunk->thunks, NULL)) goto L0000;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "typeArguments", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "typeArguments", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_valueArguments(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "valueArguments", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_LPAREN, &chunk->thunks, NULL)) goto L0002;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0003;
                if (ctx->cur == p) break;
                continue;
            L0003:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_RPAREN, &chunk->thunks, NULL)) goto L0002;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_LPAREN, &chunk->thunks, NULL)) goto L0004;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0005;
                if (ctx->cur == p) break;
                continue;
            L0005:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_inside_valueArgument, &chunk->thunks, NULL)) goto L0004;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                {
                    int i;
                    for (i = 0;; i++) {
                        const size_t p = ctx->cur;
                        const size_t n = chunk->thunks.len;
                        if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0007;
                        if (ctx->cur == p) break;
                        continue;
                    L0007:;
                        ctx->cur = p;
                        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                        break;
                    }
                }
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule_COMMA, &chunk->thunks, NULL)) goto L0006;
                {
                    int i;
                    for (i = 0;; i++) {
                        const size_t p = ctx->cur;
                        const size_t n = chunk->thunks.len;
                        if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0008;
                        if (ctx->cur == p) break;
                        continue;
                    L0008:;
                        ctx->cur = p;
                        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                        break;
                    }
                }
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule_inside_valueArgument, &chunk->thunks, NULL)) goto L0006;
                if (ctx->cur == p) break;
                continue;
            L0006:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            {
                int i;
                for (i = 0;; i++) {
                    const size_t p = ctx->cur;
                    const size_t n = chunk->thunks.len;
                    if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0010;
                    if (ctx->cur == p) break;
                    continue;
                L0010:;
                    ctx->cur = p;
                    pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                    break;
                }
            }
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_COMMA, &chunk->thunks, NULL)) goto L0009;
            goto L0011;
        L0009:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        L0011:;
        }
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0012;
                if (ctx->cur == p) break;
                continue;
            L0012:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_RPAREN, &chunk->thunks, NULL)) goto L0004;
        goto L0001;
    L0004:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "valueArguments", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "valueArguments", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_primaryExpression(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "primaryExpression", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_thisExpression, &chunk->thunks, NULL)) goto L0002;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_superExpression, &chunk->thunks, NULL)) goto L0003;
        goto L0001;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_ifExpression, &chunk->thunks, NULL)) goto L0004;
        goto L0001;
    L0004:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_whenExpression, &chunk->thunks, NULL)) goto L0005;
        goto L0001;
    L0005:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_tryExpression, &chunk->thunks, NULL)) goto L0006;
        goto L0001;
    L0006:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_jumpExpression, &chunk->thunks, NULL)) goto L0007;
        goto L0001;
    L0007:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_parenthesizedExpression, &chunk->thunks, NULL)) goto L0008;
        goto L0001;
    L0008:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_callableReference, &chunk->thunks, NULL)) goto L0009;
        goto L0001;
    L0009:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_stringLiteral, &chunk->thunks, NULL)) goto L0010;
        goto L0001;
    L0010:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_functionLiteral, &chunk->thunks, NULL)) goto L0011;
        goto L0001;
    L0011:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_objectLiteral, &chunk->thunks, NULL)) goto L0012;
        goto L0001;
    L0012:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_collectionLiteral, &chunk->thunks, NULL)) goto L0013;
        goto L0001;
    L0013:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_simpleIdentifier, &chunk->thunks, NULL)) goto L0014;
        goto L0001;
    L0014:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_literalConstant, &chunk->thunks, NULL)) goto L0015;
        goto L0001;
    L0015:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "primaryExpression", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "primaryExpression", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_parenthesizedExpression(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "parenthesizedExpression", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_LPAREN, &chunk->thunks, NULL)) goto L0000;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0001;
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_inside_expression, &chunk->thunks, NULL)) goto L0000;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0002;
            if (ctx->cur == p) break;
            continue;
        L0002:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_RPAREN, &chunk->thunks, NULL)) goto L0000;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "parenthesizedExpression", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "parenthesizedExpression", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_collectionLiteral(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "collectionLiteral", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_LSQUARE, &chunk->thunks, NULL)) goto L0002;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0003;
                if (ctx->cur == p) break;
                continue;
            L0003:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_inside_expression, &chunk->thunks, NULL)) goto L0002;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                {
                    int i;
                    for (i = 0;; i++) {
                        const size_t p = ctx->cur;
                        const size_t n = chunk->thunks.len;
                        if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0005;
                        if (ctx->cur == p) break;
                        continue;
                    L0005:;
                        ctx->cur = p;
                        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                        break;
                    }
                }
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule_COMMA, &chunk->thunks, NULL)) goto L0004;
                {
                    int i;
                    for (i = 0;; i++) {
                        const size_t p = ctx->cur;
                        const size_t n = chunk->thunks.len;
                        if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0006;
                        if (ctx->cur == p) break;
                        continue;
                    L0006:;
                        ctx->cur = p;
                        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                        break;
                    }
                }
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule_inside_expression, &chunk->thunks, NULL)) goto L0004;
                if (ctx->cur == p) break;
                continue;
            L0004:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            {
                int i;
                for (i = 0;; i++) {
                    const size_t p = ctx->cur;
                    const size_t n = chunk->thunks.len;
                    if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0008;
                    if (ctx->cur == p) break;
                    continue;
                L0008:;
                    ctx->cur = p;
                    pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                    break;
                }
            }
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_COMMA, &chunk->thunks, NULL)) goto L0007;
            goto L0009;
        L0007:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        L0009:;
        }
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0010;
                if (ctx->cur == p) break;
                continue;
            L0010:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_RSQUARE, &chunk->thunks, NULL)) goto L0002;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_LSQUARE, &chunk->thunks, NULL)) goto L0011;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0012;
                if (ctx->cur == p) break;
                continue;
            L0012:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_RSQUARE, &chunk->thunks, NULL)) goto L0011;
        goto L0001;
    L0011:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "collectionLiteral", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "collectionLiteral", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_literalConstant(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "literalConstant", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_BooleanLiteral, &chunk->thunks, NULL)) goto L0002;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_CharacterLiteral, &chunk->thunks, NULL)) goto L0003;
        goto L0001;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_NullLiteral, &chunk->thunks, NULL)) goto L0004;
        goto L0001;
    L0004:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_RealLiteral, &chunk->thunks, NULL)) goto L0005;
        goto L0001;
    L0005:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_UnsignedLiteral, &chunk->thunks, NULL)) goto L0006;
        goto L0001;
    L0006:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_LongLiteral, &chunk->thunks, NULL)) goto L0007;
        goto L0001;
    L0007:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_HexLiteral, &chunk->thunks, NULL)) goto L0008;
        goto L0001;
    L0008:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_BinLiteral, &chunk->thunks, NULL)) goto L0009;
        goto L0001;
    L0009:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_IntegerLiteral, &chunk->thunks, NULL)) goto L0010;
        goto L0001;
    L0010:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "literalConstant", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "literalConstant", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_stringLiteral(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "stringLiteral", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_multiLineStringLiteral, &chunk->thunks, NULL)) goto L0002;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_lineStringLiteral, &chunk->thunks, NULL)) goto L0003;
        goto L0001;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "stringLiteral", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "stringLiteral", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_lineStringLiteral(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "lineStringLiteral", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_QUOTE_OPEN, &chunk->thunks, NULL)) goto L0000;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule_lineStringExpression, &chunk->thunks, NULL)) goto L0003;
                goto L0002;
            L0003:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule_lineStringContent, &chunk->thunks, NULL)) goto L0004;
                goto L0002;
            L0004:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                goto L0001;
            L0002:;
            }
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_QUOTE_CLOSE, &chunk->thunks, NULL)) goto L0000;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "lineStringLiteral", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "lineStringLiteral", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_multiLineStringLiteral(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "multiLineStringLiteral", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_TRIPLE_QUOTE_OPEN, &chunk->thunks, NULL)) goto L0000;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule_multiLineStringExpression, &chunk->thunks, NULL)) goto L0003;
                goto L0002;
            L0003:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule_multiLineStringContent, &chunk->thunks, NULL)) goto L0004;
                goto L0002;
            L0004:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule_MultiLineStringQuote, &chunk->thunks, NULL)) goto L0005;
                goto L0002;
            L0005:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                goto L0001;
            L0002:;
            }
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_TRIPLE_QUOTE_CLOSE, &chunk->thunks, NULL)) goto L0000;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "multiLineStringLiteral", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "multiLineStringLiteral", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_lineStringContent(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "lineStringContent", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_LineStrText, &chunk->thunks, NULL)) goto L0002;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_LineStrEscapedChar, &chunk->thunks, NULL)) goto L0003;
        goto L0001;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_LineStrRef, &chunk->thunks, NULL)) goto L0004;
        goto L0001;
    L0004:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "lineStringContent", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "lineStringContent", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_lineStringExpression(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "lineStringExpression", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_LineStrExprStart, &chunk->thunks, NULL)) goto L0000;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0001;
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_expression, &chunk->thunks, NULL)) goto L0000;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0002;
            if (ctx->cur == p) break;
            continue;
        L0002:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_RCURL, &chunk->thunks, NULL)) goto L0000;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "lineStringExpression", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "lineStringExpression", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_multiLineStringContent(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "multiLineStringContent", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_MultiLineStrRef, &chunk->thunks, NULL)) goto L0002;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_MultiLineStrText, &chunk->thunks, NULL)) goto L0003;
        goto L0001;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_MultiLineStringQuote, &chunk->thunks, NULL)) goto L0004;
        goto L0001;
    L0004:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "multiLineStringContent", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "multiLineStringContent", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_multiLineStringExpression(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "multiLineStringExpression", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_MultiLineStrExprStart, &chunk->thunks, NULL)) goto L0000;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0001;
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_expression, &chunk->thunks, NULL)) goto L0000;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0002;
            if (ctx->cur == p) break;
            continue;
        L0002:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_RCURL, &chunk->thunks, NULL)) goto L0000;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "multiLineStringExpression", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "multiLineStringExpression", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_inside_expression(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "inside_expression", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_inside_disjunction, &chunk->thunks, NULL)) goto L0000;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "inside_expression", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "inside_expression", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_inside_disjunction(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "inside_disjunction", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_inside_conjunction, &chunk->thunks, NULL)) goto L0000;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            {
                int i;
                for (i = 0;; i++) {
                    const size_t p = ctx->cur;
                    const size_t n = chunk->thunks.len;
                    if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0002;
                    if (ctx->cur == p) break;
                    continue;
                L0002:;
                    ctx->cur = p;
                    pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                    break;
                }
            }
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_DISJ, &chunk->thunks, NULL)) goto L0001;
            {
                int i;
                for (i = 0;; i++) {
                    const size_t p = ctx->cur;
                    const size_t n = chunk->thunks.len;
                    if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0003;
                    if (ctx->cur == p) break;
                    continue;
                L0003:;
                    ctx->cur = p;
                    pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                    break;
                }
            }
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_inside_conjunction, &chunk->thunks, NULL)) goto L0001;
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "inside_disjunction", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "inside_disjunction", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_inside_conjunction(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "inside_conjunction", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_inside_equality, &chunk->thunks, NULL)) goto L0000;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            {
                int i;
                for (i = 0;; i++) {
                    const size_t p = ctx->cur;
                    const size_t n = chunk->thunks.len;
                    if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0002;
                    if (ctx->cur == p) break;
                    continue;
                L0002:;
                    ctx->cur = p;
                    pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                    break;
                }
            }
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_CONJ, &chunk->thunks, NULL)) goto L0001;
            {
                int i;
                for (i = 0;; i++) {
                    const size_t p = ctx->cur;
                    const size_t n = chunk->thunks.len;
                    if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0003;
                    if (ctx->cur == p) break;
                    continue;
                L0003:;
                    ctx->cur = p;
                    pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                    break;
                }
            }
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_inside_equality, &chunk->thunks, NULL)) goto L0001;
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "inside_conjunction", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "inside_conjunction", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_inside_equality(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "inside_equality", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_inside_comparison, &chunk->thunks, NULL)) goto L0000;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            {
                int i;
                for (i = 0;; i++) {
                    const size_t p = ctx->cur;
                    const size_t n = chunk->thunks.len;
                    {
                        const size_t p = ctx->cur;
                        const size_t n = chunk->thunks.len;
                        if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0004;
                        goto L0003;
                    L0004:;
                        ctx->cur = p;
                        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_NL, &chunk->thunks, NULL)) goto L0005;
                        goto L0003;
                    L0005:;
                        ctx->cur = p;
                        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                        goto L0002;
                    L0003:;
                    }
                    if (ctx->cur == p) break;
                    continue;
                L0002:;
                    ctx->cur = p;
                    pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                    break;
                }
            }
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_equalityOperator, &chunk->thunks, NULL)) goto L0001;
            {
                int i;
                for (i = 0;; i++) {
                    const size_t p = ctx->cur;
                    const size_t n = chunk->thunks.len;
                    if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0006;
                    if (ctx->cur == p) break;
                    continue;
                L0006:;
                    ctx->cur = p;
                    pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                    break;
                }
            }
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_inside_comparison, &chunk->thunks, NULL)) goto L0001;
            {
                int i;
                for (i = 0;; i++) {
                    const size_t p = ctx->cur;
                    const size_t n = chunk->thunks.len;
                    {
                        const size_t p = ctx->cur;
                        const size_t n = chunk->thunks.len;
                        if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0009;
                        goto L0008;
                    L0009:;
                        ctx->cur = p;
                        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_NL, &chunk->thunks, NULL)) goto L0010;
                        goto L0008;
                    L0010:;
                        ctx->cur = p;
                        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                        goto L0007;
                    L0008:;
                    }
                    if (ctx->cur == p) break;
                    continue;
                L0007:;
                    ctx->cur = p;
                    pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                    break;
                }
            }
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "inside_equality", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "inside_equality", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_inside_comparison(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "inside_comparison", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_inside_genericCallLikeComparison, &chunk->thunks, NULL)) goto L0000;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            {
                int i;
                for (i = 0;; i++) {
                    const size_t p = ctx->cur;
                    const size_t n = chunk->thunks.len;
                    {
                        const size_t p = ctx->cur;
                        const size_t n = chunk->thunks.len;
                        if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0004;
                        goto L0003;
                    L0004:;
                        ctx->cur = p;
                        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_NL, &chunk->thunks, NULL)) goto L0005;
                        goto L0003;
                    L0005:;
                        ctx->cur = p;
                        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                        goto L0002;
                    L0003:;
                    }
                    if (ctx->cur == p) break;
                    continue;
                L0002:;
                    ctx->cur = p;
                    pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                    break;
                }
            }
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_comparisonOperator, &chunk->thunks, NULL)) goto L0001;
            {
                int i;
                for (i = 0;; i++) {
                    const size_t p = ctx->cur;
                    const size_t n = chunk->thunks.len;
                    if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0006;
                    if (ctx->cur == p) break;
                    continue;
                L0006:;
                    ctx->cur = p;
                    pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                    break;
                }
            }
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_inside_genericCallLikeComparison, &chunk->thunks, NULL)) goto L0001;
            {
                int i;
                for (i = 0;; i++) {
                    const size_t p = ctx->cur;
                    const size_t n = chunk->thunks.len;
                    {
                        const size_t p = ctx->cur;
                        const size_t n = chunk->thunks.len;
                        if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0009;
                        goto L0008;
                    L0009:;
                        ctx->cur = p;
                        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_NL, &chunk->thunks, NULL)) goto L0010;
                        goto L0008;
                    L0010:;
                        ctx->cur = p;
                        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                        goto L0007;
                    L0008:;
                    }
                    if (ctx->cur == p) break;
                    continue;
                L0007:;
                    ctx->cur = p;
                    pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                    break;
                }
            }
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "inside_comparison", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "inside_comparison", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_inside_genericCallLikeComparison(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "inside_genericCallLikeComparison", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_inside_infixOperation, &chunk->thunks, NULL)) goto L0000;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            {
                int i;
                for (i = 0;; i++) {
                    const size_t p = ctx->cur;
                    const size_t n = chunk->thunks.len;
                    {
                        const size_t p = ctx->cur;
                        const size_t n = chunk->thunks.len;
                        if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0004;
                        goto L0003;
                    L0004:;
                        ctx->cur = p;
                        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_NL, &chunk->thunks, NULL)) goto L0005;
                        goto L0003;
                    L0005:;
                        ctx->cur = p;
                        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                        goto L0002;
                    L0003:;
                    }
                    if (ctx->cur == p) break;
                    continue;
                L0002:;
                    ctx->cur = p;
                    pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                    break;
                }
            }
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_callSuffix, &chunk->thunks, NULL)) goto L0001;
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "inside_genericCallLikeComparison", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "inside_genericCallLikeComparison", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_inside_infixOperation(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "inside_infixOperation", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_inside_elvisExpression, &chunk->thunks, NULL)) goto L0000;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                {
                    int i;
                    for (i = 0;; i++) {
                        const size_t p = ctx->cur;
                        const size_t n = chunk->thunks.len;
                        {
                            const size_t p = ctx->cur;
                            const size_t n = chunk->thunks.len;
                            if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0006;
                            goto L0005;
                        L0006:;
                            ctx->cur = p;
                            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_NL, &chunk->thunks, NULL)) goto L0007;
                            goto L0005;
                        L0007:;
                            ctx->cur = p;
                            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                            goto L0004;
                        L0005:;
                        }
                        if (ctx->cur == p) break;
                        continue;
                    L0004:;
                        ctx->cur = p;
                        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                        break;
                    }
                }
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule_inOperator, &chunk->thunks, NULL)) goto L0003;
                {
                    int i;
                    for (i = 0;; i++) {
                        const size_t p = ctx->cur;
                        const size_t n = chunk->thunks.len;
                        if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0008;
                        if (ctx->cur == p) break;
                        continue;
                    L0008:;
                        ctx->cur = p;
                        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                        break;
                    }
                }
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule_inside_elvisExpression, &chunk->thunks, NULL)) goto L0003;
                goto L0002;
            L0003:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                {
                    int i;
                    for (i = 0;; i++) {
                        const size_t p = ctx->cur;
                        const size_t n = chunk->thunks.len;
                        {
                            const size_t p = ctx->cur;
                            const size_t n = chunk->thunks.len;
                            if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0012;
                            goto L0011;
                        L0012:;
                            ctx->cur = p;
                            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_NL, &chunk->thunks, NULL)) goto L0013;
                            goto L0011;
                        L0013:;
                            ctx->cur = p;
                            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                            goto L0010;
                        L0011:;
                        }
                        if (ctx->cur == p) break;
                        continue;
                    L0010:;
                        ctx->cur = p;
                        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                        break;
                    }
                }
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule_isOperator, &chunk->thunks, NULL)) goto L0009;
                {
                    int i;
                    for (i = 0;; i++) {
                        const size_t p = ctx->cur;
                        const size_t n = chunk->thunks.len;
                        if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0014;
                        if (ctx->cur == p) break;
                        continue;
                    L0014:;
                        ctx->cur = p;
                        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                        break;
                    }
                }
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule_type, &chunk->thunks, NULL)) goto L0009;
                goto L0002;
            L0009:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                goto L0001;
            L0002:;
            }
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "inside_infixOperation", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "inside_infixOperation", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_inside_elvisExpression(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "inside_elvisExpression", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_inside_infixFunctionCall, &chunk->thunks, NULL)) goto L0000;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            {
                int i;
                for (i = 0;; i++) {
                    const size_t p = ctx->cur;
                    const size_t n = chunk->thunks.len;
                    if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0002;
                    if (ctx->cur == p) break;
                    continue;
                L0002:;
                    ctx->cur = p;
                    pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                    break;
                }
            }
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_elvis, &chunk->thunks, NULL)) goto L0001;
            {
                int i;
                for (i = 0;; i++) {
                    const size_t p = ctx->cur;
                    const size_t n = chunk->thunks.len;
                    if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0003;
                    if (ctx->cur == p) break;
                    continue;
                L0003:;
                    ctx->cur = p;
                    pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                    break;
                }
            }
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_inside_infixFunctionCall, &chunk->thunks, NULL)) goto L0001;
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "inside_elvisExpression", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "inside_elvisExpression", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_inside_infixFunctionCall(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "inside_infixFunctionCall", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_inside_rangeExpression, &chunk->thunks, NULL)) goto L0000;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            {
                int i;
                for (i = 0;; i++) {
                    const size_t p = ctx->cur;
                    const size_t n = chunk->thunks.len;
                    {
                        const size_t p = ctx->cur;
                        const size_t n = chunk->thunks.len;
                        if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0004;
                        goto L0003;
                    L0004:;
                        ctx->cur = p;
                        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_NL, &chunk->thunks, NULL)) goto L0005;
                        goto L0003;
                    L0005:;
                        ctx->cur = p;
                        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                        goto L0002;
                    L0003:;
                    }
                    if (ctx->cur == p) break;
                    continue;
                L0002:;
                    ctx->cur = p;
                    pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                    break;
                }
            }
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_simpleIdentifier, &chunk->thunks, NULL)) goto L0001;
            {
                int i;
                for (i = 0;; i++) {
                    const size_t p = ctx->cur;
                    const size_t n = chunk->thunks.len;
                    if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0006;
                    if (ctx->cur == p) break;
                    continue;
                L0006:;
                    ctx->cur = p;
                    pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                    break;
                }
            }
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_inside_rangeExpression, &chunk->thunks, NULL)) goto L0001;
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "inside_infixFunctionCall", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "inside_infixFunctionCall", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_inside_rangeExpression(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "inside_rangeExpression", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_inside_additiveExpression, &chunk->thunks, NULL)) goto L0000;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            {
                int i;
                for (i = 0;; i++) {
                    const size_t p = ctx->cur;
                    const size_t n = chunk->thunks.len;
                    {
                        const size_t p = ctx->cur;
                        const size_t n = chunk->thunks.len;
                        if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0004;
                        goto L0003;
                    L0004:;
                        ctx->cur = p;
                        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_NL, &chunk->thunks, NULL)) goto L0005;
                        goto L0003;
                    L0005:;
                        ctx->cur = p;
                        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                        goto L0002;
                    L0003:;
                    }
                    if (ctx->cur == p) break;
                    continue;
                L0002:;
                    ctx->cur = p;
                    pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                    break;
                }
            }
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_RANGE, &chunk->thunks, NULL)) goto L0001;
            {
                int i;
                for (i = 0;; i++) {
                    const size_t p = ctx->cur;
                    const size_t n = chunk->thunks.len;
                    if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0006;
                    if (ctx->cur == p) break;
                    continue;
                L0006:;
                    ctx->cur = p;
                    pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                    break;
                }
            }
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_inside_additiveExpression, &chunk->thunks, NULL)) goto L0001;
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "inside_rangeExpression", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "inside_rangeExpression", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_inside_additiveExpression(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "inside_additiveExpression", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_inside_multiplicativeExpression, &chunk->thunks, NULL)) goto L0000;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            {
                int i;
                for (i = 0;; i++) {
                    const size_t p = ctx->cur;
                    const size_t n = chunk->thunks.len;
                    {
                        const size_t p = ctx->cur;
                        const size_t n = chunk->thunks.len;
                        if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0004;
                        goto L0003;
                    L0004:;
                        ctx->cur = p;
                        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_NL, &chunk->thunks, NULL)) goto L0005;
                        goto L0003;
                    L0005:;
                        ctx->cur = p;
                        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                        goto L0002;
                    L0003:;
                    }
                    if (ctx->cur == p) break;
                    continue;
                L0002:;
                    ctx->cur = p;
                    pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                    break;
                }
            }
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_additiveOperator, &chunk->thunks, NULL)) goto L0001;
            {
                int i;
                for (i = 0;; i++) {
                    const size_t p = ctx->cur;
                    const size_t n = chunk->thunks.len;
                    if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0006;
                    if (ctx->cur == p) break;
                    continue;
                L0006:;
                    ctx->cur = p;
                    pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                    break;
                }
            }
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_inside_multiplicativeExpression, &chunk->thunks, NULL)) goto L0001;
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "inside_additiveExpression", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "inside_additiveExpression", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_inside_multiplicativeExpression(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "inside_multiplicativeExpression", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_inside_asExpression, &chunk->thunks, NULL)) goto L0000;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            {
                int i;
                for (i = 0;; i++) {
                    const size_t p = ctx->cur;
                    const size_t n = chunk->thunks.len;
                    {
                        const size_t p = ctx->cur;
                        const size_t n = chunk->thunks.len;
                        if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0004;
                        goto L0003;
                    L0004:;
                        ctx->cur = p;
                        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_NL, &chunk->thunks, NULL)) goto L0005;
                        goto L0003;
                    L0005:;
                        ctx->cur = p;
                        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                        goto L0002;
                    L0003:;
                    }
                    if (ctx->cur == p) break;
                    continue;
                L0002:;
                    ctx->cur = p;
                    pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                    break;
                }
            }
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_multiplicativeOperator, &chunk->thunks, NULL)) goto L0001;
            {
                int i;
                for (i = 0;; i++) {
                    const size_t p = ctx->cur;
                    const size_t n = chunk->thunks.len;
                    if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0006;
                    if (ctx->cur == p) break;
                    continue;
                L0006:;
                    ctx->cur = p;
                    pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                    break;
                }
            }
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_inside_asExpression, &chunk->thunks, NULL)) goto L0001;
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "inside_multiplicativeExpression", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "inside_multiplicativeExpression", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_inside_asExpression(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "inside_asExpression", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_inside_prefixUnaryExpression, &chunk->thunks, NULL)) goto L0000;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            {
                int i;
                for (i = 0;; i++) {
                    const size_t p = ctx->cur;
                    const size_t n = chunk->thunks.len;
                    if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0002;
                    if (ctx->cur == p) break;
                    continue;
                L0002:;
                    ctx->cur = p;
                    pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                    break;
                }
            }
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_asOperator, &chunk->thunks, NULL)) goto L0001;
            {
                int i;
                for (i = 0;; i++) {
                    const size_t p = ctx->cur;
                    const size_t n = chunk->thunks.len;
                    if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0003;
                    if (ctx->cur == p) break;
                    continue;
                L0003:;
                    ctx->cur = p;
                    pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                    break;
                }
            }
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_type, &chunk->thunks, NULL)) goto L0001;
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "inside_asExpression", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "inside_asExpression", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_inside_prefixUnaryExpression(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "inside_prefixUnaryExpression", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_inside_unaryPrefix, &chunk->thunks, NULL)) goto L0001;
            {
                int i;
                for (i = 0;; i++) {
                    const size_t p = ctx->cur;
                    const size_t n = chunk->thunks.len;
                    {
                        const size_t p = ctx->cur;
                        const size_t n = chunk->thunks.len;
                        if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0004;
                        goto L0003;
                    L0004:;
                        ctx->cur = p;
                        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_NL, &chunk->thunks, NULL)) goto L0005;
                        goto L0003;
                    L0005:;
                        ctx->cur = p;
                        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                        goto L0002;
                    L0003:;
                    }
                    if (ctx->cur == p) break;
                    continue;
                L0002:;
                    ctx->cur = p;
                    pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                    break;
                }
            }
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_inside_postfixUnaryExpression, &chunk->thunks, NULL)) goto L0000;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "inside_prefixUnaryExpression", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "inside_prefixUnaryExpression", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_inside_unaryPrefix(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "inside_unaryPrefix", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_annotation, &chunk->thunks, NULL)) goto L0002;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_label, &chunk->thunks, NULL)) goto L0003;
        goto L0001;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_prefixUnaryOperator, &chunk->thunks, NULL)) goto L0004;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0005;
                if (ctx->cur == p) break;
                continue;
            L0005:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        goto L0001;
    L0004:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "inside_unaryPrefix", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "inside_unaryPrefix", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_inside_postfixUnaryExpression(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "inside_postfixUnaryExpression", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_primaryExpression, &chunk->thunks, NULL)) goto L0002;
        {
            const size_t p0 = ctx->cur;
            const size_t n0 = chunk->thunks.len;
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                {
                    int i;
                    for (i = 0;; i++) {
                        const size_t p = ctx->cur;
                        const size_t n = chunk->thunks.len;
                        {
                            const size_t p = ctx->cur;
                            const size_t n = chunk->thunks.len;
                            if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0006;
                            goto L0005;
                        L0006:;
                            ctx->cur = p;
                            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_NL, &chunk->thunks, NULL)) goto L0007;
                            goto L0005;
                        L0007:;
                            ctx->cur = p;
                            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                            goto L0004;
                        L0005:;
                        }
                        if (ctx->cur == p) break;
                        continue;
                    L0004:;
                        ctx->cur = p;
                        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                        break;
                    }
                }
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule_inside_postfixUnarySuffix, &chunk->thunks, NULL)) goto L0003;
                if (ctx->cur == p) break;
                continue;
            L0003:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
            if (i < 1) {
                ctx->cur = p0;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n0);
                goto L0002;
            }
        }
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_primaryExpression, &chunk->thunks, NULL)) goto L0008;
        goto L0001;
    L0008:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "inside_postfixUnaryExpression", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "inside_postfixUnaryExpression", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_inside_postfixUnarySuffix(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "inside_postfixUnarySuffix", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_postfixUnaryOperator, &chunk->thunks, NULL)) goto L0002;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_typeArguments, &chunk->thunks, NULL)) goto L0003;
        goto L0001;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_callSuffix, &chunk->thunks, NULL)) goto L0004;
        goto L0001;
    L0004:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_indexingSuffix, &chunk->thunks, NULL)) goto L0005;
        goto L0001;
    L0005:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_navigationSuffix, &chunk->thunks, NULL)) goto L0006;
        goto L0001;
    L0006:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "inside_postfixUnarySuffix", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "inside_postfixUnarySuffix", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_inside_directlyAssignableExpression(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "inside_directlyAssignableExpression", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_inside_postfixUnaryExpression, &chunk->thunks, NULL)) goto L0002;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                {
                    const size_t p = ctx->cur;
                    const size_t n = chunk->thunks.len;
                    if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0005;
                    goto L0004;
                L0005:;
                    ctx->cur = p;
                    pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_NL, &chunk->thunks, NULL)) goto L0006;
                    goto L0004;
                L0006:;
                    ctx->cur = p;
                    pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                    goto L0003;
                L0004:;
                }
                if (ctx->cur == p) break;
                continue;
            L0003:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_assignableSuffix, &chunk->thunks, NULL)) goto L0002;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_inside_postfixUnaryExpression, &chunk->thunks, NULL)) goto L0007;
        goto L0001;
    L0007:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_simpleIdentifier, &chunk->thunks, NULL)) goto L0008;
        goto L0001;
    L0008:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_parenthesizedDirectlyAssignableExpression, &chunk->thunks, NULL)) goto L0009;
        goto L0001;
    L0009:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "inside_directlyAssignableExpression", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "inside_directlyAssignableExpression", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_inside_assignableExpression(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "inside_assignableExpression", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_inside_prefixUnaryExpression, &chunk->thunks, NULL)) goto L0002;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_parenthesizedAssignableExpression, &chunk->thunks, NULL)) goto L0003;
        goto L0001;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "inside_assignableExpression", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "inside_assignableExpression", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_inside_valueArgument(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "inside_valueArgument", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_annotation, &chunk->thunks, NULL)) goto L0001;
        goto L0002;
    L0001:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0002:;
    }
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0003;
            if (ctx->cur == p) break;
            continue;
        L0003:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_simpleIdentifier, &chunk->thunks, NULL)) goto L0004;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0005;
                if (ctx->cur == p) break;
                continue;
            L0005:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_ASSIGNMENT, &chunk->thunks, NULL)) goto L0004;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0006;
                if (ctx->cur == p) break;
                continue;
            L0006:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        goto L0007;
    L0004:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0007:;
    }
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_MULT, &chunk->thunks, NULL)) goto L0008;
        goto L0009;
    L0008:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0009:;
    }
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0010;
            if (ctx->cur == p) break;
            continue;
        L0010:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_inside_expression, &chunk->thunks, NULL)) goto L0000;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "inside_valueArgument", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "inside_valueArgument", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_lambdaLiteral(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "lambdaLiteral", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_LCURL, &chunk->thunks, NULL)) goto L0002;
        {
            pcc_thunk_t *const thunk = pcc_thunk__create_leaf(ctx->auxil, pcc_action_lambdaLiteral_0, 0, 0);
            thunk->data.leaf.capt0.range.start = chunk->pos;
            thunk->data.leaf.capt0.range.end = ctx->cur;
            pcc_thunk_array__add(ctx->auxil, &chunk->thunks, thunk);
        }
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0003;
                if (ctx->cur == p) break;
                continue;
            L0003:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_statements, &chunk->thunks, NULL)) goto L0002;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0004;
                if (ctx->cur == p) break;
                continue;
            L0004:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_RCURL, &chunk->thunks, NULL)) goto L0002;
        {
            pcc_thunk_t *const thunk = pcc_thunk__create_leaf(ctx->auxil, pcc_action_lambdaLiteral_1, 0, 0);
            thunk->data.leaf.capt0.range.start = chunk->pos;
            thunk->data.leaf.capt0.range.end = ctx->cur;
            pcc_thunk_array__add(ctx->auxil, &chunk->thunks, thunk);
        }
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_LCURL, &chunk->thunks, NULL)) goto L0005;
        {
            pcc_thunk_t *const thunk = pcc_thunk__create_leaf(ctx->auxil, pcc_action_lambdaLiteral_2, 0, 0);
            thunk->data.leaf.capt0.range.start = chunk->pos;
            thunk->data.leaf.capt0.range.end = ctx->cur;
            pcc_thunk_array__add(ctx->auxil, &chunk->thunks, thunk);
        }
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0006;
                if (ctx->cur == p) break;
                continue;
            L0006:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_lambdaParameters, &chunk->thunks, NULL)) goto L0007;
            goto L0008;
        L0007:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        L0008:;
        }
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0009;
                if (ctx->cur == p) break;
                continue;
            L0009:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_ARROW, &chunk->thunks, NULL)) goto L0005;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0010;
                if (ctx->cur == p) break;
                continue;
            L0010:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_statements, &chunk->thunks, NULL)) goto L0005;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0011;
                if (ctx->cur == p) break;
                continue;
            L0011:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_RCURL, &chunk->thunks, NULL)) goto L0005;
        {
            pcc_thunk_t *const thunk = pcc_thunk__create_leaf(ctx->auxil, pcc_action_lambdaLiteral_3, 0, 0);
            thunk->data.leaf.capt0.range.start = chunk->pos;
            thunk->data.leaf.capt0.range.end = ctx->cur;
            pcc_thunk_array__add(ctx->auxil, &chunk->thunks, thunk);
        }
        goto L0001;
    L0005:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "lambdaLiteral", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "lambdaLiteral", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_lambdaParameters(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "lambdaParameters", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_lambdaParameter, &chunk->thunks, NULL)) goto L0000;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            {
                int i;
                for (i = 0;; i++) {
                    const size_t p = ctx->cur;
                    const size_t n = chunk->thunks.len;
                    if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0002;
                    if (ctx->cur == p) break;
                    continue;
                L0002:;
                    ctx->cur = p;
                    pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                    break;
                }
            }
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_COMMA, &chunk->thunks, NULL)) goto L0001;
            {
                int i;
                for (i = 0;; i++) {
                    const size_t p = ctx->cur;
                    const size_t n = chunk->thunks.len;
                    if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0003;
                    if (ctx->cur == p) break;
                    continue;
                L0003:;
                    ctx->cur = p;
                    pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                    break;
                }
            }
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_lambdaParameter, &chunk->thunks, NULL)) goto L0001;
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0005;
                if (ctx->cur == p) break;
                continue;
            L0005:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_COMMA, &chunk->thunks, NULL)) goto L0004;
        goto L0006;
    L0004:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0006:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "lambdaParameters", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "lambdaParameters", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_lambdaParameter(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "lambdaParameter", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_variableDeclaration, &chunk->thunks, NULL)) goto L0002;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_multiVariableDeclaration, &chunk->thunks, NULL)) goto L0003;
        {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            {
                int i;
                for (i = 0;; i++) {
                    const size_t p = ctx->cur;
                    const size_t n = chunk->thunks.len;
                    if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0005;
                    if (ctx->cur == p) break;
                    continue;
                L0005:;
                    ctx->cur = p;
                    pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                    break;
                }
            }
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_COLON, &chunk->thunks, NULL)) goto L0004;
            {
                int i;
                for (i = 0;; i++) {
                    const size_t p = ctx->cur;
                    const size_t n = chunk->thunks.len;
                    if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0006;
                    if (ctx->cur == p) break;
                    continue;
                L0006:;
                    ctx->cur = p;
                    pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                    break;
                }
            }
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_type, &chunk->thunks, NULL)) goto L0004;
            goto L0007;
        L0004:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        L0007:;
        }
        goto L0001;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "lambdaParameter", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "lambdaParameter", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_anonymousFunction(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "anonymousFunction", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_SUSPEND, &chunk->thunks, NULL)) goto L0001;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0002;
                if (ctx->cur == p) break;
                continue;
            L0002:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        goto L0003;
    L0001:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0003:;
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_FUN, &chunk->thunks, NULL)) goto L0000;
    {
        pcc_thunk_t *const thunk = pcc_thunk__create_leaf(ctx->auxil, pcc_action_anonymousFunction_0, 0, 0);
        thunk->data.leaf.capt0.range.start = chunk->pos;
        thunk->data.leaf.capt0.range.end = ctx->cur;
        pcc_thunk_array__add(ctx->auxil, &chunk->thunks, thunk);
    }
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0005;
                if (ctx->cur == p) break;
                continue;
            L0005:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_type, &chunk->thunks, NULL)) goto L0004;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0006;
                if (ctx->cur == p) break;
                continue;
            L0006:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_DOT, &chunk->thunks, NULL)) goto L0004;
        goto L0007;
    L0004:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0007:;
    }
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0008;
            if (ctx->cur == p) break;
            continue;
        L0008:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_parametersWithOptionalType, &chunk->thunks, NULL)) goto L0000;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0010;
                if (ctx->cur == p) break;
                continue;
            L0010:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_COLON, &chunk->thunks, NULL)) goto L0009;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0011;
                if (ctx->cur == p) break;
                continue;
            L0011:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_type, &chunk->thunks, NULL)) goto L0009;
        goto L0012;
    L0009:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0012:;
    }
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0014;
                if (ctx->cur == p) break;
                continue;
            L0014:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_typeConstraints, &chunk->thunks, NULL)) goto L0013;
        goto L0015;
    L0013:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0015:;
    }
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0017;
                if (ctx->cur == p) break;
                continue;
            L0017:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_functionBody, &chunk->thunks, NULL)) goto L0016;
        goto L0018;
    L0016:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0018:;
    }
    {
        pcc_thunk_t *const thunk = pcc_thunk__create_leaf(ctx->auxil, pcc_action_anonymousFunction_1, 0, 0);
        thunk->data.leaf.capt0.range.start = chunk->pos;
        thunk->data.leaf.capt0.range.end = ctx->cur;
        pcc_thunk_array__add(ctx->auxil, &chunk->thunks, thunk);
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "anonymousFunction", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "anonymousFunction", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_functionLiteral(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "functionLiteral", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_lambdaLiteral, &chunk->thunks, NULL)) goto L0002;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_anonymousFunction, &chunk->thunks, NULL)) goto L0003;
        goto L0001;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "functionLiteral", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "functionLiteral", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_objectLiteral(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "objectLiteral", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_DATA, &chunk->thunks, NULL)) goto L0003;
            {
                int i;
                for (i = 0;; i++) {
                    const size_t p = ctx->cur;
                    const size_t n = chunk->thunks.len;
                    if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0004;
                    if (ctx->cur == p) break;
                    continue;
                L0004:;
                    ctx->cur = p;
                    pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                    break;
                }
            }
            goto L0005;
        L0003:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        L0005:;
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_OBJECT, &chunk->thunks, NULL)) goto L0002;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0006;
                if (ctx->cur == p) break;
                continue;
            L0006:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_COLON, &chunk->thunks, NULL)) goto L0002;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0007;
                if (ctx->cur == p) break;
                continue;
            L0007:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_delegationSpecifiers, &chunk->thunks, NULL)) goto L0002;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0008;
                if (ctx->cur == p) break;
                continue;
            L0008:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_classBody, &chunk->thunks, NULL)) goto L0002;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_OBJECT, &chunk->thunks, NULL)) goto L0009;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0010;
                if (ctx->cur == p) break;
                continue;
            L0010:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_classBody, &chunk->thunks, NULL)) goto L0009;
        goto L0001;
    L0009:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "objectLiteral", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "objectLiteral", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_thisExpression(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "thisExpression", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_THIS_AT, &chunk->thunks, NULL)) goto L0002;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_THIS, &chunk->thunks, NULL)) goto L0003;
        {
            const size_t p = ctx->cur;
            {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule_Letter, &chunk->thunks, NULL)) goto L0006;
                goto L0005;
            L0006:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule_UnicodeDigit, &chunk->thunks, NULL)) goto L0007;
                goto L0005;
            L0007:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                goto L0004;
            L0005:;
            }
            ctx->cur = p;
            goto L0003;
        L0004:;
            ctx->cur = p;
        }
        goto L0001;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "thisExpression", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "thisExpression", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_superExpression(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "superExpression", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_SUPER_AT, &chunk->thunks, NULL)) goto L0002;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_SUPER, &chunk->thunks, NULL)) goto L0003;
        {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_LANGLE, &chunk->thunks, NULL)) goto L0004;
            {
                int i;
                for (i = 0;; i++) {
                    const size_t p = ctx->cur;
                    const size_t n = chunk->thunks.len;
                    if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0005;
                    if (ctx->cur == p) break;
                    continue;
                L0005:;
                    ctx->cur = p;
                    pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                    break;
                }
            }
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_type, &chunk->thunks, NULL)) goto L0004;
            {
                int i;
                for (i = 0;; i++) {
                    const size_t p = ctx->cur;
                    const size_t n = chunk->thunks.len;
                    if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0006;
                    if (ctx->cur == p) break;
                    continue;
                L0006:;
                    ctx->cur = p;
                    pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                    break;
                }
            }
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_RANGLE, &chunk->thunks, NULL)) goto L0004;
            goto L0007;
        L0004:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        L0007:;
        }
        {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_AT_NO_WS, &chunk->thunks, NULL)) goto L0008;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_simpleIdentifier, &chunk->thunks, NULL)) goto L0008;
            goto L0009;
        L0008:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        L0009:;
        }
        goto L0001;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "superExpression", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "superExpression", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_ifExpression(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "ifExpression", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_IF, &chunk->thunks, NULL)) goto L0002;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0003;
                if (ctx->cur == p) break;
                continue;
            L0003:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_LPAREN, &chunk->thunks, NULL)) goto L0002;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0004;
                if (ctx->cur == p) break;
                continue;
            L0004:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_expression, &chunk->thunks, NULL)) goto L0002;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0005;
                if (ctx->cur == p) break;
                continue;
            L0005:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_RPAREN, &chunk->thunks, NULL)) goto L0002;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0006;
                if (ctx->cur == p) break;
                continue;
            L0006:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_controlStructureBody, &chunk->thunks, NULL)) goto L0007;
            goto L0008;
        L0007:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        L0008:;
        }
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0009;
                if (ctx->cur == p) break;
                continue;
            L0009:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_SEMICOLON, &chunk->thunks, NULL)) goto L0010;
            goto L0011;
        L0010:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        L0011:;
        }
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0012;
                if (ctx->cur == p) break;
                continue;
            L0012:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_ELSE, &chunk->thunks, NULL)) goto L0002;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0013;
                if (ctx->cur == p) break;
                continue;
            L0013:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_controlStructureBody, &chunk->thunks, NULL)) goto L0015;
            goto L0014;
        L0015:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_SEMICOLON, &chunk->thunks, NULL)) goto L0016;
            goto L0014;
        L0016:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            goto L0002;
        L0014:;
        }
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_IF, &chunk->thunks, NULL)) goto L0017;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0018;
                if (ctx->cur == p) break;
                continue;
            L0018:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_LPAREN, &chunk->thunks, NULL)) goto L0017;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0019;
                if (ctx->cur == p) break;
                continue;
            L0019:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_expression, &chunk->thunks, NULL)) goto L0017;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0020;
                if (ctx->cur == p) break;
                continue;
            L0020:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_RPAREN, &chunk->thunks, NULL)) goto L0017;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0021;
                if (ctx->cur == p) break;
                continue;
            L0021:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_controlStructureBody, &chunk->thunks, NULL)) goto L0023;
            goto L0022;
        L0023:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_SEMICOLON, &chunk->thunks, NULL)) goto L0024;
            goto L0022;
        L0024:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            goto L0017;
        L0022:;
        }
        goto L0001;
    L0017:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "ifExpression", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "ifExpression", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_whenSubject(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "whenSubject", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_LPAREN, &chunk->thunks, NULL)) goto L0000;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule_annotation, &chunk->thunks, NULL)) goto L0002;
                if (ctx->cur == p) break;
                continue;
            L0002:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0003;
                if (ctx->cur == p) break;
                continue;
            L0003:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_VAL, &chunk->thunks, NULL)) goto L0001;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0004;
                if (ctx->cur == p) break;
                continue;
            L0004:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_variableDeclaration, &chunk->thunks, NULL)) goto L0001;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0005;
                if (ctx->cur == p) break;
                continue;
            L0005:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_ASSIGNMENT, &chunk->thunks, NULL)) goto L0001;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0006;
                if (ctx->cur == p) break;
                continue;
            L0006:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        goto L0007;
    L0001:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0007:;
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_expression, &chunk->thunks, NULL)) goto L0000;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_RPAREN, &chunk->thunks, NULL)) goto L0000;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "whenSubject", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "whenSubject", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_whenExpression(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "whenExpression", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_WHEN, &chunk->thunks, NULL)) goto L0000;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0001;
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_whenSubject, &chunk->thunks, NULL)) goto L0002;
        goto L0003;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0003:;
    }
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0004;
            if (ctx->cur == p) break;
            continue;
        L0004:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_LCURL, &chunk->thunks, NULL)) goto L0000;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0005;
            if (ctx->cur == p) break;
            continue;
        L0005:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_whenEntry, &chunk->thunks, NULL)) goto L0006;
            {
                int i;
                for (i = 0;; i++) {
                    const size_t p = ctx->cur;
                    const size_t n = chunk->thunks.len;
                    if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0007;
                    if (ctx->cur == p) break;
                    continue;
                L0007:;
                    ctx->cur = p;
                    pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                    break;
                }
            }
            if (ctx->cur == p) break;
            continue;
        L0006:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0008;
            if (ctx->cur == p) break;
            continue;
        L0008:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_RCURL, &chunk->thunks, NULL)) goto L0000;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "whenExpression", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "whenExpression", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_whenEntry(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "whenEntry", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_whenCondition, &chunk->thunks, NULL)) goto L0002;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                {
                    int i;
                    for (i = 0;; i++) {
                        const size_t p = ctx->cur;
                        const size_t n = chunk->thunks.len;
                        if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0004;
                        if (ctx->cur == p) break;
                        continue;
                    L0004:;
                        ctx->cur = p;
                        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                        break;
                    }
                }
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule_COMMA, &chunk->thunks, NULL)) goto L0003;
                {
                    int i;
                    for (i = 0;; i++) {
                        const size_t p = ctx->cur;
                        const size_t n = chunk->thunks.len;
                        if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0005;
                        if (ctx->cur == p) break;
                        continue;
                    L0005:;
                        ctx->cur = p;
                        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                        break;
                    }
                }
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule_whenCondition, &chunk->thunks, NULL)) goto L0003;
                if (ctx->cur == p) break;
                continue;
            L0003:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            {
                int i;
                for (i = 0;; i++) {
                    const size_t p = ctx->cur;
                    const size_t n = chunk->thunks.len;
                    if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0007;
                    if (ctx->cur == p) break;
                    continue;
                L0007:;
                    ctx->cur = p;
                    pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                    break;
                }
            }
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_COMMA, &chunk->thunks, NULL)) goto L0006;
            goto L0008;
        L0006:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        L0008:;
        }
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0009;
                if (ctx->cur == p) break;
                continue;
            L0009:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_ARROW, &chunk->thunks, NULL)) goto L0002;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0010;
                if (ctx->cur == p) break;
                continue;
            L0010:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_controlStructureBody, &chunk->thunks, NULL)) goto L0002;
        {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_semi, &chunk->thunks, NULL)) goto L0011;
            goto L0012;
        L0011:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        L0012:;
        }
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_ELSE, &chunk->thunks, NULL)) goto L0013;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0014;
                if (ctx->cur == p) break;
                continue;
            L0014:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_ARROW, &chunk->thunks, NULL)) goto L0013;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0015;
                if (ctx->cur == p) break;
                continue;
            L0015:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_controlStructureBody, &chunk->thunks, NULL)) goto L0013;
        {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_semi, &chunk->thunks, NULL)) goto L0016;
            goto L0017;
        L0016:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        L0017:;
        }
        goto L0001;
    L0013:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "whenEntry", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "whenEntry", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_whenCondition(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "whenCondition", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_expression, &chunk->thunks, NULL)) goto L0002;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_rangeTest, &chunk->thunks, NULL)) goto L0003;
        goto L0001;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_typeTest, &chunk->thunks, NULL)) goto L0004;
        goto L0001;
    L0004:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "whenCondition", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "whenCondition", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_rangeTest(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "rangeTest", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_inOperator, &chunk->thunks, NULL)) goto L0000;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0001;
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_expression, &chunk->thunks, NULL)) goto L0000;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "rangeTest", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "rangeTest", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_typeTest(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "typeTest", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_isOperator, &chunk->thunks, NULL)) goto L0000;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0001;
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_type, &chunk->thunks, NULL)) goto L0000;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "typeTest", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "typeTest", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_tryExpression(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "tryExpression", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_TRY, &chunk->thunks, NULL)) goto L0000;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0001;
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_block, &chunk->thunks, NULL)) goto L0000;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        {
            const size_t p0 = ctx->cur;
            const size_t n0 = chunk->thunks.len;
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                {
                    int i;
                    for (i = 0;; i++) {
                        const size_t p = ctx->cur;
                        const size_t n = chunk->thunks.len;
                        if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0005;
                        if (ctx->cur == p) break;
                        continue;
                    L0005:;
                        ctx->cur = p;
                        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                        break;
                    }
                }
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule_catchBlock, &chunk->thunks, NULL)) goto L0004;
                if (ctx->cur == p) break;
                continue;
            L0004:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
            if (i < 1) {
                ctx->cur = p0;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n0);
                goto L0003;
            }
        }
        {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            {
                int i;
                for (i = 0;; i++) {
                    const size_t p = ctx->cur;
                    const size_t n = chunk->thunks.len;
                    if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0007;
                    if (ctx->cur == p) break;
                    continue;
                L0007:;
                    ctx->cur = p;
                    pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                    break;
                }
            }
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_finallyBlock, &chunk->thunks, NULL)) goto L0006;
            goto L0008;
        L0006:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        L0008:;
        }
        goto L0002;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0010;
                if (ctx->cur == p) break;
                continue;
            L0010:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_finallyBlock, &chunk->thunks, NULL)) goto L0009;
        goto L0002;
    L0009:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0002:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "tryExpression", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "tryExpression", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_catchBlock(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "catchBlock", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_CATCH, &chunk->thunks, NULL)) goto L0000;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0001;
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_LPAREN, &chunk->thunks, NULL)) goto L0000;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0002;
            if (ctx->cur == p) break;
            continue;
        L0002:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_annotation, &chunk->thunks, NULL)) goto L0003;
            {
                int i;
                for (i = 0;; i++) {
                    const size_t p = ctx->cur;
                    const size_t n = chunk->thunks.len;
                    if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0004;
                    if (ctx->cur == p) break;
                    continue;
                L0004:;
                    ctx->cur = p;
                    pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                    break;
                }
            }
            if (ctx->cur == p) break;
            continue;
        L0003:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_simpleIdentifier, &chunk->thunks, NULL)) goto L0000;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0005;
            if (ctx->cur == p) break;
            continue;
        L0005:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_COLON, &chunk->thunks, NULL)) goto L0000;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0006;
            if (ctx->cur == p) break;
            continue;
        L0006:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_type, &chunk->thunks, NULL)) goto L0000;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0008;
                if (ctx->cur == p) break;
                continue;
            L0008:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_COMMA, &chunk->thunks, NULL)) goto L0007;
        goto L0009;
    L0007:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0009:;
    }
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0010;
            if (ctx->cur == p) break;
            continue;
        L0010:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_RPAREN, &chunk->thunks, NULL)) goto L0000;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0011;
            if (ctx->cur == p) break;
            continue;
        L0011:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_block, &chunk->thunks, NULL)) goto L0000;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "catchBlock", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "catchBlock", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_finallyBlock(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "finallyBlock", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_FINALLY, &chunk->thunks, NULL)) goto L0000;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0001;
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_block, &chunk->thunks, NULL)) goto L0000;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "finallyBlock", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "finallyBlock", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_jumpExpression(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "jumpExpression", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_THROW, &chunk->thunks, NULL)) goto L0002;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0003;
                if (ctx->cur == p) break;
                continue;
            L0003:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_expression, &chunk->thunks, NULL)) goto L0002;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_RETURN_AT, &chunk->thunks, NULL)) goto L0006;
            goto L0005;
        L0006:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_RETURN, &chunk->thunks, NULL)) goto L0007;
            goto L0005;
        L0007:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            goto L0004;
        L0005:;
        }
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0008;
                if (ctx->cur == p) break;
                continue;
            L0008:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_expression, &chunk->thunks, NULL)) goto L0009;
            goto L0010;
        L0009:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        L0010:;
        }
        goto L0001;
    L0004:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_CONTINUE_AT, &chunk->thunks, NULL)) goto L0011;
        goto L0001;
    L0011:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_CONTINUE, &chunk->thunks, NULL)) goto L0012;
        goto L0001;
    L0012:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_BREAK_AT, &chunk->thunks, NULL)) goto L0013;
        goto L0001;
    L0013:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_BREAK, &chunk->thunks, NULL)) goto L0014;
        goto L0001;
    L0014:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "jumpExpression", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "jumpExpression", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_callableReference(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "callableReference", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_receiverType, &chunk->thunks, NULL)) goto L0001;
        goto L0002;
    L0001:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0002:;
    }
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0003;
            if (ctx->cur == p) break;
            continue;
        L0003:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_COLONCOLON, &chunk->thunks, NULL)) goto L0000;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0004;
            if (ctx->cur == p) break;
            continue;
        L0004:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_simpleIdentifier, &chunk->thunks, NULL)) goto L0006;
        goto L0005;
    L0006:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_CLASS, &chunk->thunks, NULL)) goto L0007;
        goto L0005;
    L0007:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0005:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "callableReference", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "callableReference", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_assignmentAndOperator(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "assignmentAndOperator", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_ADD_ASSIGNMENT, &chunk->thunks, NULL)) goto L0002;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_SUB_ASSIGNMENT, &chunk->thunks, NULL)) goto L0003;
        goto L0001;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_MULT_ASSIGNMENT, &chunk->thunks, NULL)) goto L0004;
        goto L0001;
    L0004:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_DIV_ASSIGNMENT, &chunk->thunks, NULL)) goto L0005;
        goto L0001;
    L0005:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_MOD_ASSIGNMENT, &chunk->thunks, NULL)) goto L0006;
        goto L0001;
    L0006:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "assignmentAndOperator", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "assignmentAndOperator", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_equalityOperator(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "equalityOperator", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_EQEQEQ, &chunk->thunks, NULL)) goto L0002;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_EQEQ, &chunk->thunks, NULL)) goto L0003;
        goto L0001;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_EXCL_EQEQ, &chunk->thunks, NULL)) goto L0004;
        goto L0001;
    L0004:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_EXCL_EQ, &chunk->thunks, NULL)) goto L0005;
        goto L0001;
    L0005:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "equalityOperator", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "equalityOperator", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_comparisonOperator(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "comparisonOperator", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_LE, &chunk->thunks, NULL)) goto L0002;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_GE, &chunk->thunks, NULL)) goto L0003;
        goto L0001;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_LANGLE, &chunk->thunks, NULL)) goto L0004;
        goto L0001;
    L0004:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_RANGLE, &chunk->thunks, NULL)) goto L0005;
        goto L0001;
    L0005:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "comparisonOperator", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "comparisonOperator", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_inOperator(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "inOperator", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_IN, &chunk->thunks, NULL)) goto L0002;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_NOT_IN, &chunk->thunks, NULL)) goto L0003;
        goto L0001;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "inOperator", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "inOperator", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_isOperator(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "isOperator", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_IS, &chunk->thunks, NULL)) goto L0002;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_NOT_IS, &chunk->thunks, NULL)) goto L0003;
        goto L0001;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "isOperator", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "isOperator", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_additiveOperator(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "additiveOperator", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_ADD, &chunk->thunks, NULL)) goto L0002;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_SUB, &chunk->thunks, NULL)) goto L0003;
        goto L0001;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "additiveOperator", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "additiveOperator", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_multiplicativeOperator(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "multiplicativeOperator", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_MULT, &chunk->thunks, NULL)) goto L0002;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_DIV, &chunk->thunks, NULL)) goto L0003;
        goto L0001;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_MOD, &chunk->thunks, NULL)) goto L0004;
        goto L0001;
    L0004:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "multiplicativeOperator", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "multiplicativeOperator", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_asOperator(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "asOperator", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_AS_SAFE, &chunk->thunks, NULL)) goto L0002;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_AS, &chunk->thunks, NULL)) goto L0003;
        goto L0001;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "asOperator", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "asOperator", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_prefixUnaryOperator(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "prefixUnaryOperator", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_INCR, &chunk->thunks, NULL)) goto L0002;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_DECR, &chunk->thunks, NULL)) goto L0003;
        goto L0001;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_SUB, &chunk->thunks, NULL)) goto L0004;
        goto L0001;
    L0004:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_ADD, &chunk->thunks, NULL)) goto L0005;
        goto L0001;
    L0005:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_excl, &chunk->thunks, NULL)) goto L0006;
        goto L0001;
    L0006:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "prefixUnaryOperator", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "prefixUnaryOperator", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_postfixUnaryOperator(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "postfixUnaryOperator", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_INCR, &chunk->thunks, NULL)) goto L0002;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_DECR, &chunk->thunks, NULL)) goto L0003;
        goto L0001;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_EXCL_NO_WS, &chunk->thunks, NULL)) goto L0004;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_excl, &chunk->thunks, NULL)) goto L0004;
        goto L0001;
    L0004:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "postfixUnaryOperator", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "postfixUnaryOperator", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_excl(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "excl", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_EXCL_WS, &chunk->thunks, NULL)) goto L0002;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_EXCL_NO_WS, &chunk->thunks, NULL)) goto L0003;
        goto L0001;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "excl", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "excl", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_memberAccessOperator(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "memberAccessOperator", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_DOT, &chunk->thunks, NULL)) goto L0002;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_safeNav, &chunk->thunks, NULL)) goto L0003;
        goto L0001;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_COLONCOLON, &chunk->thunks, NULL)) goto L0004;
        goto L0001;
    L0004:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "memberAccessOperator", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "memberAccessOperator", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_safeNav(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "safeNav", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_QUEST_NO_WS, &chunk->thunks, NULL)) goto L0000;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_DOT, &chunk->thunks, NULL)) goto L0000;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "safeNav", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "safeNav", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_modifiers(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "modifiers", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p0 = ctx->cur;
        const size_t n0 = chunk->thunks.len;
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule_annotation, &chunk->thunks, NULL)) goto L0003;
                goto L0002;
            L0003:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule_modifier, &chunk->thunks, NULL)) goto L0004;
                goto L0002;
            L0004:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                goto L0001;
            L0002:;
            }
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
        if (i < 1) {
            ctx->cur = p0;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n0);
            goto L0000;
        }
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "modifiers", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "modifiers", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_parameterModifiers(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "parameterModifiers", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p0 = ctx->cur;
        const size_t n0 = chunk->thunks.len;
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule_annotation, &chunk->thunks, NULL)) goto L0003;
                goto L0002;
            L0003:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule_parameterModifier, &chunk->thunks, NULL)) goto L0004;
                goto L0002;
            L0004:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                goto L0001;
            L0002:;
            }
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
        if (i < 1) {
            ctx->cur = p0;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n0);
            goto L0000;
        }
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "parameterModifiers", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "parameterModifiers", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_modifier(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "modifier", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_classModifier, &chunk->thunks, NULL)) goto L0002;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_memberModifier, &chunk->thunks, NULL)) goto L0003;
        goto L0001;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_visibilityModifier, &chunk->thunks, NULL)) goto L0004;
        goto L0001;
    L0004:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_functionModifier, &chunk->thunks, NULL)) goto L0005;
        goto L0001;
    L0005:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_propertyModifier, &chunk->thunks, NULL)) goto L0006;
        goto L0001;
    L0006:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_inheritanceModifier, &chunk->thunks, NULL)) goto L0007;
        goto L0001;
    L0007:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_parameterModifier, &chunk->thunks, NULL)) goto L0008;
        goto L0001;
    L0008:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_platformModifier, &chunk->thunks, NULL)) goto L0009;
        goto L0001;
    L0009:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0010;
            if (ctx->cur == p) break;
            continue;
        L0010:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "modifier", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "modifier", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_typeModifiers(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "typeModifiers", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p0 = ctx->cur;
        const size_t n0 = chunk->thunks.len;
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_typeModifier, &chunk->thunks, NULL)) goto L0001;
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
        if (i < 1) {
            ctx->cur = p0;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n0);
            goto L0000;
        }
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "typeModifiers", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "typeModifiers", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_typeModifier(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "typeModifier", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_annotation, &chunk->thunks, NULL)) goto L0002;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_SUSPEND, &chunk->thunks, NULL)) goto L0003;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0004;
                if (ctx->cur == p) break;
                continue;
            L0004:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        goto L0001;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "typeModifier", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "typeModifier", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_classModifier(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "classModifier", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_ENUM, &chunk->thunks, NULL)) goto L0002;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_SEALED, &chunk->thunks, NULL)) goto L0003;
        goto L0001;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_ANNOTATION, &chunk->thunks, NULL)) goto L0004;
        goto L0001;
    L0004:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_DATA, &chunk->thunks, NULL)) goto L0005;
        goto L0001;
    L0005:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_INNER, &chunk->thunks, NULL)) goto L0006;
        goto L0001;
    L0006:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "classModifier", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "classModifier", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_memberModifier(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "memberModifier", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_OVERRIDE, &chunk->thunks, NULL)) goto L0002;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_LATEINIT, &chunk->thunks, NULL)) goto L0003;
        goto L0001;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "memberModifier", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "memberModifier", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_visibilityModifier(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "visibilityModifier", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_PUBLIC, &chunk->thunks, NULL)) goto L0002;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_PRIVATE, &chunk->thunks, NULL)) goto L0003;
        goto L0001;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_INTERNAL, &chunk->thunks, NULL)) goto L0004;
        goto L0001;
    L0004:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_PROTECTED, &chunk->thunks, NULL)) goto L0005;
        goto L0001;
    L0005:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "visibilityModifier", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "visibilityModifier", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_varianceModifier(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "varianceModifier", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_IN, &chunk->thunks, NULL)) goto L0002;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_OUT, &chunk->thunks, NULL)) goto L0003;
        goto L0001;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "varianceModifier", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "varianceModifier", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_typeParameterModifiers(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "typeParameterModifiers", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p0 = ctx->cur;
        const size_t n0 = chunk->thunks.len;
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_typeParameterModifier, &chunk->thunks, NULL)) goto L0001;
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
        if (i < 1) {
            ctx->cur = p0;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n0);
            goto L0000;
        }
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "typeParameterModifiers", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "typeParameterModifiers", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_typeParameterModifier(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "typeParameterModifier", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_reificationModifier, &chunk->thunks, NULL)) goto L0002;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0003;
                if (ctx->cur == p) break;
                continue;
            L0003:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_varianceModifier, &chunk->thunks, NULL)) goto L0004;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0005;
                if (ctx->cur == p) break;
                continue;
            L0005:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        goto L0001;
    L0004:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_annotation, &chunk->thunks, NULL)) goto L0006;
        goto L0001;
    L0006:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "typeParameterModifier", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "typeParameterModifier", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_functionModifier(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "functionModifier", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_TAILREC, &chunk->thunks, NULL)) goto L0002;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_OPERATOR, &chunk->thunks, NULL)) goto L0003;
        goto L0001;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_INFIX, &chunk->thunks, NULL)) goto L0004;
        goto L0001;
    L0004:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_INLINE, &chunk->thunks, NULL)) goto L0005;
        goto L0001;
    L0005:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_EXTERNAL, &chunk->thunks, NULL)) goto L0006;
        goto L0001;
    L0006:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_SUSPEND, &chunk->thunks, NULL)) goto L0007;
        goto L0001;
    L0007:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "functionModifier", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "functionModifier", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_propertyModifier(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "propertyModifier", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_CONST, &chunk->thunks, NULL)) goto L0000;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "propertyModifier", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "propertyModifier", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_inheritanceModifier(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "inheritanceModifier", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_ABSTRACT, &chunk->thunks, NULL)) goto L0002;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_FINAL, &chunk->thunks, NULL)) goto L0003;
        goto L0001;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_OPEN, &chunk->thunks, NULL)) goto L0004;
        goto L0001;
    L0004:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "inheritanceModifier", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "inheritanceModifier", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_parameterModifier(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "parameterModifier", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_VARARG, &chunk->thunks, NULL)) goto L0002;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_NOINLINE, &chunk->thunks, NULL)) goto L0003;
        goto L0001;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_CROSSINLINE, &chunk->thunks, NULL)) goto L0004;
        goto L0001;
    L0004:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "parameterModifier", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "parameterModifier", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_reificationModifier(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "reificationModifier", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_REIFIED, &chunk->thunks, NULL)) goto L0000;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "reificationModifier", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "reificationModifier", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_platformModifier(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "platformModifier", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_EXPECT, &chunk->thunks, NULL)) goto L0002;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_ACTUAL, &chunk->thunks, NULL)) goto L0003;
        goto L0001;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "platformModifier", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "platformModifier", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_annotation(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "annotation", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_singleAnnotation, &chunk->thunks, NULL)) goto L0002;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_multiAnnotation, &chunk->thunks, NULL)) goto L0003;
        goto L0001;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0004;
            if (ctx->cur == p) break;
            continue;
        L0004:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "annotation", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "annotation", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_singleAnnotation(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "singleAnnotation", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_annotationUseSiteTarget, &chunk->thunks, NULL)) goto L0002;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0003;
                if (ctx->cur == p) break;
                continue;
            L0003:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_unescapedAnnotation, &chunk->thunks, NULL)) goto L0002;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_AT_NO_WS, &chunk->thunks, NULL)) goto L0006;
            goto L0005;
        L0006:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_AT_PRE_WS, &chunk->thunks, NULL)) goto L0007;
            goto L0005;
        L0007:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            goto L0004;
        L0005:;
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_unescapedAnnotation, &chunk->thunks, NULL)) goto L0004;
        goto L0001;
    L0004:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "singleAnnotation", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "singleAnnotation", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_multiAnnotation(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "multiAnnotation", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_annotationUseSiteTarget, &chunk->thunks, NULL)) goto L0002;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0003;
                if (ctx->cur == p) break;
                continue;
            L0003:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_LSQUARE, &chunk->thunks, NULL)) goto L0002;
        {
            const size_t p0 = ctx->cur;
            const size_t n0 = chunk->thunks.len;
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule_unescapedAnnotation, &chunk->thunks, NULL)) goto L0004;
                if (ctx->cur == p) break;
                continue;
            L0004:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
            if (i < 1) {
                ctx->cur = p0;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n0);
                goto L0002;
            }
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_RSQUARE, &chunk->thunks, NULL)) goto L0002;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_AT_NO_WS, &chunk->thunks, NULL)) goto L0007;
            goto L0006;
        L0007:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_AT_PRE_WS, &chunk->thunks, NULL)) goto L0008;
            goto L0006;
        L0008:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            goto L0005;
        L0006:;
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_LSQUARE, &chunk->thunks, NULL)) goto L0005;
        {
            const size_t p0 = ctx->cur;
            const size_t n0 = chunk->thunks.len;
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule_unescapedAnnotation, &chunk->thunks, NULL)) goto L0009;
                if (ctx->cur == p) break;
                continue;
            L0009:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
            if (i < 1) {
                ctx->cur = p0;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n0);
                goto L0005;
            }
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_RSQUARE, &chunk->thunks, NULL)) goto L0005;
        goto L0001;
    L0005:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "multiAnnotation", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "multiAnnotation", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_annotationUseSiteTarget(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "annotationUseSiteTarget", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_AT_NO_WS, &chunk->thunks, NULL)) goto L0002;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_AT_PRE_WS, &chunk->thunks, NULL)) goto L0003;
        goto L0001;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_FIELD, &chunk->thunks, NULL)) goto L0005;
        goto L0004;
    L0005:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_PROPERTY, &chunk->thunks, NULL)) goto L0006;
        goto L0004;
    L0006:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_GET, &chunk->thunks, NULL)) goto L0007;
        goto L0004;
    L0007:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_SET, &chunk->thunks, NULL)) goto L0008;
        goto L0004;
    L0008:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_RECEIVER, &chunk->thunks, NULL)) goto L0009;
        goto L0004;
    L0009:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_PARAM, &chunk->thunks, NULL)) goto L0010;
        goto L0004;
    L0010:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_SETPARAM, &chunk->thunks, NULL)) goto L0011;
        goto L0004;
    L0011:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_DELEGATE, &chunk->thunks, NULL)) goto L0012;
        goto L0004;
    L0012:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0004:;
    }
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0013;
            if (ctx->cur == p) break;
            continue;
        L0013:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_COLON, &chunk->thunks, NULL)) goto L0000;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "annotationUseSiteTarget", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "annotationUseSiteTarget", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_unescapedAnnotation(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "unescapedAnnotation", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_constructorInvocation, &chunk->thunks, NULL)) goto L0002;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_userType, &chunk->thunks, NULL)) goto L0003;
        goto L0001;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "unescapedAnnotation", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "unescapedAnnotation", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_simpleIdentifier(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "simpleIdentifier", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        {
            const size_t p = ctx->cur;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_hardKeyword, &chunk->thunks, NULL)) goto L0003;
            {
                const size_t p = ctx->cur;
                {
                    const size_t p = ctx->cur;
                    const size_t n = chunk->thunks.len;
                    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_Letter, &chunk->thunks, NULL)) goto L0006;
                    goto L0005;
                L0006:;
                    ctx->cur = p;
                    pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                    if (
                        pcc_refill_buffer(ctx, 1) < 1 ||
                        ctx->buffer.buf[ctx->cur] != '_'
                    ) goto L0007;
                    ctx->cur++;
                    goto L0005;
                L0007:;
                    ctx->cur = p;
                    pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_UnicodeDigit, &chunk->thunks, NULL)) goto L0008;
                    goto L0005;
                L0008:;
                    ctx->cur = p;
                    pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                    goto L0004;
                L0005:;
                }
                ctx->cur = p;
                goto L0003;
            L0004:;
                ctx->cur = p;
            }
            ctx->cur = p;
            goto L0002;
        L0003:;
            ctx->cur = p;
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_Identifier, &chunk->thunks, NULL)) goto L0002;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_ABSTRACT, &chunk->thunks, NULL)) goto L0009;
        goto L0001;
    L0009:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_ANNOTATION, &chunk->thunks, NULL)) goto L0010;
        goto L0001;
    L0010:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_BY, &chunk->thunks, NULL)) goto L0011;
        goto L0001;
    L0011:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_CATCH, &chunk->thunks, NULL)) goto L0012;
        goto L0001;
    L0012:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_COMPANION, &chunk->thunks, NULL)) goto L0013;
        goto L0001;
    L0013:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_CONSTRUCTOR, &chunk->thunks, NULL)) goto L0014;
        goto L0001;
    L0014:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_CROSSINLINE, &chunk->thunks, NULL)) goto L0015;
        goto L0001;
    L0015:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_DATA, &chunk->thunks, NULL)) goto L0016;
        goto L0001;
    L0016:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_DYNAMIC, &chunk->thunks, NULL)) goto L0017;
        goto L0001;
    L0017:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_ENUM, &chunk->thunks, NULL)) goto L0018;
        goto L0001;
    L0018:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_EXTERNAL, &chunk->thunks, NULL)) goto L0019;
        goto L0001;
    L0019:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_FINAL, &chunk->thunks, NULL)) goto L0020;
        goto L0001;
    L0020:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_FINALLY, &chunk->thunks, NULL)) goto L0021;
        goto L0001;
    L0021:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_GET, &chunk->thunks, NULL)) goto L0022;
        goto L0001;
    L0022:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_IMPORT, &chunk->thunks, NULL)) goto L0023;
        goto L0001;
    L0023:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_INFIX, &chunk->thunks, NULL)) goto L0024;
        goto L0001;
    L0024:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_INIT, &chunk->thunks, NULL)) goto L0025;
        goto L0001;
    L0025:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_INLINE, &chunk->thunks, NULL)) goto L0026;
        goto L0001;
    L0026:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_INNER, &chunk->thunks, NULL)) goto L0027;
        goto L0001;
    L0027:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_INTERNAL, &chunk->thunks, NULL)) goto L0028;
        goto L0001;
    L0028:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_LATEINIT, &chunk->thunks, NULL)) goto L0029;
        goto L0001;
    L0029:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_NOINLINE, &chunk->thunks, NULL)) goto L0030;
        goto L0001;
    L0030:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_OPEN, &chunk->thunks, NULL)) goto L0031;
        goto L0001;
    L0031:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_OPERATOR, &chunk->thunks, NULL)) goto L0032;
        goto L0001;
    L0032:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_OUT, &chunk->thunks, NULL)) goto L0033;
        goto L0001;
    L0033:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_OVERRIDE, &chunk->thunks, NULL)) goto L0034;
        goto L0001;
    L0034:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_PRIVATE, &chunk->thunks, NULL)) goto L0035;
        goto L0001;
    L0035:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_PROTECTED, &chunk->thunks, NULL)) goto L0036;
        goto L0001;
    L0036:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_PUBLIC, &chunk->thunks, NULL)) goto L0037;
        goto L0001;
    L0037:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_REIFIED, &chunk->thunks, NULL)) goto L0038;
        goto L0001;
    L0038:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_SEALED, &chunk->thunks, NULL)) goto L0039;
        goto L0001;
    L0039:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_TAILREC, &chunk->thunks, NULL)) goto L0040;
        goto L0001;
    L0040:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_SET, &chunk->thunks, NULL)) goto L0041;
        goto L0001;
    L0041:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_VARARG, &chunk->thunks, NULL)) goto L0042;
        goto L0001;
    L0042:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_WHERE, &chunk->thunks, NULL)) goto L0043;
        goto L0001;
    L0043:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_FIELD, &chunk->thunks, NULL)) goto L0044;
        goto L0001;
    L0044:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_PROPERTY, &chunk->thunks, NULL)) goto L0045;
        goto L0001;
    L0045:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_RECEIVER, &chunk->thunks, NULL)) goto L0046;
        goto L0001;
    L0046:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_PARAM, &chunk->thunks, NULL)) goto L0047;
        goto L0001;
    L0047:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_SETPARAM, &chunk->thunks, NULL)) goto L0048;
        goto L0001;
    L0048:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_DELEGATE, &chunk->thunks, NULL)) goto L0049;
        goto L0001;
    L0049:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_FILE, &chunk->thunks, NULL)) goto L0050;
        goto L0001;
    L0050:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_EXPECT, &chunk->thunks, NULL)) goto L0051;
        goto L0001;
    L0051:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_ACTUAL, &chunk->thunks, NULL)) goto L0052;
        goto L0001;
    L0052:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_CONST, &chunk->thunks, NULL)) goto L0053;
        goto L0001;
    L0053:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_SUSPEND, &chunk->thunks, NULL)) goto L0054;
        goto L0001;
    L0054:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "simpleIdentifier", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "simpleIdentifier", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_identifier(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "identifier", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_simpleIdentifier, &chunk->thunks, NULL)) goto L0000;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            {
                int i;
                for (i = 0;; i++) {
                    const size_t p = ctx->cur;
                    const size_t n = chunk->thunks.len;
                    if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0002;
                    if (ctx->cur == p) break;
                    continue;
                L0002:;
                    ctx->cur = p;
                    pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                    break;
                }
            }
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_DOT, &chunk->thunks, NULL)) goto L0001;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_simpleIdentifier, &chunk->thunks, NULL)) goto L0001;
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "identifier", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "identifier", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_hardKeyword(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "hardKeyword", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_AS, &chunk->thunks, NULL)) goto L0002;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_BREAK, &chunk->thunks, NULL)) goto L0003;
        goto L0001;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_CLASS, &chunk->thunks, NULL)) goto L0004;
        goto L0001;
    L0004:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_CONTINUE, &chunk->thunks, NULL)) goto L0005;
        goto L0001;
    L0005:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_DO, &chunk->thunks, NULL)) goto L0006;
        goto L0001;
    L0006:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_ELSE, &chunk->thunks, NULL)) goto L0007;
        goto L0001;
    L0007:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_FOR, &chunk->thunks, NULL)) goto L0008;
        goto L0001;
    L0008:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_FUN, &chunk->thunks, NULL)) goto L0009;
        goto L0001;
    L0009:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_IF, &chunk->thunks, NULL)) goto L0010;
        goto L0001;
    L0010:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_IN, &chunk->thunks, NULL)) goto L0011;
        goto L0001;
    L0011:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_INTERFACE, &chunk->thunks, NULL)) goto L0012;
        goto L0001;
    L0012:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_IS, &chunk->thunks, NULL)) goto L0013;
        goto L0001;
    L0013:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_NullLiteral, &chunk->thunks, NULL)) goto L0014;
        goto L0001;
    L0014:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_OBJECT, &chunk->thunks, NULL)) goto L0015;
        goto L0001;
    L0015:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_PACKAGE, &chunk->thunks, NULL)) goto L0016;
        goto L0001;
    L0016:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_RETURN, &chunk->thunks, NULL)) goto L0017;
        goto L0001;
    L0017:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_SUPER, &chunk->thunks, NULL)) goto L0018;
        goto L0001;
    L0018:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_THIS, &chunk->thunks, NULL)) goto L0019;
        goto L0001;
    L0019:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_THROW, &chunk->thunks, NULL)) goto L0020;
        goto L0001;
    L0020:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_TRY, &chunk->thunks, NULL)) goto L0021;
        goto L0001;
    L0021:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_TYPE_ALIAS, &chunk->thunks, NULL)) goto L0022;
        goto L0001;
    L0022:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_TYPEOF, &chunk->thunks, NULL)) goto L0023;
        goto L0001;
    L0023:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_VAL, &chunk->thunks, NULL)) goto L0024;
        goto L0001;
    L0024:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_VAR, &chunk->thunks, NULL)) goto L0025;
        goto L0001;
    L0025:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_WHEN, &chunk->thunks, NULL)) goto L0026;
        goto L0001;
    L0026:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_WHILE, &chunk->thunks, NULL)) goto L0027;
        goto L0001;
    L0027:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_BooleanLiteral, &chunk->thunks, NULL)) goto L0028;
        goto L0001;
    L0028:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "hardKeyword", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "hardKeyword", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_ShebangLine(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "ShebangLine", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 2) < 2 ||
        (ctx->buffer.buf + ctx->cur)[0] != '#' ||
        (ctx->buffer.buf + ctx->cur)[1] != '!'
    ) goto L0000;
    ctx->cur += 2;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            {
                int u;
                const size_t n = pcc_get_char_as_utf32(ctx, &u);
                if (n == 0) goto L0001;
                if (
                    u == 0x00000d ||
                    u == 0x00000a
                ) goto L0001;
                ctx->cur += n;
            }
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "ShebangLine", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "ShebangLine", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_DelimitedComment(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "DelimitedComment", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 2) < 2 ||
        (ctx->buffer.buf + ctx->cur)[0] != '/' ||
        (ctx->buffer.buf + ctx->cur)[1] != '*'
    ) goto L0000;
    ctx->cur += 2;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule_DelimitedComment, &chunk->thunks, NULL)) goto L0003;
                goto L0002;
            L0003:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                {
                    const size_t p = ctx->cur;
                    if (
                        pcc_refill_buffer(ctx, 2) < 2 ||
                        (ctx->buffer.buf + ctx->cur)[0] != '*' ||
                        (ctx->buffer.buf + ctx->cur)[1] != '/'
                    ) goto L0005;
                    ctx->cur += 2;
                    ctx->cur = p;
                    goto L0004;
                L0005:;
                    ctx->cur = p;
                }
                {
                    int u;
                    const size_t n = pcc_get_char_as_utf32(ctx, &u);
                    if (n == 0) goto L0004;
                    ctx->cur += n;
                }
                goto L0002;
            L0004:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                goto L0001;
            L0002:;
            }
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    if (
        pcc_refill_buffer(ctx, 2) < 2 ||
        (ctx->buffer.buf + ctx->cur)[0] != '*' ||
        (ctx->buffer.buf + ctx->cur)[1] != '/'
    ) goto L0000;
    ctx->cur += 2;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "DelimitedComment", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "DelimitedComment", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_LineComment(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "LineComment", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 2) < 2 ||
        (ctx->buffer.buf + ctx->cur)[0] != '/' ||
        (ctx->buffer.buf + ctx->cur)[1] != '/'
    ) goto L0000;
    ctx->cur += 2;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            {
                int u;
                const size_t n = pcc_get_char_as_utf32(ctx, &u);
                if (n == 0) goto L0001;
                if (
                    u == 0x00000d ||
                    u == 0x00000a
                ) goto L0001;
                ctx->cur += n;
            }
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "LineComment", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "LineComment", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_Hidden(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "Hidden", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_DelimitedComment, &chunk->thunks, NULL)) goto L0002;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_LineComment, &chunk->thunks, NULL)) goto L0003;
        goto L0001;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_WS, &chunk->thunks, NULL)) goto L0004;
        goto L0001;
    L0004:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "Hidden", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "Hidden", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_DOT(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "DOT", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 1) < 1 ||
        ctx->buffer.buf[ctx->cur] != '.'
    ) goto L0000;
    ctx->cur++;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "DOT", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "DOT", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_COMMA(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "COMMA", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 1) < 1 ||
        ctx->buffer.buf[ctx->cur] != ','
    ) goto L0000;
    ctx->cur++;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "COMMA", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "COMMA", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_LPAREN(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "LPAREN", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 1) < 1 ||
        ctx->buffer.buf[ctx->cur] != '('
    ) goto L0000;
    ctx->cur++;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "LPAREN", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "LPAREN", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_RPAREN(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "RPAREN", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 1) < 1 ||
        ctx->buffer.buf[ctx->cur] != ')'
    ) goto L0000;
    ctx->cur++;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "RPAREN", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "RPAREN", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_LSQUARE(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "LSQUARE", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 1) < 1 ||
        ctx->buffer.buf[ctx->cur] != '['
    ) goto L0000;
    ctx->cur++;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "LSQUARE", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "LSQUARE", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_RSQUARE(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "RSQUARE", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 1) < 1 ||
        ctx->buffer.buf[ctx->cur] != ']'
    ) goto L0000;
    ctx->cur++;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "RSQUARE", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "RSQUARE", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_LCURL(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "LCURL", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 1) < 1 ||
        ctx->buffer.buf[ctx->cur] != '{'
    ) goto L0000;
    ctx->cur++;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "LCURL", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "LCURL", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_RCURL(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "RCURL", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 1) < 1 ||
        ctx->buffer.buf[ctx->cur] != '}'
    ) goto L0000;
    ctx->cur++;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "RCURL", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "RCURL", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_MULT(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "MULT", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 1) < 1 ||
        ctx->buffer.buf[ctx->cur] != '*'
    ) goto L0000;
    ctx->cur++;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "MULT", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "MULT", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_MOD(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "MOD", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 1) < 1 ||
        ctx->buffer.buf[ctx->cur] != '%'
    ) goto L0000;
    ctx->cur++;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "MOD", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "MOD", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_DIV(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "DIV", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 1) < 1 ||
        ctx->buffer.buf[ctx->cur] != '/'
    ) goto L0000;
    ctx->cur++;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "DIV", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "DIV", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_ADD(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "ADD", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 1) < 1 ||
        ctx->buffer.buf[ctx->cur] != '+'
    ) goto L0000;
    ctx->cur++;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "ADD", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "ADD", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_SUB(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "SUB", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 1) < 1 ||
        ctx->buffer.buf[ctx->cur] != '-'
    ) goto L0000;
    ctx->cur++;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "SUB", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "SUB", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_INCR(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "INCR", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 2) < 2 ||
        (ctx->buffer.buf + ctx->cur)[0] != '+' ||
        (ctx->buffer.buf + ctx->cur)[1] != '+'
    ) goto L0000;
    ctx->cur += 2;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "INCR", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "INCR", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_DECR(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "DECR", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 2) < 2 ||
        (ctx->buffer.buf + ctx->cur)[0] != '-' ||
        (ctx->buffer.buf + ctx->cur)[1] != '-'
    ) goto L0000;
    ctx->cur += 2;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "DECR", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "DECR", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_CONJ(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "CONJ", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 2) < 2 ||
        (ctx->buffer.buf + ctx->cur)[0] != '&' ||
        (ctx->buffer.buf + ctx->cur)[1] != '&'
    ) goto L0000;
    ctx->cur += 2;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "CONJ", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "CONJ", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_DISJ(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "DISJ", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 2) < 2 ||
        (ctx->buffer.buf + ctx->cur)[0] != '|' ||
        (ctx->buffer.buf + ctx->cur)[1] != '|'
    ) goto L0000;
    ctx->cur += 2;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "DISJ", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "DISJ", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_EXCL_WS(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "EXCL_WS", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 1) < 1 ||
        ctx->buffer.buf[ctx->cur] != '!'
    ) goto L0000;
    ctx->cur++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_Hidden, &chunk->thunks, NULL)) goto L0000;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "EXCL_WS", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "EXCL_WS", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_EXCL_NO_WS(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "EXCL_NO_WS", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 1) < 1 ||
        ctx->buffer.buf[ctx->cur] != '!'
    ) goto L0000;
    ctx->cur++;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "EXCL_NO_WS", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "EXCL_NO_WS", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_COLON(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "COLON", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 1) < 1 ||
        ctx->buffer.buf[ctx->cur] != ':'
    ) goto L0000;
    ctx->cur++;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "COLON", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "COLON", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_SEMICOLON(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "SEMICOLON", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 1) < 1 ||
        ctx->buffer.buf[ctx->cur] != ';'
    ) goto L0000;
    ctx->cur++;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "SEMICOLON", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "SEMICOLON", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_ASSIGNMENT(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "ASSIGNMENT", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 1) < 1 ||
        ctx->buffer.buf[ctx->cur] != '='
    ) goto L0000;
    ctx->cur++;
    {
        const size_t p = ctx->cur;
        if (
            pcc_refill_buffer(ctx, 1) < 1 ||
            ctx->buffer.buf[ctx->cur] != '='
        ) goto L0001;
        ctx->cur++;
        ctx->cur = p;
        goto L0000;
    L0001:;
        ctx->cur = p;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "ASSIGNMENT", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "ASSIGNMENT", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_ADD_ASSIGNMENT(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "ADD_ASSIGNMENT", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 2) < 2 ||
        (ctx->buffer.buf + ctx->cur)[0] != '+' ||
        (ctx->buffer.buf + ctx->cur)[1] != '='
    ) goto L0000;
    ctx->cur += 2;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "ADD_ASSIGNMENT", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "ADD_ASSIGNMENT", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_SUB_ASSIGNMENT(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "SUB_ASSIGNMENT", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 2) < 2 ||
        (ctx->buffer.buf + ctx->cur)[0] != '-' ||
        (ctx->buffer.buf + ctx->cur)[1] != '='
    ) goto L0000;
    ctx->cur += 2;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "SUB_ASSIGNMENT", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "SUB_ASSIGNMENT", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_MULT_ASSIGNMENT(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "MULT_ASSIGNMENT", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 2) < 2 ||
        (ctx->buffer.buf + ctx->cur)[0] != '*' ||
        (ctx->buffer.buf + ctx->cur)[1] != '='
    ) goto L0000;
    ctx->cur += 2;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "MULT_ASSIGNMENT", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "MULT_ASSIGNMENT", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_DIV_ASSIGNMENT(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "DIV_ASSIGNMENT", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 2) < 2 ||
        (ctx->buffer.buf + ctx->cur)[0] != '/' ||
        (ctx->buffer.buf + ctx->cur)[1] != '='
    ) goto L0000;
    ctx->cur += 2;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "DIV_ASSIGNMENT", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "DIV_ASSIGNMENT", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_MOD_ASSIGNMENT(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "MOD_ASSIGNMENT", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 2) < 2 ||
        (ctx->buffer.buf + ctx->cur)[0] != '%' ||
        (ctx->buffer.buf + ctx->cur)[1] != '='
    ) goto L0000;
    ctx->cur += 2;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "MOD_ASSIGNMENT", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "MOD_ASSIGNMENT", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_ARROW(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "ARROW", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 2) < 2 ||
        (ctx->buffer.buf + ctx->cur)[0] != '-' ||
        (ctx->buffer.buf + ctx->cur)[1] != '>'
    ) goto L0000;
    ctx->cur += 2;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "ARROW", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "ARROW", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_RANGE(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "RANGE", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 2) < 2 ||
        (ctx->buffer.buf + ctx->cur)[0] != '.' ||
        (ctx->buffer.buf + ctx->cur)[1] != '.'
    ) goto L0000;
    ctx->cur += 2;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "RANGE", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "RANGE", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_RANGE_UNTIL(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "RANGE_UNTIL", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 3) < 3 ||
        (ctx->buffer.buf + ctx->cur)[0] != '.' ||
        (ctx->buffer.buf + ctx->cur)[1] != '.' ||
        (ctx->buffer.buf + ctx->cur)[2] != '<'
    ) goto L0000;
    ctx->cur += 3;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "RANGE_UNTIL", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "RANGE_UNTIL", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_COLONCOLON(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "COLONCOLON", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 2) < 2 ||
        (ctx->buffer.buf + ctx->cur)[0] != ':' ||
        (ctx->buffer.buf + ctx->cur)[1] != ':'
    ) goto L0000;
    ctx->cur += 2;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "COLONCOLON", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "COLONCOLON", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_AT_NO_WS(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "AT_NO_WS", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 1) < 1 ||
        ctx->buffer.buf[ctx->cur] != '@'
    ) goto L0000;
    ctx->cur++;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "AT_NO_WS", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "AT_NO_WS", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_AT_POST_WS(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "AT_POST_WS", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 1) < 1 ||
        ctx->buffer.buf[ctx->cur] != '@'
    ) goto L0000;
    ctx->cur++;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_Hidden, &chunk->thunks, NULL)) goto L0002;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_NL, &chunk->thunks, NULL)) goto L0003;
        goto L0001;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "AT_POST_WS", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "AT_POST_WS", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_AT_PRE_WS(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "AT_PRE_WS", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_Hidden, &chunk->thunks, NULL)) goto L0002;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_NL, &chunk->thunks, NULL)) goto L0003;
        goto L0001;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    if (
        pcc_refill_buffer(ctx, 1) < 1 ||
        ctx->buffer.buf[ctx->cur] != '@'
    ) goto L0000;
    ctx->cur++;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "AT_PRE_WS", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "AT_PRE_WS", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_QUEST_WS(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "QUEST_WS", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 1) < 1 ||
        ctx->buffer.buf[ctx->cur] != '?'
    ) goto L0000;
    ctx->cur++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_Hidden, &chunk->thunks, NULL)) goto L0000;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "QUEST_WS", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "QUEST_WS", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_QUEST_NO_WS(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "QUEST_NO_WS", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 1) < 1 ||
        ctx->buffer.buf[ctx->cur] != '?'
    ) goto L0000;
    ctx->cur++;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "QUEST_NO_WS", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "QUEST_NO_WS", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_LANGLE(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "LANGLE", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 1) < 1 ||
        ctx->buffer.buf[ctx->cur] != '<'
    ) goto L0000;
    ctx->cur++;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "LANGLE", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "LANGLE", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_RANGLE(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "RANGLE", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 1) < 1 ||
        ctx->buffer.buf[ctx->cur] != '>'
    ) goto L0000;
    ctx->cur++;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "RANGLE", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "RANGLE", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_LE(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "LE", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 2) < 2 ||
        (ctx->buffer.buf + ctx->cur)[0] != '<' ||
        (ctx->buffer.buf + ctx->cur)[1] != '='
    ) goto L0000;
    ctx->cur += 2;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "LE", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "LE", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_GE(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "GE", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 2) < 2 ||
        (ctx->buffer.buf + ctx->cur)[0] != '>' ||
        (ctx->buffer.buf + ctx->cur)[1] != '='
    ) goto L0000;
    ctx->cur += 2;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "GE", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "GE", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_EXCL_EQ(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "EXCL_EQ", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 2) < 2 ||
        (ctx->buffer.buf + ctx->cur)[0] != '!' ||
        (ctx->buffer.buf + ctx->cur)[1] != '='
    ) goto L0000;
    ctx->cur += 2;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "EXCL_EQ", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "EXCL_EQ", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_EXCL_EQEQ(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "EXCL_EQEQ", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 3) < 3 ||
        (ctx->buffer.buf + ctx->cur)[0] != '!' ||
        (ctx->buffer.buf + ctx->cur)[1] != '=' ||
        (ctx->buffer.buf + ctx->cur)[2] != '='
    ) goto L0000;
    ctx->cur += 3;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "EXCL_EQEQ", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "EXCL_EQEQ", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_AS_SAFE(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "AS_SAFE", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 3) < 3 ||
        (ctx->buffer.buf + ctx->cur)[0] != 'a' ||
        (ctx->buffer.buf + ctx->cur)[1] != 's' ||
        (ctx->buffer.buf + ctx->cur)[2] != '?'
    ) goto L0000;
    ctx->cur += 3;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "AS_SAFE", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "AS_SAFE", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_EQEQ(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "EQEQ", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 2) < 2 ||
        (ctx->buffer.buf + ctx->cur)[0] != '=' ||
        (ctx->buffer.buf + ctx->cur)[1] != '='
    ) goto L0000;
    ctx->cur += 2;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "EQEQ", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "EQEQ", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_EQEQEQ(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "EQEQEQ", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 3) < 3 ||
        (ctx->buffer.buf + ctx->cur)[0] != '=' ||
        (ctx->buffer.buf + ctx->cur)[1] != '=' ||
        (ctx->buffer.buf + ctx->cur)[2] != '='
    ) goto L0000;
    ctx->cur += 3;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "EQEQEQ", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "EQEQEQ", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_RETURN_AT(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "RETURN_AT", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 7) < 7 ||
        (ctx->buffer.buf + ctx->cur)[0] != 'r' ||
        (ctx->buffer.buf + ctx->cur)[1] != 'e' ||
        (ctx->buffer.buf + ctx->cur)[2] != 't' ||
        (ctx->buffer.buf + ctx->cur)[3] != 'u' ||
        (ctx->buffer.buf + ctx->cur)[4] != 'r' ||
        (ctx->buffer.buf + ctx->cur)[5] != 'n' ||
        (ctx->buffer.buf + ctx->cur)[6] != '@'
    ) goto L0000;
    ctx->cur += 7;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_Identifier, &chunk->thunks, NULL)) goto L0000;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "RETURN_AT", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "RETURN_AT", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_CONTINUE_AT(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "CONTINUE_AT", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 9) < 9 ||
        (ctx->buffer.buf + ctx->cur)[0] != 'c' ||
        (ctx->buffer.buf + ctx->cur)[1] != 'o' ||
        (ctx->buffer.buf + ctx->cur)[2] != 'n' ||
        (ctx->buffer.buf + ctx->cur)[3] != 't' ||
        (ctx->buffer.buf + ctx->cur)[4] != 'i' ||
        (ctx->buffer.buf + ctx->cur)[5] != 'n' ||
        (ctx->buffer.buf + ctx->cur)[6] != 'u' ||
        (ctx->buffer.buf + ctx->cur)[7] != 'e' ||
        (ctx->buffer.buf + ctx->cur)[8] != '@'
    ) goto L0000;
    ctx->cur += 9;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_Identifier, &chunk->thunks, NULL)) goto L0000;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "CONTINUE_AT", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "CONTINUE_AT", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_BREAK_AT(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "BREAK_AT", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 6) < 6 ||
        (ctx->buffer.buf + ctx->cur)[0] != 'b' ||
        (ctx->buffer.buf + ctx->cur)[1] != 'r' ||
        (ctx->buffer.buf + ctx->cur)[2] != 'e' ||
        (ctx->buffer.buf + ctx->cur)[3] != 'a' ||
        (ctx->buffer.buf + ctx->cur)[4] != 'k' ||
        (ctx->buffer.buf + ctx->cur)[5] != '@'
    ) goto L0000;
    ctx->cur += 6;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_Identifier, &chunk->thunks, NULL)) goto L0000;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "BREAK_AT", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "BREAK_AT", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_THIS_AT(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "THIS_AT", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 5) < 5 ||
        (ctx->buffer.buf + ctx->cur)[0] != 't' ||
        (ctx->buffer.buf + ctx->cur)[1] != 'h' ||
        (ctx->buffer.buf + ctx->cur)[2] != 'i' ||
        (ctx->buffer.buf + ctx->cur)[3] != 's' ||
        (ctx->buffer.buf + ctx->cur)[4] != '@'
    ) goto L0000;
    ctx->cur += 5;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_Identifier, &chunk->thunks, NULL)) goto L0000;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "THIS_AT", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "THIS_AT", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_SUPER_AT(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "SUPER_AT", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 6) < 6 ||
        (ctx->buffer.buf + ctx->cur)[0] != 's' ||
        (ctx->buffer.buf + ctx->cur)[1] != 'u' ||
        (ctx->buffer.buf + ctx->cur)[2] != 'p' ||
        (ctx->buffer.buf + ctx->cur)[3] != 'e' ||
        (ctx->buffer.buf + ctx->cur)[4] != 'r' ||
        (ctx->buffer.buf + ctx->cur)[5] != '@'
    ) goto L0000;
    ctx->cur += 6;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_Identifier, &chunk->thunks, NULL)) goto L0000;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "SUPER_AT", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "SUPER_AT", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_FILE(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "FILE", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 4) < 4 ||
        (ctx->buffer.buf + ctx->cur)[0] != 'f' ||
        (ctx->buffer.buf + ctx->cur)[1] != 'i' ||
        (ctx->buffer.buf + ctx->cur)[2] != 'l' ||
        (ctx->buffer.buf + ctx->cur)[3] != 'e'
    ) goto L0000;
    ctx->cur += 4;
    {
        const size_t p = ctx->cur;
        {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_Letter, &chunk->thunks, NULL)) goto L0003;
            goto L0002;
        L0003:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_UnicodeDigit, &chunk->thunks, NULL)) goto L0004;
            goto L0002;
        L0004:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            goto L0001;
        L0002:;
        }
        ctx->cur = p;
        goto L0000;
    L0001:;
        ctx->cur = p;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "FILE", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "FILE", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_FIELD(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "FIELD", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 5) < 5 ||
        (ctx->buffer.buf + ctx->cur)[0] != 'f' ||
        (ctx->buffer.buf + ctx->cur)[1] != 'i' ||
        (ctx->buffer.buf + ctx->cur)[2] != 'e' ||
        (ctx->buffer.buf + ctx->cur)[3] != 'l' ||
        (ctx->buffer.buf + ctx->cur)[4] != 'd'
    ) goto L0000;
    ctx->cur += 5;
    {
        const size_t p = ctx->cur;
        {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_Letter, &chunk->thunks, NULL)) goto L0003;
            goto L0002;
        L0003:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_UnicodeDigit, &chunk->thunks, NULL)) goto L0004;
            goto L0002;
        L0004:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            goto L0001;
        L0002:;
        }
        ctx->cur = p;
        goto L0000;
    L0001:;
        ctx->cur = p;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "FIELD", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "FIELD", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_PROPERTY(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "PROPERTY", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 8) < 8 ||
        (ctx->buffer.buf + ctx->cur)[0] != 'p' ||
        (ctx->buffer.buf + ctx->cur)[1] != 'r' ||
        (ctx->buffer.buf + ctx->cur)[2] != 'o' ||
        (ctx->buffer.buf + ctx->cur)[3] != 'p' ||
        (ctx->buffer.buf + ctx->cur)[4] != 'e' ||
        (ctx->buffer.buf + ctx->cur)[5] != 'r' ||
        (ctx->buffer.buf + ctx->cur)[6] != 't' ||
        (ctx->buffer.buf + ctx->cur)[7] != 'y'
    ) goto L0000;
    ctx->cur += 8;
    {
        const size_t p = ctx->cur;
        {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_Letter, &chunk->thunks, NULL)) goto L0003;
            goto L0002;
        L0003:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_UnicodeDigit, &chunk->thunks, NULL)) goto L0004;
            goto L0002;
        L0004:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            goto L0001;
        L0002:;
        }
        ctx->cur = p;
        goto L0000;
    L0001:;
        ctx->cur = p;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "PROPERTY", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "PROPERTY", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_GET(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "GET", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 3) < 3 ||
        (ctx->buffer.buf + ctx->cur)[0] != 'g' ||
        (ctx->buffer.buf + ctx->cur)[1] != 'e' ||
        (ctx->buffer.buf + ctx->cur)[2] != 't'
    ) goto L0000;
    ctx->cur += 3;
    {
        const size_t p = ctx->cur;
        {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_Letter, &chunk->thunks, NULL)) goto L0003;
            goto L0002;
        L0003:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_UnicodeDigit, &chunk->thunks, NULL)) goto L0004;
            goto L0002;
        L0004:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            goto L0001;
        L0002:;
        }
        ctx->cur = p;
        goto L0000;
    L0001:;
        ctx->cur = p;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "GET", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "GET", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_SET(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "SET", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 3) < 3 ||
        (ctx->buffer.buf + ctx->cur)[0] != 's' ||
        (ctx->buffer.buf + ctx->cur)[1] != 'e' ||
        (ctx->buffer.buf + ctx->cur)[2] != 't'
    ) goto L0000;
    ctx->cur += 3;
    {
        const size_t p = ctx->cur;
        {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_Letter, &chunk->thunks, NULL)) goto L0003;
            goto L0002;
        L0003:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_UnicodeDigit, &chunk->thunks, NULL)) goto L0004;
            goto L0002;
        L0004:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            goto L0001;
        L0002:;
        }
        ctx->cur = p;
        goto L0000;
    L0001:;
        ctx->cur = p;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "SET", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "SET", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_RECEIVER(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "RECEIVER", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 8) < 8 ||
        (ctx->buffer.buf + ctx->cur)[0] != 'r' ||
        (ctx->buffer.buf + ctx->cur)[1] != 'e' ||
        (ctx->buffer.buf + ctx->cur)[2] != 'c' ||
        (ctx->buffer.buf + ctx->cur)[3] != 'e' ||
        (ctx->buffer.buf + ctx->cur)[4] != 'i' ||
        (ctx->buffer.buf + ctx->cur)[5] != 'v' ||
        (ctx->buffer.buf + ctx->cur)[6] != 'e' ||
        (ctx->buffer.buf + ctx->cur)[7] != 'r'
    ) goto L0000;
    ctx->cur += 8;
    {
        const size_t p = ctx->cur;
        {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_Letter, &chunk->thunks, NULL)) goto L0003;
            goto L0002;
        L0003:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_UnicodeDigit, &chunk->thunks, NULL)) goto L0004;
            goto L0002;
        L0004:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            goto L0001;
        L0002:;
        }
        ctx->cur = p;
        goto L0000;
    L0001:;
        ctx->cur = p;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "RECEIVER", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "RECEIVER", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_PARAM(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "PARAM", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 5) < 5 ||
        (ctx->buffer.buf + ctx->cur)[0] != 'p' ||
        (ctx->buffer.buf + ctx->cur)[1] != 'a' ||
        (ctx->buffer.buf + ctx->cur)[2] != 'r' ||
        (ctx->buffer.buf + ctx->cur)[3] != 'a' ||
        (ctx->buffer.buf + ctx->cur)[4] != 'm'
    ) goto L0000;
    ctx->cur += 5;
    {
        const size_t p = ctx->cur;
        {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_Letter, &chunk->thunks, NULL)) goto L0003;
            goto L0002;
        L0003:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_UnicodeDigit, &chunk->thunks, NULL)) goto L0004;
            goto L0002;
        L0004:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            goto L0001;
        L0002:;
        }
        ctx->cur = p;
        goto L0000;
    L0001:;
        ctx->cur = p;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "PARAM", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "PARAM", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_SETPARAM(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "SETPARAM", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 8) < 8 ||
        (ctx->buffer.buf + ctx->cur)[0] != 's' ||
        (ctx->buffer.buf + ctx->cur)[1] != 'e' ||
        (ctx->buffer.buf + ctx->cur)[2] != 't' ||
        (ctx->buffer.buf + ctx->cur)[3] != 'p' ||
        (ctx->buffer.buf + ctx->cur)[4] != 'a' ||
        (ctx->buffer.buf + ctx->cur)[5] != 'r' ||
        (ctx->buffer.buf + ctx->cur)[6] != 'a' ||
        (ctx->buffer.buf + ctx->cur)[7] != 'm'
    ) goto L0000;
    ctx->cur += 8;
    {
        const size_t p = ctx->cur;
        {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_Letter, &chunk->thunks, NULL)) goto L0003;
            goto L0002;
        L0003:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_UnicodeDigit, &chunk->thunks, NULL)) goto L0004;
            goto L0002;
        L0004:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            goto L0001;
        L0002:;
        }
        ctx->cur = p;
        goto L0000;
    L0001:;
        ctx->cur = p;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "SETPARAM", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "SETPARAM", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_DELEGATE(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "DELEGATE", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 8) < 8 ||
        (ctx->buffer.buf + ctx->cur)[0] != 'd' ||
        (ctx->buffer.buf + ctx->cur)[1] != 'e' ||
        (ctx->buffer.buf + ctx->cur)[2] != 'l' ||
        (ctx->buffer.buf + ctx->cur)[3] != 'e' ||
        (ctx->buffer.buf + ctx->cur)[4] != 'g' ||
        (ctx->buffer.buf + ctx->cur)[5] != 'a' ||
        (ctx->buffer.buf + ctx->cur)[6] != 't' ||
        (ctx->buffer.buf + ctx->cur)[7] != 'e'
    ) goto L0000;
    ctx->cur += 8;
    {
        const size_t p = ctx->cur;
        {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_Letter, &chunk->thunks, NULL)) goto L0003;
            goto L0002;
        L0003:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_UnicodeDigit, &chunk->thunks, NULL)) goto L0004;
            goto L0002;
        L0004:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            goto L0001;
        L0002:;
        }
        ctx->cur = p;
        goto L0000;
    L0001:;
        ctx->cur = p;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "DELEGATE", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "DELEGATE", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_PACKAGE(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "PACKAGE", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 7) < 7 ||
        (ctx->buffer.buf + ctx->cur)[0] != 'p' ||
        (ctx->buffer.buf + ctx->cur)[1] != 'a' ||
        (ctx->buffer.buf + ctx->cur)[2] != 'c' ||
        (ctx->buffer.buf + ctx->cur)[3] != 'k' ||
        (ctx->buffer.buf + ctx->cur)[4] != 'a' ||
        (ctx->buffer.buf + ctx->cur)[5] != 'g' ||
        (ctx->buffer.buf + ctx->cur)[6] != 'e'
    ) goto L0000;
    ctx->cur += 7;
    {
        const size_t p = ctx->cur;
        {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_Letter, &chunk->thunks, NULL)) goto L0003;
            goto L0002;
        L0003:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_UnicodeDigit, &chunk->thunks, NULL)) goto L0004;
            goto L0002;
        L0004:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            goto L0001;
        L0002:;
        }
        ctx->cur = p;
        goto L0000;
    L0001:;
        ctx->cur = p;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "PACKAGE", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "PACKAGE", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_IMPORT(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "IMPORT", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 6) < 6 ||
        (ctx->buffer.buf + ctx->cur)[0] != 'i' ||
        (ctx->buffer.buf + ctx->cur)[1] != 'm' ||
        (ctx->buffer.buf + ctx->cur)[2] != 'p' ||
        (ctx->buffer.buf + ctx->cur)[3] != 'o' ||
        (ctx->buffer.buf + ctx->cur)[4] != 'r' ||
        (ctx->buffer.buf + ctx->cur)[5] != 't'
    ) goto L0000;
    ctx->cur += 6;
    {
        const size_t p = ctx->cur;
        {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_Letter, &chunk->thunks, NULL)) goto L0003;
            goto L0002;
        L0003:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_UnicodeDigit, &chunk->thunks, NULL)) goto L0004;
            goto L0002;
        L0004:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            goto L0001;
        L0002:;
        }
        ctx->cur = p;
        goto L0000;
    L0001:;
        ctx->cur = p;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "IMPORT", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "IMPORT", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_CLASS(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "CLASS", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 5) < 5 ||
        (ctx->buffer.buf + ctx->cur)[0] != 'c' ||
        (ctx->buffer.buf + ctx->cur)[1] != 'l' ||
        (ctx->buffer.buf + ctx->cur)[2] != 'a' ||
        (ctx->buffer.buf + ctx->cur)[3] != 's' ||
        (ctx->buffer.buf + ctx->cur)[4] != 's'
    ) goto L0000;
    ctx->cur += 5;
    {
        const size_t p = ctx->cur;
        {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_Letter, &chunk->thunks, NULL)) goto L0003;
            goto L0002;
        L0003:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_UnicodeDigit, &chunk->thunks, NULL)) goto L0004;
            goto L0002;
        L0004:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            goto L0001;
        L0002:;
        }
        ctx->cur = p;
        goto L0000;
    L0001:;
        ctx->cur = p;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "CLASS", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "CLASS", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_INTERFACE(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "INTERFACE", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 9) < 9 ||
        (ctx->buffer.buf + ctx->cur)[0] != 'i' ||
        (ctx->buffer.buf + ctx->cur)[1] != 'n' ||
        (ctx->buffer.buf + ctx->cur)[2] != 't' ||
        (ctx->buffer.buf + ctx->cur)[3] != 'e' ||
        (ctx->buffer.buf + ctx->cur)[4] != 'r' ||
        (ctx->buffer.buf + ctx->cur)[5] != 'f' ||
        (ctx->buffer.buf + ctx->cur)[6] != 'a' ||
        (ctx->buffer.buf + ctx->cur)[7] != 'c' ||
        (ctx->buffer.buf + ctx->cur)[8] != 'e'
    ) goto L0000;
    ctx->cur += 9;
    {
        const size_t p = ctx->cur;
        {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_Letter, &chunk->thunks, NULL)) goto L0003;
            goto L0002;
        L0003:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_UnicodeDigit, &chunk->thunks, NULL)) goto L0004;
            goto L0002;
        L0004:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            goto L0001;
        L0002:;
        }
        ctx->cur = p;
        goto L0000;
    L0001:;
        ctx->cur = p;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "INTERFACE", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "INTERFACE", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_FUN(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "FUN", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 3) < 3 ||
        (ctx->buffer.buf + ctx->cur)[0] != 'f' ||
        (ctx->buffer.buf + ctx->cur)[1] != 'u' ||
        (ctx->buffer.buf + ctx->cur)[2] != 'n'
    ) goto L0000;
    ctx->cur += 3;
    {
        const size_t p = ctx->cur;
        {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_Letter, &chunk->thunks, NULL)) goto L0003;
            goto L0002;
        L0003:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_UnicodeDigit, &chunk->thunks, NULL)) goto L0004;
            goto L0002;
        L0004:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            goto L0001;
        L0002:;
        }
        ctx->cur = p;
        goto L0000;
    L0001:;
        ctx->cur = p;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "FUN", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "FUN", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_OBJECT(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "OBJECT", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 6) < 6 ||
        (ctx->buffer.buf + ctx->cur)[0] != 'o' ||
        (ctx->buffer.buf + ctx->cur)[1] != 'b' ||
        (ctx->buffer.buf + ctx->cur)[2] != 'j' ||
        (ctx->buffer.buf + ctx->cur)[3] != 'e' ||
        (ctx->buffer.buf + ctx->cur)[4] != 'c' ||
        (ctx->buffer.buf + ctx->cur)[5] != 't'
    ) goto L0000;
    ctx->cur += 6;
    {
        const size_t p = ctx->cur;
        {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_Letter, &chunk->thunks, NULL)) goto L0003;
            goto L0002;
        L0003:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_UnicodeDigit, &chunk->thunks, NULL)) goto L0004;
            goto L0002;
        L0004:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            goto L0001;
        L0002:;
        }
        ctx->cur = p;
        goto L0000;
    L0001:;
        ctx->cur = p;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "OBJECT", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "OBJECT", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_VAL(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "VAL", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 3) < 3 ||
        (ctx->buffer.buf + ctx->cur)[0] != 'v' ||
        (ctx->buffer.buf + ctx->cur)[1] != 'a' ||
        (ctx->buffer.buf + ctx->cur)[2] != 'l'
    ) goto L0000;
    ctx->cur += 3;
    {
        const size_t p = ctx->cur;
        {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_Letter, &chunk->thunks, NULL)) goto L0003;
            goto L0002;
        L0003:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_UnicodeDigit, &chunk->thunks, NULL)) goto L0004;
            goto L0002;
        L0004:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            goto L0001;
        L0002:;
        }
        ctx->cur = p;
        goto L0000;
    L0001:;
        ctx->cur = p;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "VAL", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "VAL", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_VAR(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "VAR", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 3) < 3 ||
        (ctx->buffer.buf + ctx->cur)[0] != 'v' ||
        (ctx->buffer.buf + ctx->cur)[1] != 'a' ||
        (ctx->buffer.buf + ctx->cur)[2] != 'r'
    ) goto L0000;
    ctx->cur += 3;
    {
        const size_t p = ctx->cur;
        {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_Letter, &chunk->thunks, NULL)) goto L0003;
            goto L0002;
        L0003:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_UnicodeDigit, &chunk->thunks, NULL)) goto L0004;
            goto L0002;
        L0004:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            goto L0001;
        L0002:;
        }
        ctx->cur = p;
        goto L0000;
    L0001:;
        ctx->cur = p;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "VAR", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "VAR", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_TYPE_ALIAS(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "TYPE_ALIAS", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 9) < 9 ||
        (ctx->buffer.buf + ctx->cur)[0] != 't' ||
        (ctx->buffer.buf + ctx->cur)[1] != 'y' ||
        (ctx->buffer.buf + ctx->cur)[2] != 'p' ||
        (ctx->buffer.buf + ctx->cur)[3] != 'e' ||
        (ctx->buffer.buf + ctx->cur)[4] != 'a' ||
        (ctx->buffer.buf + ctx->cur)[5] != 'l' ||
        (ctx->buffer.buf + ctx->cur)[6] != 'i' ||
        (ctx->buffer.buf + ctx->cur)[7] != 'a' ||
        (ctx->buffer.buf + ctx->cur)[8] != 's'
    ) goto L0000;
    ctx->cur += 9;
    {
        const size_t p = ctx->cur;
        {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_Letter, &chunk->thunks, NULL)) goto L0003;
            goto L0002;
        L0003:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_UnicodeDigit, &chunk->thunks, NULL)) goto L0004;
            goto L0002;
        L0004:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            goto L0001;
        L0002:;
        }
        ctx->cur = p;
        goto L0000;
    L0001:;
        ctx->cur = p;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "TYPE_ALIAS", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "TYPE_ALIAS", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_CONSTRUCTOR(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "CONSTRUCTOR", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 11) < 11 ||
        (ctx->buffer.buf + ctx->cur)[0] != 'c' ||
        (ctx->buffer.buf + ctx->cur)[1] != 'o' ||
        (ctx->buffer.buf + ctx->cur)[2] != 'n' ||
        (ctx->buffer.buf + ctx->cur)[3] != 's' ||
        (ctx->buffer.buf + ctx->cur)[4] != 't' ||
        (ctx->buffer.buf + ctx->cur)[5] != 'r' ||
        (ctx->buffer.buf + ctx->cur)[6] != 'u' ||
        (ctx->buffer.buf + ctx->cur)[7] != 'c' ||
        (ctx->buffer.buf + ctx->cur)[8] != 't' ||
        (ctx->buffer.buf + ctx->cur)[9] != 'o' ||
        (ctx->buffer.buf + ctx->cur)[10] != 'r'
    ) goto L0000;
    ctx->cur += 11;
    {
        const size_t p = ctx->cur;
        {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_Letter, &chunk->thunks, NULL)) goto L0003;
            goto L0002;
        L0003:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_UnicodeDigit, &chunk->thunks, NULL)) goto L0004;
            goto L0002;
        L0004:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            goto L0001;
        L0002:;
        }
        ctx->cur = p;
        goto L0000;
    L0001:;
        ctx->cur = p;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "CONSTRUCTOR", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "CONSTRUCTOR", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_BY(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "BY", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 2) < 2 ||
        (ctx->buffer.buf + ctx->cur)[0] != 'b' ||
        (ctx->buffer.buf + ctx->cur)[1] != 'y'
    ) goto L0000;
    ctx->cur += 2;
    {
        const size_t p = ctx->cur;
        {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_Letter, &chunk->thunks, NULL)) goto L0003;
            goto L0002;
        L0003:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_UnicodeDigit, &chunk->thunks, NULL)) goto L0004;
            goto L0002;
        L0004:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            goto L0001;
        L0002:;
        }
        ctx->cur = p;
        goto L0000;
    L0001:;
        ctx->cur = p;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "BY", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "BY", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_COMPANION(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "COMPANION", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 9) < 9 ||
        (ctx->buffer.buf + ctx->cur)[0] != 'c' ||
        (ctx->buffer.buf + ctx->cur)[1] != 'o' ||
        (ctx->buffer.buf + ctx->cur)[2] != 'm' ||
        (ctx->buffer.buf + ctx->cur)[3] != 'p' ||
        (ctx->buffer.buf + ctx->cur)[4] != 'a' ||
        (ctx->buffer.buf + ctx->cur)[5] != 'n' ||
        (ctx->buffer.buf + ctx->cur)[6] != 'i' ||
        (ctx->buffer.buf + ctx->cur)[7] != 'o' ||
        (ctx->buffer.buf + ctx->cur)[8] != 'n'
    ) goto L0000;
    ctx->cur += 9;
    {
        const size_t p = ctx->cur;
        {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_Letter, &chunk->thunks, NULL)) goto L0003;
            goto L0002;
        L0003:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_UnicodeDigit, &chunk->thunks, NULL)) goto L0004;
            goto L0002;
        L0004:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            goto L0001;
        L0002:;
        }
        ctx->cur = p;
        goto L0000;
    L0001:;
        ctx->cur = p;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "COMPANION", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "COMPANION", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_INIT(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "INIT", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 4) < 4 ||
        (ctx->buffer.buf + ctx->cur)[0] != 'i' ||
        (ctx->buffer.buf + ctx->cur)[1] != 'n' ||
        (ctx->buffer.buf + ctx->cur)[2] != 'i' ||
        (ctx->buffer.buf + ctx->cur)[3] != 't'
    ) goto L0000;
    ctx->cur += 4;
    {
        const size_t p = ctx->cur;
        {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_Letter, &chunk->thunks, NULL)) goto L0003;
            goto L0002;
        L0003:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_UnicodeDigit, &chunk->thunks, NULL)) goto L0004;
            goto L0002;
        L0004:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            goto L0001;
        L0002:;
        }
        ctx->cur = p;
        goto L0000;
    L0001:;
        ctx->cur = p;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "INIT", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "INIT", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_THIS(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "THIS", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 4) < 4 ||
        (ctx->buffer.buf + ctx->cur)[0] != 't' ||
        (ctx->buffer.buf + ctx->cur)[1] != 'h' ||
        (ctx->buffer.buf + ctx->cur)[2] != 'i' ||
        (ctx->buffer.buf + ctx->cur)[3] != 's'
    ) goto L0000;
    ctx->cur += 4;
    {
        const size_t p = ctx->cur;
        {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_Letter, &chunk->thunks, NULL)) goto L0003;
            goto L0002;
        L0003:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_UnicodeDigit, &chunk->thunks, NULL)) goto L0004;
            goto L0002;
        L0004:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            goto L0001;
        L0002:;
        }
        ctx->cur = p;
        goto L0000;
    L0001:;
        ctx->cur = p;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "THIS", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "THIS", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_SUPER(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "SUPER", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 5) < 5 ||
        (ctx->buffer.buf + ctx->cur)[0] != 's' ||
        (ctx->buffer.buf + ctx->cur)[1] != 'u' ||
        (ctx->buffer.buf + ctx->cur)[2] != 'p' ||
        (ctx->buffer.buf + ctx->cur)[3] != 'e' ||
        (ctx->buffer.buf + ctx->cur)[4] != 'r'
    ) goto L0000;
    ctx->cur += 5;
    {
        const size_t p = ctx->cur;
        {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_Letter, &chunk->thunks, NULL)) goto L0003;
            goto L0002;
        L0003:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_UnicodeDigit, &chunk->thunks, NULL)) goto L0004;
            goto L0002;
        L0004:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            goto L0001;
        L0002:;
        }
        ctx->cur = p;
        goto L0000;
    L0001:;
        ctx->cur = p;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "SUPER", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "SUPER", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_TYPEOF(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "TYPEOF", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 6) < 6 ||
        (ctx->buffer.buf + ctx->cur)[0] != 't' ||
        (ctx->buffer.buf + ctx->cur)[1] != 'y' ||
        (ctx->buffer.buf + ctx->cur)[2] != 'p' ||
        (ctx->buffer.buf + ctx->cur)[3] != 'e' ||
        (ctx->buffer.buf + ctx->cur)[4] != 'o' ||
        (ctx->buffer.buf + ctx->cur)[5] != 'f'
    ) goto L0000;
    ctx->cur += 6;
    {
        const size_t p = ctx->cur;
        {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_Letter, &chunk->thunks, NULL)) goto L0003;
            goto L0002;
        L0003:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_UnicodeDigit, &chunk->thunks, NULL)) goto L0004;
            goto L0002;
        L0004:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            goto L0001;
        L0002:;
        }
        ctx->cur = p;
        goto L0000;
    L0001:;
        ctx->cur = p;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "TYPEOF", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "TYPEOF", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_WHERE(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "WHERE", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 5) < 5 ||
        (ctx->buffer.buf + ctx->cur)[0] != 'w' ||
        (ctx->buffer.buf + ctx->cur)[1] != 'h' ||
        (ctx->buffer.buf + ctx->cur)[2] != 'e' ||
        (ctx->buffer.buf + ctx->cur)[3] != 'r' ||
        (ctx->buffer.buf + ctx->cur)[4] != 'e'
    ) goto L0000;
    ctx->cur += 5;
    {
        const size_t p = ctx->cur;
        {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_Letter, &chunk->thunks, NULL)) goto L0003;
            goto L0002;
        L0003:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_UnicodeDigit, &chunk->thunks, NULL)) goto L0004;
            goto L0002;
        L0004:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            goto L0001;
        L0002:;
        }
        ctx->cur = p;
        goto L0000;
    L0001:;
        ctx->cur = p;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "WHERE", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "WHERE", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_IF(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "IF", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 2) < 2 ||
        (ctx->buffer.buf + ctx->cur)[0] != 'i' ||
        (ctx->buffer.buf + ctx->cur)[1] != 'f'
    ) goto L0000;
    ctx->cur += 2;
    {
        const size_t p = ctx->cur;
        {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_Letter, &chunk->thunks, NULL)) goto L0003;
            goto L0002;
        L0003:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_UnicodeDigit, &chunk->thunks, NULL)) goto L0004;
            goto L0002;
        L0004:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            goto L0001;
        L0002:;
        }
        ctx->cur = p;
        goto L0000;
    L0001:;
        ctx->cur = p;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "IF", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "IF", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_ELSE(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "ELSE", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 4) < 4 ||
        (ctx->buffer.buf + ctx->cur)[0] != 'e' ||
        (ctx->buffer.buf + ctx->cur)[1] != 'l' ||
        (ctx->buffer.buf + ctx->cur)[2] != 's' ||
        (ctx->buffer.buf + ctx->cur)[3] != 'e'
    ) goto L0000;
    ctx->cur += 4;
    {
        const size_t p = ctx->cur;
        {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_Letter, &chunk->thunks, NULL)) goto L0003;
            goto L0002;
        L0003:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_UnicodeDigit, &chunk->thunks, NULL)) goto L0004;
            goto L0002;
        L0004:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            goto L0001;
        L0002:;
        }
        ctx->cur = p;
        goto L0000;
    L0001:;
        ctx->cur = p;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "ELSE", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "ELSE", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_WHEN(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "WHEN", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 4) < 4 ||
        (ctx->buffer.buf + ctx->cur)[0] != 'w' ||
        (ctx->buffer.buf + ctx->cur)[1] != 'h' ||
        (ctx->buffer.buf + ctx->cur)[2] != 'e' ||
        (ctx->buffer.buf + ctx->cur)[3] != 'n'
    ) goto L0000;
    ctx->cur += 4;
    {
        const size_t p = ctx->cur;
        {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_Letter, &chunk->thunks, NULL)) goto L0003;
            goto L0002;
        L0003:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_UnicodeDigit, &chunk->thunks, NULL)) goto L0004;
            goto L0002;
        L0004:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            goto L0001;
        L0002:;
        }
        ctx->cur = p;
        goto L0000;
    L0001:;
        ctx->cur = p;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "WHEN", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "WHEN", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_TRY(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "TRY", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 3) < 3 ||
        (ctx->buffer.buf + ctx->cur)[0] != 't' ||
        (ctx->buffer.buf + ctx->cur)[1] != 'r' ||
        (ctx->buffer.buf + ctx->cur)[2] != 'y'
    ) goto L0000;
    ctx->cur += 3;
    {
        const size_t p = ctx->cur;
        {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_Letter, &chunk->thunks, NULL)) goto L0003;
            goto L0002;
        L0003:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_UnicodeDigit, &chunk->thunks, NULL)) goto L0004;
            goto L0002;
        L0004:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            goto L0001;
        L0002:;
        }
        ctx->cur = p;
        goto L0000;
    L0001:;
        ctx->cur = p;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "TRY", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "TRY", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_CATCH(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "CATCH", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 5) < 5 ||
        (ctx->buffer.buf + ctx->cur)[0] != 'c' ||
        (ctx->buffer.buf + ctx->cur)[1] != 'a' ||
        (ctx->buffer.buf + ctx->cur)[2] != 't' ||
        (ctx->buffer.buf + ctx->cur)[3] != 'c' ||
        (ctx->buffer.buf + ctx->cur)[4] != 'h'
    ) goto L0000;
    ctx->cur += 5;
    {
        const size_t p = ctx->cur;
        {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_Letter, &chunk->thunks, NULL)) goto L0003;
            goto L0002;
        L0003:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_UnicodeDigit, &chunk->thunks, NULL)) goto L0004;
            goto L0002;
        L0004:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            goto L0001;
        L0002:;
        }
        ctx->cur = p;
        goto L0000;
    L0001:;
        ctx->cur = p;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "CATCH", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "CATCH", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_FINALLY(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "FINALLY", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 7) < 7 ||
        (ctx->buffer.buf + ctx->cur)[0] != 'f' ||
        (ctx->buffer.buf + ctx->cur)[1] != 'i' ||
        (ctx->buffer.buf + ctx->cur)[2] != 'n' ||
        (ctx->buffer.buf + ctx->cur)[3] != 'a' ||
        (ctx->buffer.buf + ctx->cur)[4] != 'l' ||
        (ctx->buffer.buf + ctx->cur)[5] != 'l' ||
        (ctx->buffer.buf + ctx->cur)[6] != 'y'
    ) goto L0000;
    ctx->cur += 7;
    {
        const size_t p = ctx->cur;
        {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_Letter, &chunk->thunks, NULL)) goto L0003;
            goto L0002;
        L0003:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_UnicodeDigit, &chunk->thunks, NULL)) goto L0004;
            goto L0002;
        L0004:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            goto L0001;
        L0002:;
        }
        ctx->cur = p;
        goto L0000;
    L0001:;
        ctx->cur = p;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "FINALLY", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "FINALLY", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_FOR(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "FOR", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 3) < 3 ||
        (ctx->buffer.buf + ctx->cur)[0] != 'f' ||
        (ctx->buffer.buf + ctx->cur)[1] != 'o' ||
        (ctx->buffer.buf + ctx->cur)[2] != 'r'
    ) goto L0000;
    ctx->cur += 3;
    {
        const size_t p = ctx->cur;
        {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_Letter, &chunk->thunks, NULL)) goto L0003;
            goto L0002;
        L0003:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_UnicodeDigit, &chunk->thunks, NULL)) goto L0004;
            goto L0002;
        L0004:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            goto L0001;
        L0002:;
        }
        ctx->cur = p;
        goto L0000;
    L0001:;
        ctx->cur = p;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "FOR", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "FOR", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_DO(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "DO", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 2) < 2 ||
        (ctx->buffer.buf + ctx->cur)[0] != 'd' ||
        (ctx->buffer.buf + ctx->cur)[1] != 'o'
    ) goto L0000;
    ctx->cur += 2;
    {
        const size_t p = ctx->cur;
        {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_Letter, &chunk->thunks, NULL)) goto L0003;
            goto L0002;
        L0003:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_UnicodeDigit, &chunk->thunks, NULL)) goto L0004;
            goto L0002;
        L0004:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            goto L0001;
        L0002:;
        }
        ctx->cur = p;
        goto L0000;
    L0001:;
        ctx->cur = p;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "DO", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "DO", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_WHILE(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "WHILE", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 5) < 5 ||
        (ctx->buffer.buf + ctx->cur)[0] != 'w' ||
        (ctx->buffer.buf + ctx->cur)[1] != 'h' ||
        (ctx->buffer.buf + ctx->cur)[2] != 'i' ||
        (ctx->buffer.buf + ctx->cur)[3] != 'l' ||
        (ctx->buffer.buf + ctx->cur)[4] != 'e'
    ) goto L0000;
    ctx->cur += 5;
    {
        const size_t p = ctx->cur;
        {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_Letter, &chunk->thunks, NULL)) goto L0003;
            goto L0002;
        L0003:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_UnicodeDigit, &chunk->thunks, NULL)) goto L0004;
            goto L0002;
        L0004:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            goto L0001;
        L0002:;
        }
        ctx->cur = p;
        goto L0000;
    L0001:;
        ctx->cur = p;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "WHILE", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "WHILE", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_THROW(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "THROW", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 5) < 5 ||
        (ctx->buffer.buf + ctx->cur)[0] != 't' ||
        (ctx->buffer.buf + ctx->cur)[1] != 'h' ||
        (ctx->buffer.buf + ctx->cur)[2] != 'r' ||
        (ctx->buffer.buf + ctx->cur)[3] != 'o' ||
        (ctx->buffer.buf + ctx->cur)[4] != 'w'
    ) goto L0000;
    ctx->cur += 5;
    {
        const size_t p = ctx->cur;
        {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_Letter, &chunk->thunks, NULL)) goto L0003;
            goto L0002;
        L0003:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_UnicodeDigit, &chunk->thunks, NULL)) goto L0004;
            goto L0002;
        L0004:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            goto L0001;
        L0002:;
        }
        ctx->cur = p;
        goto L0000;
    L0001:;
        ctx->cur = p;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "THROW", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "THROW", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_RETURN(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "RETURN", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 6) < 6 ||
        (ctx->buffer.buf + ctx->cur)[0] != 'r' ||
        (ctx->buffer.buf + ctx->cur)[1] != 'e' ||
        (ctx->buffer.buf + ctx->cur)[2] != 't' ||
        (ctx->buffer.buf + ctx->cur)[3] != 'u' ||
        (ctx->buffer.buf + ctx->cur)[4] != 'r' ||
        (ctx->buffer.buf + ctx->cur)[5] != 'n'
    ) goto L0000;
    ctx->cur += 6;
    {
        const size_t p = ctx->cur;
        {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_Letter, &chunk->thunks, NULL)) goto L0003;
            goto L0002;
        L0003:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_UnicodeDigit, &chunk->thunks, NULL)) goto L0004;
            goto L0002;
        L0004:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            goto L0001;
        L0002:;
        }
        ctx->cur = p;
        goto L0000;
    L0001:;
        ctx->cur = p;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "RETURN", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "RETURN", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_CONTINUE(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "CONTINUE", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 8) < 8 ||
        (ctx->buffer.buf + ctx->cur)[0] != 'c' ||
        (ctx->buffer.buf + ctx->cur)[1] != 'o' ||
        (ctx->buffer.buf + ctx->cur)[2] != 'n' ||
        (ctx->buffer.buf + ctx->cur)[3] != 't' ||
        (ctx->buffer.buf + ctx->cur)[4] != 'i' ||
        (ctx->buffer.buf + ctx->cur)[5] != 'n' ||
        (ctx->buffer.buf + ctx->cur)[6] != 'u' ||
        (ctx->buffer.buf + ctx->cur)[7] != 'e'
    ) goto L0000;
    ctx->cur += 8;
    {
        const size_t p = ctx->cur;
        {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_Letter, &chunk->thunks, NULL)) goto L0003;
            goto L0002;
        L0003:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_UnicodeDigit, &chunk->thunks, NULL)) goto L0004;
            goto L0002;
        L0004:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            goto L0001;
        L0002:;
        }
        ctx->cur = p;
        goto L0000;
    L0001:;
        ctx->cur = p;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "CONTINUE", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "CONTINUE", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_BREAK(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "BREAK", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 5) < 5 ||
        (ctx->buffer.buf + ctx->cur)[0] != 'b' ||
        (ctx->buffer.buf + ctx->cur)[1] != 'r' ||
        (ctx->buffer.buf + ctx->cur)[2] != 'e' ||
        (ctx->buffer.buf + ctx->cur)[3] != 'a' ||
        (ctx->buffer.buf + ctx->cur)[4] != 'k'
    ) goto L0000;
    ctx->cur += 5;
    {
        const size_t p = ctx->cur;
        {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_Letter, &chunk->thunks, NULL)) goto L0003;
            goto L0002;
        L0003:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_UnicodeDigit, &chunk->thunks, NULL)) goto L0004;
            goto L0002;
        L0004:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            goto L0001;
        L0002:;
        }
        ctx->cur = p;
        goto L0000;
    L0001:;
        ctx->cur = p;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "BREAK", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "BREAK", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_AS(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "AS", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 2) < 2 ||
        (ctx->buffer.buf + ctx->cur)[0] != 'a' ||
        (ctx->buffer.buf + ctx->cur)[1] != 's'
    ) goto L0000;
    ctx->cur += 2;
    {
        const size_t p = ctx->cur;
        {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_Letter, &chunk->thunks, NULL)) goto L0003;
            goto L0002;
        L0003:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_UnicodeDigit, &chunk->thunks, NULL)) goto L0004;
            goto L0002;
        L0004:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            goto L0001;
        L0002:;
        }
        ctx->cur = p;
        goto L0000;
    L0001:;
        ctx->cur = p;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "AS", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "AS", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_IS(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "IS", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 2) < 2 ||
        (ctx->buffer.buf + ctx->cur)[0] != 'i' ||
        (ctx->buffer.buf + ctx->cur)[1] != 's'
    ) goto L0000;
    ctx->cur += 2;
    {
        const size_t p = ctx->cur;
        {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_Letter, &chunk->thunks, NULL)) goto L0003;
            goto L0002;
        L0003:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_UnicodeDigit, &chunk->thunks, NULL)) goto L0004;
            goto L0002;
        L0004:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            goto L0001;
        L0002:;
        }
        ctx->cur = p;
        goto L0000;
    L0001:;
        ctx->cur = p;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "IS", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "IS", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_IN(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "IN", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 2) < 2 ||
        (ctx->buffer.buf + ctx->cur)[0] != 'i' ||
        (ctx->buffer.buf + ctx->cur)[1] != 'n'
    ) goto L0000;
    ctx->cur += 2;
    {
        const size_t p = ctx->cur;
        {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_Letter, &chunk->thunks, NULL)) goto L0003;
            goto L0002;
        L0003:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_UnicodeDigit, &chunk->thunks, NULL)) goto L0004;
            goto L0002;
        L0004:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            goto L0001;
        L0002:;
        }
        ctx->cur = p;
        goto L0000;
    L0001:;
        ctx->cur = p;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "IN", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "IN", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_NOT_IS(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "NOT_IS", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 3) < 3 ||
        (ctx->buffer.buf + ctx->cur)[0] != '!' ||
        (ctx->buffer.buf + ctx->cur)[1] != 'i' ||
        (ctx->buffer.buf + ctx->cur)[2] != 's'
    ) goto L0000;
    ctx->cur += 3;
    {
        const size_t p = ctx->cur;
        {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_Letter, &chunk->thunks, NULL)) goto L0003;
            goto L0002;
        L0003:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_UnicodeDigit, &chunk->thunks, NULL)) goto L0004;
            goto L0002;
        L0004:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            goto L0001;
        L0002:;
        }
        ctx->cur = p;
        goto L0000;
    L0001:;
        ctx->cur = p;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "NOT_IS", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "NOT_IS", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_NOT_IN(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "NOT_IN", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 3) < 3 ||
        (ctx->buffer.buf + ctx->cur)[0] != '!' ||
        (ctx->buffer.buf + ctx->cur)[1] != 'i' ||
        (ctx->buffer.buf + ctx->cur)[2] != 'n'
    ) goto L0000;
    ctx->cur += 3;
    {
        const size_t p = ctx->cur;
        {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_Letter, &chunk->thunks, NULL)) goto L0003;
            goto L0002;
        L0003:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_UnicodeDigit, &chunk->thunks, NULL)) goto L0004;
            goto L0002;
        L0004:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            goto L0001;
        L0002:;
        }
        ctx->cur = p;
        goto L0000;
    L0001:;
        ctx->cur = p;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "NOT_IN", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "NOT_IN", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_OUT(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "OUT", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 3) < 3 ||
        (ctx->buffer.buf + ctx->cur)[0] != 'o' ||
        (ctx->buffer.buf + ctx->cur)[1] != 'u' ||
        (ctx->buffer.buf + ctx->cur)[2] != 't'
    ) goto L0000;
    ctx->cur += 3;
    {
        const size_t p = ctx->cur;
        {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_Letter, &chunk->thunks, NULL)) goto L0003;
            goto L0002;
        L0003:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_UnicodeDigit, &chunk->thunks, NULL)) goto L0004;
            goto L0002;
        L0004:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            goto L0001;
        L0002:;
        }
        ctx->cur = p;
        goto L0000;
    L0001:;
        ctx->cur = p;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "OUT", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "OUT", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_DYNAMIC(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "DYNAMIC", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 7) < 7 ||
        (ctx->buffer.buf + ctx->cur)[0] != 'd' ||
        (ctx->buffer.buf + ctx->cur)[1] != 'y' ||
        (ctx->buffer.buf + ctx->cur)[2] != 'n' ||
        (ctx->buffer.buf + ctx->cur)[3] != 'a' ||
        (ctx->buffer.buf + ctx->cur)[4] != 'm' ||
        (ctx->buffer.buf + ctx->cur)[5] != 'i' ||
        (ctx->buffer.buf + ctx->cur)[6] != 'c'
    ) goto L0000;
    ctx->cur += 7;
    {
        const size_t p = ctx->cur;
        {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_Letter, &chunk->thunks, NULL)) goto L0003;
            goto L0002;
        L0003:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_UnicodeDigit, &chunk->thunks, NULL)) goto L0004;
            goto L0002;
        L0004:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            goto L0001;
        L0002:;
        }
        ctx->cur = p;
        goto L0000;
    L0001:;
        ctx->cur = p;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "DYNAMIC", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "DYNAMIC", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_PUBLIC(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "PUBLIC", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 6) < 6 ||
        (ctx->buffer.buf + ctx->cur)[0] != 'p' ||
        (ctx->buffer.buf + ctx->cur)[1] != 'u' ||
        (ctx->buffer.buf + ctx->cur)[2] != 'b' ||
        (ctx->buffer.buf + ctx->cur)[3] != 'l' ||
        (ctx->buffer.buf + ctx->cur)[4] != 'i' ||
        (ctx->buffer.buf + ctx->cur)[5] != 'c'
    ) goto L0000;
    ctx->cur += 6;
    {
        const size_t p = ctx->cur;
        {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_Letter, &chunk->thunks, NULL)) goto L0003;
            goto L0002;
        L0003:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_UnicodeDigit, &chunk->thunks, NULL)) goto L0004;
            goto L0002;
        L0004:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            goto L0001;
        L0002:;
        }
        ctx->cur = p;
        goto L0000;
    L0001:;
        ctx->cur = p;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "PUBLIC", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "PUBLIC", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_PRIVATE(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "PRIVATE", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 7) < 7 ||
        (ctx->buffer.buf + ctx->cur)[0] != 'p' ||
        (ctx->buffer.buf + ctx->cur)[1] != 'r' ||
        (ctx->buffer.buf + ctx->cur)[2] != 'i' ||
        (ctx->buffer.buf + ctx->cur)[3] != 'v' ||
        (ctx->buffer.buf + ctx->cur)[4] != 'a' ||
        (ctx->buffer.buf + ctx->cur)[5] != 't' ||
        (ctx->buffer.buf + ctx->cur)[6] != 'e'
    ) goto L0000;
    ctx->cur += 7;
    {
        const size_t p = ctx->cur;
        {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_Letter, &chunk->thunks, NULL)) goto L0003;
            goto L0002;
        L0003:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_UnicodeDigit, &chunk->thunks, NULL)) goto L0004;
            goto L0002;
        L0004:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            goto L0001;
        L0002:;
        }
        ctx->cur = p;
        goto L0000;
    L0001:;
        ctx->cur = p;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "PRIVATE", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "PRIVATE", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_PROTECTED(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "PROTECTED", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 9) < 9 ||
        (ctx->buffer.buf + ctx->cur)[0] != 'p' ||
        (ctx->buffer.buf + ctx->cur)[1] != 'r' ||
        (ctx->buffer.buf + ctx->cur)[2] != 'o' ||
        (ctx->buffer.buf + ctx->cur)[3] != 't' ||
        (ctx->buffer.buf + ctx->cur)[4] != 'e' ||
        (ctx->buffer.buf + ctx->cur)[5] != 'c' ||
        (ctx->buffer.buf + ctx->cur)[6] != 't' ||
        (ctx->buffer.buf + ctx->cur)[7] != 'e' ||
        (ctx->buffer.buf + ctx->cur)[8] != 'd'
    ) goto L0000;
    ctx->cur += 9;
    {
        const size_t p = ctx->cur;
        {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_Letter, &chunk->thunks, NULL)) goto L0003;
            goto L0002;
        L0003:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_UnicodeDigit, &chunk->thunks, NULL)) goto L0004;
            goto L0002;
        L0004:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            goto L0001;
        L0002:;
        }
        ctx->cur = p;
        goto L0000;
    L0001:;
        ctx->cur = p;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "PROTECTED", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "PROTECTED", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_INTERNAL(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "INTERNAL", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 8) < 8 ||
        (ctx->buffer.buf + ctx->cur)[0] != 'i' ||
        (ctx->buffer.buf + ctx->cur)[1] != 'n' ||
        (ctx->buffer.buf + ctx->cur)[2] != 't' ||
        (ctx->buffer.buf + ctx->cur)[3] != 'e' ||
        (ctx->buffer.buf + ctx->cur)[4] != 'r' ||
        (ctx->buffer.buf + ctx->cur)[5] != 'n' ||
        (ctx->buffer.buf + ctx->cur)[6] != 'a' ||
        (ctx->buffer.buf + ctx->cur)[7] != 'l'
    ) goto L0000;
    ctx->cur += 8;
    {
        const size_t p = ctx->cur;
        {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_Letter, &chunk->thunks, NULL)) goto L0003;
            goto L0002;
        L0003:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_UnicodeDigit, &chunk->thunks, NULL)) goto L0004;
            goto L0002;
        L0004:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            goto L0001;
        L0002:;
        }
        ctx->cur = p;
        goto L0000;
    L0001:;
        ctx->cur = p;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "INTERNAL", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "INTERNAL", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_ENUM(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "ENUM", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 4) < 4 ||
        (ctx->buffer.buf + ctx->cur)[0] != 'e' ||
        (ctx->buffer.buf + ctx->cur)[1] != 'n' ||
        (ctx->buffer.buf + ctx->cur)[2] != 'u' ||
        (ctx->buffer.buf + ctx->cur)[3] != 'm'
    ) goto L0000;
    ctx->cur += 4;
    {
        const size_t p = ctx->cur;
        {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_Letter, &chunk->thunks, NULL)) goto L0003;
            goto L0002;
        L0003:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_UnicodeDigit, &chunk->thunks, NULL)) goto L0004;
            goto L0002;
        L0004:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            goto L0001;
        L0002:;
        }
        ctx->cur = p;
        goto L0000;
    L0001:;
        ctx->cur = p;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "ENUM", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "ENUM", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_SEALED(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "SEALED", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 6) < 6 ||
        (ctx->buffer.buf + ctx->cur)[0] != 's' ||
        (ctx->buffer.buf + ctx->cur)[1] != 'e' ||
        (ctx->buffer.buf + ctx->cur)[2] != 'a' ||
        (ctx->buffer.buf + ctx->cur)[3] != 'l' ||
        (ctx->buffer.buf + ctx->cur)[4] != 'e' ||
        (ctx->buffer.buf + ctx->cur)[5] != 'd'
    ) goto L0000;
    ctx->cur += 6;
    {
        const size_t p = ctx->cur;
        {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_Letter, &chunk->thunks, NULL)) goto L0003;
            goto L0002;
        L0003:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_UnicodeDigit, &chunk->thunks, NULL)) goto L0004;
            goto L0002;
        L0004:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            goto L0001;
        L0002:;
        }
        ctx->cur = p;
        goto L0000;
    L0001:;
        ctx->cur = p;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "SEALED", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "SEALED", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_ANNOTATION(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "ANNOTATION", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 10) < 10 ||
        (ctx->buffer.buf + ctx->cur)[0] != 'a' ||
        (ctx->buffer.buf + ctx->cur)[1] != 'n' ||
        (ctx->buffer.buf + ctx->cur)[2] != 'n' ||
        (ctx->buffer.buf + ctx->cur)[3] != 'o' ||
        (ctx->buffer.buf + ctx->cur)[4] != 't' ||
        (ctx->buffer.buf + ctx->cur)[5] != 'a' ||
        (ctx->buffer.buf + ctx->cur)[6] != 't' ||
        (ctx->buffer.buf + ctx->cur)[7] != 'i' ||
        (ctx->buffer.buf + ctx->cur)[8] != 'o' ||
        (ctx->buffer.buf + ctx->cur)[9] != 'n'
    ) goto L0000;
    ctx->cur += 10;
    {
        const size_t p = ctx->cur;
        {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_Letter, &chunk->thunks, NULL)) goto L0003;
            goto L0002;
        L0003:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_UnicodeDigit, &chunk->thunks, NULL)) goto L0004;
            goto L0002;
        L0004:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            goto L0001;
        L0002:;
        }
        ctx->cur = p;
        goto L0000;
    L0001:;
        ctx->cur = p;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "ANNOTATION", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "ANNOTATION", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_DATA(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "DATA", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 4) < 4 ||
        (ctx->buffer.buf + ctx->cur)[0] != 'd' ||
        (ctx->buffer.buf + ctx->cur)[1] != 'a' ||
        (ctx->buffer.buf + ctx->cur)[2] != 't' ||
        (ctx->buffer.buf + ctx->cur)[3] != 'a'
    ) goto L0000;
    ctx->cur += 4;
    {
        const size_t p = ctx->cur;
        {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_Letter, &chunk->thunks, NULL)) goto L0003;
            goto L0002;
        L0003:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_UnicodeDigit, &chunk->thunks, NULL)) goto L0004;
            goto L0002;
        L0004:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            goto L0001;
        L0002:;
        }
        ctx->cur = p;
        goto L0000;
    L0001:;
        ctx->cur = p;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "DATA", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "DATA", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_INNER(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "INNER", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 5) < 5 ||
        (ctx->buffer.buf + ctx->cur)[0] != 'i' ||
        (ctx->buffer.buf + ctx->cur)[1] != 'n' ||
        (ctx->buffer.buf + ctx->cur)[2] != 'n' ||
        (ctx->buffer.buf + ctx->cur)[3] != 'e' ||
        (ctx->buffer.buf + ctx->cur)[4] != 'r'
    ) goto L0000;
    ctx->cur += 5;
    {
        const size_t p = ctx->cur;
        {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_Letter, &chunk->thunks, NULL)) goto L0003;
            goto L0002;
        L0003:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_UnicodeDigit, &chunk->thunks, NULL)) goto L0004;
            goto L0002;
        L0004:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            goto L0001;
        L0002:;
        }
        ctx->cur = p;
        goto L0000;
    L0001:;
        ctx->cur = p;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "INNER", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "INNER", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_TAILREC(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "TAILREC", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 7) < 7 ||
        (ctx->buffer.buf + ctx->cur)[0] != 't' ||
        (ctx->buffer.buf + ctx->cur)[1] != 'a' ||
        (ctx->buffer.buf + ctx->cur)[2] != 'i' ||
        (ctx->buffer.buf + ctx->cur)[3] != 'l' ||
        (ctx->buffer.buf + ctx->cur)[4] != 'r' ||
        (ctx->buffer.buf + ctx->cur)[5] != 'e' ||
        (ctx->buffer.buf + ctx->cur)[6] != 'c'
    ) goto L0000;
    ctx->cur += 7;
    {
        const size_t p = ctx->cur;
        {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_Letter, &chunk->thunks, NULL)) goto L0003;
            goto L0002;
        L0003:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_UnicodeDigit, &chunk->thunks, NULL)) goto L0004;
            goto L0002;
        L0004:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            goto L0001;
        L0002:;
        }
        ctx->cur = p;
        goto L0000;
    L0001:;
        ctx->cur = p;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "TAILREC", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "TAILREC", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_OPERATOR(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "OPERATOR", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 8) < 8 ||
        (ctx->buffer.buf + ctx->cur)[0] != 'o' ||
        (ctx->buffer.buf + ctx->cur)[1] != 'p' ||
        (ctx->buffer.buf + ctx->cur)[2] != 'e' ||
        (ctx->buffer.buf + ctx->cur)[3] != 'r' ||
        (ctx->buffer.buf + ctx->cur)[4] != 'a' ||
        (ctx->buffer.buf + ctx->cur)[5] != 't' ||
        (ctx->buffer.buf + ctx->cur)[6] != 'o' ||
        (ctx->buffer.buf + ctx->cur)[7] != 'r'
    ) goto L0000;
    ctx->cur += 8;
    {
        const size_t p = ctx->cur;
        {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_Letter, &chunk->thunks, NULL)) goto L0003;
            goto L0002;
        L0003:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_UnicodeDigit, &chunk->thunks, NULL)) goto L0004;
            goto L0002;
        L0004:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            goto L0001;
        L0002:;
        }
        ctx->cur = p;
        goto L0000;
    L0001:;
        ctx->cur = p;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "OPERATOR", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "OPERATOR", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_INLINE(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "INLINE", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 6) < 6 ||
        (ctx->buffer.buf + ctx->cur)[0] != 'i' ||
        (ctx->buffer.buf + ctx->cur)[1] != 'n' ||
        (ctx->buffer.buf + ctx->cur)[2] != 'l' ||
        (ctx->buffer.buf + ctx->cur)[3] != 'i' ||
        (ctx->buffer.buf + ctx->cur)[4] != 'n' ||
        (ctx->buffer.buf + ctx->cur)[5] != 'e'
    ) goto L0000;
    ctx->cur += 6;
    {
        const size_t p = ctx->cur;
        {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_Letter, &chunk->thunks, NULL)) goto L0003;
            goto L0002;
        L0003:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_UnicodeDigit, &chunk->thunks, NULL)) goto L0004;
            goto L0002;
        L0004:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            goto L0001;
        L0002:;
        }
        ctx->cur = p;
        goto L0000;
    L0001:;
        ctx->cur = p;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "INLINE", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "INLINE", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_INFIX(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "INFIX", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 5) < 5 ||
        (ctx->buffer.buf + ctx->cur)[0] != 'i' ||
        (ctx->buffer.buf + ctx->cur)[1] != 'n' ||
        (ctx->buffer.buf + ctx->cur)[2] != 'f' ||
        (ctx->buffer.buf + ctx->cur)[3] != 'i' ||
        (ctx->buffer.buf + ctx->cur)[4] != 'x'
    ) goto L0000;
    ctx->cur += 5;
    {
        const size_t p = ctx->cur;
        {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_Letter, &chunk->thunks, NULL)) goto L0003;
            goto L0002;
        L0003:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_UnicodeDigit, &chunk->thunks, NULL)) goto L0004;
            goto L0002;
        L0004:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            goto L0001;
        L0002:;
        }
        ctx->cur = p;
        goto L0000;
    L0001:;
        ctx->cur = p;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "INFIX", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "INFIX", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_EXTERNAL(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "EXTERNAL", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 8) < 8 ||
        (ctx->buffer.buf + ctx->cur)[0] != 'e' ||
        (ctx->buffer.buf + ctx->cur)[1] != 'x' ||
        (ctx->buffer.buf + ctx->cur)[2] != 't' ||
        (ctx->buffer.buf + ctx->cur)[3] != 'e' ||
        (ctx->buffer.buf + ctx->cur)[4] != 'r' ||
        (ctx->buffer.buf + ctx->cur)[5] != 'n' ||
        (ctx->buffer.buf + ctx->cur)[6] != 'a' ||
        (ctx->buffer.buf + ctx->cur)[7] != 'l'
    ) goto L0000;
    ctx->cur += 8;
    {
        const size_t p = ctx->cur;
        {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_Letter, &chunk->thunks, NULL)) goto L0003;
            goto L0002;
        L0003:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_UnicodeDigit, &chunk->thunks, NULL)) goto L0004;
            goto L0002;
        L0004:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            goto L0001;
        L0002:;
        }
        ctx->cur = p;
        goto L0000;
    L0001:;
        ctx->cur = p;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "EXTERNAL", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "EXTERNAL", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_SUSPEND(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "SUSPEND", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 7) < 7 ||
        (ctx->buffer.buf + ctx->cur)[0] != 's' ||
        (ctx->buffer.buf + ctx->cur)[1] != 'u' ||
        (ctx->buffer.buf + ctx->cur)[2] != 's' ||
        (ctx->buffer.buf + ctx->cur)[3] != 'p' ||
        (ctx->buffer.buf + ctx->cur)[4] != 'e' ||
        (ctx->buffer.buf + ctx->cur)[5] != 'n' ||
        (ctx->buffer.buf + ctx->cur)[6] != 'd'
    ) goto L0000;
    ctx->cur += 7;
    {
        const size_t p = ctx->cur;
        {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_Letter, &chunk->thunks, NULL)) goto L0003;
            goto L0002;
        L0003:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_UnicodeDigit, &chunk->thunks, NULL)) goto L0004;
            goto L0002;
        L0004:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            goto L0001;
        L0002:;
        }
        ctx->cur = p;
        goto L0000;
    L0001:;
        ctx->cur = p;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "SUSPEND", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "SUSPEND", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_OVERRIDE(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "OVERRIDE", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 8) < 8 ||
        (ctx->buffer.buf + ctx->cur)[0] != 'o' ||
        (ctx->buffer.buf + ctx->cur)[1] != 'v' ||
        (ctx->buffer.buf + ctx->cur)[2] != 'e' ||
        (ctx->buffer.buf + ctx->cur)[3] != 'r' ||
        (ctx->buffer.buf + ctx->cur)[4] != 'r' ||
        (ctx->buffer.buf + ctx->cur)[5] != 'i' ||
        (ctx->buffer.buf + ctx->cur)[6] != 'd' ||
        (ctx->buffer.buf + ctx->cur)[7] != 'e'
    ) goto L0000;
    ctx->cur += 8;
    {
        const size_t p = ctx->cur;
        {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_Letter, &chunk->thunks, NULL)) goto L0003;
            goto L0002;
        L0003:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_UnicodeDigit, &chunk->thunks, NULL)) goto L0004;
            goto L0002;
        L0004:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            goto L0001;
        L0002:;
        }
        ctx->cur = p;
        goto L0000;
    L0001:;
        ctx->cur = p;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "OVERRIDE", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "OVERRIDE", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_ABSTRACT(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "ABSTRACT", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 8) < 8 ||
        (ctx->buffer.buf + ctx->cur)[0] != 'a' ||
        (ctx->buffer.buf + ctx->cur)[1] != 'b' ||
        (ctx->buffer.buf + ctx->cur)[2] != 's' ||
        (ctx->buffer.buf + ctx->cur)[3] != 't' ||
        (ctx->buffer.buf + ctx->cur)[4] != 'r' ||
        (ctx->buffer.buf + ctx->cur)[5] != 'a' ||
        (ctx->buffer.buf + ctx->cur)[6] != 'c' ||
        (ctx->buffer.buf + ctx->cur)[7] != 't'
    ) goto L0000;
    ctx->cur += 8;
    {
        const size_t p = ctx->cur;
        {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_Letter, &chunk->thunks, NULL)) goto L0003;
            goto L0002;
        L0003:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_UnicodeDigit, &chunk->thunks, NULL)) goto L0004;
            goto L0002;
        L0004:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            goto L0001;
        L0002:;
        }
        ctx->cur = p;
        goto L0000;
    L0001:;
        ctx->cur = p;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "ABSTRACT", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "ABSTRACT", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_FINAL(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "FINAL", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 5) < 5 ||
        (ctx->buffer.buf + ctx->cur)[0] != 'f' ||
        (ctx->buffer.buf + ctx->cur)[1] != 'i' ||
        (ctx->buffer.buf + ctx->cur)[2] != 'n' ||
        (ctx->buffer.buf + ctx->cur)[3] != 'a' ||
        (ctx->buffer.buf + ctx->cur)[4] != 'l'
    ) goto L0000;
    ctx->cur += 5;
    {
        const size_t p = ctx->cur;
        {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_Letter, &chunk->thunks, NULL)) goto L0003;
            goto L0002;
        L0003:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_UnicodeDigit, &chunk->thunks, NULL)) goto L0004;
            goto L0002;
        L0004:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            goto L0001;
        L0002:;
        }
        ctx->cur = p;
        goto L0000;
    L0001:;
        ctx->cur = p;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "FINAL", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "FINAL", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_OPEN(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "OPEN", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 4) < 4 ||
        (ctx->buffer.buf + ctx->cur)[0] != 'o' ||
        (ctx->buffer.buf + ctx->cur)[1] != 'p' ||
        (ctx->buffer.buf + ctx->cur)[2] != 'e' ||
        (ctx->buffer.buf + ctx->cur)[3] != 'n'
    ) goto L0000;
    ctx->cur += 4;
    {
        const size_t p = ctx->cur;
        {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_Letter, &chunk->thunks, NULL)) goto L0003;
            goto L0002;
        L0003:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_UnicodeDigit, &chunk->thunks, NULL)) goto L0004;
            goto L0002;
        L0004:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            goto L0001;
        L0002:;
        }
        ctx->cur = p;
        goto L0000;
    L0001:;
        ctx->cur = p;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "OPEN", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "OPEN", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_CONST(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "CONST", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 5) < 5 ||
        (ctx->buffer.buf + ctx->cur)[0] != 'c' ||
        (ctx->buffer.buf + ctx->cur)[1] != 'o' ||
        (ctx->buffer.buf + ctx->cur)[2] != 'n' ||
        (ctx->buffer.buf + ctx->cur)[3] != 's' ||
        (ctx->buffer.buf + ctx->cur)[4] != 't'
    ) goto L0000;
    ctx->cur += 5;
    {
        const size_t p = ctx->cur;
        {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_Letter, &chunk->thunks, NULL)) goto L0003;
            goto L0002;
        L0003:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_UnicodeDigit, &chunk->thunks, NULL)) goto L0004;
            goto L0002;
        L0004:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            goto L0001;
        L0002:;
        }
        ctx->cur = p;
        goto L0000;
    L0001:;
        ctx->cur = p;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "CONST", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "CONST", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_LATEINIT(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "LATEINIT", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 8) < 8 ||
        (ctx->buffer.buf + ctx->cur)[0] != 'l' ||
        (ctx->buffer.buf + ctx->cur)[1] != 'a' ||
        (ctx->buffer.buf + ctx->cur)[2] != 't' ||
        (ctx->buffer.buf + ctx->cur)[3] != 'e' ||
        (ctx->buffer.buf + ctx->cur)[4] != 'i' ||
        (ctx->buffer.buf + ctx->cur)[5] != 'n' ||
        (ctx->buffer.buf + ctx->cur)[6] != 'i' ||
        (ctx->buffer.buf + ctx->cur)[7] != 't'
    ) goto L0000;
    ctx->cur += 8;
    {
        const size_t p = ctx->cur;
        {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_Letter, &chunk->thunks, NULL)) goto L0003;
            goto L0002;
        L0003:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_UnicodeDigit, &chunk->thunks, NULL)) goto L0004;
            goto L0002;
        L0004:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            goto L0001;
        L0002:;
        }
        ctx->cur = p;
        goto L0000;
    L0001:;
        ctx->cur = p;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "LATEINIT", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "LATEINIT", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_VARARG(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "VARARG", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 6) < 6 ||
        (ctx->buffer.buf + ctx->cur)[0] != 'v' ||
        (ctx->buffer.buf + ctx->cur)[1] != 'a' ||
        (ctx->buffer.buf + ctx->cur)[2] != 'r' ||
        (ctx->buffer.buf + ctx->cur)[3] != 'a' ||
        (ctx->buffer.buf + ctx->cur)[4] != 'r' ||
        (ctx->buffer.buf + ctx->cur)[5] != 'g'
    ) goto L0000;
    ctx->cur += 6;
    {
        const size_t p = ctx->cur;
        {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_Letter, &chunk->thunks, NULL)) goto L0003;
            goto L0002;
        L0003:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_UnicodeDigit, &chunk->thunks, NULL)) goto L0004;
            goto L0002;
        L0004:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            goto L0001;
        L0002:;
        }
        ctx->cur = p;
        goto L0000;
    L0001:;
        ctx->cur = p;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "VARARG", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "VARARG", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_NOINLINE(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "NOINLINE", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 8) < 8 ||
        (ctx->buffer.buf + ctx->cur)[0] != 'n' ||
        (ctx->buffer.buf + ctx->cur)[1] != 'o' ||
        (ctx->buffer.buf + ctx->cur)[2] != 'i' ||
        (ctx->buffer.buf + ctx->cur)[3] != 'n' ||
        (ctx->buffer.buf + ctx->cur)[4] != 'l' ||
        (ctx->buffer.buf + ctx->cur)[5] != 'i' ||
        (ctx->buffer.buf + ctx->cur)[6] != 'n' ||
        (ctx->buffer.buf + ctx->cur)[7] != 'e'
    ) goto L0000;
    ctx->cur += 8;
    {
        const size_t p = ctx->cur;
        {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_Letter, &chunk->thunks, NULL)) goto L0003;
            goto L0002;
        L0003:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_UnicodeDigit, &chunk->thunks, NULL)) goto L0004;
            goto L0002;
        L0004:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            goto L0001;
        L0002:;
        }
        ctx->cur = p;
        goto L0000;
    L0001:;
        ctx->cur = p;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "NOINLINE", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "NOINLINE", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_CROSSINLINE(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "CROSSINLINE", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 11) < 11 ||
        (ctx->buffer.buf + ctx->cur)[0] != 'c' ||
        (ctx->buffer.buf + ctx->cur)[1] != 'r' ||
        (ctx->buffer.buf + ctx->cur)[2] != 'o' ||
        (ctx->buffer.buf + ctx->cur)[3] != 's' ||
        (ctx->buffer.buf + ctx->cur)[4] != 's' ||
        (ctx->buffer.buf + ctx->cur)[5] != 'i' ||
        (ctx->buffer.buf + ctx->cur)[6] != 'n' ||
        (ctx->buffer.buf + ctx->cur)[7] != 'l' ||
        (ctx->buffer.buf + ctx->cur)[8] != 'i' ||
        (ctx->buffer.buf + ctx->cur)[9] != 'n' ||
        (ctx->buffer.buf + ctx->cur)[10] != 'e'
    ) goto L0000;
    ctx->cur += 11;
    {
        const size_t p = ctx->cur;
        {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_Letter, &chunk->thunks, NULL)) goto L0003;
            goto L0002;
        L0003:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_UnicodeDigit, &chunk->thunks, NULL)) goto L0004;
            goto L0002;
        L0004:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            goto L0001;
        L0002:;
        }
        ctx->cur = p;
        goto L0000;
    L0001:;
        ctx->cur = p;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "CROSSINLINE", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "CROSSINLINE", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_REIFIED(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "REIFIED", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 7) < 7 ||
        (ctx->buffer.buf + ctx->cur)[0] != 'r' ||
        (ctx->buffer.buf + ctx->cur)[1] != 'e' ||
        (ctx->buffer.buf + ctx->cur)[2] != 'i' ||
        (ctx->buffer.buf + ctx->cur)[3] != 'f' ||
        (ctx->buffer.buf + ctx->cur)[4] != 'i' ||
        (ctx->buffer.buf + ctx->cur)[5] != 'e' ||
        (ctx->buffer.buf + ctx->cur)[6] != 'd'
    ) goto L0000;
    ctx->cur += 7;
    {
        const size_t p = ctx->cur;
        {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_Letter, &chunk->thunks, NULL)) goto L0003;
            goto L0002;
        L0003:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_UnicodeDigit, &chunk->thunks, NULL)) goto L0004;
            goto L0002;
        L0004:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            goto L0001;
        L0002:;
        }
        ctx->cur = p;
        goto L0000;
    L0001:;
        ctx->cur = p;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "REIFIED", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "REIFIED", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_EXPECT(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "EXPECT", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 6) < 6 ||
        (ctx->buffer.buf + ctx->cur)[0] != 'e' ||
        (ctx->buffer.buf + ctx->cur)[1] != 'x' ||
        (ctx->buffer.buf + ctx->cur)[2] != 'p' ||
        (ctx->buffer.buf + ctx->cur)[3] != 'e' ||
        (ctx->buffer.buf + ctx->cur)[4] != 'c' ||
        (ctx->buffer.buf + ctx->cur)[5] != 't'
    ) goto L0000;
    ctx->cur += 6;
    {
        const size_t p = ctx->cur;
        {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_Letter, &chunk->thunks, NULL)) goto L0003;
            goto L0002;
        L0003:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_UnicodeDigit, &chunk->thunks, NULL)) goto L0004;
            goto L0002;
        L0004:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            goto L0001;
        L0002:;
        }
        ctx->cur = p;
        goto L0000;
    L0001:;
        ctx->cur = p;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "EXPECT", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "EXPECT", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_ACTUAL(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "ACTUAL", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 6) < 6 ||
        (ctx->buffer.buf + ctx->cur)[0] != 'a' ||
        (ctx->buffer.buf + ctx->cur)[1] != 'c' ||
        (ctx->buffer.buf + ctx->cur)[2] != 't' ||
        (ctx->buffer.buf + ctx->cur)[3] != 'u' ||
        (ctx->buffer.buf + ctx->cur)[4] != 'a' ||
        (ctx->buffer.buf + ctx->cur)[5] != 'l'
    ) goto L0000;
    ctx->cur += 6;
    {
        const size_t p = ctx->cur;
        {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_Letter, &chunk->thunks, NULL)) goto L0003;
            goto L0002;
        L0003:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_UnicodeDigit, &chunk->thunks, NULL)) goto L0004;
            goto L0002;
        L0004:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            goto L0001;
        L0002:;
        }
        ctx->cur = p;
        goto L0000;
    L0001:;
        ctx->cur = p;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "ACTUAL", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "ACTUAL", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_DecDigit(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "DecDigit", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        int u;
        const size_t n = pcc_get_char_as_utf32(ctx, &u);
        if (n == 0) goto L0000;
        if (!(
            (u >= 0x000030 && u <= 0x000039)
        )) goto L0000;
        ctx->cur += n;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "DecDigit", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "DecDigit", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_DecDigitNoZero(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "DecDigitNoZero", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        int u;
        const size_t n = pcc_get_char_as_utf32(ctx, &u);
        if (n == 0) goto L0000;
        if (!(
            (u >= 0x000031 && u <= 0x000039)
        )) goto L0000;
        ctx->cur += n;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "DecDigitNoZero", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "DecDigitNoZero", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_DecDigitOrSeparator(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "DecDigitOrSeparator", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_DecDigit, &chunk->thunks, NULL)) goto L0002;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (
            pcc_refill_buffer(ctx, 1) < 1 ||
            ctx->buffer.buf[ctx->cur] != '_'
        ) goto L0003;
        ctx->cur++;
        goto L0001;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "DecDigitOrSeparator", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "DecDigitOrSeparator", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_DecDigits(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "DecDigits", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_DecDigit, &chunk->thunks, NULL)) goto L0002;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule_DecDigitOrSeparator, &chunk->thunks, NULL)) goto L0003;
                if (ctx->cur == p) break;
                continue;
            L0003:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_DecDigit, &chunk->thunks, NULL)) goto L0004;
        goto L0001;
    L0004:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "DecDigits", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "DecDigits", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_DoubleExponent(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "DoubleExponent", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        int u;
        const size_t n = pcc_get_char_as_utf32(ctx, &u);
        if (n == 0) goto L0000;
        if (!(
            u == 0x000065 ||
            u == 0x000045
        )) goto L0000;
        ctx->cur += n;
    }
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        {
            int u;
            const size_t n = pcc_get_char_as_utf32(ctx, &u);
            if (n == 0) goto L0001;
            if (!(
                u == 0x00002d ||
                u == 0x00002b
            )) goto L0001;
            ctx->cur += n;
        }
        goto L0002;
    L0001:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0002:;
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_DecDigits, &chunk->thunks, NULL)) goto L0000;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "DoubleExponent", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "DoubleExponent", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_RealLiteral(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "RealLiteral", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_FloatLiteral, &chunk->thunks, NULL)) goto L0002;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_DoubleLiteral, &chunk->thunks, NULL)) goto L0003;
        goto L0001;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "RealLiteral", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "RealLiteral", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_FloatLiteral(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "FloatLiteral", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_DoubleLiteral, &chunk->thunks, NULL)) goto L0002;
        {
            int u;
            const size_t n = pcc_get_char_as_utf32(ctx, &u);
            if (n == 0) goto L0002;
            if (!(
                u == 0x000066 ||
                u == 0x000046
            )) goto L0002;
            ctx->cur += n;
        }
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_DecDigits, &chunk->thunks, NULL)) goto L0003;
        {
            int u;
            const size_t n = pcc_get_char_as_utf32(ctx, &u);
            if (n == 0) goto L0003;
            if (!(
                u == 0x000066 ||
                u == 0x000046
            )) goto L0003;
            ctx->cur += n;
        }
        goto L0001;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "FloatLiteral", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "FloatLiteral", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_DoubleLiteral(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "DoubleLiteral", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_DecDigits, &chunk->thunks, NULL)) goto L0003;
            goto L0004;
        L0003:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        L0004:;
        }
        if (
            pcc_refill_buffer(ctx, 1) < 1 ||
            ctx->buffer.buf[ctx->cur] != '.'
        ) goto L0002;
        ctx->cur++;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_DecDigits, &chunk->thunks, NULL)) goto L0002;
        {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_DoubleExponent, &chunk->thunks, NULL)) goto L0005;
            goto L0006;
        L0005:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        L0006:;
        }
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_DecDigits, &chunk->thunks, NULL)) goto L0007;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_DoubleExponent, &chunk->thunks, NULL)) goto L0007;
        goto L0001;
    L0007:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "DoubleLiteral", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "DoubleLiteral", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_IntegerLiteral(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "IntegerLiteral", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_DecDigitNoZero, &chunk->thunks, NULL)) goto L0002;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule_DecDigitOrSeparator, &chunk->thunks, NULL)) goto L0003;
                if (ctx->cur == p) break;
                continue;
            L0003:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_DecDigit, &chunk->thunks, NULL)) goto L0004;
        goto L0001;
    L0004:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "IntegerLiteral", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "IntegerLiteral", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_HexDigit(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "HexDigit", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        int u;
        const size_t n = pcc_get_char_as_utf32(ctx, &u);
        if (n == 0) goto L0000;
        if (!(
            (u >= 0x000030 && u <= 0x000039) ||
            (u >= 0x000061 && u <= 0x000066) ||
            (u >= 0x000041 && u <= 0x000046)
        )) goto L0000;
        ctx->cur += n;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "HexDigit", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "HexDigit", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_HexDigitOrSeparator(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "HexDigitOrSeparator", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_HexDigit, &chunk->thunks, NULL)) goto L0002;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (
            pcc_refill_buffer(ctx, 1) < 1 ||
            ctx->buffer.buf[ctx->cur] != '_'
        ) goto L0003;
        ctx->cur++;
        goto L0001;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "HexDigitOrSeparator", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "HexDigitOrSeparator", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_HexLiteral(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "HexLiteral", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (
            pcc_refill_buffer(ctx, 1) < 1 ||
            ctx->buffer.buf[ctx->cur] != '0'
        ) goto L0002;
        ctx->cur++;
        {
            int u;
            const size_t n = pcc_get_char_as_utf32(ctx, &u);
            if (n == 0) goto L0002;
            if (!(
                u == 0x000078 ||
                u == 0x000058
            )) goto L0002;
            ctx->cur += n;
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_HexDigit, &chunk->thunks, NULL)) goto L0002;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule_HexDigitOrSeparator, &chunk->thunks, NULL)) goto L0003;
                if (ctx->cur == p) break;
                continue;
            L0003:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (
            pcc_refill_buffer(ctx, 1) < 1 ||
            ctx->buffer.buf[ctx->cur] != '0'
        ) goto L0004;
        ctx->cur++;
        {
            int u;
            const size_t n = pcc_get_char_as_utf32(ctx, &u);
            if (n == 0) goto L0004;
            if (!(
                u == 0x000078 ||
                u == 0x000058
            )) goto L0004;
            ctx->cur += n;
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_HexDigit, &chunk->thunks, NULL)) goto L0004;
        goto L0001;
    L0004:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "HexLiteral", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "HexLiteral", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_BinDigit(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "BinDigit", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        int u;
        const size_t n = pcc_get_char_as_utf32(ctx, &u);
        if (n == 0) goto L0000;
        if (!(
            u == 0x000030 ||
            u == 0x000031
        )) goto L0000;
        ctx->cur += n;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "BinDigit", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "BinDigit", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_BinDigitOrSeparator(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "BinDigitOrSeparator", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_BinDigit, &chunk->thunks, NULL)) goto L0002;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (
            pcc_refill_buffer(ctx, 1) < 1 ||
            ctx->buffer.buf[ctx->cur] != '_'
        ) goto L0003;
        ctx->cur++;
        goto L0001;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "BinDigitOrSeparator", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "BinDigitOrSeparator", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_BinLiteral(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "BinLiteral", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (
            pcc_refill_buffer(ctx, 1) < 1 ||
            ctx->buffer.buf[ctx->cur] != '0'
        ) goto L0002;
        ctx->cur++;
        {
            int u;
            const size_t n = pcc_get_char_as_utf32(ctx, &u);
            if (n == 0) goto L0002;
            if (!(
                u == 0x000062 ||
                u == 0x000042
            )) goto L0002;
            ctx->cur += n;
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_BinDigit, &chunk->thunks, NULL)) goto L0002;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule_BinDigitOrSeparator, &chunk->thunks, NULL)) goto L0003;
                if (ctx->cur == p) break;
                continue;
            L0003:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (
            pcc_refill_buffer(ctx, 1) < 1 ||
            ctx->buffer.buf[ctx->cur] != '0'
        ) goto L0004;
        ctx->cur++;
        {
            int u;
            const size_t n = pcc_get_char_as_utf32(ctx, &u);
            if (n == 0) goto L0004;
            if (!(
                u == 0x000062 ||
                u == 0x000042
            )) goto L0004;
            ctx->cur += n;
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_BinDigit, &chunk->thunks, NULL)) goto L0004;
        goto L0001;
    L0004:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "BinLiteral", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "BinLiteral", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_UnsignedLiteral(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "UnsignedLiteral", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_HexLiteral, &chunk->thunks, NULL)) goto L0002;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_BinLiteral, &chunk->thunks, NULL)) goto L0003;
        goto L0001;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_IntegerLiteral, &chunk->thunks, NULL)) goto L0004;
        goto L0001;
    L0004:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    {
        int u;
        const size_t n = pcc_get_char_as_utf32(ctx, &u);
        if (n == 0) goto L0000;
        if (!(
            u == 0x000075 ||
            u == 0x000055
        )) goto L0000;
        ctx->cur += n;
    }
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        {
            int u;
            const size_t n = pcc_get_char_as_utf32(ctx, &u);
            if (n == 0) goto L0005;
            if (!(
                u == 0x00006c ||
                u == 0x00004c
            )) goto L0005;
            ctx->cur += n;
        }
        goto L0006;
    L0005:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0006:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "UnsignedLiteral", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "UnsignedLiteral", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_LongLiteral(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "LongLiteral", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_HexLiteral, &chunk->thunks, NULL)) goto L0002;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_BinLiteral, &chunk->thunks, NULL)) goto L0003;
        goto L0001;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_IntegerLiteral, &chunk->thunks, NULL)) goto L0004;
        goto L0001;
    L0004:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    {
        int u;
        const size_t n = pcc_get_char_as_utf32(ctx, &u);
        if (n == 0) goto L0000;
        if (!(
            u == 0x00006c ||
            u == 0x00004c
        )) goto L0000;
        ctx->cur += n;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "LongLiteral", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "LongLiteral", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_BooleanLiteral(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "BooleanLiteral", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (
            pcc_refill_buffer(ctx, 4) < 4 ||
            (ctx->buffer.buf + ctx->cur)[0] != 't' ||
            (ctx->buffer.buf + ctx->cur)[1] != 'r' ||
            (ctx->buffer.buf + ctx->cur)[2] != 'u' ||
            (ctx->buffer.buf + ctx->cur)[3] != 'e'
        ) goto L0002;
        ctx->cur += 4;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (
            pcc_refill_buffer(ctx, 5) < 5 ||
            (ctx->buffer.buf + ctx->cur)[0] != 'f' ||
            (ctx->buffer.buf + ctx->cur)[1] != 'a' ||
            (ctx->buffer.buf + ctx->cur)[2] != 'l' ||
            (ctx->buffer.buf + ctx->cur)[3] != 's' ||
            (ctx->buffer.buf + ctx->cur)[4] != 'e'
        ) goto L0003;
        ctx->cur += 5;
        goto L0001;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "BooleanLiteral", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "BooleanLiteral", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_NullLiteral(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "NullLiteral", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 4) < 4 ||
        (ctx->buffer.buf + ctx->cur)[0] != 'n' ||
        (ctx->buffer.buf + ctx->cur)[1] != 'u' ||
        (ctx->buffer.buf + ctx->cur)[2] != 'l' ||
        (ctx->buffer.buf + ctx->cur)[3] != 'l'
    ) goto L0000;
    ctx->cur += 4;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "NullLiteral", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "NullLiteral", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_CharacterLiteral(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "CharacterLiteral", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 1) < 1 ||
        ctx->buffer.buf[ctx->cur] != '\''
    ) goto L0000;
    ctx->cur++;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_EscapeSeq, &chunk->thunks, NULL)) goto L0002;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        {
            int u;
            const size_t n = pcc_get_char_as_utf32(ctx, &u);
            if (n == 0) goto L0003;
            if (
                u == 0x00000a ||
                u == 0x00000d ||
                u == 0x000027 ||
                u == 0x00005c
            ) goto L0003;
            ctx->cur += n;
        }
        goto L0001;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    if (
        pcc_refill_buffer(ctx, 1) < 1 ||
        ctx->buffer.buf[ctx->cur] != '\''
    ) goto L0000;
    ctx->cur++;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "CharacterLiteral", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "CharacterLiteral", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_Identifier(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "Identifier", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (
            pcc_refill_buffer(ctx, 1) < 1 ||
            ctx->buffer.buf[ctx->cur] != '`'
        ) goto L0002;
        ctx->cur++;
        {
            const size_t p0 = ctx->cur;
            const size_t n0 = chunk->thunks.len;
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                {
                    int u;
                    const size_t n = pcc_get_char_as_utf32(ctx, &u);
                    if (n == 0) goto L0003;
                    if (
                        u == 0x000060 ||
                        u == 0x00000d ||
                        u == 0x00000a
                    ) goto L0003;
                    ctx->cur += n;
                }
                if (ctx->cur == p) break;
                continue;
            L0003:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
            if (i < 1) {
                ctx->cur = p0;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n0);
                goto L0002;
            }
        }
        if (
            pcc_refill_buffer(ctx, 1) < 1 ||
            ctx->buffer.buf[ctx->cur] != '`'
        ) goto L0002;
        ctx->cur++;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_Letter, &chunk->thunks, NULL)) goto L0006;
            goto L0005;
        L0006:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            if (
                pcc_refill_buffer(ctx, 1) < 1 ||
                ctx->buffer.buf[ctx->cur] != '_'
            ) goto L0007;
            ctx->cur++;
            goto L0005;
        L0007:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            goto L0004;
        L0005:;
        }
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                {
                    const size_t p = ctx->cur;
                    const size_t n = chunk->thunks.len;
                    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_Letter, &chunk->thunks, NULL)) goto L0010;
                    goto L0009;
                L0010:;
                    ctx->cur = p;
                    pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                    if (
                        pcc_refill_buffer(ctx, 1) < 1 ||
                        ctx->buffer.buf[ctx->cur] != '_'
                    ) goto L0011;
                    ctx->cur++;
                    goto L0009;
                L0011:;
                    ctx->cur = p;
                    pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_UnicodeDigit, &chunk->thunks, NULL)) goto L0012;
                    goto L0009;
                L0012:;
                    ctx->cur = p;
                    pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                    goto L0008;
                L0009:;
                }
                if (ctx->cur == p) break;
                continue;
            L0008:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        goto L0001;
    L0004:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "Identifier", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "Identifier", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_IdentifierOrSoftKey(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "IdentifierOrSoftKey", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_Identifier, &chunk->thunks, NULL)) goto L0002;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_ABSTRACT, &chunk->thunks, NULL)) goto L0003;
        goto L0001;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_ANNOTATION, &chunk->thunks, NULL)) goto L0004;
        goto L0001;
    L0004:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_BY, &chunk->thunks, NULL)) goto L0005;
        goto L0001;
    L0005:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_CATCH, &chunk->thunks, NULL)) goto L0006;
        goto L0001;
    L0006:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_COMPANION, &chunk->thunks, NULL)) goto L0007;
        goto L0001;
    L0007:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_CONSTRUCTOR, &chunk->thunks, NULL)) goto L0008;
        goto L0001;
    L0008:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_CROSSINLINE, &chunk->thunks, NULL)) goto L0009;
        goto L0001;
    L0009:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_DATA, &chunk->thunks, NULL)) goto L0010;
        goto L0001;
    L0010:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_DYNAMIC, &chunk->thunks, NULL)) goto L0011;
        goto L0001;
    L0011:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_ENUM, &chunk->thunks, NULL)) goto L0012;
        goto L0001;
    L0012:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_EXTERNAL, &chunk->thunks, NULL)) goto L0013;
        goto L0001;
    L0013:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_FINAL, &chunk->thunks, NULL)) goto L0014;
        goto L0001;
    L0014:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_FINALLY, &chunk->thunks, NULL)) goto L0015;
        goto L0001;
    L0015:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_IMPORT, &chunk->thunks, NULL)) goto L0016;
        goto L0001;
    L0016:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_INFIX, &chunk->thunks, NULL)) goto L0017;
        goto L0001;
    L0017:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_INIT, &chunk->thunks, NULL)) goto L0018;
        goto L0001;
    L0018:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_INLINE, &chunk->thunks, NULL)) goto L0019;
        goto L0001;
    L0019:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_INNER, &chunk->thunks, NULL)) goto L0020;
        goto L0001;
    L0020:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_INTERNAL, &chunk->thunks, NULL)) goto L0021;
        goto L0001;
    L0021:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_LATEINIT, &chunk->thunks, NULL)) goto L0022;
        goto L0001;
    L0022:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_NOINLINE, &chunk->thunks, NULL)) goto L0023;
        goto L0001;
    L0023:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_OPEN, &chunk->thunks, NULL)) goto L0024;
        goto L0001;
    L0024:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_OPERATOR, &chunk->thunks, NULL)) goto L0025;
        goto L0001;
    L0025:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_OUT, &chunk->thunks, NULL)) goto L0026;
        goto L0001;
    L0026:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_OVERRIDE, &chunk->thunks, NULL)) goto L0027;
        goto L0001;
    L0027:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_PRIVATE, &chunk->thunks, NULL)) goto L0028;
        goto L0001;
    L0028:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_PROTECTED, &chunk->thunks, NULL)) goto L0029;
        goto L0001;
    L0029:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_PUBLIC, &chunk->thunks, NULL)) goto L0030;
        goto L0001;
    L0030:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_REIFIED, &chunk->thunks, NULL)) goto L0031;
        goto L0001;
    L0031:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_SEALED, &chunk->thunks, NULL)) goto L0032;
        goto L0001;
    L0032:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_TAILREC, &chunk->thunks, NULL)) goto L0033;
        goto L0001;
    L0033:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_VARARG, &chunk->thunks, NULL)) goto L0034;
        goto L0001;
    L0034:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_WHERE, &chunk->thunks, NULL)) goto L0035;
        goto L0001;
    L0035:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_GET, &chunk->thunks, NULL)) goto L0036;
        goto L0001;
    L0036:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_SET, &chunk->thunks, NULL)) goto L0037;
        goto L0001;
    L0037:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_FIELD, &chunk->thunks, NULL)) goto L0038;
        goto L0001;
    L0038:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_PROPERTY, &chunk->thunks, NULL)) goto L0039;
        goto L0001;
    L0039:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_RECEIVER, &chunk->thunks, NULL)) goto L0040;
        goto L0001;
    L0040:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_PARAM, &chunk->thunks, NULL)) goto L0041;
        goto L0001;
    L0041:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_SETPARAM, &chunk->thunks, NULL)) goto L0042;
        goto L0001;
    L0042:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_DELEGATE, &chunk->thunks, NULL)) goto L0043;
        goto L0001;
    L0043:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_FILE, &chunk->thunks, NULL)) goto L0044;
        goto L0001;
    L0044:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_EXPECT, &chunk->thunks, NULL)) goto L0045;
        goto L0001;
    L0045:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_ACTUAL, &chunk->thunks, NULL)) goto L0046;
        goto L0001;
    L0046:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_CONST, &chunk->thunks, NULL)) goto L0047;
        goto L0001;
    L0047:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_SUSPEND, &chunk->thunks, NULL)) goto L0048;
        goto L0001;
    L0048:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "IdentifierOrSoftKey", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "IdentifierOrSoftKey", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_FieldIdentifier(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "FieldIdentifier", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 1) < 1 ||
        ctx->buffer.buf[ctx->cur] != '$'
    ) goto L0000;
    ctx->cur++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_IdentifierOrSoftKey, &chunk->thunks, NULL)) goto L0000;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "FieldIdentifier", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "FieldIdentifier", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_UniCharacterLiteral(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "UniCharacterLiteral", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 1) < 1 ||
        ctx->buffer.buf[ctx->cur] != '\\'
    ) goto L0000;
    ctx->cur++;
    if (
        pcc_refill_buffer(ctx, 1) < 1 ||
        ctx->buffer.buf[ctx->cur] != 'u'
    ) goto L0000;
    ctx->cur++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_HexDigit, &chunk->thunks, NULL)) goto L0000;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_HexDigit, &chunk->thunks, NULL)) goto L0000;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_HexDigit, &chunk->thunks, NULL)) goto L0000;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_HexDigit, &chunk->thunks, NULL)) goto L0000;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "UniCharacterLiteral", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "UniCharacterLiteral", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_EscapedIdentifier(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "EscapedIdentifier", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 1) < 1 ||
        ctx->buffer.buf[ctx->cur] != '\\'
    ) goto L0000;
    ctx->cur++;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (
            pcc_refill_buffer(ctx, 1) < 1 ||
            ctx->buffer.buf[ctx->cur] != 't'
        ) goto L0002;
        ctx->cur++;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (
            pcc_refill_buffer(ctx, 1) < 1 ||
            ctx->buffer.buf[ctx->cur] != 'b'
        ) goto L0003;
        ctx->cur++;
        goto L0001;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (
            pcc_refill_buffer(ctx, 1) < 1 ||
            ctx->buffer.buf[ctx->cur] != 'r'
        ) goto L0004;
        ctx->cur++;
        goto L0001;
    L0004:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (
            pcc_refill_buffer(ctx, 1) < 1 ||
            ctx->buffer.buf[ctx->cur] != 'n'
        ) goto L0005;
        ctx->cur++;
        goto L0001;
    L0005:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (
            pcc_refill_buffer(ctx, 1) < 1 ||
            ctx->buffer.buf[ctx->cur] != '\''
        ) goto L0006;
        ctx->cur++;
        goto L0001;
    L0006:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (
            pcc_refill_buffer(ctx, 1) < 1 ||
            ctx->buffer.buf[ctx->cur] != '\"'
        ) goto L0007;
        ctx->cur++;
        goto L0001;
    L0007:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (
            pcc_refill_buffer(ctx, 1) < 1 ||
            ctx->buffer.buf[ctx->cur] != '\\'
        ) goto L0008;
        ctx->cur++;
        goto L0001;
    L0008:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (
            pcc_refill_buffer(ctx, 1) < 1 ||
            ctx->buffer.buf[ctx->cur] != '$'
        ) goto L0009;
        ctx->cur++;
        goto L0001;
    L0009:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "EscapedIdentifier", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "EscapedIdentifier", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_EscapeSeq(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "EscapeSeq", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_UniCharacterLiteral, &chunk->thunks, NULL)) goto L0002;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_EscapedIdentifier, &chunk->thunks, NULL)) goto L0003;
        goto L0001;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "EscapeSeq", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "EscapeSeq", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_Letter(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "Letter", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        int u;
        const size_t n = pcc_get_char_as_utf32(ctx, &u);
        if (n == 0) goto L0000;
        if (!(
            (u >= 0x000041 && u <= 0x00005a) ||
            (u >= 0x000061 && u <= 0x00007a) ||
            u == 0x0000aa ||
            u == 0x0000b5 ||
            u == 0x0000ba ||
            (u >= 0x0000c0 && u <= 0x0000d6) ||
            (u >= 0x0000d8 && u <= 0x0000f6) ||
            (u >= 0x0000f8 && u <= 0x0002c1) ||
            (u >= 0x0002c6 && u <= 0x0002d1) ||
            (u >= 0x0002e0 && u <= 0x0002e4) ||
            u == 0x0002ec ||
            u == 0x0002ee ||
            (u >= 0x000370 && u <= 0x000374) ||
            (u >= 0x000376 && u <= 0x000377) ||
            (u >= 0x00037a && u <= 0x00037d) ||
            u == 0x000386 ||
            (u >= 0x000388 && u <= 0x00038a) ||
            u == 0x00038c ||
            (u >= 0x00038e && u <= 0x0003a1) ||
            (u >= 0x0003a3 && u <= 0x0003f5) ||
            (u >= 0x0003f7 && u <= 0x000481) ||
            (u >= 0x00048a && u <= 0x000527) ||
            (u >= 0x000531 && u <= 0x000556) ||
            u == 0x000559 ||
            (u >= 0x000561 && u <= 0x000587) ||
            (u >= 0x0005d0 && u <= 0x0005ea) ||
            (u >= 0x0005f0 && u <= 0x0005f2) ||
            (u >= 0x000620 && u <= 0x00064a) ||
            (u >= 0x00066e && u <= 0x00066f) ||
            (u >= 0x000671 && u <= 0x0006d3) ||
            u == 0x0006d5 ||
            (u >= 0x0006e5 && u <= 0x0006e6) ||
            (u >= 0x0006ee && u <= 0x0006ef) ||
            (u >= 0x0006fa && u <= 0x0006fc) ||
            u == 0x0006ff ||
            u == 0x000710 ||
            (u >= 0x000712 && u <= 0x00072f) ||
            (u >= 0x00074d && u <= 0x0007a5) ||
            u == 0x0007b1 ||
            (u >= 0x0007ca && u <= 0x0007ea) ||
            (u >= 0x0007f4 && u <= 0x0007f5) ||
            u == 0x0007fa ||
            (u >= 0x000800 && u <= 0x000815) ||
            u == 0x00081a ||
            u == 0x000824 ||
            u == 0x000828 ||
            (u >= 0x000840 && u <= 0x000858) ||
            u == 0x0008a0 ||
            (u >= 0x0008a2 && u <= 0x0008ac) ||
            (u >= 0x000904 && u <= 0x000939) ||
            u == 0x00093d ||
            u == 0x000950 ||
            (u >= 0x000958 && u <= 0x000961) ||
            (u >= 0x000971 && u <= 0x000977) ||
            (u >= 0x000979 && u <= 0x00097f) ||
            (u >= 0x000985 && u <= 0x00098c) ||
            (u >= 0x00098f && u <= 0x000990) ||
            (u >= 0x000993 && u <= 0x0009a8) ||
            (u >= 0x0009aa && u <= 0x0009b0) ||
            u == 0x0009b2 ||
            (u >= 0x0009b6 && u <= 0x0009b9) ||
            u == 0x0009bd ||
            u == 0x0009ce ||
            (u >= 0x0009dc && u <= 0x0009dd) ||
            (u >= 0x0009df && u <= 0x0009e1) ||
            (u >= 0x0009f0 && u <= 0x0009f1) ||
            (u >= 0x000a05 && u <= 0x000a0a) ||
            (u >= 0x000a0f && u <= 0x000a10) ||
            (u >= 0x000a13 && u <= 0x000a28) ||
            (u >= 0x000a2a && u <= 0x000a30) ||
            (u >= 0x000a32 && u <= 0x000a33) ||
            (u >= 0x000a35 && u <= 0x000a36) ||
            (u >= 0x000a38 && u <= 0x000a39) ||
            (u >= 0x000a59 && u <= 0x000a5c) ||
            u == 0x000a5e ||
            (u >= 0x000a72 && u <= 0x000a74) ||
            (u >= 0x000a85 && u <= 0x000a8d) ||
            (u >= 0x000a8f && u <= 0x000a91) ||
            (u >= 0x000a93 && u <= 0x000aa8) ||
            (u >= 0x000aaa && u <= 0x000ab0) ||
            (u >= 0x000ab2 && u <= 0x000ab3) ||
            (u >= 0x000ab5 && u <= 0x000ab9) ||
            u == 0x000abd ||
            u == 0x000ad0 ||
            (u >= 0x000ae0 && u <= 0x000ae1) ||
            (u >= 0x000b05 && u <= 0x000b0c) ||
            (u >= 0x000b0f && u <= 0x000b10) ||
            (u >= 0x000b13 && u <= 0x000b28) ||
            (u >= 0x000b2a && u <= 0x000b30) ||
            (u >= 0x000b32 && u <= 0x000b33) ||
            (u >= 0x000b35 && u <= 0x000b39) ||
            u == 0x000b3d ||
            (u >= 0x000b5c && u <= 0x000b5d) ||
            (u >= 0x000b5f && u <= 0x000b61) ||
            u == 0x000b71 ||
            u == 0x000b83 ||
            (u >= 0x000b85 && u <= 0x000b8a) ||
            (u >= 0x000b8e && u <= 0x000b90) ||
            (u >= 0x000b92 && u <= 0x000b95) ||
            (u >= 0x000b99 && u <= 0x000b9a) ||
            u == 0x000b9c ||
            (u >= 0x000b9e && u <= 0x000b9f) ||
            (u >= 0x000ba3 && u <= 0x000ba4) ||
            (u >= 0x000ba8 && u <= 0x000baa) ||
            (u >= 0x000bae && u <= 0x000bb9) ||
            u == 0x000bd0 ||
            (u >= 0x000c05 && u <= 0x000c0c) ||
            (u >= 0x000c0e && u <= 0x000c10) ||
            (u >= 0x000c12 && u <= 0x000c28) ||
            (u >= 0x000c2a && u <= 0x000c33) ||
            (u >= 0x000c35 && u <= 0x000c39) ||
            u == 0x000c3d ||
            (u >= 0x000c58 && u <= 0x000c59) ||
            (u >= 0x000c60 && u <= 0x000c61) ||
            (u >= 0x000c85 && u <= 0x000c8c) ||
            (u >= 0x000c8e && u <= 0x000c90) ||
            (u >= 0x000c92 && u <= 0x000ca8) ||
            (u >= 0x000caa && u <= 0x000cb3) ||
            (u >= 0x000cb5 && u <= 0x000cb9) ||
            u == 0x000cbd ||
            u == 0x000cde ||
            (u >= 0x000ce0 && u <= 0x000ce1) ||
            (u >= 0x000cf1 && u <= 0x000cf2) ||
            (u >= 0x000d05 && u <= 0x000d0c) ||
            (u >= 0x000d0e && u <= 0x000d10) ||
            (u >= 0x000d12 && u <= 0x000d3a) ||
            u == 0x000d3d ||
            u == 0x000d4e ||
            (u >= 0x000d60 && u <= 0x000d61) ||
            (u >= 0x000d7a && u <= 0x000d7f) ||
            (u >= 0x000d85 && u <= 0x000d96) ||
            (u >= 0x000d9a && u <= 0x000db1) ||
            (u >= 0x000db3 && u <= 0x000dbb) ||
            u == 0x000dbd ||
            (u >= 0x000dc0 && u <= 0x000dc6) ||
            (u >= 0x000e01 && u <= 0x000e30) ||
            (u >= 0x000e32 && u <= 0x000e33) ||
            (u >= 0x000e40 && u <= 0x000e46) ||
            (u >= 0x000e81 && u <= 0x000e82) ||
            u == 0x000e84 ||
            (u >= 0x000e87 && u <= 0x000e88) ||
            u == 0x000e8a ||
            u == 0x000e8d ||
            (u >= 0x000e94 && u <= 0x000e97) ||
            (u >= 0x000e99 && u <= 0x000e9f) ||
            (u >= 0x000ea1 && u <= 0x000ea3) ||
            u == 0x000ea5 ||
            u == 0x000ea7 ||
            (u >= 0x000eaa && u <= 0x000eab) ||
            (u >= 0x000ead && u <= 0x000eb0) ||
            (u >= 0x000eb2 && u <= 0x000eb3) ||
            u == 0x000ebd ||
            (u >= 0x000ec0 && u <= 0x000ec4) ||
            u == 0x000ec6 ||
            (u >= 0x000edc && u <= 0x000edf) ||
            u == 0x000f00 ||
            (u >= 0x000f40 && u <= 0x000f47) ||
            (u >= 0x000f49 && u <= 0x000f6c) ||
            (u >= 0x000f88 && u <= 0x000f8c) ||
            (u >= 0x001000 && u <= 0x00102a) ||
            u == 0x00103f ||
            (u >= 0x001050 && u <= 0x001055) ||
            (u >= 0x00105a && u <= 0x00105d) ||
            u == 0x001061 ||
            (u >= 0x001065 && u <= 0x001066) ||
            (u >= 0x00106e && u <= 0x001070) ||
            (u >= 0x001075 && u <= 0x001081) ||
            u == 0x00108e ||
            (u >= 0x0010a0 && u <= 0x0010c5) ||
            u == 0x0010c7 ||
            u == 0x0010cd ||
            (u >= 0x0010d0 && u <= 0x0010fa) ||
            (u >= 0x0010fc && u <= 0x001248) ||
            (u >= 0x00124a && u <= 0x00124d) ||
            (u >= 0x001250 && u <= 0x001256) ||
            u == 0x001258 ||
            (u >= 0x00125a && u <= 0x00125d) ||
            (u >= 0x001260 && u <= 0x001288) ||
            (u >= 0x00128a && u <= 0x00128d) ||
            (u >= 0x001290 && u <= 0x0012b0) ||
            (u >= 0x0012b2 && u <= 0x0012b5) ||
            (u >= 0x0012b8 && u <= 0x0012be) ||
            u == 0x0012c0 ||
            (u >= 0x0012c2 && u <= 0x0012c5) ||
            (u >= 0x0012c8 && u <= 0x0012d6) ||
            (u >= 0x0012d8 && u <= 0x001310) ||
            (u >= 0x001312 && u <= 0x001315) ||
            (u >= 0x001318 && u <= 0x00135a) ||
            (u >= 0x001380 && u <= 0x00138f) ||
            (u >= 0x0013a0 && u <= 0x0013f4) ||
            (u >= 0x001401 && u <= 0x00166c) ||
            (u >= 0x00166f && u <= 0x00167f) ||
            (u >= 0x001681 && u <= 0x00169a) ||
            (u >= 0x0016a0 && u <= 0x0016ea) ||
            (u >= 0x0016ee && u <= 0x0016f0) ||
            (u >= 0x001700 && u <= 0x00170c) ||
            (u >= 0x00170e && u <= 0x001711) ||
            (u >= 0x001720 && u <= 0x001731) ||
            (u >= 0x001740 && u <= 0x001751) ||
            (u >= 0x001760 && u <= 0x00176c) ||
            (u >= 0x00176e && u <= 0x001770) ||
            (u >= 0x001780 && u <= 0x0017b3) ||
            u == 0x0017d7 ||
            u == 0x0017dc ||
            (u >= 0x001820 && u <= 0x001877) ||
            (u >= 0x001880 && u <= 0x0018a8) ||
            u == 0x0018aa ||
            (u >= 0x0018b0 && u <= 0x0018f5) ||
            (u >= 0x001900 && u <= 0x00191c) ||
            (u >= 0x001950 && u <= 0x00196d) ||
            (u >= 0x001970 && u <= 0x001974) ||
            (u >= 0x001980 && u <= 0x0019ab) ||
            (u >= 0x0019c1 && u <= 0x0019c7) ||
            (u >= 0x001a00 && u <= 0x001a16) ||
            (u >= 0x001a20 && u <= 0x001a54) ||
            u == 0x001aa7 ||
            (u >= 0x001b05 && u <= 0x001b33) ||
            (u >= 0x001b45 && u <= 0x001b4b) ||
            (u >= 0x001b83 && u <= 0x001ba0) ||
            (u >= 0x001bae && u <= 0x001baf) ||
            (u >= 0x001bba && u <= 0x001be5) ||
            (u >= 0x001c00 && u <= 0x001c23) ||
            (u >= 0x001c4d && u <= 0x001c4f) ||
            (u >= 0x001c5a && u <= 0x001c7d) ||
            (u >= 0x001ce9 && u <= 0x001cec) ||
            (u >= 0x001cee && u <= 0x001cf1) ||
            (u >= 0x001cf5 && u <= 0x001cf6) ||
            (u >= 0x001d00 && u <= 0x001dbf) ||
            (u >= 0x001e00 && u <= 0x001f15) ||
            (u >= 0x001f18 && u <= 0x001f1d) ||
            (u >= 0x001f20 && u <= 0x001f45) ||
            (u >= 0x001f48 && u <= 0x001f4d) ||
            (u >= 0x001f50 && u <= 0x001f57) ||
            u == 0x001f59 ||
            u == 0x001f5b ||
            u == 0x001f5d ||
            (u >= 0x001f5f && u <= 0x001f7d) ||
            (u >= 0x001f80 && u <= 0x001fb4) ||
            (u >= 0x001fb6 && u <= 0x001fbc) ||
            u == 0x001fbe ||
            (u >= 0x001fc2 && u <= 0x001fc4) ||
            (u >= 0x001fc6 && u <= 0x001fcc) ||
            (u >= 0x001fd0 && u <= 0x001fd3) ||
            (u >= 0x001fd6 && u <= 0x001fdb) ||
            (u >= 0x001fe0 && u <= 0x001fec) ||
            (u >= 0x001ff2 && u <= 0x001ff4) ||
            (u >= 0x001ff6 && u <= 0x001ffc) ||
            u == 0x002071 ||
            u == 0x00207f ||
            (u >= 0x002090 && u <= 0x00209c) ||
            u == 0x002102 ||
            u == 0x002107 ||
            (u >= 0x00210a && u <= 0x002113) ||
            u == 0x002115 ||
            (u >= 0x002119 && u <= 0x00211d) ||
            u == 0x002124 ||
            u == 0x002126 ||
            u == 0x002128 ||
            (u >= 0x00212a && u <= 0x00212d) ||
            (u >= 0x00212f && u <= 0x002139) ||
            (u >= 0x00213c && u <= 0x00213f) ||
            (u >= 0x002145 && u <= 0x002149) ||
            u == 0x00214e ||
            (u >= 0x002160 && u <= 0x002188) ||
            (u >= 0x002c00 && u <= 0x002c2e) ||
            (u >= 0x002c30 && u <= 0x002c5e) ||
            (u >= 0x002c60 && u <= 0x002ce4) ||
            (u >= 0x002ceb && u <= 0x002cee) ||
            (u >= 0x002cf2 && u <= 0x002cf3) ||
            (u >= 0x002d00 && u <= 0x002d25) ||
            u == 0x002d27 ||
            u == 0x002d2d ||
            (u >= 0x002d30 && u <= 0x002d67) ||
            u == 0x002d6f ||
            (u >= 0x002d80 && u <= 0x002d96) ||
            (u >= 0x002da0 && u <= 0x002da6) ||
            (u >= 0x002da8 && u <= 0x002dae) ||
            (u >= 0x002db0 && u <= 0x002db6) ||
            (u >= 0x002db8 && u <= 0x002dbe) ||
            (u >= 0x002dc0 && u <= 0x002dc6) ||
            (u >= 0x002dc8 && u <= 0x002dce) ||
            (u >= 0x002dd0 && u <= 0x002dd6) ||
            (u >= 0x002dd8 && u <= 0x002dde) ||
            u == 0x002e2f ||
            (u >= 0x003005 && u <= 0x003007) ||
            (u >= 0x003021 && u <= 0x003029) ||
            (u >= 0x003031 && u <= 0x003035) ||
            (u >= 0x003038 && u <= 0x00303c) ||
            (u >= 0x003041 && u <= 0x003096) ||
            (u >= 0x00309d && u <= 0x00309f) ||
            (u >= 0x0030a1 && u <= 0x0030fa) ||
            (u >= 0x0030fc && u <= 0x0030ff) ||
            (u >= 0x003105 && u <= 0x00312d) ||
            (u >= 0x003131 && u <= 0x00318e) ||
            (u >= 0x0031a0 && u <= 0x0031ba) ||
            (u >= 0x0031f0 && u <= 0x0031ff) ||
            u == 0x003400 ||
            u == 0x004db5 ||
            u == 0x004e00 ||
            u == 0x009fcc ||
            (u >= 0x00a000 && u <= 0x00a48c) ||
            (u >= 0x00a4d0 && u <= 0x00a4fd) ||
            (u >= 0x00a500 && u <= 0x00a60c) ||
            (u >= 0x00a610 && u <= 0x00a61f) ||
            (u >= 0x00a62a && u <= 0x00a62b) ||
            (u >= 0x00a640 && u <= 0x00a66e) ||
            (u >= 0x00a67f && u <= 0x00a697) ||
            (u >= 0x00a6a0 && u <= 0x00a6ef) ||
            (u >= 0x00a717 && u <= 0x00a71f) ||
            (u >= 0x00a722 && u <= 0x00a788) ||
            (u >= 0x00a78b && u <= 0x00a78e) ||
            (u >= 0x00a790 && u <= 0x00a793) ||
            (u >= 0x00a7a0 && u <= 0x00a7aa) ||
            (u >= 0x00a7f8 && u <= 0x00a801) ||
            (u >= 0x00a803 && u <= 0x00a805) ||
            (u >= 0x00a807 && u <= 0x00a80a) ||
            (u >= 0x00a80c && u <= 0x00a822) ||
            (u >= 0x00a840 && u <= 0x00a873) ||
            (u >= 0x00a882 && u <= 0x00a8b3) ||
            (u >= 0x00a8f2 && u <= 0x00a8f7) ||
            u == 0x00a8fb ||
            (u >= 0x00a90a && u <= 0x00a925) ||
            (u >= 0x00a930 && u <= 0x00a946) ||
            (u >= 0x00a960 && u <= 0x00a97c) ||
            (u >= 0x00a984 && u <= 0x00a9b2) ||
            u == 0x00a9cf ||
            (u >= 0x00aa00 && u <= 0x00aa28) ||
            (u >= 0x00aa40 && u <= 0x00aa42) ||
            (u >= 0x00aa44 && u <= 0x00aa4b) ||
            (u >= 0x00aa60 && u <= 0x00aa76) ||
            u == 0x00aa7a ||
            (u >= 0x00aa80 && u <= 0x00aaaf) ||
            u == 0x00aab1 ||
            (u >= 0x00aab5 && u <= 0x00aab6) ||
            (u >= 0x00aab9 && u <= 0x00aabd) ||
            u == 0x00aac0 ||
            u == 0x00aac2 ||
            (u >= 0x00aadb && u <= 0x00aadd) ||
            (u >= 0x00aae0 && u <= 0x00aaea) ||
            (u >= 0x00aaf2 && u <= 0x00aaf4) ||
            (u >= 0x00ab01 && u <= 0x00ab06) ||
            (u >= 0x00ab09 && u <= 0x00ab0e) ||
            (u >= 0x00ab11 && u <= 0x00ab16) ||
            (u >= 0x00ab20 && u <= 0x00ab26) ||
            (u >= 0x00ab28 && u <= 0x00ab2e) ||
            (u >= 0x00abc0 && u <= 0x00abe2) ||
            u == 0x00ac00 ||
            u == 0x00d7a3 ||
            (u >= 0x00d7b0 && u <= 0x00d7c6) ||
            (u >= 0x00d7cb && u <= 0x00d7fb) ||
            (u >= 0x00f900 && u <= 0x00fa6d) ||
            (u >= 0x00fa70 && u <= 0x00fad9) ||
            (u >= 0x00fb00 && u <= 0x00fb06) ||
            (u >= 0x00fb13 && u <= 0x00fb17) ||
            u == 0x00fb1d ||
            (u >= 0x00fb1f && u <= 0x00fb28) ||
            (u >= 0x00fb2a && u <= 0x00fb36) ||
            (u >= 0x00fb38 && u <= 0x00fb3c) ||
            u == 0x00fb3e ||
            (u >= 0x00fb40 && u <= 0x00fb41) ||
            (u >= 0x00fb43 && u <= 0x00fb44) ||
            (u >= 0x00fb46 && u <= 0x00fbb1) ||
            (u >= 0x00fbd3 && u <= 0x00fd3d) ||
            (u >= 0x00fd50 && u <= 0x00fd8f) ||
            (u >= 0x00fd92 && u <= 0x00fdc7) ||
            (u >= 0x00fdf0 && u <= 0x00fdfb) ||
            (u >= 0x00fe70 && u <= 0x00fe74) ||
            (u >= 0x00fe76 && u <= 0x00fefc) ||
            (u >= 0x00ff21 && u <= 0x00ff3a) ||
            (u >= 0x00ff41 && u <= 0x00ff5a) ||
            (u >= 0x00ff66 && u <= 0x00ffbe) ||
            (u >= 0x00ffc2 && u <= 0x00ffc7) ||
            (u >= 0x00ffca && u <= 0x00ffcf) ||
            (u >= 0x00ffd2 && u <= 0x00ffd7) ||
            (u >= 0x00ffda && u <= 0x00ffdc)
        )) goto L0000;
        ctx->cur += n;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "Letter", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "Letter", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_UnicodeDigit(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "UnicodeDigit", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        int u;
        const size_t n = pcc_get_char_as_utf32(ctx, &u);
        if (n == 0) goto L0000;
        if (!(
            (u >= 0x000030 && u <= 0x000039) ||
            (u >= 0x000660 && u <= 0x000669) ||
            (u >= 0x0006f0 && u <= 0x0006f9) ||
            (u >= 0x0007c0 && u <= 0x0007c9) ||
            (u >= 0x000966 && u <= 0x00096f) ||
            (u >= 0x0009e6 && u <= 0x0009ef) ||
            (u >= 0x000a66 && u <= 0x000a6f) ||
            (u >= 0x000ae6 && u <= 0x000aef) ||
            (u >= 0x000b66 && u <= 0x000b6f) ||
            (u >= 0x000be6 && u <= 0x000bef) ||
            (u >= 0x000c66 && u <= 0x000c6f) ||
            (u >= 0x000ce6 && u <= 0x000cef) ||
            (u >= 0x000d66 && u <= 0x000d6f) ||
            (u >= 0x000e50 && u <= 0x000e59) ||
            (u >= 0x000ed0 && u <= 0x000ed9) ||
            (u >= 0x000f20 && u <= 0x000f29) ||
            (u >= 0x001040 && u <= 0x001049) ||
            (u >= 0x001090 && u <= 0x001099) ||
            (u >= 0x0017e0 && u <= 0x0017e9) ||
            (u >= 0x001810 && u <= 0x001819) ||
            (u >= 0x001946 && u <= 0x00194f) ||
            (u >= 0x0019d0 && u <= 0x0019d9) ||
            (u >= 0x001a80 && u <= 0x001a89) ||
            (u >= 0x001a90 && u <= 0x001a99) ||
            (u >= 0x001b50 && u <= 0x001b59) ||
            (u >= 0x001bb0 && u <= 0x001bb9) ||
            (u >= 0x001c40 && u <= 0x001c49) ||
            (u >= 0x001c50 && u <= 0x001c59) ||
            (u >= 0x00a620 && u <= 0x00a629) ||
            (u >= 0x00a8d0 && u <= 0x00a8d9) ||
            (u >= 0x00a900 && u <= 0x00a909) ||
            (u >= 0x00a9d0 && u <= 0x00a9d9) ||
            (u >= 0x00aa50 && u <= 0x00aa59) ||
            (u >= 0x00abf0 && u <= 0x00abf9) ||
            (u >= 0x00ff10 && u <= 0x00ff19)
        )) goto L0000;
        ctx->cur += n;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "UnicodeDigit", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "UnicodeDigit", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_QUOTE_OPEN(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "QUOTE_OPEN", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 1) < 1 ||
        ctx->buffer.buf[ctx->cur] != '\"'
    ) goto L0000;
    ctx->cur++;
    {
        const size_t p = ctx->cur;
        if (
            pcc_refill_buffer(ctx, 2) < 2 ||
            (ctx->buffer.buf + ctx->cur)[0] != '\"' ||
            (ctx->buffer.buf + ctx->cur)[1] != '\"'
        ) goto L0001;
        ctx->cur += 2;
        ctx->cur = p;
        goto L0000;
    L0001:;
        ctx->cur = p;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "QUOTE_OPEN", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "QUOTE_OPEN", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_TRIPLE_QUOTE_OPEN(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "TRIPLE_QUOTE_OPEN", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 3) < 3 ||
        (ctx->buffer.buf + ctx->cur)[0] != '\"' ||
        (ctx->buffer.buf + ctx->cur)[1] != '\"' ||
        (ctx->buffer.buf + ctx->cur)[2] != '\"'
    ) goto L0000;
    ctx->cur += 3;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "TRIPLE_QUOTE_OPEN", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "TRIPLE_QUOTE_OPEN", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_QUOTE_CLOSE(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "QUOTE_CLOSE", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 1) < 1 ||
        ctx->buffer.buf[ctx->cur] != '\"'
    ) goto L0000;
    ctx->cur++;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "QUOTE_CLOSE", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "QUOTE_CLOSE", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_LineStrRef(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "LineStrRef", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_FieldIdentifier, &chunk->thunks, NULL)) goto L0000;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "LineStrRef", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "LineStrRef", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_LineStrText(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "LineStrText", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        {
            const size_t p0 = ctx->cur;
            const size_t n0 = chunk->thunks.len;
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                {
                    int u;
                    const size_t n = pcc_get_char_as_utf32(ctx, &u);
                    if (n == 0) goto L0003;
                    if (
                        u == 0x00005c ||
                        u == 0x000022 ||
                        u == 0x000024
                    ) goto L0003;
                    ctx->cur += n;
                }
                if (ctx->cur == p) break;
                continue;
            L0003:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
            if (i < 1) {
                ctx->cur = p0;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n0);
                goto L0002;
            }
        }
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (
            pcc_refill_buffer(ctx, 1) < 1 ||
            ctx->buffer.buf[ctx->cur] != '$'
        ) goto L0004;
        ctx->cur++;
        goto L0001;
    L0004:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "LineStrText", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "LineStrText", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_LineStrEscapedChar(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "LineStrEscapedChar", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_EscapedIdentifier, &chunk->thunks, NULL)) goto L0002;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_UniCharacterLiteral, &chunk->thunks, NULL)) goto L0003;
        goto L0001;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "LineStrEscapedChar", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "LineStrEscapedChar", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_LineStrExprStart(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "LineStrExprStart", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 2) < 2 ||
        (ctx->buffer.buf + ctx->cur)[0] != '$' ||
        (ctx->buffer.buf + ctx->cur)[1] != '{'
    ) goto L0000;
    ctx->cur += 2;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "LineStrExprStart", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "LineStrExprStart", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_TRIPLE_QUOTE_CLOSE(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "TRIPLE_QUOTE_CLOSE", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (
            pcc_refill_buffer(ctx, 5) < 5 ||
            (ctx->buffer.buf + ctx->cur)[0] != '\"' ||
            (ctx->buffer.buf + ctx->cur)[1] != '\"' ||
            (ctx->buffer.buf + ctx->cur)[2] != '\"' ||
            (ctx->buffer.buf + ctx->cur)[3] != '\"' ||
            (ctx->buffer.buf + ctx->cur)[4] != '\"'
        ) goto L0002;
        ctx->cur += 5;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (
            pcc_refill_buffer(ctx, 4) < 4 ||
            (ctx->buffer.buf + ctx->cur)[0] != '\"' ||
            (ctx->buffer.buf + ctx->cur)[1] != '\"' ||
            (ctx->buffer.buf + ctx->cur)[2] != '\"' ||
            (ctx->buffer.buf + ctx->cur)[3] != '\"'
        ) goto L0003;
        ctx->cur += 4;
        goto L0001;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (
            pcc_refill_buffer(ctx, 3) < 3 ||
            (ctx->buffer.buf + ctx->cur)[0] != '\"' ||
            (ctx->buffer.buf + ctx->cur)[1] != '\"' ||
            (ctx->buffer.buf + ctx->cur)[2] != '\"'
        ) goto L0004;
        ctx->cur += 3;
        goto L0001;
    L0004:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "TRIPLE_QUOTE_CLOSE", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "TRIPLE_QUOTE_CLOSE", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_MultiLineStringQuote(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "MultiLineStringQuote", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (
            pcc_refill_buffer(ctx, 2) < 2 ||
            (ctx->buffer.buf + ctx->cur)[0] != '\"' ||
            (ctx->buffer.buf + ctx->cur)[1] != '\"'
        ) goto L0002;
        ctx->cur += 2;
        {
            const size_t p = ctx->cur;
            if (
                pcc_refill_buffer(ctx, 1) < 1 ||
                ctx->buffer.buf[ctx->cur] != '\"'
            ) goto L0003;
            ctx->cur++;
            ctx->cur = p;
            goto L0002;
        L0003:;
            ctx->cur = p;
        }
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (
            pcc_refill_buffer(ctx, 1) < 1 ||
            ctx->buffer.buf[ctx->cur] != '\"'
        ) goto L0004;
        ctx->cur++;
        {
            const size_t p = ctx->cur;
            if (
                pcc_refill_buffer(ctx, 2) < 2 ||
                (ctx->buffer.buf + ctx->cur)[0] != '\"' ||
                (ctx->buffer.buf + ctx->cur)[1] != '\"'
            ) goto L0005;
            ctx->cur += 2;
            ctx->cur = p;
            goto L0004;
        L0005:;
            ctx->cur = p;
        }
        goto L0001;
    L0004:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "MultiLineStringQuote", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "MultiLineStringQuote", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_MultiLineStrRef(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "MultiLineStrRef", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_FieldIdentifier, &chunk->thunks, NULL)) goto L0000;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "MultiLineStrRef", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "MultiLineStrRef", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_MultiLineStrText(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "MultiLineStrText", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        {
            const size_t p0 = ctx->cur;
            const size_t n0 = chunk->thunks.len;
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                {
                    int u;
                    const size_t n = pcc_get_char_as_utf32(ctx, &u);
                    if (n == 0) goto L0003;
                    if (
                        u == 0x000022 ||
                        u == 0x000024
                    ) goto L0003;
                    ctx->cur += n;
                }
                if (ctx->cur == p) break;
                continue;
            L0003:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
            if (i < 1) {
                ctx->cur = p0;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n0);
                goto L0002;
            }
        }
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (
            pcc_refill_buffer(ctx, 1) < 1 ||
            ctx->buffer.buf[ctx->cur] != '$'
        ) goto L0004;
        ctx->cur++;
        goto L0001;
    L0004:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "MultiLineStrText", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "MultiLineStrText", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_MultiLineStrExprStart(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "MultiLineStrExprStart", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 2) < 2 ||
        (ctx->buffer.buf + ctx->cur)[0] != '$' ||
        (ctx->buffer.buf + ctx->cur)[1] != '{'
    ) goto L0000;
    ctx->cur += 2;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "MultiLineStrExprStart", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "MultiLineStrExprStart", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule__(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "_", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p0 = ctx->cur;
        const size_t n0 = chunk->thunks.len;
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule_WS, &chunk->thunks, NULL)) goto L0003;
                goto L0002;
            L0003:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule_DelimitedComment, &chunk->thunks, NULL)) goto L0004;
                goto L0002;
            L0004:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule_LineComment, &chunk->thunks, NULL)) goto L0005;
                goto L0002;
            L0005:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                goto L0001;
            L0002:;
            }
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
        if (i < 1) {
            ctx->cur = p0;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n0);
            goto L0000;
        }
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "_", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "_", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule___(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "__", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p0 = ctx->cur;
        const size_t n0 = chunk->thunks.len;
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                {
                    int u;
                    const size_t n = pcc_get_char_as_utf32(ctx, &u);
                    if (n == 0) goto L0003;
                    if (!(
                        u == 0x000020 ||
                        u == 0x000009 ||
                        u == 0x00000c ||
                        u == 0x00000d ||
                        u == 0x00000a
                    )) goto L0003;
                    ctx->cur += n;
                }
                goto L0002;
            L0003:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule_DelimitedComment, &chunk->thunks, NULL)) goto L0004;
                goto L0002;
            L0004:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule_LineComment, &chunk->thunks, NULL)) goto L0005;
                goto L0002;
            L0005:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                goto L0001;
            L0002:;
            }
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
        if (i < 1) {
            ctx->cur = p0;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n0);
            goto L0000;
        }
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "__", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "__", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_WS(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "WS", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        int u;
        const size_t n = pcc_get_char_as_utf32(ctx, &u);
        if (n == 0) goto L0000;
        if (!(
            u == 0x000020 ||
            u == 0x000009 ||
            u == 0x00000c
        )) goto L0000;
        ctx->cur += n;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "WS", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "WS", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_NL(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "NL", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0001;
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (
            pcc_refill_buffer(ctx, 1) < 1 ||
            ctx->buffer.buf[ctx->cur] != '\n'
        ) goto L0003;
        ctx->cur++;
        goto L0002;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (
            pcc_refill_buffer(ctx, 1) < 1 ||
            ctx->buffer.buf[ctx->cur] != '\r'
        ) goto L0004;
        ctx->cur++;
        {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (
                pcc_refill_buffer(ctx, 1) < 1 ||
                ctx->buffer.buf[ctx->cur] != '\n'
            ) goto L0005;
            ctx->cur++;
            goto L0006;
        L0005:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        L0006:;
        }
        goto L0002;
    L0004:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0002:;
    }
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0007;
            if (ctx->cur == p) break;
            continue;
        L0007:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "NL", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "NL", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_EOF(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "EOF", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        {
            int u;
            const size_t n = pcc_get_char_as_utf32(ctx, &u);
            if (n == 0) goto L0001;
            ctx->cur += n;
        }
        ctx->cur = p;
        goto L0000;
    L0001:;
        ctx->cur = p;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "EOF", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "EOF", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

pkotlin_context_t *pkotlin_create(struct parserCtx *auxil) {
    return pcc_context__create(auxil);
}

int pkotlin_parse(pkotlin_context_t *ctx, int *ret) {
    if (pcc_apply_rule(ctx, pcc_evaluate_rule_file, &ctx->thunks, ret))
        pcc_do_action(ctx, &ctx->thunks, ret);
    else
        PCC_ERROR(ctx->auxil);
    pcc_commit_buffer(ctx);
    pcc_thunk_array__revert(ctx->auxil, &ctx->thunks, 0);
    return pcc_refill_buffer(ctx, 1) >= 1;
}

void pkotlin_destroy(pkotlin_context_t *ctx) {
    pcc_context__destroy(ctx);
}

#include "kotlin_post.h"
