/* A packrat parser generated by PackCC 1.8.0 */

#include "general.h"

#ifdef _MSC_VER
#undef _CRT_SECURE_NO_WARNINGS
#define _CRT_SECURE_NO_WARNINGS
#endif /* _MSC_VER */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifndef _MSC_VER
#if defined __GNUC__ && defined _WIN32 /* MinGW */
#ifndef PCC_USE_SYSTEM_STRNLEN
#define strnlen(str, maxlen) pcc_strnlen(str, maxlen)
static size_t pcc_strnlen(const char *str, size_t maxlen) {
    size_t i;
    for (i = 0; i < maxlen && str[i]; i++);
    return i;
}
#endif /* !PCC_USE_SYSTEM_STRNLEN */
#endif /* defined __GNUC__ && defined _WIN32 */
#endif /* !_MSC_VER */

#include "./peg/thrift.h"

#include "thrift_pre.h"
#include "routines.h"
#if !defined __has_attribute || defined _MSC_VER
#define __attribute__(x)
#endif

#ifdef _MSC_VER
#define MARK_FUNC_AS_USED __pragma(warning(suppress:4505))
#else
#define MARK_FUNC_AS_USED __attribute__((__unused__))
#endif

#ifndef PCC_BUFFER_MIN_SIZE
#define PCC_BUFFER_MIN_SIZE 256
#endif /* !PCC_BUFFER_MIN_SIZE */

#ifndef PCC_ARRAY_MIN_SIZE
#define PCC_ARRAY_MIN_SIZE 2
#endif /* !PCC_ARRAY_MIN_SIZE */

#ifndef PCC_POOL_MIN_SIZE
#define PCC_POOL_MIN_SIZE 65536
#endif /* !PCC_POOL_MIN_SIZE */

#define PCC_DBG_EVALUATE 0
#define PCC_DBG_MATCH    1
#define PCC_DBG_NOMATCH  2

#define PCC_VOID_VALUE (~(size_t)0)

typedef enum pcc_bool_tag {
    PCC_FALSE = 0,
    PCC_TRUE
} pcc_bool_t;

typedef struct pcc_char_array_tag {
    char *buf;
    size_t max;
    size_t len;
} pcc_char_array_t;

typedef struct pcc_range_tag {
    size_t start;
    size_t end;
} pcc_range_t;

typedef int pcc_value_t;

typedef struct parserCtx *pcc_auxil_t;

typedef pthrift_context_t pcc_context_t;

typedef struct pcc_value_table_tag {
    pcc_value_t *buf;
    size_t max;
    size_t len;
} pcc_value_table_t;

typedef struct pcc_value_refer_table_tag {
    pcc_value_t **buf;
    size_t max;
    size_t len;
} pcc_value_refer_table_t;

typedef struct pcc_capture_tag {
    pcc_range_t range;
    char *string; /* mutable */
} pcc_capture_t;

typedef struct pcc_capture_table_tag {
    pcc_capture_t *buf;
    size_t max;
    size_t len;
} pcc_capture_table_t;

typedef struct pcc_capture_const_table_tag {
    const pcc_capture_t **buf;
    size_t max;
    size_t len;
} pcc_capture_const_table_t;

typedef struct pcc_thunk_tag pcc_thunk_t;
typedef struct pcc_thunk_array_tag pcc_thunk_array_t;

typedef void (*pcc_action_t)(pcc_context_t *, pcc_thunk_t *, pcc_value_t *);

typedef enum pcc_thunk_type_tag {
    PCC_THUNK_LEAF,
    PCC_THUNK_NODE
} pcc_thunk_type_t;

typedef struct pcc_thunk_leaf_tag {
    pcc_value_refer_table_t values;
    pcc_capture_const_table_t capts;
    pcc_capture_t capt0;
    pcc_action_t action;
} pcc_thunk_leaf_t;

typedef struct pcc_thunk_node_tag {
    const pcc_thunk_array_t *thunks; /* just a reference */
    pcc_value_t *value; /* just a reference */
} pcc_thunk_node_t;

typedef union pcc_thunk_data_tag {
    pcc_thunk_leaf_t leaf;
    pcc_thunk_node_t node;
} pcc_thunk_data_t;

struct pcc_thunk_tag {
    pcc_thunk_type_t type;
    pcc_thunk_data_t data;
};

struct pcc_thunk_array_tag {
    pcc_thunk_t **buf;
    size_t max;
    size_t len;
};

typedef struct pcc_thunk_chunk_tag {
    pcc_value_table_t values;
    pcc_capture_table_t capts;
    pcc_thunk_array_t thunks;
    size_t pos; /* the starting position in the character buffer */
} pcc_thunk_chunk_t;

typedef struct pcc_lr_entry_tag pcc_lr_entry_t;

typedef enum pcc_lr_answer_type_tag {
    PCC_LR_ANSWER_LR,
    PCC_LR_ANSWER_CHUNK
} pcc_lr_answer_type_t;

typedef union pcc_lr_answer_data_tag {
    pcc_lr_entry_t *lr;
    pcc_thunk_chunk_t *chunk;
} pcc_lr_answer_data_t;

typedef struct pcc_lr_answer_tag pcc_lr_answer_t;

struct pcc_lr_answer_tag {
    pcc_lr_answer_type_t type;
    pcc_lr_answer_data_t data;
    size_t pos; /* the absolute position in the input */
    pcc_lr_answer_t *hold;
};

typedef pcc_thunk_chunk_t *(*pcc_rule_t)(pcc_context_t *);

typedef struct pcc_rule_set_tag {
    pcc_rule_t *buf;
    size_t max;
    size_t len;
} pcc_rule_set_t;

typedef struct pcc_lr_head_tag pcc_lr_head_t;

struct pcc_lr_head_tag {
    pcc_rule_t rule;
    pcc_rule_set_t invol;
    pcc_rule_set_t eval;
    pcc_lr_head_t *hold;
};

typedef struct pcc_lr_memo_tag {
    pcc_rule_t rule;
    pcc_lr_answer_t *answer;
} pcc_lr_memo_t;

typedef struct pcc_lr_memo_map_tag {
    pcc_lr_memo_t *buf;
    size_t max;
    size_t len;
} pcc_lr_memo_map_t;

typedef struct pcc_lr_table_entry_tag {
    pcc_lr_head_t *head; /* just a reference */
    pcc_lr_memo_map_t memos;
    pcc_lr_answer_t *hold_a;
    pcc_lr_head_t *hold_h;
} pcc_lr_table_entry_t;

typedef struct pcc_lr_table_tag {
    pcc_lr_table_entry_t **buf;
    size_t max;
    size_t len;
    size_t ofs;
} pcc_lr_table_t;

struct pcc_lr_entry_tag {
    pcc_rule_t rule;
    pcc_thunk_chunk_t *seed; /* just a reference */
    pcc_lr_head_t *head; /* just a reference */
};

typedef struct pcc_lr_stack_tag {
    pcc_lr_entry_t **buf;
    size_t max;
    size_t len;
} pcc_lr_stack_t;

typedef struct pcc_memory_entry_tag pcc_memory_entry_t;
typedef struct pcc_memory_pool_tag pcc_memory_pool_t;

struct pcc_memory_entry_tag {
    pcc_memory_entry_t *next;
};

struct pcc_memory_pool_tag {
    pcc_memory_pool_t *next;
    size_t allocated;
    size_t unused;
};

typedef struct pcc_memory_recycler_tag {
    pcc_memory_pool_t *pool_list;
    pcc_memory_entry_t *entry_list;
    size_t element_size;
} pcc_memory_recycler_t;

struct pthrift_context_tag {
    size_t pos; /* the position in the input of the first character currently buffered */
    size_t cur; /* the current parsing position in the character buffer */
    size_t level;
    pcc_char_array_t buffer;
    pcc_lr_table_t lrtable;
    pcc_lr_stack_t lrstack;
    pcc_thunk_array_t thunks;
    pcc_auxil_t auxil;
    pcc_memory_recycler_t thunk_chunk_recycler;
    pcc_memory_recycler_t lr_head_recycler;
    pcc_memory_recycler_t lr_answer_recycler;
};

#ifndef PCC_ERROR
#define PCC_ERROR(auxil) pcc_error()
MARK_FUNC_AS_USED
static void pcc_error(void) {
    fprintf(stderr, "Syntax error\n");
    exit(1);
}
#endif /* !PCC_ERROR */

#ifndef PCC_GETCHAR
#define PCC_GETCHAR(auxil) getchar()
#endif /* !PCC_GETCHAR */

#ifndef PCC_MALLOC
#define PCC_MALLOC(auxil, size) pcc_malloc_e(size)
static void *pcc_malloc_e(size_t size) {
    void *const p = malloc(size);
    if (p == NULL) {
        fprintf(stderr, "Out of memory\n");
        exit(1);
    }
    return p;
}
#endif /* !PCC_MALLOC */

#ifndef PCC_REALLOC
#define PCC_REALLOC(auxil, ptr, size) pcc_realloc_e(ptr, size)
static void *pcc_realloc_e(void *ptr, size_t size) {
    void *const p = realloc(ptr, size);
    if (p == NULL) {
        fprintf(stderr, "Out of memory\n");
        exit(1);
    }
    return p;
}
#endif /* !PCC_REALLOC */

#ifndef PCC_FREE
#define PCC_FREE(auxil, ptr) free(ptr)
#endif /* !PCC_FREE */

#ifndef PCC_DEBUG
#define PCC_DEBUG(auxil, event, rule, level, pos, buffer, length) ((void)0)
#endif /* !PCC_DEBUG */

static char *pcc_strndup_e(pcc_auxil_t auxil, const char *str, size_t len) {
    const size_t m = strnlen(str, len);
    char *const s = (char *)PCC_MALLOC(auxil, m + 1);
    memcpy(s, str, m);
    s[m] = '\0';
    return s;
}

static void pcc_char_array__init(pcc_auxil_t auxil, pcc_char_array_t *array) {
    array->len = 0;
    array->max = 0;
    array->buf = NULL;
}

static void pcc_char_array__add(pcc_auxil_t auxil, pcc_char_array_t *array, char ch) {
    if (array->max <= array->len) {
        const size_t n = array->len + 1;
        size_t m = array->max;
        if (m == 0) m = PCC_BUFFER_MIN_SIZE;
        while (m < n && m != 0) m <<= 1;
        if (m == 0) m = n;
        array->buf = (char *)PCC_REALLOC(auxil, array->buf, m);
        array->max = m;
    }
    array->buf[array->len++] = ch;
}

static void pcc_char_array__term(pcc_auxil_t auxil, pcc_char_array_t *array) {
    PCC_FREE(auxil, array->buf);
}

static void pcc_value_table__init(pcc_auxil_t auxil, pcc_value_table_t *table) {
    table->len = 0;
    table->max = 0;
    table->buf = NULL;
}

MARK_FUNC_AS_USED
static void pcc_value_table__resize(pcc_auxil_t auxil, pcc_value_table_t *table, size_t len) {
    if (table->max < len) {
        size_t m = table->max;
        if (m == 0) m = PCC_ARRAY_MIN_SIZE;
        while (m < len && m != 0) m <<= 1;
        if (m == 0) m = len;
        table->buf = (pcc_value_t *)PCC_REALLOC(auxil, table->buf, sizeof(pcc_value_t) * m);
        table->max = m;
    }
    table->len = len;
}

MARK_FUNC_AS_USED
static void pcc_value_table__clear(pcc_auxil_t auxil, pcc_value_table_t *table) {
    memset(table->buf, 0, sizeof(pcc_value_t) * table->len);
}

static void pcc_value_table__term(pcc_auxil_t auxil, pcc_value_table_t *table) {
    PCC_FREE(auxil, table->buf);
}

static void pcc_value_refer_table__init(pcc_auxil_t auxil, pcc_value_refer_table_t *table) {
    table->len = 0;
    table->max = 0;
    table->buf = NULL;
}

static void pcc_value_refer_table__resize(pcc_auxil_t auxil, pcc_value_refer_table_t *table, size_t len) {
    size_t i;
    if (table->max < len) {
        size_t m = table->max;
        if (m == 0) m = PCC_ARRAY_MIN_SIZE;
        while (m < len && m != 0) m <<= 1;
        if (m == 0) m = len;
        table->buf = (pcc_value_t **)PCC_REALLOC(auxil, table->buf, sizeof(pcc_value_t *) * m);
        table->max = m;
    }
    for (i = table->len; i < len; i++) table->buf[i] = NULL;
    table->len = len;
}

static void pcc_value_refer_table__term(pcc_auxil_t auxil, pcc_value_refer_table_t *table) {
    PCC_FREE(auxil, table->buf);
}

static void pcc_capture_table__init(pcc_auxil_t auxil, pcc_capture_table_t *table) {
    table->len = 0;
    table->max = 0;
    table->buf = NULL;
}

MARK_FUNC_AS_USED
static void pcc_capture_table__resize(pcc_auxil_t auxil, pcc_capture_table_t *table, size_t len) {
    size_t i;
    for (i = len; i < table->len; i++) PCC_FREE(auxil, table->buf[i].string);
    if (table->max < len) {
        size_t m = table->max;
        if (m == 0) m = PCC_ARRAY_MIN_SIZE;
        while (m < len && m != 0) m <<= 1;
        if (m == 0) m = len;
        table->buf = (pcc_capture_t *)PCC_REALLOC(auxil, table->buf, sizeof(pcc_capture_t) * m);
        table->max = m;
    }
    for (i = table->len; i < len; i++) {
        table->buf[i].range.start = 0;
        table->buf[i].range.end = 0;
        table->buf[i].string = NULL;
    }
    table->len = len;
}

static void pcc_capture_table__term(pcc_auxil_t auxil, pcc_capture_table_t *table) {
    while (table->len > 0) {
        table->len--;
        PCC_FREE(auxil, table->buf[table->len].string);
    }
    PCC_FREE(auxil, table->buf);
}

static void pcc_capture_const_table__init(pcc_auxil_t auxil, pcc_capture_const_table_t *table) {
    table->len = 0;
    table->max = 0;
    table->buf = NULL;
}

static void pcc_capture_const_table__resize(pcc_auxil_t auxil, pcc_capture_const_table_t *table, size_t len) {
    size_t i;
    if (table->max < len) {
        size_t m = table->max;
        if (m == 0) m = PCC_ARRAY_MIN_SIZE;
        while (m < len && m != 0) m <<= 1;
        if (m == 0) m = len;
        table->buf = (const pcc_capture_t **)PCC_REALLOC(auxil, (pcc_capture_t **)table->buf, sizeof(const pcc_capture_t *) * m);
        table->max = m;
    }
    for (i = table->len; i < len; i++) table->buf[i] = NULL;
    table->len = len;
}

static void pcc_capture_const_table__term(pcc_auxil_t auxil, pcc_capture_const_table_t *table) {
    PCC_FREE(auxil, (void *)table->buf);
}

MARK_FUNC_AS_USED
static pcc_thunk_t *pcc_thunk__create_leaf(pcc_auxil_t auxil, pcc_action_t action, size_t valuec, size_t captc) {
    pcc_thunk_t *const thunk = (pcc_thunk_t *)PCC_MALLOC(auxil, sizeof(pcc_thunk_t));
    thunk->type = PCC_THUNK_LEAF;
    pcc_value_refer_table__init(auxil, &thunk->data.leaf.values);
    pcc_value_refer_table__resize(auxil, &thunk->data.leaf.values, valuec);
    pcc_capture_const_table__init(auxil, &thunk->data.leaf.capts);
    pcc_capture_const_table__resize(auxil, &thunk->data.leaf.capts, captc);
    thunk->data.leaf.capt0.range.start = 0;
    thunk->data.leaf.capt0.range.end = 0;
    thunk->data.leaf.capt0.string = NULL;
    thunk->data.leaf.action = action;
    return thunk;
}

static pcc_thunk_t *pcc_thunk__create_node(pcc_auxil_t auxil, const pcc_thunk_array_t *thunks, pcc_value_t *value) {
    pcc_thunk_t *const thunk = (pcc_thunk_t *)PCC_MALLOC(auxil, sizeof(pcc_thunk_t));
    thunk->type = PCC_THUNK_NODE;
    thunk->data.node.thunks = thunks;
    thunk->data.node.value = value;
    return thunk;
}

static void pcc_thunk__destroy(pcc_auxil_t auxil, pcc_thunk_t *thunk) {
    if (thunk == NULL) return;
    switch (thunk->type) {
    case PCC_THUNK_LEAF:
        PCC_FREE(auxil, thunk->data.leaf.capt0.string);
        pcc_capture_const_table__term(auxil, &thunk->data.leaf.capts);
        pcc_value_refer_table__term(auxil, &thunk->data.leaf.values);
        break;
    case PCC_THUNK_NODE:
        break;
    default: /* unknown */
        break;
    }
    PCC_FREE(auxil, thunk);
}

static void pcc_thunk_array__init(pcc_auxil_t auxil, pcc_thunk_array_t *array) {
    array->len = 0;
    array->max = 0;
    array->buf = NULL;
}

static void pcc_thunk_array__add(pcc_auxil_t auxil, pcc_thunk_array_t *array, pcc_thunk_t *thunk) {
    if (array->max <= array->len) {
        const size_t n = array->len + 1;
        size_t m = array->max;
        if (m == 0) m = PCC_ARRAY_MIN_SIZE;
        while (m < n && m != 0) m <<= 1;
        if (m == 0) m = n;
        array->buf = (pcc_thunk_t **)PCC_REALLOC(auxil, array->buf, sizeof(pcc_thunk_t *) * m);
        array->max = m;
    }
    array->buf[array->len++] = thunk;
}

static void pcc_thunk_array__revert(pcc_auxil_t auxil, pcc_thunk_array_t *array, size_t len) {
    while (array->len > len) {
        array->len--;
        pcc_thunk__destroy(auxil, array->buf[array->len]);
    }
}

static void pcc_thunk_array__term(pcc_auxil_t auxil, pcc_thunk_array_t *array) {
    while (array->len > 0) {
        array->len--;
        pcc_thunk__destroy(auxil, array->buf[array->len]);
    }
    PCC_FREE(auxil, array->buf);
}

static void pcc_memory_recycler__init(pcc_auxil_t auxil, pcc_memory_recycler_t *recycler, size_t element_size) {
    recycler->pool_list = NULL;
    recycler->entry_list = NULL;
    recycler->element_size = element_size;
}

static void *pcc_memory_recycler__supply(pcc_auxil_t auxil, pcc_memory_recycler_t *recycler) {
    if (recycler->entry_list) {
        pcc_memory_entry_t *const tmp = recycler->entry_list;
        recycler->entry_list = tmp->next;
        return tmp;
    }
    if (!recycler->pool_list || recycler->pool_list->unused == 0) {
        size_t size = PCC_POOL_MIN_SIZE;
        if (recycler->pool_list) {
            size = recycler->pool_list->allocated << 1;
            if (size == 0) size = recycler->pool_list->allocated;
        }
        {
            pcc_memory_pool_t *const pool = (pcc_memory_pool_t *)PCC_MALLOC(
                auxil, sizeof(pcc_memory_pool_t) + recycler->element_size * size
            );
            pool->allocated = size;
            pool->unused = size;
            pool->next = recycler->pool_list;
            recycler->pool_list = pool;
        }
    }
    recycler->pool_list->unused--;
    return (char *)recycler->pool_list + sizeof(pcc_memory_pool_t) + recycler->element_size * recycler->pool_list->unused;
}

static void pcc_memory_recycler__recycle(pcc_auxil_t auxil, pcc_memory_recycler_t *recycler, void *ptr) {
    pcc_memory_entry_t *const tmp = (pcc_memory_entry_t *)ptr;
    tmp->next = recycler->entry_list;
    recycler->entry_list = tmp;
}

static void pcc_memory_recycler__term(pcc_auxil_t auxil, pcc_memory_recycler_t *recycler) {
    while (recycler->pool_list) {
        pcc_memory_pool_t *const tmp = recycler->pool_list;
        recycler->pool_list = tmp->next;
        PCC_FREE(auxil, tmp);
    }
}

MARK_FUNC_AS_USED
static pcc_thunk_chunk_t *pcc_thunk_chunk__create(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = (pcc_thunk_chunk_t *)pcc_memory_recycler__supply(ctx->auxil, &ctx->thunk_chunk_recycler);
    pcc_value_table__init(ctx->auxil, &chunk->values);
    pcc_capture_table__init(ctx->auxil, &chunk->capts);
    pcc_thunk_array__init(ctx->auxil, &chunk->thunks);
    chunk->pos = 0;
    return chunk;
}

static void pcc_thunk_chunk__destroy(pcc_context_t *ctx, pcc_thunk_chunk_t *chunk) {
    if (chunk == NULL) return;
    pcc_thunk_array__term(ctx->auxil, &chunk->thunks);
    pcc_capture_table__term(ctx->auxil, &chunk->capts);
    pcc_value_table__term(ctx->auxil, &chunk->values);
    pcc_memory_recycler__recycle(ctx->auxil, &ctx->thunk_chunk_recycler, chunk);
}

static void pcc_rule_set__init(pcc_auxil_t auxil, pcc_rule_set_t *set) {
    set->len = 0;
    set->max = 0;
    set->buf = NULL;
}

static size_t pcc_rule_set__index(pcc_auxil_t auxil, const pcc_rule_set_t *set, pcc_rule_t rule) {
    size_t i;
    for (i = 0; i < set->len; i++) {
        if (set->buf[i] == rule) return i;
    }
    return PCC_VOID_VALUE;
}

static pcc_bool_t pcc_rule_set__add(pcc_auxil_t auxil, pcc_rule_set_t *set, pcc_rule_t rule) {
    const size_t i = pcc_rule_set__index(auxil, set, rule);
    if (i != PCC_VOID_VALUE) return PCC_FALSE;
    if (set->max <= set->len) {
        const size_t n = set->len + 1;
        size_t m = set->max;
        if (m == 0) m = PCC_ARRAY_MIN_SIZE;
        while (m < n && m != 0) m <<= 1;
        if (m == 0) m = n;
        set->buf = (pcc_rule_t *)PCC_REALLOC(auxil, set->buf, sizeof(pcc_rule_t) * m);
        set->max = m;
    }
    set->buf[set->len++] = rule;
    return PCC_TRUE;
}

static pcc_bool_t pcc_rule_set__remove(pcc_auxil_t auxil, pcc_rule_set_t *set, pcc_rule_t rule) {
    const size_t i = pcc_rule_set__index(auxil, set, rule);
    if (i == PCC_VOID_VALUE) return PCC_FALSE;
    memmove(set->buf + i, set->buf + (i + 1), sizeof(pcc_rule_t) * (set->len - (i + 1)));
    return PCC_TRUE;
}

static void pcc_rule_set__clear(pcc_auxil_t auxil, pcc_rule_set_t *set) {
    set->len = 0;
}

static void pcc_rule_set__copy(pcc_auxil_t auxil, pcc_rule_set_t *set, const pcc_rule_set_t *src) {
    size_t i;
    pcc_rule_set__clear(auxil, set);
    for (i = 0; i < src->len; i++) {
        pcc_rule_set__add(auxil, set, src->buf[i]);
    }
}

static void pcc_rule_set__term(pcc_auxil_t auxil, pcc_rule_set_t *set) {
    PCC_FREE(auxil, set->buf);
}

static pcc_lr_head_t *pcc_lr_head__create(pcc_context_t *ctx, pcc_rule_t rule) {
    pcc_lr_head_t *const head = (pcc_lr_head_t *)pcc_memory_recycler__supply(ctx->auxil, &ctx->lr_head_recycler);
    head->rule = rule;
    pcc_rule_set__init(ctx->auxil, &head->invol);
    pcc_rule_set__init(ctx->auxil, &head->eval);
    head->hold = NULL;
    return head;
}

static void pcc_lr_head__destroy(pcc_context_t *ctx, pcc_lr_head_t *head) {
    if (head == NULL) return;
    pcc_lr_head__destroy(ctx, head->hold);
    pcc_rule_set__term(ctx->auxil, &head->eval);
    pcc_rule_set__term(ctx->auxil, &head->invol);
    pcc_memory_recycler__recycle(ctx->auxil, &ctx->lr_head_recycler, head);
}

static void pcc_lr_entry__destroy(pcc_auxil_t auxil, pcc_lr_entry_t *lr);

static pcc_lr_answer_t *pcc_lr_answer__create(pcc_context_t *ctx, pcc_lr_answer_type_t type, size_t pos) {
    pcc_lr_answer_t *answer = (pcc_lr_answer_t *)pcc_memory_recycler__supply(ctx->auxil, &ctx->lr_answer_recycler);
    answer->type = type;
    answer->pos = pos;
    answer->hold = NULL;
    switch (answer->type) {
    case PCC_LR_ANSWER_LR:
        answer->data.lr = NULL;
        break;
    case PCC_LR_ANSWER_CHUNK:
        answer->data.chunk = NULL;
        break;
    default: /* unknown */
        PCC_FREE(ctx->auxil, answer);
        answer = NULL;
    }
    return answer;
}

static void pcc_lr_answer__set_chunk(pcc_context_t *ctx, pcc_lr_answer_t *answer, pcc_thunk_chunk_t *chunk) {
    pcc_lr_answer_t *const a = pcc_lr_answer__create(ctx, answer->type, answer->pos);
    switch (answer->type) {
    case PCC_LR_ANSWER_LR:
        a->data.lr = answer->data.lr;
        break;
    case PCC_LR_ANSWER_CHUNK:
        a->data.chunk = answer->data.chunk;
        break;
    default: /* unknown */
        break;
    }
    a->hold = answer->hold;
    answer->hold = a;
    answer->type = PCC_LR_ANSWER_CHUNK;
    answer->data.chunk = chunk;
}

static void pcc_lr_answer__destroy(pcc_context_t *ctx, pcc_lr_answer_t *answer) {
    while (answer != NULL) {
        pcc_lr_answer_t *const a = answer->hold;
        switch (answer->type) {
        case PCC_LR_ANSWER_LR:
            pcc_lr_entry__destroy(ctx->auxil, answer->data.lr);
            break;
        case PCC_LR_ANSWER_CHUNK:
            pcc_thunk_chunk__destroy(ctx, answer->data.chunk);
            break;
        default: /* unknown */
            break;
        }
        pcc_memory_recycler__recycle(ctx->auxil, &ctx->lr_answer_recycler, answer);
        answer = a;
    }
}

static void pcc_lr_memo_map__init(pcc_auxil_t auxil, pcc_lr_memo_map_t *map) {
    map->len = 0;
    map->max = 0;
    map->buf = NULL;
}

static size_t pcc_lr_memo_map__index(pcc_context_t *ctx, pcc_lr_memo_map_t *map, pcc_rule_t rule) {
    size_t i;
    for (i = 0; i < map->len; i++) {
        if (map->buf[i].rule == rule) return i;
    }
    return PCC_VOID_VALUE;
}

static void pcc_lr_memo_map__put(pcc_context_t *ctx, pcc_lr_memo_map_t *map, pcc_rule_t rule, pcc_lr_answer_t *answer) {
    const size_t i = pcc_lr_memo_map__index(ctx, map, rule);
    if (i != PCC_VOID_VALUE) {
        pcc_lr_answer__destroy(ctx, map->buf[i].answer);
        map->buf[i].answer = answer;
    }
    else {
        if (map->max <= map->len) {
            const size_t n = map->len + 1;
            size_t m = map->max;
            if (m == 0) m = PCC_ARRAY_MIN_SIZE;
            while (m < n && m != 0) m <<= 1;
            if (m == 0) m = n;
            map->buf = (pcc_lr_memo_t *)PCC_REALLOC(ctx->auxil, map->buf, sizeof(pcc_lr_memo_t) * m);
            map->max = m;
        }
        map->buf[map->len].rule = rule;
        map->buf[map->len].answer = answer;
        map->len++;
    }
}

static pcc_lr_answer_t *pcc_lr_memo_map__get(pcc_context_t *ctx, pcc_lr_memo_map_t *map, pcc_rule_t rule) {
    const size_t i = pcc_lr_memo_map__index(ctx, map, rule);
    return (i != PCC_VOID_VALUE) ? map->buf[i].answer : NULL;
}

static void pcc_lr_memo_map__term(pcc_context_t *ctx, pcc_lr_memo_map_t *map) {
    while (map->len > 0) {
        map->len--;
        pcc_lr_answer__destroy(ctx, map->buf[map->len].answer);
    }
    PCC_FREE(ctx->auxil, map->buf);
}

static pcc_lr_table_entry_t *pcc_lr_table_entry__create(pcc_context_t *ctx) {
    pcc_lr_table_entry_t *const entry = (pcc_lr_table_entry_t *)PCC_MALLOC(ctx->auxil, sizeof(pcc_lr_table_entry_t));
    entry->head = NULL;
    pcc_lr_memo_map__init(ctx->auxil, &entry->memos);
    entry->hold_a = NULL;
    entry->hold_h = NULL;
    return entry;
}

static void pcc_lr_table_entry__destroy(pcc_context_t *ctx, pcc_lr_table_entry_t *entry) {
    if (entry == NULL) return;
    pcc_lr_head__destroy(ctx, entry->hold_h);
    pcc_lr_answer__destroy(ctx, entry->hold_a);
    pcc_lr_memo_map__term(ctx, &entry->memos);
    PCC_FREE(ctx->auxil, entry);
}

static void pcc_lr_table__init(pcc_auxil_t auxil, pcc_lr_table_t *table) {
    table->ofs = 0;
    table->len = 0;
    table->max = 0;
    table->buf = NULL;
}

static void pcc_lr_table__resize(pcc_context_t *ctx, pcc_lr_table_t *table, size_t len) {
    size_t i;
    for (i = len; i < table->len; i++) pcc_lr_table_entry__destroy(ctx, table->buf[i]);
    if (table->max < len) {
        size_t m = table->max;
        if (m == 0) m = PCC_ARRAY_MIN_SIZE;
        while (m < len && m != 0) m <<= 1;
        if (m == 0) m = len;
        table->buf = (pcc_lr_table_entry_t **)PCC_REALLOC(ctx->auxil, table->buf, sizeof(pcc_lr_table_entry_t *) * m);
        table->max = m;
    }
    for (i = table->len; i < len; i++) table->buf[i] = NULL;
    table->len = len;
}

static void pcc_lr_table__set_head(pcc_context_t *ctx, pcc_lr_table_t *table, size_t index, pcc_lr_head_t *head) {
    index += table->ofs;
    if (index >= table->len) pcc_lr_table__resize(ctx, table, index + 1);
    if (table->buf[index] == NULL) table->buf[index] = pcc_lr_table_entry__create(ctx);
    table->buf[index]->head = head;
}

static void pcc_lr_table__hold_head(pcc_context_t *ctx, pcc_lr_table_t *table, size_t index, pcc_lr_head_t *head) {
    index += table->ofs;
    if (index >= table->len) pcc_lr_table__resize(ctx, table, index + 1);
    if (table->buf[index] == NULL) table->buf[index] = pcc_lr_table_entry__create(ctx);
    head->hold = table->buf[index]->hold_h;
    table->buf[index]->hold_h = head;
}

static void pcc_lr_table__set_answer(pcc_context_t *ctx, pcc_lr_table_t *table, size_t index, pcc_rule_t rule, pcc_lr_answer_t *answer) {
    index += table->ofs;
    if (index >= table->len) pcc_lr_table__resize(ctx, table, index + 1);
    if (table->buf[index] == NULL) table->buf[index] = pcc_lr_table_entry__create(ctx);
    pcc_lr_memo_map__put(ctx, &table->buf[index]->memos, rule, answer);
}

static void pcc_lr_table__hold_answer(pcc_context_t *ctx, pcc_lr_table_t *table, size_t index, pcc_lr_answer_t *answer) {
    index += table->ofs;
    if (index >= table->len) pcc_lr_table__resize(ctx, table, index + 1);
    if (table->buf[index] == NULL) table->buf[index] = pcc_lr_table_entry__create(ctx);
    answer->hold = table->buf[index]->hold_a;
    table->buf[index]->hold_a = answer;
}

static pcc_lr_head_t *pcc_lr_table__get_head(pcc_context_t *ctx, pcc_lr_table_t *table, size_t index) {
    index += table->ofs;
    if (index >= table->len || table->buf[index] == NULL) return NULL;
    return table->buf[index]->head;
}

static pcc_lr_answer_t *pcc_lr_table__get_answer(pcc_context_t *ctx, pcc_lr_table_t *table, size_t index, pcc_rule_t rule) {
    index += table->ofs;
    if (index >= table->len || table->buf[index] == NULL) return NULL;
    return pcc_lr_memo_map__get(ctx, &table->buf[index]->memos, rule);
}

static void pcc_lr_table__shift(pcc_context_t *ctx, pcc_lr_table_t *table, size_t count) {
    size_t i;
    if (count > table->len - table->ofs) count = table->len - table->ofs;
    for (i = 0; i < count; i++) pcc_lr_table_entry__destroy(ctx, table->buf[table->ofs++]);
    if (table->ofs > (table->max >> 1)) {
        memmove(table->buf, table->buf + table->ofs, sizeof(pcc_lr_table_entry_t *) * (table->len - table->ofs));
        table->len -= table->ofs;
        table->ofs = 0;
    }
}

static void pcc_lr_table__term(pcc_context_t *ctx, pcc_lr_table_t *table) {
    while (table->len > table->ofs) {
        table->len--;
        pcc_lr_table_entry__destroy(ctx, table->buf[table->len]);
    }
    PCC_FREE(ctx->auxil, table->buf);
}

static pcc_lr_entry_t *pcc_lr_entry__create(pcc_auxil_t auxil, pcc_rule_t rule) {
    pcc_lr_entry_t *const lr = (pcc_lr_entry_t *)PCC_MALLOC(auxil, sizeof(pcc_lr_entry_t));
    lr->rule = rule;
    lr->seed = NULL;
    lr->head = NULL;
    return lr;
}

static void pcc_lr_entry__destroy(pcc_auxil_t auxil, pcc_lr_entry_t *lr) {
    PCC_FREE(auxil, lr);
}

static void pcc_lr_stack__init(pcc_auxil_t auxil, pcc_lr_stack_t *stack) {
    stack->len = 0;
    stack->max = 0;
    stack->buf = NULL;
}

static void pcc_lr_stack__push(pcc_auxil_t auxil, pcc_lr_stack_t *stack, pcc_lr_entry_t *lr) {
    if (stack->max <= stack->len) {
        const size_t n = stack->len + 1;
        size_t m = stack->max;
        if (m == 0) m = PCC_ARRAY_MIN_SIZE;
        while (m < n && m != 0) m <<= 1;
        if (m == 0) m = n;
        stack->buf = (pcc_lr_entry_t **)PCC_REALLOC(auxil, stack->buf, sizeof(pcc_lr_entry_t *) * m);
        stack->max = m;
    }
    stack->buf[stack->len++] = lr;
}

static pcc_lr_entry_t *pcc_lr_stack__pop(pcc_auxil_t auxil, pcc_lr_stack_t *stack) {
    return stack->buf[--stack->len];
}

static void pcc_lr_stack__term(pcc_auxil_t auxil, pcc_lr_stack_t *stack) {
    PCC_FREE(auxil, stack->buf);
}

static pcc_context_t *pcc_context__create(pcc_auxil_t auxil) {
    pcc_context_t *const ctx = (pcc_context_t *)PCC_MALLOC(auxil, sizeof(pcc_context_t));
    ctx->pos = 0;
    ctx->cur = 0;
    ctx->level = 0;
    pcc_char_array__init(auxil, &ctx->buffer);
    pcc_lr_table__init(auxil, &ctx->lrtable);
    pcc_lr_stack__init(auxil, &ctx->lrstack);
    pcc_thunk_array__init(auxil, &ctx->thunks);
    pcc_memory_recycler__init(auxil, &ctx->thunk_chunk_recycler, sizeof(pcc_thunk_chunk_t));
    pcc_memory_recycler__init(auxil, &ctx->lr_head_recycler, sizeof(pcc_lr_head_t));
    pcc_memory_recycler__init(auxil, &ctx->lr_answer_recycler, sizeof(pcc_lr_answer_t));
    ctx->auxil = auxil;
    return ctx;
}

static void pcc_context__destroy(pcc_context_t *ctx) {
    if (ctx == NULL) return;
    pcc_thunk_array__term(ctx->auxil, &ctx->thunks);
    pcc_lr_stack__term(ctx->auxil, &ctx->lrstack);
    pcc_lr_table__term(ctx, &ctx->lrtable);
    pcc_char_array__term(ctx->auxil, &ctx->buffer);
    pcc_memory_recycler__term(ctx->auxil, &ctx->thunk_chunk_recycler);
    pcc_memory_recycler__term(ctx->auxil, &ctx->lr_head_recycler);
    pcc_memory_recycler__term(ctx->auxil, &ctx->lr_answer_recycler);
    PCC_FREE(ctx->auxil, ctx);
}

static size_t pcc_refill_buffer(pcc_context_t *ctx, size_t num) {
    if (ctx->buffer.len >= ctx->cur + num) return ctx->buffer.len - ctx->cur;
    while (ctx->buffer.len < ctx->cur + num) {
        const int c = PCC_GETCHAR(ctx->auxil);
        if (c < 0) break;
        pcc_char_array__add(ctx->auxil, &ctx->buffer, (char)c);
    }
    return ctx->buffer.len - ctx->cur;
}

MARK_FUNC_AS_USED
static void pcc_commit_buffer(pcc_context_t *ctx) {
    memmove(ctx->buffer.buf, ctx->buffer.buf + ctx->cur, ctx->buffer.len - ctx->cur);
    ctx->buffer.len -= ctx->cur;
    ctx->pos += ctx->cur;
    pcc_lr_table__shift(ctx, &ctx->lrtable, ctx->cur);
    ctx->cur = 0;
}

MARK_FUNC_AS_USED
static const char *pcc_get_capture_string(pcc_context_t *ctx, const pcc_capture_t *capt) {
    if (capt->string == NULL)
        ((pcc_capture_t *)capt)->string =
            pcc_strndup_e(ctx->auxil, ctx->buffer.buf + capt->range.start, capt->range.end - capt->range.start);
    return capt->string;
}

static size_t pcc_get_char_as_utf32(pcc_context_t *ctx, int *out) { /* with checking UTF-8 validity */
    int c, u;
    size_t n;
    if (pcc_refill_buffer(ctx, 1) < 1) return 0;
    c = (int)(unsigned char)ctx->buffer.buf[ctx->cur];
    n = (c < 0x80) ? 1 :
        ((c & 0xe0) == 0xc0) ? 2 :
        ((c & 0xf0) == 0xe0) ? 3 :
        ((c & 0xf8) == 0xf0) ? 4 : 0;
    if (n < 1) return 0;
    if (pcc_refill_buffer(ctx, n) < n) return 0;
    switch (n) {
    case 1:
        u = c;
        break;
    case 2:
        u = c & 0x1f;
        c = (int)(unsigned char)ctx->buffer.buf[ctx->cur + 1];
        if ((c & 0xc0) != 0x80) return 0;
        u <<= 6; u |= c & 0x3f;
        if (u < 0x80) return 0;
        break;
    case 3:
        u = c & 0x0f;
        c = (int)(unsigned char)ctx->buffer.buf[ctx->cur + 1];
        if ((c & 0xc0) != 0x80) return 0;
        u <<= 6; u |= c & 0x3f;
        c = (int)(unsigned char)ctx->buffer.buf[ctx->cur + 2];
        if ((c & 0xc0) != 0x80) return 0;
        u <<= 6; u |= c & 0x3f;
        if (u < 0x800) return 0;
        break;
    case 4:
        u = c & 0x07;
        c = (int)(unsigned char)ctx->buffer.buf[ctx->cur + 1];
        if ((c & 0xc0) != 0x80) return 0;
        u <<= 6; u |= c & 0x3f;
        c = (int)(unsigned char)ctx->buffer.buf[ctx->cur + 2];
        if ((c & 0xc0) != 0x80) return 0;
        u <<= 6; u |= c & 0x3f;
        c = (int)(unsigned char)ctx->buffer.buf[ctx->cur + 3];
        if ((c & 0xc0) != 0x80) return 0;
        u <<= 6; u |= c & 0x3f;
        if (u < 0x10000 || u > 0x10ffff) return 0;
        break;
    default:
        return 0;
    }
    if (out) *out = u;
    return n;
}

MARK_FUNC_AS_USED
static pcc_bool_t pcc_apply_rule(pcc_context_t *ctx, pcc_rule_t rule, pcc_thunk_array_t *thunks, pcc_value_t *value) {
    static pcc_value_t null;
    pcc_thunk_chunk_t *c = NULL;
    const size_t p = ctx->pos + ctx->cur;
    pcc_bool_t b = PCC_TRUE;
    pcc_lr_answer_t *a = pcc_lr_table__get_answer(ctx, &ctx->lrtable, p, rule);
    pcc_lr_head_t *h = pcc_lr_table__get_head(ctx, &ctx->lrtable, p);
    if (h != NULL) {
        if (a == NULL && rule != h->rule && pcc_rule_set__index(ctx->auxil, &h->invol, rule) == PCC_VOID_VALUE) {
            b = PCC_FALSE;
            c = NULL;
        }
        else if (pcc_rule_set__remove(ctx->auxil, &h->eval, rule)) {
            b = PCC_FALSE;
            c = rule(ctx);
            a = pcc_lr_answer__create(ctx, PCC_LR_ANSWER_CHUNK, ctx->pos + ctx->cur);
            a->data.chunk = c;
            pcc_lr_table__hold_answer(ctx, &ctx->lrtable, p, a);
        }
    }
    if (b) {
        if (a != NULL) {
            ctx->cur = a->pos - ctx->pos;
            switch (a->type) {
            case PCC_LR_ANSWER_LR:
                if (a->data.lr->head == NULL) {
                    a->data.lr->head = pcc_lr_head__create(ctx, rule);
                    pcc_lr_table__hold_head(ctx, &ctx->lrtable, p, a->data.lr->head);
                }
                {
                    size_t i = ctx->lrstack.len;
                    while (i > 0) {
                        i--;
                        if (ctx->lrstack.buf[i]->head == a->data.lr->head) break;
                        ctx->lrstack.buf[i]->head = a->data.lr->head;
                        pcc_rule_set__add(ctx->auxil, &a->data.lr->head->invol, ctx->lrstack.buf[i]->rule);
                    }
                }
                c = a->data.lr->seed;
                break;
            case PCC_LR_ANSWER_CHUNK:
                c = a->data.chunk;
                break;
            default: /* unknown */
                break;
            }
        }
        else {
            pcc_lr_entry_t *const e = pcc_lr_entry__create(ctx->auxil, rule);
            pcc_lr_stack__push(ctx->auxil, &ctx->lrstack, e);
            a = pcc_lr_answer__create(ctx, PCC_LR_ANSWER_LR, p);
            a->data.lr = e;
            pcc_lr_table__set_answer(ctx, &ctx->lrtable, p, rule, a);
            c = rule(ctx);
            pcc_lr_stack__pop(ctx->auxil, &ctx->lrstack);
            a->pos = ctx->pos + ctx->cur;
            if (e->head == NULL) {
                pcc_lr_answer__set_chunk(ctx, a, c);
            }
            else {
                e->seed = c;
                h = a->data.lr->head;
                if (h->rule != rule) {
                    c = a->data.lr->seed;
                    a = pcc_lr_answer__create(ctx, PCC_LR_ANSWER_CHUNK, ctx->pos + ctx->cur);
                    a->data.chunk = c;
                    pcc_lr_table__hold_answer(ctx, &ctx->lrtable, p, a);
                }
                else {
                    pcc_lr_answer__set_chunk(ctx, a, a->data.lr->seed);
                    if (a->data.chunk == NULL) {
                        c = NULL;
                    }
                    else {
                        pcc_lr_table__set_head(ctx, &ctx->lrtable, p, h);
                        for (;;) {
                            ctx->cur = p - ctx->pos;
                            pcc_rule_set__copy(ctx->auxil, &h->eval, &h->invol);
                            c = rule(ctx);
                            if (c == NULL || ctx->pos + ctx->cur <= a->pos) break;
                            pcc_lr_answer__set_chunk(ctx, a, c);
                            a->pos = ctx->pos + ctx->cur;
                        }
                        pcc_thunk_chunk__destroy(ctx, c);
                        pcc_lr_table__set_head(ctx, &ctx->lrtable, p, NULL);
                        ctx->cur = a->pos - ctx->pos;
                        c = a->data.chunk;
                    }
                }
            }
        }
    }
    if (c == NULL) return PCC_FALSE;
    if (value == NULL) value = &null;
    memset(value, 0, sizeof(pcc_value_t)); /* in case */
    pcc_thunk_array__add(ctx->auxil, thunks, pcc_thunk__create_node(ctx->auxil, &c->thunks, value));
    return PCC_TRUE;
}

MARK_FUNC_AS_USED
static void pcc_do_action(pcc_context_t *ctx, const pcc_thunk_array_t *thunks, pcc_value_t *value) {
    size_t i;
    for (i = 0; i < thunks->len; i++) {
        pcc_thunk_t *const thunk = thunks->buf[i];
        switch (thunk->type) {
        case PCC_THUNK_LEAF:
            thunk->data.leaf.action(ctx, thunk, value);
            break;
        case PCC_THUNK_NODE:
            pcc_do_action(ctx, thunk->data.node.thunks, thunk->data.node.value);
            break;
        default: /* unknown */
            break;
        }
    }
}

static void pcc_action_Include_0(pthrift_context_t *__pcc_ctx, pcc_thunk_t *__pcc_in, pcc_value_t *__pcc_out) {
#define auxil (__pcc_ctx->auxil)
#define __ (*__pcc_out)
#define _0 pcc_get_capture_string(__pcc_ctx, &__pcc_in->data.leaf.capt0)
#define _0s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.start))
#define _0e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.end))
#define _1 pcc_get_capture_string(__pcc_ctx, __pcc_in->data.leaf.capts.buf[0])
#define _1s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[0]->range.start))
#define _1e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[0]->range.end))
#define _2 pcc_get_capture_string(__pcc_ctx, __pcc_in->data.leaf.capts.buf[1])
#define _2s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[1]->range.start))
#define _2e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[1]->range.end))
    vString *f = unliteral (_2);
    if (vStringLength(f) > 0)
    {
        if (_1[0] == 'i')
            makeThriftTagFull (auxil, vStringValue (f), _2s, K_THRIFTFILE, THRIFT_THRIFT_FILE_INCLUDED, false);
        else
        {
            tagEntryInfo e;
            initForeignRefTagEntry (&e, vStringValue(f), getNamedLanguage ("C++", 0), CXXTagKindINCLUDE, CR_HEADER_LOCAL);
            e.lineNumber = getInputLineNumberForFileOffset (_2s);
            e.filePosition = getInputFilePositionForLine (e.lineNumber);
            makeTagEntry (&e);
        }
    }
    vStringDelete (f);
#undef _2e
#undef _2s
#undef _2
#undef _1e
#undef _1s
#undef _1
#undef _0e
#undef _0s
#undef _0
#undef __
#undef auxil
}

static void pcc_action_Namespace_0(pthrift_context_t *__pcc_ctx, pcc_thunk_t *__pcc_in, pcc_value_t *__pcc_out) {
#define auxil (__pcc_ctx->auxil)
#define __ (*__pcc_out)
#define _0 pcc_get_capture_string(__pcc_ctx, &__pcc_in->data.leaf.capt0)
#define _0s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.start))
#define _0e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.end))
#define _1 pcc_get_capture_string(__pcc_ctx, __pcc_in->data.leaf.capts.buf[0])
#define _1s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[0]->range.start))
#define _1e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[0]->range.end))
#define _2 pcc_get_capture_string(__pcc_ctx, __pcc_in->data.leaf.capts.buf[1])
#define _2s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[1]->range.start))
#define _2e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[1]->range.end))
    int r = makeThriftTag (auxil, _2, _2s, K_NAMESPACE, false);
    attachParserFieldToCorkEntry (r, ThriftFields[F_TARGET].ftype, _1);
#undef _2e
#undef _2s
#undef _2
#undef _1e
#undef _1s
#undef _1
#undef _0e
#undef _0s
#undef _0
#undef __
#undef auxil
}

static void pcc_action_Const_0(pthrift_context_t *__pcc_ctx, pcc_thunk_t *__pcc_in, pcc_value_t *__pcc_out) {
#define auxil (__pcc_ctx->auxil)
#define __ (*__pcc_out)
#define _0 pcc_get_capture_string(__pcc_ctx, &__pcc_in->data.leaf.capt0)
#define _0s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.start))
#define _0e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.end))
#define _1 pcc_get_capture_string(__pcc_ctx, __pcc_in->data.leaf.capts.buf[0])
#define _1s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[0]->range.start))
#define _1e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[0]->range.end))
#define _2 pcc_get_capture_string(__pcc_ctx, __pcc_in->data.leaf.capts.buf[1])
#define _2s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[1]->range.start))
#define _2e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[1]->range.end))
    int r = makeThriftTag (auxil, _2, _2s, K_CONST, false);
    tagEntryInfo *e = getEntryInCorkQueue (r);
    if (e)
    {
        e->extensionFields.typeRef[0] = eStrdup ("typename");
        e->extensionFields.typeRef[1] = eStrdup (_1);
    }
#undef _2e
#undef _2s
#undef _2
#undef _1e
#undef _1s
#undef _1
#undef _0e
#undef _0s
#undef _0
#undef __
#undef auxil
}

static void pcc_action_Enum_0(pthrift_context_t *__pcc_ctx, pcc_thunk_t *__pcc_in, pcc_value_t *__pcc_out) {
#define auxil (__pcc_ctx->auxil)
#define __ (*__pcc_out)
#define _0 pcc_get_capture_string(__pcc_ctx, &__pcc_in->data.leaf.capt0)
#define _0s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.start))
#define _0e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.end))
    PUSH_KIND (auxil, K_ENUM);
#undef _0e
#undef _0s
#undef _0
#undef __
#undef auxil
}

static void pcc_action_Enum_1(pthrift_context_t *__pcc_ctx, pcc_thunk_t *__pcc_in, pcc_value_t *__pcc_out) {
#define auxil (__pcc_ctx->auxil)
#define __ (*__pcc_out)
#define _0 pcc_get_capture_string(__pcc_ctx, &__pcc_in->data.leaf.capt0)
#define _0s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.start))
#define _0e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.end))
#define _1 pcc_get_capture_string(__pcc_ctx, __pcc_in->data.leaf.capts.buf[0])
#define _1s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[0]->range.start))
#define _1e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[0]->range.end))
    makeThriftTag (auxil, _1, _1s, USE_KIND_STACK, true);
#undef _1e
#undef _1s
#undef _1
#undef _0e
#undef _0s
#undef _0
#undef __
#undef auxil
}

static void pcc_action_Enum_2(pthrift_context_t *__pcc_ctx, pcc_thunk_t *__pcc_in, pcc_value_t *__pcc_out) {
#define auxil (__pcc_ctx->auxil)
#define __ (*__pcc_out)
#define _0 pcc_get_capture_string(__pcc_ctx, &__pcc_in->data.leaf.capt0)
#define _0s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.start))
#define _0e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.end))
#define _1 pcc_get_capture_string(__pcc_ctx, __pcc_in->data.leaf.capts.buf[0])
#define _1s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[0]->range.start))
#define _1e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[0]->range.end))
    POP_KIND (auxil, true);
#undef _1e
#undef _1s
#undef _1
#undef _0e
#undef _0s
#undef _0
#undef __
#undef auxil
}

static void pcc_action_EnumValue_0(pthrift_context_t *__pcc_ctx, pcc_thunk_t *__pcc_in, pcc_value_t *__pcc_out) {
#define auxil (__pcc_ctx->auxil)
#define __ (*__pcc_out)
#define _0 pcc_get_capture_string(__pcc_ctx, &__pcc_in->data.leaf.capt0)
#define _0s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.start))
#define _0e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.end))
#define _1 pcc_get_capture_string(__pcc_ctx, __pcc_in->data.leaf.capts.buf[0])
#define _1s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[0]->range.start))
#define _1e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[0]->range.end))
    makeThriftTag (auxil, _1, _1s, K_ENUMERATOR, false);
#undef _1e
#undef _1s
#undef _1
#undef _0e
#undef _0s
#undef _0
#undef __
#undef auxil
}

static void pcc_action_TypeDef_0(pthrift_context_t *__pcc_ctx, pcc_thunk_t *__pcc_in, pcc_value_t *__pcc_out) {
#define auxil (__pcc_ctx->auxil)
#define __ (*__pcc_out)
#define _0 pcc_get_capture_string(__pcc_ctx, &__pcc_in->data.leaf.capt0)
#define _0s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.start))
#define _0e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.end))
#define _1 pcc_get_capture_string(__pcc_ctx, __pcc_in->data.leaf.capts.buf[0])
#define _1s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[0]->range.start))
#define _1e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[0]->range.end))
#define _2 pcc_get_capture_string(__pcc_ctx, __pcc_in->data.leaf.capts.buf[1])
#define _2s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[1]->range.start))
#define _2e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[1]->range.end))
    int r = makeThriftTag (auxil, _2, _2s, K_TYPEDEF, false);
    tagEntryInfo *e = getEntryInCorkQueue (r);
    if (e)
    {
        e->extensionFields.typeRef[0] = eStrdup ("typename");
        e->extensionFields.typeRef[1] = eStrdup (_1);
    }
#undef _2e
#undef _2s
#undef _2
#undef _1e
#undef _1s
#undef _1
#undef _0e
#undef _0s
#undef _0
#undef __
#undef auxil
}

static void pcc_action_Struct_0(pthrift_context_t *__pcc_ctx, pcc_thunk_t *__pcc_in, pcc_value_t *__pcc_out) {
#define auxil (__pcc_ctx->auxil)
#define __ (*__pcc_out)
#define _0 pcc_get_capture_string(__pcc_ctx, &__pcc_in->data.leaf.capt0)
#define _0s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.start))
#define _0e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.end))
    PUSH_KIND (auxil, K_STRUCT);
#undef _0e
#undef _0s
#undef _0
#undef __
#undef auxil
}

static void pcc_action_Struct_1(pthrift_context_t *__pcc_ctx, pcc_thunk_t *__pcc_in, pcc_value_t *__pcc_out) {
#define auxil (__pcc_ctx->auxil)
#define __ (*__pcc_out)
#define _0 pcc_get_capture_string(__pcc_ctx, &__pcc_in->data.leaf.capt0)
#define _0s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.start))
#define _0e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.end))
    POP_KIND (auxil, true);
#undef _0e
#undef _0s
#undef _0
#undef __
#undef auxil
}

static void pcc_action_Exception_0(pthrift_context_t *__pcc_ctx, pcc_thunk_t *__pcc_in, pcc_value_t *__pcc_out) {
#define auxil (__pcc_ctx->auxil)
#define __ (*__pcc_out)
#define _0 pcc_get_capture_string(__pcc_ctx, &__pcc_in->data.leaf.capt0)
#define _0s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.start))
#define _0e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.end))
    PUSH_KIND (auxil, K_EXCEPTION);
#undef _0e
#undef _0s
#undef _0
#undef __
#undef auxil
}

static void pcc_action_Exception_1(pthrift_context_t *__pcc_ctx, pcc_thunk_t *__pcc_in, pcc_value_t *__pcc_out) {
#define auxil (__pcc_ctx->auxil)
#define __ (*__pcc_out)
#define _0 pcc_get_capture_string(__pcc_ctx, &__pcc_in->data.leaf.capt0)
#define _0s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.start))
#define _0e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.end))
    POP_KIND (auxil, true);
#undef _0e
#undef _0s
#undef _0
#undef __
#undef auxil
}

static void pcc_action_Union_0(pthrift_context_t *__pcc_ctx, pcc_thunk_t *__pcc_in, pcc_value_t *__pcc_out) {
#define auxil (__pcc_ctx->auxil)
#define __ (*__pcc_out)
#define _0 pcc_get_capture_string(__pcc_ctx, &__pcc_in->data.leaf.capt0)
#define _0s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.start))
#define _0e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.end))
    PUSH_KIND (auxil, K_UNION);
#undef _0e
#undef _0s
#undef _0
#undef __
#undef auxil
}

static void pcc_action_Union_1(pthrift_context_t *__pcc_ctx, pcc_thunk_t *__pcc_in, pcc_value_t *__pcc_out) {
#define auxil (__pcc_ctx->auxil)
#define __ (*__pcc_out)
#define _0 pcc_get_capture_string(__pcc_ctx, &__pcc_in->data.leaf.capt0)
#define _0s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.start))
#define _0e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.end))
    POP_KIND (auxil, true);
#undef _0e
#undef _0s
#undef _0
#undef __
#undef auxil
}

static void pcc_action_StructLike_0(pthrift_context_t *__pcc_ctx, pcc_thunk_t *__pcc_in, pcc_value_t *__pcc_out) {
#define auxil (__pcc_ctx->auxil)
#define __ (*__pcc_out)
#define _0 pcc_get_capture_string(__pcc_ctx, &__pcc_in->data.leaf.capt0)
#define _0s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.start))
#define _0e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.end))
#define _1 pcc_get_capture_string(__pcc_ctx, __pcc_in->data.leaf.capts.buf[0])
#define _1s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[0]->range.start))
#define _1e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[0]->range.end))
    makeThriftTag (auxil, _1, _1s, USE_KIND_STACK, true);
    PUSH_KIND (auxil, K_MEMBER);
#undef _1e
#undef _1s
#undef _1
#undef _0e
#undef _0s
#undef _0
#undef __
#undef auxil
}

static void pcc_action_StructLike_1(pthrift_context_t *__pcc_ctx, pcc_thunk_t *__pcc_in, pcc_value_t *__pcc_out) {
#define auxil (__pcc_ctx->auxil)
#define __ (*__pcc_out)
#define _0 pcc_get_capture_string(__pcc_ctx, &__pcc_in->data.leaf.capt0)
#define _0s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.start))
#define _0e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.end))
#define _1 pcc_get_capture_string(__pcc_ctx, __pcc_in->data.leaf.capts.buf[0])
#define _1s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[0]->range.start))
#define _1e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[0]->range.end))
    POP_KIND (auxil, false);
#undef _1e
#undef _1s
#undef _1
#undef _0e
#undef _0s
#undef _0
#undef __
#undef auxil
}

static void pcc_action_Field_0(pthrift_context_t *__pcc_ctx, pcc_thunk_t *__pcc_in, pcc_value_t *__pcc_out) {
#define auxil (__pcc_ctx->auxil)
#define __ (*__pcc_out)
#define _0 pcc_get_capture_string(__pcc_ctx, &__pcc_in->data.leaf.capt0)
#define _0s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.start))
#define _0e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.end))
#define _1 pcc_get_capture_string(__pcc_ctx, __pcc_in->data.leaf.capts.buf[0])
#define _1s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[0]->range.start))
#define _1e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[0]->range.end))
#define _2 pcc_get_capture_string(__pcc_ctx, __pcc_in->data.leaf.capts.buf[1])
#define _2s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[1]->range.start))
#define _2e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[1]->range.end))
    int r = makeThriftTag (auxil, _2, _2s, USE_KIND_STACK, false);
    tagEntryInfo *e = getEntryInCorkQueue (r);
    if (e)
    {
        e->extensionFields.typeRef[0] = eStrdup ("typename");
        e->extensionFields.typeRef[1] = eStrdup (_1);
    }
#undef _2e
#undef _2s
#undef _2
#undef _1e
#undef _1s
#undef _1
#undef _0e
#undef _0s
#undef _0
#undef __
#undef auxil
}

static void pcc_action_Service_0(pthrift_context_t *__pcc_ctx, pcc_thunk_t *__pcc_in, pcc_value_t *__pcc_out) {
#define auxil (__pcc_ctx->auxil)
#define __ (*__pcc_out)
#define _0 pcc_get_capture_string(__pcc_ctx, &__pcc_in->data.leaf.capt0)
#define _0s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.start))
#define _0e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.end))
#define _1 pcc_get_capture_string(__pcc_ctx, __pcc_in->data.leaf.capts.buf[0])
#define _1s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[0]->range.start))
#define _1e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[0]->range.end))
    makeThriftTag (auxil, _1, _1s, K_SERVICE, true);
#undef _1e
#undef _1s
#undef _1
#undef _0e
#undef _0s
#undef _0
#undef __
#undef auxil
}

static void pcc_action_Service_1(pthrift_context_t *__pcc_ctx, pcc_thunk_t *__pcc_in, pcc_value_t *__pcc_out) {
#define auxil (__pcc_ctx->auxil)
#define __ (*__pcc_out)
#define _0 pcc_get_capture_string(__pcc_ctx, &__pcc_in->data.leaf.capt0)
#define _0s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.start))
#define _0e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.end))
#define _1 pcc_get_capture_string(__pcc_ctx, __pcc_in->data.leaf.capts.buf[0])
#define _1s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[0]->range.start))
#define _1e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[0]->range.end))
#define _2 pcc_get_capture_string(__pcc_ctx, __pcc_in->data.leaf.capts.buf[1])
#define _2s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[1]->range.start))
#define _2e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[1]->range.end))
    int r = BASE_SCOPE (auxil);
    tagEntryInfo *e = getEntryInCorkQueue (r);
    if (e)
        e->extensionFields.inheritance = eStrdup (_2);
#undef _2e
#undef _2s
#undef _2
#undef _1e
#undef _1s
#undef _1
#undef _0e
#undef _0s
#undef _0
#undef __
#undef auxil
}

static void pcc_action_Service_2(pthrift_context_t *__pcc_ctx, pcc_thunk_t *__pcc_in, pcc_value_t *__pcc_out) {
#define auxil (__pcc_ctx->auxil)
#define __ (*__pcc_out)
#define _0 pcc_get_capture_string(__pcc_ctx, &__pcc_in->data.leaf.capt0)
#define _0s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.start))
#define _0e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.end))
#define _1 pcc_get_capture_string(__pcc_ctx, __pcc_in->data.leaf.capts.buf[0])
#define _1s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[0]->range.start))
#define _1e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[0]->range.end))
#define _2 pcc_get_capture_string(__pcc_ctx, __pcc_in->data.leaf.capts.buf[1])
#define _2s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[1]->range.start))
#define _2e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[1]->range.end))
    POP_SCOPE (auxil);
#undef _2e
#undef _2s
#undef _2
#undef _1e
#undef _1s
#undef _1
#undef _0e
#undef _0s
#undef _0
#undef __
#undef auxil
}

static void pcc_action_Function_0(pthrift_context_t *__pcc_ctx, pcc_thunk_t *__pcc_in, pcc_value_t *__pcc_out) {
#define auxil (__pcc_ctx->auxil)
#define __ (*__pcc_out)
#define _0 pcc_get_capture_string(__pcc_ctx, &__pcc_in->data.leaf.capt0)
#define _0s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.start))
#define _0e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.end))
#define _1 pcc_get_capture_string(__pcc_ctx, __pcc_in->data.leaf.capts.buf[0])
#define _1s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[0]->range.start))
#define _1e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[0]->range.end))
#define _2 pcc_get_capture_string(__pcc_ctx, __pcc_in->data.leaf.capts.buf[1])
#define _2s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[1]->range.start))
#define _2e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[1]->range.end))
    int r = makeThriftTag (auxil, _2, _2s, K_FUNCTION, true);
    tagEntryInfo *e = getEntryInCorkQueue (r);
    if (e)
    {
        e->extensionFields.typeRef[0] = eStrdup ("typename");
        e->extensionFields.typeRef[1] = eStrdup (_1);
    }
    PUSH_KIND (auxil, K_PARAMETER);
#undef _2e
#undef _2s
#undef _2
#undef _1e
#undef _1s
#undef _1
#undef _0e
#undef _0s
#undef _0
#undef __
#undef auxil
}

static void pcc_action_Function_1(pthrift_context_t *__pcc_ctx, pcc_thunk_t *__pcc_in, pcc_value_t *__pcc_out) {
#define auxil (__pcc_ctx->auxil)
#define __ (*__pcc_out)
#define _0 pcc_get_capture_string(__pcc_ctx, &__pcc_in->data.leaf.capt0)
#define _0s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.start))
#define _0e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.end))
#define _1 pcc_get_capture_string(__pcc_ctx, __pcc_in->data.leaf.capts.buf[0])
#define _1s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[0]->range.start))
#define _1e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[0]->range.end))
#define _2 pcc_get_capture_string(__pcc_ctx, __pcc_in->data.leaf.capts.buf[1])
#define _2s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[1]->range.start))
#define _2e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[1]->range.end))
#define _3 pcc_get_capture_string(__pcc_ctx, __pcc_in->data.leaf.capts.buf[2])
#define _3s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[2]->range.start))
#define _3e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[2]->range.end))
    int r = BASE_SCOPE (auxil);
    tagEntryInfo *e = getEntryInCorkQueue (r);
    if (e)
         e->extensionFields.signature = eStrdup (_3);
#undef _3e
#undef _3s
#undef _3
#undef _2e
#undef _2s
#undef _2
#undef _1e
#undef _1s
#undef _1
#undef _0e
#undef _0s
#undef _0
#undef __
#undef auxil
}

static void pcc_action_Function_2(pthrift_context_t *__pcc_ctx, pcc_thunk_t *__pcc_in, pcc_value_t *__pcc_out) {
#define auxil (__pcc_ctx->auxil)
#define __ (*__pcc_out)
#define _0 pcc_get_capture_string(__pcc_ctx, &__pcc_in->data.leaf.capt0)
#define _0s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.start))
#define _0e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.end))
#define _1 pcc_get_capture_string(__pcc_ctx, __pcc_in->data.leaf.capts.buf[0])
#define _1s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[0]->range.start))
#define _1e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[0]->range.end))
#define _2 pcc_get_capture_string(__pcc_ctx, __pcc_in->data.leaf.capts.buf[1])
#define _2s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[1]->range.start))
#define _2e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[1]->range.end))
#define _3 pcc_get_capture_string(__pcc_ctx, __pcc_in->data.leaf.capts.buf[2])
#define _3s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[2]->range.start))
#define _3e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[2]->range.end))
    POP_KIND (auxil, true);
#undef _3e
#undef _3s
#undef _3
#undef _2e
#undef _2s
#undef _2
#undef _1e
#undef _1s
#undef _1
#undef _0e
#undef _0s
#undef _0
#undef __
#undef auxil
}

static void pcc_action_Throws_0(pthrift_context_t *__pcc_ctx, pcc_thunk_t *__pcc_in, pcc_value_t *__pcc_out) {
#define auxil (__pcc_ctx->auxil)
#define __ (*__pcc_out)
#define _0 pcc_get_capture_string(__pcc_ctx, &__pcc_in->data.leaf.capt0)
#define _0s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.start))
#define _0e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.end))
    PUSH_KIND (auxil, K_THROWSPARAM);
#undef _0e
#undef _0s
#undef _0
#undef __
#undef auxil
}

static void pcc_action_Throws_1(pthrift_context_t *__pcc_ctx, pcc_thunk_t *__pcc_in, pcc_value_t *__pcc_out) {
#define auxil (__pcc_ctx->auxil)
#define __ (*__pcc_out)
#define _0 pcc_get_capture_string(__pcc_ctx, &__pcc_in->data.leaf.capt0)
#define _0s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.start))
#define _0e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.end))
#define _1 pcc_get_capture_string(__pcc_ctx, __pcc_in->data.leaf.capts.buf[0])
#define _1s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[0]->range.start))
#define _1e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[0]->range.end))
    int r = BASE_SCOPE (auxil);
    attachParserFieldToCorkEntry (r, ThriftFields[F_THROWS].ftype, _1);
    POP_KIND (auxil, false);
#undef _1e
#undef _1s
#undef _1
#undef _0e
#undef _0s
#undef _0
#undef __
#undef auxil
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_Grammar(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_SyntaxError(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_Include(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_Statement(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_Namespace(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_Const(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_Enum(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_EnumValue(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_TypeDef(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_Struct(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_Exception(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_Union(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_StructLike(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_FieldList(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_Field(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_FieldReq(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_Service(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_EndOfServiceError(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_Function(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_FunctionType(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_Throws(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_FieldType(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_BaseType(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_BaseTypeName(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_ContainerType(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_MapType(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_SetType(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_ListType(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_CppType(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_ConstValue(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_TypeAnnotations(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_TypeAnnotation(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_IntConstant(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_DoubleConstant(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_ConstList(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_ConstMap(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_Literal(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_Identifier(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_ListSeparator(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_Letter(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_Digit(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_SourceChar(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_Comment(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_MultiLineComment(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_MultiLineCommentNoLineTerminator(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_SingleLineComment(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule___(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule__(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_WS(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_Whitespace(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_EOL(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_EOS(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_EOF(pcc_context_t *ctx);

static pcc_thunk_chunk_t *pcc_evaluate_rule_Grammar(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "Grammar", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0000;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_Statement, &chunk->thunks, NULL)) goto L0001;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0001;
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_EOF, &chunk->thunks, NULL)) goto L0003;
        goto L0002;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_SyntaxError, &chunk->thunks, NULL)) goto L0004;
        goto L0002;
    L0004:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0002:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "Grammar", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "Grammar", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_SyntaxError(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "SyntaxError", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        int u;
        const size_t n = pcc_get_char_as_utf32(ctx, &u);
        if (n == 0) goto L0000;
        ctx->cur += n;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "SyntaxError", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "SyntaxError", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_Include(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "Include", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    pcc_capture_table__resize(ctx->auxil, &chunk->capts, 2);
    {
        const size_t p = ctx->cur;
        size_t q;
        {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (
                pcc_refill_buffer(ctx, 7) < 7 ||
                (ctx->buffer.buf + ctx->cur)[0] != 'i' ||
                (ctx->buffer.buf + ctx->cur)[1] != 'n' ||
                (ctx->buffer.buf + ctx->cur)[2] != 'c' ||
                (ctx->buffer.buf + ctx->cur)[3] != 'l' ||
                (ctx->buffer.buf + ctx->cur)[4] != 'u' ||
                (ctx->buffer.buf + ctx->cur)[5] != 'd' ||
                (ctx->buffer.buf + ctx->cur)[6] != 'e'
            ) goto L0002;
            ctx->cur += 7;
            goto L0001;
        L0002:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            if (
                pcc_refill_buffer(ctx, 11) < 11 ||
                (ctx->buffer.buf + ctx->cur)[0] != 'c' ||
                (ctx->buffer.buf + ctx->cur)[1] != 'p' ||
                (ctx->buffer.buf + ctx->cur)[2] != 'p' ||
                (ctx->buffer.buf + ctx->cur)[3] != '_' ||
                (ctx->buffer.buf + ctx->cur)[4] != 'i' ||
                (ctx->buffer.buf + ctx->cur)[5] != 'n' ||
                (ctx->buffer.buf + ctx->cur)[6] != 'c' ||
                (ctx->buffer.buf + ctx->cur)[7] != 'l' ||
                (ctx->buffer.buf + ctx->cur)[8] != 'u' ||
                (ctx->buffer.buf + ctx->cur)[9] != 'd' ||
                (ctx->buffer.buf + ctx->cur)[10] != 'e'
            ) goto L0003;
            ctx->cur += 11;
            goto L0001;
        L0003:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            goto L0000;
        L0001:;
        }
        q = ctx->cur;
        chunk->capts.buf[0].range.start = p;
        chunk->capts.buf[0].range.end = q;
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0000;
    {
        const size_t p = ctx->cur;
        size_t q;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_Literal, &chunk->thunks, NULL)) goto L0000;
        q = ctx->cur;
        chunk->capts.buf[1].range.start = p;
        chunk->capts.buf[1].range.end = q;
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_EOS, &chunk->thunks, NULL)) goto L0000;
    {
        pcc_thunk_t *const thunk = pcc_thunk__create_leaf(ctx->auxil, pcc_action_Include_0, 0, 2);
        thunk->data.leaf.capts.buf[0] = &(chunk->capts.buf[0]);
        thunk->data.leaf.capts.buf[1] = &(chunk->capts.buf[1]);
        thunk->data.leaf.capt0.range.start = chunk->pos;
        thunk->data.leaf.capt0.range.end = ctx->cur;
        pcc_thunk_array__add(ctx->auxil, &chunk->thunks, thunk);
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "Include", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "Include", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_Statement(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "Statement", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_Include, &chunk->thunks, NULL)) goto L0002;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_Namespace, &chunk->thunks, NULL)) goto L0003;
        goto L0001;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_Const, &chunk->thunks, NULL)) goto L0004;
        goto L0001;
    L0004:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_Enum, &chunk->thunks, NULL)) goto L0005;
        goto L0001;
    L0005:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_TypeDef, &chunk->thunks, NULL)) goto L0006;
        goto L0001;
    L0006:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_Struct, &chunk->thunks, NULL)) goto L0007;
        goto L0001;
    L0007:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_Exception, &chunk->thunks, NULL)) goto L0008;
        goto L0001;
    L0008:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_Union, &chunk->thunks, NULL)) goto L0009;
        goto L0001;
    L0009:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_Service, &chunk->thunks, NULL)) goto L0010;
        goto L0001;
    L0010:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "Statement", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "Statement", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_Namespace(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "Namespace", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    pcc_capture_table__resize(ctx->auxil, &chunk->capts, 2);
    if (
        pcc_refill_buffer(ctx, 9) < 9 ||
        (ctx->buffer.buf + ctx->cur)[0] != 'n' ||
        (ctx->buffer.buf + ctx->cur)[1] != 'a' ||
        (ctx->buffer.buf + ctx->cur)[2] != 'm' ||
        (ctx->buffer.buf + ctx->cur)[3] != 'e' ||
        (ctx->buffer.buf + ctx->cur)[4] != 's' ||
        (ctx->buffer.buf + ctx->cur)[5] != 'p' ||
        (ctx->buffer.buf + ctx->cur)[6] != 'a' ||
        (ctx->buffer.buf + ctx->cur)[7] != 'c' ||
        (ctx->buffer.buf + ctx->cur)[8] != 'e'
    ) goto L0000;
    ctx->cur += 9;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0000;
    {
        const size_t p = ctx->cur;
        size_t q;
        {
            const size_t p0 = ctx->cur;
            const size_t n0 = chunk->thunks.len;
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                {
                    int u;
                    const size_t n = pcc_get_char_as_utf32(ctx, &u);
                    if (n == 0) goto L0001;
                    if (!(
                        u == 0x00002d ||
                        u == 0x00002a ||
                        (u >= 0x000061 && u <= 0x00007a) ||
                        u == 0x00002e
                    )) goto L0001;
                    ctx->cur += n;
                }
                if (ctx->cur == p) break;
                continue;
            L0001:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
            if (i < 1) {
                ctx->cur = p0;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n0);
                goto L0000;
            }
        }
        q = ctx->cur;
        chunk->capts.buf[0].range.start = p;
        chunk->capts.buf[0].range.end = q;
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0000;
    {
        const size_t p = ctx->cur;
        size_t q;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_Identifier, &chunk->thunks, NULL)) goto L0000;
        q = ctx->cur;
        chunk->capts.buf[1].range.start = p;
        chunk->capts.buf[1].range.end = q;
    }
    {
        pcc_thunk_t *const thunk = pcc_thunk__create_leaf(ctx->auxil, pcc_action_Namespace_0, 0, 2);
        thunk->data.leaf.capts.buf[0] = &(chunk->capts.buf[0]);
        thunk->data.leaf.capts.buf[1] = &(chunk->capts.buf[1]);
        thunk->data.leaf.capt0.range.start = chunk->pos;
        thunk->data.leaf.capt0.range.end = ctx->cur;
        pcc_thunk_array__add(ctx->auxil, &chunk->thunks, thunk);
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_EOS, &chunk->thunks, NULL)) goto L0000;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "Namespace", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "Namespace", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_Const(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "Const", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    pcc_capture_table__resize(ctx->auxil, &chunk->capts, 2);
    if (
        pcc_refill_buffer(ctx, 5) < 5 ||
        (ctx->buffer.buf + ctx->cur)[0] != 'c' ||
        (ctx->buffer.buf + ctx->cur)[1] != 'o' ||
        (ctx->buffer.buf + ctx->cur)[2] != 'n' ||
        (ctx->buffer.buf + ctx->cur)[3] != 's' ||
        (ctx->buffer.buf + ctx->cur)[4] != 't'
    ) goto L0000;
    ctx->cur += 5;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0000;
    {
        const size_t p = ctx->cur;
        size_t q;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_FieldType, &chunk->thunks, NULL)) goto L0000;
        q = ctx->cur;
        chunk->capts.buf[0].range.start = p;
        chunk->capts.buf[0].range.end = q;
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0000;
    {
        const size_t p = ctx->cur;
        size_t q;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_Identifier, &chunk->thunks, NULL)) goto L0000;
        q = ctx->cur;
        chunk->capts.buf[1].range.start = p;
        chunk->capts.buf[1].range.end = q;
    }
    {
        pcc_thunk_t *const thunk = pcc_thunk__create_leaf(ctx->auxil, pcc_action_Const_0, 0, 2);
        thunk->data.leaf.capts.buf[0] = &(chunk->capts.buf[0]);
        thunk->data.leaf.capts.buf[1] = &(chunk->capts.buf[1]);
        thunk->data.leaf.capt0.range.start = chunk->pos;
        thunk->data.leaf.capt0.range.end = ctx->cur;
        pcc_thunk_array__add(ctx->auxil, &chunk->thunks, thunk);
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0000;
    if (
        pcc_refill_buffer(ctx, 1) < 1 ||
        ctx->buffer.buf[ctx->cur] != '='
    ) goto L0000;
    ctx->cur++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0000;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_ConstValue, &chunk->thunks, NULL)) goto L0000;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0000;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_ListSeparator, &chunk->thunks, NULL)) goto L0001;
        goto L0002;
    L0001:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0002:;
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_EOS, &chunk->thunks, NULL)) goto L0000;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "Const", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "Const", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_Enum(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "Enum", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    pcc_capture_table__resize(ctx->auxil, &chunk->capts, 1);
    if (
        pcc_refill_buffer(ctx, 4) < 4 ||
        (ctx->buffer.buf + ctx->cur)[0] != 'e' ||
        (ctx->buffer.buf + ctx->cur)[1] != 'n' ||
        (ctx->buffer.buf + ctx->cur)[2] != 'u' ||
        (ctx->buffer.buf + ctx->cur)[3] != 'm'
    ) goto L0000;
    ctx->cur += 4;
    {
        pcc_thunk_t *const thunk = pcc_thunk__create_leaf(ctx->auxil, pcc_action_Enum_0, 0, 1);
        thunk->data.leaf.capt0.range.start = chunk->pos;
        thunk->data.leaf.capt0.range.end = ctx->cur;
        pcc_thunk_array__add(ctx->auxil, &chunk->thunks, thunk);
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0000;
    {
        const size_t p = ctx->cur;
        size_t q;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_Identifier, &chunk->thunks, NULL)) goto L0000;
        q = ctx->cur;
        chunk->capts.buf[0].range.start = p;
        chunk->capts.buf[0].range.end = q;
    }
    {
        pcc_thunk_t *const thunk = pcc_thunk__create_leaf(ctx->auxil, pcc_action_Enum_1, 0, 1);
        thunk->data.leaf.capts.buf[0] = &(chunk->capts.buf[0]);
        thunk->data.leaf.capt0.range.start = chunk->pos;
        thunk->data.leaf.capt0.range.end = ctx->cur;
        pcc_thunk_array__add(ctx->auxil, &chunk->thunks, thunk);
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0000;
    if (
        pcc_refill_buffer(ctx, 1) < 1 ||
        ctx->buffer.buf[ctx->cur] != '{'
    ) goto L0000;
    ctx->cur++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0000;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_EnumValue, &chunk->thunks, NULL)) goto L0001;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0001;
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    if (
        pcc_refill_buffer(ctx, 1) < 1 ||
        ctx->buffer.buf[ctx->cur] != '}'
    ) goto L0000;
    ctx->cur++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0000;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_TypeAnnotations, &chunk->thunks, NULL)) goto L0002;
        goto L0003;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0003:;
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_EOS, &chunk->thunks, NULL)) goto L0000;
    {
        pcc_thunk_t *const thunk = pcc_thunk__create_leaf(ctx->auxil, pcc_action_Enum_2, 0, 1);
        thunk->data.leaf.capts.buf[0] = &(chunk->capts.buf[0]);
        thunk->data.leaf.capt0.range.start = chunk->pos;
        thunk->data.leaf.capt0.range.end = ctx->cur;
        pcc_thunk_array__add(ctx->auxil, &chunk->thunks, thunk);
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "Enum", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "Enum", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_EnumValue(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "EnumValue", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    pcc_capture_table__resize(ctx->auxil, &chunk->capts, 1);
    {
        const size_t p = ctx->cur;
        size_t q;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_Identifier, &chunk->thunks, NULL)) goto L0000;
        q = ctx->cur;
        chunk->capts.buf[0].range.start = p;
        chunk->capts.buf[0].range.end = q;
    }
    {
        pcc_thunk_t *const thunk = pcc_thunk__create_leaf(ctx->auxil, pcc_action_EnumValue_0, 0, 1);
        thunk->data.leaf.capts.buf[0] = &(chunk->capts.buf[0]);
        thunk->data.leaf.capt0.range.start = chunk->pos;
        thunk->data.leaf.capt0.range.end = ctx->cur;
        pcc_thunk_array__add(ctx->auxil, &chunk->thunks, thunk);
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0000;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (
            pcc_refill_buffer(ctx, 1) < 1 ||
            ctx->buffer.buf[ctx->cur] != '='
        ) goto L0001;
        ctx->cur++;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0001;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_IntConstant, &chunk->thunks, NULL)) goto L0001;
        goto L0002;
    L0001:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0002:;
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0000;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_TypeAnnotations, &chunk->thunks, NULL)) goto L0003;
        goto L0004;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0004:;
    }
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_ListSeparator, &chunk->thunks, NULL)) goto L0005;
        goto L0006;
    L0005:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0006:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "EnumValue", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "EnumValue", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_TypeDef(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "TypeDef", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    pcc_capture_table__resize(ctx->auxil, &chunk->capts, 2);
    if (
        pcc_refill_buffer(ctx, 7) < 7 ||
        (ctx->buffer.buf + ctx->cur)[0] != 't' ||
        (ctx->buffer.buf + ctx->cur)[1] != 'y' ||
        (ctx->buffer.buf + ctx->cur)[2] != 'p' ||
        (ctx->buffer.buf + ctx->cur)[3] != 'e' ||
        (ctx->buffer.buf + ctx->cur)[4] != 'd' ||
        (ctx->buffer.buf + ctx->cur)[5] != 'e' ||
        (ctx->buffer.buf + ctx->cur)[6] != 'f'
    ) goto L0000;
    ctx->cur += 7;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0000;
    {
        const size_t p = ctx->cur;
        size_t q;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_FieldType, &chunk->thunks, NULL)) goto L0000;
        q = ctx->cur;
        chunk->capts.buf[0].range.start = p;
        chunk->capts.buf[0].range.end = q;
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0000;
    {
        const size_t p = ctx->cur;
        size_t q;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_Identifier, &chunk->thunks, NULL)) goto L0000;
        q = ctx->cur;
        chunk->capts.buf[1].range.start = p;
        chunk->capts.buf[1].range.end = q;
    }
    {
        pcc_thunk_t *const thunk = pcc_thunk__create_leaf(ctx->auxil, pcc_action_TypeDef_0, 0, 2);
        thunk->data.leaf.capts.buf[0] = &(chunk->capts.buf[0]);
        thunk->data.leaf.capts.buf[1] = &(chunk->capts.buf[1]);
        thunk->data.leaf.capt0.range.start = chunk->pos;
        thunk->data.leaf.capt0.range.end = ctx->cur;
        pcc_thunk_array__add(ctx->auxil, &chunk->thunks, thunk);
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0000;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_TypeAnnotations, &chunk->thunks, NULL)) goto L0001;
        goto L0002;
    L0001:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0002:;
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_EOS, &chunk->thunks, NULL)) goto L0000;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "TypeDef", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "TypeDef", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_Struct(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "Struct", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 6) < 6 ||
        (ctx->buffer.buf + ctx->cur)[0] != 's' ||
        (ctx->buffer.buf + ctx->cur)[1] != 't' ||
        (ctx->buffer.buf + ctx->cur)[2] != 'r' ||
        (ctx->buffer.buf + ctx->cur)[3] != 'u' ||
        (ctx->buffer.buf + ctx->cur)[4] != 'c' ||
        (ctx->buffer.buf + ctx->cur)[5] != 't'
    ) goto L0000;
    ctx->cur += 6;
    {
        pcc_thunk_t *const thunk = pcc_thunk__create_leaf(ctx->auxil, pcc_action_Struct_0, 0, 0);
        thunk->data.leaf.capt0.range.start = chunk->pos;
        thunk->data.leaf.capt0.range.end = ctx->cur;
        pcc_thunk_array__add(ctx->auxil, &chunk->thunks, thunk);
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0000;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_StructLike, &chunk->thunks, NULL)) goto L0000;
    {
        pcc_thunk_t *const thunk = pcc_thunk__create_leaf(ctx->auxil, pcc_action_Struct_1, 0, 0);
        thunk->data.leaf.capt0.range.start = chunk->pos;
        thunk->data.leaf.capt0.range.end = ctx->cur;
        pcc_thunk_array__add(ctx->auxil, &chunk->thunks, thunk);
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "Struct", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "Struct", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_Exception(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "Exception", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 9) < 9 ||
        (ctx->buffer.buf + ctx->cur)[0] != 'e' ||
        (ctx->buffer.buf + ctx->cur)[1] != 'x' ||
        (ctx->buffer.buf + ctx->cur)[2] != 'c' ||
        (ctx->buffer.buf + ctx->cur)[3] != 'e' ||
        (ctx->buffer.buf + ctx->cur)[4] != 'p' ||
        (ctx->buffer.buf + ctx->cur)[5] != 't' ||
        (ctx->buffer.buf + ctx->cur)[6] != 'i' ||
        (ctx->buffer.buf + ctx->cur)[7] != 'o' ||
        (ctx->buffer.buf + ctx->cur)[8] != 'n'
    ) goto L0000;
    ctx->cur += 9;
    {
        pcc_thunk_t *const thunk = pcc_thunk__create_leaf(ctx->auxil, pcc_action_Exception_0, 0, 0);
        thunk->data.leaf.capt0.range.start = chunk->pos;
        thunk->data.leaf.capt0.range.end = ctx->cur;
        pcc_thunk_array__add(ctx->auxil, &chunk->thunks, thunk);
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0000;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_StructLike, &chunk->thunks, NULL)) goto L0000;
    {
        pcc_thunk_t *const thunk = pcc_thunk__create_leaf(ctx->auxil, pcc_action_Exception_1, 0, 0);
        thunk->data.leaf.capt0.range.start = chunk->pos;
        thunk->data.leaf.capt0.range.end = ctx->cur;
        pcc_thunk_array__add(ctx->auxil, &chunk->thunks, thunk);
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "Exception", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "Exception", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_Union(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "Union", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 5) < 5 ||
        (ctx->buffer.buf + ctx->cur)[0] != 'u' ||
        (ctx->buffer.buf + ctx->cur)[1] != 'n' ||
        (ctx->buffer.buf + ctx->cur)[2] != 'i' ||
        (ctx->buffer.buf + ctx->cur)[3] != 'o' ||
        (ctx->buffer.buf + ctx->cur)[4] != 'n'
    ) goto L0000;
    ctx->cur += 5;
    {
        pcc_thunk_t *const thunk = pcc_thunk__create_leaf(ctx->auxil, pcc_action_Union_0, 0, 0);
        thunk->data.leaf.capt0.range.start = chunk->pos;
        thunk->data.leaf.capt0.range.end = ctx->cur;
        pcc_thunk_array__add(ctx->auxil, &chunk->thunks, thunk);
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0000;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_StructLike, &chunk->thunks, NULL)) goto L0000;
    {
        pcc_thunk_t *const thunk = pcc_thunk__create_leaf(ctx->auxil, pcc_action_Union_1, 0, 0);
        thunk->data.leaf.capt0.range.start = chunk->pos;
        thunk->data.leaf.capt0.range.end = ctx->cur;
        pcc_thunk_array__add(ctx->auxil, &chunk->thunks, thunk);
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "Union", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "Union", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_StructLike(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "StructLike", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    pcc_capture_table__resize(ctx->auxil, &chunk->capts, 1);
    {
        const size_t p = ctx->cur;
        size_t q;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_Identifier, &chunk->thunks, NULL)) goto L0000;
        q = ctx->cur;
        chunk->capts.buf[0].range.start = p;
        chunk->capts.buf[0].range.end = q;
    }
    {
        pcc_thunk_t *const thunk = pcc_thunk__create_leaf(ctx->auxil, pcc_action_StructLike_0, 0, 1);
        thunk->data.leaf.capts.buf[0] = &(chunk->capts.buf[0]);
        thunk->data.leaf.capt0.range.start = chunk->pos;
        thunk->data.leaf.capt0.range.end = ctx->cur;
        pcc_thunk_array__add(ctx->auxil, &chunk->thunks, thunk);
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0000;
    if (
        pcc_refill_buffer(ctx, 1) < 1 ||
        ctx->buffer.buf[ctx->cur] != '{'
    ) goto L0000;
    ctx->cur++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0000;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_FieldList, &chunk->thunks, NULL)) goto L0000;
    if (
        pcc_refill_buffer(ctx, 1) < 1 ||
        ctx->buffer.buf[ctx->cur] != '}'
    ) goto L0000;
    ctx->cur++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0000;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_TypeAnnotations, &chunk->thunks, NULL)) goto L0001;
        goto L0002;
    L0001:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0002:;
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_EOS, &chunk->thunks, NULL)) goto L0000;
    {
        pcc_thunk_t *const thunk = pcc_thunk__create_leaf(ctx->auxil, pcc_action_StructLike_1, 0, 1);
        thunk->data.leaf.capts.buf[0] = &(chunk->capts.buf[0]);
        thunk->data.leaf.capt0.range.start = chunk->pos;
        thunk->data.leaf.capt0.range.end = ctx->cur;
        pcc_thunk_array__add(ctx->auxil, &chunk->thunks, thunk);
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "StructLike", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "StructLike", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_FieldList(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "FieldList", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_Field, &chunk->thunks, NULL)) goto L0001;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0001;
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "FieldList", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_Field(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "Field", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    pcc_capture_table__resize(ctx->auxil, &chunk->capts, 2);
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_IntConstant, &chunk->thunks, NULL)) goto L0000;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0000;
    if (
        pcc_refill_buffer(ctx, 1) < 1 ||
        ctx->buffer.buf[ctx->cur] != ':'
    ) goto L0000;
    ctx->cur++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0000;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_FieldReq, &chunk->thunks, NULL)) goto L0001;
        goto L0002;
    L0001:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0002:;
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0000;
    {
        const size_t p = ctx->cur;
        size_t q;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_FieldType, &chunk->thunks, NULL)) goto L0000;
        q = ctx->cur;
        chunk->capts.buf[0].range.start = p;
        chunk->capts.buf[0].range.end = q;
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0000;
    {
        const size_t p = ctx->cur;
        size_t q;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_Identifier, &chunk->thunks, NULL)) goto L0000;
        q = ctx->cur;
        chunk->capts.buf[1].range.start = p;
        chunk->capts.buf[1].range.end = q;
    }
    {
        pcc_thunk_t *const thunk = pcc_thunk__create_leaf(ctx->auxil, pcc_action_Field_0, 0, 2);
        thunk->data.leaf.capts.buf[0] = &(chunk->capts.buf[0]);
        thunk->data.leaf.capts.buf[1] = &(chunk->capts.buf[1]);
        thunk->data.leaf.capt0.range.start = chunk->pos;
        thunk->data.leaf.capt0.range.end = ctx->cur;
        pcc_thunk_array__add(ctx->auxil, &chunk->thunks, thunk);
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0000;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (
            pcc_refill_buffer(ctx, 1) < 1 ||
            ctx->buffer.buf[ctx->cur] != '='
        ) goto L0003;
        ctx->cur++;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0003;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_ConstValue, &chunk->thunks, NULL)) goto L0003;
        goto L0004;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0004:;
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0000;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_TypeAnnotations, &chunk->thunks, NULL)) goto L0005;
        goto L0006;
    L0005:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0006:;
    }
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_ListSeparator, &chunk->thunks, NULL)) goto L0007;
        goto L0008;
    L0007:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0008:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "Field", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "Field", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_FieldReq(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "FieldReq", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (
            pcc_refill_buffer(ctx, 8) < 8 ||
            (ctx->buffer.buf + ctx->cur)[0] != 'r' ||
            (ctx->buffer.buf + ctx->cur)[1] != 'e' ||
            (ctx->buffer.buf + ctx->cur)[2] != 'q' ||
            (ctx->buffer.buf + ctx->cur)[3] != 'u' ||
            (ctx->buffer.buf + ctx->cur)[4] != 'i' ||
            (ctx->buffer.buf + ctx->cur)[5] != 'r' ||
            (ctx->buffer.buf + ctx->cur)[6] != 'e' ||
            (ctx->buffer.buf + ctx->cur)[7] != 'd'
        ) goto L0002;
        ctx->cur += 8;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (
            pcc_refill_buffer(ctx, 8) < 8 ||
            (ctx->buffer.buf + ctx->cur)[0] != 'o' ||
            (ctx->buffer.buf + ctx->cur)[1] != 'p' ||
            (ctx->buffer.buf + ctx->cur)[2] != 't' ||
            (ctx->buffer.buf + ctx->cur)[3] != 'i' ||
            (ctx->buffer.buf + ctx->cur)[4] != 'o' ||
            (ctx->buffer.buf + ctx->cur)[5] != 'n' ||
            (ctx->buffer.buf + ctx->cur)[6] != 'a' ||
            (ctx->buffer.buf + ctx->cur)[7] != 'l'
        ) goto L0003;
        ctx->cur += 8;
        goto L0001;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "FieldReq", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "FieldReq", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_Service(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "Service", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    pcc_capture_table__resize(ctx->auxil, &chunk->capts, 2);
    if (
        pcc_refill_buffer(ctx, 7) < 7 ||
        (ctx->buffer.buf + ctx->cur)[0] != 's' ||
        (ctx->buffer.buf + ctx->cur)[1] != 'e' ||
        (ctx->buffer.buf + ctx->cur)[2] != 'r' ||
        (ctx->buffer.buf + ctx->cur)[3] != 'v' ||
        (ctx->buffer.buf + ctx->cur)[4] != 'i' ||
        (ctx->buffer.buf + ctx->cur)[5] != 'c' ||
        (ctx->buffer.buf + ctx->cur)[6] != 'e'
    ) goto L0000;
    ctx->cur += 7;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0000;
    {
        const size_t p = ctx->cur;
        size_t q;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_Identifier, &chunk->thunks, NULL)) goto L0000;
        q = ctx->cur;
        chunk->capts.buf[0].range.start = p;
        chunk->capts.buf[0].range.end = q;
    }
    {
        pcc_thunk_t *const thunk = pcc_thunk__create_leaf(ctx->auxil, pcc_action_Service_0, 0, 2);
        thunk->data.leaf.capts.buf[0] = &(chunk->capts.buf[0]);
        thunk->data.leaf.capt0.range.start = chunk->pos;
        thunk->data.leaf.capt0.range.end = ctx->cur;
        pcc_thunk_array__add(ctx->auxil, &chunk->thunks, thunk);
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0000;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (
            pcc_refill_buffer(ctx, 7) < 7 ||
            (ctx->buffer.buf + ctx->cur)[0] != 'e' ||
            (ctx->buffer.buf + ctx->cur)[1] != 'x' ||
            (ctx->buffer.buf + ctx->cur)[2] != 't' ||
            (ctx->buffer.buf + ctx->cur)[3] != 'e' ||
            (ctx->buffer.buf + ctx->cur)[4] != 'n' ||
            (ctx->buffer.buf + ctx->cur)[5] != 'd' ||
            (ctx->buffer.buf + ctx->cur)[6] != 's'
        ) goto L0001;
        ctx->cur += 7;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0001;
        {
            const size_t p = ctx->cur;
            size_t q;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_Identifier, &chunk->thunks, NULL)) goto L0001;
            q = ctx->cur;
            chunk->capts.buf[1].range.start = p;
            chunk->capts.buf[1].range.end = q;
        }
        {
            pcc_thunk_t *const thunk = pcc_thunk__create_leaf(ctx->auxil, pcc_action_Service_1, 0, 2);
            thunk->data.leaf.capts.buf[0] = &(chunk->capts.buf[0]);
            thunk->data.leaf.capts.buf[1] = &(chunk->capts.buf[1]);
            thunk->data.leaf.capt0.range.start = chunk->pos;
            thunk->data.leaf.capt0.range.end = ctx->cur;
            pcc_thunk_array__add(ctx->auxil, &chunk->thunks, thunk);
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0001;
        goto L0002;
    L0001:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0002:;
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0000;
    if (
        pcc_refill_buffer(ctx, 1) < 1 ||
        ctx->buffer.buf[ctx->cur] != '{'
    ) goto L0000;
    ctx->cur++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0000;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_Function, &chunk->thunks, NULL)) goto L0003;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0003;
            if (ctx->cur == p) break;
            continue;
        L0003:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (
            pcc_refill_buffer(ctx, 1) < 1 ||
            ctx->buffer.buf[ctx->cur] != '}'
        ) goto L0005;
        ctx->cur++;
        goto L0004;
    L0005:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_EndOfServiceError, &chunk->thunks, NULL)) goto L0006;
        goto L0004;
    L0006:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0004:;
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0000;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_TypeAnnotations, &chunk->thunks, NULL)) goto L0007;
        goto L0008;
    L0007:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0008:;
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_EOS, &chunk->thunks, NULL)) goto L0000;
    {
        pcc_thunk_t *const thunk = pcc_thunk__create_leaf(ctx->auxil, pcc_action_Service_2, 0, 2);
        thunk->data.leaf.capts.buf[0] = &(chunk->capts.buf[0]);
        thunk->data.leaf.capts.buf[1] = &(chunk->capts.buf[1]);
        thunk->data.leaf.capt0.range.start = chunk->pos;
        thunk->data.leaf.capt0.range.end = ctx->cur;
        pcc_thunk_array__add(ctx->auxil, &chunk->thunks, thunk);
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "Service", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "Service", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_EndOfServiceError(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "EndOfServiceError", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        int u;
        const size_t n = pcc_get_char_as_utf32(ctx, &u);
        if (n == 0) goto L0000;
        ctx->cur += n;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "EndOfServiceError", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "EndOfServiceError", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_Function(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "Function", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    pcc_capture_table__resize(ctx->auxil, &chunk->capts, 3);
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (
            pcc_refill_buffer(ctx, 6) < 6 ||
            (ctx->buffer.buf + ctx->cur)[0] != 'o' ||
            (ctx->buffer.buf + ctx->cur)[1] != 'n' ||
            (ctx->buffer.buf + ctx->cur)[2] != 'e' ||
            (ctx->buffer.buf + ctx->cur)[3] != 'w' ||
            (ctx->buffer.buf + ctx->cur)[4] != 'a' ||
            (ctx->buffer.buf + ctx->cur)[5] != 'y'
        ) goto L0001;
        ctx->cur += 6;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0001;
        goto L0002;
    L0001:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0002:;
    }
    {
        const size_t p = ctx->cur;
        size_t q;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_FunctionType, &chunk->thunks, NULL)) goto L0000;
        q = ctx->cur;
        chunk->capts.buf[0].range.start = p;
        chunk->capts.buf[0].range.end = q;
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0000;
    {
        const size_t p = ctx->cur;
        size_t q;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_Identifier, &chunk->thunks, NULL)) goto L0000;
        q = ctx->cur;
        chunk->capts.buf[1].range.start = p;
        chunk->capts.buf[1].range.end = q;
    }
    {
        pcc_thunk_t *const thunk = pcc_thunk__create_leaf(ctx->auxil, pcc_action_Function_0, 0, 3);
        thunk->data.leaf.capts.buf[0] = &(chunk->capts.buf[0]);
        thunk->data.leaf.capts.buf[1] = &(chunk->capts.buf[1]);
        thunk->data.leaf.capt0.range.start = chunk->pos;
        thunk->data.leaf.capt0.range.end = ctx->cur;
        pcc_thunk_array__add(ctx->auxil, &chunk->thunks, thunk);
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0000;
    {
        const size_t p = ctx->cur;
        size_t q;
        if (
            pcc_refill_buffer(ctx, 1) < 1 ||
            ctx->buffer.buf[ctx->cur] != '('
        ) goto L0000;
        ctx->cur++;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0000;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_FieldList, &chunk->thunks, NULL)) goto L0000;
        if (
            pcc_refill_buffer(ctx, 1) < 1 ||
            ctx->buffer.buf[ctx->cur] != ')'
        ) goto L0000;
        ctx->cur++;
        q = ctx->cur;
        chunk->capts.buf[2].range.start = p;
        chunk->capts.buf[2].range.end = q;
    }
    {
        pcc_thunk_t *const thunk = pcc_thunk__create_leaf(ctx->auxil, pcc_action_Function_1, 0, 3);
        thunk->data.leaf.capts.buf[0] = &(chunk->capts.buf[0]);
        thunk->data.leaf.capts.buf[1] = &(chunk->capts.buf[1]);
        thunk->data.leaf.capts.buf[2] = &(chunk->capts.buf[2]);
        thunk->data.leaf.capt0.range.start = chunk->pos;
        thunk->data.leaf.capt0.range.end = ctx->cur;
        pcc_thunk_array__add(ctx->auxil, &chunk->thunks, thunk);
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0000;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_Throws, &chunk->thunks, NULL)) goto L0003;
        goto L0004;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0004:;
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0000;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_TypeAnnotations, &chunk->thunks, NULL)) goto L0005;
        goto L0006;
    L0005:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0006:;
    }
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_ListSeparator, &chunk->thunks, NULL)) goto L0007;
        goto L0008;
    L0007:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0008:;
    }
    {
        pcc_thunk_t *const thunk = pcc_thunk__create_leaf(ctx->auxil, pcc_action_Function_2, 0, 3);
        thunk->data.leaf.capts.buf[0] = &(chunk->capts.buf[0]);
        thunk->data.leaf.capts.buf[1] = &(chunk->capts.buf[1]);
        thunk->data.leaf.capts.buf[2] = &(chunk->capts.buf[2]);
        thunk->data.leaf.capt0.range.start = chunk->pos;
        thunk->data.leaf.capt0.range.end = ctx->cur;
        pcc_thunk_array__add(ctx->auxil, &chunk->thunks, thunk);
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "Function", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "Function", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_FunctionType(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "FunctionType", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (
            pcc_refill_buffer(ctx, 4) < 4 ||
            (ctx->buffer.buf + ctx->cur)[0] != 'v' ||
            (ctx->buffer.buf + ctx->cur)[1] != 'o' ||
            (ctx->buffer.buf + ctx->cur)[2] != 'i' ||
            (ctx->buffer.buf + ctx->cur)[3] != 'd'
        ) goto L0002;
        ctx->cur += 4;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_FieldType, &chunk->thunks, NULL)) goto L0003;
        goto L0001;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "FunctionType", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "FunctionType", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_Throws(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "Throws", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    pcc_capture_table__resize(ctx->auxil, &chunk->capts, 1);
    if (
        pcc_refill_buffer(ctx, 6) < 6 ||
        (ctx->buffer.buf + ctx->cur)[0] != 't' ||
        (ctx->buffer.buf + ctx->cur)[1] != 'h' ||
        (ctx->buffer.buf + ctx->cur)[2] != 'r' ||
        (ctx->buffer.buf + ctx->cur)[3] != 'o' ||
        (ctx->buffer.buf + ctx->cur)[4] != 'w' ||
        (ctx->buffer.buf + ctx->cur)[5] != 's'
    ) goto L0000;
    ctx->cur += 6;
    {
        pcc_thunk_t *const thunk = pcc_thunk__create_leaf(ctx->auxil, pcc_action_Throws_0, 0, 1);
        thunk->data.leaf.capt0.range.start = chunk->pos;
        thunk->data.leaf.capt0.range.end = ctx->cur;
        pcc_thunk_array__add(ctx->auxil, &chunk->thunks, thunk);
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0000;
    {
        const size_t p = ctx->cur;
        size_t q;
        if (
            pcc_refill_buffer(ctx, 1) < 1 ||
            ctx->buffer.buf[ctx->cur] != '('
        ) goto L0000;
        ctx->cur++;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0000;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_FieldList, &chunk->thunks, NULL)) goto L0000;
        if (
            pcc_refill_buffer(ctx, 1) < 1 ||
            ctx->buffer.buf[ctx->cur] != ')'
        ) goto L0000;
        ctx->cur++;
        q = ctx->cur;
        chunk->capts.buf[0].range.start = p;
        chunk->capts.buf[0].range.end = q;
    }
    {
        pcc_thunk_t *const thunk = pcc_thunk__create_leaf(ctx->auxil, pcc_action_Throws_1, 0, 1);
        thunk->data.leaf.capts.buf[0] = &(chunk->capts.buf[0]);
        thunk->data.leaf.capt0.range.start = chunk->pos;
        thunk->data.leaf.capt0.range.end = ctx->cur;
        pcc_thunk_array__add(ctx->auxil, &chunk->thunks, thunk);
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "Throws", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "Throws", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_FieldType(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "FieldType", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_BaseType, &chunk->thunks, NULL)) goto L0002;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_ContainerType, &chunk->thunks, NULL)) goto L0003;
        goto L0001;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_Identifier, &chunk->thunks, NULL)) goto L0004;
        goto L0001;
    L0004:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "FieldType", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "FieldType", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_BaseType(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "BaseType", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_BaseTypeName, &chunk->thunks, NULL)) goto L0000;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0000;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_TypeAnnotations, &chunk->thunks, NULL)) goto L0001;
        goto L0002;
    L0001:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0002:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "BaseType", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "BaseType", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_BaseTypeName(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "BaseTypeName", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (
            pcc_refill_buffer(ctx, 4) < 4 ||
            (ctx->buffer.buf + ctx->cur)[0] != 'b' ||
            (ctx->buffer.buf + ctx->cur)[1] != 'o' ||
            (ctx->buffer.buf + ctx->cur)[2] != 'o' ||
            (ctx->buffer.buf + ctx->cur)[3] != 'l'
        ) goto L0002;
        ctx->cur += 4;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (
            pcc_refill_buffer(ctx, 4) < 4 ||
            (ctx->buffer.buf + ctx->cur)[0] != 'b' ||
            (ctx->buffer.buf + ctx->cur)[1] != 'y' ||
            (ctx->buffer.buf + ctx->cur)[2] != 't' ||
            (ctx->buffer.buf + ctx->cur)[3] != 'e'
        ) goto L0003;
        ctx->cur += 4;
        goto L0001;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (
            pcc_refill_buffer(ctx, 3) < 3 ||
            (ctx->buffer.buf + ctx->cur)[0] != 'i' ||
            (ctx->buffer.buf + ctx->cur)[1] != '1' ||
            (ctx->buffer.buf + ctx->cur)[2] != '6'
        ) goto L0004;
        ctx->cur += 3;
        goto L0001;
    L0004:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (
            pcc_refill_buffer(ctx, 3) < 3 ||
            (ctx->buffer.buf + ctx->cur)[0] != 'i' ||
            (ctx->buffer.buf + ctx->cur)[1] != '3' ||
            (ctx->buffer.buf + ctx->cur)[2] != '2'
        ) goto L0005;
        ctx->cur += 3;
        goto L0001;
    L0005:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (
            pcc_refill_buffer(ctx, 3) < 3 ||
            (ctx->buffer.buf + ctx->cur)[0] != 'i' ||
            (ctx->buffer.buf + ctx->cur)[1] != '6' ||
            (ctx->buffer.buf + ctx->cur)[2] != '4'
        ) goto L0006;
        ctx->cur += 3;
        goto L0001;
    L0006:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (
            pcc_refill_buffer(ctx, 6) < 6 ||
            (ctx->buffer.buf + ctx->cur)[0] != 'd' ||
            (ctx->buffer.buf + ctx->cur)[1] != 'o' ||
            (ctx->buffer.buf + ctx->cur)[2] != 'u' ||
            (ctx->buffer.buf + ctx->cur)[3] != 'b' ||
            (ctx->buffer.buf + ctx->cur)[4] != 'l' ||
            (ctx->buffer.buf + ctx->cur)[5] != 'e'
        ) goto L0007;
        ctx->cur += 6;
        goto L0001;
    L0007:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (
            pcc_refill_buffer(ctx, 6) < 6 ||
            (ctx->buffer.buf + ctx->cur)[0] != 's' ||
            (ctx->buffer.buf + ctx->cur)[1] != 't' ||
            (ctx->buffer.buf + ctx->cur)[2] != 'r' ||
            (ctx->buffer.buf + ctx->cur)[3] != 'i' ||
            (ctx->buffer.buf + ctx->cur)[4] != 'n' ||
            (ctx->buffer.buf + ctx->cur)[5] != 'g'
        ) goto L0008;
        ctx->cur += 6;
        goto L0001;
    L0008:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (
            pcc_refill_buffer(ctx, 6) < 6 ||
            (ctx->buffer.buf + ctx->cur)[0] != 'b' ||
            (ctx->buffer.buf + ctx->cur)[1] != 'i' ||
            (ctx->buffer.buf + ctx->cur)[2] != 'n' ||
            (ctx->buffer.buf + ctx->cur)[3] != 'a' ||
            (ctx->buffer.buf + ctx->cur)[4] != 'r' ||
            (ctx->buffer.buf + ctx->cur)[5] != 'y'
        ) goto L0009;
        ctx->cur += 6;
        goto L0001;
    L0009:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "BaseTypeName", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "BaseTypeName", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_ContainerType(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "ContainerType", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_MapType, &chunk->thunks, NULL)) goto L0002;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_SetType, &chunk->thunks, NULL)) goto L0003;
        goto L0001;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_ListType, &chunk->thunks, NULL)) goto L0004;
        goto L0001;
    L0004:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "ContainerType", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "ContainerType", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_MapType(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "MapType", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_CppType, &chunk->thunks, NULL)) goto L0001;
        goto L0002;
    L0001:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0002:;
    }
    if (
        pcc_refill_buffer(ctx, 3) < 3 ||
        (ctx->buffer.buf + ctx->cur)[0] != 'm' ||
        (ctx->buffer.buf + ctx->cur)[1] != 'a' ||
        (ctx->buffer.buf + ctx->cur)[2] != 'p'
    ) goto L0000;
    ctx->cur += 3;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_WS, &chunk->thunks, NULL)) goto L0000;
    if (
        pcc_refill_buffer(ctx, 1) < 1 ||
        ctx->buffer.buf[ctx->cur] != '<'
    ) goto L0000;
    ctx->cur++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_WS, &chunk->thunks, NULL)) goto L0000;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_FieldType, &chunk->thunks, NULL)) goto L0000;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_WS, &chunk->thunks, NULL)) goto L0000;
    if (
        pcc_refill_buffer(ctx, 1) < 1 ||
        ctx->buffer.buf[ctx->cur] != ','
    ) goto L0000;
    ctx->cur++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_WS, &chunk->thunks, NULL)) goto L0000;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_FieldType, &chunk->thunks, NULL)) goto L0000;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_WS, &chunk->thunks, NULL)) goto L0000;
    if (
        pcc_refill_buffer(ctx, 1) < 1 ||
        ctx->buffer.buf[ctx->cur] != '>'
    ) goto L0000;
    ctx->cur++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0000;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_TypeAnnotations, &chunk->thunks, NULL)) goto L0003;
        goto L0004;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0004:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "MapType", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "MapType", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_SetType(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "SetType", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_CppType, &chunk->thunks, NULL)) goto L0001;
        goto L0002;
    L0001:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0002:;
    }
    if (
        pcc_refill_buffer(ctx, 3) < 3 ||
        (ctx->buffer.buf + ctx->cur)[0] != 's' ||
        (ctx->buffer.buf + ctx->cur)[1] != 'e' ||
        (ctx->buffer.buf + ctx->cur)[2] != 't'
    ) goto L0000;
    ctx->cur += 3;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_WS, &chunk->thunks, NULL)) goto L0000;
    if (
        pcc_refill_buffer(ctx, 1) < 1 ||
        ctx->buffer.buf[ctx->cur] != '<'
    ) goto L0000;
    ctx->cur++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_WS, &chunk->thunks, NULL)) goto L0000;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_FieldType, &chunk->thunks, NULL)) goto L0000;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_WS, &chunk->thunks, NULL)) goto L0000;
    if (
        pcc_refill_buffer(ctx, 1) < 1 ||
        ctx->buffer.buf[ctx->cur] != '>'
    ) goto L0000;
    ctx->cur++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0000;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_TypeAnnotations, &chunk->thunks, NULL)) goto L0003;
        goto L0004;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0004:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "SetType", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "SetType", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_ListType(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "ListType", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 4) < 4 ||
        (ctx->buffer.buf + ctx->cur)[0] != 'l' ||
        (ctx->buffer.buf + ctx->cur)[1] != 'i' ||
        (ctx->buffer.buf + ctx->cur)[2] != 's' ||
        (ctx->buffer.buf + ctx->cur)[3] != 't'
    ) goto L0000;
    ctx->cur += 4;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_WS, &chunk->thunks, NULL)) goto L0000;
    if (
        pcc_refill_buffer(ctx, 1) < 1 ||
        ctx->buffer.buf[ctx->cur] != '<'
    ) goto L0000;
    ctx->cur++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_WS, &chunk->thunks, NULL)) goto L0000;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_FieldType, &chunk->thunks, NULL)) goto L0000;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_WS, &chunk->thunks, NULL)) goto L0000;
    if (
        pcc_refill_buffer(ctx, 1) < 1 ||
        ctx->buffer.buf[ctx->cur] != '>'
    ) goto L0000;
    ctx->cur++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0000;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_TypeAnnotations, &chunk->thunks, NULL)) goto L0001;
        goto L0002;
    L0001:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0002:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "ListType", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "ListType", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_CppType(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "CppType", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 8) < 8 ||
        (ctx->buffer.buf + ctx->cur)[0] != 'c' ||
        (ctx->buffer.buf + ctx->cur)[1] != 'p' ||
        (ctx->buffer.buf + ctx->cur)[2] != 'p' ||
        (ctx->buffer.buf + ctx->cur)[3] != '_' ||
        (ctx->buffer.buf + ctx->cur)[4] != 't' ||
        (ctx->buffer.buf + ctx->cur)[5] != 'y' ||
        (ctx->buffer.buf + ctx->cur)[6] != 'p' ||
        (ctx->buffer.buf + ctx->cur)[7] != 'e'
    ) goto L0000;
    ctx->cur += 8;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_Literal, &chunk->thunks, NULL)) goto L0000;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "CppType", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "CppType", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_ConstValue(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "ConstValue", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_Literal, &chunk->thunks, NULL)) goto L0002;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_DoubleConstant, &chunk->thunks, NULL)) goto L0003;
        goto L0001;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_IntConstant, &chunk->thunks, NULL)) goto L0004;
        goto L0001;
    L0004:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_ConstMap, &chunk->thunks, NULL)) goto L0005;
        goto L0001;
    L0005:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_ConstList, &chunk->thunks, NULL)) goto L0006;
        goto L0001;
    L0006:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_Identifier, &chunk->thunks, NULL)) goto L0007;
        goto L0001;
    L0007:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "ConstValue", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "ConstValue", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_TypeAnnotations(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "TypeAnnotations", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 1) < 1 ||
        ctx->buffer.buf[ctx->cur] != '('
    ) goto L0000;
    ctx->cur++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0000;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_TypeAnnotation, &chunk->thunks, NULL)) goto L0001;
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    if (
        pcc_refill_buffer(ctx, 1) < 1 ||
        ctx->buffer.buf[ctx->cur] != ')'
    ) goto L0000;
    ctx->cur++;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "TypeAnnotations", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "TypeAnnotations", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_TypeAnnotation(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "TypeAnnotation", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_Identifier, &chunk->thunks, NULL)) goto L0000;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0000;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (
            pcc_refill_buffer(ctx, 1) < 1 ||
            ctx->buffer.buf[ctx->cur] != '='
        ) goto L0001;
        ctx->cur++;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0001;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_Literal, &chunk->thunks, NULL)) goto L0001;
        goto L0002;
    L0001:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0002:;
    }
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_ListSeparator, &chunk->thunks, NULL)) goto L0003;
        goto L0004;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0004:;
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0000;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "TypeAnnotation", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "TypeAnnotation", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_IntConstant(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "IntConstant", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        {
            int u;
            const size_t n = pcc_get_char_as_utf32(ctx, &u);
            if (n == 0) goto L0001;
            if (!(
                u == 0x00002d ||
                u == 0x00002b
            )) goto L0001;
            ctx->cur += n;
        }
        goto L0002;
    L0001:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0002:;
    }
    {
        const size_t p0 = ctx->cur;
        const size_t n0 = chunk->thunks.len;
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_Digit, &chunk->thunks, NULL)) goto L0003;
            if (ctx->cur == p) break;
            continue;
        L0003:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
        if (i < 1) {
            ctx->cur = p0;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n0);
            goto L0000;
        }
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "IntConstant", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "IntConstant", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_DoubleConstant(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "DoubleConstant", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        {
            int u;
            const size_t n = pcc_get_char_as_utf32(ctx, &u);
            if (n == 0) goto L0001;
            if (!(
                u == 0x00002d ||
                u == 0x00002b
            )) goto L0001;
            ctx->cur += n;
        }
        goto L0002;
    L0001:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0002:;
    }
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_Digit, &chunk->thunks, NULL)) goto L0003;
            if (ctx->cur == p) break;
            continue;
        L0003:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    if (
        pcc_refill_buffer(ctx, 1) < 1 ||
        ctx->buffer.buf[ctx->cur] != '.'
    ) goto L0000;
    ctx->cur++;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_Digit, &chunk->thunks, NULL)) goto L0004;
            if (ctx->cur == p) break;
            continue;
        L0004:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        {
            int u;
            const size_t n = pcc_get_char_as_utf32(ctx, &u);
            if (n == 0) goto L0005;
            if (!(
                u == 0x000027 ||
                u == 0x000045 ||
                u == 0x000065 ||
                u == 0x000027
            )) goto L0005;
            ctx->cur += n;
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_IntConstant, &chunk->thunks, NULL)) goto L0005;
        goto L0006;
    L0005:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0006:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "DoubleConstant", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "DoubleConstant", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_ConstList(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "ConstList", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 1) < 1 ||
        ctx->buffer.buf[ctx->cur] != '['
    ) goto L0000;
    ctx->cur++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0000;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_ConstValue, &chunk->thunks, NULL)) goto L0001;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0001;
            {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule_ListSeparator, &chunk->thunks, NULL)) goto L0002;
                goto L0003;
            L0002:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            L0003:;
            }
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0001;
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0000;
    if (
        pcc_refill_buffer(ctx, 1) < 1 ||
        ctx->buffer.buf[ctx->cur] != ']'
    ) goto L0000;
    ctx->cur++;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "ConstList", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "ConstList", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_ConstMap(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "ConstMap", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 1) < 1 ||
        ctx->buffer.buf[ctx->cur] != '{'
    ) goto L0000;
    ctx->cur++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0000;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_ConstValue, &chunk->thunks, NULL)) goto L0001;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0001;
            if (
                pcc_refill_buffer(ctx, 1) < 1 ||
                ctx->buffer.buf[ctx->cur] != ':'
            ) goto L0001;
            ctx->cur++;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0001;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_ConstValue, &chunk->thunks, NULL)) goto L0001;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0001;
            {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                {
                    const size_t p = ctx->cur;
                    const size_t n = chunk->thunks.len;
                    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_ListSeparator, &chunk->thunks, NULL)) goto L0004;
                    goto L0005;
                L0004:;
                    ctx->cur = p;
                    pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                L0005:;
                }
                /* unreachable codes omitted */
            }
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0001;
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    if (
        pcc_refill_buffer(ctx, 1) < 1 ||
        ctx->buffer.buf[ctx->cur] != '}'
    ) goto L0000;
    ctx->cur++;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "ConstMap", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "ConstMap", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_Literal(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "Literal", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (
            pcc_refill_buffer(ctx, 1) < 1 ||
            ctx->buffer.buf[ctx->cur] != '\"'
        ) goto L0002;
        ctx->cur++;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                {
                    const size_t p = ctx->cur;
                    const size_t n = chunk->thunks.len;
                    if (
                        pcc_refill_buffer(ctx, 2) < 2 ||
                        (ctx->buffer.buf + ctx->cur)[0] != '\\' ||
                        (ctx->buffer.buf + ctx->cur)[1] != '\"'
                    ) goto L0005;
                    ctx->cur += 2;
                    goto L0004;
                L0005:;
                    ctx->cur = p;
                    pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                    {
                        int u;
                        const size_t n = pcc_get_char_as_utf32(ctx, &u);
                        if (n == 0) goto L0006;
                        if (
                            u == 0x000022
                        ) goto L0006;
                        ctx->cur += n;
                    }
                    goto L0004;
                L0006:;
                    ctx->cur = p;
                    pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                    goto L0003;
                L0004:;
                }
                if (ctx->cur == p) break;
                continue;
            L0003:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        if (
            pcc_refill_buffer(ctx, 1) < 1 ||
            ctx->buffer.buf[ctx->cur] != '\"'
        ) goto L0002;
        ctx->cur++;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (
            pcc_refill_buffer(ctx, 1) < 1 ||
            ctx->buffer.buf[ctx->cur] != '\''
        ) goto L0007;
        ctx->cur++;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                {
                    const size_t p = ctx->cur;
                    const size_t n = chunk->thunks.len;
                    if (
                        pcc_refill_buffer(ctx, 2) < 2 ||
                        (ctx->buffer.buf + ctx->cur)[0] != '\\' ||
                        (ctx->buffer.buf + ctx->cur)[1] != '\''
                    ) goto L0010;
                    ctx->cur += 2;
                    goto L0009;
                L0010:;
                    ctx->cur = p;
                    pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                    {
                        int u;
                        const size_t n = pcc_get_char_as_utf32(ctx, &u);
                        if (n == 0) goto L0011;
                        if (
                            u == 0x000027
                        ) goto L0011;
                        ctx->cur += n;
                    }
                    goto L0009;
                L0011:;
                    ctx->cur = p;
                    pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                    goto L0008;
                L0009:;
                }
                if (ctx->cur == p) break;
                continue;
            L0008:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        if (
            pcc_refill_buffer(ctx, 1) < 1 ||
            ctx->buffer.buf[ctx->cur] != '\''
        ) goto L0007;
        ctx->cur++;
        goto L0001;
    L0007:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "Literal", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "Literal", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_Identifier(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "Identifier", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p0 = ctx->cur;
        const size_t n0 = chunk->thunks.len;
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule_Letter, &chunk->thunks, NULL)) goto L0003;
                goto L0002;
            L0003:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                if (
                    pcc_refill_buffer(ctx, 1) < 1 ||
                    ctx->buffer.buf[ctx->cur] != '_'
                ) goto L0004;
                ctx->cur++;
                goto L0002;
            L0004:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                goto L0001;
            L0002:;
            }
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
        if (i < 1) {
            ctx->cur = p0;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n0);
            goto L0000;
        }
    }
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule_Letter, &chunk->thunks, NULL)) goto L0007;
                goto L0006;
            L0007:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule_Digit, &chunk->thunks, NULL)) goto L0008;
                goto L0006;
            L0008:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                {
                    int u;
                    const size_t n = pcc_get_char_as_utf32(ctx, &u);
                    if (n == 0) goto L0009;
                    if (!(
                        u == 0x00002e ||
                        u == 0x00005f
                    )) goto L0009;
                    ctx->cur += n;
                }
                goto L0006;
            L0009:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                goto L0005;
            L0006:;
            }
            if (ctx->cur == p) break;
            continue;
        L0005:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "Identifier", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "Identifier", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_ListSeparator(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "ListSeparator", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        int u;
        const size_t n = pcc_get_char_as_utf32(ctx, &u);
        if (n == 0) goto L0000;
        if (!(
            u == 0x00002c ||
            u == 0x00003b
        )) goto L0000;
        ctx->cur += n;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "ListSeparator", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "ListSeparator", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_Letter(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "Letter", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        int u;
        const size_t n = pcc_get_char_as_utf32(ctx, &u);
        if (n == 0) goto L0000;
        if (!(
            (u >= 0x000041 && u <= 0x00005a) ||
            (u >= 0x000061 && u <= 0x00007a)
        )) goto L0000;
        ctx->cur += n;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "Letter", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "Letter", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_Digit(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "Digit", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        int u;
        const size_t n = pcc_get_char_as_utf32(ctx, &u);
        if (n == 0) goto L0000;
        if (!(
            (u >= 0x000030 && u <= 0x000039)
        )) goto L0000;
        ctx->cur += n;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "Digit", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "Digit", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_SourceChar(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "SourceChar", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        int u;
        const size_t n = pcc_get_char_as_utf32(ctx, &u);
        if (n == 0) goto L0000;
        ctx->cur += n;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "SourceChar", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "SourceChar", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_Comment(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "Comment", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_MultiLineComment, &chunk->thunks, NULL)) goto L0002;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_SingleLineComment, &chunk->thunks, NULL)) goto L0003;
        goto L0001;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "Comment", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "Comment", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_MultiLineComment(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "MultiLineComment", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 2) < 2 ||
        (ctx->buffer.buf + ctx->cur)[0] != '/' ||
        (ctx->buffer.buf + ctx->cur)[1] != '*'
    ) goto L0000;
    ctx->cur += 2;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            {
                const size_t p = ctx->cur;
                if (
                    pcc_refill_buffer(ctx, 2) < 2 ||
                    (ctx->buffer.buf + ctx->cur)[0] != '*' ||
                    (ctx->buffer.buf + ctx->cur)[1] != '/'
                ) goto L0002;
                ctx->cur += 2;
                ctx->cur = p;
                goto L0001;
            L0002:;
                ctx->cur = p;
            }
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_SourceChar, &chunk->thunks, NULL)) goto L0001;
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    if (
        pcc_refill_buffer(ctx, 2) < 2 ||
        (ctx->buffer.buf + ctx->cur)[0] != '*' ||
        (ctx->buffer.buf + ctx->cur)[1] != '/'
    ) goto L0000;
    ctx->cur += 2;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "MultiLineComment", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "MultiLineComment", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_MultiLineCommentNoLineTerminator(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "MultiLineCommentNoLineTerminator", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 2) < 2 ||
        (ctx->buffer.buf + ctx->cur)[0] != '/' ||
        (ctx->buffer.buf + ctx->cur)[1] != '*'
    ) goto L0000;
    ctx->cur += 2;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            {
                const size_t p = ctx->cur;
                {
                    const size_t p = ctx->cur;
                    const size_t n = chunk->thunks.len;
                    if (
                        pcc_refill_buffer(ctx, 2) < 2 ||
                        (ctx->buffer.buf + ctx->cur)[0] != '*' ||
                        (ctx->buffer.buf + ctx->cur)[1] != '/'
                    ) goto L0004;
                    ctx->cur += 2;
                    goto L0003;
                L0004:;
                    ctx->cur = p;
                    pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_EOL, &chunk->thunks, NULL)) goto L0005;
                    goto L0003;
                L0005:;
                    ctx->cur = p;
                    pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                    goto L0002;
                L0003:;
                }
                ctx->cur = p;
                goto L0001;
            L0002:;
                ctx->cur = p;
            }
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_SourceChar, &chunk->thunks, NULL)) goto L0001;
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    if (
        pcc_refill_buffer(ctx, 2) < 2 ||
        (ctx->buffer.buf + ctx->cur)[0] != '*' ||
        (ctx->buffer.buf + ctx->cur)[1] != '/'
    ) goto L0000;
    ctx->cur += 2;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "MultiLineCommentNoLineTerminator", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "MultiLineCommentNoLineTerminator", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_SingleLineComment(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "SingleLineComment", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (
            pcc_refill_buffer(ctx, 2) < 2 ||
            (ctx->buffer.buf + ctx->cur)[0] != '/' ||
            (ctx->buffer.buf + ctx->cur)[1] != '/'
        ) goto L0002;
        ctx->cur += 2;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                {
                    const size_t p = ctx->cur;
                    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_EOL, &chunk->thunks, NULL)) goto L0004;
                    ctx->cur = p;
                    goto L0003;
                L0004:;
                    ctx->cur = p;
                }
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule_SourceChar, &chunk->thunks, NULL)) goto L0003;
                if (ctx->cur == p) break;
                continue;
            L0003:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (
            pcc_refill_buffer(ctx, 1) < 1 ||
            ctx->buffer.buf[ctx->cur] != '#'
        ) goto L0005;
        ctx->cur++;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                {
                    const size_t p = ctx->cur;
                    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_EOL, &chunk->thunks, NULL)) goto L0007;
                    ctx->cur = p;
                    goto L0006;
                L0007:;
                    ctx->cur = p;
                }
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule_SourceChar, &chunk->thunks, NULL)) goto L0006;
                if (ctx->cur == p) break;
                continue;
            L0006:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        goto L0001;
    L0005:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "SingleLineComment", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "SingleLineComment", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule___(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "__", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule_Whitespace, &chunk->thunks, NULL)) goto L0003;
                goto L0002;
            L0003:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule_EOL, &chunk->thunks, NULL)) goto L0004;
                goto L0002;
            L0004:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule_Comment, &chunk->thunks, NULL)) goto L0005;
                goto L0002;
            L0005:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                goto L0001;
            L0002:;
            }
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "__", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule__(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "_", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule_Whitespace, &chunk->thunks, NULL)) goto L0003;
                goto L0002;
            L0003:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule_MultiLineCommentNoLineTerminator, &chunk->thunks, NULL)) goto L0004;
                goto L0002;
            L0004:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                goto L0001;
            L0002:;
            }
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "_", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_WS(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "WS", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_Whitespace, &chunk->thunks, NULL)) goto L0001;
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "WS", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_Whitespace(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "Whitespace", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        int u;
        const size_t n = pcc_get_char_as_utf32(ctx, &u);
        if (n == 0) goto L0000;
        if (!(
            u == 0x000020 ||
            u == 0x000009 ||
            u == 0x00000d
        )) goto L0000;
        ctx->cur += n;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "Whitespace", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "Whitespace", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_EOL(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "EOL", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 1) < 1 ||
        ctx->buffer.buf[ctx->cur] != '\n'
    ) goto L0000;
    ctx->cur++;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "EOL", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "EOL", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_EOS(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "EOS", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0002;
        if (
            pcc_refill_buffer(ctx, 1) < 1 ||
            ctx->buffer.buf[ctx->cur] != ';'
        ) goto L0002;
        ctx->cur++;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule__, &chunk->thunks, NULL)) goto L0003;
        {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_SingleLineComment, &chunk->thunks, NULL)) goto L0004;
            goto L0005;
        L0004:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        L0005:;
        }
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_EOL, &chunk->thunks, NULL)) goto L0003;
        goto L0001;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule___, &chunk->thunks, NULL)) goto L0006;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_EOF, &chunk->thunks, NULL)) goto L0006;
        goto L0001;
    L0006:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "EOS", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "EOS", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_EOF(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "EOF", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p = ctx->cur;
        {
            int u;
            const size_t n = pcc_get_char_as_utf32(ctx, &u);
            if (n == 0) goto L0001;
            ctx->cur += n;
        }
        ctx->cur = p;
        goto L0000;
    L0001:;
        ctx->cur = p;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "EOF", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "EOF", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

pthrift_context_t *pthrift_create(struct parserCtx *auxil) {
    return pcc_context__create(auxil);
}

int pthrift_parse(pthrift_context_t *ctx, int *ret) {
    if (pcc_apply_rule(ctx, pcc_evaluate_rule_Grammar, &ctx->thunks, ret))
        pcc_do_action(ctx, &ctx->thunks, ret);
    else
        PCC_ERROR(ctx->auxil);
    pcc_commit_buffer(ctx);
    pcc_thunk_array__revert(ctx->auxil, &ctx->thunks, 0);
    return pcc_refill_buffer(ctx, 1) >= 1;
}

void pthrift_destroy(pthrift_context_t *ctx) {
    pcc_context__destroy(ctx);
}

#include "thrift_post.h"
