/* terminal.c generated by valac 0.34.9, the Vala compiler
 * generated from terminal.vala, do not modify */

/*
 * terminal.vala - This file is part of the Geany MultiTerm plugin
 *
 * Copyright (c) 2012 Matthew Brush <matt@geany.org>.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include "multiterm.h"
#include <vte/vte.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _multi_term_shell_config_unref0(var) ((var == NULL) ? NULL : (var = (multi_term_shell_config_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _MultiTermTerminalPrivate {
	MultiTermShellConfig* sh;
};


static gpointer multi_term_terminal_parent_class = NULL;

#define MULTI_TERM_TERMINAL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), MULTI_TERM_TYPE_TERMINAL, MultiTermTerminalPrivate))
enum  {
	MULTI_TERM_TERMINAL_DUMMY_PROPERTY,
	MULTI_TERM_TERMINAL_TAB_LABEL_TEXT,
	MULTI_TERM_TERMINAL_BACKGROUND_COLOR,
	MULTI_TERM_TERMINAL_FOREGROUND_COLOR
};
static void multi_term_terminal_on_window_title_changed (MultiTermTerminal* self);
static void multi_term_terminal_on_vte_realize (MultiTermTerminal* self);
MultiTermConfig* multi_term_shell_config_get_cfg (MultiTermShellConfig* self);
static gboolean multi_term_terminal_on_button_press (MultiTermTerminal* self, GdkEventButton* event);
static gboolean _multi_term_terminal_on_button_press_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static void multi_term_terminal_on_child_exited (MultiTermTerminal* self);
static void _multi_term_terminal_on_window_title_changed_vte_terminal_window_title_changed (VteTerminal* _sender, gpointer self);
static void _multi_term_terminal_on_child_exited_vte_terminal_child_exited (VteTerminal* _sender, gpointer self);
static void _multi_term_terminal_on_vte_realize_gtk_widget_realize (GtkWidget* _sender, gpointer self);
static void g_cclosure_user_marshal_BOOLEAN__POINTER (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void multi_term_terminal_finalize (GObject* obj);
static void _vala_multi_term_terminal_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_multi_term_terminal_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static void multi_term_terminal_on_window_title_changed (MultiTermTerminal* self) {
	VteTerminal* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->terminal;
	_tmp1_ = vte_terminal_get_window_title (_tmp0_);
	_tmp2_ = _tmp1_;
	multi_term_terminal_set_tab_label_text (self, _tmp2_);
}


void multi_term_terminal_run_command (MultiTermTerminal* self, const gchar* command) {
	GPid pid = 0;
	gchar** argv = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar** _tmp2_ = NULL;
	gint argv_length1 = 0;
	gint _argv_size_ = 0;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (command != NULL);
	_tmp0_ = command;
	_tmp1_ = g_strdup (_tmp0_);
	_tmp2_ = g_new0 (gchar*, 2 + 1);
	_tmp2_[0] = _tmp1_;
	_tmp2_[1] = NULL;
	argv = _tmp2_;
	argv_length1 = 2;
	_argv_size_ = argv_length1;
	{
		VteTerminal* _tmp3_ = NULL;
		GPid _tmp4_ = 0;
		_tmp3_ = self->terminal;
		vte_terminal_fork_command_full (_tmp3_, VTE_PTY_DEFAULT, NULL, argv, NULL, G_SPAWN_SEARCH_PATH, NULL, NULL, &_tmp4_, &_inner_error_);
		pid = _tmp4_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch24_g_error;
		}
	}
	goto __finally24;
	__catch24_g_error:
	{
		GError* err = NULL;
		const gchar* _tmp5_ = NULL;
		GError* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp5_ = _ ("Unable to run command: %s");
		_tmp6_ = err;
		_tmp7_ = _tmp6_->message;
		g_warning (_tmp5_, _tmp7_);
		_g_error_free0 (err);
	}
	__finally24:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
}


static gboolean _multi_term_terminal_on_button_press_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = multi_term_terminal_on_button_press ((MultiTermTerminal*) self, event);
	return result;
}


static void multi_term_terminal_on_vte_realize (MultiTermTerminal* self) {
	MultiTermShellConfig* _tmp0_ = NULL;
	MultiTermConfig* _tmp1_ = NULL;
	MultiTermConfig* _tmp2_ = NULL;
	VteTerminal* _tmp11_ = NULL;
	VteTerminal* _tmp12_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->sh;
	_tmp1_ = multi_term_shell_config_get_cfg (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != NULL) {
		MultiTermShellConfig* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		MultiTermShellConfig* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		_tmp3_ = self->priv->sh;
		_tmp4_ = multi_term_shell_config_get_background_color (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = _tmp5_;
		multi_term_terminal_set_background_color (self, _tmp6_);
		_g_free0 (_tmp6_);
		_tmp7_ = self->priv->sh;
		_tmp8_ = multi_term_shell_config_get_foreground_color (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = _tmp9_;
		multi_term_terminal_set_foreground_color (self, _tmp10_);
		_g_free0 (_tmp10_);
	} else {
		multi_term_terminal_set_background_color (self, "#ffffff");
		multi_term_terminal_set_foreground_color (self, "#000000");
	}
	_tmp11_ = self->terminal;
	gtk_widget_add_events ((GtkWidget*) _tmp11_, (gint) GDK_BUTTON_PRESS_MASK);
	_tmp12_ = self->terminal;
	g_signal_connect_object ((GtkWidget*) _tmp12_, "button-press-event", (GCallback) _multi_term_terminal_on_button_press_gtk_widget_button_press_event, self, 0);
}


static void multi_term_terminal_on_child_exited (MultiTermTerminal* self) {
	MultiTermShellConfig* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->sh;
	_tmp1_ = multi_term_shell_config_get_command (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	multi_term_terminal_run_command (self, _tmp3_);
	_g_free0 (_tmp3_);
}


static gboolean multi_term_terminal_on_button_press (MultiTermTerminal* self, GdkEventButton* event) {
	gboolean result = FALSE;
	GdkEventButton _tmp0_ = {0};
	guint _tmp1_ = 0U;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = *event;
	_tmp1_ = _tmp0_.button;
	if (_tmp1_ == ((guint) 3)) {
		GdkEventButton _tmp2_ = {0};
		gboolean _tmp3_ = FALSE;
		_tmp2_ = *event;
		g_signal_emit_by_name (self, "right-click-event", &_tmp2_, &_tmp3_);
		result = _tmp3_;
		return result;
	}
	result = FALSE;
	return result;
}


void multi_term_terminal_send_command (MultiTermTerminal* self, const gchar* command) {
	VteTerminal* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (command != NULL);
	_tmp0_ = self->terminal;
	_tmp1_ = command;
	_tmp2_ = g_strdup_printf ("%s\n", _tmp1_);
	_tmp3_ = _tmp2_;
	vte_terminal_feed_child (_tmp0_, _tmp3_, (glong) -1);
	_g_free0 (_tmp3_);
}


static gpointer _multi_term_shell_config_ref0 (gpointer self) {
	return self ? multi_term_shell_config_ref (self) : NULL;
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


static void _multi_term_terminal_on_window_title_changed_vte_terminal_window_title_changed (VteTerminal* _sender, gpointer self) {
	multi_term_terminal_on_window_title_changed ((MultiTermTerminal*) self);
}


static void _multi_term_terminal_on_child_exited_vte_terminal_child_exited (VteTerminal* _sender, gpointer self) {
	multi_term_terminal_on_child_exited ((MultiTermTerminal*) self);
}


static void _multi_term_terminal_on_vte_realize_gtk_widget_realize (GtkWidget* _sender, gpointer self) {
	multi_term_terminal_on_vte_realize ((MultiTermTerminal*) self);
}


MultiTermTerminal* multi_term_terminal_construct (GType object_type, MultiTermShellConfig* sh) {
	MultiTermTerminal * self = NULL;
	GtkVScrollbar* vsb = NULL;
	GtkHBox* hbox = NULL;
	MultiTermShellConfig* _tmp0_ = NULL;
	MultiTermShellConfig* _tmp1_ = NULL;
	MultiTermShellConfig* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	VteTerminal* _tmp10_ = NULL;
	VteTerminal* _tmp11_ = NULL;
	VteTerminal* _tmp12_ = NULL;
	VteTerminal* _tmp13_ = NULL;
	GtkAdjustment* _tmp14_ = NULL;
	GtkVScrollbar* _tmp15_ = NULL;
	GtkHBox* _tmp16_ = NULL;
	GtkHBox* _tmp17_ = NULL;
	VteTerminal* _tmp18_ = NULL;
	GtkHBox* _tmp19_ = NULL;
	GtkVScrollbar* _tmp20_ = NULL;
	GtkHBox* _tmp21_ = NULL;
	MultiTermShellConfig* _tmp22_ = NULL;
	gboolean _tmp23_ = FALSE;
	gboolean _tmp24_ = FALSE;
	VteTerminal* _tmp26_ = NULL;
	MultiTermShellConfig* _tmp27_ = NULL;
	MultiTermConfig* _tmp28_ = NULL;
	MultiTermConfig* _tmp29_ = NULL;
	VteTerminal* _tmp92_ = NULL;
	MultiTermShellConfig* _tmp93_ = NULL;
	gchar* _tmp94_ = NULL;
	gchar* _tmp95_ = NULL;
	gchar* _tmp96_ = NULL;
	g_return_val_if_fail (sh != NULL, NULL);
	self = (MultiTermTerminal*) g_object_new (object_type, NULL);
	_tmp0_ = sh;
	_tmp1_ = _multi_term_shell_config_ref0 (_tmp0_);
	_multi_term_shell_config_unref0 (self->priv->sh);
	self->priv->sh = _tmp1_;
	_tmp2_ = self->priv->sh;
	_tmp3_ = multi_term_shell_config_get_command (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_;
	_tmp6_ = string_strip (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strcmp0 (_tmp7_, "") == 0;
	_g_free0 (_tmp7_);
	_g_free0 (_tmp5_);
	if (_tmp8_) {
		MultiTermShellConfig* _tmp9_ = NULL;
		_tmp9_ = self->priv->sh;
		multi_term_shell_config_set_command (_tmp9_, "sh");
	}
	_tmp10_ = (VteTerminal*) vte_terminal_new ();
	g_object_ref_sink (_tmp10_);
	_g_object_unref0 (self->terminal);
	self->terminal = _tmp10_;
	_tmp11_ = self->terminal;
	gtk_widget_set_size_request ((GtkWidget*) _tmp11_, 100, 100);
	_tmp12_ = self->terminal;
	gtk_widget_show_all ((GtkWidget*) _tmp12_);
	_tmp13_ = self->terminal;
	_tmp14_ = vte_terminal_get_adjustment (_tmp13_);
	_tmp15_ = (GtkVScrollbar*) gtk_vscrollbar_new (_tmp14_);
	g_object_ref_sink (_tmp15_);
	_g_object_unref0 (vsb);
	vsb = _tmp15_;
	_tmp16_ = (GtkHBox*) gtk_hbox_new (FALSE, 0);
	g_object_ref_sink (_tmp16_);
	_g_object_unref0 (hbox);
	hbox = _tmp16_;
	_tmp17_ = hbox;
	_tmp18_ = self->terminal;
	gtk_box_pack_start ((GtkBox*) _tmp17_, (GtkWidget*) _tmp18_, TRUE, TRUE, (guint) 0);
	_tmp19_ = hbox;
	_tmp20_ = vsb;
	gtk_box_pack_start ((GtkBox*) _tmp19_, (GtkWidget*) _tmp20_, FALSE, FALSE, (guint) 0);
	_tmp21_ = hbox;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp21_);
	_tmp22_ = self->priv->sh;
	_tmp23_ = multi_term_shell_config_get_track_title (_tmp22_);
	_tmp24_ = _tmp23_;
	if (_tmp24_) {
		VteTerminal* _tmp25_ = NULL;
		_tmp25_ = self->terminal;
		g_signal_connect_object (_tmp25_, "window-title-changed", (GCallback) _multi_term_terminal_on_window_title_changed_vte_terminal_window_title_changed, self, 0);
	}
	_tmp26_ = self->terminal;
	g_signal_connect_object (_tmp26_, "child-exited", (GCallback) _multi_term_terminal_on_child_exited_vte_terminal_child_exited, self, 0);
	_tmp27_ = self->priv->sh;
	_tmp28_ = multi_term_shell_config_get_cfg (_tmp27_);
	_tmp29_ = _tmp28_;
	if (_tmp29_ != NULL) {
		VteTerminal* _tmp30_ = NULL;
		MultiTermShellConfig* _tmp31_ = NULL;
		gchar* _tmp32_ = NULL;
		gchar* _tmp33_ = NULL;
		gchar* _tmp34_ = NULL;
		VteTerminal* _tmp35_ = NULL;
		MultiTermShellConfig* _tmp36_ = NULL;
		gboolean _tmp37_ = FALSE;
		gboolean _tmp38_ = FALSE;
		VteTerminal* _tmp39_ = NULL;
		MultiTermShellConfig* _tmp40_ = NULL;
		gboolean _tmp41_ = FALSE;
		gboolean _tmp42_ = FALSE;
		VteTerminal* _tmp43_ = NULL;
		MultiTermShellConfig* _tmp44_ = NULL;
		VteTerminalCursorBlinkMode _tmp45_ = 0;
		VteTerminalCursorBlinkMode _tmp46_ = 0;
		VteTerminal* _tmp47_ = NULL;
		MultiTermShellConfig* _tmp48_ = NULL;
		VteTerminalCursorShape _tmp49_ = 0;
		VteTerminalCursorShape _tmp50_ = 0;
		VteTerminal* _tmp51_ = NULL;
		MultiTermShellConfig* _tmp52_ = NULL;
		VteTerminalEraseBinding _tmp53_ = 0;
		VteTerminalEraseBinding _tmp54_ = 0;
		VteTerminal* _tmp55_ = NULL;
		MultiTermShellConfig* _tmp56_ = NULL;
		gboolean _tmp57_ = FALSE;
		gboolean _tmp58_ = FALSE;
		VteTerminal* _tmp59_ = NULL;
		MultiTermShellConfig* _tmp60_ = NULL;
		gboolean _tmp61_ = FALSE;
		gboolean _tmp62_ = FALSE;
		VteTerminal* _tmp63_ = NULL;
		MultiTermShellConfig* _tmp64_ = NULL;
		gboolean _tmp65_ = FALSE;
		gboolean _tmp66_ = FALSE;
		VteTerminal* _tmp67_ = NULL;
		MultiTermShellConfig* _tmp68_ = NULL;
		gint _tmp69_ = 0;
		gint _tmp70_ = 0;
		VteTerminal* _tmp71_ = NULL;
		MultiTermShellConfig* _tmp72_ = NULL;
		gboolean _tmp73_ = FALSE;
		gboolean _tmp74_ = FALSE;
		VteTerminal* _tmp75_ = NULL;
		MultiTermShellConfig* _tmp76_ = NULL;
		gchar* _tmp77_ = NULL;
		gchar* _tmp78_ = NULL;
		gchar* _tmp79_ = NULL;
		_tmp30_ = self->terminal;
		_tmp31_ = self->priv->sh;
		_tmp32_ = multi_term_shell_config_get_font (_tmp31_);
		_tmp33_ = _tmp32_;
		_tmp34_ = _tmp33_;
		vte_terminal_set_font_from_string (_tmp30_, _tmp34_);
		_g_free0 (_tmp34_);
		_tmp35_ = self->terminal;
		_tmp36_ = self->priv->sh;
		_tmp37_ = multi_term_shell_config_get_allow_bold (_tmp36_);
		_tmp38_ = _tmp37_;
		vte_terminal_set_allow_bold (_tmp35_, _tmp38_);
		_tmp39_ = self->terminal;
		_tmp40_ = self->priv->sh;
		_tmp41_ = multi_term_shell_config_get_audible_bell (_tmp40_);
		_tmp42_ = _tmp41_;
		vte_terminal_set_audible_bell (_tmp39_, _tmp42_);
		_tmp43_ = self->terminal;
		_tmp44_ = self->priv->sh;
		_tmp45_ = multi_term_shell_config_get_cursor_blink_mode (_tmp44_);
		_tmp46_ = _tmp45_;
		vte_terminal_set_cursor_blink_mode (_tmp43_, _tmp46_);
		_tmp47_ = self->terminal;
		_tmp48_ = self->priv->sh;
		_tmp49_ = multi_term_shell_config_get_cursor_shape (_tmp48_);
		_tmp50_ = _tmp49_;
		vte_terminal_set_cursor_shape (_tmp47_, _tmp50_);
		_tmp51_ = self->terminal;
		_tmp52_ = self->priv->sh;
		_tmp53_ = multi_term_shell_config_get_backspace_binding (_tmp52_);
		_tmp54_ = _tmp53_;
		vte_terminal_set_backspace_binding (_tmp51_, _tmp54_);
		_tmp55_ = self->terminal;
		_tmp56_ = self->priv->sh;
		_tmp57_ = multi_term_shell_config_get_pointer_autohide (_tmp56_);
		_tmp58_ = _tmp57_;
		vte_terminal_set_mouse_autohide (_tmp55_, _tmp58_);
		_tmp59_ = self->terminal;
		_tmp60_ = self->priv->sh;
		_tmp61_ = multi_term_shell_config_get_scroll_on_keystroke (_tmp60_);
		_tmp62_ = _tmp61_;
		vte_terminal_set_scroll_on_keystroke (_tmp59_, _tmp62_);
		_tmp63_ = self->terminal;
		_tmp64_ = self->priv->sh;
		_tmp65_ = multi_term_shell_config_get_scroll_on_output (_tmp64_);
		_tmp66_ = _tmp65_;
		vte_terminal_set_scroll_on_output (_tmp63_, _tmp66_);
		_tmp67_ = self->terminal;
		_tmp68_ = self->priv->sh;
		_tmp69_ = multi_term_shell_config_get_scrollback_lines (_tmp68_);
		_tmp70_ = _tmp69_;
		vte_terminal_set_scrollback_lines (_tmp67_, (glong) _tmp70_);
		_tmp71_ = self->terminal;
		_tmp72_ = self->priv->sh;
		_tmp73_ = multi_term_shell_config_get_visible_bell (_tmp72_);
		_tmp74_ = _tmp73_;
		vte_terminal_set_visible_bell (_tmp71_, _tmp74_);
		_tmp75_ = self->terminal;
		_tmp76_ = self->priv->sh;
		_tmp77_ = multi_term_shell_config_get_word_chars (_tmp76_);
		_tmp78_ = _tmp77_;
		_tmp79_ = _tmp78_;
		vte_terminal_set_word_chars (_tmp75_, _tmp79_);
		_g_free0 (_tmp79_);
	} else {
		VteTerminal* _tmp80_ = NULL;
		VteTerminal* _tmp81_ = NULL;
		VteTerminal* _tmp82_ = NULL;
		VteTerminal* _tmp83_ = NULL;
		VteTerminal* _tmp84_ = NULL;
		VteTerminal* _tmp85_ = NULL;
		VteTerminal* _tmp86_ = NULL;
		VteTerminal* _tmp87_ = NULL;
		VteTerminal* _tmp88_ = NULL;
		VteTerminal* _tmp89_ = NULL;
		VteTerminal* _tmp90_ = NULL;
		VteTerminal* _tmp91_ = NULL;
		_tmp80_ = self->terminal;
		vte_terminal_set_font_from_string (_tmp80_, "Monospace 9");
		_tmp81_ = self->terminal;
		vte_terminal_set_allow_bold (_tmp81_, TRUE);
		_tmp82_ = self->terminal;
		vte_terminal_set_audible_bell (_tmp82_, TRUE);
		_tmp83_ = self->terminal;
		vte_terminal_set_cursor_blink_mode (_tmp83_, VTE_CURSOR_BLINK_SYSTEM);
		_tmp84_ = self->terminal;
		vte_terminal_set_cursor_shape (_tmp84_, VTE_CURSOR_SHAPE_BLOCK);
		_tmp85_ = self->terminal;
		vte_terminal_set_backspace_binding (_tmp85_, VTE_ERASE_AUTO);
		_tmp86_ = self->terminal;
		vte_terminal_set_mouse_autohide (_tmp86_, FALSE);
		_tmp87_ = self->terminal;
		vte_terminal_set_scroll_on_keystroke (_tmp87_, TRUE);
		_tmp88_ = self->terminal;
		vte_terminal_set_scroll_on_output (_tmp88_, FALSE);
		_tmp89_ = self->terminal;
		vte_terminal_set_scrollback_lines (_tmp89_, (glong) 512);
		_tmp90_ = self->terminal;
		vte_terminal_set_visible_bell (_tmp90_, FALSE);
		_tmp91_ = self->terminal;
		vte_terminal_set_word_chars (_tmp91_, "");
	}
	_tmp92_ = self->terminal;
	g_signal_connect_object ((GtkWidget*) _tmp92_, "realize", (GCallback) _multi_term_terminal_on_vte_realize_gtk_widget_realize, self, 0);
	_tmp93_ = self->priv->sh;
	_tmp94_ = multi_term_shell_config_get_command (_tmp93_);
	_tmp95_ = _tmp94_;
	_tmp96_ = _tmp95_;
	multi_term_terminal_run_command (self, _tmp96_);
	_g_free0 (_tmp96_);
	_g_object_unref0 (hbox);
	_g_object_unref0 (vsb);
	return self;
}


MultiTermTerminal* multi_term_terminal_new (MultiTermShellConfig* sh) {
	return multi_term_terminal_construct (MULTI_TERM_TYPE_TERMINAL, sh);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


const gchar* multi_term_terminal_get_tab_label_text (MultiTermTerminal* self) {
	const gchar* result;
	MultiTermTabLabel* label = NULL;
	gconstpointer _tmp0_ = NULL;
	MultiTermTabLabel* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_object_get_data ((GObject*) self, "label");
	_tmp1_ = _g_object_ref0 ((MultiTermTabLabel*) _tmp0_);
	label = _tmp1_;
	_tmp2_ = multi_term_tab_label_get_text (label);
	_tmp3_ = _tmp2_;
	result = _tmp3_;
	_g_object_unref0 (label);
	return result;
}


void multi_term_terminal_set_tab_label_text (MultiTermTerminal* self, const gchar* value) {
	MultiTermTabLabel* label = NULL;
	gconstpointer _tmp0_ = NULL;
	MultiTermTabLabel* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_object_get_data ((GObject*) self, "label");
	_tmp1_ = _g_object_ref0 ((MultiTermTabLabel*) _tmp0_);
	label = _tmp1_;
	_tmp2_ = value;
	multi_term_tab_label_set_text (label, _tmp2_);
	_g_object_unref0 (label);
	g_object_notify ((GObject *) self, "tab-label-text");
}


void multi_term_terminal_set_background_color (MultiTermTerminal* self, const gchar* value) {
	GdkColor color = {0};
	GdkColormap* _tmp0_ = NULL;
	GdkColor _tmp1_ = {0};
	const gchar* _tmp2_ = NULL;
	GdkColor _tmp3_ = {0};
	VteTerminal* _tmp4_ = NULL;
	GdkColor _tmp5_ = {0};
	g_return_if_fail (self != NULL);
	memset (&color, 0, sizeof (GdkColor));
	_tmp0_ = gdk_colormap_get_system ();
	_tmp1_ = color;
	gdk_colormap_alloc_color (_tmp0_, &_tmp1_, TRUE, TRUE);
	_tmp2_ = value;
	gdk_color_parse (_tmp2_, &_tmp3_);
	color = _tmp3_;
	_tmp4_ = self->terminal;
	_tmp5_ = color;
	vte_terminal_set_color_background (_tmp4_, &_tmp5_);
	g_object_notify ((GObject *) self, "background-color");
}


void multi_term_terminal_set_foreground_color (MultiTermTerminal* self, const gchar* value) {
	GdkColor color = {0};
	GdkColormap* _tmp0_ = NULL;
	GdkColor _tmp1_ = {0};
	const gchar* _tmp2_ = NULL;
	GdkColor _tmp3_ = {0};
	VteTerminal* _tmp4_ = NULL;
	GdkColor _tmp5_ = {0};
	g_return_if_fail (self != NULL);
	memset (&color, 0, sizeof (GdkColor));
	_tmp0_ = gdk_colormap_get_system ();
	_tmp1_ = color;
	gdk_colormap_alloc_color (_tmp0_, &_tmp1_, TRUE, TRUE);
	_tmp2_ = value;
	gdk_color_parse (_tmp2_, &_tmp3_);
	color = _tmp3_;
	_tmp4_ = self->terminal;
	_tmp5_ = color;
	vte_terminal_set_color_foreground (_tmp4_, &_tmp5_);
	g_object_notify ((GObject *) self, "foreground-color");
}


static void g_cclosure_user_marshal_BOOLEAN__POINTER (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef gboolean (*GMarshalFunc_BOOLEAN__POINTER) (gpointer data1, gpointer arg_1, gpointer data2);
	register GMarshalFunc_BOOLEAN__POINTER callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	gboolean v_return;
	cc = (GCClosure *) closure;
	g_return_if_fail (return_value != NULL);
	g_return_if_fail (n_param_values == 2);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_BOOLEAN__POINTER) (marshal_data ? marshal_data : cc->callback);
	v_return = callback (data1, g_value_get_pointer (param_values + 1), data2);
	g_value_set_boolean (return_value, v_return);
}


static void multi_term_terminal_class_init (MultiTermTerminalClass * klass) {
	multi_term_terminal_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (MultiTermTerminalPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_multi_term_terminal_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_multi_term_terminal_set_property;
	G_OBJECT_CLASS (klass)->finalize = multi_term_terminal_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MULTI_TERM_TERMINAL_TAB_LABEL_TEXT, g_param_spec_string ("tab-label-text", "tab-label-text", "tab-label-text", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MULTI_TERM_TERMINAL_BACKGROUND_COLOR, g_param_spec_string ("background-color", "background-color", "background-color", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MULTI_TERM_TERMINAL_FOREGROUND_COLOR, g_param_spec_string ("foreground-color", "foreground-color", "foreground-color", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE));
	g_signal_new ("right_click_event", MULTI_TERM_TYPE_TERMINAL, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_BOOLEAN__POINTER, G_TYPE_BOOLEAN, 1, G_TYPE_POINTER);
}


static void multi_term_terminal_instance_init (MultiTermTerminal * self) {
	self->priv = MULTI_TERM_TERMINAL_GET_PRIVATE (self);
}


static void multi_term_terminal_finalize (GObject* obj) {
	MultiTermTerminal * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MULTI_TERM_TYPE_TERMINAL, MultiTermTerminal);
	_g_object_unref0 (self->terminal);
	_multi_term_shell_config_unref0 (self->priv->sh);
	G_OBJECT_CLASS (multi_term_terminal_parent_class)->finalize (obj);
}


GType multi_term_terminal_get_type (void) {
	static volatile gsize multi_term_terminal_type_id__volatile = 0;
	if (g_once_init_enter (&multi_term_terminal_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MultiTermTerminalClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) multi_term_terminal_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MultiTermTerminal), 0, (GInstanceInitFunc) multi_term_terminal_instance_init, NULL };
		GType multi_term_terminal_type_id;
		multi_term_terminal_type_id = g_type_register_static (GTK_TYPE_FRAME, "MultiTermTerminal", &g_define_type_info, 0);
		g_once_init_leave (&multi_term_terminal_type_id__volatile, multi_term_terminal_type_id);
	}
	return multi_term_terminal_type_id__volatile;
}


static void _vala_multi_term_terminal_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	MultiTermTerminal * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, MULTI_TERM_TYPE_TERMINAL, MultiTermTerminal);
	switch (property_id) {
		case MULTI_TERM_TERMINAL_TAB_LABEL_TEXT:
		g_value_set_string (value, multi_term_terminal_get_tab_label_text (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_multi_term_terminal_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	MultiTermTerminal * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, MULTI_TERM_TYPE_TERMINAL, MultiTermTerminal);
	switch (property_id) {
		case MULTI_TERM_TERMINAL_TAB_LABEL_TEXT:
		multi_term_terminal_set_tab_label_text (self, g_value_get_string (value));
		break;
		case MULTI_TERM_TERMINAL_BACKGROUND_COLOR:
		multi_term_terminal_set_background_color (self, g_value_get_string (value));
		break;
		case MULTI_TERM_TERMINAL_FOREGROUND_COLOR:
		multi_term_terminal_set_foreground_color (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



