<a href="http://gmic.eu">![Logo](http://gmic.eu/img/logo4.jpg)</a>

#### A Full-Featured Open-Source Framework for Image Processing
##### http://gmic.eu

-----------------------

**G'MIC** is a full-featured open-source framework for **[image processing](https://en.wikipedia.org/wiki/Image_processing)**, distributed under the
**[CeCILL](http://www.cecill.info/licences/Licence_CeCILL_V2.1-en.html)** license (GPL compatible).
It provides several different **[user interfaces](https://en.wikipedia.org/wiki/User_interface)** to convert/manipulate/filter/visualize **generic image datasets**,
ranging from _1d scalar signals_ to _3d+t sequences of multi-spectral volumetric images_, thus including _2d color images_.
These user interfaces are:

- **1** - A command-line interface **[gmic](http://gmic.eu/tutorial/basics.shtml)**, to use the **G'MIC** image processing features from a shell.
In this setting, **G'MIC** may be seen as a friendly companion to the [ImageMagick](http://www.imagemagick.org) or [GraphicsMagick](http://www.graphicsmagick.org)
software suites.

<a href="http://gmic.eu/img/gmic_cli.jpg">![cli_interface](http://gmic.eu/img/gmic_cli_thumb.jpg)<a>

- **2** - A small, portable, thread-safe and multi-threaded _C++_ image processing library **[libgmic](http://gmic.eu/libgmic.shtml)**, to be linked to third-party applications.
[Its simple API](http://gmic.eu/libgmic.shtml) allows programmers to add all **G'MIC** features in their own software without much efforts (a _C_ API is provided as well).

<a href="http://gmic.eu/img/gmic_libgmic.jpg">![interface_libgmic](http://gmic.eu/img/gmic_libgmic_thumb.jpg)</a>

- **3** - A plug-in **[gmic_gimp](http://gmic.eu/gimp.shtml)**, to bring **G'MIC** capabilities to the image retouching software [GIMP](http://www.gimp.org).
More than **450 filters** are already available, sorted by category (_Artistic, Black &amp; white, Colors, Contours, Deformations, Degradations, Details, Film emulation, Frames, Layers,
Light &amp; shadows, Patterns, Rendering, Repair, Sequences_, etc.).

<a href="http://gmic.eu/img/gmic_gimp.jpg">![gimp_interface](http://gmic.eu/img/gmic_gimp_thumb.jpg)</a>

- **4** - A web service **[G'MIC Online](http://gmicol.greyc.fr)**, to allow users applying image processing algorithms on their images, directly from a web browser.

<a href="http://gmic.eu/img/gmic_gmicol.jpg">![gmicol_interface](http://gmic.eu/img/gmic_gmicol_thumb.jpg)</a>

- **5** - A Qt-based interface **[ZArt](https://www.youtube.com/watch?v=k1l3RdvwHeM)**, for real-time processing of video streaming coming from webcams or video files.

<a href="http://gmic.eu/img/gmic_zart.jpg">![interface_zart](http://gmic.eu/img/gmic_zart_thumb.jpg)</a>

-----------------------

Other open-source projects are known to use some of the <b><font color="#000066">G'MIC</font></b> features:

- **[EKD](http://ekd.tuxfamily.org)**, a free software dedicated to post-production processing for videos and images.
- **[Flowblade](https://github.com/jliljebl/flowblade)**, a multitrack non-linear video editor for Linux released under GPL 3 license.
- **[Krita](https://www.krita.org)**, a free digital painting and illustration application. **Krita** has its own **G'MIC** plug-in.
- **[Photoflow](http://aferrero2707.github.io/PhotoFlow/)**, a fully non-destructive photo retouching program.
- **[Veejay](http://veejayhq.net/)**, a visual instrument and realtime video sampler.

-----------------------

<a href="http://gmic.eu">![Logo](http://gmic.eu/img/logos2.jpg)</a>