/* sudoku-generator.c generated by valac 0.38.0.11-8bd7f, the Vala compiler
 * generated from sudoku-generator.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * Copyright © 2014 Parin Porecha
 * Copyright © 2014 Michael Catanzaro
 *
 * This file is part of GNOME Sudoku.
 *
 * GNOME Sudoku is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME Sudoku is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME Sudoku. If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include "qqwing-wrapper.h"
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>


#define SUDOKU_GENERATOR_TYPE_WORKER (sudoku_generator_worker_get_type ())
#define SUDOKU_GENERATOR_WORKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SUDOKU_GENERATOR_TYPE_WORKER, SudokuGeneratorWorker))
#define SUDOKU_GENERATOR_WORKER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SUDOKU_GENERATOR_TYPE_WORKER, SudokuGeneratorWorkerClass))
#define SUDOKU_GENERATOR_IS_WORKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SUDOKU_GENERATOR_TYPE_WORKER))
#define SUDOKU_GENERATOR_IS_WORKER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SUDOKU_GENERATOR_TYPE_WORKER))
#define SUDOKU_GENERATOR_WORKER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SUDOKU_GENERATOR_TYPE_WORKER, SudokuGeneratorWorkerClass))

typedef struct _SudokuGeneratorWorker SudokuGeneratorWorker;
typedef struct _SudokuGeneratorWorkerClass SudokuGeneratorWorkerClass;
typedef struct _SudokuGeneratorWorkerPrivate SudokuGeneratorWorkerPrivate;

#define TYPE_DIFFICULTY_CATEGORY (difficulty_category_get_type ())

#define TYPE_SUDOKU_BOARD (sudoku_board_get_type ())
#define SUDOKU_BOARD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_BOARD, SudokuBoard))
#define SUDOKU_BOARD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_BOARD, SudokuBoardClass))
#define IS_SUDOKU_BOARD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_BOARD))
#define IS_SUDOKU_BOARD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_BOARD))
#define SUDOKU_BOARD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_BOARD, SudokuBoardClass))

typedef struct _SudokuBoard SudokuBoard;
typedef struct _SudokuBoardClass SudokuBoardClass;
enum  {
	SUDOKU_GENERATOR_WORKER_DUMMY_PROPERTY,
	SUDOKU_GENERATOR_WORKER_LAST_PROPERTY
};
static GParamSpec* sudoku_generator_worker_properties[SUDOKU_GENERATOR_WORKER_LAST_PROPERTY];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _g_thread_pool_free0(var) ((var == NULL) ? NULL : (var = (g_thread_pool_free (var, FALSE, TRUE), NULL)))
typedef struct _SudokuGeneratorGenerateBoardsAsyncData SudokuGeneratorGenerateBoardsAsyncData;

struct _SudokuGeneratorWorker {
	GObject parent_instance;
	SudokuGeneratorWorkerPrivate * priv;
};

struct _SudokuGeneratorWorkerClass {
	GObjectClass parent_class;
};

typedef enum  {
	DIFFICULTY_CATEGORY_UNKNOWN,
	DIFFICULTY_CATEGORY_EASY,
	DIFFICULTY_CATEGORY_MEDIUM,
	DIFFICULTY_CATEGORY_HARD,
	DIFFICULTY_CATEGORY_VERY_HARD,
	DIFFICULTY_CATEGORY_CUSTOM
} DifficultyCategory;

struct _SudokuGeneratorWorkerPrivate {
	gint nsudokus;
	DifficultyCategory level;
	GeeList* boards_list;
	GSourceFunc callback;
	gpointer callback_target;
};

struct _Block1Data {
	int _ref_count_;
	GThreadPool* pool;
	gpointer _async_data_;
};

struct _SudokuGeneratorGenerateBoardsAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
	gint nboards;
	DifficultyCategory category;
	GCancellable* cancellable;
	GeeList* result;
	Block1Data* _data1_;
	GeeArrayList* boards;
	GeeArrayList* _tmp0_;
	guint _tmp1_;
	GThreadPool* _tmp2_;
	GCancellable* _tmp3_;
	GCancellable* _tmp4_;
	gint i;
	gboolean _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	GThreadPool* _tmp9_;
	gint _tmp10_;
	DifficultyCategory _tmp11_;
	GeeArrayList* _tmp12_;
	SudokuGeneratorWorker* _tmp13_;
	GCancellable* _tmp14_;
	GError * _inner_error_;
};


static gpointer sudoku_generator_worker_parent_class = NULL;
static GMutex sudoku_generator_worker_mutex;
static GMutex sudoku_generator_worker_mutex = {0};

GType sudoku_generator_worker_get_type (void) G_GNUC_CONST;
GType difficulty_category_get_type (void) G_GNUC_CONST;
GType sudoku_board_get_type (void) G_GNUC_CONST;
#define SUDOKU_GENERATOR_WORKER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SUDOKU_GENERATOR_TYPE_WORKER, SudokuGeneratorWorkerPrivate))
SudokuGeneratorWorker* sudoku_generator_worker_new (gint nsudokus, DifficultyCategory level, GeeList* boards_list, GSourceFunc callback, void* callback_target);
SudokuGeneratorWorker* sudoku_generator_worker_construct (GType object_type, gint nsudokus, DifficultyCategory level, GeeList* boards_list, GSourceFunc callback, void* callback_target);
void sudoku_generator_worker_run (SudokuGeneratorWorker* self);
SudokuBoard* sudoku_generator_generate_board (DifficultyCategory category);
static gboolean ___lambda4_ (SudokuGeneratorWorker* self);
static gboolean ____lambda4__gsource_func (gpointer self);
static void sudoku_generator_worker_finalize (GObject * obj);
SudokuBoard* sudoku_board_new (gint block_rows, gint block_cols);
SudokuBoard* sudoku_board_construct (GType object_type, gint block_rows, gint block_cols);
gint sudoku_board_get_rows (SudokuBoard* self);
gint sudoku_board_get_cols (SudokuBoard* self);
void sudoku_board_insert (SudokuBoard* self, gint row, gint col, gint val, gboolean is_fixed);
void sudoku_board_set_difficulty_category (SudokuBoard* self, DifficultyCategory value);
static void sudoku_generator_generate_boards_async_data_free (gpointer _data);
static void sudoku_generator_generate_boards_async_async_ready_wrapper (GObject *source_object, GAsyncResult *res, void *user_data);
void sudoku_generator_generate_boards_async (gint nboards, DifficultyCategory category, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
GeeList* sudoku_generator_generate_boards_finish (GAsyncResult* _res_, GError** error);
static gboolean sudoku_generator_generate_boards_async_co (SudokuGeneratorGenerateBoardsAsyncData* _data_);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void __lambda5_ (SudokuGeneratorWorker* worker);
static void ___lambda5__gfunc (gpointer data, gpointer self);
static void ___lambda6_ (Block1Data* _data1_);
static void ____lambda6__gfunc (gconstpointer data, gpointer self);
static gboolean _sudoku_generator_generate_boards_async_co_gsource_func (gpointer self);
void sudoku_generator_print_stats (SudokuBoard* board);
gint* sudoku_board_get_cells (SudokuBoard* self, int* result_length1, int* result_length2);
gchar* sudoku_generator_qqwing_version (void);


static gpointer _g_object_ref0 (gpointer self) {
#line 40 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
	return self ? g_object_ref (self) : NULL;
#line 173 "sudoku-generator.c"
}


SudokuGeneratorWorker* sudoku_generator_worker_construct (GType object_type, gint nsudokus, DifficultyCategory level, GeeList* boards_list, GSourceFunc callback, void* callback_target) {
	SudokuGeneratorWorker * self = NULL;
	gint _tmp0_;
	DifficultyCategory _tmp1_;
	GeeList* _tmp2_;
	GeeList* _tmp3_;
	GSourceFunc _tmp4_;
	void* _tmp4__target;
#line 36 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
	g_return_val_if_fail (boards_list != NULL, NULL);
#line 36 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
	self = (SudokuGeneratorWorker*) g_object_new (object_type, NULL);
#line 38 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp0_ = nsudokus;
#line 38 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
	self->priv->nsudokus = _tmp0_;
#line 39 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp1_ = level;
#line 39 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
	self->priv->level = _tmp1_;
#line 40 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp2_ = boards_list;
#line 40 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 40 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
	_g_object_unref0 (self->priv->boards_list);
#line 40 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
	self->priv->boards_list = _tmp3_;
#line 41 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp4_ = callback;
#line 41 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp4__target = callback_target;
#line 41 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
	self->priv->callback = _tmp4_;
#line 41 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
	self->priv->callback_target = _tmp4__target;
#line 36 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
	return self;
#line 215 "sudoku-generator.c"
}


SudokuGeneratorWorker* sudoku_generator_worker_new (gint nsudokus, DifficultyCategory level, GeeList* boards_list, GSourceFunc callback, void* callback_target) {
#line 36 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
	return sudoku_generator_worker_construct (SUDOKU_GENERATOR_TYPE_WORKER, nsudokus, level, boards_list, callback, callback_target);
#line 222 "sudoku-generator.c"
}


static gboolean ___lambda4_ (SudokuGeneratorWorker* self) {
	gboolean result = FALSE;
	GSourceFunc _tmp0_;
	void* _tmp0__target;
#line 55 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp0_ = self->priv->callback;
#line 55 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp0__target = self->priv->callback_target;
#line 55 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp0_ (_tmp0__target);
#line 56 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
	result = G_SOURCE_REMOVE;
#line 56 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
	return result;
#line 240 "sudoku-generator.c"
}


static gboolean ____lambda4__gsource_func (gpointer self) {
	gboolean result;
	result = ___lambda4_ ((SudokuGeneratorWorker*) self);
#line 54 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
	return result;
#line 249 "sudoku-generator.c"
}


void sudoku_generator_worker_run (SudokuGeneratorWorker* self) {
	SudokuBoard* board = NULL;
	DifficultyCategory _tmp0_;
	SudokuBoard* _tmp1_;
	GeeList* _tmp2_;
	SudokuBoard* _tmp3_;
	GeeList* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
#line 44 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
	g_return_if_fail (self != NULL);
#line 47 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp0_ = self->priv->level;
#line 47 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp1_ = sudoku_generator_generate_board (_tmp0_);
#line 47 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
	board = _tmp1_;
#line 48 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
	g_mutex_lock (&sudoku_generator_worker_mutex);
#line 49 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp2_ = self->priv->boards_list;
#line 49 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp3_ = board;
#line 49 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
	gee_collection_add ((GeeCollection*) _tmp2_, _tmp3_);
#line 50 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp4_ = self->priv->boards_list;
#line 50 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp5_ = gee_collection_get_size ((GeeCollection*) _tmp4_);
#line 50 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp6_ = _tmp5_;
#line 50 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp7_ = self->priv->nsudokus;
#line 50 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
	if (_tmp6_ == _tmp7_) {
#line 54 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ____lambda4__gsource_func, g_object_ref (self), g_object_unref);
#line 291 "sudoku-generator.c"
	}
#line 59 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
	g_mutex_unlock (&sudoku_generator_worker_mutex);
#line 44 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
	_g_object_unref0 (board);
#line 297 "sudoku-generator.c"
}


static void sudoku_generator_worker_class_init (SudokuGeneratorWorkerClass * klass) {
#line 26 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
	sudoku_generator_worker_parent_class = g_type_class_peek_parent (klass);
#line 26 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
	g_type_class_add_private (klass, sizeof (SudokuGeneratorWorkerPrivate));
#line 26 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
	G_OBJECT_CLASS (klass)->finalize = sudoku_generator_worker_finalize;
#line 308 "sudoku-generator.c"
}


static void sudoku_generator_worker_instance_init (SudokuGeneratorWorker * self) {
#line 26 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
	self->priv = SUDOKU_GENERATOR_WORKER_GET_PRIVATE (self);
#line 315 "sudoku-generator.c"
}


static void sudoku_generator_worker_finalize (GObject * obj) {
	SudokuGeneratorWorker * self;
#line 26 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SUDOKU_GENERATOR_TYPE_WORKER, SudokuGeneratorWorker);
#line 32 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
	_g_object_unref0 (self->priv->boards_list);
#line 26 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
	G_OBJECT_CLASS (sudoku_generator_worker_parent_class)->finalize (obj);
#line 327 "sudoku-generator.c"
}


GType sudoku_generator_worker_get_type (void) {
	static volatile gsize sudoku_generator_worker_type_id__volatile = 0;
	if (g_once_init_enter (&sudoku_generator_worker_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SudokuGeneratorWorkerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sudoku_generator_worker_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SudokuGeneratorWorker), 0, (GInstanceInitFunc) sudoku_generator_worker_instance_init, NULL };
		GType sudoku_generator_worker_type_id;
		sudoku_generator_worker_type_id = g_type_register_static (G_TYPE_OBJECT, "SudokuGeneratorWorker", &g_define_type_info, 0);
		g_once_init_leave (&sudoku_generator_worker_type_id__volatile, sudoku_generator_worker_type_id);
	}
	return sudoku_generator_worker_type_id__volatile;
}


SudokuBoard* sudoku_generator_generate_board (DifficultyCategory category) {
	SudokuBoard* result = NULL;
	SudokuBoard* board = NULL;
	SudokuBoard* _tmp0_;
	gint* puzzle = NULL;
	SudokuBoard* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	SudokuBoard* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	gint* _tmp7_;
	gint puzzle_length1;
	gint _puzzle_size_;
	DifficultyCategory _tmp8_;
	SudokuBoard* _tmp35_;
	DifficultyCategory _tmp36_;
#line 65 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp0_ = sudoku_board_new (3, 3);
#line 65 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
	board = _tmp0_;
#line 66 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp1_ = board;
#line 66 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp2_ = sudoku_board_get_rows (_tmp1_);
#line 66 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp3_ = _tmp2_;
#line 66 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp4_ = board;
#line 66 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp5_ = sudoku_board_get_cols (_tmp4_);
#line 66 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp6_ = _tmp5_;
#line 66 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp7_ = g_new0 (gint, _tmp3_ * _tmp6_);
#line 66 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
	puzzle = _tmp7_;
#line 66 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
	puzzle_length1 = _tmp3_ * _tmp6_;
#line 66 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
	_puzzle_size_ = puzzle_length1;
#line 67 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp8_ = category;
#line 67 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
	if (_tmp8_ != DIFFICULTY_CATEGORY_CUSTOM) {
#line 388 "sudoku-generator.c"
		DifficultyCategory _tmp9_;
		gint* _tmp10_;
#line 68 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
		_tmp9_ = category;
#line 68 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
		_tmp10_ = qqwing_generate_puzzle ((gint) _tmp9_);
#line 68 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
		puzzle = (g_free (puzzle), NULL);
#line 68 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
		puzzle = _tmp10_;
#line 68 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
		puzzle_length1 = -1;
#line 68 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
		_puzzle_size_ = puzzle_length1;
#line 403 "sudoku-generator.c"
	}
	{
		gint row = 0;
#line 70 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
		row = 0;
#line 409 "sudoku-generator.c"
		{
			gboolean _tmp11_ = FALSE;
#line 70 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
			_tmp11_ = TRUE;
#line 70 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
			while (TRUE) {
#line 416 "sudoku-generator.c"
				gint _tmp13_;
				SudokuBoard* _tmp14_;
				gint _tmp15_;
				gint _tmp16_;
#line 70 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
				if (!_tmp11_) {
#line 423 "sudoku-generator.c"
					gint _tmp12_;
#line 70 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
					_tmp12_ = row;
#line 70 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
					row = _tmp12_ + 1;
#line 429 "sudoku-generator.c"
				}
#line 70 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
				_tmp11_ = FALSE;
#line 70 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
				_tmp13_ = row;
#line 70 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
				_tmp14_ = board;
#line 70 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
				_tmp15_ = sudoku_board_get_rows (_tmp14_);
#line 70 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
				_tmp16_ = _tmp15_;
#line 70 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
				if (!(_tmp13_ < _tmp16_)) {
#line 70 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
					break;
#line 445 "sudoku-generator.c"
				}
				{
					gint col = 0;
#line 71 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
					col = 0;
#line 451 "sudoku-generator.c"
					{
						gboolean _tmp17_ = FALSE;
#line 71 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
						_tmp17_ = TRUE;
#line 71 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
						while (TRUE) {
#line 458 "sudoku-generator.c"
							gint _tmp19_;
							SudokuBoard* _tmp20_;
							gint _tmp21_;
							gint _tmp22_;
							gint val = 0;
							gint* _tmp23_;
							gint _tmp23__length1;
							gint _tmp24_;
							SudokuBoard* _tmp25_;
							gint _tmp26_;
							gint _tmp27_;
							gint _tmp28_;
							gint _tmp29_;
							gint _tmp30_;
#line 71 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
							if (!_tmp17_) {
#line 475 "sudoku-generator.c"
								gint _tmp18_;
#line 71 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
								_tmp18_ = col;
#line 71 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
								col = _tmp18_ + 1;
#line 481 "sudoku-generator.c"
							}
#line 71 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp17_ = FALSE;
#line 71 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp19_ = col;
#line 71 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp20_ = board;
#line 71 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp21_ = sudoku_board_get_cols (_tmp20_);
#line 71 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp22_ = _tmp21_;
#line 71 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
							if (!(_tmp19_ < _tmp22_)) {
#line 71 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
								break;
#line 497 "sudoku-generator.c"
							}
#line 73 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp23_ = puzzle;
#line 73 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp23__length1 = puzzle_length1;
#line 73 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp24_ = row;
#line 73 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp25_ = board;
#line 73 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp26_ = sudoku_board_get_cols (_tmp25_);
#line 73 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp27_ = _tmp26_;
#line 73 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp28_ = col;
#line 73 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp29_ = _tmp23_[(_tmp24_ * _tmp27_) + _tmp28_];
#line 73 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
							val = _tmp29_;
#line 74 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp30_ = val;
#line 74 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
							if (_tmp30_ != 0) {
#line 521 "sudoku-generator.c"
								SudokuBoard* _tmp31_;
								gint _tmp32_;
								gint _tmp33_;
								gint _tmp34_;
#line 75 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
								_tmp31_ = board;
#line 75 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
								_tmp32_ = row;
#line 75 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
								_tmp33_ = col;
#line 75 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
								_tmp34_ = val;
#line 75 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
								sudoku_board_insert (_tmp31_, _tmp32_, _tmp33_, _tmp34_, TRUE);
#line 536 "sudoku-generator.c"
							}
						}
					}
				}
			}
		}
	}
#line 77 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp35_ = board;
#line 77 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp36_ = category;
#line 77 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
	sudoku_board_set_difficulty_category (_tmp35_, _tmp36_);
#line 79 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
	result = board;
#line 79 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
	puzzle = (g_free (puzzle), NULL);
#line 79 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
	return result;
#line 556 "sudoku-generator.c"
}


static void sudoku_generator_generate_boards_async_data_free (gpointer _data) {
	SudokuGeneratorGenerateBoardsAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	g_slice_free (SudokuGeneratorGenerateBoardsAsyncData, _data_);
}


static void sudoku_generator_generate_boards_async_async_ready_wrapper (GObject *source_object, GAsyncResult *res, void *user_data) {
	SudokuGeneratorGenerateBoardsAsyncData* _task_data_;
	_task_data_ = g_task_get_task_data (G_TASK (res));
	if (_task_data_->_callback_ != NULL) {
		_task_data_->_callback_ (source_object, res, user_data);
	}
	_task_data_->_task_complete_ = TRUE;
}


void sudoku_generator_generate_boards_async (gint nboards, DifficultyCategory category, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SudokuGeneratorGenerateBoardsAsyncData* _data_;
	gint _tmp0_;
	DifficultyCategory _tmp1_;
	GCancellable* _tmp2_;
	GCancellable* _tmp3_;
	_data_ = g_slice_new0 (SudokuGeneratorGenerateBoardsAsyncData);
	_data_->_callback_ = _callback_;
	_data_->_async_result = g_task_new (NULL, cancellable, sudoku_generator_generate_boards_async_async_ready_wrapper, _user_data_);
	if (_callback_ == NULL) {
		_data_->_task_complete_ = TRUE;
	}
	g_task_set_task_data (_data_->_async_result, _data_, sudoku_generator_generate_boards_async_data_free);
	_tmp0_ = nboards;
	_data_->nboards = _tmp0_;
	_tmp1_ = category;
	_data_->category = _tmp1_;
	_tmp2_ = cancellable;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp3_;
	sudoku_generator_generate_boards_async_co (_data_);
}


GeeList* sudoku_generator_generate_boards_finish (GAsyncResult* _res_, GError** error) {
	GeeList* result;
	SudokuGeneratorGenerateBoardsAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
#line 82 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
	g_atomic_int_inc (&_data1_->_ref_count_);
#line 82 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
	return _data1_;
#line 622 "sudoku-generator.c"
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
#line 82 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
#line 82 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
		_g_thread_pool_free0 (_data1_->pool);
#line 82 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
		g_slice_free (Block1Data, _data1_);
#line 635 "sudoku-generator.c"
	}
}


static void __lambda5_ (SudokuGeneratorWorker* worker) {
	SudokuGeneratorWorker* _tmp0_;
#line 86 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
	g_return_if_fail (worker != NULL);
#line 87 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp0_ = worker;
#line 87 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
	sudoku_generator_worker_run (_tmp0_);
#line 86 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
	_g_object_unref0 (worker);
#line 650 "sudoku-generator.c"
}


static void ___lambda5__gfunc (gpointer data, gpointer self) {
#line 86 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
	__lambda5_ ((SudokuGeneratorWorker*) data);
#line 657 "sudoku-generator.c"
}


static void vala__g_thread_pool_free_wrapper (GThreadPool* pool, gboolean immediate, gboolean wait) {
	GThreadPool* ptr = NULL;
	GThreadPool* _tmp0_;
	GThreadPool* _tmp1_;
#line 2134 "/home/mcatanzaro/Projects/GNOME/install/share/vala-0.38/vapi/glib-2.0.vapi"
	_tmp0_ = pool;
#line 2134 "/home/mcatanzaro/Projects/GNOME/install/share/vala-0.38/vapi/glib-2.0.vapi"
	pool = NULL;
#line 2134 "/home/mcatanzaro/Projects/GNOME/install/share/vala-0.38/vapi/glib-2.0.vapi"
	ptr = _tmp0_;
#line 2135 "/home/mcatanzaro/Projects/GNOME/install/share/vala-0.38/vapi/glib-2.0.vapi"
	_tmp1_ = ptr;
#line 2135 "/home/mcatanzaro/Projects/GNOME/install/share/vala-0.38/vapi/glib-2.0.vapi"
	if (_tmp1_ != NULL) {
#line 675 "sudoku-generator.c"
		GThreadPool* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
#line 2136 "/home/mcatanzaro/Projects/GNOME/install/share/vala-0.38/vapi/glib-2.0.vapi"
		_tmp2_ = ptr;
#line 2136 "/home/mcatanzaro/Projects/GNOME/install/share/vala-0.38/vapi/glib-2.0.vapi"
		_tmp3_ = immediate;
#line 2136 "/home/mcatanzaro/Projects/GNOME/install/share/vala-0.38/vapi/glib-2.0.vapi"
		_tmp4_ = wait;
#line 2136 "/home/mcatanzaro/Projects/GNOME/install/share/vala-0.38/vapi/glib-2.0.vapi"
		g_thread_pool_free ((GThreadPool*) _tmp2_, _tmp3_, _tmp4_);
#line 687 "sudoku-generator.c"
	}
#line 2133 "/home/mcatanzaro/Projects/GNOME/install/share/vala-0.38/vapi/glib-2.0.vapi"
	_g_thread_pool_free0 (pool);
#line 691 "sudoku-generator.c"
}


static void ___lambda6_ (Block1Data* _data1_) {
	GThreadPool* _tmp0_;
#line 93 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp0_ = _data1_->pool;
#line 93 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
	_data1_->pool = NULL;
#line 93 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
	vala__g_thread_pool_free_wrapper (_tmp0_, TRUE, FALSE);
#line 94 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
	sudoku_generator_generate_boards_async_co (_data1_->_async_data_);
#line 705 "sudoku-generator.c"
}


static void ____lambda6__gfunc (gconstpointer data, gpointer self) {
#line 92 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
	___lambda6_ (self);
#line 712 "sudoku-generator.c"
}


static gboolean _sudoku_generator_generate_boards_async_co_gsource_func (gpointer self) {
	gboolean result;
	result = sudoku_generator_generate_boards_async_co (self);
#line 99 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
	return result;
#line 721 "sudoku-generator.c"
}


static gboolean sudoku_generator_generate_boards_async_co (SudokuGeneratorGenerateBoardsAsyncData* _data_) {
#line 82 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
	switch (_data_->_state_) {
#line 82 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
		case 0:
#line 730 "sudoku-generator.c"
		goto _state_0;
#line 82 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
		case 1:
#line 734 "sudoku-generator.c"
		goto _state_1;
		default:
#line 82 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
		g_assert_not_reached ();
#line 739 "sudoku-generator.c"
	}
	_state_0:
#line 82 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
	_data_->_data1_ = g_slice_new0 (Block1Data);
#line 82 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
	_data_->_data1_->_ref_count_ = 1;
#line 82 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
	_data_->_data1_->_async_data_ = _data_;
#line 85 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
	_data_->_tmp0_ = gee_array_list_new (TYPE_SUDOKU_BOARD, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 85 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
	_data_->boards = _data_->_tmp0_;
#line 86 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
	_data_->_tmp1_ = g_get_num_processors ();
#line 86 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
	_data_->_tmp2_ = g_thread_pool_new (___lambda5__gfunc, NULL, (gint) _data_->_tmp1_, FALSE, &_data_->_inner_error_);
#line 86 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
	_data_->_data1_->pool = _data_->_tmp2_;
#line 86 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 86 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
		if ((_data_->_inner_error_->domain == G_THREAD_ERROR) || (_data_->_inner_error_->domain == G_IO_ERROR)) {
#line 86 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
			g_task_return_error (_data_->_async_result, _data_->_inner_error_);
#line 86 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
			_g_object_unref0 (_data_->boards);
#line 86 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
			block1_data_unref (_data_->_data1_);
#line 86 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
			_data_->_data1_ = NULL;
#line 86 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
			g_object_unref (_data_->_async_result);
#line 86 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
			return FALSE;
#line 774 "sudoku-generator.c"
		} else {
#line 86 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
			_g_object_unref0 (_data_->boards);
#line 86 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
			block1_data_unref (_data_->_data1_);
#line 86 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
			_data_->_data1_ = NULL;
#line 86 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 86 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
			g_clear_error (&_data_->_inner_error_);
#line 86 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
			g_object_unref (_data_->_async_result);
#line 86 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
			return FALSE;
#line 790 "sudoku-generator.c"
		}
	}
#line 90 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
	_data_->_tmp3_ = _data_->cancellable;
#line 90 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
	if (_data_->_tmp3_ != NULL) {
#line 92 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
		_data_->_tmp4_ = _data_->cancellable;
#line 92 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
		g_cancellable_connect (_data_->_tmp4_, (GCallback) ____lambda6__gfunc, block1_data_ref (_data_->_data1_), block1_data_unref);
#line 801 "sudoku-generator.c"
	}
	{
#line 98 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
		_data_->i = 0;
#line 806 "sudoku-generator.c"
		{
#line 98 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
			_data_->_tmp5_ = TRUE;
#line 98 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
			while (TRUE) {
#line 98 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
				if (!_data_->_tmp5_) {
#line 98 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
					_data_->_tmp6_ = _data_->i;
#line 98 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
					_data_->i = _data_->_tmp6_ + 1;
#line 818 "sudoku-generator.c"
				}
#line 98 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
				_data_->_tmp5_ = FALSE;
#line 98 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
				_data_->_tmp7_ = _data_->i;
#line 98 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
				_data_->_tmp8_ = _data_->nboards;
#line 98 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
				if (!(_data_->_tmp7_ < _data_->_tmp8_)) {
#line 98 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
					break;
#line 830 "sudoku-generator.c"
				}
#line 99 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
				_data_->_tmp9_ = _data_->_data1_->pool;
#line 99 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
				_data_->_tmp10_ = _data_->nboards;
#line 99 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
				_data_->_tmp11_ = _data_->category;
#line 99 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
				_data_->_tmp12_ = _data_->boards;
#line 99 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
				_data_->_tmp13_ = sudoku_generator_worker_new (_data_->_tmp10_, _data_->_tmp11_, (GeeList*) _data_->_tmp12_, _sudoku_generator_generate_boards_async_co_gsource_func, _data_);
#line 99 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
				g_thread_pool_push (_data_->_tmp9_, _data_->_tmp13_, &_data_->_inner_error_);
#line 99 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
				if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 99 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
					if ((_data_->_inner_error_->domain == G_THREAD_ERROR) || (_data_->_inner_error_->domain == G_IO_ERROR)) {
#line 99 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
						g_task_return_error (_data_->_async_result, _data_->_inner_error_);
#line 99 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
						_g_object_unref0 (_data_->boards);
#line 99 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
						block1_data_unref (_data_->_data1_);
#line 99 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
						_data_->_data1_ = NULL;
#line 99 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
						g_object_unref (_data_->_async_result);
#line 99 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
						return FALSE;
#line 860 "sudoku-generator.c"
					} else {
#line 99 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
						_g_object_unref0 (_data_->boards);
#line 99 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
						block1_data_unref (_data_->_data1_);
#line 99 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
						_data_->_data1_ = NULL;
#line 99 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 99 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
						g_clear_error (&_data_->_inner_error_);
#line 99 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
						g_object_unref (_data_->_async_result);
#line 99 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
						return FALSE;
#line 876 "sudoku-generator.c"
					}
				}
			}
		}
	}
#line 101 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
	_data_->_state_ = 1;
#line 101 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
	return FALSE;
#line 886 "sudoku-generator.c"
	_state_1:
	;
#line 103 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
	_data_->_tmp14_ = _data_->cancellable;
#line 103 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
	g_cancellable_set_error_if_cancelled (_data_->_tmp14_, &_data_->_inner_error_);
#line 103 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 103 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
		if ((_data_->_inner_error_->domain == G_THREAD_ERROR) || (_data_->_inner_error_->domain == G_IO_ERROR)) {
#line 103 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
			g_task_return_error (_data_->_async_result, _data_->_inner_error_);
#line 103 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
			_g_object_unref0 (_data_->boards);
#line 103 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
			block1_data_unref (_data_->_data1_);
#line 103 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
			_data_->_data1_ = NULL;
#line 103 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
			g_object_unref (_data_->_async_result);
#line 103 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
			return FALSE;
#line 909 "sudoku-generator.c"
		} else {
#line 103 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
			_g_object_unref0 (_data_->boards);
#line 103 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
			block1_data_unref (_data_->_data1_);
#line 103 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
			_data_->_data1_ = NULL;
#line 103 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 103 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
			g_clear_error (&_data_->_inner_error_);
#line 103 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
			g_object_unref (_data_->_async_result);
#line 103 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
			return FALSE;
#line 925 "sudoku-generator.c"
		}
	}
#line 104 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
	_data_->result = (GeeList*) _data_->boards;
#line 104 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
	block1_data_unref (_data_->_data1_);
#line 104 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
	_data_->_data1_ = NULL;
#line 104 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 104 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
	if (_data_->_state_ != 0) {
#line 104 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
		while (_data_->_task_complete_ != TRUE) {
#line 104 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 942 "sudoku-generator.c"
		}
	}
#line 104 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
	g_object_unref (_data_->_async_result);
#line 104 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
	return FALSE;
#line 949 "sudoku-generator.c"
}


void sudoku_generator_print_stats (SudokuBoard* board) {
	gint* cells = NULL;
	SudokuBoard* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint* _tmp3_;
	gint cells_length1;
	gint cells_length2;
	gint* puzzle = NULL;
	SudokuBoard* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	SudokuBoard* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	gint* _tmp10_;
	gint puzzle_length1;
	gint _puzzle_size_;
	gint* _tmp34_;
	gint _tmp34__length1;
#line 107 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
	g_return_if_fail (board != NULL);
#line 109 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp0_ = board;
#line 109 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp3_ = sudoku_board_get_cells (_tmp0_, &_tmp1_, &_tmp2_);
#line 109 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
	cells = _tmp3_;
#line 109 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
	cells_length1 = _tmp1_;
#line 109 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
	cells_length2 = _tmp2_;
#line 110 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp4_ = board;
#line 110 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp5_ = sudoku_board_get_rows (_tmp4_);
#line 110 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp6_ = _tmp5_;
#line 110 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp7_ = board;
#line 110 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp8_ = sudoku_board_get_cols (_tmp7_);
#line 110 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp9_ = _tmp8_;
#line 110 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp10_ = g_new0 (gint, _tmp6_ * _tmp9_);
#line 110 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
	puzzle = _tmp10_;
#line 110 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
	puzzle_length1 = _tmp6_ * _tmp9_;
#line 110 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
	_puzzle_size_ = puzzle_length1;
#line 1005 "sudoku-generator.c"
	{
		gint row = 0;
#line 112 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
		row = 0;
#line 1010 "sudoku-generator.c"
		{
			gboolean _tmp11_ = FALSE;
#line 112 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
			_tmp11_ = TRUE;
#line 112 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
			while (TRUE) {
#line 1017 "sudoku-generator.c"
				gint _tmp13_;
				SudokuBoard* _tmp14_;
				gint _tmp15_;
				gint _tmp16_;
#line 112 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
				if (!_tmp11_) {
#line 1024 "sudoku-generator.c"
					gint _tmp12_;
#line 112 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
					_tmp12_ = row;
#line 112 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
					row = _tmp12_ + 1;
#line 1030 "sudoku-generator.c"
				}
#line 112 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
				_tmp11_ = FALSE;
#line 112 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
				_tmp13_ = row;
#line 112 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
				_tmp14_ = board;
#line 112 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
				_tmp15_ = sudoku_board_get_rows (_tmp14_);
#line 112 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
				_tmp16_ = _tmp15_;
#line 112 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
				if (!(_tmp13_ < _tmp16_)) {
#line 112 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
					break;
#line 1046 "sudoku-generator.c"
				}
				{
					gint col = 0;
#line 113 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
					col = 0;
#line 1052 "sudoku-generator.c"
					{
						gboolean _tmp17_ = FALSE;
#line 113 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
						_tmp17_ = TRUE;
#line 113 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
						while (TRUE) {
#line 1059 "sudoku-generator.c"
							gint _tmp19_;
							SudokuBoard* _tmp20_;
							gint _tmp21_;
							gint _tmp22_;
							gint* _tmp23_;
							gint _tmp23__length1;
							gint _tmp24_;
							SudokuBoard* _tmp25_;
							gint _tmp26_;
							gint _tmp27_;
							gint _tmp28_;
							gint* _tmp29_;
							gint _tmp29__length1;
							gint _tmp29__length2;
							gint _tmp30_;
							gint _tmp31_;
							gint _tmp32_;
							gint _tmp33_;
#line 113 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
							if (!_tmp17_) {
#line 1080 "sudoku-generator.c"
								gint _tmp18_;
#line 113 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
								_tmp18_ = col;
#line 113 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
								col = _tmp18_ + 1;
#line 1086 "sudoku-generator.c"
							}
#line 113 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp17_ = FALSE;
#line 113 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp19_ = col;
#line 113 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp20_ = board;
#line 113 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp21_ = sudoku_board_get_cols (_tmp20_);
#line 113 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp22_ = _tmp21_;
#line 113 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
							if (!(_tmp19_ < _tmp22_)) {
#line 113 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
								break;
#line 1102 "sudoku-generator.c"
							}
#line 114 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp23_ = puzzle;
#line 114 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp23__length1 = puzzle_length1;
#line 114 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp24_ = row;
#line 114 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp25_ = board;
#line 114 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp26_ = sudoku_board_get_cols (_tmp25_);
#line 114 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp27_ = _tmp26_;
#line 114 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp28_ = col;
#line 114 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp29_ = cells;
#line 114 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp29__length1 = cells_length1;
#line 114 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp29__length2 = cells_length2;
#line 114 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp30_ = row;
#line 114 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp31_ = col;
#line 114 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp32_ = _tmp29_[(_tmp30_ * _tmp29__length2) + _tmp31_];
#line 114 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp23_[(_tmp24_ * _tmp27_) + _tmp28_] = _tmp32_;
#line 114 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp33_ = _tmp23_[(_tmp24_ * _tmp27_) + _tmp28_];
#line 1134 "sudoku-generator.c"
						}
					}
				}
			}
		}
	}
#line 116 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp34_ = puzzle;
#line 116 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp34__length1 = puzzle_length1;
#line 116 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
	qqwing_print_stats (_tmp34_);
#line 107 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
	puzzle = (g_free (puzzle), NULL);
#line 107 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
	cells = (g_free (cells), NULL);
#line 1151 "sudoku-generator.c"
}


gchar* sudoku_generator_qqwing_version (void) {
	gchar* result = NULL;
	gchar* _tmp0_;
#line 121 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp0_ = qqwing_get_version ();
#line 121 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
	result = _tmp0_;
#line 121 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/lib/sudoku-generator.vala"
	return result;
#line 1164 "sudoku-generator.c"
}



