/*
	$Id:$

    TiMidity++ -- MIDI to WAVE converter and player
    Copyright (C) 1999 Masanao Izumo <mo@goice.co.jp>
    Copyright (C) 1995 Tuukka Toivonen <tt@cgs.fi>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#include <math.h>
#include <stdio.h>
#ifdef __FreeBSD__
#include <stdlib.h>
#else
#include <malloc.h>
#endif

#include "gtim.h"
#include "common.h"
#include "instrum.h"
#include "playmidi.h"
#include "output.h"
#include "controls.h"
#include "tables.h"
#include "resample.h"

static FLOAT_T moog_q0[241][3] = {
{ /* dummy entry */ 0, 0, 0},
{ /*  1 f=  100 */ 0.00000000000000000000, 0.00748611111111113781, -0.98502777777777772439 },
{ /*  2 f=  200 */ 0.00000000000000000000, 0.01494444444444442688, -0.97011111111111114624 },
{ /*  3 f=  300 */ 0.00000000000000000000, 0.02237499999999997824, -0.95525000000000004352 },
{ /*  4 f=  400 */ 0.00000000000000000000, 0.02977777777777779189, -0.94044444444444441622 },
{ /*  5 f=  500 */ 0.00000000000000000000, 0.03715277777777775681, -0.92569444444444448639 },
{ /*  6 f=  600 */ 0.00000000000000000000, 0.04449999999999998401, -0.91100000000000003197 },
{ /*  7 f=  700 */ 0.00000000000000000000, 0.05181944444444447351, -0.89636111111111105298 },
{ /*  8 f=  800 */ 0.00000000000000000000, 0.05911111111111111427, -0.88177777777777777146 },
{ /*  9 f=  900 */ 0.00000000000000000000, 0.06637500000000001732, -0.86724999999999996536 },
{ /* 10 f= 1000 */ 0.00000000000000000000, 0.07361111111111112715, -0.85277777777777774570 },
{ /* 11 f= 1100 */ 0.00000000000000000000, 0.08081944444444444375, -0.83836111111111111249 },
{ /* 12 f= 1200 */ 0.00000000000000000000, 0.08800000000000002265, -0.82399999999999995470 },
{ /* 13 f= 1300 */ 0.00000000000000000000, 0.09515277777777780832, -0.80969444444444438336 },
{ /* 14 f= 1400 */ 0.00000000000000000000, 0.10227777777777780077, -0.79544444444444439846 },
{ /* 15 f= 1500 */ 0.00000000000000000000, 0.10937500000000000000, -0.78125000000000000000 },
{ /* 16 f= 1600 */ 0.00000000000000000000, 0.11644444444444446152, -0.76711111111111107697 },
{ /* 17 f= 1700 */ 0.00000000000000000000, 0.12348611111111112981, -0.75302777777777774038 },
{ /* 18 f= 1800 */ 0.00000000000000000000, 0.13050000000000000488, -0.73899999999999999023 },
{ /* 19 f= 1900 */ 0.00000000000000000000, 0.13748611111111108674, -0.72502777777777782653 },
{ /* 20 f= 2000 */ 0.00000000000000000000, 0.14444444444444443088, -0.71111111111111113825 },
{ /* 21 f= 2100 */ 0.00000000000000000000, 0.15137499999999998179, -0.69725000000000003642 },
{ /* 22 f= 2200 */ 0.00000000000000000000, 0.15827777777777779500, -0.68344444444444441000 },
{ /* 23 f= 2300 */ 0.00000000000000000000, 0.16515277777777781498, -0.66969444444444437003 },
{ /* 24 f= 2400 */ 0.00000000000000000000, 0.17199999999999998623, -0.65600000000000002753 },
{ /* 25 f= 2500 */ 0.00000000000000000000, 0.17881944444444447528, -0.64236111111111104943 },
{ /* 26 f= 2600 */ 0.00000000000000000000, 0.18561111111111111560, -0.62877777777777776880 },
{ /* 27 f= 2700 */ 0.00000000000000000000, 0.19237500000000001821, -0.61524999999999996358 },
{ /* 28 f= 2800 */ 0.00000000000000000000, 0.19911111111111112759, -0.60177777777777774482 },
{ /* 29 f= 2900 */ 0.00000000000000000000, 0.20581944444444444375, -0.58836111111111111249 },
{ /* 30 f= 3000 */ 0.00000000000000000000, 0.21250000000000002220, -0.57499999999999995559 },
{ /* 31 f= 3100 */ 0.00000000000000000000, 0.21915277777777780743, -0.56169444444444438513 },
{ /* 32 f= 3200 */ 0.00000000000000000000, 0.22577777777777779944, -0.54844444444444440112 },
{ /* 33 f= 3300 */ 0.00000000000000000000, 0.23237499999999999822, -0.53525000000000000355 },
{ /* 34 f= 3400 */ 0.00000000000000000000, 0.23894444444444445930, -0.52211111111111108141 },
{ /* 35 f= 3500 */ 0.00000000000000000000, 0.24548611111111112715, -0.50902777777777774570 },
{ /* 36 f= 3600 */ 0.00000000000000000000, 0.25200000000000000178, -0.49599999999999999645 },
{ /* 37 f= 3700 */ 0.00000000000000000000, 0.25848611111111113869, -0.48302777777777772261 },
{ /* 38 f= 3800 */ 0.00000000000000000000, 0.26494444444444442688, -0.47011111111111114624 },
{ /* 39 f= 3900 */ 0.00000000000000000000, 0.27137500000000003286, -0.45724999999999998979 },
{ /* 40 f= 4000 */ 0.00000000000000000000, 0.27777777777777779011, -0.44444444444444447528 },
{ /* 41 f= 4100 */ 0.00000000000000000000, 0.28415277777777780965, -0.43169444444444443620 },
{ /* 42 f= 4200 */ 0.00000000000000000000, 0.29049999999999998046, -0.41900000000000003908 },
{ /* 43 f= 4300 */ 0.00000000000000000000, 0.29681944444444441356, -0.40636111111111111738 },
{ /* 44 f= 4400 */ 0.00000000000000000000, 0.30311111111111110894, -0.39377777777777778212 },
{ /* 45 f= 4500 */ 0.00000000000000000000, 0.30937500000000001110, -0.38124999999999997780 },
{ /* 46 f= 4600 */ 0.00000000000000000000, 0.31561111111111117555, -0.36877777777777770440 },
{ /* 47 f= 4700 */ 0.00000000000000000000, 0.32181944444444443576, -0.35636111111111112848 },
{ /* 48 f= 4800 */ 0.00000000000000000000, 0.32800000000000001377, -0.34399999999999997247 },
{ /* 49 f= 4900 */ 0.00000000000000000000, 0.33415277777777774304, -0.33169444444444445841 },
{ /* 50 f= 5000 */ 0.00000000000000000000, 0.34027777777777779011, -0.31944444444444441977 },
{ /* 51 f= 5100 */ 0.00000000000000000000, 0.34637499999999998845, -0.30725000000000002309 },
{ /* 52 f= 5200 */ 0.00000000000000000000, 0.35244444444444444908, -0.29511111111111110183 },
{ /* 53 f= 5300 */ 0.00000000000000000000, 0.35848611111111111649, -0.28302777777777776702 },
{ /* 54 f= 5400 */ 0.00000000000000000000, 0.36450000000000004619, -0.27099999999999996314 },
{ /* 55 f= 5500 */ 0.00000000000000000000, 0.37048611111111107164, -0.25902777777777780122 },
{ /* 56 f= 5600 */ 0.00000000000000000000, 0.37644444444444447040, -0.24711111111111108696 },
{ /* 57 f= 5700 */ 0.00000000000000000000, 0.38237500000000002043, -0.23525000000000001465 },
{ /* 58 f= 5800 */ 0.00000000000000000000, 0.38827777777777777724, -0.22344444444444441777 },
{ /* 59 f= 5900 */ 0.00000000000000000000, 0.39415277777777779633, -0.21169444444444446285 },
{ /* 60 f= 6000 */ 0.00000000000000000000, 0.40000000000000002220, -0.19999999999999998335 },
{ /* 61 f= 6100 */ 0.00000000000000000000, 0.40581944444444439934, -0.18836111111111114580 },
{ /* 62 f= 6200 */ 0.00000000000000000000, 0.41161111111111114980, -0.17677777777777770041 },
{ /* 63 f= 6300 */ 0.00000000000000000000, 0.41737500000000005151, -0.16524999999999995248 },
{ /* 64 f= 6400 */ 0.00000000000000000000, 0.42311111111111110450, -0.15377777777777776325 },
{ /* 65 f= 6500 */ 0.00000000000000000000, 0.42881944444444441977, -0.14236111111111113270 },
{ /* 66 f= 6600 */ 0.00000000000000000000, 0.43450000000000005285, -0.13099999999999992206 },
{ /* 67 f= 6700 */ 0.00000000000000000000, 0.44015277777777778168, -0.11969444444444440889 },
{ /* 68 f= 6800 */ 0.00000000000000000000, 0.44577777777777777279, -0.10844444444444444053 },
{ /* 69 f= 6900 */ 0.00000000000000000000, 0.45137499999999997069, -0.09725000000000004474 },
{ /* 70 f= 7000 */ 0.00000000000000000000, 0.45694444444444448639, -0.08611111111111104111 },
{ /* 71 f= 7100 */ 0.00000000000000000000, 0.46248611111111115335, -0.07502777777777774881 },
{ /* 72 f= 7200 */ 0.00000000000000000000, 0.46799999999999997158, -0.06400000000000001521 },
{ /* 73 f= 7300 */ 0.00000000000000000000, 0.47348611111111110761, -0.05302777777777782642 },
{ /* 74 f= 7400 */ 0.00000000000000000000, 0.47894444444444445041, -0.04211111111111105060 },
{ /* 75 f= 7500 */ 0.00000000000000000000, 0.48437500000000000000, -0.03124999999999997918 },
{ /* 76 f= 7600 */ 0.00000000000000000000, 0.48977777777777775636, -0.02044444444444446299 },
{ /* 77 f= 7700 */ 0.00000000000000000000, 0.49515277777777783053, -0.00969444444444435803 },
{ /* 78 f= 7800 */ 0.00000000000000000000, 0.50050000000000005596, 0.00100000000000004794 },
{ /* 79 f= 7900 */ 0.00000000000000000000, 0.50581944444444448816, 0.01163888888888889826 },
{ /* 80 f= 8000 */ 0.00000000000000000000, 0.51111111111111107164, 0.02222222222222219531 },
{ /* 81 f= 8100 */ 0.00000000000000000000, 0.51637500000000002842, 0.03275000000000007766 },
{ /* 82 f= 8200 */ 0.00000000000000000000, 0.52161111111111113647, 0.04322222222222225907 },
{ /* 83 f= 8300 */ 0.00000000000000000000, 0.52681944444444439579, 0.05363888888888888873 },
{ /* 84 f= 8400 */ 0.00000000000000000000, 0.53200000000000002842, 0.06399999999999995970 },
{ /* 85 f= 8500 */ 0.00000000000000000000, 0.53715277777777781232, 0.07430555555555562464 },
{ /* 86 f= 8600 */ 0.00000000000000000000, 0.54227777777777774748, 0.08455555555555557823 },
{ /* 87 f= 8700 */ 0.00000000000000000000, 0.54737499999999994493, 0.09474999999999998701 },
{ /* 88 f= 8800 */ 0.00000000000000000000, 0.55244444444444440467, 0.10488888888888885098 },
{ /* 89 f= 8900 */ 0.00000000000000000000, 0.55748611111111112670, 0.11497222222222228116 },
{ /* 90 f= 9000 */ 0.00000000000000000000, 0.56250000000000000000, 0.12500000000000002776 },
{ /* 91 f= 9100 */ 0.00000000000000000000, 0.56748611111111113559, 0.13497222222222221566 },
{ /* 92 f= 9200 */ 0.00000000000000000000, 0.57244444444444453346, 0.14488888888888898365 },
{ /* 93 f= 9300 */ 0.00000000000000000000, 0.57737499999999997158, 0.15475000000000005418 },
{ /* 94 f= 9400 */ 0.00000000000000000000, 0.58227777777777778301, 0.16455555555555556602 },
{ /* 95 f= 9500 */ 0.00000000000000000000, 0.58715277777777774570, 0.17430555555555554692 },
{ /* 96 f= 9600 */ 0.00000000000000000000, 0.59200000000000008171, 0.18400000000000008016 },
{ /* 97 f= 9700 */ 0.00000000000000000000, 0.59681944444444445796, 0.19363888888888891593 },
{ /* 98 f= 9800 */ 0.00000000000000000000, 0.60161111111111109651, 0.20322222222222222077 },
{ /* 99 f= 9900 */ 0.00000000000000000000, 0.60637499999999999734, 0.21274999999999996692 },
{ /*100 f=10000 */ 0.00000000000000000000, 0.61111111111111116045, 0.22222222222222229315 },
{ /*101 f=10100 */ 0.00000000000000000000, 0.61581944444444447484, 0.23163888888888892192 },
{ /*102 f=10200 */ 0.00000000000000000000, 0.62050000000000005151, 0.24099999999999999201 },
{ /*103 f=10300 */ 0.00000000000000000000, 0.62515277777777777946, 0.25030555555555550340 },
{ /*104 f=10400 */ 0.00000000000000000000, 0.62977777777777776969, 0.25955555555555559488 },
{ /*105 f=10500 */ 0.00000000000000000000, 0.63437500000000002220, 0.26875000000000004441 },
{ /*106 f=10600 */ 0.00000000000000000000, 0.63894444444444442599, 0.27788888888888885198 },
{ /*107 f=10700 */ 0.00000000000000000000, 0.64348611111111120309, 0.28697222222222229515 },
{ /*108 f=10800 */ 0.00000000000000000000, 0.64800000000000002043, 0.29600000000000004086 },
{ /*109 f=10900 */ 0.00000000000000000000, 0.65248611111111110006, 0.30497222222222225563 },
{ /*110 f=11000 */ 0.00000000000000000000, 0.65694444444444444198, 0.31388888888888888395 },
{ /*111 f=11100 */ 0.00000000000000000000, 0.66137500000000004619, 0.32275000000000009237 },
{ /*112 f=11200 */ 0.00000000000000000000, 0.66577777777777780166, 0.33155555555555560332 },
{ /*113 f=11300 */ 0.00000000000000000000, 0.67015277777777781942, 0.34030555555555558334 },
{ /*114 f=11400 */ 0.00000000000000000000, 0.67449999999999998845, 0.34899999999999997691 },
{ /*115 f=11500 */ 0.00000000000000000000, 0.67881944444444441977, 0.35763888888888895057 },
{ /*116 f=11600 */ 0.00000000000000000000, 0.68311111111111111338, 0.36622222222222222676 },
{ /*117 f=11700 */ 0.00000000000000000000, 0.68737499999999995826, 0.37474999999999997202 },
{ /*118 f=11800 */ 0.00000000000000000000, 0.69161111111111106542, 0.38322222222222218635 },
{ /*119 f=11900 */ 0.00000000000000000000, 0.69581944444444443487, 0.39163888888888892525 },
{ /*120 f=12000 */ 0.00000000000000000000, 0.69999999999999995559, 0.40000000000000002220 },
{ /*121 f=12100 */ 0.00000000000000000000, 0.70415277777777773860, 0.40830555555555553271 },
{ /*122 f=12200 */ 0.00000000000000000000, 0.70827777777777778390, 0.41655555555555551228 },
{ /*123 f=12300 */ 0.00000000000000000000, 0.71237499999999998046, 0.42474999999999996092 },
{ /*124 f=12400 */ 0.00000000000000000000, 0.71644444444444443931, 0.43288888888888898965 },
{ /*125 f=12500 */ 0.00000000000000000000, 0.72048611111111116045, 0.44097222222222232091 },
{ /*126 f=12600 */ 0.00000000000000000000, 0.72450000000000003286, 0.44900000000000006573 },
{ /*127 f=12700 */ 0.00000000000000000000, 0.72848611111111116756, 0.45697222222222227961 },
{ /*128 f=12800 */ 0.00000000000000000000, 0.73244444444444445352, 0.46488888888888890705 },
{ /*129 f=12900 */ 0.00000000000000000000, 0.73637500000000000178, 0.47275000000000000355 },
{ /*130 f=13000 */ 0.00000000000000000000, 0.74027777777777781232, 0.48055555555555551361 },
{ /*131 f=13100 */ 0.00000000000000000000, 0.74415277777777777413, 0.48830555555555549274 },
{ /*132 f=13200 */ 0.00000000000000000000, 0.74799999999999999822, 0.49600000000000010747 },
{ /*133 f=13300 */ 0.00000000000000000000, 0.75181944444444448461, 0.50363888888888896922 },
{ /*134 f=13400 */ 0.00000000000000000000, 0.75561111111111112226, 0.51122222222222224453 },
{ /*135 f=13500 */ 0.00000000000000000000, 0.75937500000000002220, 0.51875000000000004441 },
{ /*136 f=13600 */ 0.00000000000000000000, 0.76311111111111107341, 0.52622222222222225785 },
{ /*137 f=13700 */ 0.00000000000000000000, 0.76681944444444449793, 0.53363888888888888484 },
{ /*138 f=13800 */ 0.00000000000000000000, 0.77049999999999996270, 0.54099999999999992539 },
{ /*139 f=13900 */ 0.00000000000000000000, 0.77415277777777791179, 0.54830555555555571257 },
{ /*140 f=14000 */ 0.00000000000000000000, 0.77777777777777790114, 0.55555555555555569125 },
{ /*141 f=14100 */ 0.00000000000000000000, 0.78137500000000004174, 0.56275000000000008349 },
{ /*142 f=14200 */ 0.00000000000000000000, 0.78494444444444444464, 0.56988888888888888928 },
{ /*143 f=14300 */ 0.00000000000000000000, 0.78848611111111110983, 0.57697222222222221966 },
{ /*144 f=14400 */ 0.00000000000000000000, 0.79200000000000003730, 0.58399999999999996358 },
{ /*145 f=14500 */ 0.00000000000000000000, 0.79548611111111111605, 0.59097222222222223209 },
{ /*146 f=14600 */ 0.00000000000000000000, 0.79894444444444445708, 0.59788888888888880313 },
{ /*147 f=14700 */ 0.00000000000000000000, 0.80237500000000006040, 0.60475000000000012079 },
{ /*148 f=14800 */ 0.00000000000000000000, 0.80577777777777781498, 0.61155555555555562997 },
{ /*149 f=14900 */ 0.00000000000000000000, 0.80915277777777783186, 0.61830555555555555269 },
{ /*150 f=15000 */ 0.00000000000000000000, 0.81250000000000000000, 0.62500000000000000000 },
{ /*151 f=15100 */ 0.00000000000000000000, 0.81581944444444443043, 0.63163888888888886086 },
{ /*152 f=15200 */ 0.00000000000000000000, 0.81911111111111112315, 0.63822222222222224630 },
{ /*153 f=15300 */ 0.00000000000000000000, 0.82237499999999996714, 0.64474999999999993427 },
{ /*154 f=15400 */ 0.00000000000000000000, 0.82561111111111118444, 0.65122222222222236887 },
{ /*155 f=15500 */ 0.00000000000000000000, 0.82881944444444455300, 0.65763888888888899498 },
{ /*156 f=15600 */ 0.00000000000000000000, 0.83200000000000007283, 0.66400000000000003464 },
{ /*157 f=15700 */ 0.00000000000000000000, 0.83515277777777785495, 0.67030555555555559888 },
{ /*158 f=15800 */ 0.00000000000000000000, 0.83827777777777778834, 0.67655555555555557667 },
{ /*159 f=15900 */ 0.00000000000000000000, 0.84137499999999998401, 0.68274999999999996803 },
{ /*160 f=16000 */ 0.00000000000000000000, 0.84444444444444444198, 0.68888888888888888395 },
{ /*161 f=16100 */ 0.00000000000000000000, 0.84748611111111116223, 0.69497222222222221344 },
{ /*162 f=16200 */ 0.00000000000000000000, 0.85050000000000003375, 0.70100000000000006750 },
{ /*163 f=16300 */ 0.00000000000000000000, 0.85348611111111116756, 0.70697222222222233512 },
{ /*164 f=16400 */ 0.00000000000000000000, 0.85644444444444445264, 0.71288888888888890527 },
{ /*165 f=16500 */ 0.00000000000000000000, 0.85937500000000000000, 0.71875000000000000000 },
{ /*166 f=16600 */ 0.00000000000000000000, 0.86227777777777769863, 0.72455555555555550828 },
{ /*167 f=16700 */ 0.00000000000000000000, 0.86515277777777777057, 0.73030555555555554115 },
{ /*168 f=16800 */ 0.00000000000000000000, 0.86799999999999999378, 0.73599999999999998757 },
{ /*169 f=16900 */ 0.00000000000000000000, 0.87081944444444447928, 0.74163888888888895856 },
{ /*170 f=17000 */ 0.00000000000000000000, 0.87361111111111111605, 0.74722222222222234311 },
{ /*171 f=17100 */ 0.00000000000000000000, 0.87637500000000001510, 0.75275000000000003020 },
{ /*172 f=17200 */ 0.00000000000000000000, 0.87911111111111117644, 0.75822222222222224186 },
{ /*173 f=17300 */ 0.00000000000000000000, 0.88181944444444448905, 0.76363888888888886708 },
{ /*174 f=17400 */ 0.00000000000000000000, 0.88450000000000006395, 0.76900000000000001688 },
{ /*175 f=17500 */ 0.00000000000000000000, 0.88715277777777779011, 0.77430555555555558023 },
{ /*176 f=17600 */ 0.00000000000000000000, 0.88977777777777777857, 0.77955555555555555713 },
{ /*177 f=17700 */ 0.00000000000000000000, 0.89237500000000002931, 0.78475000000000005862 },
{ /*178 f=17800 */ 0.00000000000000000000, 0.89494444444444454234, 0.78988888888888897366 },
{ /*179 f=17900 */ 0.00000000000000000000, 0.89748611111111120664, 0.79497222222222230226 },
{ /*180 f=18000 */ 0.00000000000000000000, 0.90000000000000002220, 0.80000000000000004441 },
{ /*181 f=18100 */ 0.00000000000000000000, 0.90248611111111110006, 0.80497222222222220012 },
{ /*182 f=18200 */ 0.00000000000000000000, 0.90494444444444444020, 0.80988888888888888040 },
{ /*183 f=18300 */ 0.00000000000000000000, 0.90737500000000004263, 0.81474999999999997424 },
{ /*184 f=18400 */ 0.00000000000000000000, 0.90977777777777779633, 0.81955555555555559266 },
{ /*185 f=18500 */ 0.00000000000000000000, 0.91215277777777781232, 0.82430555555555562464 },
{ /*186 f=18600 */ 0.00000000000000000000, 0.91450000000000009059, 0.82900000000000007017 },
{ /*187 f=18700 */ 0.00000000000000000000, 0.91681944444444440911, 0.83363888888888892925 },
{ /*188 f=18800 */ 0.00000000000000000000, 0.91911111111111110095, 0.83822222222222220189 },
{ /*189 f=18900 */ 0.00000000000000000000, 0.92137500000000005507, 0.84274999999999999911 },
{ /*190 f=19000 */ 0.00000000000000000000, 0.92361111111111116045, 0.84722222222222220989 },
{ /*191 f=19100 */ 0.00000000000000000000, 0.92581944444444441711, 0.85163888888888883422 },
{ /*192 f=19200 */ 0.00000000000000000000, 0.92800000000000004707, 0.85600000000000009415 },
{ /*193 f=19300 */ 0.00000000000000000000, 0.93015277777777782831, 0.86030555555555554559 },
{ /*194 f=19400 */ 0.00000000000000000000, 0.93227777777777776080, 0.86455555555555563263 },
{ /*195 f=19500 */ 0.00000000000000000000, 0.93437499999999995559, 0.86875000000000002220 },
{ /*196 f=19600 */ 0.00000000000000000000, 0.93644444444444441267, 0.87288888888888893636 },
{ /*197 f=19700 */ 0.00000000000000000000, 0.93848611111111113203, 0.87697222222222215304 },
{ /*198 f=19800 */ 0.00000000000000000000, 0.94050000000000000266, 0.88100000000000000533 },
{ /*199 f=19900 */ 0.00000000000000000000, 0.94248611111111113559, 0.88497222222222227117 },
{ /*200 f=20000 */ 0.00000000000000000000, 0.94444444444444441977, 0.88888888888888895057 },
{ /*201 f=20100 */ 0.00000000000000000000, 0.94637499999999996625, 0.89275000000000004352 },
{ /*202 f=20200 */ 0.00000000000000000000, 0.94827777777777777501, 0.89655555555555555003 },
{ /*203 f=20300 */ 0.00000000000000000000, 0.95015277777777784607, 0.90030555555555558112 },
{ /*204 f=20400 */ 0.00000000000000000000, 0.95199999999999995737, 0.90400000000000002576 },
{ /*205 f=20500 */ 0.00000000000000000000, 0.95381944444444444198, 0.90763888888888888395 },
{ /*206 f=20600 */ 0.00000000000000000000, 0.95561111111111107785, 0.91122222222222215571 },
{ /*207 f=20700 */ 0.00000000000000000000, 0.95737500000000008704, 0.91475000000000006306 },
{ /*208 f=20800 */ 0.00000000000000000000, 0.95911111111111113647, 0.91822222222222227295 },
{ /*209 f=20900 */ 0.00000000000000000000, 0.96081944444444444819, 0.92163888888888889639 },
{ /*210 f=21000 */ 0.00000000000000000000, 0.96250000000000002220, 0.92500000000000004441 },
{ /*211 f=21100 */ 0.00000000000000000000, 0.96415277777777785850, 0.92830555555555560598 },
{ /*212 f=21200 */ 0.00000000000000000000, 0.96577777777777784607, 0.93155555555555558112 },
{ /*213 f=21300 */ 0.00000000000000000000, 0.96737499999999998490, 0.93474999999999996980 },
{ /*214 f=21400 */ 0.00000000000000000000, 0.96894444444444438602, 0.93788888888888888307 },
{ /*215 f=21500 */ 0.00000000000000000000, 0.97048611111111116045, 0.94097222222222220989 },
{ /*216 f=21600 */ 0.00000000000000000000, 0.97199999999999997513, 0.94400000000000006128 },
{ /*217 f=21700 */ 0.00000000000000000000, 0.97348611111111105210, 0.94697222222222221522 },
{ /*218 f=21800 */ 0.00000000000000000000, 0.97494444444444439135, 0.94988888888888889372 },
{ /*219 f=21900 */ 0.00000000000000000000, 0.97637499999999999289, 0.95274999999999998579 },
{ /*220 f=22000 */ 0.00000000000000000000, 0.97777777777777774570, 0.95555555555555549141 },
{ /*221 f=22100 */ 0.00000000000000000000, 0.97915277777777776080, 0.95830555555555552161 },
{ /*222 f=22200 */ 0.00000000000000000000, 0.98050000000000003819, 0.96100000000000007638 },
{ /*223 f=22300 */ 0.00000000000000000000, 0.98181944444444446685, 0.96363888888888893369 },
{ /*224 f=22400 */ 0.00000000000000000000, 0.98311111111111104677, 0.96622222222222220456 },
{ /*225 f=22500 */ 0.00000000000000000000, 0.98437500000000000000, 0.96875000000000000000 },
{ /*226 f=22600 */ 0.00000000000000000000, 0.98561111111111110450, 0.97122222222222220900 },
{ /*227 f=22700 */ 0.00000000000000000000, 0.98681944444444447129, 0.97363888888888883155 },
{ /*228 f=22800 */ 0.00000000000000000000, 0.98799999999999998934, 0.97599999999999997868 },
{ /*229 f=22900 */ 0.00000000000000000000, 0.98915277777777776969, 0.97830555555555553937 },
{ /*230 f=23000 */ 0.00000000000000000000, 0.99027777777777781232, 0.98055555555555562464 },
{ /*231 f=23100 */ 0.00000000000000000000, 0.99137500000000000622, 0.98275000000000001243 },
{ /*232 f=23200 */ 0.00000000000000000000, 0.99244444444444446241, 0.98488888888888892481 },
{ /*233 f=23300 */ 0.00000000000000000000, 0.99348611111111106986, 0.98697222222222225074 },
{ /*234 f=23400 */ 0.00000000000000000000, 0.99449999999999993960, 0.98899999999999999023 },
{ /*235 f=23500 */ 0.00000000000000000000, 0.99548611111111107164, 0.99097222222222225430 },
{ /*236 f=23600 */ 0.00000000000000000000, 0.99644444444444446596, 0.99288888888888882089 },
{ /*237 f=23700 */ 0.00000000000000000000, 0.99737500000000001155, 0.99475000000000002309 },
{ /*238 f=23800 */ 0.00000000000000000000, 0.99827777777777781942, 0.99655555555555552782 },
{ /*239 f=23900 */ 0.00000000000000000000, 0.99915277777777777857, 0.99830555555555555713 },
{ /*240 f=24000 */ 0.00000000000000000000, 1.00000000000000000000, 1.00000000000000000000 }
};
static FLOAT_T moog_q10[241][3] = {
{ /* dummy entry */ 0, 0, 0},
{ /*  1 f=  100 */ 0.81415675793969166651, 0.00748611111111113781, -0.98502777777777772439 },
{ /*  2 f=  200 */ 0.80578246993203150872, 0.01494444444444442688, -0.97011111111111114624 },
{ /*  3 f=  300 */ 0.79752502816859827117, 0.02237499999999997824, -0.95525000000000004352 },
{ /*  4 f=  400 */ 0.78938260254957826056, 0.02977777777777779189, -0.94044444444444441622 },
{ /*  5 f=  500 */ 0.78135339491381039512, 0.03715277777777775681, -0.92569444444444448639 },
{ /*  6 f=  600 */ 0.77343563843714191464, 0.04449999999999998401, -0.91100000000000003197 },
{ /*  7 f=  700 */ 0.76562759704291938334, 0.05181944444444447351, -0.89636111111111105298 },
{ /*  8 f=  800 */ 0.75792756482435363896, 0.05911111111111111427, -0.88177777777777777146 },
{ /*  9 f=  900 */ 0.75033386547850644543, 0.06637500000000001732, -0.86724999999999996536 },
{ /* 10 f= 1000 */ 0.74284485175165437809, 0.07361111111111112715, -0.85277777777777774570 },
{ /* 11 f= 1100 */ 0.73545890489578125138, 0.08081944444444444375, -0.83836111111111111249 },
{ /* 12 f= 1200 */ 0.72817443413596993906, 0.08800000000000002265, -0.82399999999999995470 },
{ /* 13 f= 1300 */ 0.72098987614845799765, 0.09515277777777780832, -0.80969444444444438336 },
{ /* 14 f= 1400 */ 0.71390369454913193970, 0.10227777777777780077, -0.79544444444444439846 },
{ /* 15 f= 1500 */ 0.70691437939224044396, 0.10937500000000000000, -0.78125000000000000000 },
{ /* 16 f= 1600 */ 0.70002044667910767739, 0.11644444444444446152, -0.76711111111111107697 },
{ /* 17 f= 1700 */ 0.69322043787663967240, 0.12348611111111112981, -0.75302777777777774038 },
{ /* 18 f= 1800 */ 0.68651291944541226187, 0.13050000000000000488, -0.73899999999999999023 },
{ /* 19 f= 1900 */ 0.67989648237714284118, 0.13748611111111108674, -0.72502777777777782653 },
{ /* 20 f= 2000 */ 0.67336974174134611726, 0.14444444444444443088, -0.71111111111111113825 },
{ /* 21 f= 2100 */ 0.66693133624098055456, 0.15137499999999998179, -0.69725000000000003642 },
{ /* 22 f= 2200 */ 0.66057992777689977792, 0.15827777777777779500, -0.68344444444444441000 },
{ /* 23 f= 2300 */ 0.65431420102091875091, 0.16515277777777781498, -0.66969444444444437003 },
{ /* 24 f= 2400 */ 0.64813286299732042472, 0.17199999999999998623, -0.65600000000000002753 },
{ /* 25 f= 2500 */ 0.64203464267262078113, 0.17881944444444447528, -0.64236111111111104943 },
{ /* 26 f= 2600 */ 0.63601829055342418151, 0.18561111111111111560, -0.62877777777777776880 },
{ /* 27 f= 2700 */ 0.63008257829219582735, 0.19237500000000001821, -0.61524999999999996358 },
{ /* 28 f= 2800 */ 0.62422629830079023883, 0.19911111111111112759, -0.60177777777777774482 },
{ /* 29 f= 2900 */ 0.61844826337157099427, 0.20581944444444444375, -0.58836111111111111249 },
{ /* 30 f= 3000 */ 0.61274730630596541125, 0.21250000000000002220, -0.57499999999999995559 },
{ /* 31 f= 3100 */ 0.60712227955029984816, 0.21915277777777780743, -0.56169444444444438513 },
{ /* 32 f= 3200 */ 0.60157205483876241559, 0.22577777777777779944, -0.54844444444444440112 },
{ /* 33 f= 3300 */ 0.59609552284334865746, 0.23237499999999999822, -0.53525000000000000355 },
{ /* 34 f= 3400 */ 0.59069159283064220922, 0.23894444444444445930, -0.52211111111111108141 },
{ /* 35 f= 3500 */ 0.58535919232529087797, 0.24548611111111112715, -0.50902777777777774570 },
{ /* 36 f= 3600 */ 0.58009726678004025491, 0.25200000000000000178, -0.49599999999999999645 },
{ /* 37 f= 3700 */ 0.57490477925218708144, 0.25848611111111113869, -0.48302777777777772261 },
{ /* 38 f= 3800 */ 0.56978071008632291683, 0.26494444444444442688, -0.47011111111111114624 },
{ /* 39 f= 3900 */ 0.56472405660323676813, 0.27137500000000003286, -0.45724999999999998979 },
{ /* 40 f= 4000 */ 0.55973383279485067199, 0.27777777777777779011, -0.44444444444444447528 },
{ /* 41 f= 4100 */ 0.55480906902506366141, 0.28415277777777780965, -0.43169444444444443620 },
{ /* 42 f= 4200 */ 0.54994881173638343608, 0.29049999999999998046, -0.41900000000000003908 },
{ /* 43 f= 4300 */ 0.54515212316222738664, 0.29681944444444441356, -0.40636111111111111738 },
{ /* 44 f= 4400 */ 0.54041808104477628838, 0.30311111111111110894, -0.39377777777777778212 },
{ /* 45 f= 4500 */ 0.53574577835826708849, 0.30937500000000001110, -0.38124999999999997780 },
{ /* 46 f= 4600 */ 0.53113432303761398678, 0.31561111111111117555, -0.36877777777777770440 },
{ /* 47 f= 4700 */ 0.52658283771224945191, 0.32181944444444443576, -0.35636111111111112848 },
{ /* 48 f= 4800 */ 0.52209045944507781467, 0.32800000000000001377, -0.34399999999999997247 },
{ /* 49 f= 4900 */ 0.51765633947643874269, 0.33415277777777774304, -0.33169444444444445841 },
{ /* 50 f= 5000 */ 0.51327964297297656859, 0.34027777777777779011, -0.31944444444444441977 },
{ /* 51 f= 5100 */ 0.50895954878131988153, 0.34637499999999998845, -0.30725000000000002309 },
{ /* 52 f= 5200 */ 0.50469524918646746503, 0.35244444444444444908, -0.29511111111111110183 },
{ /* 53 f= 5300 */ 0.50048594967479298479, 0.35848611111111111649, -0.28302777777777776702 },
{ /* 54 f= 5400 */ 0.49633086870156778447, 0.36450000000000004619, -0.27099999999999996314 },
{ /* 55 f= 5500 */ 0.49222923746291596947, 0.37048611111111107164, -0.25902777777777780122 },
{ /* 56 f= 5600 */ 0.48818029967210824216, 0.37644444444444447040, -0.24711111111111108696 },
{ /* 57 f= 5700 */ 0.48418331134011033390, 0.38237500000000002043, -0.23525000000000001465 },
{ /* 58 f= 5800 */ 0.48023754056029765991, 0.38827777777777777724, -0.22344444444444441777 },
{ /* 59 f= 5900 */ 0.47634226729725437366, 0.39415277777777779633, -0.21169444444444446285 },
{ /* 60 f= 6000 */ 0.47249678317957338747, 0.40000000000000002220, -0.19999999999999998335 },
{ /* 61 f= 6100 */ 0.46870039129657825594, 0.40581944444444439934, -0.18836111111111114580 },
{ /* 62 f= 6200 */ 0.46495240599888704169, 0.41161111111111114980, -0.17677777777777770041 },
{ /* 63 f= 6300 */ 0.46125215270274266821, 0.41737500000000005151, -0.16524999999999995248 },
{ /* 64 f= 6400 */ 0.45759896769803365402, 0.42311111111111110450, -0.15377777777777776325 },
{ /* 65 f= 6500 */ 0.45399219795993034365, 0.42881944444444441977, -0.14236111111111113270 },
{ /* 66 f= 6600 */ 0.45043120096406841224, 0.43450000000000005285, -0.13099999999999992206 },
{ /* 67 f= 6700 */ 0.44691534450520364885, 0.44015277777777778168, -0.11969444444444440889 },
{ /* 68 f= 6800 */ 0.44344400651927357027, 0.44577777777777777279, -0.10844444444444444053 },
{ /* 69 f= 6900 */ 0.44001657490879547696, 0.45137499999999997069, -0.09725000000000004474 },
{ /* 70 f= 7000 */ 0.43663244737153578123, 0.45694444444444448639, -0.08611111111111104111 },
{ /* 71 f= 7100 */ 0.43329103123238549289, 0.46248611111111115335, -0.07502777777777774881 },
{ /* 72 f= 7200 */ 0.42999174327837824672, 0.46799999999999997158, -0.06400000000000001521 },
{ /* 73 f= 7300 */ 0.42673400959678964295, 0.47348611111111110761, -0.05302777777777782642 },
{ /* 74 f= 7400 */ 0.42351726541625489553, 0.47894444444444445041, -0.04211111111111105060 },
{ /* 75 f= 7500 */ 0.42034095495084883298, 0.48437500000000000000, -0.03124999999999997918 },
{ /* 76 f= 7600 */ 0.41720453124706535775, 0.48977777777777775636, -0.02044444444444446299 },
{ /* 77 f= 7700 */ 0.41410745603364307321, 0.49515277777777783053, -0.00969444444444435803 },
{ /* 78 f= 7800 */ 0.41104919957418017962, 0.50050000000000005596, 0.00100000000000004794 },
{ /* 79 f= 7900 */ 0.40802924052248196185, 0.50581944444444448816, 0.01163888888888889826 },
{ /* 80 f= 8000 */ 0.40504706578059013200, 0.51111111111111107164, 0.02222222222222219531 },
{ /* 81 f= 8100 */ 0.40210217035943962571, 0.51637500000000002842, 0.03275000000000007766 },
{ /* 82 f= 8200 */ 0.39919405724209261477, 0.52161111111111113647, 0.04322222222222225907 },
{ /* 83 f= 8300 */ 0.39632223724949783294, 0.52681944444444439579, 0.05363888888888888873 },
{ /* 84 f= 8400 */ 0.39348622890872780866, 0.53200000000000002842, 0.06399999999999995970 },
{ /* 85 f= 8500 */ 0.39068555832364537661, 0.53715277777777781232, 0.07430555555555562464 },
{ /* 86 f= 8600 */ 0.38791975904795034102, 0.54227777777777774748, 0.08455555555555557823 },
{ /* 87 f= 8700 */ 0.38518837196056249228, 0.54737499999999994493, 0.09474999999999998701 },
{ /* 88 f= 8800 */ 0.38249094514329462502, 0.55244444444444440467, 0.10488888888888885098 },
{ /* 89 f= 8900 */ 0.37982703376077076030, 0.55748611111111112670, 0.11497222222222228116 },
{ /* 90 f= 9000 */ 0.37719619994254682815, 0.56250000000000000000, 0.12500000000000002776 },
{ /* 91 f= 9100 */ 0.37459801266739045644, 0.56748611111111113559, 0.13497222222222221566 },
{ /* 92 f= 9200 */ 0.37203204764967978679, 0.57244444444444453346, 0.14488888888888898365 },
{ /* 93 f= 9300 */ 0.36949788722787801909, 0.57737499999999997158, 0.15475000000000005418 },
{ /* 94 f= 9400 */ 0.36699512025504593682, 0.58227777777777778301, 0.16455555555555556602 },
{ /* 95 f= 9500 */ 0.36452334199135216775, 0.58715277777777774570, 0.17430555555555554692 },
{ /* 96 f= 9600 */ 0.36208215399854282168, 0.59200000000000008171, 0.18400000000000008016 },
{ /* 97 f= 9700 */ 0.35967116403633397903, 0.59681944444444445796, 0.19363888888888891593 },
{ /* 98 f= 9800 */ 0.35728998596068761717, 0.60161111111111109651, 0.20322222222222222077 },
{ /* 99 f= 9900 */ 0.35493823962393866722, 0.60637499999999999734, 0.21274999999999996692 },
{ /*100 f=10000 */ 0.35261555077673456537, 0.61111111111111116045, 0.22222222222222229315 },
{ /*101 f=10100 */ 0.35032155097175499137, 0.61581944444444447484, 0.23163888888888892192 },
{ /*102 f=10200 */ 0.34805587746917587832, 0.62050000000000005151, 0.24099999999999999201 },
{ /*103 f=10300 */ 0.34581817314384682982, 0.62515277777777777946, 0.25030555555555550340 },
{ /*104 f=10400 */ 0.34360808639414708310, 0.62977777777777776969, 0.25955555555555559488 },
{ /*105 f=10500 */ 0.34142527105249009800, 0.63437500000000002220, 0.26875000000000004441 },
{ /*106 f=10600 */ 0.33926938629744440856, 0.63894444444444442599, 0.27788888888888885198 },
{ /*107 f=10700 */ 0.33714009656744031718, 0.64348611111111120309, 0.28697222222222229515 },
{ /*108 f=10800 */ 0.33503707147603323246, 0.64800000000000002043, 0.29600000000000004086 },
{ /*109 f=10900 */ 0.33295998572869295318, 0.65248611111111110006, 0.30497222222222225563 },
{ /*110 f=11000 */ 0.33090851904109147563, 0.65694444444444444198, 0.31388888888888888395 },
{ /*111 f=11100 */ 0.32888235605886090296, 0.66137500000000004619, 0.32275000000000009237 },
{ /*112 f=11200 */ 0.32688118627879259037, 0.66577777777777780166, 0.33155555555555560332 },
{ /*113 f=11300 */ 0.32490470397145254644, 0.67015277777777781942, 0.34030555555555558334 },
{ /*114 f=11400 */ 0.32295260810518489070, 0.67449999999999998845, 0.34899999999999997691 },
{ /*115 f=11500 */ 0.32102460227147805449, 0.67881944444444441977, 0.35763888888888895057 },
{ /*116 f=11600 */ 0.31912039461166868959, 0.68311111111111111338, 0.36622222222222222676 },
{ /*117 f=11700 */ 0.31723969774495780483, 0.68737499999999995826, 0.37474999999999997202 },
{ /*118 f=11800 */ 0.31538222869771465051, 0.69161111111111106542, 0.38322222222222218635 },
{ /*119 f=11900 */ 0.31354770883404481374, 0.69581944444444443487, 0.39163888888888892525 },
{ /*120 f=12000 */ 0.31173586378759898796, 0.69999999999999995559, 0.40000000000000002220 },
{ /*121 f=12100 */ 0.30994642339459932412, 0.70415277777777773860, 0.40830555555555553271 },
{ /*122 f=12200 */ 0.30817912162806093690, 0.70827777777777778390, 0.41655555555555551228 },
{ /*123 f=12300 */ 0.30643369653318630608, 0.71237499999999998046, 0.42474999999999996092 },
{ /*124 f=12400 */ 0.30470989016391109017, 0.71644444444444443931, 0.43288888888888898965 },
{ /*125 f=12500 */ 0.30300744852058075773, 0.72048611111111116045, 0.44097222222222232091 },
{ /*126 f=12600 */ 0.30132612148873594293, 0.72450000000000003286, 0.44900000000000006573 },
{ /*127 f=12700 */ 0.29966566277898737392, 0.72848611111111116756, 0.45697222222222227961 },
{ /*128 f=12800 */ 0.29802582986796005704, 0.73244444444444445352, 0.46488888888888890705 },
{ /*129 f=12900 */ 0.29640638394028673286, 0.73637500000000000178, 0.47275000000000000355 },
{ /*130 f=13000 */ 0.29480708983163239623, 0.74027777777777781232, 0.48055555555555551361 },
{ /*131 f=13100 */ 0.29322771597273028510, 0.74415277777777777413, 0.48830555555555549274 },
{ /*132 f=13200 */ 0.29166803433441118587, 0.74799999999999999822, 0.49600000000000010747 },
{ /*133 f=13300 */ 0.29012782037360795862, 0.75181944444444448461, 0.50363888888888896922 },
{ /*134 f=13400 */ 0.28860685298031829582, 0.75561111111111112226, 0.51122222222222224453 },
{ /*135 f=13500 */ 0.28710491442550706287, 0.75937500000000002220, 0.51875000000000004441 },
{ /*136 f=13600 */ 0.28562179030993251061, 0.76311111111111107341, 0.52622222222222225785 },
{ /*137 f=13700 */ 0.28415726951387937360, 0.76681944444444449793, 0.53363888888888888484 },
{ /*138 f=13800 */ 0.28271114414778181212, 0.77049999999999996270, 0.54099999999999992539 },
{ /*139 f=13900 */ 0.28128320950372109888, 0.77415277777777791179, 0.54830555555555571257 },
{ /*140 f=14000 */ 0.27987326400778284041, 0.77777777777777790114, 0.55555555555555569125 },
{ /*141 f=14100 */ 0.27848110917325602509, 0.78137500000000004174, 0.56275000000000008349 },
{ /*142 f=14200 */ 0.27710654955466212934, 0.78494444444444444464, 0.56988888888888888928 },
{ /*143 f=14300 */ 0.27574939270259690716, 0.78848611111111110983, 0.57697222222222221966 },
{ /*144 f=14400 */ 0.27440944911937181772, 0.79200000000000003730, 0.58399999999999996358 },
{ /*145 f=14500 */ 0.27308653221543999212, 0.79548611111111111605, 0.59097222222222223209 },
{ /*146 f=14600 */ 0.27178045826659413819, 0.79894444444444445708, 0.59788888888888880313 },
{ /*147 f=14700 */ 0.27049104637192117329, 0.80237500000000006040, 0.60475000000000012079 },
{ /*148 f=14800 */ 0.26921811841250159469, 0.80577777777777781498, 0.61155555555555562997 },
{ /*149 f=14900 */ 0.26796149901083954337, 0.80915277777777783186, 0.61830555555555555269 },
{ /*150 f=15000 */ 0.26672101549101157048, 0.81250000000000000000, 0.62500000000000000000 },
{ /*151 f=15100 */ 0.26549649783952089521, 0.81581944444444443043, 0.63163888888888886086 },
{ /*152 f=15200 */ 0.26428777866684516340, 0.81911111111111112315, 0.63822222222222224630 },
{ /*153 f=15300 */ 0.26309469316966521690, 0.82237499999999996714, 0.64474999999999993427 },
{ /*154 f=15400 */ 0.26191707909376393815, 0.82561111111111118444, 0.65122222222222236887 },
{ /*155 f=15500 */ 0.26075477669758251320, 0.82881944444444455300, 0.65763888888888899498 },
{ /*156 f=15600 */ 0.25960762871642345528, 0.83200000000000007283, 0.66400000000000003464 },
{ /*157 f=15700 */ 0.25847548032728895340, 0.83515277777777785495, 0.67030555555555559888 },
{ /*158 f=15800 */ 0.25735817911434338834, 0.83827777777777778834, 0.67655555555555557667 },
{ /*159 f=15900 */ 0.25625557503499041268, 0.84137499999999998401, 0.68274999999999996803 },
{ /*160 f=16000 */ 0.25516752038655210466, 0.84444444444444444198, 0.68888888888888888395 },
{ /*161 f=16100 */ 0.25409386977354220249, 0.84748611111111116223, 0.69497222222222221344 },
{ /*162 f=16200 */ 0.25303448007552153953, 0.85050000000000003375, 0.70100000000000006750 },
{ /*163 f=16300 */ 0.25198921041552629907, 0.85348611111111116756, 0.70697222222222233512 },
{ /*164 f=16400 */ 0.25095792212906053997, 0.85644444444444445264, 0.71288888888888890527 },
{ /*165 f=16500 */ 0.24994047873364136358, 0.85937500000000000000, 0.71875000000000000000 },
{ /*166 f=16600 */ 0.24893674589888931115, 0.86227777777777769863, 0.72455555555555550828 },
{ /*167 f=16700 */ 0.24794659141715377770, 0.86515277777777777057, 0.73030555555555554115 },
{ /*168 f=16800 */ 0.24696988517466497703, 0.86799999999999999378, 0.73599999999999998757 },
{ /*169 f=16900 */ 0.24600649912320363133, 0.87081944444444447928, 0.74163888888888895856 },
{ /*170 f=17000 */ 0.24505630725227964262, 0.87361111111111111605, 0.74722222222222234311 },
{ /*171 f=17100 */ 0.24411918556181111395, 0.87637500000000001510, 0.75275000000000003020 },
{ /*172 f=17200 */ 0.24319501203529633737, 0.87911111111111117644, 0.75822222222222224186 },
{ /*173 f=17300 */ 0.24228366661346972810, 0.88181944444444448905, 0.76363888888888886708 },
{ /*174 f=17400 */ 0.24138503116843396112, 0.88450000000000006395, 0.76900000000000001688 },
{ /*175 f=17500 */ 0.24049898947826120477, 0.88715277777777779011, 0.77430555555555558023 },
{ /*176 f=17600 */ 0.23962542720205473601, 0.88977777777777777857, 0.77955555555555555713 },
{ /*177 f=17700 */ 0.23876423185546483130, 0.89237500000000002931, 0.78475000000000005862 },
{ /*178 f=17800 */ 0.23791529278664994007, 0.89494444444444454234, 0.78988888888888897366 },
{ /*179 f=17900 */ 0.23707850115267797841, 0.89748611111111120664, 0.79497222222222230226 },
{ /*180 f=18000 */ 0.23625374989635858358, 0.90000000000000002220, 0.80000000000000004441 },
{ /*181 f=18100 */ 0.23544093372350125004, 0.90248611111111110006, 0.80497222222222220012 },
{ /*182 f=18200 */ 0.23463994908059165878, 0.90494444444444444020, 0.80988888888888888040 },
{ /*183 f=18300 */ 0.23385069413287978835, 0.90737500000000004263, 0.81474999999999997424 },
{ /*184 f=18400 */ 0.23307306874287336829, 0.90977777777777779633, 0.81955555555555559266 },
{ /*185 f=18500 */ 0.23230697444923029127, 0.91215277777777781232, 0.82430555555555562464 },
{ /*186 f=18600 */ 0.23155231444604376656, 0.91450000000000009059, 0.82900000000000007017 },
{ /*187 f=18700 */ 0.23080899356251469157, 0.91681944444444440911, 0.83363888888888892925 },
{ /*188 f=18800 */ 0.23007691824300363637, 0.91911111111111110095, 0.83822222222222220189 },
{ /*189 f=18900 */ 0.22935599652745894406, 0.92137500000000005507, 0.84274999999999999911 },
{ /*190 f=19000 */ 0.22864613803221336963, 0.92361111111111116045, 0.84722222222222220989 },
{ /*191 f=19100 */ 0.22794725393114437240, 0.92581944444444441711, 0.85163888888888883422 },
{ /*192 f=19200 */ 0.22725925693719239984, 0.92800000000000004707, 0.85600000000000009415 },
{ /*193 f=19300 */ 0.22658206128423238890, 0.93015277777777782831, 0.86030555555555554559 },
{ /*194 f=19400 */ 0.22591558270929215646, 0.93227777777777776080, 0.86455555555555563263 },
{ /*195 f=19500 */ 0.22525973843511323813, 0.93437499999999995559, 0.86875000000000002220 },
{ /*196 f=19600 */ 0.22461444715304940134, 0.93644444444444441267, 0.87288888888888893636 },
{ /*197 f=19700 */ 0.22397962900629692085, 0.93848611111111113203, 0.87697222222222215304 },
{ /*198 f=19800 */ 0.22335520557345278636, 0.94050000000000000266, 0.88100000000000000533 },
{ /*199 f=19900 */ 0.22274109985239534670, 0.94248611111111113559, 0.88497222222222227117 },
{ /*200 f=20000 */ 0.22213723624448336591, 0.94444444444444441977, 0.88888888888888895057 },
{ /*201 f=20100 */ 0.22154354053906846755, 0.94637499999999996625, 0.89275000000000004352 },
{ /*202 f=20200 */ 0.22095993989831694271, 0.94827777777777777501, 0.89655555555555555003 },
{ /*203 f=20300 */ 0.22038636284233614759, 0.95015277777777784607, 0.90030555555555558112 },
{ /*204 f=20400 */ 0.21982273923460185494, 0.95199999999999995737, 0.90400000000000002576 },
{ /*205 f=20500 */ 0.21926900026768136875, 0.95381944444444444198, 0.90763888888888888395 },
{ /*206 f=20600 */ 0.21872507844924990450, 0.95561111111111107785, 0.91122222222222215571 },
{ /*207 f=20700 */ 0.21819090758839448929, 0.95737500000000008704, 0.91475000000000006306 },
{ /*208 f=20800 */ 0.21766642278220302287, 0.95911111111111113647, 0.91822222222222227295 },
{ /*209 f=20900 */ 0.21715156040263353110, 0.96081944444444444819, 0.92163888888888889639 },
{ /*210 f=21000 */ 0.21664625808366078097, 0.96250000000000002220, 0.92500000000000004441 },
{ /*211 f=21100 */ 0.21615045470869601041, 0.96415277777777785850, 0.92830555555555560598 },
{ /*212 f=21200 */ 0.21566409039827666438, 0.96577777777777784607, 0.93155555555555558112 },
{ /*213 f=21300 */ 0.21518710649802216817, 0.96737499999999998490, 0.93474999999999996980 },
{ /*214 f=21400 */ 0.21471944556685296224, 0.96894444444444438602, 0.93788888888888888307 },
{ /*215 f=21500 */ 0.21426105136546894081, 0.97048611111111116045, 0.94097222222222220989 },
{ /*216 f=21600 */ 0.21381186884508457391, 0.97199999999999997513, 0.94400000000000006128 },
{ /*217 f=21700 */ 0.21337184413641668845, 0.97348611111111105210, 0.94697222222222221522 },
{ /*218 f=21800 */ 0.21294092453892327077, 0.97494444444444439135, 0.94988888888888889372 },
{ /*219 f=21900 */ 0.21251905851028848882, 0.97637499999999999289, 0.95274999999999998579 },
{ /*220 f=22000 */ 0.21210619565615282389, 0.97777777777777774570, 0.95555555555555549141 },
{ /*221 f=22100 */ 0.21170228672008373216, 0.97915277777777776080, 0.95830555555555552161 },
{ /*222 f=22200 */ 0.21130728357378555926, 0.98050000000000003819, 0.96100000000000007638 },
{ /*223 f=22300 */ 0.21092113920754471112, 0.98181944444444446685, 0.96363888888888893369 },
{ /*224 f=22400 */ 0.21054380772090866558, 0.98311111111111104677, 0.96622222222222220456 },
{ /*225 f=22500 */ 0.21017524431359460579, 0.98437500000000000000, 0.96875000000000000000 },
{ /*226 f=22600 */ 0.20981540527662742579, 0.98561111111111110450, 0.97122222222222220900 },
{ /*227 f=22700 */ 0.20946424798370200104, 0.98681944444444447129, 0.97363888888888883155 },
{ /*228 f=22800 */ 0.20912173088276977961, 0.98799999999999998934, 0.97599999999999997868 },
{ /*229 f=22900 */ 0.20878781348784566929, 0.98915277777777776969, 0.97830555555555553937 },
{ /*230 f=23000 */ 0.20846245637103369419, 0.99027777777777781232, 0.98055555555555562464 },
{ /*231 f=23100 */ 0.20814562115476922810, 0.99137500000000000622, 0.98275000000000001243 },
{ /*232 f=23200 */ 0.20783727050427547312, 0.99244444444444446241, 0.98488888888888892481 },
{ /*233 f=23300 */ 0.20753736812023212965, 0.99348611111111106986, 0.98697222222222225074 },
{ /*234 f=23400 */ 0.20724587873165412066, 0.99449999999999993960, 0.98899999999999999023 },
{ /*235 f=23500 */ 0.20696276808897914878, 0.99548611111111107164, 0.99097222222222225430 },
{ /*236 f=23600 */ 0.20668800295736106110, 0.99644444444444446596, 0.99288888888888882089 },
{ /*237 f=23700 */ 0.20642155111016780022, 0.99737500000000001155, 0.99475000000000002309 },
{ /*238 f=23800 */ 0.20616338132268241523, 0.99827777777777781942, 0.99655555555555552782 },
{ /*239 f=23900 */ 0.20591346336600491185, 0.99915277777777777857, 0.99830555555555555713 },
{ /*240 f=24000 */ 0.20567176800115327673, 1.00000000000000000000, 1.00000000000000000000 }
};
static FLOAT_T moog_q20[241][3] = {
{ /* dummy entry */ 0, 0, 0},
{ /*  1 f=  100 */ 1.46086445604384018715, 0.00748611111111113781, -0.98502777777777772439 },
{ /*  2 f=  200 */ 1.44583823464880634191, 0.01494444444444442688, -0.97011111111111114624 },
{ /*  3 f=  300 */ 1.43102167376859146231, 0.02237499999999997824, -0.95525000000000004352 },
{ /*  4 f=  400 */ 1.41641148960343343788, 0.02977777777777779189, -0.94044444444444441622 },
{ /*  5 f=  500 */ 1.40200445566199416447, 0.03715277777777775681, -0.92569444444444448639 },
{ /*  6 f=  600 */ 1.38779740168181642268, 0.04449999999999998401, -0.91100000000000003197 },
{ /*  7 f=  700 */ 1.37378721257154712276, 0.05181944444444447351, -0.89636111111111105298 },
{ /*  8 f=  800 */ 1.35997082737447394507, 0.05911111111111111427, -0.88177777777777777146 },
{ /*  9 f=  900 */ 1.34634523825290930432, 0.06637500000000001732, -0.86724999999999996536 },
{ /* 10 f= 1000 */ 1.33290748949299153736, 0.07361111111111112715, -0.85277777777777774570 },
{ /* 11 f= 1100 */ 1.31965467652945522836, 0.08081944444444444375, -0.83836111111111111249 },
{ /* 12 f= 1200 */ 1.30658394498995589217, 0.08800000000000002265, -0.82399999999999995470 },
{ /* 13 f= 1300 */ 1.29369248975853046169, 0.09515277777777780832, -0.80969444444444438336 },
{ /* 14 f= 1400 */ 1.28097755405778879201, 0.10227777777777780077, -0.79544444444444439846 },
{ /* 15 f= 1500 */ 1.26843642854944094189, 0.10937500000000000000, -0.78125000000000000000 },
{ /* 16 f= 1600 */ 1.25606645045276654749, 0.11644444444444446152, -0.76711111111111107697 },
{ /* 17 f= 1700 */ 1.24386500268065747221, 0.12348611111111112981, -0.75302777777777774038 },
{ /* 18 f= 1800 */ 1.23182951299285359248, 0.13050000000000000488, -0.73899999999999999023 },
{ /* 19 f= 1900 */ 1.21995745316601400532, 0.13748611111111108674, -0.72502777777777782653 },
{ /* 20 f= 2000 */ 1.20824633818026971888, 0.14444444444444443088, -0.71111111111111113825 },
{ /* 21 f= 2100 */ 1.19669372542190721731, 0.15137499999999998179, -0.69725000000000003642 },
{ /* 22 f= 2200 */ 1.18529721390185072138, 0.15827777777777779500, -0.68344444444444441000 },
{ /* 23 f= 2300 */ 1.17405444348960341650, 0.16515277777777781498, -0.66969444444444437003 },
{ /* 24 f= 2400 */ 1.16296309416233301093, 0.17199999999999998623, -0.65600000000000002753 },
{ /* 25 f= 2500 */ 1.15202088526877521879, 0.17881944444444447528, -0.64236111111111104943 },
{ /* 26 f= 2600 */ 1.14122557480765451920, 0.18561111111111111560, -0.62877777777777776880 },
{ /* 27 f= 2700 */ 1.13057495872031066320, 0.19237500000000001821, -0.61524999999999996358 },
{ /* 28 f= 2800 */ 1.12006687019724182619, 0.19911111111111112759, -0.60177777777777774482 },
{ /* 29 f= 2900 */ 1.10969917899826819863, 0.20581944444444444375, -0.58836111111111111249 },
{ /* 30 f= 3000 */ 1.09946979078603890301, 0.21250000000000002220, -0.57499999999999995559 },
{ /* 31 f= 3100 */ 1.08937664647259913053, 0.21915277777777780743, -0.56169444444444438513 },
{ /* 32 f= 3200 */ 1.07941772157875015559, 0.22577777777777779944, -0.54844444444444440112 },
{ /* 33 f= 3300 */ 1.06959102560593422027, 0.23237499999999999822, -0.53525000000000000355 },
{ /* 34 f= 3400 */ 1.05989460142038893764, 0.23894444444444445930, -0.52211111111111108141 },
{ /* 35 f= 3500 */ 1.05032652464931230973, 0.24548611111111112715, -0.50902777777777774570 },
{ /* 36 f= 3600 */ 1.04088490308879322299, 0.25200000000000000178, -0.49599999999999999645 },
{ /* 37 f= 3700 */ 1.03156787612326428238, 0.25848611111111113869, -0.48302777777777772261 },
{ /* 38 f= 3800 */ 1.02237361415623939642, 0.26494444444444442688, -0.47011111111111114624 },
{ /* 39 f= 3900 */ 1.01330031805210274420, 0.27137500000000003286, -0.45724999999999998979 },
{ /* 40 f= 4000 */ 1.00434621858872263900, 0.27777777777777779011, -0.44444444444444447528 },
{ /* 41 f= 4100 */ 0.99550957592066879887, 0.28415277777777780965, -0.43169444444444443620 },
{ /* 42 f= 4200 */ 0.98678867905281164585, 0.29049999999999998046, -0.41900000000000003908 },
{ /* 43 f= 4300 */ 0.97818184532409724330, 0.29681944444444441356, -0.40636111111111111738 },
{ /* 44 f= 4400 */ 0.96968741990128304309, 0.30311111111111110894, -0.39377777777777778212 },
{ /* 45 f= 4500 */ 0.96130377528243549090, 0.30937500000000001110, -0.38124999999999997780 },
{ /* 46 f= 4600 */ 0.95302931080998631863, 0.31561111111111117555, -0.36877777777777770440 },
{ /* 47 f= 4700 */ 0.94486245219315634358, 0.32181944444444443576, -0.35636111111111112848 },
{ /* 48 f= 4800 */ 0.93680165103955226336, 0.32800000000000001377, -0.34399999999999997247 },
{ /* 49 f= 4900 */ 0.92884538439575325963, 0.33415277777777774304, -0.33169444444444445841 },
{ /* 50 f= 5000 */ 0.92099215429670056032, 0.34027777777777779011, -0.31944444444444441977 },
{ /* 51 f= 5100 */ 0.91324048732371665427, 0.34637499999999998845, -0.30725000000000002309 },
{ /* 52 f= 5200 */ 0.90558893417097174883, 0.35244444444444444908, -0.29511111111111110183 },
{ /* 53 f= 5300 */ 0.89803606922023515580, 0.35848611111111111649, -0.28302777777777776702 },
{ /* 54 f= 5400 */ 0.89058049012373596831, 0.36450000000000004619, -0.27099999999999996314 },
{ /* 55 f= 5500 */ 0.88322081739497459996, 0.37048611111111107164, -0.25902777777777780122 },
{ /* 56 f= 5600 */ 0.87595569400732131715, 0.37644444444444447040, -0.24711111111111108696 },
{ /* 57 f= 5700 */ 0.86878378500024744380, 0.38237500000000002043, -0.23525000000000001465 },
{ /* 58 f= 5800 */ 0.86170377709303347391, 0.38827777777777777724, -0.22344444444444441777 },
{ /* 59 f= 5900 */ 0.85471437830580465622, 0.39415277777777779633, -0.21169444444444446285 },
{ /* 60 f= 6000 */ 0.84781431758774650209, 0.40000000000000002220, -0.19999999999999998335 },
{ /* 61 f= 6100 */ 0.84100234445235699798, 0.40581944444444439934, -0.18836111111111114580 },
{ /* 62 f= 6200 */ 0.83427722861959308087, 0.41161111111111114980, -0.17677777777777770041 },
{ /* 63 f= 6300 */ 0.82763775966477448609, 0.41737500000000005151, -0.16524999999999995248 },
{ /* 64 f= 6400 */ 0.82108274667411018655, 0.42311111111111110450, -0.15377777777777776325 },
{ /* 65 f= 6500 */ 0.81461101790671242018, 0.42881944444444441977, -0.14236111111111113270 },
{ /* 66 f= 6600 */ 0.80822142046297418272, 0.43450000000000005285, -0.13099999999999992206 },
{ /* 67 f= 6700 */ 0.80191281995917773617, 0.44015277777777778168, -0.11969444444444440889 },
{ /* 68 f= 6800 */ 0.79568410020821334072, 0.44577777777777777279, -0.10844444444444444053 },
{ /* 69 f= 6900 */ 0.78953416290628719576, 0.45137499999999997069, -0.09725000000000004474 },
{ /* 70 f= 7000 */ 0.78346192732549746474, 0.45694444444444448639, -0.08611111111111104111 },
{ /* 71 f= 7100 */ 0.77746633001216347569, 0.46248611111111115335, -0.07502777777777774881 },
{ /* 72 f= 7200 */ 0.77154632449079463274, 0.46799999999999997158, -0.06400000000000001521 },
{ /* 73 f= 7300 */ 0.76570088097358657286, 0.47348611111111110761, -0.05302777777777782642 },
{ /* 74 f= 7400 */ 0.75992898607533510003, 0.47894444444444445041, -0.04211111111111105060 },
{ /* 75 f= 7500 */ 0.75422964253366364673, 0.48437500000000000000, -0.03124999999999997918 },
{ /* 76 f= 7600 */ 0.74860186893445457290, 0.48977777777777775636, -0.02044444444444446299 },
{ /* 77 f= 7700 */ 0.74304469944238704660, 0.49515277777777783053, -0.00969444444444435803 },
{ /* 78 f= 7800 */ 0.73755718353647992114, 0.50050000000000005596, 0.00100000000000004794 },
{ /* 79 f= 7900 */ 0.73213838575053735713, 0.50581944444444448816, 0.01163888888888889826 },
{ /* 80 f= 8000 */ 0.72678738541840692822, 0.51111111111111107164, 0.02222222222222219531 },
{ /* 81 f= 8100 */ 0.72150327642395251093, 0.51637500000000002842, 0.03275000000000007766 },
{ /* 82 f= 8200 */ 0.71628516695565058736, 0.52161111111111113647, 0.04322222222222225907 },
{ /* 83 f= 8300 */ 0.71113217926571903327, 0.52681944444444439579, 0.05363888888888888873 },
{ /* 84 f= 8400 */ 0.70604344943369123921, 0.53200000000000002842, 0.06399999999999995970 },
{ /* 85 f= 8500 */ 0.70101812713434907831, 0.53715277777777781232, 0.07430555555555562464 },
{ /* 86 f= 8600 */ 0.69605537540992745704, 0.54227777777777774748, 0.08455555555555557823 },
{ /* 87 f= 8700 */ 0.69115437044651040210, 0.54737499999999994493, 0.09474999999999998701 },
{ /* 88 f= 8800 */ 0.68631430135453586061, 0.55244444444444440467, 0.10488888888888885098 },
{ /* 89 f= 8900 */ 0.68153436995333016579, 0.55748611111111112670, 0.11497222222222228116 },
{ /* 90 f= 9000 */ 0.67681379055959367541, 0.56250000000000000000, 0.12500000000000002776 },
{ /* 91 f= 9100 */ 0.67215178977976042241, 0.56748611111111113559, 0.13497222222222221566 },
{ /* 92 f= 9200 */ 0.66754760630616072348, 0.57244444444444453346, 0.14488888888888898365 },
{ /* 93 f= 9300 */ 0.66300049071690769775, 0.57737499999999997158, 0.15475000000000005418 },
{ /* 94 f= 9400 */ 0.65850970527944086008, 0.58227777777777778301, 0.16455555555555556602 },
{ /* 95 f= 9500 */ 0.65407452375765395836, 0.58715277777777774570, 0.17430555555555554692 },
{ /* 96 f= 9600 */ 0.64969423122253966429, 0.59200000000000008171, 0.18400000000000008016 },
{ /* 97 f= 9700 */ 0.64536812386628239491, 0.59681944444444445796, 0.19363888888888891593 },
{ /* 98 f= 9800 */ 0.64109550881973353942, 0.60161111111111109651, 0.20322222222222222077 },
{ /* 99 f= 9900 */ 0.63687570397320492077, 0.60637499999999999734, 0.21274999999999996692 },
{ /*100 f=10000 */ 0.63270803780051776410, 0.61111111111111116045, 0.22222222222222229315 },
{ /*101 f=10100 */ 0.62859184918624311234, 0.61581944444444447484, 0.23163888888888892192 },
{ /*102 f=10200 */ 0.62452648725607373681, 0.62050000000000005151, 0.24099999999999999201 },
{ /*103 f=10300 */ 0.62051131121026992243, 0.62515277777777777946, 0.25030555555555550340 },
{ /*104 f=10400 */ 0.61654569016011695481, 0.62977777777777776969, 0.25955555555555559488 },
{ /*105 f=10500 */ 0.61262900296734168482, 0.63437500000000002220, 0.26875000000000004441 },
{ /*106 f=10600 */ 0.60876063808642733033, 0.63894444444444442599, 0.27788888888888885198 },
{ /*107 f=10700 */ 0.60493999340977577805, 0.64348611111111120309, 0.28697222222222229515 },
{ /*108 f=10800 */ 0.60116647611566209619, 0.64800000000000002043, 0.29600000000000004086 },
{ /*109 f=10900 */ 0.59743950251892696812, 0.65248611111111110006, 0.30497222222222225563 },
{ /*110 f=11000 */ 0.59375849792435853036, 0.65694444444444444198, 0.31388888888888888395 },
{ /*111 f=11100 */ 0.59012289648271110121, 0.66137500000000004619, 0.32275000000000009237 },
{ /*112 f=11200 */ 0.58653214104931161721, 0.66577777777777780166, 0.33155555555555560332 },
{ /*113 f=11300 */ 0.58298568304520526073, 0.67015277777777781942, 0.34030555555555558334 },
{ /*114 f=11400 */ 0.57948298232079287207, 0.67449999999999998845, 0.34899999999999997691 },
{ /*115 f=11500 */ 0.57602350702191418286, 0.67881944444444441977, 0.35763888888888895057 },
{ /*116 f=11600 */ 0.57260673345832979741, 0.68311111111111111338, 0.36622222222222222676 },
{ /*117 f=11700 */ 0.56923214597455873420, 0.68737499999999995826, 0.37474999999999997202 },
{ /*118 f=11800 */ 0.56589923682302634145, 0.69161111111111106542, 0.38322222222222218635 },
{ /*119 f=11900 */ 0.56260750603948084247, 0.69581944444444443487, 0.39163888888888892525 },
{ /*120 f=12000 */ 0.55935646132063587821, 0.69999999999999995559, 0.40000000000000002220 },
{ /*121 f=12100 */ 0.55614561790399752450, 0.70415277777777773860, 0.40830555555555553271 },
{ /*122 f=12200 */ 0.55297449844983626033, 0.70827777777777778390, 0.41655555555555551228 },
{ /*123 f=12300 */ 0.54984263292526336375, 0.71237499999999998046, 0.42474999999999996092 },
{ /*124 f=12400 */ 0.54674955849037354394, 0.71644444444444443931, 0.43288888888888898965 },
{ /*125 f=12500 */ 0.54369481938641539553, 0.72048611111111116045, 0.44097222222222232091 },
{ /*126 f=12600 */ 0.54067796682595337110, 0.72450000000000003286, 0.44900000000000006573 },
{ /*127 f=12700 */ 0.53769855888498319096, 0.72848611111111116756, 0.45697222222222227961 },
{ /*128 f=12800 */ 0.53475616039696594051, 0.73244444444444445352, 0.46488888888888890705 },
{ /*129 f=12900 */ 0.53185034284874610488, 0.73637500000000000178, 0.47275000000000000355 },
{ /*130 f=13000 */ 0.52898068427831823612, 0.74027777777777781232, 0.48055555555555551361 },
{ /*131 f=13100 */ 0.52614676917440927895, 0.74415277777777777413, 0.48830555555555549274 },
{ /*132 f=13200 */ 0.52334818837784302659, 0.74799999999999999822, 0.49600000000000010747 },
{ /*133 f=13300 */ 0.52058453898465506526, 0.75181944444444448461, 0.50363888888888896922 },
{ /*134 f=13400 */ 0.51785542425092567775, 0.75561111111111112226, 0.51122222222222224453 },
{ /*135 f=13500 */ 0.51516045349930028596, 0.75937500000000002220, 0.51875000000000004441 },
{ /*136 f=13600 */ 0.51249924202716667931, 0.76311111111111107341, 0.52622222222222225785 },
{ /*137 f=13700 */ 0.50987141101645905295, 0.76681944444444449793, 0.53363888888888888484 },
{ /*138 f=13800 */ 0.50727658744506043398, 0.77049999999999996270, 0.54099999999999992539 },
{ /*139 f=13900 */ 0.50471440399977318680, 0.77415277777777791179, 0.54830555555555571257 },
{ /*140 f=14000 */ 0.50218449899083150711, 0.77777777777777790114, 0.55555555555555569125 },
{ /*141 f=14100 */ 0.49968651626792637277, 0.78137500000000004174, 0.56275000000000008349 },
{ /*142 f=14200 */ 0.49722010513771774942, 0.78494444444444444464, 0.56988888888888888928 },
{ /*143 f=14300 */ 0.49478492028280651738, 0.78848611111111110983, 0.57697222222222221966 },
{ /*144 f=14400 */ 0.49238062168213997394, 0.79200000000000003730, 0.58399999999999996358 },
{ /*145 f=14500 */ 0.49000687453282665285, 0.79548611111111111605, 0.59097222222222223209 },
{ /*146 f=14600 */ 0.48766334917333431509, 0.79894444444444445708, 0.59788888888888880313 },
{ /*147 f=14700 */ 0.48534972100804746331, 0.80237500000000006040, 0.60475000000000012079 },
{ /*148 f=14800 */ 0.48306567043316023247, 0.80577777777777781498, 0.61155555555555562997 },
{ /*149 f=14900 */ 0.48081088276388045388, 0.80915277777777783186, 0.61830555555555555269 },
{ /*150 f=15000 */ 0.47858504816292390949, 0.81250000000000000000, 0.62500000000000000000 },
{ /*151 f=15100 */ 0.47638786157027324109, 0.81581944444444443043, 0.63163888888888886086 },
{ /*152 f=15200 */ 0.47421902263418291845, 0.81911111111111112315, 0.63822222222222224630 },
{ /*153 f=15300 */ 0.47207823564340456457, 0.82237499999999996714, 0.64474999999999993427 },
{ /*154 f=15400 */ 0.46996520946061559609, 0.82561111111111118444, 0.65122222222222236887 },
{ /*155 f=15500 */ 0.46787965745702742026, 0.82881944444444455300, 0.65763888888888899498 },
{ /*156 f=15600 */ 0.46582129744815325978, 0.83200000000000007283, 0.66400000000000003464 },
{ /*157 f=15700 */ 0.46378985163071712039, 0.83515277777777785495, 0.67030555555555559888 },
{ /*158 f=15800 */ 0.46178504652068241842, 0.83827777777777778834, 0.67655555555555557667 },
{ /*159 f=15900 */ 0.45980661289238217160, 0.84137499999999998401, 0.68274999999999996803 },
{ /*160 f=16000 */ 0.45785428571873182380, 0.84444444444444444198, 0.68888888888888888395 },
{ /*161 f=16100 */ 0.45592780411250527495, 0.84748611111111116223, 0.69497222222222221344 },
{ /*162 f=16200 */ 0.45402691126865801774, 0.85050000000000003375, 0.70100000000000006750 },
{ /*163 f=16300 */ 0.45215135440767673103, 0.85348611111111116756, 0.70697222222222233512 },
{ /*164 f=16400 */ 0.45030088471994156318, 0.85644444444444445264, 0.71288888888888890527 },
{ /*165 f=16500 */ 0.44847525731108012215, 0.85937500000000000000, 0.71875000000000000000 },
{ /*166 f=16600 */ 0.44667423114830029363, 0.86227777777777769863, 0.72455555555555550828 },
{ /*167 f=16700 */ 0.44489756900768201442, 0.86515277777777777057, 0.73030555555555554115 },
{ /*168 f=16800 */ 0.44314503742241484474, 0.86799999999999999378, 0.73599999999999998757 },
{ /*169 f=16900 */ 0.44141640663196385352, 0.87081944444444447928, 0.74163888888888895856 },
{ /*170 f=17000 */ 0.43971145053214916176, 0.87361111111111111605, 0.74722222222222234311 },
{ /*171 f=17100 */ 0.43802994662612299015, 0.87637500000000001510, 0.75275000000000003020 },
{ /*172 f=17200 */ 0.43637167597623160997, 0.87911111111111117644, 0.75822222222222224186 },
{ /*173 f=17300 */ 0.43473642315674521086, 0.88181944444444448905, 0.76363888888888886708 },
{ /*174 f=17400 */ 0.43312397620744269577, 0.88450000000000006395, 0.76900000000000001688 },
{ /*175 f=17500 */ 0.43153412658803774749, 0.88715277777777779011, 0.77430555555555558023 },
{ /*176 f=17600 */ 0.42996666913343128957, 0.88977777777777777857, 0.77955555555555555713 },
{ /*177 f=17700 */ 0.42842140200977901765, 0.89237500000000002931, 0.78475000000000005862 },
{ /*178 f=17800 */ 0.42689812667135762503, 0.89494444444444454234, 0.78988888888888897366 },
{ /*179 f=17900 */ 0.42539664781822134065, 0.89748611111111120664, 0.79497222222222230226 },
{ /*180 f=18000 */ 0.42391677335463090470, 0.90000000000000002220, 0.80000000000000004441 },
{ /*181 f=18100 */ 0.42245831434824770989, 0.90248611111111110006, 0.80497222222222220012 },
{ /*182 f=18200 */ 0.42102108499007750986, 0.90494444444444444020, 0.80988888888888888040 },
{ /*183 f=18300 */ 0.41960490255515331404, 0.90737500000000004263, 0.81474999999999997424 },
{ /*184 f=18400 */ 0.41820958736394570066, 0.90977777777777779633, 0.81955555555555559266 },
{ /*185 f=18500 */ 0.41683496274448872398, 0.91215277777777781232, 0.82430555555555562464 },
{ /*186 f=18600 */ 0.41548085499521081321, 0.91450000000000009059, 0.82900000000000007017 },
{ /*187 f=18700 */ 0.41414709334846028232, 0.91681944444444440911, 0.83363888888888892925 },
{ /*188 f=18800 */ 0.41283350993471196189, 0.91911111111111110095, 0.83822222222222220189 },
{ /*189 f=18900 */ 0.41153993974744912387, 0.92137500000000005507, 0.84274999999999999911 },
{ /*190 f=19000 */ 0.41026622060870576725, 0.92361111111111116045, 0.84722222222222220989 },
{ /*191 f=19100 */ 0.40901219313526249177, 0.92581944444444441711, 0.85163888888888883422 },
{ /*192 f=19200 */ 0.40777770070548413628, 0.92800000000000004707, 0.85600000000000009415 },
{ /*193 f=19300 */ 0.40656258942679113222, 0.93015277777777782831, 0.86030555555555554559 },
{ /*194 f=19400 */ 0.40536670810375347029, 0.93227777777777776080, 0.86455555555555563263 },
{ /*195 f=19500 */ 0.40418990820679945308, 0.93437499999999995559, 0.86875000000000002220 },
{ /*196 f=19600 */ 0.40303204384152957473, 0.93644444444444441267, 0.87288888888888893636 },
{ /*197 f=19700 */ 0.40189297171862642388, 0.93848611111111113203, 0.87697222222222215304 },
{ /*198 f=19800 */ 0.40077255112435256068, 0.94050000000000000266, 0.88100000000000000533 },
{ /*199 f=19900 */ 0.39967064389162715310, 0.94248611111111113559, 0.88497222222222227117 },
{ /*200 f=20000 */ 0.39858711437167404501, 0.94444444444444441977, 0.88888888888888895057 },
{ /*201 f=20100 */ 0.39752182940623165264, 0.94637499999999996625, 0.89275000000000004352 },
{ /*202 f=20200 */ 0.39647465830031852763, 0.94827777777777777501, 0.89655555555555555003 },
{ /*203 f=20300 */ 0.39544547279554542740, 0.95015277777777784607, 0.90030555555555558112 },
{ /*204 f=20400 */ 0.39443414704396673187, 0.95199999999999995737, 0.90400000000000002576 },
{ /*205 f=20500 */ 0.39344055758246343490, 0.95381944444444444198, 0.90763888888888888395 },
{ /*206 f=20600 */ 0.39246458330765171540, 0.95561111111111107785, 0.91122222222222215571 },
{ /*207 f=20700 */ 0.39150610545130770657, 0.95737500000000008704, 0.91475000000000006306 },
{ /*208 f=20800 */ 0.39056500755630391142, 0.95911111111111113647, 0.91822222222222227295 },
{ /*209 f=20900 */ 0.38964117545304827184, 0.96081944444444444819, 0.92163888888888889639 },
{ /*210 f=21000 */ 0.38873449723642095055, 0.96250000000000002220, 0.92500000000000004441 },
{ /*211 f=21100 */ 0.38784486324320138761, 0.96415277777777785850, 0.92830555555555560598 },
{ /*212 f=21200 */ 0.38697216602997924761, 0.96577777777777784607, 0.93155555555555558112 },
{ /*213 f=21300 */ 0.38611630035154370644, 0.96737499999999998490, 0.93474999999999996980 },
{ /*214 f=21400 */ 0.38527716313974391671, 0.96894444444444438602, 0.93788888888888888307 },
{ /*215 f=21500 */ 0.38445465348281604445, 0.97048611111111116045, 0.94097222222222220989 },
{ /*216 f=21600 */ 0.38364867260516999359, 0.97199999999999997513, 0.94400000000000006128 },
{ /*217 f=21700 */ 0.38285912384763010063, 0.97348611111111105210, 0.94697222222222221522 },
{ /*218 f=21800 */ 0.38208591264812608035, 0.97494444444444439135, 0.94988888888888889372 },
{ /*219 f=21900 */ 0.38132894652282545156, 0.97637499999999999289, 0.95274999999999998579 },
{ /*220 f=22000 */ 0.38058813504770622194, 0.97777777777777774570, 0.95555555555555549141 },
{ /*221 f=22100 */ 0.37986338984056083889, 0.97915277777777776080, 0.95830555555555552161 },
{ /*222 f=22200 */ 0.37915462454342968579, 0.98050000000000003819, 0.96100000000000007638 },
{ /*223 f=22300 */ 0.37846175480545640735, 0.98181944444444446685, 0.96363888888888893369 },
{ /*224 f=22400 */ 0.37778469826616323246, 0.98311111111111104677, 0.96622222222222220456 },
{ /*225 f=22500 */ 0.37712337453913796770, 0.98437500000000000000, 0.96875000000000000000 },
{ /*226 f=22600 */ 0.37647770519613243945, 0.98561111111111110450, 0.97122222222222220900 },
{ /*227 f=22700 */ 0.37584761375156405805, 0.98681944444444447129, 0.97363888888888883155 },
{ /*228 f=22800 */ 0.37523302564741894960, 0.98799999999999998934, 0.97599999999999997868 },
{ /*229 f=22900 */ 0.37463386823855115981, 0.98915277777777776969, 0.97830555555555553937 },
{ /*230 f=23000 */ 0.37405007077837365559, 0.99027777777777781232, 0.98055555555555562464 },
{ /*231 f=23100 */ 0.37348156440493890385, 0.99137500000000000622, 0.98275000000000001243 },
{ /*232 f=23200 */ 0.37292828212740275484, 0.99244444444444446241, 0.98488888888888892481 },
{ /*233 f=23300 */ 0.37239015881287002019, 0.99348611111111106986, 0.98697222222222225074 },
{ /*234 f=23400 */ 0.37186713117361636094, 0.99449999999999993960, 0.98899999999999999023 },
{ /*235 f=23500 */ 0.37135913775468537557, 0.99548611111111107164, 0.99097222222222225430 },
{ /*236 f=23600 */ 0.37086611892185411543, 0.99644444444444446596, 0.99288888888888882089 },
{ /*237 f=23700 */ 0.37038801684996702779, 0.99737500000000001155, 0.99475000000000002309 },
{ /*238 f=23800 */ 0.36992477551163288618, 0.99827777777777781942, 0.99655555555555552782 },
{ /*239 f=23900 */ 0.36947634066628293192, 0.99915277777777777857, 0.99830555555555555713 },
{ /*240 f=24000 */ 0.36904265984958639635, 1.00000000000000000000, 1.00000000000000000000 }
};
static FLOAT_T moog_q30[241][3] = {
{ /* dummy entry */ 0, 0, 0},
{ /*  1 f=  100 */ 1.97456263849895252704, 0.00748611111111113781, -0.98502777777777772439 },
{ /*  2 f=  200 */ 1.95425259861695166386, 0.01494444444444442688, -0.97011111111111114624 },
{ /*  3 f=  300 */ 1.93422594424523408563, 0.02237499999999997824, -0.95525000000000004352 },
{ /*  4 f=  400 */ 1.91447823686912665941, 0.02977777777777779189, -0.94044444444444441622 },
{ /*  5 f=  500 */ 1.89500511543430794070, 0.03715277777777775681, -0.92569444444444448639 },
{ /*  6 f=  600 */ 1.87580229488765248824, 0.04449999999999998401, -0.91100000000000003197 },
{ /*  7 f=  700 */ 1.85686556474750052992, 0.05181944444444447351, -0.89636111111111105298 },
{ /*  8 f=  800 */ 1.83819078770272836820, 0.05911111111111111427, -0.88177777777777777146 },
{ /*  9 f=  900 */ 1.81977389824000623797, 0.06637500000000001732, -0.86724999999999996536 },
{ /* 10 f= 1000 */ 1.80161090129864387421, 0.07361111111111112715, -0.85277777777777774570 },
{ /* 11 f= 1100 */ 1.78369787095243359509, 0.08081944444444444375, -0.83836111111111111249 },
{ /* 12 f= 1200 */ 1.76603094911792002364, 0.08800000000000002265, -0.82399999999999995470 },
{ /* 13 f= 1300 */ 1.74860634428853778388, 0.09515277777777780832, -0.80969444444444438336 },
{ /* 14 f= 1400 */ 1.73142033029406250400, 0.10227777777777780077, -0.79544444444444439846 },
{ /* 15 f= 1500 */ 1.71446924508484954686, 0.10937500000000000000, -0.78125000000000000000 },
{ /* 16 f= 1600 */ 1.69774948954032089965, 0.11644444444444446152, -0.76711111111111107697 },
{ /* 17 f= 1700 */ 1.68125752630120706144, 0.12348611111111112981, -0.75302777777777774038 },
{ /* 18 f= 1800 */ 1.66498987862502612067, 0.13050000000000000488, -0.73899999999999999023 },
{ /* 19 f= 1900 */ 1.64894312926431885202, 0.13748611111111108674, -0.72502777777777782653 },
{ /* 20 f= 2000 */ 1.63311391936716043816, 0.14444444444444443088, -0.71111111111111113825 },
{ /* 21 f= 2100 */ 1.61749894739947763789, 0.15137499999999998179, -0.69725000000000003642 },
{ /* 22 f= 2200 */ 1.60209496808871576512, 0.15827777777777779500, -0.68344444444444441000 },
{ /* 23 f= 2300 */ 1.58689879138840539419, 0.16515277777777781498, -0.66969444444444437003 },
{ /* 24 f= 2400 */ 1.57190728146319491643, 0.17199999999999998623, -0.65600000000000002753 },
{ /* 25 f= 2500 */ 1.55711735569391351852, 0.17881944444444447528, -0.64236111111111104943 },
{ /* 26 f= 2600 */ 1.54252598370225602054, 0.18561111111111111560, -0.62877777777777776880 },
{ /* 27 f= 2700 */ 1.52813018639466946524, 0.19237500000000001821, -0.61524999999999996358 },
{ /* 28 f= 2800 */ 1.51392703502504710755, 0.19911111111111112759, -0.60177777777777774482 },
{ /* 29 f= 2900 */ 1.49991365027583722913, 0.20581944444444444375, -0.58836111111111111249 },
{ /* 30 f= 3000 */ 1.48608720135718175293, 0.21250000000000002220, -0.57499999999999995559 },
{ /* 31 f= 3100 */ 1.47244490512371251079, 0.21915277777777780743, -0.56169444444444438513 },
{ /* 32 f= 3200 */ 1.45898402520863457177, 0.22577777777777779944, -0.54844444444444440112 },
{ /* 33 f= 3300 */ 1.44570187117474358018, 0.23237499999999999822, -0.53525000000000000355 },
{ /* 34 f= 3400 */ 1.43259579768202227612, 0.23894444444444445930, -0.52211111111111108141 },
{ /* 35 f= 3500 */ 1.41966320367147247339, 0.24548611111111112715, -0.50902777777777774570 },
{ /* 36 f= 3600 */ 1.40690153156485253660, 0.25200000000000000178, -0.49599999999999999645 },
{ /* 37 f= 3700 */ 1.39430826647998507006, 0.25848611111111113869, -0.48302777777777772261 },
{ /* 38 f= 3800 */ 1.38188093546131973710, 0.26494444444444442688, -0.47011111111111114624 },
{ /* 39 f= 3900 */ 1.36961710672543279799, 0.27137500000000003286, -0.45724999999999998979 },
{ /* 40 f= 4000 */ 1.35751438892115805501, 0.27777777777777779011, -0.44444444444444447528 },
{ /* 41 f= 4100 */ 1.34557043040405033274, 0.28415277777777780965, -0.43169444444444443620 },
{ /* 42 f= 4200 */ 1.33378291852488084501, 0.29049999999999998046, -0.41900000000000003908 },
{ /* 43 f= 4300 */ 1.32214957893188711502, 0.29681944444444441356, -0.40636111111111111738 },
{ /* 44 f= 4400 */ 1.31066817488648590384, 0.30311111111111110894, -0.39377777777777778212 },
{ /* 45 f= 4500 */ 1.29933650659218091761, 0.30937500000000001110, -0.38124999999999997780 },
{ /* 46 f= 4600 */ 1.28815241053638995794, 0.31561111111111117555, -0.36877777777777770440 },
{ /* 47 f= 4700 */ 1.27711375884493438804, 0.32181944444444443576, -0.35636111111111112848 },
{ /* 48 f= 4800 */ 1.26621845864892601519, 0.32800000000000001377, -0.34399999999999997247 },
{ /* 49 f= 4900 */ 1.25546445146380669655, 0.33415277777777774304, -0.33169444444444445841 },
{ /* 50 f= 5000 */ 1.24484971258028398466, 0.34027777777777779011, -0.31944444444444441977 },
{ /* 51 f= 5100 */ 1.23437225046693299646, 0.34637499999999998845, -0.30725000000000002309 },
{ /* 52 f= 5200 */ 1.22403010618421559386, 0.35244444444444444908, -0.29511111111111110183 },
{ /* 53 f= 5300 */ 1.21382135280969638558, 0.35848611111111111649, -0.28302777777777776702 },
{ /* 54 f= 5400 */ 1.20374409487422151521, 0.36450000000000004619, -0.27099999999999996314 },
{ /* 55 f= 5500 */ 1.19379646780884240975, 0.37048611111111107164, -0.25902777777777780122 },
{ /* 56 f= 5600 */ 1.18397663740226666285, 0.37644444444444447040, -0.24711111111111108696 },
{ /* 57 f= 5700 */ 1.17428279926862311200, 0.38237500000000002043, -0.23525000000000001465 },
{ /* 58 f= 5800 */ 1.16471317832533527437, 0.38827777777777777724, -0.22344444444444441777 },
{ /* 59 f= 5900 */ 1.15526602828089774988, 0.39415277777777779633, -0.21169444444444446285 },
{ /* 60 f= 6000 */ 1.14593963113235686180, 0.40000000000000002220, -0.19999999999999998335 },
{ /* 61 f= 6100 */ 1.13673229667230413220, 0.40581944444444439934, -0.18836111111111114580 },
{ /* 62 f= 6200 */ 1.12764236200518630504, 0.41161111111111114980, -0.17677777777777770041 },
{ /* 63 f= 6300 */ 1.11866819107274961809, 0.41737500000000005151, -0.16524999999999995248 },
{ /* 64 f= 6400 */ 1.10980817418843669131, 0.42311111111111110450, -0.15377777777777776325 },
{ /* 65 f= 6500 */ 1.10106072758055018035, 0.42881944444444441977, -0.14236111111111113270 },
{ /* 66 f= 6600 */ 1.09242429294401932616, 0.43450000000000005285, -0.13099999999999992206 },
{ /* 67 f= 6700 */ 1.08389733700058688015, 0.44015277777777778168, -0.11969444444444440889 },
{ /* 68 f= 6800 */ 1.07547835106725697685, 0.44577777777777777279, -0.10844444444444444053 },
{ /* 69 f= 6900 */ 1.06716585063283608825, 0.45137499999999997069, -0.09725000000000004474 },
{ /* 70 f= 7000 */ 1.05895837494240718790, 0.45694444444444448639, -0.08611111111111104111 },
{ /* 71 f= 7100 */ 1.05085448658957925083, 0.46248611111111115335, -0.07502777777777774881 },
{ /* 72 f= 7200 */ 1.04285277111635976688, 0.46799999999999997158, -0.06400000000000001521 },
{ /* 73 f= 7300 */ 1.03495183662049816675, 0.47348611111111110761, -0.05302777777777782642 },
{ /* 74 f= 7400 */ 1.02715031337015205715, 0.47894444444444445041, -0.04211111111111105060 },
{ /* 75 f= 7500 */ 1.01944685342573615472, 0.48437500000000000000, -0.03124999999999997918 },
{ /* 76 f= 7600 */ 1.01184013026880315067, 0.48977777777777775636, -0.02044444444444446299 },
{ /* 77 f= 7700 */ 1.00432883843782883027, 0.49515277777777783053, -0.00969444444444435803 },
{ /* 78 f= 7800 */ 0.99691169317076122613, 0.50050000000000005596, 0.00100000000000004794 },
{ /* 79 f= 7900 */ 0.98958743005419602667, 0.50581944444444448816, 0.01163888888888889826 },
{ /* 80 f= 8000 */ 0.98235480467905778035, 0.51111111111111107164, 0.02222222222222219531 },
{ /* 81 f= 8100 */ 0.97521259230265311402, 0.51637500000000002842, 0.03275000000000007766 },
{ /* 82 f= 8200 */ 0.96815958751697339668, 0.52161111111111113647, 0.04322222222222225907 },
{ /* 83 f= 8300 */ 0.96119460392312339181, 0.52681944444444439579, 0.05363888888888888873 },
{ /* 84 f= 8400 */ 0.95431647381175899181, 0.53200000000000002842, 0.06399999999999995970 },
{ /* 85 f= 8500 */ 0.94752404784941568483, 0.53715277777777781232, 0.07430555555555562464 },
{ /* 86 f= 8600 */ 0.94081619477061162460, 0.54227777777777774748, 0.08455555555555557823 },
{ /* 87 f= 8700 */ 0.93419180107561516913, 0.54737499999999994493, 0.09474999999999998701 },
{ /* 88 f= 8800 */ 0.92764977073376686523, 0.55244444444444440467, 0.10488888888888885098 },
{ /* 89 f= 8900 */ 0.92118902489224752106, 0.55748611111111112670, 0.11497222222222228116 },
{ /* 90 f= 9000 */ 0.91480850159018667345, 0.56250000000000000000, 0.12500000000000002776 },
{ /* 91 f= 9100 */ 0.90850715547800808825, 0.56748611111111113559, 0.13497222222222221566 },
{ /* 92 f= 9200 */ 0.90228395754191470512, 0.57244444444444453346, 0.14488888888888898365 },
{ /* 93 f= 9300 */ 0.89613789483340722253, 0.57737499999999997158, 0.15475000000000005418 },
{ /* 94 f= 9400 */ 0.89006797020374583962, 0.58227777777777778301, 0.16455555555555556602 },
{ /* 95 f= 9500 */ 0.88407320204325712254, 0.58715277777777774570, 0.17430555555555554692 },
{ /* 96 f= 9600 */ 0.87815262402539273623, 0.59200000000000008171, 0.18400000000000008016 },
{ /* 97 f= 9700 */ 0.87230528485545089090, 0.59681944444444445796, 0.19363888888888891593 },
{ /* 98 f= 9800 */ 0.86653024802386768854, 0.60161111111111109651, 0.20322222222222222077 },
{ /* 99 f= 9900 */ 0.86082659156399554679, 0.60637499999999999734, 0.21274999999999996692 },
{ /*100 f=10000 */ 0.85519340781427943821, 0.61111111111111116045, 0.22222222222222229315 },
{ /*101 f=10100 */ 0.84962980318474923269, 0.61581944444444447484, 0.23163888888888892192 },
{ /*102 f=10200 */ 0.84413489792774332177, 0.62050000000000005151, 0.24099999999999999201 },
{ /*103 f=10300 */ 0.83870782591278680851, 0.62515277777777777946, 0.25030555555555550340 },
{ /*104 f=10400 */ 0.83334773440554166246, 0.62977777777777776969, 0.25955555555555559488 },
{ /*105 f=10500 */ 0.82805378385075489867, 0.63437500000000002220, 0.26875000000000004441 },
{ /*106 f=10600 */ 0.82282514765912606602, 0.63894444444444442599, 0.27788888888888885198 },
{ /*107 f=10700 */ 0.81766101199802154742, 0.64348611111111120309, 0.28697222222222229515 },
{ /*108 f=10800 */ 0.81256057558596406221, 0.64800000000000002043, 0.29600000000000004086 },
{ /*109 f=10900 */ 0.80752304949082276408, 0.65248611111111110006, 0.30497222222222225563 },
{ /*110 f=11000 */ 0.80254765693163809814, 0.65694444444444444198, 0.31388888888888888395 },
{ /*111 f=11100 */ 0.79763363308401136198, 0.66137500000000004619, 0.32275000000000009237 },
{ /*112 f=11200 */ 0.79278022488899058118, 0.66577777777777780166, 0.33155555555555560332 },
{ /*113 f=11300 */ 0.78798669086539052664, 0.67015277777777781942, 0.34030555555555558334 },
{ /*114 f=11400 */ 0.78325230092547937222, 0.67449999999999998845, 0.34899999999999997691 },
{ /*115 f=11500 */ 0.77857633619397048630, 0.67881944444444441977, 0.35763888888888895057 },
{ /*116 f=11600 */ 0.77395808883025873914, 0.68311111111111111338, 0.36622222222222222676 },
{ /*117 f=11700 */ 0.76939686185383848738, 0.68737499999999995826, 0.37474999999999997202 },
{ /*118 f=11800 */ 0.76489196897284583709, 0.69161111111111106542, 0.38322222222222218635 },
{ /*119 f=11900 */ 0.76044273441566612171, 0.69581944444444443487, 0.39163888888888892525 },
{ /*120 f=12000 */ 0.75604849276555097237, 0.69999999999999995559, 0.40000000000000002220 },
{ /*121 f=12100 */ 0.75170858879818791554, 0.70415277777777773860, 0.40830555555555553271 },
{ /*122 f=12200 */ 0.74742237732216842971, 0.70827777777777778390, 0.41655555555555551228 },
{ /*123 f=12300 */ 0.74318922302230172594, 0.71237499999999998046, 0.42474999999999996092 },
{ /*124 f=12400 */ 0.73900850030571962890, 0.71644444444444443931, 0.43288888888888898965 },
{ /*125 f=12500 */ 0.73487959315072448607, 0.72048611111111116045, 0.44097222222222232091 },
{ /*126 f=12600 */ 0.73080189495832659219, 0.72450000000000003286, 0.44900000000000006573 },
{ /*127 f=12700 */ 0.72677480840642394444, 0.72848611111111116756, 0.45697222222222227961 },
{ /*128 f=12800 */ 0.72279774530657370235, 0.73244444444444445352, 0.46488888888888890705 },
{ /*129 f=12900 */ 0.71887012646331172050, 0.73637500000000000178, 0.47275000000000000355 },
{ /*130 f=13000 */ 0.71499138153596908385, 0.74027777777777781232, 0.48055555555555551361 },
{ /*131 f=13100 */ 0.71116094890294423436, 0.74415277777777777413, 0.48830555555555549274 },
{ /*132 f=13200 */ 0.70737827552838272727, 0.74799999999999999822, 0.49600000000000010747 },
{ /*133 f=13300 */ 0.70364281683122387179, 0.75181944444444448461, 0.50363888888888896922 },
{ /*134 f=13400 */ 0.69995403655656884823, 0.75561111111111112226, 0.51122222222222224453 },
{ /*135 f=13500 */ 0.69631140664933044437, 0.75937500000000002220, 0.51875000000000004441 },
{ /*136 f=13600 */ 0.69271440713012089052, 0.76311111111111107341, 0.52622222222222225785 },
{ /*137 f=13700 */ 0.68916252597334060059, 0.76681944444444449793, 0.53363888888888888484 },
{ /*138 f=13800 */ 0.68565525898742507582, 0.77049999999999996270, 0.54099999999999992539 },
{ /*139 f=13900 */ 0.68219210969721266746, 0.77415277777777791179, 0.54830555555555571257 },
{ /*140 f=14000 */ 0.67877258922839667221, 0.77777777777777790114, 0.55555555555555569125 },
{ /*141 f=14100 */ 0.67539621619402101516, 0.78137500000000004174, 0.56275000000000008349 },
{ /*142 f=14200 */ 0.67206251658298621354, 0.78494444444444444464, 0.56988888888888888928 },
{ /*143 f=14300 */ 0.66877102365052898403, 0.78848611111111110983, 0.57697222222222221966 },
{ /*144 f=14400 */ 0.66552127781063918910, 0.79200000000000003730, 0.58399999999999996358 },
{ /*145 f=14500 */ 0.66231282653038103803, 0.79548611111111111605, 0.59097222222222223209 },
{ /*146 f=14600 */ 0.65914522422608512464, 0.79894444444444445708, 0.59788888888888880313 },
{ /*147 f=14700 */ 0.65601803216137710706, 0.80237500000000006040, 0.60475000000000012079 },
{ /*148 f=14800 */ 0.65293081834701138799, 0.80577777777777781498, 0.61155555555555562997 },
{ /*149 f=14900 */ 0.64988315744247748817, 0.80915277777777783186, 0.61830555555555555269 },
{ /*150 f=15000 */ 0.64687463065934991402, 0.81250000000000000000, 0.62500000000000000000 },
{ /*151 f=15100 */ 0.64390482566634743566, 0.81581944444444443043, 0.63163888888888886086 },
{ /*152 f=15200 */ 0.64097333649607679540, 0.81911111111111112315, 0.63822222222222224630 },
{ /*153 f=15300 */ 0.63807976345342576341, 0.82237499999999996714, 0.64474999999999993427 },
{ /*154 f=15400 */ 0.63522371302558244821, 0.82561111111111118444, 0.65122222222222236887 },
{ /*155 f=15500 */ 0.63240479779364922042, 0.82881944444444455300, 0.65763888888888899498 },
{ /*156 f=15600 */ 0.62962263634582393834, 0.83200000000000007283, 0.66400000000000003464 },
{ /*157 f=15700 */ 0.62687685319212393953, 0.83515277777777785495, 0.67030555555555559888 },
{ /*158 f=15800 */ 0.62416707868062226705, 0.83827777777777778834, 0.67655555555555557667 },
{ /*159 f=15900 */ 0.62149294891517448125, 0.84137499999999998401, 0.68274999999999996803 },
{ /*160 f=16000 */ 0.61885410567460730213, 0.84444444444444444198, 0.68888888888888888395 },
{ /*161 f=16100 */ 0.61625019633334510161, 0.84748611111111116223, 0.69497222222222221344 },
{ /*162 f=16200 */ 0.61368087378345193006, 0.85050000000000003375, 0.70100000000000006750 },
{ /*163 f=16300 */ 0.61114579635806021152, 0.85348611111111116756, 0.70697222222222233512 },
{ /*164 f=16400 */ 0.60864462775616823276, 0.85644444444444445264, 0.71288888888888890527 },
{ /*165 f=16500 */ 0.60617703696877955899, 0.85937500000000000000, 0.71875000000000000000 },
{ /*166 f=16600 */ 0.60374269820636294881, 0.86227777777777769863, 0.72455555555555550828 },
{ /*167 f=16700 */ 0.60134129082761078600, 0.86515277777777777057, 0.73030555555555554115 },
{ /*168 f=16800 */ 0.59897249926947460086, 0.86799999999999999378, 0.73599999999999998757 },
{ /*169 f=16900 */ 0.59663601297845547666, 0.87081944444444447928, 0.74163888888888895856 },
{ /*170 f=17000 */ 0.59433152634313002327, 0.87361111111111111605, 0.74722222222222234311 },
{ /*171 f=17100 */ 0.59205873862788860329, 0.87637500000000001510, 0.75275000000000003020 },
{ /*172 f=17200 */ 0.58981735390787004558, 0.87911111111111117644, 0.75822222222222224186 },
{ /*173 f=17300 */ 0.58760708100506964247, 0.88181944444444448905, 0.76363888888888886708 },
{ /*174 f=17400 */ 0.58542763342560255602, 0.88450000000000006395, 0.76900000000000001688 },
{ /*175 f=17500 */ 0.58327872929810375968, 0.88715277777777779011, 0.77430555555555558023 },
{ /*176 f=17600 */ 0.58116009131324641857, 0.88977777777777777857, 0.77955555555555555713 },
{ /*177 f=17700 */ 0.57907144666435983460, 0.89237500000000002931, 0.78475000000000005862 },
{ /*178 f=17800 */ 0.57701252698912919303, 0.89494444444444454234, 0.78988888888888897366 },
{ /*179 f=17900 */ 0.57498306831236178915, 0.89748611111111120664, 0.79497222222222230226 },
{ /*180 f=18000 */ 0.57298281098979841897, 0.90000000000000002220, 0.80000000000000004441 },
{ /*181 f=18100 */ 0.57101149965295794342, 0.90248611111111110006, 0.80497222222222220012 },
{ /*182 f=18200 */ 0.56906888315499615238, 0.90494444444444444020, 0.80988888888888888040 },
{ /*183 f=18300 */ 0.56715471451756316323, 0.90737500000000004263, 0.81474999999999997424 },
{ /*184 f=18400 */ 0.56526875087864358882, 0.90977777777777779633, 0.81955555555555559266 },
{ /*185 f=18500 */ 0.56341075344136515302, 0.91215277777777781232, 0.82430555555555562464 },
{ /*186 f=18600 */ 0.56158048742375887841, 0.91450000000000009059, 0.82900000000000007017 },
{ /*187 f=18700 */ 0.55977772200945852266, 0.91681944444444440911, 0.83363888888888892925 },
{ /*188 f=18800 */ 0.55800223029932183305, 0.91911111111111110095, 0.83822222222222220189 },
{ /*189 f=18900 */ 0.55625378926396218393, 0.92137500000000005507, 0.84274999999999999911 },
{ /*190 f=19000 */ 0.55453217969717549796, 0.92361111111111116045, 0.84722222222222220989 },
{ /*191 f=19100 */ 0.55283718617024835140, 0.92581944444444441711, 0.85163888888888883422 },
{ /*192 f=19200 */ 0.55116859698713449589, 0.92800000000000004707, 0.85600000000000009415 },
{ /*193 f=19300 */ 0.54952620414048847231, 0.93015277777777782831, 0.86030555555555554559 },
{ /*194 f=19400 */ 0.54790980326853921945, 0.93227777777777776080, 0.86455555555555563263 },
{ /*195 f=19500 */ 0.54631919361279646097, 0.93437499999999995559, 0.86875000000000002220 },
{ /*196 f=19600 */ 0.54475417797657332830, 0.93644444444444441267, 0.87288888888888893636 },
{ /*197 f=19700 */ 0.54321456268431600467, 0.93848611111111113203, 0.87697222222222215304 },
{ /*198 f=19800 */ 0.54170015754172717859, 0.94050000000000000266, 0.88100000000000000533 },
{ /*199 f=19900 */ 0.54021077579667231561, 0.94248611111111113559, 0.88497222222222227117 },
{ /*200 f=20000 */ 0.53874623410085731301, 0.94444444444444441977, 0.88888888888888895057 },
{ /*201 f=20100 */ 0.53730635247226765649, 0.94637499999999996625, 0.89275000000000004352 },
{ /*202 f=20200 */ 0.53589095425835586717, 0.94827777777777777501, 0.89655555555555555003 },
{ /*203 f=20300 */ 0.53449986609996980036, 0.95015277777777784607, 0.90030555555555558112 },
{ /*204 f=20400 */ 0.53313291789600913972, 0.95199999999999995737, 0.90400000000000002576 },
{ /*205 f=20500 */ 0.53178994276880009462, 0.95381944444444444198, 0.90763888888888888395 },
{ /*206 f=20600 */ 0.53047077703018097328, 0.95561111111111107785, 0.91122222222222215571 },
{ /*207 f=20700 */ 0.52917526014828586423, 0.95737500000000008704, 0.91475000000000006306 },
{ /*208 f=20800 */ 0.52790323471501809927, 0.95911111111111113647, 0.91822222222222227295 },
{ /*209 f=20900 */ 0.52665454641420583748, 0.96081944444444444819, 0.92163888888888889639 },
{ /*210 f=21000 */ 0.52542904399042766883, 0.96250000000000002220, 0.92500000000000004441 },
{ /*211 f=21100 */ 0.52422657921850268625, 0.96415277777777785850, 0.92830555555555560598 },
{ /*212 f=21200 */ 0.52304700687363425704, 0.96577777777777784607, 0.93155555555555558112 },
{ /*213 f=21300 */ 0.52189018470219961099, 0.96737499999999998490, 0.93474999999999996980 },
{ /*214 f=21400 */ 0.52075597339317702961, 0.96894444444444438602, 0.93788888888888888307 },
{ /*215 f=21500 */ 0.51964423655020353099, 0.97048611111111116045, 0.94097222222222220989 },
{ /*216 f=21600 */ 0.51855484066425372447, 0.97199999999999997513, 0.94400000000000006128 },
{ /*217 f=21700 */ 0.51748765508693228554, 0.97348611111111105210, 0.94697222222222221522 },
{ /*218 f=21800 */ 0.51644255200437516606, 0.97494444444444439135, 0.94988888888888889372 },
{ /*219 f=21900 */ 0.51541940641174721627, 0.97637499999999999289, 0.95274999999999998579 },
{ /*220 f=22000 */ 0.51441809608833566347, 0.97777777777777774570, 0.95555555555555549141 },
{ /*221 f=22100 */ 0.51343850157322512562, 0.97915277777777776080, 0.95830555555555552161 },
{ /*222 f=22200 */ 0.51248050614155460369, 0.98050000000000003819, 0.96100000000000007638 },
{ /*223 f=22300 */ 0.51154399578134401860, 0.98181944444444446685, 0.96363888888888893369 },
{ /*224 f=22400 */ 0.51062885917088796095, 0.98311111111111104677, 0.96622222222222220456 },
{ /*225 f=22500 */ 0.50973498765670699484, 0.98437500000000000000, 0.96875000000000000000 },
{ /*226 f=22600 */ 0.50886227523205440626, 0.98561111111111110450, 0.97122222222222220900 },
{ /*227 f=22700 */ 0.50801061851596740482, 0.98681944444444447129, 0.97363888888888883155 },
{ /*228 f=22800 */ 0.50717991673286200172, 0.98799999999999998934, 0.97599999999999997868 },
{ /*229 f=22900 */ 0.50637007169266290418, 0.98915277777777776969, 0.97830555555555553937 },
{ /*230 f=23000 */ 0.50558098777146276426, 0.99027777777777781232, 0.98055555555555562464 },
{ /*231 f=23100 */ 0.50481257189270778429, 0.99137500000000000622, 0.98275000000000001243 },
{ /*232 f=23200 */ 0.50406473350890246277, 0.99244444444444446241, 0.98488888888888892481 },
{ /*233 f=23300 */ 0.50333738458382892844, 0.99348611111111106986, 0.98697222222222225074 },
{ /*234 f=23400 */ 0.50263043957527608896, 0.99449999999999993960, 0.98899999999999999023 },
{ /*235 f=23500 */ 0.50194381541827459703, 0.99548611111111107164, 0.99097222222222225430 },
{ /*236 f=23600 */ 0.50127743150883152801, 0.99644444444444446596, 0.99288888888888882089 },
{ /*237 f=23700 */ 0.50063120968816121614, 0.99737500000000001155, 0.99475000000000002309 },
{ /*238 f=23800 */ 0.50000507422740803065, 0.99827777777777781942, 0.99655555555555552782 },
{ /*239 f=23900 */ 0.49939895181285709480, 0.99915277777777777857, 0.99830555555555555713 },
{ /*240 f=24000 */ 0.49881277153162706384, 1.00000000000000000000, 1.00000000000000000000 }
};
static FLOAT_T moog_q40[241][3] = {
{ /* dummy entry */ 0, 0, 0},
{ /*  1 f=  100 */ 2.38260760754954237228, 0.00748611111111113781, -0.98502777777777772439 },
{ /*  2 f=  200 */ 2.35810048147058637369, 0.01494444444444442688, -0.97011111111111114624 },
{ /*  3 f=  300 */ 2.33393530274721472395, 0.02237499999999997824, -0.95525000000000004352 },
{ /*  4 f=  400 */ 2.31010671564210046114, 0.02977777777777779189, -0.94044444444444441622 },
{ /*  5 f=  500 */ 2.28660945788551428492, 0.03715277777777775681, -0.92569444444444448639 },
{ /*  6 f=  600 */ 2.26343835891462985543, 0.04449999999999998401, -0.91100000000000003197 },
{ /*  7 f=  700 */ 2.24058833814834112985, 0.05181944444444447351, -0.89636111111111105298 },
{ /*  8 f=  800 */ 2.21805440329682879153, 0.05911111111111111427, -0.88177777777777777146 },
{ /*  9 f=  900 */ 2.19583164870513947164, 0.06637500000000001732, -0.86724999999999996536 },
{ /* 10 f= 1000 */ 2.17391525373005478627, 0.07361111111111112715, -0.85277777777777774570 },
{ /* 11 f= 1100 */ 2.15230048114953476102, 0.08081944444444444375, -0.83836111111111111249 },
{ /* 12 f= 1200 */ 2.13098267560405219001, 0.08800000000000002265, -0.82399999999999995470 },
{ /* 13 f= 1300 */ 2.10995726206913847278, 0.09515277777777780832, -0.80969444444444438336 },
{ /* 14 f= 1400 */ 2.08921974435847346285, 0.10227777777777780077, -0.79544444444444439846 },
{ /* 15 f= 1500 */ 2.06876570365688605690, 0.10937500000000000000, -0.78125000000000000000 },
{ /* 16 f= 1600 */ 2.04859079708261493380, 0.11644444444444446152, -0.76711111111111107697 },
{ /* 17 f= 1700 */ 2.02869075627823169938, 0.12348611111111112981, -0.75302777777777774038 },
{ /* 18 f= 1800 */ 2.00906138602960337991, 0.13050000000000000488, -0.73899999999999999023 },
{ /* 19 f= 1900 */ 1.98969856291231472767, 0.13748611111111108674, -0.72502777777777782653 },
{ /* 20 f= 2000 */ 1.97059823396496969217, 0.14444444444444443088, -0.71111111111111113825 },
{ /* 21 f= 2100 */ 1.95175641538880317860, 0.15137499999999998179, -0.69725000000000003642 },
{ /* 22 f= 2200 */ 1.93316919127305797410, 0.15827777777777779500, -0.68344444444444441000 },
{ /* 23 f= 2300 */ 1.91483271234557728135, 0.16515277777777781498, -0.66969444444444437003 },
{ /* 24 f= 2400 */ 1.89674319474809327524, 0.17199999999999998623, -0.65600000000000002753 },
{ /* 25 f= 2500 */ 1.87889691883568632491, 0.17881944444444447528, -0.64236111111111104943 },
{ /* 26 f= 2600 */ 1.86129022799991883375, 0.18561111111111111560, -0.62877777777777776880 },
{ /* 27 f= 2700 */ 1.84391952751514143216, 0.19237500000000001821, -0.61524999999999996358 },
{ /* 28 f= 2800 */ 1.82678128340749190706, 0.19911111111111112759, -0.60177777777777774482 },
{ /* 29 f= 2900 */ 1.80987202134611302462, 0.20581944444444444375, -0.58836111111111111249 },
{ /* 30 f= 3000 */ 1.79318832555612961421, 0.21250000000000002220, -0.57499999999999995559 },
{ /* 31 f= 3100 */ 1.77672683775292772346, 0.21915277777777780743, -0.56169444444444438513 },
{ /* 32 f= 3200 */ 1.76048425609729775054, 0.22577777777777779944, -0.54844444444444440112 },
{ /* 33 f= 3300 */ 1.74445733417100701246, 0.23237499999999999822, -0.53525000000000000355 },
{ /* 34 f= 3400 */ 1.72864287997238030847, 0.23894444444444445930, -0.52211111111111108141 },
{ /* 35 f= 3500 */ 1.71303775493147014686, 0.24548611111111112715, -0.50902777777777774570 },
{ /* 36 f= 3600 */ 1.69763887294441895293, 0.25200000000000000178, -0.49599999999999999645 },
{ /* 37 f= 3700 */ 1.68244319942661024747, 0.25848611111111113869, -0.48302777777777772261 },
{ /* 38 f= 3800 */ 1.66744775038422532454, 0.26494444444444442688, -0.47011111111111114624 },
{ /* 39 f= 3900 */ 1.65264959150382528819, 0.27137500000000003286, -0.45724999999999998979 },
{ /* 40 f= 4000 */ 1.63804583725958896601, 0.27777777777777779011, -0.44444444444444447528 },
{ /* 41 f= 4100 */ 1.62363365003784010376, 0.28415277777777780965, -0.43169444444444443620 },
{ /* 42 f= 4200 */ 1.60941023927851367681, 0.29049999999999998046, -0.41900000000000003908 },
{ /* 43 f= 4300 */ 1.59537286063321270824, 0.29681944444444441356, -0.40636111111111111738 },
{ /* 44 f= 4400 */ 1.58151881513951364511, 0.30311111111111110894, -0.39377777777777778212 },
{ /* 45 f= 4500 */ 1.56784544841119166669, 0.30937500000000001110, -0.38124999999999997780 },
{ /* 46 f= 4600 */ 1.55435014984403685467, 0.31561111111111117555, -0.36877777777777770440 },
{ /* 47 f= 4700 */ 1.54103035183694747623, 0.32181944444444443576, -0.35636111111111112848 },
{ /* 48 f= 4800 */ 1.52788352902798396649, 0.32800000000000001377, -0.34399999999999997247 },
{ /* 49 f= 4900 */ 1.51490719754508607053, 0.33415277777777774304, -0.33169444444444445841 },
{ /* 50 f= 5000 */ 1.50209891427114583529, 0.34027777777777779011, -0.31944444444444441977 },
{ /* 51 f= 5100 */ 1.48945627612315623090, 0.34637499999999998845, -0.30725000000000002309 },
{ /* 52 f= 5200 */ 1.47697691934513586354, 0.35244444444444444908, -0.29511111111111110183 },
{ /* 53 f= 5300 */ 1.46465851881456732286, 0.35848611111111111649, -0.28302777777777776702 },
{ /* 54 f= 5400 */ 1.45249878736205983998, 0.36450000000000004619, -0.27099999999999996314 },
{ /* 55 f= 5500 */ 1.44049547510398179284, 0.37048611111111107164, -0.25902777777777780122 },
{ /* 56 f= 5600 */ 1.42864636878779016627, 0.37644444444444447040, -0.24711111111111108696 },
{ /* 57 f= 5700 */ 1.41694929114981227336, 0.38237500000000002043, -0.23525000000000001465 },
{ /* 58 f= 5800 */ 1.40540210028521861396, 0.38827777777777777724, -0.22344444444444441777 },
{ /* 59 f= 5900 */ 1.39400268902994928233, 0.39415277777777779633, -0.21169444444444446285 },
{ /* 60 f= 6000 */ 1.38274898435434878685, 0.40000000000000002220, -0.19999999999999998335 },
{ /* 61 f= 6100 */ 1.37163894676827813335, 0.40581944444444439934, -0.18836111111111114580 },
{ /* 62 f= 6200 */ 1.36067056973746991488, 0.41161111111111114980, -0.17677777777777770041 },
{ /* 63 f= 6300 */ 1.34984187911090769418, 0.41737500000000005151, -0.16524999999999995248 },
{ /* 64 f= 6400 */ 1.33915093255900252700, 0.42311111111111110450, -0.15377777777777776325 },
{ /* 65 f= 6500 */ 1.32859581902235235340, 0.42881944444444441977, -0.14236111111111113270 },
{ /* 66 f= 6600 */ 1.31817465817088130819, 0.43450000000000005285, -0.13099999999999992206 },
{ /* 67 f= 6700 */ 1.30788559987313779409, 0.44015277777777778168, -0.11969444444444440889 },
{ /* 68 f= 6800 */ 1.29772682367556257965, 0.44577777777777777279, -0.10844444444444444053 },
{ /* 69 f= 6900 */ 1.28769653829152153079, 0.45137499999999997069, -0.09725000000000004474 },
{ /* 70 f= 7000 */ 1.27779298109990979704, 0.45694444444444448639, -0.08611111111111104111 },
{ /* 71 f= 7100 */ 1.26801441765314160115, 0.46248611111111115335, -0.07502777777777774881 },
{ /* 72 f= 7200 */ 1.25835914119433400771, 0.46799999999999997158, -0.06400000000000001521 },
{ /* 73 f= 7300 */ 1.24882547218350903329, 0.47348611111111110761, -0.05302777777777782642 },
{ /* 74 f= 7400 */ 1.23941175783262913512, 0.47894444444444445041, -0.04211111111111105060 },
{ /* 75 f= 7500 */ 1.23011637164930109911, 0.48437500000000000000, -0.03124999999999997918 },
{ /* 76 f= 7600 */ 1.22093771298896647259, 0.48977777777777775636, -0.02044444444444446299 },
{ /* 77 f= 7700 */ 1.21187420661541889189, 0.49515277777777783053, -0.00969444444444435803 },
{ /* 78 f= 7800 */ 1.20292430226948754424, 0.50050000000000005596, 0.00100000000000004794 },
{ /* 79 f= 7900 */ 1.19408647424571379148, 0.50581944444444448816, 0.01163888888888889826 },
{ /* 80 f= 8000 */ 1.18535922097687840271, 0.51111111111111107164, 0.02222222222222219531 },
{ /* 81 f= 8100 */ 1.17674106462621819169, 0.51637500000000002842, 0.03275000000000007766 },
{ /* 82 f= 8200 */ 1.16823055068718262284, 0.52161111111111113647, 0.04322222222222225907 },
{ /* 83 f= 8300 */ 1.15982624759058405850, 0.52681944444444439579, 0.05363888888888888873 },
{ /* 84 f= 8400 */ 1.15152674631899598623, 0.53200000000000002842, 0.06399999999999995970 },
{ /* 85 f= 8500 */ 1.14333066002826222451, 0.53715277777777781232, 0.07430555555555562464 },
{ /* 86 f= 8600 */ 1.13523662367597277800, 0.54227777777777774748, 0.08455555555555557823 },
{ /* 87 f= 8700 */ 1.12724329365677400361, 0.54737499999999994493, 0.09474999999999998701 },
{ /* 88 f= 8800 */ 1.11934934744438296939, 0.55244444444444440467, 0.10488888888888885098 },
{ /* 89 f= 8900 */ 1.11155348324017122508, 0.55748611111111112670, 0.11497222222222228116 },
{ /* 90 f= 9000 */ 1.10385441962819386141, 0.56250000000000000000, 0.12500000000000002776 },
{ /* 91 f= 9100 */ 1.09625089523653795887, 0.56748611111111113559, 0.13497222222222221566 },
{ /* 92 f= 9200 */ 1.08874166840487118790, 0.57244444444444453346, 0.14488888888888898365 },
{ /* 93 f= 9300 */ 1.08132551685806665986, 0.57737499999999997158, 0.15475000000000005418 },
{ /* 94 f= 9400 */ 1.07400123738578945343, 0.58227777777777778301, 0.16455555555555556602 },
{ /* 95 f= 9500 */ 1.06676764552793179597, 0.58715277777777774570, 0.17430555555555554692 },
{ /* 96 f= 9600 */ 1.05962357526578099254, 0.59200000000000008171, 0.18400000000000008016 },
{ /* 97 f= 9700 */ 1.05256787871881440921, 0.59681944444444445796, 0.19363888888888891593 },
{ /* 98 f= 9800 */ 1.04559942584700849011, 0.60161111111111109651, 0.20322222222222222077 },
{ /* 99 f= 9900 */ 1.03871710415856055576, 0.60637499999999999734, 0.21274999999999996692 },
{ /*100 f=10000 */ 1.03191981842291968796, 0.61111111111111116045, 0.22222222222222229315 },
{ /*101 f=10100 */ 1.02520649038902478267, 0.61581944444444447484, 0.23163888888888892192 },
{ /*102 f=10200 */ 1.01857605850864696428, 0.62050000000000005151, 0.24099999999999999201 },
{ /*103 f=10300 */ 1.01202747766474709934, 0.62515277777777777946, 0.25030555555555550340 },
{ /*104 f=10400 */ 1.00555971890474538100, 0.62977777777777776969, 0.25955555555555559488 },
{ /*105 f=10500 */ 0.99917176917861527663, 0.63437500000000002220, 0.26875000000000004441 },
{ /*106 f=10600 */ 0.99286263108170791369, 0.63894444444444442599, 0.27788888888888885198 },
{ /*107 f=10700 */ 0.98663132260221653169, 0.64348611111111120309, 0.28697222222222229515 },
{ /*108 f=10800 */ 0.98047687687319728944, 0.64800000000000002043, 0.29600000000000004086 },
{ /*109 f=10900 */ 0.97439834192905527832, 0.65248611111111110006, 0.30497222222222225563 },
{ /*110 f=11000 */ 0.96839478046641647158, 0.65694444444444444198, 0.31388888888888888395 },
{ /*111 f=11100 */ 0.96246526960930034456, 0.66137500000000004619, 0.32275000000000009237 },
{ /*112 f=11200 */ 0.95660890067851245266, 0.66577777777777780166, 0.33155555555555560332 },
{ /*113 f=11300 */ 0.95082477896517991756, 0.67015277777777781942, 0.34030555555555558334 },
{ /*114 f=11400 */ 0.94511202350834944141, 0.67449999999999998845, 0.34899999999999997691 },
{ /*115 f=11500 */ 0.93946976687657424154, 0.67881944444444441977, 0.35763888888888895057 },
{ /*116 f=11600 */ 0.93389715495341429907, 0.68311111111111111338, 0.36622222222222222676 },
{ /*117 f=11700 */ 0.92839334672677820137, 0.68737499999999995826, 0.37474999999999997202 },
{ /*118 f=11800 */ 0.92295751408203197119, 0.69161111111111106542, 0.38322222222222218635 },
{ /*119 f=11900 */ 0.91758884159880937936, 0.69581944444444443487, 0.39163888888888892525 },
{ /*120 f=12000 */ 0.91228652635145190963, 0.69999999999999995559, 0.40000000000000002220 },
{ /*121 f=12100 */ 0.90704977771301187328, 0.70415277777777773860, 0.40830555555555553271 },
{ /*122 f=12200 */ 0.90187781716275383648, 0.70827777777777778390, 0.41655555555555551228 },
{ /*123 f=12300 */ 0.89676987809708763599, 0.71237499999999998046, 0.42474999999999996092 },
{ /*124 f=12400 */ 0.89172520564387247610, 0.71644444444444443931, 0.43288888888888898965 },
{ /*125 f=12500 */ 0.88674305648002738067, 0.72048611111111116045, 0.44097222222222232091 },
{ /*126 f=12600 */ 0.88182269865239037987, 0.72450000000000003286, 0.44900000000000006573 },
{ /*127 f=12700 */ 0.87696341140176259366, 0.72848611111111116756, 0.45697222222222227961 },
{ /*128 f=12800 */ 0.87216448499008336626, 0.73244444444444445352, 0.46488888888888890705 },
{ /*129 f=12900 */ 0.86742522053067638854, 0.73637500000000000178, 0.47275000000000000355 },
{ /*130 f=13000 */ 0.86274492982151151921, 0.74027777777777781232, 0.48055555555555551361 },
{ /*131 f=13100 */ 0.85812293518142801485, 0.74415277777777777413, 0.48830555555555549274 },
{ /*132 f=13200 */ 0.85355856928926432392, 0.74799999999999999822, 0.49600000000000010747 },
{ /*133 f=13300 */ 0.84905117502584226408, 0.75181944444444448461, 0.50363888888888896922 },
{ /*134 f=13400 */ 0.84460010531875373552, 0.75561111111111112226, 0.51122222222222224453 },
{ /*135 f=13500 */ 0.84020472298989956617, 0.75937500000000002220, 0.51875000000000004441 },
{ /*136 f=13600 */ 0.83586440060573075073, 0.76311111111111107341, 0.52622222222222225785 },
{ /*137 f=13700 */ 0.83157852033014223458, 0.76681944444444449793, 0.53363888888888888484 },
{ /*138 f=13800 */ 0.82734647377997450057, 0.77049999999999996270, 0.54099999999999992539 },
{ /*139 f=13900 */ 0.82316766188307122221, 0.77415277777777791179, 0.54830555555555571257 },
{ /*140 f=14000 */ 0.81904149473885445865, 0.77777777777777790114, 0.55555555555555569125 },
{ /*141 f=14100 */ 0.81496739148136343456, 0.78137500000000004174, 0.56275000000000008349 },
{ /*142 f=14200 */ 0.81094478014472104466, 0.78494444444444444464, 0.56988888888888888928 },
{ /*143 f=14300 */ 0.80697309753098045437, 0.78848611111111110983, 0.57697222222222221966 },
{ /*144 f=14400 */ 0.80305178908031005225, 0.79200000000000003730, 0.58399999999999996358 },
{ /*145 f=14500 */ 0.79918030874347634196, 0.79548611111111111605, 0.59097222222222223209 },
{ /*146 f=14600 */ 0.79535811885658369569, 0.79894444444444445708, 0.59788888888888880313 },
{ /*147 f=14700 */ 0.79158469001803033471, 0.80237500000000006040, 0.60475000000000012079 },
{ /*148 f=14800 */ 0.78785950096764323369, 0.80577777777777781498, 0.61155555555555562997 },
{ /*149 f=14900 */ 0.78418203846795075940, 0.80915277777777783186, 0.61830555555555555269 },
{ /*150 f=15000 */ 0.78055179718755984819, 0.81250000000000000000, 0.62500000000000000000 },
{ /*151 f=15100 */ 0.77696827958659619995, 0.81581944444444443043, 0.63163888888888886086 },
{ /*152 f=15200 */ 0.77343099580417562500, 0.81911111111111112315, 0.63822222222222224630 },
{ /*153 f=15300 */ 0.76993946354786724218, 0.82237499999999996714, 0.64474999999999993427 },
{ /*154 f=15400 */ 0.76649320798511755282, 0.82561111111111118444, 0.65122222222222236887 },
{ /*155 f=15500 */ 0.76309176163659997449, 0.82881944444444455300, 0.65763888888888899498 },
{ /*156 f=15600 */ 0.75973466427145452950, 0.83200000000000007283, 0.66400000000000003464 },
{ /*157 f=15700 */ 0.75642146280438926631, 0.83515277777777785495, 0.67030555555555559888 },
{ /*158 f=15800 */ 0.75315171119460710969, 0.83827777777777778834, 0.67655555555555557667 },
{ /*159 f=15900 */ 0.74992497034653049504, 0.84137499999999998401, 0.68274999999999996803 },
{ /*160 f=16000 */ 0.74674080801229025806, 0.84444444444444444198, 0.68888888888888888395 },
{ /*161 f=16100 */ 0.74359879869595035817, 0.84748611111111116223, 0.69497222222222221344 },
{ /*162 f=16200 */ 0.74049852355943823756, 0.85050000000000003375, 0.70100000000000006750 },
{ /*163 f=16300 */ 0.73743957033015139491, 0.85348611111111116756, 0.70697222222222233512 },
{ /*164 f=16400 */ 0.73442153321021375056, 0.85644444444444445264, 0.71288888888888890527 },
{ /*165 f=16500 */ 0.73144401278735149408, 0.85937500000000000000, 0.71875000000000000000 },
{ /*166 f=16600 */ 0.72850661594736276783, 0.86227777777777769863, 0.72455555555555550828 },
{ /*167 f=16700 */ 0.72560895578815409745, 0.86515277777777777057, 0.73030555555555554115 },
{ /*168 f=16800 */ 0.72275065153531714568, 0.86799999999999999378, 0.73599999999999998757 },
{ /*169 f=16900 */ 0.71993132845922114260, 0.87081944444444447928, 0.74163888888888895856 },
{ /*170 f=17000 */ 0.71715061779359401406, 0.87361111111111111605, 0.74722222222222234311 },
{ /*171 f=17100 */ 0.71440815665556911540, 0.87637500000000001510, 0.75275000000000003020 },
{ /*172 f=17200 */ 0.71170358796717281269, 0.87911111111111117644, 0.75822222222222224186 },
{ /*173 f=17300 */ 0.70903656037822970770, 0.88181944444444448905, 0.76363888888888886708 },
{ /*174 f=17400 */ 0.70640672819066174792, 0.88450000000000006395, 0.76900000000000001688 },
{ /*175 f=17500 */ 0.70381375128415779585, 0.88715277777777779011, 0.77430555555555558023 },
{ /*176 f=17600 */ 0.70125729504319400665, 0.88977777777777777857, 0.77955555555555555713 },
{ /*177 f=17700 */ 0.69873703028538014514, 0.89237500000000002931, 0.78475000000000005862 },
{ /*178 f=17800 */ 0.69625263319111163618, 0.89494444444444454234, 0.78988888888888897366 },
{ /*179 f=17900 */ 0.69380378523450836337, 0.89748611111111120664, 0.79497222222222230226 },
{ /*180 f=18000 */ 0.69139017311561445922, 0.90000000000000002220, 0.80000000000000004441 },
{ /*181 f=18100 */ 0.68901148869384531981, 0.90248611111111110006, 0.80497222222222220012 },
{ /*182 f=18200 */ 0.68666742892265797416, 0.90494444444444444020, 0.80988888888888888040 },
{ /*183 f=18300 */ 0.68435769578542626768, 0.90737500000000004263, 0.81474999999999997424 },
{ /*184 f=18400 */ 0.68208199623250276300, 0.90977777777777779633, 0.81955555555555559266 },
{ /*185 f=18500 */ 0.67984004211944792928, 0.91215277777777781232, 0.82430555555555562464 },
{ /*186 f=18600 */ 0.67763155014640863438, 0.91450000000000009059, 0.82900000000000007017 },
{ /*187 f=18700 */ 0.67545624179862973069, 0.91681944444444440911, 0.83363888888888892925 },
{ /*188 f=18800 */ 0.67331384328807719619, 0.91911111111111110095, 0.83822222222222220189 },
{ /*189 f=18900 */ 0.67120408549616106253, 0.92137500000000005507, 0.84274999999999999911 },
{ /*190 f=19000 */ 0.66912670391753747978, 0.92361111111111116045, 0.84722222222222220989 },
{ /*191 f=19100 */ 0.66708143860497493005, 0.92581944444444441711, 0.85163888888888883422 },
{ /*192 f=19200 */ 0.66506803411526782543, 0.92800000000000004707, 0.85600000000000009415 },
{ /*193 f=19300 */ 0.66308623945618383466, 0.93015277777777782831, 0.86030555555555554559 },
{ /*194 f=19400 */ 0.66113580803442684175, 0.93227777777777776080, 0.86455555555555563263 },
{ /*195 f=19500 */ 0.65921649760460143685, 0.93437499999999995559, 0.86875000000000002220 },
{ /*196 f=19600 */ 0.65732807021916583867, 0.93644444444444441267, 0.87288888888888893636 },
{ /*197 f=19700 */ 0.65547029217935626200, 0.93848611111111113203, 0.87697222222222215304 },
{ /*198 f=19800 */ 0.65364293398706962979, 0.94050000000000000266, 0.88100000000000000533 },
{ /*199 f=19900 */ 0.65184577029769130707, 0.94248611111111113559, 0.88497222222222227117 },
{ /*200 f=20000 */ 0.65007857987385408993, 0.94444444444444441977, 0.88888888888888895057 },
{ /*201 f=20100 */ 0.64834114554011390563, 0.94637499999999996625, 0.89275000000000004352 },
{ /*202 f=20200 */ 0.64663325413853156576, 0.94827777777777777501, 0.89655555555555555003 },
{ /*203 f=20300 */ 0.64495469648514536232, 0.95015277777777784607, 0.90030555555555558112 },
{ /*204 f=20400 */ 0.64330526732732495887, 0.95199999999999995737, 0.90400000000000002576 },
{ /*205 f=20500 */ 0.64168476530199014540, 0.95381944444444444198, 0.90763888888888888395 },
{ /*206 f=20600 */ 0.64009299289468790661, 0.95561111111111107785, 0.91122222222222215571 },
{ /*207 f=20700 */ 0.63852975639951203846, 0.95737500000000008704, 0.91475000000000006306 },
{ /*208 f=20800 */ 0.63699486587985554298, 0.95911111111111113647, 0.91822222222222227295 },
{ /*209 f=20900 */ 0.63548813512998414410, 0.96081944444444444819, 0.92163888888888889639 },
{ /*210 f=21000 */ 0.63400938163742137643, 0.96250000000000002220, 0.92500000000000004441 },
{ /*211 f=21100 */ 0.63255842654613259057, 0.96415277777777785850, 0.92830555555555560598 },
{ /*212 f=21200 */ 0.63113509462049910415, 0.96577777777777784607, 0.93155555555555558112 },
{ /*213 f=21300 */ 0.62973921421007184041, 0.96737499999999998490, 0.93474999999999996980 },
{ /*214 f=21400 */ 0.62837061721509368528, 0.96894444444444438602, 0.93788888888888888307 },
{ /*215 f=21500 */ 0.62702913905278256923, 0.97048611111111116045, 0.94097222222222220989 },
{ /*216 f=21600 */ 0.62571461862436483781, 0.97199999999999997513, 0.94400000000000006128 },
{ /*217 f=21700 */ 0.62442689828284858589, 0.97348611111111105210, 0.94697222222222221522 },
{ /*218 f=21800 */ 0.62316582380153096032, 0.97494444444444439135, 0.94988888888888889372 },
{ /*219 f=21900 */ 0.62193124434322666350, 0.97637499999999999289, 0.95274999999999998579 },
{ /*220 f=22000 */ 0.62072301243021332784, 0.97777777777777774570, 0.95555555555555549141 },
{ /*221 f=22100 */ 0.61954098391488066078, 0.97915277777777776080, 0.95830555555555552161 },
{ /*222 f=22200 */ 0.61838501795108069548, 0.98050000000000003819, 0.96100000000000007638 },
{ /*223 f=22300 */ 0.61725497696616515864, 0.98181944444444446685, 0.96363888888888893369 },
{ /*224 f=22400 */ 0.61615072663370806794, 0.98311111111111104677, 0.96622222222222220456 },
{ /*225 f=22500 */ 0.61507213584690056951, 0.98437500000000000000, 0.96875000000000000000 },
{ /*226 f=22600 */ 0.61401907669261557299, 0.98561111111111110450, 0.97122222222222220900 },
{ /*227 f=22700 */ 0.61299142442613085979, 0.98681944444444447129, 0.97363888888888883155 },
{ /*228 f=22800 */ 0.61198905744650633487, 0.98799999999999998934, 0.97599999999999997868 },
{ /*229 f=22900 */ 0.61101185727260787228, 0.98915277777777776969, 0.97830555555555553937 },
{ /*230 f=23000 */ 0.61005970851977020519, 0.99027777777777781232, 0.98055555555555562464 },
{ /*231 f=23100 */ 0.60913249887709441932, 0.99137500000000000622, 0.98275000000000001243 },
{ /*232 f=23200 */ 0.60823011908537172321, 0.99244444444444446241, 0.98488888888888892481 },
{ /*233 f=23300 */ 0.60735246291562849930, 0.99348611111111106986, 0.98697222222222225074 },
{ /*234 f=23400 */ 0.60649942714828630752, 0.99449999999999993960, 0.98899999999999999023 },
{ /*235 f=23500 */ 0.60567091155293262261, 0.99548611111111107164, 0.99097222222222225430 },
{ /*236 f=23600 */ 0.60486681886869408942, 0.99644444444444446596, 0.99288888888888882089 },
{ /*237 f=23700 */ 0.60408705478520874355, 0.99737500000000001155, 0.99475000000000002309 },
{ /*238 f=23800 */ 0.60333152792419153521, 0.99827777777777781942, 0.99655555555555552782 },
{ /*239 f=23900 */ 0.60260014982158882635, 0.99915277777777777857, 0.99830555555555555713 },
{ /*240 f=24000 */ 0.60189283491031519979, 1.00000000000000000000, 1.00000000000000000000 }
};
static FLOAT_T moog_q50[241][3] = {
{ /* dummy entry */ 0, 0, 0},
{ /*  1 f=  100 */ 2.70672924639152201465, 0.00748611111111113781, -0.98502777777777772439 },
{ /*  2 f=  200 */ 2.67888825625419180199, 0.01494444444444442688, -0.97011111111111114624 },
{ /*  3 f=  300 */ 2.65143573079948646765, 0.02237499999999997824, -0.95525000000000004352 },
{ /*  4 f=  400 */ 2.62436558571423095287, 0.02977777777777779189, -0.94044444444444441622 },
{ /*  5 f=  500 */ 2.59767184286785246528, 0.03715277777777775681, -0.92569444444444448639 },
{ /*  6 f=  600 */ 2.57134862831217114731, 0.04449999999999998401, -0.91100000000000003197 },
{ /*  7 f=  700 */ 2.54539017032152559139, 0.05181944444444447351, -0.89636111111111105298 },
{ /*  8 f=  800 */ 2.51979079747238099429, 0.05911111111111111427, -0.88177777777777777146 },
{ /*  9 f=  900 */ 2.49454493676157262882, 0.06637500000000001732, -0.86724999999999996536 },
{ /* 10 f= 1000 */ 2.46964711176237328161, 0.07361111111111112715, -0.85277777777777774570 },
{ /* 11 f= 1100 */ 2.44509194081755820704, 0.08081944444444444375, -0.83836111111111111249 },
{ /* 12 f= 1200 */ 2.42087413526870909308, 0.08800000000000002265, -0.82399999999999995470 },
{ /* 13 f= 1300 */ 2.39698849772096433952, 0.09515277777777780832, -0.80969444444444438336 },
{ /* 14 f= 1400 */ 2.37342992034248112532, 0.10227777777777780077, -0.79544444444444439846 },
{ /* 15 f= 1500 */ 2.35019338319786497138, 0.10937500000000000000, -0.78125000000000000000 },
{ /* 16 f= 1600 */ 2.32727395261484959477, 0.11644444444444446152, -0.76711111111111107697 },
{ /* 17 f= 1700 */ 2.30466677958353072242, 0.12348611111111112981, -0.75302777777777774038 },
{ /* 18 f= 1800 */ 2.28236709818745975298, 0.13050000000000000488, -0.73899999999999999023 },
{ /* 19 f= 1900 */ 2.26037022406592802426, 0.13748611111111108674, -0.72502777777777782653 },
{ /* 20 f= 2000 */ 2.23867155290679020752, 0.14444444444444443088, -0.71111111111111113825 },
{ /* 21 f= 2100 */ 2.21726655896917534960, 0.15137499999999998179, -0.69725000000000003642 },
{ /* 22 f= 2200 */ 2.19615079363546827906, 0.15827777777777779500, -0.68344444444444441000 },
{ /* 23 f= 2300 */ 2.17531988399193743078, 0.16515277777777781498, -0.66969444444444437003 },
{ /* 24 f= 2400 */ 2.15476953143741756236, 0.17199999999999998623, -0.65600000000000002753 },
{ /* 25 f= 2500 */ 2.13449551031945228274, 0.17881944444444447528, -0.64236111111111104943 },
{ /* 26 f= 2600 */ 2.11449366659733017926, 0.18561111111111111560, -0.62877777777777776880 },
{ /* 27 f= 2700 */ 2.09475991653144699711, 0.19237500000000001821, -0.61524999999999996358 },
{ /* 28 f= 2800 */ 2.07529024539844764163, 0.19911111111111112759, -0.60177777777777774482 },
{ /* 29 f= 2900 */ 2.05608070623160799073, 0.20581944444444444375, -0.58836111111111111249 },
{ /* 30 f= 3000 */ 2.03712741858593826549, 0.21250000000000002220, -0.57499999999999995559 },
{ /* 31 f= 3100 */ 2.01842656732748482185, 0.21915277777777780743, -0.56169444444444438513 },
{ /* 32 f= 3200 */ 1.99997440144633409354, 0.22577777777777779944, -0.54844444444444440112 },
{ /* 33 f= 3300 */ 1.98176723289282619156, 0.23237499999999999822, -0.53525000000000000355 },
{ /* 34 f= 3400 */ 1.96380143543649765547, 0.23894444444444445930, -0.52211111111111108141 },
{ /* 35 f= 3500 */ 1.94607344354727929137, 0.24548611111111112715, -0.50902777777777774570 },
{ /* 36 f= 3600 */ 1.92857975129849568141, 0.25200000000000000178, -0.49599999999999999645 },
{ /* 37 f= 3700 */ 1.91131691129120961925, 0.25848611111111113869, -0.48302777777777772261 },
{ /* 38 f= 3800 */ 1.89428153359947892831, 0.26494444444444442688, -0.47011111111111114624 },
{ /* 39 f= 3900 */ 1.87747028473608690291, 0.27137500000000003286, -0.45724999999999998979 },
{ /* 40 f= 4000 */ 1.86087988663833070468, 0.27777777777777779011, -0.44444444444444447528 },
{ /* 41 f= 4100 */ 1.84450711567345559949, 0.28415277777777780965, -0.43169444444444443620 },
{ /* 42 f= 4200 */ 1.82834880166332625073, 0.29049999999999998046, -0.41900000000000003908 },
{ /* 43 f= 4300 */ 1.81240182692794982167, 0.29681944444444441356, -0.40636111111111111738 },
{ /* 44 f= 4400 */ 1.79666312534745720164, 0.30311111111111110894, -0.39377777777777778212 },
{ /* 45 f= 4500 */ 1.78112968144216821109, 0.30937500000000001110, -0.38124999999999997780 },
{ /* 46 f= 4600 */ 1.76579852947037041488, 0.31561111111111117555, -0.36877777777777770440 },
{ /* 47 f= 4700 */ 1.75066675254345271995, 0.32181944444444443576, -0.35636111111111112848 },
{ /* 48 f= 4800 */ 1.73573148175803493309, 0.32800000000000001377, -0.34399999999999997247 },
{ /* 49 f= 4900 */ 1.72098989534475466101, 0.33415277777777774304, -0.33169444444444445841 },
{ /* 50 f= 5000 */ 1.70643921783336338649, 0.34027777777777779011, -0.31944444444444441977 },
{ /* 51 f= 5100 */ 1.69207671923381286483, 0.34637499999999998845, -0.30725000000000002309 },
{ /* 52 f= 5200 */ 1.67789971423299255626, 0.35244444444444444908, -0.29511111111111110183 },
{ /* 53 f= 5300 */ 1.66390556140681789010, 0.35848611111111111649, -0.28302777777777776702 },
{ /* 54 f= 5400 */ 1.65009166244734184481, 0.36450000000000004619, -0.27099999999999996314 },
{ /* 55 f= 5500 */ 1.63645546140460074191, 0.37048611111111107164, -0.25902777777777780122 },
{ /* 56 f= 5600 */ 1.62299444394288605586, 0.37644444444444447040, -0.24711111111111108696 },
{ /* 57 f= 5700 */ 1.60970613661115979909, 0.38237500000000002043, -0.23525000000000001465 },
{ /* 58 f= 5800 */ 1.59658810612732127154, 0.38827777777777777724, -0.22344444444444441777 },
{ /* 59 f= 5900 */ 1.58363795867605228196, 0.39415277777777779633, -0.21169444444444446285 },
{ /* 60 f= 6000 */ 1.57085333921996439521, 0.40000000000000002220, -0.19999999999999998335 },
{ /* 61 f= 6100 */ 1.55823193082378486096, 0.40581944444444439934, -0.18836111111111114580 },
{ /* 62 f= 6200 */ 1.54577145399131521408, 0.41161111111111114980, -0.17677777777777770041 },
{ /* 63 f= 6300 */ 1.53346966601491119242, 0.41737500000000005151, -0.16524999999999995248 },
{ /* 64 f= 6400 */ 1.52132436033723306146, 0.42311111111111110450, -0.15377777777777776325 },
{ /* 65 f= 6500 */ 1.50933336592501543549, 0.42881944444444441977, -0.14236111111111113270 },
{ /* 66 f= 6600 */ 1.49749454665462877756, 0.43450000000000005285, -0.13099999999999992206 },
{ /* 67 f= 6700 */ 1.48580580070918433222, 0.44015277777777778168, -0.11969444444444440889 },
{ /* 68 f= 6800 */ 1.47426505998696244504, 0.44577777777777777279, -0.10844444444444444053 },
{ /* 69 f= 6900 */ 1.46287028952093511869, 0.45137499999999997069, -0.09725000000000004474 },
{ /* 70 f= 7000 */ 1.45161948690916298155, 0.45694444444444448639, -0.08611111111111104111 },
{ /* 71 f= 7100 */ 1.44051068175585283981, 0.46248611111111115335, -0.07502777777777774881 },
{ /* 72 f= 7200 */ 1.42954193512286087397, 0.46799999999999997158, -0.06400000000000001521 },
{ /* 73 f= 7300 */ 1.41871133899144141743, 0.47348611111111110761, -0.05302777777777782642 },
{ /* 74 f= 7400 */ 1.40801701573403015288, 0.47894444444444445041, -0.04211111111111105060 },
{ /* 75 f= 7500 */ 1.39745711759587454281, 0.48437500000000000000, -0.03124999999999997918 },
{ /* 76 f= 7600 */ 1.38702982618630654699, 0.48977777777777775636, -0.02044444444444446299 },
{ /* 77 f= 7700 */ 1.37673335197947399600, 0.49515277777777783053, -0.00969444444444435803 },
{ /* 78 f= 7800 */ 1.36656593382434854433, 0.50050000000000005596, 0.00100000000000004794 },
{ /* 79 f= 7900 */ 1.35652583846381613597, 0.50581944444444448816, 0.01163888888888889826 },
{ /* 80 f= 8000 */ 1.34661136006268433718, 0.51111111111111107164, 0.02222222222222219531 },
{ /* 81 f= 8100 */ 1.33682081974442423800, 0.51637500000000002842, 0.03275000000000007766 },
{ /* 82 f= 8200 */ 1.32715256513648149905, 0.52161111111111113647, 0.04322222222222225907 },
{ /* 83 f= 8300 */ 1.31760496992398312699, 0.52681944444444439579, 0.05363888888888888873 },
{ /* 84 f= 8400 */ 1.30817643341168032833, 0.53200000000000002842, 0.06399999999999995970 },
{ /* 85 f= 8500 */ 1.29886538009396956816, 0.53715277777777781232, 0.07430555555555562464 },
{ /* 86 f= 8600 */ 1.28967025923282596622, 0.54227777777777774748, 0.08455555555555557823 },
{ /* 87 f= 8700 */ 1.28058954444350470148, 0.54737499999999994493, 0.09474999999999998701 },
{ /* 88 f= 8800 */ 1.27162173328785432780, 0.55244444444444440467, 0.10488888888888885098 },
{ /* 89 f= 8900 */ 1.26276534687509567334, 0.55748611111111112670, 0.11497222222222228116 },
{ /* 90 f= 9000 */ 1.25401892946992310485, 0.56250000000000000000, 0.12500000000000002776 },
{ /* 91 f= 9100 */ 1.24538104810778271769, 0.56748611111111113559, 0.13497222222222221566 },
{ /* 92 f= 9200 */ 1.23685029221719600123, 0.57244444444444453346, 0.14488888888888898365 },
{ /* 93 f= 9300 */ 1.22842527324898531660, 0.57737499999999997158, 0.15475000000000005418 },
{ /* 94 f= 9400 */ 1.22010462431227395541, 0.58227777777777778301, 0.16455555555555556602 },
{ /* 95 f= 9500 */ 1.21188699981712666442, 0.58715277777777774570, 0.17430555555555554692 },
{ /* 96 f= 9600 */ 1.20377107512370762343, 0.59200000000000008171, 0.18400000000000008016 },
{ /* 97 f= 9700 */ 1.19575554619782642440, 0.59681944444444445796, 0.19363888888888891593 },
{ /* 98 f= 9800 */ 1.18783912927275125959, 0.60161111111111109651, 0.20322222222222222077 },
{ /* 99 f= 9900 */ 1.18002056051717008067, 0.60637499999999999734, 0.21274999999999996692 },
{ /*100 f=10000 */ 1.17229859570918337752, 0.61111111111111116045, 0.22222222222222229315 },
{ /*101 f=10100 */ 1.16467200991621178119, 0.61581944444444447484, 0.23163888888888892192 },
{ /*102 f=10200 */ 1.15713959718070347193, 0.62050000000000005151, 0.24099999999999999201 },
{ /*103 f=10300 */ 1.14970017021153791958, 0.62515277777777777946, 0.25030555555555550340 },
{ /*104 f=10400 */ 1.14235256008101071501, 0.62977777777777776969, 0.25955555555555559488 },
{ /*105 f=10500 */ 1.13509561592729935064, 0.63437500000000002220, 0.26875000000000004441 },
{ /*106 f=10600 */ 1.12792820466230070409, 0.63894444444444442599, 0.27788888888888885198 },
{ /*107 f=10700 */ 1.12084921068474274719, 0.64348611111111120309, 0.28697222222222229515 },
{ /*108 f=10800 */ 1.11385753559847100469, 0.64800000000000002043, 0.29600000000000004086 },
{ /*109 f=10900 */ 1.10695209793580717772, 0.65248611111111110006, 0.30497222222222225563 },
{ /*110 f=11000 */ 1.10013183288589155850, 0.65694444444444444198, 0.31388888888888888395 },
{ /*111 f=11100 */ 1.09339569202790976021, 0.66137500000000004619, 0.32275000000000009237 },
{ /*112 f=11200 */ 1.08674264306911583233, 0.66577777777777780166, 0.33155555555555560332 },
{ /*113 f=11300 */ 1.08017166958755828077, 0.67015277777777781942, 0.34030555555555558334 },
{ /*114 f=11400 */ 1.07368177077942461572, 0.67449999999999998845, 0.34899999999999997691 },
{ /*115 f=11500 */ 1.06727196121091605363, 0.67881944444444441977, 0.35763888888888895057 },
{ /*116 f=11600 */ 1.06094127057456732999, 0.68311111111111111338, 0.36622222222222222676 },
{ /*117 f=11700 */ 1.05468874344993190917, 0.68737499999999995826, 0.37474999999999997202 },
{ /*118 f=11800 */ 1.04851343906854577170, 0.69161111111111106542, 0.38322222222222218635 },
{ /*119 f=11900 */ 1.04241443108309694843, 0.69581944444444443487, 0.39163888888888892525 },
{ /*120 f=12000 */ 1.03639080734071709067, 0.69999999999999995559, 0.40000000000000002220 },
{ /*121 f=12100 */ 1.03044166966032313404, 0.70415277777777773860, 0.40830555555555553271 },
{ /*122 f=12200 */ 1.02456613361393045203, 0.70827777777777778390, 0.41655555555555551228 },
{ /*123 f=12300 */ 1.01876332831186733330, 0.71237499999999998046, 0.42474999999999996092 },
{ /*124 f=12400 */ 1.01303239619181639775, 0.71644444444444443931, 0.43288888888888898965 },
{ /*125 f=12500 */ 1.00737249281161456160, 0.72048611111111116045, 0.44097222222222232091 },
{ /*126 f=12600 */ 1.00178278664574094137, 0.72450000000000003286, 0.44900000000000006573 },
{ /*127 f=12700 */ 0.99626245888542674933, 0.72848611111111116756, 0.45697222222222227961 },
{ /*128 f=12800 */ 0.99081070324231768076, 0.73244444444444445352, 0.46488888888888890705 },
{ /*129 f=12900 */ 0.98542672575562872961, 0.73637500000000000178, 0.47275000000000000355 },
{ /*130 f=13000 */ 0.98010974460272282105, 0.74027777777777781232, 0.48055555555555551361 },
{ /*131 f=13100 */ 0.97485898991305508510, 0.74415277777777777413, 0.48830555555555549274 },
{ /*132 f=13200 */ 0.96967370358541771225, 0.74799999999999999822, 0.49600000000000010747 },
{ /*133 f=13300 */ 0.96455313910842865877, 0.75181944444444448461, 0.50363888888888896922 },
{ /*134 f=13400 */ 0.95949656138420369444, 0.75561111111111112226, 0.51122222222222224453 },
{ /*135 f=13500 */ 0.95450324655515483840, 0.75937500000000002220, 0.51875000000000004441 },
{ /*136 f=13600 */ 0.94957248183385845053, 0.76311111111111107341, 0.52622222222222225785 },
{ /*137 f=13700 */ 0.94470356533593824455, 0.76681944444444449793, 0.53363888888888888484 },
{ /*138 f=13800 */ 0.93989580591590915493, 0.77049999999999996270, 0.54099999999999992539 },
{ /*139 f=13900 */ 0.93514852300592565815, 0.77415277777777791179, 0.54830555555555571257 },
{ /*140 f=14000 */ 0.93046104645738991756, 0.77777777777777790114, 0.55555555555555569125 },
{ /*141 f=14100 */ 0.92583271638535946657, 0.78137500000000004174, 0.56275000000000008349 },
{ /*142 f=14200 */ 0.92126288301571190864, 0.78494444444444444464, 0.56988888888888888928 },
{ /*143 f=14300 */ 0.91675090653501356552, 0.78848611111111110983, 0.57697222222222221966 },
{ /*144 f=14400 */ 0.91229615694304522222, 0.79200000000000003730, 0.58399999999999996358 },
{ /*145 f=14500 */ 0.90789801390793811731, 0.79548611111111111605, 0.59097222222222223209 },
{ /*146 f=14600 */ 0.90355586662387288310, 0.79894444444444445708, 0.59788888888888880313 },
{ /*147 f=14700 */ 0.89926911367129847008, 0.80237500000000006040, 0.60475000000000012079 },
{ /*148 f=14800 */ 0.89503716287962331588, 0.80577777777777781498, 0.61155555555555562997 },
{ /*149 f=14900 */ 0.89085943119233845788, 0.80915277777777783186, 0.61830555555555555269 },
{ /*150 f=15000 */ 0.88673534453452840243, 0.81250000000000000000, 0.62500000000000000000 },
{ /*151 f=15100 */ 0.88266433768272756222, 0.81581944444444443043, 0.63163888888888886086 },
{ /*152 f=15200 */ 0.87864585413708351513, 0.81911111111111112315, 0.63822222222222224630 },
{ /*153 f=15300 */ 0.87467934599578311960, 0.82237499999999996714, 0.64474999999999993427 },
{ /*154 f=15400 */ 0.87076427383170673657, 0.82561111111111118444, 0.65122222222222236887 },
{ /*155 f=15500 */ 0.86690010657126848059, 0.82881944444444455300, 0.65763888888888899498 },
{ /*156 f=15600 */ 0.86308632137540541862, 0.83200000000000007283, 0.66400000000000003464 },
{ /*157 f=15700 */ 0.85932240352268096650, 0.83515277777777785495, 0.67030555555555559888 },
{ /*158 f=15800 */ 0.85560784629446173799, 0.83827777777777778834, 0.67655555555555557667 },
{ /*159 f=15900 */ 0.85194215086213753718, 0.84137499999999998401, 0.68274999999999996803 },
{ /*160 f=16000 */ 0.84832482617634497046, 0.84444444444444444198, 0.68888888888888888395 },
{ /*161 f=16100 */ 0.84475538885816281454, 0.84748611111111116223, 0.69497222222222221344 },
{ /*162 f=16200 */ 0.84123336309224649998, 0.85050000000000003375, 0.70100000000000006750 },
{ /*163 f=16300 */ 0.83775828052186473993, 0.85348611111111116756, 0.70697222222222233512 },
{ /*164 f=16400 */ 0.83432968014581199157, 0.85644444444444445264, 0.71288888888888890527 },
{ /*165 f=16500 */ 0.83094710821716022409, 0.85937500000000000000, 0.71875000000000000000 },
{ /*166 f=16600 */ 0.82761011814382090535, 0.86227777777777769863, 0.72455555555555550828 },
{ /*167 f=16700 */ 0.82431827039088756415, 0.86515277777777777057, 0.73030555555555554115 },
{ /*168 f=16800 */ 0.82107113238472806405, 0.86799999999999999378, 0.73599999999999998757 },
{ /*169 f=16900 */ 0.81786827841879772283, 0.87081944444444447928, 0.74163888888888895856 },
{ /*170 f=17000 */ 0.81470928956114596620, 0.87361111111111111605, 0.74722222222222234311 },
{ /*171 f=17100 */ 0.81159375356358443021, 0.87637500000000001510, 0.75275000000000003020 },
{ /*172 f=17200 */ 0.80852126477249641745, 0.87911111111111117644, 0.75822222222222224186 },
{ /*173 f=17300 */ 0.80549142404125251282, 0.88181944444444448905, 0.76363888888888886708 },
{ /*174 f=17400 */ 0.80250383864421215296, 0.88450000000000006395, 0.76900000000000001688 },
{ /*175 f=17500 */ 0.79955812219228239446, 0.88715277777777779011, 0.77430555555555558023 },
{ /*176 f=17600 */ 0.79665389455000867880, 0.88977777777777777857, 0.77955555555555555713 },
{ /*177 f=17700 */ 0.79379078175417550067, 0.89237500000000002931, 0.78475000000000005862 },
{ /*178 f=17800 */ 0.79096841593388722558, 0.89494444444444454234, 0.78988888888888897366 },
{ /*179 f=17900 */ 0.78818643523211262547, 0.89748611111111120664, 0.79497222222222230226 },
{ /*180 f=18000 */ 0.78544448372866126906, 0.90000000000000002220, 0.80000000000000004441 },
{ /*181 f=18100 */ 0.78274221136457677872, 0.90248611111111110006, 0.80497222222222220012 },
{ /*182 f=18200 */ 0.78007927386792041968, 0.90494444444444444020, 0.80988888888888888040 },
{ /*183 f=18300 */ 0.77745533268092215096, 0.90737500000000004263, 0.81474999999999997424 },
{ /*184 f=18400 */ 0.77487005488848137436, 0.90977777777777779633, 0.81955555555555559266 },
{ /*185 f=18500 */ 0.77232311314799295676, 0.91215277777777781232, 0.82430555555555562464 },
{ /*186 f=18600 */ 0.76981418562047843057, 0.91450000000000009059, 0.82900000000000007017 },
{ /*187 f=18700 */ 0.76734295590300583001, 0.91681944444444440911, 0.83363888888888892925 },
{ /*188 f=18800 */ 0.76490911296237051875, 0.91911111111111110095, 0.83822222222222220189 },
{ /*189 f=18900 */ 0.76251235107002734992, 0.92137500000000005507, 0.84274999999999999911 },
{ /*190 f=19000 */ 0.76015236973824673594, 0.92361111111111116045, 0.84722222222222220989 },
{ /*191 f=19100 */ 0.75782887365748141661, 0.92581944444444441711, 0.85163888888888883422 },
{ /*192 f=19200 */ 0.75554157263492183194, 0.92800000000000004707, 0.85600000000000009415 },
{ /*193 f=19300 */ 0.75329018153422688808, 0.93015277777777782831, 0.86030555555555554559 },
{ /*194 f=19400 */ 0.75107442021640735685, 0.93227777777777776080, 0.86455555555555563263 },
{ /*195 f=19500 */ 0.74889401348184825302, 0.93437499999999995559, 0.86875000000000002220 },
{ /*196 f=19600 */ 0.74674869101345320299, 0.93644444444444441267, 0.87288888888888893636 },
{ /*197 f=19700 */ 0.74463818732089248620, 0.93848611111111113203, 0.87697222222222215304 },
{ /*198 f=19800 */ 0.74256224168594076041, 0.94050000000000000266, 0.88100000000000000533 },
{ /*199 f=19900 */ 0.74052059810888692937, 0.94248611111111113559, 0.88497222222222227117 },
{ /*200 f=20000 */ 0.73851300525600305225, 0.94444444444444441977, 0.88888888888888895057 },
{ /*201 f=20100 */ 0.73653921640805419813, 0.94637499999999996625, 0.89275000000000004352 },
{ /*202 f=20200 */ 0.73459898940983769933, 0.94827777777777777501, 0.89655555555555555003 },
{ /*203 f=20300 */ 0.73269208662073459504, 0.95015277777777784607, 0.90030555555555558112 },
{ /*204 f=20400 */ 0.73081827486626138590, 0.95199999999999995737, 0.90400000000000002576 },
{ /*205 f=20500 */ 0.72897732539060622337, 0.95381944444444444198, 0.90763888888888888395 },
{ /*206 f=20600 */ 0.72716901381013776540, 0.95561111111111107785, 0.91122222222222215571 },
{ /*207 f=20700 */ 0.72539312006787326492, 0.95737500000000008704, 0.91475000000000006306 },
{ /*208 f=20800 */ 0.72364942838889123600, 0.95911111111111113647, 0.91822222222222227295 },
{ /*209 f=20900 */ 0.72193772723667803959, 0.96081944444444444819, 0.92163888888888889639 },
{ /*210 f=21000 */ 0.72025780927039584345, 0.96250000000000002220, 0.92500000000000004441 },
{ /*211 f=21100 */ 0.71860947130305785624, 0.96415277777777785850, 0.92830555555555560598 },
{ /*212 f=21200 */ 0.71699251426060262027, 0.96577777777777784607, 0.93155555555555558112 },
{ /*213 f=21300 */ 0.71540674314185159766, 0.96737499999999998490, 0.93474999999999996980 },
{ /*214 f=21400 */ 0.71385196697934238941, 0.96894444444444438602, 0.93788888888888888307 },
{ /*215 f=21500 */ 0.71232799880102470880, 0.97048611111111116045, 0.94097222222222220989 },
{ /*216 f=21600 */ 0.71083465559280900603, 0.97199999999999997513, 0.94400000000000006128 },
{ /*217 f=21700 */ 0.70937175826195553174, 0.97348611111111105210, 0.94697222222222221522 },
{ /*218 f=21800 */ 0.70793913160129828821, 0.97494444444444439135, 0.94988888888888889372 },
{ /*219 f=21900 */ 0.70653660425428654879, 0.97637499999999999289, 0.95274999999999998579 },
{ /*220 f=22000 */ 0.70516400868084239129, 0.97777777777777774570, 0.95555555555555549141 },
{ /*221 f=22100 */ 0.70382118112401692578, 0.97915277777777776080, 0.95830555555555552161 },
{ /*222 f=22200 */ 0.70250796157744266335, 0.98050000000000003819, 0.96100000000000007638 },
{ /*223 f=22300 */ 0.70122419375356759286, 0.98181944444444446685, 0.96363888888888893369 },
{ /*224 f=22400 */ 0.69996972505266674691, 0.98311111111111104677, 0.96622222222222220456 },
{ /*225 f=22500 */ 0.69874440653261771228, 0.98437500000000000000, 0.96875000000000000000 },
{ /*226 f=22600 */ 0.69754809287943708718, 0.98561111111111110450, 0.97122222222222220900 },
{ /*227 f=22700 */ 0.69638064237856522887, 0.98681944444444447129, 0.97363888888888883155 },
{ /*228 f=22800 */ 0.69524191688689385149, 0.98799999999999998934, 0.97599999999999997868 },
{ /*229 f=22900 */ 0.69413178180552792540, 0.98915277777777776969, 0.97830555555555553937 },
{ /*230 f=23000 */ 0.69305010605327455053, 0.99027777777777781232, 0.98055555555555562464 },
{ /*231 f=23100 */ 0.69199676204085114328, 0.99137500000000000622, 0.98275000000000001243 },
{ /*232 f=23200 */ 0.69097162564580683064, 0.99244444444444446241, 0.98488888888888892481 },
{ /*233 f=23300 */ 0.68997457618814850289, 0.99348611111111106986, 0.98697222222222225074 },
{ /*234 f=23400 */ 0.68900549640666575169, 0.99449999999999993960, 0.98899999999999999023 },
{ /*235 f=23500 */ 0.68806427243595003063, 0.99548611111111107164, 0.99097222222222225430 },
{ /*236 f=23600 */ 0.68715079378409760213, 0.99644444444444446596, 0.99288888888888882089 },
{ /*237 f=23700 */ 0.68626495331109316211, 0.99737500000000001155, 0.99475000000000002309 },
{ /*238 f=23800 */ 0.68540664720786836916, 0.99827777777777781942, 0.99655555555555552782 },
{ /*239 f=23900 */ 0.68457577497602772887, 0.99915277777777777857, 0.99830555555555555713 },
{ /*240 f=24000 */ 0.68377223940823772530, 1.00000000000000000000, 1.00000000000000000000 }
};
static FLOAT_T moog_q60[241][3] = {
{ /* dummy entry */ 0, 0, 0},
{ /*  1 f=  100 */ 2.96418821472544014028, 0.00748611111111113781, -0.98502777777777772439 },
{ /*  2 f=  200 */ 2.93369904224489719269, 0.01494444444444442688, -0.97011111111111114624 },
{ /*  3 f=  300 */ 2.90363528447312457814, 0.02237499999999997824, -0.95525000000000004352 },
{ /*  4 f=  400 */ 2.87399027836858111939, 0.02977777777777779189, -0.94044444444444441622 },
{ /*  5 f=  500 */ 2.84475747717221771893, 0.03715277777777775681, -0.92569444444444448639 },
{ /*  6 f=  600 */ 2.81593044821700866365, 0.04449999999999998401, -0.91100000000000003197 },
{ /*  7 f=  700 */ 2.78750287078166048005, 0.05181944444444447351, -0.89636111111111105298 },
{ /*  8 f=  800 */ 2.75946853398755420628, 0.05911111111111111427, -0.88177777777777777146 },
{ /*  9 f=  900 */ 2.73182133473800181633, 0.06637500000000001732, -0.86724999999999996536 },
{ /* 10 f= 1000 */ 2.70455527569891884809, 0.07361111111111112715, -0.85277777777777774570 },
{ /* 11 f= 1100 */ 2.67766446332002150399, 0.08081944444444444375, -0.83836111111111111249 },
{ /* 12 f= 1200 */ 2.65114310589570045806, 0.08800000000000002265, -0.82399999999999995470 },
{ /* 13 f= 1300 */ 2.62498551166472360308, 0.09515277777777780832, -0.80969444444444438336 },
{ /* 14 f= 1400 */ 2.59918608694793862313, 0.10227777777777780077, -0.79544444444444439846 },
{ /* 15 f= 1500 */ 2.57373933432318890979, 0.10937500000000000000, -0.78125000000000000000 },
{ /* 16 f= 1600 */ 2.54863985083662925035, 0.11644444444444446152, -0.76711111111111107697 },
{ /* 17 f= 1700 */ 2.52388232624970187956, 0.12348611111111112981, -0.75302777777777774038 },
{ /* 18 f= 1800 */ 2.49946154132099573886, 0.13050000000000000488, -0.73899999999999999023 },
{ /* 19 f= 1900 */ 2.47537236612226863031, 0.13748611111111108674, -0.72502777777777782653 },
{ /* 20 f= 2000 */ 2.45160975838790973214, 0.14444444444444443088, -0.71111111111111113825 },
{ /* 21 f= 2100 */ 2.42816876189713237721, 0.15137499999999998179, -0.69725000000000003642 },
{ /* 22 f= 2200 */ 2.40504450488822563159, 0.15827777777777779500, -0.68344444444444441000 },
{ /* 23 f= 2300 */ 2.38223219850417100574, 0.16515277777777781498, -0.66969444444444437003 },
{ /* 24 f= 2400 */ 2.35972713526898791869, 0.17199999999999998623, -0.65600000000000002753 },
{ /* 25 f= 2500 */ 2.33752468759414755439, 0.17881944444444447528, -0.64236111111111104943 },
{ /* 26 f= 2600 */ 2.31562030631444049078, 0.18561111111111111560, -0.62877777777777776880 },
{ /* 27 f= 2700 */ 2.29400951925267193587, 0.19237500000000001821, -0.61524999999999996358 },
{ /* 28 f= 2800 */ 2.27268792981259171171, 0.19911111111111112759, -0.60177777777777774482 },
{ /* 29 f= 2900 */ 2.25165121559946435070, 0.20581944444444444375, -0.58836111111111111249 },
{ /* 30 f= 3000 */ 2.23089512706770864980, 0.21250000000000002220, -0.57499999999999995559 },
{ /* 31 f= 3100 */ 2.21041548619504224504, 0.21915277777777780743, -0.56169444444444438513 },
{ /* 32 f= 3200 */ 2.19020818518258097995, 0.22577777777777779944, -0.54844444444444440112 },
{ /* 33 f= 3300 */ 2.17026918518035394357, 0.23237499999999999822, -0.53525000000000000355 },
{ /* 34 f= 3400 */ 2.15059451503771281722, 0.23894444444444445930, -0.52211111111111108141 },
{ /* 35 f= 3500 */ 2.13118027007810884044, 0.24548611111111112715, -0.50902777777777774570 },
{ /* 36 f= 3600 */ 2.11202261089774978586, 0.25200000000000000178, -0.49599999999999999645 },
{ /* 37 f= 3700 */ 2.09311776218763023749, 0.25848611111111113869, -0.48302777777777772261 },
{ /* 38 f= 3800 */ 2.07446201157846088492, 0.26494444444444442688, -0.47011111111111114624 },
{ /* 39 f= 3900 */ 2.05605170850802432270, 0.27137500000000003286, -0.45724999999999998979 },
{ /* 40 f= 4000 */ 2.03788326311049017292, 0.27777777777777779011, -0.44444444444444447528 },
{ /* 41 f= 4100 */ 2.01995314512725210321, 0.28415277777777780965, -0.43169444444444443620 },
{ /* 42 f= 4200 */ 2.00225788283882355501, 0.29049999999999998046, -0.41900000000000003908 },
{ /* 43 f= 4300 */ 1.98479406201738561855, 0.29681944444444441356, -0.40636111111111111738 },
{ /* 44 f= 4400 */ 1.96755832489954429754, 0.30311111111111110894, -0.39377777777777778212 },
{ /* 45 f= 4500 */ 1.95054736917889370851, 0.30937500000000001110, -0.38124999999999997780 },
{ /* 46 f= 4600 */ 1.93375794701797687480, 0.31561111111111117555, -0.36877777777777770440 },
{ /* 47 f= 4700 */ 1.91718686407925287263, 0.32181944444444443576, -0.35636111111111112848 },
{ /* 48 f= 4800 */ 1.90083097857467642200, 0.32800000000000001377, -0.34399999999999997247 },
{ /* 49 f= 4900 */ 1.88468720033351799792, 0.33415277777777774304, -0.33169444444444445841 },
{ /* 50 f= 5000 */ 1.86875248988804698591, 0.34027777777777779011, -0.31944444444444441977 },
{ /* 51 f= 5100 */ 1.85302385757672349875, 0.34637499999999998845, -0.30725000000000002309 },
{ /* 52 f= 5200 */ 1.83749836266453070444, 0.35244444444444444908, -0.29511111111111110183 },
{ /* 53 f= 5300 */ 1.82217311248011926139, 0.35848611111111111649, -0.28302777777777776702 },
{ /* 54 f= 5400 */ 1.80704526156940259440, 0.36450000000000004619, -0.27099999999999996314 },
{ /* 55 f= 5500 */ 1.79211201086528948423, 0.37048611111111107164, -0.25902777777777780122 },
{ /* 56 f= 5600 */ 1.77737060687321246633, 0.37644444444444447040, -0.24711111111111108696 },
{ /* 57 f= 5700 */ 1.76281834087214694939, 0.38237500000000002043, -0.23525000000000001465 },
{ /* 58 f= 5800 */ 1.74845254813079997724, 0.38827777777777777724, -0.22344444444444441777 },
{ /* 59 f= 5900 */ 1.73427060713866576513, 0.39415277777777779633, -0.21169444444444446285 },
{ /* 60 f= 6000 */ 1.72026993885165246922, 0.40000000000000002220, -0.19999999999999998335 },
{ /* 61 f= 6100 */ 1.70644800595198464777, 0.40581944444444439934, -0.18836111111111114580 },
{ /* 62 f= 6200 */ 1.69280231212209519853, 0.41161111111111114980, -0.17677777777777770041 },
{ /* 63 f= 6300 */ 1.67933040133222921675, 0.41737500000000005151, -0.16524999999999995248 },
{ /* 64 f= 6400 */ 1.66602985714148443819, 0.42311111111111110450, -0.15377777777777776325 },
{ /* 65 f= 6500 */ 1.65289830201201626281, 0.42881944444444441977, -0.14236111111111113270 },
{ /* 66 f= 6600 */ 1.63993339663615422808, 0.43450000000000005285, -0.13099999999999992206 },
{ /* 67 f= 6700 */ 1.62713283927616103597, 0.44015277777777778168, -0.11969444444444440889 },
{ /* 68 f= 6800 */ 1.61449436511639121683, 0.44577777777777777279, -0.10844444444444444053 },
{ /* 69 f= 6900 */ 1.60201574562760096221, 0.45137499999999997069, -0.09725000000000004474 },
{ /* 70 f= 7000 */ 1.58969478794316421144, 0.45694444444444448639, -0.08611111111111104111 },
{ /* 71 f= 7100 */ 1.57752933424696561993, 0.46248611111111115335, -0.07502777777777774881 },
{ /* 72 f= 7200 */ 1.56551726117273060090, 0.46799999999999997158, -0.06400000000000001521 },
{ /* 73 f= 7300 */ 1.55365647921457794567, 0.47348611111111110761, -0.05302777777777782642 },
{ /* 74 f= 7400 */ 1.54194493214855943286, 0.47894444444444445041, -0.04211111111111105060 },
{ /* 75 f= 7500 */ 1.53038059646498436628, 0.48437500000000000000, -0.03124999999999997918 },
{ /* 76 f= 7600 */ 1.51896148081130188956, 0.48977777777777775636, -0.02044444444444446299 },
{ /* 77 f= 7700 */ 1.50768562544534479031, 0.49515277777777783053, -0.00969444444444435803 },
{ /* 78 f= 7800 */ 1.49655110169872807013, 0.50050000000000005596, 0.00100000000000004794 },
{ /* 79 f= 7900 */ 1.48555601145019822162, 0.50581944444444448816, 0.01163888888888889826 },
{ /* 80 f= 8000 */ 1.47469848660874469637, 0.51111111111111107164, 0.02222222222222219531 },
{ /* 81 f= 8100 */ 1.46397668860627705456, 0.51637500000000002842, 0.03275000000000007766 },
{ /* 82 f= 8200 */ 1.45338880789968838414, 0.52161111111111113647, 0.04322222222222225907 },
{ /* 83 f= 8300 */ 1.44293306348210914614, 0.52681944444444439579, 0.05363888888888888873 },
{ /* 84 f= 8400 */ 1.43260770240318513480, 0.53200000000000002842, 0.06399999999999995970 },
{ /* 85 f= 8500 */ 1.42241099929819836412, 0.53715277777777781232, 0.07430555555555562464 },
{ /* 86 f= 8600 */ 1.41234125592585524345, 0.54227777777777774748, 0.08455555555555557823 },
{ /* 87 f= 8700 */ 1.40239680071458017174, 0.54737499999999994493, 0.09474999999999998701 },
{ /* 88 f= 8800 */ 1.39257598831714490828, 0.55244444444444440467, 0.10488888888888885098 },
{ /* 89 f= 8900 */ 1.38287719917347606824, 0.55748611111111112670, 0.11497222222222228116 },
{ /* 90 f= 9000 */ 1.37329883908147754035, 0.56250000000000000000, 0.12500000000000002776 },
{ /* 91 f= 9100 */ 1.36383933877571617010, 0.56748611111111113559, 0.13497222222222221566 },
{ /* 92 f= 9200 */ 1.35449715351382193873, 0.57244444444444453346, 0.14488888888888898365 },
{ /* 93 f= 9300 */ 1.34527076267044476410, 0.57737499999999997158, 0.15475000000000005418 },
{ /* 94 f= 9400 */ 1.33615866933863158827, 0.58227777777777778301, 0.16455555555555556602 },
{ /* 95 f= 9500 */ 1.32715939993847720224, 0.58715277777777774570, 0.17430555555555554692 },
{ /* 96 f= 9600 */ 1.31827150383290847557, 0.59200000000000008171, 0.18400000000000008016 },
{ /* 97 f= 9700 */ 1.30949355295046876435, 0.59681944444444445796, 0.19363888888888891593 },
{ /* 98 f= 9800 */ 1.30082414141496172100, 0.60161111111111109651, 0.20322222222222222077 },
{ /* 99 f= 9900 */ 1.29226188518183060516, 0.60637499999999999734, 0.21274999999999996692 },
{ /*100 f=10000 */ 1.28380542168114120116, 0.61111111111111116045, 0.22222222222222229315 },
{ /*101 f=10100 */ 1.27545340946704288676, 0.61581944444444447484, 0.23163888888888892192 },
{ /*102 f=10200 */ 1.26720452787358195401, 0.62050000000000005151, 0.24099999999999999201 },
{ /*103 f=10300 */ 1.25905747667675105284, 0.62515277777777777946, 0.25030555555555550340 },
{ /*104 f=10400 */ 1.25101097576265285483, 0.62977777777777776969, 0.25955555555555559488 },
{ /*105 f=10500 */ 1.24306376480166380638, 0.63437500000000002220, 0.26875000000000004441 },
{ /*106 f=10600 */ 1.23521460292848317408, 0.63894444444444442599, 0.27788888888888885198 },
{ /*107 f=10700 */ 1.22746226842795502776, 0.64348611111111120309, 0.28697222222222229515 },
{ /*108 f=10800 */ 1.21980555842655924437, 0.64800000000000002043, 0.29600000000000004086 },
{ /*109 f=10900 */ 1.21224328858945695764, 0.65248611111111110006, 0.30497222222222225563 },
{ /*110 f=11000 */ 1.20477429282299253188, 0.65694444444444444198, 0.31388888888888888395 },
{ /*111 f=11100 */ 1.19739742298254614461, 0.66137500000000004619, 0.32275000000000009237 },
{ /*112 f=11200 */ 1.19011154858563727998, 0.66577777777777780166, 0.33155555555555560332 },
{ /*113 f=11300 */ 1.18291555653018010119, 0.67015277777777781942, 0.34030555555555558334 },
{ /*114 f=11400 */ 1.17580835081779633278, 0.67449999999999998845, 0.34899999999999997691 },
{ /*115 f=11500 */ 1.16878885228208662106, 0.67881944444444441977, 0.35763888888888895057 },
{ /*116 f=11600 */ 1.16185599832177488544, 0.68311111111111111338, 0.36622222222222222676 },
{ /*117 f=11700 */ 1.15500874263862751690, 0.68737499999999995826, 0.37474999999999997202 },
{ /*118 f=11800 */ 1.14824605498006326876, 0.69161111111111106542, 0.38322222222222218635 },
{ /*119 f=11900 */ 1.14156692088636479987, 0.69581944444444443487, 0.39163888888888892525 },
{ /*120 f=12000 */ 1.13497034144240815934, 0.69999999999999995559, 0.40000000000000002220 },
{ /*121 f=12100 */ 1.12845533303382339341, 0.70415277777777773860, 0.40830555555555553271 },
{ /*122 f=12200 */ 1.12202092710750855886, 0.70827777777777778390, 0.41655555555555551228 },
{ /*123 f=12300 */ 1.11566616993641254396, 0.71237499999999998046, 0.42474999999999996092 },
{ /*124 f=12400 */ 1.10939012238851186787, 0.71644444444444443931, 0.43288888888888898965 },
{ /*125 f=12500 */ 1.10319185969990152252, 0.72048611111111116045, 0.44097222222222232091 },
{ /*126 f=12600 */ 1.09707047125192547199, 0.72450000000000003286, 0.44900000000000006573 },
{ /*127 f=12700 */ 1.09102506035227220238, 0.72848611111111116756, 0.45697222222222227961 },
{ /*128 f=12800 */ 1.08505474401996426792, 0.73244444444444445352, 0.46488888888888890705 },
{ /*129 f=12900 */ 1.07915865277416767043, 0.73637500000000000178, 0.47275000000000000355 },
{ /*130 f=13000 */ 1.07333593042675445872, 0.74027777777777781232, 0.48055555555555551361 },
{ /*131 f=13100 */ 1.06758573387854904801, 0.74415277777777777413, 0.48830555555555549274 },
{ /*132 f=13200 */ 1.06190723291918986959, 0.74799999999999999822, 0.49600000000000010747 },
{ /*133 f=13300 */ 1.05629961003054395619, 0.75181944444444448461, 0.50363888888888896922 },
{ /*134 f=13400 */ 1.05076206019360585131, 0.75561111111111112226, 0.51122222222222224453 },
{ /*135 f=13500 */ 1.04529379069882244480, 0.75937500000000002220, 0.51875000000000004441 },
{ /*136 f=13600 */ 1.03989402095977845342, 0.76311111111111107341, 0.52622222222222225785 },
{ /*137 f=13700 */ 1.03456198233018215049, 0.76681944444444449793, 0.53363888888888888484 },
{ /*138 f=13800 */ 1.02929691792409716555, 0.77049999999999996270, 0.54099999999999992539 },
{ /*139 f=13900 */ 1.02409808243935085414, 0.77415277777777791179, 0.54830555555555571257 },
{ /*140 f=14000 */ 1.01896474198407815948, 0.77777777777777790114, 0.55555555555555569125 },
{ /*141 f=14100 */ 1.01389617390632835736, 0.78137500000000004174, 0.56275000000000008349 },
{ /*142 f=14200 */ 1.00889166662669294006, 0.78494444444444444464, 0.56988888888888888928 },
{ /*143 f=14300 */ 1.00395051947389424285, 0.78848611111111110983, 0.57697222222222221966 },
{ /*144 f=14400 */ 0.99907204252328341010, 0.79200000000000003730, 0.58399999999999996358 },
{ /*145 f=14500 */ 0.99425555643819685248, 0.79548611111111111605, 0.59097222222222223209 },
{ /*146 f=14600 */ 0.98950039231412101337, 0.79894444444444445708, 0.59788888888888880313 },
{ /*147 f=14700 */ 0.98480589152561359700, 0.80237500000000006040, 0.60475000000000012079 },
{ /*148 f=14800 */ 0.98017140557593662731, 0.80577777777777781498, 0.61155555555555562997 },
{ /*149 f=14900 */ 0.97559629594934804686, 0.80915277777777783186, 0.61830555555555555269 },
{ /*150 f=15000 */ 0.97107993396601188785, 0.81250000000000000000, 0.62500000000000000000 },
{ /*151 f=15100 */ 0.96662170063947494558, 0.81581944444444443043, 0.63163888888888886086 },
{ /*152 f=15200 */ 0.96222098653667131885, 0.81911111111111112315, 0.63822222222222224630 },
{ /*153 f=15300 */ 0.95787719164040330266, 0.82237499999999996714, 0.64474999999999993427 },
{ /*154 f=15400 */ 0.95358972521426321745, 0.82561111111111118444, 0.65122222222222236887 },
{ /*155 f=15500 */ 0.94935800566995010019, 0.82881944444444455300, 0.65763888888888899498 },
{ /*156 f=15600 */ 0.94518146043693773706, 0.83200000000000007283, 0.66400000000000003464 },
{ /*157 f=15700 */ 0.94105952583445973136, 0.83515277777777785495, 0.67030555555555559888 },
{ /*158 f=15800 */ 0.93699164694576420054, 0.83827777777777778834, 0.67655555555555557667 },
{ /*159 f=15900 */ 0.93297727749460690472, 0.84137499999999998401, 0.68274999999999996803 },
{ /*160 f=16000 */ 0.92901587972393728787, 0.84444444444444444198, 0.68888888888888888395 },
{ /*161 f=16100 */ 0.92510692427674501293, 0.84748611111111116223, 0.69497222222222221344 },
{ /*162 f=16200 */ 0.92124989007902957638, 0.85050000000000003375, 0.70100000000000006750 },
{ /*163 f=16300 */ 0.91744426422485303441, 0.85348611111111116756, 0.70697222222222233512 },
{ /*164 f=16400 */ 0.91368954186344675250, 0.85644444444444445264, 0.71288888888888890527 },
{ /*165 f=16500 */ 0.90998522608833265490, 0.85937500000000000000, 0.71875000000000000000 },
{ /*166 f=16600 */ 0.90633082782842733227, 0.86227777777777769863, 0.72455555555555550828 },
{ /*167 f=16700 */ 0.90272586574109481283, 0.86515277777777777057, 0.73030555555555554115 },
{ /*168 f=16800 */ 0.89916986610711713279, 0.86799999999999999378, 0.73599999999999998757 },
{ /*169 f=16900 */ 0.89566236272754784498, 0.87081944444444447928, 0.74163888888888895856 },
{ /*170 f=17000 */ 0.89220289682242115425, 0.87361111111111111605, 0.74722222222222234311 },
{ /*171 f=17100 */ 0.88879101693128093054, 0.87637500000000001510, 0.75275000000000003020 },
{ /*172 f=17200 */ 0.88542627881550495239, 0.87911111111111117644, 0.75822222222222224186 },
{ /*173 f=17300 */ 0.88210824536239129667, 0.88181944444444448905, 0.76363888888888886708 },
{ /*174 f=17400 */ 0.87883648649097889649, 0.88450000000000006395, 0.76900000000000001688 },
{ /*175 f=17500 */ 0.87561057905957473402, 0.88715277777777779011, 0.77430555555555558023 },
{ /*176 f=17600 */ 0.87243010677495891336, 0.88977777777777777857, 0.77955555555555555713 },
{ /*177 f=17700 */ 0.86929466010324152325, 0.89237500000000002931, 0.78475000000000005862 },
{ /*178 f=17800 */ 0.86620383618234308987, 0.89494444444444454234, 0.78988888888888897366 },
{ /*179 f=17900 */ 0.86315723873607563821, 0.89748611111111120664, 0.79497222222222230226 },
{ /*180 f=18000 */ 0.86015447798979305372, 0.90000000000000002220, 0.80000000000000004441 },
{ /*181 f=18100 */ 0.85719517058759320260, 0.90248611111111110006, 0.80497222222222220012 },
{ /*182 f=18200 */ 0.85427893951104105774, 0.90494444444444444020, 0.80988888888888888040 },
{ /*183 f=18300 */ 0.85140541399939195788, 0.90737500000000004263, 0.81474999999999997424 },
{ /*184 f=18400 */ 0.84857422947129013124, 0.90977777777777779633, 0.81955555555555559266 },
{ /*185 f=18500 */ 0.84578502744792083412, 0.91215277777777781232, 0.82430555555555562464 },
{ /*186 f=18600 */ 0.84303745547759045831, 0.91450000000000009059, 0.82900000000000007017 },
{ /*187 f=18700 */ 0.84033116706171839816, 0.91681944444444440911, 0.83363888888888892925 },
{ /*188 f=18800 */ 0.83766582158220959098, 0.91911111111111110095, 0.83822222222222220189 },
{ /*189 f=18900 */ 0.83504108423019773877, 0.92137500000000005507, 0.84274999999999999911 },
{ /*190 f=19000 */ 0.83245662593612856917, 0.92361111111111116045, 0.84722222222222220989 },
{ /*191 f=19100 */ 0.82991212330116903573, 0.92581944444444441711, 0.85163888888888883422 },
{ /*192 f=19200 */ 0.82740725852991814371, 0.92800000000000004707, 0.85600000000000009415 },
{ /*193 f=19300 */ 0.82494171936440519044, 0.93015277777777782831, 0.86030555555555554559 },
{ /*194 f=19400 */ 0.82251519901934988521, 0.93227777777777776080, 0.86455555555555563263 },
{ /*195 f=19500 */ 0.82012739611867035983, 0.93437499999999995559, 0.86875000000000002220 },
{ /*196 f=19600 */ 0.81777801463321886377, 0.93644444444444441267, 0.87288888888888893636 },
{ /*197 f=19700 */ 0.81546676381972749148, 0.93848611111111113203, 0.87697222222222215304 },
{ /*198 f=19800 */ 0.81319335816094651115, 0.94050000000000000266, 0.88100000000000000533 },
{ /*199 f=19900 */ 0.81095751730695608828, 0.94248611111111113559, 0.88497222222222227117 },
{ /*200 f=20000 */ 0.80875896601763930249, 0.94444444444444441977, 0.88888888888888895057 },
{ /*201 f=20100 */ 0.80659743410629414218, 0.94637499999999996625, 0.89275000000000004352 },
{ /*202 f=20200 */ 0.80447265638437293056, 0.94827777777777777501, 0.89655555555555555003 },
{ /*203 f=20300 */ 0.80238437260733008749, 0.95015277777777784607, 0.90030555555555558112 },
{ /*204 f=20400 */ 0.80033232742156656947, 0.95199999999999995737, 0.90400000000000002576 },
{ /*205 f=20500 */ 0.79831627031244967174, 0.95381944444444444198, 0.90763888888888888395 },
{ /*206 f=20600 */ 0.79633595555340164207, 0.95561111111111107785, 0.91122222222222215571 },
{ /*207 f=20700 */ 0.79439114215603545688, 0.95737500000000008704, 0.91475000000000006306 },
{ /*208 f=20800 */ 0.79248159382132699058, 0.95911111111111113647, 0.91822222222222227295 },
{ /*209 f=20900 */ 0.79060707889180970032, 0.96081944444444444819, 0.92163888888888889639 },
{ /*210 f=21000 */ 0.78876737030477694912, 0.96250000000000002220, 0.92500000000000004441 },
{ /*211 f=21100 */ 0.78696224554647997707, 0.96415277777777785850, 0.92830555555555560598 },
{ /*212 f=21200 */ 0.78519148660730908595, 0.96577777777777784607, 0.93155555555555558112 },
{ /*213 f=21300 */ 0.78345487993794227233, 0.96737499999999998490, 0.93474999999999996980 },
{ /*214 f=21400 */ 0.78175221640645320420, 0.96894444444444438602, 0.93788888888888888307 },
{ /*215 f=21500 */ 0.78008329125636355350, 0.97048611111111116045, 0.94097222222222220989 },
{ /*216 f=21600 */ 0.77844790406562969221, 0.97199999999999997513, 0.94400000000000006128 },
{ /*217 f=21700 */ 0.77684585870654920825, 0.97348611111111105210, 0.94697222222222221522 },
{ /*218 f=21800 */ 0.77527696330658146806, 0.97494444444444439135, 0.94988888888888889372 },
{ /*219 f=21900 */ 0.77374103021006479519, 0.97637499999999999289, 0.95274999999999998579 },
{ /*220 f=22000 */ 0.77223787594082582419, 0.97777777777777774570, 0.95555555555555549141 },
{ /*221 f=22100 */ 0.77076732116566415431, 0.97915277777777776080, 0.95830555555555552161 },
{ /*222 f=22200 */ 0.76932919065870941644, 0.98050000000000003819, 0.96100000000000007638 },
{ /*223 f=22300 */ 0.76792331326663287872, 0.98181944444444446685, 0.96363888888888893369 },
{ /*224 f=22400 */ 0.76654952187471236957, 0.98311111111111104677, 0.96622222222222220456 },
{ /*225 f=22500 */ 0.76520765337373231052, 0.98437500000000000000, 0.96875000000000000000 },
{ /*226 f=22600 */ 0.76389754862771808153, 0.98561111111111110450, 0.97122222222222220900 },
{ /*227 f=22700 */ 0.76261905244248895386, 0.98681944444444447129, 0.97363888888888883155 },
{ /*228 f=22800 */ 0.76137201353502537149, 0.98799999999999998934, 0.97599999999999997868 },
{ /*229 f=22900 */ 0.76015628450364003399, 0.98915277777777776969, 0.97830555555555553937 },
{ /*230 f=23000 */ 0.75897172179894445421, 0.99027777777777781232, 0.98055555555555562464 },
{ /*231 f=23100 */ 0.75781818569560521759, 0.99137500000000000622, 0.98275000000000001243 },
{ /*232 f=23200 */ 0.75669554026487828580, 0.99244444444444446241, 0.98488888888888892481 },
{ /*233 f=23300 */ 0.75560365334791768088, 0.99348611111111106986, 0.98697222222222225074 },
{ /*234 f=23400 */ 0.75454239652984866904, 0.99449999999999993960, 0.98899999999999999023 },
{ /*235 f=23500 */ 0.75351164511460022588, 0.99548611111111107164, 0.99097222222222225430 },
{ /*236 f=23600 */ 0.75251127810048745737, 0.99644444444444446596, 0.99288888888888882089 },
{ /*237 f=23700 */ 0.75154117815653953549, 0.99737500000000001155, 0.99475000000000002309 },
{ /*238 f=23800 */ 0.75060123159956582128, 0.99827777777777781942, 0.99655555555555552782 },
{ /*239 f=23900 */ 0.74969132837195340269, 0.99915277777777777857, 0.99830555555555555713 },
{ /*240 f=24000 */ 0.74881136202019094039, 1.00000000000000000000, 1.00000000000000000000 }
};
static FLOAT_T moog_q70[241][3] = {
{ /* dummy entry */ 0, 0, 0},
{ /*  1 f=  100 */ 3.16869514185436829123, 0.00748611111111113781, -0.98502777777777772439 },
{ /*  2 f=  200 */ 3.13610244337513055513, 0.01494444444444442688, -0.97011111111111114624 },
{ /*  3 f=  300 */ 3.10396451005360374253, 0.02237499999999997824, -0.95525000000000004352 },
{ /*  4 f=  400 */ 3.07227421914796661184, 0.02977777777777779189, -0.94044444444444441622 },
{ /*  5 f=  500 */ 3.04102457222151745242, 0.03715277777777775681, -0.92569444444444448639 },
{ /*  6 f=  600 */ 3.01020869280107827848, 0.04449999999999998401, -0.91100000000000003197 },
{ /*  7 f=  700 */ 2.97981982408262524586, 0.05181944444444447351, -0.89636111111111105298 },
{ /*  8 f=  800 */ 2.94985132668313676518, 0.05911111111111111427, -0.88177777777777777146 },
{ /*  9 f=  900 */ 2.92029667643767298912, 0.06637500000000001732, -0.86724999999999996536 },
{ /* 10 f= 1000 */ 2.89114946224072966174, 0.07361111111111112715, -0.85277777777777774570 },
{ /* 11 f= 1100 */ 2.86240338393091464653, 0.08081944444444444375, -0.83836111111111111249 },
{ /* 12 f= 1200 */ 2.83405225021803319763, 0.08800000000000002265, -0.82399999999999995470 },
{ /* 13 f= 1300 */ 2.80608997665168580227, 0.09515277777777780832, -0.80969444444444438336 },
{ /* 14 f= 1400 */ 2.77851058363048863953, 0.10227777777777780077, -0.79544444444444439846 },
{ /* 15 f= 1500 */ 2.75130819445106755694, 0.10937500000000000000, -0.78125000000000000000 },
{ /* 16 f= 1600 */ 2.72447703339597158134, 0.11644444444444446152, -0.76711111111111107697 },
{ /* 17 f= 1700 */ 2.69801142385970171844, 0.12348611111111112981, -0.75302777777777774038 },
{ /* 18 f= 1800 */ 2.67190578651203125560, 0.13050000000000000488, -0.73899999999999999023 },
{ /* 19 f= 1900 */ 2.64615463749784662895, 0.13748611111111108674, -0.72502777777777782653 },
{ /* 20 f= 2000 */ 2.62075258667273391922, 0.14444444444444443088, -0.71111111111111113825 },
{ /* 21 f= 2100 */ 2.59569433587355824500, 0.15137499999999998179, -0.69725000000000003642 },
{ /* 22 f= 2200 */ 2.57097467722330552675, 0.15827777777777779500, -0.68344444444444441000 },
{ /* 23 f= 2300 */ 2.54658849146946275610, 0.16515277777777781498, -0.66969444444444437003 },
{ /* 24 f= 2400 */ 2.52253074635523910629, 0.17199999999999998623, -0.65600000000000002753 },
{ /* 25 f= 2500 */ 2.49879649502293643692, 0.17881944444444447528, -0.64236111111111104943 },
{ /* 26 f= 2600 */ 2.47538087444880128274, 0.18561111111111111560, -0.62877777777777776880 },
{ /* 27 f= 2700 */ 2.45227910390869485724, 0.19237500000000001821, -0.61524999999999996358 },
{ /* 28 f= 2800 */ 2.42948648347394557945, 0.19911111111111112759, -0.60177777777777774482 },
{ /* 29 f= 2900 */ 2.40699839253674774397, 0.20581944444444444375, -0.58836111111111111249 },
{ /* 30 f= 3000 */ 2.38481028836450059671, 0.21250000000000002220, -0.57499999999999995559 },
{ /* 31 f= 3100 */ 2.36291770468247896986, 0.21915277777777780743, -0.56169444444444438513 },
{ /* 32 f= 3200 */ 2.34131625028424439350, 0.22577777777777779944, -0.54844444444444440112 },
{ /* 33 f= 3300 */ 2.32000160766923713140, 0.23237499999999999822, -0.53525000000000000355 },
{ /* 34 f= 3400 */ 2.29896953170696605184, 0.23894444444444445930, -0.52211111111111108141 },
{ /* 35 f= 3500 */ 2.27821584832725987368, 0.24548611111111112715, -0.50902777777777774570 },
{ /* 36 f= 3600 */ 2.25773645323603799895, 0.25200000000000000178, -0.49599999999999999645 },
{ /* 37 f= 3700 */ 2.23752731065606980110, 0.25848611111111113869, -0.48302777777777772261 },
{ /* 38 f= 3800 */ 2.21758445209221299876, 0.26494444444444442688, -0.47011111111111114624 },
{ /* 39 f= 3900 */ 2.19790397512062352092, 0.27137500000000003286, -0.45724999999999998979 },
{ /* 40 f= 4000 */ 2.17848204220144703314, 0.27777777777777779011, -0.44444444444444447528 },
{ /* 41 f= 4100 */ 2.15931487951450362672, 0.28415277777777780965, -0.43169444444444443620 },
{ /* 42 f= 4200 */ 2.14039877581750026536, 0.29049999999999998046, -0.41900000000000003908 },
{ /* 43 f= 4300 */ 2.12173008132630691591, 0.29681944444444441356, -0.40636111111111111738 },
{ /* 44 f= 4400 */ 2.10330520661684383654, 0.30311111111111110894, -0.39377777777777778212 },
{ /* 45 f= 4500 */ 2.08512062154813948567, 0.30937500000000001110, -0.38124999999999997780 },
{ /* 46 f= 4600 */ 2.06717285420612295610, 0.31561111111111117555, -0.36877777777777770440 },
{ /* 47 f= 4700 */ 2.04945848986773571099, 0.32181944444444443576, -0.35636111111111112848 },
{ /* 48 f= 4800 */ 2.03197416998493807228, 0.32800000000000001377, -0.34399999999999997247 },
{ /* 49 f= 4900 */ 2.01471659118821833090, 0.33415277777777774304, -0.33169444444444445841 },
{ /* 50 f= 5000 */ 1.99768250430919169780, 0.34027777777777779011, -0.31944444444444441977 },
{ /* 51 f= 5100 */ 1.98086871342192138989, 0.34637499999999998845, -0.30725000000000002309 },
{ /* 52 f= 5200 */ 1.96427207490255972822, 0.35244444444444444908, -0.29511111111111110183 },
{ /* 53 f= 5300 */ 1.94788949650696174842, 0.35848611111111111649, -0.28302777777777776702 },
{ /* 54 f= 5400 */ 1.93171793646588474402, 0.36450000000000004619, -0.27099999999999996314 },
{ /* 55 f= 5500 */ 1.91575440259743934313, 0.37048611111111107164, -0.25902777777777780122 },
{ /* 56 f= 5600 */ 1.89999595143642419082, 0.37644444444444447040, -0.24711111111111108696 },
{ /* 57 f= 5700 */ 1.88443968738022316067, 0.38237500000000002043, -0.23525000000000001465 },
{ /* 58 f= 5800 */ 1.86908276185091448696, 0.38827777777777777724, -0.22344444444444441777 },
{ /* 59 f= 5900 */ 1.85392237247327718030, 0.39415277777777779633, -0.21169444444444446285 },
{ /* 60 f= 6000 */ 1.83895576226837054179, 0.40000000000000002220, -0.19999999999999998335 },
{ /* 61 f= 6100 */ 1.82418021886237569085, 0.40581944444444439934, -0.18836111111111114580 },
{ /* 62 f= 6200 */ 1.80959307371039068713, 0.41161111111111114980, -0.17677777777777770041 },
{ /* 63 f= 6300 */ 1.79519170133488592533, 0.41737500000000005151, -0.16524999999999995248 },
{ /* 64 f= 6400 */ 1.78097351857852026491, 0.42311111111111110450, -0.15377777777777776325 },
{ /* 65 f= 6500 */ 1.76693598387103101288, 0.42881944444444441977, -0.14236111111111113270 },
{ /* 66 f= 6600 */ 1.75307659650992819778, 0.43450000000000005285, -0.13099999999999992206 },
{ /* 67 f= 6700 */ 1.73939289595470025773, 0.44015277777777778168, -0.11969444444444440889 },
{ /* 68 f= 6800 */ 1.72588246113427712380, 0.44577777777777777279, -0.10844444444444444053 },
{ /* 69 f= 6900 */ 1.71254290976748202446, 0.45137499999999997069, -0.09725000000000004474 },
{ /* 70 f= 7000 */ 1.69937189769621110891, 0.45694444444444448639, -0.08611111111111104111 },
{ /* 71 f= 7100 */ 1.68636711823109530783, 0.46248611111111115335, -0.07502777777777774881 },
{ /* 72 f= 7200 */ 1.67352630150938996856, 0.46799999999999997158, -0.06400000000000001521 },
{ /* 73 f= 7300 */ 1.66084721386485822947, 0.47348611111111110761, -0.05302777777777782642 },
{ /* 74 f= 7400 */ 1.64832765720940188636, 0.47894444444444445041, -0.04211111111111105060 },
{ /* 75 f= 7500 */ 1.63596546842622037055, 0.48437500000000000000, -0.03124999999999997918 },
{ /* 76 f= 7600 */ 1.62375851877425692038, 0.48977777777777775636, -0.02044444444444446299 },
{ /* 77 f= 7700 */ 1.61170471330371922747, 0.49515277777777783053, -0.00969444444444435803 },
{ /* 78 f= 7800 */ 1.59980199028245717585, 0.50050000000000005596, 0.00100000000000004794 },
{ /* 79 f= 7900 */ 1.58804832063297651779, 0.50581944444444448816, 0.01163888888888889826 },
{ /* 80 f= 8000 */ 1.57644170737988909003, 0.51111111111111107164, 0.02222222222222219531 },
{ /* 81 f= 8100 */ 1.56498018510758996058, 0.51637500000000002842, 0.03275000000000007766 },
{ /* 82 f= 8200 */ 1.55366181942796344195, 0.52161111111111113647, 0.04322222222222225907 },
{ /* 83 f= 8300 */ 1.54248470645792123968, 0.52681944444444439579, 0.05363888888888888873 },
{ /* 84 f= 8400 */ 1.53144697230657977904, 0.53200000000000002842, 0.06399999999999995970 },
{ /* 85 f= 8500 */ 1.52054677257189596595, 0.53715277777777781232, 0.07430555555555562464 },
{ /* 86 f= 8600 */ 1.50978229184656576045, 0.54227777777777774748, 0.08455555555555557823 },
{ /* 87 f= 8700 */ 1.49915174323301392256, 0.54737499999999994493, 0.09474999999999998701 },
{ /* 88 f= 8800 */ 1.48865336786729907104, 0.55244444444444440467, 0.10488888888888885098 },
{ /* 89 f= 8900 */ 1.47828543445175508708, 0.55748611111111112670, 0.11497222222222228116 },
{ /* 90 f= 9000 */ 1.46804623879620543825, 0.56250000000000000000, 0.12500000000000002776 },
{ /* 91 f= 9100 */ 1.45793410336758122448, 0.56748611111111113559, 0.13497222222222221566 },
{ /* 92 f= 9200 */ 1.44794737684778440645, 0.57244444444444453346, 0.14488888888888898365 },
{ /* 93 f= 9300 */ 1.43808443369963256941, 0.57737499999999997158, 0.15475000000000005418 },
{ /* 94 f= 9400 */ 1.42834367374073289980, 0.58227777777777778301, 0.16455555555555556602 },
{ /* 95 f= 9500 */ 1.41872352172513305213, 0.58715277777777774570, 0.17430555555555554692 },
{ /* 96 f= 9600 */ 1.40922242693259791579, 0.59200000000000008171, 0.18400000000000008016 },
{ /* 97 f= 9700 */ 1.39983886276536795279, 0.59681944444444445796, 0.19363888888888891593 },
{ /* 98 f= 9800 */ 1.39057132635225189077, 0.60161111111111109651, 0.20322222222222222077 },
{ /* 99 f= 9900 */ 1.38141833815991876833, 0.60637499999999999734, 0.21274999999999996692 },
{ /*100 f=10000 */ 1.37237844161124922238, 0.61111111111111116045, 0.22222222222222229315 },
{ /*101 f=10100 */ 1.36345020271061234673, 0.61581944444444447484, 0.23163888888888892192 },
{ /*102 f=10200 */ 1.35463220967593134247, 0.62050000000000005151, 0.24099999999999999201 },
{ /*103 f=10300 */ 1.34592307257741961024, 0.62515277777777777946, 0.25030555555555550340 },
{ /*104 f=10400 */ 1.33732142298284717441, 0.62977777777777776969, 0.25955555555555559488 },
{ /*105 f=10500 */ 1.32882591360922597268, 0.63437500000000002220, 0.26875000000000004441 },
{ /*106 f=10600 */ 1.32043521798078389295, 0.63894444444444442599, 0.27788888888888885198 },
{ /*107 f=10700 */ 1.31214803009311165027, 0.64348611111111120309, 0.28697222222222229515 },
{ /*108 f=10800 */ 1.30396306408336792870, 0.64800000000000002043, 0.29600000000000004086 },
{ /*109 f=10900 */ 1.29587905390642399439, 0.65248611111111110006, 0.30497222222222225563 },
{ /*110 f=11000 */ 1.28789475301683986608, 0.65694444444444444198, 0.31388888888888888395 },
{ /*111 f=11100 */ 1.28000893405656190893, 0.66137500000000004619, 0.32275000000000009237 },
{ /*112 f=11200 */ 1.27222038854823127352, 0.66577777777777780166, 0.33155555555555560332 },
{ /*113 f=11300 */ 1.26452792659400237163, 0.67015277777777781942, 0.34030555555555558334 },
{ /*114 f=11400 */ 1.25693037657976480759, 0.67449999999999998845, 0.34899999999999997691 },
{ /*115 f=11500 */ 1.24942658488466906697, 0.67881944444444441977, 0.35763888888888895057 },
{ /*116 f=11600 */ 1.24201541559585915131, 0.68311111111111111338, 0.36622222222222222676 },
{ /*117 f=11700 */ 1.23469575022830979627, 0.68737499999999995826, 0.37474999999999997202 },
{ /*118 f=11800 */ 1.22746648744967878919, 0.69161111111111106542, 0.38322222222222218635 },
{ /*119 f=11900 */ 1.22032654281007824082, 0.69581944444444443487, 0.39163888888888892525 },
{ /*120 f=12000 */ 1.21327484847667443901, 0.69999999999999995559, 0.40000000000000002220 },
{ /*121 f=12100 */ 1.20631035297302613429, 0.70415277777777773860, 0.40830555555555553271 },
{ /*122 f=12200 */ 1.19943202092307510398, 0.70827777777777778390, 0.41655555555555551228 },
{ /*123 f=12300 */ 1.19263883279970173135, 0.71237499999999998046, 0.42474999999999996092 },
{ /*124 f=12400 */ 1.18592978467776188900, 0.71644444444444443931, 0.43288888888888898965 },
{ /*125 f=12500 */ 1.17930388799152319201, 0.72048611111111116045, 0.44097222222222232091 },
{ /*126 f=12600 */ 1.17276016929641935249, 0.72450000000000003286, 0.44900000000000006573 },
{ /*127 f=12700 */ 1.16629767003504292155, 0.72848611111111116756, 0.45697222222222227961 },
{ /*128 f=12800 */ 1.15991544630729936927, 0.73244444444444445352, 0.46488888888888890705 },
{ /*129 f=12900 */ 1.15361256864464856164, 0.73637500000000000178, 0.47275000000000000355 },
{ /*130 f=13000 */ 1.14738812178835347666, 0.74027777777777781232, 0.48055555555555551361 },
{ /*131 f=13100 */ 1.14124120447166932379, 0.74415277777777777413, 0.48830555555555549274 },
{ /*132 f=13200 */ 1.13517092920589868221, 0.74799999999999999822, 0.49600000000000010747 },
{ /*133 f=13300 */ 1.12917642207024115919, 0.75181944444444448461, 0.50363888888888896922 },
{ /*134 f=13400 */ 1.12325682250537095541, 0.75561111111111112226, 0.51122222222222224453 },
{ /*135 f=13500 */ 1.11741128311067527967, 0.75937500000000002220, 0.51875000000000004441 },
{ /*136 f=13600 */ 1.11163896944508500120, 0.76311111111111107341, 0.52622222222222225785 },
{ /*137 f=13700 */ 1.10593905983143514504, 0.76681944444444449793, 0.53363888888888888484 },
{ /*138 f=13800 */ 1.10031074516429194787, 0.77049999999999996270, 0.54099999999999992539 },
{ /*139 f=13900 */ 1.09475322872117986073, 0.77415277777777791179, 0.54830555555555571257 },
{ /*140 f=14000 */ 1.08926572597715654034, 0.77777777777777790114, 0.55555555555555569125 },
{ /*141 f=14100 */ 1.08384746442266499677, 0.78137500000000004174, 0.56275000000000008349 },
{ /*142 f=14200 */ 1.07849768338461293737, 0.78494444444444444464, 0.56988888888888888928 },
{ /*143 f=14300 */ 1.07321563385061913287, 0.78848611111111110983, 0.57697222222222221966 },
{ /*144 f=14400 */ 1.06800057829636818596, 0.79200000000000003730, 0.58399999999999996358 },
{ /*145 f=14500 */ 1.06285179051602240996, 0.79548611111111111605, 0.59097222222222223209 },
{ /*146 f=14600 */ 1.05776855545563508443, 0.79894444444444445708, 0.59788888888888880313 },
{ /*147 f=14700 */ 1.05275016904950979857, 0.80237500000000006040, 0.60475000000000012079 },
{ /*148 f=14800 */ 1.04779593805945991924, 0.80577777777777781498, 0.61155555555555562997 },
{ /*149 f=14900 */ 1.04290517991690867561, 0.80915277777777783186, 0.61830555555555555269 },
{ /*150 f=15000 */ 1.03807722256779055847, 0.81250000000000000000, 0.62500000000000000000 },
{ /*151 f=15100 */ 1.03331140432019363828, 0.81581944444444443043, 0.63163888888888886086 },
{ /*152 f=15200 */ 1.02860707369470549821, 0.81911111111111112315, 0.63822222222222224630 },
{ /*153 f=15300 */ 1.02396358927740727118, 0.82237499999999996714, 0.64474999999999993427 },
{ /*154 f=15400 */ 1.01938031957547559081, 0.82561111111111118444, 0.65122222222222236887 },
{ /*155 f=15500 */ 1.01485664287534516070, 0.82881944444444455300, 0.65763888888888899498 },
{ /*156 f=15600 */ 1.01039194710338420258, 0.83200000000000007283, 0.66400000000000003464 },
{ /*157 f=15700 */ 1.00598562968904836623, 0.83515277777777785495, 0.67030555555555559888 },
{ /*158 f=15800 */ 1.00163709743045981071, 0.83827777777777778834, 0.67655555555555557667 },
{ /*159 f=15900 */ 0.99734576636237892711, 0.84137499999999998401, 0.68274999999999996803 },
{ /*160 f=16000 */ 0.99311106162652040830, 0.84444444444444444198, 0.68888888888888888395 },
{ /*161 f=16100 */ 0.98893241734418002586, 0.84748611111111116223, 0.69497222222222221344 },
{ /*162 f=16200 */ 0.98480927649112892652, 0.85050000000000003375, 0.70100000000000006750 },
{ /*163 f=16300 */ 0.98074109077473659024, 0.85348611111111116756, 0.70697222222222233512 },
{ /*164 f=16400 */ 0.97672732051328847724, 0.85644444444444445264, 0.71288888888888890527 },
{ /*165 f=16500 */ 0.97276743451745739666, 0.85937500000000000000, 0.71875000000000000000 },
{ /*166 f=16600 */ 0.96886090997389517909, 0.86227777777777769863, 0.72455555555555550828 },
{ /*167 f=16700 */ 0.96500723233090590636, 0.86515277777777777057, 0.73030555555555554115 },
{ /*168 f=16800 */ 0.96120589518617094438, 0.86799999999999999378, 0.73599999999999998757 },
{ /*169 f=16900 */ 0.95745640017648647735, 0.87081944444444447928, 0.74163888888888895856 },
{ /*170 f=17000 */ 0.95375825686948290105, 0.87361111111111111605, 0.74722222222222234311 },
{ /*171 f=17100 */ 0.95011098265729254653, 0.87637500000000001510, 0.75275000000000003020 },
{ /*172 f=17200 */ 0.94651410265213431483, 0.87911111111111117644, 0.75822222222222224186 },
{ /*173 f=17300 */ 0.94296714958378280436, 0.88181944444444448905, 0.76363888888888886708 },
{ /*174 f=17400 */ 0.93946966369889151061, 0.88450000000000006395, 0.76900000000000001688 },
{ /*175 f=17500 */ 0.93602119266213956728, 0.88715277777777779011, 0.77430555555555558023 },
{ /*176 f=17600 */ 0.93262129145917282980, 0.88977777777777777857, 0.77955555555555555713 },
{ /*177 f=17700 */ 0.92926952230131099064, 0.89237500000000002931, 0.78475000000000005862 },
{ /*178 f=17800 */ 0.92596545453198919606, 0.89494444444444454234, 0.78988888888888897366 },
{ /*179 f=17900 */ 0.92270866453491140469, 0.89748611111111120664, 0.79497222222222230226 },
{ /*180 f=18000 */ 0.91949873564388184821, 0.90000000000000002220, 0.80000000000000004441 },
{ /*181 f=18100 */ 0.91633525805429394406, 0.90248611111111110006, 0.80497222222222220012 },
{ /*182 f=18200 */ 0.91321782873624668397, 0.90494444444444444020, 0.80988888888888888040 },
{ /*183 f=18300 */ 0.91014605134926285235, 0.90737500000000004263, 0.81474999999999997424 },
{ /*184 f=18400 */ 0.90711953615858686994, 0.90977777777777779633, 0.81955555555555559266 },
{ /*185 f=18500 */ 0.90413789995303328606, 0.91215277777777781232, 0.82430555555555562464 },
{ /*186 f=18600 */ 0.90120076596436471394, 0.91450000000000009059, 0.82900000000000007017 },
{ /*187 f=18700 */ 0.89830776378817689398, 0.91681944444444440911, 0.83363888888888892925 },
{ /*188 f=18800 */ 0.89545852930626157473, 0.91911111111111110095, 0.83822222222222220189 },
{ /*189 f=18900 */ 0.89265270461043200179, 0.92137500000000005507, 0.84274999999999999911 },
{ /*190 f=19000 */ 0.88988993792778370295, 0.92361111111111116045, 0.84722222222222220989 },
{ /*191 f=19100 */ 0.88716988354737080780, 0.92581944444444441711, 0.85163888888888883422 },
{ /*192 f=19200 */ 0.88449220174827491991, 0.92800000000000004707, 0.85600000000000009415 },
{ /*193 f=19300 */ 0.88185655872904911146, 0.93015277777777782831, 0.86030555555555554559 },
{ /*194 f=19400 */ 0.87926262653851194884, 0.93227777777777776080, 0.86455555555555563263 },
{ /*195 f=19500 */ 0.87671008300787445222, 0.93437499999999995559, 0.86875000000000002220 },
{ /*196 f=19600 */ 0.87419861168418111497, 0.93644444444444441267, 0.87288888888888893636 },
{ /*197 f=19700 */ 0.87172790176504222348, 0.93848611111111113203, 0.87697222222222215304 },
{ /*198 f=19800 */ 0.86929764803464237843, 0.94050000000000000266, 0.88100000000000000533 },
{ /*199 f=19900 */ 0.86690755080100390106, 0.94248611111111113559, 0.88497222222222227117 },
{ /*200 f=20000 */ 0.86455731583449013655, 0.94444444444444441977, 0.88888888888888895057 },
{ /*201 f=20100 */ 0.86224665430752733819, 0.94637499999999996625, 0.89275000000000004352 },
{ /*202 f=20200 */ 0.85997528273553158762, 0.94827777777777777501, 0.89655555555555555003 },
{ /*203 f=20300 */ 0.85774292291902054508, 0.95015277777777784607, 0.90030555555555558112 },
{ /*204 f=20400 */ 0.85554930188689692905, 0.95199999999999995737, 0.90400000000000002576 },
{ /*205 f=20500 */ 0.85339415184088285304, 0.95381944444444444198, 0.90763888888888888395 },
{ /*206 f=20600 */ 0.85127721010109558275, 0.95561111111111107785, 0.91122222222222215571 },
{ /*207 f=20700 */ 0.84919821905274261997, 0.95737500000000008704, 0.91475000000000006306 },
{ /*208 f=20800 */ 0.84715692609392589940, 0.95911111111111113647, 0.91822222222222227295 },
{ /*209 f=20900 */ 0.84515308358453744564, 0.96081944444444444819, 0.92163888888888889639 },
{ /*210 f=21000 */ 0.84318644879623383392, 0.96250000000000002220, 0.92500000000000004441 },
{ /*211 f=21100 */ 0.84125678386347368942, 0.96415277777777785850, 0.92830555555555560598 },
{ /*212 f=21200 */ 0.83936385573560656770, 0.96577777777777784607, 0.93155555555555558112 },
{ /*213 f=21300 */ 0.83750743612999656307, 0.96737499999999998490, 0.93474999999999996980 },
{ /*214 f=21400 */ 0.83568730148617076381, 0.96894444444444438602, 0.93788888888888888307 },
{ /*215 f=21500 */ 0.83390323292097767727, 0.97048611111111116045, 0.94097222222222220989 },
{ /*216 f=21600 */ 0.83215501618474407852, 0.97199999999999997513, 0.94400000000000006128 },
{ /*217 f=21700 */ 0.83044244161841573870, 0.97348611111111105210, 0.94697222222222221522 },
{ /*218 f=21800 */ 0.82876530411167481649, 0.97494444444444439135, 0.94988888888888889372 },
{ /*219 f=21900 */ 0.82712340306201548312, 0.97637499999999999289, 0.95274999999999998579 },
{ /*220 f=22000 */ 0.82551654233477367306, 0.97777777777777774570, 0.95555555555555549141 },
{ /*221 f=22100 */ 0.82394453022409308574, 0.97915277777777776080, 0.95830555555555552161 },
{ /*222 f=22200 */ 0.82240717941482188724, 0.98050000000000003819, 0.96100000000000007638 },
{ /*223 f=22300 */ 0.82090430694532567912, 0.98181944444444446685, 0.96363888888888893369 },
{ /*224 f=22400 */ 0.81943573417121018387, 0.98311111111111104677, 0.96622222222222220456 },
{ /*225 f=22500 */ 0.81800128672993765999, 0.98437500000000000000, 0.96875000000000000000 },
{ /*226 f=22600 */ 0.81660079450633571430, 0.98561111111111110450, 0.97122222222222220900 },
{ /*227 f=22700 */ 0.81523409159897997078, 0.98681944444444447129, 0.97363888888888883155 },
{ /*228 f=22800 */ 0.81390101628744837559, 0.98799999999999998934, 0.97599999999999997868 },
{ /*229 f=22900 */ 0.81260141100043437046, 0.98915277777777776969, 0.97830555555555553937 },
{ /*230 f=23000 */ 0.81133512228470983096, 0.99027777777777781232, 0.98055555555555562464 },
{ /*231 f=23100 */ 0.81010200077493299542, 0.99137500000000000622, 0.98275000000000001243 },
{ /*232 f=23200 */ 0.80890190116428839495, 0.99244444444444446241, 0.98488888888888892481 },
{ /*233 f=23300 */ 0.80773468217595301155, 0.99348611111111106986, 0.98697222222222225074 },
{ /*234 f=23400 */ 0.80660020653538155866, 0.99449999999999993960, 0.98899999999999999023 },
{ /*235 f=23500 */ 0.80549834094340200252, 0.99548611111111107164, 0.99097222222222225430 },
{ /*236 f=23600 */ 0.80442895605011377480, 0.99644444444444446596, 0.99288888888888882089 },
{ /*237 f=23700 */ 0.80339192642958212609, 0.99737500000000001155, 0.99475000000000002309 },
{ /*238 f=23800 */ 0.80238713055532240315, 0.99827777777777781942, 0.99655555555555552782 },
{ /*239 f=23900 */ 0.80141445077656547902, 0.99915277777777777857, 0.99830555555555555713 },
{ /*240 f=24000 */ 0.80047377329529989520, 1.00000000000000000000, 1.00000000000000000000 }
};
static FLOAT_T moog_q80[241][3] = {
{ /* dummy entry */ 0, 0, 0},
{ /*  1 f=  100 */ 3.33114076771220712914, 0.00748611111111113781, -0.98502777777777772439 },
{ /*  2 f=  200 */ 3.29687717914546274400, 0.01494444444444442688, -0.97011111111111114624 },
{ /*  3 f=  300 */ 3.26309166962664365386, 0.02237499999999997824, -0.95525000000000004352 },
{ /*  4 f=  400 */ 3.22977675126102026226, 0.02977777777777779189, -0.94044444444444441622 },
{ /*  5 f=  500 */ 3.19692506683157784408, 0.03715277777777775681, -0.92569444444444448639 },
{ /*  6 f=  600 */ 3.16452938733738209365, 0.04449999999999998401, -0.91100000000000003197 },
{ /*  7 f=  700 */ 3.13258260958158585296, 0.05181944444444447351, -0.89636111111111105298 },
{ /*  8 f=  800 */ 3.10107775380802230814, 0.05911111111111111427, -0.88177777777777777146 },
{ /*  9 f=  900 */ 3.07000796138535170243, 0.06637500000000001732, -0.86724999999999996536 },
{ /* 10 f= 1000 */ 3.03936649253774993085, 0.07361111111111112715, -0.85277777777777774570 },
{ /* 11 f= 1100 */ 3.00914672412114070355, 0.08081944444444444375, -0.83836111111111111249 },
{ /* 12 f= 1200 */ 2.97934214744401337782, 0.08800000000000002265, -0.82399999999999995470 },
{ /* 13 f= 1300 */ 2.94994636613187699581, 0.09515277777777780832, -0.80969444444444438336 },
{ /* 14 f= 1400 */ 2.92095309403442193741, 0.10227777777777780077, -0.79544444444444439846 },
{ /* 15 f= 1500 */ 2.89235615317449612505, 0.10937500000000000000, -0.78125000000000000000 },
{ /* 16 f= 1600 */ 2.86414947173799294688, 0.11644444444444446152, -0.76711111111111107697 },
{ /* 17 f= 1700 */ 2.83632708210380757308, 0.12348611111111112981, -0.75302777777777774038 },
{ /* 18 f= 1800 */ 2.80888311891300235246, 0.13050000000000000488, -0.73899999999999999023 },
{ /* 19 f= 1900 */ 2.78181181717635661599, 0.13748611111111108674, -0.72502777777777782653 },
{ /* 20 f= 2000 */ 2.75510751041950330276, 0.14444444444444443088, -0.71111111111111113825 },
{ /* 21 f= 2100 */ 2.72876462886484505432, 0.15137499999999998179, -0.69725000000000003642 },
{ /* 22 f= 2200 */ 2.70277769764949393760, 0.15827777777777779500, -0.68344444444444441000 },
{ /* 23 f= 2300 */ 2.67714133507846741011, 0.16515277777777781498, -0.66969444444444437003 },
{ /* 24 f= 2400 */ 2.65185025091240911266, 0.17199999999999998623, -0.65600000000000002753 },
{ /* 25 f= 2500 */ 2.62689924468910529498, 0.17881944444444447528, -0.64236111111111104943 },
{ /* 26 f= 2600 */ 2.60228320407810009840, 0.18561111111111111560, -0.62877777777777776880 },
{ /* 27 f= 2700 */ 2.57799710326770581403, 0.19237500000000001821, -0.61524999999999996358 },
{ /* 28 f= 2800 */ 2.55403600138374464734, 0.19911111111111112759, -0.60177777777777774482 },
{ /* 29 f= 2900 */ 2.53039504093935185836, 0.20581944444444444375, -0.58836111111111111249 },
{ /* 30 f= 3000 */ 2.50706944631519945688, 0.21250000000000002220, -0.57499999999999995559 },
{ /* 31 f= 3100 */ 2.48405452226950629324, 0.21915277777777780743, -0.56169444444444438513 },
{ /* 32 f= 3200 */ 2.46134565247721592840, 0.22577777777777779944, -0.54844444444444440112 },
{ /* 33 f= 3300 */ 2.43893829809773610151, 0.23237499999999999822, -0.53525000000000000355 },
{ /* 34 f= 3400 */ 2.41682799637065315324, 0.23894444444444445930, -0.52211111111111108141 },
{ /* 35 f= 3500 */ 2.39501035923883609513, 0.24548611111111112715, -0.50902777777777774570 },
{ /* 36 f= 3600 */ 2.37348107199836944048, 0.25200000000000000178, -0.49599999999999999645 },
{ /* 37 f= 3700 */ 2.35223589197475746460, 0.25848611111111113869, -0.48302777777777772261 },
{ /* 38 f= 3800 */ 2.33127064722486165849, 0.26494444444444442688, -0.47011111111111114624 },
{ /* 39 f= 3900 */ 2.31058123526403935699, 0.27137500000000003286, -0.45724999999999998979 },
{ /* 40 f= 4000 */ 2.29016362181796306885, 0.27777777777777779011, -0.44444444444444447528 },
{ /* 41 f= 4100 */ 2.27001383959862224060, 0.28415277777777780965, -0.43169444444444443620 },
{ /* 42 f= 4200 */ 2.25012798710399453128, 0.29049999999999998046, -0.41900000000000003908 },
{ /* 43 f= 4300 */ 2.23050222744092208060, 0.29681944444444441356, -0.40636111111111111738 },
{ /* 44 f= 4400 */ 2.21113278717070294022, 0.30311111111111110894, -0.39377777777777778212 },
{ /* 45 f= 4500 */ 2.19201595517693714754, 0.30937500000000001110, -0.38124999999999997780 },
{ /* 46 f= 4600 */ 2.17314808155517358301, 0.31561111111111117555, -0.36877777777777770440 },
{ /* 47 f= 4700 */ 2.15452557652391440968, 0.32181944444444443576, -0.35636111111111112848 },
{ /* 48 f= 4800 */ 2.13614490935653789094, 0.32800000000000001377, -0.34399999999999997247 },
{ /* 49 f= 4900 */ 2.11800260733371947808, 0.33415277777777774304, -0.33169444444444445841 },
{ /* 50 f= 5000 */ 2.10009525471592528589, 0.34027777777777779011, -0.31944444444444441977 },
{ /* 51 f= 5100 */ 2.08241949173558493769, 0.34637499999999998845, -0.30725000000000002309 },
{ /* 52 f= 5200 */ 2.06497201360852411511, 0.35244444444444444908, -0.29511111111111110183 },
{ /* 53 f= 5300 */ 2.04774956956429177168, 0.35848611111111111649, -0.28302777777777776702 },
{ /* 54 f= 5400 */ 2.03074896189497478005, 0.36450000000000004619, -0.27099999999999996314 },
{ /* 55 f= 5500 */ 2.01396704502214696220, 0.37048611111111107164, -0.25902777777777780122 },
{ /* 56 f= 5600 */ 1.99740072458156991964, 0.37644444444444447040, -0.24711111111111108696 },
{ /* 57 f= 5700 */ 1.98104695652530260475, 0.38237500000000002043, -0.23525000000000001465 },
{ /* 58 f= 5800 */ 1.96490274624085614619, 0.38827777777777777724, -0.22344444444444441777 },
{ /* 59 f= 5900 */ 1.94896514768706019538, 0.39415277777777779633, -0.21169444444444446285 },
{ /* 60 f= 6000 */ 1.93323126254629973353, 0.40000000000000002220, -0.19999999999999998335 },
{ /* 61 f= 6100 */ 1.91769823939279837610, 0.40581944444444439934, -0.18836111111111114580 },
{ /* 62 f= 6200 */ 1.90236327287662065899, 0.41161111111111114980, -0.17677777777777770041 },
{ /* 63 f= 6300 */ 1.88722360292308444230, 0.41737500000000005151, -0.16524999999999995248 },
{ /* 64 f= 6400 */ 1.87227651394727501177, 0.42311111111111110450, -0.15377777777777776325 },
{ /* 65 f= 6500 */ 1.85751933408334934938, 0.42881944444444441977, -0.14236111111111113270 },
{ /* 66 f= 6600 */ 1.84294943442835523761, 0.43450000000000005285, -0.13099999999999992206 },
{ /* 67 f= 6700 */ 1.82856422830025477921, 0.44015277777777778168, -0.11969444444444440889 },
{ /* 68 f= 6800 */ 1.81436117050988232613, 0.44577777777777777279, -0.10844444444444444053 },
{ /* 69 f= 6900 */ 1.80033775664655992799, 0.45137499999999997069, -0.09725000000000004474 },
{ /* 70 f= 7000 */ 1.78649152237709230029, 0.45694444444444448639, -0.08611111111111104111 },
{ /* 71 f= 7100 */ 1.77282004275788174219, 0.46248611111111115335, -0.07502777777777774881 },
{ /* 72 f= 7200 */ 1.75932093155990099120, 0.46799999999999997158, -0.06400000000000001521 },
{ /* 73 f= 7300 */ 1.74599184060627288240, 0.47348611111111110761, -0.05302777777777782642 },
{ /* 74 f= 7400 */ 1.73283045912220012852, 0.47894444444444445041, -0.04211111111111105060 },
{ /* 75 f= 7500 */ 1.71983451309701362852, 0.48437500000000000000, -0.03124999999999997918 },
{ /* 76 f= 7600 */ 1.70700176465808728388, 0.48977777777777775636, -0.02044444444444446299 },
{ /* 77 f= 7700 */ 1.69433001145639461349, 0.49515277777777783053, -0.00969444444444435803 },
{ /* 78 f= 7800 */ 1.68181708606348045976, 0.50050000000000005596, 0.00100000000000004794 },
{ /* 79 f= 7900 */ 1.66946085537961197431, 0.50581944444444448816, 0.01163888888888889826 },
{ /* 80 f= 8000 */ 1.65725922005290082772, 0.51111111111111107164, 0.02222222222222219531 },
{ /* 81 f= 8100 */ 1.64521011390917948347, 0.51637500000000002842, 0.03275000000000007766 },
{ /* 82 f= 8200 */ 1.63331150339241837344, 0.52161111111111113647, 0.04322222222222225907 },
{ /* 83 f= 8300 */ 1.62156138701547836156, 0.52681944444444439579, 0.05363888888888888873 },
{ /* 84 f= 8400 */ 1.60995779482100020985, 0.53200000000000002842, 0.06399999999999995970 },
{ /* 85 f= 8500 */ 1.59849878785223209476, 0.53715277777777781232, 0.07430555555555562464 },
{ /* 86 f= 8600 */ 1.58718245763359977474, 0.54227777777777774748, 0.08455555555555557823 },
{ /* 87 f= 8700 */ 1.57600692566083155910, 0.54737499999999994493, 0.09474999999999998701 },
{ /* 88 f= 8800 */ 1.56497034290045511362, 0.55244444444444440467, 0.10488888888888885098 },
{ /* 89 f= 8900 */ 1.55407088929848047343, 0.55748611111111112670, 0.11497222222222228116 },
{ /* 90 f= 9000 */ 1.54330677329809362597, 0.56250000000000000000, 0.12500000000000002776 },
{ /* 91 f= 9100 */ 1.53267623136618524882, 0.56748611111111113559, 0.13497222222222221566 },
{ /* 92 f= 9200 */ 1.52217752752854829090, 0.57244444444444453346, 0.14488888888888898365 },
{ /* 93 f= 9300 */ 1.51180895291357009214, 0.57737499999999997158, 0.15475000000000005418 },
{ /* 94 f= 9400 */ 1.50156882530425983546, 0.58227777777777778301, 0.16455555555555556602 },
{ /* 95 f= 9500 */ 1.49145548869845456785, 0.58715277777777774570, 0.17430555555555554692 },
{ /* 96 f= 9600 */ 1.48146731287703725677, 0.59200000000000008171, 0.18400000000000008016 },
{ /* 97 f= 9700 */ 1.47160269298002499561, 0.59681944444444445796, 0.19363888888888891593 },
{ /* 98 f= 9800 */ 1.46186004909036326715, 0.60161111111111109651, 0.20322222222222222077 },
{ /* 99 f= 9900 */ 1.45223782582529192808, 0.60637499999999999734, 0.21274999999999996692 },
{ /*100 f=10000 */ 1.44273449193513081390, 0.61111111111111116045, 0.22222222222222229315 },
{ /*101 f=10100 */ 1.43334853990934485424, 0.61581944444444447484, 0.23163888888888892192 },
{ /*102 f=10200 */ 1.42407848558974969855, 0.62050000000000005151, 0.24099999999999999201 },
{ /*103 f=10300 */ 1.41492286779072418135, 0.62515277777777777946, 0.25030555555555550340 },
{ /*104 f=10400 */ 1.40588024792629395776, 0.62977777777777776969, 0.25955555555555559488 },
{ /*105 f=10500 */ 1.39694920964395885576, 0.63437500000000002220, 0.26875000000000004441 },
{ /*106 f=10600 */ 1.38812835846513227267, 0.63894444444444442599, 0.27788888888888885198 },
{ /*107 f=10700 */ 1.37941632143207137950, 0.64348611111111120309, 0.28697222222222229515 },
{ /*108 f=10800 */ 1.37081174676117378830, 0.64800000000000002043, 0.29600000000000004086 },
{ /*109 f=10900 */ 1.36231330350252100025, 0.65248611111111110006, 0.30497222222222225563 },
{ /*110 f=11000 */ 1.35391968120554939681, 0.65694444444444444198, 0.31388888888888888395 },
{ /*111 f=11100 */ 1.34562958959073819543, 0.66137500000000004619, 0.32275000000000009237 },
{ /*112 f=11200 */ 1.33744175822719513214, 0.66577777777777780166, 0.33155555555555560332 },
{ /*113 f=11300 */ 1.32935493621603395553, 0.67015277777777781942, 0.34030555555555558334 },
{ /*114 f=11400 */ 1.32136789187943404222, 0.67449999999999998845, 0.34899999999999997691 },
{ /*115 f=11500 */ 1.31347941245527444210, 0.67881944444444441977, 0.35763888888888895057 },
{ /*116 f=11600 */ 1.30568830379724043489, 0.68311111111111111338, 0.36622222222222222676 },
{ /*117 f=11700 */ 1.29799339008030067966, 0.68737499999999995826, 0.37474999999999997202 },
{ /*118 f=11800 */ 1.29039351351145259450, 0.69161111111111106542, 0.38322222222222218635 },
{ /*119 f=11900 */ 1.28288753404563937721, 0.69581944444444443487, 0.39163888888888892525 },
{ /*120 f=12000 */ 1.27547432910674451989, 0.69999999999999995559, 0.40000000000000002220 },
{ /*121 f=12100 */ 1.26815279331356789427, 0.70415277777777773860, 0.40830555555555553271 },
{ /*122 f=12200 */ 1.26092183821069081517, 0.70827777777777778390, 0.41655555555555551228 },
{ /*123 f=12300 */ 1.25378039200414148624, 0.71237499999999998046, 0.42474999999999996092 },
{ /*124 f=12400 */ 1.24672739930177089995, 0.71644444444444443931, 0.43288888888888898965 },
{ /*125 f=12500 */ 1.23976182085825348267, 0.72048611111111116045, 0.44097222222222232091 },
{ /*126 f=12600 */ 1.23288263332462899591, 0.72450000000000003286, 0.44900000000000006573 },
{ /*127 f=12700 */ 1.22608882900229732016, 0.72848611111111116756, 0.45697222222222227961 },
{ /*128 f=12800 */ 1.21937941560139040398, 0.73244444444444445352, 0.46488888888888890705 },
{ /*129 f=12900 */ 1.21275341600343877779, 0.73637500000000000178, 0.47275000000000000355 },
{ /*130 f=13000 */ 1.20620986802825269635, 0.74027777777777781232, 0.48055555555555551361 },
{ /*131 f=13100 */ 1.19974782420494574531, 0.74415277777777777413, 0.48830555555555549274 },
{ /*132 f=13200 */ 1.19336635154702075390, 0.74799999999999999822, 0.49600000000000010747 },
{ /*133 f=13300 */ 1.18706453133144629319, 0.75181944444444448461, 0.50363888888888896922 },
{ /*134 f=13400 */ 1.18084145888165203964, 0.75561111111111112226, 0.51122222222222224453 },
{ /*135 f=13500 */ 1.17469624335437261564, 0.75937500000000002220, 0.51875000000000004441 },
{ /*136 f=13600 */ 1.16862800753026685463, 0.76311111111111107341, 0.52622222222222225785 },
{ /*137 f=13700 */ 1.16263588760825009594, 0.76681944444444449793, 0.53363888888888888484 },
{ /*138 f=13800 */ 1.15671903300346734511, 0.77049999999999996270, 0.54099999999999992539 },
{ /*139 f=13900 */ 1.15087660614884512711, 0.77415277777777791179, 0.54830555555555571257 },
{ /*140 f=14000 */ 1.14510778230015786150, 0.77777777777777790114, 0.55555555555555569125 },
{ /*141 f=14100 */ 1.13941174934454458878, 0.78137500000000004174, 0.56275000000000008349 },
{ /*142 f=14200 */ 1.13378770761241387532, 0.78494444444444444464, 0.56988888888888888928 },
{ /*143 f=14300 */ 1.12823486969268094171, 0.78848611111111110983, 0.57697222222222221966 },
{ /*144 f=14400 */ 1.12275246025127173333, 0.79200000000000003730, 0.58399999999999996358 },
{ /*145 f=14500 */ 1.11733971585284086459, 0.79548611111111111605, 0.59097222222222223209 },
{ /*146 f=14600 */ 1.11199588478564281857, 0.79894444444444445708, 0.59788888888888880313 },
{ /*147 f=14700 */ 1.10672022688950533187, 0.80237500000000006040, 0.60475000000000012079 },
{ /*148 f=14800 */ 1.10151201338684545661, 0.80577777777777781498, 0.61155555555555562997 },
{ /*149 f=14900 */ 1.09637052671667678538, 0.80915277777777783186, 0.61830555555555555269 },
{ /*150 f=15000 */ 1.09129506037155810105, 0.81250000000000000000, 0.62500000000000000000 },
{ /*151 f=15100 */ 1.08628491873742571983, 0.81581944444444443043, 0.63163888888888886086 },
{ /*152 f=15200 */ 1.08133941693626800529, 0.81911111111111112315, 0.63822222222222224630 },
{ /*153 f=15300 */ 1.07645788067158143519, 0.82237499999999996714, 0.64474999999999993427 },
{ /*154 f=15400 */ 1.07163964607657091754, 0.82561111111111118444, 0.65122222222222236887 },
{ /*155 f=15500 */ 1.06688405956504039906, 0.82881944444444455300, 0.65763888888888899498 },
{ /*156 f=15600 */ 1.06219047768492691475, 0.83200000000000007283, 0.66400000000000003464 },
{ /*157 f=15700 */ 1.05755826697443722217, 0.83515277777777785495, 0.67030555555555559888 },
{ /*158 f=15800 */ 1.05298680382073728268, 0.83827777777777778834, 0.67655555555555557667 },
{ /*159 f=15900 */ 1.04847547432115373311, 0.84137499999999998401, 0.68274999999999996803 },
{ /*160 f=16000 */ 1.04402367414684382751, 0.84444444444444444198, 0.68888888888888888395 },
{ /*161 f=16100 */ 1.03963080840889032785, 0.84748611111111116223, 0.69497222222222221344 },
{ /*162 f=16200 */ 1.03529629152678337434, 0.85050000000000003375, 0.70100000000000006750 },
{ /*163 f=16300 */ 1.03101954709924337195, 0.85348611111111116756, 0.70697222222222233512 },
{ /*164 f=16400 */ 1.02680000777735180861, 0.85644444444444445264, 0.71288888888888890527 },
{ /*165 f=16500 */ 1.02263711513994737246, 0.85937500000000000000, 0.71875000000000000000 },
{ /*166 f=16600 */ 1.01853031957124740003, 0.86227777777777769863, 0.72455555555555550828 },
{ /*167 f=16700 */ 1.01447908014066268123, 0.86515277777777777057, 0.73030555555555554115 },
{ /*168 f=16800 */ 1.01048286448476498656, 0.86799999999999999378, 0.73599999999999998757 },
{ /*169 f=16900 */ 1.00654114869137245591, 0.87081944444444447928, 0.74163888888888895856 },
{ /*170 f=17000 */ 1.00265341718571798779, 0.87361111111111111605, 0.74722222222222234311 },
{ /*171 f=17100 */ 0.99881916261866521278, 0.87637500000000001510, 0.75275000000000003020 },
{ /*172 f=17200 */ 0.99503788575694118723, 0.87911111111111117644, 0.75822222222222224186 },
{ /*173 f=17300 */ 0.99130909537534805942, 0.88181944444444448905, 0.76363888888888886708 },
{ /*174 f=17400 */ 0.98763230815092561965, 0.88450000000000006395, 0.76900000000000001688 },
{ /*175 f=17500 */ 0.98400704855903053936, 0.88715277777777779011, 0.77430555555555558023 },
{ /*176 f=17600 */ 0.98043284877130065791, 0.88977777777777777857, 0.77955555555555555713 },
{ /*177 f=17700 */ 0.97690924855547811578, 0.89237500000000002931, 0.78475000000000005862 },
{ /*178 f=17800 */ 0.97343579517705347559, 0.89494444444444454234, 0.78988888888888897366 },
{ /*179 f=17900 */ 0.97001204330271117993, 0.89748611111111120664, 0.79497222222222230226 },
{ /*180 f=18000 */ 0.96663755490553826544, 0.90000000000000002220, 0.80000000000000004441 },
{ /*181 f=18100 */ 0.96331189917197557193, 0.90248611111111110006, 0.80497222222222220012 },
{ /*182 f=18200 */ 0.96003465241048013823, 0.90494444444444444020, 0.80988888888888888040 },
{ /*183 f=18300 */ 0.95680539796187136226, 0.90737500000000004263, 0.81474999999999997424 },
{ /*184 f=18400 */ 0.95362372611133772171, 0.90977777777777779633, 0.81955555555555559266 },
{ /*185 f=18500 */ 0.95048923400207341317, 0.91215277777777781232, 0.82430555555555562464 },
{ /*186 f=18600 */ 0.94740152555052403738, 0.91450000000000009059, 0.82900000000000007017 },
{ /*187 f=18700 */ 0.94436021136321490754, 0.91681944444444440911, 0.83363888888888892925 },
{ /*188 f=18800 */ 0.94136490865513389181, 0.91911111111111110095, 0.83822222222222220189 },
{ /*189 f=18900 */ 0.93841524116965224778, 0.92137500000000005507, 0.84274999999999999911 },
{ /*190 f=19000 */ 0.93551083909995325083, 0.92361111111111116045, 0.84722222222222220989 },
{ /*191 f=19100 */ 0.93265133901195018673, 0.92581944444444441711, 0.85163888888888883422 },
{ /*192 f=19200 */ 0.92983638376866684094, 0.92800000000000004707, 0.85600000000000009415 },
{ /*193 f=19300 */ 0.92706562245606516370, 0.93015277777777782831, 0.86030555555555554559 },
{ /*194 f=19400 */ 0.92433871031029057885, 0.93227777777777776080, 0.86455555555555563263 },
{ /*195 f=19500 */ 0.92165530864632039254, 0.93437499999999995559, 0.86875000000000002220 },
{ /*196 f=19600 */ 0.91901508478799132096, 0.93644444444444441267, 0.87288888888888893636 },
{ /*197 f=19700 */ 0.91641771199938726333, 0.93848611111111113203, 0.87697222222222215304 },
{ /*198 f=19800 */ 0.91386286941756600388, 0.94050000000000000266, 0.88100000000000000533 },
{ /*199 f=19900 */ 0.91135024198660719019, 0.94248611111111113559, 0.88497222222222227117 },
{ /*200 f=20000 */ 0.90887952039296249218, 0.94444444444444441977, 0.88888888888888895057 },
{ /*201 f=20100 */ 0.90645040100208751355, 0.94637499999999996625, 0.89275000000000004352 },
{ /*202 f=20200 */ 0.90406258579634013461, 0.94827777777777777501, 0.89655555555555555003 },
{ /*203 f=20300 */ 0.90171578231412485849, 0.95015277777777784607, 0.90030555555555558112 },
{ /*204 f=20400 */ 0.89940970359026828351, 0.95199999999999995737, 0.90400000000000002576 },
{ /*205 f=20500 */ 0.89714406809760527395, 0.95381944444444444198, 0.90763888888888888395 },
{ /*206 f=20600 */ 0.89491859968976406048, 0.95561111111111107785, 0.91122222222222215571 },
{ /*207 f=20700 */ 0.89273302754512895429, 0.95737500000000008704, 0.91475000000000006306 },
{ /*208 f=20800 */ 0.89058708611196890637, 0.95911111111111113647, 0.91822222222222227295 },
{ /*209 f=20900 */ 0.88848051505471270506, 0.96081944444444444819, 0.92163888888888889639 },
{ /*210 f=21000 */ 0.88641305920135937679, 0.96250000000000002220, 0.92500000000000004441 },
{ /*211 f=21100 */ 0.88438446849200502697, 0.96415277777777785850, 0.92830555555555560598 },
{ /*212 f=21200 */ 0.88239449792847612919, 0.96577777777777784607, 0.93155555555555558112 },
{ /*213 f=21300 */ 0.88044290752504938968, 0.96737499999999998490, 0.93474999999999996980 },
{ /*214 f=21400 */ 0.87852946226025019349, 0.96894444444444438602, 0.93788888888888888307 },
{ /*215 f=21500 */ 0.87665393202971164666, 0.97048611111111116045, 0.94097222222222220989 },
{ /*216 f=21600 */ 0.87481609160008400039, 0.97199999999999997513, 0.94400000000000006128 },
{ /*217 f=21700 */ 0.87301572056397835908, 0.97348611111111105210, 0.94697222222222221522 },
{ /*218 f=21800 */ 0.87125260329593656738, 0.97494444444444439135, 0.94988888888888889372 },
{ /*219 f=21900 */ 0.86952652890940873576, 0.97637499999999999289, 0.95274999999999998579 },
{ /*220 f=22000 */ 0.86783729121473474066, 0.97777777777777774570, 0.95555555555555549141 },
{ /*221 f=22100 */ 0.86618468867810793910, 0.97915277777777776080, 0.95830555555555552161 },
{ /*222 f=22200 */ 0.86456852438151943208, 0.98050000000000003819, 0.96100000000000007638 },
{ /*223 f=22300 */ 0.86298860598366389230, 0.98181944444444446685, 0.96363888888888893369 },
{ /*224 f=22400 */ 0.86144474568180307017, 0.98311111111111104677, 0.96622222222222220456 },
{ /*225 f=22500 */ 0.85993676017456777139, 0.98437500000000000000, 0.96875000000000000000 },
{ /*226 f=22600 */ 0.85846447062569863906, 0.98561111111111110450, 0.97122222222222220900 },
{ /*227 f=22700 */ 0.85702770262870564544, 0.98681944444444447129, 0.97363888888888883155 },
{ /*228 f=22800 */ 0.85562628617244329554, 0.98799999999999998934, 0.97599999999999997868 },
{ /*229 f=22900 */ 0.85426005560758888624, 0.98915277777777776969, 0.97830555555555553937 },
{ /*230 f=23000 */ 0.85292884961401538302, 0.99027777777777781232, 0.98055555555555562464 },
{ /*231 f=23100 */ 0.85163251116905014371, 0.99137500000000000622, 0.98275000000000001243 },
{ /*232 f=23200 */ 0.85037088751661060737, 0.99244444444444446241, 0.98488888888888892481 },
{ /*233 f=23300 */ 0.84914383013720728943, 0.99348611111111106986, 0.98697222222222225074 },
{ /*234 f=23400 */ 0.84795119471880842088, 0.99449999999999993960, 0.98899999999999999023 },
{ /*235 f=23500 */ 0.84679284112855590649, 0.99548611111111107164, 0.99097222222222225430 },
{ /*236 f=23600 */ 0.84566863338532594074, 0.99644444444444446596, 0.99288888888888882089 },
{ /*237 f=23700 */ 0.84457843963312528857, 0.99737500000000001155, 0.99475000000000002309 },
{ /*238 f=23800 */ 0.84352213211531956727, 0.99827777777777781942, 0.99655555555555552782 },
{ /*239 f=23900 */ 0.84249958714968098406, 0.99915277777777777857, 0.99830555555555555713 },
{ /*240 f=24000 */ 0.84151068510425452995, 1.00000000000000000000, 1.00000000000000000000 }
};
static FLOAT_T moog_q90[241][3] = {
{ /* dummy entry */ 0, 0, 0},
{ /*  1 f=  100 */ 3.46017591449581018992, 0.00748611111111113781, -0.98502777777777772439 },
{ /*  2 f=  200 */ 3.42458509075999195659, 0.01494444444444442688, -0.97011111111111114624 },
{ /*  3 f=  300 */ 3.38949086495329510171, 0.02237499999999997824, -0.95525000000000004352 },
{ /*  4 f=  400 */ 3.35488545912972346841, 0.02977777777777779189, -0.94044444444444441622 },
{ /*  5 f=  500 */ 3.32076123108293241870, 0.03715277777777775681, -0.92569444444444448639 },
{ /*  6 f=  600 */ 3.28711067178923821430, 0.04449999999999998401, -0.91100000000000003197 },
{ /*  7 f=  700 */ 3.25392640290219370414, 0.05181944444444447351, -0.89636111111111105298 },
{ /*  8 f=  800 */ 3.22120117429763475059, 0.05911111111111111427, -0.88177777777777777146 },
{ /*  9 f=  900 */ 3.18892786166811648130, 0.06637500000000001732, -0.86724999999999996536 },
{ /* 10 f= 1000 */ 3.15709946416570108596, 0.07361111111111112715, -0.85277777777777774570 },
{ /* 11 f= 1100 */ 3.12570910209204821939, 0.08081944444444444375, -0.83836111111111111249 },
{ /* 12 f= 1200 */ 3.09475001463482035646, 0.08800000000000002265, -0.82399999999999995470 },
{ /* 13 f= 1300 */ 3.06421555764941411226, 0.09515277777777780832, -0.80969444444444438336 },
{ /* 14 f= 1400 */ 3.03409920148505518611, 0.10227777777777780077, -0.79544444444444439846 },
{ /* 15 f= 1500 */ 3.00439452885432345397, 0.10937500000000000000, -0.78125000000000000000 },
{ /* 16 f= 1600 */ 2.97509523274517828639, 0.11644444444444446152, -0.76711111111111107697 },
{ /* 17 f= 1700 */ 2.94619511437460479542, 0.12348611111111112981, -0.75302777777777774038 },
{ /* 18 f= 1800 */ 2.91768808118298350607, 0.13050000000000000488, -0.73899999999999999023 },
{ /* 19 f= 1900 */ 2.88956814486833701849, 0.13748611111111108674, -0.72502777777777782653 },
{ /* 20 f= 2000 */ 2.86182941945961433206, 0.14444444444444443088, -0.71111111111111113825 },
{ /* 21 f= 2100 */ 2.83446611942818194052, 0.15137499999999998179, -0.69725000000000003642 },
{ /* 22 f= 2200 */ 2.80747255783673566043, 0.15827777777777779500, -0.68344444444444441000 },
{ /* 23 f= 2300 */ 2.78084314452482983526, 0.16515277777777781498, -0.66969444444444437003 },
{ /* 24 f= 2400 */ 2.75457238433027207236, 0.17199999999999998623, -0.65600000000000002753 },
{ /* 25 f= 2500 */ 2.72865487534562367600, 0.17881944444444447528, -0.64236111111111104943 },
{ /* 26 f= 2600 */ 2.70308530720907524980, 0.18561111111111111560, -0.62877777777777776880 },
{ /* 27 f= 2700 */ 2.67785845942898070859, 0.19237500000000001821, -0.61524999999999996358 },
{ /* 28 f= 2800 */ 2.65296919974134404185, 0.19911111111111112759, -0.60177777777777774482 },
{ /* 29 f= 2900 */ 2.62841248249957581962, 0.20581944444444444375, -0.58836111111111111249 },
{ /* 30 f= 3000 */ 2.60418334709584531339, 0.21250000000000002220, -0.57499999999999995559 },
{ /* 31 f= 3100 */ 2.58027691641337630912, 0.21915277777777780743, -0.56169444444444438513 },
{ /* 32 f= 3200 */ 2.55668839530903690971, 0.22577777777777779944, -0.54844444444444440112 },
{ /* 33 f= 3300 */ 2.53341306912559938169, 0.23237499999999999822, -0.53525000000000000355 },
{ /* 34 f= 3400 */ 2.51044630223305809125, 0.23894444444444445930, -0.52211111111111108141 },
{ /* 35 f= 3500 */ 2.48778353659839845946, 0.24548611111111112715, -0.50902777777777774570 },
{ /* 36 f= 3600 */ 2.46542029038323251555, 0.25200000000000000178, -0.49599999999999999645 },
{ /* 37 f= 3700 */ 2.44335215656872639656, 0.25848611111111113869, -0.48302777777777772261 },
{ /* 38 f= 3800 */ 2.42157480160725446794, 0.26494444444444442688, -0.47011111111111114624 },
{ /* 39 f= 3900 */ 2.40008396410023205902, 0.27137500000000003286, -0.45724999999999998979 },
{ /* 40 f= 4000 */ 2.37887545350158857715, 0.27777777777777779011, -0.44444444444444447528 },
{ /* 41 f= 4100 */ 2.35794514884635075802, 0.28415277777777780965, -0.43169444444444443620 },
{ /* 42 f= 4200 */ 2.33728899750382312916, 0.29049999999999998046, -0.41900000000000003908 },
{ /* 43 f= 4300 */ 2.31690301395486430991, 0.29681944444444441356, -0.40636111111111111738 },
{ /* 44 f= 4400 */ 2.29678327859276265599, 0.30311111111111110894, -0.39377777777777778212 },
{ /* 45 f= 4500 */ 2.27692593654722674756, 0.30937500000000001110, -0.38124999999999997780 },
{ /* 46 f= 4600 */ 2.25732719653102043011, 0.31561111111111117555, -0.36877777777777770440 },
{ /* 47 f= 4700 */ 2.23798332970878632864, 0.32181944444444443576, -0.35636111111111112848 },
{ /* 48 f= 4800 */ 2.21889066858759331780, 0.32800000000000001377, -0.34399999999999997247 },
{ /* 49 f= 4900 */ 2.20004560592877984604, 0.33415277777777774304, -0.33169444444444445841 },
{ /* 50 f= 5000 */ 2.18144459368064547178, 0.34027777777777779011, -0.31944444444444441977 },
{ /* 51 f= 5100 */ 2.16308414193158426997, 0.34637499999999998845, -0.30725000000000002309 },
{ /* 52 f= 5200 */ 2.14496081788322490169, 0.35244444444444444908, -0.29511111111111110183 },
{ /* 53 f= 5300 */ 2.12707124484319631819, 0.35848611111111111649, -0.28302777777777776702 },
{ /* 54 f= 5400 */ 2.10941210123709632640, 0.36450000000000004619, -0.27099999999999996314 },
{ /* 55 f= 5500 */ 2.09198011963929930701, 0.37048611111111107164, -0.25902777777777780122 },
{ /* 56 f= 5600 */ 2.07477208582220207234, 0.37644444444444447040, -0.24711111111111108696 },
{ /* 57 f= 5700 */ 2.05778483782354992826, 0.38237500000000002043, -0.23525000000000001465 },
{ /* 58 f= 5800 */ 2.04101526503147523428, 0.38827777777777777724, -0.22344444444444441777 },
{ /* 59 f= 5900 */ 2.02446030728688786127, 0.39415277777777779633, -0.21169444444444446285 },
{ /* 60 f= 6000 */ 2.00811695400287382185, 0.40000000000000002220, -0.19999999999999998335 },
{ /* 61 f= 6100 */ 1.99198224330076079092, 0.40581944444444439934, -0.18836111111111114580 },
{ /* 62 f= 6200 */ 1.97605326116251256430, 0.41161111111111114980, -0.17677777777777770041 },
{ /* 63 f= 6300 */ 1.96032714059912982485, 0.41737500000000005151, -0.16524999999999995248 },
{ /* 64 f= 6400 */ 1.94480106083473658352, 0.42311111111111110450, -0.15377777777777776325 },
{ /* 65 f= 6500 */ 1.92947224650603210705, 0.42881944444444441977, -0.14236111111111113270 },
{ /* 66 f= 6600 */ 1.91433796687681834214, 0.43450000000000005285, -0.13099999999999992206 },
{ /* 67 f= 6700 */ 1.89939553506728042720, 0.44015277777777778168, -0.11969444444444440889 },
{ /* 68 f= 6800 */ 1.88464230729774651074, 0.44577777777777777279, -0.10844444444444444053 },
{ /* 69 f= 6900 */ 1.87007568214662733830, 0.45137499999999997069, -0.09725000000000004474 },
{ /* 70 f= 7000 */ 1.85569309982225938427, 0.45694444444444448639, -0.08611111111111104111 },
{ /* 71 f= 7100 */ 1.84149204144837330688, 0.46248611111111115335, -0.07502777777777774881 },
{ /* 72 f= 7200 */ 1.82747002836291838612, 0.46799999999999997158, -0.06400000000000001521 },
{ /* 73 f= 7300 */ 1.81362462142998248638, 0.47348611111111110761, -0.05302777777777782642 },
{ /* 74 f= 7400 */ 1.79995342036454197832, 0.47894444444444445041, -0.04211111111111105060 },
{ /* 75 f= 7500 */ 1.78645406306979714905, 0.48437500000000000000, -0.03124999999999997918 },
{ /* 76 f= 7600 */ 1.77312422498683508465, 0.48977777777777775636, -0.02044444444444446299 },
{ /* 77 f= 7700 */ 1.75996161845638665611, 0.49515277777777783053, -0.00969444444444435803 },
{ /* 78 f= 7800 */ 1.74696399209243691253, 0.50050000000000005596, 0.00100000000000004794 },
{ /* 79 f= 7900 */ 1.73412913016745129369, 0.50581944444444448816, 0.01163888888888889826 },
{ /* 80 f= 8000 */ 1.72145485200899850398, 0.51111111111111107164, 0.02222222222222219531 },
{ /* 81 f= 8100 */ 1.70893901140753934342, 0.51637500000000002842, 0.03275000000000007766 },
{ /* 82 f= 8200 */ 1.69657949603517055337, 0.52161111111111113647, 0.04322222222222225907 },
{ /* 83 f= 8300 */ 1.68437422687510029995, 0.52681944444444439579, 0.05363888888888888873 },
{ /* 84 f= 8400 */ 1.67232115766165478909, 0.53200000000000002842, 0.06399999999999995970 },
{ /* 85 f= 8500 */ 1.66041827433060840136, 0.53715277777777781232, 0.07430555555555562464 },
{ /* 86 f= 8600 */ 1.64866359447963195528, 0.54227777777777774748, 0.08455555555555557823 },
{ /* 87 f= 8700 */ 1.63705516683866858507, 0.54737499999999994493, 0.09474999999999998701 },
{ /* 88 f= 8800 */ 1.62559107075004205534, 0.55244444444444440467, 0.10488888888888885098 },
{ /* 89 f= 8900 */ 1.61426941565810810886, 0.55748611111111112670, 0.11497222222222228116 },
{ /* 90 f= 9000 */ 1.60308834060826632673, 0.56250000000000000000, 0.12500000000000002776 },
{ /* 91 f= 9100 */ 1.59204601375514753769, 0.56748611111111113559, 0.13497222222222221566 },
{ /* 92 f= 9200 */ 1.58114063187980735670, 0.57244444444444453346, 0.14488888888888898365 },
{ /* 93 f= 9300 */ 1.57037041991574177757, 0.57737499999999997158, 0.15475000000000005418 },
{ /* 94 f= 9400 */ 1.55973363048356383764, 0.58227777777777778301, 0.16455555555555556602 },
{ /* 95 f= 9500 */ 1.54922854343417126799, 0.58715277777777774570, 0.17430555555555554692 },
{ /* 96 f= 9600 */ 1.53885346540024214868, 0.59200000000000008171, 0.18400000000000008016 },
{ /* 97 f= 9700 */ 1.52860672935589891885, 0.59681944444444445796, 0.19363888888888891593 },
{ /* 98 f= 9800 */ 1.51848669418438309009, 0.60161111111111109651, 0.20322222222222222077 },
{ /* 99 f= 9900 */ 1.50849174425359189300, 0.60637499999999999734, 0.21274999999999996692 },
{ /*100 f=10000 */ 1.49862028899932120396, 0.61111111111111116045, 0.22222222222222229315 },
{ /*101 f=10100 */ 1.48887076251607330946, 0.61581944444444447484, 0.23163888888888892192 },
{ /*102 f=10200 */ 1.47924162315527674139, 0.62050000000000005151, 0.24099999999999999201 },
{ /*103 f=10300 */ 1.46973135313079072972, 0.62515277777777777946, 0.25030555555555550340 },
{ /*104 f=10400 */ 1.46033845813154039561, 0.62977777777777776969, 0.25955555555555559488 },
{ /*105 f=10500 */ 1.45106146694116211471, 0.63437500000000002220, 0.26875000000000004441 },
{ /*106 f=10600 */ 1.44189893106451427762, 0.63894444444444442599, 0.27788888888888885198 },
{ /*107 f=10700 */ 1.43284942436093043483, 0.64348611111111120309, 0.28697222222222229515 },
{ /*108 f=10800 */ 1.42391154268408715033, 0.64800000000000002043, 0.29600000000000004086 },
{ /*109 f=10900 */ 1.41508390352835866643, 0.65248611111111110006, 0.30497222222222225563 },
{ /*110 f=11000 */ 1.40636514568153758731, 0.65694444444444444198, 0.31388888888888888395 },
{ /*111 f=11100 */ 1.39775392888380567413, 0.66137500000000004619, 0.32275000000000009237 },
{ /*112 f=11200 */ 1.38924893349282929655, 0.66577777777777780166, 0.33155555555555560332 },
{ /*113 f=11300 */ 1.38084886015487451338, 0.67015277777777781942, 0.34030555555555558334 },
{ /*114 f=11400 */ 1.37255242948181899187, 0.67449999999999998845, 0.34899999999999997691 },
{ /*115 f=11500 */ 1.36435838173395995732, 0.67881944444444441977, 0.35763888888888895057 },
{ /*116 f=11600 */ 1.35626547650850359794, 0.68311111111111111338, 0.36622222222222222676 },
{ /*117 f=11700 */ 1.34827249243363245235, 0.68737499999999995826, 0.37474999999999997202 },
{ /*118 f=11800 */ 1.34037822686804664052, 0.69161111111111106542, 0.38322222222222218635 },
{ /*119 f=11900 */ 1.33258149560587768612, 0.69581944444444443487, 0.39163888888888892525 },
{ /*120 f=12000 */ 1.32488113258687456586, 0.69999999999999995559, 0.40000000000000002220 },
{ /*121 f=12100 */ 1.31727598961176450842, 0.70415277777777773860, 0.40830555555555553271 },
{ /*122 f=12200 */ 1.30976493606269484005, 0.70827777777777778390, 0.41655555555555551228 },
{ /*123 f=12300 */ 1.30234685862865706696, 0.71237499999999998046, 0.42474999999999996092 },
{ /*124 f=12400 */ 1.29502066103580681933, 0.71644444444444443931, 0.43288888888888898965 },
{ /*125 f=12500 */ 1.28778526378258817431, 0.72048611111111116045, 0.44097222222222232091 },
{ /*126 f=12600 */ 1.28063960387957087583, 0.72450000000000003286, 0.44900000000000006573 },
{ /*127 f=12700 */ 1.27358263459391851669, 0.72848611111111116756, 0.45697222222222227961 },
{ /*128 f=12800 */ 1.26661332519839953115, 0.73244444444444445352, 0.46488888888888890705 },
{ /*129 f=12900 */ 1.25973066072485995193, 0.73637500000000000178, 0.47275000000000000355 },
{ /*130 f=13000 */ 1.25293364172207644103, 0.74027777777777781232, 0.48055555555555551361 },
{ /*131 f=13100 */ 1.24622128401790810415, 0.74415277777777777413, 0.48830555555555549274 },
{ /*132 f=13200 */ 1.23959261848567026121, 0.74799999999999999822, 0.49600000000000010747 },
{ /*133 f=13300 */ 1.23304669081465512193, 0.75181944444444448461, 0.50363888888888896922 },
{ /*134 f=13400 */ 1.22658256128471987445, 0.75561111111111112226, 0.51122222222222224453 },
{ /*135 f=13500 */ 1.22019930454487268712, 0.75937500000000002220, 0.51875000000000004441 },
{ /*136 f=13600 */ 1.21389600939578423677, 0.76311111111111107341, 0.52622222222222225785 },
{ /*137 f=13700 */ 1.20767177857615037873, 0.76681944444444449793, 0.53363888888888888484 },
{ /*138 f=13800 */ 1.20152572855284156539, 0.77049999999999996270, 0.54099999999999992539 },
{ /*139 f=13900 */ 1.19545698931476618299, 0.77415277777777791179, 0.54830555555555571257 },
{ /*140 f=14000 */ 1.18946470417038741019, 0.77777777777777790114, 0.55555555555555569125 },
{ /*141 f=14100 */ 1.18354802954882099009, 0.78137500000000004174, 0.56275000000000008349 },
{ /*142 f=14200 */ 1.17770613480445618393, 0.78494444444444444464, 0.56988888888888888928 },
{ /*143 f=14300 */ 1.17193820202503329320, 0.78848611111111110983, 0.57697222222222221966 },
{ /*144 f=14400 */ 1.16624342584312001847, 0.79200000000000003730, 0.58399999999999996358 },
{ /*145 f=14500 */ 1.16062101325092070780, 0.79548611111111111605, 0.59097222222222223209 },
{ /*146 f=14600 */ 1.15507018341836698028, 0.79894444444444445708, 0.59788888888888880313 },
{ /*147 f=14700 */ 1.14959016751442444360, 0.80237500000000006040, 0.60475000000000012079 },
{ /*148 f=14800 */ 1.14418020853156443550, 0.80577777777777781498, 0.61155555555555562997 },
{ /*149 f=14900 */ 1.13883956111334172512, 0.80915277777777783186, 0.61830555555555555269 },
{ /*150 f=15000 */ 1.13356749138502599372, 0.81250000000000000000, 0.62500000000000000000 },
{ /*151 f=15100 */ 1.12836327678723113976, 0.81581944444444443043, 0.63163888888888886086 },
{ /*152 f=15200 */ 1.12322620591249466848, 0.81911111111111112315, 0.63822222222222224630 },
{ /*153 f=15300 */ 1.11815557834474788024, 0.82237499999999996714, 0.64474999999999993427 },
{ /*154 f=15400 */ 1.11315070450163622340, 0.82561111111111118444, 0.65122222222222236887 },
{ /*155 f=15500 */ 1.10821090547963341244, 0.82881944444444455300, 0.65763888888888899498 },
{ /*156 f=15600 */ 1.10333551290190179373, 0.83200000000000007283, 0.66400000000000003464 },
{ /*157 f=15700 */ 1.09852386876885788070, 0.83515277777777785495, 0.67030555555555559888 },
{ /*158 f=15800 */ 1.09377532531138599303, 0.83827777777777778834, 0.67655555555555557667 },
{ /*159 f=15900 */ 1.08908924484666469468, 0.84137499999999998401, 0.68274999999999996803 },
{ /*160 f=16000 */ 1.08446499963655451637, 0.84444444444444444198, 0.68888888888888888395 },
{ /*161 f=16100 */ 1.07990197174850788286, 0.84748611111111116223, 0.69497222222222221344 },
{ /*162 f=16200 */ 1.07539955291895394929, 0.85050000000000003375, 0.70100000000000006750 },
{ /*163 f=16300 */ 1.07095714441911993298, 0.85348611111111116756, 0.70697222222222233512 },
{ /*164 f=16400 */ 1.06657415692324653023, 0.85644444444444445264, 0.71288888888888890527 },
{ /*165 f=16500 */ 1.06225001037915678381, 0.85937500000000000000, 0.71875000000000000000 },
{ /*166 f=16600 */ 1.05798413388113843325, 0.86227777777777769863, 0.72455555555555550828 },
{ /*167 f=16700 */ 1.05377596554510266635, 0.86515277777777777057, 0.73030555555555554115 },
{ /*168 f=16800 */ 1.04962495238597863789, 0.86799999999999999378, 0.73599999999999998757 },
{ /*169 f=16900 */ 1.04553055019730978259, 0.87081944444444447928, 0.74163888888888895856 },
{ /*170 f=17000 */ 1.04149222343301306459, 0.87361111111111111605, 0.74722222222222234311 },
{ /*171 f=17100 */ 1.03750944509126408200, 0.87637500000000001510, 0.75275000000000003020 },
{ /*172 f=17200 */ 1.03358169660047782834, 0.87911111111111117644, 0.75822222222222224186 },
{ /*173 f=17300 */ 1.02970846770734603126, 0.88181944444444448905, 0.76363888888888886708 },
{ /*174 f=17400 */ 1.02588925636689887178, 0.88450000000000006395, 0.76900000000000001688 },
{ /*175 f=17500 */ 1.02212356863455910982, 0.88715277777777779011, 0.77430555555555558023 },
{ /*176 f=17600 */ 1.01841091856015464323, 0.88977777777777777857, 0.77955555555555555713 },
{ /*177 f=17700 */ 1.01475082808385974609, 0.89237500000000002931, 0.78475000000000005862 },
{ /*178 f=17800 */ 1.01114282693403012559, 0.89494444444444454234, 0.78988888888888897366 },
{ /*179 f=17900 */ 1.00758645252690914873, 0.89748611111111120664, 0.79497222222222230226 },
{ /*180 f=18000 */ 1.00408124986816282842, 0.90000000000000002220, 0.80000000000000004441 },
{ /*181 f=18100 */ 1.00062677145622780372, 0.90248611111111110006, 0.80497222222222220012 },
{ /*182 f=18200 */ 0.99722257718743567700, 0.90494444444444444020, 0.80988888888888888040 },
{ /*183 f=18300 */ 0.99386823426288595229, 0.90737500000000004263, 0.81474999999999997424 },
{ /*184 f=18400 */ 0.99056331709704459332, 0.90977777777777779633, 0.81955555555555559266 },
{ /*185 f=18500 */ 0.98730740722803533860, 0.91215277777777781232, 0.82430555555555562464 },
{ /*186 f=18600 */ 0.98410009322960168010, 0.91450000000000009059, 0.82900000000000007017 },
{ /*187 f=18700 */ 0.98094097062471441451, 0.91681944444444440911, 0.83363888888888892925 },
{ /*188 f=18800 */ 0.97782964180079201544, 0.91911111111111110095, 0.83822222222222220189 },
{ /*189 f=18900 */ 0.97476571592652005993, 0.92137500000000005507, 0.84274999999999999911 },
{ /*190 f=19000 */ 0.97174880887023673548, 0.92361111111111116045, 0.84722222222222220989 },
{ /*191 f=19100 */ 0.96877854311986377756, 0.92581944444444441711, 0.85163888888888883422 },
{ /*192 f=19200 */ 0.96585454770435863470, 0.92800000000000004707, 0.85600000000000009415 },
{ /*193 f=19300 */ 0.96297645811666898741, 0.93015277777777782831, 0.86030555555555554559 },
{ /*194 f=19400 */ 0.96014391623815942278, 0.93227777777777776080, 0.86455555555555563263 },
{ /*195 f=19500 */ 0.95735657026449627605, 0.93437499999999995559, 0.86875000000000002220 },
{ /*196 f=19600 */ 0.95461407463296477083, 0.93644444444444441267, 0.87288888888888893636 },
{ /*197 f=19700 */ 0.95191608995119847414, 0.93848611111111113203, 0.87697222222222215304 },
{ /*198 f=19800 */ 0.94926228292730086000, 0.94050000000000000266, 0.88100000000000000533 },
{ /*199 f=19900 */ 0.94665232630133810954, 0.94248611111111113559, 0.88497222222222227117 },
{ /*200 f=20000 */ 0.94408589877818493985, 0.94444444444444441977, 0.88888888888888895057 },
{ /*201 f=20100 */ 0.94156268496170225646, 0.94637499999999996625, 0.89275000000000004352 },
{ /*202 f=20200 */ 0.93908237529022942081, 0.94827777777777777501, 0.89655555555555555003 },
{ /*203 f=20300 */ 0.93664466597337181497, 0.95015277777777784607, 0.90030555555555558112 },
{ /*204 f=20400 */ 0.93424925893006638411, 0.95199999999999995737, 0.90400000000000002576 },
{ /*205 f=20500 */ 0.93189586172790506158, 0.95381944444444444198, 0.90763888888888888395 },
{ /*206 f=20600 */ 0.92958418752370375326, 0.95561111111111107785, 0.91122222222222215571 },
{ /*207 f=20700 */ 0.92731395500529445464, 0.95737500000000008704, 0.91475000000000006306 },
{ /*208 f=20800 */ 0.92508488833452784394, 0.95911111111111113647, 0.91822222222222227295 },
{ /*209 f=20900 */ 0.92289671709146814393, 0.96081944444444444819, 0.92163888888888889639 },
{ /*210 f=21000 */ 0.92074917621976559712, 0.96250000000000002220, 0.92500000000000004441 },
{ /*211 f=21100 */ 0.91864200597319012331, 0.96415277777777785850, 0.92830555555555560598 },
{ /*212 f=21200 */ 0.91657495186331305881, 0.96577777777777784607, 0.93155555555555558112 },
{ /*213 f=21300 */ 0.91454776460831876950, 0.96737499999999998490, 0.93474999999999996980 },
{ /*214 f=21400 */ 0.91256020008293503576, 0.96894444444444438602, 0.93788888888888888307 },
{ /*215 f=21500 */ 0.91061201926946688801, 0.97048611111111116045, 0.94097222222222220989 },
{ /*216 f=21600 */ 0.90870298820992045918, 0.97199999999999997513, 0.94400000000000006128 },
{ /*217 f=21700 */ 0.90683287795920086705, 0.97348611111111105210, 0.94697222222222221522 },
{ /*218 f=21800 */ 0.90500146453937713176, 0.97494444444444439135, 0.94988888888888889372 },
{ /*219 f=21900 */ 0.90320852889499314564, 0.97637499999999999289, 0.95274999999999998579 },
{ /*220 f=22000 */ 0.90145385684942136439, 0.97777777777777774570, 0.95555555555555549141 },
{ /*221 f=22100 */ 0.89973723906223668223, 0.97915277777777776080, 0.95830555555555552161 },
{ /*222 f=22200 */ 0.89805847098760960279, 0.98050000000000003819, 0.96100000000000007638 },
{ /*223 f=22300 */ 0.89641735283369783360, 0.98181944444444446685, 0.96363888888888893369 },
{ /*224 f=22400 */ 0.89481368952303141917, 0.98311111111111104677, 0.96622222222222220456 },
{ /*225 f=22500 */ 0.89324729065387520333, 0.98437500000000000000, 0.96875000000000000000 },
{ /*226 f=22600 */ 0.89171797046256451313, 0.98561111111111110450, 0.97122222222222220900 },
{ /*227 f=22700 */ 0.89022554778679507947, 0.98681944444444447129, 0.97363888888888883155 },
{ /*228 f=22800 */ 0.88876984602986586204, 0.98799999999999998934, 0.97599999999999997868 },
{ /*229 f=22900 */ 0.88735069312585823642, 0.98915277777777776969, 0.97830555555555553937 },
{ /*230 f=23000 */ 0.88596792150574465996, 0.99027777777777781232, 0.98055555555555562464 },
{ /*231 f=23100 */ 0.88462136806441893366, 0.99137500000000000622, 0.98275000000000001243 },
{ /*232 f=23200 */ 0.88331087412863484865, 0.99244444444444446241, 0.98488888888888892481 },
{ /*233 f=23300 */ 0.88203628542584899819, 0.99348611111111106986, 0.98697222222222225074 },
{ /*234 f=23400 */ 0.88079745205395498786, 0.99449999999999993960, 0.98899999999999999023 },
{ /*235 f=23500 */ 0.87959422845190526896, 0.99548611111111107164, 0.99097222222222225430 },
{ /*236 f=23600 */ 0.87842647337120782769, 0.99644444444444446596, 0.99288888888888882089 },
{ /*237 f=23700 */ 0.87729404984829295611, 0.99737500000000001155, 0.99475000000000002309 },
{ /*238 f=23800 */ 0.87619682517774177821, 0.99827777777777781942, 0.99655555555555552782 },
{ /*239 f=23900 */ 0.87513467088636931468, 0.99915277777777777857, 0.99830555555555555713 },
{ /*240 f=24000 */ 0.87410746270815398162, 1.00000000000000000000, 1.00000000000000000000 }
};
static FLOAT_T moog_q100[241][3] = {
{ /* dummy entry */ 0, 0, 0},
{ /*  1 f=  100 */ 3.56267217450614115393, 0.00748611111111113781, -0.98502777777777772439 },
{ /*  2 f=  200 */ 3.52602709040502571014, 0.01494444444444442688, -0.97011111111111114624 },
{ /*  3 f=  300 */ 3.48989331430319094096, 0.02237499999999997824, -0.95525000000000004352 },
{ /*  4 f=  400 */ 3.45426283785873078358, 0.02977777777777779189, -0.94044444444444441622 },
{ /*  5 f=  500 */ 3.41912779249022991124, 0.03715277777777775681, -0.92569444444444448639 },
{ /*  6 f=  600 */ 3.38448044674402881427, 0.04449999999999998401, -0.91100000000000003197 },
{ /*  7 f=  700 */ 3.35031320371458596341, 0.05181944444444447351, -0.89636111111111105298 },
{ /*  8 f=  800 */ 3.31661859851680285161, 0.05911111111111111427, -0.88177777777777777146 },
{ /*  9 f=  900 */ 3.28338929580920435569, 0.06637500000000001732, -0.86724999999999996536 },
{ /* 10 f= 1000 */ 3.25061808736690194266, 0.07361111111111112715, -0.85277777777777774570 },
{ /* 11 f= 1100 */ 3.21829788970326058362, 0.08081944444444444375, -0.83836111111111111249 },
{ /* 12 f= 1200 */ 3.18642174173925152303, 0.08800000000000002265, -0.82399999999999995470 },
{ /* 13 f= 1300 */ 3.15498280251947749164, 0.09515277777777780832, -0.80969444444444438336 },
{ /* 14 f= 1400 */ 3.12397434897386849784, 0.10227777777777780077, -0.79544444444444439846 },
{ /* 15 f= 1500 */ 3.09338977372410317557, 0.10937500000000000000, -0.78125000000000000000 },
{ /* 16 f= 1600 */ 3.06322258293378268945, 0.11644444444444446152, -0.76711111111111107697 },
{ /* 17 f= 1700 */ 3.03346639420145969268, 0.12348611111111112981, -0.75302777777777774038 },
{ /* 18 f= 1800 */ 3.00411493449559907631, 0.13050000000000000488, -0.73899999999999999023 },
{ /* 19 f= 1900 */ 2.97516203813059654237, 0.13748611111111108674, -0.72502777777777782653 },
{ /* 20 f= 2000 */ 2.94660164478298725044, 0.14444444444444443088, -0.71111111111111113825 },
{ /* 21 f= 2100 */ 2.91842779754700032413, 0.15137499999999998179, -0.69725000000000003642 },
{ /* 22 f= 2200 */ 2.89063464102863409977, 0.15827777777777779500, -0.68344444444444441000 },
{ /* 23 f= 2300 */ 2.86321641947744032208, 0.16515277777777781498, -0.66969444444444437003 },
{ /* 24 f= 2400 */ 2.83616747495523346956, 0.17199999999999998623, -0.65600000000000002753 },
{ /* 25 f= 2500 */ 2.80948224554094361238, 0.17881944444444447528, -0.64236111111111104943 },
{ /* 26 f= 2600 */ 2.78315526357086850950, 0.18561111111111111560, -0.62877777777777776880 },
{ /* 27 f= 2700 */ 2.75718115391357354582, 0.19237500000000001821, -0.61524999999999996358 },
{ /* 28 f= 2800 */ 2.73155463227872719045, 0.19911111111111112759, -0.60177777777777774482 },
{ /* 29 f= 2900 */ 2.70627050355915876878, 0.20581944444444444375, -0.58836111111111111249 },
{ /* 30 f= 3000 */ 2.68132366020544710139, 0.21250000000000002220, -0.57499999999999995559 },
{ /* 31 f= 3100 */ 2.65670908063237343200, 0.21915277777777780743, -0.56169444444444438513 },
{ /* 32 f= 3200 */ 2.63242182765655829968, 0.22577777777777779944, -0.54844444444444440112 },
{ /* 33 f= 3300 */ 2.60845704696465796602, 0.23237499999999999822, -0.53525000000000000355 },
{ /* 34 f= 3400 */ 2.58480996561146980639, 0.23894444444444445930, -0.52211111111111108141 },
{ /* 35 f= 3500 */ 2.56147589054733471059, 0.24548611111111112715, -0.50902777777777774570 },
{ /* 36 f= 3600 */ 2.53845020717423652812, 0.25200000000000000178, -0.49599999999999999645 },
{ /* 37 f= 3700 */ 2.51572837792999282058, 0.25848611111111113869, -0.48302777777777772261 },
{ /* 38 f= 3800 */ 2.49330594089997115148, 0.26494444444444442688, -0.47011111111111114624 },
{ /* 39 f= 3900 */ 2.47117850845575759422, 0.27137500000000003286, -0.45724999999999998979 },
{ /* 40 f= 4000 */ 2.44934176592022234686, 0.27777777777777779011, -0.44444444444444447528 },
{ /* 41 f= 4100 */ 2.42779147025844288521, 0.28415277777777780965, -0.43169444444444443620 },
{ /* 42 f= 4200 */ 2.40652344879395219124, 0.29049999999999998046, -0.41900000000000003908 },
{ /* 43 f= 4300 */ 2.38553359794979424890, 0.29681944444444441356, -0.40636111111111111738 },
{ /* 44 f= 4400 */ 2.36481788201388010151, 0.30311111111111110894, -0.39377777777777778212 },
{ /* 45 f= 4500 */ 2.34437233192814398208, 0.30937500000000001110, -0.38124999999999997780 },
{ /* 46 f= 4600 */ 2.32419304410101235092, 0.31561111111111117555, -0.36877777777777770440 },
{ /* 47 f= 4700 */ 2.30427617924272176708, 0.32181944444444443576, -0.35636111111111112848 },
{ /* 48 f= 4800 */ 2.28461796122299976020, 0.32800000000000001377, -0.34399999999999997247 },
{ /* 49 f= 4900 */ 2.26521467595067749201, 0.33415277777777774304, -0.33169444444444445841 },
{ /* 50 f= 5000 */ 2.24606267027476613762, 0.34027777777777779011, -0.31944444444444441977 },
{ /* 51 f= 5100 */ 2.22715835090657732209, 0.34637499999999998845, -0.30725000000000002309 },
{ /* 52 f= 5200 */ 2.20849818336244974049, 0.35244444444444444908, -0.29511111111111110183 },
{ /* 53 f= 5300 */ 2.19007869092667517563, 0.35848611111111111649, -0.28302777777777776702 },
{ /* 54 f= 5400 */ 2.17189645363420291702, 0.36450000000000004619, -0.27099999999999996314 },
{ /* 55 f= 5500 */ 2.15394810727273666728, 0.37048611111111107164, -0.25902777777777780122 },
{ /* 56 f= 5600 */ 2.13623034240381715065, 0.37644444444444447040, -0.24711111111111108696 },
{ /* 57 f= 5700 */ 2.11873990340252404962, 0.38237500000000002043, -0.23525000000000001465 },
{ /* 58 f= 5800 */ 2.10147358751540691557, 0.38827777777777777724, -0.22344444444444441777 },
{ /* 59 f= 5900 */ 2.08442824393629022595, 0.39415277777777779633, -0.21169444444444446285 },
{ /* 60 f= 6000 */ 2.06760077289958577040, 0.40000000000000002220, -0.19999999999999998335 },
{ /* 61 f= 6100 */ 2.05098812479076819670, 0.40581944444444439934, -0.18836111111111114580 },
{ /* 62 f= 6200 */ 2.03458729927366110957, 0.41161111111111114980, -0.17677777777777770041 },
{ /* 63 f= 6300 */ 2.01839534443420420828, 0.41737500000000005151, -0.16524999999999995248 },
{ /* 64 f= 6400 */ 2.00240935594037150480, 0.42311111111111110450, -0.15377777777777776325 },
{ /* 65 f= 6500 */ 1.98662647621790977581, 0.42881944444444441977, -0.14236111111111113270 },
{ /* 66 f= 6600 */ 1.97104389364159837683, 0.43450000000000005285, -0.13099999999999992206 },
{ /* 67 f= 6700 */ 1.95565884174170001586, 0.44015277777777778168, -0.11969444444444440889 },
{ /* 68 f= 6800 */ 1.94046859842531960183, 0.44577777777777777279, -0.10844444444444444053 },
{ /* 69 f= 6900 */ 1.92547048521236319196, 0.45137499999999997069, -0.09725000000000004474 },
{ /* 70 f= 7000 */ 1.91066186648581060048, 0.45694444444444448639, -0.08611111111111104111 },
{ /* 71 f= 7100 */ 1.89604014875601900592, 0.46248611111111115335, -0.07502777777777774881 },
{ /* 72 f= 7200 */ 1.88160277993877755875, 0.46799999999999997158, -0.06400000000000001521 },
{ /* 73 f= 7300 */ 1.86734724864684542567, 0.47348611111111110761, -0.05302777777777782642 },
{ /* 74 f= 7400 */ 1.85327108349469837911, 0.47894444444444445041, -0.04211111111111105060 },
{ /* 75 f= 7500 */ 1.83937185241623701870, 0.48437500000000000000, -0.03124999999999997918 },
{ /* 76 f= 7600 */ 1.82564716199518350948, 0.48977777777777775636, -0.02044444444444446299 },
{ /* 77 f= 7700 */ 1.81209465680793346820, 0.49515277777777783053, -0.00969444444444435803 },
{ /* 78 f= 7800 */ 1.79871201877861275342, 0.50050000000000005596, 0.00100000000000004794 },
{ /* 79 f= 7900 */ 1.78549696654609157953, 0.50581944444444448816, 0.01163888888888889826 },
{ /* 80 f= 8000 */ 1.77244725484273413230, 0.51111111111111107164, 0.02222222222222219531 },
{ /* 81 f= 8100 */ 1.75956067388464743040, 0.51637500000000002842, 0.03275000000000007766 },
{ /* 82 f= 8200 */ 1.74683504877320405768, 0.52161111111111113647, 0.04322222222222225907 },
{ /* 83 f= 8300 */ 1.73426823890762071834, 0.52681944444444439579, 0.05363888888888888873 },
{ /* 84 f= 8400 */ 1.72185813740837478925, 0.53200000000000002842, 0.06399999999999995970 },
{ /* 85 f= 8500 */ 1.70960267055125370028, 0.53715277777777781232, 0.07430555555555562464 },
{ /* 86 f= 8600 */ 1.69749979721181998293, 0.54227777777777774748, 0.08455555555555557823 },
{ /* 87 f= 8700 */ 1.68554750832009925254, 0.54737499999999994493, 0.09474999999999998701 },
{ /* 88 f= 8800 */ 1.67374382632528773129, 0.55244444444444440467, 0.10488888888888885098 },
{ /* 89 f= 8900 */ 1.66208680467028724337, 0.55748611111111112670, 0.11497222222222228116 },
{ /* 90 f= 9000 */ 1.65057452727587605779, 0.56250000000000000000, 0.12500000000000002776 },
{ /* 91 f= 9100 */ 1.63920510803432839531, 0.56748611111111113559, 0.13497222222222221566 },
{ /* 92 f= 9200 */ 1.62797669031230651804, 0.57244444444444453346, 0.14488888888888898365 },
{ /* 93 f= 9300 */ 1.61688744646283577566, 0.57737499999999997158, 0.15475000000000005418 },
{ /* 94 f= 9400 */ 1.60593557734619762911, 0.58227777777777778301, 0.16455555555555556602 },
{ /* 95 f= 9500 */ 1.59511931185956612467, 0.58715277777777774570, 0.17430555555555554692 },
{ /* 96 f= 9600 */ 1.58443690647521551185, 0.59200000000000008171, 0.18400000000000008016 },
{ /* 97 f= 9700 */ 1.57388664478714468409, 0.59681944444444445796, 0.19363888888888891593 },
{ /* 98 f= 9800 */ 1.56346683706594213881, 0.60161111111111109651, 0.20322222222222222077 },
{ /* 99 f= 9900 */ 1.55317581982175068056, 0.60637499999999999734, 0.21274999999999996692 },
{ /*100 f=10000 */ 1.54301195537516622203, 0.61111111111111116045, 0.22222222222222229315 },
{ /*101 f=10100 */ 1.53297363143592235701, 0.61581944444444447484, 0.23163888888888892192 },
{ /*102 f=10200 */ 1.52305926068921126948, 0.62050000000000005151, 0.24099999999999999201 },
{ /*103 f=10300 */ 1.51326728038950042432, 0.62515277777777777946, 0.25030555555555550340 },
{ /*104 f=10400 */ 1.50359615196169538187, 0.62977777777777776969, 0.25955555555555559488 },
{ /*105 f=10500 */ 1.49404436060951639753, 0.63437500000000002220, 0.26875000000000004441 },
{ /*106 f=10600 */ 1.48461041493094692001, 0.63894444444444442599, 0.27788888888888885198 },
{ /*107 f=10700 */ 1.47529284654062342597, 0.64348611111111120309, 0.28697222222222229515 },
{ /*108 f=10800 */ 1.46609020969903469656, 0.64800000000000002043, 0.29600000000000004086 },
{ /*109 f=10900 */ 1.45700108094840063977, 0.65248611111111110006, 0.30497222222222225563 },
{ /*110 f=11000 */ 1.44802405875510786792, 0.65694444444444444198, 0.31388888888888888395 },
{ /*111 f=11100 */ 1.43915776315857590895, 0.66137500000000004619, 0.32275000000000009237 },
{ /*112 f=11200 */ 1.43040083542643525760, 0.66577777777777780166, 0.33155555555555560332 },
{ /*113 f=11300 */ 1.42175193771589669645, 0.67015277777777781942, 0.34030555555555558334 },
{ /*114 f=11400 */ 1.41320975274119975396, 0.67449999999999998845, 0.34899999999999997691 },
{ /*115 f=11500 */ 1.40477298344702217214, 0.67881944444444441977, 0.35763888888888895057 },
{ /*116 f=11600 */ 1.39644035268774180381, 0.68311111111111111338, 0.36622222222222222676 },
{ /*117 f=11700 */ 1.38821060291244346985, 0.68737499999999995826, 0.37474999999999997202 },
{ /*118 f=11800 */ 1.38008249585555931027, 0.69161111111111106542, 0.38322222222222218635 },
{ /*119 f=11900 */ 1.37205481223304048832, 0.69581944444444443487, 0.39163888888888892525 },
{ /*120 f=12000 */ 1.36412635144396054976, 0.69999999999999995559, 0.40000000000000002220 },
{ /*121 f=12100 */ 1.35629593127744341174, 0.70415277777777773860, 0.40830555555555553271 },
{ /*122 f=12200 */ 1.34856238762482383287, 0.70827777777777778390, 0.41655555555555551228 },
{ /*123 f=12300 */ 1.34092457419693933396, 0.71237499999999998046, 0.42474999999999996092 },
{ /*124 f=12400 */ 1.33338136224646142125, 0.71644444444444443931, 0.43288888888888898965 },
{ /*125 f=12500 */ 1.32593164029517240898, 0.72048611111111116045, 0.44097222222222232091 },
{ /*126 f=12600 */ 1.31857431386609880164, 0.72450000000000003286, 0.44900000000000006573 },
{ /*127 f=12700 */ 1.31130830522040797703, 0.72848611111111116756, 0.45697222222222227961 },
{ /*128 f=12800 */ 1.30413255309898490353, 0.73244444444444445352, 0.46488888888888890705 },
{ /*129 f=12900 */ 1.29704601246860384833, 0.73637500000000000178, 0.47275000000000000355 },
{ /*130 f=13000 */ 1.29004765427260581490, 0.74027777777777781232, 0.48055555555555551361 },
{ /*131 f=13100 */ 1.28313646518600776858, 0.74415277777777777413, 0.48830555555555549274 },
{ /*132 f=13200 */ 1.27631144737495461072, 0.74799999999999999822, 0.49600000000000010747 },
{ /*133 f=13300 */ 1.26957161826044173658, 0.75181944444444448461, 0.50363888888888896922 },
{ /*134 f=13400 */ 1.26291601028622690883, 0.75561111111111112226, 0.51122222222222224453 },
{ /*135 f=13500 */ 1.25634367069085817192, 0.75937500000000002220, 0.51875000000000004441 },
{ /*136 f=13600 */ 1.24985366128374142392, 0.76311111111111107341, 0.52622222222222225785 },
{ /*137 f=13700 */ 1.24344505822517570337, 0.76681944444444449793, 0.53363888888888888484 },
{ /*138 f=13800 */ 1.23711695181028669133, 0.77049999999999996270, 0.54099999999999992539 },
{ /*139 f=13900 */ 1.23086844625678359932, 0.77415277777777791179, 0.54830555555555571257 },
{ /*140 f=14000 */ 1.22469865949647793713, 0.77777777777777790114, 0.55555555555555569125 },
{ /*141 f=14100 */ 1.21860672297048977519, 0.78137500000000004174, 0.56275000000000008349 },
{ /*142 f=14200 */ 1.21259178142808110579, 0.78494444444444444464, 0.56988888888888888928 },
{ /*143 f=14300 */ 1.20665299272904880112, 0.78848611111111110983, 0.57697222222222221966 },
{ /*144 f=14400 */ 1.20078952764961544020, 0.79200000000000003730, 0.58399999999999996358 },
{ /*145 f=14500 */ 1.19500056969175405541, 0.79548611111111111605, 0.59097222222222223209 },
{ /*146 f=14600 */ 1.18928531489588928949, 0.79894444444444445708, 0.59788888888888880313 },
{ /*147 f=14700 */ 1.18364297165691212399, 0.80237500000000006040, 0.60475000000000012079 },
{ /*148 f=14800 */ 1.17807276054345089200, 0.80577777777777781498, 0.61155555555555562997 },
{ /*149 f=14900 */ 1.17257391412034284173, 0.80915277777777783186, 0.61830555555555555269 },
{ /*150 f=15000 */ 1.16714567677424718717, 0.81250000000000000000, 0.62500000000000000000 },
{ /*151 f=15100 */ 1.16178730454234746539, 0.81581944444444443043, 0.63163888888888886086 },
{ /*152 f=15200 */ 1.15649806494408968760, 0.81911111111111112315, 0.63822222222222224630 },
{ /*153 f=15300 */ 1.15127723681589677618, 0.82237499999999996714, 0.64474999999999993427 },
{ /*154 f=15400 */ 1.14612411014881931948, 0.82561111111111118444, 0.65122222222222236887 },
{ /*155 f=15500 */ 1.14103798592906069409, 0.82881944444444455300, 0.65763888888888899498 },
{ /*156 f=15600 */ 1.13601817598133192355, 0.83200000000000007283, 0.66400000000000003464 },
{ /*157 f=15700 */ 1.13106400281498897797, 0.83515277777777785495, 0.67030555555555559888 },
{ /*158 f=15800 */ 1.12617479947290011211, 0.83827777777777778834, 0.67655555555555557667 },
{ /*159 f=15900 */ 1.12134990938300060925, 0.84137499999999998401, 0.68274999999999996803 },
{ /*160 f=16000 */ 1.11658868621248652531, 0.84444444444444444198, 0.68888888888888888395 },
{ /*161 f=16100 */ 1.11189049372460302401, 0.84748611111111116223, 0.69497222222222221344 },
{ /*162 f=16200 */ 1.10725470563798444879, 0.85050000000000003375, 0.70100000000000006750 },
{ /*163 f=16300 */ 1.10268070548849927981, 0.85348611111111116756, 0.70697222222222233512 },
{ /*164 f=16400 */ 1.09816788649356356089, 0.85644444444444445264, 0.71288888888888890527 },
{ /*165 f=16500 */ 1.09371565141887350237, 0.85937500000000000000, 0.71875000000000000000 },
{ /*166 f=16600 */ 1.08932341244752528553, 0.86227777777777769863, 0.72455555555555550828 },
{ /*167 f=16700 */ 1.08499059105147277471, 0.86515277777777777057, 0.73030555555555554115 },
{ /*168 f=16800 */ 1.08071661786529293892, 0.86799999999999999378, 0.73599999999999998757 },
{ /*169 f=16900 */ 1.07650093256221413007, 0.87081944444444447928, 0.74163888888888895856 },
{ /*170 f=17000 */ 1.07234298373237280089, 0.87361111111111111605, 0.74722222222222234311 },
{ /*171 f=17100 */ 1.06824222876325936049, 0.87637500000000001510, 0.75275000000000003020 },
{ /*172 f=17200 */ 1.06419813372232230364, 0.87911111111111117644, 0.75822222222222224186 },
{ /*173 f=17300 */ 1.06021017324168753682, 0.88181944444444448905, 0.76363888888888886708 },
{ /*174 f=17400 */ 1.05627783040496425748, 0.88450000000000006395, 0.76900000000000001688 },
{ /*175 f=17500 */ 1.05240059663610252549, 0.88715277777777779011, 0.77430555555555558023 },
{ /*176 f=17600 */ 1.04857797159026389089, 0.88977777777777777857, 0.77955555555555555713 },
{ /*177 f=17700 */ 1.04480946304668265157, 0.89237500000000002931, 0.78475000000000005862 },
{ /*178 f=17800 */ 1.04109458680347399806, 0.89494444444444454234, 0.78988888888888897366 },
{ /*179 f=17900 */ 1.03743286657436772913, 0.89748611111111120664, 0.79497222222222230226 },
{ /*180 f=18000 */ 1.03382383388732868035, 0.90000000000000002220, 0.80000000000000004441 },
{ /*181 f=18100 */ 1.03026702798504077307, 0.90248611111111110006, 0.80497222222222220012 },
{ /*182 f=18200 */ 1.02676199572722093301, 0.90494444444444444020, 0.80988888888888888040 },
{ /*183 f=18300 */ 1.02330829149473356843, 0.90737500000000004263, 0.81474999999999997424 },
{ /*184 f=18400 */ 1.01990547709548184940, 0.90977777777777779633, 0.81955555555555559266 },
{ /*185 f=18500 */ 1.01655312167204092688, 0.91215277777777781232, 0.82430555555555562464 },
{ /*186 f=18600 */ 1.01325080161101355181, 0.91450000000000009059, 0.82900000000000007017 },
{ /*187 f=18700 */ 1.00999810045407678594, 0.91681944444444440911, 0.83363888888888892925 },
{ /*188 f=18800 */ 1.00679460881069227085, 0.91911111111111110095, 0.83822222222222220189 },
{ /*189 f=18900 */ 1.00363992427246162542, 0.92137500000000005507, 0.84274999999999999911 },
{ /*190 f=19000 */ 1.00053365132909388713, 0.92361111111111116045, 0.84722222222222220989 },
{ /*191 f=19100 */ 0.99747540128596423603, 0.92581944444444441711, 0.85163888888888883422 },
{ /*192 f=19200 */ 0.99446479218324135285, 0.92800000000000004707, 0.85600000000000009415 },
{ /*193 f=19300 */ 0.99150144871655754297, 0.93015277777777782831, 0.86030555555555554559 },
{ /*194 f=19400 */ 0.98858500215919808962, 0.93227777777777776080, 0.86455555555555563263 },
{ /*195 f=19500 */ 0.98571509028579018530, 0.93437499999999995559, 0.86875000000000002220 },
{ /*196 f=19600 */ 0.98289135729746734960, 0.93644444444444441267, 0.87288888888888893636 },
{ /*197 f=19700 */ 0.98011345374848746204, 0.93848611111111113203, 0.87697222222222215304 },
{ /*198 f=19800 */ 0.97738103647428475895, 0.94050000000000000266, 0.88100000000000000533 },
{ /*199 f=19900 */ 0.97469376852093259078, 0.94248611111111113559, 0.88497222222222227117 },
{ /*200 f=20000 */ 0.97205131907600117458, 0.94444444444444441977, 0.88888888888888895057 },
{ /*201 f=20100 */ 0.96945336340078458459, 0.94637499999999996625, 0.89275000000000004352 },
{ /*202 f=20200 */ 0.96689958276388243696, 0.94827777777777777501, 0.89655555555555555003 },
{ /*203 f=20300 */ 0.96438966437611495230, 0.95015277777777784607, 0.90030555555555558112 },
{ /*204 f=20400 */ 0.96192330132675418763, 0.95199999999999995737, 0.90400000000000002576 },
{ /*205 f=20500 */ 0.95950019252105001044, 0.95381944444444444198, 0.90763888888888888395 },
{ /*206 f=20600 */ 0.95712004261903793623, 0.95561111111111107785, 0.91122222222222215571 },
{ /*207 f=20700 */ 0.95478256197560806839, 0.95737500000000008704, 0.91475000000000006306 },
{ /*208 f=20800 */ 0.95248746658181904223, 0.95911111111111113647, 0.91822222222222227295 },
{ /*209 f=20900 */ 0.95023447800743932046, 0.96081944444444444819, 0.92163888888888889639 },
{ /*210 f=21000 */ 0.94802332334470174047, 0.96250000000000002220, 0.92500000000000004441 },
{ /*211 f=21100 */ 0.94585373515325410487, 0.96415277777777785850, 0.92830555555555560598 },
{ /*212 f=21200 */ 0.94372545140629016114, 0.96577777777777784607, 0.93155555555555558112 },
{ /*213 f=21300 */ 0.94163821543784542722, 0.96737499999999998490, 0.93474999999999996980 },
{ /*214 f=21400 */ 0.93959177589124454055, 0.96894444444444438602, 0.93788888888888888307 },
{ /*215 f=21500 */ 0.93758588666868436512, 0.97048611111111116045, 0.94097222222222220989 },
{ /*216 f=21600 */ 0.93562030688193953409, 0.97199999999999997513, 0.94400000000000006128 },
{ /*217 f=21700 */ 0.93369480080417466272, 0.97348611111111105210, 0.94697222222222221522 },
{ /*218 f=21800 */ 0.93180913782285368363, 0.97494444444444439135, 0.94988888888888889372 },
{ /*219 f=21900 */ 0.92996309239372765276, 0.97637499999999999289, 0.95274999999999998579 },
{ /*220 f=22000 */ 0.92815644399589514180, 0.97777777777777774570, 0.95555555555555549141 },
{ /*221 f=22100 */ 0.92638897708791390073, 0.97915277777777776080, 0.95830555555555552161 },
{ /*222 f=22200 */ 0.92466048106496112613, 0.98050000000000003819, 0.96100000000000007638 },
{ /*223 f=22300 */ 0.92297075021702223996, 0.98181944444444446685, 0.96363888888888893369 },
{ /*224 f=22400 */ 0.92131958368810318305, 0.98311111111111104677, 0.96622222222222220456 },
{ /*225 f=22500 */ 0.91970678543644734937, 0.98437500000000000000, 0.96875000000000000000 },
{ /*226 f=22600 */ 0.91813216419575605087, 0.98561111111111110450, 0.97122222222222220900 },
{ /*227 f=22700 */ 0.91659553343739175180, 0.98681944444444447129, 0.97363888888888883155 },
{ /*228 f=22800 */ 0.91509671133356040862, 0.98799999999999998934, 0.97599999999999997868 },
{ /*229 f=22900 */ 0.91363552072145981509, 0.98915277777777776969, 0.97830555555555553937 },
{ /*230 f=23000 */ 0.91221178906838484846, 0.99027777777777781232, 0.98055555555555562464 },
{ /*231 f=23100 */ 0.91082534843778018008, 0.99137500000000000622, 0.98275000000000001243 },
{ /*232 f=23200 */ 0.90947603545622990318, 0.99244444444444446241, 0.98488888888888892481 },
{ /*233 f=23300 */ 0.90816369128137697242, 0.99348611111111106986, 0.98697222222222225074 },
{ /*234 f=23400 */ 0.90688816157076113100, 0.99449999999999993960, 0.98899999999999999023 },
{ /*235 f=23500 */ 0.90564929645157077331, 0.99548611111111107164, 0.99097222222222225430 },
{ /*236 f=23600 */ 0.90444695049129464337, 0.99644444444444446596, 0.99288888888888882089 },
{ /*237 f=23700 */ 0.90328098266927037141, 0.99737500000000001155, 0.99475000000000002309 },
{ /*238 f=23800 */ 0.90215125634912063379, 0.99827777777777781942, 0.99655555555555552782 },
{ /*239 f=23900 */ 0.90105763925206716625, 0.99915277777777777857, 0.99830555555555555713 },
{ /*240 f=24000 */ 0.90000000343111907775, 1.00000000000000000000, 1.00000000000000000000 }
};
static FLOAT_T moog_q110[241][3] = {
{ /* dummy entry */ 0, 0, 0},
{ /*  1 f=  100 */ 3.64408784750664160867, 0.00748611111111113781, -0.98502777777777772439 },
{ /*  2 f=  200 */ 3.60660533463349342043, 0.01494444444444442688, -0.97011111111111114624 },
{ /*  3 f=  300 */ 3.56964581438364758625, 0.02237499999999997824, -0.95525000000000004352 },
{ /*  4 f=  400 */ 3.53320109540522286906, 0.02977777777777779189, -0.94044444444444441622 },
{ /*  5 f=  500 */ 3.49726312930069438423, 0.03715277777777775681, -0.92569444444444448639 },
{ /*  6 f=  600 */ 3.46182400793399347450, 0.04449999999999998401, -0.91100000000000003197 },
{ /*  7 f=  700 */ 3.42687596079191880705, 0.05181944444444447351, -0.89636111111111105298 },
{ /*  8 f=  800 */ 3.39241135239869828766, 0.05911111111111111427, -0.88177777777777777146 },
{ /*  9 f=  900 */ 3.35842267978257025263, 0.06637500000000001732, -0.86724999999999996536 },
{ /* 10 f= 1000 */ 3.32490256999327860044, 0.07361111111111112715, -0.85277777777777774570 },
{ /* 11 f= 1100 */ 3.29184377766939162413, 0.08081944444444444375, -0.83836111111111111249 },
{ /* 12 f= 1200 */ 3.25923918265439560571, 0.08800000000000002265, -0.82399999999999995470 },
{ /* 13 f= 1300 */ 3.22708178766052133923, 0.09515277777777780832, -0.80969444444444438336 },
{ /* 14 f= 1400 */ 3.19536471597929327970, 0.10227777777777780077, -0.79544444444444439846 },
{ /* 15 f= 1500 */ 3.16408120923781988054, 0.10937500000000000000, -0.78125000000000000000 },
{ /* 16 f= 1600 */ 3.13322462519984012985, 0.11644444444444446152, -0.76711111111111107697 },
{ /* 17 f= 1700 */ 3.10278843561060169165, 0.12348611111111112981, -0.75302777777777774038 },
{ /* 18 f= 1800 */ 3.07276622408463317981, 0.13050000000000000488, -0.73899999999999999023 },
{ /* 19 f= 1900 */ 3.04315168403550506682, 0.13748611111111108674, -0.72502777777777782653 },
{ /* 20 f= 2000 */ 3.01393861664671014466, 0.14444444444444443088, -0.71111111111111113825 },
{ /* 21 f= 2100 */ 2.98512092888277758007, 0.15137499999999998179, -0.69725000000000003642 },
{ /* 22 f= 2200 */ 2.95669263153979589021, 0.15827777777777779500, -0.68344444444444441000 },
{ /* 23 f= 2300 */ 2.92864783733450240177, 0.16515277777777781498, -0.66969444444444437003 },
{ /* 24 f= 2400 */ 2.90098075903114427376, 0.17199999999999998623, -0.65600000000000002753 },
{ /* 25 f= 2500 */ 2.87368570760530817054, 0.17881944444444447528, -0.64236111111111104943 },
{ /* 26 f= 2600 */ 2.84675709044395652825, 0.18561111111111111560, -0.62877777777777776880 },
{ /* 27 f= 2700 */ 2.82018940958090480464, 0.19237500000000001821, -0.61524999999999996358 },
{ /* 28 f= 2800 */ 2.79397725996701185025, 0.19911111111111112759, -0.60177777777777774482 },
{ /* 29 f= 2900 */ 2.76811532777434621266, 0.20581944444444444375, -0.58836111111111111249 },
{ /* 30 f= 3000 */ 2.74259838873363470668, 0.21250000000000002220, -0.57499999999999995559 },
{ /* 31 f= 3100 */ 2.71742130650429469796, 0.21915277777777780743, -0.56169444444444438513 },
{ /* 32 f= 3200 */ 2.69257903107636931139, 0.22577777777777779944, -0.54844444444444440112 },
{ /* 33 f= 3300 */ 2.66806659720371808220, 0.23237499999999999822, -0.53525000000000000355 },
{ /* 34 f= 3400 */ 2.64387912286780091264, 0.23894444444444445930, -0.52211111111111108141 },
{ /* 35 f= 3500 */ 2.62001180777142694822, 0.24548611111111112715, -0.50902777777777774570 },
{ /* 36 f= 3600 */ 2.59645993186185819468, 0.25200000000000000178, -0.49599999999999999645 },
{ /* 37 f= 3700 */ 2.57321885388264481875, 0.25848611111111113869, -0.48302777777777772261 },
{ /* 38 f= 3800 */ 2.55028400995361836934, 0.26494444444444442688, -0.47011111111111114624 },
{ /* 39 f= 3900 */ 2.52765091217844606319, 0.27137500000000003286, -0.45724999999999998979 },
{ /* 40 f= 4000 */ 2.50531514727919413232, 0.27777777777777779011, -0.44444444444444447528 },
{ /* 41 f= 4100 */ 2.48327237525733357515, 0.28415277777777780965, -0.43169444444444443620 },
{ /* 42 f= 4200 */ 2.46151832808065051950, 0.29049999999999998046, -0.41900000000000003908 },
{ /* 43 f= 4300 */ 2.44004880839553495164, 0.29681944444444441356, -0.40636111111111111738 },
{ /* 44 f= 4400 */ 2.41885968826411890120, 0.30311111111111110894, -0.39377777777777778212 },
{ /* 45 f= 4500 */ 2.39794690792576314919, 0.30937500000000001110, -0.38124999999999997780 },
{ /* 46 f= 4600 */ 2.37730647458238886216, 0.31561111111111117555, -0.36877777777777770440 },
{ /* 47 f= 4700 */ 2.35693446120717808867, 0.32181944444444443576, -0.35636111111111112848 },
{ /* 48 f= 4800 */ 2.33682700537615284375, 0.32800000000000001377, -0.34399999999999997247 },
{ /* 49 f= 4900 */ 2.31698030812218114249, 0.33415277777777774304, -0.33169444444444445841 },
{ /* 50 f= 5000 */ 2.29739063281094013647, 0.34027777777777779011, -0.31944444444444441977 },
{ /* 51 f= 5100 */ 2.27805430403840869502, 0.34637499999999998845, -0.30725000000000002309 },
{ /* 52 f= 5200 */ 2.25896770654942713463, 0.35244444444444444908, -0.29511111111111110183 },
{ /* 53 f= 5300 */ 2.24012728417692752458, 0.35848611111111111649, -0.28302777777777776702 },
{ /* 54 f= 5400 */ 2.22152953880138914755, 0.36450000000000004619, -0.27099999999999996314 },
{ /* 55 f= 5500 */ 2.20317102933013098109, 0.37048611111111107164, -0.25902777777777780122 },
{ /* 56 f= 5600 */ 2.18504837069602331212, 0.37644444444444447040, -0.24711111111111108696 },
{ /* 57 f= 5700 */ 2.16715823287524500529, 0.38237500000000002043, -0.23525000000000001465 },
{ /* 58 f= 5800 */ 2.14949733992368452462, 0.38827777777777777724, -0.22344444444444441777 },
{ /* 59 f= 5900 */ 2.13206246903162854878, 0.39415277777777779633, -0.21169444444444446285 },
{ /* 60 f= 6000 */ 2.11485044959635049011, 0.40000000000000002220, -0.19999999999999998335 },
{ /* 61 f= 6100 */ 2.09785816231225918926, 0.40581944444444439934, -0.18836111111111114580 },
{ /* 62 f= 6200 */ 2.08108253827824274396, 0.41161111111111114980, -0.17677777777777770041 },
{ /* 63 f= 6300 */ 2.06452055812186729966, 0.41737500000000005151, -0.16524999999999995248 },
{ /* 64 f= 6400 */ 2.04816925114009817932, 0.42311111111111110450, -0.15377777777777776325 },
{ /* 65 f= 6500 */ 2.03202569445620184752, 0.42881944444444441977, -0.14236111111111113270 },
{ /* 66 f= 6600 */ 2.01608701219252228753, 0.43450000000000005285, -0.13099999999999992206 },
{ /* 67 f= 6700 */ 2.00035037465880050078, 0.44015277777777778168, -0.11969444444444440889 },
{ /* 68 f= 6800 */ 1.98481299755573803445, 0.44577777777777777279, -0.10844444444444444053 },
{ /* 69 f= 6900 */ 1.96947214119349367500, 0.45137499999999997069, -0.09725000000000004474 },
{ /* 70 f= 7000 */ 1.95432510972482620382, 0.45694444444444448639, -0.08611111111111104111 },
{ /* 71 f= 7100 */ 1.93936925039258434289, 0.46248611111111115335, -0.07502777777777774881 },
{ /* 72 f= 7200 */ 1.92460195279126256018, 0.46799999999999997158, -0.06400000000000001521 },
{ /* 73 f= 7300 */ 1.91002064814234917556, 0.47348611111111110761, -0.05302777777777782642 },
{ /* 74 f= 7400 */ 1.89562280858318588095, 0.47894444444444445041, -0.04211111111111105060 },
{ /* 75 f= 7500 */ 1.88140594646908199117, 0.48437500000000000000, -0.03124999999999997918 },
{ /* 76 f= 7600 */ 1.86736761368841164277, 0.48977777777777775636, -0.02044444444444446299 },
{ /* 77 f= 7700 */ 1.85350540099044591713, 0.49515277777777783053, -0.00969444444444435803 },
{ /* 78 f= 7800 */ 1.83981693732567208599, 0.50050000000000005596, 0.00100000000000004794 },
{ /* 79 f= 7900 */ 1.82629988919834285177, 0.50581944444444448816, 0.01163888888888889826 },
{ /* 80 f= 8000 */ 1.81295196003102843108, 0.51111111111111107164, 0.02222222222222219531 },
{ /* 81 f= 8100 */ 1.79977088954093100703, 0.51637500000000002842, 0.03275000000000007766 },
{ /* 82 f= 8200 */ 1.78675445312773106821, 0.52161111111111113647, 0.04322222222222225907 },
{ /* 83 f= 8300 */ 1.77390046127274181309, 0.52681944444444439579, 0.05363888888888888873 },
{ /* 84 f= 8400 */ 1.76120675894914935355, 0.53200000000000002842, 0.06399999999999995970 },
{ /* 85 f= 8500 */ 1.74867122504312955122, 0.53715277777777781232, 0.07430555555555562464 },
{ /* 86 f= 8600 */ 1.73629177178561611150, 0.54227777777777774748, 0.08455555555555557823 },
{ /* 87 f= 8700 */ 1.72406634419452831075, 0.54737499999999994493, 0.09474999999999998701 },
{ /* 88 f= 8800 */ 1.71199291952724519383, 0.55244444444444440467, 0.10488888888888885098 },
{ /* 89 f= 8900 */ 1.70006950674313261906, 0.55748611111111112670, 0.11497222222222228116 },
{ /* 90 f= 9000 */ 1.68829414597592575298, 0.56250000000000000000, 0.12500000000000002776 },
{ /* 91 f= 9100 */ 1.67666490801577716674, 0.56748611111111113559, 0.13497222222222221566 },
{ /* 92 f= 9200 */ 1.66517989380078845763, 0.57244444444444453346, 0.14488888888888898365 },
{ /* 93 f= 9300 */ 1.65383723391783221679, 0.57737499999999997158, 0.15475000000000005418 },
{ /* 94 f= 9400 */ 1.64263508811249825392, 0.58227777777777778301, 0.16455555555555556602 },
{ /* 95 f= 9500 */ 1.63157164480797822748, 0.58715277777777774570, 0.17430555555555554692 },
{ /* 96 f= 9600 */ 1.62064512063272303521, 0.59200000000000008171, 0.18400000000000008016 },
{ /* 97 f= 9700 */ 1.60985375995670354499, 0.59681944444444445796, 0.19363888888888891593 },
{ /* 98 f= 9800 */ 1.59919583443610635598, 0.60161111111111109651, 0.20322222222222222077 },
{ /* 99 f= 9900 */ 1.58866964256630938124, 0.60637499999999999734, 0.21274999999999996692 },
{ /*100 f=10000 */ 1.57827350924297382662, 0.61111111111111116045, 0.22222222222222229315 },
{ /*101 f=10100 */ 1.56800578533110290813, 0.61581944444444447484, 0.23163888888888892192 },
{ /*102 f=10200 */ 1.55786484724190765760, 0.62050000000000005151, 0.24099999999999999201 },
{ /*103 f=10300 */ 1.54784909651734192693, 0.62515277777777777946, 0.25030555555555550340 },
{ /*104 f=10400 */ 1.53795695942214982743, 0.62977777777777776969, 0.25955555555555559488 },
{ /*105 f=10500 */ 1.52818688654329482013, 0.63437500000000002220, 0.26875000000000004441 },
{ /*106 f=10600 */ 1.51853735239661791212, 0.63894444444444442599, 0.27788888888888885198 },
{ /*107 f=10700 */ 1.50900685504059972608, 0.64348611111111120309, 0.28697222222222229515 },
{ /*108 f=10800 */ 1.49959391569708588854, 0.64800000000000002043, 0.29600000000000004086 },
{ /*109 f=10900 */ 1.49029707837884450861, 0.65248611111111110006, 0.30497222222222225563 },
{ /*110 f=11000 */ 1.48111490952383051400, 0.65694444444444444198, 0.31388888888888888395 },
{ /*111 f=11100 */ 1.47204599763602761442, 0.66137500000000004619, 0.32275000000000009237 },
{ /*112 f=11200 */ 1.46308895293274621174, 0.66577777777777780166, 0.33155555555555560332 },
{ /*113 f=11300 */ 1.45424240699825535472, 0.67015277777777781942, 0.34030555555555558334 },
{ /*114 f=11400 */ 1.44550501244362950004, 0.67449999999999998845, 0.34899999999999997691 },
{ /*115 f=11500 */ 1.43687544257269639303, 0.67881944444444441977, 0.35763888888888895057 },
{ /*116 f=11600 */ 1.42835239105396860637, 0.68311111111111111338, 0.36622222222222222676 },
{ /*117 f=11700 */ 1.41993457159845215543, 0.68737499999999995826, 0.37474999999999997202 },
{ /*118 f=11800 */ 1.41162071764321672696, 0.69161111111111106542, 0.38322222222222218635 },
{ /*119 f=11900 */ 1.40340958204062560277, 0.69581944444444443487, 0.39163888888888892525 },
{ /*120 f=12000 */ 1.39529993675311758672, 0.69999999999999995559, 0.40000000000000002220 },
{ /*121 f=12100 */ 1.38729057255344034871, 0.70415277777777773860, 0.40830555555555553271 },
{ /*122 f=12200 */ 1.37938029873023082494, 0.70827777777777778390, 0.41655555555555551228 },
{ /*123 f=12300 */ 1.37156794279884763910, 0.71237499999999998046, 0.42474999999999996092 },
{ /*124 f=12400 */ 1.36385235021735651273, 0.71644444444444443931, 0.43288888888888898965 },
{ /*125 f=12500 */ 1.35623238410757607220, 0.72048611111111116045, 0.44097222222222232091 },
{ /*126 f=12600 */ 1.34870692498108679658, 0.72450000000000003286, 0.44900000000000006573 },
{ /*127 f=12700 */ 1.34127487047011806354, 0.72848611111111116756, 0.45697222222222227961 },
{ /*128 f=12800 */ 1.33393513506321892415, 0.73244444444444445352, 0.46488888888888890705 },
{ /*129 f=12900 */ 1.32668664984562689746, 0.73637500000000000178, 0.47275000000000000355 },
{ /*130 f=13000 */ 1.31952836224425107403, 0.74027777777777781232, 0.48055555555555551361 },
{ /*131 f=13100 */ 1.31245923577718159869, 0.74415277777777777413, 0.48830555555555549274 },
{ /*132 f=13200 */ 1.30547824980764803904, 0.74799999999999999822, 0.49600000000000010747 },
{ /*133 f=13300 */ 1.29858439930233937609, 0.75181944444444448461, 0.50363888888888896922 },
{ /*134 f=13400 */ 1.29177669459401411878, 0.75561111111111112226, 0.51122222222222224453 },
{ /*135 f=13500 */ 1.28505416114831771957, 0.75937500000000002220, 0.51875000000000004441 },
{ /*136 f=13600 */ 1.27841583933473224022, 0.76311111111111107341, 0.52622222222222225785 },
{ /*137 f=13700 */ 1.27186078420158610314, 0.76681944444444449793, 0.53363888888888888484 },
{ /*138 f=13800 */ 1.26538806525504932132, 0.77049999999999996270, 0.54099999999999992539 },
{ /*139 f=13900 */ 1.25899676624203959996, 0.77415277777777791179, 0.54830555555555571257 },
{ /*140 f=14000 */ 1.25268598493697780327, 0.77777777777777790114, 0.55555555555555569125 },
{ /*141 f=14100 */ 1.24645483293231373878, 0.78137500000000004174, 0.56275000000000008349 },
{ /*142 f=14200 */ 1.24030243543276186280, 0.78494444444444444464, 0.56988888888888888928 },
{ /*143 f=14300 */ 1.23422793105317962770, 0.78848611111111110983, 0.57697222222222221966 },
{ /*144 f=14400 */ 1.22823047162002119137, 0.79200000000000003730, 0.58399999999999996358 },
{ /*145 f=14500 */ 1.22230922197630564874, 0.79548611111111111605, 0.59097222222222223209 },
{ /*146 f=14600 */ 1.21646335979003761274, 0.79894444444444445708, 0.59788888888888880313 },
{ /*147 f=14700 */ 1.21069207536601730624, 0.80237500000000006040, 0.60475000000000012079 },
{ /*148 f=14800 */ 1.20499457146098176707, 0.80577777777777781498, 0.61155555555555562997 },
{ /*149 f=14900 */ 1.19937006310201899062, 0.80915277777777783186, 0.61830555555555555269 },
{ /*150 f=15000 */ 1.19381777740819683409, 0.81250000000000000000, 0.62500000000000000000 },
{ /*151 f=15100 */ 1.18833695341534961720, 0.81581944444444443043, 0.63163888888888886086 },
{ /*152 f=15200 */ 1.18292684190397134891, 0.81911111111111112315, 0.63822222222222224630 },
{ /*153 f=15300 */ 1.17758670523015429588, 0.82237499999999996714, 0.64474999999999993427 },
{ /*154 f=15400 */ 1.17231581715952715150, 0.82561111111111118444, 0.65122222222222236887 },
{ /*155 f=15500 */ 1.16711346270413840465, 0.82881944444444455300, 0.65763888888888899498 },
{ /*156 f=15600 */ 1.16197893796222961882, 0.83200000000000007283, 0.66400000000000003464 },
{ /*157 f=15700 */ 1.15691154996085776574, 0.83515277777777785495, 0.67030555555555559888 },
{ /*158 f=15800 */ 1.15191061650130799343, 0.83827777777777778834, 0.67655555555555557667 },
{ /*159 f=15900 */ 1.14697546600725619470, 0.84137499999999998401, 0.68274999999999996803 },
{ /*160 f=16000 */ 1.14210543737563163802, 0.84444444444444444198, 0.68888888888888888395 },
{ /*161 f=16100 */ 1.13729987983013081099, 0.84748611111111116223, 0.69497222222222221344 },
{ /*162 f=16200 */ 1.13255815277734517288, 0.85050000000000003375, 0.70100000000000006750 },
{ /*163 f=16300 */ 1.12787962566544708309, 0.85348611111111116756, 0.70697222222222233512 },
{ /*164 f=16400 */ 1.12326367784540304129, 0.85644444444444445264, 0.71288888888888890527 },
{ /*165 f=16500 */ 1.11870969843466205873, 0.85937500000000000000, 0.71875000000000000000 },
{ /*166 f=16600 */ 1.11421708618328252349, 0.86227777777777769863, 0.72455555555555550828 },
{ /*167 f=16700 */ 1.10978524934245381672, 0.86515277777777777057, 0.73030555555555554115 },
{ /*168 f=16800 */ 1.10541360553537648670, 0.86799999999999999378, 0.73599999999999998757 },
{ /*169 f=16900 */ 1.10110158163045701585, 0.87081944444444447928, 0.74163888888888895856 },
{ /*170 f=17000 */ 1.09684861361678342995, 0.87361111111111111605, 0.74722222222222234311 },
{ /*171 f=17100 */ 1.09265414648183845081, 0.87637500000000001510, 0.75275000000000003020 },
{ /*172 f=17200 */ 1.08851763409142088257, 0.87911111111111117644, 0.75822222222222224186 },
{ /*173 f=17300 */ 1.08443853907173037854, 0.88181944444444448905, 0.76363888888888886708 },
{ /*174 f=17400 */ 1.08041633269358694491, 0.88450000000000006395, 0.76900000000000001688 },
{ /*175 f=17500 */ 1.07645049475874787781, 0.88715277777777779011, 0.77430555555555558023 },
{ /*176 f=17600 */ 1.07254051348828594037, 0.88977777777777777857, 0.77955555555555555713 },
{ /*177 f=17700 */ 1.06868588541300080230, 0.89237500000000002931, 0.78475000000000005862 },
{ /*178 f=17800 */ 1.06488611526582332978, 0.89494444444444454234, 0.78988888888888897366 },
{ /*179 f=17900 */ 1.06114071587619096526, 0.89748611111111120664, 0.79497222222222230226 },
{ /*180 f=18000 */ 1.05744920806634978838, 0.90000000000000002220, 0.80000000000000004441 },
{ /*181 f=18100 */ 1.05381112054956505020, 0.90248611111111110006, 0.80497222222222220012 },
{ /*182 f=18200 */ 1.05022598983020243324, 0.90494444444444444020, 0.80988888888888888040 },
{ /*183 f=18300 */ 1.04669336010565205974, 0.90737500000000004263, 0.81474999999999997424 },
{ /*184 f=18400 */ 1.04321278317006771452, 0.90977777777777779633, 0.81955555555555559266 },
{ /*185 f=18500 */ 1.03978381831989108441, 0.91215277777777781232, 0.82430555555555562464 },
{ /*186 f=18600 */ 1.03640603226113436897, 0.91450000000000009059, 0.82900000000000007017 },
{ /*187 f=18700 */ 1.03307899901839506107, 0.91681944444444440911, 0.83363888888888892925 },
{ /*188 f=18800 */ 1.02980229984557136724, 0.91911111111111110095, 0.83822222222222220189 },
{ /*189 f=18900 */ 1.02657552313825983781, 0.92137500000000005507, 0.84274999999999999911 },
{ /*190 f=19000 */ 1.02339826434780301057, 0.92361111111111116045, 0.84722222222222220989 },
{ /*191 f=19100 */ 1.02027012589696464140, 0.92581944444444441711, 0.85163888888888883422 },
{ /*192 f=19200 */ 1.01719071709720698671, 0.92800000000000004707, 0.85600000000000009415 },
{ /*193 f=19300 */ 1.01415965406755081979, 0.93015277777777782831, 0.86030555555555554559 },
{ /*194 f=19400 */ 1.01117655965498398629, 0.93227777777777776080, 0.86455555555555563263 },
{ /*195 f=19500 */ 1.00824106335640850673, 0.93437499999999995559, 0.86875000000000002220 },
{ /*196 f=19600 */ 1.00535280124209336350, 0.93644444444444441267, 0.87288888888888893636 },
{ /*197 f=19700 */ 1.00251141588061654097, 0.93848611111111113203, 0.87697222222222215304 },
{ /*198 f=19800 */ 0.99971655626527178296, 0.94050000000000000266, 0.88100000000000000533 },
{ /*199 f=19900 */ 0.99696787774192097142, 0.94248611111111113559, 0.88497222222222227117 },
{ /*200 f=20000 */ 0.99426504193827025535, 0.94444444444444441977, 0.88888888888888895057 },
{ /*201 f=20100 */ 0.99160771669454916832, 0.94637499999999996625, 0.89275000000000004352 },
{ /*202 f=20200 */ 0.98899557599557430532, 0.94827777777777777501, 0.89655555555555555003 },
{ /*203 f=20300 */ 0.98642829990417679742, 0.95015277777777784607, 0.90030555555555558112 },
{ /*204 f=20400 */ 0.98390557449597648709, 0.95199999999999995737, 0.90400000000000002576 },
{ /*205 f=20500 */ 0.98142709179548004439, 0.95381944444444444198, 0.90763888888888888395 },
{ /*206 f=20600 */ 0.97899254971349114474, 0.95561111111111107785, 0.91122222222222215571 },
{ /*207 f=20700 */ 0.97660165198580861645, 0.95737500000000008704, 0.91475000000000006306 },
{ /*208 f=20800 */ 0.97425410811320001248, 0.95911111111111113647, 0.91822222222222227295 },
{ /*209 f=20900 */ 0.97194963330262984513, 0.96081944444444444819, 0.92163888888888889639 },
{ /*210 f=21000 */ 0.96968794840972871718, 0.96250000000000002220, 0.92500000000000004441 },
{ /*211 f=21100 */ 0.96746877988248580760, 0.96415277777777785850, 0.92830555555555560598 },
{ /*212 f=21200 */ 0.96529185970614872492, 0.96577777777777784607, 0.93155555555555558112 },
{ /*213 f=21300 */ 0.96315692534931507396, 0.96737499999999998490, 0.93474999999999996980 },
{ /*214 f=21400 */ 0.96106371971120185815, 0.96894444444444438602, 0.93788888888888888307 },
{ /*215 f=21500 */ 0.95901199107007606415, 0.97048611111111116045, 0.94097222222222220989 },
{ /*216 f=21600 */ 0.95700149303283410518, 0.97199999999999997513, 0.94400000000000006128 },
{ /*217 f=21700 */ 0.95503198448571213763, 0.97348611111111105210, 0.94697222222222221522 },
{ /*218 f=21800 */ 0.95310322954612036739, 0.97494444444444439135, 0.94988888888888889372 },
{ /*219 f=21900 */ 0.95121499751557836433, 0.97637499999999999289, 0.95274999999999998579 },
{ /*220 f=22000 */ 0.94936706283374883153, 0.97777777777777774570, 0.95555555555555549141 },
{ /*221 f=22100 */ 0.94755920503354651441, 0.97915277777777776080, 0.95830555555555552161 },
{ /*222 f=22200 */ 0.94579120869731925225, 0.98050000000000003819, 0.96100000000000007638 },
{ /*223 f=22300 */ 0.94406286341408118812, 0.98181944444444446685, 0.96363888888888893369 },
{ /*224 f=22400 */ 0.94237396373779314107, 0.98311111111111104677, 0.96622222222222220456 },
{ /*225 f=22500 */ 0.94072430914667048985, 0.98437500000000000000, 0.96875000000000000000 },
{ /*226 f=22600 */ 0.93911370400351723564, 0.98561111111111110450, 0.97122222222222220900 },
{ /*227 f=22700 */ 0.93754195751706526085, 0.98681944444444447129, 0.97363888888888883155 },
{ /*228 f=22800 */ 0.93600888370431578611, 0.98799999999999998934, 0.97599999999999997868 },
{ /*229 f=22900 */ 0.93451430135386859277, 0.98915277777777776969, 0.97830555555555553937 },
{ /*230 f=23000 */ 0.93305803399022879674, 0.99027777777777781232, 0.98055555555555562464 },
{ /*231 f=23100 */ 0.93163990983908473442, 0.99137500000000000622, 0.98275000000000001243 },
{ /*232 f=23200 */ 0.93025976179354297191, 0.99244444444444446241, 0.98488888888888892481 },
{ /*233 f=23300 */ 0.92891742738131477530, 0.99348611111111106986, 0.98697222222222225074 },
{ /*234 f=23400 */ 0.92761274873284127462, 0.99449999999999993960, 0.98899999999999999023 },
{ /*235 f=23500 */ 0.92634557255035476775, 0.99548611111111107164, 0.99097222222222225430 },
{ /*236 f=23600 */ 0.92511575007785962210, 0.99644444444444446596, 0.99288888888888882089 },
{ /*237 f=23700 */ 0.92392313707203033157, 0.99737500000000001155, 0.99475000000000002309 },
{ /*238 f=23800 */ 0.92276759377401784690, 0.99827777777777781942, 0.99655555555555552782 },
{ /*239 f=23900 */ 0.92164898488215407646, 0.99915277777777777857, 0.99830555555555555713 },
{ /*240 f=24000 */ 0.92056717952555011664, 1.00000000000000000000, 1.00000000000000000000 }
};
static FLOAT_T moog_q120[241][3] = {
{ /* dummy entry */ 0, 0, 0},
{ /*  1 f=  100 */ 3.70875861509812532191, 0.00748611111111113781, -0.98502777777777772439 },
{ /*  2 f=  200 */ 3.67061090890906305262, 0.01494444444444442688, -0.97011111111111114624 },
{ /*  3 f=  300 */ 3.63299547677004408541, 0.02237499999999997824, -0.95525000000000004352 },
{ /*  4 f=  400 */ 3.59590398195919735969, 0.02977777777777779189, -0.94044444444444441622 },
{ /*  5 f=  500 */ 3.55932823324598501813, 0.03715277777777775681, -0.92569444444444448639 },
{ /*  6 f=  600 */ 3.52326018215051250948, 0.04449999999999998401, -0.91100000000000003197 },
{ /*  7 f=  700 */ 3.48769192025811314295, 0.05181944444444447351, -0.89636111111111105298 },
{ /*  8 f=  800 */ 3.45261567658802803749, 0.05911111111111111427, -0.88177777777777777146 },
{ /*  9 f=  900 */ 3.41802381501502416938, 0.06637500000000001732, -0.86724999999999996536 },
{ /* 10 f= 1000 */ 3.38390883174283674251, 0.07361111111111112715, -0.85277777777777774570 },
{ /* 11 f= 1100 */ 3.35026335282831366769, 0.08081944444444444375, -0.83836111111111111249 },
{ /* 12 f= 1200 */ 3.31708013175520211036, 0.08800000000000002265, -0.82399999999999995470 },
{ /* 13 f= 1300 */ 3.28435204705651750956, 0.09515277777777780832, -0.80969444444444438336 },
{ /* 14 f= 1400 */ 3.25207209998446078458, 0.10227777777777780077, -0.79544444444444439846 },
{ /* 15 f= 1500 */ 3.22023341222689074570, 0.10937500000000000000, -0.78125000000000000000 },
{ /* 16 f= 1600 */ 3.18882922366934584701, 0.11644444444444446152, -0.76711111111111107697 },
{ /* 17 f= 1700 */ 3.15785289020167647678, 0.12348611111111112981, -0.75302777777777774038 },
{ /* 18 f= 1800 */ 3.12729788156833077295, 0.13050000000000000488, -0.73899999999999999023 },
{ /* 19 f= 1900 */ 3.09715777926137869613, 0.13748611111111108674, -0.72502777777777782653 },
{ /* 20 f= 2000 */ 3.06742627445537729969, 0.14444444444444443088, -0.71111111111111113825 },
{ /* 21 f= 2100 */ 3.03809716598319212721, 0.15137499999999998179, -0.69725000000000003642 },
{ /* 22 f= 2200 */ 3.00916435835192341841, 0.15827777777777779500, -0.68344444444444441000 },
{ /* 23 f= 2300 */ 2.98062185979808003111, 0.16515277777777781498, -0.66969444444444437003 },
{ /* 24 f= 2400 */ 2.95246378038120171894, 0.17199999999999998623, -0.65600000000000002753 },
{ /* 25 f= 2500 */ 2.92468433011510020592, 0.17881944444444447528, -0.64236111111111104943 },
{ /* 26 f= 2600 */ 2.89727781713595300417, 0.18561111111111111560, -0.62877777777777776880 },
{ /* 27 f= 2700 */ 2.87023864590646704542, 0.19237500000000001821, -0.61524999999999996358 },
{ /* 28 f= 2800 */ 2.84356131545536872096, 0.19911111111111112759, -0.60177777777777774482 },
{ /* 29 f= 2900 */ 2.81724041765147559246, 0.20581944444444444375, -0.58836111111111111249 },
{ /* 30 f= 3000 */ 2.79127063551163923094, 0.21250000000000002220, -0.57499999999999995559 },
{ /* 31 f= 3100 */ 2.76564674154185219379, 0.21915277777777780743, -0.56169444444444438513 },
{ /* 32 f= 3200 */ 2.74036359611082280807, 0.22577777777777779944, -0.54844444444444440112 },
{ /* 33 f= 3300 */ 2.71541614585535739934, 0.23237499999999999822, -0.53525000000000000355 },
{ /* 34 f= 3400 */ 2.69079942211688383225, 0.23894444444444445930, -0.52211111111111108141 },
{ /* 35 f= 3500 */ 2.66650853940847065715, 0.24548611111111112715, -0.50902777777777774570 },
{ /* 36 f= 3600 */ 2.64253869391171569703, 0.25200000000000000178, -0.49599999999999999645 },
{ /* 37 f= 3700 */ 2.61888516200288679059, 0.25848611111111113869, -0.48302777777777772261 },
{ /* 38 f= 3800 */ 2.59554329880770939809, 0.26494444444444442688, -0.47011111111111114624 },
{ /* 39 f= 3900 */ 2.57250853678421398385, 0.27137500000000003286, -0.45724999999999998979 },
{ /* 40 f= 4000 */ 2.54977638433306319499, 0.27777777777777779011, -0.44444444444444447528 },
{ /* 41 f= 4100 */ 2.52734242443479795170, 0.28415277777777780965, -0.43169444444444443620 },
{ /* 42 f= 4200 */ 2.50520231331344378489, 0.29049999999999998046, -0.41900000000000003908 },
{ /* 43 f= 4300 */ 2.48335177912594540217, 0.29681944444444441356, -0.40636111111111111738 },
{ /* 44 f= 4400 */ 2.46178662067689524307, 0.30311111111111110894, -0.39377777777777778212 },
{ /* 45 f= 4500 */ 2.44050270615803954755, 0.30937500000000001110, -0.38124999999999997780 },
{ /* 46 f= 4600 */ 2.41949597191205389990, 0.31561111111111117555, -0.36877777777777770440 },
{ /* 47 f= 4700 */ 2.39876242122010152613, 0.32181944444444443576, -0.35636111111111112848 },
{ /* 48 f= 4800 */ 2.37829812311267696501, 0.32800000000000001377, -0.34399999999999997247 },
{ /* 49 f= 4900 */ 2.35809921120327370403, 0.33415277777777774304, -0.33169444444444445841 },
{ /* 50 f= 5000 */ 2.33816188254440238126, 0.34027777777777779011, -0.31944444444444441977 },
{ /* 51 f= 5100 */ 2.31848239650551235513, 0.34637499999999998845, -0.30725000000000002309 },
{ /* 52 f= 5200 */ 2.29905707367236322725, 0.35244444444444444908, -0.29511111111111110183 },
{ /* 53 f= 5300 */ 2.27988229476742976232, 0.35848611111111111649, -0.28302777777777776702 },
{ /* 54 f= 5400 */ 2.26095449959088856673, 0.36450000000000004619, -0.27099999999999996314 },
{ /* 55 f= 5500 */ 2.24227018598179839159, 0.37048611111111107164, -0.25902777777777780122 },
{ /* 56 f= 5600 */ 2.22382590879904107339, 0.37644444444444447040, -0.24711111111111108696 },
{ /* 57 f= 5700 */ 2.20561827892164830089, 0.38237500000000002043, -0.23525000000000001465 },
{ /* 58 f= 5800 */ 2.18764396226810209356, 0.38827777777777777724, -0.22344444444444441777 },
{ /* 59 f= 5900 */ 2.16989967883424350603, 0.39415277777777779633, -0.21169444444444446285 },
{ /* 60 f= 6000 */ 2.15238220174940853013, 0.40000000000000002220, -0.19999999999999998335 },
{ /* 61 f= 6100 */ 2.13508835635042482082, 0.40581944444444439934, -0.18836111111111114580 },
{ /* 62 f= 6200 */ 2.11801501927311575102, 0.41161111111111114980, -0.17677777777777770041 },
{ /* 63 f= 6300 */ 2.10115911756095785634, 0.41737500000000005151, -0.16524999999999995248 },
{ /* 64 f= 6400 */ 2.08451762779054972086, 0.42311111111111110450, -0.15377777777777776325 },
{ /* 65 f= 6500 */ 2.06808757521355390807, 0.42881944444444441977, -0.14236111111111113270 },
{ /* 66 f= 6600 */ 2.05186603291479174871, 0.43450000000000005285, -0.13099999999999992206 },
{ /* 67 f= 6700 */ 2.03585012098615925069, 0.44015277777777778168, -0.11969444444444440889 },
{ /* 68 f= 6800 */ 2.02003700571605415703, 0.44577777777777777279, -0.10844444444444444053 },
{ /* 69 f= 6900 */ 2.00442389879400639785, 0.45137499999999997069, -0.09725000000000004474 },
{ /* 70 f= 7000 */ 1.98900805653020906760, 0.45694444444444448639, -0.08611111111111104111 },
{ /* 71 f= 7100 */ 1.97378677908965571852, 0.46248611111111115335, -0.07502777777777774881 },
{ /* 72 f= 7200 */ 1.95875740974058953903, 0.46799999999999997158, -0.06400000000000001521 },
{ /* 73 f= 7300 */ 1.94391733411699307865, 0.47348611111111110761, -0.05302777777777782642 },
{ /* 74 f= 7400 */ 1.92926397949482519856, 0.47894444444444445041, -0.04211111111111105060 },
{ /* 75 f= 7500 */ 1.91479481408175167267, 0.48437500000000000000, -0.03124999999999997918 },
{ /* 76 f= 7600 */ 1.90050734632008677671, 0.48977777777777775636, -0.02044444444444446299 },
{ /* 77 f= 7700 */ 1.88639912420269739712, 0.49515277777777783053, -0.00969444444444435803 },
{ /* 78 f= 7800 */ 1.87246773460161430869, 0.50050000000000005596, 0.00100000000000004794 },
{ /* 79 f= 7900 */ 1.85871080260909127269, 0.50581944444444448816, 0.01163888888888889826 },
{ /* 80 f= 8000 */ 1.84512599089088080717, 0.51111111111111107164, 0.02222222222222219531 },
{ /* 81 f= 8100 */ 1.83171099905147882758, 0.51637500000000002842, 0.03275000000000007766 },
{ /* 82 f= 8200 */ 1.81846356301110945175, 0.52161111111111113647, 0.04322222222222225907 },
{ /* 83 f= 8300 */ 1.80538145439421326977, 0.52681944444444439579, 0.05363888888888888873 },
{ /* 84 f= 8400 */ 1.79246247992922458359, 0.53200000000000002842, 0.06399999999999995970 },
{ /* 85 f= 8500 */ 1.77970448085941179706, 0.53715277777777781232, 0.07430555555555562464 },
{ /* 86 f= 8600 */ 1.76710533236456379669, 0.54227777777777774748, 0.08455555555555557823 },
{ /* 87 f= 8700 */ 1.75466294299331737605, 0.54737499999999994493, 0.09474999999999998701 },
{ /* 88 f= 8800 */ 1.74237525410591520547, 0.55244444444444440467, 0.10488888888888885098 },
{ /* 89 f= 8900 */ 1.73024023932719450691, 0.55748611111111112670, 0.11497222222222228116 },
{ /* 90 f= 9000 */ 1.71825590400960659387, 0.56250000000000000000, 0.12500000000000002776 },
{ /* 91 f= 9100 */ 1.70642028470607165502, 0.56748611111111113559, 0.13497222222222221566 },
{ /* 92 f= 9200 */ 1.69473144865248737112, 0.57244444444444453346, 0.14488888888888898365 },
{ /* 93 f= 9300 */ 1.68318749325969285735, 0.57737499999999997158, 0.15475000000000005418 },
{ /* 94 f= 9400 */ 1.67178654561471651263, 0.58227777777777778301, 0.16455555555555556602 },
{ /* 95 f= 9500 */ 1.66052676199112392297, 0.58715277777777774570, 0.17430555555555554692 },
{ /* 96 f= 9600 */ 1.64940632736829129179, 0.59200000000000008171, 0.18400000000000008016 },
{ /* 97 f= 9700 */ 1.63842345495943808587, 0.59681944444444445796, 0.19363888888888891593 },
{ /* 98 f= 9800 */ 1.62757638574824037292, 0.60161111111111109651, 0.20322222222222222077 },
{ /* 99 f= 9900 */ 1.61686338803387474883, 0.60637499999999999734, 0.21274999999999996692 },
{ /*100 f=10000 */ 1.60628275698432121388, 0.61111111111111116045, 0.22222222222222229315 },
{ /*101 f=10100 */ 1.59583281419777311960, 0.61581944444444447484, 0.23163888888888892192 },
{ /*102 f=10200 */ 1.58551190727199386998, 0.62050000000000005151, 0.24099999999999999201 },
{ /*103 f=10300 */ 1.57531840938147915665, 0.62515277777777777946, 0.25030555555555550340 },
{ /*104 f=10400 */ 1.56525071886226530005, 0.62977777777777776969, 0.25955555555555559488 },
{ /*105 f=10500 */ 1.55530725880424758323, 0.63437500000000002220, 0.26875000000000004441 },
{ /*106 f=10600 */ 1.54548647665085958636, 0.63894444444444442599, 0.27788888888888885198 },
{ /*107 f=10700 */ 1.53578684380597985104, 0.64348611111111120309, 0.28697222222222229515 },
{ /*108 f=10800 */ 1.52620685524792709664, 0.64800000000000002043, 0.29600000000000004086 },
{ /*109 f=10900 */ 1.51674502915040720907, 0.65248611111111110006, 0.30497222222222225563 },
{ /*110 f=11000 */ 1.50739990651028743507, 0.65694444444444444198, 0.31388888888888888395 },
{ /*111 f=11100 */ 1.49817005078206499924, 0.66137500000000004619, 0.32275000000000009237 },
{ /*112 f=11200 */ 1.48905404751890468873, 0.66577777777777780166, 0.33155555555555560332 },
{ /*113 f=11300 */ 1.48005050402012394706, 0.67015277777777781942, 0.34030555555555558334 },
{ /*114 f=11400 */ 1.47115804898500401876, 0.67449999999999998845, 0.34899999999999997691 },
{ /*115 f=11500 */ 1.46237533217280835096, 0.67881944444444441977, 0.35763888888888895057 },
{ /*116 f=11600 */ 1.45370102406889278868, 0.68311111111111111338, 0.36622222222222222676 },
{ /*117 f=11700 */ 1.44513381555679609747, 0.68737499999999995826, 0.37474999999999997202 },
{ /*118 f=11800 */ 1.43667241759619424002, 0.69161111111111106542, 0.38322222222222218635 },
{ /*119 f=11900 */ 1.42831556090661537795, 0.69581944444444443487, 0.39163888888888892525 },
{ /*120 f=12000 */ 1.42006199565680546471, 0.69999999999999995559, 0.40000000000000002220 },
{ /*121 f=12100 */ 1.41191049115964140093, 0.70415277777777773860, 0.40830555555555553271 },
{ /*122 f=12200 */ 1.40385983557248605891, 0.70827777777777778390, 0.41655555555555551228 },
{ /*123 f=12300 */ 1.39590883560289014120, 0.71237499999999998046, 0.42474999999999996092 },
{ /*124 f=12400 */ 1.38805631621953584620, 0.71644444444444443931, 0.43288888888888898965 },
{ /*125 f=12500 */ 1.38030112036833241262, 0.72048611111111116045, 0.44097222222222232091 },
{ /*126 f=12600 */ 1.37264210869356362288, 0.72450000000000003286, 0.44900000000000006573 },
{ /*127 f=12700 */ 1.36507815926399844741, 0.72848611111111116756, 0.45697222222222227961 },
{ /*128 f=12800 */ 1.35760816730386935092, 0.73244444444444445352, 0.46488888888888890705 },
{ /*129 f=12900 */ 1.35023104492863654791, 0.73637500000000000178, 0.47275000000000000355 },
{ /*130 f=13000 */ 1.34294572088544206245, 0.74027777777777781232, 0.48055555555555551361 },
{ /*131 f=13100 */ 1.33575114029817654249, 0.74415277777777777413, 0.48830555555555549274 },
{ /*132 f=13200 */ 1.32864626441706890070, 0.74799999999999999822, 0.49600000000000010747 },
{ /*133 f=13300 */ 1.32163007037271951205, 0.75181944444444448461, 0.50363888888888896922 },
{ /*134 f=13400 */ 1.31470155093449569961, 0.75561111111111112226, 0.51122222222222224453 },
{ /*135 f=13500 */ 1.30785971427321134897, 0.75937500000000002220, 0.51875000000000004441 },
{ /*136 f=13600 */ 1.30110358372801204752, 0.76311111111111107341, 0.52622222222222225785 },
{ /*137 f=13700 */ 1.29443219757739202969, 0.76681944444444449793, 0.53363888888888888484 },
{ /*138 f=13800 */ 1.28784460881426632284, 0.77049999999999996270, 0.54099999999999992539 },
{ /*139 f=13900 */ 1.28133988492502570722, 0.77415277777777791179, 0.54830555555555571257 },
{ /*140 f=14000 */ 1.27491710767250632230, 0.77777777777777790114, 0.55555555555555569125 },
{ /*141 f=14100 */ 1.26857537288279864640, 0.78137500000000004174, 0.56275000000000008349 },
{ /*142 f=14200 */ 1.26231379023583145660, 0.78494444444444444464, 0.56988888888888888928 },
{ /*143 f=14300 */ 1.25613148305966348950, 0.78848611111111110983, 0.57697222222222221966 },
{ /*144 f=14400 */ 1.25002758812841285874, 0.79200000000000003730, 0.58399999999999996358 },
{ /*145 f=14500 */ 1.24400125546376472130, 0.79548611111111111605, 0.59097222222222223209 },
{ /*146 f=14600 */ 1.23805164813999168949, 0.79894444444444445708, 0.59788888888888880313 },
{ /*147 f=14700 */ 1.23217794209242414993, 0.80237500000000006040, 0.60475000000000012079 },
{ /*148 f=14800 */ 1.22637932592931120368, 0.80577777777777781498, 0.61155555555555562997 },
{ /*149 f=14900 */ 1.22065500074701138722, 0.80915277777777783186, 0.61830555555555555269 },
{ /*150 f=15000 */ 1.21500417994845721914, 0.81250000000000000000, 0.62500000000000000000 },
{ /*151 f=15100 */ 1.20942608906483139997, 0.81581944444444443043, 0.63163888888888886086 },
{ /*152 f=15200 */ 1.20391996558040603738, 0.81911111111111112315, 0.63822222222222224630 },
{ /*153 f=15300 */ 1.19848505876048072594, 0.82237499999999996714, 0.64474999999999993427 },
{ /*154 f=15400 */ 1.19312062948237440629, 0.82561111111111118444, 0.65122222222222236887 },
{ /*155 f=15500 */ 1.18782595006941260607, 0.82881944444444455300, 0.65763888888888899498 },
{ /*156 f=15600 */ 1.18260030412785899223, 0.83200000000000007283, 0.66400000000000003464 },
{ /*157 f=15700 */ 1.17744298638674260715, 0.83515277777777785495, 0.67030555555555559888 },
{ /*158 f=15800 */ 1.17235330254052882992, 0.83827777777777778834, 0.67655555555555557667 },
{ /*159 f=15900 */ 1.16733056909458765560, 0.84137499999999998401, 0.68274999999999996803 },
{ /*160 f=16000 */ 1.16237411321340711190, 0.84444444444444444198, 0.68888888888888888395 },
{ /*161 f=16100 */ 1.15748327257151095715, 0.84748611111111116223, 0.69497222222222221344 },
{ /*162 f=16200 */ 1.15265739520702981125, 0.85050000000000003375, 0.70100000000000006750 },
{ /*163 f=16300 */ 1.14789583937788197687, 0.85348611111111116756, 0.70697222222222233512 },
{ /*164 f=16400 */ 1.14319797342052176248, 0.85644444444444445264, 0.71288888888888890527 },
{ /*165 f=16500 */ 1.13856317561120956583, 0.85937500000000000000, 0.71875000000000000000 },
{ /*166 f=16600 */ 1.13399083402976286195, 0.86227777777777769863, 0.72455555555555550828 },
{ /*167 f=16700 */ 1.12948034642574435260, 0.86515277777777777057, 0.73030555555555554115 },
{ /*168 f=16800 */ 1.12503112008705108416, 0.86799999999999999378, 0.73599999999999998757 },
{ /*169 f=16900 */ 1.12064257171085834841, 0.87081944444444447928, 0.74163888888888895856 },
{ /*170 f=17000 */ 1.11631412727688528186, 0.87361111111111111605, 0.74722222222222234311 },
{ /*171 f=17100 */ 1.11204522192293864258, 0.87637500000000001510, 0.75275000000000003020 },
{ /*172 f=17200 */ 1.10783529982270234626, 0.87911111111111117644, 0.75822222222222224186 },
{ /*173 f=17300 */ 1.10368381406572946268, 0.88181944444444448905, 0.76363888888888886708 },
{ /*174 f=17400 */ 1.09959022653960869498, 0.88450000000000006395, 0.76900000000000001688 },
{ /*175 f=17500 */ 1.09555400781426115486, 0.88715277777777779011, 0.77430555555555558023 },
{ /*176 f=17600 */ 1.09157463702834012231, 0.88977777777777777857, 0.77955555555555555713 },
{ /*177 f=17700 */ 1.08765160177769582006, 0.89237500000000002931, 0.78475000000000005862 },
{ /*178 f=17800 */ 1.08378439800587145214, 0.89494444444444454234, 0.78988888888888897366 },
{ /*179 f=17900 */ 1.07997252989660319500, 0.89748611111111120664, 0.79497222222222230226 },
{ /*180 f=18000 */ 1.07621550976828284085, 0.90000000000000002220, 0.80000000000000004441 },
{ /*181 f=18100 */ 1.07251285797036066683, 0.90248611111111110006, 0.80497222222222220012 },
{ /*182 f=18200 */ 1.06886410278165522314, 0.90494444444444444020, 0.80988888888888888040 },
{ /*183 f=18300 */ 1.06526878031053451323, 0.90737500000000004263, 0.81474999999999997424 },
{ /*184 f=18400 */ 1.06172643439694946998, 0.90977777777777779633, 0.81955555555555559266 },
{ /*185 f=18500 */ 1.05823661651627931590, 0.91215277777777781232, 0.82430555555555562464 },
{ /*186 f=18600 */ 1.05479888568497037760, 0.91450000000000009059, 0.82900000000000007017 },
{ /*187 f=18700 */ 1.05141280836793482578, 0.91681944444444440911, 0.83363888888888892925 },
{ /*188 f=18800 */ 1.04807795838768247343, 0.91911111111111110095, 0.83822222222222220189 },
{ /*189 f=18900 */ 1.04479391683516409373, 0.92137500000000005507, 0.84274999999999999911 },
{ /*190 f=19000 */ 1.04156027198229206299, 0.92361111111111116045, 0.84722222222222220989 },
{ /*191 f=19100 */ 1.03837661919612100903, 0.92581944444444441711, 0.85163888888888883422 },
{ /*192 f=19200 */ 1.03524256085465604649, 0.92800000000000004707, 0.85600000000000009415 },
{ /*193 f=19300 */ 1.03215770626427194578, 0.93015277777777782831, 0.86030555555555554559 },
{ /*194 f=19400 */ 1.02912167157871192735, 0.93227777777777776080, 0.86455555555555563263 },
{ /*195 f=19500 */ 1.02613407971964654131, 0.93437499999999995559, 0.86875000000000002220 },
{ /*196 f=19600 */ 1.02319456029876931780, 0.93644444444444441267, 0.87288888888888893636 },
{ /*197 f=19700 */ 1.02030274954140742771, 0.93848611111111113203, 0.87697222222222215304 },
{ /*198 f=19800 */ 1.01745829021162159655, 0.94050000000000000266, 0.88100000000000000533 },
{ /*199 f=19900 */ 1.01466083153877772993, 0.94248611111111113559, 0.88497222222222227117 },
{ /*200 f=20000 */ 1.01191002914556871239, 0.94444444444444441977, 0.88888888888888895057 },
{ /*201 f=20100 */ 1.00920554497746306488, 0.94637499999999996625, 0.89275000000000004352 },
{ /*202 f=20200 */ 1.00654704723356247520, 0.94827777777777777501, 0.89655555555555555003 },
{ /*203 f=20300 */ 1.00393421029884888362, 0.95015277777777784607, 0.90030555555555558112 },
{ /*204 f=20400 */ 1.00136671467780047351, 0.95199999999999995737, 0.90400000000000002576 },
{ /*205 f=20500 */ 0.99884424692935491752, 0.95381944444444444198, 0.90763888888888888395 },
{ /*206 f=20600 */ 0.99636649960321033159, 0.95561111111111107785, 0.91122222222222215571 },
{ /*207 f=20700 */ 0.99393317117743484879, 0.95737500000000008704, 0.91475000000000006306 },
{ /*208 f=20800 */ 0.99154396599737437690, 0.95911111111111113647, 0.91822222222222227295 },
{ /*209 f=20900 */ 0.98919859421583888892, 0.96081944444444444819, 0.92163888888888889639 },
{ /*210 f=21000 */ 0.98689677173454948278, 0.96250000000000002220, 0.92500000000000004441 },
{ /*211 f=21100 */ 0.98463822014683233252, 0.96415277777777785850, 0.92830555555555560598 },
{ /*212 f=21200 */ 0.98242266668154054621, 0.96577777777777784607, 0.93155555555555558112 },
{ /*213 f=21300 */ 0.98024984414818883138, 0.96737499999999998490, 0.93474999999999996980 },
{ /*214 f=21400 */ 0.97811949088328709045, 0.96894444444444438602, 0.93788888888888888307 },
{ /*215 f=21500 */ 0.97603135069785618150, 0.97048611111111116045, 0.94097222222222220989 },
{ /*216 f=21600 */ 0.97398517282611229984, 0.97199999999999997513, 0.94400000000000006128 },
{ /*217 f=21700 */ 0.97198071187530243886, 0.97348611111111105210, 0.94697222222222221522 },
{ /*218 f=21800 */ 0.97001772777668404668, 0.97494444444444439135, 0.94988888888888889372 },
{ /*219 f=21900 */ 0.96809598573762523088, 0.97637499999999999289, 0.95274999999999998579 },
{ /*220 f=22000 */ 0.96621525619482251379, 0.97777777777777774570, 0.95555555555555549141 },
{ /*221 f=22100 */ 0.96437531476861337865, 0.97915277777777776080, 0.95830555555555552161 },
{ /*222 f=22200 */ 0.96257594221837938786, 0.98050000000000003819, 0.96100000000000007638 },
{ /*223 f=22300 */ 0.96081692439902055547, 0.98181944444444446685, 0.96363888888888893369 },
{ /*224 f=22400 */ 0.95909805221849520063, 0.98311111111111104677, 0.96622222222222220456 },
{ /*225 f=22500 */ 0.95741912159640585323, 0.98437500000000000000, 0.96875000000000000000 },
{ /*226 f=22600 */ 0.95577993342362943530, 0.98561111111111110450, 0.97122222222222220900 },
{ /*227 f=22700 */ 0.95418029352297029089, 0.98681944444444447129, 0.97363888888888883155 },
{ /*228 f=22800 */ 0.95262001261083306680, 0.98799999999999998934, 0.97599999999999997868 },
{ /*229 f=22900 */ 0.95109890625990156643, 0.98915277777777776969, 0.97830555555555553937 },
{ /*230 f=23000 */ 0.94961679486281191931, 0.99027777777777781232, 0.98055555555555562464 },
{ /*231 f=23100 */ 0.94817350359681429328, 0.99137500000000000622, 0.98275000000000001243 },
{ /*232 f=23200 */ 0.94676886238940882734, 0.99244444444444446241, 0.98488888888888892481 },
{ /*233 f=23300 */ 0.94540270588494890180, 0.99348611111111106986, 0.98697222222222225074 },
{ /*234 f=23400 */ 0.94407487341220230892, 0.99449999999999993960, 0.98899999999999999023 },
{ /*235 f=23500 */ 0.94278520895286188619, 0.99548611111111107164, 0.99097222222222225430 },
{ /*236 f=23600 */ 0.94153356111099417713, 0.99644444444444446596, 0.99288888888888882089 },
{ /*237 f=23700 */ 0.94031978308342167860, 0.99737500000000001155, 0.99475000000000002309 },
{ /*238 f=23800 */ 0.93914373263102790546, 0.99827777777777781942, 0.99655555555555552782 },
{ /*239 f=23900 */ 0.93800527205097816719, 0.99915277777777777857, 0.99830555555555555713 },
{ /*240 f=24000 */ 0.93690426814984839599, 1.00000000000000000000, 1.00000000000000000000 }
};
static FLOAT_T moog_q130[241][3] = {
{ /* dummy entry */ 0, 0, 0},
{ /*  1 f=  100 */ 3.76012843158107701313, 0.00748611111111113781, -0.98502777777777772439 },
{ /*  2 f=  200 */ 3.72145234356144793963, 0.01494444444444442688, -0.97011111111111114624 },
{ /*  3 f=  300 */ 3.68331590209115500301, 0.02237499999999997824, -0.95525000000000004352 },
{ /*  4 f=  400 */ 3.64571065497684054790, 0.02977777777777779189, -0.94044444444444441622 },
{ /*  5 f=  500 */ 3.60862829753167257962, 0.03715277777777775681, -0.92569444444444448639 },
{ /*  6 f=  600 */ 3.57206066979669323302, 0.04449999999999998401, -0.91100000000000003197 },
{ /*  7 f=  700 */ 3.53599975381820952336, 0.05181944444444447351, -0.89636111111111105298 },
{ /*  8 f=  800 */ 3.50043767098002422955, 0.05911111111111111427, -0.88177777777777777146 },
{ /*  9 f=  900 */ 3.46536667938934428435, 0.06637500000000001732, -0.86724999999999996536 },
{ /* 10 f= 1000 */ 3.43077917131522536209, 0.07361111111111112715, -0.85277777777777774570 },
{ /* 11 f= 1100 */ 3.39666767067842423344, 0.08081944444444444375, -0.83836111111111111249 },
{ /* 12 f= 1200 */ 3.36302483059158152656, 0.08800000000000002265, -0.82399999999999995470 },
{ /* 13 f= 1300 */ 3.32984343094865486989, 0.09515277777777780832, -0.80969444444444438336 },
{ /* 14 f= 1400 */ 3.29711637606256546817, 0.10227777777777780077, -0.79544444444444439846 },
{ /* 15 f= 1500 */ 3.26483669235004025921, 0.10937500000000000000, -0.78125000000000000000 },
{ /* 16 f= 1600 */ 3.23299752606263446353, 0.11644444444444446152, -0.76711111111111107697 },
{ /* 17 f= 1700 */ 3.20159214106298550817, 0.12348611111111112981, -0.75302777777777774038 },
{ /* 18 f= 1800 */ 3.17061391664532354895, 0.13050000000000000488, -0.73899999999999999023 },
{ /* 19 f= 1900 */ 3.14005634539930822413, 0.13748611111111108674, -0.72502777777777782653 },
{ /* 20 f= 2000 */ 3.10991303111629546763, 0.14444444444444443088, -0.71111111111111113825 },
{ /* 21 f= 2100 */ 3.08017768673711689331, 0.15137499999999998179, -0.69725000000000003642 },
{ /* 22 f= 2200 */ 3.05084413234052709285, 0.15827777777777779500, -0.68344444444444441000 },
{ /* 23 f= 2300 */ 3.02190629317144221488, 0.16515277777777781498, -0.66969444444444437003 },
{ /* 24 f= 2400 */ 2.99335819770815181329, 0.17199999999999998623, -0.65600000000000002753 },
{ /* 25 f= 2500 */ 2.96519397576767973490, 0.17881944444444447528, -0.64236111111111104943 },
{ /* 26 f= 2600 */ 2.93740785664850356795, 0.18561111111111111560, -0.62877777777777776880 },
{ /* 27 f= 2700 */ 2.90999416730984394874, 0.19237500000000001821, -0.61524999999999996358 },
{ /* 28 f= 2800 */ 2.88294733058676833082, 0.19911111111111112759, -0.60177777777777774482 },
{ /* 29 f= 2900 */ 2.85626186344036003817, 0.20581944444444444375, -0.58836111111111111249 },
{ /* 30 f= 3000 */ 2.82993237524222340795, 0.21250000000000002220, -0.57499999999999995559 },
{ /* 31 f= 3100 */ 2.80395356609261092729, 0.21915277777777780743, -0.56169444444444438513 },
{ /* 32 f= 3200 */ 2.77832022517147425589, 0.22577777777777779944, -0.54844444444444440112 },
{ /* 33 f= 3300 */ 2.75302722912175745762, 0.23237499999999999822, -0.53525000000000000355 },
{ /* 34 f= 3400 */ 2.72806954046426541893, 0.23894444444444445930, -0.52211111111111108141 },
{ /* 35 f= 3500 */ 2.70344220604344886993, 0.24548611111111112715, -0.50902777777777774570 },
{ /* 36 f= 3600 */ 2.67914035550347540138, 0.25200000000000000178, -0.49599999999999999645 },
{ /* 37 f= 3700 */ 2.65515919979395365047, 0.25848611111111113869, -0.48302777777777772261 },
{ /* 38 f= 3800 */ 2.63149402970470536189, 0.26494444444444442688, -0.47011111111111114624 },
{ /* 39 f= 3900 */ 2.60814021442898180680, 0.27137500000000003286, -0.45724999999999998979 },
{ /* 40 f= 4000 */ 2.58509320015454502339, 0.27777777777777779011, -0.44444444444444447528 },
{ /* 41 f= 4100 */ 2.56234850868203567487, 0.28415277777777780965, -0.43169444444444443620 },
{ /* 42 f= 4200 */ 2.53990173607007241330, 0.29049999999999998046, -0.41900000000000003908 },
{ /* 43 f= 4300 */ 2.51774855130653030244, 0.29681944444444441356, -0.40636111111111111738 },
{ /* 44 f= 4400 */ 2.49588469500547027735, 0.30311111111111110894, -0.39377777777777778212 },
{ /* 45 f= 4500 */ 2.47430597812918406930, 0.30937500000000001110, -0.38124999999999997780 },
{ /* 46 f= 4600 */ 2.45300828073484744607, 0.31561111111111117555, -0.36877777777777770440 },
{ /* 47 f= 4700 */ 2.43198755074528571996, 0.32181944444444443576, -0.35636111111111112848 },
{ /* 48 f= 4800 */ 2.41123980274334615004, 0.32800000000000001377, -0.34399999999999997247 },
{ /* 49 f= 4900 */ 2.39076111678941050087, 0.33415277777777774304, -0.33169444444444445841 },
{ /* 50 f= 5000 */ 2.37054763726156725312, 0.34027777777777779011, -0.31944444444444441977 },
{ /* 51 f= 5100 */ 2.35059557171799271558, 0.34637499999999998845, -0.30725000000000002309 },
{ /* 52 f= 5200 */ 2.33090118978107829761, 0.35244444444444444908, -0.29511111111111110183 },
{ /* 53 f= 5300 */ 2.31146082204287939277, 0.35848611111111111649, -0.28302777777777776702 },
{ /* 54 f= 5400 */ 2.29227085899143556702, 0.36450000000000004619, -0.27099999999999996314 },
{ /* 55 f= 5500 */ 2.27332774995756325964, 0.37048611111111107164, -0.25902777777777780122 },
{ /* 56 f= 5600 */ 2.25462800208167912785, 0.37644444444444447040, -0.24711111111111108696 },
{ /* 57 f= 5700 */ 2.23616817930028277672, 0.38237500000000002043, -0.23525000000000001465 },
{ /* 58 f= 5800 */ 2.21794490135167121636, 0.38827777777777777724, -0.22344444444444441777 },
{ /* 59 f= 5900 */ 2.19995484280052444603, 0.39415277777777779633, -0.21169444444444446285 },
{ /* 60 f= 6000 */ 2.18219473208096603756, 0.40000000000000002220, -0.19999999999999998335 },
{ /* 61 f= 6100 */ 2.16466135055773500895, 0.40581944444444439934, -0.18836111111111114580 },
{ /* 62 f= 6200 */ 2.14735153160510439108, 0.41161111111111114980, -0.17677777777777770041 },
{ /* 63 f= 6300 */ 2.13026215970319521276, 0.41737500000000005151, -0.16524999999999995248 },
{ /* 64 f= 6400 */ 2.11339016955133152109, 0.42311111111111110450, -0.15377777777777776325 },
{ /* 65 f= 6500 */ 2.09673254519809448837, 0.42881944444444441977, -0.14236111111111113270 },
{ /* 66 f= 6600 */ 2.08028631918776252263, 0.43450000000000005285, -0.13099999999999992206 },
{ /* 67 f= 6700 */ 2.06404857172277811372, 0.44015277777777778168, -0.11969444444444440889 },
{ /* 68 f= 6800 */ 2.04801642984195142461, 0.44577777777777777279, -0.10844444444444444053 },
{ /* 69 f= 6900 */ 2.03218706661407377823, 0.45137499999999997069, -0.09725000000000004474 },
{ /* 70 f= 7000 */ 2.01655770034663905932, 0.45694444444444448639, -0.08611111111111104111 },
{ /* 71 f= 7100 */ 2.00112559380937016229, 0.46248611111111115335, -0.07502777777777774881 },
{ /* 72 f= 7200 */ 1.98588805347226160514, 0.46799999999999997158, -0.06400000000000001521 },
{ /* 73 f= 7300 */ 1.97084242875785231597, 0.47348611111111110761, -0.05302777777777782642 },
{ /* 74 f= 7400 */ 1.95598611130743882391, 0.47894444444444445041, -0.04211111111111105060 },
{ /* 75 f= 7500 */ 1.94131653426096728587, 0.48437500000000000000, -0.03124999999999997918 },
{ /* 76 f= 7600 */ 1.92683117155031990997, 0.48977777777777775636, -0.02044444444444446299 },
{ /* 77 f= 7700 */ 1.91252753720574464324, 0.49515277777777783053, -0.00969444444444435803 },
{ /* 78 f= 7800 */ 1.89840318467516633305, 0.50050000000000005596, 0.00100000000000004794 },
{ /* 79 f= 7900 */ 1.88445570615611890375, 0.50581944444444448816, 0.01163888888888889826 },
{ /* 80 f= 8000 */ 1.87068273194006384763, 0.51111111111111107164, 0.02222222222222219531 },
{ /* 81 f= 8100 */ 1.85708192976884212122, 0.51637500000000002842, 0.03275000000000007766 },
{ /* 82 f= 8200 */ 1.84365100420303074102, 0.52161111111111113647, 0.04322222222222225907 },
{ /* 83 f= 8300 */ 1.83038769600196005172, 0.52681944444444439579, 0.05363888888888888873 },
{ /* 84 f= 8400 */ 1.81728978151517717166, 0.53200000000000002842, 0.06399999999999995970 },
{ /* 85 f= 8500 */ 1.80435507208512757593, 0.53715277777777781232, 0.07430555555555562464 },
{ /* 86 f= 8600 */ 1.79158141346082877554, 0.54227777777777774748, 0.08455555555555557823 },
{ /* 87 f= 8700 */ 1.77896668522233758480, 0.54737499999999994493, 0.09474999999999998701 },
{ /* 88 f= 8800 */ 1.76650880021578760015, 0.55244444444444440467, 0.10488888888888885098 },
{ /* 89 f= 8900 */ 1.75420570399880282331, 0.55748611111111112670, 0.11497222222222228116 },
{ /* 90 f= 9000 */ 1.74205537429607804079, 0.56250000000000000000, 0.12500000000000002776 },
{ /* 91 f= 9100 */ 1.73005582046493322501, 0.56748611111111113559, 0.13497222222222221566 },
{ /* 92 f= 9200 */ 1.71820508297065455139, 0.57244444444444453346, 0.14488888888888898365 },
{ /* 93 f= 9300 */ 1.70650123287142063688, 0.57737499999999997158, 0.15475000000000005418 },
{ /* 94 f= 9400 */ 1.69494237131264324780, 0.58227777777777778301, 0.16455555555555556602 },
{ /* 95 f= 9500 */ 1.68352662903053151844, 0.58715277777777774570, 0.17430555555555554692 },
{ /* 96 f= 9600 */ 1.67225216586470870617, 0.59200000000000008171, 0.18400000000000008016 },
{ /* 97 f= 9700 */ 1.66111717027970651195, 0.59681944444444445796, 0.19363888888888891593 },
{ /* 98 f= 9800 */ 1.65011985889516044068, 0.60161111111111109651, 0.20322222222222222077 },
{ /* 99 f= 9900 */ 1.63925847602455188046, 0.60637499999999999734, 0.21274999999999996692 },
{ /*100 f=10000 */ 1.62853129322232370590, 0.61111111111111116045, 0.22222222222222229315 },
{ /*101 f=10100 */ 1.61793660883921619487, 0.61581944444444447484, 0.23163888888888892192 },
{ /*102 f=10200 */ 1.60747274758565827923, 0.62050000000000005151, 0.24099999999999999201 },
{ /*103 f=10300 */ 1.59713806010307268757, 0.62515277777777777946, 0.25030555555555550340 },
{ /*104 f=10400 */ 1.58693092254293421917, 0.62977777777777776969, 0.25955555555555559488 },
{ /*105 f=10500 */ 1.57684973615344081743, 0.63437500000000002220, 0.26875000000000004441 },
{ /*106 f=10600 */ 1.56689292687364867263, 0.63894444444444442599, 0.27788888888888885198 },
{ /*107 f=10700 */ 1.55705894493493346431, 0.64348611111111120309, 0.28697222222222229515 },
{ /*108 f=10800 */ 1.54734626446963896562, 0.64800000000000002043, 0.29600000000000004086 },
{ /*109 f=10900 */ 1.53775338312677534169, 0.65248611111111110006, 0.30497222222222225563 },
{ /*110 f=11000 */ 1.52827882169463502571, 0.65694444444444444198, 0.31388888888888888395 },
{ /*111 f=11100 */ 1.51892112373020116145, 0.66137500000000004619, 0.32275000000000009237 },
{ /*112 f=11200 */ 1.50967885519521094473, 0.66577777777777780166, 0.33155555555555560332 },
{ /*113 f=11300 */ 1.50055060409875973271, 0.67015277777777781942, 0.34030555555555558334 },
{ /*114 f=11400 */ 1.49153498014631602508, 0.67449999999999998845, 0.34899999999999997691 },
{ /*115 f=11500 */ 1.48263061439503118777, 0.67881944444444441977, 0.35763888888888895057 },
{ /*116 f=11600 */ 1.47383615891522534724, 0.68311111111111111338, 0.36622222222222222676 },
{ /*117 f=11700 */ 1.46515028645793510265, 0.68737499999999995826, 0.37474999999999997202 },
{ /*118 f=11800 */ 1.45657169012840848055, 0.69161111111111106542, 0.38322222222222218635 },
{ /*119 f=11900 */ 1.44809908306543766443, 0.69581944444444443487, 0.39163888888888892525 },
{ /*120 f=12000 */ 1.43973119812642336157, 0.69999999999999995559, 0.40000000000000002220 },
{ /*121 f=12100 */ 1.43146678757806067317, 0.70415277777777773860, 0.40830555555555553271 },
{ /*122 f=12200 */ 1.42330462279254565949, 0.70827777777777778390, 0.41655555555555551228 },
{ /*123 f=12300 */ 1.41524349394919890521, 0.71237499999999998046, 0.42474999999999996092 },
{ /*124 f=12400 */ 1.40728220974140727506, 0.71644444444444443931, 0.43288888888888898965 },
{ /*125 f=12500 */ 1.39941959708878571611, 0.72048611111111116045, 0.44097222222222232091 },
{ /*126 f=12600 */ 1.39165450085446340545, 0.72450000000000003286, 0.44900000000000006573 },
{ /*127 f=12700 */ 1.38398578356739943018, 0.72848611111111116756, 0.45697222222222227961 },
{ /*128 f=12800 */ 1.37641232514963718359, 0.73244444444444445352, 0.46488888888888890705 },
{ /*129 f=12900 */ 1.36893302264840599491, 0.73637500000000000178, 0.47275000000000000355 },
{ /*130 f=13000 */ 1.36154678997298228538, 0.74027777777777781232, 0.48055555555555551361 },
{ /*131 f=13100 */ 1.35425255763622454097, 0.74415277777777777413, 0.48830555555555549274 },
{ /*132 f=13200 */ 1.34704927250069395051, 0.74799999999999999822, 0.49600000000000010747 },
{ /*133 f=13300 */ 1.33993589752928188297, 0.75181944444444448461, 0.50363888888888896922 },
{ /*134 f=13400 */ 1.33291141154025805093, 0.75561111111111112226, 0.51122222222222224453 },
{ /*135 f=13500 */ 1.32597480896666386485, 0.75937500000000002220, 0.51875000000000004441 },
{ /*136 f=13600 */ 1.31912509961996793351, 0.76311111111111107341, 0.52622222222222225785 },
{ /*137 f=13700 */ 1.31236130845791110211, 0.76681944444444449793, 0.53363888888888888484 },
{ /*138 f=13800 */ 1.30568247535646442259, 0.77049999999999996270, 0.54099999999999992539 },
{ /*139 f=13900 */ 1.29908765488582256253, 0.77415277777777791179, 0.54830555555555571257 },
{ /*140 f=14000 */ 1.29257591609036803781, 0.77777777777777790114, 0.55555555555555569125 },
{ /*141 f=14100 */ 1.28614634227252722098, 0.78137500000000004174, 0.56275000000000008349 },
{ /*142 f=14200 */ 1.27979803078045328846, 0.78494444444444444464, 0.56988888888888888928 },
{ /*143 f=14300 */ 1.27353009279946882693, 0.78848611111111110983, 0.57697222222222221966 },
{ /*144 f=14400 */ 1.26734165314719660067, 0.79200000000000003730, 0.58399999999999996358 },
{ /*145 f=14500 */ 1.26123185007231808363, 0.79548611111111111605, 0.59097222222222223209 },
{ /*146 f=14600 */ 1.25519983505689203263, 0.79894444444444445708, 0.59788888888888880313 },
{ /*147 f=14700 */ 1.24924477262217381579, 0.80237500000000006040, 0.60475000000000012079 },
{ /*148 f=14800 */ 1.24336584013786888292, 0.80577777777777781498, 0.61155555555555562997 },
{ /*149 f=14900 */ 1.23756222763476420035, 0.80915277777777783186, 0.61830555555555555269 },
{ /*150 f=15000 */ 1.23183313762067836450, 0.81250000000000000000, 0.62500000000000000000 },
{ /*151 f=15100 */ 1.22617778489966822164, 0.81581944444444443043, 0.63163888888888886086 },
{ /*152 f=15200 */ 1.22059539639444158965, 0.81911111111111112315, 0.63822222222222224630 },
{ /*153 f=15300 */ 1.21508521097191191096, 0.82237499999999996714, 0.64474999999999993427 },
{ /*154 f=15400 */ 1.20964647927184953957, 0.82561111111111118444, 0.65122222222222236887 },
{ /*155 f=15500 */ 1.20427846353856948802, 0.82881944444444455300, 0.65763888888888899498 },
{ /*156 f=15600 */ 1.19898043745560411999, 0.83200000000000007283, 0.66400000000000003464 },
{ /*157 f=15700 */ 1.19375168598331238279, 0.83515277777777785495, 0.67030555555555559888 },
{ /*158 f=15800 */ 1.18859150519937095680, 0.83827777777777778834, 0.67655555555555557667 },
{ /*159 f=15900 */ 1.18349920214210180269, 0.84137499999999998401, 0.68274999999999996803 },
{ /*160 f=16000 */ 1.17847409465658525818, 0.84444444444444444198, 0.68888888888888888395 },
{ /*161 f=16100 */ 1.17351551124350983457, 0.84748611111111116223, 0.69497222222222221344 },
{ /*162 f=16200 */ 1.16862279091071763482, 0.85050000000000003375, 0.70100000000000006750 },
{ /*163 f=16300 */ 1.16379528302739143619, 0.85348611111111116756, 0.70697222222222233512 },
{ /*164 f=16400 */ 1.15903234718084813260, 0.85644444444444445264, 0.71288888888888890527 },
{ /*165 f=16500 */ 1.15433335303588591181, 0.85937500000000000000, 0.71875000000000000000 },
{ /*166 f=16600 */ 1.14969768019664853043, 0.86227777777777769863, 0.72455555555555550828 },
{ /*167 f=16700 */ 1.14512471807096027909, 0.86515277777777777057, 0.73030555555555554115 },
{ /*168 f=16800 */ 1.14061386573709455661, 0.86799999999999999378, 0.73599999999999998757 },
{ /*169 f=16900 */ 1.13616453181293053376, 0.87081944444444447928, 0.74163888888888895856 },
{ /*170 f=17000 */ 1.13177613432746348998, 0.87361111111111111605, 0.74722222222222234311 },
{ /*171 f=17100 */ 1.12744810059462419183, 0.87637500000000001510, 0.75275000000000003020 },
{ /*172 f=17200 */ 1.12317986708937578300, 0.87911111111111117644, 0.75822222222222224186 },
{ /*173 f=17300 */ 1.11897087932604466509, 0.88181944444444448905, 0.76363888888888886708 },
{ /*174 f=17400 */ 1.11482059173885272862, 0.88450000000000006395, 0.76900000000000001688 },
{ /*175 f=17500 */ 1.11072846756461407480, 0.88715277777777779011, 0.77430555555555558023 },
{ /*176 f=17600 */ 1.10669397872755914669, 0.88977777777777777857, 0.77955555555555555713 },
{ /*177 f=17700 */ 1.10271660572625562757, 0.89237500000000002931, 0.78475000000000005862 },
{ /*178 f=17800 */ 1.09879583752258835894, 0.89494444444444454234, 0.78988888888888897366 },
{ /*179 f=17900 */ 1.09493117143276852410, 0.89748611111111120664, 0.79497222222222230226 },
{ /*180 f=18000 */ 1.09112211302033634830, 0.90000000000000002220, 0.80000000000000004441 },
{ /*181 f=18100 */ 1.08736817599112822741, 0.90248611111111110006, 0.80497222222222220012 },
{ /*182 f=18200 */ 1.08366888209017742106, 0.90494444444444444020, 0.80988888888888888040 },
{ /*183 f=18300 */ 1.08002376100051478147, 0.90737500000000004263, 0.81474999999999997424 },
{ /*184 f=18400 */ 1.07643235024384176235, 0.90977777777777779633, 0.81955555555555559266 },
{ /*185 f=18500 */ 1.07289419508304817441, 0.91215277777777781232, 0.82430555555555562464 },
{ /*186 f=18600 */ 1.06940884842654004849, 0.91450000000000009059, 0.82900000000000007017 },
{ /*187 f=18700 */ 1.06597587073435873251, 0.91681944444444440911, 0.83363888888888892925 },
{ /*188 f=18800 */ 1.06259482992605236440, 0.91911111111111110095, 0.83822222222222220189 },
{ /*189 f=18900 */ 1.05926530129028506622, 0.92137500000000005507, 0.84274999999999999911 },
{ /*190 f=19000 */ 1.05598686739614544550, 0.92361111111111116045, 0.84722222222222220989 },
{ /*191 f=19100 */ 1.05275911800613886093, 0.92581944444444441711, 0.85163888888888883422 },
{ /*192 f=19200 */ 1.04958164999082992352, 0.92800000000000004707, 0.85600000000000009415 },
{ /*193 f=19300 */ 1.04645406724511658147, 0.93015277777777782831, 0.86030555555555554559 },
{ /*194 f=19400 */ 1.04337598060610825534, 0.93227777777777776080, 0.86455555555555563263 },
{ /*195 f=19500 */ 1.04034700777258382054, 0.93437499999999995559, 0.86875000000000002220 },
{ /*196 f=19600 */ 1.03736677322600834295, 0.93644444444444441267, 0.87288888888888893636 },
{ /*197 f=19700 */ 1.03443490815308525299, 0.93848611111111113203, 0.87697222222222215304 },
{ /*198 f=19800 */ 1.03155105036981975530, 0.94050000000000000266, 0.88100000000000000533 },
{ /*199 f=19900 */ 1.02871484424707237970, 0.94248611111111113559, 0.88497222222222227117 },
{ /*200 f=20000 */ 1.02592594063758446588, 0.94444444444444441977, 0.88888888888888895057 },
{ /*201 f=20100 */ 1.02318399680444938049, 0.94637499999999996625, 0.89275000000000004352 },
{ /*202 f=20200 */ 1.02048867635101236928, 0.94827777777777777501, 0.89655555555555555003 },
{ /*203 f=20300 */ 1.01783964915217928215, 0.95015277777777784607, 0.90030555555555558112 },
{ /*204 f=20400 */ 1.01523659128711263300, 0.95199999999999995737, 0.90400000000000002576 },
{ /*205 f=20500 */ 1.01267918497329545424, 0.95381944444444444198, 0.90763888888888888395 },
{ /*206 f=20600 */ 1.01016711850194762512, 0.95561111111111107785, 0.91122222222222215571 },
{ /*207 f=20700 */ 1.00770008617477335733, 0.95737500000000008704, 0.91475000000000006306 },
{ /*208 f=20800 */ 1.00527778824202207453, 0.95911111111111113647, 0.91822222222222227295 },
{ /*209 f=20900 */ 1.00289993084184558825, 0.96081944444444444819, 0.92163888888888889639 },
{ /*210 f=21000 */ 1.00056622594093491685, 0.96250000000000002220, 0.92500000000000004441 },
{ /*211 f=21100 */ 0.99827639127642064931, 0.96415277777777785850, 0.92830555555555560598 },
{ /*212 f=21200 */ 0.99603015029901709187, 0.96577777777777784607, 0.93155555555555558112 },
{ /*213 f=21300 */ 0.99382723211739809610, 0.96737499999999998490, 0.93474999999999996980 },
{ /*214 f=21400 */ 0.99166737144378658275, 0.96894444444444438602, 0.93788888888888888307 },
{ /*215 f=21500 */ 0.98955030854074343960, 0.97048611111111116045, 0.94097222222222220989 },
{ /*216 f=21600 */ 0.98747578916914158231, 0.97199999999999997513, 0.94400000000000006128 },
{ /*217 f=21700 */ 0.98544356453730619361, 0.97348611111111105210, 0.94697222222222221522 },
{ /*218 f=21800 */ 0.98345339125131536751, 0.97494444444444439135, 0.94988888888888889372 },
{ /*219 f=21900 */ 0.98150503126643717788, 0.97637499999999999289, 0.95274999999999998579 },
{ /*220 f=22000 */ 0.97959825183969906348, 0.97777777777777774570, 0.95555555555555549141 },
{ /*221 f=22100 */ 0.97773282548356776900, 0.97915277777777776080, 0.95830555555555552161 },
{ /*222 f=22200 */ 0.97590852992073506833, 0.98050000000000003819, 0.96100000000000007638 },
{ /*223 f=22300 */ 0.97412514803998839774, 0.98181944444444446685, 0.96363888888888893369 },
{ /*224 f=22400 */ 0.97238246785316351239, 0.98311111111111104677, 0.96622222222222220456 },
{ /*225 f=22500 */ 0.97068028245315662872, 0.98437500000000000000, 0.96875000000000000000 },
{ /*226 f=22600 */ 0.96901838997299449829, 0.98561111111111110450, 0.97122222222222220900 },
{ /*227 f=22700 */ 0.96739659354594365048, 0.98681944444444447129, 0.97363888888888883155 },
{ /*228 f=22800 */ 0.96581470126665192044, 0.98799999999999998934, 0.97599999999999997868 },
{ /*229 f=22900 */ 0.96427252615331016106, 0.98915277777777776969, 0.97830555555555553937 },
{ /*230 f=23000 */ 0.96276988611082259251, 0.99027777777777781232, 0.98055555555555562464 },
{ /*231 f=23100 */ 0.96130660389497890606, 0.99137500000000000622, 0.98275000000000001243 },
{ /*232 f=23200 */ 0.95988250707761402225, 0.99244444444444446241, 0.98488888888888892481 },
{ /*233 f=23300 */ 0.95849742801274939730, 0.99348611111111106986, 0.98697222222222225074 },
{ /*234 f=23400 */ 0.95715120380370388720, 0.99449999999999993960, 0.98899999999999999023 },
{ /*235 f=23500 */ 0.95584367627116928468, 0.99548611111111107164, 0.99097222222222225430 },
{ /*236 f=23600 */ 0.95457469192223531884, 0.99644444444444446596, 0.99288888888888882089 },
{ /*237 f=23700 */ 0.95334410192036134202, 0.99737500000000001155, 0.99475000000000002309 },
{ /*238 f=23800 */ 0.95215176205628448969, 0.99827777777777781942, 0.99655555555555552782 },
{ /*239 f=23900 */ 0.95099753271985565384, 0.99915277777777777857, 0.99830555555555555713 },
{ /*240 f=24000 */ 0.94988127887279583117, 1.00000000000000000000, 1.00000000000000000000 }
};
static FLOAT_T moog_q140[241][3] = {
{ /* dummy entry */ 0, 0, 0},
{ /*  1 f=  100 */ 3.80093292708608521124, 0.00748611111111113781, -0.98502777777777772439 },
{ /*  2 f=  200 */ 3.76183713046116086076, 0.01494444444444442688, -0.97011111111111114624 },
{ /*  3 f=  300 */ 3.72328683656990255813, 0.02237499999999997824, -0.95525000000000004352 },
{ /*  4 f=  400 */ 3.68527350149668952994, 0.02977777777777779189, -0.94044444444444441622 },
{ /*  5 f=  500 */ 3.64778873043315199354, 0.03715277777777775681, -0.92569444444444448639 },
{ /*  6 f=  600 */ 3.61082427486936552441, 0.04449999999999998401, -0.91100000000000003197 },
{ /*  7 f=  700 */ 3.57437202984169477560, 0.05181944444444447351, -0.89636111111111105298 },
{ /*  8 f=  800 */ 3.53842403123607684989, 0.05911111111111111427, -0.88177777777777777146 },
{ /*  9 f=  900 */ 3.50297245314555816265, 0.06637500000000001732, -0.86724999999999996536 },
{ /* 10 f= 1000 */ 3.46800960528094570634, 0.07361111111111112715, -0.85277777777777774570 },
{ /* 11 f= 1100 */ 3.43352793043341497636, 0.08081944444444444375, -0.83836111111111111249 },
{ /* 12 f= 1200 */ 3.39952000198800163844, 0.08800000000000002265, -0.82399999999999995470 },
{ /* 13 f= 1300 */ 3.36597852148687692875, 0.09515277777777780832, -0.80969444444444438336 },
{ /* 14 f= 1400 */ 3.33289631624135429533, 0.10227777777777780077, -0.79544444444444439846 },
{ /* 15 f= 1500 */ 3.30026633699161031643, 0.10937500000000000000, -0.78125000000000000000 },
{ /* 16 f= 1600 */ 3.26808165561308516800, 0.11644444444444446152, -0.76711111111111107697 },
{ /* 17 f= 1700 */ 3.23633546286860296348, 0.12348611111111112981, -0.75302777777777774038 },
{ /* 18 f= 1800 */ 3.20502106620523097291, 0.13050000000000000488, -0.73899999999999999023 },
{ /* 19 f= 1900 */ 3.17413188759493536395, 0.13748611111111108674, -0.72502777777777782653 },
{ /* 20 f= 2000 */ 3.14366146141812707882, 0.14444444444444443088, -0.71111111111111113825 },
{ /* 21 f= 2100 */ 3.11360343238917192110, 0.15137499999999998179, -0.69725000000000003642 },
{ /* 22 f= 2200 */ 3.08395155352300642804, 0.15827777777777779500, -0.68344444444444441000 },
{ /* 23 f= 2300 */ 3.05469968414197889928, 0.16515277777777781498, -0.66969444444444437003 },
{ /* 24 f= 2400 */ 3.02584178792209090858, 0.17199999999999998623, -0.65600000000000002753 },
{ /* 25 f= 2500 */ 2.99737193097779286433, 0.17881944444444447528, -0.64236111111111104943 },
{ /* 26 f= 2600 */ 2.96928427998455202186, 0.18561111111111111560, -0.62877777777777776880 },
{ /* 27 f= 2700 */ 2.94157310033838026442, 0.19237500000000001821, -0.61524999999999996358 },
{ /* 28 f= 2800 */ 2.91423275435157247415, 0.19911111111111112759, -0.60177777777777774482 },
{ /* 29 f= 2900 */ 2.88725769948388366615, 0.20581944444444444375, -0.58836111111111111249 },
{ /* 30 f= 3000 */ 2.86064248660841746741, 0.21250000000000002220, -0.57499999999999995559 },
{ /* 31 f= 3100 */ 2.83438175831150473982, 0.21915277777777780743, -0.56169444444444438513 },
{ /* 32 f= 3200 */ 2.80847024722585691947, 0.22577777777777779944, -0.54844444444444440112 },
{ /* 33 f= 3300 */ 2.78290277439631816847, 0.23237499999999999822, -0.53525000000000000355 },
{ /* 34 f= 3400 */ 2.75767424767752800108, 0.23894444444444445930, -0.52211111111111108141 },
{ /* 35 f= 3500 */ 2.73277966016284556972, 0.24548611111111112715, -0.50902777777777774570 },
{ /* 36 f= 3600 */ 2.70821408864387747073, 0.25200000000000000178, -0.49599999999999999645 },
{ /* 37 f= 3700 */ 2.68397269209999089767, 0.25848611111111113869, -0.48302777777777772261 },
{ /* 38 f= 3800 */ 2.66005071021718197954, 0.26494444444444442688, -0.47011111111111114624 },
{ /* 39 f= 3900 */ 2.63644346193570289216, 0.27137500000000003286, -0.45724999999999998979 },
{ /* 40 f= 4000 */ 2.61314634402585088679, 0.27777777777777779011, -0.44444444444444447528 },
{ /* 41 f= 4100 */ 2.59015482969134680502, 0.28415277777777780965, -0.43169444444444443620 },
{ /* 42 f= 4200 */ 2.56746446719972531980, 0.29049999999999998046, -0.41900000000000003908 },
{ /* 43 f= 4300 */ 2.54507087853920133114, 0.29681944444444441356, -0.40636111111111111738 },
{ /* 44 f= 4400 */ 2.52296975810145207575, 0.30311111111111110894, -0.39377777777777778212 },
{ /* 45 f= 4500 */ 2.50115687138979847504, 0.30937500000000001110, -0.38124999999999997780 },
{ /* 46 f= 4600 */ 2.47962805375225592286, 0.31561111111111117555, -0.36877777777777770440 },
{ /* 47 f= 4700 */ 2.45837920913895802144, 0.32181944444444443576, -0.35636111111111112848 },
{ /* 48 f= 4800 */ 2.43740630888344789184, 0.32800000000000001377, -0.34399999999999997247 },
{ /* 49 f= 4900 */ 2.41670539050735921904, 0.33415277777777774304, -0.33169444444444445841 },
{ /* 50 f= 5000 */ 2.39627255654800075391, 0.34027777777777779011, -0.31944444444444441977 },
{ /* 51 f= 5100 */ 2.37610397340839130109, 0.34637499999999998845, -0.30725000000000002309 },
{ /* 52 f= 5200 */ 2.35619587022927978737, 0.35244444444444444908, -0.29511111111111110183 },
{ /* 53 f= 5300 */ 2.33654453778271387066, 0.35848611111111111649, -0.28302777777777776702 },
{ /* 54 f= 5400 */ 2.31714632738671255652, 0.36450000000000004619, -0.27099999999999996314 },
{ /* 55 f= 5500 */ 2.29799764984062315776, 0.37048611111111107164, -0.25902777777777780122 },
{ /* 56 f= 5600 */ 2.27909497438074071241, 0.37644444444444447040, -0.24711111111111108696 },
{ /* 57 f= 5700 */ 2.26043482765578396254, 0.38237500000000002043, -0.23525000000000001465 },
{ /* 58 f= 5800 */ 2.24201379272182688140, 0.38827777777777777724, -0.22344444444444441777 },
{ /* 59 f= 5900 */ 2.22382850805629583846, 0.39415277777777779633, -0.21169444444444446285 },
{ /* 60 f= 6000 */ 2.20587566659064426844, 0.40000000000000002220, -0.19999999999999998335 },
{ /* 61 f= 6100 */ 2.18815201476133935898, 0.40581944444444439934, -0.18836111111111114580 },
{ /* 62 f= 6200 */ 2.17065435157878550143, 0.41161111111111114980, -0.17677777777777770041 },
{ /* 63 f= 6300 */ 2.15337952771382656891, 0.41737500000000005151, -0.16524999999999995248 },
{ /* 64 f= 6400 */ 2.13632444460148551713, 0.42311111111111110450, -0.15377777777777776325 },
{ /* 65 f= 6500 */ 2.11948605356157449009, 0.42881944444444441977, -0.14236111111111113270 },
{ /* 66 f= 6600 */ 2.10286135493587211798, 0.43450000000000005285, -0.13099999999999992206 },
{ /* 67 f= 6700 */ 2.08644739724150252158, 0.44015277777777778168, -0.11969444444444440889 },
{ /* 68 f= 6800 */ 2.07024127634022070410, 0.44577777777777777279, -0.10844444444444444053 },
{ /* 69 f= 6900 */ 2.05424013462327526014, 0.45137499999999997069, -0.09725000000000004474 },
{ /* 70 f= 7000 */ 2.03844116021154153628, 0.45694444444444448639, -0.08611111111111104111 },
{ /* 71 f= 7100 */ 2.02284158617062459484, 0.46248611111111115335, -0.07502777777777774881 },
{ /* 72 f= 7200 */ 2.00743868974063088828, 0.46799999999999997158, -0.06400000000000001521 },
{ /* 73 f= 7300 */ 1.99222979158032731384, 0.47348611111111110761, -0.05302777777777782642 },
{ /* 74 f= 7400 */ 1.97721225502539210694, 0.47894444444444445041, -0.04211111111111105060 },
{ /* 75 f= 7500 */ 1.96238348536049134196, 0.48437500000000000000, -0.03124999999999997918 },
{ /* 76 f= 7600 */ 1.94774092910489748931, 0.48977777777777775636, -0.02044444444444446299 },
{ /* 77 f= 7700 */ 1.93328207331139068081, 0.49515277777777783053, -0.00969444444444435803 },
{ /* 78 f= 7800 */ 1.91900444487818511163, 0.50050000000000005596, 0.00100000000000004794 },
{ /* 79 f= 7900 */ 1.90490560987360990630, 0.50581944444444448816, 0.01163888888888889826 },
{ /* 80 f= 8000 */ 1.89098317287331330050, 0.51111111111111107164, 0.02222222222222219531 },
{ /* 81 f= 8100 */ 1.87723477630973034636, 0.51637500000000002842, 0.03275000000000007766 },
{ /* 82 f= 8200 */ 1.86365809983358432511, 0.52161111111111113647, 0.04322222222222225907 },
{ /* 83 f= 8300 */ 1.85025085968717717400, 0.52681944444444439579, 0.05363888888888888873 },
{ /* 84 f= 8400 */ 1.83701080808924888110, 0.53200000000000002842, 0.06399999999999995970 },
{ /* 85 f= 8500 */ 1.82393573263117625416, 0.53715277777777781232, 0.07430555555555562464 },
{ /* 86 f= 8600 */ 1.81102345568428524381, 0.54227777777777774748, 0.08455555555555557823 },
{ /* 87 f= 8700 */ 1.79827183381807076401, 0.54737499999999994493, 0.09474999999999998701 },
{ /* 88 f= 8800 */ 1.78567875722910507363, 0.55244444444444440467, 0.10488888888888885098 },
{ /* 89 f= 8900 */ 1.77324214918043199241, 0.55748611111111112670, 0.11497222222222228116 },
{ /* 90 f= 9000 */ 1.76095996545123956167, 0.56250000000000000000, 0.12500000000000002776 },
{ /* 91 f= 9100 */ 1.74883019379661486248, 0.56748611111111113559, 0.13497222222222221566 },
{ /* 92 f= 9200 */ 1.73685085341719136487, 0.57244444444444453346, 0.14488888888888898365 },
{ /* 93 f= 9300 */ 1.72501999443848585969, 0.57737499999999997158, 0.15475000000000005418 },
{ /* 94 f= 9400 */ 1.71333569739975044577, 0.58227777777777778301, 0.16455555555555556602 },
{ /* 95 f= 9500 */ 1.70179607275215238893, 0.58715277777777774570, 0.17430555555555554692 },
{ /* 96 f= 9600 */ 1.69039926036609911009, 0.59200000000000008171, 0.18400000000000008016 },
{ /* 97 f= 9700 */ 1.67914342904754043673, 0.59681944444444445796, 0.19363888888888891593 },
{ /* 98 f= 9800 */ 1.66802677606306692937, 0.60161111111111109651, 0.20322222222222222077 },
{ /* 99 f= 9900 */ 1.65704752667364485497, 0.60637499999999999734, 0.21274999999999996692 },
{ /*100 f=10000 */ 1.64620393367681838726, 0.61111111111111116045, 0.22222222222222229315 },
{ /*101 f=10100 */ 1.63549427695721916187, 0.61581944444444447484, 0.23163888888888892192 },
{ /*102 f=10200 */ 1.62491686304522020556, 0.62050000000000005151, 0.24099999999999999201 },
{ /*103 f=10300 */ 1.61447002468358835614, 0.62515277777777777946, 0.25030555555555550340 },
{ /*104 f=10400 */ 1.60415212040197485699, 0.62977777777777776969, 0.25955555555555559488 },
{ /*105 f=10500 */ 1.59396153409910068532, 0.63437500000000002220, 0.26875000000000004441 },
{ /*106 f=10600 */ 1.58389667463248784429, 0.63894444444444442599, 0.27788888888888885198 },
{ /*107 f=10700 */ 1.57395597541559562060, 0.64348611111111120309, 0.28697222222222229515 },
{ /*108 f=10800 */ 1.56413789402222147551, 0.64800000000000002043, 0.29600000000000004086 },
{ /*109 f=10900 */ 1.55444091179802934555, 0.65248611111111110006, 0.30497222222222225563 },
{ /*110 f=11000 */ 1.54486353347907168221, 0.65694444444444444198, 0.31388888888888888395 },
{ /*111 f=11100 */ 1.53540428681717311399, 0.66137500000000004619, 0.32275000000000009237 },
{ /*112 f=11200 */ 1.52606172221204738904, 0.66577777777777780166, 0.33155555555555560332 },
{ /*113 f=11300 */ 1.51683441235002169911, 0.67015277777777781942, 0.34030555555555558334 },
{ /*114 f=11400 */ 1.50772095184924292965, 0.67449999999999998845, 0.34899999999999997691 },
{ /*115 f=11500 */ 1.49871995691124682004, 0.67881944444444441977, 0.35763888888888895057 },
{ /*116 f=11600 */ 1.48983006497877079610, 0.68311111111111111338, 0.36622222222222222676 },
{ /*117 f=11700 */ 1.48104993439969323532, 0.68737499999999995826, 0.37474999999999997202 },
{ /*118 f=11800 */ 1.47237824409698525585, 0.69161111111111106542, 0.38322222222222218635 },
{ /*119 f=11900 */ 1.46381369324456489522, 0.69581944444444443487, 0.39163888888888892525 },
{ /*120 f=12000 */ 1.45535500094894221235, 0.69999999999999995559, 0.40000000000000002220 },
{ /*121 f=12100 */ 1.44700090593654895343, 0.70415277777777773860, 0.40830555555555553271 },
{ /*122 f=12200 */ 1.43875016624664908704, 0.70827777777777778390, 0.41655555555555551228 },
{ /*123 f=12300 */ 1.43060155892972384883, 0.71237499999999998046, 0.42474999999999996092 },
{ /*124 f=12400 */ 1.42255387975123337441, 0.71644444444444443931, 0.43288888888888898965 },
{ /*125 f=12500 */ 1.41460594290065411194, 0.72048611111111116045, 0.44097222222222232091 },
{ /*126 f=12600 */ 1.40675658070569920000, 0.72450000000000003286, 0.44900000000000006573 },
{ /*127 f=12700 */ 1.39900464335161833773, 0.72848611111111116756, 0.45697222222222227961 },
{ /*128 f=12800 */ 1.39134899860549321460, 0.73244444444444445352, 0.46488888888888890705 },
{ /*129 f=12900 */ 1.38378853154543235426, 0.73637500000000000178, 0.47275000000000000355 },
{ /*130 f=13000 */ 1.37632214429457655491, 0.74027777777777781232, 0.48055555555555551361 },
{ /*131 f=13100 */ 1.36894875575982877258, 0.74415277777777777413, 0.48830555555555549274 },
{ /*132 f=13200 */ 1.36166730137522007382, 0.74799999999999999822, 0.49600000000000010747 },
{ /*133 f=13300 */ 1.35447673284983016728, 0.75181944444444448461, 0.50363888888888896922 },
{ /*134 f=13400 */ 1.34737601792017858138, 0.75561111111111112226, 0.51122222222222224453 },
{ /*135 f=13500 */ 1.34036414010700566379, 0.75937500000000002220, 0.51875000000000004441 },
{ /*136 f=13600 */ 1.33344009847636413291, 0.76311111111111107341, 0.52622222222222225785 },
{ /*137 f=13700 */ 1.32660290740494501982, 0.76681944444444449793, 0.53363888888888888484 },
{ /*138 f=13800 */ 1.31985159634955984131, 0.77049999999999996270, 0.54099999999999992539 },
{ /*139 f=13900 */ 1.31318520962070439673, 0.77415277777777791179, 0.54830555555555571257 },
{ /*140 f=14000 */ 1.30660280616013446675, 0.77777777777777790114, 0.55555555555555569125 },
{ /*141 f=14100 */ 1.30010345932237614264, 0.78137500000000004174, 0.56275000000000008349 },
{ /*142 f=14200 */ 1.29368625666010528263, 0.78494444444444444464, 0.56988888888888888928 },
{ /*143 f=14300 */ 1.28735029971332615162, 0.78848611111111110983, 0.57697222222222221966 },
{ /*144 f=14400 */ 1.28109470380228018804, 0.79200000000000003730, 0.58399999999999996358 },
{ /*145 f=14500 */ 1.27491859782401872891, 0.79548611111111111605, 0.59097222222222223209 },
{ /*146 f=14600 */ 1.26882112405257929666, 0.79894444444444445708, 0.59788888888888880313 },
{ /*147 f=14700 */ 1.26280143794269372748, 0.80237500000000006040, 0.60475000000000012079 },
{ /*148 f=14800 */ 1.25685870793697551662, 0.80577777777777781498, 0.61155555555555562997 },
{ /*149 f=14900 */ 1.25099211527651599241, 0.80915277777777783186, 0.61830555555555555269 },
{ /*150 f=15000 */ 1.24520085381483691656, 0.81250000000000000000, 0.62500000000000000000 },
{ /*151 f=15100 */ 1.23948412983513645003, 0.81581944444444443043, 0.63163888888888886086 },
{ /*152 f=15200 */ 1.23384116187077341742, 0.81911111111111112315, 0.63822222222222224630 },
{ /*153 f=15300 */ 1.22827118052892969580, 0.82237499999999996714, 0.64474999999999993427 },
{ /*154 f=15400 */ 1.22277342831740165607, 0.82561111111111118444, 0.65122222222222236887 },
{ /*155 f=15500 */ 1.21734715947446203721, 0.82881944444444455300, 0.65763888888888899498 },
{ /*156 f=15600 */ 1.21199163980173740818, 0.83200000000000007283, 0.66400000000000003464 },
{ /*157 f=15700 */ 1.20670614650005592061, 0.83515277777777785495, 0.67030555555555559888 },
{ /*158 f=15800 */ 1.20148996800820762054, 0.83827777777777778834, 0.67655555555555557667 },
{ /*159 f=15900 */ 1.19634240384457180006, 0.84137499999999998401, 0.68274999999999996803 },
{ /*160 f=16000 */ 1.19126276445155898642, 0.84444444444444444198, 0.68888888888888888395 },
{ /*161 f=16100 */ 1.18625037104282204936, 0.84748611111111116223, 0.69497222222222221344 },
{ /*162 f=16200 */ 1.18130455545318957533, 0.85050000000000003375, 0.70100000000000006750 },
{ /*163 f=16300 */ 1.17642465999127154852, 0.85348611111111116756, 0.70697222222222233512 },
{ /*164 f=16400 */ 1.17161003729469714862, 0.85644444444444445264, 0.71288888888888890527 },
{ /*165 f=16500 */ 1.16686005018793714783, 0.85937500000000000000, 0.71875000000000000000 },
{ /*166 f=16600 */ 1.16217407154266849645, 0.86227777777777769863, 0.72455555555555550828 },
{ /*167 f=16700 */ 1.15755148414063757656, 0.86515277777777777057, 0.73030555555555554115 },
{ /*168 f=16800 */ 1.15299168053898126729, 0.86799999999999999378, 0.73599999999999998757 },
{ /*169 f=16900 */ 1.14849406293796607592, 0.87081944444444447928, 0.74163888888888895856 },
{ /*170 f=17000 */ 1.14405804305110292418, 0.87361111111111111605, 0.74722222222222234311 },
{ /*171 f=17100 */ 1.13968304197759673357, 0.87637500000000001510, 0.75275000000000003020 },
{ /*172 f=17200 */ 1.13536849007709972348, 0.87911111111111117644, 0.75822222222222224186 },
{ /*173 f=17300 */ 1.13111382684672157062, 0.88181944444444448905, 0.76363888888888886708 },
{ /*174 f=17400 */ 1.12691850080026489955, 0.88450000000000006395, 0.76900000000000001688 },
{ /*175 f=17500 */ 1.12278196934964946685, 0.88715277777777779011, 0.77430555555555558023 },
{ /*176 f=17600 */ 1.11870369868848595907, 0.88977777777777777857, 0.77955555555555555713 },
{ /*177 f=17700 */ 1.11468316367777076081, 0.89237500000000002931, 0.78475000000000005862 },
{ /*178 f=17800 */ 1.11071984773365950439, 0.89494444444444454234, 0.78988888888888897366 },
{ /*179 f=17900 */ 1.10681324271729519815, 0.89748611111111120664, 0.79497222222222230226 },
{ /*180 f=18000 */ 1.10296284882664807903, 0.90000000000000002220, 0.80000000000000004441 },
{ /*181 f=18100 */ 1.09916817449034498466, 0.90248611111111110006, 0.80497222222222220012 },
{ /*182 f=18200 */ 1.09542873626344894333, 0.90494444444444444020, 0.80988888888888888040 },
{ /*183 f=18300 */ 1.09174405872516344651, 0.90737500000000004263, 0.81474999999999997424 },
{ /*184 f=18400 */ 1.08811367437842765327, 0.90977777777777779633, 0.81955555555555559266 },
{ /*185 f=18500 */ 1.08453712355137366075, 0.91215277777777781232, 0.82430555555555562464 },
{ /*186 f=18600 */ 1.08101395430061986147, 0.91450000000000009059, 0.82900000000000007017 },
{ /*187 f=18700 */ 1.07754372231636885715, 0.91681944444444440911, 0.83363888888888892925 },
{ /*188 f=18800 */ 1.07412599082928017502, 0.91911111111111110095, 0.83822222222222220189 },
{ /*189 f=18900 */ 1.07076033051909669247, 0.92137500000000005507, 0.84274999999999999911 },
{ /*190 f=19000 */ 1.06744631942499412780, 0.92361111111111116045, 0.84722222222222220989 },
{ /*191 f=19100 */ 1.06418354285762584155, 0.92581944444444441711, 0.85163888888888883422 },
{ /*192 f=19200 */ 1.06097159331284052186, 0.92800000000000004707, 0.85600000000000009415 },
{ /*193 f=19300 */ 1.05781007038704810697, 0.93015277777777782831, 0.86030555555555554559 },
{ /*194 f=19400 */ 1.05469858069420507896, 0.93227777777777776080, 0.86455555555555563263 },
{ /*195 f=19500 */ 1.05163673778440003304, 0.93437499999999995559, 0.86875000000000002220 },
{ /*196 f=19600 */ 1.04862416206401309893, 0.93644444444444441267, 0.87288888888888893636 },
{ /*197 f=19700 */ 1.04566048071742656589, 0.93848611111111113203, 0.87697222222222215304 },
{ /*198 f=19800 */ 1.04274532763026495097, 0.94050000000000000266, 0.88100000000000000533 },
{ /*199 f=19900 */ 1.03987834331414119582, 0.94248611111111113559, 0.88497222222222227117 },
{ /*200 f=20000 */ 1.03705917483288967418, 0.94444444444444441977, 0.88888888888888895057 },
{ /*201 f=20100 */ 1.03428747573026025286, 0.94637499999999996625, 0.89275000000000004352 },
{ /*202 f=20200 */ 1.03156290595905986152, 0.94827777777777777501, 0.89655555555555555003 },
{ /*203 f=20300 */ 1.02888513181171314947, 0.95015277777777784607, 0.90030555555555558112 },
{ /*204 f=20400 */ 1.02625382585222979515, 0.95199999999999995737, 0.90400000000000002576 },
{ /*205 f=20500 */ 1.02366866684955226674, 0.95381944444444444198, 0.90763888888888888395 },
{ /*206 f=20600 */ 1.02112933971227137775, 0.95561111111111107785, 0.91122222222222215571 },
{ /*207 f=20700 */ 1.01863553542468765478, 0.95737500000000008704, 0.91475000000000006306 },
{ /*208 f=20800 */ 1.01618695098419942191, 0.95911111111111113647, 0.91822222222222227295 },
{ /*209 f=20900 */ 1.01378328934000228045, 0.96081944444444444819, 0.92163888888888889639 },
{ /*210 f=21000 */ 1.01142425933308222064, 0.96250000000000002220, 0.92500000000000004441 },
{ /*211 f=21100 */ 1.00910957563748415744, 0.96415277777777785850, 0.92830555555555560598 },
{ /*212 f=21200 */ 1.00683895870284034757, 0.96577777777777784607, 0.93155555555555558112 },
{ /*213 f=21300 */ 1.00461213469814247823, 0.96737499999999998490, 0.93474999999999996980 },
{ /*214 f=21400 */ 1.00242883545673944212, 0.96894444444444438602, 0.93788888888888888307 },
{ /*215 f=21500 */ 1.00028879842255102872, 0.97048611111111116045, 0.94097222222222220989 },
{ /*216 f=21600 */ 0.99819176659747466118, 0.97199999999999997513, 0.94400000000000006128 },
{ /*217 f=21700 */ 0.99613748848997651919, 0.97348611111111105210, 0.94697222222222221522 },
{ /*218 f=21800 */ 0.99412571806485061643, 0.97494444444444439135, 0.94988888888888889372 },
{ /*219 f=21900 */ 0.99215621469413017852, 0.97637499999999999289, 0.95274999999999998579 },
{ /*220 f=22000 */ 0.99022874310914188456, 0.97777777777777774570, 0.95555555555555549141 },
{ /*221 f=22100 */ 0.98834307335368309921, 0.97915277777777776080, 0.95830555555555552161 },
{ /*222 f=22200 */ 0.98649898073831654433, 0.98050000000000003819, 0.96100000000000007638 },
{ /*223 f=22300 */ 0.98469624579576353618, 0.98181944444444446685, 0.96363888888888893369 },
{ /*224 f=22400 */ 0.98293465423738746178, 0.98311111111111104677, 0.96622222222222220456 },
{ /*225 f=22500 */ 0.98121399691075161797, 0.98437500000000000000, 0.96875000000000000000 },
{ /*226 f=22600 */ 0.97953406975824508507, 0.98561111111111110450, 0.97122222222222220900 },
{ /*227 f=22700 */ 0.97789467377675831639, 0.98681944444444447129, 0.97363888888888883155 },
{ /*228 f=22800 */ 0.97629561497840366968, 0.98799999999999998934, 0.97599999999999997868 },
{ /*229 f=22900 */ 0.97473670435226622555, 0.98915277777777776969, 0.97830555555555553937 },
{ /*230 f=23000 */ 0.97321775782717445669, 0.99027777777777781232, 0.98055555555555562464 },
{ /*231 f=23100 */ 0.97173859623548353159, 0.99137500000000000622, 0.98275000000000001243 },
{ /*232 f=23200 */ 0.97029904527785704182, 0.99244444444444446241, 0.98488888888888892481 },
{ /*233 f=23300 */ 0.96889893548904115761, 0.99348611111111106986, 0.98697222222222225074 },
{ /*234 f=23400 */ 0.96753810220461800018, 0.99449999999999993960, 0.98899999999999999023 },
{ /*235 f=23500 */ 0.96621638552873501116, 0.99548611111111107164, 0.99097222222222225430 },
{ /*236 f=23600 */ 0.96493363030279399872, 0.99644444444444446596, 0.99288888888888882089 },
{ /*237 f=23700 */ 0.96368968607509664093, 0.99737500000000001155, 0.99475000000000002309 },
{ /*238 f=23800 */ 0.96248440707143745332, 0.99827777777777781942, 0.99655555555555552782 },
{ /*239 f=23900 */ 0.96131765216663322970, 0.99915277777777777857, 0.99830555555555555713 },
{ /*240 f=24000 */ 0.96018928485698462616, 1.00000000000000000000, 1.00000000000000000000 }
};
static FLOAT_T moog_q150[241][3] = {
{ /* dummy entry */ 0, 0, 0},
{ /*  1 f=  100 */ 3.83334508985818311899, 0.00748611111111113781, -0.98502777777777772439 },
{ /*  2 f=  200 */ 3.79391590683886059665, 0.01494444444444442688, -0.97011111111111114624 },
{ /*  3 f=  300 */ 3.75503687828574772567, 0.02237499999999997824, -0.95525000000000004352 },
{ /*  4 f=  400 */ 3.71669938742564287537, 0.02977777777777779189, -0.94044444444444441622 },
{ /*  5 f=  500 */ 3.67889496786409342377, 0.03715277777777775681, -0.92569444444444448639 },
{ /*  6 f=  600 */ 3.64161530075264261441, 0.04449999999999998401, -0.91100000000000003197 },
{ /*  7 f=  700 */ 3.60485221201320182871, 0.05181944444444447351, -0.89636111111111105298 },
{ /*  8 f=  800 */ 3.56859766961833857479, 0.05911111111111111427, -0.88177777777777777146 },
{ /*  9 f=  900 */ 3.53284378092628070789, 0.06637500000000001732, -0.86724999999999996536 },
{ /* 10 f= 1000 */ 3.49758279006948624712, 0.07361111111111112715, -0.85277777777777774570 },
{ /* 11 f= 1100 */ 3.46280707539561483088, 0.08081944444444444375, -0.83836111111111111249 },
{ /* 12 f= 1200 */ 3.42850914695981545677, 0.08800000000000002265, -0.82399999999999995470 },
{ /* 13 f= 1300 */ 3.39468164406722117121, 0.09515277777777780832, -0.80969444444444438336 },
{ /* 14 f= 1400 */ 3.36131733286459599697, 0.10227777777777780077, -0.79544444444444439846 },
{ /* 15 f= 1500 */ 3.32840910398009626192, 0.10937500000000000000, -0.78125000000000000000 },
{ /* 16 f= 1600 */ 3.29594997021011382188, 0.11644444444444446152, -0.76711111111111107697 },
{ /* 17 f= 1700 */ 3.26393306425222640144, 0.12348611111111112981, -0.75302777777777774038 },
{ /* 18 f= 1800 */ 3.23235163648327183950, 0.13050000000000000488, -0.73899999999999999023 },
{ /* 19 f= 1900 */ 3.20119905278159011530, 0.13748611111111108674, -0.72502777777777782653 },
{ /* 20 f= 2000 */ 3.17046879239251788718, 0.14444444444444443088, -0.71111111111111113825 },
{ /* 21 f= 2100 */ 3.14015444583621228247, 0.15137499999999998179, -0.69725000000000003642 },
{ /* 22 f= 2200 */ 3.11024971285692597434, 0.15827777777777779500, -0.68344444444444441000 },
{ /* 23 f= 2300 */ 3.08074840041285247239, 0.16515277777777781498, -0.66969444444444437003 },
{ /* 24 f= 2400 */ 3.05164442070570407495, 0.17199999999999998623, -0.65600000000000002753 },
{ /* 25 f= 2500 */ 3.02293178924918048978, 0.17881944444444447528, -0.64236111111111104943 },
{ /* 26 f= 2600 */ 2.99460462297552165722, 0.18561111111111111560, -0.62877777777777776880 },
{ /* 27 f= 2700 */ 2.96665713837934763575, 0.19237500000000001821, -0.61524999999999996358 },
{ /* 28 f= 2800 */ 2.93908364969800439681, 0.19911111111111112759, -0.60177777777777774482 },
{ /* 29 f= 2900 */ 2.91187856712766190981, 0.20581944444444444375, -0.58836111111111111249 },
{ /* 30 f= 3000 */ 2.88503639507441445033, 0.21250000000000002220, -0.57499999999999995559 },
{ /* 31 f= 3100 */ 2.85855173043965971047, 0.21915277777777780743, -0.56169444444444438513 },
{ /* 32 f= 3200 */ 2.83241926093904172745, 0.22577777777777779944, -0.54844444444444440112 },
{ /* 33 f= 3300 */ 2.80663376345426129888, 0.23237499999999999822, -0.53525000000000000355 },
{ /* 34 f= 3400 */ 2.78119010241708286557, 0.23894444444444445930, -0.52211111111111108141 },
{ /* 35 f= 3500 */ 2.75608322822485307668, 0.24548611111111112715, -0.50902777777777774570 },
{ /* 36 f= 3600 */ 2.73130817568689954200, 0.25200000000000000178, -0.49599999999999999645 },
{ /* 37 f= 3700 */ 2.70686006250115784866, 0.25848611111111113869, -0.48302777777777772261 },
{ /* 38 f= 3800 */ 2.68273408776041355495, 0.26494444444444442688, -0.47011111111111114624 },
{ /* 39 f= 3900 */ 2.65892553048754232137, 0.27137500000000003286, -0.45724999999999998979 },
{ /* 40 f= 4000 */ 2.63542974819915487572, 0.27777777777777779011, -0.44444444444444447528 },
{ /* 41 f= 4100 */ 2.61224217549706505537, 0.28415277777777780965, -0.43169444444444443620 },
{ /* 42 f= 4200 */ 2.58935832268700227843, 0.29049999999999998046, -0.41900000000000003908 },
{ /* 43 f= 4300 */ 2.56677377442402265828, 0.29681944444444441356, -0.40636111111111111738 },
{ /* 44 f= 4400 */ 2.54448418838406098530, 0.30311111111111110894, -0.39377777777777778212 },
{ /* 45 f= 4500 */ 2.52248529396109288925, 0.30937500000000001110, -0.38124999999999997780 },
{ /* 46 f= 4600 */ 2.50077289098938448930, 0.31561111111111117555, -0.36877777777777770440 },
{ /* 47 f= 4700 */ 2.47934284849032104958, 0.32181944444444443576, -0.35636111111111112848 },
{ /* 48 f= 4800 */ 2.45819110344330171714, 0.32800000000000001377, -0.34399999999999997247 },
{ /* 49 f= 4900 */ 2.43731365958023182827, 0.33415277777777774304, -0.33169444444444445841 },
{ /* 50 f= 5000 */ 2.41670658620310652154, 0.34027777777777779011, -0.31944444444444441977 },
{ /* 51 f= 5100 */ 2.39636601702424201221, 0.34637499999999998845, -0.30725000000000002309 },
{ /* 52 f= 5200 */ 2.37628814902867535608, 0.35244444444444444908, -0.29511111111111110183 },
{ /* 53 f= 5300 */ 2.35646924135829882729, 0.35848611111111111649, -0.28302777777777776702 },
{ /* 54 f= 5400 */ 2.33690561421727593938, 0.36450000000000004619, -0.27099999999999996314 },
{ /* 55 f= 5500 */ 2.31759364779832299774, 0.37048611111111107164, -0.25902777777777780122 },
{ /* 56 f= 5600 */ 2.29852978122941875583, 0.37644444444444447040, -0.24711111111111108696 },
{ /* 57 f= 5700 */ 2.27971051154054693555, 0.38237500000000002043, -0.23525000000000001465 },
{ /* 58 f= 5800 */ 2.26113239265005550038, 0.38827777777777777724, -0.22344444444444441777 },
{ /* 59 f= 5900 */ 2.24279203437024499124, 0.39415277777777779633, -0.21169444444444446285 },
{ /* 60 f= 6000 */ 2.22468610143179734706, 0.40000000000000002220, -0.19999999999999998335 },
{ /* 61 f= 6100 */ 2.20681131252666729026, 0.40581944444444439934, -0.18836111111111114580 },
{ /* 62 f= 6200 */ 2.18916443936906679468, 0.41161111111111114980, -0.17677777777777770041 },
{ /* 63 f= 6300 */ 2.17174230577417803900, 0.41737500000000005151, -0.16524999999999995248 },
{ /* 64 f= 6400 */ 2.15454178675424978806, 0.42311111111111110450, -0.15377777777777776325 },
{ /* 65 f= 6500 */ 2.13755980763170905234, 0.42881944444444441977, -0.14236111111111113270 },
{ /* 66 f= 6600 */ 2.12079334316897893942, 0.43450000000000005285, -0.13099999999999992206 },
{ /* 67 f= 6700 */ 2.10423941671464209691, 0.44015277777777778168, -0.11969444444444440889 },
{ /* 68 f= 6800 */ 2.08789509936563710824, 0.44577777777777777279, -0.10844444444444444053 },
{ /* 69 f= 6900 */ 2.07175750914517475820, 0.45137499999999997069, -0.09725000000000004474 },
{ /* 70 f= 7000 */ 2.05582381019604776284, 0.45694444444444448639, -0.08611111111111104111 },
{ /* 71 f= 7100 */ 2.04009121198904042060, 0.46248611111111115335, -0.07502777777777774881 },
{ /* 72 f= 7200 */ 2.02455696854613487190, 0.46799999999999997158, -0.06400000000000001521 },
{ /* 73 f= 7300 */ 2.00921837767822220044, 0.47348611111111110761, -0.05302777777777782642 },
{ /* 74 f= 7400 */ 1.99407278023702749792, 0.47894444444444445041, -0.04211111111111105060 },
{ /* 75 f= 7500 */ 1.97911755938098266050, 0.48437500000000000000, -0.03124999999999997918 },
{ /* 76 f= 7600 */ 1.96435013985474959952, 0.48977777777777775636, -0.02044444444444446299 },
{ /* 77 f= 7700 */ 1.94976798728214495426, 0.49515277777777783053, -0.00969444444444435803 },
{ /* 78 f= 7800 */ 1.93536860747219718881, 0.50050000000000005596, 0.00100000000000004794 },
{ /* 79 f= 7900 */ 1.92114954573807139582, 0.50581944444444448816, 0.01163888888888889826 },
{ /* 80 f= 8000 */ 1.90710838622861866831, 0.51111111111111107164, 0.02222222222222219531 },
{ /* 81 f= 8100 */ 1.89324275127229846305, 0.51637500000000002842, 0.03275000000000007766 },
{ /* 82 f= 8200 */ 1.87955030073323370310, 0.52161111111111113647, 0.04322222222222225907 },
{ /* 83 f= 8300 */ 1.86602873137915947765, 0.52681944444444439579, 0.05363888888888888873 },
{ /* 84 f= 8400 */ 1.85267577626103374655, 0.53200000000000002842, 0.06399999999999995970 },
{ /* 85 f= 8500 */ 1.83948920410408889303, 0.53715277777777781232, 0.07430555555555562464 },
{ /* 86 f= 8600 */ 1.82646681871009031184, 0.54227777777777774748, 0.08455555555555557823 },
{ /* 87 f= 8700 */ 1.81360645837059464291, 0.54737499999999994493, 0.09474999999999998701 },
{ /* 88 f= 8800 */ 1.80090599529098760456, 0.55244444444444440467, 0.10488888888888885098 },
{ /* 89 f= 8900 */ 1.78836333502509847726, 0.55748611111111112670, 0.11497222222222228116 },
{ /* 90 f= 9000 */ 1.77597641592018007373, 0.56250000000000000000, 0.12500000000000002776 },
{ /* 91 f= 9100 */ 1.76374320857205613144, 0.56748611111111113559, 0.13497222222222221566 },
{ /* 92 f= 9200 */ 1.75166171529024561337, 0.57244444444444453346, 0.14488888888888898365 },
{ /* 93 f= 9300 */ 1.73972996957286096809, 0.57737499999999997158, 0.15475000000000005418 },
{ /* 94 f= 9400 */ 1.72794603559110071522, 0.58227777777777778301, 0.16455555555555556602 },
{ /* 95 f= 9500 */ 1.71630800768315006088, 0.58715277777777774570, 0.17430555555555554692 },
{ /* 96 f= 9600 */ 1.70481400985730457975, 0.59200000000000008171, 0.18400000000000008016 },
{ /* 97 f= 9700 */ 1.69346219530414776600, 0.59681944444444445796, 0.19363888888888891593 },
{ /* 98 f= 9800 */ 1.68225074591759971021, 0.60161111111111109651, 0.20322222222222222077 },
{ /* 99 f= 9900 */ 1.67117787182467680829, 0.60637499999999999734, 0.21274999999999996692 },
{ /*100 f=10000 */ 1.66024181092378841917, 0.61111111111111116045, 0.22222222222222229315 },
{ /*101 f=10100 */ 1.64944082843141504036, 0.61581944444444447484, 0.23163888888888892192 },
{ /*102 f=10200 */ 1.63877321643699791487, 0.62050000000000005151, 0.24099999999999999201 },
{ /*103 f=10300 */ 1.62823729346589596290, 0.62515277777777777946, 0.25030555555555550340 },
{ /*104 f=10400 */ 1.61783140405024883357, 0.62977777777777776969, 0.25955555555555559488 },
{ /*105 f=10500 */ 1.60755391830759819527, 0.63437500000000002220, 0.26875000000000004441 },
{ /*106 f=10600 */ 1.59740323152712115906, 0.63894444444444442599, 0.27788888888888885198 },
{ /*107 f=10700 */ 1.58737776376333061812, 0.64348611111111120309, 0.28697222222222229515 },
{ /*108 f=10800 */ 1.57747595943710394728, 0.64800000000000002043, 0.29600000000000004086 },
{ /*109 f=10900 */ 1.56769628694389684398, 0.65248611111111110006, 0.30497222222222225563 },
{ /*110 f=11000 */ 1.55803723826901352467, 0.65694444444444444198, 0.31388888888888888395 },
{ /*111 f=11100 */ 1.54849732860979605320, 0.66137500000000004619, 0.32275000000000009237 },
{ /*112 f=11200 */ 1.53907509600460334909, 0.66577777777777780166, 0.33155555555555560332 },
{ /*113 f=11300 */ 1.52976910096845486464, 0.67015277777777781942, 0.34030555555555558334 },
{ /*114 f=11400 */ 1.52057792613521236547, 0.67449999999999998845, 0.34899999999999997691 },
{ /*115 f=11500 */ 1.51150017590617657959, 0.67881944444444441977, 0.35763888888888895057 },
{ /*116 f=11600 */ 1.50253447610498258591, 0.68311111111111111338, 0.36622222222222222676 },
{ /*117 f=11700 */ 1.49367947363867403787, 0.68737499999999995826, 0.37474999999999997202 },
{ /*118 f=11800 */ 1.48493383616483942689, 0.69161111111111106542, 0.38322222222222218635 },
{ /*119 f=11900 */ 1.47629625176470224979, 0.69581944444444443487, 0.39163888888888892525 },
{ /*120 f=12000 */ 1.46776542862205205964, 0.69999999999999995559, 0.40000000000000002220 },
{ /*121 f=12100 */ 1.45934009470790782004, 0.70415277777777773860, 0.40830555555555553271 },
{ /*122 f=12200 */ 1.45101899747080853587, 0.70827777777777778390, 0.41655555555555551228 },
{ /*123 f=12300 */ 1.44280090353262790970, 0.71237499999999998046, 0.42474999999999996092 },
{ /*124 f=12400 */ 1.43468459838980821885, 0.71644444444444443931, 0.43288888888888898965 },
{ /*125 f=12500 */ 1.42666888611991904412, 0.72048611111111116045, 0.44097222222222232091 },
{ /*126 f=12600 */ 1.41875258909343693325, 0.72450000000000003286, 0.44900000000000006573 },
{ /*127 f=12700 */ 1.41093454769065540511, 0.72848611111111116756, 0.45697222222222227961 },
{ /*128 f=12800 */ 1.40321362002362715060, 0.73244444444444445352, 0.46488888888888890705 },
{ /*129 f=12900 */ 1.39558868166305027891, 0.73637500000000000178, 0.47275000000000000355 },
{ /*130 f=13000 */ 1.38805862537000490597, 0.74027777777777781232, 0.48055555555555551361 },
{ /*131 f=13100 */ 1.38062236083245615248, 0.74415277777777777413, 0.48830555555555549274 },
{ /*132 f=13200 */ 1.37327881440643051469, 0.74799999999999999822, 0.49600000000000010747 },
{ /*133 f=13300 */ 1.36602692886178789244, 0.75181944444444448461, 0.50363888888888896922 },
{ /*134 f=13400 */ 1.35886566313250023441, 0.75561111111111112226, 0.51122222222222224453 },
{ /*135 f=13500 */ 1.35179399207135930716, 0.75937500000000002220, 0.51875000000000004441 },
{ /*136 f=13600 */ 1.34481090620903098731, 0.76311111111111107341, 0.52622222222222225785 },
{ /*137 f=13700 */ 1.33791541151737902737, 0.76681944444444449793, 0.53363888888888888484 },
{ /*138 f=13800 */ 1.33110652917698324416, 0.77049999999999996270, 0.54099999999999992539 },
{ /*139 f=13900 */ 1.32438329534877019533, 0.77415277777777791179, 0.54830555555555571257 },
{ /*140 f=14000 */ 1.31774476094969439366, 0.77777777777777790114, 0.55555555555555569125 },
{ /*141 f=14100 */ 1.31118999143238346150, 0.78137500000000004174, 0.56275000000000008349 },
{ /*142 f=14200 */ 1.30471806656868971608, 0.78494444444444444464, 0.56988888888888888928 },
{ /*143 f=14300 */ 1.29832808023706869349, 0.78848611111111110983, 0.57697222222222221966 },
{ /*144 f=14400 */ 1.29201914021372310515, 0.79200000000000003730, 0.58399999999999996358 },
{ /*145 f=14500 */ 1.28579036796744161641, 0.79548611111111111605, 0.59097222222222223209 },
{ /*146 f=14600 */ 1.27964089845806894274, 0.79894444444444445708, 0.59788888888888880313 },
{ /*147 f=14700 */ 1.27356987993854242625, 0.80237500000000006040, 0.60475000000000012079 },
{ /*148 f=14800 */ 1.26757647376043425247, 0.80577777777777781498, 0.61155555555555562997 },
{ /*149 f=14900 */ 1.26165985418293202791, 0.80915277777777783186, 0.61830555555555555269 },
{ /*150 f=15000 */ 1.25581920818520553773, 0.81250000000000000000, 0.62500000000000000000 },
{ /*151 f=15100 */ 1.25005373528209395850, 0.81581944444444443043, 0.63163888888888886086 },
{ /*152 f=15200 */ 1.24436264734305956914, 0.81911111111111112315, 0.63822222222222224630 },
{ /*153 f=15300 */ 1.23874516841434623160, 0.82237499999999996714, 0.64474999999999993427 },
{ /*154 f=15400 */ 1.23320053454429423567, 0.82561111111111118444, 0.65122222222222236887 },
{ /*155 f=15500 */ 1.22772799361175000143, 0.82881944444444455300, 0.65763888888888899498 },
{ /*156 f=15600 */ 1.22232680515752045736, 0.83200000000000007283, 0.66400000000000003464 },
{ /*157 f=15700 */ 1.21699624021881969149, 0.83515277777777785495, 0.67030555555555559888 },
{ /*158 f=15800 */ 1.21173558116665391893, 0.83827777777777778834, 0.67655555555555557667 },
{ /*159 f=15900 */ 1.20654412154609946839, 0.84137499999999998401, 0.68274999999999996803 },
{ /*160 f=16000 */ 1.20142116591941761072, 0.84444444444444444198, 0.68888888888888888395 },
{ /*161 f=16100 */ 1.19636602971196293055, 0.84748611111111116223, 0.69497222222222221344 },
{ /*162 f=16200 */ 1.19137803906083727945, 0.85050000000000003375, 0.70100000000000006750 },
{ /*163 f=16300 */ 1.18645653066623735228, 0.85348611111111116756, 0.70697222222222233512 },
{ /*164 f=16400 */ 1.18160085164546013736, 0.85644444444444445264, 0.71288888888888890527 },
{ /*165 f=16500 */ 1.17681035938951095154, 0.85937500000000000000, 0.71875000000000000000 },
{ /*166 f=16600 */ 1.17208442142227853289, 0.86227777777777769863, 0.72455555555555550828 },
{ /*167 f=16700 */ 1.16742241526222745307, 0.86515277777777777057, 0.73030555555555554115 },
{ /*168 f=16800 */ 1.16282372828657298847, 0.86799999999999999378, 0.73599999999999998757 },
{ /*169 f=16900 */ 1.15828775759789048827, 0.87081944444444447928, 0.74163888888888895856 },
{ /*170 f=17000 */ 1.15381390989312282436, 0.87361111111111111605, 0.74722222222222234311 },
{ /*171 f=17100 */ 1.14940160133494306827, 0.87637500000000001510, 0.75275000000000003020 },
{ /*172 f=17200 */ 1.14505025742543931067, 0.87911111111111117644, 0.75822222222222224186 },
{ /*173 f=17300 */ 1.14075931288207566006, 0.88181944444444448905, 0.76363888888888886708 },
{ /*174 f=17400 */ 1.13652821151589944471, 0.88450000000000006395, 0.76900000000000001688 },
{ /*175 f=17500 */ 1.13235640611195154115, 0.88715277777777779011, 0.77430555555555558023 },
{ /*176 f=17600 */ 1.12824335831185029733, 0.88977777777777777857, 0.77955555555555555713 },
{ /*177 f=17700 */ 1.12418853849850952642, 0.89237500000000002931, 0.78475000000000005862 },
{ /*178 f=17800 */ 1.12019142568295593243, 0.89494444444444454234, 0.78988888888888897366 },
{ /*179 f=17900 */ 1.11625150739321754578, 0.89748611111111120664, 0.79497222222222230226 },
{ /*180 f=18000 */ 1.11236827956524120253, 0.90000000000000002220, 0.80000000000000004441 },
{ /*181 f=18100 */ 1.10854124643581686271, 0.90248611111111110006, 0.80497222222222220012 },
{ /*182 f=18200 */ 1.10476992043746813366, 0.90494444444444444020, 0.80988888888888888040 },
{ /*183 f=18300 */ 1.10105382209528412929, 0.90737500000000004263, 0.81474999999999997424 },
{ /*184 f=18400 */ 1.09739247992565847056, 0.90977777777777779633, 0.81955555555555559266 },
{ /*185 f=18500 */ 1.09378543033690767139, 0.91215277777777781232, 0.82430555555555562464 },
{ /*186 f=18600 */ 1.09023221753173715776, 0.91450000000000009059, 0.82900000000000007017 },
{ /*187 f=18700 */ 1.08673239341153227144, 0.91681944444444440911, 0.83363888888888892925 },
{ /*188 f=18800 */ 1.08328551748243517849, 0.91911111111111110095, 0.83822222222222220189 },
{ /*189 f=18900 */ 1.07989115676319391568, 0.92137500000000005507, 0.84274999999999999911 },
{ /*190 f=19000 */ 1.07654888569474516125, 0.92361111111111116045, 0.84722222222222220989 },
{ /*191 f=19100 */ 1.07325828605151141204, 0.92581944444444441711, 0.85163888888888883422 },
{ /*192 f=19200 */ 1.07001894685438037058, 0.92800000000000004707, 0.85600000000000009415 },
{ /*193 f=19300 */ 1.06683046428535188710, 0.93015277777777782831, 0.86030555555555554559 },
{ /*194 f=19400 */ 1.06369244160381315467, 0.93227777777777776080, 0.86455555555555563263 },
{ /*195 f=19500 */ 1.06060448906443061112, 0.93437499999999995559, 0.86875000000000002220 },
{ /*196 f=19600 */ 1.05756622383662901576, 0.93644444444444441267, 0.87288888888888893636 },
{ /*197 f=19700 */ 1.05457726992563438628, 0.93848611111111113203, 0.87697222222222215304 },
{ /*198 f=19800 */ 1.05163725809505925746, 0.94050000000000000266, 0.88100000000000000533 },
{ /*199 f=19900 */ 1.04874582579100694701, 0.94248611111111113559, 0.88497222222222227117 },
{ /*200 f=20000 */ 1.04590261706767551075, 0.94444444444444441977, 0.88888888888888895057 },
{ /*201 f=20100 */ 1.04310728251443629588, 0.94637499999999996625, 0.89275000000000004352 },
{ /*202 f=20200 */ 1.04035947918436955106, 0.94827777777777777501, 0.89655555555555555003 },
{ /*203 f=20300 */ 1.03765887052423466663, 0.95015277777777784607, 0.90030555555555558112 },
{ /*204 f=20400 */ 1.03500512630585594920, 0.95199999999999995737, 0.90400000000000002576 },
{ /*205 f=20500 */ 1.03239792255890261430, 0.95381944444444444198, 0.90763888888888888395 },
{ /*206 f=20600 */ 1.02983694150504834219, 0.95561111111111107785, 0.91122222222222215571 },
{ /*207 f=20700 */ 1.02732187149348530575, 0.95737500000000008704, 0.91475000000000006306 },
{ /*208 f=20800 */ 1.02485240693778090204, 0.95911111111111113647, 0.91822222222222227295 },
{ /*209 f=20900 */ 1.02242824825405276279, 0.96081944444444444819, 0.92163888888888889639 },
{ /*210 f=21000 */ 1.02004910180045094137, 0.96250000000000002220, 0.92500000000000004441 },
{ /*211 f=21100 */ 1.01771467981792529400, 0.96415277777777785850, 0.92830555555555560598 },
{ /*212 f=21200 */ 1.01542470037226384427, 0.96577777777777784607, 0.93155555555555558112 },
{ /*213 f=21300 */ 1.01317888729738481146, 0.96737499999999998490, 0.93474999999999996980 },
{ /*214 f=21400 */ 1.01097697013986764780, 0.96894444444444438602, 0.93788888888888888307 },
{ /*215 f=21500 */ 1.00881868410470465491, 0.97048611111111116045, 0.94097222222222220989 },
{ /*216 f=21600 */ 1.00670377000226207720, 0.97199999999999997513, 0.94400000000000006128 },
{ /*217 f=21700 */ 1.00463197419643113228, 0.97348611111111105210, 0.94697222222222221522 },
{ /*218 f=21800 */ 1.00260304855396009671, 0.97494444444444439135, 0.94988888888888889372 },
{ /*219 f=21900 */ 1.00061675039494524242, 0.97637499999999999289, 0.95274999999999998579 },
{ /*220 f=22000 */ 0.99867284244447773744, 0.97777777777777774570, 0.95555555555555549141 },
{ /*221 f=22100 */ 0.99677109278542130877, 0.97915277777777776080, 0.95830555555555552161 },
{ /*222 f=22200 */ 0.99491127481231689256, 0.98050000000000003819, 0.96100000000000007638 },
{ /*223 f=22300 */ 0.99309316718639539801, 0.98181944444444446685, 0.96363888888888893369 },
{ /*224 f=22400 */ 0.99131655379169036912, 0.98311111111111104677, 0.96622222222222220456 },
{ /*225 f=22500 */ 0.98958122369223378012, 0.98437500000000000000, 0.96875000000000000000 },
{ /*226 f=22600 */ 0.98788697109032919119, 0.98561111111111110450, 0.97122222222222220900 },
{ /*227 f=22700 */ 0.98623359528588339096, 0.98681944444444447129, 0.97363888888888883155 },
{ /*228 f=22800 */ 0.98462090063679197360, 0.98799999999999998934, 0.97599999999999997868 },
{ /*229 f=22900 */ 0.98304869652036386274, 0.98915277777777776969, 0.97830555555555553937 },
{ /*230 f=23000 */ 0.98151679729577490097, 0.99027777777777781232, 0.98055555555555562464 },
{ /*231 f=23100 */ 0.98002502226754195647, 0.99137500000000000622, 0.98275000000000001243 },
{ /*232 f=23200 */ 0.97857319565000466799, 0.99244444444444446241, 0.98488888888888892481 },
{ /*233 f=23300 */ 0.97716114653280683466, 0.99348611111111106986, 0.98697222222222225074 },
{ /*234 f=23400 */ 0.97578870884736779168, 0.99449999999999993960, 0.98899999999999999023 },
{ /*235 f=23500 */ 0.97445572133433533413, 0.99548611111111107164, 0.99097222222222225430 },
{ /*236 f=23600 */ 0.97316202751200819865, 0.99644444444444446596, 0.99288888888888882089 },
{ /*237 f=23700 */ 0.97190747564572299577, 0.99737500000000001155, 0.99475000000000002309 },
{ /*238 f=23800 */ 0.97069191871819560102, 0.99827777777777781942, 0.99655555555555552782 },
{ /*239 f=23900 */ 0.96951521440080901115, 0.99915277777777777857, 0.99830555555555555713 },
{ /*240 f=24000 */ 0.96837722502583889472, 1.00000000000000000000, 1.00000000000000000000 }
};
static FLOAT_T moog_q160[241][3] = {
{ /* dummy entry */ 0, 0, 0},
{ /*  1 f=  100 */ 3.85909098580820275615, 0.00748611111111113781, -0.98502777777777772439 },
{ /*  2 f=  200 */ 3.81939698456364506995, 0.01494444444444442688, -0.97011111111111114624 },
{ /*  3 f=  300 */ 3.78025683278778501517, 0.02237499999999997824, -0.95525000000000004352 },
{ /*  4 f=  400 */ 3.74166185583458599240, 0.02977777777777779189, -0.94044444444444441622 },
{ /*  5 f=  500 */ 3.70360353044674983636, 0.03715277777777775681, -0.92569444444444448639 },
{ /*  6 f=  600 */ 3.66607348190393711462, 0.04449999999999998401, -0.91100000000000003197 },
{ /*  7 f=  700 */ 3.62906348122849786719, 0.05181944444444447351, -0.89636111111111105298 },
{ /*  8 f=  800 */ 3.59256544244749287387, 0.05911111111111111427, -0.88177777777777777146 },
{ /*  9 f=  900 */ 3.55657141990980019131, 0.06637500000000001732, -0.86724999999999996536 },
{ /* 10 f= 1000 */ 3.52107360565714300193, 0.07361111111111112715, -0.85277777777777774570 },
{ /* 11 f= 1100 */ 3.48606432684787703735, 0.08081944444444444375, -0.83836111111111111249 },
{ /* 12 f= 1200 */ 3.45153604323243401453, 0.08800000000000002265, -0.82399999999999995470 },
{ /* 13 f= 1300 */ 3.41748134467931174996, 0.09515277777777780832, -0.80969444444444438336 },
{ /* 14 f= 1400 */ 3.38389294875054558176, 0.10227777777777780077, -0.79544444444444439846 },
{ /* 15 f= 1500 */ 3.35076369832561615780, 0.10937500000000000000, -0.78125000000000000000 },
{ /* 16 f= 1600 */ 3.31808655927275886199, 0.11644444444444446152, -0.76711111111111107697 },
{ /* 17 f= 1700 */ 3.28585461816668900070, 0.12348611111111112981, -0.75302777777777774038 },
{ /* 18 f= 1800 */ 3.25406108005174887765, 0.13050000000000000488, -0.73899999999999999023 },
{ /* 19 f= 1900 */ 3.22269926624952596228, 0.13748611111111108674, -0.72502777777777782653 },
{ /* 20 f= 2000 */ 3.19176261221001356105, 0.14444444444444443088, -0.71111111111111113825 },
{ /* 21 f= 2100 */ 3.16124466540537740755, 0.15137499999999998179, -0.69725000000000003642 },
{ /* 22 f= 2200 */ 3.13113908326546264149, 0.15827777777777779500, -0.68344444444444441000 },
{ /* 23 f= 2300 */ 3.10143963115413479059, 0.16515277777777781498, -0.66969444444444437003 },
{ /* 24 f= 2400 */ 3.07214018038562741708, 0.17199999999999998623, -0.65600000000000002753 },
{ /* 25 f= 2500 */ 3.04323470628003267535, 0.17881944444444447528, -0.64236111111111104943 },
{ /* 26 f= 2600 */ 3.01471728625714341376, 0.18561111111111111560, -0.62877777777777776880 },
{ /* 27 f= 2700 */ 2.98658209796782081469, 0.19237500000000001821, -0.61524999999999996358 },
{ /* 28 f= 2800 */ 2.95882341746212373934, 0.19911111111111112759, -0.60177777777777774482 },
{ /* 29 f= 2900 */ 2.93143561739342173311, 0.20581944444444444375, -0.58836111111111111249 },
{ /* 30 f= 3000 */ 2.90441316525775139468, 0.21250000000000002220, -0.57499999999999995559 },
{ /* 31 f= 3100 */ 2.87775062166767892080, 0.21915277777777780743, -0.56169444444444438513 },
{ /* 32 f= 3200 */ 2.85144263865995162277, 0.22577777777777779944, -0.54844444444444440112 },
{ /* 33 f= 3300 */ 2.82548395803624163847, 0.23237499999999999822, -0.53525000000000000355 },
{ /* 34 f= 3400 */ 2.79986940973629527818, 0.23894444444444445930, -0.52211111111111108141 },
{ /* 35 f= 3500 */ 2.77459391024281254445, 0.24548611111111112715, -0.50902777777777774570 },
{ /* 36 f= 3600 */ 2.74965246101741067619, 0.25200000000000000178, -0.49599999999999999645 },
{ /* 37 f= 3700 */ 2.72504014696701934994, 0.25848611111111113869, -0.48302777777777772261 },
{ /* 38 f= 3800 */ 2.70075213494009114257, 0.26494444444444442688, -0.47011111111111114624 },
{ /* 39 f= 3900 */ 2.67678367225200197765, 0.27137500000000003286, -0.45724999999999998979 },
{ /* 40 f= 4000 */ 2.65313008523905136116, 0.27777777777777779011, -0.44444444444444447528 },
{ /* 41 f= 4100 */ 2.62978677784046865895, 0.28415277777777780965, -0.43169444444444443620 },
{ /* 42 f= 4200 */ 2.60674923020784943262, 0.29049999999999998046, -0.41900000000000003908 },
{ /* 43 f= 4300 */ 2.58401299734146805420, 0.29681944444444441356, -0.40636111111111111738 },
{ /* 44 f= 4400 */ 2.56157370775290793574, 0.30311111111111110894, -0.39377777777777778212 },
{ /* 45 f= 4500 */ 2.53942706215347291376, 0.30937500000000001110, -0.38124999999999997780 },
{ /* 46 f= 4600 */ 2.51756883216785665169, 0.31561111111111117555, -0.36877777777777770440 },
{ /* 47 f= 4700 */ 2.49599485907255047579, 0.32181944444444443576, -0.35636111111111112848 },
{ /* 48 f= 4800 */ 2.47470105255849004422, 0.32800000000000001377, -0.34399999999999997247 },
{ /* 49 f= 4900 */ 2.45368338951744346943, 0.33415277777777774304, -0.33169444444444445841 },
{ /* 50 f= 5000 */ 2.43293791285165861282, 0.34027777777777779011, -0.31944444444444441977 },
{ /* 51 f= 5100 */ 2.41246073030630459044, 0.34637499999999998845, -0.30725000000000002309 },
{ /* 52 f= 5200 */ 2.39224801332422698508, 0.35244444444444444908, -0.29511111111111110183 },
{ /* 53 f= 5300 */ 2.37229599592259399188, 0.35848611111111111649, -0.28302777777777776702 },
{ /* 54 f= 5400 */ 2.35260097359095565750, 0.36450000000000004619, -0.27099999999999996314 },
{ /* 55 f= 5500 */ 2.33315930221031564429, 0.37048611111111107164, -0.25902777777777780122 },
{ /* 56 f= 5600 */ 2.31396739699276832170, 0.37644444444444447040, -0.24711111111111108696 },
{ /* 57 f= 5700 */ 2.29502173144129928417, 0.38237500000000002043, -0.23525000000000001465 },
{ /* 58 f= 5800 */ 2.27631883632933806894, 0.38827777777777777724, -0.22344444444444441777 },
{ /* 59 f= 5900 */ 2.25785529869966783423, 0.39415277777777779633, -0.21169444444444446285 },
{ /* 60 f= 6000 */ 2.23962776088229986726, 0.40000000000000002220, -0.19999999999999998335 },
{ /* 61 f= 6100 */ 2.22163291953094033104, 0.40581944444444439934, -0.18836111111111114580 },
{ /* 62 f= 6200 */ 2.20386752467766422470, 0.41161111111111114980, -0.17677777777777770041 },
{ /* 63 f= 6300 */ 2.18632837880544439457, 0.41737500000000005151, -0.16524999999999995248 },
{ /* 64 f= 6400 */ 2.16901233593817321932, 0.42311111111111110450, -0.15377777777777776325 },
{ /* 65 f= 6500 */ 2.15191630074782080939, 0.42881944444444441977, -0.14236111111111113270 },
{ /* 66 f= 6600 */ 2.13503722767840686814, 0.43450000000000005285, -0.13099999999999992206 },
{ /* 67 f= 6700 */ 2.11837212008642961081, 0.44015277777777778168, -0.11969444444444440889 },
{ /* 68 f= 6800 */ 2.10191802939743643819, 0.44577777777777777279, -0.10844444444444444053 },
{ /* 69 f= 6900 */ 2.08567205427841662058, 0.45137499999999997069, -0.09725000000000004474 },
{ /* 70 f= 7000 */ 2.06963133982569491565, 0.45694444444444448639, -0.08611111111111104111 },
{ /* 71 f= 7100 */ 2.05379307676802458360, 0.46248611111111115335, -0.07502777777777774881 },
{ /* 72 f= 7200 */ 2.03815450068457426624, 0.46799999999999997158, -0.06400000000000001521 },
{ /* 73 f= 7300 */ 2.02271289123752273653, 0.47348611111111110761, -0.05302777777777782642 },
{ /* 74 f= 7400 */ 2.00746557141895776155, 0.47894444444444445041, -0.04211111111111105060 },
{ /* 75 f= 7500 */ 1.99240990681181751043, 0.48437500000000000000, -0.03124999999999997918 },
{ /* 76 f= 7600 */ 1.97754330486457607918, 0.48977777777777775636, -0.02044444444444446299 },
{ /* 77 f= 7700 */ 1.96286321417941911349, 0.49515277777777783053, -0.00969444444444435803 },
{ /* 78 f= 7800 */ 1.94836712381364063340, 0.50050000000000005596, 0.00100000000000004794 },
{ /* 79 f= 7900 */ 1.93405256259399171981, 0.50581944444444448816, 0.01163888888888889826 },
{ /* 80 f= 8000 */ 1.91991709844374258687, 0.51111111111111107164, 0.02222222222222219531 },
{ /* 81 f= 8100 */ 1.90595833772219669378, 0.51637500000000002842, 0.03275000000000007766 },
{ /* 82 f= 8200 */ 1.89217392457642286097, 0.52161111111111113647, 0.04322222222222225907 },
{ /* 83 f= 8300 */ 1.87856154030495647866, 0.52681944444444439579, 0.05363888888888888873 },
{ /* 84 f= 8400 */ 1.86511890273324554279, 0.53200000000000002842, 0.06399999999999995970 },
{ /* 85 f= 8500 */ 1.85184376560061192407, 0.53715277777777781232, 0.07430555555555562464 },
{ /* 86 f= 8600 */ 1.83873391795849450148, 0.54227777777777774748, 0.08455555555555557823 },
{ /* 87 f= 8700 */ 1.82578718357976699238, 0.54737499999999994493, 0.09474999999999998701 },
{ /* 88 f= 8800 */ 1.81300142037890821278, 0.55244444444444440467, 0.10488888888888885098 },
{ /* 89 f= 8900 */ 1.80037451984281848816, 0.55748611111111112670, 0.11497222222222228116 },
{ /* 90 f= 9000 */ 1.78790440647207193869, 0.56250000000000000000, 0.12500000000000002776 },
{ /* 91 f= 9100 */ 1.77558903723240502082, 0.56748611111111113559, 0.13497222222222221566 },
{ /* 92 f= 9200 */ 1.76342640101624770210, 0.57244444444444453346, 0.14488888888888898365 },
{ /* 93 f= 9300 */ 1.75141451811409609718, 0.57737499999999997158, 0.15475000000000005418 },
{ /* 94 f= 9400 */ 1.73955143969554137939, 0.58227777777777778301, 0.16455555555555556602 },
{ /* 95 f= 9500 */ 1.72783524729977178147, 0.58715277777777774570, 0.17430555555555554692 },
{ /* 96 f= 9600 */ 1.71626405233536005746, 0.59200000000000008171, 0.18400000000000008016 },
{ /* 97 f= 9700 */ 1.70483599558916321115, 0.59681944444444445796, 0.19363888888888891593 },
{ /* 98 f= 9800 */ 1.69354924674415574515, 0.60161111111111109651, 0.20322222222222222077 },
{ /* 99 f= 9900 */ 1.68240200390602945291, 0.60637499999999999734, 0.21274999999999996692 },
{ /*100 f=10000 */ 1.67139249313839099997, 0.61111111111111116045, 0.22222222222222229315 },
{ /*101 f=10100 */ 1.66051896800639409157, 0.61581944444444447484, 0.23163888888888892192 },
{ /*102 f=10200 */ 1.64977970912863969311, 0.62050000000000005151, 0.24099999999999999201 },
{ /*103 f=10300 */ 1.63917302373719953046, 0.62515277777777777946, 0.25030555555555550340 },
{ /*104 f=10400 */ 1.62869724524559300605, 0.62977777777777776969, 0.25955555555555559488 },
{ /*105 f=10500 */ 1.61835073282458297150, 0.63437500000000002220, 0.26875000000000004441 },
{ /*106 f=10600 */ 1.60813187098562693222, 0.63894444444444442599, 0.27788888888888885198 },
{ /*107 f=10700 */ 1.59803906917184979086, 0.64348611111111120309, 0.28697222222222229515 },
{ /*108 f=10800 */ 1.58807076135639246850, 0.64800000000000002043, 0.29600000000000004086 },
{ /*109 f=10900 */ 1.57822540564799518314, 0.65248611111111110006, 0.30497222222222225563 },
{ /*110 f=11000 */ 1.56850148390368304696, 0.65694444444444444198, 0.31388888888888888395 },
{ /*111 f=11100 */ 1.55889750134841742479, 0.66137500000000004619, 0.32275000000000009237 },
{ /*112 f=11200 */ 1.54941198620158449017, 0.66577777777777780166, 0.33155555555555560332 },
{ /*113 f=11300 */ 1.54004348931019063862, 0.67015277777777781942, 0.34030555555555558334 },
{ /*114 f=11400 */ 1.53079058378864107937, 0.67449999999999998845, 0.34899999999999997691 },
{ /*115 f=11500 */ 1.52165186466497703854, 0.67881944444444441977, 0.35763888888888895057 },
{ /*116 f=11600 */ 1.51262594853345300194, 0.68311111111111111338, 0.36622222222222222676 },
{ /*117 f=11700 */ 1.50371147321333364921, 0.68737499999999995826, 0.37474999999999997202 },
{ /*118 f=11800 */ 1.49490709741379657061, 0.69161111111111106542, 0.38322222222222218635 },
{ /*119 f=11900 */ 1.48621150040482508103, 0.69581944444444443487, 0.39163888888888892525 },
{ /*120 f=12000 */ 1.47762338169398299570, 0.69999999999999995559, 0.40000000000000002220 },
{ /*121 f=12100 */ 1.46914146070896123319, 0.70415277777777773860, 0.40830555555555553271 },
{ /*122 f=12200 */ 1.46076447648578722216, 0.70827777777777778390, 0.41655555555555551228 },
{ /*123 f=12300 */ 1.45249118736259719142, 0.71237499999999998046, 0.42474999999999996092 },
{ /*124 f=12400 */ 1.44432037067886298587, 0.71644444444444443931, 0.43288888888888898965 },
{ /*125 f=12500 */ 1.43625082247997992724, 0.72048611111111116045, 0.44097222222222232091 },
{ /*126 f=12600 */ 1.42828135722711202504, 0.72450000000000003286, 0.44900000000000006573 },
{ /*127 f=12700 */ 1.42041080751219839229, 0.72848611111111116756, 0.45697222222222227961 },
{ /*128 f=12800 */ 1.41263802377802938359, 0.73244444444444445352, 0.46488888888888890705 },
{ /*129 f=12900 */ 1.40496187404329875292, 0.73637500000000000178, 0.47275000000000000355 },
{ /*130 f=13000 */ 1.39738124363253790605, 0.74027777777777781232, 0.48055555555555551361 },
{ /*131 f=13100 */ 1.38989503491084898101, 0.74415277777777777413, 0.48830555555555549274 },
{ /*132 f=13200 */ 1.38250216702334349783, 0.74799999999999999822, 0.49600000000000010747 },
{ /*133 f=13300 */ 1.37520157563920641941, 0.75181944444444448461, 0.50363888888888896922 },
{ /*134 f=13400 */ 1.36799221270029769393, 0.75561111111111112226, 0.51122222222222224453 },
{ /*135 f=13500 */ 1.36087304617421289699, 0.75937500000000002220, 0.51875000000000004441 },
{ /*136 f=13600 */ 1.35384305981171904065, 0.76311111111111107341, 0.52622222222222225785 },
{ /*137 f=13700 */ 1.34690125290848849993, 0.76681944444444449793, 0.53363888888888888484 },
{ /*138 f=13800 */ 1.34004664007105622758, 0.77049999999999996270, 0.54099999999999992539 },
{ /*139 f=13900 */ 1.33327825098691610251, 0.77415277777777791179, 0.54830555555555571257 },
{ /*140 f=14000 */ 1.32659513019869645944, 0.77777777777777790114, 0.55555555555555569125 },
{ /*141 f=14100 */ 1.31999633688232420603, 0.78137500000000004174, 0.56275000000000008349 },
{ /*142 f=14200 */ 1.31348094462912312608, 0.78494444444444444464, 0.56988888888888888928 },
{ /*143 f=14300 */ 1.30704804123176465680, 0.78848611111111110983, 0.57697222222222221966 },
{ /*144 f=14400 */ 1.30069672847400852334, 0.79200000000000003730, 0.58399999999999996358 },
{ /*145 f=14500 */ 1.29442612192416439676, 0.79548611111111111605, 0.59097222222222223209 },
{ /*146 f=14600 */ 1.28823535073220774017, 0.79894444444444445708, 0.59788888888888880313 },
{ /*147 f=14700 */ 1.28212355743048722623, 0.80237500000000006040, 0.60475000000000012079 },
{ /*148 f=14800 */ 1.27608989773795999945, 0.80577777777777781498, 0.61155555555555562997 },
{ /*149 f=14900 */ 1.27013354036789061219, 0.80915277777777783186, 0.61830555555555555269 },
{ /*150 f=15000 */ 1.26425366683895745723, 0.81250000000000000000, 0.62500000000000000000 },
{ /*151 f=15100 */ 1.25844947128970097161, 0.81581944444444443043, 0.63163888888888886086 },
{ /*152 f=15200 */ 1.25272016029626209743, 0.81911111111111112315, 0.63822222222222224630 },
{ /*153 f=15300 */ 1.24706495269334660669, 0.82237499999999996714, 0.64474999999999993427 },
{ /*154 f=15400 */ 1.24148307939836577418, 0.82561111111111118444, 0.65122222222222236887 },
{ /*155 f=15500 */ 1.23597378323869544481, 0.82881944444444455300, 0.65763888888888899498 },
{ /*156 f=15600 */ 1.23053631878199554173, 0.83200000000000007283, 0.66400000000000003464 },
{ /*157 f=15700 */ 1.22516995216954782677, 0.83515277777777785495, 0.67030555555555559888 },
{ /*158 f=15800 */ 1.21987396095254663209, 0.83827777777777778834, 0.67655555555555557667 },
{ /*159 f=15900 */ 1.21464763393130525948, 0.84137499999999998401, 0.68274999999999996803 },
{ /*160 f=16000 */ 1.20949027099731609702, 0.84444444444444444198, 0.68888888888888888395 },
{ /*161 f=16100 */ 1.20440118297812559511, 0.84748611111111116223, 0.69497222222222221344 },
{ /*162 f=16200 */ 1.19937969148496925698, 0.85050000000000003375, 0.70100000000000006750 },
{ /*163 f=16300 */ 1.19442512876312423309, 0.85348611111111116756, 0.70697222222222233512 },
{ /*164 f=16400 */ 1.18953683754493044766, 0.85644444444444445264, 0.71288888888888890527 },
{ /*165 f=16500 */ 1.18471417090543917894, 0.85937500000000000000, 0.71875000000000000000 },
{ /*166 f=16600 */ 1.17995649212063891120, 0.86227777777777769863, 0.72455555555555550828 },
{ /*167 f=16700 */ 1.17526317452822226528, 0.86515277777777777057, 0.73030555555555554115 },
{ /*168 f=16800 */ 1.17063360139084582379, 0.86799999999999999378, 0.73599999999999998757 },
{ /*169 f=16900 */ 1.16606716576184465950, 0.87081944444444447928, 0.74163888888888895856 },
{ /*170 f=17000 */ 1.16156327035336048858, 0.87361111111111111605, 0.74722222222222234311 },
{ /*171 f=17100 */ 1.15712132740683970589, 0.87637500000000001510, 0.75275000000000003020 },
{ /*172 f=17200 */ 1.15274075856586977196, 0.87911111111111117644, 0.75822222222222224186 },
{ /*173 f=17300 */ 1.14842099475130821062, 0.88181944444444448905, 0.76363888888888886708 },
{ /*174 f=17400 */ 1.14416147603866957816, 0.88450000000000006395, 0.76900000000000001688 },
{ /*175 f=17500 */ 1.13996165153773576506, 0.88715277777777779011, 0.77430555555555558023 },
{ /*176 f=17600 */ 1.13582097927434810813, 0.88977777777777777857, 0.77955555555555555713 },
{ /*177 f=17700 */ 1.13173892607435333524, 0.89237500000000002931, 0.78475000000000005862 },
{ /*178 f=17800 */ 1.12771496744965982195, 0.89494444444444454234, 0.78988888888888897366 },
{ /*179 f=17900 */ 1.12374858748637995731, 0.89748611111111120664, 0.79497222222222230226 },
{ /*180 f=18000 */ 1.11983927873501554195, 0.90000000000000002220, 0.80000000000000004441 },
{ /*181 f=18100 */ 1.11598654210266134967, 0.90248611111111110006, 0.80497222222222220012 },
{ /*182 f=18200 */ 1.11218988674719221343, 0.90494444444444444020, 0.80988888888888888040 },
{ /*183 f=18300 */ 1.10844882997339944097, 0.90737500000000004263, 0.81474999999999997424 },
{ /*184 f=18400 */ 1.10476289713105169099, 0.90977777777777779633, 0.81955555555555559266 },
{ /*185 f=18500 */ 1.10113162151484389462, 0.91215277777777781232, 0.82430555555555562464 },
{ /*186 f=18600 */ 1.09755454426621068542, 0.91450000000000009059, 0.82900000000000007017 },
{ /*187 f=18700 */ 1.09403121427697236356, 0.91681944444444440911, 0.83363888888888892925 },
{ /*188 f=18800 */ 1.09056118809478208576, 0.91911111111111110095, 0.83822222222222220189 },
{ /*189 f=18900 */ 1.08714402983035607342, 0.92137500000000005507, 0.84274999999999999911 },
{ /*190 f=19000 */ 1.08377931106644886938, 0.92361111111111116045, 0.84722222222222220989 },
{ /*191 f=19100 */ 1.08046661076855388117, 0.92581944444444441711, 0.85163888888888883422 },
{ /*192 f=19200 */ 1.07720551519730034506, 0.92800000000000004707, 0.85600000000000009415 },
{ /*193 f=19300 */ 1.07399561782252472852, 0.93015277777777782831, 0.86030555555555554559 },
{ /*194 f=19400 */ 1.07083651923898548475, 0.93227777777777776080, 0.86455555555555563263 },
{ /*195 f=19500 */ 1.06772782708370250759, 0.93437499999999995559, 0.86875000000000002220 },
{ /*196 f=19600 */ 1.06466915595489552970, 0.93644444444444441267, 0.87288888888888893636 },
{ /*197 f=19700 */ 1.06166012733249681688, 0.93848611111111113203, 0.87697222222222215304 },
{ /*198 f=19800 */ 1.05870036950021617628, 0.94050000000000000266, 0.88100000000000000533 },
{ /*199 f=19900 */ 1.05578951746913651810, 0.94248611111111113559, 0.88497222222222227117 },
{ /*200 f=20000 */ 1.05292721290281687807, 0.94444444444444441977, 0.88888888888888895057 },
{ /*201 f=20100 */ 1.05011310404388225059, 0.94637499999999996625, 0.89275000000000004352 },
{ /*202 f=20200 */ 1.04734684564207825019, 0.94827777777777777501, 0.89655555555555555003 },
{ /*203 f=20300 */ 1.04462809888377172740, 0.95015277777777784607, 0.90030555555555558112 },
{ /*204 f=20400 */ 1.04195653132287535669, 0.95199999999999995737, 0.90400000000000002576 },
{ /*205 f=20500 */ 1.03933181681317665657, 0.95381944444444444198, 0.90763888888888888395 },
{ /*206 f=20600 */ 1.03675363544205456634, 0.95561111111111107785, 0.91122222222222215571 },
{ /*207 f=20700 */ 1.03422167346556115319, 0.95737500000000008704, 0.91475000000000006306 },
{ /*208 f=20800 */ 1.03173562324485312836, 0.95911111111111113647, 0.91822222222222227295 },
{ /*209 f=20900 */ 1.02929518318395318843, 0.96081944444444444819, 0.92163888888888889639 },
{ /*210 f=21000 */ 1.02690005766882475058, 0.96250000000000002220, 0.92500000000000004441 },
{ /*211 f=21100 */ 1.02454995700774098566, 0.96415277777777785850, 0.92830555555555560598 },
{ /*212 f=21200 */ 1.02224459737293571493, 0.96577777777777784607, 0.93155555555555558112 },
{ /*213 f=21300 */ 1.01998370074351263348, 0.96737499999999998490, 0.93474999999999996980 },
{ /*214 f=21400 */ 1.01776699484960486686, 0.96894444444444438602, 0.93788888888888888307 },
{ /*215 f=21500 */ 1.01559421311776199026, 0.97048611111111116045, 0.94097222222222220989 },
{ /*216 f=21600 */ 1.01346509461755518444, 0.97199999999999997513, 0.94400000000000006128 },
{ /*217 f=21700 */ 1.01137938400937898997, 0.97348611111111105210, 0.94697222222222221522 },
{ /*218 f=21800 */ 1.00933683149344433083, 0.97494444444444439135, 0.94988888888888889372 },
{ /*219 f=21900 */ 1.00733719275993660602, 0.97637499999999999289, 0.95274999999999998579 },
{ /*220 f=22000 */ 1.00538022894033773902, 0.97777777777777774570, 0.95555555555555549141 },
{ /*221 f=22100 */ 1.00346570655988576171, 0.97915277777777776080, 0.95830555555555552161 },
{ /*222 f=22200 */ 1.00159339749117193286, 0.98050000000000003819, 0.96100000000000007638 },
{ /*223 f=22300 */ 0.99976307890884930085, 0.98181944444444446685, 0.96363888888888893369 },
{ /*224 f=22400 */ 0.99797453324545171149, 0.98311111111111104677, 0.96622222222222220456 },
{ /*225 f=22500 */ 0.99622754814830194459, 0.98437500000000000000, 0.96875000000000000000 },
{ /*226 f=22600 */ 0.99452191643750442740, 0.98561111111111110450, 0.97122222222222220900 },
{ /*227 f=22700 */ 0.99285743606500398428, 0.98681944444444447129, 0.97363888888888883155 },
{ /*228 f=22800 */ 0.99123391007470484926, 0.98799999999999998934, 0.97599999999999997868 },
{ /*229 f=22900 */ 0.98965114656363717405, 0.98915277777777776969, 0.97830555555555553937 },
{ /*230 f=23000 */ 0.98810895864415704271, 0.99027777777777781232, 0.98055555555555562464 },
{ /*231 f=23100 */ 0.98660716440717621811, 0.99137500000000000622, 0.98275000000000001243 },
{ /*232 f=23200 */ 0.98514558688640518902, 0.99244444444444446241, 0.98488888888888892481 },
{ /*233 f=23300 */ 0.98372405402360263427, 0.99348611111111106986, 0.98697222222222225074 },
{ /*234 f=23400 */ 0.98234239863482120114, 0.99449999999999993960, 0.98899999999999999023 },
{ /*235 f=23500 */ 0.98100045837764260348, 0.99548611111111107164, 0.99097222222222225430 },
{ /*236 f=23600 */ 0.97969807571938760660, 0.99644444444444446596, 0.99288888888888882089 },
{ /*237 f=23700 */ 0.97843509790629712430, 0.99737500000000001155, 0.99475000000000002309 },
{ /*238 f=23800 */ 0.97721137693367499111, 0.99827777777777781942, 0.99655555555555552782 },
{ /*239 f=23900 */ 0.97602676951698230656, 0.99915277777777777857, 0.99830555555555555713 },
{ /*240 f=24000 */ 0.97488113706387724555, 1.00000000000000000000, 1.00000000000000000000 }
};
static FLOAT_T moog_q170[241][3] = {
{ /* dummy entry */ 0, 0, 0},
{ /*  1 f=  100 */ 3.87954167781940739701, 0.00748611111111113781, -0.98502777777777772439 },
{ /*  2 f=  200 */ 3.83963732398219814712, 0.01494444444444442688, -0.97011111111111114624 },
{ /*  3 f=  300 */ 3.80028975465847906889, 0.02237499999999997824, -0.95525000000000004352 },
{ /*  4 f=  400 */ 3.76149024923218844307, 0.02977777777777779189, -0.94044444444444441622 },
{ /*  5 f=  500 */ 3.72323023927826390889, 0.03715277777777775681, -0.92569444444444448639 },
{ /*  6 f=  600 */ 3.68550130569575218331, 0.04449999999999998401, -0.91100000000000003197 },
{ /*  7 f=  700 */ 3.64829517589873209005, 0.05181944444444447351, -0.89636111111111105298 },
{ /*  8 f=  800 */ 3.61160372106382521196, 0.05911111111111111427, -0.88177777777777777146 },
{ /*  9 f=  900 */ 3.57541895343308580024, 0.06637500000000001732, -0.86724999999999996536 },
{ /* 10 f= 1000 */ 3.53973302367109710076, 0.07361111111111112715, -0.85277777777777774570 },
{ /* 11 f= 1100 */ 3.50453821827510525466, 0.08081944444444444375, -0.83836111111111111249 },
{ /* 12 f= 1200 */ 3.46982695703708410306, 0.08800000000000002265, -0.82399999999999995470 },
{ /* 13 f= 1300 */ 3.43559179055661711999, 0.09515277777777780832, -0.80969444444444438336 },
{ /* 14 f= 1400 */ 3.40182539780351644865, 0.10227777777777780077, -0.79544444444444439846 },
{ /* 15 f= 1500 */ 3.36852058372914386908, 0.10937500000000000000, -0.78125000000000000000 },
{ /* 16 f= 1600 */ 3.33567027692537454442, 0.11644444444444446152, -0.76711111111111107697 },
{ /* 17 f= 1700 */ 3.30326752733023099040, 0.12348611111111112981, -0.75302777777777774038 },
{ /* 18 f= 1800 */ 3.27130550397917518879, 0.13050000000000000488, -0.73899999999999999023 },
{ /* 19 f= 1900 */ 3.23977749280110938201, 0.13748611111111108674, -0.72502777777777782653 },
{ /* 20 f= 2000 */ 3.20867689445814674443, 0.14444444444444443088, -0.71111111111111113825 },
{ /* 21 f= 2100 */ 3.17799722222821978690, 0.15137499999999998179, -0.69725000000000003642 },
{ /* 22 f= 2200 */ 3.14773209992964453363, 0.15827777777777779500, -0.68344444444444441000 },
{ /* 23 f= 2300 */ 3.11787525988673808186, 0.16515277777777781498, -0.66969444444444437003 },
{ /* 24 f= 2400 */ 3.08842054093565376860, 0.17199999999999998623, -0.65600000000000002753 },
{ /* 25 f= 2500 */ 3.05936188646956885862, 0.17881944444444447528, -0.64236111111111104943 },
{ /* 26 f= 2600 */ 3.03069334252242184036, 0.18561111111111111560, -0.62877777777777776880 },
{ /* 27 f= 2700 */ 3.00240905589038131751, 0.19237500000000001821, -0.61524999999999996358 },
{ /* 28 f= 2800 */ 2.97450327229026445508, 0.19911111111111112759, -0.60177777777777774482 },
{ /* 29 f= 2900 */ 2.94697033455413537339, 0.20581944444444444375, -0.58836111111111111249 },
{ /* 30 f= 3000 */ 2.91980468085932898248, 0.21250000000000002220, -0.57499999999999995559 },
{ /* 31 f= 3100 */ 2.89300084299316884184, 0.21915277777777780743, -0.56169444444444438513 },
{ /* 32 f= 3200 */ 2.86655344465164807488, 0.22577777777777779944, -0.54844444444444440112 },
{ /* 33 f= 3300 */ 2.84045719977138011458, 0.23237499999999999822, -0.53525000000000000355 },
{ /* 34 f= 3400 */ 2.81470691089412783370, 0.23894444444444445930, -0.52211111111111108141 },
{ /* 35 f= 3500 */ 2.78929746756323071466, 0.24548611111111112715, -0.50902777777777774570 },
{ /* 36 f= 3600 */ 2.76422384475127769221, 0.25200000000000000178, -0.49599999999999999645 },
{ /* 37 f= 3700 */ 2.73948110131837685444, 0.25848611111111113869, -0.48302777777777772261 },
{ /* 38 f= 3800 */ 2.71506437850039628046, 0.26494444444444442688, -0.47011111111111114624 },
{ /* 39 f= 3900 */ 2.69096889842654984903, 0.27137500000000003286, -0.45724999999999998979 },
{ /* 40 f= 4000 */ 2.66718996266573560305, 0.27777777777777779011, -0.44444444444444447528 },
{ /* 41 f= 4100 */ 2.64372295080102670539, 0.28415277777777780965, -0.43169444444444443620 },
{ /* 42 f= 4200 */ 2.62056331903173900244, 0.29049999999999998046, -0.41900000000000003908 },
{ /* 43 f= 4300 */ 2.59770659880251608698, 0.29681944444444441356, -0.40636111111111111738 },
{ /* 44 f= 4400 */ 2.57514839545887364025, 0.30311111111111110894, -0.39377777777777778212 },
{ /* 45 f= 4500 */ 2.55288438692866082036, 0.30937500000000001110, -0.38124999999999997780 },
{ /* 46 f= 4600 */ 2.53091032242890845438, 0.31561111111111117555, -0.36877777777777770440 },
{ /* 47 f= 4700 */ 2.50922202119755910488, 0.32181944444444443576, -0.35636111111111112848 },
{ /* 48 f= 4800 */ 2.48781537124954832407, 0.32800000000000001377, -0.34399999999999997247 },
{ /* 49 f= 4900 */ 2.46668632815676680536, 0.33415277777777774304, -0.33169444444444445841 },
{ /* 50 f= 5000 */ 2.44583091385139894669, 0.34027777777777779011, -0.31944444444444441977 },
{ /* 51 f= 5100 */ 2.42524521545217330853, 0.34637499999999998845, -0.30725000000000002309 },
{ /* 52 f= 5200 */ 2.40492538411305423196, 0.35244444444444444908, -0.29511111111111110183 },
{ /* 53 f= 5300 */ 2.38486763389393052748, 0.35848611111111111649, -0.28302777777777776702 },
{ /* 54 f= 5400 */ 2.36506824065283671743, 0.36450000000000004619, -0.27099999999999996314 },
{ /* 55 f= 5500 */ 2.34552354095929915800, 0.37048611111111107164, -0.25902777777777780122 },
{ /* 56 f= 5600 */ 2.32622993102834740853, 0.37644444444444447040, -0.24711111111111108696 },
{ /* 57 f= 5700 */ 2.30718386567480937543, 0.38237500000000002043, -0.23525000000000001465 },
{ /* 58 f= 5800 */ 2.28838185728745280301, 0.38827777777777777724, -0.22344444444444441777 },
{ /* 59 f= 5900 */ 2.26982047482258941784, 0.39415277777777779633, -0.21169444444444446285 },
{ /* 60 f= 6000 */ 2.25149634281674648761, 0.40000000000000002220, -0.19999999999999998335 },
{ /* 61 f= 6100 */ 2.23340614041802609790, 0.40581944444444439934, -0.18836111111111114580 },
{ /* 62 f= 6200 */ 2.21554660043577067441, 0.41161111111111114980, -0.17677777777777770041 },
{ /* 63 f= 6300 */ 2.19791450840817637058, 0.41737500000000005151, -0.16524999999999995248 },
{ /* 64 f= 6400 */ 2.18050670168749149980, 0.42311111111111110450, -0.15377777777777776325 },
{ /* 65 f= 6500 */ 2.16332006854244518479, 0.42881944444444441977, -0.14236111111111113270 },
{ /* 66 f= 6600 */ 2.14635154727757671012, 0.43450000000000005285, -0.13099999999999992206 },
{ /* 67 f= 6700 */ 2.12959812536910586545, 0.44015277777777778168, -0.11969444444444440889 },
{ /* 68 f= 6800 */ 2.11305683861703919035, 0.44577777777777777279, -0.10844444444444444053 },
{ /* 69 f= 6900 */ 2.09672477031317283647, 0.45137499999999997069, -0.09725000000000004474 },
{ /* 70 f= 7000 */ 2.08059905042468429315, 0.45694444444444448639, -0.08611111111111104111 },
{ /* 71 f= 7100 */ 2.06467685479300211426, 0.46248611111111115335, -0.07502777777777774881 },
{ /* 72 f= 7200 */ 2.04895540434764855675, 0.46799999999999997158, -0.06400000000000001521 },
{ /* 73 f= 7300 */ 2.03343196433476647300, 0.47348611111111110761, -0.05302777777777782642 },
{ /* 74 f= 7400 */ 2.01810384356003025275, 0.47894444444444445041, -0.04211111111111105060 },
{ /* 75 f= 7500 */ 2.00296839364566681141, 0.48437500000000000000, -0.03124999999999997918 },
{ /* 76 f= 7600 */ 1.98802300830130040943, 0.48977777777777775636, -0.02044444444444446299 },
{ /* 77 f= 7700 */ 1.97326512260835462698, 0.49515277777777783053, -0.00969444444444435803 },
{ /* 78 f= 7800 */ 1.95869221231774726100, 0.50050000000000005596, 0.00100000000000004794 },
{ /* 79 f= 7900 */ 1.94430179316060613992, 0.50581944444444448816, 0.01163888888888889826 },
{ /* 80 f= 8000 */ 1.93009142017176382744, 0.51111111111111107164, 0.02222222222222219531 },
{ /* 81 f= 8100 */ 1.91605868702577297746, 0.51637500000000002842, 0.03275000000000007766 },
{ /* 82 f= 8200 */ 1.90220122538520164390, 0.52161111111111113647, 0.04322222222222225907 },
{ /* 83 f= 8300 */ 1.88851670426096407418, 0.52681944444444439579, 0.05363888888888888873 },
{ /* 84 f= 8400 */ 1.87500282938445583802, 0.53200000000000002842, 0.06399999999999995970 },
{ /* 85 f= 8500 */ 1.86165734259126613992, 0.53715277777777781232, 0.07430555555555562464 },
{ /* 86 f= 8600 */ 1.84847802121623372429, 0.54227777777777774748, 0.08455555555555557823 },
{ /* 87 f= 8700 */ 1.83546267749963254445, 0.54737499999999994493, 0.09474999999999998701 },
{ /* 88 f= 8800 */ 1.82260915800427047984, 0.55244444444444440467, 0.10488888888888885098 },
{ /* 89 f= 8900 */ 1.80991534304328927085, 0.55748611111111112670, 0.11497222222222228116 },
{ /* 90 f= 9000 */ 1.79737914611845517321, 0.56250000000000000000, 0.12500000000000002776 },
{ /* 91 f= 9100 */ 1.78499851336874115759, 0.56748611111111113559, 0.13497222222222221566 },
{ /* 92 f= 9200 */ 1.77277142302900503346, 0.57244444444444453346, 0.14488888888888898365 },
{ /* 93 f= 9300 */ 1.76069588489856010405, 0.57737499999999997158, 0.15475000000000005418 },
{ /* 94 f= 9400 */ 1.74876993981945361156, 0.58227777777777778301, 0.16455555555555556602 },
{ /* 95 f= 9500 */ 1.73699165916427000766, 0.58715277777777774570, 0.17430555555555554692 },
{ /* 96 f= 9600 */ 1.72535914433326542650, 0.59200000000000008171, 0.18400000000000008016 },
{ /* 97 f= 9700 */ 1.71387052626066771488, 0.59681944444444445796, 0.19363888888888891593 },
{ /* 98 f= 9800 */ 1.70252396492995150545, 0.60161111111111109651, 0.20322222222222222077 },
{ /* 99 f= 9900 */ 1.69131764889793179130, 0.60637499999999999734, 0.21274999999999996692 },
{ /*100 f=10000 */ 1.68024979482749725612, 0.61111111111111116045, 0.22222222222222229315 },
{ /*101 f=10100 */ 1.66931864702882348794, 0.61581944444444447484, 0.23163888888888892192 },
{ /*102 f=10200 */ 1.65852247700889998683, 0.62050000000000005151, 0.24099999999999999201 },
{ /*103 f=10300 */ 1.64785958302921997642, 0.62515277777777777946, 0.25030555555555550340 },
{ /*104 f=10400 */ 1.63732828967147092669, 0.62977777777777776969, 0.25955555555555559488 },
{ /*105 f=10500 */ 1.62692694741107901635, 0.63437500000000002220, 0.26875000000000004441 },
{ /*106 f=10600 */ 1.61665393219845499040, 0.63894444444444442599, 0.27788888888888885198 },
{ /*107 f=10700 */ 1.60650764504779841602, 0.64348611111111120309, 0.28697222222222229515 },
{ /*108 f=10800 */ 1.59648651163331889435, 0.64800000000000002043, 0.29600000000000004086 },
{ /*109 f=10900 */ 1.58658898189272767887, 0.65248611111111110006, 0.30497222222222225563 },
{ /*110 f=11000 */ 1.57681352963787158039, 0.65694444444444444198, 0.31388888888888888395 },
{ /*111 f=11100 */ 1.56715865217236904883, 0.66137500000000004619, 0.32275000000000009237 },
{ /*112 f=11200 */ 1.55762286991611853537, 0.66577777777777780166, 0.33155555555555560332 },
{ /*113 f=11300 */ 1.54820472603655101551, 0.67015277777777781942, 0.34030555555555558334 },
{ /*114 f=11400 */ 1.53890278608649855308, 0.67449999999999998845, 0.34899999999999997691 },
{ /*115 f=11500 */ 1.52971563764855766898, 0.67881944444444441977, 0.35763888888888895057 },
{ /*116 f=11600 */ 1.52064188998582472401, 0.68311111111111111338, 0.36622222222222222676 },
{ /*117 f=11700 */ 1.51168017369888629808, 0.68737499999999995826, 0.37474999999999997202 },
{ /*118 f=11800 */ 1.50282914038894332975, 0.69161111111111106542, 0.38322222222222218635 },
{ /*119 f=11900 */ 1.49408746232696265643, 0.69581944444444443487, 0.39163888888888892525 },
{ /*120 f=12000 */ 1.48545383212873760570, 0.69999999999999995559, 0.40000000000000002220 },
{ /*121 f=12100 */ 1.47692696243575150028, 0.70415277777777773860, 0.40830555555555553271 },
{ /*122 f=12200 */ 1.46850558560173727329, 0.70827777777777778390, 0.41655555555555551228 },
{ /*123 f=12300 */ 1.46018845338482372576, 0.71237499999999998046, 0.42474999999999996092 },
{ /*124 f=12400 */ 1.45197433664517117080, 0.71644444444444443931, 0.43288888888888898965 },
{ /*125 f=12500 */ 1.44386202504799276980, 0.72048611111111116045, 0.44097222222222232091 },
{ /*126 f=12600 */ 1.43585032677186097416, 0.72450000000000003286, 0.44900000000000006573 },
{ /*127 f=12700 */ 1.42793806822220603614, 0.72848611111111116756, 0.45697222222222227961 },
{ /*128 f=12800 */ 1.42012409374990689059, 0.73244444444444445352, 0.46488888888888890705 },
{ /*129 f=12900 */ 1.41240726537488647807, 0.73637500000000000178, 0.47275000000000000355 },
{ /*130 f=13000 */ 1.40478646251461603001, 0.74027777777777781232, 0.48055555555555551361 },
{ /*131 f=13100 */ 1.39726058171744038638, 0.74415277777777777413, 0.48830555555555549274 },
{ /*132 f=13200 */ 1.38982853640063797052, 0.74799999999999999822, 0.49600000000000010747 },
{ /*133 f=13300 */ 1.38248925659312704717, 0.75181944444444448461, 0.50363888888888896922 },
{ /*134 f=13400 */ 1.37524168868273588551, 0.75561111111111112226, 0.51122222222222224453 },
{ /*135 f=13500 */ 1.36808479516795444830, 0.75937500000000002220, 0.51875000000000004441 },
{ /*136 f=13600 */ 1.36101755441408411862, 0.76311111111111107341, 0.52622222222222225785 },
{ /*137 f=13700 */ 1.35403896041371041292, 0.76681944444444449793, 0.53363888888888888484 },
{ /*138 f=13800 */ 1.34714802255141874454, 0.77049999999999996270, 0.54099999999999992539 },
{ /*139 f=13900 */ 1.34034376537267285734, 0.77415277777777791179, 0.54830555555555571257 },
{ /*140 f=14000 */ 1.33362522835679309097, 0.77777777777777790114, 0.55555555555555569125 },
{ /*141 f=14100 */ 1.32699146569394654804, 0.78137500000000004174, 0.56275000000000008349 },
{ /*142 f=14200 */ 1.32044154606608854507, 0.78494444444444444464, 0.56988888888888888928 },
{ /*143 f=14300 */ 1.31397455243178007400, 0.78848611111111110983, 0.57697222222222221966 },
{ /*144 f=14400 */ 1.30758958181481510508, 0.79200000000000003730, 0.58399999999999996358 },
{ /*145 f=14500 */ 1.30128574509658512248, 0.79548611111111111605, 0.59097222222222223209 },
{ /*146 f=14600 */ 1.29506216681212293906, 0.79894444444444445708, 0.59788888888888880313 },
{ /*147 f=14700 */ 1.28891798494975184930, 0.80237500000000006040, 0.60475000000000012079 },
{ /*148 f=14800 */ 1.28285235075428438734, 0.80577777777777781498, 0.61155555555555562997 },
{ /*149 f=14900 */ 1.27686442853370185624, 0.80915277777777783186, 0.61830555555555555269 },
{ /*150 f=15000 */ 1.27095339546925956142, 0.81250000000000000000, 0.62500000000000000000 },
{ /*151 f=15100 */ 1.26511844142895246712, 0.81581944444444443043, 0.63163888888888886086 },
{ /*152 f=15200 */ 1.25935876878428687498, 0.81911111111111112315, 0.63822222222222224630 },
{ /*153 f=15300 */ 1.25367359223029661841, 0.82237499999999996714, 0.64474999999999993427 },
{ /*154 f=15400 */ 1.24806213860875159227, 0.82561111111111118444, 0.65122222222222236887 },
{ /*155 f=15500 */ 1.24252364673450133026, 0.82881944444444455300, 0.65763888888888899498 },
{ /*156 f=15600 */ 1.23705736722489523238, 0.83200000000000007283, 0.66400000000000003464 },
{ /*157 f=15700 */ 1.23166256233223725403, 0.83515277777777785495, 0.67030555555555559888 },
{ /*158 f=15800 */ 1.22633850577920999747, 0.83827777777777778834, 0.67655555555555557667 },
{ /*159 f=15900 */ 1.22108448259722646156, 0.84137499999999998401, 0.68274999999999996803 },
{ /*160 f=16000 */ 1.21589978896765615879, 0.84444444444444444198, 0.68888888888888888395 },
{ /*161 f=16100 */ 1.21078373206587608379, 0.84748611111111116223, 0.69497222222222221344 },
{ /*162 f=16200 */ 1.20573562990809945994, 0.85050000000000003375, 0.70100000000000006750 },
{ /*163 f=16300 */ 1.20075481120093363607, 0.85348611111111116756, 0.70697222222222233512 },
{ /*164 f=16400 */ 1.19584061519362450099, 0.85644444444444445264, 0.71288888888888890527 },
{ /*165 f=16500 */ 1.19099239153293834370, 0.85937500000000000000, 0.71875000000000000000 },
{ /*166 f=16600 */ 1.18620950012063763879, 0.86227777777777769863, 0.72455555555555550828 },
{ /*167 f=16700 */ 1.18149131097350856834, 0.86515277777777777057, 0.73030555555555554115 },
{ /*168 f=16800 */ 1.17683720408589809203, 0.86799999999999999378, 0.73599999999999998757 },
{ /*169 f=16900 */ 1.17224656929471593436, 0.87081944444444447928, 0.74163888888888895856 },
{ /*170 f=17000 */ 1.16771880614686285327, 0.87361111111111111605, 0.74722222222222234311 },
{ /*171 f=17100 */ 1.16325332376904477805, 0.87637500000000001510, 0.75275000000000003020 },
{ /*172 f=17200 */ 1.15884954073993307055, 0.87911111111111117644, 0.75822222222222224186 },
{ /*173 f=17300 */ 1.15450688496463316213, 0.88181944444444448905, 0.76363888888888886708 },
{ /*174 f=17400 */ 1.15022479355142115409, 0.88450000000000006395, 0.76900000000000001688 },
{ /*175 f=17500 */ 1.14600271269071618541, 0.88715277777777779011, 0.77430555555555558023 },
{ /*176 f=17600 */ 1.14184009753624637895, 0.88977777777777777857, 0.77955555555555555713 },
{ /*177 f=17700 */ 1.13773641208837950067, 0.89237500000000002931, 0.78475000000000005862 },
{ /*178 f=17800 */ 1.13369112907957525493, 0.89494444444444454234, 0.78988888888888897366 },
{ /*179 f=17900 */ 1.12970372986193545728, 0.89748611111111120664, 0.79497222222222230226 },
{ /*180 f=18000 */ 1.12577370429680723163, 0.90000000000000002220, 0.80000000000000004441 },
{ /*181 f=18100 */ 1.12190055064641480698, 0.90248611111111110006, 0.80497222222222220012 },
{ /*182 f=18200 */ 1.11808377546748638487, 0.90494444444444444020, 0.80988888888888888040 },
{ /*183 f=18300 */ 1.11432289350684055051, 0.90737500000000004263, 0.81474999999999997424 },
{ /*184 f=18400 */ 1.11061742759890536014, 0.90977777777777779633, 0.81955555555555559266 },
{ /*185 f=18500 */ 1.10696690856513946244, 0.91215277777777781232, 0.82430555555555562464 },
{ /*186 f=18600 */ 1.10337087511532283557, 0.91450000000000009059, 0.82900000000000007017 },
{ /*187 f=18700 */ 1.09982887375069360303, 0.91681944444444440911, 0.83363888888888892925 },
{ /*188 f=18800 */ 1.09634045866889362486, 0.91911111111111110095, 0.83822222222222220189 },
{ /*189 f=18900 */ 1.09290519167070709905, 0.92137500000000005507, 0.84274999999999999911 },
{ /*190 f=19000 */ 1.08952264206855375939, 0.92361111111111116045, 0.84722222222222220989 },
{ /*191 f=19100 */ 1.08619238659671579761, 0.92581944444444441711, 0.85163888888888883422 },
{ /*192 f=19200 */ 1.08291400932327075424, 0.92800000000000004707, 0.85600000000000009415 },
{ /*193 f=19300 */ 1.07968710156370750752, 0.93015277777777782831, 0.86030555555555554559 },
{ /*194 f=19400 */ 1.07651126179619449630, 0.93227777777777776080, 0.86455555555555563263 },
{ /*195 f=19500 */ 1.07338609557848085885, 0.93437499999999995559, 0.86875000000000002220 },
{ /*196 f=19600 */ 1.07031121546640584086, 0.93644444444444441267, 0.87288888888888893636 },
{ /*197 f=19700 */ 1.06728624093398938300, 0.93848611111111113203, 0.87697222222222215304 },
{ /*198 f=19800 */ 1.06431079829508523638, 0.94050000000000000266, 0.88100000000000000533 },
{ /*199 f=19900 */ 1.06138452062656996056, 0.94248611111111113559, 0.88497222222222227117 },
{ /*200 f=20000 */ 1.05850704769305115072, 0.94444444444444441977, 0.88888888888888895057 },
{ /*201 f=20100 */ 1.05567802587306625028, 0.94637499999999996625, 0.89275000000000004352 },
{ /*202 f=20200 */ 1.05289710808675796017, 0.94827777777777777501, 0.89655555555555555003 },
{ /*203 f=20300 */ 1.05016395372499893313, 0.95015277777777784607, 0.90030555555555558112 },
{ /*204 f=20400 */ 1.04747822857995243062, 0.95199999999999995737, 0.90400000000000002576 },
{ /*205 f=20500 */ 1.04483960477704118652, 0.95381944444444444198, 0.90763888888888888395 },
{ /*206 f=20600 */ 1.04224776070831404162, 0.95561111111111107785, 0.91122222222222215571 },
{ /*207 f=20700 */ 1.03970238096718214926, 0.95737500000000008704, 0.91475000000000006306 },
{ /*208 f=20800 */ 1.03720315628451542622, 0.95911111111111113647, 0.91822222222222227295 },
{ /*209 f=20900 */ 1.03474978346607215940, 0.96081944444444444819, 0.92163888888888889639 },
{ /*210 f=21000 */ 1.03234196533125199835, 0.96250000000000002220, 0.92500000000000004441 },
{ /*211 f=21100 */ 1.02997941065314924103, 0.96415277777777785850, 0.92830555555555560598 },
{ /*212 f=21200 */ 1.02766183409989353414, 0.96577777777777784607, 0.93155555555555558112 },
{ /*213 f=21300 */ 1.02538895617725733800, 0.96737499999999998490, 0.93474999999999996980 },
{ /*214 f=21400 */ 1.02316050317251905355, 0.96894444444444438602, 0.93788888888888888307 },
{ /*215 f=21500 */ 1.02097620709956071750, 0.97048611111111116045, 0.94097222222222220989 },
{ /*216 f=21600 */ 1.01883580564519093947, 0.97199999999999997513, 0.94400000000000006128 },
{ /*217 f=21700 */ 1.01673904211666932262, 0.97348611111111105210, 0.94697222222222221522 },
{ /*218 f=21800 */ 1.01468566539042881480, 0.97494444444444439135, 0.94988888888888889372 },
{ /*219 f=21900 */ 1.01267542986197045529, 0.97637499999999999289, 0.95274999999999998579 },
{ /*220 f=22000 */ 1.01070809539692696433, 0.97777777777777774570, 0.95555555555555549141 },
{ /*221 f=22100 */ 1.00878342728327141664, 0.97915277777777776080, 0.95830555555555552161 },
{ /*222 f=22200 */ 1.00690119618466633611, 0.98050000000000003819, 0.96100000000000007638 },
{ /*223 f=22300 */ 1.00506117809493433768, 0.98181944444444446685, 0.96363888888888893369 },
{ /*224 f=22400 */ 1.00326315429364254506, 0.98311111111111104677, 0.96622222222222220456 },
{ /*225 f=22500 */ 1.00150691130278124419, 0.98437500000000000000, 0.96875000000000000000 },
{ /*226 f=22600 */ 0.99979224084453510724, 0.98561111111111110450, 0.97122222222222220900 },
{ /*227 f=22700 */ 0.99811893980012456051, 0.98681944444444447129, 0.97363888888888883155 },
{ /*228 f=22800 */ 0.99648681016971385471, 0.98799999999999998934, 0.97599999999999997868 },
{ /*229 f=22900 */ 0.99489565903337107144, 0.98915277777777776969, 0.97830555555555553937 },
{ /*230 f=23000 */ 0.99334529851306840875, 0.99027777777777781232, 0.98055555555555562464 },
{ /*231 f=23100 */ 0.99183554573571697244, 0.99137500000000000622, 0.98275000000000001243 },
{ /*232 f=23200 */ 0.99036622279721997497, 0.99244444444444446241, 0.98488888888888892481 },
{ /*233 f=23300 */ 0.98893715672753834678, 0.99348611111111106986, 0.98697222222222225074 },
{ /*234 f=23400 */ 0.98754817945675787971, 0.99449999999999993960, 0.98899999999999999023 },
{ /*235 f=23500 */ 0.98619912778215024218, 0.99548611111111107164, 0.99097222222222225430 },
{ /*236 f=23600 */ 0.98488984333621443223, 0.99644444444444446596, 0.99288888888888882089 },
{ /*237 f=23700 */ 0.98362017255569522689, 0.99737500000000001155, 0.99475000000000002309 },
{ /*238 f=23800 */ 0.98238996665156708143, 0.99827777777777781942, 0.99655555555555552782 },
{ /*239 f=23900 */ 0.98119908157997537401, 0.99915277777777777857, 0.99830555555555555713 },
{ /*240 f=24000 */ 0.98004737801412822318, 1.00000000000000000000, 1.00000000000000000000 }
};
static FLOAT_T moog_q180[241][3] = {
{ /* dummy entry */ 0, 0, 0},
{ /*  1 f=  100 */ 3.89578623984782090872, 0.00748611111111113781, -0.98502777777777772439 },
{ /*  2 f=  200 */ 3.85571479700759356390, 0.01494444444444442688, -0.97011111111111114624 },
{ /*  3 f=  300 */ 3.81620247006979873561, 0.02237499999999997824, -0.95525000000000004352 },
{ /*  4 f=  400 */ 3.77724050190308391350, 0.02977777777777779189, -0.94044444444444441622 },
{ /*  5 f=  500 */ 3.73882028820435685645, 0.03715277777777775681, -0.92569444444444448639 },
{ /*  6 f=  600 */ 3.70093337461988980408, 0.04449999999999998401, -0.91100000000000003197 },
{ /*  7 f=  700 */ 3.66357145392448035892, 0.05181944444444447351, -0.89636111111111105298 },
{ /*  8 f=  800 */ 3.62672636325743757979, 0.05911111111111111427, -0.88177777777777777146 },
{ /*  9 f=  900 */ 3.59039008141417648190, 0.06637500000000001732, -0.86724999999999996536 },
{ /* 10 f= 1000 */ 3.55455472619224854824, 0.07361111111111112715, -0.85277777777777774570 },
{ /* 11 f= 1100 */ 3.51921255179063363627, 0.08081944444444444375, -0.83836111111111111249 },
{ /* 12 f= 1200 */ 3.48435594626117506323, 0.08800000000000002265, -0.82399999999999995470 },
{ /* 13 f= 1300 */ 3.44997742901104764712, 0.09515277777777780832, -0.80969444444444438336 },
{ /* 14 f= 1400 */ 3.41606964835517246115, 0.10227777777777780077, -0.79544444444444439846 },
{ /* 15 f= 1500 */ 3.38262537911753424780, 0.10937500000000000000, -0.78125000000000000000 },
{ /* 16 f= 1600 */ 3.34963752028034367214, 0.11644444444444446152, -0.76711111111111107697 },
{ /* 17 f= 1700 */ 3.31709909268006430949, 0.12348611111111112981, -0.75302777777777774038 },
{ /* 18 f= 1800 */ 3.28500323674928695894, 0.13050000000000000488, -0.73899999999999999023 },
{ /* 19 f= 1900 */ 3.25334321030350448467, 0.13748611111111108674, -0.72502777777777782653 },
{ /* 20 f= 2000 */ 3.22211238637183550182, 0.14444444444444443088, -0.71111111111111113825 },
{ /* 21 f= 2100 */ 3.19130425107076831637, 0.15137499999999998179, -0.69725000000000003642 },
{ /* 22 f= 2200 */ 3.16091240152003116748, 0.15827777777777779500, -0.68344444444444441000 },
{ /* 23 f= 2300 */ 3.13093054379969615297, 0.16515277777777781498, -0.66969444444444437003 },
{ /* 24 f= 2400 */ 3.10135249094766018985, 0.17199999999999998623, -0.65600000000000002753 },
{ /* 25 f= 2500 */ 3.07217216099664947038, 0.17881944444444447528, -0.64236111111111104943 },
{ /* 26 f= 2600 */ 3.04338357504993473057, 0.18561111111111111560, -0.62877777777777776880 },
{ /* 27 f= 2700 */ 3.01498085539492866047, 0.19237500000000001821, -0.61524999999999996358 },
{ /* 28 f= 2800 */ 2.98695822365389984654, 0.19911111111111112759, -0.60177777777777774482 },
{ /* 29 f= 2900 */ 2.95930999897100699414, 0.20581944444444444375, -0.58836111111111111249 },
{ /* 30 f= 3000 */ 2.93203059623491313346, 0.21250000000000002220, -0.57499999999999995559 },
{ /* 31 f= 3100 */ 2.90511452433623684755, 0.21915277777777780743, -0.56169444444444438513 },
{ /* 32 f= 3200 */ 2.87855638445910999579, 0.22577777777777779944, -0.54844444444444440112 },
{ /* 33 f= 3300 */ 2.85235086840614382453, 0.23237499999999999822, -0.53525000000000000355 },
{ /* 34 f= 3400 */ 2.82649275695611024162, 0.23894444444444445930, -0.52211111111111108141 },
{ /* 35 f= 3500 */ 2.80097691825365258111, 0.24548611111111112715, -0.50902777777777774570 },
{ /* 36 f= 3600 */ 2.77579830623037748794, 0.25200000000000000178, -0.49599999999999999645 },
{ /* 37 f= 3700 */ 2.75095195905666667358, 0.25848611111111113869, -0.48302777777777772261 },
{ /* 38 f= 3800 */ 2.72643299762358992666, 0.26494444444444442688, -0.47011111111111114624 },
{ /* 39 f= 3900 */ 2.70223662405428211031, 0.27137500000000003286, -0.45724999999999998979 },
{ /* 40 f= 4000 */ 2.67835812024419439581, 0.27777777777777779011, -0.44444444444444447528 },
{ /* 41 f= 4100 */ 2.65479284642961710361, 0.28415277777777780965, -0.43169444444444443620 },
{ /* 42 f= 4200 */ 2.63153623978389417104, 0.29049999999999998046, -0.41900000000000003908 },
{ /* 43 f= 4300 */ 2.60858381304076747398, 0.29681944444444441356, -0.40636111111111111738 },
{ /* 44 f= 4400 */ 2.58593115314429056184, 0.30311111111111110894, -0.39377777777777778212 },
{ /* 45 f= 4500 */ 2.56357391992476957299, 0.30937500000000001110, -0.38124999999999997780 },
{ /* 46 f= 4600 */ 2.54150784480019975575, 0.31561111111111117555, -0.36877777777777770440 },
{ /* 47 f= 4700 */ 2.51972872950267934300, 0.32181944444444443576, -0.35636111111111112848 },
{ /* 48 f= 4800 */ 2.49823244482928563670, 0.32800000000000001377, -0.34399999999999997247 },
{ /* 49 f= 4900 */ 2.47701492941693057759, 0.33415277777777774304, -0.33169444444444445841 },
{ /* 50 f= 5000 */ 2.45607218854068154457, 0.34027777777777779011, -0.31944444444444441977 },
{ /* 51 f= 5100 */ 2.43540029293510684738, 0.34637499999999998845, -0.30725000000000002309 },
{ /* 52 f= 5200 */ 2.41499537763813698632, 0.35244444444444444908, -0.29511111111111110183 },
{ /* 53 f= 5300 */ 2.39485364085703134052, 0.35848611111111111649, -0.28302777777777776702 },
{ /* 54 f= 5400 */ 2.37497134285595867809, 0.36450000000000004619, -0.27099999999999996314 },
{ /* 55 f= 5500 */ 2.35534480486479047556, 0.37048611111111107164, -0.25902777777777780122 },
{ /* 56 f= 5600 */ 2.33597040800865451970, 0.37644444444444447040, -0.24711111111111108696 },
{ /* 57 f= 5700 */ 2.31684459225784644687, 0.38237500000000002043, -0.23525000000000001465 },
{ /* 58 f= 5800 */ 2.29796385539767733519, 0.38827777777777777724, -0.22344444444444441777 },
{ /* 59 f= 5900 */ 2.27932475201786433061, 0.39415277777777779633, -0.21169444444444446285 },
{ /* 60 f= 6000 */ 2.26092389252106906739, 0.40000000000000002220, -0.19999999999999998335 },
{ /* 61 f= 6100 */ 2.24275794215019708133, 0.40581944444444439934, -0.18836111111111114580 },
{ /* 62 f= 6200 */ 2.22482362003408784545, 0.41161111111111114980, -0.17677777777777770041 },
{ /* 63 f= 6300 */ 2.20711769825122372524, 0.41737500000000005151, -0.16524999999999995248 },
{ /* 64 f= 6400 */ 2.18963700091109503276, 0.42311111111111110450, -0.15377777777777776325 },
{ /* 65 f= 6500 */ 2.17237840325287479004, 0.42881944444444441977, -0.14236111111111113270 },
{ /* 66 f= 6600 */ 2.15533883076105459153, 0.43450000000000005285, -0.13099999999999992206 },
{ /* 67 f= 6700 */ 2.13851525829770361398, 0.44015277777777778168, -0.11969444444444440889 },
{ /* 68 f= 6800 */ 2.12190470925101859478, 0.44577777777777777279, -0.10844444444444444053 },
{ /* 69 f= 6900 */ 2.10550425469984592297, 0.45137499999999997069, -0.09725000000000004474 },
{ /* 70 f= 7000 */ 2.08931101259385432201, 0.45694444444444448639, -0.08611111111111104111 },
{ /* 71 f= 7100 */ 2.07332214694905037078, 0.46248611111111115335, -0.07502777777777774881 },
{ /* 72 f= 7200 */ 2.05753486705832777659, 0.46799999999999997158, -0.06400000000000001521 },
{ /* 73 f= 7300 */ 2.04194642671676662715, 0.47348611111111110761, -0.05302777777777782642 },
{ /* 74 f= 7400 */ 2.02655412346137087098, 0.47894444444444445041, -0.04211111111111105060 },
{ /* 75 f= 7500 */ 2.01135529782498112539, 0.48437500000000000000, -0.03124999999999997918 },
{ /* 76 f= 7600 */ 1.99634733260406571631, 0.48977777777777775636, -0.02044444444444446299 },
{ /* 77 f= 7700 */ 1.98152765214012482886, 0.49515277777777783053, -0.00969444444444435803 },
{ /* 78 f= 7800 */ 1.96689372161444597786, 0.50050000000000005596, 0.00100000000000004794 },
{ /* 79 f= 7900 */ 1.95244304635593368680, 0.50581944444444448816, 0.01163888888888889826 },
{ /* 80 f= 8000 */ 1.93817317116177045833, 0.51111111111111107164, 0.02222222222222219531 },
{ /* 81 f= 8100 */ 1.92408167963065346306, 0.51637500000000002842, 0.03275000000000007766 },
{ /* 82 f= 8200 */ 1.91016619350835958890, 0.52161111111111113647, 0.04322222222222225907 },
{ /* 83 f= 8300 */ 1.89642437204539815454, 0.52681944444444439579, 0.05363888888888888873 },
{ /* 84 f= 8400 */ 1.88285391136651769628, 0.53200000000000002842, 0.06399999999999995970 },
{ /* 85 f= 8500 */ 1.86945254385183701196, 0.53715277777777781232, 0.07430555555555562464 },
{ /* 86 f= 8600 */ 1.85621803752936775922, 0.54227777777777774748, 0.08455555555555557823 },
{ /* 87 f= 8700 */ 1.84314819547871500127, 0.54737499999999994493, 0.09474999999999998701 },
{ /* 88 f= 8800 */ 1.83024085524573343342, 0.55244444444444440467, 0.10488888888888885098 },
{ /* 89 f= 8900 */ 1.81749388826793278895, 0.55748611111111112670, 0.11497222222222228116 },
{ /* 90 f= 9000 */ 1.80490519931041593082, 0.56250000000000000000, 0.12500000000000002776 },
{ /* 91 f= 9100 */ 1.79247272591215223159, 0.56748611111111113559, 0.13497222222222221566 },
{ /* 92 f= 9200 */ 1.78019443784238906581, 0.57244444444444453346, 0.14488888888888898365 },
{ /* 93 f= 9300 */ 1.76806833656699602386, 0.57737499999999997158, 0.15475000000000005418 },
{ /* 94 f= 9400 */ 1.75609245472456199089, 0.58227777777777778301, 0.16455555555555556602 },
{ /* 95 f= 9500 */ 1.74426485561204991370, 0.58715277777777774570, 0.17430555555555554692 },
{ /* 96 f= 9600 */ 1.73258363267982851141, 0.59200000000000008171, 0.18400000000000008016 },
{ /* 97 f= 9700 */ 1.72104690903590307194, 0.59681944444444445796, 0.19363888888888891593 },
{ /* 98 f= 9800 */ 1.70965283695916236972, 0.60161111111111109651, 0.20322222222222222077 },
{ /* 99 f= 9900 */ 1.69839959742147894595, 0.60637499999999999734, 0.21274999999999996692 },
{ /*100 f=10000 */ 1.68728539961848533757, 0.61111111111111116045, 0.22222222222222229315 },
{ /*101 f=10100 */ 1.67630848050886704925, 0.61581944444444447484, 0.23163888888888892192 },
{ /*102 f=10200 */ 1.66546710436200329220, 0.62050000000000005151, 0.24099999999999999201 },
{ /*103 f=10300 */ 1.65475956231380383343, 0.62515277777777777946, 0.25030555555555550340 },
{ /*104 f=10400 */ 1.64418417193058208348, 0.62977777777777776969, 0.25955555555555559488 },
{ /*105 f=10500 */ 1.63373927678081320991, 0.63437500000000002220, 0.26875000000000004441 },
{ /*106 f=10600 */ 1.62342324601462650868, 0.63894444444444442599, 0.27788888888888885198 },
{ /*107 f=10700 */ 1.61323447395088881429, 0.64348611111111120309, 0.28697222222222229515 },
{ /*108 f=10800 */ 1.60317137967173373170, 0.64800000000000002043, 0.29600000000000004086 },
{ /*109 f=10900 */ 1.59323240662439347126, 0.65248611111111110006, 0.30497222222222225563 },
{ /*110 f=11000 */ 1.58341602223020294637, 0.65694444444444444198, 0.31388888888888888395 },
{ /*111 f=11100 */ 1.57372071750063424744, 0.66137500000000004619, 0.32275000000000009237 },
{ /*112 f=11200 */ 1.56414500666023270625, 0.66577777777777780166, 0.33155555555555560332 },
{ /*113 f=11300 */ 1.55468742677632487670, 0.67015277777777781942, 0.34030555555555558334 },
{ /*114 f=11400 */ 1.54534653739537253259, 0.67449999999999998845, 0.34899999999999997691 },
{ /*115 f=11500 */ 1.53612092018584522890, 0.67881944444444441977, 0.35763888888888895057 },
{ /*116 f=11600 */ 1.52700917858749352085, 0.68311111111111111338, 0.36622222222222222676 },
{ /*117 f=11700 */ 1.51800993746690360275, 0.68737499999999995826, 0.37474999999999997202 },
{ /*118 f=11800 */ 1.50912184277921057607, 0.69161111111111106542, 0.38322222222222218635 },
{ /*119 f=11900 */ 1.50034356123586443132, 0.69581944444444443487, 0.39163888888888892525 },
{ /*120 f=12000 */ 1.49167377997833061620, 0.69999999999999995559, 0.40000000000000002220 },
{ /*121 f=12100 */ 1.48311120625761705405, 0.70415277777777773860, 0.40830555555555553271 },
{ /*122 f=12200 */ 1.47465456711951992119, 0.70827777777777778390, 0.41655555555555551228 },
{ /*123 f=12300 */ 1.46630260909548360004, 0.71237499999999998046, 0.42474999999999996092 },
{ /*124 f=12400 */ 1.45805409789896822659, 0.71644444444444443931, 0.43288888888888898965 },
{ /*125 f=12500 */ 1.44990781812722735467, 0.72048611111111116045, 0.44097222222222232091 },
{ /*126 f=12600 */ 1.44186257296839470676, 0.72450000000000003286, 0.44900000000000006573 },
{ /*127 f=12700 */ 1.43391718391378075736, 0.72848611111111116756, 0.45697222222222227961 },
{ /*128 f=12800 */ 1.42607049047528788854, 0.73244444444444445352, 0.46488888888888890705 },
{ /*129 f=12900 */ 1.41832134990784619610, 0.73637500000000000178, 0.47275000000000000355 },
{ /*130 f=13000 */ 1.41066863693678135050, 0.74027777777777781232, 0.48055555555555551361 },
{ /*131 f=13100 */ 1.40311124349002480649, 0.74415277777777777413, 0.48830555555555549274 },
{ /*132 f=13200 */ 1.39564807843507465712, 0.74799999999999999822, 0.49600000000000010747 },
{ /*133 f=13300 */ 1.38827806732062652983, 0.75181944444444448461, 0.50363888888888896922 },
{ /*134 f=13400 */ 1.38100015212278437460, 0.75561111111111112226, 0.51122222222222224453 },
{ /*135 f=13500 */ 1.37381329099577276232, 0.75937500000000002220, 0.51875000000000004441 },
{ /*136 f=13600 */ 1.36671645802706609452, 0.76311111111111107341, 0.52622222222222225785 },
{ /*137 f=13700 */ 1.35970864299685834098, 0.76681944444444449793, 0.53363888888888888484 },
{ /*138 f=13800 */ 1.35278885114179270310, 0.77049999999999996270, 0.54099999999999992539 },
{ /*139 f=13900 */ 1.34595610292287326537, 0.77415277777777791179, 0.54830555555555571257 },
{ /*140 f=14000 */ 1.33920943379749246560, 0.77777777777777790114, 0.55555555555555569125 },
{ /*141 f=14100 */ 1.33254789399548689843, 0.78137500000000004174, 0.56275000000000008349 },
{ /*142 f=14200 */ 1.32597054829916194407, 0.78494444444444444464, 0.56988888888888888928 },
{ /*143 f=14300 */ 1.31947647582720861692, 0.78848611111111110983, 0.57697222222222221966 },
{ /*144 f=14400 */ 1.31306476982244513252, 0.79200000000000003730, 0.58399999999999996358 },
{ /*145 f=14500 */ 1.30673453744331236059, 0.79548611111111111605, 0.59097222222222223209 },
{ /*146 f=14600 */ 1.30048489955906321214, 0.79894444444444445708, 0.59788888888888880313 },
{ /*147 f=14700 */ 1.29431499054857357400, 0.80237500000000006040, 0.60475000000000012079 },
{ /*148 f=14800 */ 1.28822395810271661531, 0.80577777777777781498, 0.61155555555555562997 },
{ /*149 f=14900 */ 1.28221096303023252005, 0.80915277777777783186, 0.61830555555555555269 },
{ /*150 f=15000 */ 1.27627517906703968897, 0.81250000000000000000, 0.62500000000000000000 },
{ /*151 f=15100 */ 1.27041579268891724475, 0.81581944444444443043, 0.63163888888888886086 },
{ /*152 f=15200 */ 1.26463200292751221099, 0.81911111111111112315, 0.63822222222222224630 },
{ /*153 f=15300 */ 1.25892302118959986679, 0.82237499999999996714, 0.64474999999999993427 },
{ /*154 f=15400 */ 1.25328807107955308986, 0.82561111111111118444, 0.65122222222222236887 },
{ /*155 f=15500 */ 1.24772638822495851585, 0.82881944444444455300, 0.65763888888888899498 },
{ /*156 f=15600 */ 1.24223722010532244830, 0.83200000000000007283, 0.66400000000000003464 },
{ /*157 f=15700 */ 1.23681982588382433086, 0.83515277777777785495, 0.67030555555555559888 },
{ /*158 f=15800 */ 1.23147347624205072414, 0.83827777777777778834, 0.67655555555555557667 },
{ /*159 f=15900 */ 1.22619745321767159574, 0.84137499999999998401, 0.68274999999999996803 },
{ /*160 f=16000 */ 1.22099105004500119165, 0.84444444444444444198, 0.68888888888888888395 },
{ /*161 f=16100 */ 1.21585357099839486139, 0.84748611111111116223, 0.69497222222222221344 },
{ /*162 f=16200 */ 1.21078433123843787200, 0.85050000000000003375, 0.70100000000000006750 },
{ /*163 f=16300 */ 1.20578265666087269814, 0.85348611111111116756, 0.70697222222222233512 },
{ /*164 f=16400 */ 1.20084788374822548640, 0.85644444444444445264, 0.71288888888888890527 },
{ /*165 f=16500 */ 1.19597935942407840315, 0.85937500000000000000, 0.71875000000000000000 },
{ /*166 f=16600 */ 1.19117644090995100647, 0.86227777777777769863, 0.72455555555555550828 },
{ /*167 f=16700 */ 1.18643849558474046013, 0.86515277777777777057, 0.73030555555555554115 },
{ /*168 f=16800 */ 1.18176490084668239788, 0.86799999999999999378, 0.73599999999999998757 },
{ /*169 f=16900 */ 1.17715504397778869539, 0.87081944444444447928, 0.74163888888888895856 },
{ /*170 f=17000 */ 1.17260832201072129344, 0.87361111111111111605, 0.74722222222222234311 },
{ /*171 f=17100 */ 1.16812414159805832981, 0.87637500000000001510, 0.75275000000000003020 },
{ /*172 f=17200 */ 1.16370191888392282564, 0.87911111111111117644, 0.75822222222222224186 },
{ /*173 f=17300 */ 1.15934107937792263421, 0.88181944444444448905, 0.76363888888888886708 },
{ /*174 f=17400 */ 1.15504105783137278607, 0.88450000000000006395, 0.76900000000000001688 },
{ /*175 f=17500 */ 1.15080129811576004073, 0.88715277777777779011, 0.77430555555555558023 },
{ /*176 f=17600 */ 1.14662125310341211915, 0.88977777777777777857, 0.77955555555555555713 },
{ /*177 f=17700 */ 1.14250038455033853246, 0.89237500000000002931, 0.78475000000000005862 },
{ /*178 f=17800 */ 1.13843816298120525943, 0.89494444444444454234, 0.78988888888888897366 },
{ /*179 f=17900 */ 1.13443406757641196414, 0.89748611111111120664, 0.79497222222222230226 },
{ /*180 f=18000 */ 1.13048758606123378456, 0.90000000000000002220, 0.80000000000000004441 },
{ /*181 f=18100 */ 1.12659821459700038027, 0.90248611111111110006, 0.80497222222222220012 },
{ /*182 f=18200 */ 1.12276545767427560207, 0.90494444444444444020, 0.80988888888888888040 },
{ /*183 f=18300 */ 1.11898882800800758552, 0.90737500000000004263, 0.81474999999999997424 },
{ /*184 f=18400 */ 1.11526784643461884805, 0.90977777777777779633, 0.81955555555555559266 },
{ /*185 f=18500 */ 1.11160204181100641385, 0.91215277777777781232, 0.82430555555555562464 },
{ /*186 f=18600 */ 1.10799095091541843772, 0.91450000000000009059, 0.82900000000000007017 },
{ /*187 f=18700 */ 1.10443411835018578948, 0.91681944444444440911, 0.83363888888888892925 },
{ /*188 f=18800 */ 1.10093109644627062949, 0.91911111111111110095, 0.83822222222222220189 },
{ /*189 f=18900 */ 1.09748144516961243511, 0.92137500000000005507, 0.84274999999999999911 },
{ /*190 f=19000 */ 1.09408473202923994805, 0.92361111111111116045, 0.84722222222222220989 },
{ /*191 f=19100 */ 1.09074053198712150881, 0.92581944444444441711, 0.85163888888888883422 },
{ /*192 f=19200 */ 1.08744842736972868735, 0.92800000000000004707, 0.85600000000000009415 },
{ /*193 f=19300 */ 1.08420800778129144959, 0.93015277777777782831, 0.86030555555555554559 },
{ /*194 f=19400 */ 1.08101887001871088678, 0.93227777777777776080, 0.86455555555555563263 },
{ /*195 f=19500 */ 1.07788061798811307668, 0.93437499999999995559, 0.86875000000000002220 },
{ /*196 f=19600 */ 1.07479286262301632071, 0.93644444444444441267, 0.87288888888888893636 },
{ /*197 f=19700 */ 1.07175522180408799855, 0.93848611111111113203, 0.87697222222222215304 },
{ /*198 f=19800 */ 1.06876732028046905754, 0.94050000000000000266, 0.88100000000000000533 },
{ /*199 f=19900 */ 1.06582878959264215624, 0.94248611111111113559, 0.88497222222222227117 },
{ /*200 f=20000 */ 1.06293926799682347806, 0.94444444444444441977, 0.88888888888888895057 },
{ /*201 f=20100 */ 1.06009840039085401209, 0.94637499999999996625, 0.89275000000000004352 },
{ /*202 f=20200 */ 1.05730583824156987305, 0.94827777777777777501, 0.89655555555555555003 },
{ /*203 f=20300 */ 1.05456123951363323066, 0.95015277777777784607, 0.90030555555555558112 },
{ /*204 f=20400 */ 1.05186426859979920145, 0.95199999999999995737, 0.90400000000000002576 },
{ /*205 f=20500 */ 1.04921459625260227178, 0.95381944444444444198, 0.90763888888888888395 },
{ /*206 f=20600 */ 1.04661189951744204585, 0.95561111111111107785, 0.91122222222222215571 },
{ /*207 f=20700 */ 1.04405586166704766882, 0.95737500000000008704, 0.91475000000000006306 },
{ /*208 f=20800 */ 1.04154617213730560366, 0.95911111111111113647, 0.91822222222222227295 },
{ /*209 f=20900 */ 1.03908252646442811340, 0.96081944444444444819, 0.92163888888888889639 },
{ /*210 f=21000 */ 1.03666462622344890399, 0.96250000000000002220, 0.92500000000000004441 },
{ /*211 f=21100 */ 1.03429217896802616572, 0.96415277777777785850, 0.92830555555555560598 },
{ /*212 f=21200 */ 1.03196489817153702617, 0.96577777777777784607, 0.93155555555555558112 },
{ /*213 f=21300 */ 1.02968250316944587297, 0.96737499999999998490, 0.93474999999999996980 },
{ /*214 f=21400 */ 1.02744471910293033723, 0.96894444444444438602, 0.93788888888888888307 },
{ /*215 f=21500 */ 1.02525127686375139291, 0.97048611111111116045, 0.94097222222222220989 },
{ /*216 f=21600 */ 1.02310191304034980853, 0.97199999999999997513, 0.94400000000000006128 },
{ /*217 f=21700 */ 1.02099636986515163173, 0.97348611111111105210, 0.94697222222222221522 },
{ /*218 f=21800 */ 1.01893439516307582338, 0.97494444444444439135, 0.94988888888888889372 },
{ /*219 f=21900 */ 1.01691574230121939415, 0.97637499999999999289, 0.95274999999999998579 },
{ /*220 f=22000 */ 1.01494017013971538077, 0.97777777777777774570, 0.95555555555555549141 },
{ /*221 f=22100 */ 1.01300744298374190144, 0.97915277777777776080, 0.95830555555555552161 },
{ /*222 f=22200 */ 1.01111733053667540716, 0.98050000000000003819, 0.96100000000000007638 },
{ /*223 f=22300 */ 1.00926960785437191959, 0.98181944444444446685, 0.96363888888888893369 },
{ /*224 f=22400 */ 1.00746405530056382105, 0.98311111111111104677, 0.96622222222222220456 },
{ /*225 f=22500 */ 1.00570045850335865190, 0.98437500000000000000, 0.96875000000000000000 },
{ /*226 f=22600 */ 1.00397860831283214367, 0.98561111111111110450, 0.97122222222222220900 },
{ /*227 f=22700 */ 1.00229830075969816860, 0.98681944444444447129, 0.97363888888888883155 },
{ /*228 f=22800 */ 1.00065933701504894415, 0.98799999999999998934, 0.97599999999999997868 },
{ /*229 f=22900 */ 0.99906152335115072649, 0.98915277777777776969, 0.97830555555555553937 },
{ /*230 f=23000 */ 0.99750467110328588927, 0.99027777777777781232, 0.98055555555555562464 },
{ /*231 f=23100 */ 0.99598859663263261677, 0.99137500000000000622, 0.98275000000000001243 },
{ /*232 f=23200 */ 0.99451312129016711250, 0.99244444444444446241, 0.98488888888888892481 },
{ /*233 f=23300 */ 0.99307807138158399329, 0.99348611111111106986, 0.98697222222222225074 },
{ /*234 f=23400 */ 0.99168327813322043607, 0.99449999999999993960, 0.98899999999999999023 },
{ /*235 f=23500 */ 0.99032857765897919222, 0.99548611111111107164, 0.99097222222222225430 },
{ /*236 f=23600 */ 0.98901381092823736907, 0.99644444444444446596, 0.99288888888888882089 },
{ /*237 f=23700 */ 0.98773882373473365082, 0.99737500000000001155, 0.99475000000000002309 },
{ /*238 f=23800 */ 0.98650346666642763083, 0.99827777777777781942, 0.99655555555555552782 },
{ /*239 f=23900 */ 0.98530759507631882066, 0.99915277777777777857, 0.99830555555555555713 },
{ /*240 f=24000 */ 0.98415106905422111705, 1.00000000000000000000, 1.00000000000000000000 }
};
static FLOAT_T moog_q190[241][3] = {
{ /* dummy entry */ 0, 0, 0},
{ /*  1 f=  100 */ 3.90868975408344665468, 0.00748611111111113781, -0.98502777777777772439 },
{ /*  2 f=  200 */ 3.86848558773086592666, 0.01494444444444442688, -0.97011111111111114624 },
{ /*  3 f=  300 */ 3.82884238916877350789, 0.02237499999999997824, -0.95525000000000004352 },
{ /*  4 f=  400 */ 3.78975137226069147545, 0.02977777777777779189, -0.94044444444444441622 },
{ /*  5 f=  500 */ 3.75120390420459592917, 0.03715277777777775681, -0.92569444444444448639 },
{ /*  6 f=  600 */ 3.71319150264448483156, 0.04449999999999998401, -0.91100000000000003197 },
{ /*  7 f=  700 */ 3.67570583284019658521, 0.05181944444444447351, -0.89636111111111105298 },
{ /*  8 f=  800 */ 3.63873870489424167118, 0.05911111111111111427, -0.88177777777777777146 },
{ /*  9 f=  900 */ 3.60228207103442477077, 0.06637500000000001732, -0.86724999999999996536 },
{ /* 10 f= 1000 */ 3.56632802295108808366, 0.07361111111111112715, -0.85277777777777774570 },
{ /* 11 f= 1100 */ 3.53086878918778523939, 0.08081944444444444375, -0.83836111111111111249 },
{ /* 12 f= 1200 */ 3.49589673258427824365, 0.08800000000000002265, -0.82399999999999995470 },
{ /* 13 f= 1300 */ 3.46140434777073036088, 0.09515277777777780832, -0.80969444444444438336 },
{ /* 14 f= 1400 */ 3.42738425871201846107, 0.10227777777777780077, -0.79544444444444439846 },
{ /* 15 f= 1500 */ 3.39382921630110034883, 0.10937500000000000000, -0.78125000000000000000 },
{ /* 16 f= 1600 */ 3.36073209600039479739, 0.11644444444444446152, -0.76711111111111107697 },
{ /* 17 f= 1700 */ 3.32808589553017375451, 0.12348611111111112981, -0.75302777777777774038 },
{ /* 18 f= 1800 */ 3.29588373260296263467, 0.13050000000000000488, -0.73899999999999999023 },
{ /* 19 f= 1900 */ 3.26411884270297791844, 0.13748611111111108674, -0.72502777777777782653 },
{ /* 20 f= 2000 */ 3.23278457690967124805, 0.14444444444444443088, -0.71111111111111113825 },
{ /* 21 f= 2100 */ 3.20187439976442789202, 0.15137499999999998179, -0.69725000000000003642 },
{ /* 22 f= 2200 */ 3.17138188717953495299, 0.15827777777777779500, -0.68344444444444441000 },
{ /* 23 f= 2300 */ 3.14130072438851914995, 0.16515277777777781498, -0.66969444444444437003 },
{ /* 24 f= 2400 */ 3.11162470393699486237, 0.17199999999999998623, -0.65600000000000002753 },
{ /* 25 f= 2500 */ 3.08234772371316623207, 0.17881944444444447528, -0.64236111111111104943 },
{ /* 26 f= 2600 */ 3.05346378501716841924, 0.18561111111111111560, -0.62877777777777776880 },
{ /* 27 f= 2700 */ 3.02496699066842023029, 0.19237500000000001821, -0.61524999999999996358 },
{ /* 28 f= 2800 */ 2.99685154315020874094, 0.19911111111111112759, -0.60177777777777774482 },
{ /* 29 f= 2900 */ 2.96911174279072032078, 0.20581944444444444375, -0.58836111111111111249 },
{ /* 30 f= 3000 */ 2.94174198597976843672, 0.21250000000000002220, -0.57499999999999995559 },
{ /* 31 f= 3100 */ 2.91473676342047349763, 0.21915277777777780743, -0.56169444444444438513 },
{ /* 32 f= 3200 */ 2.88809065841515977269, 0.22577777777777779944, -0.54844444444444440112 },
{ /* 33 f= 3300 */ 2.86179834518477616001, 0.23237499999999999822, -0.53525000000000000355 },
{ /* 34 f= 3400 */ 2.83585458722113559205, 0.23894444444444445930, -0.52211111111111108141 },
{ /* 35 f= 3500 */ 2.81025423567129317703, 0.24548611111111112715, -0.50902777777777774570 },
{ /* 36 f= 3600 */ 2.78499222775340937730, 0.25200000000000000178, -0.49599999999999999645 },
{ /* 37 f= 3700 */ 2.76006358520343342278, 0.25848611111111113869, -0.48302777777777772261 },
{ /* 38 f= 3800 */ 2.73546341275198523491, 0.26494444444444442688, -0.47011111111111114624 },
{ /* 39 f= 3900 */ 2.71118689663080747465, 0.27137500000000003286, -0.45724999999999998979 },
{ /* 40 f= 4000 */ 2.68722930310817664790, 0.27777777777777779011, -0.44444444444444447528 },
{ /* 41 f= 4100 */ 2.66358597705268751454, 0.28415277777777780965, -0.43169444444444443620 },
{ /* 42 f= 4200 */ 2.64025234052481749814, 0.29049999999999998046, -0.41900000000000003908 },
{ /* 43 f= 4300 */ 2.61722389139571065542, 0.29681944444444441356, -0.40636111111111111738 },
{ /* 44 f= 4400 */ 2.59449620199261943299, 0.30311111111111110894, -0.39377777777777778212 },
{ /* 45 f= 4500 */ 2.57206491777046286629, 0.30937500000000001110, -0.38124999999999997780 },
{ /* 46 f= 4600 */ 2.54992575600895632348, 0.31561111111111117555, -0.36877777777777770440 },
{ /* 47 f= 4700 */ 2.52807450453481319386, 0.32181944444444443576, -0.35636111111111112848 },
{ /* 48 f= 4800 */ 2.50650702046848117277, 0.32800000000000001377, -0.34399999999999997247 },
{ /* 49 f= 4900 */ 2.48521922899493752368, 0.33415277777777774304, -0.33169444444444445841 },
{ /* 50 f= 5000 */ 2.46420712215803483502, 0.34027777777777779011, -0.31944444444444441977 },
{ /* 51 f= 5100 */ 2.44346675767793675149, 0.34637499999999998845, -0.30725000000000002309 },
{ /* 52 f= 5200 */ 2.42299425779115651380, 0.35244444444444444908, -0.29511111111111110183 },
{ /* 53 f= 5300 */ 2.40278580811275999096, 0.35848611111111111649, -0.28302777777777776702 },
{ /* 54 f= 5400 */ 2.38283765652026824355, 0.36450000000000004619, -0.27099999999999996314 },
{ /* 55 f= 5500 */ 2.36314611205883373657, 0.37048611111111107164, -0.25902777777777780122 },
{ /* 56 f= 5600 */ 2.34370754386724744478, 0.37644444444444447040, -0.24711111111111108696 },
{ /* 57 f= 5700 */ 2.32451838012437450587, 0.38237500000000002043, -0.23525000000000001465 },
{ /* 58 f= 5800 */ 2.30557510701558809885, 0.38827777777777777724, -0.22344444444444441777 },
{ /* 59 f= 5900 */ 2.28687426771881474608, 0.39415277777777779633, -0.21169444444444446285 },
{ /* 60 f= 6000 */ 2.26841246140978469725, 0.40000000000000002220, -0.19999999999999998335 },
{ /* 61 f= 6100 */ 2.25018634228611613679, 0.40581944444444439934, -0.18836111111111114580 },
{ /* 62 f= 6200 */ 2.23219261860983841927, 0.41161111111111114980, -0.17677777777777770041 },
{ /* 63 f= 6300 */ 2.21442805176800128208, 0.41737500000000005151, -0.16524999999999995248 },
{ /* 64 f= 6400 */ 2.19688945535100144113, 0.42311111111111110450, -0.15377777777777776325 },
{ /* 65 f= 6500 */ 2.17957369424826419291, 0.42881944444444441977, -0.14236111111111113270 },
{ /* 66 f= 6600 */ 2.16247768376095850229, 0.43450000000000005285, -0.13099999999999992206 },
{ /* 67 f= 6700 */ 2.14559838873137609383, 0.44015277777777778168, -0.11969444444444440889 },
{ /* 68 f= 6800 */ 2.12893282268866235185, 0.44577777777777777279, -0.10844444444444444053 },
{ /* 69 f= 6900 */ 2.11247804701057395604, 0.45137499999999997069, -0.09725000000000004474 },
{ /* 70 f= 7000 */ 2.09623117010093240609, 0.45694444444444448639, -0.08611111111111104111 },
{ /* 71 f= 7100 */ 2.08018934658247767189, 0.46248611111111115335, -0.07502777777777774881 },
{ /* 72 f= 7200 */ 2.06434977650480222522, 0.46799999999999997158, -0.06400000000000001521 },
{ /* 73 f= 7300 */ 2.04870970456708167973, 0.47348611111111110761, -0.05302777777777782642 },
{ /* 74 f= 7400 */ 2.03326641935529828231, 0.47894444444444445041, -0.04211111111111105060 },
{ /* 75 f= 7500 */ 2.01801725259368014420, 0.48437500000000000000, -0.03124999999999997918 },
{ /* 76 f= 7600 */ 2.00295957841006666555, 0.48977777777777775636, -0.02044444444444446299 },
{ /* 77 f= 7700 */ 1.98809081261493436621, 0.49515277777777783053, -0.00969444444444435803 },
{ /* 78 f= 7800 */ 1.97340841199381511473, 0.50050000000000005596, 0.00100000000000004794 },
{ /* 79 f= 7900 */ 1.95890987361283319679, 0.50581944444444448816, 0.01163888888888889826 },
{ /* 80 f= 8000 */ 1.94459273413711741796, 0.51111111111111107164, 0.02222222222222219531 },
{ /* 81 f= 8100 */ 1.93045456916182822660, 0.51637500000000002842, 0.03275000000000007766 },
{ /* 82 f= 8200 */ 1.91649299255555494170, 0.52161111111111113647, 0.04322222222222225907 },
{ /* 83 f= 8300 */ 1.90270565581584216730, 0.52681944444444439579, 0.05363888888888888873 },
{ /* 84 f= 8400 */ 1.88909024743660736156, 0.53200000000000002842, 0.06399999999999995970 },
{ /* 85 f= 8500 */ 1.87564449228722174290, 0.53715277777777781232, 0.07430555555555562464 },
{ /* 86 f= 8600 */ 1.86236615100302205228, 0.54227777777777774748, 0.08455555555555557823 },
{ /* 87 f= 8700 */ 1.84925301938703490201, 0.54737499999999994493, 0.09474999999999998701 },
{ /* 88 f= 8800 */ 1.83630292782269544105, 0.55244444444444440467, 0.10488888888888885098 },
{ /* 89 f= 8900 */ 1.82351374069734739614, 0.55748611111111112670, 0.11497222222222228116 },
{ /* 90 f= 9000 */ 1.81088335583631576675, 0.56250000000000000000, 0.12500000000000002776 },
{ /* 91 f= 9100 */ 1.79840970394734389615, 0.56748611111111113559, 0.13497222222222221566 },
{ /* 92 f= 9200 */ 1.78609074807520551431, 0.57244444444444453346, 0.14488888888888898365 },
{ /* 93 f= 9300 */ 1.77392448306628214283, 0.57737499999999997158, 0.15475000000000005418 },
{ /* 94 f= 9400 */ 1.76190893504292223071, 0.58227777777777778301, 0.16455555555555556602 },
{ /* 95 f= 9500 */ 1.75004216088739572577, 0.58715277777777774570, 0.17430555555555554692 },
{ /* 96 f= 9600 */ 1.73832224773525045869, 0.59200000000000008171, 0.18400000000000008016 },
{ /* 97 f= 9700 */ 1.72674731247790291810, 0.59681944444444445796, 0.19363888888888891593 },
{ /* 98 f= 9800 */ 1.71531550127427179220, 0.60161111111111109651, 0.20322222222222222077 },
{ /* 99 f= 9900 */ 1.70402498907129529293, 0.60637499999999999734, 0.21274999999999996692 },
{ /*100 f=10000 */ 1.69287397913315373899, 0.61111111111111116045, 0.22222222222222229315 },
{ /*101 f=10100 */ 1.68186070257903685921, 0.61581944444444447484, 0.23163888888888892192 },
{ /*102 f=10200 */ 1.67098341792928484217, 0.62050000000000005151, 0.24099999999999999201 },
{ /*103 f=10300 */ 1.66024041065975636045, 0.62515277777777777946, 0.25030555555555550340 },
{ /*104 f=10400 */ 1.64962999276425437145, 0.62977777777777776969, 0.25955555555555559488 },
{ /*105 f=10500 */ 1.63915050232486803061, 0.63437500000000002220, 0.26875000000000004441 },
{ /*106 f=10600 */ 1.62880030309007151068, 0.63894444444444442599, 0.27788888888888885198 },
{ /*107 f=10700 */ 1.61857778406043961716, 0.64348611111111120309, 0.28697222222222229515 },
{ /*108 f=10800 */ 1.60848135908183342835, 0.64800000000000002043, 0.29600000000000004086 },
{ /*109 f=10900 */ 1.59850946644591518364, 0.65248611111111110006, 0.30497222222222225563 },
{ /*110 f=11000 */ 1.58866056849785541871, 0.65694444444444444198, 0.31388888888888888395 },
{ /*111 f=11100 */ 1.57893315125109645614, 0.66137500000000004619, 0.32275000000000009237 },
{ /*112 f=11200 */ 1.56932572400903969090, 0.66577777777777780166, 0.33155555555555560332 },
{ /*113 f=11300 */ 1.55983681899352744082, 0.67015277777777781942, 0.34030555555555558334 },
{ /*114 f=11400 */ 1.55046499097999102013, 0.67449999999999998845, 0.34899999999999997691 },
{ /*115 f=11500 */ 1.54120881693914202337, 0.67881944444444441977, 0.35763888888888895057 },
{ /*116 f=11600 */ 1.53206689568508380717, 0.68311111111111111338, 0.36622222222222222676 },
{ /*117 f=11700 */ 1.52303784752972326544, 0.68737499999999995826, 0.37474999999999997202 },
{ /*118 f=11800 */ 1.51412031394336676904, 0.69161111111111106542, 0.38322222222222218635 },
{ /*119 f=11900 */ 1.50531295722138258597, 0.69581944444444443487, 0.39163888888888892525 },
{ /*120 f=12000 */ 1.49661446015682320088, 0.69999999999999995559, 0.40000000000000002220 },
{ /*121 f=12100 */ 1.48802352571888918398, 0.70415277777777773860, 0.40830555555555553271 },
{ /*122 f=12200 */ 1.47953887673713402329, 0.70827777777777778390, 0.41655555555555551228 },
{ /*123 f=12300 */ 1.47115925559129800959, 0.71237499999999998046, 0.42474999999999996092 },
{ /*124 f=12400 */ 1.46288342390667214232, 0.71644444444444443931, 0.43288888888888898965 },
{ /*125 f=12500 */ 1.45471016225488680718, 0.72048611111111116045, 0.44097222222222232091 },
{ /*126 f=12600 */ 1.44663826986002908015, 0.72450000000000003286, 0.44900000000000006573 },
{ /*127 f=12700 */ 1.43866656430998607341, 0.72848611111111116756, 0.45697222222222227961 },
{ /*128 f=12800 */ 1.43079388127292372879, 0.73244444444444445352, 0.46488888888888890705 },
{ /*129 f=12900 */ 1.42301907421880402538, 0.73637500000000000178, 0.47275000000000000355 },
{ /*130 f=13000 */ 1.41534101414584911893, 0.74027777777777781232, 0.48055555555555551361 },
{ /*131 f=13100 */ 1.40775858931186514944, 0.74415277777777777413, 0.48830555555555549274 },
{ /*132 f=13200 */ 1.40027070497033179208, 0.74799999999999999822, 0.49600000000000010747 },
{ /*133 f=13300 */ 1.39287628311117717139, 0.75181944444444448461, 0.50363888888888896922 },
{ /*134 f=13400 */ 1.38557426220614798851, 0.75561111111111112226, 0.51122222222222224453 },
{ /*135 f=13500 */ 1.37836359695869647979, 0.75937500000000002220, 0.51875000000000004441 },
{ /*136 f=13600 */ 1.37124325805829805347, 0.76311111111111107341, 0.52622222222222225785 },
{ /*137 f=13700 */ 1.36421223193912499738, 0.76681944444444449793, 0.53363888888888888484 },
{ /*138 f=13800 */ 1.35726952054299321304, 0.77049999999999996270, 0.54099999999999992539 },
{ /*139 f=13900 */ 1.35041414108650492665, 0.77415277777777791179, 0.54830555555555571257 },
{ /*140 f=14000 */ 1.34364512583232165177, 0.77777777777777790114, 0.55555555555555569125 },
{ /*141 f=14100 */ 1.33696152186447791976, 0.78137500000000004174, 0.56275000000000008349 },
{ /*142 f=14200 */ 1.33036239086767693607, 0.78494444444444444464, 0.56988888888888888928 },
{ /*143 f=14300 */ 1.32384680891049266727, 0.78848611111111110983, 0.57697222222222221966 },
{ /*144 f=14400 */ 1.31741386623240730458, 0.79200000000000003730, 0.58399999999999996358 },
{ /*145 f=14500 */ 1.31106266703461726841, 0.79548611111111111605, 0.59097222222222223209 },
{ /*146 f=14600 */ 1.30479232927454269486, 0.79894444444444445708, 0.59788888888888880313 },
{ /*147 f=14700 */ 1.29860198446397379080, 0.80237500000000006040, 0.60475000000000012079 },
{ /*148 f=14800 */ 1.29249077747078899847, 0.80577777777777781498, 0.61155555555555562997 },
{ /*149 f=14900 */ 1.28645786632418301920, 0.80915277777777783186, 0.61830555555555555269 },
{ /*150 f=15000 */ 1.28050242202334474406, 0.81250000000000000000, 0.62500000000000000000 },
{ /*151 f=15100 */ 1.27462362834952203094, 0.81581944444444443043, 0.63163888888888886086 },
{ /*152 f=15200 */ 1.26882068168141626252, 0.81911111111111112315, 0.63822222222222224630 },
{ /*153 f=15300 */ 1.26309279081384673304, 0.82237499999999996714, 0.64474999999999993427 },
{ /*154 f=15400 */ 1.25743917677963046309, 0.82561111111111118444, 0.65122222222222236887 },
{ /*155 f=15500 */ 1.25185907267462059878, 0.82881944444444455300, 0.65763888888888899498 },
{ /*156 f=15600 */ 1.24635172348584655211, 0.83200000000000007283, 0.66400000000000003464 },
{ /*157 f=15700 */ 1.24091638592270858688, 0.83515277777777785495, 0.67030555555555559888 },
{ /*158 f=15800 */ 1.23555232825116534379, 0.83827777777777778834, 0.67655555555555557667 },
{ /*159 f=15900 */ 1.23025883013087233842, 0.84137499999999998401, 0.68274999999999996803 },
{ /*160 f=16000 */ 1.22503518245521347829, 0.84444444444444444198, 0.68888888888888888395 },
{ /*161 f=16100 */ 1.21988068719418163433, 0.84748611111111116223, 0.69497222222222221344 },
{ /*162 f=16200 */ 1.21479465724005586402, 0.85050000000000003375, 0.70100000000000006750 },
{ /*163 f=16300 */ 1.20977641625582998941, 0.85348611111111116756, 0.70697222222222233512 },
{ /*164 f=16400 */ 1.20482529852634523415, 0.85644444444444445264, 0.71288888888888890527 },
{ /*165 f=16500 */ 1.19994064881208295503, 0.85937500000000000000, 0.71875000000000000000 },
{ /*166 f=16600 */ 1.19512182220556950618, 0.86227777777777769863, 0.72455555555555550828 },
{ /*167 f=16700 */ 1.19036818399035237981, 0.86515277777777777057, 0.73030555555555554115 },
{ /*168 f=16800 */ 1.18567910950250277047, 0.86799999999999999378, 0.73599999999999998757 },
{ /*169 f=16900 */ 1.18105398399460526093, 0.87081944444444447928, 0.74163888888888895856 },
{ /*170 f=17000 */ 1.17649220250219022077, 0.87361111111111111605, 0.74722222222222234311 },
{ /*171 f=17100 */ 1.17199316971256739528, 0.87637500000000001510, 0.75275000000000003020 },
{ /*172 f=17200 */ 1.16755629983602826627, 0.87911111111111117644, 0.75822222222222224186 },
{ /*173 f=17300 */ 1.16318101647936966714, 0.88181944444444448905, 0.76363888888888886708 },
{ /*174 f=17400 */ 1.15886675252170601169, 0.88450000000000006395, 0.76900000000000001688 },
{ /*175 f=17500 */ 1.15461294999253083482, 0.88715277777777779011, 0.77430555555555558023 },
{ /*176 f=17600 */ 1.15041905995199034152, 0.88977777777777777857, 0.77955555555555555713 },
{ /*177 f=17700 */ 1.14628454237333787802, 0.89237500000000002931, 0.78475000000000005862 },
{ /*178 f=17800 */ 1.14220886602752558225, 0.89494444444444454234, 0.78988888888888897366 },
{ /*179 f=17900 */ 1.13819150836990967690, 0.89748611111111120664, 0.79497222222222230226 },
{ /*180 f=18000 */ 1.13423195542902277566, 0.90000000000000002220, 0.80000000000000004441 },
{ /*181 f=18100 */ 1.13032970169739410693, 0.90248611111111110006, 0.80497222222222220012 },
{ /*182 f=18200 */ 1.12648425002437502229, 0.90494444444444444020, 0.80988888888888888040 },
{ /*183 f=18300 */ 1.12269511151094203427, 0.90737500000000004263, 0.81474999999999997424 },
{ /*184 f=18400 */ 1.11896180540644563095, 0.90977777777777779633, 0.81955555555555559266 },
{ /*185 f=18500 */ 1.11528385900727533553, 0.91215277777777781232, 0.82430555555555562464 },
{ /*186 f=18600 */ 1.11166080755740925845, 0.91450000000000009059, 0.82900000000000007017 },
{ /*187 f=18700 */ 1.10809219415082305105, 0.91681944444444440911, 0.83363888888888892925 },
{ /*188 f=18800 */ 1.10457756963572162334, 0.91911111111111110095, 0.83822222222222220189 },
{ /*189 f=18900 */ 1.10111649252057652859, 0.92137500000000005507, 0.84274999999999999911 },
{ /*190 f=19000 */ 1.09770852888193171104, 0.92361111111111116045, 0.84722222222222220989 },
{ /*191 f=19100 */ 1.09435325227395607861, 0.92581944444444441711, 0.85163888888888883422 },
{ /*192 f=19200 */ 1.09105024363971536694, 0.92800000000000004707, 0.85600000000000009415 },
{ /*193 f=19300 */ 1.08779909122413753764, 0.93015277777777782831, 0.86030555555555554559 },
{ /*194 f=19400 */ 1.08459939048864595357, 0.93227777777777776080, 0.86455555555555563263 },
{ /*195 f=19500 */ 1.08145074402743546216, 0.93437499999999995559, 0.86875000000000002220 },
{ /*196 f=19600 */ 1.07835276148536940433, 0.93644444444444441267, 0.87288888888888893636 },
{ /*197 f=19700 */ 1.07530505947747001549, 0.93848611111111113203, 0.87697222222222215304 },
{ /*198 f=19800 */ 1.07230726150998290080, 0.94050000000000000266, 0.88100000000000000533 },
{ /*199 f=19900 */ 1.06935899790298960532, 0.94248611111111113559, 0.88497222222222227117 },
{ /*200 f=20000 */ 1.06645990571454851725, 0.94444444444444441977, 0.88888888888888895057 },
{ /*201 f=20100 */ 1.06360962866634123358, 0.94637499999999996625, 0.89275000000000004352 },
{ /*202 f=20200 */ 1.06080781707080196163, 0.94827777777777777501, 0.89655555555555555003 },
{ /*203 f=20300 */ 1.05805412775971285910, 0.95015277777777784607, 0.90030555555555558112 },
{ /*204 f=20400 */ 1.05534822401424044358, 0.95199999999999995737, 0.90400000000000002576 },
{ /*205 f=20500 */ 1.05268977549639486391, 0.95381944444444444198, 0.90763888888888888395 },
{ /*206 f=20600 */ 1.05007845818189426979, 0.95561111111111107785, 0.91122222222222215571 },
{ /*207 f=20700 */ 1.04751395429441296336, 0.95737500000000008704, 0.91475000000000006306 },
{ /*208 f=20800 */ 1.04499595224119556924, 0.95911111111111113647, 0.91822222222222227295 },
{ /*209 f=20900 */ 1.04252414655001768296, 0.96081944444444444819, 0.92163888888888889639 },
{ /*210 f=21000 */ 1.04009823780747834299, 0.96250000000000002220, 0.92500000000000004441 },
{ /*211 f=21100 */ 1.03771793259860301006, 0.96415277777777785850, 0.92830555555555560598 },
{ /*212 f=21200 */ 1.03538294344774373101, 0.96577777777777784607, 0.93155555555555558112 },
{ /*213 f=21300 */ 1.03309298876075517093, 0.96737499999999998490, 0.93474999999999996980 },
{ /*214 f=21400 */ 1.03084779276843541140, 0.96894444444444438602, 0.93788888888888888307 },
{ /*215 f=21500 */ 1.02864708547121286308, 0.97048611111111116045, 0.94097222222222220989 },
{ /*216 f=21600 */ 1.02649060258506352739, 0.97199999999999997513, 0.94400000000000006128 },
{ /*217 f=21700 */ 1.02437808548864328628, 0.97348611111111105210, 0.94697222222222221522 },
{ /*218 f=21800 */ 1.02230928117162367386, 0.97494444444444439135, 0.94988888888888889372 },
{ /*219 f=21900 */ 1.02028394218421114559, 0.97637499999999999289, 0.95274999999999998579 },
{ /*220 f=22000 */ 1.01830182658784185179, 0.97777777777777774570, 0.95555555555555549141 },
{ /*221 f=22100 */ 1.01636269790703193117, 0.97915277777777776080, 0.95830555555555552161 },
{ /*222 f=22200 */ 1.01446632508237666315, 0.98050000000000003819, 0.96100000000000007638 },
{ /*223 f=22300 */ 1.01261248242467738478, 0.98181944444444446685, 0.96363888888888893369 },
{ /*224 f=22400 */ 1.01080094957019395174, 0.98311111111111104677, 0.96622222222222220456 },
{ /*225 f=22500 */ 1.00903151143699698622, 0.98437500000000000000, 0.96875000000000000000 },
{ /*226 f=22600 */ 1.00730395818242213224, 0.98561111111111110450, 0.97122222222222220900 },
{ /*227 f=22700 */ 1.00561808516160144933, 0.98681944444444447129, 0.97363888888888883155 },
{ /*228 f=22800 */ 1.00397369288707172252, 0.98799999999999998934, 0.97599999999999997868 },
{ /*229 f=22900 */ 1.00237058698943992674, 0.98915277777777776969, 0.97830555555555553937 },
{ /*230 f=23000 */ 1.00080857817909807395, 0.99027777777777781232, 0.98055555555555562464 },
{ /*231 f=23100 */ 0.99928748220898089283, 0.99137500000000000622, 0.98275000000000001243 },
{ /*232 f=23200 */ 0.99780711983834857737, 0.99244444444444446241, 0.98488888888888892481 },
{ /*233 f=23300 */ 0.99636731679759038549, 0.99348611111111106986, 0.98697222222222225074 },
{ /*234 f=23400 */ 0.99496790375403576512, 0.99449999999999993960, 0.98899999999999999023 },
{ /*235 f=23500 */ 0.99360871627876878875, 0.99548611111111107164, 0.99097222222222225430 },
{ /*236 f=23600 */ 0.99228959481442957635, 0.99644444444444446596, 0.99288888888888882089 },
{ /*237 f=23700 */ 0.99101038464399937578, 0.99737500000000001155, 0.99475000000000002309 },
{ /*238 f=23800 */ 0.98977093586055919783, 0.99827777777777781942, 0.99655555555555552782 },
{ /*239 f=23900 */ 0.98857110333801290203, 0.99915277777777777857, 0.99830555555555555713 },
{ /*240 f=24000 */ 0.98741074670276773873, 1.00000000000000000000, 1.00000000000000000000 }
};
static FLOAT_T moog_q200[241][3] = {
{ /* dummy entry */ 0, 0, 0},
{ /*  1 f=  100 */ 3.91893937973280293008, 0.00748611111111113781, -0.98502777777777772439 },
{ /*  2 f=  200 */ 3.87862978734730967645, 0.01494444444444442688, -0.97011111111111114624 },
{ /*  3 f=  300 */ 3.83888263375927030197, 0.02237499999999997824, -0.95525000000000004352 },
{ /*  4 f=  400 */ 3.79968910979261664806, 0.02977777777777779189, -0.94044444444444441622 },
{ /*  5 f=  500 */ 3.76104056000781827862, 0.03715277777777775681, -0.92569444444444448639 },
{ /*  6 f=  600 */ 3.72292847980587637835, 0.04449999999999998401, -0.91100000000000003197 },
{ /*  7 f=  700 */ 3.68534451259072115548, 0.05181944444444447351, -0.89636111111111105298 },
{ /*  8 f=  800 */ 3.64828044698876974294, 0.05911111111111111427, -0.88177777777777777146 },
{ /*  9 f=  900 */ 3.61172821412442512923, 0.06637500000000001732, -0.86724999999999996536 },
{ /* 10 f= 1000 */ 3.57567988495033484142, 0.07361111111111112715, -0.85277777777777774570 },
{ /* 11 f= 1100 */ 3.54012766763122366243, 0.08081944444444444375, -0.83836111111111111249 },
{ /* 12 f= 1200 */ 3.50506390498018483015, 0.08800000000000002265, -0.82399999999999995470 },
{ /* 13 f= 1300 */ 3.47048107194630350847, 0.09515277777777780832, -0.80969444444444438336 },
{ /* 14 f= 1400 */ 3.43637177315252762000, 0.10227777777777780077, -0.79544444444444439846 },
{ /* 15 f= 1500 */ 3.40272874048272511160, 0.10937500000000000000, -0.78125000000000000000 },
{ /* 16 f= 1600 */ 3.36954483071687960205, 0.11644444444444446152, -0.76711111111111107697 },
{ /* 17 f= 1700 */ 3.33681302321342121431, 0.12348611111111112981, -0.75302777777777774038 },
{ /* 18 f= 1800 */ 3.30452641763768317773, 0.13050000000000000488, -0.73899999999999999023 },
{ /* 19 f= 1900 */ 3.27267823173552097060, 0.13748611111111108674, -0.72502777777777782653 },
{ /* 20 f= 2000 */ 3.24126179915114498442, 0.14444444444444443088, -0.71111111111111113825 },
{ /* 21 f= 2100 */ 3.21027056728822701714, 0.15137499999999998179, -0.69725000000000003642 },
{ /* 22 f= 2200 */ 3.17969809521338575564, 0.15827777777777779500, -0.68344444444444441000 },
{ /* 23 f= 2300 */ 3.14953805160114796990, 0.16515277777777781498, -0.66969444444444437003 },
{ /* 24 f= 2400 */ 3.11978421271952832683, 0.17199999999999998623, -0.65600000000000002753 },
{ /* 25 f= 2500 */ 3.09043046045536984323, 0.17881944444444447528, -0.64236111111111104943 },
{ /* 26 f= 2600 */ 3.06147078037861808397, 0.18561111111111111560, -0.62877777777777776880 },
{ /* 27 f= 2700 */ 3.03289925984471420151, 0.19237500000000001821, -0.61524999999999996358 },
{ /* 28 f= 2800 */ 3.00471008613431100898, 0.19911111111111112759, -0.60177777777777774482 },
{ /* 29 f= 2900 */ 2.97689754462953803937, 0.20581944444444444375, -0.58836111111111111249 },
{ /* 30 f= 3000 */ 2.94945601702605131322, 0.21250000000000002220, -0.57499999999999995559 },
{ /* 31 f= 3100 */ 2.92237997958012529764, 0.21915277777777780743, -0.56169444444444438513 },
{ /* 32 f= 3200 */ 2.89566400139006141501, 0.22577777777777779944, -0.54844444444444440112 },
{ /* 33 f= 3300 */ 2.86930274271119722940, 0.23237499999999999822, -0.53525000000000000355 },
{ /* 34 f= 3400 */ 2.84329095330382575213, 0.23894444444444445930, -0.52211111111111108141 },
{ /* 35 f= 3500 */ 2.81762347081333963672, 0.24548611111111112715, -0.50902777777777774570 },
{ /* 36 f= 3600 */ 2.79229521918193546171, 0.25200000000000000178, -0.49599999999999999645 },
{ /* 37 f= 3700 */ 2.76730120709122839884, 0.25848611111111113869, -0.48302777777777772261 },
{ /* 38 f= 3800 */ 2.74263652643513866636, 0.26494444444444442688, -0.47011111111111114624 },
{ /* 39 f= 3900 */ 2.71829635082242582200, 0.27137500000000003286, -0.45724999999999998979 },
{ /* 40 f= 4000 */ 2.69427593410826160536, 0.27777777777777779011, -0.44444444444444447528 },
{ /* 41 f= 4100 */ 2.67057060895424580593, 0.28415277777777780965, -0.43169444444444443620 },
{ /* 42 f= 4200 */ 2.64717578541627895916, 0.29049999999999998046, -0.41900000000000003908 },
{ /* 43 f= 4300 */ 2.62408694955972388030, 0.29681944444444441356, -0.40636111111111111738 },
{ /* 44 f= 4400 */ 2.60129966210129648374, 0.30311111111111110894, -0.39377777777777778212 },
{ /* 45 f= 4500 */ 2.57880955707713788172, 0.30937500000000001110, -0.38124999999999997780 },
{ /* 46 f= 4600 */ 2.55661234053653085851, 0.31561111111111117555, -0.36877777777777770440 },
{ /* 47 f= 4700 */ 2.53470378926074779713, 0.32181944444444443576, -0.35636111111111112848 },
{ /* 48 f= 4800 */ 2.51307974950650336865, 0.32800000000000001377, -0.34399999999999997247 },
{ /* 49 f= 4900 */ 2.49173613577352437432, 0.33415277777777774304, -0.33169444444444445841 },
{ /* 50 f= 5000 */ 2.47066892959573447541, 0.34027777777777779011, -0.31944444444444441977 },
{ /* 51 f= 5100 */ 2.44987417835558973778, 0.34637499999999998845, -0.30725000000000002309 },
{ /* 52 f= 5200 */ 2.42934799412107471639, 0.35244444444444444908, -0.29511111111111110183 },
{ /* 53 f= 5300 */ 2.40908655250492165223, 0.35848611111111111649, -0.28302777777777776702 },
{ /* 54 f= 5400 */ 2.38908609154558781995, 0.36450000000000004619, -0.27099999999999996314 },
{ /* 55 f= 5500 */ 2.36934291060955803943, 0.37048611111111107164, -0.25902777777777780122 },
{ /* 56 f= 5600 */ 2.34985336931453847598, 0.37644444444444447040, -0.24711111111111108696 },
{ /* 57 f= 5700 */ 2.33061388647312783817, 0.38237500000000002043, -0.23525000000000001465 },
{ /* 58 f= 5800 */ 2.31162093905654186798, 0.38827777777777777724, -0.22344444444444441777 },
{ /* 59 f= 5900 */ 2.29287106117799766025, 0.39415277777777779633, -0.21169444444444446285 },
{ /* 60 f= 6000 */ 2.27436084309535990755, 0.40000000000000002220, -0.19999999999999998335 },
{ /* 61 f= 6100 */ 2.25608693023266049238, 0.40581944444444439934, -0.18836111111111114580 },
{ /* 62 f= 6200 */ 2.23804602222011572721, 0.41161111111111114980, -0.17677777777777770041 },
{ /* 63 f= 6300 */ 2.22023487195226998381, 0.41737500000000005151, -0.16524999999999995248 },
{ /* 64 f= 6400 */ 2.20265028466390377915, 0.42311111111111110450, -0.15377777777777776325 },
{ /* 65 f= 6500 */ 2.18528911702334882605, 0.42881944444444441977, -0.14236111111111113270 },
{ /* 66 f= 6600 */ 2.16814827624287209673, 0.43450000000000005285, -0.13099999999999992206 },
{ /* 67 f= 6700 */ 2.15122471920577185145, 0.44015277777777778168, -0.11969444444444440889 },
{ /* 68 f= 6800 */ 2.13451545160987299354, 0.44577777777777777279, -0.10844444444444444053 },
{ /* 69 f= 6900 */ 2.11801752712708113435, 0.45137499999999997069, -0.09725000000000004474 },
{ /* 70 f= 7000 */ 2.10172804657868317335, 0.45694444444444448639, -0.08611111111111104111 },
{ /* 71 f= 7100 */ 2.08564415712608131059, 0.46248611111111115335, -0.07502777777777774881 },
{ /* 72 f= 7200 */ 2.06976305147665229356, 0.46799999999999997158, -0.06400000000000001521 },
{ /* 73 f= 7300 */ 2.05408196710443924360, 0.47348611111111110761, -0.05302777777777782642 },
{ /* 74 f= 7400 */ 2.03859818548537452543, 0.47894444444444445041, -0.04211111111111105060 },
{ /* 75 f= 7500 */ 2.02330903134675699206, 0.48437500000000000000, -0.03124999999999997918 },
{ /* 76 f= 7600 */ 2.00821187193068917409, 0.48977777777777775636, -0.02044444444444446299 },
{ /* 77 f= 7700 */ 1.99330411627121439899, 0.49515277777777783053, -0.00969444444444435803 },
{ /* 78 f= 7800 */ 1.97858321448487894934, 0.50050000000000005596, 0.00100000000000004794 },
{ /* 79 f= 7900 */ 1.96404665707444792133, 0.50581944444444448816, 0.01163888888888889826 },
{ /* 80 f= 8000 */ 1.94969197424553009057, 0.51111111111111107164, 0.02222222222222219531 },
{ /* 81 f= 8100 */ 1.93551673523584999437, 0.51637500000000002842, 0.03275000000000007766 },
{ /* 82 f= 8200 */ 1.92151854765692542415, 0.52161111111111113647, 0.04322222222222225907 },
{ /* 83 f= 8300 */ 1.90769505684790185995, 0.52681944444444439579, 0.05363888888888888873 },
{ /* 84 f= 8400 */ 1.89404394524131203248, 0.53200000000000002842, 0.06399999999999995970 },
{ /* 85 f= 8500 */ 1.88056293174052879813, 0.53715277777777781232, 0.07430555555555562464 },
{ /* 86 f= 8600 */ 1.86724977110867818020, 0.54227777777777774748, 0.08455555555555557823 },
{ /* 87 f= 8700 */ 1.85410225336879497249, 0.54737499999999994493, 0.09474999999999998701 },
{ /* 88 f= 8800 */ 1.84111820321500219144, 0.55244444444444440467, 0.10488888888888885098 },
{ /* 89 f= 8900 */ 1.82829547943449810532, 0.55748611111111112670, 0.11497222222222228116 },
{ /* 90 f= 9000 */ 1.81563197434014589327, 0.56250000000000000000, 0.12500000000000002776 },
{ /* 91 f= 9100 */ 1.80312561321345343757, 0.56748611111111113559, 0.13497222222222221566 },
{ /* 92 f= 9200 */ 1.79077435375775539939, 0.57244444444444453346, 0.14488888888888898365 },
{ /* 93 f= 9300 */ 1.77857618556138596944, 0.57737499999999997158, 0.15475000000000005418 },
{ /* 94 f= 9400 */ 1.76652912957066132726, 0.58227777777777778301, 0.16455555555555556602 },
{ /* 95 f= 9500 */ 1.75463123757247840828, 0.58715277777777774570, 0.17430555555555554692 },
{ /* 96 f= 9600 */ 1.74288059168634545948, 0.59200000000000008171, 0.18400000000000008016 },
{ /* 97 f= 9700 */ 1.73127530386566674814, 0.59681944444444445796, 0.19363888888888891593 },
{ /* 98 f= 9800 */ 1.71981351540809557221, 0.60161111111111109651, 0.20322222222222222077 },
{ /* 99 f= 9900 */ 1.70849339647479481208, 0.60637499999999999734, 0.21274999999999996692 },
{ /*100 f=10000 */ 1.69731314561842516753, 0.61111111111111116045, 0.22222222222222229315 },
{ /*101 f=10100 */ 1.68627098931969943152, 0.61581944444444447484, 0.23163888888888892192 },
{ /*102 f=10200 */ 1.67536518153233471295, 0.62050000000000005151, 0.24099999999999999201 },
{ /*103 f=10300 */ 1.66459400323625028584, 0.62515277777777777946, 0.25030555555555550340 },
{ /*104 f=10400 */ 1.65395576199884764002, 0.62977777777777776969, 0.25955555555555559488 },
{ /*105 f=10500 */ 1.64344879154422396361, 0.63437500000000002220, 0.26875000000000004441 },
{ /*106 f=10600 */ 1.63307145133016673455, 0.63894444444444442599, 0.27788888888888885198 },
{ /*107 f=10700 */ 1.62282212613278042923, 0.64348611111111120309, 0.28697222222222229515 },
{ /*108 f=10800 */ 1.61269922563860812481, 0.64800000000000002043, 0.29600000000000004086 },
{ /*109 f=10900 */ 1.60270118404409656065, 0.65248611111111110006, 0.30497222222222225563 },
{ /*110 f=11000 */ 1.59282645966227565104, 0.65694444444444444198, 0.31388888888888888395 },
{ /*111 f=11100 */ 1.58307353453651189490, 0.66137500000000004619, 0.32275000000000009237 },
{ /*112 f=11200 */ 1.57344091406120312193, 0.66577777777777780166, 0.33155555555555560332 },
{ /*113 f=11300 */ 1.56392712660928623336, 0.67015277777777781942, 0.34030555555555558334 },
{ /*114 f=11400 */ 1.55453072316642892936, 0.67449999999999998845, 0.34899999999999997691 },
{ /*115 f=11500 */ 1.54525027697178107822, 0.67881944444444441977, 0.35763888888888895057 },
{ /*116 f=11600 */ 1.53608438316516271449, 0.68311111111111111338, 0.36622222222222222676 },
{ /*117 f=11700 */ 1.52703165844057209277, 0.68737499999999995826, 0.37474999999999997202 },
{ /*118 f=11800 */ 1.51809074070588789773, 0.69161111111111106542, 0.38322222222222218635 },
{ /*119 f=11900 */ 1.50926028874866124951, 0.69581944444444443487, 0.39163888888888892525 },
{ /*120 f=12000 */ 1.50053898190787671219, 0.69999999999999995559, 0.40000000000000002220 },
{ /*121 f=12100 */ 1.49192551975157505773, 0.70415277777777773860, 0.40830555555555553271 },
{ /*122 f=12200 */ 1.48341862176022809550, 0.70827777777777778390, 0.41655555555555551228 },
{ /*123 f=12300 */ 1.47501702701576142829, 0.71237499999999998046, 0.42474999999999996092 },
{ /*124 f=12400 */ 1.46671949389611722125, 0.71644444444444443931, 0.43288888888888898965 },
{ /*125 f=12500 */ 1.45852479977526039434, 0.72048611111111116045, 0.44097222222222232091 },
{ /*126 f=12600 */ 1.45043174072852343315, 0.72450000000000003286, 0.44900000000000006573 },
{ /*127 f=12700 */ 1.44243913124319389496, 0.72848611111111116756, 0.45697222222222227961 },
{ /*128 f=12800 */ 1.43454580393424935281, 0.73244444444444445352, 0.46488888888888890705 },
{ /*129 f=12900 */ 1.42675060926514496451, 0.73637500000000000178, 0.47275000000000000355 },
{ /*130 f=13000 */ 1.41905241527355951980, 0.74027777777777781232, 0.48055555555555551361 },
{ /*131 f=13100 */ 1.41145010730201470039, 0.74415277777777777413, 0.48830555555555549274 },
{ /*132 f=13200 */ 1.40394258773327362810, 0.74799999999999999822, 0.49600000000000010747 },
{ /*133 f=13300 */ 1.39652877573043454618, 0.75181944444444448461, 0.50363888888888896922 },
{ /*134 f=13400 */ 1.38920760698163436864, 0.75561111111111112226, 0.51122222222222224453 },
{ /*135 f=13500 */ 1.38197803344927927505, 0.75937500000000002220, 0.51875000000000004441 },
{ /*136 f=13600 */ 1.37483902312371886190, 0.76311111111111107341, 0.52622222222222225785 },
{ /*137 f=13700 */ 1.36778955978128524684, 0.76681944444444449793, 0.53363888888888888484 },
{ /*138 f=13800 */ 1.36082864274661985426, 0.77049999999999996270, 0.54099999999999992539 },
{ /*139 f=13900 */ 1.35395528665920572564, 0.77415277777777791179, 0.54830555555555571257 },
{ /*140 f=14000 */ 1.34716852124403896340, 0.77777777777777790114, 0.55555555555555569125 },
{ /*141 f=14100 */ 1.34046739108635404314, 0.78137500000000004174, 0.56275000000000008349 },
{ /*142 f=14200 */ 1.33385095541034259803, 0.78494444444444444464, 0.56988888888888888928 },
{ /*143 f=14300 */ 1.32731828786178374102, 0.78848611111111110983, 0.57697222222222221966 },
{ /*144 f=14400 */ 1.32086847629452508457, 0.79200000000000003730, 0.58399999999999996358 },
{ /*145 f=14500 */ 1.31450062256074007294, 0.79548611111111111605, 0.59097222222222223209 },
{ /*146 f=14600 */ 1.30821384230489878853, 0.79894444444444445708, 0.59788888888888880313 },
{ /*147 f=14700 */ 1.30200726476138339827, 0.80237500000000006040, 0.60475000000000012079 },
{ /*148 f=14800 */ 1.29588003255568828820, 0.80577777777777781498, 0.61155555555555562997 },
{ /*149 f=14900 */ 1.28983130150913649636, 0.80915277777777783186, 0.61830555555555555269 },
{ /*150 f=15000 */ 1.28386024044705604474, 0.81250000000000000000, 0.62500000000000000000 },
{ /*151 f=15100 */ 1.27796603101035177730, 0.81581944444444443043, 0.63163888888888886086 },
{ /*152 f=15200 */ 1.27214786747041608272, 0.81911111111111112315, 0.63822222222222224630 },
{ /*153 f=15300 */ 1.26640495654731721764, 0.82237499999999996714, 0.64474999999999993427 },
{ /*154 f=15400 */ 1.26073651723121304968, 0.82561111111111118444, 0.65122222222222236887 },
{ /*155 f=15500 */ 1.25514178060692960237, 0.82881944444444455300, 0.65763888888888899498 },
{ /*156 f=15600 */ 1.24961998968165155510, 0.83200000000000007283, 0.66400000000000003464 },
{ /*157 f=15700 */ 1.24417039921567273986, 0.83515277777777785495, 0.67030555555555559888 },
{ /*158 f=15800 */ 1.23879227555615023526, 0.83827777777777778834, 0.67655555555555557667 },
{ /*159 f=15900 */ 1.23348489647381565071, 0.84137499999999998401, 0.68274999999999996803 },
{ /*160 f=16000 */ 1.22824755100258653506, 0.84444444444444444198, 0.68888888888888888395 },
{ /*161 f=16100 */ 1.22307953928203461125, 0.84748611111111116223, 0.69497222222222221344 },
{ /*162 f=16200 */ 1.21798017240266021055, 0.85050000000000003375, 0.70100000000000006750 },
{ /*163 f=16300 */ 1.21294877225392050413, 0.85348611111111116756, 0.70697222222222233512 },
{ /*164 f=16400 */ 1.20798467137497511636, 0.85644444444444445264, 0.71288888888888890527 },
{ /*165 f=16500 */ 1.20308721280809227672, 0.85937500000000000000, 0.71875000000000000000 },
{ /*166 f=16600 */ 1.19825574995467953876, 0.86227777777777769863, 0.72455555555555550828 },
{ /*167 f=16700 */ 1.19348964643388821827, 0.86515277777777777057, 0.73030555555555554115 },
{ /*168 f=16800 */ 1.18878827594375491294, 0.86799999999999999378, 0.73599999999999998757 },
{ /*169 f=16900 */ 1.18415102212483258626, 0.87081944444444447928, 0.74163888888888895856 },
{ /*170 f=17000 */ 1.17957727842627346782, 0.87361111111111111605, 0.74722222222222234311 },
{ /*171 f=17100 */ 1.17506644797431913929, 0.87637500000000001510, 0.75275000000000003020 },
{ /*172 f=17200 */ 1.17061794344316405514, 0.87911111111111117644, 0.75822222222222224186 },
{ /*173 f=17300 */ 1.16623118692814897734, 0.88181944444444448905, 0.76363888888888886708 },
{ /*174 f=17400 */ 1.16190560982124591050, 0.88450000000000006395, 0.76900000000000001688 },
{ /*175 f=17500 */ 1.15764065268880100845, 0.88715277777777779011, 0.77430555555555558023 },
{ /*176 f=17600 */ 1.15343576515149437434, 0.88977777777777777857, 0.77955555555555555713 },
{ /*177 f=17700 */ 1.14929040576648544558, 0.89237500000000002931, 0.78475000000000005862 },
{ /*178 f=17800 */ 1.14520404191170199759, 0.89494444444444454234, 0.78988888888888897366 },
{ /*179 f=17900 */ 1.14117614967224878519, 0.89748611111111120664, 0.79497222222222230226 },
{ /*180 f=18000 */ 1.13720621372888897049, 0.90000000000000002220, 0.80000000000000004441 },
{ /*181 f=18100 */ 1.13329372724857613264, 0.90248611111111110006, 0.80497222222222220012 },
{ /*182 f=18200 */ 1.12943819177700044420, 0.90494444444444444020, 0.80988888888888888040 },
{ /*183 f=18300 */ 1.12563911713311437524, 0.90737500000000004263, 0.81474999999999997424 },
{ /*184 f=18400 */ 1.12189602130561283388, 0.90977777777777779633, 0.81955555555555559266 },
{ /*185 f=18500 */ 1.11820843035133021814, 0.91215277777777781232, 0.82430555555555562464 },
{ /*186 f=18600 */ 1.11457587829553084191, 0.91450000000000009059, 0.82900000000000007017 },
{ /*187 f=18700 */ 1.11099790703406076098, 0.91681944444444440911, 0.83363888888888892925 },
{ /*188 f=18800 */ 1.10747406623732946862, 0.91911111111111110095, 0.83822222222222220189 },
{ /*189 f=18900 */ 1.10400391325609992244, 0.92137500000000005507, 0.84274999999999999911 },
{ /*190 f=19000 */ 1.10058701302905315167, 0.92361111111111116045, 0.84722222222222220989 },
{ /*191 f=19100 */ 1.09722293799210390830, 0.92581944444444441711, 0.85163888888888883422 },
{ /*192 f=19200 */ 1.09391126798943849607, 0.92800000000000004707, 0.85600000000000009415 },
{ /*193 f=19300 */ 1.09065159018625368326, 0.93015277777777782831, 0.86030555555555554559 },
{ /*194 f=19400 */ 1.08744349898316516878, 0.93227777777777776080, 0.86455555555555563263 },
{ /*195 f=19500 */ 1.08428659593226339730, 0.93437499999999995559, 0.86875000000000002220 },
{ /*196 f=19600 */ 1.08118048965479696122, 0.93644444444444441267, 0.87288888888888893636 },
{ /*197 f=19700 */ 1.07812479576045028296, 0.93848611111111113203, 0.87697222222222215304 },
{ /*198 f=19800 */ 1.07511913676820247687, 0.94050000000000000266, 0.88100000000000000533 },
{ /*199 f=19900 */ 1.07216314202873541639, 0.94248611111111113559, 0.88497222222222227117 },
{ /*200 f=20000 */ 1.06925644764837746159, 0.94444444444444441977, 0.88888888888888895057 },
{ /*201 f=20100 */ 1.06639869641455309335, 0.94637499999999996625, 0.89275000000000004352 },
{ /*202 f=20200 */ 1.06358953772272313287, 0.94827777777777777501, 0.89655555555555555003 },
{ /*203 f=20300 */ 1.06082862750479067770, 0.95015277777777784607, 0.90030555555555558112 },
{ /*204 f=20400 */ 1.05811562815895632284, 0.95199999999999995737, 0.90400000000000002576 },
{ /*205 f=20500 */ 1.05545020848099557753, 0.95381944444444444198, 0.90763888888888888395 },
{ /*206 f=20600 */ 1.05283204359694892993, 0.95561111111111107785, 0.91122222222222215571 },
{ /*207 f=20700 */ 1.05026081489719635975, 0.95737500000000008704, 0.91475000000000006306 },
{ /*208 f=20800 */ 1.04773620997190319848, 0.95911111111111113647, 0.91822222222222227295 },
{ /*209 f=20900 */ 1.04525792254781557666, 0.96081944444444444819, 0.92163888888888889639 },
{ /*210 f=21000 */ 1.04282565242639102543, 0.96250000000000002220, 0.92500000000000004441 },
{ /*211 f=21100 */ 1.04043910542324269386, 0.96415277777777785850, 0.92830555555555560598 },
{ /*212 f=21200 */ 1.03809799330888474778, 0.96577777777777784607, 0.93155555555555558112 },
{ /*213 f=21300 */ 1.03580203375075718952, 0.96737499999999998490, 0.93474999999999996980 },
{ /*214 f=21400 */ 1.03355095025651766427, 0.96894444444444438602, 0.93788888888888888307 },
{ /*215 f=21500 */ 1.03134447211858404359, 0.97048611111111116045, 0.94097222222222220989 },
{ /*216 f=21600 */ 1.02918233435990891245, 0.97199999999999997513, 0.94400000000000006128 },
{ /*217 f=21700 */ 1.02706427768097419140, 0.97348611111111105210, 0.94697222222222221522 },
{ /*218 f=21800 */ 1.02499004840799101679, 0.97494444444444439135, 0.94988888888888889372 },
{ /*219 f=21900 */ 1.02295939844228644944, 0.97637499999999999289, 0.95274999999999998579 },
{ /*220 f=22000 */ 1.02097208521086946220, 0.97777777777777774570, 0.95555555555555549141 },
{ /*221 f=22100 */ 1.01902787161815444605, 0.97915277777777776080, 0.95830555555555552161 },
{ /*222 f=22200 */ 1.01712652599883712767, 0.98050000000000003819, 0.96100000000000007638 },
{ /*223 f=22300 */ 1.01526782207190202634, 0.98181944444444446685, 0.96363888888888893369 },
{ /*224 f=22400 */ 1.01345153889575634309, 0.98311111111111104677, 0.96622222222222220456 },
{ /*225 f=22500 */ 1.01167746082446852185, 0.98437500000000000000, 0.96875000000000000000 },
{ /*226 f=22600 */ 1.00994537746511103826, 0.98561111111111110450, 0.97122222222222220900 },
{ /*227 f=22700 */ 1.00825508363618254748, 0.98681944444444447129, 0.97363888888888883155 },
{ /*228 f=22800 */ 1.00660637932711072295, 0.98799999999999998934, 0.97599999999999997868 },
{ /*229 f=22900 */ 1.00499906965881358190, 0.98915277777777776969, 0.97830555555555553937 },
{ /*230 f=23000 */ 1.00343296484531618873, 0.99027777777777781232, 0.98055555555555562464 },
{ /*231 f=23100 */ 1.00190788015640808162, 0.99137500000000000622, 0.98275000000000001243 },
{ /*232 f=23200 */ 1.00042363588133231822, 0.99244444444444446241, 0.98488888888888892481 },
{ /*233 f=23300 */ 0.99898005729349692583, 0.99348611111111106986, 0.98697222222222225074 },
{ /*234 f=23400 */ 0.99757697461619598833, 0.99449999999999993960, 0.98899999999999999023 },
{ /*235 f=23500 */ 0.99621422298933726136, 0.99548611111111107164, 0.99097222222222225430 },
{ /*236 f=23600 */ 0.99489164243715888514, 0.99644444444444446596, 0.99288888888888882089 },
{ /*237 f=23700 */ 0.99360907783693286355, 0.99737500000000001155, 0.99475000000000002309 },
{ /*238 f=23800 */ 0.99236637888864431822, 0.99827777777777781942, 0.99655555555555552782 },
{ /*239 f=23900 */ 0.99116340008563796893, 0.99915277777777777857, 0.99830555555555555713 },
{ /*240 f=24000 */ 0.99000000068622384664, 1.00000000000000000000, 1.00000000000000000000 }
};
static FLOAT_T moog_q210[241][3] = {
{ /* dummy entry */ 0, 0, 0},
{ /*  1 f=  100 */ 3.92708094675350594116, 0.00748611111111113781, -0.98502777777777772439 },
{ /*  2 f=  200 */ 3.88668761149368258145, 0.01494444444444442688, -0.97011111111111114624 },
{ /*  3 f=  300 */ 3.84685788349367552286, 0.02237499999999997824, -0.95525000000000004352 },
{ /*  4 f=  400 */ 3.80758293527641900056, 0.02977777777777779189, -0.94044444444444441622 },
{ /*  5 f=  500 */ 3.76885409342077259964, 0.03715277777777775681, -0.92569444444444448639 },
{ /*  6 f=  600 */ 3.73066283565949774470, 0.04449999999999998401, -0.91100000000000003197 },
{ /*  7 f=  700 */ 3.69300078803575848596, 0.05181944444444447351, -0.89636111111111105298 },
{ /*  8 f=  800 */ 3.65585972211690490852, 0.05911111111111111427, -0.88177777777777777146 },
{ /*  9 f=  900 */ 3.61923155226431303433, 0.06637500000000001732, -0.86724999999999996536 },
{ /* 10 f= 1000 */ 3.58310833295809327836, 0.07361111111111112715, -0.85277777777777774570 },
{ /* 11 f= 1100 */ 3.54748225617549151067, 0.08081944444444444375, -0.83836111111111111249 },
{ /* 12 f= 1200 */ 3.51234564882185340551, 0.08800000000000002265, -0.82399999999999995470 },
{ /* 13 f= 1300 */ 3.47769097021302764361, 0.09515277777777780832, -0.80969444444444438336 },
{ /* 14 f= 1400 */ 3.44351080960812083731, 0.10227777777777780077, -0.79544444444444439846 },
{ /* 15 f= 1500 */ 3.40979788379154546973, 0.10937500000000000000, -0.78125000000000000000 },
{ /* 16 f= 1600 */ 3.37654503470329991899, 0.11644444444444446152, -0.76711111111111107697 },
{ /* 17 f= 1700 */ 3.34374522711648314299, 0.12348611111111112981, -0.75302777777777774038 },
{ /* 18 f= 1800 */ 3.31139154636103549834, 0.13050000000000000488, -0.73899999999999999023 },
{ /* 19 f= 1900 */ 3.27947719609273136143, 0.13748611111111108674, -0.72502777777777782653 },
{ /* 20 f= 2000 */ 3.24799549610647586562, 0.14444444444444443088, -0.71111111111111113825 },
{ /* 21 f= 2100 */ 3.21693988019297272274, 0.15137499999999998179, -0.69725000000000003642 },
{ /* 22 f= 2200 */ 3.18630389403784919367, 0.15827777777777779500, -0.68344444444444441000 },
{ /* 23 f= 2300 */ 3.15608119316235091745, 0.16515277777777781498, -0.66969444444444437003 },
{ /* 24 f= 2400 */ 3.12626554090473707248, 0.17199999999999998623, -0.65600000000000002753 },
{ /* 25 f= 2500 */ 3.09685080644151611295, 0.17881944444444447528, -0.64236111111111104943 },
{ /* 26 f= 2600 */ 3.06783096284770140372, 0.18561111111111111560, -0.62877777777777776880 },
{ /* 27 f= 2700 */ 3.03920008519525808310, 0.19237500000000001821, -0.61524999999999996358 },
{ /* 28 f= 2800 */ 3.01095234868895955671, 0.19911111111111112759, -0.60177777777777774482 },
{ /* 29 f= 2900 */ 2.98308202683886003470, 0.20581944444444444375, -0.58836111111111111249 },
{ /* 30 f= 3000 */ 2.95558348966862860507, 0.21250000000000002220, -0.57499999999999995559 },
{ /* 31 f= 3100 */ 2.92845120195900632254, 0.21915277777777780743, -0.56169444444444438513 },
{ /* 32 f= 3200 */ 2.90167972152563580224, 0.22577777777777779944, -0.54844444444444440112 },
{ /* 33 f= 3300 */ 2.87526369753057542411, 0.23237499999999999822, -0.53525000000000000355 },
{ /* 34 f= 3400 */ 2.84919786882678538475, 0.23894444444444445930, -0.52211111111111108141 },
{ /* 35 f= 3500 */ 2.82347706233490480798, 0.24548611111111112715, -0.50902777777777774570 },
{ /* 36 f= 3600 */ 2.79809619145165910936, 0.25200000000000000178, -0.49599999999999999645 },
{ /* 37 f= 3700 */ 2.77305025448923680997, 0.25848611111111113869, -0.48302777777777772261 },
{ /* 38 f= 3800 */ 2.74833433314500474864, 0.26494444444444442688, -0.47011111111111114624 },
{ /* 39 f= 3900 */ 2.72394359100093108594, 0.27137500000000003286, -0.45724999999999998979 },
{ /* 40 f= 4000 */ 2.69987327205210725367, 0.27777777777777779011, -0.44444444444444447528 },
{ /* 41 f= 4100 */ 2.67611869926377288209, 0.28415277777777780965, -0.43169444444444443620 },
{ /* 42 f= 4200 */ 2.65267527315625439854, 0.29049999999999998046, -0.41900000000000003908 },
{ /* 43 f= 4300 */ 2.62953847041724975142, 0.29681944444444441356, -0.40636111111111111738 },
{ /* 44 f= 4400 */ 2.60670384254089615439, 0.30311111111111110894, -0.39377777777777778212 },
{ /* 45 f= 4500 */ 2.58416701449307861793, 0.30937500000000001110, -0.38124999999999997780 },
{ /* 46 f= 4600 */ 2.56192368340242992986, 0.31561111111111117555, -0.36877777777777770440 },
{ /* 47 f= 4700 */ 2.53996961727651671126, 0.32181944444444443576, -0.35636111111111112848 },
{ /* 48 f= 4800 */ 2.51830065374268308176, 0.32800000000000001377, -0.34399999999999997247 },
{ /* 49 f= 4900 */ 2.49691269881306032730, 0.33415277777777774304, -0.33169444444444445841 },
{ /* 50 f= 5000 */ 2.47580172567323941735, 0.34027777777777779011, -0.31944444444444441977 },
{ /* 51 f= 5100 */ 2.45496377349414274249, 0.34637499999999998845, -0.30725000000000002309 },
{ /* 52 f= 5200 */ 2.43439494626660524190, 0.35244444444444444908, -0.29511111111111110183 },
{ /* 53 f= 5300 */ 2.41409141165822438424, 0.35848611111111111649, -0.28302777777777776702 },
{ /* 54 f= 5400 */ 2.39404939989200915562, 0.36450000000000004619, -0.27099999999999996314 },
{ /* 55 f= 5500 */ 2.37426520264640750213, 0.37048611111111107164, -0.25902777777777780122 },
{ /* 56 f= 5600 */ 2.35473517197625836772, 0.37644444444444447040, -0.24711111111111108696 },
{ /* 57 f= 5700 */ 2.33545571925427086768, 0.38237500000000002043, -0.23525000000000001465 },
{ /* 58 f= 5800 */ 2.31642331413259405792, 0.38827777777777777724, -0.22344444444444441777 },
{ /* 59 f= 5900 */ 2.29763448352409271891, 0.39415277777777779633, -0.21169444444444446285 },
{ /* 60 f= 6000 */ 2.27908581060291703935, 0.40000000000000002220, -0.19999999999999998335 },
{ /* 61 f= 6100 */ 2.26077393382399272070, 0.40581944444444439934, -0.18836111111111114580 },
{ /* 62 f= 6200 */ 2.24269554596104336852, 0.41161111111111114980, -0.17677777777777770041 },
{ /* 63 f= 6300 */ 2.22484739316277480015, 0.41737500000000005151, -0.16524999999999995248 },
{ /* 64 f= 6400 */ 2.20722627402686866205, 0.42311111111111110450, -0.15377777777777776325 },
{ /* 65 f= 6500 */ 2.18982903869140788089, 0.42881944444444441977, -0.14236111111111113270 },
{ /* 66 f= 6600 */ 2.17265258794341598048, 0.43450000000000005285, -0.13099999999999992206 },
{ /* 67 f= 6700 */ 2.15569387234413989418, 0.44015277777777778168, -0.11969444444444440889 },
{ /* 68 f= 6800 */ 2.13894989137076363406, 0.44577777777777777279, -0.10844444444444444053 },
{ /* 69 f= 6900 */ 2.12241769257421930561, 0.45137499999999997069, -0.09725000000000004474 },
{ /* 70 f= 7000 */ 2.10609437075277083906, 0.45694444444444448639, -0.08611111111111104111 },
{ /* 71 f= 7100 */ 2.08997706714107023274, 0.46248611111111115335, -0.07502777777777774881 },
{ /* 72 f= 7200 */ 2.07406296861436523216, 0.46799999999999997158, -0.06400000000000001521 },
{ /* 73 f= 7300 */ 2.05834930690757200722, 0.47348611111111110761, -0.05302777777777782642 },
{ /* 74 f= 7400 */ 2.04283335784890951459, 0.47894444444444445041, -0.04211111111111105060 },
{ /* 75 f= 7500 */ 2.02751244060781710132, 0.48437500000000000000, -0.03124999999999997918 },
{ /* 76 f= 7600 */ 2.01238391695686402727, 0.48977777777777775636, -0.02044444444444446299 },
{ /* 77 f= 7700 */ 1.99744519054738023378, 0.49515277777777783053, -0.00969444444444435803 },
{ /* 78 f= 7800 */ 1.98269370619854901072, 0.50050000000000005596, 0.00100000000000004794 },
{ /* 79 f= 7900 */ 1.96812694919967334783, 0.50581944444444448816, 0.01163888888888889826 },
{ /* 80 f= 8000 */ 1.95374244462538282363, 0.51111111111111107164, 0.02222222222222219531 },
{ /* 81 f= 8100 */ 1.93953775666351213580, 0.51637500000000002842, 0.03275000000000007766 },
{ /* 82 f= 8200 */ 1.92551048795540991065, 0.52161111111111113647, 0.04322222222222225907 },
{ /* 83 f= 8300 */ 1.91165827894843110002, 0.52681944444444439579, 0.05363888888888888873 },
{ /* 84 f= 8400 */ 1.89797880726037959676, 0.53200000000000002842, 0.06399999999999995970 },
{ /* 85 f= 8500 */ 1.88446978705566725587, 0.53715277777777781232, 0.07430555555555562464 },
{ /* 86 f= 8600 */ 1.87112896843295772875, 0.54227777777777774748, 0.08455555555555557823 },
{ /* 87 f= 8700 */ 1.85795413682407506428, 0.54737499999999994493, 0.09474999999999998701 },
{ /* 88 f= 8800 */ 1.84494311240396058338, 0.55244444444444440467, 0.10488888888888885098 },
{ /* 89 f= 8900 */ 1.83209374951145953503, 0.55748611111111112670, 0.11497222222222228116 },
{ /* 90 f= 9000 */ 1.81940393608073036624, 0.56250000000000000000, 0.12500000000000002776 },
{ /* 91 f= 9100 */ 1.80687159308306921623, 0.56748611111111113559, 0.13497222222222221566 },
{ /* 92 f= 9200 */ 1.79449467397895490173, 0.57244444444444453346, 0.14488888888888898365 },
{ /* 93 f= 9300 */ 1.78227116418010633758, 0.57737499999999997158, 0.15475000000000005418 },
{ /* 94 f= 9400 */ 1.77019908052137076027, 0.58227777777777778301, 0.16455555555555556602 },
{ /* 95 f= 9500 */ 1.75827647074224713286, 0.58715277777777774570, 0.17430555555555554692 },
{ /* 96 f= 9600 */ 1.74650141297786154482, 0.59200000000000008171, 0.18400000000000008016 },
{ /* 97 f= 9700 */ 1.73487201525921497236, 0.59681944444444445796, 0.19363888888888891593 },
{ /* 98 f= 9800 */ 1.72338641502252132298, 0.60161111111111109651, 0.20322222222222222077 },
{ /* 99 f= 9900 */ 1.71204277862746701011, 0.60637499999999999734, 0.21274999999999996692 },
{ /*100 f=10000 */ 1.70083930088421908522, 0.61111111111111116045, 0.22222222222222229315 },
{ /*101 f=10100 */ 1.68977420458901783640, 0.61581944444444447484, 0.23163888888888892192 },
{ /*102 f=10200 */ 1.67884574006818221292, 0.62050000000000005151, 0.24099999999999999201 },
{ /*103 f=10300 */ 1.66805218473037997207, 0.62515277777777777946, 0.25030555555555550340 },
{ /*104 f=10400 */ 1.65739184262699690287, 0.62977777777777776969, 0.25955555555555559488 },
{ /*105 f=10500 */ 1.64686304402045458062, 0.63437500000000002220, 0.26875000000000004441 },
{ /*106 f=10600 */ 1.63646414496032632790, 0.63894444444444442599, 0.27788888888888885198 },
{ /*107 f=10700 */ 1.62619352686710105793, 0.64348611111111120309, 0.28697222222222229515 },
{ /*108 f=10800 */ 1.61604959612345799869, 0.64800000000000002043, 0.29600000000000004086 },
{ /*109 f=10900 */ 1.60603078367289819894, 0.65248611111111110006, 0.30497222222222225563 },
{ /*110 f=11000 */ 1.59613554462560913727, 0.65694444444444444198, 0.31388888888888888395 },
{ /*111 f=11100 */ 1.58636235787141344211, 0.66137500000000004619, 0.32275000000000009237 },
{ /*112 f=11200 */ 1.57670972569967737797, 0.66577777777777780166, 0.33155555555555560332 },
{ /*113 f=11300 */ 1.56717617342604342845, 0.67015277777777781942, 0.34030555555555558334 },
{ /*114 f=11400 */ 1.55776024902586285314, 0.67449999999999998845, 0.34899999999999997691 },
{ /*115 f=11500 */ 1.54846052277420098697, 0.67881944444444441977, 0.35763888888888895057 },
{ /*116 f=11600 */ 1.53927558689229138089, 0.68311111111111111338, 0.36622222222222222676 },
{ /*117 f=11700 */ 1.53020405520032398705, 0.68737499999999995826, 0.37474999999999997202 },
{ /*118 f=11800 */ 1.52124456277644215518, 0.69161111111111106542, 0.38322222222222218635 },
{ /*119 f=11900 */ 1.51239576562183763997, 0.69581944444444443487, 0.39163888888888892525 },
{ /*120 f=12000 */ 1.50365634033183215301, 0.69999999999999995559, 0.40000000000000002220 },
{ /*121 f=12100 */ 1.49502498377282821984, 0.70415277777777773860, 0.40830555555555553271 },
{ /*122 f=12200 */ 1.48650041276502875576, 0.70827777777777778390, 0.41655555555555551228 },
{ /*123 f=12300 */ 1.47808136377081122959, 0.71237499999999998046, 0.42474999999999996092 },
{ /*124 f=12400 */ 1.46976659258865716140, 0.71644444444444443931, 0.43288888888888898965 },
{ /*125 f=12500 */ 1.46155487405253525779, 0.72048611111111116045, 0.44097222222222232091 },
{ /*126 f=12600 */ 1.45344500173663337961, 0.72450000000000003286, 0.44900000000000006573 },
{ /*127 f=12700 */ 1.44543578766534586144, 0.72848611111111116756, 0.45697222222222227961 },
{ /*128 f=12800 */ 1.43752606202841648475, 0.73244444444444445352, 0.46488888888888890705 },
{ /*129 f=12900 */ 1.42971467290114651050, 0.73637500000000000178, 0.47275000000000000355 },
{ /*130 f=13000 */ 1.42200048596957207003, 0.74027777777777781232, 0.48055555555555551361 },
{ /*131 f=13100 */ 1.41438238426052209640, 0.74415277777777777413, 0.48830555555555549274 },
{ /*132 f=13200 */ 1.40685926787646797820, 0.74799999999999999822, 0.49600000000000010747 },
{ /*133 f=13300 */ 1.39943005373507789457, 0.75181944444444448461, 0.50363888888888896922 },
{ /*134 f=13400 */ 1.39209367531338856772, 0.75561111111111112226, 0.51122222222222224453 },
{ /*135 f=13500 */ 1.38484908239651605122, 0.75937500000000002220, 0.51875000000000004441 },
{ /*136 f=13600 */ 1.37769524083081762456, 0.76311111111111107341, 0.52622222222222225785 },
{ /*137 f=13700 */ 1.37063113228142841038, 0.76681944444444449793, 0.53363888888888888484 },
{ /*138 f=13800 */ 1.36365575399409455493, 0.77049999999999996270, 0.54099999999999992539 },
{ /*139 f=13900 */ 1.35676811856121970479, 0.77415277777777791179, 0.54830555555555571257 },
{ /*140 f=14000 */ 1.34996725369206083123, 0.77777777777777790114, 0.55555555555555569125 },
{ /*141 f=14100 */ 1.34325220198698613849, 0.78137500000000004174, 0.56275000000000008349 },
{ /*142 f=14200 */ 1.33662202071573199547, 0.78494444444444444464, 0.56988888888888888928 },
{ /*143 f=14300 */ 1.33007578159958383957, 0.78848611111111110983, 0.57697222222222221966 },
{ /*144 f=14400 */ 1.32361257059741244113, 0.79200000000000003730, 0.58399999999999996358 },
{ /*145 f=14500 */ 1.31723148769549602832, 0.79548611111111111605, 0.59097222222222223209 },
{ /*146 f=14600 */ 1.31093164670106232528, 0.79894444444444445708, 0.59788888888888880313 },
{ /*147 f=14700 */ 1.30471217503948500038, 0.80237500000000006040, 0.60475000000000012079 },
{ /*148 f=14800 */ 1.29857221355506924354, 0.80577777777777781498, 0.61155555555555562997 },
{ /*149 f=14900 */ 1.29251091631536318971, 0.80915277777777783186, 0.61830555555555555269 },
{ /*150 f=15000 */ 1.28652745041893590283, 0.81250000000000000000, 0.62500000000000000000 },
{ /*151 f=15100 */ 1.28062099580655686104, 0.81581944444444443043, 0.63163888888888886086 },
{ /*152 f=15200 */ 1.27479074507572387454, 0.81911111111111112315, 0.63822222222222224630 },
{ /*153 f=15300 */ 1.26903590329847193452, 0.82237499999999996714, 0.64474999999999993427 },
{ /*154 f=15400 */ 1.26335568784241680795, 0.82561111111111118444, 0.65122222222222236887 },
{ /*155 f=15500 */ 1.25774932819496920722, 0.82881944444444455300, 0.65763888888888899498 },
{ /*156 f=15600 */ 1.25221606579066668807, 0.83200000000000007283, 0.66400000000000003464 },
{ /*157 f=15700 */ 1.24675515384157353793, 0.83515277777777785495, 0.67030555555555559888 },
{ /*158 f=15800 */ 1.24136585717068825829, 0.83827777777777778834, 0.67655555555555557667 },
{ /*159 f=15900 */ 1.23604745204831667493, 0.84137499999999998401, 0.68274999999999996803 },
{ /*160 f=16000 */ 1.23079922603134983561, 0.84444444444444444198, 0.68888888888888888395 },
{ /*161 f=16100 */ 1.22562047780540472885, 0.84748611111111116223, 0.69497222222222221344 },
{ /*162 f=16200 */ 1.22051051702977697566, 0.85050000000000003375, 0.70100000000000006750 },
{ /*163 f=16300 */ 1.21546866418515464581, 0.85348611111111116756, 0.70697222222222233512 },
{ /*164 f=16400 */ 1.21049425042405234265, 0.85644444444444445264, 0.71288888888888890527 },
{ /*165 f=16500 */ 1.20558661742391337590, 0.85937500000000000000, 0.71875000000000000000 },
{ /*166 f=16600 */ 1.20074511724284183067, 0.86227777777777769863, 0.72455555555555550828 },
{ /*167 f=16700 */ 1.19596911217791279647, 0.86515277777777777057, 0.73030555555555554115 },
{ /*168 f=16800 */ 1.19125797462602478483, 0.86799999999999999378, 0.73599999999999998757 },
{ /*169 f=16900 */ 1.18661108694724903856, 0.87081944444444447928, 0.74163888888888895856 },
{ /*170 f=17000 */ 1.18202784133063287797, 0.87361111111111111605, 0.74722222222222234311 },
{ /*171 f=17100 */ 1.17750763966241667191, 0.87637500000000001510, 0.75275000000000003020 },
{ /*172 f=17200 */ 1.17304989339663068293, 0.87911111111111117644, 0.75822222222222224186 },
{ /*173 f=17300 */ 1.16865402342802271463, 0.88181944444444448905, 0.76363888888888886708 },
{ /*174 f=17400 */ 1.16431945996728591908, 0.88450000000000006395, 0.76900000000000001688 },
{ /*175 f=17500 */ 1.16004564241854746243, 0.88715277777777779011, 0.77430555555555558023 },
{ /*176 f=17600 */ 1.15583201925907830265, 0.88977777777777777857, 0.77955555555555555713 },
{ /*177 f=17700 */ 1.15167804792119432555, 0.89237500000000002931, 0.78475000000000005862 },
{ /*178 f=17800 */ 1.14758319467630531818, 0.89494444444444454234, 0.78988888888888897366 },
{ /*179 f=17900 */ 1.14354693452108668872, 0.89748611111111120664, 0.79497222222222230226 },
{ /*180 f=18000 */ 1.13956875106572952383, 0.90000000000000002220, 0.80000000000000004441 },
{ /*181 f=18100 */ 1.13564813642424589091, 0.90248611111111110006, 0.80497222222222220012 },
{ /*182 f=18200 */ 1.13178459110679074939, 0.90494444444444444020, 0.80988888888888888040 },
{ /*183 f=18300 */ 1.12797762391396916293, 0.90737500000000004263, 0.81474999999999997424 },
{ /*184 f=18400 */ 1.12422675183310127878, 0.90977777777777779633, 0.81955555555555559266 },
{ /*185 f=18500 */ 1.12053149993640799309, 0.91215277777777781232, 0.82430555555555562464 },
{ /*186 f=18600 */ 1.11689140128109443140, 0.91450000000000009059, 0.82900000000000007017 },
{ /*187 f=18700 */ 1.11330599681129904788, 0.91681944444444440911, 0.83363888888888892925 },
{ /*188 f=18800 */ 1.10977483526187503671, 0.91911111111111110095, 0.83822222222222220189 },
{ /*189 f=18900 */ 1.10629747306398473761, 0.92137500000000005507, 0.84274999999999999911 },
{ /*190 f=19000 */ 1.10287347425247284072, 0.92361111111111116045, 0.84722222222222220989 },
{ /*191 f=19100 */ 1.09950241037499241159, 0.92581944444444441711, 0.85163888888888883422 },
{ /*192 f=19200 */ 1.09618386040285953342, 0.92800000000000004707, 0.85600000000000009415 },
{ /*193 f=19300 */ 1.09291741064360992119, 0.93015277777777782831, 0.86030555555555554559 },
{ /*194 f=19400 */ 1.08970265465522930803, 0.93227777777777776080, 0.86455555555555563263 },
{ /*195 f=19500 */ 1.08653919316203584344, 0.93437499999999995559, 0.86875000000000002220 },
{ /*196 f=19600 */ 1.08342663397219141075, 0.93644444444444441267, 0.87288888888888893636 },
{ /*197 f=19700 */ 1.08036459189681299797, 0.93848611111111113203, 0.87697222222222215304 },
{ /*198 f=19800 */ 1.07735268867066524834, 0.94050000000000000266, 0.88100000000000000533 },
{ /*199 f=19900 */ 1.07439055287440909936, 0.94248611111111113559, 0.88497222222222227117 },
{ /*200 f=20000 */ 1.07147781985838652652, 0.94444444444444441977, 0.88888888888888895057 },
{ /*201 f=20100 */ 1.06861413166791519025, 0.94637499999999996625, 0.89275000000000004352 },
{ /*202 f=20200 */ 1.06579913697007810924, 0.94827777777777777501, 0.89655555555555555003 },
{ /*203 f=20300 */ 1.06303249098197971634, 0.95015277777777784607, 0.90030555555555558112 },
{ /*204 f=20400 */ 1.06031385540045475224, 0.95199999999999995737, 0.90400000000000002576 },
{ /*205 f=20500 */ 1.05764289833320468404, 0.95381944444444444198, 0.90763888888888888395 },
{ /*206 f=20600 */ 1.05501929423134699348, 0.95561111111111107785, 0.91122222222222215571 },
{ /*207 f=20700 */ 1.05244272382335246618, 0.95737500000000008704, 0.91475000000000006306 },
{ /*208 f=20800 */ 1.04991287405035715885, 0.95911111111111113647, 0.91822222222222227295 },
{ /*209 f=20900 */ 1.04742943800282728439, 0.96081944444444444819, 0.92163888888888889639 },
{ /*210 f=21000 */ 1.04499211485855969528, 0.96250000000000002220, 0.92500000000000004441 },
{ /*211 f=21100 */ 1.04260060982200197799, 0.96415277777777785850, 0.92830555555555560598 },
{ /*212 f=21200 */ 1.04025463406487372886, 0.96577777777777784607, 0.93155555555555558112 },
{ /*213 f=21300 */ 1.03795390466807080365, 0.96737499999999998490, 0.93474999999999996980 },
{ /*214 f=21400 */ 1.03569814456484055043, 0.96894444444444438602, 0.93788888888888888307 },
{ /*215 f=21500 */ 1.03348708248520759767, 0.97048611111111116045, 0.94097222222222220989 },
{ /*216 f=21600 */ 1.03132045290163687490, 0.97199999999999997513, 0.94400000000000006128 },
{ /*217 f=21700 */ 1.02919799597591743456, 0.97348611111111105210, 0.94697222222222221522 },
{ /*218 f=21800 */ 1.02711945750725508475, 0.97494444444444439135, 0.94988888888888889372 },
{ /*219 f=21900 */ 1.02508458888155362665, 0.97637499999999999289, 0.95274999999999998579 },
{ /*220 f=22000 */ 1.02309314702187847956, 0.97777777777777774570, 0.95555555555555549141 },
{ /*221 f=22100 */ 1.02114489434008004487, 0.97915277777777776080, 0.95830555555555552161 },
{ /*222 f=22200 */ 1.01923959868957081376, 0.98050000000000003819, 0.96100000000000007638 },
{ /*223 f=22300 */ 1.01737703331923823313, 0.98181944444444446685, 0.96363888888888893369 },
{ /*224 f=22400 */ 1.01555697682848511398, 0.98311111111111104677, 0.96622222222222220456 },
{ /*225 f=22500 */ 1.01377921312337715420, 0.98437500000000000000, 0.96875000000000000000 },
{ /*226 f=22600 */ 1.01204353137389690964, 0.98561111111111110450, 0.97122222222222220900 },
{ /*227 f=22700 */ 1.01034972597228023261, 0.98681944444444447129, 0.97363888888888883155 },
{ /*228 f=22800 */ 1.00869759649243406763, 0.98799999999999998934, 0.97599999999999997868 },
{ /*229 f=22900 */ 1.00708694765041673058, 0.98915277777777776969, 0.97830555555555553937 },
{ /*230 f=23000 */ 1.00551758926597445409, 0.99027777777777781232, 0.98055555555555562464 },
{ /*231 f=23100 */ 1.00398933622512109842, 0.99137500000000000622, 0.98275000000000001243 },
{ /*232 f=23200 */ 1.00250200844375214615, 0.99244444444444446241, 0.98488888888888892481 },
{ /*233 f=23300 */ 1.00105543083228210044, 0.99348611111111106986, 0.98697222222222225074 },
{ /*234 f=23400 */ 0.99964943326129540591, 0.99449999999999993960, 0.98899999999999999023 },
{ /*235 f=23500 */ 0.99828385052820423073, 0.99548611111111107164, 0.99097222222222225430 },
{ /*236 f=23600 */ 0.99695852232489823308, 0.99644444444444446596, 0.99288888888888882089 },
{ /*237 f=23700 */ 0.99567329320638309209, 0.99737500000000001155, 0.99475000000000002309 },
{ /*238 f=23800 */ 0.99442801256039692337, 0.99827777777777781942, 0.99655555555555552782 },
{ /*239 f=23900 */ 0.99322253457799514198, 0.99915277777777777857, 0.99830555555555555713 },
{ /*240 f=24000 */ 0.99205671822509844393, 1.00000000000000000000, 1.00000000000000000000 }
};
static FLOAT_T moog_q220[241][3] = {
{ /* dummy entry */ 0, 0, 0},
{ /*  1 f=  100 */ 3.93354802329076136402, 0.00748611111111113781, -0.98502777777777772439 },
{ /*  2 f=  200 */ 3.89308816870162921475, 0.01494444444444442688, -0.97011111111111114624 },
{ /*  3 f=  300 */ 3.85319284951495522051, 0.02237499999999997824, -0.95525000000000004352 },
{ /*  4 f=  400 */ 3.81385322371667578878, 0.02977777777777779189, -0.94044444444444441622 },
{ /*  5 f=  500 */ 3.77506060360234929618, 0.03715277777777775681, -0.92569444444444448639 },
{ /*  6 f=  600 */ 3.73680645287035506641, 0.04449999999999998401, -0.91100000000000003197 },
{ /*  7 f=  700 */ 3.69908238377371123562, 0.05181944444444447351, -0.89636111111111105298 },
{ /*  8 f=  800 */ 3.66188015432926983195, 0.05911111111111111427, -0.88177777777777777146 },
{ /*  9 f=  900 */ 3.62519166558305983017, 0.06637500000000001732, -0.86724999999999996536 },
{ /* 10 f= 1000 */ 3.58900895893059157515, 0.07361111111111112715, -0.85277777777777774570 },
{ /* 11 f= 1100 */ 3.55332421349093952045, 0.08081944444444444375, -0.83836111111111111249 },
{ /* 12 f= 1200 */ 3.51812974353347485135, 0.08800000000000002265, -0.82399999999999995470 },
{ /* 13 f= 1300 */ 3.48341799595612622298, 0.09515277777777780832, -0.80969444444444438336 },
{ /* 14 f= 1400 */ 3.44918154781406771647, 0.10227777777777780077, -0.79544444444444439846 },
{ /* 15 f= 1500 */ 3.41541310389778818291, 0.10937500000000000000, -0.78125000000000000000 },
{ /* 16 f= 1600 */ 3.38210549435946461472, 0.11644444444444446152, -0.76711111111111107697 },
{ /* 17 f= 1700 */ 3.34925167238665766334, 0.12348611111111112981, -0.75302777777777774038 },
{ /* 18 f= 1800 */ 3.31684471192230079239, 0.13050000000000000488, -0.73899999999999999023 },
{ /* 19 f= 1900 */ 3.28487780543001717248, 0.13748611111111108674, -0.72502777777777782653 },
{ /* 20 f= 2000 */ 3.25334426170382018384, 0.14444444444444443088, -0.71111111111111113825 },
{ /* 21 f= 2100 */ 3.22223750372124628782, 0.15137499999999998179, -0.69725000000000003642 },
{ /* 22 f= 2200 */ 3.19155106653902498337, 0.15827777777777779500, -0.68344444444444441000 },
{ /* 23 f= 2300 */ 3.16127859523037946232, 0.16515277777777781498, -0.66969444444444437003 },
{ /* 24 f= 2400 */ 3.13141384286309865104, 0.17199999999999998623, -0.65600000000000002753 },
{ /* 25 f= 2500 */ 3.10195066851751333203, 0.17881944444444447528, -0.64236111111111104943 },
{ /* 26 f= 2600 */ 3.07288303534355833335, 0.18561111111111111560, -0.62877777777777776880 },
{ /* 27 f= 2700 */ 3.04420500865608945062, 0.19237500000000001821, -0.61524999999999996358 },
{ /* 28 f= 2800 */ 3.01591075406766684353, 0.19911111111111112759, -0.60177777777777774482 },
{ /* 29 f= 2900 */ 2.98799453565801886867, 0.20581944444444444375, -0.58836111111111111249 },
{ /* 30 f= 3000 */ 2.96045071417942917691, 0.21250000000000002220, -0.57499999999999995559 },
{ /* 31 f= 3100 */ 2.93327374529729523189, 0.21915277777777780743, -0.56169444444444438513 },
{ /* 32 f= 3200 */ 2.90645817786512683512, 0.22577777777777779944, -0.54844444444444440112 },
{ /* 33 f= 3300 */ 2.87999865223327766728, 0.23237499999999999822, -0.53525000000000000355 },
{ /* 34 f= 3400 */ 2.85388989859070463240, 0.23894444444444445930, -0.52211111111111108141 },
{ /* 35 f= 3500 */ 2.82812673533907377177, 0.24548611111111112715, -0.50902777777777774570 },
{ /* 36 f= 3600 */ 2.80270406749854350537, 0.25200000000000000178, -0.49599999999999999645 },
{ /* 37 f= 3700 */ 2.77761688514457460997, 0.25848611111111113869, -0.48302777777777772261 },
{ /* 38 f= 3800 */ 2.75286026187512389285, 0.26494444444444442688, -0.47011111111111114624 },
{ /* 39 f= 3900 */ 2.72842935330759628343, 0.27137500000000003286, -0.45724999999999998979 },
{ /* 40 f= 4000 */ 2.70431939560494249974, 0.27777777777777779011, -0.44444444444444447528 },
{ /* 41 f= 4100 */ 2.68052570403030987478, 0.28415277777777780965, -0.43169444444444443620 },
{ /* 42 f= 4200 */ 2.65704367152964904264, 0.29049999999999998046, -0.41900000000000003908 },
{ /* 43 f= 4300 */ 2.63386876734171293535, 0.29681944444444441356, -0.40636111111111111738 },
{ /* 44 f= 4400 */ 2.61099653563488676156, 0.30311111111111110894, -0.39377777777777778212 },
{ /* 45 f= 4500 */ 2.58842259417029252333, 0.30937500000000001110, -0.38124999999999997780 },
{ /* 46 f= 4600 */ 2.56614263299063916079, 0.31561111111111117555, -0.36877777777777770440 },
{ /* 47 f= 4700 */ 2.54415241313429252301, 0.32181944444444443576, -0.35636111111111112848 },
{ /* 48 f= 4800 */ 2.52244776537404336025, 0.32800000000000001377, -0.34399999999999997247 },
{ /* 49 f= 4900 */ 2.50102458898008572774, 0.33415277777777774304, -0.33169444444444445841 },
{ /* 50 f= 5000 */ 2.47987885050669465414, 0.34027777777777779011, -0.31944444444444441977 },
{ /* 51 f= 5100 */ 2.45900658260213944573, 0.34637499999999998845, -0.30725000000000002309 },
{ /* 52 f= 5200 */ 2.43840388284134768071, 0.35244444444444444908, -0.29511111111111110183 },
{ /* 53 f= 5300 */ 2.41806691258087047558, 0.35848611111111111649, -0.28302777777777776702 },
{ /* 54 f= 5400 */ 2.39799189583568761464, 0.36450000000000004619, -0.27099999999999996314 },
{ /* 55 f= 5500 */ 2.37817511817742044400, 0.37048611111111107164, -0.25902777777777780122 },
{ /* 56 f= 5600 */ 2.35861292565350977313, 0.37644444444444447040, -0.24711111111111108696 },
{ /* 57 f= 5700 */ 2.33930172372695022176, 0.38237500000000002043, -0.23525000000000001465 },
{ /* 58 f= 5800 */ 2.32023797623615024577, 0.38827777777777777724, -0.22344444444444441777 },
{ /* 59 f= 5900 */ 2.30141820437453015202, 0.39415277777777779633, -0.21169444444444446285 },
{ /* 60 f= 6000 */ 2.28283898568944687568, 0.40000000000000002220, -0.19999999999999998335 },
{ /* 61 f= 6100 */ 2.26449695310006804405, 0.40581944444444439934, -0.18836111111111114580 },
{ /* 62 f= 6200 */ 2.24638879393381074578, 0.41161111111111114980, -0.17677777777777770041 },
{ /* 63 f= 6300 */ 2.22851124898097285865, 0.41737500000000005151, -0.16524999999999995248 },
{ /* 64 f= 6400 */ 2.21086111156719811177, 0.42311111111111110450, -0.15377777777777776325 },
{ /* 65 f= 6500 */ 2.19343522664341072925, 0.42881944444444441977, -0.14236111111111113270 },
{ /* 66 f= 6600 */ 2.17623048989288081501, 0.43450000000000005285, -0.13099999999999992206 },
{ /* 67 f= 6700 */ 2.15924384685507186887, 0.44015277777777778168, -0.11969444444444440889 },
{ /* 68 f= 6800 */ 2.14247229206593781115, 0.44577777777777777279, -0.10844444444444444053 },
{ /* 69 f= 6900 */ 2.12591286821434666265, 0.45137499999999997069, -0.09725000000000004474 },
{ /* 70 f= 7000 */ 2.10956266531430802758, 0.45694444444444448639, -0.08611111111111104111 },
{ /* 71 f= 7100 */ 2.09341881989268685516, 0.46248611111111115335, -0.07502777777777774881 },
{ /* 72 f= 7200 */ 2.07747851419210638468, 0.46799999999999997158, -0.06400000000000001521 },
{ /* 73 f= 7300 */ 2.06173897538873296398, 0.47348611111111110761, -0.05302777777777782642 },
{ /* 74 f= 7400 */ 2.04619747482464653388, 0.47894444444444445041, -0.04211111111111105060 },
{ /* 75 f= 7500 */ 2.03085132725452321978, 0.48437500000000000000, -0.03124999999999997918 },
{ /* 76 f= 7600 */ 2.01569789010632494097, 0.48977777777777775636, -0.02044444444444446299 },
{ /* 77 f= 7700 */ 2.00073456275574335095, 0.49515277777777783053, -0.00969444444444435803 },
{ /* 78 f= 7800 */ 1.98595878581411455777, 0.50050000000000005596, 0.00100000000000004794 },
{ /* 79 f= 7900 */ 1.97136804042954261185, 0.50581944444444448816, 0.01163888888888889826 },
{ /* 80 f= 8000 */ 1.95695984760097529964, 0.51111111111111107164, 0.02222222222222219531 },
{ /* 81 f= 8100 */ 1.94273176750497666987, 0.51637500000000002842, 0.03275000000000007766 },
{ /* 82 f= 8200 */ 1.92868139883495004483, 0.52161111111111113647, 0.04322222222222225907 },
{ /* 83 f= 8300 */ 1.91480637815256327094, 0.52681944444444439579, 0.05363888888888888873 },
{ /* 84 f= 8400 */ 1.90110437925114506008, 0.53200000000000002842, 0.06399999999999995970 },
{ /* 85 f= 8500 */ 1.88757311253081683233, 0.53715277777777781232, 0.07430555555555562464 },
{ /* 86 f= 8600 */ 1.87421032438512757956, 0.54227777777777774748, 0.08455555555555557823 },
{ /* 87 f= 8700 */ 1.86101379659897347985, 0.54737499999999994493, 0.09474999999999998701 },
{ /* 88 f= 8800 */ 1.84798134575758221665, 0.55244444444444440467, 0.10488888888888885098 },
{ /* 89 f= 8900 */ 1.83511082266634639737, 0.55748611111111112670, 0.11497222222222228116 },
{ /* 90 f= 9000 */ 1.82240011178129601710, 0.56250000000000000000, 0.12500000000000002776 },
{ /* 91 f= 9100 */ 1.80984713065000457632, 0.56748611111111113559, 0.13497222222222221566 },
{ /* 92 f= 9200 */ 1.79744982936272990059, 0.57244444444444453346, 0.14488888888888898365 },
{ /* 93 f= 9300 */ 1.78520619001358826772, 0.57737499999999997158, 0.15475000000000005418 },
{ /* 94 f= 9400 */ 1.77311422617157066206, 0.58227777777777778301, 0.16455555555555556602 },
{ /* 95 f= 9500 */ 1.76117198236121330623, 0.58715277777777774570, 0.17430555555555554692 },
{ /* 96 f= 9600 */ 1.74937753355273528655, 0.59200000000000008171, 0.18400000000000008016 },
{ /* 97 f= 9700 */ 1.73772898466146252794, 0.59681944444444445796, 0.19363888888888891593 },
{ /* 98 f= 9800 */ 1.72622447005635781814, 0.60161111111111109651, 0.20322222222222222077 },
{ /* 99 f= 9900 */ 1.71486215307748746106, 0.60637499999999999734, 0.21274999999999996692 },
{ /*100 f=10000 */ 1.70364022556225092053, 0.61111111111111116045, 0.22222222222222229315 },
{ /*101 f=10100 */ 1.69255690738020714292, 0.61581944444444447484, 0.23163888888888892192 },
{ /*102 f=10200 */ 1.68161044597633035913, 0.62050000000000005151, 0.24099999999999999201 },
{ /*103 f=10300 */ 1.67079911592254326536, 0.62515277777777777946, 0.25030555555555550340 },
{ /*104 f=10400 */ 1.66012121847736038305, 0.62977777777777776969, 0.25955555555555559488 },
{ /*105 f=10500 */ 1.64957508115349682498, 0.63437500000000002220, 0.26875000000000004441 },
{ /*106 f=10600 */ 1.63915905729328481577, 0.63894444444444442599, 0.27788888888888885198 },
{ /*107 f=10700 */ 1.62887152565175385988, 0.64348611111111120309, 0.28697222222222229515 },
{ /*108 f=10800 */ 1.61871088998723000607, 0.64800000000000002043, 0.29600000000000004086 },
{ /*109 f=10900 */ 1.60867557865930854710, 0.65248611111111110006, 0.30497222222222225563 },
{ /*110 f=11000 */ 1.59876404423406803801, 0.65694444444444444198, 0.31388888888888888395 },
{ /*111 f=11100 */ 1.58897476309638263636, 0.66137500000000004619, 0.32275000000000009237 },
{ /*112 f=11200 */ 1.57930623506920397858, 0.66577777777777780166, 0.33155555555555560332 },
{ /*113 f=11300 */ 1.56975698303967958758, 0.67015277777777781942, 0.34030555555555558334 },
{ /*114 f=11400 */ 1.56032555259198191244, 0.67449999999999998845, 0.34899999999999997691 },
{ /*115 f=11500 */ 1.55101051164671899230, 0.67881944444444441977, 0.35763888888888895057 },
{ /*116 f=11600 */ 1.54181045010680972673, 0.68311111111111111338, 0.36622222222222222676 },
{ /*117 f=11700 */ 1.53272397950969696545, 0.68737499999999995826, 0.37474999999999997202 },
{ /*118 f=11800 */ 1.52374973268578450813, 0.69161111111111106542, 0.38322222222222218635 },
{ /*119 f=11900 */ 1.51488636342298121917, 0.69581944444444443487, 0.39163888888888892525 },
{ /*120 f=12000 */ 1.50613254613723945852, 0.69999999999999995559, 0.40000000000000002220 },
{ /*121 f=12100 */ 1.49748697554897458595, 0.70415277777777773860, 0.40830555555555553271 },
{ /*122 f=12200 */ 1.48894836636526228801, 0.70827777777777778390, 0.41655555555555551228 },
{ /*123 f=12300 */ 1.48051545296769893056, 0.71237499999999998046, 0.42474999999999996092 },
{ /*124 f=12400 */ 1.47218698910582834749, 0.71644444444444443931, 0.43288888888888898965 },
{ /*125 f=12500 */ 1.46396174759602826221, 0.72048611111111116045, 0.44097222222222232091 },
{ /*126 f=12600 */ 1.45583852002575664386, 0.72450000000000003286, 0.44900000000000006573 },
{ /*127 f=12700 */ 1.44781611646306207497, 0.72848611111111116756, 0.45697222222222227961 },
{ /*128 f=12800 */ 1.43989336517125665615, 0.73244444444444445352, 0.46488888888888890705 },
{ /*129 f=12900 */ 1.43206911232866396233, 0.73637500000000000178, 0.47275000000000000355 },
{ /*130 f=13000 */ 1.42434222175334346261, 0.74027777777777781232, 0.48055555555555551361 },
{ /*131 f=13100 */ 1.41671157463270436239, 0.74415277777777777413, 0.48830555555555549274 },
{ /*132 f=13200 */ 1.40917606925791805139, 0.74799999999999999822, 0.49600000000000010747 },
{ /*133 f=13300 */ 1.40173462076304344848, 0.75181944444444448461, 0.50363888888888896922 },
{ /*134 f=13400 */ 1.39438616086877886779, 0.75561111111111112226, 0.51122222222222224453 },
{ /*135 f=13500 */ 1.38712963763075691759, 0.75937500000000002220, 0.51875000000000004441 },
{ /*136 f=13600 */ 1.37996401519230116328, 0.76311111111111107341, 0.52622222222222225785 },
{ /*137 f=13700 */ 1.37288827354156373062, 0.76681944444444449793, 0.53363888888888888484 },
{ /*138 f=13800 */ 1.36590140827296524506, 0.77049999999999996270, 0.54099999999999992539 },
{ /*139 f=13900 */ 1.35900243035285628324, 0.77415277777777791179, 0.54830555555555571257 },
{ /*140 f=14000 */ 1.35219036588933616549, 0.77777777777777790114, 0.55555555555555569125 },
{ /*141 f=14100 */ 1.34546425590613649703, 0.78137500000000004174, 0.56275000000000008349 },
{ /*142 f=14200 */ 1.33882315612051550069, 0.78494444444444444464, 0.56988888888888888928 },
{ /*143 f=14300 */ 1.33226613672507854247, 0.78848611111111110983, 0.57697222222222221966 },
{ /*144 f=14400 */ 1.32579228217346312135, 0.79200000000000003730, 0.58399999999999996358 },
{ /*145 f=14500 */ 1.31940069096981393848, 0.79548611111111111605, 0.59097222222222223209 },
{ /*146 f=14600 */ 1.31309047546198587320, 0.79894444444444445708, 0.59788888888888880313 },
{ /*147 f=14700 */ 1.30686076163840514397, 0.80237500000000006040, 0.60475000000000012079 },
{ /*148 f=14800 */ 1.30071068892852870214, 0.80577777777777781498, 0.61155555555555562997 },
{ /*149 f=14900 */ 1.29463941000683124827, 0.80915277777777783186, 0.61830555555555555269 },
{ /*150 f=15000 */ 1.28864609060026880094, 0.81250000000000000000, 0.62500000000000000000 },
{ /*151 f=15100 */ 1.28272990929914576519, 0.81581944444444443043, 0.63163888888888886086 },
{ /*152 f=15200 */ 1.27689005737133753904, 0.81911111111111112315, 0.63822222222222224630 },
{ /*153 f=15300 */ 1.27112573857980004632, 0.82237499999999996714, 0.64474999999999993427 },
{ /*154 f=15400 */ 1.26543616900331779007, 0.82561111111111118444, 0.65122222222222236887 },
{ /*155 f=15500 */ 1.25982057686042980826, 0.82881944444444455300, 0.65763888888888899498 },
{ /*156 f=15600 */ 1.25427820233647535630, 0.83200000000000007283, 0.66400000000000003464 },
{ /*157 f=15700 */ 1.24880829741371623953, 0.83515277777777785495, 0.67030555555555559888 },
{ /*158 f=15800 */ 1.24341012570446918239, 0.83827777777777778834, 0.67655555555555557667 },
{ /*159 f=15900 */ 1.23808296228720915444, 0.84137499999999998401, 0.68274999999999996803 },
{ /*160 f=16000 */ 1.23282609354558325698, 0.84444444444444444198, 0.68888888888888888395 },
{ /*161 f=16100 */ 1.22763881701029120563, 0.84748611111111116223, 0.69497222222222221344 },
{ /*162 f=16200 */ 1.22252044120378267067, 0.85050000000000003375, 0.70100000000000006750 },
{ /*163 f=16300 */ 1.21747028548772018297, 0.85348611111111116756, 0.70697222222222233512 },
{ /*164 f=16400 */ 1.21248767991316719339, 0.85644444444444445264, 0.71288888888888890527 },
{ /*165 f=16500 */ 1.20757196507344866099, 0.85937500000000000000, 0.71875000000000000000 },
{ /*166 f=16600 */ 1.20272249195964398005, 0.86227777777777769863, 0.72455555555555550828 },
{ /*167 f=16700 */ 1.19793862181866561656, 0.86515277777777777057, 0.73030555555555554115 },
{ /*168 f=16800 */ 1.19321972601388237578, 0.86799999999999999378, 0.73599999999999998757 },
{ /*169 f=16900 */ 1.18856518588824178195, 0.87081944444444447928, 0.74163888888888895856 },
{ /*170 f=17000 */ 1.18397439262985448849, 0.87361111111111111605, 0.74722222222222234311 },
{ /*171 f=17100 */ 1.17944674713999364535, 0.87637500000000001510, 0.75275000000000003020 },
{ /*172 f=17200 */ 1.17498165990347769316, 0.87911111111111117644, 0.75822222222222224186 },
{ /*173 f=17300 */ 1.17057855086138973277, 0.88181944444444448905, 0.76363888888888886708 },
{ /*174 f=17400 */ 1.16623684928610016343, 0.88450000000000006395, 0.76900000000000001688 },
{ /*175 f=17500 */ 1.16195599365855239959, 0.88715277777777779011, 0.77430555555555558023 },
{ /*176 f=17600 */ 1.15773543154777525110, 0.88977777777777777857, 0.77955555555555555713 },
{ /*177 f=17700 */ 1.15357461949259021416, 0.89237500000000002931, 0.78475000000000005862 },
{ /*178 f=17800 */ 1.14947302288546793214, 0.89494444444444454234, 0.78988888888888897366 },
{ /*179 f=17900 */ 1.14543011585851362000, 0.89748611111111120664, 0.79497222222222230226 },
{ /*180 f=18000 */ 1.14144538117153349077, 0.90000000000000002220, 0.80000000000000004441 },
{ /*181 f=18100 */ 1.13751831010215753714, 0.90248611111111110006, 0.80497222222222220012 },
{ /*182 f=18200 */ 1.13364840233798647162, 0.90494444444444444020, 0.80988888888888888040 },
{ /*183 f=18300 */ 1.12983516587072307935, 0.90737500000000004263, 0.81474999999999997424 },
{ /*184 f=18400 */ 1.12607811689226688934, 0.90977777777777779633, 0.81955555555555559266 },
{ /*185 f=18500 */ 1.12237677969273308420, 0.91215277777777781232, 0.82430555555555562464 },
{ /*186 f=18600 */ 1.11873068656036989132, 0.91450000000000009059, 0.82900000000000007017 },
{ /*187 f=18700 */ 1.11513937768334758793, 0.91681944444444440911, 0.83363888888888892925 },
{ /*188 f=18800 */ 1.11160240105338026240, 0.91911111111111110095, 0.83822222222222220189 },
{ /*189 f=18900 */ 1.10811931237116589877, 0.92137500000000005507, 0.84274999999999999911 },
{ /*190 f=19000 */ 1.10468967495360570474, 0.92361111111111116045, 0.84722222222222220989 },
{ /*191 f=19100 */ 1.10131305964278247700, 0.92581944444444441711, 0.85163888888888883422 },
{ /*192 f=19200 */ 1.09798904471666647353, 0.92800000000000004707, 0.85600000000000009415 },
{ /*193 f=19300 */ 1.09471721580152880904, 0.93015277777777782831, 0.86030555555555554559 },
{ /*194 f=19400 */ 1.09149716578603017680, 0.93227777777777776080, 0.86455555555555563263 },
{ /*195 f=19500 */ 1.08832849473696668952, 0.93437499999999995559, 0.86875000000000002220 },
{ /*196 f=19600 */ 1.08521080981664197473, 0.93644444444444441267, 0.87288888888888893636 },
{ /*197 f=19700 */ 1.08214372520184798354, 0.93848611111111113203, 0.87697222222222215304 },
{ /*198 f=19800 */ 1.07912686200442631268, 0.94050000000000000266, 0.88100000000000000533 },
{ /*199 f=19900 */ 1.07615984819338827982, 0.94248611111111113559, 0.88497222222222227117 },
{ /*200 f=20000 */ 1.07324231851857421205, 0.94444444444444441977, 0.88888888888888895057 },
{ /*201 f=20100 */ 1.07037391443582641237, 0.94637499999999996625, 0.89275000000000004352 },
{ /*202 f=20200 */ 1.06755428403365582035, 0.94827777777777777501, 0.89655555555555555003 },
{ /*203 f=20300 */ 1.06478308196138193864, 0.95015277777777784607, 0.90030555555555558112 },
{ /*204 f=20400 */ 1.06205996935872581943, 0.95199999999999995737, 0.90400000000000002576 },
{ /*205 f=20500 */ 1.05938461378683190794, 0.95381944444444444198, 0.90763888888888888395 },
{ /*206 f=20600 */ 1.05675668916070675252, 0.95561111111111107785, 0.91122222222222215571 },
{ /*207 f=20700 */ 1.05417587568304860213, 0.95737500000000008704, 0.91475000000000006306 },
{ /*208 f=20800 */ 1.05164185977945101591, 0.95911111111111113647, 0.91822222222222227295 },
{ /*209 f=20900 */ 1.04915433403496494158, 0.96081944444444444819, 0.92163888888888889639 },
{ /*210 f=21000 */ 1.04671299713199639214, 0.96250000000000002220, 0.92500000000000004441 },
{ /*211 f=21100 */ 1.04431755378952639823, 0.96415277777777785850, 0.92830555555555560598 },
{ /*212 f=21200 */ 1.04196771470363502843, 0.96577777777777784607, 0.93155555555555558112 },
{ /*213 f=21300 */ 1.03966319648931038166, 0.96737499999999998490, 0.93474999999999996980 },
{ /*214 f=21400 */ 1.03740372162352878505, 0.96894444444444438602, 0.93788888888888888307 },
{ /*215 f=21500 */ 1.03518901838959020978, 0.97048611111111116045, 0.94097222222222220989 },
{ /*216 f=21600 */ 1.03301882082269158580, 0.97199999999999997513, 0.94400000000000006128 },
{ /*217 f=21700 */ 1.03089286865672336013, 0.97348611111111105210, 0.94697222222222221522 },
{ /*218 f=21800 */ 1.02881090727227575421, 0.97494444444444439135, 0.94988888888888889372 },
{ /*219 f=21900 */ 1.02677268764583762284, 0.97637499999999999289, 0.95274999999999998579 },
{ /*220 f=22000 */ 1.02477796630017770063, 0.97777777777777774570, 0.95555555555555549141 },
{ /*221 f=22100 */ 1.02282650525588869606, 0.97915277777777776080, 0.95830555555555552161 },
{ /*222 f=22200 */ 1.02091807198408646151, 0.98050000000000003819, 0.96100000000000007638 },
{ /*223 f=22300 */ 1.01905243936024714202, 0.98181944444444446685, 0.96363888888888893369 },
{ /*224 f=22400 */ 1.01722938561917297662, 0.98311111111111104677, 0.96622222222222220456 },
{ /*225 f=22500 */ 1.01544869431106898894, 0.98437500000000000000, 0.96875000000000000000 },
{ /*226 f=22600 */ 1.01371015425872434967, 0.98561111111111110450, 0.97122222222222220900 },
{ /*227 f=22700 */ 1.01201355951578264580, 0.98681944444444447129, 0.97363888888888883155 },
{ /*228 f=22800 */ 1.01035870932609106454, 0.98799999999999998934, 0.97599999999999997868 },
{ /*229 f=22900 */ 1.00874540808411650161, 0.98915277777777776969, 0.97830555555555553937 },
{ /*230 f=23000 */ 1.00717346529641771369, 0.99027777777777781232, 0.98055555555555562464 },
{ /*231 f=23100 */ 1.00564269554416529928, 0.99137500000000000622, 0.98275000000000001243 },
{ /*232 f=23200 */ 1.00415291844669396504, 0.99244444444444446241, 0.98488888888888892481 },
{ /*233 f=23300 */ 1.00270395862608263648, 0.99348611111111106986, 0.98697222222222225074 },
{ /*234 f=23400 */ 1.00129564567274798037, 0.99449999999999993960, 0.98899999999999999023 },
{ /*235 f=23500 */ 0.99992781411204867403, 0.99548611111111107164, 0.99097222222222225430 },
{ /*236 f=23600 */ 0.99860030337188021576, 0.99644444444444446596, 0.99288888888888882089 },
{ /*237 f=23700 */ 0.99731295775126338476, 0.99737500000000001155, 0.99475000000000002309 },
{ /*238 f=23800 */ 0.99606562638990947534, 0.99827777777777781942, 0.99655555555555552782 },
{ /*239 f=23900 */ 0.99485816323875719824, 0.99915277777777777857, 0.99830555555555555713 },
{ /*240 f=24000 */ 0.99369042703147381079, 1.00000000000000000000, 1.00000000000000000000 }
};
static FLOAT_T moog_q230[241][3] = {
{ /* dummy entry */ 0, 0, 0},
{ /*  1 f=  100 */ 3.93868500476280036793, 0.00748611111111113781, -0.98502777777777772439 },
{ /*  2 f=  200 */ 3.89817231199242453243, 0.01494444444444442688, -0.97011111111111114624 },
{ /*  3 f=  300 */ 3.85822489187441064473, 0.02237499999999997824, -0.95525000000000004352 },
{ /*  4 f=  400 */ 3.81883389084754742981, 0.02977777777777779189, -0.94044444444444441622 },
{ /*  5 f=  500 */ 3.77999060986176349530, 0.03715277777777775681, -0.92569444444444448639 },
{ /*  6 f=  600 */ 3.74168650146753245522, 0.04449999999999998401, -0.91100000000000003197 },
{ /*  7 f=  700 */ 3.70391316696397066011, 0.05181944444444447351, -0.89636111111111105298 },
{ /*  8 f=  800 */ 3.66666235360438674817, 0.05911111111111111427, -0.88177777777777777146 },
{ /*  9 f=  900 */ 3.62992595185805289049, 0.06637500000000001732, -0.86724999999999996536 },
{ /* 10 f= 1000 */ 3.59369599272701290005, 0.07361111111111112715, -0.85277777777777774570 },
{ /* 11 f= 1100 */ 3.55796464511673171671, 0.08081944444444444375, -0.83836111111111111249 },
{ /* 12 f= 1200 */ 3.52272421325947115989, 0.08800000000000002265, -0.82399999999999995470 },
{ /* 13 f= 1300 */ 3.48796713418925330430, 0.09515277777777780832, -0.80969444444444438336 },
{ /* 14 f= 1400 */ 3.45368597526732612479, 0.10227777777777780077, -0.79544444444444439846 },
{ /* 15 f= 1500 */ 3.41987343175706381970, 0.10937500000000000000, -0.78125000000000000000 },
{ /* 16 f= 1600 */ 3.38652232444724665683, 0.11644444444444446152, -0.76711111111111107697 },
{ /* 17 f= 1700 */ 3.35362559732271403590, 0.12348611111111112981, -0.75302777777777774038 },
{ /* 18 f= 1800 */ 3.32117631528137735586, 0.13050000000000000488, -0.73899999999999999023 },
{ /* 19 f= 1900 */ 3.28916766189662013176, 0.13748611111111108674, -0.72502777777777782653 },
{ /* 20 f= 2000 */ 3.25759293722413501015, 0.14444444444444443088, -0.71111111111111113825 },
{ /* 21 f= 2100 */ 3.22644555565225532590, 0.15137499999999998179, -0.69725000000000003642 },
{ /* 22 f= 2200 */ 3.19571904379487703451, 0.15827777777777779500, -0.68344444444444441000 },
{ /* 23 f= 2300 */ 3.16540703842606374607, 0.16515277777777781498, -0.66969444444444437003 },
{ /* 24 f= 2400 */ 3.13550328445547998868, 0.17199999999999998623, -0.65600000000000002753 },
{ /* 25 f= 2500 */ 3.10600163294377784595, 0.17881944444444447528, -0.64236111111111104943 },
{ /* 26 f= 2600 */ 3.07689603915712250881, 0.18561111111111111560, -0.62877777777777776880 },
{ /* 27 f= 2700 */ 3.04818056066002140980, 0.19237500000000001821, -0.61524999999999996358 },
{ /* 28 f= 2800 */ 3.01984935544566868160, 0.19911111111111112759, -0.60177777777777774482 },
{ /* 29 f= 2900 */ 2.99189668010301978995, 0.20581944444444444375, -0.58836111111111111249 },
{ /* 30 f= 3000 */ 2.96431688801983428405, 0.21250000000000002220, -0.57499999999999995559 },
{ /* 31 f= 3100 */ 2.93710442762093570934, 0.21915277777777780743, -0.56169444444444438513 },
{ /* 32 f= 3200 */ 2.91025384064095815617, 0.22577777777777779944, -0.54844444444444440112 },
{ /* 33 f= 3300 */ 2.88375976043086934553, 0.23237499999999999822, -0.53525000000000000355 },
{ /* 34 f= 3400 */ 2.85761691029756459415, 0.23894444444444445930, -0.52211111111111108141 },
{ /* 35 f= 3500 */ 2.83182010187584731753, 0.24548611111111112715, -0.50902777777777774570 },
{ /* 36 f= 3600 */ 2.80636423353213437792, 0.25200000000000000178, -0.49599999999999999645 },
{ /* 37 f= 3700 */ 2.78124428879922058755, 0.25848611111111113869, -0.48302777777777772261 },
{ /* 38 f= 3800 */ 2.75645533484147220449, 0.26494444444444442688, -0.47011111111111114624 },
{ /* 39 f= 3900 */ 2.73199252094981615002, 0.27137500000000003286, -0.45724999999999998979 },
{ /* 40 f= 4000 */ 2.70785107706591432475, 0.27777777777777779011, -0.44444444444444447528 },
{ /* 41 f= 4100 */ 2.68402631233492350304, 0.28415277777777780965, -0.43169444444444443620 },
{ /* 42 f= 4200 */ 2.66051361368625371995, 0.29049999999999998046, -0.41900000000000003908 },
{ /* 43 f= 4300 */ 2.63730844444175183128, 0.29681944444444441356, -0.40636111111111111738 },
{ /* 44 f= 4400 */ 2.61440634295074936233, 0.30311111111111110894, -0.39377777777777778212 },
{ /* 45 f= 4500 */ 2.59180292125142397452, 0.30937500000000001110, -0.38124999999999997780 },
{ /* 46 f= 4600 */ 2.56949386375793364934, 0.31561111111111117555, -0.36877777777777770440 },
{ /* 47 f= 4700 */ 2.54747492597281111060, 0.32181944444444443576, -0.35636111111111112848 },
{ /* 48 f= 4800 */ 2.52574193322408335760, 0.32800000000000001377, -0.34399999999999997247 },
{ /* 49 f= 4900 */ 2.50429077942663269596, 0.33415277777777774304, -0.33169444444444445841 },
{ /* 50 f= 5000 */ 2.48311742586729167215, 0.34027777777777779011, -0.31944444444444441977 },
{ /* 51 f= 5100 */ 2.46221790001320339769, 0.34637499999999998845, -0.30725000000000002309 },
{ /* 52 f= 5200 */ 2.44158829434295787664, 0.35244444444444444908, -0.29511111111111110183 },
{ /* 53 f= 5300 */ 2.42122476520006557621, 0.35848611111111111649, -0.28302777777777776702 },
{ /* 54 f= 5400 */ 2.40112353166829173290, 0.36450000000000004619, -0.27099999999999996314 },
{ /* 55 f= 5500 */ 2.38128087446843439423, 0.37048611111111107164, -0.25902777777777780122 },
{ /* 56 f= 5600 */ 2.36169313487608789615, 0.37644444444444447040, -0.24711111111111108696 },
{ /* 57 f= 5700 */ 2.34235671365999298388, 0.38237500000000002043, -0.23525000000000001465 },
{ /* 58 f= 5800 */ 2.32326807004054103345, 0.38827777777777777724, -0.22344444444444441777 },
{ /* 59 f= 5900 */ 2.30442372066803535802, 0.39415277777777779633, -0.21169444444444446285 },
{ /* 60 f= 6000 */ 2.28582023862031213923, 0.40000000000000002220, -0.19999999999999998335 },
{ /* 61 f= 6100 */ 2.26745425241933062921, 0.40581944444444439934, -0.18836111111111114580 },
{ /* 62 f= 6200 */ 2.24932244506635248271, 0.41161111111111114980, -0.17677777777777770041 },
{ /* 63 f= 6300 */ 2.23142155309534029328, 0.41737500000000005151, -0.16524999999999995248 },
{ /* 64 f= 6400 */ 2.21374836564421118013, 0.42311111111111110450, -0.15377777777777776325 },
{ /* 65 f= 6500 */ 2.19629972354358038444, 0.42881944444444441977, -0.14236111111111113270 },
{ /* 66 f= 6600 */ 2.17907251842266447284, 0.43450000000000005285, -0.13099999999999992206 },
{ /* 67 f= 6700 */ 2.16206369183198132689, 0.44015277777777778168, -0.11969444444444440889 },
{ /* 68 f= 6800 */ 2.14527023438252673060, 0.44577777777777777279, -0.10844444444444444053 },
{ /* 69 f= 6900 */ 2.12868918490109493291, 0.45137499999999997069, -0.09725000000000004474 },
{ /* 70 f= 7000 */ 2.11231762960142477326, 0.45694444444444448639, -0.08611111111111104111 },
{ /* 71 f= 7100 */ 2.09615270127085562279, 0.46248611111111115335, -0.07502777777777774881 },
{ /* 72 f= 7200 */ 2.08019157847218538748, 0.46799999999999997158, -0.06400000000000001521 },
{ /* 73 f= 7300 */ 2.06443148476043569772, 0.47348611111111110761, -0.05302777777777782642 },
{ /* 74 f= 7400 */ 2.04886968791422097169, 0.47894444444444445041, -0.04211111111111105060 },
{ /* 75 f= 7500 */ 2.03350349918144557293, 0.48437500000000000000, -0.03124999999999997918 },
{ /* 76 f= 7600 */ 2.01833027253902841380, 0.48977777777777775636, -0.02044444444444446299 },
{ /* 77 f= 7700 */ 2.00334740396639832127, 0.49515277777777783053, -0.00969444444444435803 },
{ /* 78 f= 7800 */ 1.98855233073248194309, 0.50050000000000005596, 0.00100000000000004794 },
{ /* 79 f= 7900 */ 1.97394253069591130156, 0.50581944444444448816, 0.01163888888888889826 },
{ /* 80 f= 8000 */ 1.95951552161820519160, 0.51111111111111107164, 0.02222222222222219531 },
{ /* 81 f= 8100 */ 1.94526886048966218823, 0.51637500000000002842, 0.03275000000000007766 },
{ /* 82 f= 8200 */ 1.93120014286772101464, 0.52161111111111113647, 0.04322222222222225907 },
{ /* 83 f= 8300 */ 1.91730700222753847051, 0.52681944444444439579, 0.05363888888888888873 },
{ /* 84 f= 8400 */ 1.90358710932455466036, 0.53200000000000002842, 0.06399999999999995970 },
{ /* 85 f= 8500 */ 1.89003817156880926653, 0.53715277777777781232, 0.07430555555555562464 },
{ /* 86 f= 8600 */ 1.87665793241077372144, 0.54227777777777774748, 0.08455555555555557823 },
{ /* 87 f= 8700 */ 1.86344417073848633848, 0.54737499999999994493, 0.09474999999999998701 },
{ /* 88 f= 8800 */ 1.85039470028576436000, 0.55244444444444440467, 0.10488888888888885098 },
{ /* 89 f= 8900 */ 1.83750736905127864951, 0.55748611111111112670, 0.11497222222222228116 },
{ /* 90 f= 9000 */ 1.82478005872828430434, 0.56250000000000000000, 0.12500000000000002776 },
{ /* 91 f= 9100 */ 1.81221068414479424824, 0.56748611111111113559, 0.13497222222222221566 },
{ /* 92 f= 9200 */ 1.79979719271400573355, 0.57244444444444453346, 0.14488888888888898365 },
{ /* 93 f= 9300 */ 1.78753756389476881061, 0.57737499999999997158, 0.15475000000000005418 },
{ /* 94 f= 9400 */ 1.77542980866191291156, 0.58227777777777778301, 0.16455555555555556602 },
{ /* 95 f= 9500 */ 1.76347196898623881367, 0.58715277777777774570, 0.17430555555555554692 },
{ /* 96 f= 9600 */ 1.75166211732399013101, 0.59200000000000008171, 0.18400000000000008016 },
{ /* 97 f= 9700 */ 1.73999835611562447824, 0.59681944444444445796, 0.19363888888888891593 },
{ /* 98 f= 9800 */ 1.72847881729370045356, 0.60161111111111109651, 0.20322222222222222077 },
{ /* 99 f= 9900 */ 1.71710166179971479572, 0.60637499999999999734, 0.21274999999999996692 },
{ /*100 f=10000 */ 1.70586507910971363344, 0.61111111111111116045, 0.22222222222222229315 },
{ /*101 f=10100 */ 1.69476728676851062794, 0.61581944444444447484, 0.23163888888888892192 },
{ /*102 f=10200 */ 1.68380652993234658510, 0.62050000000000005151, 0.24099999999999999201 },
{ /*103 f=10300 */ 1.67298108091983688261, 0.62515277777777777946, 0.25030555555555550340 },
{ /*104 f=10400 */ 1.66228923877103973439, 0.62977777777777776969, 0.25955555555555559488 },
{ /*105 f=10500 */ 1.65172932881450118536, 0.63437500000000002220, 0.26875000000000004441 },
{ /*106 f=10600 */ 1.64129970224211563234, 0.63894444444444442599, 0.27788888888888885198 },
{ /*107 f=10700 */ 1.63099873569166198273, 0.64348611111111120309, 0.28697222222222229515 },
{ /*108 f=10800 */ 1.62082483083686912373, 0.64800000000000002043, 0.29600000000000004086 },
{ /*109 f=10900 */ 1.61077641398486304247, 0.65248611111111110006, 0.30497222222222225563 },
{ /*110 f=11000 */ 1.60085193568086459059, 0.65694444444444444198, 0.31388888888888888395 },
{ /*111 f=11100 */ 1.59104987031999667302, 0.66137500000000004619, 0.32275000000000009237 },
{ /*112 f=11200 */ 1.58136871576606830025, 0.66577777777777780166, 0.33155555555555560332 },
{ /*113 f=11300 */ 1.57180699297720494201, 0.67015277777777781942, 0.34030555555555558334 },
{ /*114 f=11400 */ 1.56236324563819728439, 0.67449999999999998845, 0.34899999999999997691 },
{ /*115 f=11500 */ 1.55303603979944293556, 0.67881944444444441977, 0.35763888888888895057 },
{ /*116 f=11600 */ 1.54382396352235695680, 0.68311111111111111338, 0.36622222222222222676 },
{ /*117 f=11700 */ 1.53472562653113198117, 0.68737499999999995826, 0.37474999999999997202 },
{ /*118 f=11800 */ 1.52573965987072912576, 0.69161111111111106542, 0.38322222222222218635 },
{ /*119 f=11900 */ 1.51686471557098379037, 0.69581944444444443487, 0.39163888888888892525 },
{ /*120 f=12000 */ 1.50809946631671376593, 0.69999999999999995559, 0.40000000000000002220 },
{ /*121 f=12100 */ 1.49944260512371640992, 0.70415277777777773860, 0.40830555555555553271 },
{ /*122 f=12200 */ 1.49089284502055074988, 0.70827777777777778390, 0.41655555555555551228 },
{ /*123 f=12300 */ 1.48244891873599038412, 0.71237499999999998046, 0.42474999999999996092 },
{ /*124 f=12400 */ 1.47410957839204925790, 0.71644444444444443931, 0.43288888888888898965 },
{ /*125 f=12500 */ 1.46587359520247573208, 0.72048611111111116045, 0.44097222222222232091 },
{ /*126 f=12600 */ 1.45773975917661280377, 0.72450000000000003286, 0.44900000000000006573 },
{ /*127 f=12700 */ 1.44970687882852788952, 0.72848611111111116756, 0.45697222222222227961 },
{ /*128 f=12800 */ 1.44177378089131402739, 0.73244444444444445352, 0.46488888888888890705 },
{ /*129 f=12900 */ 1.43393931003647212563, 0.73637500000000000178, 0.47275000000000000355 },
{ /*130 f=13000 */ 1.42620232859827500427, 0.74027777777777781232, 0.48055555555555551361 },
{ /*131 f=13100 */ 1.41856171630302840825, 0.74415277777777777413, 0.48830555555555549274 },
{ /*132 f=13200 */ 1.41101637000313751003, 0.74799999999999999822, 0.49600000000000010747 },
{ /*133 f=13300 */ 1.40356520341589008360, 0.75181944444444448461, 0.50363888888888896922 },
{ /*134 f=13400 */ 1.39620714686687485973, 0.75561111111111112226, 0.51122222222222224453 },
{ /*135 f=13500 */ 1.38894114703794713250, 0.75937500000000002220, 0.51875000000000004441 },
{ /*136 f=13600 */ 1.38176616671966279171, 0.76311111111111107341, 0.52622222222222225785 },
{ /*137 f=13700 */ 1.37468118456809884620, 0.76681944444444449793, 0.53363888888888888484 },
{ /*138 f=13800 */ 1.36768519486598116863, 0.77049999999999996270, 0.54099999999999992539 },
{ /*139 f=13900 */ 1.36077720728804130168, 0.77415277777777791179, 0.54830555555555571257 },
{ /*140 f=14000 */ 1.35395624667053282586, 0.77777777777777790114, 0.55555555555555569125 },
{ /*141 f=14100 */ 1.34722135278482135767, 0.78137500000000004174, 0.56275000000000008349 },
{ /*142 f=14200 */ 1.34057158011498711581, 0.78494444444444444464, 0.56988888888888888928 },
{ /*143 f=14300 */ 1.33400599763936233977, 0.78848611111111110983, 0.57697222222222221966 },
{ /*144 f=14400 */ 1.32752368861593494920, 0.79200000000000003730, 0.58399999999999996358 },
{ /*145 f=14500 */ 1.32112375037154916591, 0.79548611111111111605, 0.59097222222222223209 },
{ /*146 f=14600 */ 1.31480529409483848369, 0.79894444444444445708, 0.59788888888888880313 },
{ /*147 f=14700 */ 1.30856744463282193003, 0.80237500000000006040, 0.60475000000000012079 },
{ /*148 f=14800 */ 1.30240934029110166925, 0.80577777777777781498, 0.61155555555555562997 },
{ /*149 f=14900 */ 1.29633013263759577782, 0.80915277777777783186, 0.61830555555555555269 },
{ /*150 f=15000 */ 1.29032898630974868226, 0.81250000000000000000, 0.62500000000000000000 },
{ /*151 f=15100 */ 1.28440507882515242422, 0.81581944444444443043, 0.63163888888888886086 },
{ /*152 f=15200 */ 1.27855760039552568408, 0.81911111111111112315, 0.63822222222222224630 },
{ /*153 f=15300 */ 1.27278575374398594811, 0.82237499999999996714, 0.64474999999999993427 },
{ /*154 f=15400 */ 1.26708875392556308270, 0.82561111111111118444, 0.65122222222222236887 },
{ /*155 f=15500 */ 1.26146582815089480789, 0.82881944444444455300, 0.65763888888888899498 },
{ /*156 f=15600 */ 1.25591621561304767063, 0.83200000000000007283, 0.66400000000000003464 },
{ /*157 f=15700 */ 1.25043916731741600046, 0.83515277777777785495, 0.67030555555555559888 },
{ /*158 f=15800 */ 1.24503394591463822927, 0.83827777777777778834, 0.67655555555555557667 },
{ /*159 f=15900 */ 1.23969982553648394585, 0.84137499999999998401, 0.68274999999999996803 },
{ /*160 f=16000 */ 1.23443609163465994882, 0.84444444444444444198, 0.68888888888888888395 },
{ /*161 f=16100 */ 1.22924204082248245129, 0.84748611111111116223, 0.69497222222222221344 },
{ /*162 f=16200 */ 1.22411698071937213861, 0.85050000000000003375, 0.70100000000000006750 },
{ /*163 f=16300 */ 1.21906022979811834439, 0.85348611111111116756, 0.70697222222222233512 },
{ /*164 f=16400 */ 1.21407111723487015631, 0.85644444444444445264, 0.71288888888888890527 },
{ /*165 f=16500 */ 1.20914898276180693415, 0.85937500000000000000, 0.71875000000000000000 },
{ /*166 f=16600 */ 1.20429317652244050052, 0.86227777777777769863, 0.72455555555555550828 },
{ /*167 f=16700 */ 1.19950305892950948028, 0.86515277777777777057, 0.73030555555555554115 },
{ /*168 f=16800 */ 1.19477800052542049158, 0.86799999999999999378, 0.73599999999999998757 },
{ /*169 f=16900 */ 1.19011738184519133554, 0.87081944444444447928, 0.74163888888888895856 },
{ /*170 f=17000 */ 1.18552059328186043530, 0.87361111111111111605, 0.74722222222222234311 },
{ /*171 f=17100 */ 1.18098703495431300858, 0.87637500000000001510, 0.75275000000000003020 },
{ /*172 f=17200 */ 1.17651611657749599615, 0.87911111111111117644, 0.75822222222222224186 },
{ /*173 f=17300 */ 1.17210725733496956558, 0.88181944444444448905, 0.76363888888888886708 },
{ /*174 f=17400 */ 1.16775988575376743484, 0.88450000000000006395, 0.76900000000000001688 },
{ /*175 f=17500 */ 1.16347343958152227295, 0.88715277777777779011, 0.77430555555555558023 },
{ /*176 f=17600 */ 1.15924736566582087249, 0.88977777777777777857, 0.77955555555555555713 },
{ /*177 f=17700 */ 1.15508111983575623150, 0.89237500000000002931, 0.78475000000000005862 },
{ /*178 f=17800 */ 1.15097416678563346792, 0.89494444444444454234, 0.78988888888888897366 },
{ /*179 f=17900 */ 1.14692597996080536404, 0.89748611111111120664, 0.79497222222222230226 },
{ /*180 f=18000 */ 1.14293604144559246549, 0.90000000000000002220, 0.80000000000000004441 },
{ /*181 f=18100 */ 1.13900384185326397635, 0.90248611111111110006, 0.80497222222222220012 },
{ /*182 f=18200 */ 1.13512888021804170258, 0.90494444444444444020, 0.80988888888888888040 },
{ /*183 f=18300 */ 1.13131066388909484743, 0.90737500000000004263, 0.81474999999999997424 },
{ /*184 f=18400 */ 1.12754870842649834728, 0.90977777777777779633, 0.81955555555555559266 },
{ /*185 f=18500 */ 1.12384253749911788844, 0.91215277777777781232, 0.82430555555555562464 },
{ /*186 f=18600 */ 1.12019168278439829045, 0.91450000000000009059, 0.82900000000000007017 },
{ /*187 f=18700 */ 1.11659568387002239298, 0.91681944444444440911, 0.83363888888888892925 },
{ /*188 f=18800 */ 1.11305408815740802808, 0.91911111111111110095, 0.83822222222222220189 },
{ /*189 f=18900 */ 1.10956645076702486996, 0.92137500000000005507, 0.84274999999999999911 },
{ /*190 f=19000 */ 1.10613233444549163842, 0.92361111111111116045, 0.84722222222222220989 },
{ /*191 f=19100 */ 1.10275130947443633644, 0.92581944444444441711, 0.85163888888888883422 },
{ /*192 f=19200 */ 1.09942295358108466097, 0.92800000000000004707, 0.85600000000000009415 },
{ /*193 f=19300 */ 1.09614685185056059957, 0.93015277777777782831, 0.86030555555555554559 },
{ /*194 f=19400 */ 1.09292259663986168761, 0.93227777777777776080, 0.86455555555555563263 },
{ /*195 f=19500 */ 1.08974978749349404872, 0.93437499999999995559, 0.86875000000000002220 },
{ /*196 f=19600 */ 1.08662803106073924120, 0.93644444444444441267, 0.87288888888888893636 },
{ /*197 f=19700 */ 1.08355694101452670886, 0.93848611111111113203, 0.87697222222222215304 },
{ /*198 f=19800 */ 1.08053613797189229651, 0.94050000000000000266, 0.88100000000000000533 },
{ /*199 f=19900 */ 1.07756524941599662881, 0.94248611111111113559, 0.88497222222222227117 },
{ /*200 f=20000 */ 1.07464390961968558891, 0.94444444444444441977, 0.88888888888888895057 },
{ /*201 f=20100 */ 1.07177175957056336486, 0.94637499999999996625, 0.89275000000000004352 },
{ /*202 f=20200 */ 1.06894844689756540745, 0.94827777777777777501, 0.89655555555555555003 },
{ /*203 f=20300 */ 1.06617362579900376574, 0.95015277777777784607, 0.90030555555555558112 },
{ /*204 f=20400 */ 1.06344695697206792495, 0.95199999999999995737, 0.90400000000000002576 },
{ /*205 f=20500 */ 1.06076810754375649992, 0.95381944444444444198, 0.90763888888888888395 },
{ /*206 f=20600 */ 1.05813675100322890366, 0.95561111111111107785, 0.91122222222222215571 },
{ /*207 f=20700 */ 1.05555256713554634906, 0.95737500000000008704, 0.91475000000000006306 },
{ /*208 f=20800 */ 1.05301524195679352403, 0.95911111111111113647, 0.91822222222222227295 },
{ /*209 f=20900 */ 1.05052446765055473854, 0.96081944444444444819, 0.92163888888888889639 },
{ /*210 f=21000 */ 1.04807994250573344175, 0.96250000000000002220, 0.92500000000000004441 },
{ /*211 f=21100 */ 1.04568137085569090594, 0.96415277777777785850, 0.92830555555555560598 },
{ /*212 f=21200 */ 1.04332846301869386352, 0.96577777777777784607, 0.93155555555555558112 },
{ /*213 f=21300 */ 1.04102093523964556177, 0.96737499999999998490, 0.93474999999999996980 },
{ /*214 f=21400 */ 1.03875850963309424024, 0.96894444444444438602, 0.93788888888888888307 },
{ /*215 f=21500 */ 1.03654091412749371770, 0.97048611111111116045, 0.94097222222222220989 },
{ /*216 f=21600 */ 1.03436788241070676264, 0.97199999999999997513, 0.94400000000000006128 },
{ /*217 f=21700 */ 1.03223915387673104149, 0.97348611111111105210, 0.94697222222222221522 },
{ /*218 f=21800 */ 1.03015447357363942871, 0.97494444444444439135, 0.94988888888888889372 },
{ /*219 f=21900 */ 1.02811359215271069800, 0.97637499999999999289, 0.95274999999999998579 },
{ /*220 f=22000 */ 1.02611626581874681996, 0.97777777777777774570, 0.95555555555555549141 },
{ /*221 f=22100 */ 1.02416225628155288518, 0.97915277777777776080, 0.95830555555555552161 },
{ /*222 f=22200 */ 1.02225133070857632234, 0.98050000000000003819, 0.96100000000000007638 },
{ /*223 f=22300 */ 1.02038326167868165228, 0.98181944444444446685, 0.96363888888888893369 },
{ /*224 f=22400 */ 1.01855782713705944609, 0.98311111111111104677, 0.96622222222222220456 },
{ /*225 f=22500 */ 1.01677481035124328557, 0.98437500000000000000, 0.96875000000000000000 },
{ /*226 f=22600 */ 1.01503399986823805712, 0.98561111111111110450, 0.97122222222222220900 },
{ /*227 f=22700 */ 1.01333518947273315547, 0.98681944444444447129, 0.97363888888888883155 },
{ /*228 f=22800 */ 1.01167817814640037533, 0.98799999999999998934, 0.97599999999999997868 },
{ /*229 f=22900 */ 1.01006277002825695099, 0.98915277777777776969, 0.97830555555555553937 },
{ /*230 f=23000 */ 1.00848877437608908103, 0.99027777777777781232, 0.98055555555555562464 },
{ /*231 f=23100 */ 1.00695600552892061685, 0.99137500000000000622, 0.98275000000000001243 },
{ /*232 f=23200 */ 1.00546428287052003192, 0.99244444444444446241, 0.98488888888888892481 },
{ /*233 f=23300 */ 1.00401343079393301494, 0.99348611111111106986, 0.98697222222222225074 },
{ /*234 f=23400 */ 1.00260327866703180533, 0.99449999999999993960, 0.98899999999999999023 },
{ /*235 f=23500 */ 1.00123366079907416548, 0.99548611111111107164, 0.99097222222222225430 },
{ /*236 f=23600 */ 0.99990441640825866720, 0.99644444444444446596, 0.99288888888888882089 },
{ /*237 f=23700 */ 0.99861538959026940887, 0.99737500000000001155, 0.99475000000000002309 },
{ /*238 f=23800 */ 0.99736642928780294692, 0.99827777777777781942, 0.99655555555555552782 },
{ /*239 f=23900 */ 0.99615738926106700557, 0.99915277777777777857, 0.99830555555555555713 },
{ /*240 f=24000 */ 0.99498812805924286007, 1.00000000000000000000, 1.00000000000000000000 }
};
static FLOAT_T moog_q240[241][3] = {
{ /* dummy entry */ 0, 0, 0},
{ /*  1 f=  100 */ 3.94276545417329637999, 0.00748611111111113781, -0.98502777777777772439 },
{ /*  2 f=  200 */ 3.90221079054383102047, 0.01494444444444442688, -0.97011111111111114624 },
{ /*  3 f=  300 */ 3.86222198518514048260, 0.02237499999999997824, -0.95525000000000004352 },
{ /*  4 f=  400 */ 3.82279017536378740161, 0.02977777777777779189, -0.94044444444444441622 },
{ /*  5 f=  500 */ 3.78390665301754758332, 0.03715277777777775681, -0.92569444444444448639 },
{ /*  6 f=  600 */ 3.74556286184179754173, 0.04449999999999998401, -0.91100000000000003197 },
{ /*  7 f=  700 */ 3.70775039443465947997, 0.05181944444444447351, -0.89636111111111105298 },
{ /*  8 f=  800 */ 3.67046098949965626801, 0.05911111111111111427, -0.88177777777777777146 },
{ /*  9 f=  900 */ 3.63368652910464451367, 0.06637500000000001732, -0.86724999999999996536 },
{ /* 10 f= 1000 */ 3.59741903599584267326, 0.07361111111111112715, -0.85277777777777774570 },
{ /* 11 f= 1100 */ 3.56165067096575915784, 0.08081944444444444375, -0.83836111111111111249 },
{ /* 12 f= 1200 */ 3.52637373027389422475, 0.08800000000000002265, -0.82399999999999995470 },
{ /* 13 f= 1300 */ 3.49158064311909210886, 0.09515277777777780832, -0.80969444444444438336 },
{ /* 14 f= 1400 */ 3.45726396916243983171, 0.10227777777777780077, -0.79544444444444439846 },
{ /* 15 f= 1500 */ 3.42341639609965753266, 0.10937500000000000000, -0.78125000000000000000 },
{ /* 16 f= 1600 */ 3.39003073728191406389, 0.11644444444444446152, -0.76711111111111107697 },
{ /* 17 f= 1700 */ 3.35709992938406776020, 0.12348611111111112981, -0.75302777777777774038 },
{ /* 18 f= 1800 */ 3.32461703011931364316, 0.13050000000000000488, -0.73899999999999999023 },
{ /* 19 f= 1900 */ 3.29257521599926583633, 0.13748611111111108674, -0.72502777777777782653 },
{ /* 20 f= 2000 */ 3.26096778013852350853, 0.14444444444444443088, -0.71111111111111113825 },
{ /* 21 f= 2100 */ 3.22978813010277354678, 0.15137499999999998179, -0.69725000000000003642 },
{ /* 22 f= 2200 */ 3.19902978579952979032, 0.15827777777777779500, -0.68344444444444441000 },
{ /* 23 f= 2300 */ 3.16868637741059977486, 0.16515277777777781498, -0.66969444444444437003 },
{ /* 24 f= 2400 */ 3.13875164336541878640, 0.17199999999999998623, -0.65600000000000002753 },
{ /* 25 f= 2500 */ 3.10921942835438303021, 0.17881944444444447528, -0.64236111111111104943 },
{ /* 26 f= 2600 */ 3.08008368138135546488, 0.18561111111111111560, -0.62877777777777776880 },
{ /* 27 f= 2700 */ 3.05133845385452406873, 0.19237500000000001821, -0.61524999999999996358 },
{ /* 28 f= 2800 */ 3.02297789771480518439, 0.19911111111111112759, -0.60177777777777774482 },
{ /* 29 f= 2900 */ 2.99499626360102189082, 0.20581944444444444375, -0.58836111111111111249 },
{ /* 30 f= 3000 */ 2.96738789905108379941, 0.21250000000000002220, -0.57499999999999995559 },
{ /* 31 f= 3100 */ 2.94014724673842264835, 0.21915277777777780743, -0.56169444444444438513 },
{ /* 32 f= 3200 */ 2.91326884274294828359, 0.22577777777777779944, -0.54844444444444440112 },
{ /* 33 f= 3300 */ 2.88674731485581892443, 0.23237499999999999822, -0.53525000000000000355 },
{ /* 34 f= 3400 */ 2.86057738091731383889, 0.23894444444444445930, -0.52211111111111108141 },
{ /* 35 f= 3500 */ 2.83475384718712719589, 0.24548611111111112715, -0.50902777777777774570 },
{ /* 36 f= 3600 */ 2.80927160674641962501, 0.25200000000000000178, -0.49599999999999999645 },
{ /* 37 f= 3700 */ 2.78412563793096179410, 0.25848611111111113869, -0.48302777777777772261 },
{ /* 38 f= 3800 */ 2.75931100279473895398, 0.26494444444444442688, -0.47011111111111114624 },
{ /* 39 f= 3900 */ 2.73482284560337651769, 0.27137500000000003286, -0.45724999999999998979 },
{ /* 40 f= 4000 */ 2.71065639135679115057, 0.27777777777777779011, -0.44444444444444447528 },
{ /* 41 f= 4100 */ 2.68680694434044786689, 0.28415277777777780965, -0.43169444444444443620 },
{ /* 42 f= 4200 */ 2.66326988670464848141, 0.29049999999999998046, -0.41900000000000003908 },
{ /* 43 f= 4300 */ 2.64004067707127321185, 0.29681944444444441356, -0.40636111111111111738 },
{ /* 44 f= 4400 */ 2.61711484916741587980, 0.30311111111111110894, -0.39377777777777778212 },
{ /* 45 f= 4500 */ 2.59448801048535671043, 0.30937500000000001110, -0.38124999999999997780 },
{ /* 46 f= 4600 */ 2.57215584096833893568, 0.31561111111111117555, -0.36877777777777770440 },
{ /* 47 f= 4700 */ 2.55011409172162561987, 0.32181944444444443576, -0.35636111111111112848 },
{ /* 48 f= 4800 */ 2.52835858374831312645, 0.32800000000000001377, -0.34399999999999997247 },
{ /* 49 f= 4900 */ 2.50688520670940961921, 0.33415277777777774304, -0.33169444444444445841 },
{ /* 50 f= 5000 */ 2.48568991770766967164, 0.34027777777777779011, -0.31944444444444441977 },
{ /* 51 f= 5100 */ 2.46476874009472091132, 0.34637499999999998845, -0.30725000000000002309 },
{ /* 52 f= 5200 */ 2.44411776230098931606, 0.35244444444444444908, -0.29511111111111110183 },
{ /* 53 f= 5300 */ 2.42373313668798395781, 0.35848611111111111649, -0.28302777777777776702 },
{ /* 54 f= 5400 */ 2.40361107842246912725, 0.36450000000000004619, -0.27099999999999996314 },
{ /* 55 f= 5500 */ 2.38374786437209529311, 0.37048611111111107164, -0.25902777777777780122 },
{ /* 56 f= 5600 */ 2.36413983202204525114, 0.37644444444444447040, -0.24711111111111108696 },
{ /* 57 f= 5700 */ 2.34478337841228157146, 0.38237500000000002043, -0.23525000000000001465 },
{ /* 58 f= 5800 */ 2.32567495909497345963, 0.38827777777777777724, -0.22344444444444441777 },
{ /* 59 f= 5900 */ 2.30681108711169935432, 0.39415277777777779633, -0.21169444444444446285 },
{ /* 60 f= 6000 */ 2.28818833199002824585, 0.40000000000000002220, -0.19999999999999998335 },
{ /* 61 f= 6100 */ 2.26980331875909202566, 0.40581944444444439934, -0.18836111111111114580 },
{ /* 62 f= 6200 */ 2.25165272698376606186, 0.41161111111111114980, -0.17677777777777770041 },
{ /* 63 f= 6300 */ 2.23373328981708541008, 0.41737500000000005151, -0.16524999999999995248 },
{ /* 64 f= 6400 */ 2.21604179307053650305, 0.42311111111111110450, -0.15377777777777776325 },
{ /* 65 f= 6500 */ 2.19857507430185838970, 0.42881944444444441977, -0.14236111111111113270 },
{ /* 66 f= 6600 */ 2.18133002192001779207, 0.43450000000000005285, -0.13099999999999992206 },
{ /* 67 f= 6700 */ 2.16430357430700093246, 0.44015277777777778168, -0.11969444444444440889 },
{ /* 68 f= 6800 */ 2.14749271895609750160, 0.44577777777777777279, -0.10844444444444444053 },
{ /* 69 f= 6900 */ 2.13089449162634814172, 0.45137499999999997069, -0.09725000000000004474 },
{ /* 70 f= 7000 */ 2.11450597551283037134, 0.45694444444444448639, -0.08611111111111104111 },
{ /* 71 f= 7100 */ 2.09832430043247120111, 0.46248611111111115335, -0.07502777777777774881 },
{ /* 72 f= 7200 */ 2.08234664202507957498, 0.46799999999999997158, -0.06400000000000001521 },
{ /* 73 f= 7300 */ 2.06657022096930065302, 0.47348611111111110761, -0.05302777777777782642 },
{ /* 74 f= 7400 */ 2.05099230221318729050, 0.47894444444444445041, -0.04211111111111105060 },
{ /* 75 f= 7500 */ 2.03561019421911471028, 0.48437500000000000000, -0.03124999999999997918 },
{ /* 76 f= 7600 */ 2.02042124822274216100, 0.48977777777777775636, -0.02044444444444446299 },
{ /* 77 f= 7700 */ 2.00542285750575155490, 0.49515277777777783053, -0.00969444444444435803 },
{ /* 78 f= 7800 */ 1.99061245668209862991, 0.50050000000000005596, 0.00100000000000004794 },
{ /* 79 f= 7900 */ 1.97598752099749463973, 0.50581944444444448816, 0.01163888888888889826 },
{ /* 80 f= 8000 */ 1.96154556564187720902, 0.51111111111111107164, 0.02222222222222219531 },
{ /* 81 f= 8100 */ 1.94728414507460434457, 0.51637500000000002842, 0.03275000000000007766 },
{ /* 82 f= 8200 */ 1.93320085236212979574, 0.52161111111111113647, 0.04322222222222225907 },
{ /* 83 f= 8300 */ 1.91929331852790729940, 0.52681944444444439579, 0.05363888888888888873 },
{ /* 84 f= 8400 */ 1.90555921191429677997, 0.53200000000000002842, 0.06399999999999995970 },
{ /* 85 f= 8500 */ 1.89199623755623069776, 0.53715277777777781232, 0.07430555555555562464 },
{ /* 86 f= 8600 */ 1.87860213656641139579, 0.54227777777777774748, 0.08455555555555557823 },
{ /* 87 f= 8700 */ 1.86537468553182161912, 0.54737499999999994493, 0.09474999999999998701 },
{ /* 88 f= 8800 */ 1.85231169592132172141, 0.55244444444444440467, 0.10488888888888885098 },
{ /* 89 f= 8900 */ 1.83941101350412550275, 0.55748611111111112670, 0.11497222222222228116 },
{ /* 90 f= 9000 */ 1.82667051777893663100, 0.56250000000000000000, 0.12500000000000002776 },
{ /* 91 f= 9100 */ 1.81408812141354536251, 0.56748611111111113559, 0.13497222222222221566 },
{ /* 92 f= 9200 */ 1.80166176969468372349, 0.57244444444444453346, 0.14488888888888898365 },
{ /* 93 f= 9300 */ 1.78938943998793531520, 0.57737499999999997158, 0.15475000000000005418 },
{ /* 94 f= 9400 */ 1.77726914120751389170, 0.58227777777777778301, 0.16455555555555556602 },
{ /* 95 f= 9500 */ 1.76529891329571642089, 0.58715277777777774570, 0.17430555555555554692 },
{ /* 96 f= 9600 */ 1.75347682671186433367, 0.59200000000000008171, 0.18400000000000008016 },
{ /* 97 f= 9700 */ 1.74180098193055776790, 0.59681944444444445796, 0.19363888888888891593 },
{ /* 98 f= 9800 */ 1.73026950894905029443, 0.60161111111111109651, 0.20322222222222222077 },
{ /* 99 f= 9900 */ 1.71888056680358780604, 0.60637499999999999734, 0.21274999999999996692 },
{ /*100 f=10000 */ 1.70763234309452638371, 0.61111111111111116045, 0.22222222222222229315 },
{ /*101 f=10100 */ 1.69652305352006860240, 0.61581944444444447484, 0.23163888888888892192 },
{ /*102 f=10200 */ 1.68555094141844996614, 0.62050000000000005151, 0.24099999999999999201 },
{ /*103 f=10300 */ 1.67471427731842048559, 0.62515277777777777946, 0.25030555555555550340 },
{ /*104 f=10400 */ 1.66401135849785597465, 0.62977777777777776969, 0.25955555555555559488 },
{ /*105 f=10500 */ 1.65344050855035473724, 0.63437500000000002220, 0.26875000000000004441 },
{ /*106 f=10600 */ 1.64300007695965777366, 0.63894444444444442599, 0.27788888888888885198 },
{ /*107 f=10700 */ 1.63268843868175261846, 0.64348611111111120309, 0.28697222222222229515 },
{ /*108 f=10800 */ 1.62250399373451337226, 0.64800000000000002043, 0.29600000000000004086 },
{ /*109 f=10900 */ 1.61244516679473171017, 0.65248611111111110006, 0.30497222222222225563 },
{ /*110 f=11000 */ 1.60251040680240430802, 0.65694444444444444198, 0.31388888888888888395 },
{ /*111 f=11100 */ 1.59269818657213835245, 0.66137500000000004619, 0.32275000000000009237 },
{ /*112 f=11200 */ 1.58300700241154035375, 0.66577777777777780166, 0.33155555555555560332 },
{ /*113 f=11300 */ 1.57343537374645947580, 0.67015277777777781942, 0.34030555555555558334 },
{ /*114 f=11400 */ 1.56398184275295415446, 0.67449999999999998845, 0.34899999999999997691 },
{ /*115 f=11500 */ 1.55464497399586010218, 0.67881944444444441977, 0.35763888888888895057 },
{ /*116 f=11600 */ 1.54542335407383446544, 0.68311111111111111338, 0.36622222222222222676 },
{ /*117 f=11700 */ 1.53631559127075423277, 0.68737499999999995826, 0.37474999999999997202 },
{ /*118 f=11800 */ 1.52732031521335276381, 0.69161111111111106542, 0.38322222222222218635 },
{ /*119 f=11900 */ 1.51843617653497808817, 0.69581944444444443487, 0.39163888888888892525 },
{ /*120 f=12000 */ 1.50966184654535862109, 0.69999999999999995559, 0.40000000000000002220 },
{ /*121 f=12100 */ 1.50099601690626593964, 0.70415277777777773860, 0.40830555555555553271 },
{ /*122 f=12200 */ 1.49243739931296559575, 0.70827777777777778390, 0.41655555555555551228 },
{ /*123 f=12300 */ 1.48398472518134760811, 0.71237499999999998046, 0.42474999999999996092 },
{ /*124 f=12400 */ 1.47563674534063293819, 0.71644444444444443931, 0.43288888888888898965 },
{ /*125 f=12500 */ 1.46739222973155647445, 0.72048611111111116045, 0.44097222222222232091 },
{ /*126 f=12600 */ 1.45924996710991949911, 0.72450000000000003286, 0.44900000000000006573 },
{ /*127 f=12700 */ 1.45120876475541837891, 0.72848611111111116756, 0.45697222222222227961 },
{ /*128 f=12800 */ 1.44326744818565022577, 0.73244444444444445352, 0.46488888888888890705 },
{ /*129 f=12900 */ 1.43542486087520382299, 0.73637500000000000178, 0.47275000000000000355 },
{ /*130 f=13000 */ 1.42767986397973833945, 0.74027777777777781232, 0.48055555555555551361 },
{ /*131 f=13100 */ 1.42003133606496456665, 0.74415277777777777413, 0.48830555555555549274 },
{ /*132 f=13200 */ 1.41247817284043408748, 0.74799999999999999822, 0.49600000000000010747 },
{ /*133 f=13300 */ 1.40501928689805377637, 0.75181944444444448461, 0.50363888888888896922 },
{ /*134 f=13400 */ 1.39765360745523725683, 0.75561111111111112226, 0.51122222222222224453 },
{ /*135 f=13500 */ 1.39038008010260982772, 0.75937500000000002220, 0.51875000000000004441 },
{ /*136 f=13600 */ 1.38319766655618603401, 0.76311111111111107341, 0.52622222222222225785 },
{ /*137 f=13700 */ 1.37610534441393750349, 0.76681944444444449793, 0.53363888888888888484 },
{ /*138 f=13800 */ 1.36910210691667488803, 0.77049999999999996270, 0.54099999999999992539 },
{ /*139 f=13900 */ 1.36218696271315931057, 0.77415277777777791179, 0.54830555555555571257 },
{ /*140 f=14000 */ 1.35535893562938158929, 0.77777777777777790114, 0.55555555555555569125 },
{ /*141 f=14100 */ 1.34861706444191775667, 0.78137500000000004174, 0.56275000000000008349 },
{ /*142 f=14200 */ 1.34196040265530003310, 0.78494444444444444464, 0.56988888888888888928 },
{ /*143 f=14300 */ 1.33538801828332931443, 0.78848611111111110983, 0.57697222222222221966 },
{ /*144 f=14400 */ 1.32889899363425501022, 0.79200000000000003730, 0.58399999999999996358 },
{ /*145 f=14500 */ 1.32249242509975828419, 0.79548611111111111605, 0.59097222222222223209 },
{ /*146 f=14600 */ 1.31616742294767097299, 0.79894444444444445708, 0.59788888888888880313 },
{ /*147 f=14700 */ 1.30992311111835935122, 0.80237500000000006040, 0.60475000000000012079 },
{ /*148 f=14800 */ 1.30375862702471678745, 0.80577777777777781498, 0.61155555555555562997 },
{ /*149 f=14900 */ 1.29767312135569157228, 0.80915277777777783186, 0.61830555555555555269 },
{ /*150 f=15000 */ 1.29166575788329840435, 0.81250000000000000000, 0.62500000000000000000 },
{ /*151 f=15100 */ 1.28573571327304359002, 0.81581944444444443043, 0.63163888888888886086 },
{ /*152 f=15200 */ 1.27988217689771111019, 0.81911111111111112315, 0.63822222222222224630 },
{ /*153 f=15300 */ 1.27410435065444516134, 0.82237499999999996714, 0.64474999999999993427 },
{ /*154 f=15400 */ 1.26840144878507832260, 0.82561111111111118444, 0.65122222222222236887 },
{ /*155 f=15500 */ 1.26277269769964384238, 0.82881944444444455300, 0.65763888888888899498 },
{ /*156 f=15600 */ 1.25721733580301808786, 0.83200000000000007283, 0.66400000000000003464 },
{ /*157 f=15700 */ 1.25173461332464208695, 0.83515277777777785495, 0.67030555555555559888 },
{ /*158 f=15800 */ 1.24632379215126576355, 0.83827777777777778834, 0.67655555555555557667 },
{ /*159 f=15900 */ 1.24098414566266446180, 0.84137499999999998401, 0.68274999999999996803 },
{ /*160 f=16000 */ 1.23571495857027802145, 0.84444444444444444198, 0.68888888888888888395 },
{ /*161 f=16100 */ 1.23051552675871889164, 0.84748611111111116223, 0.69497222222222221344 },
{ /*162 f=16200 */ 1.22538515713010687236, 0.85050000000000003375, 0.70100000000000006750 },
{ /*163 f=16300 */ 1.22032316745117341839, 0.85348611111111116756, 0.70697222222222233512 },
{ /*164 f=16400 */ 1.21532888620309975636, 0.85644444444444445264, 0.71288888888888890527 },
{ /*165 f=16500 */ 1.21040165243403152751, 0.85937500000000000000, 0.71875000000000000000 },
{ /*166 f=16600 */ 1.20554081561423442892, 0.86227777777777769863, 0.72455555555555550828 },
{ /*167 f=16700 */ 1.20074573549383956106, 0.86515277777777777057, 0.73030555555555554115 },
{ /*168 f=16800 */ 1.19601578196313940161, 0.86799999999999999378, 0.73599999999999998757 },
{ /*169 f=16900 */ 1.19135033491539088502, 0.87081944444444447928, 0.74163888888888895856 },
{ /*170 f=17000 */ 1.18674878411208362117, 0.87361111111111111605, 0.74722222222222234311 },
{ /*171 f=17100 */ 1.18221052905063084282, 0.87637500000000001510, 0.75275000000000003020 },
{ /*172 f=17200 */ 1.17773497883444777656, 0.87911111111111117644, 0.75822222222222224186 },
{ /*173 f=17300 */ 1.17332155204537347259, 0.88181944444444448905, 0.76363888888888886708 },
{ /*174 f=17400 */ 1.16896967661839923380, 0.88450000000000006395, 0.76900000000000001688 },
{ /*175 f=17500 */ 1.16467878971866878324, 0.88715277777777779011, 0.77430555555555558023 },
{ /*176 f=17600 */ 1.16044833762070687122, 0.88977777777777777857, 0.77955555555555555713 },
{ /*177 f=17700 */ 1.15627777558984923267, 0.89237500000000002931, 0.78475000000000005862 },
{ /*178 f=17800 */ 1.15216656776582793142, 0.89494444444444454234, 0.78988888888888897366 },
{ /*179 f=17900 */ 1.14811418704848922090, 0.89748611111111120664, 0.79497222222222230226 },
{ /*180 f=18000 */ 1.14412011498559662570, 0.90000000000000002220, 0.80000000000000004441 },
{ /*181 f=18100 */ 1.14018384166269837188, 0.90248611111111110006, 0.80497222222222220012 },
{ /*182 f=18200 */ 1.13630486559501941990, 0.90494444444444444020, 0.80988888888888888040 },
{ /*183 f=18300 */ 1.13248269362134612592, 0.90737500000000004263, 0.81474999999999997424 },
{ /*184 f=18400 */ 1.12871684079987710803, 0.90977777777777779633, 0.81955555555555559266 },
{ /*185 f=18500 */ 1.12500683030600234780, 0.91215277777777781232, 0.82430555555555562464 },
{ /*186 f=18600 */ 1.12135219333198787872, 0.91450000000000009059, 0.82900000000000007017 },
{ /*187 f=18700 */ 1.11775246898853275468, 0.91681944444444440911, 0.83363888888888892925 },
{ /*188 f=18800 */ 1.11420720420816610208, 0.91911111111111110095, 0.83822222222222220189 },
{ /*189 f=18900 */ 1.11071595365046515980, 0.92137500000000005507, 0.84274999999999999911 },
{ /*190 f=19000 */ 1.10727827960905789162, 0.92361111111111116045, 0.84722222222222220989 },
{ /*191 f=19100 */ 1.10389375192038641238, 0.92581944444444441711, 0.85163888888888883422 },
{ /*192 f=19200 */ 1.10056194787420569270, 0.92800000000000004707, 0.85600000000000009415 },
{ /*193 f=19300 */ 1.09728245212579000878, 0.93015277777777782831, 0.86030555555555554559 },
{ /*194 f=19400 */ 1.09405485660982226825, 0.93227777777777776080, 0.86455555555555563263 },
{ /*195 f=19500 */ 1.09087876045593934471, 0.93437499999999995559, 0.86875000000000002220 },
{ /*196 f=19600 */ 1.08775376990591432502, 0.93644444444444441267, 0.87288888888888893636 },
{ /*197 f=19700 */ 1.08467949823244458329, 0.93848611111111113203, 0.87697222222222215304 },
{ /*198 f=19800 */ 1.08165556565952791779, 0.94050000000000000266, 0.88100000000000000533 },
{ /*199 f=19900 */ 1.07868159928440032758, 0.94248611111111113559, 0.88497222222222227117 },
{ /*200 f=20000 */ 1.07575723300101655511, 0.94444444444444441977, 0.88888888888888895057 },
{ /*201 f=20100 */ 1.07288210742504719342, 0.94637499999999996625, 0.89275000000000004352 },
{ /*202 f=20200 */ 1.07005586982037326216, 0.94827777777777777501, 0.89655555555555555003 },
{ /*203 f=20300 */ 1.06727817402705893457, 0.95015277777777784607, 0.90030555555555558112 },
{ /*204 f=20400 */ 1.06454868039077821251, 0.95199999999999995737, 0.90400000000000002576 },
{ /*205 f=20500 */ 1.06186705569367600965, 0.95381944444444444198, 0.90763888888888888395 },
{ /*206 f=20600 */ 1.05923297308664876581, 0.95561111111111107785, 0.91122222222222215571 },
{ /*207 f=20700 */ 1.05664611202301705895, 0.95737500000000008704, 0.91475000000000006306 },
{ /*208 f=20800 */ 1.05410615819358066680, 0.95911111111111113647, 0.91822222222222227295 },
{ /*209 f=20900 */ 1.05161280346302832278, 0.96081944444444444819, 0.92163888888888889639 },
{ /*210 f=21000 */ 1.04916574580769283997, 0.96250000000000002220, 0.92500000000000004441 },
{ /*211 f=21100 */ 1.04676468925462740067, 0.96415277777777785850, 0.92830555555555560598 },
{ /*212 f=21200 */ 1.04440934382198991059, 0.96577777777777784607, 0.93155555555555558112 },
{ /*213 f=21300 */ 1.04209942546071587799, 0.96737499999999998490, 0.93474999999999996980 },
{ /*214 f=21400 */ 1.03983465599746582875, 0.96894444444444438602, 0.93788888888888888307 },
{ /*215 f=21500 */ 1.03761476307882949399, 0.97048611111111116045, 0.94097222222222220989 },
{ /*216 f=21600 */ 1.03543948011677233723, 0.97199999999999997513, 0.94400000000000006128 },
{ /*217 f=21700 */ 1.03330854623530599135, 0.97348611111111105210, 0.94697222222222221522 },
{ /*218 f=21800 */ 1.03122170621837505600, 0.97494444444444439135, 0.94988888888888889372 },
{ /*219 f=21900 */ 1.02917871045893472015, 0.97637499999999999289, 0.95274999999999998579 },
{ /*220 f=22000 */ 1.02717931490921654536, 0.97777777777777774570, 0.95555555555555549141 },
{ /*221 f=22100 */ 1.02522328103215953909, 0.97915277777777776080, 0.95830555555555552161 },
{ /*222 f=22200 */ 1.02331037575399741435, 0.98050000000000003819, 0.96100000000000007638 },
{ /*223 f=22300 */ 1.02144037141798849078, 0.98181944444444446685, 0.96363888888888893369 },
{ /*224 f=22400 */ 1.01961304573927602490, 0.98311111111111104677, 0.96622222222222220456 },
{ /*225 f=22500 */ 1.01782818176086053974, 0.98437500000000000000, 0.96875000000000000000 },
{ /*226 f=22600 */ 1.01608556781068259944, 0.98561111111111110450, 0.97122222222222220900 },
{ /*227 f=22700 */ 1.01438499745979449074, 0.98681944444444447129, 0.97363888888888883155 },
{ /*228 f=22800 */ 1.01272626948161414973, 0.98799999999999998934, 0.97599999999999997868 },
{ /*229 f=22900 */ 1.01110918781224889962, 0.98915277777777776969, 0.97830555555555553937 },
{ /*230 f=23000 */ 1.00953356151187634282, 0.99027777777777781232, 0.98055555555555562464 },
{ /*231 f=23100 */ 1.00799920472717774445, 0.99137500000000000622, 0.98275000000000001243 },
{ /*232 f=23200 */ 1.00650593665480414529, 0.99244444444444446241, 0.98488888888888892481 },
{ /*233 f=23300 */ 1.00505358150587342791, 0.99348611111111106986, 0.98697222222222225074 },
{ /*234 f=23400 */ 1.00364196847148456904, 0.99449999999999993960, 0.98899999999999999023 },
{ /*235 f=23500 */ 1.00227093168924086264, 0.99548611111111107164, 0.99097222222222225430 },
{ /*236 f=23600 */ 1.00094031021077189969, 0.99644444444444446596, 0.99288888888888882089 },
{ /*237 f=23700 */ 0.99964994797024608886, 0.99737500000000001155, 0.99475000000000002309 },
{ /*238 f=23800 */ 0.99839969375386583561, 0.99827777777777781942, 0.99655555555555552782 },
{ /*239 f=23900 */ 0.99718940117033527670, 0.99915277777777777857, 0.99830555555555555713 },
{ /*240 f=24000 */ 0.99601892862229379766, 1.00000000000000000000, 1.00000000000000000000 }
};

#define LINEAR_INTERPOLATION
#define CSPLINE_INTERPOLATION
#define FILTER_INTERPOLATION
#define ENVELOPE_PITCH_MODULATION


#ifdef LOOKUP_HACK
#define MAX_DATAVAL 127
#define MIN_DATAVAL -128
#else
#define MAX_DATAVAL 32767
#define MIN_DATAVAL -32768
#endif

#define OVERSHOOT_STEP 50

#define MAX_MOOG_INDEX 160

static resample_t *vib_resample_voice(int, uint32 *, int);
static resample_t *normal_resample_voice(int, uint32 *, int);


static void update_reso(Voice *vp)
{
  FLOAT_T depth=vp->reso_depth / 2.0;
  int32 sweep = vp->reso_sweep << 2;
  int32 reso_vol;

  if (!sweep) return;

      /* Update sweep position */

      if (vp->reso_phase == 0) {
      	vp->reso_sweep_position += sweep;
        if (vp->reso_sweep_position >= (1<<SWEEP_SHIFT))
		vp->reso_phase = 1;
      }
      else {
      	vp->reso_sweep_position -= sweep;
        if (-vp->reso_sweep_position >= (1<<SWEEP_SHIFT))
		vp->reso_phase = 0;
      }
	  /* Need to adjust depth */
      depth *= (FLOAT_T)vp->reso_sweep_position / (FLOAT_T)(1<<SWEEP_SHIFT); /* centibels */
      depth += (FLOAT_T)vp->reso_depth/2.0; /* positive centibels */
      reso_vol = (int32)(depth + 0.5);
//fprintf(stderr,"depth = %f pos = %d factor = %f vol = %d\n", depth, vp->reso_sweep_position,
//	       	(FLOAT_T)vp->reso_sweep_position / (FLOAT_T)(1<<SWEEP_SHIFT), reso_vol );
      if (reso_vol < 0) reso_vol = 0;
      if (reso_vol > vp->reso_max) reso_vol = vp->reso_max;
      vp->reso_volume = reso_vol;
}

static void update_lfo(Voice *vp)
{
  /* FLOAT_T depth=vp->modLfoToFilterFc; */
  FLOAT_T depth=vp->lfo_depth;
  int32 sweep = vp->lfo_sweep << 2;

  if (!sweep) return;
  depth *= 0.01;
  if (depth < 0.1) return;
  if (depth > 0.9) depth = 0.9;

      /* Update sweep position */

      if (vp->lfo_phase == 0) {
      	vp->lfo_sweep_position += sweep;
        if (vp->lfo_sweep_position >= (1<<SWEEP_SHIFT))
		vp->lfo_phase = 1;
      }
      else {
      	vp->lfo_sweep_position -= sweep;
        if (-vp->lfo_sweep_position >= (1<<SWEEP_SHIFT))
		vp->lfo_phase = 0;
      }
	  /* Need to adjust depth */
      depth *= (FLOAT_T)vp->lfo_sweep_position / (FLOAT_T)(1<<SWEEP_SHIFT);
      vp->lfo_volume = 1.0 + depth;
}

static int calc_bw_index(Voice *vp)
{
  FLOAT_T mod_amount=vp->modEnvToFilterFc;
  int32 freq = vp->cutoff_freq;
  int ix;

  if (vp->lfo_phase_increment) update_lfo(vp);
  if (vp->reso_phase_increment) update_reso(vp);

/*  if (!vp->lfo_phase_increment && update_modulation_signal(vp)) return 0; */
  if (!vp->lfo_phase_increment && update_modulation_signal(vp)) return 1;

/* printf("mod_amount %f ", mod_amount); */
  if (vp->lfo_volume>0.05) {
	if (mod_amount) mod_amount *= vp->lfo_volume;
	else mod_amount = vp->lfo_volume;
/* printf("lfo %f -> mod %f ", voice[v].lfo_volume, mod_amount); */
  }

  if (mod_amount > 0.05) {
    if (vp->modulation_volume)
       freq =
	(int32)( (double)freq*(1.0 + (mod_amount - 1.0) * (vp->modulation_volume>>22) / 255.0) );
    else freq = (int32)( (double)freq*mod_amount );
/*
printf("v%d freq %d (was %d), modvol %d, mod_amount %f\n", v, (int)freq, (int)voice[v].sample->cutoff_freq,
(int)voice[v].modulation_volume>>22,
mod_amount);
*/
	ix = (freq+50) / 100;
	//if (ix >= MAX_BW_INDEX) ix = MAX_BW_INDEX - 1;
	if (ix > MAX_MOOG_INDEX) ix = MAX_MOOG_INDEX;
	if (ix < 1) ix = 1;
	vp->bw_index = ix;
	return 1;
  }
	ix = (freq+50) / 100;
	//if (ix >= MAX_BW_INDEX) ix = MAX_BW_INDEX - 1;
	if (ix > MAX_MOOG_INDEX) ix = MAX_MOOG_INDEX;
	if (ix < 1) ix = 1;
	vp->bw_index = ix;
  /* return 0; */
  return 1;
}

/*************** resampling with fixed increment *****************/

static resample_t *rs_plain(int v, uint32 *countptr)
{
  /* Play sample until end, then free the voice. */
  Voice
    *vp=&voice[v];
  int32   v0, v1, v2, v3, temp, overshoot;
  splen_t ofsd;
  int32 offset;
  FLOAT_T insamp, r, p, k, x, y1m=0, y2=0, y3=0,
    oldx=vp->current_x0, oldy1=vp->current_x1,
    oldy2=vp->current_y0, oldy3=vp->current_y1,
    y4=vp->current_y2;
  uint32 cc_count=vp->modulation_counter, bw_index=vp->bw_index, fmax;
  uint16 reso;
  resample_t newsample;
  resample_t
    *dest=resample_buffer+resample_buffer_offset;
#ifdef SL32
  samplel_t
    *src=vp->sample->ldata;
#else
  sample_t
    *src=vp->sample->data;
#endif
  int32
    incr=vp->sample_increment;
  splen_t
    ofs=vp->sample_offset;
#if defined(LAGRANGE_INTERPOLATION) || defined(CSPLINE_INTERPOLATION)
  splen_t
    ls=0,
    le=vp->sample->data_length;
#endif /* LAGRANGE_INTERPOLATION */
  splen_t
    se=vp->sample->data_length;
  uint32
    count=*countptr;

  if (!incr) return resample_buffer+resample_buffer_offset; /* --gl */

  overshoot = src[(se>>FRACTION_BITS)-1] / OVERSHOOT_STEP;
  if (overshoot < 0) overshoot = -overshoot;

    reso = vp->resonance + vp->reso_volume;
    if (reso > vp->reso_max) reso = vp->reso_max;
    fmax = (1000 + (vp->reso_max - reso) * (vp->reso_max - reso) * 2) / 100;
    if (reso && bw_index > fmax) bw_index = fmax;
    reso = (reso+5)/10;

    switch(reso) {
	case 0:
		r = moog_q0[bw_index][0];
		p = moog_q0[bw_index][1];
		k = moog_q0[bw_index][2];
		
		break;
	case 1:
		r = moog_q10[bw_index][0];
		p = moog_q10[bw_index][1];
		k = moog_q10[bw_index][2];
		
		break;
	case 2:
		r = moog_q20[bw_index][0];
		p = moog_q20[bw_index][1];
		k = moog_q20[bw_index][2];
		
		break;
	case 3:
		r = moog_q30[bw_index][0];
		p = moog_q30[bw_index][1];
		k = moog_q30[bw_index][2];
		
		break;
	case 4:
		r = moog_q40[bw_index][0];
		p = moog_q40[bw_index][1];
		k = moog_q40[bw_index][2];
		
		break;
	case 5:
		r = moog_q50[bw_index][0];
		p = moog_q50[bw_index][1];
		k = moog_q50[bw_index][2];
		
		break;
	case 6:
		r = moog_q60[bw_index][0];
		p = moog_q60[bw_index][1];
		k = moog_q60[bw_index][2];
		
		break;
	case 7:
		r = moog_q70[bw_index][0];
		p = moog_q70[bw_index][1];
		k = moog_q70[bw_index][2];
		
		break;
	case 8:
		r = moog_q80[bw_index][0];
		p = moog_q80[bw_index][1];
		k = moog_q80[bw_index][2];
		
		break;
	case 9:
		r = moog_q90[bw_index][0];
		p = moog_q90[bw_index][1];
		k = moog_q90[bw_index][2];
		
		break;
	case 10:
		r = moog_q100[bw_index][0];
		p = moog_q100[bw_index][1];
		k = moog_q100[bw_index][2];
		
		break;
	case 11:
		r = moog_q110[bw_index][0];
		p = moog_q110[bw_index][1];
		k = moog_q110[bw_index][2];
		
		break;
	case 12:
		r = moog_q120[bw_index][0];
		p = moog_q120[bw_index][1];
		k = moog_q120[bw_index][2];
		
		break;
	case 13:
		r = moog_q130[bw_index][0];
		p = moog_q130[bw_index][1];
		k = moog_q130[bw_index][2];
		
		break;
	case 14:
		r = moog_q140[bw_index][0];
		p = moog_q140[bw_index][1];
		k = moog_q140[bw_index][2];
		
		break;
	case 15:
		r = moog_q150[bw_index][0];
		p = moog_q150[bw_index][1];
		k = moog_q150[bw_index][2];
		
		break;
	case 16:
		r = moog_q160[bw_index][0];
		p = moog_q160[bw_index][1];
		k = moog_q160[bw_index][2];
		
		break;
	case 17:
		r = moog_q170[bw_index][0];
		p = moog_q170[bw_index][1];
		k = moog_q170[bw_index][2];
		
		break;
	case 18:
		r = moog_q180[bw_index][0];
		p = moog_q180[bw_index][1];
		k = moog_q180[bw_index][2];
		
		break;
	case 19:
		r = moog_q190[bw_index][0];
		p = moog_q190[bw_index][1];
		k = moog_q190[bw_index][2];
		
		break;
	case 20:
		r = moog_q200[bw_index][0];
		p = moog_q200[bw_index][1];
		k = moog_q200[bw_index][2];
		
		break;
	case 21:
		r = moog_q210[bw_index][0];
		p = moog_q210[bw_index][1];
		k = moog_q210[bw_index][2];
		
		break;
	case 22:
		r = moog_q220[bw_index][0];
		p = moog_q220[bw_index][1];
		k = moog_q220[bw_index][2];
		
		break;
	case 23:
		r = moog_q230[bw_index][0];
		p = moog_q230[bw_index][1];
		k = moog_q230[bw_index][2];
		
		break;
	default:
	case 24:
		r = moog_q240[bw_index][0];
		p = moog_q240[bw_index][1];
		k = moog_q240[bw_index][2];
		
		break;
    }


    while (count--)
    {


	offset = ofs >> FRACTION_BITS;

	if (ofs >= se) {
		int32 delta = (ofs - se)>>FRACTION_BITS;
        	v1 = (int32)src[(int32)(se>>FRACTION_BITS)-1];
		if (overshoot) v1 -=  (delta+1) * v1 / overshoot;
        }
	else  v1 = (int32)src[offset];

	if (ofs + (1L<<FRACTION_BITS) >= se) {
		v2 = v1;
        }
	else  v2 = (int32)src[offset+1];

	if ( (vp->algorithm & INTERPOLATION_LINEAR) || dont_cspline ||
	   ((ofs-(1L<<FRACTION_BITS))<ls)||((ofs+(2L<<FRACTION_BITS))>le)){
		if (!cc_count--) {
		    cc_count = control_ratio - 1;
		    if (calc_bw_index(vp)) {
		        bw_index = vp->bw_index;


    reso = vp->resonance + vp->reso_volume;
    if (reso > vp->reso_max) reso = vp->reso_max;
    fmax = (1000 + (vp->reso_max - reso) * (vp->reso_max - reso) * 2) / 100;
    if (reso && bw_index > fmax) bw_index = fmax;
    reso = (reso+5)/10;

    switch(reso) {
	case 0:
		r = moog_q0[bw_index][0];
		p = moog_q0[bw_index][1];
		k = moog_q0[bw_index][2];
		
		break;
	case 1:
		r = moog_q10[bw_index][0];
		p = moog_q10[bw_index][1];
		k = moog_q10[bw_index][2];
		
		break;
	case 2:
		r = moog_q20[bw_index][0];
		p = moog_q20[bw_index][1];
		k = moog_q20[bw_index][2];
		
		break;
	case 3:
		r = moog_q30[bw_index][0];
		p = moog_q30[bw_index][1];
		k = moog_q30[bw_index][2];
		
		break;
	case 4:
		r = moog_q40[bw_index][0];
		p = moog_q40[bw_index][1];
		k = moog_q40[bw_index][2];
		
		break;
	case 5:
		r = moog_q50[bw_index][0];
		p = moog_q50[bw_index][1];
		k = moog_q50[bw_index][2];
		
		break;
	case 6:
		r = moog_q60[bw_index][0];
		p = moog_q60[bw_index][1];
		k = moog_q60[bw_index][2];
		
		break;
	case 7:
		r = moog_q70[bw_index][0];
		p = moog_q70[bw_index][1];
		k = moog_q70[bw_index][2];
		
		break;
	case 8:
		r = moog_q80[bw_index][0];
		p = moog_q80[bw_index][1];
		k = moog_q80[bw_index][2];
		
		break;
	case 9:
		r = moog_q90[bw_index][0];
		p = moog_q90[bw_index][1];
		k = moog_q90[bw_index][2];
		
		break;
	case 10:
		r = moog_q100[bw_index][0];
		p = moog_q100[bw_index][1];
		k = moog_q100[bw_index][2];
		
		break;
	case 11:
		r = moog_q110[bw_index][0];
		p = moog_q110[bw_index][1];
		k = moog_q110[bw_index][2];
		
		break;
	case 12:
		r = moog_q120[bw_index][0];
		p = moog_q120[bw_index][1];
		k = moog_q120[bw_index][2];
		
		break;
	case 13:
		r = moog_q130[bw_index][0];
		p = moog_q130[bw_index][1];
		k = moog_q130[bw_index][2];
		
		break;
	case 14:
		r = moog_q140[bw_index][0];
		p = moog_q140[bw_index][1];
		k = moog_q140[bw_index][2];
		
		break;
	case 15:
		r = moog_q150[bw_index][0];
		p = moog_q150[bw_index][1];
		k = moog_q150[bw_index][2];
		
		break;
	case 16:
		r = moog_q160[bw_index][0];
		p = moog_q160[bw_index][1];
		k = moog_q160[bw_index][2];
		
		break;
	case 17:
		r = moog_q170[bw_index][0];
		p = moog_q170[bw_index][1];
		k = moog_q170[bw_index][2];
		
		break;
	case 18:
		r = moog_q180[bw_index][0];
		p = moog_q180[bw_index][1];
		k = moog_q180[bw_index][2];
		
		break;
	case 19:
		r = moog_q190[bw_index][0];
		p = moog_q190[bw_index][1];
		k = moog_q190[bw_index][2];
		
		break;
	case 20:
		r = moog_q200[bw_index][0];
		p = moog_q200[bw_index][1];
		k = moog_q200[bw_index][2];
		
		break;
	case 21:
		r = moog_q210[bw_index][0];
		p = moog_q210[bw_index][1];
		k = moog_q210[bw_index][2];
		
		break;
	case 22:
		r = moog_q220[bw_index][0];
		p = moog_q220[bw_index][1];
		k = moog_q220[bw_index][2];
		
		break;
	case 23:
		r = moog_q230[bw_index][0];
		p = moog_q230[bw_index][1];
		k = moog_q230[bw_index][2];
		
		break;
	default:
	case 24:
		r = moog_q240[bw_index][0];
		p = moog_q240[bw_index][1];
		k = moog_q240[bw_index][2];
		
		break;
    }


		    }
		    incr = calc_mod_freq(vp, incr);
		}
                newsample = (resample_t)(v1 + ((int32)((v2-v1) * (ofs & FRACTION_MASK)) >> FRACTION_BITS));
	        if (bw_index) {
                    insamp = (FLOAT_T)newsample;

		    x = insamp / (FLOAT_T)MAX_DATAVAL;

		    //--Inverted feed back for corner peaking
		    x = x - r*y4;

		    //Four cascaded onepole filters (bilinear transform)
		    y1m = x   * p + oldx  * p - k * y1m;
		    y2  = y1m * p + oldy1 * p - k * y2;
		    y3  = y2  * p + oldy2 * p - k * y3;
		    y4  = y3  * p + oldy3 * p - k * y4;

		    //Clipper band limited sigmoid
		    y4 = y4 - (y4*y4*y4)/6.0;

		    oldx = x;
		    oldy1 = y1m;
		    oldy2 = y2;
		    oldy3 = y3;

		    newsample = (resample_t)(y4 * (FLOAT_T)MAX_DATAVAL);
	        }
	}
	else {
		ofsd=ofs;
                v0 = (int32)src[offset-1];
                v3 = (int32)src[offset+2];
                ofs &= FRACTION_MASK;
                temp=v2;
		v2 = (6*v2 +
		      (((( ( (5*v3 - 11*v2 + 7*v1 - v0)*
		       (int32)ofs) >>FRACTION_BITS)*(int32)ofs)>>(FRACTION_BITS+2))-1))*(int32)ofs;
                ofs = (1L << FRACTION_BITS) - ofs;
		v1 = (6*v1 +
		      ((((((5*v0 - 11*v1 + 7*temp - v3)*
		       (int32)ofs)>>FRACTION_BITS)*(int32)ofs)>>(FRACTION_BITS+2))-1))*(int32)ofs;
		v1 = (v1 + v2)/(6L<<FRACTION_BITS);
		if (!cc_count--) {
		    cc_count = control_ratio - 1;
		    if (calc_bw_index(vp)) {
			bw_index = vp->bw_index;


    reso = vp->resonance + vp->reso_volume;
    if (reso > vp->reso_max) reso = vp->reso_max;
    fmax = (1000 + (vp->reso_max - reso) * (vp->reso_max - reso) * 2) / 100;
    if (reso && bw_index > fmax) bw_index = fmax;
    reso = (reso+5)/10;

    switch(reso) {
	case 0:
		r = moog_q0[bw_index][0];
		p = moog_q0[bw_index][1];
		k = moog_q0[bw_index][2];
		
		break;
	case 1:
		r = moog_q10[bw_index][0];
		p = moog_q10[bw_index][1];
		k = moog_q10[bw_index][2];
		
		break;
	case 2:
		r = moog_q20[bw_index][0];
		p = moog_q20[bw_index][1];
		k = moog_q20[bw_index][2];
		
		break;
	case 3:
		r = moog_q30[bw_index][0];
		p = moog_q30[bw_index][1];
		k = moog_q30[bw_index][2];
		
		break;
	case 4:
		r = moog_q40[bw_index][0];
		p = moog_q40[bw_index][1];
		k = moog_q40[bw_index][2];
		
		break;
	case 5:
		r = moog_q50[bw_index][0];
		p = moog_q50[bw_index][1];
		k = moog_q50[bw_index][2];
		
		break;
	case 6:
		r = moog_q60[bw_index][0];
		p = moog_q60[bw_index][1];
		k = moog_q60[bw_index][2];
		
		break;
	case 7:
		r = moog_q70[bw_index][0];
		p = moog_q70[bw_index][1];
		k = moog_q70[bw_index][2];
		
		break;
	case 8:
		r = moog_q80[bw_index][0];
		p = moog_q80[bw_index][1];
		k = moog_q80[bw_index][2];
		
		break;
	case 9:
		r = moog_q90[bw_index][0];
		p = moog_q90[bw_index][1];
		k = moog_q90[bw_index][2];
		
		break;
	case 10:
		r = moog_q100[bw_index][0];
		p = moog_q100[bw_index][1];
		k = moog_q100[bw_index][2];
		
		break;
	case 11:
		r = moog_q110[bw_index][0];
		p = moog_q110[bw_index][1];
		k = moog_q110[bw_index][2];
		
		break;
	case 12:
		r = moog_q120[bw_index][0];
		p = moog_q120[bw_index][1];
		k = moog_q120[bw_index][2];
		
		break;
	case 13:
		r = moog_q130[bw_index][0];
		p = moog_q130[bw_index][1];
		k = moog_q130[bw_index][2];
		
		break;
	case 14:
		r = moog_q140[bw_index][0];
		p = moog_q140[bw_index][1];
		k = moog_q140[bw_index][2];
		
		break;
	case 15:
		r = moog_q150[bw_index][0];
		p = moog_q150[bw_index][1];
		k = moog_q150[bw_index][2];
		
		break;
	case 16:
		r = moog_q160[bw_index][0];
		p = moog_q160[bw_index][1];
		k = moog_q160[bw_index][2];
		
		break;
	case 17:
		r = moog_q170[bw_index][0];
		p = moog_q170[bw_index][1];
		k = moog_q170[bw_index][2];
		
		break;
	case 18:
		r = moog_q180[bw_index][0];
		p = moog_q180[bw_index][1];
		k = moog_q180[bw_index][2];
		
		break;
	case 19:
		r = moog_q190[bw_index][0];
		p = moog_q190[bw_index][1];
		k = moog_q190[bw_index][2];
		
		break;
	case 20:
		r = moog_q200[bw_index][0];
		p = moog_q200[bw_index][1];
		k = moog_q200[bw_index][2];
		
		break;
	case 21:
		r = moog_q210[bw_index][0];
		p = moog_q210[bw_index][1];
		k = moog_q210[bw_index][2];
		
		break;
	case 22:
		r = moog_q220[bw_index][0];
		p = moog_q220[bw_index][1];
		k = moog_q220[bw_index][2];
		
		break;
	case 23:
		r = moog_q230[bw_index][0];
		p = moog_q230[bw_index][1];
		k = moog_q230[bw_index][2];
		
		break;
	default:
	case 24:
		r = moog_q240[bw_index][0];
		p = moog_q240[bw_index][1];
		k = moog_q240[bw_index][2];
		
		break;
    }




		    }
		    incr = calc_mod_freq(vp, incr);
		}
		newsample = (resample_t)v1;
		if (bw_index) {
                    insamp = (FLOAT_T)newsample;

		    x = insamp / (FLOAT_T)MAX_DATAVAL;

		    //--Inverted feed back for corner peaking
		    x = x - r*y4;

		    //Four cascaded onepole filters (bilinear transform)
		    y1m = x   * p + oldx  * p - k * y1m;
		    y2  = y1m * p + oldy1 * p - k * y2;
		    y3  = y2  * p + oldy2 * p - k * y3;
		    y4  = y3  * p + oldy3 * p - k * y4;

		    //Clipper band limited sigmoid
		    y4 = y4 - (y4*y4*y4)/6.0;

		    oldx = x;
		    oldy1 = y1m;
		    oldy2 = y2;
		    oldy3 = y3;

		    newsample = (resample_t)(y4 * (FLOAT_T)MAX_DATAVAL);
		}
		ofs=ofsd;
	}
	*dest++ = newsample;
      ofs += incr;
      if (ofs >= se + (overshoot << FRACTION_BITS))
	{
	  if (!(vp->status&VOICE_FREE))
	    {
	      vp->status=VOICE_FREE;
 	      ctl->note(v);
	    }
	  *countptr-=count+1;
	  break;
	}
    }

  vp->sample_offset=ofs; /* Update offset */

  vp->current_x0=oldx;
  vp->current_x1=oldy1;
  vp->current_y0=oldy2;
  vp->current_y1=oldy3;
  vp->current_y2=y4;
  vp->bw_index=bw_index;
  vp->modulation_counter=cc_count;
  return resample_buffer+resample_buffer_offset;
}

static resample_t *rs_loop(int v, Voice *vp, uint32 *countptr)
{
  /* Play sample until end-of-loop, skip back and continue. */
  int32   v0, v1, v2, v3, temp, overshoot;
  splen_t ofsd;
  int32 offset;
  FLOAT_T insamp, r, p, k, x, y1m=0, y2=0, y3=0,
    oldx=vp->current_x0, oldy1=vp->current_x1,
    oldy2=vp->current_y0, oldy3=vp->current_y1,
    y4=vp->current_y2;
  uint32 cc_count=vp->modulation_counter, bw_index=vp->bw_index, fmax;
  uint16 reso;
  resample_t newsample;
  int32
    incr=vp->sample_increment;
  splen_t
    ofs=vp->sample_offset,
    le=vp->loop_end,
#if defined(LAGRANGE_INTERPOLATION) || defined(CSPLINE_INTERPOLATION)
    ls=vp->loop_start,
#endif /* LAGRANGE_INTERPOLATION */
    ll=le - vp->loop_start;
  resample_t
    *dest=resample_buffer+resample_buffer_offset;
#ifdef SL32
  samplel_t
    *src=vp->sample->ldata;
#else
  sample_t
    *src=vp->sample->data;
#endif
  splen_t
    se=vp->sample->data_length;
  uint32
    count = *countptr;
  int
    flag_exit_loop;


  flag_exit_loop =
	(vp->status & (VOICE_FREE | VOICE_DIE)) ||
	((vp->status & VOICE_OFF) && (vp->sample->modes & MODES_FAST_RELEASE) ) ||
	((vp->status & VOICE_OFF) && dont_keep_looping ) ;

  overshoot = src[(se>>FRACTION_BITS)-1] / OVERSHOOT_STEP;
  if (overshoot < 0) overshoot = -overshoot;

    reso = vp->resonance + vp->reso_volume;
    if (reso > vp->reso_max) reso = vp->reso_max;
    fmax = (1000 + (vp->reso_max - reso) * (vp->reso_max - reso) * 2) / 100;
    if (reso && bw_index > fmax) bw_index = fmax;
    reso = (reso+5)/10;

    switch(reso) {
	case 0:
		r = moog_q0[bw_index][0];
		p = moog_q0[bw_index][1];
		k = moog_q0[bw_index][2];
		
		break;
	case 1:
		r = moog_q10[bw_index][0];
		p = moog_q10[bw_index][1];
		k = moog_q10[bw_index][2];
		
		break;
	case 2:
		r = moog_q20[bw_index][0];
		p = moog_q20[bw_index][1];
		k = moog_q20[bw_index][2];
		
		break;
	case 3:
		r = moog_q30[bw_index][0];
		p = moog_q30[bw_index][1];
		k = moog_q30[bw_index][2];
		
		break;
	case 4:
		r = moog_q40[bw_index][0];
		p = moog_q40[bw_index][1];
		k = moog_q40[bw_index][2];
		
		break;
	case 5:
		r = moog_q50[bw_index][0];
		p = moog_q50[bw_index][1];
		k = moog_q50[bw_index][2];
		
		break;
	case 6:
		r = moog_q60[bw_index][0];
		p = moog_q60[bw_index][1];
		k = moog_q60[bw_index][2];
		
		break;
	case 7:
		r = moog_q70[bw_index][0];
		p = moog_q70[bw_index][1];
		k = moog_q70[bw_index][2];
		
		break;
	case 8:
		r = moog_q80[bw_index][0];
		p = moog_q80[bw_index][1];
		k = moog_q80[bw_index][2];
		
		break;
	case 9:
		r = moog_q90[bw_index][0];
		p = moog_q90[bw_index][1];
		k = moog_q90[bw_index][2];
		
		break;
	case 10:
		r = moog_q100[bw_index][0];
		p = moog_q100[bw_index][1];
		k = moog_q100[bw_index][2];
		
		break;
	case 11:
		r = moog_q110[bw_index][0];
		p = moog_q110[bw_index][1];
		k = moog_q110[bw_index][2];
		
		break;
	case 12:
		r = moog_q120[bw_index][0];
		p = moog_q120[bw_index][1];
		k = moog_q120[bw_index][2];
		
		break;
	case 13:
		r = moog_q130[bw_index][0];
		p = moog_q130[bw_index][1];
		k = moog_q130[bw_index][2];
		
		break;
	case 14:
		r = moog_q140[bw_index][0];
		p = moog_q140[bw_index][1];
		k = moog_q140[bw_index][2];
		
		break;
	case 15:
		r = moog_q150[bw_index][0];
		p = moog_q150[bw_index][1];
		k = moog_q150[bw_index][2];
		
		break;
	case 16:
		r = moog_q160[bw_index][0];
		p = moog_q160[bw_index][1];
		k = moog_q160[bw_index][2];
		
		break;
	case 17:
		r = moog_q170[bw_index][0];
		p = moog_q170[bw_index][1];
		k = moog_q170[bw_index][2];
		
		break;
	case 18:
		r = moog_q180[bw_index][0];
		p = moog_q180[bw_index][1];
		k = moog_q180[bw_index][2];
		
		break;
	case 19:
		r = moog_q190[bw_index][0];
		p = moog_q190[bw_index][1];
		k = moog_q190[bw_index][2];
		
		break;
	case 20:
		r = moog_q200[bw_index][0];
		p = moog_q200[bw_index][1];
		k = moog_q200[bw_index][2];
		
		break;
	case 21:
		r = moog_q210[bw_index][0];
		p = moog_q210[bw_index][1];
		k = moog_q210[bw_index][2];
		
		break;
	case 22:
		r = moog_q220[bw_index][0];
		p = moog_q220[bw_index][1];
		k = moog_q220[bw_index][2];
		
		break;
	case 23:
		r = moog_q230[bw_index][0];
		p = moog_q230[bw_index][1];
		k = moog_q230[bw_index][2];
		
		break;
	default:
	case 24:
		r = moog_q240[bw_index][0];
		p = moog_q240[bw_index][1];
		k = moog_q240[bw_index][2];
		
		break;
    }


  while (count--)
    {


	offset = ofs >> FRACTION_BITS;

	if (ofs >= se) {
		int32 delta = (ofs - se)>>FRACTION_BITS;
        	v1 = (int32)src[(int32)(se>>FRACTION_BITS)-1];
		if (overshoot) v1 -=  (delta+1) * v1 / overshoot;
        }
	else  v1 = (int32)src[offset];

	if (ofs + (1L<<FRACTION_BITS) >= se) {
		v2 = v1;
        }
	else  v2 = (int32)src[offset+1];

	if ( (vp->algorithm & INTERPOLATION_LINEAR) || dont_cspline ||
	   ((ofs-(1L<<FRACTION_BITS))<ls)||((ofs+(2L<<FRACTION_BITS))>le)){
		if (!cc_count--) {
		    cc_count = control_ratio - 1;
		    if (calc_bw_index(vp)) {
		        bw_index = vp->bw_index;


    reso = vp->resonance + vp->reso_volume;
    if (reso > vp->reso_max) reso = vp->reso_max;
    fmax = (1000 + (vp->reso_max - reso) * (vp->reso_max - reso) * 2) / 100;
    if (reso && bw_index > fmax) bw_index = fmax;
    reso = (reso+5)/10;

    switch(reso) {
	case 0:
		r = moog_q0[bw_index][0];
		p = moog_q0[bw_index][1];
		k = moog_q0[bw_index][2];
		
		break;
	case 1:
		r = moog_q10[bw_index][0];
		p = moog_q10[bw_index][1];
		k = moog_q10[bw_index][2];
		
		break;
	case 2:
		r = moog_q20[bw_index][0];
		p = moog_q20[bw_index][1];
		k = moog_q20[bw_index][2];
		
		break;
	case 3:
		r = moog_q30[bw_index][0];
		p = moog_q30[bw_index][1];
		k = moog_q30[bw_index][2];
		
		break;
	case 4:
		r = moog_q40[bw_index][0];
		p = moog_q40[bw_index][1];
		k = moog_q40[bw_index][2];
		
		break;
	case 5:
		r = moog_q50[bw_index][0];
		p = moog_q50[bw_index][1];
		k = moog_q50[bw_index][2];
		
		break;
	case 6:
		r = moog_q60[bw_index][0];
		p = moog_q60[bw_index][1];
		k = moog_q60[bw_index][2];
		
		break;
	case 7:
		r = moog_q70[bw_index][0];
		p = moog_q70[bw_index][1];
		k = moog_q70[bw_index][2];
		
		break;
	case 8:
		r = moog_q80[bw_index][0];
		p = moog_q80[bw_index][1];
		k = moog_q80[bw_index][2];
		
		break;
	case 9:
		r = moog_q90[bw_index][0];
		p = moog_q90[bw_index][1];
		k = moog_q90[bw_index][2];
		
		break;
	case 10:
		r = moog_q100[bw_index][0];
		p = moog_q100[bw_index][1];
		k = moog_q100[bw_index][2];
		
		break;
	case 11:
		r = moog_q110[bw_index][0];
		p = moog_q110[bw_index][1];
		k = moog_q110[bw_index][2];
		
		break;
	case 12:
		r = moog_q120[bw_index][0];
		p = moog_q120[bw_index][1];
		k = moog_q120[bw_index][2];
		
		break;
	case 13:
		r = moog_q130[bw_index][0];
		p = moog_q130[bw_index][1];
		k = moog_q130[bw_index][2];
		
		break;
	case 14:
		r = moog_q140[bw_index][0];
		p = moog_q140[bw_index][1];
		k = moog_q140[bw_index][2];
		
		break;
	case 15:
		r = moog_q150[bw_index][0];
		p = moog_q150[bw_index][1];
		k = moog_q150[bw_index][2];
		
		break;
	case 16:
		r = moog_q160[bw_index][0];
		p = moog_q160[bw_index][1];
		k = moog_q160[bw_index][2];
		
		break;
	case 17:
		r = moog_q170[bw_index][0];
		p = moog_q170[bw_index][1];
		k = moog_q170[bw_index][2];
		
		break;
	case 18:
		r = moog_q180[bw_index][0];
		p = moog_q180[bw_index][1];
		k = moog_q180[bw_index][2];
		
		break;
	case 19:
		r = moog_q190[bw_index][0];
		p = moog_q190[bw_index][1];
		k = moog_q190[bw_index][2];
		
		break;
	case 20:
		r = moog_q200[bw_index][0];
		p = moog_q200[bw_index][1];
		k = moog_q200[bw_index][2];
		
		break;
	case 21:
		r = moog_q210[bw_index][0];
		p = moog_q210[bw_index][1];
		k = moog_q210[bw_index][2];
		
		break;
	case 22:
		r = moog_q220[bw_index][0];
		p = moog_q220[bw_index][1];
		k = moog_q220[bw_index][2];
		
		break;
	case 23:
		r = moog_q230[bw_index][0];
		p = moog_q230[bw_index][1];
		k = moog_q230[bw_index][2];
		
		break;
	default:
	case 24:
		r = moog_q240[bw_index][0];
		p = moog_q240[bw_index][1];
		k = moog_q240[bw_index][2];
		
		break;
    }


		    }
		    incr = calc_mod_freq(vp, incr);
		}
                newsample = (resample_t)(v1 + ((int32)((v2-v1) * (ofs & FRACTION_MASK)) >> FRACTION_BITS));
	        if (bw_index) {
                    insamp = (FLOAT_T)newsample;

		    x = insamp / (FLOAT_T)MAX_DATAVAL;

		    //--Inverted feed back for corner peaking
		    x = x - r*y4;

		    //Four cascaded onepole filters (bilinear transform)
		    y1m = x   * p + oldx  * p - k * y1m;
		    y2  = y1m * p + oldy1 * p - k * y2;
		    y3  = y2  * p + oldy2 * p - k * y3;
		    y4  = y3  * p + oldy3 * p - k * y4;

		    //Clipper band limited sigmoid
		    y4 = y4 - (y4*y4*y4)/6.0;

		    oldx = x;
		    oldy1 = y1m;
		    oldy2 = y2;
		    oldy3 = y3;

		    newsample = (resample_t)(y4 * (FLOAT_T)MAX_DATAVAL);
	        }
	}
	else {
		ofsd=ofs;
                v0 = (int32)src[offset-1];
                v3 = (int32)src[offset+2];
                ofs &= FRACTION_MASK;
                temp=v2;
		v2 = (6*v2 +
		      (((( ( (5*v3 - 11*v2 + 7*v1 - v0)*
		       (int32)ofs) >>FRACTION_BITS)*(int32)ofs)>>(FRACTION_BITS+2))-1))*(int32)ofs;
                ofs = (1L << FRACTION_BITS) - ofs;
		v1 = (6*v1 +
		      ((((((5*v0 - 11*v1 + 7*temp - v3)*
		       (int32)ofs)>>FRACTION_BITS)*(int32)ofs)>>(FRACTION_BITS+2))-1))*(int32)ofs;
		v1 = (v1 + v2)/(6L<<FRACTION_BITS);
		if (!cc_count--) {
		    cc_count = control_ratio - 1;
		    if (calc_bw_index(vp)) {
			bw_index = vp->bw_index;


    reso = vp->resonance + vp->reso_volume;
    if (reso > vp->reso_max) reso = vp->reso_max;
    fmax = (1000 + (vp->reso_max - reso) * (vp->reso_max - reso) * 2) / 100;
    if (reso && bw_index > fmax) bw_index = fmax;
    reso = (reso+5)/10;

    switch(reso) {
	case 0:
		r = moog_q0[bw_index][0];
		p = moog_q0[bw_index][1];
		k = moog_q0[bw_index][2];
		
		break;
	case 1:
		r = moog_q10[bw_index][0];
		p = moog_q10[bw_index][1];
		k = moog_q10[bw_index][2];
		
		break;
	case 2:
		r = moog_q20[bw_index][0];
		p = moog_q20[bw_index][1];
		k = moog_q20[bw_index][2];
		
		break;
	case 3:
		r = moog_q30[bw_index][0];
		p = moog_q30[bw_index][1];
		k = moog_q30[bw_index][2];
		
		break;
	case 4:
		r = moog_q40[bw_index][0];
		p = moog_q40[bw_index][1];
		k = moog_q40[bw_index][2];
		
		break;
	case 5:
		r = moog_q50[bw_index][0];
		p = moog_q50[bw_index][1];
		k = moog_q50[bw_index][2];
		
		break;
	case 6:
		r = moog_q60[bw_index][0];
		p = moog_q60[bw_index][1];
		k = moog_q60[bw_index][2];
		
		break;
	case 7:
		r = moog_q70[bw_index][0];
		p = moog_q70[bw_index][1];
		k = moog_q70[bw_index][2];
		
		break;
	case 8:
		r = moog_q80[bw_index][0];
		p = moog_q80[bw_index][1];
		k = moog_q80[bw_index][2];
		
		break;
	case 9:
		r = moog_q90[bw_index][0];
		p = moog_q90[bw_index][1];
		k = moog_q90[bw_index][2];
		
		break;
	case 10:
		r = moog_q100[bw_index][0];
		p = moog_q100[bw_index][1];
		k = moog_q100[bw_index][2];
		
		break;
	case 11:
		r = moog_q110[bw_index][0];
		p = moog_q110[bw_index][1];
		k = moog_q110[bw_index][2];
		
		break;
	case 12:
		r = moog_q120[bw_index][0];
		p = moog_q120[bw_index][1];
		k = moog_q120[bw_index][2];
		
		break;
	case 13:
		r = moog_q130[bw_index][0];
		p = moog_q130[bw_index][1];
		k = moog_q130[bw_index][2];
		
		break;
	case 14:
		r = moog_q140[bw_index][0];
		p = moog_q140[bw_index][1];
		k = moog_q140[bw_index][2];
		
		break;
	case 15:
		r = moog_q150[bw_index][0];
		p = moog_q150[bw_index][1];
		k = moog_q150[bw_index][2];
		
		break;
	case 16:
		r = moog_q160[bw_index][0];
		p = moog_q160[bw_index][1];
		k = moog_q160[bw_index][2];
		
		break;
	case 17:
		r = moog_q170[bw_index][0];
		p = moog_q170[bw_index][1];
		k = moog_q170[bw_index][2];
		
		break;
	case 18:
		r = moog_q180[bw_index][0];
		p = moog_q180[bw_index][1];
		k = moog_q180[bw_index][2];
		
		break;
	case 19:
		r = moog_q190[bw_index][0];
		p = moog_q190[bw_index][1];
		k = moog_q190[bw_index][2];
		
		break;
	case 20:
		r = moog_q200[bw_index][0];
		p = moog_q200[bw_index][1];
		k = moog_q200[bw_index][2];
		
		break;
	case 21:
		r = moog_q210[bw_index][0];
		p = moog_q210[bw_index][1];
		k = moog_q210[bw_index][2];
		
		break;
	case 22:
		r = moog_q220[bw_index][0];
		p = moog_q220[bw_index][1];
		k = moog_q220[bw_index][2];
		
		break;
	case 23:
		r = moog_q230[bw_index][0];
		p = moog_q230[bw_index][1];
		k = moog_q230[bw_index][2];
		
		break;
	default:
	case 24:
		r = moog_q240[bw_index][0];
		p = moog_q240[bw_index][1];
		k = moog_q240[bw_index][2];
		
		break;
    }




		    }
		    incr = calc_mod_freq(vp, incr);
		}
		newsample = (resample_t)v1;
		if (bw_index) {
                    insamp = (FLOAT_T)newsample;

		    x = insamp / (FLOAT_T)MAX_DATAVAL;

		    //--Inverted feed back for corner peaking
		    x = x - r*y4;

		    //Four cascaded onepole filters (bilinear transform)
		    y1m = x   * p + oldx  * p - k * y1m;
		    y2  = y1m * p + oldy1 * p - k * y2;
		    y3  = y2  * p + oldy2 * p - k * y3;
		    y4  = y3  * p + oldy3 * p - k * y4;

		    //Clipper band limited sigmoid
		    y4 = y4 - (y4*y4*y4)/6.0;

		    oldx = x;
		    oldy1 = y1m;
		    oldy2 = y2;
		    oldy3 = y3;

		    newsample = (resample_t)(y4 * (FLOAT_T)MAX_DATAVAL);
		}
		ofs=ofsd;
	}
	*dest++ = newsample;
      ofs += incr;
      if (ofs>=le)
	{
	  if (flag_exit_loop)
	    {
	    	vp->reverb_time -= ll >> FRACTION_BITS;
	  	if (vp->reverb_time >= 0) ofs -= ll;
	    }
	  else ofs -= ll; /* Hopefully the loop is longer than an increment. */
	}
      if (ofs >= se + (overshoot << FRACTION_BITS))
	{
	  if (!(vp->status&VOICE_FREE))
	    {
	      vp->status=VOICE_FREE;
 	      ctl->note(v);
	    }
	  *countptr-=count+1;
	  break;
	}
    }

  vp->sample_offset=ofs; /* Update offset */

  vp->current_x0=oldx;
  vp->current_x1=oldy1;
  vp->current_y0=oldy2;
  vp->current_y1=oldy3;
  vp->current_y2=y4;
  vp->bw_index=bw_index;
  vp->modulation_counter=cc_count;
  return resample_buffer+resample_buffer_offset;
}

static resample_t *rs_bidir(Voice *vp, uint32 count)
{
  int32   v0, v1, v2, v3, temp, overshoot;
  splen_t ofsd;
  int32 offset;
  FLOAT_T insamp, r, p, k, x, y1m=0, y2=0, y3=0,
    oldx=vp->current_x0, oldy1=vp->current_x1,
    oldy2=vp->current_y0, oldy3=vp->current_y1,
    y4=vp->current_y2;
  uint32 cc_count=vp->modulation_counter, bw_index=vp->bw_index, fmax;
  uint16 reso;
  resample_t newsample;
  int32
    incr=vp->sample_increment;
  splen_t
    le=vp->loop_end,
    ls=vp->loop_start,
    ofs=vp->sample_offset,
    se=vp->sample->data_length;
  resample_t
    *dest=resample_buffer+resample_buffer_offset;
#ifdef SL32
  samplel_t
    *src=vp->sample->ldata;
#else
  sample_t
    *src=vp->sample->data;
#endif


#ifdef USE_BIDIR_OVERSHOOT
  int32
    le2 = le<<1,
    ls2 = ls<<1;
#endif
  uint32
    i, j;
  /* Play normally until inside the loop region */

  overshoot = src[(se>>FRACTION_BITS)-1] / OVERSHOOT_STEP;
  if (overshoot < 0) overshoot = -overshoot;

    reso = vp->resonance + vp->reso_volume;
    if (reso > vp->reso_max) reso = vp->reso_max;
    fmax = (1000 + (vp->reso_max - reso) * (vp->reso_max - reso) * 2) / 100;
    if (reso && bw_index > fmax) bw_index = fmax;
    reso = (reso+5)/10;

    switch(reso) {
	case 0:
		r = moog_q0[bw_index][0];
		p = moog_q0[bw_index][1];
		k = moog_q0[bw_index][2];
		
		break;
	case 1:
		r = moog_q10[bw_index][0];
		p = moog_q10[bw_index][1];
		k = moog_q10[bw_index][2];
		
		break;
	case 2:
		r = moog_q20[bw_index][0];
		p = moog_q20[bw_index][1];
		k = moog_q20[bw_index][2];
		
		break;
	case 3:
		r = moog_q30[bw_index][0];
		p = moog_q30[bw_index][1];
		k = moog_q30[bw_index][2];
		
		break;
	case 4:
		r = moog_q40[bw_index][0];
		p = moog_q40[bw_index][1];
		k = moog_q40[bw_index][2];
		
		break;
	case 5:
		r = moog_q50[bw_index][0];
		p = moog_q50[bw_index][1];
		k = moog_q50[bw_index][2];
		
		break;
	case 6:
		r = moog_q60[bw_index][0];
		p = moog_q60[bw_index][1];
		k = moog_q60[bw_index][2];
		
		break;
	case 7:
		r = moog_q70[bw_index][0];
		p = moog_q70[bw_index][1];
		k = moog_q70[bw_index][2];
		
		break;
	case 8:
		r = moog_q80[bw_index][0];
		p = moog_q80[bw_index][1];
		k = moog_q80[bw_index][2];
		
		break;
	case 9:
		r = moog_q90[bw_index][0];
		p = moog_q90[bw_index][1];
		k = moog_q90[bw_index][2];
		
		break;
	case 10:
		r = moog_q100[bw_index][0];
		p = moog_q100[bw_index][1];
		k = moog_q100[bw_index][2];
		
		break;
	case 11:
		r = moog_q110[bw_index][0];
		p = moog_q110[bw_index][1];
		k = moog_q110[bw_index][2];
		
		break;
	case 12:
		r = moog_q120[bw_index][0];
		p = moog_q120[bw_index][1];
		k = moog_q120[bw_index][2];
		
		break;
	case 13:
		r = moog_q130[bw_index][0];
		p = moog_q130[bw_index][1];
		k = moog_q130[bw_index][2];
		
		break;
	case 14:
		r = moog_q140[bw_index][0];
		p = moog_q140[bw_index][1];
		k = moog_q140[bw_index][2];
		
		break;
	case 15:
		r = moog_q150[bw_index][0];
		p = moog_q150[bw_index][1];
		k = moog_q150[bw_index][2];
		
		break;
	case 16:
		r = moog_q160[bw_index][0];
		p = moog_q160[bw_index][1];
		k = moog_q160[bw_index][2];
		
		break;
	case 17:
		r = moog_q170[bw_index][0];
		p = moog_q170[bw_index][1];
		k = moog_q170[bw_index][2];
		
		break;
	case 18:
		r = moog_q180[bw_index][0];
		p = moog_q180[bw_index][1];
		k = moog_q180[bw_index][2];
		
		break;
	case 19:
		r = moog_q190[bw_index][0];
		p = moog_q190[bw_index][1];
		k = moog_q190[bw_index][2];
		
		break;
	case 20:
		r = moog_q200[bw_index][0];
		p = moog_q200[bw_index][1];
		k = moog_q200[bw_index][2];
		
		break;
	case 21:
		r = moog_q210[bw_index][0];
		p = moog_q210[bw_index][1];
		k = moog_q210[bw_index][2];
		
		break;
	case 22:
		r = moog_q220[bw_index][0];
		p = moog_q220[bw_index][1];
		k = moog_q220[bw_index][2];
		
		break;
	case 23:
		r = moog_q230[bw_index][0];
		p = moog_q230[bw_index][1];
		k = moog_q230[bw_index][2];
		
		break;
	default:
	case 24:
		r = moog_q240[bw_index][0];
		p = moog_q240[bw_index][1];
		k = moog_q240[bw_index][2];
		
		break;
    }


  if (ofs <= ls)
    {
      /* NOTE: Assumes that incr > 0, which is NOT always the case
	 when doing bidirectional looping.  I have yet to see a case
	 where both ofs <= ls AND incr < 0, however. */
      if (incr < 0) i = ls - ofs;
	else
      i = (ls - ofs) / incr + 1;
      if (i > count)
	{
	  i = count;
	  count = 0;
	}
      else count -= i;
      for(j = 0; j < i; j++)
	{


	offset = ofs >> FRACTION_BITS;

	if (ofs >= se) {
		int32 delta = (ofs - se)>>FRACTION_BITS;
        	v1 = (int32)src[(int32)(se>>FRACTION_BITS)-1];
		if (overshoot) v1 -=  (delta+1) * v1 / overshoot;
        }
	else  v1 = (int32)src[offset];

	if (ofs + (1L<<FRACTION_BITS) >= se) {
		v2 = v1;
        }
	else  v2 = (int32)src[offset+1];

	if ( (vp->algorithm & INTERPOLATION_LINEAR) || dont_cspline ||
	   ((ofs-(1L<<FRACTION_BITS))<ls)||((ofs+(2L<<FRACTION_BITS))>le)){
		if (!cc_count--) {
		    cc_count = control_ratio - 1;
		    if (calc_bw_index(vp)) {
		        bw_index = vp->bw_index;


    reso = vp->resonance + vp->reso_volume;
    if (reso > vp->reso_max) reso = vp->reso_max;
    fmax = (1000 + (vp->reso_max - reso) * (vp->reso_max - reso) * 2) / 100;
    if (reso && bw_index > fmax) bw_index = fmax;
    reso = (reso+5)/10;

    switch(reso) {
	case 0:
		r = moog_q0[bw_index][0];
		p = moog_q0[bw_index][1];
		k = moog_q0[bw_index][2];
		
		break;
	case 1:
		r = moog_q10[bw_index][0];
		p = moog_q10[bw_index][1];
		k = moog_q10[bw_index][2];
		
		break;
	case 2:
		r = moog_q20[bw_index][0];
		p = moog_q20[bw_index][1];
		k = moog_q20[bw_index][2];
		
		break;
	case 3:
		r = moog_q30[bw_index][0];
		p = moog_q30[bw_index][1];
		k = moog_q30[bw_index][2];
		
		break;
	case 4:
		r = moog_q40[bw_index][0];
		p = moog_q40[bw_index][1];
		k = moog_q40[bw_index][2];
		
		break;
	case 5:
		r = moog_q50[bw_index][0];
		p = moog_q50[bw_index][1];
		k = moog_q50[bw_index][2];
		
		break;
	case 6:
		r = moog_q60[bw_index][0];
		p = moog_q60[bw_index][1];
		k = moog_q60[bw_index][2];
		
		break;
	case 7:
		r = moog_q70[bw_index][0];
		p = moog_q70[bw_index][1];
		k = moog_q70[bw_index][2];
		
		break;
	case 8:
		r = moog_q80[bw_index][0];
		p = moog_q80[bw_index][1];
		k = moog_q80[bw_index][2];
		
		break;
	case 9:
		r = moog_q90[bw_index][0];
		p = moog_q90[bw_index][1];
		k = moog_q90[bw_index][2];
		
		break;
	case 10:
		r = moog_q100[bw_index][0];
		p = moog_q100[bw_index][1];
		k = moog_q100[bw_index][2];
		
		break;
	case 11:
		r = moog_q110[bw_index][0];
		p = moog_q110[bw_index][1];
		k = moog_q110[bw_index][2];
		
		break;
	case 12:
		r = moog_q120[bw_index][0];
		p = moog_q120[bw_index][1];
		k = moog_q120[bw_index][2];
		
		break;
	case 13:
		r = moog_q130[bw_index][0];
		p = moog_q130[bw_index][1];
		k = moog_q130[bw_index][2];
		
		break;
	case 14:
		r = moog_q140[bw_index][0];
		p = moog_q140[bw_index][1];
		k = moog_q140[bw_index][2];
		
		break;
	case 15:
		r = moog_q150[bw_index][0];
		p = moog_q150[bw_index][1];
		k = moog_q150[bw_index][2];
		
		break;
	case 16:
		r = moog_q160[bw_index][0];
		p = moog_q160[bw_index][1];
		k = moog_q160[bw_index][2];
		
		break;
	case 17:
		r = moog_q170[bw_index][0];
		p = moog_q170[bw_index][1];
		k = moog_q170[bw_index][2];
		
		break;
	case 18:
		r = moog_q180[bw_index][0];
		p = moog_q180[bw_index][1];
		k = moog_q180[bw_index][2];
		
		break;
	case 19:
		r = moog_q190[bw_index][0];
		p = moog_q190[bw_index][1];
		k = moog_q190[bw_index][2];
		
		break;
	case 20:
		r = moog_q200[bw_index][0];
		p = moog_q200[bw_index][1];
		k = moog_q200[bw_index][2];
		
		break;
	case 21:
		r = moog_q210[bw_index][0];
		p = moog_q210[bw_index][1];
		k = moog_q210[bw_index][2];
		
		break;
	case 22:
		r = moog_q220[bw_index][0];
		p = moog_q220[bw_index][1];
		k = moog_q220[bw_index][2];
		
		break;
	case 23:
		r = moog_q230[bw_index][0];
		p = moog_q230[bw_index][1];
		k = moog_q230[bw_index][2];
		
		break;
	default:
	case 24:
		r = moog_q240[bw_index][0];
		p = moog_q240[bw_index][1];
		k = moog_q240[bw_index][2];
		
		break;
    }


		    }
		    incr = calc_mod_freq(vp, incr);
		}
                newsample = (resample_t)(v1 + ((int32)((v2-v1) * (ofs & FRACTION_MASK)) >> FRACTION_BITS));
	        if (bw_index) {
                    insamp = (FLOAT_T)newsample;

		    x = insamp / (FLOAT_T)MAX_DATAVAL;

		    //--Inverted feed back for corner peaking
		    x = x - r*y4;

		    //Four cascaded onepole filters (bilinear transform)
		    y1m = x   * p + oldx  * p - k * y1m;
		    y2  = y1m * p + oldy1 * p - k * y2;
		    y3  = y2  * p + oldy2 * p - k * y3;
		    y4  = y3  * p + oldy3 * p - k * y4;

		    //Clipper band limited sigmoid
		    y4 = y4 - (y4*y4*y4)/6.0;

		    oldx = x;
		    oldy1 = y1m;
		    oldy2 = y2;
		    oldy3 = y3;

		    newsample = (resample_t)(y4 * (FLOAT_T)MAX_DATAVAL);
	        }
	}
	else {
		ofsd=ofs;
                v0 = (int32)src[offset-1];
                v3 = (int32)src[offset+2];
                ofs &= FRACTION_MASK;
                temp=v2;
		v2 = (6*v2 +
		      (((( ( (5*v3 - 11*v2 + 7*v1 - v0)*
		       (int32)ofs) >>FRACTION_BITS)*(int32)ofs)>>(FRACTION_BITS+2))-1))*(int32)ofs;
                ofs = (1L << FRACTION_BITS) - ofs;
		v1 = (6*v1 +
		      ((((((5*v0 - 11*v1 + 7*temp - v3)*
		       (int32)ofs)>>FRACTION_BITS)*(int32)ofs)>>(FRACTION_BITS+2))-1))*(int32)ofs;
		v1 = (v1 + v2)/(6L<<FRACTION_BITS);
		if (!cc_count--) {
		    cc_count = control_ratio - 1;
		    if (calc_bw_index(vp)) {
			bw_index = vp->bw_index;


    reso = vp->resonance + vp->reso_volume;
    if (reso > vp->reso_max) reso = vp->reso_max;
    fmax = (1000 + (vp->reso_max - reso) * (vp->reso_max - reso) * 2) / 100;
    if (reso && bw_index > fmax) bw_index = fmax;
    reso = (reso+5)/10;

    switch(reso) {
	case 0:
		r = moog_q0[bw_index][0];
		p = moog_q0[bw_index][1];
		k = moog_q0[bw_index][2];
		
		break;
	case 1:
		r = moog_q10[bw_index][0];
		p = moog_q10[bw_index][1];
		k = moog_q10[bw_index][2];
		
		break;
	case 2:
		r = moog_q20[bw_index][0];
		p = moog_q20[bw_index][1];
		k = moog_q20[bw_index][2];
		
		break;
	case 3:
		r = moog_q30[bw_index][0];
		p = moog_q30[bw_index][1];
		k = moog_q30[bw_index][2];
		
		break;
	case 4:
		r = moog_q40[bw_index][0];
		p = moog_q40[bw_index][1];
		k = moog_q40[bw_index][2];
		
		break;
	case 5:
		r = moog_q50[bw_index][0];
		p = moog_q50[bw_index][1];
		k = moog_q50[bw_index][2];
		
		break;
	case 6:
		r = moog_q60[bw_index][0];
		p = moog_q60[bw_index][1];
		k = moog_q60[bw_index][2];
		
		break;
	case 7:
		r = moog_q70[bw_index][0];
		p = moog_q70[bw_index][1];
		k = moog_q70[bw_index][2];
		
		break;
	case 8:
		r = moog_q80[bw_index][0];
		p = moog_q80[bw_index][1];
		k = moog_q80[bw_index][2];
		
		break;
	case 9:
		r = moog_q90[bw_index][0];
		p = moog_q90[bw_index][1];
		k = moog_q90[bw_index][2];
		
		break;
	case 10:
		r = moog_q100[bw_index][0];
		p = moog_q100[bw_index][1];
		k = moog_q100[bw_index][2];
		
		break;
	case 11:
		r = moog_q110[bw_index][0];
		p = moog_q110[bw_index][1];
		k = moog_q110[bw_index][2];
		
		break;
	case 12:
		r = moog_q120[bw_index][0];
		p = moog_q120[bw_index][1];
		k = moog_q120[bw_index][2];
		
		break;
	case 13:
		r = moog_q130[bw_index][0];
		p = moog_q130[bw_index][1];
		k = moog_q130[bw_index][2];
		
		break;
	case 14:
		r = moog_q140[bw_index][0];
		p = moog_q140[bw_index][1];
		k = moog_q140[bw_index][2];
		
		break;
	case 15:
		r = moog_q150[bw_index][0];
		p = moog_q150[bw_index][1];
		k = moog_q150[bw_index][2];
		
		break;
	case 16:
		r = moog_q160[bw_index][0];
		p = moog_q160[bw_index][1];
		k = moog_q160[bw_index][2];
		
		break;
	case 17:
		r = moog_q170[bw_index][0];
		p = moog_q170[bw_index][1];
		k = moog_q170[bw_index][2];
		
		break;
	case 18:
		r = moog_q180[bw_index][0];
		p = moog_q180[bw_index][1];
		k = moog_q180[bw_index][2];
		
		break;
	case 19:
		r = moog_q190[bw_index][0];
		p = moog_q190[bw_index][1];
		k = moog_q190[bw_index][2];
		
		break;
	case 20:
		r = moog_q200[bw_index][0];
		p = moog_q200[bw_index][1];
		k = moog_q200[bw_index][2];
		
		break;
	case 21:
		r = moog_q210[bw_index][0];
		p = moog_q210[bw_index][1];
		k = moog_q210[bw_index][2];
		
		break;
	case 22:
		r = moog_q220[bw_index][0];
		p = moog_q220[bw_index][1];
		k = moog_q220[bw_index][2];
		
		break;
	case 23:
		r = moog_q230[bw_index][0];
		p = moog_q230[bw_index][1];
		k = moog_q230[bw_index][2];
		
		break;
	default:
	case 24:
		r = moog_q240[bw_index][0];
		p = moog_q240[bw_index][1];
		k = moog_q240[bw_index][2];
		
		break;
    }




		    }
		    incr = calc_mod_freq(vp, incr);
		}
		newsample = (resample_t)v1;
		if (bw_index) {
                    insamp = (FLOAT_T)newsample;

		    x = insamp / (FLOAT_T)MAX_DATAVAL;

		    //--Inverted feed back for corner peaking
		    x = x - r*y4;

		    //Four cascaded onepole filters (bilinear transform)
		    y1m = x   * p + oldx  * p - k * y1m;
		    y2  = y1m * p + oldy1 * p - k * y2;
		    y3  = y2  * p + oldy2 * p - k * y3;
		    y4  = y3  * p + oldy3 * p - k * y4;

		    //Clipper band limited sigmoid
		    y4 = y4 - (y4*y4*y4)/6.0;

		    oldx = x;
		    oldy1 = y1m;
		    oldy2 = y2;
		    oldy3 = y3;

		    newsample = (resample_t)(y4 * (FLOAT_T)MAX_DATAVAL);
		}
		ofs=ofsd;
	}
	*dest++ = newsample;
	  ofs += incr;
	}
    }

  /* Then do the bidirectional looping */

  while(count)
    {
      /* Precalc how many times we should go through the loop */
#if 1
      i = ((incr > 0 ? le : ls) - ofs) / incr + 1;
#else
/* fix from M. Izumo */
      i = ((incr > 0 ? le : ls) - ofs + incr - 1) / incr;
#endif
      if (i > count)
	{
	  i = count;
	  count = 0;
	}
      else count -= i;
      for(j = 0; j < i && ofs < se; j++)
	{


	offset = ofs >> FRACTION_BITS;

	if (ofs >= se) {
		int32 delta = (ofs - se)>>FRACTION_BITS;
        	v1 = (int32)src[(int32)(se>>FRACTION_BITS)-1];
		if (overshoot) v1 -=  (delta+1) * v1 / overshoot;
        }
	else  v1 = (int32)src[offset];

	if (ofs + (1L<<FRACTION_BITS) >= se) {
		v2 = v1;
        }
	else  v2 = (int32)src[offset+1];

	if ( (vp->algorithm & INTERPOLATION_LINEAR) || dont_cspline ||
	   ((ofs-(1L<<FRACTION_BITS))<ls)||((ofs+(2L<<FRACTION_BITS))>le)){
		if (!cc_count--) {
		    cc_count = control_ratio - 1;
		    if (calc_bw_index(vp)) {
		        bw_index = vp->bw_index;


    reso = vp->resonance + vp->reso_volume;
    if (reso > vp->reso_max) reso = vp->reso_max;
    fmax = (1000 + (vp->reso_max - reso) * (vp->reso_max - reso) * 2) / 100;
    if (reso && bw_index > fmax) bw_index = fmax;
    reso = (reso+5)/10;

    switch(reso) {
	case 0:
		r = moog_q0[bw_index][0];
		p = moog_q0[bw_index][1];
		k = moog_q0[bw_index][2];
		
		break;
	case 1:
		r = moog_q10[bw_index][0];
		p = moog_q10[bw_index][1];
		k = moog_q10[bw_index][2];
		
		break;
	case 2:
		r = moog_q20[bw_index][0];
		p = moog_q20[bw_index][1];
		k = moog_q20[bw_index][2];
		
		break;
	case 3:
		r = moog_q30[bw_index][0];
		p = moog_q30[bw_index][1];
		k = moog_q30[bw_index][2];
		
		break;
	case 4:
		r = moog_q40[bw_index][0];
		p = moog_q40[bw_index][1];
		k = moog_q40[bw_index][2];
		
		break;
	case 5:
		r = moog_q50[bw_index][0];
		p = moog_q50[bw_index][1];
		k = moog_q50[bw_index][2];
		
		break;
	case 6:
		r = moog_q60[bw_index][0];
		p = moog_q60[bw_index][1];
		k = moog_q60[bw_index][2];
		
		break;
	case 7:
		r = moog_q70[bw_index][0];
		p = moog_q70[bw_index][1];
		k = moog_q70[bw_index][2];
		
		break;
	case 8:
		r = moog_q80[bw_index][0];
		p = moog_q80[bw_index][1];
		k = moog_q80[bw_index][2];
		
		break;
	case 9:
		r = moog_q90[bw_index][0];
		p = moog_q90[bw_index][1];
		k = moog_q90[bw_index][2];
		
		break;
	case 10:
		r = moog_q100[bw_index][0];
		p = moog_q100[bw_index][1];
		k = moog_q100[bw_index][2];
		
		break;
	case 11:
		r = moog_q110[bw_index][0];
		p = moog_q110[bw_index][1];
		k = moog_q110[bw_index][2];
		
		break;
	case 12:
		r = moog_q120[bw_index][0];
		p = moog_q120[bw_index][1];
		k = moog_q120[bw_index][2];
		
		break;
	case 13:
		r = moog_q130[bw_index][0];
		p = moog_q130[bw_index][1];
		k = moog_q130[bw_index][2];
		
		break;
	case 14:
		r = moog_q140[bw_index][0];
		p = moog_q140[bw_index][1];
		k = moog_q140[bw_index][2];
		
		break;
	case 15:
		r = moog_q150[bw_index][0];
		p = moog_q150[bw_index][1];
		k = moog_q150[bw_index][2];
		
		break;
	case 16:
		r = moog_q160[bw_index][0];
		p = moog_q160[bw_index][1];
		k = moog_q160[bw_index][2];
		
		break;
	case 17:
		r = moog_q170[bw_index][0];
		p = moog_q170[bw_index][1];
		k = moog_q170[bw_index][2];
		
		break;
	case 18:
		r = moog_q180[bw_index][0];
		p = moog_q180[bw_index][1];
		k = moog_q180[bw_index][2];
		
		break;
	case 19:
		r = moog_q190[bw_index][0];
		p = moog_q190[bw_index][1];
		k = moog_q190[bw_index][2];
		
		break;
	case 20:
		r = moog_q200[bw_index][0];
		p = moog_q200[bw_index][1];
		k = moog_q200[bw_index][2];
		
		break;
	case 21:
		r = moog_q210[bw_index][0];
		p = moog_q210[bw_index][1];
		k = moog_q210[bw_index][2];
		
		break;
	case 22:
		r = moog_q220[bw_index][0];
		p = moog_q220[bw_index][1];
		k = moog_q220[bw_index][2];
		
		break;
	case 23:
		r = moog_q230[bw_index][0];
		p = moog_q230[bw_index][1];
		k = moog_q230[bw_index][2];
		
		break;
	default:
	case 24:
		r = moog_q240[bw_index][0];
		p = moog_q240[bw_index][1];
		k = moog_q240[bw_index][2];
		
		break;
    }


		    }
		    incr = calc_mod_freq(vp, incr);
		}
                newsample = (resample_t)(v1 + ((int32)((v2-v1) * (ofs & FRACTION_MASK)) >> FRACTION_BITS));
	        if (bw_index) {
                    insamp = (FLOAT_T)newsample;

		    x = insamp / (FLOAT_T)MAX_DATAVAL;

		    //--Inverted feed back for corner peaking
		    x = x - r*y4;

		    //Four cascaded onepole filters (bilinear transform)
		    y1m = x   * p + oldx  * p - k * y1m;
		    y2  = y1m * p + oldy1 * p - k * y2;
		    y3  = y2  * p + oldy2 * p - k * y3;
		    y4  = y3  * p + oldy3 * p - k * y4;

		    //Clipper band limited sigmoid
		    y4 = y4 - (y4*y4*y4)/6.0;

		    oldx = x;
		    oldy1 = y1m;
		    oldy2 = y2;
		    oldy3 = y3;

		    newsample = (resample_t)(y4 * (FLOAT_T)MAX_DATAVAL);
	        }
	}
	else {
		ofsd=ofs;
                v0 = (int32)src[offset-1];
                v3 = (int32)src[offset+2];
                ofs &= FRACTION_MASK;
                temp=v2;
		v2 = (6*v2 +
		      (((( ( (5*v3 - 11*v2 + 7*v1 - v0)*
		       (int32)ofs) >>FRACTION_BITS)*(int32)ofs)>>(FRACTION_BITS+2))-1))*(int32)ofs;
                ofs = (1L << FRACTION_BITS) - ofs;
		v1 = (6*v1 +
		      ((((((5*v0 - 11*v1 + 7*temp - v3)*
		       (int32)ofs)>>FRACTION_BITS)*(int32)ofs)>>(FRACTION_BITS+2))-1))*(int32)ofs;
		v1 = (v1 + v2)/(6L<<FRACTION_BITS);
		if (!cc_count--) {
		    cc_count = control_ratio - 1;
		    if (calc_bw_index(vp)) {
			bw_index = vp->bw_index;


    reso = vp->resonance + vp->reso_volume;
    if (reso > vp->reso_max) reso = vp->reso_max;
    fmax = (1000 + (vp->reso_max - reso) * (vp->reso_max - reso) * 2) / 100;
    if (reso && bw_index > fmax) bw_index = fmax;
    reso = (reso+5)/10;

    switch(reso) {
	case 0:
		r = moog_q0[bw_index][0];
		p = moog_q0[bw_index][1];
		k = moog_q0[bw_index][2];
		
		break;
	case 1:
		r = moog_q10[bw_index][0];
		p = moog_q10[bw_index][1];
		k = moog_q10[bw_index][2];
		
		break;
	case 2:
		r = moog_q20[bw_index][0];
		p = moog_q20[bw_index][1];
		k = moog_q20[bw_index][2];
		
		break;
	case 3:
		r = moog_q30[bw_index][0];
		p = moog_q30[bw_index][1];
		k = moog_q30[bw_index][2];
		
		break;
	case 4:
		r = moog_q40[bw_index][0];
		p = moog_q40[bw_index][1];
		k = moog_q40[bw_index][2];
		
		break;
	case 5:
		r = moog_q50[bw_index][0];
		p = moog_q50[bw_index][1];
		k = moog_q50[bw_index][2];
		
		break;
	case 6:
		r = moog_q60[bw_index][0];
		p = moog_q60[bw_index][1];
		k = moog_q60[bw_index][2];
		
		break;
	case 7:
		r = moog_q70[bw_index][0];
		p = moog_q70[bw_index][1];
		k = moog_q70[bw_index][2];
		
		break;
	case 8:
		r = moog_q80[bw_index][0];
		p = moog_q80[bw_index][1];
		k = moog_q80[bw_index][2];
		
		break;
	case 9:
		r = moog_q90[bw_index][0];
		p = moog_q90[bw_index][1];
		k = moog_q90[bw_index][2];
		
		break;
	case 10:
		r = moog_q100[bw_index][0];
		p = moog_q100[bw_index][1];
		k = moog_q100[bw_index][2];
		
		break;
	case 11:
		r = moog_q110[bw_index][0];
		p = moog_q110[bw_index][1];
		k = moog_q110[bw_index][2];
		
		break;
	case 12:
		r = moog_q120[bw_index][0];
		p = moog_q120[bw_index][1];
		k = moog_q120[bw_index][2];
		
		break;
	case 13:
		r = moog_q130[bw_index][0];
		p = moog_q130[bw_index][1];
		k = moog_q130[bw_index][2];
		
		break;
	case 14:
		r = moog_q140[bw_index][0];
		p = moog_q140[bw_index][1];
		k = moog_q140[bw_index][2];
		
		break;
	case 15:
		r = moog_q150[bw_index][0];
		p = moog_q150[bw_index][1];
		k = moog_q150[bw_index][2];
		
		break;
	case 16:
		r = moog_q160[bw_index][0];
		p = moog_q160[bw_index][1];
		k = moog_q160[bw_index][2];
		
		break;
	case 17:
		r = moog_q170[bw_index][0];
		p = moog_q170[bw_index][1];
		k = moog_q170[bw_index][2];
		
		break;
	case 18:
		r = moog_q180[bw_index][0];
		p = moog_q180[bw_index][1];
		k = moog_q180[bw_index][2];
		
		break;
	case 19:
		r = moog_q190[bw_index][0];
		p = moog_q190[bw_index][1];
		k = moog_q190[bw_index][2];
		
		break;
	case 20:
		r = moog_q200[bw_index][0];
		p = moog_q200[bw_index][1];
		k = moog_q200[bw_index][2];
		
		break;
	case 21:
		r = moog_q210[bw_index][0];
		p = moog_q210[bw_index][1];
		k = moog_q210[bw_index][2];
		
		break;
	case 22:
		r = moog_q220[bw_index][0];
		p = moog_q220[bw_index][1];
		k = moog_q220[bw_index][2];
		
		break;
	case 23:
		r = moog_q230[bw_index][0];
		p = moog_q230[bw_index][1];
		k = moog_q230[bw_index][2];
		
		break;
	default:
	case 24:
		r = moog_q240[bw_index][0];
		p = moog_q240[bw_index][1];
		k = moog_q240[bw_index][2];
		
		break;
    }




		    }
		    incr = calc_mod_freq(vp, incr);
		}
		newsample = (resample_t)v1;
		if (bw_index) {
                    insamp = (FLOAT_T)newsample;

		    x = insamp / (FLOAT_T)MAX_DATAVAL;

		    //--Inverted feed back for corner peaking
		    x = x - r*y4;

		    //Four cascaded onepole filters (bilinear transform)
		    y1m = x   * p + oldx  * p - k * y1m;
		    y2  = y1m * p + oldy1 * p - k * y2;
		    y3  = y2  * p + oldy2 * p - k * y3;
		    y4  = y3  * p + oldy3 * p - k * y4;

		    //Clipper band limited sigmoid
		    y4 = y4 - (y4*y4*y4)/6.0;

		    oldx = x;
		    oldy1 = y1m;
		    oldy2 = y2;
		    oldy3 = y3;

		    newsample = (resample_t)(y4 * (FLOAT_T)MAX_DATAVAL);
		}
		ofs=ofsd;
	}
	*dest++ = newsample;
	  ofs += incr;
	}
#ifdef USE_BIDIR_OVERSHOOT
      if (ofs>=le)
	{
	  /* fold the overshoot back in */
	  ofs = le2 - ofs;
	  incr *= -1;
	}
      else if (ofs <= ls)
	{
	  ofs = ls2 - ofs;
	  incr *= -1;
	}
#else
	  incr *= -1;
#endif
    }

  vp->sample_increment=incr;
  vp->sample_offset=ofs; /* Update offset */

  vp->current_x0=oldx;
  vp->current_x1=oldy1;
  vp->current_y0=oldy2;
  vp->current_y1=oldy3;
  vp->current_y2=y4;
  vp->bw_index=bw_index;
  vp->modulation_counter=cc_count;
  return resample_buffer+resample_buffer_offset;
}

/*********************** vibrato versions ***************************/

/* We only need to compute one half of the vibrato sine cycle */
static uint32 vib_phase_to_inc_ptr(uint32 phase)
{
  if (phase < VIBRATO_SAMPLE_INCREMENTS/2)
    return VIBRATO_SAMPLE_INCREMENTS/2-1-phase;
  else if (phase >= 3*VIBRATO_SAMPLE_INCREMENTS/2)
    return 5*VIBRATO_SAMPLE_INCREMENTS/2-1-phase;
  else
    return phase-VIBRATO_SAMPLE_INCREMENTS/2;
}

static int32 update_vibrato(Voice *vp, int sign)
{
  uint32 depth, freq=vp->frequency;
#ifdef ENVELOPE_PITCH_MODULATION
  FLOAT_T mod_amount=vp->modEnvToPitch;
#endif
  uint32 phase;
  int pb;
  double a;

  if(vp->vibrato_delay > 0)
  {
      vp->vibrato_delay -= vp->vibrato_control_ratio;
      if(vp->vibrato_delay > 0)
	  return vp->sample_increment;
  }

  if (vp->vibrato_phase++ >= 2*VIBRATO_SAMPLE_INCREMENTS-1)
    vp->vibrato_phase=0;
  phase=vib_phase_to_inc_ptr(vp->vibrato_phase);

  if (vp->vibrato_sample_increment[phase])
    {
      if (sign)
	return -vp->vibrato_sample_increment[phase];
      else
	return vp->vibrato_sample_increment[phase];
    }

  /* Need to compute this sample increment. */

  depth = vp->vibrato_depth;
  if(depth < vp->modulation_wheel)
      depth = vp->modulation_wheel;
  depth <<= 7;

  if (vp->vibrato_sweep && !vp->modulation_wheel)
    {
      /* Need to update sweep */
      vp->vibrato_sweep_position += vp->vibrato_sweep;
      if (vp->vibrato_sweep_position >= (1<<SWEEP_SHIFT))
	vp->vibrato_sweep=0;
      else
	{
	  /* Adjust depth */
	  depth *= vp->vibrato_sweep_position;
	  depth >>= SWEEP_SHIFT;
	}
    }

#ifdef ENVELOPE_PITCH_MODULATION
#ifndef FILTER_INTERPOLATION
  if (update_modulation_signal(vp)) mod_amount = 0;
  else
#endif
  if (mod_amount>0.5)
   freq = (int32)( (double)freq*(1.0 + (mod_amount - 1.0) * (vp->modulation_volume>>22) / 255.0) );
#endif

  pb=(int)((sine(vp->vibrato_phase *
			(SINE_CYCLE_LENGTH/(2*VIBRATO_SAMPLE_INCREMENTS)))
	    * (double)(depth) * VIBRATO_AMPLITUDE_TUNING));

  a = FRSCALE(((double)(vp->sample->sample_rate) *
		  (double)(freq)) /
		 ((double)(vp->sample->root_freq) *
		  (double)(play_mode->rate)),
		 FRACTION_BITS);
  if(pb<0)
  {
      pb = -pb;
      a /= bend_fine[(pb>>5) & 0xFF] * bend_coarse[pb>>13];
  }
  else
      a *= bend_fine[(pb>>5) & 0xFF] * bend_coarse[pb>>13];
  a += 0.5;

  /* If the sweep's over, we can store the newly computed sample_increment */
  if (!vp->vibrato_sweep || vp->modulation_wheel)
    vp->vibrato_sample_increment[phase]=(int32) a;

  if (sign)
    a = -a; /* need to preserve the loop direction */

  return (int32) a;
}

static resample_t *rs_vib_plain(int v, uint32 *countptr)
{

  /* Play sample until end, then free the voice. */

  Voice *vp=&voice[v];
  int32   v0, v1, v2, v3, temp, overshoot;
  splen_t ofsd;
  int32 offset;
  FLOAT_T insamp, r, p, k, x, y1m=0, y2=0, y3=0,
    oldx=vp->current_x0, oldy1=vp->current_x1,
    oldy2=vp->current_y0, oldy3=vp->current_y1,
    y4=vp->current_y2;
  uint32 cc_count=vp->modulation_counter, bw_index=vp->bw_index, fmax;
  uint16 reso;
  resample_t newsample;
  resample_t
    *dest=resample_buffer+resample_buffer_offset;
#ifdef SL32
  samplel_t
    *src=vp->sample->ldata;
#else
  sample_t
    *src=vp->sample->data;
#endif
  int32
    incr=vp->sample_increment;
#if defined(LAGRANGE_INTERPOLATION) || defined(CSPLINE_INTERPOLATION)
  splen_t
    ls=0,
    le=vp->sample->data_length;
#endif /* LAGRANGE_INTERPOLATION */
  splen_t
    ofs=vp->sample_offset,
    se=vp->sample->data_length,
    count=*countptr;
  uint32
    cc=vp->vibrato_control_counter;

  /* This has never been tested */

  if (incr<0) incr = -incr; /* In case we're coming out of a bidir loop */

  overshoot = src[(se>>FRACTION_BITS)-1] / OVERSHOOT_STEP;
  if (overshoot < 0) overshoot = -overshoot;

    reso = vp->resonance + vp->reso_volume;
    if (reso > vp->reso_max) reso = vp->reso_max;
    fmax = (1000 + (vp->reso_max - reso) * (vp->reso_max - reso) * 2) / 100;
    if (reso && bw_index > fmax) bw_index = fmax;
    reso = (reso+5)/10;

    switch(reso) {
	case 0:
		r = moog_q0[bw_index][0];
		p = moog_q0[bw_index][1];
		k = moog_q0[bw_index][2];
		
		break;
	case 1:
		r = moog_q10[bw_index][0];
		p = moog_q10[bw_index][1];
		k = moog_q10[bw_index][2];
		
		break;
	case 2:
		r = moog_q20[bw_index][0];
		p = moog_q20[bw_index][1];
		k = moog_q20[bw_index][2];
		
		break;
	case 3:
		r = moog_q30[bw_index][0];
		p = moog_q30[bw_index][1];
		k = moog_q30[bw_index][2];
		
		break;
	case 4:
		r = moog_q40[bw_index][0];
		p = moog_q40[bw_index][1];
		k = moog_q40[bw_index][2];
		
		break;
	case 5:
		r = moog_q50[bw_index][0];
		p = moog_q50[bw_index][1];
		k = moog_q50[bw_index][2];
		
		break;
	case 6:
		r = moog_q60[bw_index][0];
		p = moog_q60[bw_index][1];
		k = moog_q60[bw_index][2];
		
		break;
	case 7:
		r = moog_q70[bw_index][0];
		p = moog_q70[bw_index][1];
		k = moog_q70[bw_index][2];
		
		break;
	case 8:
		r = moog_q80[bw_index][0];
		p = moog_q80[bw_index][1];
		k = moog_q80[bw_index][2];
		
		break;
	case 9:
		r = moog_q90[bw_index][0];
		p = moog_q90[bw_index][1];
		k = moog_q90[bw_index][2];
		
		break;
	case 10:
		r = moog_q100[bw_index][0];
		p = moog_q100[bw_index][1];
		k = moog_q100[bw_index][2];
		
		break;
	case 11:
		r = moog_q110[bw_index][0];
		p = moog_q110[bw_index][1];
		k = moog_q110[bw_index][2];
		
		break;
	case 12:
		r = moog_q120[bw_index][0];
		p = moog_q120[bw_index][1];
		k = moog_q120[bw_index][2];
		
		break;
	case 13:
		r = moog_q130[bw_index][0];
		p = moog_q130[bw_index][1];
		k = moog_q130[bw_index][2];
		
		break;
	case 14:
		r = moog_q140[bw_index][0];
		p = moog_q140[bw_index][1];
		k = moog_q140[bw_index][2];
		
		break;
	case 15:
		r = moog_q150[bw_index][0];
		p = moog_q150[bw_index][1];
		k = moog_q150[bw_index][2];
		
		break;
	case 16:
		r = moog_q160[bw_index][0];
		p = moog_q160[bw_index][1];
		k = moog_q160[bw_index][2];
		
		break;
	case 17:
		r = moog_q170[bw_index][0];
		p = moog_q170[bw_index][1];
		k = moog_q170[bw_index][2];
		
		break;
	case 18:
		r = moog_q180[bw_index][0];
		p = moog_q180[bw_index][1];
		k = moog_q180[bw_index][2];
		
		break;
	case 19:
		r = moog_q190[bw_index][0];
		p = moog_q190[bw_index][1];
		k = moog_q190[bw_index][2];
		
		break;
	case 20:
		r = moog_q200[bw_index][0];
		p = moog_q200[bw_index][1];
		k = moog_q200[bw_index][2];
		
		break;
	case 21:
		r = moog_q210[bw_index][0];
		p = moog_q210[bw_index][1];
		k = moog_q210[bw_index][2];
		
		break;
	case 22:
		r = moog_q220[bw_index][0];
		p = moog_q220[bw_index][1];
		k = moog_q220[bw_index][2];
		
		break;
	case 23:
		r = moog_q230[bw_index][0];
		p = moog_q230[bw_index][1];
		k = moog_q230[bw_index][2];
		
		break;
	default:
	case 24:
		r = moog_q240[bw_index][0];
		p = moog_q240[bw_index][1];
		k = moog_q240[bw_index][2];
		
		break;
    }

  while (count--)
    {
      if (!cc--)
	{
	  cc=vp->vibrato_control_ratio;
	  incr=update_vibrato(vp, 0);
	}


	offset = ofs >> FRACTION_BITS;

	if (ofs >= se) {
		int32 delta = (ofs - se)>>FRACTION_BITS;
        	v1 = (int32)src[(int32)(se>>FRACTION_BITS)-1];
		if (overshoot) v1 -=  (delta+1) * v1 / overshoot;
        }
	else  v1 = (int32)src[offset];

	if (ofs + (1L<<FRACTION_BITS) >= se) {
		v2 = v1;
        }
	else  v2 = (int32)src[offset+1];

	if ( (vp->algorithm & INTERPOLATION_LINEAR) || dont_cspline ||
	   ((ofs-(1L<<FRACTION_BITS))<ls)||((ofs+(2L<<FRACTION_BITS))>le)){
		if (!cc_count--) {
		    cc_count = control_ratio - 1;
		    if (calc_bw_index(vp)) {
		        bw_index = vp->bw_index;


    reso = vp->resonance + vp->reso_volume;
    if (reso > vp->reso_max) reso = vp->reso_max;
    fmax = (1000 + (vp->reso_max - reso) * (vp->reso_max - reso) * 2) / 100;
    if (reso && bw_index > fmax) bw_index = fmax;
    reso = (reso+5)/10;

    switch(reso) {
	case 0:
		r = moog_q0[bw_index][0];
		p = moog_q0[bw_index][1];
		k = moog_q0[bw_index][2];
		
		break;
	case 1:
		r = moog_q10[bw_index][0];
		p = moog_q10[bw_index][1];
		k = moog_q10[bw_index][2];
		
		break;
	case 2:
		r = moog_q20[bw_index][0];
		p = moog_q20[bw_index][1];
		k = moog_q20[bw_index][2];
		
		break;
	case 3:
		r = moog_q30[bw_index][0];
		p = moog_q30[bw_index][1];
		k = moog_q30[bw_index][2];
		
		break;
	case 4:
		r = moog_q40[bw_index][0];
		p = moog_q40[bw_index][1];
		k = moog_q40[bw_index][2];
		
		break;
	case 5:
		r = moog_q50[bw_index][0];
		p = moog_q50[bw_index][1];
		k = moog_q50[bw_index][2];
		
		break;
	case 6:
		r = moog_q60[bw_index][0];
		p = moog_q60[bw_index][1];
		k = moog_q60[bw_index][2];
		
		break;
	case 7:
		r = moog_q70[bw_index][0];
		p = moog_q70[bw_index][1];
		k = moog_q70[bw_index][2];
		
		break;
	case 8:
		r = moog_q80[bw_index][0];
		p = moog_q80[bw_index][1];
		k = moog_q80[bw_index][2];
		
		break;
	case 9:
		r = moog_q90[bw_index][0];
		p = moog_q90[bw_index][1];
		k = moog_q90[bw_index][2];
		
		break;
	case 10:
		r = moog_q100[bw_index][0];
		p = moog_q100[bw_index][1];
		k = moog_q100[bw_index][2];
		
		break;
	case 11:
		r = moog_q110[bw_index][0];
		p = moog_q110[bw_index][1];
		k = moog_q110[bw_index][2];
		
		break;
	case 12:
		r = moog_q120[bw_index][0];
		p = moog_q120[bw_index][1];
		k = moog_q120[bw_index][2];
		
		break;
	case 13:
		r = moog_q130[bw_index][0];
		p = moog_q130[bw_index][1];
		k = moog_q130[bw_index][2];
		
		break;
	case 14:
		r = moog_q140[bw_index][0];
		p = moog_q140[bw_index][1];
		k = moog_q140[bw_index][2];
		
		break;
	case 15:
		r = moog_q150[bw_index][0];
		p = moog_q150[bw_index][1];
		k = moog_q150[bw_index][2];
		
		break;
	case 16:
		r = moog_q160[bw_index][0];
		p = moog_q160[bw_index][1];
		k = moog_q160[bw_index][2];
		
		break;
	case 17:
		r = moog_q170[bw_index][0];
		p = moog_q170[bw_index][1];
		k = moog_q170[bw_index][2];
		
		break;
	case 18:
		r = moog_q180[bw_index][0];
		p = moog_q180[bw_index][1];
		k = moog_q180[bw_index][2];
		
		break;
	case 19:
		r = moog_q190[bw_index][0];
		p = moog_q190[bw_index][1];
		k = moog_q190[bw_index][2];
		
		break;
	case 20:
		r = moog_q200[bw_index][0];
		p = moog_q200[bw_index][1];
		k = moog_q200[bw_index][2];
		
		break;
	case 21:
		r = moog_q210[bw_index][0];
		p = moog_q210[bw_index][1];
		k = moog_q210[bw_index][2];
		
		break;
	case 22:
		r = moog_q220[bw_index][0];
		p = moog_q220[bw_index][1];
		k = moog_q220[bw_index][2];
		
		break;
	case 23:
		r = moog_q230[bw_index][0];
		p = moog_q230[bw_index][1];
		k = moog_q230[bw_index][2];
		
		break;
	default:
	case 24:
		r = moog_q240[bw_index][0];
		p = moog_q240[bw_index][1];
		k = moog_q240[bw_index][2];
		
		break;
    }


		    }
		    incr = calc_mod_freq(vp, incr);
		}
                newsample = (resample_t)(v1 + ((int32)((v2-v1) * (ofs & FRACTION_MASK)) >> FRACTION_BITS));
	        if (bw_index) {
                    insamp = (FLOAT_T)newsample;

		    x = insamp / (FLOAT_T)MAX_DATAVAL;

		    //--Inverted feed back for corner peaking
		    x = x - r*y4;

		    //Four cascaded onepole filters (bilinear transform)
		    y1m = x   * p + oldx  * p - k * y1m;
		    y2  = y1m * p + oldy1 * p - k * y2;
		    y3  = y2  * p + oldy2 * p - k * y3;
		    y4  = y3  * p + oldy3 * p - k * y4;

		    //Clipper band limited sigmoid
		    y4 = y4 - (y4*y4*y4)/6.0;

		    oldx = x;
		    oldy1 = y1m;
		    oldy2 = y2;
		    oldy3 = y3;

		    newsample = (resample_t)(y4 * (FLOAT_T)MAX_DATAVAL);
	        }
	}
	else {
		ofsd=ofs;
                v0 = (int32)src[offset-1];
                v3 = (int32)src[offset+2];
                ofs &= FRACTION_MASK;
                temp=v2;
		v2 = (6*v2 +
		      (((( ( (5*v3 - 11*v2 + 7*v1 - v0)*
		       (int32)ofs) >>FRACTION_BITS)*(int32)ofs)>>(FRACTION_BITS+2))-1))*(int32)ofs;
                ofs = (1L << FRACTION_BITS) - ofs;
		v1 = (6*v1 +
		      ((((((5*v0 - 11*v1 + 7*temp - v3)*
		       (int32)ofs)>>FRACTION_BITS)*(int32)ofs)>>(FRACTION_BITS+2))-1))*(int32)ofs;
		v1 = (v1 + v2)/(6L<<FRACTION_BITS);
		if (!cc_count--) {
		    cc_count = control_ratio - 1;
		    if (calc_bw_index(vp)) {
			bw_index = vp->bw_index;


    reso = vp->resonance + vp->reso_volume;
    if (reso > vp->reso_max) reso = vp->reso_max;
    fmax = (1000 + (vp->reso_max - reso) * (vp->reso_max - reso) * 2) / 100;
    if (reso && bw_index > fmax) bw_index = fmax;
    reso = (reso+5)/10;

    switch(reso) {
	case 0:
		r = moog_q0[bw_index][0];
		p = moog_q0[bw_index][1];
		k = moog_q0[bw_index][2];
		
		break;
	case 1:
		r = moog_q10[bw_index][0];
		p = moog_q10[bw_index][1];
		k = moog_q10[bw_index][2];
		
		break;
	case 2:
		r = moog_q20[bw_index][0];
		p = moog_q20[bw_index][1];
		k = moog_q20[bw_index][2];
		
		break;
	case 3:
		r = moog_q30[bw_index][0];
		p = moog_q30[bw_index][1];
		k = moog_q30[bw_index][2];
		
		break;
	case 4:
		r = moog_q40[bw_index][0];
		p = moog_q40[bw_index][1];
		k = moog_q40[bw_index][2];
		
		break;
	case 5:
		r = moog_q50[bw_index][0];
		p = moog_q50[bw_index][1];
		k = moog_q50[bw_index][2];
		
		break;
	case 6:
		r = moog_q60[bw_index][0];
		p = moog_q60[bw_index][1];
		k = moog_q60[bw_index][2];
		
		break;
	case 7:
		r = moog_q70[bw_index][0];
		p = moog_q70[bw_index][1];
		k = moog_q70[bw_index][2];
		
		break;
	case 8:
		r = moog_q80[bw_index][0];
		p = moog_q80[bw_index][1];
		k = moog_q80[bw_index][2];
		
		break;
	case 9:
		r = moog_q90[bw_index][0];
		p = moog_q90[bw_index][1];
		k = moog_q90[bw_index][2];
		
		break;
	case 10:
		r = moog_q100[bw_index][0];
		p = moog_q100[bw_index][1];
		k = moog_q100[bw_index][2];
		
		break;
	case 11:
		r = moog_q110[bw_index][0];
		p = moog_q110[bw_index][1];
		k = moog_q110[bw_index][2];
		
		break;
	case 12:
		r = moog_q120[bw_index][0];
		p = moog_q120[bw_index][1];
		k = moog_q120[bw_index][2];
		
		break;
	case 13:
		r = moog_q130[bw_index][0];
		p = moog_q130[bw_index][1];
		k = moog_q130[bw_index][2];
		
		break;
	case 14:
		r = moog_q140[bw_index][0];
		p = moog_q140[bw_index][1];
		k = moog_q140[bw_index][2];
		
		break;
	case 15:
		r = moog_q150[bw_index][0];
		p = moog_q150[bw_index][1];
		k = moog_q150[bw_index][2];
		
		break;
	case 16:
		r = moog_q160[bw_index][0];
		p = moog_q160[bw_index][1];
		k = moog_q160[bw_index][2];
		
		break;
	case 17:
		r = moog_q170[bw_index][0];
		p = moog_q170[bw_index][1];
		k = moog_q170[bw_index][2];
		
		break;
	case 18:
		r = moog_q180[bw_index][0];
		p = moog_q180[bw_index][1];
		k = moog_q180[bw_index][2];
		
		break;
	case 19:
		r = moog_q190[bw_index][0];
		p = moog_q190[bw_index][1];
		k = moog_q190[bw_index][2];
		
		break;
	case 20:
		r = moog_q200[bw_index][0];
		p = moog_q200[bw_index][1];
		k = moog_q200[bw_index][2];
		
		break;
	case 21:
		r = moog_q210[bw_index][0];
		p = moog_q210[bw_index][1];
		k = moog_q210[bw_index][2];
		
		break;
	case 22:
		r = moog_q220[bw_index][0];
		p = moog_q220[bw_index][1];
		k = moog_q220[bw_index][2];
		
		break;
	case 23:
		r = moog_q230[bw_index][0];
		p = moog_q230[bw_index][1];
		k = moog_q230[bw_index][2];
		
		break;
	default:
	case 24:
		r = moog_q240[bw_index][0];
		p = moog_q240[bw_index][1];
		k = moog_q240[bw_index][2];
		
		break;
    }




		    }
		    incr = calc_mod_freq(vp, incr);
		}
		newsample = (resample_t)v1;
		if (bw_index) {
                    insamp = (FLOAT_T)newsample;

		    x = insamp / (FLOAT_T)MAX_DATAVAL;

		    //--Inverted feed back for corner peaking
		    x = x - r*y4;

		    //Four cascaded onepole filters (bilinear transform)
		    y1m = x   * p + oldx  * p - k * y1m;
		    y2  = y1m * p + oldy1 * p - k * y2;
		    y3  = y2  * p + oldy2 * p - k * y3;
		    y4  = y3  * p + oldy3 * p - k * y4;

		    //Clipper band limited sigmoid
		    y4 = y4 - (y4*y4*y4)/6.0;

		    oldx = x;
		    oldy1 = y1m;
		    oldy2 = y2;
		    oldy3 = y3;

		    newsample = (resample_t)(y4 * (FLOAT_T)MAX_DATAVAL);
		}
		ofs=ofsd;
	}
	*dest++ = newsample;
      ofs += incr;
      if (ofs >= se + (overshoot << FRACTION_BITS))
	{
	  if (!(vp->status&VOICE_FREE))
	    {
	      vp->status=VOICE_FREE;
 	      ctl->note(v);
	    }
	  *countptr-=count+1;
	  break;
	}
    }

  vp->vibrato_control_counter=cc;
  vp->sample_increment=incr;
  vp->sample_offset=ofs; /* Update offset */

  vp->current_x0=oldx;
  vp->current_x1=oldy1;
  vp->current_y0=oldy2;
  vp->current_y1=oldy3;
  vp->current_y2=y4;
  vp->bw_index=bw_index;
  vp->modulation_counter=cc_count;
  return resample_buffer+resample_buffer_offset;
}

static resample_t *rs_vib_loop(int v, Voice *vp, uint32 *countptr)
{
  /* Play sample until end-of-loop, skip back and continue. */
  int32   v0, v1, v2, v3, temp, overshoot;
  splen_t ofsd;
  int32 offset;
  FLOAT_T insamp, r, p, k, x, y1m=0, y2=0, y3=0,
    oldx=vp->current_x0, oldy1=vp->current_x1,
    oldy2=vp->current_y0, oldy3=vp->current_y1,
    y4=vp->current_y2;
  uint32 cc_count=vp->modulation_counter, bw_index=vp->bw_index, fmax;
  uint16 reso;
  resample_t newsample;
  int32
    incr=vp->sample_increment;
  splen_t
#if defined(LAGRANGE_INTERPOLATION) || defined(CSPLINE_INTERPOLATION)
    ls=vp->loop_start,
#endif /* LAGRANGE_INTERPOLATION */
    le=vp->loop_end,
    ll=le - vp->loop_start;
  resample_t
    *dest=resample_buffer+resample_buffer_offset;
#ifdef SL32
  samplel_t
    *src=vp->sample->ldata;
#else
  sample_t
    *src=vp->sample->data;
#endif
  splen_t
    ofs=vp->sample_offset,
    se=vp->sample->data_length,
    count = *countptr;
  uint32
    cc=vp->vibrato_control_counter;
  int
    flag_exit_loop;


  flag_exit_loop =
	(vp->status & (VOICE_FREE | VOICE_DIE)) ||
	((vp->status & VOICE_OFF) && (vp->sample->modes & MODES_FAST_RELEASE) ) ||
	((vp->status & VOICE_OFF) && dont_keep_looping ) ;

  overshoot = src[(se>>FRACTION_BITS)-1] / OVERSHOOT_STEP;
  if (overshoot < 0) overshoot = -overshoot;

    reso = vp->resonance + vp->reso_volume;
    if (reso > vp->reso_max) reso = vp->reso_max;
    fmax = (1000 + (vp->reso_max - reso) * (vp->reso_max - reso) * 2) / 100;
    if (reso && bw_index > fmax) bw_index = fmax;
    reso = (reso+5)/10;

    switch(reso) {
	case 0:
		r = moog_q0[bw_index][0];
		p = moog_q0[bw_index][1];
		k = moog_q0[bw_index][2];
		
		break;
	case 1:
		r = moog_q10[bw_index][0];
		p = moog_q10[bw_index][1];
		k = moog_q10[bw_index][2];
		
		break;
	case 2:
		r = moog_q20[bw_index][0];
		p = moog_q20[bw_index][1];
		k = moog_q20[bw_index][2];
		
		break;
	case 3:
		r = moog_q30[bw_index][0];
		p = moog_q30[bw_index][1];
		k = moog_q30[bw_index][2];
		
		break;
	case 4:
		r = moog_q40[bw_index][0];
		p = moog_q40[bw_index][1];
		k = moog_q40[bw_index][2];
		
		break;
	case 5:
		r = moog_q50[bw_index][0];
		p = moog_q50[bw_index][1];
		k = moog_q50[bw_index][2];
		
		break;
	case 6:
		r = moog_q60[bw_index][0];
		p = moog_q60[bw_index][1];
		k = moog_q60[bw_index][2];
		
		break;
	case 7:
		r = moog_q70[bw_index][0];
		p = moog_q70[bw_index][1];
		k = moog_q70[bw_index][2];
		
		break;
	case 8:
		r = moog_q80[bw_index][0];
		p = moog_q80[bw_index][1];
		k = moog_q80[bw_index][2];
		
		break;
	case 9:
		r = moog_q90[bw_index][0];
		p = moog_q90[bw_index][1];
		k = moog_q90[bw_index][2];
		
		break;
	case 10:
		r = moog_q100[bw_index][0];
		p = moog_q100[bw_index][1];
		k = moog_q100[bw_index][2];
		
		break;
	case 11:
		r = moog_q110[bw_index][0];
		p = moog_q110[bw_index][1];
		k = moog_q110[bw_index][2];
		
		break;
	case 12:
		r = moog_q120[bw_index][0];
		p = moog_q120[bw_index][1];
		k = moog_q120[bw_index][2];
		
		break;
	case 13:
		r = moog_q130[bw_index][0];
		p = moog_q130[bw_index][1];
		k = moog_q130[bw_index][2];
		
		break;
	case 14:
		r = moog_q140[bw_index][0];
		p = moog_q140[bw_index][1];
		k = moog_q140[bw_index][2];
		
		break;
	case 15:
		r = moog_q150[bw_index][0];
		p = moog_q150[bw_index][1];
		k = moog_q150[bw_index][2];
		
		break;
	case 16:
		r = moog_q160[bw_index][0];
		p = moog_q160[bw_index][1];
		k = moog_q160[bw_index][2];
		
		break;
	case 17:
		r = moog_q170[bw_index][0];
		p = moog_q170[bw_index][1];
		k = moog_q170[bw_index][2];
		
		break;
	case 18:
		r = moog_q180[bw_index][0];
		p = moog_q180[bw_index][1];
		k = moog_q180[bw_index][2];
		
		break;
	case 19:
		r = moog_q190[bw_index][0];
		p = moog_q190[bw_index][1];
		k = moog_q190[bw_index][2];
		
		break;
	case 20:
		r = moog_q200[bw_index][0];
		p = moog_q200[bw_index][1];
		k = moog_q200[bw_index][2];
		
		break;
	case 21:
		r = moog_q210[bw_index][0];
		p = moog_q210[bw_index][1];
		k = moog_q210[bw_index][2];
		
		break;
	case 22:
		r = moog_q220[bw_index][0];
		p = moog_q220[bw_index][1];
		k = moog_q220[bw_index][2];
		
		break;
	case 23:
		r = moog_q230[bw_index][0];
		p = moog_q230[bw_index][1];
		k = moog_q230[bw_index][2];
		
		break;
	default:
	case 24:
		r = moog_q240[bw_index][0];
		p = moog_q240[bw_index][1];
		k = moog_q240[bw_index][2];
		
		break;
    }

  while (count--)
    {
      if (!cc--)
	{
	  cc=vp->vibrato_control_ratio;
	  incr=update_vibrato(vp, 0);
	}


	offset = ofs >> FRACTION_BITS;

	if (ofs >= se) {
		int32 delta = (ofs - se)>>FRACTION_BITS;
        	v1 = (int32)src[(int32)(se>>FRACTION_BITS)-1];
		if (overshoot) v1 -=  (delta+1) * v1 / overshoot;
        }
	else  v1 = (int32)src[offset];

	if (ofs + (1L<<FRACTION_BITS) >= se) {
		v2 = v1;
        }
	else  v2 = (int32)src[offset+1];

	if ( (vp->algorithm & INTERPOLATION_LINEAR) || dont_cspline ||
	   ((ofs-(1L<<FRACTION_BITS))<ls)||((ofs+(2L<<FRACTION_BITS))>le)){
		if (!cc_count--) {
		    cc_count = control_ratio - 1;
		    if (calc_bw_index(vp)) {
		        bw_index = vp->bw_index;


    reso = vp->resonance + vp->reso_volume;
    if (reso > vp->reso_max) reso = vp->reso_max;
    fmax = (1000 + (vp->reso_max - reso) * (vp->reso_max - reso) * 2) / 100;
    if (reso && bw_index > fmax) bw_index = fmax;
    reso = (reso+5)/10;

    switch(reso) {
	case 0:
		r = moog_q0[bw_index][0];
		p = moog_q0[bw_index][1];
		k = moog_q0[bw_index][2];
		
		break;
	case 1:
		r = moog_q10[bw_index][0];
		p = moog_q10[bw_index][1];
		k = moog_q10[bw_index][2];
		
		break;
	case 2:
		r = moog_q20[bw_index][0];
		p = moog_q20[bw_index][1];
		k = moog_q20[bw_index][2];
		
		break;
	case 3:
		r = moog_q30[bw_index][0];
		p = moog_q30[bw_index][1];
		k = moog_q30[bw_index][2];
		
		break;
	case 4:
		r = moog_q40[bw_index][0];
		p = moog_q40[bw_index][1];
		k = moog_q40[bw_index][2];
		
		break;
	case 5:
		r = moog_q50[bw_index][0];
		p = moog_q50[bw_index][1];
		k = moog_q50[bw_index][2];
		
		break;
	case 6:
		r = moog_q60[bw_index][0];
		p = moog_q60[bw_index][1];
		k = moog_q60[bw_index][2];
		
		break;
	case 7:
		r = moog_q70[bw_index][0];
		p = moog_q70[bw_index][1];
		k = moog_q70[bw_index][2];
		
		break;
	case 8:
		r = moog_q80[bw_index][0];
		p = moog_q80[bw_index][1];
		k = moog_q80[bw_index][2];
		
		break;
	case 9:
		r = moog_q90[bw_index][0];
		p = moog_q90[bw_index][1];
		k = moog_q90[bw_index][2];
		
		break;
	case 10:
		r = moog_q100[bw_index][0];
		p = moog_q100[bw_index][1];
		k = moog_q100[bw_index][2];
		
		break;
	case 11:
		r = moog_q110[bw_index][0];
		p = moog_q110[bw_index][1];
		k = moog_q110[bw_index][2];
		
		break;
	case 12:
		r = moog_q120[bw_index][0];
		p = moog_q120[bw_index][1];
		k = moog_q120[bw_index][2];
		
		break;
	case 13:
		r = moog_q130[bw_index][0];
		p = moog_q130[bw_index][1];
		k = moog_q130[bw_index][2];
		
		break;
	case 14:
		r = moog_q140[bw_index][0];
		p = moog_q140[bw_index][1];
		k = moog_q140[bw_index][2];
		
		break;
	case 15:
		r = moog_q150[bw_index][0];
		p = moog_q150[bw_index][1];
		k = moog_q150[bw_index][2];
		
		break;
	case 16:
		r = moog_q160[bw_index][0];
		p = moog_q160[bw_index][1];
		k = moog_q160[bw_index][2];
		
		break;
	case 17:
		r = moog_q170[bw_index][0];
		p = moog_q170[bw_index][1];
		k = moog_q170[bw_index][2];
		
		break;
	case 18:
		r = moog_q180[bw_index][0];
		p = moog_q180[bw_index][1];
		k = moog_q180[bw_index][2];
		
		break;
	case 19:
		r = moog_q190[bw_index][0];
		p = moog_q190[bw_index][1];
		k = moog_q190[bw_index][2];
		
		break;
	case 20:
		r = moog_q200[bw_index][0];
		p = moog_q200[bw_index][1];
		k = moog_q200[bw_index][2];
		
		break;
	case 21:
		r = moog_q210[bw_index][0];
		p = moog_q210[bw_index][1];
		k = moog_q210[bw_index][2];
		
		break;
	case 22:
		r = moog_q220[bw_index][0];
		p = moog_q220[bw_index][1];
		k = moog_q220[bw_index][2];
		
		break;
	case 23:
		r = moog_q230[bw_index][0];
		p = moog_q230[bw_index][1];
		k = moog_q230[bw_index][2];
		
		break;
	default:
	case 24:
		r = moog_q240[bw_index][0];
		p = moog_q240[bw_index][1];
		k = moog_q240[bw_index][2];
		
		break;
    }


		    }
		    incr = calc_mod_freq(vp, incr);
		}
                newsample = (resample_t)(v1 + ((int32)((v2-v1) * (ofs & FRACTION_MASK)) >> FRACTION_BITS));
	        if (bw_index) {
                    insamp = (FLOAT_T)newsample;

		    x = insamp / (FLOAT_T)MAX_DATAVAL;

		    //--Inverted feed back for corner peaking
		    x = x - r*y4;

		    //Four cascaded onepole filters (bilinear transform)
		    y1m = x   * p + oldx  * p - k * y1m;
		    y2  = y1m * p + oldy1 * p - k * y2;
		    y3  = y2  * p + oldy2 * p - k * y3;
		    y4  = y3  * p + oldy3 * p - k * y4;

		    //Clipper band limited sigmoid
		    y4 = y4 - (y4*y4*y4)/6.0;

		    oldx = x;
		    oldy1 = y1m;
		    oldy2 = y2;
		    oldy3 = y3;

		    newsample = (resample_t)(y4 * (FLOAT_T)MAX_DATAVAL);
	        }
	}
	else {
		ofsd=ofs;
                v0 = (int32)src[offset-1];
                v3 = (int32)src[offset+2];
                ofs &= FRACTION_MASK;
                temp=v2;
		v2 = (6*v2 +
		      (((( ( (5*v3 - 11*v2 + 7*v1 - v0)*
		       (int32)ofs) >>FRACTION_BITS)*(int32)ofs)>>(FRACTION_BITS+2))-1))*(int32)ofs;
                ofs = (1L << FRACTION_BITS) - ofs;
		v1 = (6*v1 +
		      ((((((5*v0 - 11*v1 + 7*temp - v3)*
		       (int32)ofs)>>FRACTION_BITS)*(int32)ofs)>>(FRACTION_BITS+2))-1))*(int32)ofs;
		v1 = (v1 + v2)/(6L<<FRACTION_BITS);
		if (!cc_count--) {
		    cc_count = control_ratio - 1;
		    if (calc_bw_index(vp)) {
			bw_index = vp->bw_index;


    reso = vp->resonance + vp->reso_volume;
    if (reso > vp->reso_max) reso = vp->reso_max;
    fmax = (1000 + (vp->reso_max - reso) * (vp->reso_max - reso) * 2) / 100;
    if (reso && bw_index > fmax) bw_index = fmax;
    reso = (reso+5)/10;

    switch(reso) {
	case 0:
		r = moog_q0[bw_index][0];
		p = moog_q0[bw_index][1];
		k = moog_q0[bw_index][2];
		
		break;
	case 1:
		r = moog_q10[bw_index][0];
		p = moog_q10[bw_index][1];
		k = moog_q10[bw_index][2];
		
		break;
	case 2:
		r = moog_q20[bw_index][0];
		p = moog_q20[bw_index][1];
		k = moog_q20[bw_index][2];
		
		break;
	case 3:
		r = moog_q30[bw_index][0];
		p = moog_q30[bw_index][1];
		k = moog_q30[bw_index][2];
		
		break;
	case 4:
		r = moog_q40[bw_index][0];
		p = moog_q40[bw_index][1];
		k = moog_q40[bw_index][2];
		
		break;
	case 5:
		r = moog_q50[bw_index][0];
		p = moog_q50[bw_index][1];
		k = moog_q50[bw_index][2];
		
		break;
	case 6:
		r = moog_q60[bw_index][0];
		p = moog_q60[bw_index][1];
		k = moog_q60[bw_index][2];
		
		break;
	case 7:
		r = moog_q70[bw_index][0];
		p = moog_q70[bw_index][1];
		k = moog_q70[bw_index][2];
		
		break;
	case 8:
		r = moog_q80[bw_index][0];
		p = moog_q80[bw_index][1];
		k = moog_q80[bw_index][2];
		
		break;
	case 9:
		r = moog_q90[bw_index][0];
		p = moog_q90[bw_index][1];
		k = moog_q90[bw_index][2];
		
		break;
	case 10:
		r = moog_q100[bw_index][0];
		p = moog_q100[bw_index][1];
		k = moog_q100[bw_index][2];
		
		break;
	case 11:
		r = moog_q110[bw_index][0];
		p = moog_q110[bw_index][1];
		k = moog_q110[bw_index][2];
		
		break;
	case 12:
		r = moog_q120[bw_index][0];
		p = moog_q120[bw_index][1];
		k = moog_q120[bw_index][2];
		
		break;
	case 13:
		r = moog_q130[bw_index][0];
		p = moog_q130[bw_index][1];
		k = moog_q130[bw_index][2];
		
		break;
	case 14:
		r = moog_q140[bw_index][0];
		p = moog_q140[bw_index][1];
		k = moog_q140[bw_index][2];
		
		break;
	case 15:
		r = moog_q150[bw_index][0];
		p = moog_q150[bw_index][1];
		k = moog_q150[bw_index][2];
		
		break;
	case 16:
		r = moog_q160[bw_index][0];
		p = moog_q160[bw_index][1];
		k = moog_q160[bw_index][2];
		
		break;
	case 17:
		r = moog_q170[bw_index][0];
		p = moog_q170[bw_index][1];
		k = moog_q170[bw_index][2];
		
		break;
	case 18:
		r = moog_q180[bw_index][0];
		p = moog_q180[bw_index][1];
		k = moog_q180[bw_index][2];
		
		break;
	case 19:
		r = moog_q190[bw_index][0];
		p = moog_q190[bw_index][1];
		k = moog_q190[bw_index][2];
		
		break;
	case 20:
		r = moog_q200[bw_index][0];
		p = moog_q200[bw_index][1];
		k = moog_q200[bw_index][2];
		
		break;
	case 21:
		r = moog_q210[bw_index][0];
		p = moog_q210[bw_index][1];
		k = moog_q210[bw_index][2];
		
		break;
	case 22:
		r = moog_q220[bw_index][0];
		p = moog_q220[bw_index][1];
		k = moog_q220[bw_index][2];
		
		break;
	case 23:
		r = moog_q230[bw_index][0];
		p = moog_q230[bw_index][1];
		k = moog_q230[bw_index][2];
		
		break;
	default:
	case 24:
		r = moog_q240[bw_index][0];
		p = moog_q240[bw_index][1];
		k = moog_q240[bw_index][2];
		
		break;
    }




		    }
		    incr = calc_mod_freq(vp, incr);
		}
		newsample = (resample_t)v1;
		if (bw_index) {
                    insamp = (FLOAT_T)newsample;

		    x = insamp / (FLOAT_T)MAX_DATAVAL;

		    //--Inverted feed back for corner peaking
		    x = x - r*y4;

		    //Four cascaded onepole filters (bilinear transform)
		    y1m = x   * p + oldx  * p - k * y1m;
		    y2  = y1m * p + oldy1 * p - k * y2;
		    y3  = y2  * p + oldy2 * p - k * y3;
		    y4  = y3  * p + oldy3 * p - k * y4;

		    //Clipper band limited sigmoid
		    y4 = y4 - (y4*y4*y4)/6.0;

		    oldx = x;
		    oldy1 = y1m;
		    oldy2 = y2;
		    oldy3 = y3;

		    newsample = (resample_t)(y4 * (FLOAT_T)MAX_DATAVAL);
		}
		ofs=ofsd;
	}
	*dest++ = newsample;
      ofs += incr;
      if (ofs>=le)
	{
	  if (flag_exit_loop)
	    {
	    	vp->reverb_time -= ll >> FRACTION_BITS;
	  	if (vp->reverb_time >= 0) ofs -= ll;
	    }
	  else ofs -= ll; /* Hopefully the loop is longer than an increment. */
	}
      if (ofs >= se + (overshoot << FRACTION_BITS))
	{
	  if (!(vp->status&VOICE_FREE))
	    {
	      vp->status=VOICE_FREE;
 	      ctl->note(v);
	    }
	  *countptr-=count+1;
	  break;
	}
    }

  vp->vibrato_control_counter=cc;
  vp->sample_increment=incr;
  vp->sample_offset=ofs; /* Update offset */

  vp->current_x0=oldx;
  vp->current_x1=oldy1;
  vp->current_y0=oldy2;
  vp->current_y1=oldy3;
  vp->current_y2=y4;
  vp->bw_index=bw_index;
  vp->modulation_counter=cc_count;
  return resample_buffer+resample_buffer_offset;
}

static resample_t *rs_vib_bidir(Voice *vp, uint32 count)
{
  int32   v0, v1, v2, v3, temp, overshoot;
  splen_t ofsd;
  int32 offset;
  FLOAT_T insamp, r, p, k, x, y1m=0, y2=0, y3=0,
    oldx=vp->current_x0, oldy1=vp->current_x1,
    oldy2=vp->current_y0, oldy3=vp->current_y1,
    y4=vp->current_y2;
  uint32 cc_count=vp->modulation_counter, bw_index=vp->bw_index, fmax;
  uint16 reso;
  resample_t newsample;
  int32
    incr=vp->sample_increment;
  splen_t
    le=vp->loop_end,
    ls=vp->loop_start,
    ofs=vp->sample_offset,
    se=vp->sample->data_length;
  resample_t
    *dest=resample_buffer+resample_buffer_offset;
#ifdef SL32
  samplel_t
    *src=vp->sample->ldata;
#else
  sample_t
    *src=vp->sample->data;
#endif
  uint32
    cc=vp->vibrato_control_counter;


#ifdef USE_BIDIR_OVERSHOOT
  splen_t
    le2=le<<1,
    ls2=ls<<1;
#endif
  uint32
    i, j;
  int
    vibflag = 0;


  overshoot = src[(se>>FRACTION_BITS)-1] / OVERSHOOT_STEP;
  if (overshoot < 0) overshoot = -overshoot;

    reso = vp->resonance + vp->reso_volume;
    if (reso > vp->reso_max) reso = vp->reso_max;
    fmax = (1000 + (vp->reso_max - reso) * (vp->reso_max - reso) * 2) / 100;
    if (reso && bw_index > fmax) bw_index = fmax;
    reso = (reso+5)/10;

    switch(reso) {
	case 0:
		r = moog_q0[bw_index][0];
		p = moog_q0[bw_index][1];
		k = moog_q0[bw_index][2];
		
		break;
	case 1:
		r = moog_q10[bw_index][0];
		p = moog_q10[bw_index][1];
		k = moog_q10[bw_index][2];
		
		break;
	case 2:
		r = moog_q20[bw_index][0];
		p = moog_q20[bw_index][1];
		k = moog_q20[bw_index][2];
		
		break;
	case 3:
		r = moog_q30[bw_index][0];
		p = moog_q30[bw_index][1];
		k = moog_q30[bw_index][2];
		
		break;
	case 4:
		r = moog_q40[bw_index][0];
		p = moog_q40[bw_index][1];
		k = moog_q40[bw_index][2];
		
		break;
	case 5:
		r = moog_q50[bw_index][0];
		p = moog_q50[bw_index][1];
		k = moog_q50[bw_index][2];
		
		break;
	case 6:
		r = moog_q60[bw_index][0];
		p = moog_q60[bw_index][1];
		k = moog_q60[bw_index][2];
		
		break;
	case 7:
		r = moog_q70[bw_index][0];
		p = moog_q70[bw_index][1];
		k = moog_q70[bw_index][2];
		
		break;
	case 8:
		r = moog_q80[bw_index][0];
		p = moog_q80[bw_index][1];
		k = moog_q80[bw_index][2];
		
		break;
	case 9:
		r = moog_q90[bw_index][0];
		p = moog_q90[bw_index][1];
		k = moog_q90[bw_index][2];
		
		break;
	case 10:
		r = moog_q100[bw_index][0];
		p = moog_q100[bw_index][1];
		k = moog_q100[bw_index][2];
		
		break;
	case 11:
		r = moog_q110[bw_index][0];
		p = moog_q110[bw_index][1];
		k = moog_q110[bw_index][2];
		
		break;
	case 12:
		r = moog_q120[bw_index][0];
		p = moog_q120[bw_index][1];
		k = moog_q120[bw_index][2];
		
		break;
	case 13:
		r = moog_q130[bw_index][0];
		p = moog_q130[bw_index][1];
		k = moog_q130[bw_index][2];
		
		break;
	case 14:
		r = moog_q140[bw_index][0];
		p = moog_q140[bw_index][1];
		k = moog_q140[bw_index][2];
		
		break;
	case 15:
		r = moog_q150[bw_index][0];
		p = moog_q150[bw_index][1];
		k = moog_q150[bw_index][2];
		
		break;
	case 16:
		r = moog_q160[bw_index][0];
		p = moog_q160[bw_index][1];
		k = moog_q160[bw_index][2];
		
		break;
	case 17:
		r = moog_q170[bw_index][0];
		p = moog_q170[bw_index][1];
		k = moog_q170[bw_index][2];
		
		break;
	case 18:
		r = moog_q180[bw_index][0];
		p = moog_q180[bw_index][1];
		k = moog_q180[bw_index][2];
		
		break;
	case 19:
		r = moog_q190[bw_index][0];
		p = moog_q190[bw_index][1];
		k = moog_q190[bw_index][2];
		
		break;
	case 20:
		r = moog_q200[bw_index][0];
		p = moog_q200[bw_index][1];
		k = moog_q200[bw_index][2];
		
		break;
	case 21:
		r = moog_q210[bw_index][0];
		p = moog_q210[bw_index][1];
		k = moog_q210[bw_index][2];
		
		break;
	case 22:
		r = moog_q220[bw_index][0];
		p = moog_q220[bw_index][1];
		k = moog_q220[bw_index][2];
		
		break;
	case 23:
		r = moog_q230[bw_index][0];
		p = moog_q230[bw_index][1];
		k = moog_q230[bw_index][2];
		
		break;
	default:
	case 24:
		r = moog_q240[bw_index][0];
		p = moog_q240[bw_index][1];
		k = moog_q240[bw_index][2];
		
		break;
    }

  /* Play normally until inside the loop region */
  while (count && (ofs <= ls))
    {
      i = (ls - ofs) / incr + 1;
      if (i > count) i = count;
      if (i > cc)
	{
	  i = cc;
	  vibflag = 1;
	}
      else cc -= i;
      count -= i;
      for(j = 0; j < i; j++)
	{


	offset = ofs >> FRACTION_BITS;

	if (ofs >= se) {
		int32 delta = (ofs - se)>>FRACTION_BITS;
        	v1 = (int32)src[(int32)(se>>FRACTION_BITS)-1];
		if (overshoot) v1 -=  (delta+1) * v1 / overshoot;
        }
	else  v1 = (int32)src[offset];

	if (ofs + (1L<<FRACTION_BITS) >= se) {
		v2 = v1;
        }
	else  v2 = (int32)src[offset+1];

	if ( (vp->algorithm & INTERPOLATION_LINEAR) || dont_cspline ||
	   ((ofs-(1L<<FRACTION_BITS))<ls)||((ofs+(2L<<FRACTION_BITS))>le)){
		if (!cc_count--) {
		    cc_count = control_ratio - 1;
		    if (calc_bw_index(vp)) {
		        bw_index = vp->bw_index;


    reso = vp->resonance + vp->reso_volume;
    if (reso > vp->reso_max) reso = vp->reso_max;
    fmax = (1000 + (vp->reso_max - reso) * (vp->reso_max - reso) * 2) / 100;
    if (reso && bw_index > fmax) bw_index = fmax;
    reso = (reso+5)/10;

    switch(reso) {
	case 0:
		r = moog_q0[bw_index][0];
		p = moog_q0[bw_index][1];
		k = moog_q0[bw_index][2];
		
		break;
	case 1:
		r = moog_q10[bw_index][0];
		p = moog_q10[bw_index][1];
		k = moog_q10[bw_index][2];
		
		break;
	case 2:
		r = moog_q20[bw_index][0];
		p = moog_q20[bw_index][1];
		k = moog_q20[bw_index][2];
		
		break;
	case 3:
		r = moog_q30[bw_index][0];
		p = moog_q30[bw_index][1];
		k = moog_q30[bw_index][2];
		
		break;
	case 4:
		r = moog_q40[bw_index][0];
		p = moog_q40[bw_index][1];
		k = moog_q40[bw_index][2];
		
		break;
	case 5:
		r = moog_q50[bw_index][0];
		p = moog_q50[bw_index][1];
		k = moog_q50[bw_index][2];
		
		break;
	case 6:
		r = moog_q60[bw_index][0];
		p = moog_q60[bw_index][1];
		k = moog_q60[bw_index][2];
		
		break;
	case 7:
		r = moog_q70[bw_index][0];
		p = moog_q70[bw_index][1];
		k = moog_q70[bw_index][2];
		
		break;
	case 8:
		r = moog_q80[bw_index][0];
		p = moog_q80[bw_index][1];
		k = moog_q80[bw_index][2];
		
		break;
	case 9:
		r = moog_q90[bw_index][0];
		p = moog_q90[bw_index][1];
		k = moog_q90[bw_index][2];
		
		break;
	case 10:
		r = moog_q100[bw_index][0];
		p = moog_q100[bw_index][1];
		k = moog_q100[bw_index][2];
		
		break;
	case 11:
		r = moog_q110[bw_index][0];
		p = moog_q110[bw_index][1];
		k = moog_q110[bw_index][2];
		
		break;
	case 12:
		r = moog_q120[bw_index][0];
		p = moog_q120[bw_index][1];
		k = moog_q120[bw_index][2];
		
		break;
	case 13:
		r = moog_q130[bw_index][0];
		p = moog_q130[bw_index][1];
		k = moog_q130[bw_index][2];
		
		break;
	case 14:
		r = moog_q140[bw_index][0];
		p = moog_q140[bw_index][1];
		k = moog_q140[bw_index][2];
		
		break;
	case 15:
		r = moog_q150[bw_index][0];
		p = moog_q150[bw_index][1];
		k = moog_q150[bw_index][2];
		
		break;
	case 16:
		r = moog_q160[bw_index][0];
		p = moog_q160[bw_index][1];
		k = moog_q160[bw_index][2];
		
		break;
	case 17:
		r = moog_q170[bw_index][0];
		p = moog_q170[bw_index][1];
		k = moog_q170[bw_index][2];
		
		break;
	case 18:
		r = moog_q180[bw_index][0];
		p = moog_q180[bw_index][1];
		k = moog_q180[bw_index][2];
		
		break;
	case 19:
		r = moog_q190[bw_index][0];
		p = moog_q190[bw_index][1];
		k = moog_q190[bw_index][2];
		
		break;
	case 20:
		r = moog_q200[bw_index][0];
		p = moog_q200[bw_index][1];
		k = moog_q200[bw_index][2];
		
		break;
	case 21:
		r = moog_q210[bw_index][0];
		p = moog_q210[bw_index][1];
		k = moog_q210[bw_index][2];
		
		break;
	case 22:
		r = moog_q220[bw_index][0];
		p = moog_q220[bw_index][1];
		k = moog_q220[bw_index][2];
		
		break;
	case 23:
		r = moog_q230[bw_index][0];
		p = moog_q230[bw_index][1];
		k = moog_q230[bw_index][2];
		
		break;
	default:
	case 24:
		r = moog_q240[bw_index][0];
		p = moog_q240[bw_index][1];
		k = moog_q240[bw_index][2];
		
		break;
    }


		    }
		    incr = calc_mod_freq(vp, incr);
		}
                newsample = (resample_t)(v1 + ((int32)((v2-v1) * (ofs & FRACTION_MASK)) >> FRACTION_BITS));
	        if (bw_index) {
                    insamp = (FLOAT_T)newsample;

		    x = insamp / (FLOAT_T)MAX_DATAVAL;

		    //--Inverted feed back for corner peaking
		    x = x - r*y4;

		    //Four cascaded onepole filters (bilinear transform)
		    y1m = x   * p + oldx  * p - k * y1m;
		    y2  = y1m * p + oldy1 * p - k * y2;
		    y3  = y2  * p + oldy2 * p - k * y3;
		    y4  = y3  * p + oldy3 * p - k * y4;

		    //Clipper band limited sigmoid
		    y4 = y4 - (y4*y4*y4)/6.0;

		    oldx = x;
		    oldy1 = y1m;
		    oldy2 = y2;
		    oldy3 = y3;

		    newsample = (resample_t)(y4 * (FLOAT_T)MAX_DATAVAL);
	        }
	}
	else {
		ofsd=ofs;
                v0 = (int32)src[offset-1];
                v3 = (int32)src[offset+2];
                ofs &= FRACTION_MASK;
                temp=v2;
		v2 = (6*v2 +
		      (((( ( (5*v3 - 11*v2 + 7*v1 - v0)*
		       (int32)ofs) >>FRACTION_BITS)*(int32)ofs)>>(FRACTION_BITS+2))-1))*(int32)ofs;
                ofs = (1L << FRACTION_BITS) - ofs;
		v1 = (6*v1 +
		      ((((((5*v0 - 11*v1 + 7*temp - v3)*
		       (int32)ofs)>>FRACTION_BITS)*(int32)ofs)>>(FRACTION_BITS+2))-1))*(int32)ofs;
		v1 = (v1 + v2)/(6L<<FRACTION_BITS);
		if (!cc_count--) {
		    cc_count = control_ratio - 1;
		    if (calc_bw_index(vp)) {
			bw_index = vp->bw_index;


    reso = vp->resonance + vp->reso_volume;
    if (reso > vp->reso_max) reso = vp->reso_max;
    fmax = (1000 + (vp->reso_max - reso) * (vp->reso_max - reso) * 2) / 100;
    if (reso && bw_index > fmax) bw_index = fmax;
    reso = (reso+5)/10;

    switch(reso) {
	case 0:
		r = moog_q0[bw_index][0];
		p = moog_q0[bw_index][1];
		k = moog_q0[bw_index][2];
		
		break;
	case 1:
		r = moog_q10[bw_index][0];
		p = moog_q10[bw_index][1];
		k = moog_q10[bw_index][2];
		
		break;
	case 2:
		r = moog_q20[bw_index][0];
		p = moog_q20[bw_index][1];
		k = moog_q20[bw_index][2];
		
		break;
	case 3:
		r = moog_q30[bw_index][0];
		p = moog_q30[bw_index][1];
		k = moog_q30[bw_index][2];
		
		break;
	case 4:
		r = moog_q40[bw_index][0];
		p = moog_q40[bw_index][1];
		k = moog_q40[bw_index][2];
		
		break;
	case 5:
		r = moog_q50[bw_index][0];
		p = moog_q50[bw_index][1];
		k = moog_q50[bw_index][2];
		
		break;
	case 6:
		r = moog_q60[bw_index][0];
		p = moog_q60[bw_index][1];
		k = moog_q60[bw_index][2];
		
		break;
	case 7:
		r = moog_q70[bw_index][0];
		p = moog_q70[bw_index][1];
		k = moog_q70[bw_index][2];
		
		break;
	case 8:
		r = moog_q80[bw_index][0];
		p = moog_q80[bw_index][1];
		k = moog_q80[bw_index][2];
		
		break;
	case 9:
		r = moog_q90[bw_index][0];
		p = moog_q90[bw_index][1];
		k = moog_q90[bw_index][2];
		
		break;
	case 10:
		r = moog_q100[bw_index][0];
		p = moog_q100[bw_index][1];
		k = moog_q100[bw_index][2];
		
		break;
	case 11:
		r = moog_q110[bw_index][0];
		p = moog_q110[bw_index][1];
		k = moog_q110[bw_index][2];
		
		break;
	case 12:
		r = moog_q120[bw_index][0];
		p = moog_q120[bw_index][1];
		k = moog_q120[bw_index][2];
		
		break;
	case 13:
		r = moog_q130[bw_index][0];
		p = moog_q130[bw_index][1];
		k = moog_q130[bw_index][2];
		
		break;
	case 14:
		r = moog_q140[bw_index][0];
		p = moog_q140[bw_index][1];
		k = moog_q140[bw_index][2];
		
		break;
	case 15:
		r = moog_q150[bw_index][0];
		p = moog_q150[bw_index][1];
		k = moog_q150[bw_index][2];
		
		break;
	case 16:
		r = moog_q160[bw_index][0];
		p = moog_q160[bw_index][1];
		k = moog_q160[bw_index][2];
		
		break;
	case 17:
		r = moog_q170[bw_index][0];
		p = moog_q170[bw_index][1];
		k = moog_q170[bw_index][2];
		
		break;
	case 18:
		r = moog_q180[bw_index][0];
		p = moog_q180[bw_index][1];
		k = moog_q180[bw_index][2];
		
		break;
	case 19:
		r = moog_q190[bw_index][0];
		p = moog_q190[bw_index][1];
		k = moog_q190[bw_index][2];
		
		break;
	case 20:
		r = moog_q200[bw_index][0];
		p = moog_q200[bw_index][1];
		k = moog_q200[bw_index][2];
		
		break;
	case 21:
		r = moog_q210[bw_index][0];
		p = moog_q210[bw_index][1];
		k = moog_q210[bw_index][2];
		
		break;
	case 22:
		r = moog_q220[bw_index][0];
		p = moog_q220[bw_index][1];
		k = moog_q220[bw_index][2];
		
		break;
	case 23:
		r = moog_q230[bw_index][0];
		p = moog_q230[bw_index][1];
		k = moog_q230[bw_index][2];
		
		break;
	default:
	case 24:
		r = moog_q240[bw_index][0];
		p = moog_q240[bw_index][1];
		k = moog_q240[bw_index][2];
		
		break;
    }




		    }
		    incr = calc_mod_freq(vp, incr);
		}
		newsample = (resample_t)v1;
		if (bw_index) {
                    insamp = (FLOAT_T)newsample;

		    x = insamp / (FLOAT_T)MAX_DATAVAL;

		    //--Inverted feed back for corner peaking
		    x = x - r*y4;

		    //Four cascaded onepole filters (bilinear transform)
		    y1m = x   * p + oldx  * p - k * y1m;
		    y2  = y1m * p + oldy1 * p - k * y2;
		    y3  = y2  * p + oldy2 * p - k * y3;
		    y4  = y3  * p + oldy3 * p - k * y4;

		    //Clipper band limited sigmoid
		    y4 = y4 - (y4*y4*y4)/6.0;

		    oldx = x;
		    oldy1 = y1m;
		    oldy2 = y2;
		    oldy3 = y3;

		    newsample = (resample_t)(y4 * (FLOAT_T)MAX_DATAVAL);
		}
		ofs=ofsd;
	}
	*dest++ = newsample;
	  ofs += incr;
	}
      if (vibflag)
	{
	  cc = vp->vibrato_control_ratio;
	  incr = update_vibrato(vp, 0);
	  vibflag = 0;
	}
    }

  /* Then do the bidirectional looping */

  while (count)
    {
      /* Precalc how many times we should go through the loop */
#if 1
      i = ((incr > 0 ? le : ls) - ofs) / incr + 1;
#else
/* fix from M. Izumo */
      i = ((incr > 0 ? le : ls) - ofs + incr - 1) / incr;
#endif
      if(i > count) i = count;
      if(i > cc)
	{
	  i = cc;
	  vibflag = 1;
	}
      else cc -= i;
      count -= i;
      while (i-- && ofs < se)
	{


	offset = ofs >> FRACTION_BITS;

	if (ofs >= se) {
		int32 delta = (ofs - se)>>FRACTION_BITS;
        	v1 = (int32)src[(int32)(se>>FRACTION_BITS)-1];
		if (overshoot) v1 -=  (delta+1) * v1 / overshoot;
        }
	else  v1 = (int32)src[offset];

	if (ofs + (1L<<FRACTION_BITS) >= se) {
		v2 = v1;
        }
	else  v2 = (int32)src[offset+1];

	if ( (vp->algorithm & INTERPOLATION_LINEAR) || dont_cspline ||
	   ((ofs-(1L<<FRACTION_BITS))<ls)||((ofs+(2L<<FRACTION_BITS))>le)){
		if (!cc_count--) {
		    cc_count = control_ratio - 1;
		    if (calc_bw_index(vp)) {
		        bw_index = vp->bw_index;


    reso = vp->resonance + vp->reso_volume;
    if (reso > vp->reso_max) reso = vp->reso_max;
    fmax = (1000 + (vp->reso_max - reso) * (vp->reso_max - reso) * 2) / 100;
    if (reso && bw_index > fmax) bw_index = fmax;
    reso = (reso+5)/10;

    switch(reso) {
	case 0:
		r = moog_q0[bw_index][0];
		p = moog_q0[bw_index][1];
		k = moog_q0[bw_index][2];
		
		break;
	case 1:
		r = moog_q10[bw_index][0];
		p = moog_q10[bw_index][1];
		k = moog_q10[bw_index][2];
		
		break;
	case 2:
		r = moog_q20[bw_index][0];
		p = moog_q20[bw_index][1];
		k = moog_q20[bw_index][2];
		
		break;
	case 3:
		r = moog_q30[bw_index][0];
		p = moog_q30[bw_index][1];
		k = moog_q30[bw_index][2];
		
		break;
	case 4:
		r = moog_q40[bw_index][0];
		p = moog_q40[bw_index][1];
		k = moog_q40[bw_index][2];
		
		break;
	case 5:
		r = moog_q50[bw_index][0];
		p = moog_q50[bw_index][1];
		k = moog_q50[bw_index][2];
		
		break;
	case 6:
		r = moog_q60[bw_index][0];
		p = moog_q60[bw_index][1];
		k = moog_q60[bw_index][2];
		
		break;
	case 7:
		r = moog_q70[bw_index][0];
		p = moog_q70[bw_index][1];
		k = moog_q70[bw_index][2];
		
		break;
	case 8:
		r = moog_q80[bw_index][0];
		p = moog_q80[bw_index][1];
		k = moog_q80[bw_index][2];
		
		break;
	case 9:
		r = moog_q90[bw_index][0];
		p = moog_q90[bw_index][1];
		k = moog_q90[bw_index][2];
		
		break;
	case 10:
		r = moog_q100[bw_index][0];
		p = moog_q100[bw_index][1];
		k = moog_q100[bw_index][2];
		
		break;
	case 11:
		r = moog_q110[bw_index][0];
		p = moog_q110[bw_index][1];
		k = moog_q110[bw_index][2];
		
		break;
	case 12:
		r = moog_q120[bw_index][0];
		p = moog_q120[bw_index][1];
		k = moog_q120[bw_index][2];
		
		break;
	case 13:
		r = moog_q130[bw_index][0];
		p = moog_q130[bw_index][1];
		k = moog_q130[bw_index][2];
		
		break;
	case 14:
		r = moog_q140[bw_index][0];
		p = moog_q140[bw_index][1];
		k = moog_q140[bw_index][2];
		
		break;
	case 15:
		r = moog_q150[bw_index][0];
		p = moog_q150[bw_index][1];
		k = moog_q150[bw_index][2];
		
		break;
	case 16:
		r = moog_q160[bw_index][0];
		p = moog_q160[bw_index][1];
		k = moog_q160[bw_index][2];
		
		break;
	case 17:
		r = moog_q170[bw_index][0];
		p = moog_q170[bw_index][1];
		k = moog_q170[bw_index][2];
		
		break;
	case 18:
		r = moog_q180[bw_index][0];
		p = moog_q180[bw_index][1];
		k = moog_q180[bw_index][2];
		
		break;
	case 19:
		r = moog_q190[bw_index][0];
		p = moog_q190[bw_index][1];
		k = moog_q190[bw_index][2];
		
		break;
	case 20:
		r = moog_q200[bw_index][0];
		p = moog_q200[bw_index][1];
		k = moog_q200[bw_index][2];
		
		break;
	case 21:
		r = moog_q210[bw_index][0];
		p = moog_q210[bw_index][1];
		k = moog_q210[bw_index][2];
		
		break;
	case 22:
		r = moog_q220[bw_index][0];
		p = moog_q220[bw_index][1];
		k = moog_q220[bw_index][2];
		
		break;
	case 23:
		r = moog_q230[bw_index][0];
		p = moog_q230[bw_index][1];
		k = moog_q230[bw_index][2];
		
		break;
	default:
	case 24:
		r = moog_q240[bw_index][0];
		p = moog_q240[bw_index][1];
		k = moog_q240[bw_index][2];
		
		break;
    }


		    }
		    incr = calc_mod_freq(vp, incr);
		}
                newsample = (resample_t)(v1 + ((int32)((v2-v1) * (ofs & FRACTION_MASK)) >> FRACTION_BITS));
	        if (bw_index) {
                    insamp = (FLOAT_T)newsample;

		    x = insamp / (FLOAT_T)MAX_DATAVAL;

		    //--Inverted feed back for corner peaking
		    x = x - r*y4;

		    //Four cascaded onepole filters (bilinear transform)
		    y1m = x   * p + oldx  * p - k * y1m;
		    y2  = y1m * p + oldy1 * p - k * y2;
		    y3  = y2  * p + oldy2 * p - k * y3;
		    y4  = y3  * p + oldy3 * p - k * y4;

		    //Clipper band limited sigmoid
		    y4 = y4 - (y4*y4*y4)/6.0;

		    oldx = x;
		    oldy1 = y1m;
		    oldy2 = y2;
		    oldy3 = y3;

		    newsample = (resample_t)(y4 * (FLOAT_T)MAX_DATAVAL);
	        }
	}
	else {
		ofsd=ofs;
                v0 = (int32)src[offset-1];
                v3 = (int32)src[offset+2];
                ofs &= FRACTION_MASK;
                temp=v2;
		v2 = (6*v2 +
		      (((( ( (5*v3 - 11*v2 + 7*v1 - v0)*
		       (int32)ofs) >>FRACTION_BITS)*(int32)ofs)>>(FRACTION_BITS+2))-1))*(int32)ofs;
                ofs = (1L << FRACTION_BITS) - ofs;
		v1 = (6*v1 +
		      ((((((5*v0 - 11*v1 + 7*temp - v3)*
		       (int32)ofs)>>FRACTION_BITS)*(int32)ofs)>>(FRACTION_BITS+2))-1))*(int32)ofs;
		v1 = (v1 + v2)/(6L<<FRACTION_BITS);
		if (!cc_count--) {
		    cc_count = control_ratio - 1;
		    if (calc_bw_index(vp)) {
			bw_index = vp->bw_index;


    reso = vp->resonance + vp->reso_volume;
    if (reso > vp->reso_max) reso = vp->reso_max;
    fmax = (1000 + (vp->reso_max - reso) * (vp->reso_max - reso) * 2) / 100;
    if (reso && bw_index > fmax) bw_index = fmax;
    reso = (reso+5)/10;

    switch(reso) {
	case 0:
		r = moog_q0[bw_index][0];
		p = moog_q0[bw_index][1];
		k = moog_q0[bw_index][2];
		
		break;
	case 1:
		r = moog_q10[bw_index][0];
		p = moog_q10[bw_index][1];
		k = moog_q10[bw_index][2];
		
		break;
	case 2:
		r = moog_q20[bw_index][0];
		p = moog_q20[bw_index][1];
		k = moog_q20[bw_index][2];
		
		break;
	case 3:
		r = moog_q30[bw_index][0];
		p = moog_q30[bw_index][1];
		k = moog_q30[bw_index][2];
		
		break;
	case 4:
		r = moog_q40[bw_index][0];
		p = moog_q40[bw_index][1];
		k = moog_q40[bw_index][2];
		
		break;
	case 5:
		r = moog_q50[bw_index][0];
		p = moog_q50[bw_index][1];
		k = moog_q50[bw_index][2];
		
		break;
	case 6:
		r = moog_q60[bw_index][0];
		p = moog_q60[bw_index][1];
		k = moog_q60[bw_index][2];
		
		break;
	case 7:
		r = moog_q70[bw_index][0];
		p = moog_q70[bw_index][1];
		k = moog_q70[bw_index][2];
		
		break;
	case 8:
		r = moog_q80[bw_index][0];
		p = moog_q80[bw_index][1];
		k = moog_q80[bw_index][2];
		
		break;
	case 9:
		r = moog_q90[bw_index][0];
		p = moog_q90[bw_index][1];
		k = moog_q90[bw_index][2];
		
		break;
	case 10:
		r = moog_q100[bw_index][0];
		p = moog_q100[bw_index][1];
		k = moog_q100[bw_index][2];
		
		break;
	case 11:
		r = moog_q110[bw_index][0];
		p = moog_q110[bw_index][1];
		k = moog_q110[bw_index][2];
		
		break;
	case 12:
		r = moog_q120[bw_index][0];
		p = moog_q120[bw_index][1];
		k = moog_q120[bw_index][2];
		
		break;
	case 13:
		r = moog_q130[bw_index][0];
		p = moog_q130[bw_index][1];
		k = moog_q130[bw_index][2];
		
		break;
	case 14:
		r = moog_q140[bw_index][0];
		p = moog_q140[bw_index][1];
		k = moog_q140[bw_index][2];
		
		break;
	case 15:
		r = moog_q150[bw_index][0];
		p = moog_q150[bw_index][1];
		k = moog_q150[bw_index][2];
		
		break;
	case 16:
		r = moog_q160[bw_index][0];
		p = moog_q160[bw_index][1];
		k = moog_q160[bw_index][2];
		
		break;
	case 17:
		r = moog_q170[bw_index][0];
		p = moog_q170[bw_index][1];
		k = moog_q170[bw_index][2];
		
		break;
	case 18:
		r = moog_q180[bw_index][0];
		p = moog_q180[bw_index][1];
		k = moog_q180[bw_index][2];
		
		break;
	case 19:
		r = moog_q190[bw_index][0];
		p = moog_q190[bw_index][1];
		k = moog_q190[bw_index][2];
		
		break;
	case 20:
		r = moog_q200[bw_index][0];
		p = moog_q200[bw_index][1];
		k = moog_q200[bw_index][2];
		
		break;
	case 21:
		r = moog_q210[bw_index][0];
		p = moog_q210[bw_index][1];
		k = moog_q210[bw_index][2];
		
		break;
	case 22:
		r = moog_q220[bw_index][0];
		p = moog_q220[bw_index][1];
		k = moog_q220[bw_index][2];
		
		break;
	case 23:
		r = moog_q230[bw_index][0];
		p = moog_q230[bw_index][1];
		k = moog_q230[bw_index][2];
		
		break;
	default:
	case 24:
		r = moog_q240[bw_index][0];
		p = moog_q240[bw_index][1];
		k = moog_q240[bw_index][2];
		
		break;
    }




		    }
		    incr = calc_mod_freq(vp, incr);
		}
		newsample = (resample_t)v1;
		if (bw_index) {
                    insamp = (FLOAT_T)newsample;

		    x = insamp / (FLOAT_T)MAX_DATAVAL;

		    //--Inverted feed back for corner peaking
		    x = x - r*y4;

		    //Four cascaded onepole filters (bilinear transform)
		    y1m = x   * p + oldx  * p - k * y1m;
		    y2  = y1m * p + oldy1 * p - k * y2;
		    y3  = y2  * p + oldy2 * p - k * y3;
		    y4  = y3  * p + oldy3 * p - k * y4;

		    //Clipper band limited sigmoid
		    y4 = y4 - (y4*y4*y4)/6.0;

		    oldx = x;
		    oldy1 = y1m;
		    oldy2 = y2;
		    oldy3 = y3;

		    newsample = (resample_t)(y4 * (FLOAT_T)MAX_DATAVAL);
		}
		ofs=ofsd;
	}
	*dest++ = newsample;
	  ofs += incr;
	}
      if (vibflag)
	{
	  cc = vp->vibrato_control_ratio;
	  incr = update_vibrato(vp, (incr < 0));
	  vibflag = 0;
	}
      if (ofs >= le)
	{
#ifdef USE_BIDIR_OVERSHOOT
	  /* fold the overshoot back in */
	  ofs = le2 - ofs;
#endif
	  incr *= -1;
	}
      else if (ofs <= ls)
	{
#ifdef USE_BIDIR_OVERSHOOT
	  ofs = ls2 - ofs;
#endif
	  incr *= -1;
	}
    }


  vp->vibrato_control_counter=cc;
  vp->sample_increment=incr;
  vp->sample_offset=ofs; /* Update offset */

  vp->current_x0=oldx;
  vp->current_x1=oldy1;
  vp->current_y0=oldy2;
  vp->current_y1=oldy3;
  vp->current_y2=y4;
  vp->bw_index=bw_index;
  vp->modulation_counter=cc_count;
  return resample_buffer+resample_buffer_offset;
}

static int rs_update_porta(int v)
{
    Voice *vp=&voice[v];
    int32 d;

    d = vp->porta_dpb;
    if(vp->porta_pb < 0)
    {
	if(d > -vp->porta_pb)
	    d = -vp->porta_pb;
    }
    else
    {
	if(d > vp->porta_pb)
	    d = -vp->porta_pb;
	else
	    d = -d;
    }

    vp->porta_pb += d;
    if(vp->porta_pb == 0)
    {
	vp->porta_control_ratio = 0;
	vp->porta_pb = 0;
    }
    recompute_freq(v);
    return vp->porta_control_ratio;
}

static resample_t *porta_resample_voice(int v, uint32 *countptr, int mode)
{
    Voice *vp=&voice[v];
    uint32 n = *countptr;
    uint32 i;
    resample_t *(* resampler)(int, uint32 *, int);
    int cc = vp->porta_control_counter;
    int loop;

    if(vp->vibrato_control_ratio)
	resampler = vib_resample_voice;
    else
	resampler = normal_resample_voice;
    if(mode != 1)
	loop = 1;
    else
	loop = 0;

    /* vp->cache = NULL; */
    resample_buffer_offset = 0;
    while(resample_buffer_offset < n)
    {
	if(cc == 0)
	{
	    if((cc = rs_update_porta(v)) == 0)
	    {
		i = n - resample_buffer_offset;
		resampler(v, &i, mode);
		resample_buffer_offset += i;
		break;
	    }
	}

	i = n - resample_buffer_offset;
	if(i > (uint32)cc)
	    i = (uint32)cc;
	resampler(v, &i, mode);
	resample_buffer_offset += i;

	/* if(!loop && vp->status == VOICE_FREE) */
	if(vp->status == VOICE_FREE)
	    break;
	cc -= (int)i;
    }
    *countptr = resample_buffer_offset;
    resample_buffer_offset = 0;
    vp->porta_control_counter = cc;
    return resample_buffer;
}

static resample_t *vib_resample_voice(int v, uint32 *countptr, int mode)
{
    Voice *vp = &voice[v];

    /* vp->cache = NULL; */
    if(mode == 0)
	return rs_vib_loop(v, vp, countptr);
    if(mode == 1)
	return rs_vib_plain(v, countptr);
    return rs_vib_bidir(vp, *countptr);
}

static resample_t *normal_resample_voice(int v, uint32 *countptr, int mode)
{
    Voice *vp = &voice[v];
    if(mode == 0)
	return rs_loop(v, vp, countptr);
    if(mode == 1)
	return rs_plain(v, countptr);
    return rs_bidir(vp, *countptr);
}

resample_t *resample_voice_moog(int v, uint32 *countptr)
{
    Voice *vp=&voice[v];
    int mode;

    mode = vp->sample->modes;
    if((mode & MODES_LOOPING) &&
       ((mode & MODES_ENVELOPE) ||
	(vp->status & (VOICE_ON | VOICE_SUSTAINED))))
    {
	if(mode & MODES_PINGPONG)
	{
	    mode = 2;
	}
	else
	    mode = 0;
    }
    else
	mode = 1;

    if(vp->porta_control_ratio)
	return porta_resample_voice(v, countptr, mode);

    if(vp->vibrato_control_ratio)
	return vib_resample_voice(v, countptr, mode);

    return normal_resample_voice(v, countptr, mode);
}

