/* candidatearea.c generated by valac 0.34.6, the Vala compiler
 * generated from candidatearea.vala, do not modify */

/* vim:set et sts=4 sw=4:
 *
 * ibus - The Input Bus
 *
 * Copyright(c) 2011-2015 Peng Huang <shawn.p.huang@gmail.com>
 * Copyright(c) 2015-2017 Takao Fujiwara <takao.fujiwara1@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301
 * USA
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <ibus.h>
#include <gdk/gdk.h>
#include <stdlib.h>
#include <string.h>
#include <pango/pango.h>


#define TYPE_CANDIDATE_AREA (candidate_area_get_type ())
#define CANDIDATE_AREA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CANDIDATE_AREA, CandidateArea))
#define CANDIDATE_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CANDIDATE_AREA, CandidateAreaClass))
#define IS_CANDIDATE_AREA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CANDIDATE_AREA))
#define IS_CANDIDATE_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CANDIDATE_AREA))
#define CANDIDATE_AREA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CANDIDATE_AREA, CandidateAreaClass))

typedef struct _CandidateArea CandidateArea;
typedef struct _CandidateAreaClass CandidateAreaClass;
typedef struct _CandidateAreaPrivate CandidateAreaPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _gtk_widget_path_unref0(var) ((var == NULL) ? NULL : (var = (gtk_widget_path_unref (var), NULL)))
#define _pango_attribute_destroy0(var) ((var == NULL) ? NULL : (var = (pango_attribute_destroy (var), NULL)))
#define _pango_attr_list_unref0(var) ((var == NULL) ? NULL : (var = (pango_attr_list_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))

#define TYPE_VSEPARATOR (vseparator_get_type ())
#define VSEPARATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VSEPARATOR, VSeparator))
#define VSEPARATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VSEPARATOR, VSeparatorClass))
#define IS_VSEPARATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VSEPARATOR))
#define IS_VSEPARATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VSEPARATOR))
#define VSEPARATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VSEPARATOR, VSeparatorClass))

typedef struct _VSeparator VSeparator;
typedef struct _VSeparatorClass VSeparatorClass;

#define TYPE_HSEPARATOR (hseparator_get_type ())
#define HSEPARATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HSEPARATOR, HSeparator))
#define HSEPARATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HSEPARATOR, HSeparatorClass))
#define IS_HSEPARATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HSEPARATOR))
#define IS_HSEPARATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HSEPARATOR))
#define HSEPARATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HSEPARATOR, HSeparatorClass))

typedef struct _HSeparator HSeparator;
typedef struct _HSeparatorClass HSeparatorClass;
typedef struct _Block1Data Block1Data;
typedef struct _Block2Data Block2Data;
typedef struct _Block3Data Block3Data;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _CandidateArea {
	GtkBox parent_instance;
	CandidateAreaPrivate * priv;
};

struct _CandidateAreaClass {
	GtkBoxClass parent_class;
};

struct _CandidateAreaPrivate {
	gboolean m_vertical;
	GtkLabel** m_labels;
	gint m_labels_length1;
	gint _m_labels_size_;
	GtkLabel** m_candidates;
	gint m_candidates_length1;
	gint _m_candidates_size_;
	GtkWidget** m_widgets;
	gint m_widgets_length1;
	gint _m_widgets_size_;
	IBusText** m_ibus_candidates;
	gint m_ibus_candidates_length1;
	gint _m_ibus_candidates_size_;
	guint m_focus_candidate;
	gboolean m_show_cursor;
	GtkStyleContext* m_style_context;
	GdkRGBA* m_selected_fg_color;
	GdkRGBA* m_selected_bg_color;
};

struct _Block1Data {
	int _ref_count_;
	CandidateArea* self;
	gint i;
};

struct _Block2Data {
	int _ref_count_;
	Block1Data * _data1_;
	gint index;
};

struct _Block3Data {
	int _ref_count_;
	CandidateArea* self;
	gint index;
};


static gpointer candidate_area_parent_class = NULL;

GType candidate_area_get_type (void) G_GNUC_CONST;
#define CANDIDATE_AREA_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_CANDIDATE_AREA, CandidateAreaPrivate))
enum  {
	CANDIDATE_AREA_DUMMY_PROPERTY
};
CandidateArea* candidate_area_new (gboolean vertical);
CandidateArea* candidate_area_construct (GType object_type, gboolean vertical);
void candidate_area_set_vertical (CandidateArea* self, gboolean vertical, gboolean force);
static void candidate_area_get_selected_color (CandidateArea* self);
static void __lambda12_ (CandidateArea* self);
static void ___lambda12__gtk_style_context_changed (GtkStyleContext* _sender, gpointer self);
gboolean candidate_area_candidate_scrolled (CandidateArea* self, GdkEventScroll* event);
gboolean candidate_area_get_vertical (CandidateArea* self);
static void candidate_area_recreate_ui (CandidateArea* self);
void candidate_area_set_candidates (CandidateArea* self, IBusText** candidates, int candidates_length1, guint focus_candidate, gboolean show_cursor);
void candidate_area_set_labels (CandidateArea* self, IBusText** labels, int labels_length1);
static IBusText** _vala_array_dup1 (IBusText** self, int length);
PangoAttrList* get_pango_attr_list_from_ibus_text (IBusText* text);
static void __lambda7_ (CandidateArea* self, GtkButton* b);
static void ___lambda7__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void __lambda8_ (CandidateArea* self, GtkButton* b);
static void ___lambda8__gtk_button_clicked (GtkButton* _sender, gpointer self);
static gboolean _candidate_area_candidate_scrolled_gtk_widget_scroll_event (GtkWidget* _sender, GdkEventScroll* event, gpointer self);
VSeparator* vseparator_new (void);
VSeparator* vseparator_construct (GType object_type);
GType vseparator_get_type (void) G_GNUC_CONST;
HSeparator* hseparator_new (void);
HSeparator* hseparator_construct (GType object_type);
GType hseparator_get_type (void) G_GNUC_CONST;
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void _vala_array_add1 (GtkLabel*** array, int* length, int* size, GtkLabel* value);
static void _vala_array_add2 (GtkLabel*** array, int* length, int* size, GtkLabel* value);
static gboolean ______lambda9_ (Block2Data* _data2_, GtkWidget* w, GdkEventButton* e);
static gboolean _______lambda9__gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static void _vala_array_add3 (GtkWidget*** array, int* length, int* size, GtkWidget* value);
static gboolean ______lambda10_ (Block2Data* _data2_, GtkWidget* w, GdkEventButton* e);
static gboolean _______lambda10__gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static void _vala_array_add4 (GtkWidget*** array, int* length, int* size, GtkWidget* value);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static void _vala_array_add5 (GtkLabel*** array, int* length, int* size, GtkLabel* value);
static void _vala_array_add6 (GtkLabel*** array, int* length, int* size, GtkLabel* value);
static gboolean ______lambda11_ (Block3Data* _data3_, GtkWidget* w, GdkEventButton* e);
static gboolean _______lambda11__gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static void _vala_array_add7 (GtkWidget*** array, int* length, int* size, GtkWidget* value);
static void g_cclosure_user_marshal_VOID__UINT_UINT_UINT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void candidate_area_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const gchar* CANDIDATE_AREA_LABELS[16] = {"1.", "2.", "3.", "4.", "5.", "6.", "7.", "8.", "9.", "0.", "a.", "b.", "c.", "d.", "e.", "f."};
static const gchar* CANDIDATE_AREA_PREV_PAGE_ICONS[2] = {"go-previous", "go-up"};
static const gchar* CANDIDATE_AREA_NEXT_PAGE_ICONS[2] = {"go-next", "go-down"};

static void __lambda12_ (CandidateArea* self) {
	candidate_area_get_selected_color (self);
}


static void ___lambda12__gtk_style_context_changed (GtkStyleContext* _sender, gpointer self) {
	__lambda12_ ((CandidateArea*) self);
}


CandidateArea* candidate_area_construct (GType object_type, gboolean vertical) {
	CandidateArea * self = NULL;
	gboolean _tmp0_ = FALSE;
	GtkWidgetPath* widget_path = NULL;
	GtkWidgetPath* _tmp1_ = NULL;
	GtkStyleContext* _tmp2_ = NULL;
	GtkStyleContext* _tmp3_ = NULL;
	GtkStyleContext* _tmp4_ = NULL;
	GtkStyleContext* _tmp5_ = NULL;
	GtkStyleContext* _tmp6_ = NULL;
	GtkStyleContext* _tmp7_ = NULL;
	self = (CandidateArea*) g_object_new (object_type, NULL);
	_tmp0_ = vertical;
	candidate_area_set_vertical (self, _tmp0_, TRUE);
	_tmp1_ = gtk_widget_path_new ();
	widget_path = _tmp1_;
	gtk_widget_path_append_type (widget_path, gtk_text_view_get_type ());
	_tmp2_ = gtk_style_context_new ();
	_g_object_unref0 (self->priv->m_style_context);
	self->priv->m_style_context = _tmp2_;
	_tmp3_ = self->priv->m_style_context;
	gtk_style_context_set_path (_tmp3_, widget_path);
	_tmp4_ = self->priv->m_style_context;
	gtk_style_context_add_class (_tmp4_, GTK_STYLE_CLASS_VIEW);
	_tmp5_ = self->priv->m_style_context;
	_tmp6_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_set_parent (_tmp5_, _tmp6_);
	candidate_area_get_selected_color (self);
	_tmp7_ = self->priv->m_style_context;
	g_signal_connect_object (_tmp7_, "changed", (GCallback) ___lambda12__gtk_style_context_changed, self, 0);
	_gtk_widget_path_unref0 (widget_path);
	return self;
}


CandidateArea* candidate_area_new (gboolean vertical) {
	return candidate_area_construct (TYPE_CANDIDATE_AREA, vertical);
}


gboolean candidate_area_candidate_scrolled (CandidateArea* self, GdkEventScroll* event) {
	gboolean result = FALSE;
	GdkEventScroll* _tmp0_ = NULL;
	GdkScrollDirection _tmp1_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = event;
	_tmp1_ = _tmp0_->direction;
	switch (_tmp1_) {
		case GDK_SCROLL_UP:
		{
			g_signal_emit_by_name (self, "cursor-up");
			break;
		}
		case GDK_SCROLL_DOWN:
		{
			g_signal_emit_by_name (self, "cursor-down");
			break;
		}
		default:
		break;
	}
	result = TRUE;
	return result;
}


gboolean candidate_area_get_vertical (CandidateArea* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->m_vertical;
	result = _tmp0_;
	return result;
}


void candidate_area_set_vertical (CandidateArea* self, gboolean vertical, gboolean force) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp4_ = FALSE;
	GtkOrientation _tmp5_ = 0;
	gboolean _tmp6_ = FALSE;
	IBusText** _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
	g_return_if_fail (self != NULL);
	_tmp1_ = force;
	if (!_tmp1_) {
		gboolean _tmp2_ = FALSE;
		gboolean _tmp3_ = FALSE;
		_tmp2_ = self->priv->m_vertical;
		_tmp3_ = vertical;
		_tmp0_ = _tmp2_ == _tmp3_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		return;
	}
	_tmp4_ = vertical;
	self->priv->m_vertical = _tmp4_;
	_tmp6_ = vertical;
	if (_tmp6_) {
		_tmp5_ = GTK_ORIENTATION_VERTICAL;
	} else {
		_tmp5_ = GTK_ORIENTATION_HORIZONTAL;
	}
	gtk_orientable_set_orientation ((GtkOrientable*) self, _tmp5_);
	candidate_area_recreate_ui (self);
	_tmp7_ = self->priv->m_ibus_candidates;
	_tmp7__length1 = self->priv->m_ibus_candidates_length1;
	if (_tmp7__length1 > 0) {
		IBusText** _tmp8_ = NULL;
		gint _tmp8__length1 = 0;
		IBusText** _tmp9_ = NULL;
		gint _tmp9__length1 = 0;
		guint _tmp10_ = 0U;
		gboolean _tmp11_ = FALSE;
		_tmp8_ = self->priv->m_ibus_candidates;
		_tmp8__length1 = self->priv->m_ibus_candidates_length1;
		self->priv->m_ibus_candidates = NULL;
		self->priv->m_ibus_candidates_length1 = 0;
		_tmp9_ = _tmp8_;
		_tmp9__length1 = _tmp8__length1;
		_tmp10_ = self->priv->m_focus_candidate;
		_tmp11_ = self->priv->m_show_cursor;
		candidate_area_set_candidates (self, _tmp9_, _tmp8__length1, _tmp10_, _tmp11_);
		_tmp9_ = (_vala_array_free (_tmp9_, _tmp9__length1, (GDestroyNotify) g_object_unref), NULL);
		gtk_widget_show_all ((GtkWidget*) self);
	}
}


void candidate_area_set_labels (CandidateArea* self, IBusText** labels, int labels_length1) {
	gint i = 0;
	g_return_if_fail (self != NULL);
	{
		gboolean _tmp0_ = FALSE;
		i = 0;
		_tmp0_ = TRUE;
		while (TRUE) {
			gint _tmp2_ = 0;
			IBusText** _tmp3_ = NULL;
			gint _tmp3__length1 = 0;
			gint _tmp4_ = 0;
			GtkLabel** _tmp5_ = NULL;
			gint _tmp5__length1 = 0;
			gint _tmp6_ = 0;
			GtkLabel* _tmp7_ = NULL;
			IBusText** _tmp8_ = NULL;
			gint _tmp8__length1 = 0;
			gint _tmp9_ = 0;
			IBusText* _tmp10_ = NULL;
			const gchar* _tmp11_ = NULL;
			if (!_tmp0_) {
				gint _tmp1_ = 0;
				_tmp1_ = i;
				i = _tmp1_ + 1;
			}
			_tmp0_ = FALSE;
			_tmp2_ = i;
			_tmp3_ = labels;
			_tmp3__length1 = labels_length1;
			_tmp4_ = MIN (16, _tmp3__length1);
			if (!(_tmp2_ < _tmp4_)) {
				break;
			}
			_tmp5_ = self->priv->m_labels;
			_tmp5__length1 = self->priv->m_labels_length1;
			_tmp6_ = i;
			_tmp7_ = _tmp5_[_tmp6_];
			_tmp8_ = labels;
			_tmp8__length1 = labels_length1;
			_tmp9_ = i;
			_tmp10_ = _tmp8_[_tmp9_];
			_tmp11_ = ibus_text_get_text (_tmp10_);
			gtk_label_set_text (_tmp7_, _tmp11_);
		}
	}
	{
		gboolean _tmp12_ = FALSE;
		_tmp12_ = TRUE;
		while (TRUE) {
			gint _tmp14_ = 0;
			GtkLabel** _tmp15_ = NULL;
			gint _tmp15__length1 = 0;
			gint _tmp16_ = 0;
			GtkLabel* _tmp17_ = NULL;
			gint _tmp18_ = 0;
			const gchar* _tmp19_ = NULL;
			if (!_tmp12_) {
				gint _tmp13_ = 0;
				_tmp13_ = i;
				i = _tmp13_ + 1;
			}
			_tmp12_ = FALSE;
			_tmp14_ = i;
			if (!(_tmp14_ < 16)) {
				break;
			}
			_tmp15_ = self->priv->m_labels;
			_tmp15__length1 = self->priv->m_labels_length1;
			_tmp16_ = i;
			_tmp17_ = _tmp15_[_tmp16_];
			_tmp18_ = i;
			_tmp19_ = CANDIDATE_AREA_LABELS[_tmp18_];
			gtk_label_set_text (_tmp17_, _tmp19_);
		}
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static IBusText** _vala_array_dup1 (IBusText** self, int length) {
	IBusText** result;
	int i;
	result = g_new0 (IBusText*, length + 1);
	for (i = 0; i < length; i++) {
		IBusText* _tmp0_ = NULL;
		_tmp0_ = _g_object_ref0 (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


void candidate_area_set_candidates (CandidateArea* self, IBusText** candidates, int candidates_length1, guint focus_candidate, gboolean show_cursor) {
	IBusText** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	IBusText** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	guint _tmp2_ = 0U;
	gboolean _tmp3_ = FALSE;
	IBusText** _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = candidates;
	_tmp0__length1 = candidates_length1;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup1 (_tmp0_, _tmp0__length1) : ((gpointer) _tmp0_);
	_tmp1__length1 = _tmp0__length1;
	self->priv->m_ibus_candidates = (_vala_array_free (self->priv->m_ibus_candidates, self->priv->m_ibus_candidates_length1, (GDestroyNotify) g_object_unref), NULL);
	self->priv->m_ibus_candidates = _tmp1_;
	self->priv->m_ibus_candidates_length1 = _tmp1__length1;
	self->priv->_m_ibus_candidates_size_ = self->priv->m_ibus_candidates_length1;
	_tmp2_ = focus_candidate;
	self->priv->m_focus_candidate = _tmp2_;
	_tmp3_ = show_cursor;
	self->priv->m_show_cursor = _tmp3_;
	_tmp4_ = candidates;
	_tmp4__length1 = candidates_length1;
	_vala_assert (_tmp4__length1 < 16, "candidates.length < 16");
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp5_ = FALSE;
			_tmp5_ = TRUE;
			while (TRUE) {
				gint _tmp7_ = 0;
				GtkLabel* label = NULL;
				GtkLabel** _tmp8_ = NULL;
				gint _tmp8__length1 = 0;
				gint _tmp9_ = 0;
				GtkLabel* _tmp10_ = NULL;
				GtkLabel* _tmp11_ = NULL;
				gboolean visible = FALSE;
				gint _tmp12_ = 0;
				IBusText** _tmp13_ = NULL;
				gint _tmp13__length1 = 0;
				gboolean _tmp67_ = FALSE;
				if (!_tmp5_) {
					gint _tmp6_ = 0;
					_tmp6_ = i;
					i = _tmp6_ + 1;
				}
				_tmp5_ = FALSE;
				_tmp7_ = i;
				if (!(_tmp7_ < 16)) {
					break;
				}
				_tmp8_ = self->priv->m_candidates;
				_tmp8__length1 = self->priv->m_candidates_length1;
				_tmp9_ = i;
				_tmp10_ = _tmp8_[_tmp9_];
				_tmp11_ = _g_object_ref0 (_tmp10_);
				label = _tmp11_;
				visible = FALSE;
				_tmp12_ = i;
				_tmp13_ = candidates;
				_tmp13__length1 = candidates_length1;
				if (_tmp12_ < _tmp13__length1) {
					PangoAttrList* attrs = NULL;
					IBusText** _tmp14_ = NULL;
					gint _tmp14__length1 = 0;
					gint _tmp15_ = 0;
					IBusText* _tmp16_ = NULL;
					PangoAttrList* _tmp17_ = NULL;
					gboolean _tmp18_ = FALSE;
					gint _tmp19_ = 0;
					guint _tmp20_ = 0U;
					GtkLabel* _tmp56_ = NULL;
					IBusText** _tmp57_ = NULL;
					gint _tmp57__length1 = 0;
					gint _tmp58_ = 0;
					IBusText* _tmp59_ = NULL;
					const gchar* _tmp60_ = NULL;
					GtkLabel* _tmp61_ = NULL;
					PangoAttrList* _tmp62_ = NULL;
					_tmp14_ = candidates;
					_tmp14__length1 = candidates_length1;
					_tmp15_ = i;
					_tmp16_ = _tmp14_[_tmp15_];
					_tmp17_ = get_pango_attr_list_from_ibus_text (_tmp16_);
					attrs = _tmp17_;
					_tmp19_ = i;
					_tmp20_ = focus_candidate;
					if (((guint) _tmp19_) == _tmp20_) {
						gboolean _tmp21_ = FALSE;
						_tmp21_ = show_cursor;
						_tmp18_ = _tmp21_;
					} else {
						_tmp18_ = FALSE;
					}
					if (_tmp18_) {
						PangoAttribute* pango_attr = NULL;
						GdkRGBA* _tmp22_ = NULL;
						gdouble _tmp23_ = 0.0;
						GdkRGBA* _tmp24_ = NULL;
						gdouble _tmp25_ = 0.0;
						GdkRGBA* _tmp26_ = NULL;
						gdouble _tmp27_ = 0.0;
						PangoAttribute* _tmp28_ = NULL;
						PangoAttribute* _tmp29_ = NULL;
						PangoAttribute* _tmp30_ = NULL;
						IBusText** _tmp31_ = NULL;
						gint _tmp31__length1 = 0;
						gint _tmp32_ = 0;
						IBusText* _tmp33_ = NULL;
						const gchar* _tmp34_ = NULL;
						gint _tmp35_ = 0;
						gint _tmp36_ = 0;
						PangoAttrList* _tmp37_ = NULL;
						PangoAttribute* _tmp38_ = NULL;
						GdkRGBA* _tmp39_ = NULL;
						gdouble _tmp40_ = 0.0;
						GdkRGBA* _tmp41_ = NULL;
						gdouble _tmp42_ = 0.0;
						GdkRGBA* _tmp43_ = NULL;
						gdouble _tmp44_ = 0.0;
						PangoAttribute* _tmp45_ = NULL;
						PangoAttribute* _tmp46_ = NULL;
						PangoAttribute* _tmp47_ = NULL;
						IBusText** _tmp48_ = NULL;
						gint _tmp48__length1 = 0;
						gint _tmp49_ = 0;
						IBusText* _tmp50_ = NULL;
						const gchar* _tmp51_ = NULL;
						gint _tmp52_ = 0;
						gint _tmp53_ = 0;
						PangoAttrList* _tmp54_ = NULL;
						PangoAttribute* _tmp55_ = NULL;
						_tmp22_ = self->priv->m_selected_fg_color;
						_tmp23_ = (*_tmp22_).red;
						_tmp24_ = self->priv->m_selected_fg_color;
						_tmp25_ = (*_tmp24_).green;
						_tmp26_ = self->priv->m_selected_fg_color;
						_tmp27_ = (*_tmp26_).blue;
						_tmp28_ = pango_attr_foreground_new ((guint16) (_tmp23_ * G_MAXUINT16), (guint16) (_tmp25_ * G_MAXUINT16), (guint16) (_tmp27_ * G_MAXUINT16));
						pango_attr = _tmp28_;
						_tmp29_ = pango_attr;
						_tmp29_->start_index = (guint) 0;
						_tmp30_ = pango_attr;
						_tmp31_ = candidates;
						_tmp31__length1 = candidates_length1;
						_tmp32_ = i;
						_tmp33_ = _tmp31_[_tmp32_];
						_tmp34_ = ibus_text_get_text (_tmp33_);
						_tmp35_ = strlen (_tmp34_);
						_tmp36_ = _tmp35_;
						_tmp30_->end_index = (guint) _tmp36_;
						_tmp37_ = attrs;
						_tmp38_ = pango_attr;
						pango_attr = NULL;
						pango_attr_list_insert (_tmp37_, _tmp38_);
						_tmp39_ = self->priv->m_selected_bg_color;
						_tmp40_ = (*_tmp39_).red;
						_tmp41_ = self->priv->m_selected_bg_color;
						_tmp42_ = (*_tmp41_).green;
						_tmp43_ = self->priv->m_selected_bg_color;
						_tmp44_ = (*_tmp43_).blue;
						_tmp45_ = pango_attr_background_new ((guint16) (_tmp40_ * G_MAXUINT16), (guint16) (_tmp42_ * G_MAXUINT16), (guint16) (_tmp44_ * G_MAXUINT16));
						_pango_attribute_destroy0 (pango_attr);
						pango_attr = _tmp45_;
						_tmp46_ = pango_attr;
						_tmp46_->start_index = (guint) 0;
						_tmp47_ = pango_attr;
						_tmp48_ = candidates;
						_tmp48__length1 = candidates_length1;
						_tmp49_ = i;
						_tmp50_ = _tmp48_[_tmp49_];
						_tmp51_ = ibus_text_get_text (_tmp50_);
						_tmp52_ = strlen (_tmp51_);
						_tmp53_ = _tmp52_;
						_tmp47_->end_index = (guint) _tmp53_;
						_tmp54_ = attrs;
						_tmp55_ = pango_attr;
						pango_attr = NULL;
						pango_attr_list_insert (_tmp54_, _tmp55_);
						_pango_attribute_destroy0 (pango_attr);
					}
					_tmp56_ = label;
					_tmp57_ = candidates;
					_tmp57__length1 = candidates_length1;
					_tmp58_ = i;
					_tmp59_ = _tmp57_[_tmp58_];
					_tmp60_ = ibus_text_get_text (_tmp59_);
					gtk_label_set_text (_tmp56_, _tmp60_);
					_tmp61_ = label;
					_tmp62_ = attrs;
					gtk_label_set_attributes (_tmp61_, _tmp62_);
					visible = TRUE;
					_pango_attr_list_unref0 (attrs);
				} else {
					GtkLabel* _tmp63_ = NULL;
					GtkLabel* _tmp64_ = NULL;
					PangoAttrList* _tmp65_ = NULL;
					PangoAttrList* _tmp66_ = NULL;
					_tmp63_ = label;
					gtk_label_set_text (_tmp63_, "");
					_tmp64_ = label;
					_tmp65_ = pango_attr_list_new ();
					_tmp66_ = _tmp65_;
					gtk_label_set_attributes (_tmp64_, _tmp66_);
					_pango_attr_list_unref0 (_tmp66_);
				}
				_tmp67_ = self->priv->m_vertical;
				if (_tmp67_) {
					GtkWidget** _tmp68_ = NULL;
					gint _tmp68__length1 = 0;
					gint _tmp69_ = 0;
					GtkWidget* _tmp70_ = NULL;
					gboolean _tmp71_ = FALSE;
					GtkWidget** _tmp72_ = NULL;
					gint _tmp72__length1 = 0;
					gint _tmp73_ = 0;
					GtkWidget* _tmp74_ = NULL;
					gboolean _tmp75_ = FALSE;
					_tmp68_ = self->priv->m_widgets;
					_tmp68__length1 = self->priv->m_widgets_length1;
					_tmp69_ = i;
					_tmp70_ = _tmp68_[_tmp69_ * 2];
					_tmp71_ = visible;
					gtk_widget_set_visible (_tmp70_, _tmp71_);
					_tmp72_ = self->priv->m_widgets;
					_tmp72__length1 = self->priv->m_widgets_length1;
					_tmp73_ = i;
					_tmp74_ = _tmp72_[(_tmp73_ * 2) + 1];
					_tmp75_ = visible;
					gtk_widget_set_visible (_tmp74_, _tmp75_);
				} else {
					GtkWidget** _tmp76_ = NULL;
					gint _tmp76__length1 = 0;
					gint _tmp77_ = 0;
					GtkWidget* _tmp78_ = NULL;
					gboolean _tmp79_ = FALSE;
					_tmp76_ = self->priv->m_widgets;
					_tmp76__length1 = self->priv->m_widgets_length1;
					_tmp77_ = i;
					_tmp78_ = _tmp76_[_tmp77_];
					_tmp79_ = visible;
					gtk_widget_set_visible (_tmp78_, _tmp79_);
				}
				_g_object_unref0 (label);
			}
		}
	}
}


static void candidate_area_get_selected_color (CandidateArea* self) {
	GdkRGBA* _tmp0_ = NULL;
	GtkStyleContext* _tmp1_ = NULL;
	gchar* bg_prop = NULL;
	gchar* _tmp2_ = NULL;
	GdkRGBA* normal_color = NULL;
	GdkRGBA* _tmp3_ = NULL;
	GtkStyleContext* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	GtkStyleContext* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp10_ = FALSE;
	GdkRGBA* _tmp11_ = NULL;
	gdouble _tmp12_ = 0.0;
	GdkRGBA* _tmp13_ = NULL;
	gdouble _tmp14_ = 0.0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_selected_fg_color;
	if (_tmp0_ != NULL) {
		gdk_rgba_free (self->priv->m_selected_fg_color);
		self->priv->m_selected_fg_color = NULL;
	}
	_tmp1_ = self->priv->m_style_context;
	gtk_style_context_get (_tmp1_, GTK_STATE_FLAG_SELECTED, "color", &self->priv->m_selected_fg_color, NULL);
	_tmp2_ = g_strdup ("background-color");
	bg_prop = _tmp2_;
	normal_color = NULL;
	_tmp3_ = self->priv->m_selected_bg_color;
	if (_tmp3_ != NULL) {
		gdk_rgba_free (self->priv->m_selected_bg_color);
		self->priv->m_selected_bg_color = NULL;
	}
	_tmp4_ = self->priv->m_style_context;
	_tmp5_ = bg_prop;
	gtk_style_context_get (_tmp4_, GTK_STATE_FLAG_NORMAL, _tmp5_, &normal_color, NULL);
	_tmp6_ = self->priv->m_style_context;
	_tmp7_ = bg_prop;
	gtk_style_context_get (_tmp6_, GTK_STATE_FLAG_SELECTED, _tmp7_, &self->priv->m_selected_bg_color, NULL);
	_tmp11_ = normal_color;
	_tmp12_ = (*_tmp11_).red;
	_tmp13_ = self->priv->m_selected_bg_color;
	_tmp14_ = (*_tmp13_).red;
	if (_tmp12_ == _tmp14_) {
		GdkRGBA* _tmp15_ = NULL;
		gdouble _tmp16_ = 0.0;
		GdkRGBA* _tmp17_ = NULL;
		gdouble _tmp18_ = 0.0;
		_tmp15_ = normal_color;
		_tmp16_ = (*_tmp15_).green;
		_tmp17_ = self->priv->m_selected_bg_color;
		_tmp18_ = (*_tmp17_).green;
		_tmp10_ = _tmp16_ == _tmp18_;
	} else {
		_tmp10_ = FALSE;
	}
	if (_tmp10_) {
		GdkRGBA* _tmp19_ = NULL;
		gdouble _tmp20_ = 0.0;
		GdkRGBA* _tmp21_ = NULL;
		gdouble _tmp22_ = 0.0;
		_tmp19_ = normal_color;
		_tmp20_ = (*_tmp19_).blue;
		_tmp21_ = self->priv->m_selected_bg_color;
		_tmp22_ = (*_tmp21_).blue;
		_tmp9_ = _tmp20_ == _tmp22_;
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		GdkRGBA* _tmp23_ = NULL;
		gdouble _tmp24_ = 0.0;
		GdkRGBA* _tmp25_ = NULL;
		gdouble _tmp26_ = 0.0;
		_tmp23_ = normal_color;
		_tmp24_ = (*_tmp23_).alpha;
		_tmp25_ = self->priv->m_selected_bg_color;
		_tmp26_ = (*_tmp25_).alpha;
		_tmp8_ = _tmp24_ == _tmp26_;
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		gchar* _tmp27_ = NULL;
		GtkStyleContext* _tmp28_ = NULL;
		const gchar* _tmp29_ = NULL;
		gdk_rgba_free (self->priv->m_selected_bg_color);
		self->priv->m_selected_bg_color = NULL;
		_tmp27_ = g_strdup ("-gtk-secondary-caret-color");
		_g_free0 (bg_prop);
		bg_prop = _tmp27_;
		_tmp28_ = self->priv->m_style_context;
		_tmp29_ = bg_prop;
		gtk_style_context_get (_tmp28_, GTK_STATE_FLAG_SELECTED, _tmp29_, &self->priv->m_selected_bg_color, NULL);
	}
	gdk_rgba_free (normal_color);
	_g_free0 (bg_prop);
}


static void __lambda7_ (CandidateArea* self, GtkButton* b) {
	g_return_if_fail (b != NULL);
	g_signal_emit_by_name (self, "page-up");
}


static void ___lambda7__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__lambda7_ ((CandidateArea*) self, _sender);
}


static void __lambda8_ (CandidateArea* self, GtkButton* b) {
	g_return_if_fail (b != NULL);
	g_signal_emit_by_name (self, "page-down");
}


static void ___lambda8__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__lambda8_ ((CandidateArea*) self, _sender);
}


static gboolean _candidate_area_candidate_scrolled_gtk_widget_scroll_event (GtkWidget* _sender, GdkEventScroll* event, gpointer self) {
	gboolean result;
	result = candidate_area_candidate_scrolled ((CandidateArea*) self, event);
	return result;
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		CandidateArea* self;
		self = _data1_->self;
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}


static void block2_data_unref (void * _userdata_) {
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		CandidateArea* self;
		self = _data2_->_data1_->self;
		block1_data_unref (_data2_->_data1_);
		_data2_->_data1_ = NULL;
		g_slice_free (Block2Data, _data2_);
	}
}


static void _vala_array_add1 (GtkLabel*** array, int* length, int* size, GtkLabel* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GtkLabel*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add2 (GtkLabel*** array, int* length, int* size, GtkLabel* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GtkLabel*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static gboolean ______lambda9_ (Block2Data* _data2_, GtkWidget* w, GdkEventButton* e) {
	Block1Data* _data1_;
	CandidateArea* self;
	gboolean result = FALSE;
	gint _tmp0_ = 0;
	GdkEventButton* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	GdkEventButton* _tmp3_ = NULL;
	GdkModifierType _tmp4_ = 0;
	_data1_ = _data2_->_data1_;
	self = _data1_->self;
	g_return_val_if_fail (w != NULL, FALSE);
	g_return_val_if_fail (e != NULL, FALSE);
	_tmp0_ = _data1_->i;
	_tmp1_ = e;
	_tmp2_ = _tmp1_->button;
	_tmp3_ = e;
	_tmp4_ = _tmp3_->state;
	g_signal_emit_by_name (self, "candidate-clicked", (guint) _tmp0_, _tmp2_, (guint) _tmp4_);
	result = TRUE;
	return result;
}


static gboolean _______lambda9__gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = ______lambda9_ (self, _sender, event);
	return result;
}


static void _vala_array_add3 (GtkWidget*** array, int* length, int* size, GtkWidget* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GtkWidget*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static gboolean ______lambda10_ (Block2Data* _data2_, GtkWidget* w, GdkEventButton* e) {
	Block1Data* _data1_;
	CandidateArea* self;
	gboolean result = FALSE;
	gint _tmp0_ = 0;
	GdkEventButton* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	GdkEventButton* _tmp3_ = NULL;
	GdkModifierType _tmp4_ = 0;
	_data1_ = _data2_->_data1_;
	self = _data1_->self;
	g_return_val_if_fail (w != NULL, FALSE);
	g_return_val_if_fail (e != NULL, FALSE);
	_tmp0_ = _data2_->index;
	_tmp1_ = e;
	_tmp2_ = _tmp1_->button;
	_tmp3_ = e;
	_tmp4_ = _tmp3_->state;
	g_signal_emit_by_name (self, "candidate-clicked", (guint) _tmp0_, _tmp2_, (guint) _tmp4_);
	result = TRUE;
	return result;
}


static gboolean _______lambda10__gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = ______lambda10_ (self, _sender, event);
	return result;
}


static void _vala_array_add4 (GtkWidget*** array, int* length, int* size, GtkWidget* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GtkWidget*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}


static void block3_data_unref (void * _userdata_) {
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		CandidateArea* self;
		self = _data3_->self;
		_g_object_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}


static void _vala_array_add5 (GtkLabel*** array, int* length, int* size, GtkLabel* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GtkLabel*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add6 (GtkLabel*** array, int* length, int* size, GtkLabel* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GtkLabel*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static gboolean ______lambda11_ (Block3Data* _data3_, GtkWidget* w, GdkEventButton* e) {
	CandidateArea* self;
	gboolean result = FALSE;
	gint _tmp0_ = 0;
	GdkEventButton* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	GdkEventButton* _tmp3_ = NULL;
	GdkModifierType _tmp4_ = 0;
	self = _data3_->self;
	g_return_val_if_fail (w != NULL, FALSE);
	g_return_val_if_fail (e != NULL, FALSE);
	_tmp0_ = _data3_->index;
	_tmp1_ = e;
	_tmp2_ = _tmp1_->button;
	_tmp3_ = e;
	_tmp4_ = _tmp3_->state;
	g_signal_emit_by_name (self, "candidate-clicked", (guint) _tmp0_, _tmp2_, (guint) _tmp4_);
	result = TRUE;
	return result;
}


static gboolean _______lambda11__gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = ______lambda11_ (self, _sender, event);
	return result;
}


static void _vala_array_add7 (GtkWidget*** array, int* length, int* size, GtkWidget* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GtkWidget*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void candidate_area_recreate_ui (CandidateArea* self) {
	GList* _tmp0_ = NULL;
	GtkButton* prev_button = NULL;
	GtkButton* _tmp3_ = NULL;
	GtkButton* _tmp4_ = NULL;
	GtkButton* _tmp5_ = NULL;
	GtkOrientation _tmp6_ = 0;
	GtkOrientation _tmp7_ = 0;
	const gchar* _tmp8_ = NULL;
	GtkImage* _tmp9_ = NULL;
	GtkImage* _tmp10_ = NULL;
	GtkButton* _tmp11_ = NULL;
	GtkButton* next_button = NULL;
	GtkButton* _tmp12_ = NULL;
	GtkButton* _tmp13_ = NULL;
	GtkButton* _tmp14_ = NULL;
	GtkOrientation _tmp15_ = 0;
	GtkOrientation _tmp16_ = 0;
	const gchar* _tmp17_ = NULL;
	GtkImage* _tmp18_ = NULL;
	GtkImage* _tmp19_ = NULL;
	GtkButton* _tmp20_ = NULL;
	gboolean _tmp21_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_container_get_children ((GtkContainer*) self);
	{
		GList* w_collection = NULL;
		GList* w_it = NULL;
		w_collection = _tmp0_;
		for (w_it = w_collection; w_it != NULL; w_it = w_it->next) {
			GtkWidget* _tmp1_ = NULL;
			GtkWidget* w = NULL;
			_tmp1_ = _g_object_ref0 ((GtkWidget*) w_it->data);
			w = _tmp1_;
			{
				GtkWidget* _tmp2_ = NULL;
				_tmp2_ = w;
				gtk_widget_destroy (_tmp2_);
				_g_object_unref0 (w);
			}
		}
		_g_list_free0 (w_collection);
	}
	_tmp3_ = (GtkButton*) gtk_button_new ();
	g_object_ref_sink (_tmp3_);
	prev_button = _tmp3_;
	_tmp4_ = prev_button;
	g_signal_connect_object (_tmp4_, "clicked", (GCallback) ___lambda7__gtk_button_clicked, self, 0);
	_tmp5_ = prev_button;
	_tmp6_ = gtk_orientable_get_orientation ((GtkOrientable*) self);
	_tmp7_ = _tmp6_;
	_tmp8_ = CANDIDATE_AREA_PREV_PAGE_ICONS[_tmp7_];
	_tmp9_ = (GtkImage*) gtk_image_new_from_icon_name (_tmp8_, GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp9_);
	_tmp10_ = _tmp9_;
	gtk_button_set_image (_tmp5_, (GtkWidget*) _tmp10_);
	_g_object_unref0 (_tmp10_);
	_tmp11_ = prev_button;
	gtk_button_set_relief (_tmp11_, GTK_RELIEF_NONE);
	_tmp12_ = (GtkButton*) gtk_button_new ();
	g_object_ref_sink (_tmp12_);
	next_button = _tmp12_;
	_tmp13_ = next_button;
	g_signal_connect_object (_tmp13_, "clicked", (GCallback) ___lambda8__gtk_button_clicked, self, 0);
	_tmp14_ = next_button;
	_tmp15_ = gtk_orientable_get_orientation ((GtkOrientable*) self);
	_tmp16_ = _tmp15_;
	_tmp17_ = CANDIDATE_AREA_NEXT_PAGE_ICONS[_tmp16_];
	_tmp18_ = (GtkImage*) gtk_image_new_from_icon_name (_tmp17_, GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp18_);
	_tmp19_ = _tmp18_;
	gtk_button_set_image (_tmp14_, (GtkWidget*) _tmp19_);
	_g_object_unref0 (_tmp19_);
	_tmp20_ = next_button;
	gtk_button_set_relief (_tmp20_, GTK_RELIEF_NONE);
	_tmp21_ = self->priv->m_vertical;
	if (_tmp21_) {
		GtkEventBox* container_ebox = NULL;
		GtkEventBox* _tmp22_ = NULL;
		GtkEventBox* _tmp23_ = NULL;
		GtkEventBox* _tmp24_ = NULL;
		GtkEventBox* _tmp25_ = NULL;
		GtkBox* vbox = NULL;
		GtkBox* _tmp26_ = NULL;
		GtkEventBox* _tmp27_ = NULL;
		GtkBox* _tmp28_ = NULL;
		GtkBox* candidates_hbox = NULL;
		GtkBox* _tmp29_ = NULL;
		GtkBox* _tmp30_ = NULL;
		GtkBox* _tmp31_ = NULL;
		GtkBox* labels_vbox = NULL;
		GtkBox* _tmp32_ = NULL;
		GtkBox* _tmp33_ = NULL;
		GtkBox* candidates_vbox = NULL;
		GtkBox* _tmp34_ = NULL;
		GtkBox* _tmp35_ = NULL;
		GtkBox* _tmp36_ = NULL;
		GtkBox* _tmp37_ = NULL;
		GtkBox* _tmp38_ = NULL;
		VSeparator* _tmp39_ = NULL;
		VSeparator* _tmp40_ = NULL;
		GtkBox* _tmp41_ = NULL;
		GtkBox* _tmp42_ = NULL;
		GtkBox* _tmp43_ = NULL;
		HSeparator* _tmp44_ = NULL;
		HSeparator* _tmp45_ = NULL;
		GtkBox* buttons_hbox = NULL;
		GtkBox* _tmp46_ = NULL;
		GtkLabel* state_label = NULL;
		GtkLabel* _tmp47_ = NULL;
		GtkLabel* _tmp48_ = NULL;
		GtkBox* _tmp49_ = NULL;
		GtkLabel* _tmp50_ = NULL;
		GtkBox* _tmp51_ = NULL;
		GtkButton* _tmp52_ = NULL;
		GtkBox* _tmp53_ = NULL;
		GtkButton* _tmp54_ = NULL;
		GtkBox* _tmp55_ = NULL;
		GtkBox* _tmp56_ = NULL;
		GtkLabel** _tmp57_ = NULL;
		GtkLabel** _tmp58_ = NULL;
		GtkWidget** _tmp59_ = NULL;
		_tmp22_ = (GtkEventBox*) gtk_event_box_new ();
		g_object_ref_sink (_tmp22_);
		container_ebox = _tmp22_;
		_tmp23_ = container_ebox;
		gtk_widget_add_events ((GtkWidget*) _tmp23_, (gint) GDK_SCROLL_MASK);
		_tmp24_ = container_ebox;
		g_signal_connect_object ((GtkWidget*) _tmp24_, "scroll-event", (GCallback) _candidate_area_candidate_scrolled_gtk_widget_scroll_event, self, 0);
		_tmp25_ = container_ebox;
		gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp25_);
		_tmp26_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
		g_object_ref_sink (_tmp26_);
		vbox = _tmp26_;
		_tmp27_ = container_ebox;
		_tmp28_ = vbox;
		gtk_container_add ((GtkContainer*) _tmp27_, (GtkWidget*) _tmp28_);
		_tmp29_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
		g_object_ref_sink (_tmp29_);
		candidates_hbox = _tmp29_;
		_tmp30_ = vbox;
		_tmp31_ = candidates_hbox;
		gtk_box_pack_start (_tmp30_, (GtkWidget*) _tmp31_, FALSE, FALSE, (guint) 0);
		_tmp32_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
		g_object_ref_sink (_tmp32_);
		labels_vbox = _tmp32_;
		_tmp33_ = labels_vbox;
		gtk_box_set_homogeneous (_tmp33_, TRUE);
		_tmp34_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
		g_object_ref_sink (_tmp34_);
		candidates_vbox = _tmp34_;
		_tmp35_ = candidates_vbox;
		gtk_box_set_homogeneous (_tmp35_, TRUE);
		_tmp36_ = candidates_hbox;
		_tmp37_ = labels_vbox;
		gtk_box_pack_start (_tmp36_, (GtkWidget*) _tmp37_, FALSE, FALSE, (guint) 4);
		_tmp38_ = candidates_hbox;
		_tmp39_ = vseparator_new ();
		g_object_ref_sink (_tmp39_);
		_tmp40_ = _tmp39_;
		gtk_box_pack_start (_tmp38_, (GtkWidget*) _tmp40_, FALSE, FALSE, (guint) 0);
		_g_object_unref0 (_tmp40_);
		_tmp41_ = candidates_hbox;
		_tmp42_ = candidates_vbox;
		gtk_box_pack_start (_tmp41_, (GtkWidget*) _tmp42_, TRUE, TRUE, (guint) 4);
		_tmp43_ = vbox;
		_tmp44_ = hseparator_new ();
		g_object_ref_sink (_tmp44_);
		_tmp45_ = _tmp44_;
		gtk_box_pack_start (_tmp43_, (GtkWidget*) _tmp45_, FALSE, FALSE, (guint) 0);
		_g_object_unref0 (_tmp45_);
		_tmp46_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
		g_object_ref_sink (_tmp46_);
		buttons_hbox = _tmp46_;
		_tmp47_ = (GtkLabel*) gtk_label_new (NULL);
		g_object_ref_sink (_tmp47_);
		state_label = _tmp47_;
		_tmp48_ = state_label;
		gtk_widget_set_size_request ((GtkWidget*) _tmp48_, 20, -1);
		_tmp49_ = buttons_hbox;
		_tmp50_ = state_label;
		gtk_box_pack_start (_tmp49_, (GtkWidget*) _tmp50_, TRUE, TRUE, (guint) 0);
		_tmp51_ = buttons_hbox;
		_tmp52_ = prev_button;
		gtk_box_pack_start (_tmp51_, (GtkWidget*) _tmp52_, FALSE, FALSE, (guint) 0);
		_tmp53_ = buttons_hbox;
		_tmp54_ = next_button;
		gtk_box_pack_start (_tmp53_, (GtkWidget*) _tmp54_, FALSE, FALSE, (guint) 0);
		_tmp55_ = vbox;
		_tmp56_ = buttons_hbox;
		gtk_box_pack_start (_tmp55_, (GtkWidget*) _tmp56_, FALSE, FALSE, (guint) 0);
		_tmp57_ = g_new0 (GtkLabel*, 0 + 1);
		self->priv->m_labels = (_vala_array_free (self->priv->m_labels, self->priv->m_labels_length1, (GDestroyNotify) g_object_unref), NULL);
		self->priv->m_labels = _tmp57_;
		self->priv->m_labels_length1 = 0;
		self->priv->_m_labels_size_ = self->priv->m_labels_length1;
		_tmp58_ = g_new0 (GtkLabel*, 0 + 1);
		self->priv->m_candidates = (_vala_array_free (self->priv->m_candidates, self->priv->m_candidates_length1, (GDestroyNotify) g_object_unref), NULL);
		self->priv->m_candidates = _tmp58_;
		self->priv->m_candidates_length1 = 0;
		self->priv->_m_candidates_size_ = self->priv->m_candidates_length1;
		_tmp59_ = g_new0 (GtkWidget*, 0 + 1);
		self->priv->m_widgets = (_vala_array_free (self->priv->m_widgets, self->priv->m_widgets_length1, (GDestroyNotify) g_object_unref), NULL);
		self->priv->m_widgets = _tmp59_;
		self->priv->m_widgets_length1 = 0;
		self->priv->_m_widgets_size_ = self->priv->m_widgets_length1;
		{
			Block1Data* _data1_;
			_data1_ = g_slice_new0 (Block1Data);
			_data1_->_ref_count_ = 1;
			_data1_->self = g_object_ref (self);
			_data1_->i = 0;
			{
				gboolean _tmp60_ = FALSE;
				_tmp60_ = TRUE;
				while (TRUE) {
					Block2Data* _data2_;
					gint _tmp62_ = 0;
					GtkLabel* label = NULL;
					gint _tmp63_ = 0;
					const gchar* _tmp64_ = NULL;
					GtkLabel* _tmp65_ = NULL;
					GtkLabel* _tmp66_ = NULL;
					GtkLabel* _tmp67_ = NULL;
					GtkLabel* _tmp68_ = NULL;
					GtkLabel** _tmp69_ = NULL;
					gint _tmp69__length1 = 0;
					GtkLabel* _tmp70_ = NULL;
					GtkLabel* _tmp71_ = NULL;
					GtkLabel* candidate = NULL;
					GtkLabel* _tmp72_ = NULL;
					GtkLabel* _tmp73_ = NULL;
					GtkLabel* _tmp74_ = NULL;
					GtkLabel* _tmp75_ = NULL;
					GtkLabel** _tmp76_ = NULL;
					gint _tmp76__length1 = 0;
					GtkLabel* _tmp77_ = NULL;
					GtkLabel* _tmp78_ = NULL;
					GtkLabel* _tmp79_ = NULL;
					GtkLabel* _tmp80_ = NULL;
					gint _tmp81_ = 0;
					GtkEventBox* label_ebox = NULL;
					GtkEventBox* _tmp82_ = NULL;
					GtkEventBox* _tmp83_ = NULL;
					GtkEventBox* _tmp84_ = NULL;
					GtkEventBox* _tmp85_ = NULL;
					GtkLabel* _tmp86_ = NULL;
					GtkBox* _tmp87_ = NULL;
					GtkEventBox* _tmp88_ = NULL;
					GtkWidget** _tmp89_ = NULL;
					gint _tmp89__length1 = 0;
					GtkEventBox* _tmp90_ = NULL;
					GtkWidget* _tmp91_ = NULL;
					GtkEventBox* candidate_ebox = NULL;
					GtkEventBox* _tmp92_ = NULL;
					GtkEventBox* _tmp93_ = NULL;
					GtkEventBox* _tmp94_ = NULL;
					GtkEventBox* _tmp95_ = NULL;
					GtkLabel* _tmp96_ = NULL;
					GtkBox* _tmp97_ = NULL;
					GtkEventBox* _tmp98_ = NULL;
					GtkWidget** _tmp99_ = NULL;
					gint _tmp99__length1 = 0;
					GtkEventBox* _tmp100_ = NULL;
					GtkWidget* _tmp101_ = NULL;
					_data2_ = g_slice_new0 (Block2Data);
					_data2_->_ref_count_ = 1;
					_data2_->_data1_ = block1_data_ref (_data1_);
					if (!_tmp60_) {
						gint _tmp61_ = 0;
						_tmp61_ = _data1_->i;
						_data1_->i = _tmp61_ + 1;
					}
					_tmp60_ = FALSE;
					_tmp62_ = _data1_->i;
					if (!(_tmp62_ < 16)) {
						block2_data_unref (_data2_);
						_data2_ = NULL;
						break;
					}
					_tmp63_ = _data1_->i;
					_tmp64_ = CANDIDATE_AREA_LABELS[_tmp63_];
					_tmp65_ = (GtkLabel*) gtk_label_new (_tmp64_);
					g_object_ref_sink (_tmp65_);
					label = _tmp65_;
					_tmp66_ = label;
					gtk_widget_set_halign ((GtkWidget*) _tmp66_, GTK_ALIGN_START);
					_tmp67_ = label;
					gtk_widget_set_valign ((GtkWidget*) _tmp67_, GTK_ALIGN_CENTER);
					_tmp68_ = label;
					gtk_widget_show ((GtkWidget*) _tmp68_);
					_tmp69_ = self->priv->m_labels;
					_tmp69__length1 = self->priv->m_labels_length1;
					_tmp70_ = label;
					_tmp71_ = _g_object_ref0 (_tmp70_);
					_vala_array_add1 (&self->priv->m_labels, &self->priv->m_labels_length1, &self->priv->_m_labels_size_, _tmp71_);
					_tmp72_ = (GtkLabel*) gtk_label_new ("test");
					g_object_ref_sink (_tmp72_);
					candidate = _tmp72_;
					_tmp73_ = candidate;
					gtk_widget_set_halign ((GtkWidget*) _tmp73_, GTK_ALIGN_START);
					_tmp74_ = candidate;
					gtk_widget_set_valign ((GtkWidget*) _tmp74_, GTK_ALIGN_CENTER);
					_tmp75_ = candidate;
					gtk_widget_show ((GtkWidget*) _tmp75_);
					_tmp76_ = self->priv->m_candidates;
					_tmp76__length1 = self->priv->m_candidates_length1;
					_tmp77_ = candidate;
					_tmp78_ = _g_object_ref0 (_tmp77_);
					_vala_array_add2 (&self->priv->m_candidates, &self->priv->m_candidates_length1, &self->priv->_m_candidates_size_, _tmp78_);
					_tmp79_ = label;
					gtk_misc_set_padding ((GtkMisc*) _tmp79_, 8, 0);
					_tmp80_ = candidate;
					gtk_misc_set_padding ((GtkMisc*) _tmp80_, 8, 0);
					_tmp81_ = _data1_->i;
					_data2_->index = _tmp81_;
					_tmp82_ = (GtkEventBox*) gtk_event_box_new ();
					g_object_ref_sink (_tmp82_);
					label_ebox = _tmp82_;
					_tmp83_ = label_ebox;
					gtk_widget_set_no_show_all ((GtkWidget*) _tmp83_, TRUE);
					_tmp84_ = label_ebox;
					g_signal_connect_data ((GtkWidget*) _tmp84_, "button-press-event", (GCallback) _______lambda9__gtk_widget_button_press_event, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
					_tmp85_ = label_ebox;
					_tmp86_ = label;
					gtk_container_add ((GtkContainer*) _tmp85_, (GtkWidget*) _tmp86_);
					_tmp87_ = labels_vbox;
					_tmp88_ = label_ebox;
					gtk_box_pack_start (_tmp87_, (GtkWidget*) _tmp88_, FALSE, FALSE, (guint) 2);
					_tmp89_ = self->priv->m_widgets;
					_tmp89__length1 = self->priv->m_widgets_length1;
					_tmp90_ = label_ebox;
					_tmp91_ = _g_object_ref0 ((GtkWidget*) _tmp90_);
					_vala_array_add3 (&self->priv->m_widgets, &self->priv->m_widgets_length1, &self->priv->_m_widgets_size_, _tmp91_);
					_tmp92_ = (GtkEventBox*) gtk_event_box_new ();
					g_object_ref_sink (_tmp92_);
					candidate_ebox = _tmp92_;
					_tmp93_ = candidate_ebox;
					gtk_widget_set_no_show_all ((GtkWidget*) _tmp93_, TRUE);
					_tmp94_ = candidate_ebox;
					g_signal_connect_data ((GtkWidget*) _tmp94_, "button-press-event", (GCallback) _______lambda10__gtk_widget_button_press_event, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
					_tmp95_ = candidate_ebox;
					_tmp96_ = candidate;
					gtk_container_add ((GtkContainer*) _tmp95_, (GtkWidget*) _tmp96_);
					_tmp97_ = candidates_vbox;
					_tmp98_ = candidate_ebox;
					gtk_box_pack_start (_tmp97_, (GtkWidget*) _tmp98_, FALSE, FALSE, (guint) 2);
					_tmp99_ = self->priv->m_widgets;
					_tmp99__length1 = self->priv->m_widgets_length1;
					_tmp100_ = candidate_ebox;
					_tmp101_ = _g_object_ref0 ((GtkWidget*) _tmp100_);
					_vala_array_add4 (&self->priv->m_widgets, &self->priv->m_widgets_length1, &self->priv->_m_widgets_size_, _tmp101_);
					_g_object_unref0 (candidate_ebox);
					_g_object_unref0 (label_ebox);
					_g_object_unref0 (candidate);
					_g_object_unref0 (label);
					block2_data_unref (_data2_);
					_data2_ = NULL;
				}
			}
			block1_data_unref (_data1_);
			_data1_ = NULL;
		}
		_g_object_unref0 (state_label);
		_g_object_unref0 (buttons_hbox);
		_g_object_unref0 (candidates_vbox);
		_g_object_unref0 (labels_vbox);
		_g_object_unref0 (candidates_hbox);
		_g_object_unref0 (vbox);
		_g_object_unref0 (container_ebox);
	} else {
		GtkEventBox* container_ebox = NULL;
		GtkEventBox* _tmp102_ = NULL;
		GtkEventBox* _tmp103_ = NULL;
		GtkEventBox* _tmp104_ = NULL;
		GtkEventBox* _tmp105_ = NULL;
		GtkBox* hbox = NULL;
		GtkBox* _tmp106_ = NULL;
		GtkEventBox* _tmp107_ = NULL;
		GtkBox* _tmp108_ = NULL;
		GtkLabel** _tmp109_ = NULL;
		GtkLabel** _tmp110_ = NULL;
		GtkWidget** _tmp111_ = NULL;
		GtkBox* _tmp148_ = NULL;
		VSeparator* _tmp149_ = NULL;
		VSeparator* _tmp150_ = NULL;
		GtkBox* _tmp151_ = NULL;
		GtkButton* _tmp152_ = NULL;
		GtkBox* _tmp153_ = NULL;
		GtkButton* _tmp154_ = NULL;
		_tmp102_ = (GtkEventBox*) gtk_event_box_new ();
		g_object_ref_sink (_tmp102_);
		container_ebox = _tmp102_;
		_tmp103_ = container_ebox;
		gtk_widget_add_events ((GtkWidget*) _tmp103_, (gint) GDK_SCROLL_MASK);
		_tmp104_ = container_ebox;
		g_signal_connect_object ((GtkWidget*) _tmp104_, "scroll-event", (GCallback) _candidate_area_candidate_scrolled_gtk_widget_scroll_event, self, 0);
		_tmp105_ = container_ebox;
		gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp105_);
		_tmp106_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
		g_object_ref_sink (_tmp106_);
		hbox = _tmp106_;
		_tmp107_ = container_ebox;
		_tmp108_ = hbox;
		gtk_container_add ((GtkContainer*) _tmp107_, (GtkWidget*) _tmp108_);
		_tmp109_ = g_new0 (GtkLabel*, 0 + 1);
		self->priv->m_labels = (_vala_array_free (self->priv->m_labels, self->priv->m_labels_length1, (GDestroyNotify) g_object_unref), NULL);
		self->priv->m_labels = _tmp109_;
		self->priv->m_labels_length1 = 0;
		self->priv->_m_labels_size_ = self->priv->m_labels_length1;
		_tmp110_ = g_new0 (GtkLabel*, 0 + 1);
		self->priv->m_candidates = (_vala_array_free (self->priv->m_candidates, self->priv->m_candidates_length1, (GDestroyNotify) g_object_unref), NULL);
		self->priv->m_candidates = _tmp110_;
		self->priv->m_candidates_length1 = 0;
		self->priv->_m_candidates_size_ = self->priv->m_candidates_length1;
		_tmp111_ = g_new0 (GtkWidget*, 0 + 1);
		self->priv->m_widgets = (_vala_array_free (self->priv->m_widgets, self->priv->m_widgets_length1, (GDestroyNotify) g_object_unref), NULL);
		self->priv->m_widgets = _tmp111_;
		self->priv->m_widgets_length1 = 0;
		self->priv->_m_widgets_size_ = self->priv->m_widgets_length1;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp112_ = FALSE;
				_tmp112_ = TRUE;
				while (TRUE) {
					Block3Data* _data3_;
					gint _tmp114_ = 0;
					GtkLabel* label = NULL;
					gint _tmp115_ = 0;
					const gchar* _tmp116_ = NULL;
					GtkLabel* _tmp117_ = NULL;
					GtkLabel* _tmp118_ = NULL;
					GtkLabel* _tmp119_ = NULL;
					GtkLabel* _tmp120_ = NULL;
					GtkLabel** _tmp121_ = NULL;
					gint _tmp121__length1 = 0;
					GtkLabel* _tmp122_ = NULL;
					GtkLabel* _tmp123_ = NULL;
					GtkLabel* candidate = NULL;
					GtkLabel* _tmp124_ = NULL;
					GtkLabel* _tmp125_ = NULL;
					GtkLabel* _tmp126_ = NULL;
					GtkLabel* _tmp127_ = NULL;
					GtkLabel** _tmp128_ = NULL;
					gint _tmp128__length1 = 0;
					GtkLabel* _tmp129_ = NULL;
					GtkLabel* _tmp130_ = NULL;
					GtkBox* candidate_hbox = NULL;
					GtkBox* _tmp131_ = NULL;
					GtkBox* _tmp132_ = NULL;
					GtkBox* _tmp133_ = NULL;
					GtkLabel* _tmp134_ = NULL;
					GtkBox* _tmp135_ = NULL;
					GtkLabel* _tmp136_ = NULL;
					gint _tmp137_ = 0;
					GtkEventBox* ebox = NULL;
					GtkEventBox* _tmp138_ = NULL;
					GtkEventBox* _tmp139_ = NULL;
					GtkEventBox* _tmp140_ = NULL;
					GtkEventBox* _tmp141_ = NULL;
					GtkBox* _tmp142_ = NULL;
					GtkBox* _tmp143_ = NULL;
					GtkEventBox* _tmp144_ = NULL;
					GtkWidget** _tmp145_ = NULL;
					gint _tmp145__length1 = 0;
					GtkEventBox* _tmp146_ = NULL;
					GtkWidget* _tmp147_ = NULL;
					_data3_ = g_slice_new0 (Block3Data);
					_data3_->_ref_count_ = 1;
					_data3_->self = g_object_ref (self);
					if (!_tmp112_) {
						gint _tmp113_ = 0;
						_tmp113_ = i;
						i = _tmp113_ + 1;
					}
					_tmp112_ = FALSE;
					_tmp114_ = i;
					if (!(_tmp114_ < 16)) {
						block3_data_unref (_data3_);
						_data3_ = NULL;
						break;
					}
					_tmp115_ = i;
					_tmp116_ = CANDIDATE_AREA_LABELS[_tmp115_];
					_tmp117_ = (GtkLabel*) gtk_label_new (_tmp116_);
					g_object_ref_sink (_tmp117_);
					label = _tmp117_;
					_tmp118_ = label;
					gtk_widget_set_halign ((GtkWidget*) _tmp118_, GTK_ALIGN_START);
					_tmp119_ = label;
					gtk_widget_set_valign ((GtkWidget*) _tmp119_, GTK_ALIGN_CENTER);
					_tmp120_ = label;
					gtk_widget_show ((GtkWidget*) _tmp120_);
					_tmp121_ = self->priv->m_labels;
					_tmp121__length1 = self->priv->m_labels_length1;
					_tmp122_ = label;
					_tmp123_ = _g_object_ref0 (_tmp122_);
					_vala_array_add5 (&self->priv->m_labels, &self->priv->m_labels_length1, &self->priv->_m_labels_size_, _tmp123_);
					_tmp124_ = (GtkLabel*) gtk_label_new ("test");
					g_object_ref_sink (_tmp124_);
					candidate = _tmp124_;
					_tmp125_ = candidate;
					gtk_widget_set_halign ((GtkWidget*) _tmp125_, GTK_ALIGN_START);
					_tmp126_ = candidate;
					gtk_widget_set_valign ((GtkWidget*) _tmp126_, GTK_ALIGN_CENTER);
					_tmp127_ = candidate;
					gtk_widget_show ((GtkWidget*) _tmp127_);
					_tmp128_ = self->priv->m_candidates;
					_tmp128__length1 = self->priv->m_candidates_length1;
					_tmp129_ = candidate;
					_tmp130_ = _g_object_ref0 (_tmp129_);
					_vala_array_add6 (&self->priv->m_candidates, &self->priv->m_candidates_length1, &self->priv->_m_candidates_size_, _tmp130_);
					_tmp131_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
					g_object_ref_sink (_tmp131_);
					candidate_hbox = _tmp131_;
					_tmp132_ = candidate_hbox;
					gtk_widget_show ((GtkWidget*) _tmp132_);
					_tmp133_ = candidate_hbox;
					_tmp134_ = label;
					gtk_box_pack_start (_tmp133_, (GtkWidget*) _tmp134_, FALSE, FALSE, (guint) 2);
					_tmp135_ = candidate_hbox;
					_tmp136_ = candidate;
					gtk_box_pack_start (_tmp135_, (GtkWidget*) _tmp136_, FALSE, FALSE, (guint) 2);
					_tmp137_ = i;
					_data3_->index = _tmp137_;
					_tmp138_ = (GtkEventBox*) gtk_event_box_new ();
					g_object_ref_sink (_tmp138_);
					ebox = _tmp138_;
					_tmp139_ = ebox;
					gtk_widget_set_no_show_all ((GtkWidget*) _tmp139_, TRUE);
					_tmp140_ = ebox;
					g_signal_connect_data ((GtkWidget*) _tmp140_, "button-press-event", (GCallback) _______lambda11__gtk_widget_button_press_event, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
					_tmp141_ = ebox;
					_tmp142_ = candidate_hbox;
					gtk_container_add ((GtkContainer*) _tmp141_, (GtkWidget*) _tmp142_);
					_tmp143_ = hbox;
					_tmp144_ = ebox;
					gtk_box_pack_start (_tmp143_, (GtkWidget*) _tmp144_, FALSE, FALSE, (guint) 4);
					_tmp145_ = self->priv->m_widgets;
					_tmp145__length1 = self->priv->m_widgets_length1;
					_tmp146_ = ebox;
					_tmp147_ = _g_object_ref0 ((GtkWidget*) _tmp146_);
					_vala_array_add7 (&self->priv->m_widgets, &self->priv->m_widgets_length1, &self->priv->_m_widgets_size_, _tmp147_);
					_g_object_unref0 (ebox);
					_g_object_unref0 (candidate_hbox);
					_g_object_unref0 (candidate);
					_g_object_unref0 (label);
					block3_data_unref (_data3_);
					_data3_ = NULL;
				}
			}
		}
		_tmp148_ = hbox;
		_tmp149_ = vseparator_new ();
		g_object_ref_sink (_tmp149_);
		_tmp150_ = _tmp149_;
		gtk_box_pack_start (_tmp148_, (GtkWidget*) _tmp150_, FALSE, FALSE, (guint) 0);
		_g_object_unref0 (_tmp150_);
		_tmp151_ = hbox;
		_tmp152_ = prev_button;
		gtk_box_pack_start (_tmp151_, (GtkWidget*) _tmp152_, FALSE, FALSE, (guint) 0);
		_tmp153_ = hbox;
		_tmp154_ = next_button;
		gtk_box_pack_start (_tmp153_, (GtkWidget*) _tmp154_, FALSE, FALSE, (guint) 0);
		_g_object_unref0 (hbox);
		_g_object_unref0 (container_ebox);
	}
	_g_object_unref0 (next_button);
	_g_object_unref0 (prev_button);
}


static void g_cclosure_user_marshal_VOID__UINT_UINT_UINT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__UINT_UINT_UINT) (gpointer data1, guint arg_1, guint arg_2, guint arg_3, gpointer data2);
	register GMarshalFunc_VOID__UINT_UINT_UINT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 4);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__UINT_UINT_UINT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_uint (param_values + 1), g_value_get_uint (param_values + 2), g_value_get_uint (param_values + 3), data2);
}


static void candidate_area_class_init (CandidateAreaClass * klass) {
	candidate_area_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (CandidateAreaPrivate));
	G_OBJECT_CLASS (klass)->finalize = candidate_area_finalize;
	g_signal_new ("candidate_clicked", TYPE_CANDIDATE_AREA, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__UINT_UINT_UINT, G_TYPE_NONE, 3, G_TYPE_UINT, G_TYPE_UINT, G_TYPE_UINT);
	g_signal_new ("page_up", TYPE_CANDIDATE_AREA, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("page_down", TYPE_CANDIDATE_AREA, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("cursor_up", TYPE_CANDIDATE_AREA, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("cursor_down", TYPE_CANDIDATE_AREA, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void candidate_area_instance_init (CandidateArea * self) {
	self->priv = CANDIDATE_AREA_GET_PRIVATE (self);
	self->priv->m_selected_fg_color = NULL;
	self->priv->m_selected_bg_color = NULL;
}


static void candidate_area_finalize (GObject* obj) {
	CandidateArea * self;
	GdkRGBA* _tmp0_ = NULL;
	GdkRGBA* _tmp1_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CANDIDATE_AREA, CandidateArea);
	_tmp0_ = self->priv->m_selected_bg_color;
	if (_tmp0_ != NULL) {
		gdk_rgba_free (self->priv->m_selected_bg_color);
		self->priv->m_selected_bg_color = NULL;
	}
	_tmp1_ = self->priv->m_selected_bg_color;
	if (_tmp1_ != NULL) {
		gdk_rgba_free (self->priv->m_selected_bg_color);
		self->priv->m_selected_bg_color = NULL;
	}
	self->priv->m_labels = (_vala_array_free (self->priv->m_labels, self->priv->m_labels_length1, (GDestroyNotify) g_object_unref), NULL);
	self->priv->m_candidates = (_vala_array_free (self->priv->m_candidates, self->priv->m_candidates_length1, (GDestroyNotify) g_object_unref), NULL);
	self->priv->m_widgets = (_vala_array_free (self->priv->m_widgets, self->priv->m_widgets_length1, (GDestroyNotify) g_object_unref), NULL);
	self->priv->m_ibus_candidates = (_vala_array_free (self->priv->m_ibus_candidates, self->priv->m_ibus_candidates_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (self->priv->m_style_context);
	G_OBJECT_CLASS (candidate_area_parent_class)->finalize (obj);
}


GType candidate_area_get_type (void) {
	static volatile gsize candidate_area_type_id__volatile = 0;
	if (g_once_init_enter (&candidate_area_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CandidateAreaClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) candidate_area_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CandidateArea), 0, (GInstanceInitFunc) candidate_area_instance_init, NULL };
		GType candidate_area_type_id;
		candidate_area_type_id = g_type_register_static (gtk_box_get_type (), "CandidateArea", &g_define_type_info, 0);
		g_once_init_leave (&candidate_area_type_id__volatile, candidate_area_type_id);
	}
	return candidate_area_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



