; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5

; RUN: llc -mtriple=amdgcn -mcpu=tahiti < %s | FileCheck -check-prefix=SI %s
; RUN: llc -mtriple=amdgcn -mcpu=tonga < %s | FileCheck -check-prefix=VI %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx900 < %s | FileCheck -check-prefix=GFX9 %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1100 -mattr=+real-true16 < %s | FileCheck -check-prefixes=GFX11,GFX11-TRUE16 %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1100 -mattr=-real-true16 < %s | FileCheck -check-prefixes=GFX11,GFX11-FAKE16 %s

define <3 x float> @bitcast_v3i32_to_v3f32(<3 x i32> %a, i32 %b) {
; SI-LABEL: bitcast_v3i32_to_v3f32:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v3
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:  ; %bb.1: ; %cmp.true
; SI-NEXT:    v_add_i32_e32 v2, vcc, 3, v2
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v1
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v0
; SI-NEXT:  ; %bb.2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v3i32_to_v3f32:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v3
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_add_u32_e32 v2, vcc, 3, v2
; VI-NEXT:    v_add_u32_e32 v1, vcc, 3, v1
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v0
; VI-NEXT:  ; %bb.2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v3i32_to_v3f32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v3
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_add_u32_e32 v2, 3, v2
; GFX9-NEXT:    v_add_u32_e32 v1, 3, v1
; GFX9-NEXT:    v_add_u32_e32 v0, 3, v0
; GFX9-NEXT:  ; %bb.2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v3i32_to_v3f32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v3
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_add_nc_u32_e32 v2, 3, v2
; GFX11-NEXT:    v_add_nc_u32_e32 v1, 3, v1
; GFX11-NEXT:    v_add_nc_u32_e32 v0, 3, v0
; GFX11-NEXT:  ; %bb.2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <3 x i32> %a, splat (i32 3)
  %a2 = bitcast <3 x i32> %a1 to <3 x float>
  br label %end

cmp.false:
  %a3 = bitcast <3 x i32> %a to <3 x float>
  br label %end

end:
  %phi = phi <3 x float> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <3 x float> %phi
}

define inreg <3 x float> @bitcast_v3i32_to_v3f32_scalar(<3 x i32> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v3i32_to_v3f32_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s19, 0
; SI-NEXT:    s_cbranch_scc0 .LBB1_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_cbranch_execnz .LBB1_3
; SI-NEXT:  .LBB1_2: ; %cmp.true
; SI-NEXT:    s_add_i32 s18, s18, 3
; SI-NEXT:    s_add_i32 s17, s17, 3
; SI-NEXT:    s_add_i32 s16, s16, 3
; SI-NEXT:  .LBB1_3: ; %end
; SI-NEXT:    v_mov_b32_e32 v0, s16
; SI-NEXT:    v_mov_b32_e32 v1, s17
; SI-NEXT:    v_mov_b32_e32 v2, s18
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB1_4:
; SI-NEXT:    s_branch .LBB1_2
;
; VI-LABEL: bitcast_v3i32_to_v3f32_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s19, 0
; VI-NEXT:    s_cbranch_scc0 .LBB1_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB1_3
; VI-NEXT:  .LBB1_2: ; %cmp.true
; VI-NEXT:    s_add_i32 s18, s18, 3
; VI-NEXT:    s_add_i32 s17, s17, 3
; VI-NEXT:    s_add_i32 s16, s16, 3
; VI-NEXT:  .LBB1_3: ; %end
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    v_mov_b32_e32 v2, s18
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB1_4:
; VI-NEXT:    s_branch .LBB1_2
;
; GFX9-LABEL: bitcast_v3i32_to_v3f32_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s19, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB1_4
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB1_3
; GFX9-NEXT:  .LBB1_2: ; %cmp.true
; GFX9-NEXT:    s_add_i32 s18, s18, 3
; GFX9-NEXT:    s_add_i32 s17, s17, 3
; GFX9-NEXT:    s_add_i32 s16, s16, 3
; GFX9-NEXT:  .LBB1_3: ; %end
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB1_4:
; GFX9-NEXT:    s_branch .LBB1_2
;
; GFX11-LABEL: bitcast_v3i32_to_v3f32_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_cmp_lg_u32 s3, 0
; GFX11-NEXT:    s_mov_b32 s3, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB1_4
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s3
; GFX11-NEXT:    s_cbranch_vccnz .LBB1_3
; GFX11-NEXT:  .LBB1_2: ; %cmp.true
; GFX11-NEXT:    s_add_i32 s2, s2, 3
; GFX11-NEXT:    s_add_i32 s1, s1, 3
; GFX11-NEXT:    s_add_i32 s0, s0, 3
; GFX11-NEXT:  .LBB1_3: ; %end
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_mov_b32_e32 v2, s2
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB1_4:
; GFX11-NEXT:    s_branch .LBB1_2
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <3 x i32> %a, splat (i32 3)
  %a2 = bitcast <3 x i32> %a1 to <3 x float>
  br label %end

cmp.false:
  %a3 = bitcast <3 x i32> %a to <3 x float>
  br label %end

end:
  %phi = phi <3 x float> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <3 x float> %phi
}

define <3 x i32> @bitcast_v3f32_to_v3i32(<3 x float> %a, i32 %b) {
; SI-LABEL: bitcast_v3f32_to_v3i32:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v3
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:  ; %bb.1: ; %cmp.true
; SI-NEXT:    v_add_f32_e32 v2, 1.0, v2
; SI-NEXT:    v_add_f32_e32 v1, 1.0, v1
; SI-NEXT:    v_add_f32_e32 v0, 1.0, v0
; SI-NEXT:  ; %bb.2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v3f32_to_v3i32:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v3
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_add_f32_e32 v2, 1.0, v2
; VI-NEXT:    v_add_f32_e32 v1, 1.0, v1
; VI-NEXT:    v_add_f32_e32 v0, 1.0, v0
; VI-NEXT:  ; %bb.2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v3f32_to_v3i32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v3
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_add_f32_e32 v2, 1.0, v2
; GFX9-NEXT:    v_add_f32_e32 v1, 1.0, v1
; GFX9-NEXT:    v_add_f32_e32 v0, 1.0, v0
; GFX9-NEXT:  ; %bb.2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v3f32_to_v3i32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v3
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_dual_add_f32 v2, 1.0, v2 :: v_dual_add_f32 v1, 1.0, v1
; GFX11-NEXT:    v_add_f32_e32 v0, 1.0, v0
; GFX11-NEXT:  ; %bb.2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <3 x float> %a, splat (float 1.000000e+00)
  %a2 = bitcast <3 x float> %a1 to <3 x i32>
  br label %end

cmp.false:
  %a3 = bitcast <3 x float> %a to <3 x i32>
  br label %end

end:
  %phi = phi <3 x i32> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <3 x i32> %phi
}

define inreg <3 x i32> @bitcast_v3f32_to_v3i32_scalar(<3 x float> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v3f32_to_v3i32_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s19, 0
; SI-NEXT:    s_cbranch_scc0 .LBB3_3
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_cbranch_execnz .LBB3_4
; SI-NEXT:  .LBB3_2: ; %cmp.true
; SI-NEXT:    v_add_f32_e64 v2, s18, 1.0
; SI-NEXT:    v_add_f32_e64 v1, s17, 1.0
; SI-NEXT:    v_add_f32_e64 v0, s16, 1.0
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB3_3:
; SI-NEXT:    s_branch .LBB3_2
; SI-NEXT:  .LBB3_4:
; SI-NEXT:    v_mov_b32_e32 v0, s16
; SI-NEXT:    v_mov_b32_e32 v1, s17
; SI-NEXT:    v_mov_b32_e32 v2, s18
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v3f32_to_v3i32_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s19, 0
; VI-NEXT:    s_cbranch_scc0 .LBB3_3
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB3_4
; VI-NEXT:  .LBB3_2: ; %cmp.true
; VI-NEXT:    v_add_f32_e64 v2, s18, 1.0
; VI-NEXT:    v_add_f32_e64 v1, s17, 1.0
; VI-NEXT:    v_add_f32_e64 v0, s16, 1.0
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB3_3:
; VI-NEXT:    s_branch .LBB3_2
; VI-NEXT:  .LBB3_4:
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    v_mov_b32_e32 v2, s18
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v3f32_to_v3i32_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s19, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB3_3
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB3_4
; GFX9-NEXT:  .LBB3_2: ; %cmp.true
; GFX9-NEXT:    v_add_f32_e64 v2, s18, 1.0
; GFX9-NEXT:    v_add_f32_e64 v1, s17, 1.0
; GFX9-NEXT:    v_add_f32_e64 v0, s16, 1.0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB3_3:
; GFX9-NEXT:    s_branch .LBB3_2
; GFX9-NEXT:  .LBB3_4:
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v3f32_to_v3i32_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_cmp_lg_u32 s3, 0
; GFX11-NEXT:    s_mov_b32 s3, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB3_3
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s3
; GFX11-NEXT:    s_cbranch_vccnz .LBB3_4
; GFX11-NEXT:  .LBB3_2: ; %cmp.true
; GFX11-NEXT:    v_add_f32_e64 v2, s2, 1.0
; GFX11-NEXT:    v_add_f32_e64 v1, s1, 1.0
; GFX11-NEXT:    v_add_f32_e64 v0, s0, 1.0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB3_3:
; GFX11-NEXT:    s_branch .LBB3_2
; GFX11-NEXT:  .LBB3_4:
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_mov_b32_e32 v2, s2
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <3 x float> %a, splat (float 1.000000e+00)
  %a2 = bitcast <3 x float> %a1 to <3 x i32>
  br label %end

cmp.false:
  %a3 = bitcast <3 x float> %a to <3 x i32>
  br label %end

end:
  %phi = phi <3 x i32> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <3 x i32> %phi
}

define <12 x i8> @bitcast_v3i32_to_v12i8(<3 x i32> %a, i32 %b) {
; SI-LABEL: bitcast_v3i32_to_v12i8:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v8, v2
; SI-NEXT:    v_mov_b32_e32 v4, v1
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v3
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    ; implicit-def: $vgpr6
; SI-NEXT:    ; implicit-def: $vgpr7
; SI-NEXT:    ; implicit-def: $vgpr9
; SI-NEXT:    ; implicit-def: $vgpr10
; SI-NEXT:    ; implicit-def: $vgpr11
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB4_3
; SI-NEXT:  ; %bb.1: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB4_4
; SI-NEXT:  .LBB4_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB4_3: ; %cmp.false
; SI-NEXT:    v_alignbit_b32 v11, s4, v8, 24
; SI-NEXT:    v_alignbit_b32 v10, s4, v8, 16
; SI-NEXT:    v_alignbit_b32 v9, s4, v8, 8
; SI-NEXT:    v_alignbit_b32 v3, v4, v0, 24
; SI-NEXT:    v_alignbit_b32 v2, v4, v0, 16
; SI-NEXT:    v_alignbit_b32 v1, v4, v0, 8
; SI-NEXT:    v_lshrrev_b32_e32 v7, 24, v4
; SI-NEXT:    v_lshrrev_b32_e32 v6, 16, v4
; SI-NEXT:    v_lshrrev_b32_e32 v5, 8, v4
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB4_2
; SI-NEXT:  .LBB4_4: ; %cmp.true
; SI-NEXT:    v_add_i32_e32 v8, vcc, 3, v8
; SI-NEXT:    v_add_i32_e32 v4, vcc, 3, v4
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v0
; SI-NEXT:    v_alignbit_b32 v3, v4, v0, 24
; SI-NEXT:    v_alignbit_b32 v2, v4, v0, 16
; SI-NEXT:    v_alignbit_b32 v1, v4, v0, 8
; SI-NEXT:    v_alignbit_b32 v11, s4, v8, 24
; SI-NEXT:    v_alignbit_b32 v10, s4, v8, 16
; SI-NEXT:    v_alignbit_b32 v9, s4, v8, 8
; SI-NEXT:    v_lshrrev_b32_e32 v7, 24, v4
; SI-NEXT:    v_lshrrev_b32_e32 v6, 16, v4
; SI-NEXT:    v_lshrrev_b32_e32 v5, 8, v4
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v3i32_to_v12i8:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v8, v2
; VI-NEXT:    v_mov_b32_e32 v14, v1
; VI-NEXT:    v_mov_b32_e32 v13, v0
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v3
; VI-NEXT:    ; implicit-def: $vgpr1
; VI-NEXT:    ; implicit-def: $vgpr2
; VI-NEXT:    ; implicit-def: $vgpr3
; VI-NEXT:    ; implicit-def: $vgpr5
; VI-NEXT:    ; implicit-def: $vgpr6
; VI-NEXT:    ; implicit-def: $vgpr7
; VI-NEXT:    ; implicit-def: $vgpr9
; VI-NEXT:    ; implicit-def: $vgpr10
; VI-NEXT:    ; implicit-def: $vgpr11
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB4_2
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    v_lshrrev_b32_e32 v9, 8, v8
; VI-NEXT:    v_lshrrev_b32_e32 v10, 16, v8
; VI-NEXT:    v_lshrrev_b32_e32 v7, 24, v14
; VI-NEXT:    v_lshrrev_b32_e32 v6, 16, v14
; VI-NEXT:    v_lshrrev_b32_e32 v5, 8, v14
; VI-NEXT:    v_lshrrev_b32_e32 v2, 16, v13
; VI-NEXT:    v_lshrrev_b64 v[11:12], 24, v[8:9]
; VI-NEXT:    v_lshrrev_b64 v[3:4], 24, v[13:14]
; VI-NEXT:    v_lshrrev_b32_e32 v1, 8, v13
; VI-NEXT:  .LBB4_2: ; %Flow
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB4_4
; VI-NEXT:  ; %bb.3: ; %cmp.true
; VI-NEXT:    v_add_u32_e32 v8, vcc, 3, v8
; VI-NEXT:    v_add_u32_e32 v14, vcc, 3, v14
; VI-NEXT:    v_add_u32_e32 v13, vcc, 3, v13
; VI-NEXT:    v_lshrrev_b32_e32 v9, 8, v8
; VI-NEXT:    v_lshrrev_b64 v[3:4], 24, v[13:14]
; VI-NEXT:    v_lshrrev_b64 v[11:12], 24, v[8:9]
; VI-NEXT:    v_lshrrev_b32_e32 v10, 16, v8
; VI-NEXT:    v_lshrrev_b32_e32 v7, 24, v14
; VI-NEXT:    v_lshrrev_b32_e32 v6, 16, v14
; VI-NEXT:    v_lshrrev_b32_e32 v5, 8, v14
; VI-NEXT:    v_lshrrev_b32_e32 v2, 16, v13
; VI-NEXT:    v_lshrrev_b32_e32 v1, 8, v13
; VI-NEXT:  .LBB4_4: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    v_mov_b32_e32 v0, v13
; VI-NEXT:    v_mov_b32_e32 v4, v14
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v3i32_to_v12i8:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v8, v2
; GFX9-NEXT:    v_mov_b32_e32 v14, v1
; GFX9-NEXT:    v_mov_b32_e32 v13, v0
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v3
; GFX9-NEXT:    ; implicit-def: $vgpr1
; GFX9-NEXT:    ; implicit-def: $vgpr2
; GFX9-NEXT:    ; implicit-def: $vgpr3
; GFX9-NEXT:    ; implicit-def: $vgpr5
; GFX9-NEXT:    ; implicit-def: $vgpr6
; GFX9-NEXT:    ; implicit-def: $vgpr7
; GFX9-NEXT:    ; implicit-def: $vgpr9
; GFX9-NEXT:    ; implicit-def: $vgpr10
; GFX9-NEXT:    ; implicit-def: $vgpr11
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB4_2
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    v_lshrrev_b32_e32 v9, 8, v8
; GFX9-NEXT:    v_lshrrev_b32_e32 v10, 16, v8
; GFX9-NEXT:    v_lshrrev_b32_e32 v7, 24, v14
; GFX9-NEXT:    v_lshrrev_b32_e32 v6, 16, v14
; GFX9-NEXT:    v_lshrrev_b32_e32 v5, 8, v14
; GFX9-NEXT:    v_lshrrev_b32_e32 v2, 16, v13
; GFX9-NEXT:    v_lshrrev_b64 v[11:12], 24, v[8:9]
; GFX9-NEXT:    v_lshrrev_b64 v[3:4], 24, v[13:14]
; GFX9-NEXT:    v_lshrrev_b32_e32 v1, 8, v13
; GFX9-NEXT:  .LBB4_2: ; %Flow
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB4_4
; GFX9-NEXT:  ; %bb.3: ; %cmp.true
; GFX9-NEXT:    v_add_u32_e32 v8, 3, v8
; GFX9-NEXT:    v_add_u32_e32 v14, 3, v14
; GFX9-NEXT:    v_add_u32_e32 v13, 3, v13
; GFX9-NEXT:    v_lshrrev_b32_e32 v9, 8, v8
; GFX9-NEXT:    v_lshrrev_b64 v[3:4], 24, v[13:14]
; GFX9-NEXT:    v_lshrrev_b64 v[11:12], 24, v[8:9]
; GFX9-NEXT:    v_lshrrev_b32_e32 v10, 16, v8
; GFX9-NEXT:    v_lshrrev_b32_e32 v7, 24, v14
; GFX9-NEXT:    v_lshrrev_b32_e32 v6, 16, v14
; GFX9-NEXT:    v_lshrrev_b32_e32 v5, 8, v14
; GFX9-NEXT:    v_lshrrev_b32_e32 v2, 16, v13
; GFX9-NEXT:    v_lshrrev_b32_e32 v1, 8, v13
; GFX9-NEXT:  .LBB4_4: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    v_mov_b32_e32 v0, v13
; GFX9-NEXT:    v_mov_b32_e32 v4, v14
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-TRUE16-LABEL: bitcast_v3i32_to_v12i8:
; GFX11-TRUE16:       ; %bb.0:
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-TRUE16-NEXT:    v_dual_mov_b32 v10, v2 :: v_dual_mov_b32 v11, v0
; GFX11-TRUE16-NEXT:    v_mov_b32_e32 v12, v1
; GFX11-TRUE16-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v3
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr1_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr3_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr5_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr7_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr9_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr13_lo16
; GFX11-TRUE16-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-TRUE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-TRUE16-NEXT:  ; %bb.1: ; %cmp.false
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v9, 8, v10
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v7, 24, v12
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v5, 8, v12
; GFX11-TRUE16-NEXT:    v_lshrrev_b64 v[13:14], 24, v[10:11]
; GFX11-TRUE16-NEXT:    v_lshrrev_b64 v[3:4], 24, v[11:12]
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v1, 8, v11
; GFX11-TRUE16-NEXT:  ; %bb.2: ; %Flow
; GFX11-TRUE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-TRUE16-NEXT:    s_cbranch_execz .LBB4_4
; GFX11-TRUE16-NEXT:  ; %bb.3: ; %cmp.true
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v12, 3, v12
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v11, 3, v11
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v10, 3, v10
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v7, 24, v12
; GFX11-TRUE16-NEXT:    v_lshrrev_b64 v[3:4], 24, v[11:12]
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX11-TRUE16-NEXT:    v_lshrrev_b64 v[13:14], 24, v[10:11]
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v9, 8, v10
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v5, 8, v12
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v1, 8, v11
; GFX11-TRUE16-NEXT:  .LBB4_4: ; %end
; GFX11-TRUE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v0.l, v11.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v2.l, v11.h
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v4.l, v12.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v6.l, v12.h
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v8.l, v10.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v10.l, v10.h
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v11.l, v13.l
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-FAKE16-LABEL: bitcast_v3i32_to_v12i8:
; GFX11-FAKE16:       ; %bb.0:
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-FAKE16-NEXT:    v_dual_mov_b32 v8, v2 :: v_dual_mov_b32 v13, v0
; GFX11-FAKE16-NEXT:    v_mov_b32_e32 v14, v1
; GFX11-FAKE16-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v3
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr1
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr2
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr3
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr5
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr6
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr7
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr9
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr10
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr11
; GFX11-FAKE16-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-FAKE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_cbranch_execz .LBB4_2
; GFX11-FAKE16-NEXT:  ; %bb.1: ; %cmp.false
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v9, 8, v8
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v10, 16, v8
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v7, 24, v14
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v6, 16, v14
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v5, 8, v14
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v2, 16, v13
; GFX11-FAKE16-NEXT:    v_lshrrev_b64 v[11:12], 24, v[8:9]
; GFX11-FAKE16-NEXT:    v_lshrrev_b64 v[3:4], 24, v[13:14]
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 8, v13
; GFX11-FAKE16-NEXT:  .LBB4_2: ; %Flow
; GFX11-FAKE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-FAKE16-NEXT:    s_cbranch_execz .LBB4_4
; GFX11-FAKE16-NEXT:  ; %bb.3: ; %cmp.true
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v8, 3, v8
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v14, 3, v14
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v13, 3, v13
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v9, 8, v8
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v10, 16, v8
; GFX11-FAKE16-NEXT:    v_lshrrev_b64 v[3:4], 24, v[13:14]
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v7, 24, v14
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v6, 16, v14
; GFX11-FAKE16-NEXT:    v_lshrrev_b64 v[11:12], 24, v[8:9]
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v5, 8, v14
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v2, 16, v13
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 8, v13
; GFX11-FAKE16-NEXT:  .LBB4_4: ; %end
; GFX11-FAKE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-FAKE16-NEXT:    v_mov_b32_e32 v0, v13
; GFX11-FAKE16-NEXT:    v_mov_b32_e32 v4, v14
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <3 x i32> %a, splat (i32 3)
  %a2 = bitcast <3 x i32> %a1 to <12 x i8>
  br label %end

cmp.false:
  %a3 = bitcast <3 x i32> %a to <12 x i8>
  br label %end

end:
  %phi = phi <12 x i8> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <12 x i8> %phi
}

define inreg <12 x i8> @bitcast_v3i32_to_v12i8_scalar(<3 x i32> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v3i32_to_v12i8_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s19, 0
; SI-NEXT:    s_cbranch_scc0 .LBB5_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    v_mov_b32_e32 v0, s18
; SI-NEXT:    v_alignbit_b32 v11, s4, v0, 24
; SI-NEXT:    v_alignbit_b32 v10, s4, v0, 16
; SI-NEXT:    v_alignbit_b32 v9, s4, v0, 8
; SI-NEXT:    v_mov_b32_e32 v0, s16
; SI-NEXT:    v_alignbit_b32 v3, s17, v0, 24
; SI-NEXT:    v_alignbit_b32 v2, s17, v0, 16
; SI-NEXT:    v_alignbit_b32 v1, s17, v0, 8
; SI-NEXT:    s_lshr_b32 s6, s17, 24
; SI-NEXT:    s_lshr_b32 s7, s17, 16
; SI-NEXT:    s_lshr_b32 s8, s17, 8
; SI-NEXT:    s_cbranch_execnz .LBB5_3
; SI-NEXT:  .LBB5_2: ; %cmp.true
; SI-NEXT:    s_add_i32 s16, s16, 3
; SI-NEXT:    s_add_i32 s18, s18, 3
; SI-NEXT:    s_add_i32 s17, s17, 3
; SI-NEXT:    v_mov_b32_e32 v0, s16
; SI-NEXT:    v_alignbit_b32 v3, s17, v0, 24
; SI-NEXT:    v_alignbit_b32 v2, s17, v0, 16
; SI-NEXT:    v_alignbit_b32 v1, s17, v0, 8
; SI-NEXT:    v_mov_b32_e32 v0, s18
; SI-NEXT:    v_alignbit_b32 v11, s4, v0, 24
; SI-NEXT:    v_alignbit_b32 v10, s4, v0, 16
; SI-NEXT:    v_alignbit_b32 v9, s4, v0, 8
; SI-NEXT:    s_lshr_b32 s6, s17, 24
; SI-NEXT:    s_lshr_b32 s7, s17, 16
; SI-NEXT:    s_lshr_b32 s8, s17, 8
; SI-NEXT:  .LBB5_3: ; %end
; SI-NEXT:    v_mov_b32_e32 v0, s16
; SI-NEXT:    v_mov_b32_e32 v4, s17
; SI-NEXT:    v_mov_b32_e32 v5, s8
; SI-NEXT:    v_mov_b32_e32 v6, s7
; SI-NEXT:    v_mov_b32_e32 v7, s6
; SI-NEXT:    v_mov_b32_e32 v8, s18
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB5_4:
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    ; implicit-def: $sgpr8
; SI-NEXT:    ; implicit-def: $sgpr7
; SI-NEXT:    ; implicit-def: $sgpr6
; SI-NEXT:    ; implicit-def: $vgpr9
; SI-NEXT:    ; implicit-def: $vgpr10
; SI-NEXT:    ; implicit-def: $vgpr11
; SI-NEXT:    s_branch .LBB5_2
;
; VI-LABEL: bitcast_v3i32_to_v12i8_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s19, 0
; VI-NEXT:    s_cbranch_scc0 .LBB5_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_lshr_b32 s19, s16, 8
; VI-NEXT:    s_lshr_b32 s10, s18, 16
; VI-NEXT:    s_lshr_b32 s11, s18, 8
; VI-NEXT:    s_lshr_b32 s12, s17, 24
; VI-NEXT:    s_lshr_b32 s13, s17, 16
; VI-NEXT:    s_lshr_b32 s14, s17, 8
; VI-NEXT:    s_lshr_b32 s15, s16, 16
; VI-NEXT:    s_lshr_b64 s[6:7], s[18:19], 24
; VI-NEXT:    s_lshr_b64 s[4:5], s[16:17], 24
; VI-NEXT:    s_cbranch_execnz .LBB5_3
; VI-NEXT:  .LBB5_2: ; %cmp.true
; VI-NEXT:    s_add_i32 s16, s16, 3
; VI-NEXT:    s_add_i32 s18, s18, 3
; VI-NEXT:    s_add_i32 s17, s17, 3
; VI-NEXT:    s_lshr_b32 s19, s16, 8
; VI-NEXT:    s_lshr_b64 s[4:5], s[16:17], 24
; VI-NEXT:    s_lshr_b32 s10, s18, 16
; VI-NEXT:    s_lshr_b32 s11, s18, 8
; VI-NEXT:    s_lshr_b32 s12, s17, 24
; VI-NEXT:    s_lshr_b32 s13, s17, 16
; VI-NEXT:    s_lshr_b32 s14, s17, 8
; VI-NEXT:    s_lshr_b32 s15, s16, 16
; VI-NEXT:    s_lshr_b64 s[6:7], s[18:19], 24
; VI-NEXT:  .LBB5_3: ; %end
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s19
; VI-NEXT:    v_mov_b32_e32 v2, s15
; VI-NEXT:    v_mov_b32_e32 v3, s4
; VI-NEXT:    v_mov_b32_e32 v4, s17
; VI-NEXT:    v_mov_b32_e32 v5, s14
; VI-NEXT:    v_mov_b32_e32 v6, s13
; VI-NEXT:    v_mov_b32_e32 v7, s12
; VI-NEXT:    v_mov_b32_e32 v8, s18
; VI-NEXT:    v_mov_b32_e32 v9, s11
; VI-NEXT:    v_mov_b32_e32 v10, s10
; VI-NEXT:    v_mov_b32_e32 v11, s6
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB5_4:
; VI-NEXT:    ; implicit-def: $sgpr19
; VI-NEXT:    ; implicit-def: $sgpr15
; VI-NEXT:    ; implicit-def: $sgpr4
; VI-NEXT:    ; implicit-def: $sgpr14
; VI-NEXT:    ; implicit-def: $sgpr13
; VI-NEXT:    ; implicit-def: $sgpr12
; VI-NEXT:    ; implicit-def: $sgpr11
; VI-NEXT:    ; implicit-def: $sgpr10
; VI-NEXT:    ; implicit-def: $sgpr6
; VI-NEXT:    s_branch .LBB5_2
;
; GFX9-LABEL: bitcast_v3i32_to_v12i8_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s19, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB5_4
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_lshr_b32 s19, s16, 8
; GFX9-NEXT:    s_lshr_b32 s10, s18, 16
; GFX9-NEXT:    s_lshr_b32 s11, s18, 8
; GFX9-NEXT:    s_lshr_b32 s12, s17, 24
; GFX9-NEXT:    s_lshr_b32 s13, s17, 16
; GFX9-NEXT:    s_lshr_b32 s14, s17, 8
; GFX9-NEXT:    s_lshr_b32 s15, s16, 16
; GFX9-NEXT:    s_lshr_b64 s[6:7], s[18:19], 24
; GFX9-NEXT:    s_lshr_b64 s[4:5], s[16:17], 24
; GFX9-NEXT:    s_cbranch_execnz .LBB5_3
; GFX9-NEXT:  .LBB5_2: ; %cmp.true
; GFX9-NEXT:    s_add_i32 s16, s16, 3
; GFX9-NEXT:    s_add_i32 s18, s18, 3
; GFX9-NEXT:    s_add_i32 s17, s17, 3
; GFX9-NEXT:    s_lshr_b32 s19, s16, 8
; GFX9-NEXT:    s_lshr_b64 s[4:5], s[16:17], 24
; GFX9-NEXT:    s_lshr_b32 s10, s18, 16
; GFX9-NEXT:    s_lshr_b32 s11, s18, 8
; GFX9-NEXT:    s_lshr_b32 s12, s17, 24
; GFX9-NEXT:    s_lshr_b32 s13, s17, 16
; GFX9-NEXT:    s_lshr_b32 s14, s17, 8
; GFX9-NEXT:    s_lshr_b32 s15, s16, 16
; GFX9-NEXT:    s_lshr_b64 s[6:7], s[18:19], 24
; GFX9-NEXT:  .LBB5_3: ; %end
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s19
; GFX9-NEXT:    v_mov_b32_e32 v2, s15
; GFX9-NEXT:    v_mov_b32_e32 v3, s4
; GFX9-NEXT:    v_mov_b32_e32 v4, s17
; GFX9-NEXT:    v_mov_b32_e32 v5, s14
; GFX9-NEXT:    v_mov_b32_e32 v6, s13
; GFX9-NEXT:    v_mov_b32_e32 v7, s12
; GFX9-NEXT:    v_mov_b32_e32 v8, s18
; GFX9-NEXT:    v_mov_b32_e32 v9, s11
; GFX9-NEXT:    v_mov_b32_e32 v10, s10
; GFX9-NEXT:    v_mov_b32_e32 v11, s6
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB5_4:
; GFX9-NEXT:    ; implicit-def: $sgpr19
; GFX9-NEXT:    ; implicit-def: $sgpr15
; GFX9-NEXT:    ; implicit-def: $sgpr4
; GFX9-NEXT:    ; implicit-def: $sgpr14
; GFX9-NEXT:    ; implicit-def: $sgpr13
; GFX9-NEXT:    ; implicit-def: $sgpr12
; GFX9-NEXT:    ; implicit-def: $sgpr11
; GFX9-NEXT:    ; implicit-def: $sgpr10
; GFX9-NEXT:    ; implicit-def: $sgpr6
; GFX9-NEXT:    s_branch .LBB5_2
;
; GFX11-LABEL: bitcast_v3i32_to_v12i8_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_cmp_lg_u32 s3, 0
; GFX11-NEXT:    s_mov_b32 s14, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB5_4
; GFX11-NEXT:  ; %bb.1: ; %cmp.false
; GFX11-NEXT:    s_lshr_b32 s3, s2, 16
; GFX11-NEXT:    s_lshr_b32 s8, s2, 8
; GFX11-NEXT:    s_lshr_b32 s9, s1, 24
; GFX11-NEXT:    s_lshr_b32 s10, s1, 16
; GFX11-NEXT:    s_lshr_b32 s11, s1, 8
; GFX11-NEXT:    s_lshr_b32 s12, s0, 16
; GFX11-NEXT:    s_lshr_b32 s13, s0, 8
; GFX11-NEXT:    s_lshr_b64 s[6:7], s[2:3], 24
; GFX11-NEXT:    s_lshr_b64 s[4:5], s[0:1], 24
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s14
; GFX11-NEXT:    s_cbranch_vccnz .LBB5_3
; GFX11-NEXT:  .LBB5_2: ; %cmp.true
; GFX11-NEXT:    s_add_i32 s2, s2, 3
; GFX11-NEXT:    s_add_i32 s1, s1, 3
; GFX11-NEXT:    s_add_i32 s0, s0, 3
; GFX11-NEXT:    s_lshr_b32 s3, s2, 16
; GFX11-NEXT:    s_lshr_b64 s[4:5], s[0:1], 24
; GFX11-NEXT:    s_lshr_b32 s8, s2, 8
; GFX11-NEXT:    s_lshr_b32 s9, s1, 24
; GFX11-NEXT:    s_lshr_b32 s10, s1, 16
; GFX11-NEXT:    s_lshr_b32 s11, s1, 8
; GFX11-NEXT:    s_lshr_b32 s12, s0, 16
; GFX11-NEXT:    s_lshr_b32 s13, s0, 8
; GFX11-NEXT:    s_lshr_b64 s[6:7], s[2:3], 24
; GFX11-NEXT:  .LBB5_3: ; %end
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s13
; GFX11-NEXT:    v_dual_mov_b32 v2, s12 :: v_dual_mov_b32 v3, s4
; GFX11-NEXT:    v_dual_mov_b32 v4, s1 :: v_dual_mov_b32 v5, s11
; GFX11-NEXT:    v_dual_mov_b32 v6, s10 :: v_dual_mov_b32 v7, s9
; GFX11-NEXT:    v_dual_mov_b32 v8, s2 :: v_dual_mov_b32 v9, s8
; GFX11-NEXT:    v_dual_mov_b32 v10, s3 :: v_dual_mov_b32 v11, s6
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB5_4:
; GFX11-NEXT:    ; implicit-def: $sgpr13
; GFX11-NEXT:    ; implicit-def: $sgpr12
; GFX11-NEXT:    ; implicit-def: $sgpr4
; GFX11-NEXT:    ; implicit-def: $sgpr11
; GFX11-NEXT:    ; implicit-def: $sgpr10
; GFX11-NEXT:    ; implicit-def: $sgpr9
; GFX11-NEXT:    ; implicit-def: $sgpr8
; GFX11-NEXT:    ; implicit-def: $sgpr3
; GFX11-NEXT:    ; implicit-def: $sgpr6
; GFX11-NEXT:    s_branch .LBB5_2
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <3 x i32> %a, splat (i32 3)
  %a2 = bitcast <3 x i32> %a1 to <12 x i8>
  br label %end

cmp.false:
  %a3 = bitcast <3 x i32> %a to <12 x i8>
  br label %end

end:
  %phi = phi <12 x i8> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <12 x i8> %phi
}

define <3 x i32> @bitcast_v12i8_to_v3i32(<12 x i8> %a, i32 %b) {
; SI-LABEL: bitcast_v12i8_to_v3i32:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v14, v2
; SI-NEXT:    v_mov_b32_e32 v13, v0
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v12
; SI-NEXT:    v_lshlrev_b32_e32 v16, 8, v1
; SI-NEXT:    v_lshlrev_b32_e32 v15, 24, v3
; SI-NEXT:    v_lshlrev_b32_e32 v12, 8, v5
; SI-NEXT:    v_lshlrev_b32_e32 v7, 24, v7
; SI-NEXT:    v_lshlrev_b32_e32 v5, 8, v9
; SI-NEXT:    v_lshlrev_b32_e32 v3, 24, v11
; SI-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB6_3
; SI-NEXT:  ; %bb.1: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB6_4
; SI-NEXT:  .LBB6_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB6_3: ; %cmp.false
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v13
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v14
; SI-NEXT:    v_or_b32_e32 v0, v0, v16
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v1, v15, v1
; SI-NEXT:    v_or_b32_e32 v0, v0, v1
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v4
; SI-NEXT:    v_and_b32_e32 v2, 0xff, v6
; SI-NEXT:    v_or_b32_e32 v1, v1, v12
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; SI-NEXT:    v_or_b32_e32 v2, v7, v2
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_and_b32_e32 v2, 0xff, v8
; SI-NEXT:    v_and_b32_e32 v4, 0xff, v10
; SI-NEXT:    v_or_b32_e32 v2, v2, v5
; SI-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; SI-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; SI-NEXT:    v_or_b32_e32 v3, v3, v4
; SI-NEXT:    v_or_b32_e32 v2, v2, v3
; SI-NEXT:    ; implicit-def: $vgpr13
; SI-NEXT:    ; implicit-def: $vgpr14
; SI-NEXT:    ; implicit-def: $vgpr4
; SI-NEXT:    ; implicit-def: $vgpr6
; SI-NEXT:    ; implicit-def: $vgpr8
; SI-NEXT:    ; implicit-def: $vgpr10
; SI-NEXT:    ; implicit-def: $vgpr16
; SI-NEXT:    ; implicit-def: $vgpr15
; SI-NEXT:    ; implicit-def: $vgpr12
; SI-NEXT:    ; implicit-def: $vgpr7
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB6_2
; SI-NEXT:  .LBB6_4: ; %cmp.true
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v13
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v0
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v14
; SI-NEXT:    v_or_b32_e32 v0, v16, v0
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v1
; SI-NEXT:    v_add_i32_e32 v0, vcc, 0x300, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v1, v15, v1
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v4
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v1
; SI-NEXT:    v_add_i32_e32 v2, vcc, 3, v6
; SI-NEXT:    s_movk_i32 s6, 0x300
; SI-NEXT:    v_or_b32_e32 v1, v12, v1
; SI-NEXT:    v_and_b32_e32 v2, 0xff, v2
; SI-NEXT:    v_add_i32_e32 v1, vcc, s6, v1
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; SI-NEXT:    v_or_b32_e32 v2, v7, v2
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    v_add_i32_e32 v2, vcc, 3, v8
; SI-NEXT:    v_and_b32_e32 v2, 0xff, v2
; SI-NEXT:    v_add_i32_e32 v4, vcc, 3, v10
; SI-NEXT:    v_or_b32_e32 v2, v5, v2
; SI-NEXT:    v_and_b32_e32 v4, 0xff, v4
; SI-NEXT:    v_add_i32_e32 v2, vcc, 0x300, v2
; SI-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; SI-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; SI-NEXT:    v_or_b32_e32 v3, v3, v4
; SI-NEXT:    s_mov_b32 s7, 0x3000000
; SI-NEXT:    v_or_b32_e32 v2, v3, v2
; SI-NEXT:    v_add_i32_e32 v0, vcc, s7, v0
; SI-NEXT:    v_add_i32_e32 v1, vcc, 0x3000000, v1
; SI-NEXT:    v_add_i32_e32 v2, vcc, 0x3000000, v2
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v12i8_to_v3i32:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v14, v2
; VI-NEXT:    v_mov_b32_e32 v13, v0
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v12
; VI-NEXT:    v_lshlrev_b16_e32 v16, 8, v1
; VI-NEXT:    v_lshlrev_b16_e32 v15, 8, v3
; VI-NEXT:    v_lshlrev_b16_e32 v12, 8, v5
; VI-NEXT:    v_lshlrev_b16_e32 v7, 8, v7
; VI-NEXT:    v_lshlrev_b16_e32 v5, 8, v9
; VI-NEXT:    v_lshlrev_b16_e32 v3, 8, v11
; VI-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_cbranch_execnz .LBB6_3
; VI-NEXT:  ; %bb.1: ; %Flow
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execnz .LBB6_4
; VI-NEXT:  .LBB6_2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB6_3: ; %cmp.false
; VI-NEXT:    v_or_b32_sdwa v0, v13, v16 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v14, v15 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v4, v12 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v2, v6, v7 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v2, v8, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v3, v10, v3 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v2, v2, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    ; implicit-def: $vgpr13
; VI-NEXT:    ; implicit-def: $vgpr14
; VI-NEXT:    ; implicit-def: $vgpr4
; VI-NEXT:    ; implicit-def: $vgpr6
; VI-NEXT:    ; implicit-def: $vgpr8
; VI-NEXT:    ; implicit-def: $vgpr10
; VI-NEXT:    ; implicit-def: $vgpr16
; VI-NEXT:    ; implicit-def: $vgpr15
; VI-NEXT:    ; implicit-def: $vgpr12
; VI-NEXT:    ; implicit-def: $vgpr7
; VI-NEXT:    ; implicit-def: $vgpr5
; VI-NEXT:    ; implicit-def: $vgpr3
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB6_2
; VI-NEXT:  .LBB6_4: ; %cmp.true
; VI-NEXT:    v_add_u16_e32 v0, 3, v13
; VI-NEXT:    v_add_u16_e32 v1, 3, v14
; VI-NEXT:    v_or_b32_sdwa v0, v16, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_or_b32_sdwa v1, v15, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_mov_b32_e32 v2, 0x300
; VI-NEXT:    v_add_u16_e32 v0, 0x300, v0
; VI-NEXT:    v_add_u16_sdwa v1, v1, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v0, v0, v1
; VI-NEXT:    v_add_u16_e32 v1, 3, v4
; VI-NEXT:    v_add_u16_e32 v4, 3, v6
; VI-NEXT:    v_or_b32_sdwa v1, v12, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_or_b32_sdwa v4, v7, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_add_u16_e32 v1, 0x300, v1
; VI-NEXT:    v_add_u16_sdwa v4, v4, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v1, v1, v4
; VI-NEXT:    v_add_u16_e32 v4, 3, v8
; VI-NEXT:    v_or_b32_sdwa v4, v5, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_add_u16_e32 v5, 3, v10
; VI-NEXT:    v_or_b32_sdwa v3, v3, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_add_u16_e32 v4, 0x300, v4
; VI-NEXT:    v_add_u16_sdwa v2, v3, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v2, v4, v2
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v12i8_to_v3i32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v14, v2
; GFX9-NEXT:    v_mov_b32_e32 v13, v0
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v12
; GFX9-NEXT:    v_lshlrev_b16_e32 v16, 8, v1
; GFX9-NEXT:    v_lshlrev_b16_e32 v15, 8, v3
; GFX9-NEXT:    v_lshlrev_b16_e32 v12, 8, v5
; GFX9-NEXT:    v_lshlrev_b16_e32 v7, 8, v7
; GFX9-NEXT:    v_lshlrev_b16_e32 v5, 8, v9
; GFX9-NEXT:    v_lshlrev_b16_e32 v3, 8, v11
; GFX9-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_cbranch_execnz .LBB6_3
; GFX9-NEXT:  ; %bb.1: ; %Flow
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:    s_cbranch_execnz .LBB6_4
; GFX9-NEXT:  .LBB6_2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB6_3: ; %cmp.false
; GFX9-NEXT:    v_or_b32_sdwa v0, v13, v16 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v1, v14, v15 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v1, v4, v12 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v2, v6, v7 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v2, v8, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v3, v10, v3 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v2, v2, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    ; implicit-def: $vgpr13
; GFX9-NEXT:    ; implicit-def: $vgpr14
; GFX9-NEXT:    ; implicit-def: $vgpr4
; GFX9-NEXT:    ; implicit-def: $vgpr6
; GFX9-NEXT:    ; implicit-def: $vgpr8
; GFX9-NEXT:    ; implicit-def: $vgpr10
; GFX9-NEXT:    ; implicit-def: $vgpr16
; GFX9-NEXT:    ; implicit-def: $vgpr15
; GFX9-NEXT:    ; implicit-def: $vgpr12
; GFX9-NEXT:    ; implicit-def: $vgpr7
; GFX9-NEXT:    ; implicit-def: $vgpr5
; GFX9-NEXT:    ; implicit-def: $vgpr3
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB6_2
; GFX9-NEXT:  .LBB6_4: ; %cmp.true
; GFX9-NEXT:    v_add_u16_e32 v0, 3, v13
; GFX9-NEXT:    v_add_u16_e32 v1, 3, v14
; GFX9-NEXT:    v_or_b32_sdwa v0, v16, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    s_movk_i32 s6, 0x300
; GFX9-NEXT:    v_or_b32_sdwa v1, v15, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u16_e32 v0, 0x300, v0
; GFX9-NEXT:    v_add_u16_sdwa v1, v1, s6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX9-NEXT:    v_add_u16_e32 v1, 3, v4
; GFX9-NEXT:    v_add_u16_e32 v2, 3, v6
; GFX9-NEXT:    v_or_b32_sdwa v1, v12, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_or_b32_sdwa v2, v7, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u16_e32 v1, 0x300, v1
; GFX9-NEXT:    v_add_u16_sdwa v2, v2, s6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_e32 v1, v1, v2
; GFX9-NEXT:    v_add_u16_e32 v2, 3, v8
; GFX9-NEXT:    v_add_u16_e32 v4, 3, v10
; GFX9-NEXT:    v_or_b32_sdwa v2, v5, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_or_b32_sdwa v3, v3, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u16_e32 v2, 0x300, v2
; GFX9-NEXT:    v_add_u16_sdwa v3, v3, s6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_e32 v2, v2, v3
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-TRUE16-LABEL: bitcast_v12i8_to_v3i32:
; GFX11-TRUE16:       ; %bb.0:
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v8.h, v7.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v6.h, v4.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v7.l, v2.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v7.h, v0.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v5.h, 8, v1.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v4.h, 8, v3.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v5.l, 8, v5.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v4.l, 8, v8.h
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v3.l, 8, v9.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v3.h, 8, v11.l
; GFX11-TRUE16-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2
; GFX11-TRUE16-NEXT:    v_cmpx_ne_u32_e32 0, v12
; GFX11-TRUE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-TRUE16-NEXT:    s_cbranch_execnz .LBB6_3
; GFX11-TRUE16-NEXT:  ; %bb.1: ; %Flow
; GFX11-TRUE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-TRUE16-NEXT:    s_cbranch_execnz .LBB6_4
; GFX11-TRUE16-NEXT:  .LBB6_2: ; %end
; GFX11-TRUE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
; GFX11-TRUE16-NEXT:  .LBB6_3: ; %cmp.false
; GFX11-TRUE16-NEXT:    v_and_b16 v0.l, 0xff, v7.h
; GFX11-TRUE16-NEXT:    v_and_b16 v0.h, 0xff, v7.l
; GFX11-TRUE16-NEXT:    v_and_b16 v1.l, 0xff, v6.h
; GFX11-TRUE16-NEXT:    v_and_b16 v1.h, 0xff, v6.l
; GFX11-TRUE16-NEXT:    v_and_b16 v2.l, 0xff, v8.l
; GFX11-TRUE16-NEXT:    v_or_b16 v0.l, v0.l, v5.h
; GFX11-TRUE16-NEXT:    v_and_b16 v2.h, 0xff, v10.l
; GFX11-TRUE16-NEXT:    v_or_b16 v6.l, v0.h, v4.h
; GFX11-TRUE16-NEXT:    v_or_b16 v1.l, v1.l, v5.l
; GFX11-TRUE16-NEXT:    v_or_b16 v4.l, v1.h, v4.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v5.l, v0.l
; GFX11-TRUE16-NEXT:    v_or_b16 v0.l, v2.l, v3.l
; GFX11-TRUE16-NEXT:    v_or_b16 v2.l, v2.h, v3.h
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v3, 0xffff, v5
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v5, 16, v6
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v6, 0xffff, v0
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v0, v3, v5
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v1, v1, v4
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v2, v6, v2
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr7_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr7_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr6_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr6_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr8_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr10_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr5_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr4_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr5_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr4_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr3_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr3_hi16
; GFX11-TRUE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-TRUE16-NEXT:    s_cbranch_execz .LBB6_2
; GFX11-TRUE16-NEXT:  .LBB6_4: ; %cmp.true
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v0.l, v7.h, 3
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v0.h, v7.l, 3
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v1.l, v6.h, 3
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v1.h, v6.l, 3
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v2.l, v8.l, 3
; GFX11-TRUE16-NEXT:    v_and_b16 v0.l, 0xff, v0.l
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v2.h, v10.l, 3
; GFX11-TRUE16-NEXT:    v_and_b16 v0.h, 0xff, v0.h
; GFX11-TRUE16-NEXT:    v_and_b16 v1.l, 0xff, v1.l
; GFX11-TRUE16-NEXT:    v_and_b16 v1.h, 0xff, v1.h
; GFX11-TRUE16-NEXT:    v_or_b16 v0.l, v5.h, v0.l
; GFX11-TRUE16-NEXT:    v_and_b16 v2.l, 0xff, v2.l
; GFX11-TRUE16-NEXT:    v_and_b16 v2.h, 0xff, v2.h
; GFX11-TRUE16-NEXT:    v_or_b16 v0.h, v4.h, v0.h
; GFX11-TRUE16-NEXT:    v_or_b16 v1.l, v5.l, v1.l
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v0.l, 0x300, v0.l
; GFX11-TRUE16-NEXT:    v_or_b16 v1.h, v4.l, v1.h
; GFX11-TRUE16-NEXT:    v_or_b16 v2.l, v3.l, v2.l
; GFX11-TRUE16-NEXT:    v_or_b16 v2.h, v3.h, v2.h
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v3.l, 0x300, v0.h
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v5.l, v0.l
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v0.l, 0x300, v1.l
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v1.l, 0x300, v1.h
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v2.l, 0x300, v2.l
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v4.l, 0x300, v2.h
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v5, 0xffff, v5
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v6, 0xffff, v0
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v0, v5, v3
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v1, v6, v1
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v2, v2, v4
; GFX11-TRUE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-FAKE16-LABEL: bitcast_v12i8_to_v3i32:
; GFX11-FAKE16:       ; %bb.0:
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-FAKE16-NEXT:    v_dual_mov_b32 v14, v2 :: v_dual_mov_b32 v13, v0
; GFX11-FAKE16-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v12
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v16, 8, v1
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v12, 8, v3
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v15, 8, v5
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v7, 8, v7
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v3, 8, v9
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v5, 8, v11
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2
; GFX11-FAKE16-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-FAKE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_cbranch_execnz .LBB6_3
; GFX11-FAKE16-NEXT:  ; %bb.1: ; %Flow
; GFX11-FAKE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-FAKE16-NEXT:    s_cbranch_execnz .LBB6_4
; GFX11-FAKE16-NEXT:  .LBB6_2: ; %end
; GFX11-FAKE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
; GFX11-FAKE16-NEXT:  .LBB6_3: ; %cmp.false
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v0, 0xff, v13
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v1, 0xff, v14
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v2, 0xff, v4
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v4, 0xff, v6
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v6, 0xff, v8
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v8, 0xff, v10
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v0, v0, v16
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v1, v1, v12
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v2, v2, v15
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v4, v4, v7
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v3, v6, v3
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v5, v8, v5
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr13
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr14
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr6
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr8
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr10
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr16
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr12
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr15
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr7
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v1, v2, v4
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr4
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v2, v3, v5
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr3
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr5
; GFX11-FAKE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-FAKE16-NEXT:    s_cbranch_execz .LBB6_2
; GFX11-FAKE16-NEXT:  .LBB6_4: ; %cmp.true
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v0, v13, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v1, v14, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v2, v4, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v4, v6, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v6, v8, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v8, v10, 3
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v1, 0xff, v1
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v2, 0xff, v2
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v4, 0xff, v4
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v6, 0xff, v6
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v8, 0xff, v8
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v0, v16, v0
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v1, v12, v1
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v2, v15, v2
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v4, v7, v4
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v3, v3, v6
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v5, v5, v8
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v0, 0x300, v0
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v1, 0x300, v1
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v2, 0x300, v2
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v4, 0x300, v4
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v3, 0x300, v3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v5, 0x300, v5
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v1, v2, v4
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v2, v3, v5
; GFX11-FAKE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <12 x i8> %a, splat (i8 3)
  %a2 = bitcast <12 x i8> %a1 to <3 x i32>
  br label %end

cmp.false:
  %a3 = bitcast <12 x i8> %a to <3 x i32>
  br label %end

end:
  %phi = phi <3 x i32> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <3 x i32> %phi
}

define inreg <3 x i32> @bitcast_v12i8_to_v3i32_scalar(<12 x i8> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v12i8_to_v3i32_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s28, 0
; SI-NEXT:    s_cbranch_scc0 .LBB7_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_and_b32 s4, s16, 0xff
; SI-NEXT:    s_lshl_b32 s5, s17, 8
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    s_and_b32 s5, s18, 0xff
; SI-NEXT:    s_lshl_b32 s5, s5, 16
; SI-NEXT:    s_lshl_b32 s6, s19, 24
; SI-NEXT:    s_and_b32 s4, s4, 0xffff
; SI-NEXT:    s_or_b32 s5, s6, s5
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    s_and_b32 s5, s20, 0xff
; SI-NEXT:    s_lshl_b32 s6, s21, 8
; SI-NEXT:    s_or_b32 s5, s5, s6
; SI-NEXT:    s_and_b32 s6, s22, 0xff
; SI-NEXT:    s_lshl_b32 s6, s6, 16
; SI-NEXT:    s_lshl_b32 s7, s23, 24
; SI-NEXT:    s_and_b32 s5, s5, 0xffff
; SI-NEXT:    s_or_b32 s6, s7, s6
; SI-NEXT:    s_or_b32 s5, s5, s6
; SI-NEXT:    s_and_b32 s6, s24, 0xff
; SI-NEXT:    s_lshl_b32 s7, s25, 8
; SI-NEXT:    s_or_b32 s6, s6, s7
; SI-NEXT:    s_and_b32 s7, s26, 0xff
; SI-NEXT:    s_lshl_b32 s7, s7, 16
; SI-NEXT:    s_lshl_b32 s8, s27, 24
; SI-NEXT:    s_and_b32 s6, s6, 0xffff
; SI-NEXT:    s_or_b32 s7, s8, s7
; SI-NEXT:    s_or_b32 s6, s6, s7
; SI-NEXT:    s_cbranch_execnz .LBB7_3
; SI-NEXT:  .LBB7_2: ; %cmp.true
; SI-NEXT:    s_add_i32 s16, s16, 3
; SI-NEXT:    s_and_b32 s4, s16, 0xff
; SI-NEXT:    s_lshl_b32 s5, s17, 8
; SI-NEXT:    s_add_i32 s18, s18, 3
; SI-NEXT:    s_or_b32 s4, s5, s4
; SI-NEXT:    s_and_b32 s6, s18, 0xff
; SI-NEXT:    s_addk_i32 s4, 0x300
; SI-NEXT:    s_lshl_b32 s5, s19, 24
; SI-NEXT:    s_lshl_b32 s6, s6, 16
; SI-NEXT:    s_and_b32 s4, s4, 0xffff
; SI-NEXT:    s_or_b32 s5, s5, s6
; SI-NEXT:    s_add_i32 s20, s20, 3
; SI-NEXT:    s_or_b32 s4, s5, s4
; SI-NEXT:    s_and_b32 s5, s20, 0xff
; SI-NEXT:    s_lshl_b32 s6, s21, 8
; SI-NEXT:    s_add_i32 s22, s22, 3
; SI-NEXT:    s_or_b32 s5, s6, s5
; SI-NEXT:    s_and_b32 s7, s22, 0xff
; SI-NEXT:    s_addk_i32 s5, 0x300
; SI-NEXT:    s_lshl_b32 s6, s23, 24
; SI-NEXT:    s_lshl_b32 s7, s7, 16
; SI-NEXT:    s_and_b32 s5, s5, 0xffff
; SI-NEXT:    s_or_b32 s6, s6, s7
; SI-NEXT:    s_add_i32 s24, s24, 3
; SI-NEXT:    s_or_b32 s5, s6, s5
; SI-NEXT:    s_and_b32 s6, s24, 0xff
; SI-NEXT:    s_lshl_b32 s7, s25, 8
; SI-NEXT:    s_add_i32 s26, s26, 3
; SI-NEXT:    s_or_b32 s6, s7, s6
; SI-NEXT:    s_and_b32 s8, s26, 0xff
; SI-NEXT:    s_addk_i32 s6, 0x300
; SI-NEXT:    s_lshl_b32 s7, s27, 24
; SI-NEXT:    s_lshl_b32 s8, s8, 16
; SI-NEXT:    s_and_b32 s6, s6, 0xffff
; SI-NEXT:    s_or_b32 s7, s7, s8
; SI-NEXT:    s_or_b32 s6, s7, s6
; SI-NEXT:    s_add_i32 s4, s4, 0x3000000
; SI-NEXT:    s_add_i32 s5, s5, 0x3000000
; SI-NEXT:    s_add_i32 s6, s6, 0x3000000
; SI-NEXT:  .LBB7_3: ; %end
; SI-NEXT:    v_mov_b32_e32 v0, s4
; SI-NEXT:    v_mov_b32_e32 v1, s5
; SI-NEXT:    v_mov_b32_e32 v2, s6
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB7_4:
; SI-NEXT:    ; implicit-def: $sgpr4_sgpr5_sgpr6
; SI-NEXT:    s_branch .LBB7_2
;
; VI-LABEL: bitcast_v12i8_to_v3i32_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s28, 0
; VI-NEXT:    s_cbranch_scc0 .LBB7_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_and_b32 s4, s16, 0xff
; VI-NEXT:    s_lshl_b32 s5, s17, 8
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_and_b32 s5, s18, 0xff
; VI-NEXT:    s_lshl_b32 s6, s19, 8
; VI-NEXT:    s_or_b32 s5, s5, s6
; VI-NEXT:    s_and_b32 s4, s4, 0xffff
; VI-NEXT:    s_lshl_b32 s5, s5, 16
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_and_b32 s5, s20, 0xff
; VI-NEXT:    s_lshl_b32 s6, s21, 8
; VI-NEXT:    s_or_b32 s5, s5, s6
; VI-NEXT:    s_and_b32 s6, s22, 0xff
; VI-NEXT:    s_lshl_b32 s7, s23, 8
; VI-NEXT:    s_or_b32 s6, s6, s7
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_lshl_b32 s6, s6, 16
; VI-NEXT:    s_or_b32 s5, s5, s6
; VI-NEXT:    s_and_b32 s6, s24, 0xff
; VI-NEXT:    s_lshl_b32 s7, s25, 8
; VI-NEXT:    s_or_b32 s6, s6, s7
; VI-NEXT:    s_and_b32 s7, s26, 0xff
; VI-NEXT:    s_lshl_b32 s8, s27, 8
; VI-NEXT:    s_or_b32 s7, s7, s8
; VI-NEXT:    s_and_b32 s6, s6, 0xffff
; VI-NEXT:    s_lshl_b32 s7, s7, 16
; VI-NEXT:    s_or_b32 s6, s6, s7
; VI-NEXT:    s_cbranch_execnz .LBB7_3
; VI-NEXT:  .LBB7_2: ; %cmp.true
; VI-NEXT:    s_add_i32 s16, s16, 3
; VI-NEXT:    s_and_b32 s4, s16, 0xff
; VI-NEXT:    s_lshl_b32 s5, s17, 8
; VI-NEXT:    s_add_i32 s18, s18, 3
; VI-NEXT:    s_or_b32 s4, s5, s4
; VI-NEXT:    s_and_b32 s5, s18, 0xff
; VI-NEXT:    s_lshl_b32 s6, s19, 8
; VI-NEXT:    s_addk_i32 s4, 0x300
; VI-NEXT:    s_or_b32 s5, s6, s5
; VI-NEXT:    s_and_b32 s4, s4, 0xffff
; VI-NEXT:    s_lshl_b32 s5, s5, 16
; VI-NEXT:    s_add_i32 s20, s20, 3
; VI-NEXT:    s_or_b32 s4, s5, s4
; VI-NEXT:    s_and_b32 s5, s20, 0xff
; VI-NEXT:    s_lshl_b32 s6, s21, 8
; VI-NEXT:    s_add_i32 s22, s22, 3
; VI-NEXT:    s_or_b32 s5, s6, s5
; VI-NEXT:    s_and_b32 s6, s22, 0xff
; VI-NEXT:    s_lshl_b32 s7, s23, 8
; VI-NEXT:    s_addk_i32 s5, 0x300
; VI-NEXT:    s_or_b32 s6, s7, s6
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_lshl_b32 s6, s6, 16
; VI-NEXT:    s_add_i32 s24, s24, 3
; VI-NEXT:    s_or_b32 s5, s6, s5
; VI-NEXT:    s_and_b32 s6, s24, 0xff
; VI-NEXT:    s_lshl_b32 s7, s25, 8
; VI-NEXT:    s_add_i32 s26, s26, 3
; VI-NEXT:    s_or_b32 s6, s7, s6
; VI-NEXT:    s_and_b32 s7, s26, 0xff
; VI-NEXT:    s_lshl_b32 s8, s27, 8
; VI-NEXT:    s_addk_i32 s6, 0x300
; VI-NEXT:    s_or_b32 s7, s8, s7
; VI-NEXT:    s_and_b32 s6, s6, 0xffff
; VI-NEXT:    s_lshl_b32 s7, s7, 16
; VI-NEXT:    s_or_b32 s6, s7, s6
; VI-NEXT:    s_add_i32 s4, s4, 0x3000000
; VI-NEXT:    s_add_i32 s5, s5, 0x3000000
; VI-NEXT:    s_add_i32 s6, s6, 0x3000000
; VI-NEXT:  .LBB7_3: ; %end
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    v_mov_b32_e32 v1, s5
; VI-NEXT:    v_mov_b32_e32 v2, s6
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB7_4:
; VI-NEXT:    ; implicit-def: $sgpr4_sgpr5_sgpr6
; VI-NEXT:    s_branch .LBB7_2
;
; GFX9-LABEL: bitcast_v12i8_to_v3i32_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s28, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB7_4
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_and_b32 s4, s16, 0xff
; GFX9-NEXT:    s_lshl_b32 s5, s17, 8
; GFX9-NEXT:    s_or_b32 s4, s4, s5
; GFX9-NEXT:    s_and_b32 s5, s18, 0xff
; GFX9-NEXT:    s_lshl_b32 s6, s19, 8
; GFX9-NEXT:    s_or_b32 s5, s5, s6
; GFX9-NEXT:    s_and_b32 s4, s4, 0xffff
; GFX9-NEXT:    s_lshl_b32 s5, s5, 16
; GFX9-NEXT:    s_or_b32 s4, s4, s5
; GFX9-NEXT:    s_and_b32 s5, s20, 0xff
; GFX9-NEXT:    s_lshl_b32 s6, s21, 8
; GFX9-NEXT:    s_or_b32 s5, s5, s6
; GFX9-NEXT:    s_and_b32 s6, s22, 0xff
; GFX9-NEXT:    s_lshl_b32 s7, s23, 8
; GFX9-NEXT:    s_or_b32 s6, s6, s7
; GFX9-NEXT:    s_and_b32 s5, s5, 0xffff
; GFX9-NEXT:    s_lshl_b32 s6, s6, 16
; GFX9-NEXT:    s_or_b32 s5, s5, s6
; GFX9-NEXT:    s_and_b32 s6, s24, 0xff
; GFX9-NEXT:    s_lshl_b32 s7, s25, 8
; GFX9-NEXT:    s_or_b32 s6, s6, s7
; GFX9-NEXT:    s_and_b32 s7, s26, 0xff
; GFX9-NEXT:    s_lshl_b32 s8, s27, 8
; GFX9-NEXT:    s_or_b32 s7, s7, s8
; GFX9-NEXT:    s_and_b32 s6, s6, 0xffff
; GFX9-NEXT:    s_lshl_b32 s7, s7, 16
; GFX9-NEXT:    s_or_b32 s6, s6, s7
; GFX9-NEXT:    s_cbranch_execnz .LBB7_3
; GFX9-NEXT:  .LBB7_2: ; %cmp.true
; GFX9-NEXT:    s_add_i32 s16, s16, 3
; GFX9-NEXT:    s_and_b32 s4, s16, 0xff
; GFX9-NEXT:    s_lshl_b32 s5, s17, 8
; GFX9-NEXT:    s_add_i32 s18, s18, 3
; GFX9-NEXT:    s_or_b32 s4, s5, s4
; GFX9-NEXT:    s_and_b32 s5, s18, 0xff
; GFX9-NEXT:    s_lshl_b32 s6, s19, 8
; GFX9-NEXT:    s_or_b32 s5, s6, s5
; GFX9-NEXT:    s_addk_i32 s4, 0x300
; GFX9-NEXT:    s_addk_i32 s5, 0x300
; GFX9-NEXT:    s_and_b32 s4, s4, 0xffff
; GFX9-NEXT:    s_lshl_b32 s5, s5, 16
; GFX9-NEXT:    s_add_i32 s20, s20, 3
; GFX9-NEXT:    s_or_b32 s4, s4, s5
; GFX9-NEXT:    s_and_b32 s5, s20, 0xff
; GFX9-NEXT:    s_lshl_b32 s6, s21, 8
; GFX9-NEXT:    s_add_i32 s22, s22, 3
; GFX9-NEXT:    s_or_b32 s5, s6, s5
; GFX9-NEXT:    s_and_b32 s6, s22, 0xff
; GFX9-NEXT:    s_lshl_b32 s7, s23, 8
; GFX9-NEXT:    s_or_b32 s6, s7, s6
; GFX9-NEXT:    s_addk_i32 s5, 0x300
; GFX9-NEXT:    s_addk_i32 s6, 0x300
; GFX9-NEXT:    s_and_b32 s5, s5, 0xffff
; GFX9-NEXT:    s_lshl_b32 s6, s6, 16
; GFX9-NEXT:    s_add_i32 s24, s24, 3
; GFX9-NEXT:    s_or_b32 s5, s5, s6
; GFX9-NEXT:    s_and_b32 s6, s24, 0xff
; GFX9-NEXT:    s_lshl_b32 s7, s25, 8
; GFX9-NEXT:    s_add_i32 s26, s26, 3
; GFX9-NEXT:    s_or_b32 s6, s7, s6
; GFX9-NEXT:    s_and_b32 s7, s26, 0xff
; GFX9-NEXT:    s_lshl_b32 s8, s27, 8
; GFX9-NEXT:    s_or_b32 s7, s8, s7
; GFX9-NEXT:    s_addk_i32 s6, 0x300
; GFX9-NEXT:    s_addk_i32 s7, 0x300
; GFX9-NEXT:    s_and_b32 s6, s6, 0xffff
; GFX9-NEXT:    s_lshl_b32 s7, s7, 16
; GFX9-NEXT:    s_or_b32 s6, s6, s7
; GFX9-NEXT:  .LBB7_3: ; %end
; GFX9-NEXT:    v_mov_b32_e32 v0, s4
; GFX9-NEXT:    v_mov_b32_e32 v1, s5
; GFX9-NEXT:    v_mov_b32_e32 v2, s6
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB7_4:
; GFX9-NEXT:    ; implicit-def: $sgpr4_sgpr5_sgpr6
; GFX9-NEXT:    s_branch .LBB7_2
;
; GFX11-LABEL: bitcast_v12i8_to_v3i32_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_cmp_lg_u32 s24, 0
; GFX11-NEXT:    s_mov_b32 s7, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB7_4
; GFX11-NEXT:  ; %bb.1: ; %cmp.false
; GFX11-NEXT:    s_and_b32 s4, s0, 0xff
; GFX11-NEXT:    s_lshl_b32 s5, s1, 8
; GFX11-NEXT:    s_and_b32 s6, s2, 0xff
; GFX11-NEXT:    s_lshl_b32 s8, s3, 8
; GFX11-NEXT:    s_or_b32 s4, s4, s5
; GFX11-NEXT:    s_or_b32 s5, s6, s8
; GFX11-NEXT:    s_and_b32 s4, s4, 0xffff
; GFX11-NEXT:    s_lshl_b32 s5, s5, 16
; GFX11-NEXT:    s_lshl_b32 s6, s17, 8
; GFX11-NEXT:    s_or_b32 s4, s4, s5
; GFX11-NEXT:    s_and_b32 s5, s16, 0xff
; GFX11-NEXT:    s_and_b32 s8, s18, 0xff
; GFX11-NEXT:    s_lshl_b32 s9, s19, 8
; GFX11-NEXT:    s_or_b32 s5, s5, s6
; GFX11-NEXT:    s_or_b32 s6, s8, s9
; GFX11-NEXT:    s_and_b32 s8, s20, 0xff
; GFX11-NEXT:    s_lshl_b32 s9, s21, 8
; GFX11-NEXT:    s_and_b32 s10, s22, 0xff
; GFX11-NEXT:    s_lshl_b32 s11, s23, 8
; GFX11-NEXT:    s_or_b32 s8, s8, s9
; GFX11-NEXT:    s_or_b32 s9, s10, s11
; GFX11-NEXT:    s_and_b32 s5, s5, 0xffff
; GFX11-NEXT:    s_lshl_b32 s6, s6, 16
; GFX11-NEXT:    s_and_b32 s8, s8, 0xffff
; GFX11-NEXT:    s_lshl_b32 s9, s9, 16
; GFX11-NEXT:    s_or_b32 s5, s5, s6
; GFX11-NEXT:    s_or_b32 s6, s8, s9
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s7
; GFX11-NEXT:    s_cbranch_vccnz .LBB7_3
; GFX11-NEXT:  .LBB7_2: ; %cmp.true
; GFX11-NEXT:    s_add_i32 s0, s0, 3
; GFX11-NEXT:    s_add_i32 s2, s2, 3
; GFX11-NEXT:    s_and_b32 s0, s0, 0xff
; GFX11-NEXT:    s_lshl_b32 s1, s1, 8
; GFX11-NEXT:    s_and_b32 s2, s2, 0xff
; GFX11-NEXT:    s_lshl_b32 s3, s3, 8
; GFX11-NEXT:    s_or_b32 s0, s1, s0
; GFX11-NEXT:    s_or_b32 s1, s3, s2
; GFX11-NEXT:    s_addk_i32 s0, 0x300
; GFX11-NEXT:    s_addk_i32 s1, 0x300
; GFX11-NEXT:    s_and_b32 s0, s0, 0xffff
; GFX11-NEXT:    s_lshl_b32 s1, s1, 16
; GFX11-NEXT:    s_add_i32 s16, s16, 3
; GFX11-NEXT:    s_or_b32 s4, s0, s1
; GFX11-NEXT:    s_and_b32 s0, s16, 0xff
; GFX11-NEXT:    s_lshl_b32 s1, s17, 8
; GFX11-NEXT:    s_add_i32 s18, s18, 3
; GFX11-NEXT:    s_or_b32 s0, s1, s0
; GFX11-NEXT:    s_and_b32 s1, s18, 0xff
; GFX11-NEXT:    s_lshl_b32 s2, s19, 8
; GFX11-NEXT:    s_add_i32 s20, s20, 3
; GFX11-NEXT:    s_add_i32 s22, s22, 3
; GFX11-NEXT:    s_or_b32 s1, s2, s1
; GFX11-NEXT:    s_and_b32 s2, s20, 0xff
; GFX11-NEXT:    s_lshl_b32 s3, s21, 8
; GFX11-NEXT:    s_and_b32 s5, s22, 0xff
; GFX11-NEXT:    s_lshl_b32 s6, s23, 8
; GFX11-NEXT:    s_or_b32 s2, s3, s2
; GFX11-NEXT:    s_or_b32 s3, s6, s5
; GFX11-NEXT:    s_addk_i32 s0, 0x300
; GFX11-NEXT:    s_addk_i32 s1, 0x300
; GFX11-NEXT:    s_addk_i32 s2, 0x300
; GFX11-NEXT:    s_addk_i32 s3, 0x300
; GFX11-NEXT:    s_and_b32 s0, s0, 0xffff
; GFX11-NEXT:    s_lshl_b32 s1, s1, 16
; GFX11-NEXT:    s_and_b32 s2, s2, 0xffff
; GFX11-NEXT:    s_lshl_b32 s3, s3, 16
; GFX11-NEXT:    s_or_b32 s5, s0, s1
; GFX11-NEXT:    s_or_b32 s6, s2, s3
; GFX11-NEXT:  .LBB7_3: ; %end
; GFX11-NEXT:    v_dual_mov_b32 v0, s4 :: v_dual_mov_b32 v1, s5
; GFX11-NEXT:    v_mov_b32_e32 v2, s6
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB7_4:
; GFX11-NEXT:    ; implicit-def: $sgpr4_sgpr5_sgpr6
; GFX11-NEXT:    s_branch .LBB7_2
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <12 x i8> %a, splat (i8 3)
  %a2 = bitcast <12 x i8> %a1 to <3 x i32>
  br label %end

cmp.false:
  %a3 = bitcast <12 x i8> %a to <3 x i32>
  br label %end

end:
  %phi = phi <3 x i32> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <3 x i32> %phi
}

define <6 x bfloat> @bitcast_v3i32_to_v6bf16(<3 x i32> %a, i32 %b) {
; SI-LABEL: bitcast_v3i32_to_v6bf16:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v8, v2
; SI-NEXT:    v_mov_b32_e32 v7, v1
; SI-NEXT:    v_mov_b32_e32 v6, v0
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v3
; SI-NEXT:    ; implicit-def: $vgpr0
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    ; implicit-def: $vgpr4
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB8_3
; SI-NEXT:  ; %bb.1: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB8_4
; SI-NEXT:  .LBB8_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB8_3: ; %cmp.false
; SI-NEXT:    v_and_b32_e32 v5, 0xffff0000, v8
; SI-NEXT:    v_lshlrev_b32_e32 v4, 16, v8
; SI-NEXT:    v_and_b32_e32 v3, 0xffff0000, v7
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v7
; SI-NEXT:    v_and_b32_e32 v1, 0xffff0000, v6
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v6
; SI-NEXT:    ; implicit-def: $vgpr6
; SI-NEXT:    ; implicit-def: $vgpr7
; SI-NEXT:    ; implicit-def: $vgpr8
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB8_2
; SI-NEXT:  .LBB8_4: ; %cmp.true
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v6
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v7
; SI-NEXT:    v_add_i32_e32 v2, vcc, 3, v8
; SI-NEXT:    v_and_b32_e32 v5, 0xffff0000, v2
; SI-NEXT:    v_lshlrev_b32_e32 v4, 16, v2
; SI-NEXT:    v_and_b32_e32 v3, 0xffff0000, v1
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v1
; SI-NEXT:    v_and_b32_e32 v1, 0xffff0000, v0
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v3i32_to_v6bf16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v3
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_add_u32_e32 v2, vcc, 3, v2
; VI-NEXT:    v_add_u32_e32 v1, vcc, 3, v1
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v0
; VI-NEXT:  ; %bb.2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v3i32_to_v6bf16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v3
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_add_u32_e32 v2, 3, v2
; GFX9-NEXT:    v_add_u32_e32 v1, 3, v1
; GFX9-NEXT:    v_add_u32_e32 v0, 3, v0
; GFX9-NEXT:  ; %bb.2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v3i32_to_v6bf16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v3
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_add_nc_u32_e32 v2, 3, v2
; GFX11-NEXT:    v_add_nc_u32_e32 v1, 3, v1
; GFX11-NEXT:    v_add_nc_u32_e32 v0, 3, v0
; GFX11-NEXT:  ; %bb.2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <3 x i32> %a, splat (i32 3)
  %a2 = bitcast <3 x i32> %a1 to <6 x bfloat>
  br label %end

cmp.false:
  %a3 = bitcast <3 x i32> %a to <6 x bfloat>
  br label %end

end:
  %phi = phi <6 x bfloat> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <6 x bfloat> %phi
}

define inreg <6 x bfloat> @bitcast_v3i32_to_v6bf16_scalar(<3 x i32> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v3i32_to_v6bf16_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s19, 0
; SI-NEXT:    s_cbranch_scc0 .LBB9_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_and_b32 s6, s18, 0xffff0000
; SI-NEXT:    s_lshl_b32 s7, s18, 16
; SI-NEXT:    s_and_b32 s8, s17, 0xffff0000
; SI-NEXT:    s_lshl_b32 s9, s17, 16
; SI-NEXT:    s_and_b32 s10, s16, 0xffff0000
; SI-NEXT:    s_lshl_b32 s11, s16, 16
; SI-NEXT:    s_cbranch_execnz .LBB9_3
; SI-NEXT:  .LBB9_2: ; %cmp.true
; SI-NEXT:    s_add_i32 s16, s16, 3
; SI-NEXT:    s_add_i32 s17, s17, 3
; SI-NEXT:    s_add_i32 s18, s18, 3
; SI-NEXT:    s_and_b32 s6, s18, 0xffff0000
; SI-NEXT:    s_lshl_b32 s7, s18, 16
; SI-NEXT:    s_and_b32 s8, s17, 0xffff0000
; SI-NEXT:    s_lshl_b32 s9, s17, 16
; SI-NEXT:    s_and_b32 s10, s16, 0xffff0000
; SI-NEXT:    s_lshl_b32 s11, s16, 16
; SI-NEXT:  .LBB9_3: ; %end
; SI-NEXT:    v_mov_b32_e32 v0, s11
; SI-NEXT:    v_mov_b32_e32 v1, s10
; SI-NEXT:    v_mov_b32_e32 v2, s9
; SI-NEXT:    v_mov_b32_e32 v3, s8
; SI-NEXT:    v_mov_b32_e32 v4, s7
; SI-NEXT:    v_mov_b32_e32 v5, s6
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB9_4:
; SI-NEXT:    ; implicit-def: $sgpr11
; SI-NEXT:    ; implicit-def: $sgpr10
; SI-NEXT:    ; implicit-def: $sgpr9
; SI-NEXT:    ; implicit-def: $sgpr8
; SI-NEXT:    ; implicit-def: $sgpr7
; SI-NEXT:    ; implicit-def: $sgpr6
; SI-NEXT:    s_branch .LBB9_2
;
; VI-LABEL: bitcast_v3i32_to_v6bf16_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s19, 0
; VI-NEXT:    s_cbranch_scc0 .LBB9_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB9_3
; VI-NEXT:  .LBB9_2: ; %cmp.true
; VI-NEXT:    s_add_i32 s18, s18, 3
; VI-NEXT:    s_add_i32 s17, s17, 3
; VI-NEXT:    s_add_i32 s16, s16, 3
; VI-NEXT:  .LBB9_3: ; %end
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    v_mov_b32_e32 v2, s18
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB9_4:
; VI-NEXT:    s_branch .LBB9_2
;
; GFX9-LABEL: bitcast_v3i32_to_v6bf16_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s19, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB9_4
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB9_3
; GFX9-NEXT:  .LBB9_2: ; %cmp.true
; GFX9-NEXT:    s_add_i32 s18, s18, 3
; GFX9-NEXT:    s_add_i32 s17, s17, 3
; GFX9-NEXT:    s_add_i32 s16, s16, 3
; GFX9-NEXT:  .LBB9_3: ; %end
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB9_4:
; GFX9-NEXT:    s_branch .LBB9_2
;
; GFX11-LABEL: bitcast_v3i32_to_v6bf16_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_cmp_lg_u32 s3, 0
; GFX11-NEXT:    s_mov_b32 s3, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB9_4
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s3
; GFX11-NEXT:    s_cbranch_vccnz .LBB9_3
; GFX11-NEXT:  .LBB9_2: ; %cmp.true
; GFX11-NEXT:    s_add_i32 s2, s2, 3
; GFX11-NEXT:    s_add_i32 s1, s1, 3
; GFX11-NEXT:    s_add_i32 s0, s0, 3
; GFX11-NEXT:  .LBB9_3: ; %end
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_mov_b32_e32 v2, s2
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB9_4:
; GFX11-NEXT:    s_branch .LBB9_2
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <3 x i32> %a, splat (i32 3)
  %a2 = bitcast <3 x i32> %a1 to <6 x bfloat>
  br label %end

cmp.false:
  %a3 = bitcast <3 x i32> %a to <6 x bfloat>
  br label %end

end:
  %phi = phi <6 x bfloat> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <6 x bfloat> %phi
}

define <3 x i32> @bitcast_v6bf16_to_v3i32(<6 x bfloat> %a, i32 %b) {
; SI-LABEL: bitcast_v6bf16_to_v3i32:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v6
; SI-NEXT:    v_mul_f32_e32 v8, 1.0, v1
; SI-NEXT:    v_mul_f32_e32 v9, 1.0, v0
; SI-NEXT:    v_mul_f32_e32 v6, 1.0, v3
; SI-NEXT:    v_mul_f32_e32 v7, 1.0, v2
; SI-NEXT:    v_mul_f32_e32 v3, 1.0, v5
; SI-NEXT:    v_mul_f32_e32 v4, 1.0, v4
; SI-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB10_3
; SI-NEXT:  ; %bb.1: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB10_4
; SI-NEXT:  .LBB10_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB10_3: ; %cmp.false
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v8
; SI-NEXT:    v_lshrrev_b32_e32 v1, 16, v6
; SI-NEXT:    v_lshrrev_b32_e32 v2, 16, v3
; SI-NEXT:    v_alignbit_b32 v0, v0, v9, 16
; SI-NEXT:    v_alignbit_b32 v1, v1, v7, 16
; SI-NEXT:    v_alignbit_b32 v2, v2, v4, 16
; SI-NEXT:    ; implicit-def: $vgpr9
; SI-NEXT:    ; implicit-def: $vgpr8
; SI-NEXT:    ; implicit-def: $vgpr7
; SI-NEXT:    ; implicit-def: $vgpr6
; SI-NEXT:    ; implicit-def: $vgpr4
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB10_2
; SI-NEXT:  .LBB10_4: ; %cmp.true
; SI-NEXT:    v_and_b32_e32 v1, 0xffff0000, v8
; SI-NEXT:    v_and_b32_e32 v0, 0xffff0000, v9
; SI-NEXT:    v_add_f32_e32 v1, 0x40c00000, v1
; SI-NEXT:    v_add_f32_e32 v0, 0x40c00000, v0
; SI-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_and_b32_e32 v2, 0xffff0000, v6
; SI-NEXT:    v_alignbit_b32 v0, v1, v0, 16
; SI-NEXT:    v_and_b32_e32 v1, 0xffff0000, v7
; SI-NEXT:    v_add_f32_e32 v2, 0x40c00000, v2
; SI-NEXT:    v_add_f32_e32 v1, 0x40c00000, v1
; SI-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_and_b32_e32 v3, 0xffff0000, v3
; SI-NEXT:    v_alignbit_b32 v1, v2, v1, 16
; SI-NEXT:    v_and_b32_e32 v2, 0xffff0000, v4
; SI-NEXT:    v_add_f32_e32 v3, 0x40c00000, v3
; SI-NEXT:    v_add_f32_e32 v2, 0x40c00000, v2
; SI-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; SI-NEXT:    v_alignbit_b32 v2, v3, v2, 16
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v6bf16_to_v3i32:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v3
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB10_2
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_lshlrev_b32_e32 v3, 16, v2
; VI-NEXT:    v_add_f32_e32 v3, 0x40c00000, v3
; VI-NEXT:    v_bfe_u32 v4, v3, 16, 1
; VI-NEXT:    v_add_u32_e32 v4, vcc, v4, v3
; VI-NEXT:    v_add_u32_e32 v4, vcc, 0x7fff, v4
; VI-NEXT:    v_and_b32_e32 v2, 0xffff0000, v2
; VI-NEXT:    v_or_b32_e32 v5, 0x400000, v3
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v3, v3
; VI-NEXT:    v_add_f32_e32 v2, 0x40c00000, v2
; VI-NEXT:    v_cndmask_b32_e32 v3, v4, v5, vcc
; VI-NEXT:    v_bfe_u32 v4, v2, 16, 1
; VI-NEXT:    s_movk_i32 s6, 0x7fff
; VI-NEXT:    v_add_u32_e32 v4, vcc, v4, v2
; VI-NEXT:    v_add_u32_e32 v4, vcc, s6, v4
; VI-NEXT:    v_or_b32_e32 v5, 0x400000, v2
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; VI-NEXT:    v_cndmask_b32_e32 v2, v4, v5, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; VI-NEXT:    v_alignbit_b32 v2, v2, v3, 16
; VI-NEXT:    v_lshlrev_b32_e32 v3, 16, v1
; VI-NEXT:    v_add_f32_e32 v3, 0x40c00000, v3
; VI-NEXT:    v_bfe_u32 v4, v3, 16, 1
; VI-NEXT:    v_add_u32_e32 v4, vcc, v4, v3
; VI-NEXT:    v_add_u32_e32 v4, vcc, s6, v4
; VI-NEXT:    v_and_b32_e32 v1, 0xffff0000, v1
; VI-NEXT:    v_or_b32_e32 v5, 0x400000, v3
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v3, v3
; VI-NEXT:    v_add_f32_e32 v1, 0x40c00000, v1
; VI-NEXT:    v_cndmask_b32_e32 v3, v4, v5, vcc
; VI-NEXT:    v_bfe_u32 v4, v1, 16, 1
; VI-NEXT:    v_add_u32_e32 v4, vcc, v4, v1
; VI-NEXT:    v_add_u32_e32 v4, vcc, s6, v4
; VI-NEXT:    v_or_b32_e32 v5, 0x400000, v1
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; VI-NEXT:    v_cndmask_b32_e32 v1, v4, v5, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; VI-NEXT:    v_alignbit_b32 v1, v1, v3, 16
; VI-NEXT:    v_lshlrev_b32_e32 v3, 16, v0
; VI-NEXT:    v_add_f32_e32 v3, 0x40c00000, v3
; VI-NEXT:    v_bfe_u32 v4, v3, 16, 1
; VI-NEXT:    v_add_u32_e32 v4, vcc, v4, v3
; VI-NEXT:    v_add_u32_e32 v4, vcc, s6, v4
; VI-NEXT:    v_and_b32_e32 v0, 0xffff0000, v0
; VI-NEXT:    v_or_b32_e32 v5, 0x400000, v3
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v3, v3
; VI-NEXT:    v_add_f32_e32 v0, 0x40c00000, v0
; VI-NEXT:    v_cndmask_b32_e32 v3, v4, v5, vcc
; VI-NEXT:    v_bfe_u32 v4, v0, 16, 1
; VI-NEXT:    v_add_u32_e32 v4, vcc, v4, v0
; VI-NEXT:    v_add_u32_e32 v4, vcc, 0x7fff, v4
; VI-NEXT:    v_or_b32_e32 v5, 0x400000, v0
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v0, v0
; VI-NEXT:    v_cndmask_b32_e32 v0, v4, v5, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; VI-NEXT:    v_alignbit_b32 v0, v0, v3, 16
; VI-NEXT:  .LBB10_2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v6bf16_to_v3i32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v3
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB10_2
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_and_b32_e32 v3, 0xffff0000, v2
; GFX9-NEXT:    v_add_f32_e32 v3, 0x40c00000, v3
; GFX9-NEXT:    v_bfe_u32 v4, v3, 16, 1
; GFX9-NEXT:    s_movk_i32 s6, 0x7fff
; GFX9-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX9-NEXT:    v_add3_u32 v4, v4, v3, s6
; GFX9-NEXT:    v_or_b32_e32 v5, 0x400000, v3
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v3, v3
; GFX9-NEXT:    v_add_f32_e32 v2, 0x40c00000, v2
; GFX9-NEXT:    v_cndmask_b32_e32 v3, v4, v5, vcc
; GFX9-NEXT:    v_bfe_u32 v4, v2, 16, 1
; GFX9-NEXT:    v_add3_u32 v4, v4, v2, s6
; GFX9-NEXT:    v_or_b32_e32 v5, 0x400000, v2
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; GFX9-NEXT:    v_cndmask_b32_e32 v2, v4, v5, vcc
; GFX9-NEXT:    s_mov_b32 s7, 0x7060302
; GFX9-NEXT:    v_perm_b32 v2, v3, v2, s7
; GFX9-NEXT:    v_and_b32_e32 v3, 0xffff0000, v1
; GFX9-NEXT:    v_add_f32_e32 v3, 0x40c00000, v3
; GFX9-NEXT:    v_bfe_u32 v4, v3, 16, 1
; GFX9-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX9-NEXT:    v_add3_u32 v4, v4, v3, s6
; GFX9-NEXT:    v_or_b32_e32 v5, 0x400000, v3
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v3, v3
; GFX9-NEXT:    v_add_f32_e32 v1, 0x40c00000, v1
; GFX9-NEXT:    v_cndmask_b32_e32 v3, v4, v5, vcc
; GFX9-NEXT:    v_bfe_u32 v4, v1, 16, 1
; GFX9-NEXT:    v_add3_u32 v4, v4, v1, s6
; GFX9-NEXT:    v_or_b32_e32 v5, 0x400000, v1
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v4, v5, vcc
; GFX9-NEXT:    v_perm_b32 v1, v3, v1, s7
; GFX9-NEXT:    v_and_b32_e32 v3, 0xffff0000, v0
; GFX9-NEXT:    v_add_f32_e32 v3, 0x40c00000, v3
; GFX9-NEXT:    v_bfe_u32 v4, v3, 16, 1
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX9-NEXT:    v_add3_u32 v4, v4, v3, s6
; GFX9-NEXT:    v_or_b32_e32 v5, 0x400000, v3
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v3, v3
; GFX9-NEXT:    v_add_f32_e32 v0, 0x40c00000, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v3, v4, v5, vcc
; GFX9-NEXT:    v_bfe_u32 v4, v0, 16, 1
; GFX9-NEXT:    v_add3_u32 v4, v4, v0, s6
; GFX9-NEXT:    v_or_b32_e32 v5, 0x400000, v0
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v0, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v4, v5, vcc
; GFX9-NEXT:    v_perm_b32 v0, v3, v0, s7
; GFX9-NEXT:  .LBB10_2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-TRUE16-LABEL: bitcast_v6bf16_to_v3i32:
; GFX11-TRUE16:       ; %bb.0:
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-TRUE16-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-TRUE16-NEXT:    v_cmpx_ne_u32_e32 0, v3
; GFX11-TRUE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-TRUE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-TRUE16-NEXT:    s_cbranch_execz .LBB10_2
; GFX11-TRUE16-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v4, 0xffff0000, v1
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-TRUE16-NEXT:    v_dual_add_f32 v4, 0x40c00000, v4 :: v_dual_lshlrev_b32 v3, 16, v2
; GFX11-TRUE16-NEXT:    v_add_f32_e32 v3, 0x40c00000, v3
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-TRUE16-NEXT:    v_bfe_u32 v10, v4, 16, 1
; GFX11-TRUE16-NEXT:    v_bfe_u32 v6, v3, 16, 1
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v8, 0x400000, v3
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v3, v3
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-TRUE16-NEXT:    v_add3_u32 v6, v6, v3, 0x7fff
; GFX11-TRUE16-NEXT:    v_dual_cndmask_b32 v3, v6, v8 :: v_dual_and_b32 v2, 0xffff0000, v2
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX11-TRUE16-NEXT:    v_dual_add_f32 v2, 0x40c00000, v2 :: v_dual_lshlrev_b32 v1, 16, v1
; GFX11-TRUE16-NEXT:    v_add3_u32 v8, v10, v4, 0x7fff
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v3.l, v3.h
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX11-TRUE16-NEXT:    v_bfe_u32 v7, v2, 16, 1
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v9, 0x400000, v2
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v2, v2
; GFX11-TRUE16-NEXT:    v_add3_u32 v7, v7, v2, 0x7fff
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v5, 0xffff0000, v0
; GFX11-TRUE16-NEXT:    v_dual_add_f32 v1, 0x40c00000, v1 :: v_dual_lshlrev_b32 v0, 16, v0
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX11-TRUE16-NEXT:    v_cndmask_b32_e32 v2, v7, v9, vcc_lo
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v9, 0x400000, v4
; GFX11-TRUE16-NEXT:    v_add_f32_e32 v0, 0x40c00000, v0
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_bfe_u32 v6, v1, 16, 1
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v10, 0x400000, v1
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v1, v1
; GFX11-TRUE16-NEXT:    v_bfi_b32 v2, 0xffff, v3, v2
; GFX11-TRUE16-NEXT:    v_bfe_u32 v7, v0, 16, 1
; GFX11-TRUE16-NEXT:    v_add3_u32 v6, v6, v1, 0x7fff
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v12, 0x400000, v0
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-TRUE16-NEXT:    v_add3_u32 v7, v7, v0, 0x7fff
; GFX11-TRUE16-NEXT:    v_cndmask_b32_e32 v1, v6, v10, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v0, v0
; GFX11-TRUE16-NEXT:    v_add_f32_e32 v5, 0x40c00000, v5
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v1.l, v1.h
; GFX11-TRUE16-NEXT:    v_cndmask_b32_e32 v0, v7, v12, vcc_lo
; GFX11-TRUE16-NEXT:    v_bfe_u32 v11, v5, 16, 1
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v4, v4
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v10, 0x400000, v5
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v0.l, v0.h
; GFX11-TRUE16-NEXT:    v_add3_u32 v6, v11, v5, 0x7fff
; GFX11-TRUE16-NEXT:    v_cndmask_b32_e32 v4, v8, v9, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v5, v5
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-TRUE16-NEXT:    v_cndmask_b32_e32 v5, v6, v10, vcc_lo
; GFX11-TRUE16-NEXT:    v_bfi_b32 v1, 0xffff, v1, v4
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-TRUE16-NEXT:    v_bfi_b32 v0, 0xffff, v0, v5
; GFX11-TRUE16-NEXT:  .LBB10_2: ; %end
; GFX11-TRUE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-FAKE16-LABEL: bitcast_v6bf16_to_v3i32:
; GFX11-FAKE16:       ; %bb.0:
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-FAKE16-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-FAKE16-NEXT:    v_cmpx_ne_u32_e32 0, v3
; GFX11-FAKE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-FAKE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-FAKE16-NEXT:    s_cbranch_execz .LBB10_2
; GFX11-FAKE16-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v3, 0xffff0000, v2
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_dual_add_f32 v3, 0x40c00000, v3 :: v_dual_lshlrev_b32 v2, 16, v2
; GFX11-FAKE16-NEXT:    v_add_f32_e32 v2, 0x40c00000, v2
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_2) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_bfe_u32 v6, v3, 16, 1
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v8, 0x400000, v3
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v3, v3
; GFX11-FAKE16-NEXT:    v_bfe_u32 v7, v2, 16, 1
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v9, 0x400000, v2
; GFX11-FAKE16-NEXT:    v_add3_u32 v6, v6, v3, 0x7fff
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v4, 0xffff0000, v1
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX11-FAKE16-NEXT:    v_add3_u32 v7, v7, v2, 0x7fff
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v3, v6, v8, vcc_lo
; GFX11-FAKE16-NEXT:    v_add_f32_e32 v4, 0x40c00000, v4
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v2, v2
; GFX11-FAKE16-NEXT:    v_add_f32_e32 v1, 0x40c00000, v1
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_bfe_u32 v10, v4, 16, 1
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v2, v7, v9, vcc_lo
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v7, 0x400000, v4
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v4, v4
; GFX11-FAKE16-NEXT:    v_bfe_u32 v8, v1, 16, 1
; GFX11-FAKE16-NEXT:    v_add3_u32 v6, v10, v4, 0x7fff
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v5, 0xffff0000, v0
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX11-FAKE16-NEXT:    v_perm_b32 v2, v3, v2, 0x7060302
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_3) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v4, v6, v7 :: v_dual_add_f32 v5, 0x40c00000, v5
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v1, v1
; GFX11-FAKE16-NEXT:    v_add3_u32 v7, v8, v1, 0x7fff
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v8, 0x400000, v1
; GFX11-FAKE16-NEXT:    v_bfe_u32 v9, v5, 16, 1
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v10, 0x400000, v5
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v1, v7, v8, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v5, v5
; GFX11-FAKE16-NEXT:    v_add3_u32 v9, v9, v5, 0x7fff
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_dual_add_f32 v0, 0x40c00000, v0 :: v_dual_cndmask_b32 v5, v9, v10
; GFX11-FAKE16-NEXT:    v_bfe_u32 v6, v0, 16, 1
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v11, 0x400000, v0
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v0, v0
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_add3_u32 v6, v6, v0, 0x7fff
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v6, v11, vcc_lo
; GFX11-FAKE16-NEXT:    v_perm_b32 v1, v4, v1, 0x7060302
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_perm_b32 v0, v5, v0, 0x7060302
; GFX11-FAKE16-NEXT:  .LBB10_2: ; %end
; GFX11-FAKE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <6 x bfloat> %a, splat (bfloat 0xR40C0)
  %a2 = bitcast <6 x bfloat> %a1 to <3 x i32>
  br label %end

cmp.false:
  %a3 = bitcast <6 x bfloat> %a to <3 x i32>
  br label %end

end:
  %phi = phi <3 x i32> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <3 x i32> %phi
}

define inreg <3 x i32> @bitcast_v6bf16_to_v3i32_scalar(<6 x bfloat> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v6bf16_to_v3i32_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s22, 0
; SI-NEXT:    v_mul_f32_e64 v7, 1.0, s17
; SI-NEXT:    v_mul_f32_e64 v8, 1.0, s16
; SI-NEXT:    v_mul_f32_e64 v5, 1.0, s19
; SI-NEXT:    v_mul_f32_e64 v6, 1.0, s18
; SI-NEXT:    v_mul_f32_e64 v3, 1.0, s21
; SI-NEXT:    v_mul_f32_e64 v4, 1.0, s20
; SI-NEXT:    s_cbranch_scc0 .LBB11_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v7
; SI-NEXT:    v_lshrrev_b32_e32 v1, 16, v5
; SI-NEXT:    v_lshrrev_b32_e32 v2, 16, v3
; SI-NEXT:    v_alignbit_b32 v0, v0, v8, 16
; SI-NEXT:    v_alignbit_b32 v1, v1, v6, 16
; SI-NEXT:    v_alignbit_b32 v2, v2, v4, 16
; SI-NEXT:    s_cbranch_execnz .LBB11_3
; SI-NEXT:  .LBB11_2: ; %cmp.true
; SI-NEXT:    v_and_b32_e32 v1, 0xffff0000, v7
; SI-NEXT:    v_and_b32_e32 v0, 0xffff0000, v8
; SI-NEXT:    v_add_f32_e32 v1, 0x40c00000, v1
; SI-NEXT:    v_add_f32_e32 v0, 0x40c00000, v0
; SI-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_and_b32_e32 v2, 0xffff0000, v5
; SI-NEXT:    v_alignbit_b32 v0, v1, v0, 16
; SI-NEXT:    v_and_b32_e32 v1, 0xffff0000, v6
; SI-NEXT:    v_add_f32_e32 v2, 0x40c00000, v2
; SI-NEXT:    v_add_f32_e32 v1, 0x40c00000, v1
; SI-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_and_b32_e32 v3, 0xffff0000, v3
; SI-NEXT:    v_alignbit_b32 v1, v2, v1, 16
; SI-NEXT:    v_and_b32_e32 v2, 0xffff0000, v4
; SI-NEXT:    v_add_f32_e32 v3, 0x40c00000, v3
; SI-NEXT:    v_add_f32_e32 v2, 0x40c00000, v2
; SI-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; SI-NEXT:    v_alignbit_b32 v2, v3, v2, 16
; SI-NEXT:  .LBB11_3: ; %end
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB11_4:
; SI-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2
; SI-NEXT:    s_branch .LBB11_2
;
; VI-LABEL: bitcast_v6bf16_to_v3i32_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s19, 0
; VI-NEXT:    s_cbranch_scc0 .LBB11_3
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB11_4
; VI-NEXT:  .LBB11_2: ; %cmp.true
; VI-NEXT:    s_lshl_b32 s4, s18, 16
; VI-NEXT:    v_mov_b32_e32 v0, 0x40c00000
; VI-NEXT:    v_add_f32_e32 v1, s4, v0
; VI-NEXT:    v_bfe_u32 v2, v1, 16, 1
; VI-NEXT:    v_add_u32_e32 v2, vcc, v2, v1
; VI-NEXT:    v_add_u32_e32 v2, vcc, 0x7fff, v2
; VI-NEXT:    v_or_b32_e32 v3, 0x400000, v1
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; VI-NEXT:    s_and_b32 s4, s18, 0xffff0000
; VI-NEXT:    v_cndmask_b32_e32 v1, v2, v3, vcc
; VI-NEXT:    v_add_f32_e32 v2, s4, v0
; VI-NEXT:    v_bfe_u32 v3, v2, 16, 1
; VI-NEXT:    v_add_u32_e32 v3, vcc, v3, v2
; VI-NEXT:    v_add_u32_e32 v3, vcc, 0x7fff, v3
; VI-NEXT:    v_or_b32_e32 v4, 0x400000, v2
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; VI-NEXT:    v_cndmask_b32_e32 v2, v3, v4, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; VI-NEXT:    s_lshl_b32 s4, s17, 16
; VI-NEXT:    v_alignbit_b32 v2, v2, v1, 16
; VI-NEXT:    v_add_f32_e32 v1, s4, v0
; VI-NEXT:    v_bfe_u32 v3, v1, 16, 1
; VI-NEXT:    v_add_u32_e32 v3, vcc, v3, v1
; VI-NEXT:    v_add_u32_e32 v3, vcc, 0x7fff, v3
; VI-NEXT:    v_or_b32_e32 v4, 0x400000, v1
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; VI-NEXT:    s_and_b32 s4, s17, 0xffff0000
; VI-NEXT:    v_cndmask_b32_e32 v1, v3, v4, vcc
; VI-NEXT:    v_add_f32_e32 v3, s4, v0
; VI-NEXT:    v_bfe_u32 v4, v3, 16, 1
; VI-NEXT:    v_add_u32_e32 v4, vcc, v4, v3
; VI-NEXT:    v_add_u32_e32 v4, vcc, 0x7fff, v4
; VI-NEXT:    v_or_b32_e32 v5, 0x400000, v3
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v3, v3
; VI-NEXT:    v_cndmask_b32_e32 v3, v4, v5, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; VI-NEXT:    s_lshl_b32 s4, s16, 16
; VI-NEXT:    v_alignbit_b32 v1, v3, v1, 16
; VI-NEXT:    v_add_f32_e32 v3, s4, v0
; VI-NEXT:    v_bfe_u32 v4, v3, 16, 1
; VI-NEXT:    v_add_u32_e32 v4, vcc, v4, v3
; VI-NEXT:    v_add_u32_e32 v4, vcc, 0x7fff, v4
; VI-NEXT:    s_and_b32 s4, s16, 0xffff0000
; VI-NEXT:    v_or_b32_e32 v5, 0x400000, v3
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v3, v3
; VI-NEXT:    v_add_f32_e32 v0, s4, v0
; VI-NEXT:    v_cndmask_b32_e32 v3, v4, v5, vcc
; VI-NEXT:    v_bfe_u32 v4, v0, 16, 1
; VI-NEXT:    v_add_u32_e32 v4, vcc, v4, v0
; VI-NEXT:    v_add_u32_e32 v4, vcc, 0x7fff, v4
; VI-NEXT:    v_or_b32_e32 v5, 0x400000, v0
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v0, v0
; VI-NEXT:    v_cndmask_b32_e32 v0, v4, v5, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; VI-NEXT:    v_alignbit_b32 v0, v0, v3, 16
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB11_3:
; VI-NEXT:    s_branch .LBB11_2
; VI-NEXT:  .LBB11_4:
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    v_mov_b32_e32 v2, s18
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v6bf16_to_v3i32_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s19, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB11_3
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB11_4
; GFX9-NEXT:  .LBB11_2: ; %cmp.true
; GFX9-NEXT:    s_pack_lh_b32_b16 s4, 0, s18
; GFX9-NEXT:    v_mov_b32_e32 v0, 0x40c00000
; GFX9-NEXT:    v_add_f32_e32 v1, s4, v0
; GFX9-NEXT:    v_bfe_u32 v2, v1, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v2, v2, v1
; GFX9-NEXT:    v_add_u32_e32 v2, 0x7fff, v2
; GFX9-NEXT:    v_or_b32_e32 v3, 0x400000, v1
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; GFX9-NEXT:    s_lshl_b32 s4, s18, 16
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v2, v3, vcc
; GFX9-NEXT:    v_add_f32_e32 v2, s4, v0
; GFX9-NEXT:    v_bfe_u32 v3, v2, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v3, v3, v2
; GFX9-NEXT:    v_add_u32_e32 v3, 0x7fff, v3
; GFX9-NEXT:    v_or_b32_e32 v4, 0x400000, v2
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; GFX9-NEXT:    v_cndmask_b32_e32 v2, v3, v4, vcc
; GFX9-NEXT:    v_mov_b32_e32 v3, 0xffff
; GFX9-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX9-NEXT:    v_and_b32_sdwa v2, v3, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-NEXT:    s_pack_lh_b32_b16 s4, 0, s17
; GFX9-NEXT:    v_lshl_or_b32 v2, v1, 16, v2
; GFX9-NEXT:    v_add_f32_e32 v1, s4, v0
; GFX9-NEXT:    v_bfe_u32 v4, v1, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v4, v4, v1
; GFX9-NEXT:    v_add_u32_e32 v4, 0x7fff, v4
; GFX9-NEXT:    v_or_b32_e32 v5, 0x400000, v1
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; GFX9-NEXT:    s_lshl_b32 s4, s17, 16
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v4, v5, vcc
; GFX9-NEXT:    v_add_f32_e32 v4, s4, v0
; GFX9-NEXT:    v_bfe_u32 v5, v4, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v5, v5, v4
; GFX9-NEXT:    v_add_u32_e32 v5, 0x7fff, v5
; GFX9-NEXT:    v_or_b32_e32 v6, 0x400000, v4
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v4, v4
; GFX9-NEXT:    v_cndmask_b32_e32 v4, v5, v6, vcc
; GFX9-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX9-NEXT:    v_and_b32_sdwa v4, v3, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-NEXT:    s_pack_lh_b32_b16 s4, 0, s16
; GFX9-NEXT:    v_lshl_or_b32 v1, v1, 16, v4
; GFX9-NEXT:    v_add_f32_e32 v4, s4, v0
; GFX9-NEXT:    v_bfe_u32 v5, v4, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v5, v5, v4
; GFX9-NEXT:    s_lshl_b32 s4, s16, 16
; GFX9-NEXT:    v_add_u32_e32 v5, 0x7fff, v5
; GFX9-NEXT:    v_or_b32_e32 v6, 0x400000, v4
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v4, v4
; GFX9-NEXT:    v_add_f32_e32 v0, s4, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v4, v5, v6, vcc
; GFX9-NEXT:    v_bfe_u32 v5, v0, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v5, v5, v0
; GFX9-NEXT:    v_add_u32_e32 v5, 0x7fff, v5
; GFX9-NEXT:    v_or_b32_e32 v6, 0x400000, v0
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v0, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v5, v6, vcc
; GFX9-NEXT:    v_lshrrev_b32_e32 v4, 16, v4
; GFX9-NEXT:    v_and_b32_sdwa v0, v3, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-NEXT:    v_lshl_or_b32 v0, v4, 16, v0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB11_3:
; GFX9-NEXT:    s_branch .LBB11_2
; GFX9-NEXT:  .LBB11_4:
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v6bf16_to_v3i32_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_cmp_lg_u32 s3, 0
; GFX11-NEXT:    s_mov_b32 s3, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB11_3
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s3
; GFX11-NEXT:    s_cbranch_vccnz .LBB11_4
; GFX11-NEXT:  .LBB11_2: ; %cmp.true
; GFX11-NEXT:    s_pack_lh_b32_b16 s3, 0, s2
; GFX11-NEXT:    s_lshl_b32 s2, s2, 16
; GFX11-NEXT:    v_add_f32_e64 v0, 0x40c00000, s3
; GFX11-NEXT:    v_add_f32_e64 v1, 0x40c00000, s2
; GFX11-NEXT:    s_pack_lh_b32_b16 s2, 0, s0
; GFX11-NEXT:    s_lshl_b32 s0, s0, 16
; GFX11-NEXT:    s_pack_lh_b32_b16 s3, 0, s1
; GFX11-NEXT:    v_bfe_u32 v2, v0, 16, 1
; GFX11-NEXT:    v_bfe_u32 v3, v1, 16, 1
; GFX11-NEXT:    v_or_b32_e32 v8, 0x400000, v0
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v0, v0
; GFX11-NEXT:    v_add_f32_e64 v7, 0x40c00000, s0
; GFX11-NEXT:    v_or_b32_e32 v9, 0x400000, v1
; GFX11-NEXT:    v_add_nc_u32_e32 v3, v3, v1
; GFX11-NEXT:    v_add_f32_e64 v4, 0x40c00000, s3
; GFX11-NEXT:    s_lshl_b32 s1, s1, 16
; GFX11-NEXT:    v_or_b32_e32 v12, 0x400000, v7
; GFX11-NEXT:    v_add_f32_e64 v5, 0x40c00000, s1
; GFX11-NEXT:    v_add_nc_u32_e32 v3, 0x7fff, v3
; GFX11-NEXT:    v_add_nc_u32_e32 v2, v2, v0
; GFX11-NEXT:    v_bfe_u32 v10, v4, 16, 1
; GFX11-NEXT:    v_add_f32_e64 v6, 0x40c00000, s2
; GFX11-NEXT:    v_or_b32_e32 v11, 0x400000, v5
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_nc_u32_e32 v2, 0x7fff, v2
; GFX11-NEXT:    v_cndmask_b32_e32 v0, v2, v8, vcc_lo
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v1, v1
; GFX11-NEXT:    v_bfe_u32 v2, v5, 16, 1
; GFX11-NEXT:    v_bfe_u32 v8, v7, 16, 1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_4)
; GFX11-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; GFX11-NEXT:    v_cndmask_b32_e32 v1, v3, v9, vcc_lo
; GFX11-NEXT:    v_add_nc_u32_e32 v3, v10, v4
; GFX11-NEXT:    v_or_b32_e32 v10, 0x400000, v4
; GFX11-NEXT:    v_bfe_u32 v9, v6, 16, 1
; GFX11-NEXT:    v_add_nc_u32_e32 v8, v8, v7
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v5, v5
; GFX11-NEXT:    v_add_nc_u32_e32 v3, 0x7fff, v3
; GFX11-NEXT:    v_add_nc_u32_e32 v2, v2, v5
; GFX11-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX11-NEXT:    v_add_nc_u32_e32 v8, 0x7fff, v8
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_add_nc_u32_e32 v2, 0x7fff, v2
; GFX11-NEXT:    v_add_nc_u32_e32 v9, v9, v6
; GFX11-NEXT:    v_dual_cndmask_b32 v2, v2, v11 :: v_dual_and_b32 v1, 0xffff, v1
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v7, v7
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(VALU_DEP_4)
; GFX11-NEXT:    v_add_nc_u32_e32 v5, 0x7fff, v9
; GFX11-NEXT:    v_or_b32_e32 v9, 0x400000, v6
; GFX11-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX11-NEXT:    v_cndmask_b32_e32 v7, v8, v12, vcc_lo
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v4, v4
; GFX11-NEXT:    v_cndmask_b32_e32 v3, v3, v10, vcc_lo
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v6, v6
; GFX11-NEXT:    v_and_b32_e32 v6, 0xffff, v2
; GFX11-NEXT:    v_lshl_or_b32 v2, v0, 16, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; GFX11-NEXT:    v_cndmask_b32_e32 v4, v5, v9, vcc_lo
; GFX11-NEXT:    v_lshrrev_b32_e32 v5, 16, v7
; GFX11-NEXT:    v_lshl_or_b32 v1, v3, 16, v6
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_lshrrev_b32_e32 v4, 16, v4
; GFX11-NEXT:    v_and_b32_e32 v5, 0xffff, v5
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_lshl_or_b32 v0, v4, 16, v5
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB11_3:
; GFX11-NEXT:    s_branch .LBB11_2
; GFX11-NEXT:  .LBB11_4:
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_mov_b32_e32 v2, s2
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <6 x bfloat> %a, splat (bfloat 0xR40C0)
  %a2 = bitcast <6 x bfloat> %a1 to <3 x i32>
  br label %end

cmp.false:
  %a3 = bitcast <6 x bfloat> %a to <3 x i32>
  br label %end

end:
  %phi = phi <3 x i32> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <3 x i32> %phi
}

define <6 x half> @bitcast_v3i32_to_v6f16(<3 x i32> %a, i32 %b) {
; SI-LABEL: bitcast_v3i32_to_v6f16:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v8, v2
; SI-NEXT:    v_mov_b32_e32 v7, v1
; SI-NEXT:    v_mov_b32_e32 v6, v0
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v3
; SI-NEXT:    ; implicit-def: $vgpr0
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    ; implicit-def: $vgpr4
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB12_3
; SI-NEXT:  ; %bb.1: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB12_4
; SI-NEXT:  .LBB12_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB12_3: ; %cmp.false
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v8
; SI-NEXT:    v_cvt_f32_f16_e32 v5, v0
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v7
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v0
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v6
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v0
; SI-NEXT:    v_cvt_f32_f16_e32 v4, v8
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v7
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v6
; SI-NEXT:    ; implicit-def: $vgpr6
; SI-NEXT:    ; implicit-def: $vgpr7
; SI-NEXT:    ; implicit-def: $vgpr8
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB12_2
; SI-NEXT:  .LBB12_4: ; %cmp.true
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v6
; SI-NEXT:    v_add_i32_e32 v3, vcc, 3, v7
; SI-NEXT:    v_add_i32_e32 v5, vcc, 3, v8
; SI-NEXT:    v_cvt_f32_f16_e32 v4, v5
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v3
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v1
; SI-NEXT:    v_lshrrev_b32_e32 v5, 16, v5
; SI-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; SI-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_cvt_f32_f16_e32 v5, v5
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v3
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v3i32_to_v6f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v3
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_add_u32_e32 v2, vcc, 3, v2
; VI-NEXT:    v_add_u32_e32 v1, vcc, 3, v1
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v0
; VI-NEXT:  ; %bb.2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v3i32_to_v6f16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v3
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_add_u32_e32 v2, 3, v2
; GFX9-NEXT:    v_add_u32_e32 v1, 3, v1
; GFX9-NEXT:    v_add_u32_e32 v0, 3, v0
; GFX9-NEXT:  ; %bb.2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v3i32_to_v6f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v3
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_add_nc_u32_e32 v2, 3, v2
; GFX11-NEXT:    v_add_nc_u32_e32 v1, 3, v1
; GFX11-NEXT:    v_add_nc_u32_e32 v0, 3, v0
; GFX11-NEXT:  ; %bb.2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <3 x i32> %a, splat (i32 3)
  %a2 = bitcast <3 x i32> %a1 to <6 x half>
  br label %end

cmp.false:
  %a3 = bitcast <3 x i32> %a to <6 x half>
  br label %end

end:
  %phi = phi <6 x half> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <6 x half> %phi
}

define inreg <6 x half> @bitcast_v3i32_to_v6f16_scalar(<3 x i32> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v3i32_to_v6f16_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s19, 0
; SI-NEXT:    s_cbranch_scc0 .LBB13_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_lshr_b32 s4, s18, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v5, s4
; SI-NEXT:    s_lshr_b32 s4, s17, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v3, s4
; SI-NEXT:    s_lshr_b32 s4, s16, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v1, s4
; SI-NEXT:    v_cvt_f32_f16_e32 v4, s18
; SI-NEXT:    v_cvt_f32_f16_e32 v2, s17
; SI-NEXT:    v_cvt_f32_f16_e32 v0, s16
; SI-NEXT:    s_cbranch_execnz .LBB13_3
; SI-NEXT:  .LBB13_2: ; %cmp.true
; SI-NEXT:    s_add_i32 s18, s18, 3
; SI-NEXT:    s_add_i32 s17, s17, 3
; SI-NEXT:    s_lshr_b32 s4, s18, 16
; SI-NEXT:    s_add_i32 s16, s16, 3
; SI-NEXT:    v_cvt_f32_f16_e32 v5, s4
; SI-NEXT:    s_lshr_b32 s4, s17, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v3, s4
; SI-NEXT:    s_lshr_b32 s4, s16, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v4, s18
; SI-NEXT:    v_cvt_f32_f16_e32 v2, s17
; SI-NEXT:    v_cvt_f32_f16_e32 v0, s16
; SI-NEXT:    v_cvt_f32_f16_e32 v1, s4
; SI-NEXT:  .LBB13_3: ; %end
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB13_4:
; SI-NEXT:    ; implicit-def: $vgpr0
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    ; implicit-def: $vgpr4
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    s_branch .LBB13_2
;
; VI-LABEL: bitcast_v3i32_to_v6f16_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s19, 0
; VI-NEXT:    s_cbranch_scc0 .LBB13_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB13_3
; VI-NEXT:  .LBB13_2: ; %cmp.true
; VI-NEXT:    s_add_i32 s18, s18, 3
; VI-NEXT:    s_add_i32 s17, s17, 3
; VI-NEXT:    s_add_i32 s16, s16, 3
; VI-NEXT:  .LBB13_3: ; %end
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    v_mov_b32_e32 v2, s18
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB13_4:
; VI-NEXT:    s_branch .LBB13_2
;
; GFX9-LABEL: bitcast_v3i32_to_v6f16_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s19, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB13_4
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB13_3
; GFX9-NEXT:  .LBB13_2: ; %cmp.true
; GFX9-NEXT:    s_add_i32 s18, s18, 3
; GFX9-NEXT:    s_add_i32 s17, s17, 3
; GFX9-NEXT:    s_add_i32 s16, s16, 3
; GFX9-NEXT:  .LBB13_3: ; %end
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB13_4:
; GFX9-NEXT:    s_branch .LBB13_2
;
; GFX11-LABEL: bitcast_v3i32_to_v6f16_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_cmp_lg_u32 s3, 0
; GFX11-NEXT:    s_mov_b32 s3, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB13_4
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s3
; GFX11-NEXT:    s_cbranch_vccnz .LBB13_3
; GFX11-NEXT:  .LBB13_2: ; %cmp.true
; GFX11-NEXT:    s_add_i32 s2, s2, 3
; GFX11-NEXT:    s_add_i32 s1, s1, 3
; GFX11-NEXT:    s_add_i32 s0, s0, 3
; GFX11-NEXT:  .LBB13_3: ; %end
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_mov_b32_e32 v2, s2
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB13_4:
; GFX11-NEXT:    s_branch .LBB13_2
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <3 x i32> %a, splat (i32 3)
  %a2 = bitcast <3 x i32> %a1 to <6 x half>
  br label %end

cmp.false:
  %a3 = bitcast <3 x i32> %a to <6 x half>
  br label %end

end:
  %phi = phi <6 x half> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <6 x half> %phi
}

define <3 x i32> @bitcast_v6f16_to_v3i32(<6 x half> %a, i32 %b) {
; SI-LABEL: bitcast_v6f16_to_v3i32:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v10, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v9, v0
; SI-NEXT:    v_cvt_f16_f32_e32 v8, v3
; SI-NEXT:    v_cvt_f16_f32_e32 v7, v2
; SI-NEXT:    v_cvt_f16_f32_e32 v5, v5
; SI-NEXT:    v_cvt_f16_f32_e32 v3, v4
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v6
; SI-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB14_3
; SI-NEXT:  ; %bb.1: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB14_4
; SI-NEXT:  .LBB14_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB14_3: ; %cmp.false
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v10
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v8
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v5
; SI-NEXT:    v_or_b32_e32 v0, v9, v0
; SI-NEXT:    v_or_b32_e32 v1, v7, v1
; SI-NEXT:    v_or_b32_e32 v2, v3, v2
; SI-NEXT:    ; implicit-def: $vgpr10
; SI-NEXT:    ; implicit-def: $vgpr9
; SI-NEXT:    ; implicit-def: $vgpr8
; SI-NEXT:    ; implicit-def: $vgpr7
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB14_2
; SI-NEXT:  .LBB14_4: ; %cmp.true
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v10
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v9
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v8
; SI-NEXT:    v_cvt_f32_f16_e32 v4, v7
; SI-NEXT:    v_add_f32_e32 v0, 0x38000000, v0
; SI-NEXT:    v_add_f32_e32 v1, 0x38000000, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-NEXT:    v_add_f32_e32 v2, 0x38000000, v2
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v3
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v2
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v5
; SI-NEXT:    v_add_f32_e32 v4, 0x38000000, v4
; SI-NEXT:    v_add_f32_e32 v3, 0x38000000, v3
; SI-NEXT:    v_cvt_f16_f32_e32 v4, v4
; SI-NEXT:    v_add_f32_e32 v2, 0x38000000, v2
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_or_b32_e32 v1, v4, v1
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_or_b32_e32 v2, v3, v2
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v6f16_to_v3i32:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v3
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB14_2
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_mov_b32_e32 v3, 0x200
; VI-NEXT:    v_add_f16_sdwa v4, v2, v3 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v2, 0x200, v2
; VI-NEXT:    v_or_b32_e32 v2, v2, v4
; VI-NEXT:    v_add_f16_sdwa v4, v1, v3 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v1, 0x200, v1
; VI-NEXT:    v_add_f16_sdwa v3, v0, v3 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v0, 0x200, v0
; VI-NEXT:    v_or_b32_e32 v1, v1, v4
; VI-NEXT:    v_or_b32_e32 v0, v0, v3
; VI-NEXT:  .LBB14_2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v6f16_to_v3i32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v3
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    s_movk_i32 s6, 0x200
; GFX9-NEXT:    v_pk_add_f16 v2, v2, s6 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v1, v1, s6 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v0, v0, s6 op_sel_hi:[1,0]
; GFX9-NEXT:  ; %bb.2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v6f16_to_v3i32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v3
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_pk_add_f16 v2, 0x200, v2 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v1, 0x200, v1 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v0, 0x200, v0 op_sel_hi:[0,1]
; GFX11-NEXT:  ; %bb.2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <6 x half> %a, splat (half 0xH0200)
  %a2 = bitcast <6 x half> %a1 to <3 x i32>
  br label %end

cmp.false:
  %a3 = bitcast <6 x half> %a to <3 x i32>
  br label %end

end:
  %phi = phi <3 x i32> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <3 x i32> %phi
}

define inreg <3 x i32> @bitcast_v6f16_to_v3i32_scalar(<6 x half> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v6f16_to_v3i32_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v8, s17
; SI-NEXT:    v_cvt_f16_f32_e32 v7, s16
; SI-NEXT:    v_cvt_f16_f32_e32 v6, s19
; SI-NEXT:    v_cvt_f16_f32_e32 v5, s18
; SI-NEXT:    v_cvt_f16_f32_e32 v4, s21
; SI-NEXT:    v_cvt_f16_f32_e32 v3, s20
; SI-NEXT:    s_cmp_lg_u32 s22, 0
; SI-NEXT:    s_cbranch_scc0 .LBB15_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v8
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v6
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v4
; SI-NEXT:    v_or_b32_e32 v0, v7, v0
; SI-NEXT:    v_or_b32_e32 v1, v5, v1
; SI-NEXT:    v_or_b32_e32 v2, v3, v2
; SI-NEXT:    s_cbranch_execnz .LBB15_3
; SI-NEXT:  .LBB15_2: ; %cmp.true
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v8
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v7
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v6
; SI-NEXT:    v_cvt_f32_f16_e32 v5, v5
; SI-NEXT:    v_add_f32_e32 v0, 0x38000000, v0
; SI-NEXT:    v_add_f32_e32 v1, 0x38000000, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-NEXT:    v_add_f32_e32 v2, 0x38000000, v2
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v3
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v2
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v4
; SI-NEXT:    v_add_f32_e32 v4, 0x38000000, v5
; SI-NEXT:    v_add_f32_e32 v3, 0x38000000, v3
; SI-NEXT:    v_cvt_f16_f32_e32 v4, v4
; SI-NEXT:    v_add_f32_e32 v2, 0x38000000, v2
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_or_b32_e32 v1, v4, v1
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_or_b32_e32 v2, v3, v2
; SI-NEXT:  .LBB15_3: ; %end
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB15_4:
; SI-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2
; SI-NEXT:    s_branch .LBB15_2
;
; VI-LABEL: bitcast_v6f16_to_v3i32_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s19, 0
; VI-NEXT:    s_cbranch_scc0 .LBB15_3
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB15_4
; VI-NEXT:  .LBB15_2: ; %cmp.true
; VI-NEXT:    s_lshr_b32 s4, s18, 16
; VI-NEXT:    v_mov_b32_e32 v0, 0x200
; VI-NEXT:    v_mov_b32_e32 v1, s4
; VI-NEXT:    v_add_f16_sdwa v1, v1, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v2, s18, v0
; VI-NEXT:    s_lshr_b32 s4, s17, 16
; VI-NEXT:    v_or_b32_e32 v2, v2, v1
; VI-NEXT:    v_mov_b32_e32 v1, s4
; VI-NEXT:    v_add_f16_sdwa v1, v1, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v3, s17, v0
; VI-NEXT:    s_lshr_b32 s4, s16, 16
; VI-NEXT:    v_or_b32_e32 v1, v3, v1
; VI-NEXT:    v_mov_b32_e32 v3, s4
; VI-NEXT:    v_add_f16_sdwa v3, v3, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v0, s16, v0
; VI-NEXT:    v_or_b32_e32 v0, v0, v3
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB15_3:
; VI-NEXT:    s_branch .LBB15_2
; VI-NEXT:  .LBB15_4:
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    v_mov_b32_e32 v2, s18
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v6f16_to_v3i32_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s19, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB15_3
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB15_4
; GFX9-NEXT:  .LBB15_2: ; %cmp.true
; GFX9-NEXT:    v_mov_b32_e32 v0, 0x200
; GFX9-NEXT:    v_pk_add_f16 v2, s18, v0 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v1, s17, v0 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v0, s16, v0 op_sel_hi:[1,0]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB15_3:
; GFX9-NEXT:    s_branch .LBB15_2
; GFX9-NEXT:  .LBB15_4:
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v6f16_to_v3i32_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_cmp_lg_u32 s3, 0
; GFX11-NEXT:    s_mov_b32 s3, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB15_3
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s3
; GFX11-NEXT:    s_cbranch_vccnz .LBB15_4
; GFX11-NEXT:  .LBB15_2: ; %cmp.true
; GFX11-NEXT:    v_pk_add_f16 v2, 0x200, s2 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v1, 0x200, s1 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v0, 0x200, s0 op_sel_hi:[0,1]
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB15_3:
; GFX11-NEXT:    s_branch .LBB15_2
; GFX11-NEXT:  .LBB15_4:
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_mov_b32_e32 v2, s2
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <6 x half> %a, splat (half 0xH0200)
  %a2 = bitcast <6 x half> %a1 to <3 x i32>
  br label %end

cmp.false:
  %a3 = bitcast <6 x half> %a to <3 x i32>
  br label %end

end:
  %phi = phi <3 x i32> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <3 x i32> %phi
}

define <6 x i16> @bitcast_v3i32_to_v6i16(<3 x i32> %a, i32 %b) {
; SI-LABEL: bitcast_v3i32_to_v6i16:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v4, v2
; SI-NEXT:    v_mov_b32_e32 v2, v1
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v3
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB16_3
; SI-NEXT:  ; %bb.1: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB16_4
; SI-NEXT:  .LBB16_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB16_3: ; %cmp.false
; SI-NEXT:    v_alignbit_b32 v5, s4, v4, 16
; SI-NEXT:    v_alignbit_b32 v1, v2, v0, 16
; SI-NEXT:    v_lshrrev_b32_e32 v3, 16, v2
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB16_2
; SI-NEXT:  .LBB16_4: ; %cmp.true
; SI-NEXT:    v_add_i32_e32 v4, vcc, 3, v4
; SI-NEXT:    v_add_i32_e32 v2, vcc, 3, v2
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v0
; SI-NEXT:    v_alignbit_b32 v1, v2, v0, 16
; SI-NEXT:    v_alignbit_b32 v5, s4, v4, 16
; SI-NEXT:    v_lshrrev_b32_e32 v3, 16, v2
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v3i32_to_v6i16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v3
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_add_u32_e32 v2, vcc, 3, v2
; VI-NEXT:    v_add_u32_e32 v1, vcc, 3, v1
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v0
; VI-NEXT:  ; %bb.2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v3i32_to_v6i16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v3
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_add_u32_e32 v2, 3, v2
; GFX9-NEXT:    v_add_u32_e32 v1, 3, v1
; GFX9-NEXT:    v_add_u32_e32 v0, 3, v0
; GFX9-NEXT:  ; %bb.2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v3i32_to_v6i16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v3
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_add_nc_u32_e32 v2, 3, v2
; GFX11-NEXT:    v_add_nc_u32_e32 v1, 3, v1
; GFX11-NEXT:    v_add_nc_u32_e32 v0, 3, v0
; GFX11-NEXT:  ; %bb.2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <3 x i32> %a, splat (i32 3)
  %a2 = bitcast <3 x i32> %a1 to <6 x i16>
  br label %end

cmp.false:
  %a3 = bitcast <3 x i32> %a to <6 x i16>
  br label %end

end:
  %phi = phi <6 x i16> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <6 x i16> %phi
}

define inreg <6 x i16> @bitcast_v3i32_to_v6i16_scalar(<3 x i32> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v3i32_to_v6i16_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s19, 0
; SI-NEXT:    s_cbranch_scc0 .LBB17_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    v_mov_b32_e32 v0, s18
; SI-NEXT:    v_alignbit_b32 v5, s4, v0, 16
; SI-NEXT:    v_mov_b32_e32 v0, s16
; SI-NEXT:    v_alignbit_b32 v1, s17, v0, 16
; SI-NEXT:    s_lshr_b32 s6, s17, 16
; SI-NEXT:    s_cbranch_execnz .LBB17_3
; SI-NEXT:  .LBB17_2: ; %cmp.true
; SI-NEXT:    s_add_i32 s16, s16, 3
; SI-NEXT:    s_add_i32 s18, s18, 3
; SI-NEXT:    s_add_i32 s17, s17, 3
; SI-NEXT:    v_mov_b32_e32 v0, s16
; SI-NEXT:    v_alignbit_b32 v1, s17, v0, 16
; SI-NEXT:    v_mov_b32_e32 v0, s18
; SI-NEXT:    v_alignbit_b32 v5, s4, v0, 16
; SI-NEXT:    s_lshr_b32 s6, s17, 16
; SI-NEXT:  .LBB17_3: ; %end
; SI-NEXT:    v_mov_b32_e32 v0, s16
; SI-NEXT:    v_mov_b32_e32 v2, s17
; SI-NEXT:    v_mov_b32_e32 v3, s6
; SI-NEXT:    v_mov_b32_e32 v4, s18
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB17_4:
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    ; implicit-def: $sgpr6
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    s_branch .LBB17_2
;
; VI-LABEL: bitcast_v3i32_to_v6i16_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s19, 0
; VI-NEXT:    s_cbranch_scc0 .LBB17_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB17_3
; VI-NEXT:  .LBB17_2: ; %cmp.true
; VI-NEXT:    s_add_i32 s18, s18, 3
; VI-NEXT:    s_add_i32 s17, s17, 3
; VI-NEXT:    s_add_i32 s16, s16, 3
; VI-NEXT:  .LBB17_3: ; %end
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    v_mov_b32_e32 v2, s18
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB17_4:
; VI-NEXT:    s_branch .LBB17_2
;
; GFX9-LABEL: bitcast_v3i32_to_v6i16_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s19, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB17_4
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB17_3
; GFX9-NEXT:  .LBB17_2: ; %cmp.true
; GFX9-NEXT:    s_add_i32 s18, s18, 3
; GFX9-NEXT:    s_add_i32 s17, s17, 3
; GFX9-NEXT:    s_add_i32 s16, s16, 3
; GFX9-NEXT:  .LBB17_3: ; %end
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB17_4:
; GFX9-NEXT:    s_branch .LBB17_2
;
; GFX11-LABEL: bitcast_v3i32_to_v6i16_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_cmp_lg_u32 s3, 0
; GFX11-NEXT:    s_mov_b32 s3, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB17_4
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s3
; GFX11-NEXT:    s_cbranch_vccnz .LBB17_3
; GFX11-NEXT:  .LBB17_2: ; %cmp.true
; GFX11-NEXT:    s_add_i32 s2, s2, 3
; GFX11-NEXT:    s_add_i32 s1, s1, 3
; GFX11-NEXT:    s_add_i32 s0, s0, 3
; GFX11-NEXT:  .LBB17_3: ; %end
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_mov_b32_e32 v2, s2
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB17_4:
; GFX11-NEXT:    s_branch .LBB17_2
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <3 x i32> %a, splat (i32 3)
  %a2 = bitcast <3 x i32> %a1 to <6 x i16>
  br label %end

cmp.false:
  %a3 = bitcast <3 x i32> %a to <6 x i16>
  br label %end

end:
  %phi = phi <6 x i16> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <6 x i16> %phi
}

define <3 x i32> @bitcast_v6i16_to_v3i32(<6 x i16> %a, i32 %b) {
; SI-LABEL: bitcast_v6i16_to_v3i32:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v8, v2
; SI-NEXT:    v_mov_b32_e32 v7, v0
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v6
; SI-NEXT:    v_lshlrev_b32_e32 v9, 16, v1
; SI-NEXT:    v_lshlrev_b32_e32 v6, 16, v3
; SI-NEXT:    v_lshlrev_b32_e32 v3, 16, v5
; SI-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB18_3
; SI-NEXT:  ; %bb.1: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB18_4
; SI-NEXT:  .LBB18_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB18_3: ; %cmp.false
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v7
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v8
; SI-NEXT:    v_and_b32_e32 v2, 0xffff, v4
; SI-NEXT:    v_or_b32_e32 v0, v0, v9
; SI-NEXT:    v_or_b32_e32 v1, v1, v6
; SI-NEXT:    v_or_b32_e32 v2, v2, v3
; SI-NEXT:    ; implicit-def: $vgpr7
; SI-NEXT:    ; implicit-def: $vgpr9
; SI-NEXT:    ; implicit-def: $vgpr8
; SI-NEXT:    ; implicit-def: $vgpr6
; SI-NEXT:    ; implicit-def: $vgpr4
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB18_2
; SI-NEXT:  .LBB18_4: ; %cmp.true
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v7
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v8
; SI-NEXT:    v_add_i32_e32 v2, vcc, 3, v4
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; SI-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; SI-NEXT:    v_or_b32_e32 v0, v9, v0
; SI-NEXT:    v_or_b32_e32 v1, v6, v1
; SI-NEXT:    v_or_b32_e32 v2, v3, v2
; SI-NEXT:    v_add_i32_e32 v0, vcc, 0x30000, v0
; SI-NEXT:    v_add_i32_e32 v1, vcc, 0x30000, v1
; SI-NEXT:    v_add_i32_e32 v2, vcc, 0x30000, v2
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v6i16_to_v3i32:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v3
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB18_2
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_mov_b32_e32 v4, 3
; VI-NEXT:    v_add_u16_e32 v3, 3, v2
; VI-NEXT:    v_add_u16_sdwa v2, v2, v4 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v2, v3, v2
; VI-NEXT:    v_add_u16_e32 v3, 3, v1
; VI-NEXT:    v_add_u16_sdwa v1, v1, v4 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v1, v3, v1
; VI-NEXT:    v_add_u16_e32 v3, 3, v0
; VI-NEXT:    v_add_u16_sdwa v0, v0, v4 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v0, v3, v0
; VI-NEXT:  .LBB18_2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v6i16_to_v3i32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v3
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_pk_add_u16 v2, v2, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v1, v1, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v0, v0, 3 op_sel_hi:[1,0]
; GFX9-NEXT:  ; %bb.2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v6i16_to_v3i32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v3
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_pk_add_u16 v2, v2, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v1, v1, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v0, v0, 3 op_sel_hi:[1,0]
; GFX11-NEXT:  ; %bb.2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <6 x i16> %a, splat (i16 3)
  %a2 = bitcast <6 x i16> %a1 to <3 x i32>
  br label %end

cmp.false:
  %a3 = bitcast <6 x i16> %a to <3 x i32>
  br label %end

end:
  %phi = phi <3 x i32> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <3 x i32> %phi
}

define inreg <3 x i32> @bitcast_v6i16_to_v3i32_scalar(<6 x i16> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v6i16_to_v3i32_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s22, 0
; SI-NEXT:    s_cbranch_scc0 .LBB19_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_and_b32 s4, s16, 0xffff
; SI-NEXT:    s_lshl_b32 s5, s17, 16
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    s_and_b32 s5, s18, 0xffff
; SI-NEXT:    s_lshl_b32 s6, s19, 16
; SI-NEXT:    s_or_b32 s5, s5, s6
; SI-NEXT:    s_and_b32 s6, s20, 0xffff
; SI-NEXT:    s_lshl_b32 s7, s21, 16
; SI-NEXT:    s_or_b32 s6, s6, s7
; SI-NEXT:    s_cbranch_execnz .LBB19_3
; SI-NEXT:  .LBB19_2: ; %cmp.true
; SI-NEXT:    s_add_i32 s16, s16, 3
; SI-NEXT:    s_and_b32 s4, s16, 0xffff
; SI-NEXT:    s_lshl_b32 s5, s17, 16
; SI-NEXT:    s_add_i32 s18, s18, 3
; SI-NEXT:    s_or_b32 s4, s5, s4
; SI-NEXT:    s_and_b32 s5, s18, 0xffff
; SI-NEXT:    s_lshl_b32 s6, s19, 16
; SI-NEXT:    s_add_i32 s20, s20, 3
; SI-NEXT:    s_or_b32 s5, s6, s5
; SI-NEXT:    s_and_b32 s6, s20, 0xffff
; SI-NEXT:    s_lshl_b32 s7, s21, 16
; SI-NEXT:    s_or_b32 s6, s7, s6
; SI-NEXT:    s_add_i32 s4, s4, 0x30000
; SI-NEXT:    s_add_i32 s5, s5, 0x30000
; SI-NEXT:    s_add_i32 s6, s6, 0x30000
; SI-NEXT:  .LBB19_3: ; %end
; SI-NEXT:    v_mov_b32_e32 v0, s4
; SI-NEXT:    v_mov_b32_e32 v1, s5
; SI-NEXT:    v_mov_b32_e32 v2, s6
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB19_4:
; SI-NEXT:    ; implicit-def: $sgpr4_sgpr5_sgpr6
; SI-NEXT:    s_branch .LBB19_2
;
; VI-LABEL: bitcast_v6i16_to_v3i32_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s19, 0
; VI-NEXT:    s_cbranch_scc0 .LBB19_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB19_3
; VI-NEXT:  .LBB19_2: ; %cmp.true
; VI-NEXT:    s_add_i32 s5, s18, 3
; VI-NEXT:    s_and_b32 s4, s18, 0xffff0000
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_add_i32 s5, s17, 3
; VI-NEXT:    s_add_i32 s18, s4, 0x30000
; VI-NEXT:    s_and_b32 s4, s17, 0xffff0000
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_add_i32 s5, s16, 3
; VI-NEXT:    s_add_i32 s17, s4, 0x30000
; VI-NEXT:    s_and_b32 s4, s16, 0xffff0000
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_add_i32 s16, s4, 0x30000
; VI-NEXT:  .LBB19_3: ; %end
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    v_mov_b32_e32 v2, s18
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB19_4:
; VI-NEXT:    s_branch .LBB19_2
;
; GFX9-LABEL: bitcast_v6i16_to_v3i32_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s19, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB19_3
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB19_4
; GFX9-NEXT:  .LBB19_2: ; %cmp.true
; GFX9-NEXT:    v_pk_add_u16 v2, s18, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v1, s17, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v0, s16, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB19_3:
; GFX9-NEXT:    s_branch .LBB19_2
; GFX9-NEXT:  .LBB19_4:
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v6i16_to_v3i32_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_cmp_lg_u32 s3, 0
; GFX11-NEXT:    s_mov_b32 s3, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB19_3
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s3
; GFX11-NEXT:    s_cbranch_vccnz .LBB19_4
; GFX11-NEXT:  .LBB19_2: ; %cmp.true
; GFX11-NEXT:    v_pk_add_u16 v2, s2, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v1, s1, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v0, s0, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB19_3:
; GFX11-NEXT:    s_branch .LBB19_2
; GFX11-NEXT:  .LBB19_4:
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_mov_b32_e32 v2, s2
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <6 x i16> %a, splat (i16 3)
  %a2 = bitcast <6 x i16> %a1 to <3 x i32>
  br label %end

cmp.false:
  %a3 = bitcast <6 x i16> %a to <3 x i32>
  br label %end

end:
  %phi = phi <3 x i32> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <3 x i32> %phi
}

define <12 x i8> @bitcast_v3f32_to_v12i8(<3 x float> %a, i32 %b) {
; SI-LABEL: bitcast_v3f32_to_v12i8:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v8, v2
; SI-NEXT:    v_mov_b32_e32 v4, v1
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v3
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    ; implicit-def: $vgpr6
; SI-NEXT:    ; implicit-def: $vgpr7
; SI-NEXT:    ; implicit-def: $vgpr9
; SI-NEXT:    ; implicit-def: $vgpr10
; SI-NEXT:    ; implicit-def: $vgpr11
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB20_3
; SI-NEXT:  ; %bb.1: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB20_4
; SI-NEXT:  .LBB20_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB20_3: ; %cmp.false
; SI-NEXT:    v_alignbit_b32 v11, s4, v8, 24
; SI-NEXT:    v_alignbit_b32 v10, s4, v8, 16
; SI-NEXT:    v_alignbit_b32 v9, s4, v8, 8
; SI-NEXT:    v_alignbit_b32 v3, v4, v0, 24
; SI-NEXT:    v_alignbit_b32 v2, v4, v0, 16
; SI-NEXT:    v_alignbit_b32 v1, v4, v0, 8
; SI-NEXT:    v_lshrrev_b32_e32 v7, 24, v4
; SI-NEXT:    v_lshrrev_b32_e32 v6, 16, v4
; SI-NEXT:    v_lshrrev_b32_e32 v5, 8, v4
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB20_2
; SI-NEXT:  .LBB20_4: ; %cmp.true
; SI-NEXT:    v_add_f32_e32 v8, 1.0, v8
; SI-NEXT:    v_add_f32_e32 v4, 1.0, v4
; SI-NEXT:    v_add_f32_e32 v0, 1.0, v0
; SI-NEXT:    v_alignbit_b32 v3, v4, v0, 24
; SI-NEXT:    v_alignbit_b32 v2, v4, v0, 16
; SI-NEXT:    v_alignbit_b32 v1, v4, v0, 8
; SI-NEXT:    v_alignbit_b32 v11, s4, v8, 24
; SI-NEXT:    v_alignbit_b32 v10, s4, v8, 16
; SI-NEXT:    v_alignbit_b32 v9, s4, v8, 8
; SI-NEXT:    v_lshrrev_b32_e32 v7, 24, v4
; SI-NEXT:    v_lshrrev_b32_e32 v6, 16, v4
; SI-NEXT:    v_lshrrev_b32_e32 v5, 8, v4
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v3f32_to_v12i8:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v8, v2
; VI-NEXT:    v_mov_b32_e32 v14, v1
; VI-NEXT:    v_mov_b32_e32 v13, v0
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v3
; VI-NEXT:    ; implicit-def: $vgpr1
; VI-NEXT:    ; implicit-def: $vgpr2
; VI-NEXT:    ; implicit-def: $vgpr3
; VI-NEXT:    ; implicit-def: $vgpr5
; VI-NEXT:    ; implicit-def: $vgpr6
; VI-NEXT:    ; implicit-def: $vgpr7
; VI-NEXT:    ; implicit-def: $vgpr9
; VI-NEXT:    ; implicit-def: $vgpr10
; VI-NEXT:    ; implicit-def: $vgpr11
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB20_2
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    v_lshrrev_b32_e32 v9, 8, v8
; VI-NEXT:    v_lshrrev_b32_e32 v10, 16, v8
; VI-NEXT:    v_lshrrev_b32_e32 v7, 24, v14
; VI-NEXT:    v_lshrrev_b32_e32 v6, 16, v14
; VI-NEXT:    v_lshrrev_b32_e32 v5, 8, v14
; VI-NEXT:    v_lshrrev_b32_e32 v2, 16, v13
; VI-NEXT:    v_lshrrev_b64 v[11:12], 24, v[8:9]
; VI-NEXT:    v_lshrrev_b64 v[3:4], 24, v[13:14]
; VI-NEXT:    v_lshrrev_b32_e32 v1, 8, v13
; VI-NEXT:  .LBB20_2: ; %Flow
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB20_4
; VI-NEXT:  ; %bb.3: ; %cmp.true
; VI-NEXT:    v_add_f32_e32 v8, 1.0, v8
; VI-NEXT:    v_add_f32_e32 v14, 1.0, v14
; VI-NEXT:    v_add_f32_e32 v13, 1.0, v13
; VI-NEXT:    v_lshrrev_b32_e32 v9, 8, v8
; VI-NEXT:    v_lshrrev_b64 v[3:4], 24, v[13:14]
; VI-NEXT:    v_lshrrev_b64 v[11:12], 24, v[8:9]
; VI-NEXT:    v_lshrrev_b32_e32 v10, 16, v8
; VI-NEXT:    v_lshrrev_b32_e32 v7, 24, v14
; VI-NEXT:    v_lshrrev_b32_e32 v6, 16, v14
; VI-NEXT:    v_lshrrev_b32_e32 v5, 8, v14
; VI-NEXT:    v_lshrrev_b32_e32 v2, 16, v13
; VI-NEXT:    v_lshrrev_b32_e32 v1, 8, v13
; VI-NEXT:  .LBB20_4: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    v_mov_b32_e32 v0, v13
; VI-NEXT:    v_mov_b32_e32 v4, v14
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v3f32_to_v12i8:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v8, v2
; GFX9-NEXT:    v_mov_b32_e32 v14, v1
; GFX9-NEXT:    v_mov_b32_e32 v13, v0
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v3
; GFX9-NEXT:    ; implicit-def: $vgpr1
; GFX9-NEXT:    ; implicit-def: $vgpr2
; GFX9-NEXT:    ; implicit-def: $vgpr3
; GFX9-NEXT:    ; implicit-def: $vgpr5
; GFX9-NEXT:    ; implicit-def: $vgpr6
; GFX9-NEXT:    ; implicit-def: $vgpr7
; GFX9-NEXT:    ; implicit-def: $vgpr9
; GFX9-NEXT:    ; implicit-def: $vgpr10
; GFX9-NEXT:    ; implicit-def: $vgpr11
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB20_2
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    v_lshrrev_b32_e32 v9, 8, v8
; GFX9-NEXT:    v_lshrrev_b32_e32 v10, 16, v8
; GFX9-NEXT:    v_lshrrev_b32_e32 v7, 24, v14
; GFX9-NEXT:    v_lshrrev_b32_e32 v6, 16, v14
; GFX9-NEXT:    v_lshrrev_b32_e32 v5, 8, v14
; GFX9-NEXT:    v_lshrrev_b32_e32 v2, 16, v13
; GFX9-NEXT:    v_lshrrev_b64 v[11:12], 24, v[8:9]
; GFX9-NEXT:    v_lshrrev_b64 v[3:4], 24, v[13:14]
; GFX9-NEXT:    v_lshrrev_b32_e32 v1, 8, v13
; GFX9-NEXT:  .LBB20_2: ; %Flow
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB20_4
; GFX9-NEXT:  ; %bb.3: ; %cmp.true
; GFX9-NEXT:    v_add_f32_e32 v8, 1.0, v8
; GFX9-NEXT:    v_add_f32_e32 v14, 1.0, v14
; GFX9-NEXT:    v_add_f32_e32 v13, 1.0, v13
; GFX9-NEXT:    v_lshrrev_b32_e32 v9, 8, v8
; GFX9-NEXT:    v_lshrrev_b64 v[3:4], 24, v[13:14]
; GFX9-NEXT:    v_lshrrev_b64 v[11:12], 24, v[8:9]
; GFX9-NEXT:    v_lshrrev_b32_e32 v10, 16, v8
; GFX9-NEXT:    v_lshrrev_b32_e32 v7, 24, v14
; GFX9-NEXT:    v_lshrrev_b32_e32 v6, 16, v14
; GFX9-NEXT:    v_lshrrev_b32_e32 v5, 8, v14
; GFX9-NEXT:    v_lshrrev_b32_e32 v2, 16, v13
; GFX9-NEXT:    v_lshrrev_b32_e32 v1, 8, v13
; GFX9-NEXT:  .LBB20_4: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    v_mov_b32_e32 v0, v13
; GFX9-NEXT:    v_mov_b32_e32 v4, v14
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-TRUE16-LABEL: bitcast_v3f32_to_v12i8:
; GFX11-TRUE16:       ; %bb.0:
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-TRUE16-NEXT:    v_dual_mov_b32 v10, v2 :: v_dual_mov_b32 v11, v0
; GFX11-TRUE16-NEXT:    v_mov_b32_e32 v12, v1
; GFX11-TRUE16-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v3
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr1_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr3_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr5_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr7_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr9_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr13_lo16
; GFX11-TRUE16-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-TRUE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-TRUE16-NEXT:  ; %bb.1: ; %cmp.false
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v9, 8, v10
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v7, 24, v12
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v5, 8, v12
; GFX11-TRUE16-NEXT:    v_lshrrev_b64 v[13:14], 24, v[10:11]
; GFX11-TRUE16-NEXT:    v_lshrrev_b64 v[3:4], 24, v[11:12]
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v1, 8, v11
; GFX11-TRUE16-NEXT:  ; %bb.2: ; %Flow
; GFX11-TRUE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-TRUE16-NEXT:    s_cbranch_execz .LBB20_4
; GFX11-TRUE16-NEXT:  ; %bb.3: ; %cmp.true
; GFX11-TRUE16-NEXT:    v_dual_add_f32 v12, 1.0, v12 :: v_dual_add_f32 v11, 1.0, v11
; GFX11-TRUE16-NEXT:    v_add_f32_e32 v10, 1.0, v10
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v7, 24, v12
; GFX11-TRUE16-NEXT:    v_lshrrev_b64 v[3:4], 24, v[11:12]
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX11-TRUE16-NEXT:    v_lshrrev_b64 v[13:14], 24, v[10:11]
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v9, 8, v10
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v5, 8, v12
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v1, 8, v11
; GFX11-TRUE16-NEXT:  .LBB20_4: ; %end
; GFX11-TRUE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v0.l, v11.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v2.l, v11.h
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v4.l, v12.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v6.l, v12.h
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v8.l, v10.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v10.l, v10.h
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v11.l, v13.l
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-FAKE16-LABEL: bitcast_v3f32_to_v12i8:
; GFX11-FAKE16:       ; %bb.0:
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-FAKE16-NEXT:    v_dual_mov_b32 v8, v2 :: v_dual_mov_b32 v13, v0
; GFX11-FAKE16-NEXT:    v_mov_b32_e32 v14, v1
; GFX11-FAKE16-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v3
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr1
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr2
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr3
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr5
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr6
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr7
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr9
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr10
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr11
; GFX11-FAKE16-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-FAKE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_cbranch_execz .LBB20_2
; GFX11-FAKE16-NEXT:  ; %bb.1: ; %cmp.false
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v9, 8, v8
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v10, 16, v8
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v7, 24, v14
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v6, 16, v14
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v5, 8, v14
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v2, 16, v13
; GFX11-FAKE16-NEXT:    v_lshrrev_b64 v[11:12], 24, v[8:9]
; GFX11-FAKE16-NEXT:    v_lshrrev_b64 v[3:4], 24, v[13:14]
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 8, v13
; GFX11-FAKE16-NEXT:  .LBB20_2: ; %Flow
; GFX11-FAKE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-FAKE16-NEXT:    s_cbranch_execz .LBB20_4
; GFX11-FAKE16-NEXT:  ; %bb.3: ; %cmp.true
; GFX11-FAKE16-NEXT:    v_add_f32_e32 v8, 1.0, v8
; GFX11-FAKE16-NEXT:    v_dual_add_f32 v14, 1.0, v14 :: v_dual_add_f32 v13, 1.0, v13
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v9, 8, v8
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v10, 16, v8
; GFX11-FAKE16-NEXT:    v_lshrrev_b64 v[3:4], 24, v[13:14]
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v7, 24, v14
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v6, 16, v14
; GFX11-FAKE16-NEXT:    v_lshrrev_b64 v[11:12], 24, v[8:9]
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v5, 8, v14
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v2, 16, v13
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 8, v13
; GFX11-FAKE16-NEXT:  .LBB20_4: ; %end
; GFX11-FAKE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-FAKE16-NEXT:    v_mov_b32_e32 v0, v13
; GFX11-FAKE16-NEXT:    v_mov_b32_e32 v4, v14
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <3 x float> %a, splat (float 1.000000e+00)
  %a2 = bitcast <3 x float> %a1 to <12 x i8>
  br label %end

cmp.false:
  %a3 = bitcast <3 x float> %a to <12 x i8>
  br label %end

end:
  %phi = phi <12 x i8> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <12 x i8> %phi
}

define inreg <12 x i8> @bitcast_v3f32_to_v12i8_scalar(<3 x float> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v3f32_to_v12i8_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s19, 0
; SI-NEXT:    s_cbranch_scc0 .LBB21_3
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    v_mov_b32_e32 v0, s18
; SI-NEXT:    v_alignbit_b32 v11, s4, v0, 24
; SI-NEXT:    v_alignbit_b32 v10, s4, v0, 16
; SI-NEXT:    v_alignbit_b32 v9, s4, v0, 8
; SI-NEXT:    v_mov_b32_e32 v0, s16
; SI-NEXT:    v_alignbit_b32 v3, s17, v0, 24
; SI-NEXT:    v_alignbit_b32 v2, s17, v0, 16
; SI-NEXT:    v_alignbit_b32 v1, s17, v0, 8
; SI-NEXT:    s_lshr_b32 s6, s17, 24
; SI-NEXT:    s_lshr_b32 s7, s17, 16
; SI-NEXT:    s_lshr_b32 s8, s17, 8
; SI-NEXT:    s_cbranch_execnz .LBB21_4
; SI-NEXT:  .LBB21_2: ; %cmp.true
; SI-NEXT:    v_add_f32_e64 v8, s18, 1.0
; SI-NEXT:    v_add_f32_e64 v4, s17, 1.0
; SI-NEXT:    v_add_f32_e64 v0, s16, 1.0
; SI-NEXT:    v_alignbit_b32 v3, v4, v0, 24
; SI-NEXT:    v_alignbit_b32 v2, v4, v0, 16
; SI-NEXT:    v_alignbit_b32 v1, v4, v0, 8
; SI-NEXT:    v_alignbit_b32 v11, s4, v8, 24
; SI-NEXT:    v_alignbit_b32 v10, s4, v8, 16
; SI-NEXT:    v_alignbit_b32 v9, s4, v8, 8
; SI-NEXT:    v_lshrrev_b32_e32 v7, 24, v4
; SI-NEXT:    v_lshrrev_b32_e32 v6, 16, v4
; SI-NEXT:    v_lshrrev_b32_e32 v5, 8, v4
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB21_3:
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    ; implicit-def: $sgpr8
; SI-NEXT:    ; implicit-def: $sgpr7
; SI-NEXT:    ; implicit-def: $sgpr6
; SI-NEXT:    ; implicit-def: $vgpr9
; SI-NEXT:    ; implicit-def: $vgpr10
; SI-NEXT:    ; implicit-def: $vgpr11
; SI-NEXT:    s_branch .LBB21_2
; SI-NEXT:  .LBB21_4:
; SI-NEXT:    v_mov_b32_e32 v0, s16
; SI-NEXT:    v_mov_b32_e32 v4, s17
; SI-NEXT:    v_mov_b32_e32 v8, s18
; SI-NEXT:    v_mov_b32_e32 v5, s8
; SI-NEXT:    v_mov_b32_e32 v6, s7
; SI-NEXT:    v_mov_b32_e32 v7, s6
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v3f32_to_v12i8_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s19, 0
; VI-NEXT:    s_cbranch_scc0 .LBB21_3
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_lshr_b32 s19, s16, 8
; VI-NEXT:    s_lshr_b32 s10, s18, 16
; VI-NEXT:    s_lshr_b32 s11, s18, 8
; VI-NEXT:    s_lshr_b32 s12, s17, 24
; VI-NEXT:    s_lshr_b32 s13, s17, 16
; VI-NEXT:    s_lshr_b32 s15, s17, 8
; VI-NEXT:    s_lshr_b32 s14, s16, 16
; VI-NEXT:    s_lshr_b64 s[6:7], s[18:19], 24
; VI-NEXT:    s_lshr_b64 s[4:5], s[16:17], 24
; VI-NEXT:    s_cbranch_execnz .LBB21_4
; VI-NEXT:  .LBB21_2: ; %cmp.true
; VI-NEXT:    v_add_f32_e64 v8, s18, 1.0
; VI-NEXT:    v_add_f32_e64 v14, s17, 1.0
; VI-NEXT:    v_add_f32_e64 v13, s16, 1.0
; VI-NEXT:    v_lshrrev_b32_e32 v9, 8, v8
; VI-NEXT:    v_lshrrev_b64 v[3:4], 24, v[13:14]
; VI-NEXT:    v_lshrrev_b64 v[11:12], 24, v[8:9]
; VI-NEXT:    v_lshrrev_b32_e32 v10, 16, v8
; VI-NEXT:    v_lshrrev_b32_e32 v7, 24, v14
; VI-NEXT:    v_lshrrev_b32_e32 v6, 16, v14
; VI-NEXT:    v_lshrrev_b32_e32 v5, 8, v14
; VI-NEXT:    v_lshrrev_b32_e32 v2, 16, v13
; VI-NEXT:    v_lshrrev_b32_e32 v1, 8, v13
; VI-NEXT:    s_branch .LBB21_5
; VI-NEXT:  .LBB21_3:
; VI-NEXT:    ; implicit-def: $sgpr19
; VI-NEXT:    ; implicit-def: $sgpr14
; VI-NEXT:    ; implicit-def: $sgpr4
; VI-NEXT:    ; implicit-def: $sgpr15
; VI-NEXT:    ; implicit-def: $sgpr13
; VI-NEXT:    ; implicit-def: $sgpr12
; VI-NEXT:    ; implicit-def: $sgpr11
; VI-NEXT:    ; implicit-def: $sgpr10
; VI-NEXT:    ; implicit-def: $sgpr6
; VI-NEXT:    s_branch .LBB21_2
; VI-NEXT:  .LBB21_4:
; VI-NEXT:    v_mov_b32_e32 v13, s16
; VI-NEXT:    v_mov_b32_e32 v14, s17
; VI-NEXT:    v_mov_b32_e32 v8, s18
; VI-NEXT:    v_mov_b32_e32 v1, s19
; VI-NEXT:    v_mov_b32_e32 v2, s14
; VI-NEXT:    v_mov_b32_e32 v5, s15
; VI-NEXT:    v_mov_b32_e32 v6, s13
; VI-NEXT:    v_mov_b32_e32 v7, s12
; VI-NEXT:    v_mov_b32_e32 v9, s11
; VI-NEXT:    v_mov_b32_e32 v10, s10
; VI-NEXT:    v_mov_b32_e32 v11, s6
; VI-NEXT:    v_mov_b32_e32 v3, s4
; VI-NEXT:  .LBB21_5: ; %end
; VI-NEXT:    v_mov_b32_e32 v0, v13
; VI-NEXT:    v_mov_b32_e32 v4, v14
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v3f32_to_v12i8_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s19, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB21_3
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_lshr_b32 s19, s16, 8
; GFX9-NEXT:    s_lshr_b32 s10, s18, 16
; GFX9-NEXT:    s_lshr_b32 s11, s18, 8
; GFX9-NEXT:    s_lshr_b32 s12, s17, 24
; GFX9-NEXT:    s_lshr_b32 s13, s17, 16
; GFX9-NEXT:    s_lshr_b32 s15, s17, 8
; GFX9-NEXT:    s_lshr_b32 s14, s16, 16
; GFX9-NEXT:    s_lshr_b64 s[6:7], s[18:19], 24
; GFX9-NEXT:    s_lshr_b64 s[4:5], s[16:17], 24
; GFX9-NEXT:    s_cbranch_execnz .LBB21_4
; GFX9-NEXT:  .LBB21_2: ; %cmp.true
; GFX9-NEXT:    v_add_f32_e64 v8, s18, 1.0
; GFX9-NEXT:    v_add_f32_e64 v14, s17, 1.0
; GFX9-NEXT:    v_add_f32_e64 v13, s16, 1.0
; GFX9-NEXT:    v_lshrrev_b32_e32 v9, 8, v8
; GFX9-NEXT:    v_lshrrev_b64 v[3:4], 24, v[13:14]
; GFX9-NEXT:    v_lshrrev_b64 v[11:12], 24, v[8:9]
; GFX9-NEXT:    v_lshrrev_b32_e32 v10, 16, v8
; GFX9-NEXT:    v_lshrrev_b32_e32 v7, 24, v14
; GFX9-NEXT:    v_lshrrev_b32_e32 v6, 16, v14
; GFX9-NEXT:    v_lshrrev_b32_e32 v5, 8, v14
; GFX9-NEXT:    v_lshrrev_b32_e32 v2, 16, v13
; GFX9-NEXT:    v_lshrrev_b32_e32 v1, 8, v13
; GFX9-NEXT:    s_branch .LBB21_5
; GFX9-NEXT:  .LBB21_3:
; GFX9-NEXT:    ; implicit-def: $sgpr19
; GFX9-NEXT:    ; implicit-def: $sgpr14
; GFX9-NEXT:    ; implicit-def: $sgpr4
; GFX9-NEXT:    ; implicit-def: $sgpr15
; GFX9-NEXT:    ; implicit-def: $sgpr13
; GFX9-NEXT:    ; implicit-def: $sgpr12
; GFX9-NEXT:    ; implicit-def: $sgpr11
; GFX9-NEXT:    ; implicit-def: $sgpr10
; GFX9-NEXT:    ; implicit-def: $sgpr6
; GFX9-NEXT:    s_branch .LBB21_2
; GFX9-NEXT:  .LBB21_4:
; GFX9-NEXT:    v_mov_b32_e32 v13, s16
; GFX9-NEXT:    v_mov_b32_e32 v14, s17
; GFX9-NEXT:    v_mov_b32_e32 v8, s18
; GFX9-NEXT:    v_mov_b32_e32 v1, s19
; GFX9-NEXT:    v_mov_b32_e32 v2, s14
; GFX9-NEXT:    v_mov_b32_e32 v5, s15
; GFX9-NEXT:    v_mov_b32_e32 v6, s13
; GFX9-NEXT:    v_mov_b32_e32 v7, s12
; GFX9-NEXT:    v_mov_b32_e32 v9, s11
; GFX9-NEXT:    v_mov_b32_e32 v10, s10
; GFX9-NEXT:    v_mov_b32_e32 v11, s6
; GFX9-NEXT:    v_mov_b32_e32 v3, s4
; GFX9-NEXT:  .LBB21_5: ; %end
; GFX9-NEXT:    v_mov_b32_e32 v0, v13
; GFX9-NEXT:    v_mov_b32_e32 v4, v14
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v3f32_to_v12i8_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_cmp_lg_u32 s3, 0
; GFX11-NEXT:    s_mov_b32 s3, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB21_3
; GFX11-NEXT:  ; %bb.1: ; %cmp.false
; GFX11-NEXT:    s_lshr_b32 s8, s2, 16
; GFX11-NEXT:    s_lshr_b32 s9, s2, 8
; GFX11-NEXT:    s_lshr_b32 s10, s1, 24
; GFX11-NEXT:    s_lshr_b32 s11, s1, 16
; GFX11-NEXT:    s_lshr_b32 s13, s1, 8
; GFX11-NEXT:    s_lshr_b32 s12, s0, 16
; GFX11-NEXT:    s_lshr_b32 s14, s0, 8
; GFX11-NEXT:    s_lshr_b64 s[6:7], s[2:3], 24
; GFX11-NEXT:    s_lshr_b64 s[4:5], s[0:1], 24
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s3
; GFX11-NEXT:    s_cbranch_vccnz .LBB21_4
; GFX11-NEXT:  .LBB21_2: ; %cmp.true
; GFX11-NEXT:    v_add_f32_e64 v8, s2, 1.0
; GFX11-NEXT:    v_add_f32_e64 v14, s1, 1.0
; GFX11-NEXT:    v_add_f32_e64 v13, s0, 1.0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_lshrrev_b32_e32 v9, 8, v8
; GFX11-NEXT:    v_lshrrev_b32_e32 v10, 16, v8
; GFX11-NEXT:    v_lshrrev_b64 v[3:4], 24, v[13:14]
; GFX11-NEXT:    v_lshrrev_b32_e32 v7, 24, v14
; GFX11-NEXT:    v_lshrrev_b32_e32 v6, 16, v14
; GFX11-NEXT:    v_lshrrev_b64 v[11:12], 24, v[8:9]
; GFX11-NEXT:    v_lshrrev_b32_e32 v5, 8, v14
; GFX11-NEXT:    v_lshrrev_b32_e32 v2, 16, v13
; GFX11-NEXT:    v_lshrrev_b32_e32 v1, 8, v13
; GFX11-NEXT:    s_branch .LBB21_5
; GFX11-NEXT:  .LBB21_3:
; GFX11-NEXT:    ; implicit-def: $sgpr14
; GFX11-NEXT:    ; implicit-def: $sgpr12
; GFX11-NEXT:    ; implicit-def: $sgpr4
; GFX11-NEXT:    ; implicit-def: $sgpr13
; GFX11-NEXT:    ; implicit-def: $sgpr11
; GFX11-NEXT:    ; implicit-def: $sgpr10
; GFX11-NEXT:    ; implicit-def: $sgpr9
; GFX11-NEXT:    ; implicit-def: $sgpr8
; GFX11-NEXT:    ; implicit-def: $sgpr6
; GFX11-NEXT:    s_branch .LBB21_2
; GFX11-NEXT:  .LBB21_4:
; GFX11-NEXT:    v_dual_mov_b32 v13, s0 :: v_dual_mov_b32 v14, s1
; GFX11-NEXT:    v_dual_mov_b32 v8, s2 :: v_dual_mov_b32 v1, s14
; GFX11-NEXT:    v_dual_mov_b32 v2, s12 :: v_dual_mov_b32 v5, s13
; GFX11-NEXT:    v_dual_mov_b32 v6, s11 :: v_dual_mov_b32 v7, s10
; GFX11-NEXT:    v_dual_mov_b32 v9, s9 :: v_dual_mov_b32 v10, s8
; GFX11-NEXT:    v_mov_b32_e32 v11, s6
; GFX11-NEXT:    v_mov_b32_e32 v3, s4
; GFX11-NEXT:  .LBB21_5: ; %end
; GFX11-NEXT:    v_mov_b32_e32 v0, v13
; GFX11-NEXT:    v_mov_b32_e32 v4, v14
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <3 x float> %a, splat (float 1.000000e+00)
  %a2 = bitcast <3 x float> %a1 to <12 x i8>
  br label %end

cmp.false:
  %a3 = bitcast <3 x float> %a to <12 x i8>
  br label %end

end:
  %phi = phi <12 x i8> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <12 x i8> %phi
}

define <3 x float> @bitcast_v12i8_to_v3f32(<12 x i8> %a, i32 %b) {
; SI-LABEL: bitcast_v12i8_to_v3f32:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v14, v2
; SI-NEXT:    v_mov_b32_e32 v13, v0
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v12
; SI-NEXT:    v_lshlrev_b32_e32 v16, 8, v1
; SI-NEXT:    v_lshlrev_b32_e32 v15, 24, v3
; SI-NEXT:    v_lshlrev_b32_e32 v12, 8, v5
; SI-NEXT:    v_lshlrev_b32_e32 v7, 24, v7
; SI-NEXT:    v_lshlrev_b32_e32 v5, 8, v9
; SI-NEXT:    v_lshlrev_b32_e32 v3, 24, v11
; SI-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB22_3
; SI-NEXT:  ; %bb.1: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB22_4
; SI-NEXT:  .LBB22_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB22_3: ; %cmp.false
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v13
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v14
; SI-NEXT:    v_or_b32_e32 v0, v0, v16
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v1, v15, v1
; SI-NEXT:    v_or_b32_e32 v0, v0, v1
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v4
; SI-NEXT:    v_and_b32_e32 v2, 0xff, v6
; SI-NEXT:    v_or_b32_e32 v1, v1, v12
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; SI-NEXT:    v_or_b32_e32 v2, v7, v2
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_and_b32_e32 v2, 0xff, v8
; SI-NEXT:    v_and_b32_e32 v4, 0xff, v10
; SI-NEXT:    v_or_b32_e32 v2, v2, v5
; SI-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; SI-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; SI-NEXT:    v_or_b32_e32 v3, v3, v4
; SI-NEXT:    v_or_b32_e32 v2, v2, v3
; SI-NEXT:    ; implicit-def: $vgpr13
; SI-NEXT:    ; implicit-def: $vgpr14
; SI-NEXT:    ; implicit-def: $vgpr4
; SI-NEXT:    ; implicit-def: $vgpr6
; SI-NEXT:    ; implicit-def: $vgpr8
; SI-NEXT:    ; implicit-def: $vgpr10
; SI-NEXT:    ; implicit-def: $vgpr16
; SI-NEXT:    ; implicit-def: $vgpr15
; SI-NEXT:    ; implicit-def: $vgpr12
; SI-NEXT:    ; implicit-def: $vgpr7
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB22_2
; SI-NEXT:  .LBB22_4: ; %cmp.true
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v13
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v0
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v14
; SI-NEXT:    v_or_b32_e32 v0, v16, v0
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v1
; SI-NEXT:    v_add_i32_e32 v0, vcc, 0x300, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v1, v15, v1
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v4
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v1
; SI-NEXT:    v_add_i32_e32 v2, vcc, 3, v6
; SI-NEXT:    s_movk_i32 s6, 0x300
; SI-NEXT:    v_or_b32_e32 v1, v12, v1
; SI-NEXT:    v_and_b32_e32 v2, 0xff, v2
; SI-NEXT:    v_add_i32_e32 v1, vcc, s6, v1
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; SI-NEXT:    v_or_b32_e32 v2, v7, v2
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    v_add_i32_e32 v2, vcc, 3, v8
; SI-NEXT:    v_and_b32_e32 v2, 0xff, v2
; SI-NEXT:    v_add_i32_e32 v4, vcc, 3, v10
; SI-NEXT:    v_or_b32_e32 v2, v5, v2
; SI-NEXT:    v_and_b32_e32 v4, 0xff, v4
; SI-NEXT:    v_add_i32_e32 v2, vcc, 0x300, v2
; SI-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; SI-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; SI-NEXT:    v_or_b32_e32 v3, v3, v4
; SI-NEXT:    s_mov_b32 s7, 0x3000000
; SI-NEXT:    v_or_b32_e32 v2, v3, v2
; SI-NEXT:    v_add_i32_e32 v0, vcc, s7, v0
; SI-NEXT:    v_add_i32_e32 v1, vcc, 0x3000000, v1
; SI-NEXT:    v_add_i32_e32 v2, vcc, 0x3000000, v2
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v12i8_to_v3f32:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v14, v2
; VI-NEXT:    v_mov_b32_e32 v13, v0
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v12
; VI-NEXT:    v_lshlrev_b16_e32 v16, 8, v1
; VI-NEXT:    v_lshlrev_b16_e32 v15, 8, v3
; VI-NEXT:    v_lshlrev_b16_e32 v12, 8, v5
; VI-NEXT:    v_lshlrev_b16_e32 v7, 8, v7
; VI-NEXT:    v_lshlrev_b16_e32 v5, 8, v9
; VI-NEXT:    v_lshlrev_b16_e32 v3, 8, v11
; VI-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_cbranch_execnz .LBB22_3
; VI-NEXT:  ; %bb.1: ; %Flow
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execnz .LBB22_4
; VI-NEXT:  .LBB22_2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB22_3: ; %cmp.false
; VI-NEXT:    v_or_b32_sdwa v0, v13, v16 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v14, v15 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v4, v12 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v2, v6, v7 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v2, v8, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v3, v10, v3 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v2, v2, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    ; implicit-def: $vgpr13
; VI-NEXT:    ; implicit-def: $vgpr14
; VI-NEXT:    ; implicit-def: $vgpr4
; VI-NEXT:    ; implicit-def: $vgpr6
; VI-NEXT:    ; implicit-def: $vgpr8
; VI-NEXT:    ; implicit-def: $vgpr10
; VI-NEXT:    ; implicit-def: $vgpr16
; VI-NEXT:    ; implicit-def: $vgpr15
; VI-NEXT:    ; implicit-def: $vgpr12
; VI-NEXT:    ; implicit-def: $vgpr7
; VI-NEXT:    ; implicit-def: $vgpr5
; VI-NEXT:    ; implicit-def: $vgpr3
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB22_2
; VI-NEXT:  .LBB22_4: ; %cmp.true
; VI-NEXT:    v_add_u16_e32 v0, 3, v13
; VI-NEXT:    v_add_u16_e32 v1, 3, v14
; VI-NEXT:    v_or_b32_sdwa v0, v16, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_or_b32_sdwa v1, v15, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_mov_b32_e32 v2, 0x300
; VI-NEXT:    v_add_u16_e32 v0, 0x300, v0
; VI-NEXT:    v_add_u16_sdwa v1, v1, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v0, v0, v1
; VI-NEXT:    v_add_u16_e32 v1, 3, v4
; VI-NEXT:    v_add_u16_e32 v4, 3, v6
; VI-NEXT:    v_or_b32_sdwa v1, v12, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_or_b32_sdwa v4, v7, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_add_u16_e32 v1, 0x300, v1
; VI-NEXT:    v_add_u16_sdwa v4, v4, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v1, v1, v4
; VI-NEXT:    v_add_u16_e32 v4, 3, v8
; VI-NEXT:    v_or_b32_sdwa v4, v5, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_add_u16_e32 v5, 3, v10
; VI-NEXT:    v_or_b32_sdwa v3, v3, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_add_u16_e32 v4, 0x300, v4
; VI-NEXT:    v_add_u16_sdwa v2, v3, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v2, v4, v2
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v12i8_to_v3f32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v14, v2
; GFX9-NEXT:    v_mov_b32_e32 v13, v0
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v12
; GFX9-NEXT:    v_lshlrev_b16_e32 v16, 8, v1
; GFX9-NEXT:    v_lshlrev_b16_e32 v15, 8, v3
; GFX9-NEXT:    v_lshlrev_b16_e32 v12, 8, v5
; GFX9-NEXT:    v_lshlrev_b16_e32 v7, 8, v7
; GFX9-NEXT:    v_lshlrev_b16_e32 v5, 8, v9
; GFX9-NEXT:    v_lshlrev_b16_e32 v3, 8, v11
; GFX9-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_cbranch_execnz .LBB22_3
; GFX9-NEXT:  ; %bb.1: ; %Flow
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:    s_cbranch_execnz .LBB22_4
; GFX9-NEXT:  .LBB22_2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB22_3: ; %cmp.false
; GFX9-NEXT:    v_or_b32_sdwa v0, v13, v16 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v1, v14, v15 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v1, v4, v12 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v2, v6, v7 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v2, v8, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v3, v10, v3 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v2, v2, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    ; implicit-def: $vgpr13
; GFX9-NEXT:    ; implicit-def: $vgpr14
; GFX9-NEXT:    ; implicit-def: $vgpr4
; GFX9-NEXT:    ; implicit-def: $vgpr6
; GFX9-NEXT:    ; implicit-def: $vgpr8
; GFX9-NEXT:    ; implicit-def: $vgpr10
; GFX9-NEXT:    ; implicit-def: $vgpr16
; GFX9-NEXT:    ; implicit-def: $vgpr15
; GFX9-NEXT:    ; implicit-def: $vgpr12
; GFX9-NEXT:    ; implicit-def: $vgpr7
; GFX9-NEXT:    ; implicit-def: $vgpr5
; GFX9-NEXT:    ; implicit-def: $vgpr3
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB22_2
; GFX9-NEXT:  .LBB22_4: ; %cmp.true
; GFX9-NEXT:    v_add_u16_e32 v0, 3, v13
; GFX9-NEXT:    v_add_u16_e32 v1, 3, v14
; GFX9-NEXT:    v_or_b32_sdwa v0, v16, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    s_movk_i32 s6, 0x300
; GFX9-NEXT:    v_or_b32_sdwa v1, v15, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u16_e32 v0, 0x300, v0
; GFX9-NEXT:    v_add_u16_sdwa v1, v1, s6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX9-NEXT:    v_add_u16_e32 v1, 3, v4
; GFX9-NEXT:    v_add_u16_e32 v2, 3, v6
; GFX9-NEXT:    v_or_b32_sdwa v1, v12, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_or_b32_sdwa v2, v7, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u16_e32 v1, 0x300, v1
; GFX9-NEXT:    v_add_u16_sdwa v2, v2, s6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_e32 v1, v1, v2
; GFX9-NEXT:    v_add_u16_e32 v2, 3, v8
; GFX9-NEXT:    v_add_u16_e32 v4, 3, v10
; GFX9-NEXT:    v_or_b32_sdwa v2, v5, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_or_b32_sdwa v3, v3, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u16_e32 v2, 0x300, v2
; GFX9-NEXT:    v_add_u16_sdwa v3, v3, s6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_e32 v2, v2, v3
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-TRUE16-LABEL: bitcast_v12i8_to_v3f32:
; GFX11-TRUE16:       ; %bb.0:
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v8.h, v7.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v6.h, v4.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v7.l, v2.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v7.h, v0.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v5.h, 8, v1.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v4.h, 8, v3.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v5.l, 8, v5.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v4.l, 8, v8.h
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v3.l, 8, v9.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v3.h, 8, v11.l
; GFX11-TRUE16-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2
; GFX11-TRUE16-NEXT:    v_cmpx_ne_u32_e32 0, v12
; GFX11-TRUE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-TRUE16-NEXT:    s_cbranch_execnz .LBB22_3
; GFX11-TRUE16-NEXT:  ; %bb.1: ; %Flow
; GFX11-TRUE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-TRUE16-NEXT:    s_cbranch_execnz .LBB22_4
; GFX11-TRUE16-NEXT:  .LBB22_2: ; %end
; GFX11-TRUE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
; GFX11-TRUE16-NEXT:  .LBB22_3: ; %cmp.false
; GFX11-TRUE16-NEXT:    v_and_b16 v0.l, 0xff, v7.h
; GFX11-TRUE16-NEXT:    v_and_b16 v0.h, 0xff, v7.l
; GFX11-TRUE16-NEXT:    v_and_b16 v1.l, 0xff, v6.h
; GFX11-TRUE16-NEXT:    v_and_b16 v1.h, 0xff, v6.l
; GFX11-TRUE16-NEXT:    v_and_b16 v2.l, 0xff, v8.l
; GFX11-TRUE16-NEXT:    v_or_b16 v0.l, v0.l, v5.h
; GFX11-TRUE16-NEXT:    v_and_b16 v2.h, 0xff, v10.l
; GFX11-TRUE16-NEXT:    v_or_b16 v6.l, v0.h, v4.h
; GFX11-TRUE16-NEXT:    v_or_b16 v1.l, v1.l, v5.l
; GFX11-TRUE16-NEXT:    v_or_b16 v4.l, v1.h, v4.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v5.l, v0.l
; GFX11-TRUE16-NEXT:    v_or_b16 v0.l, v2.l, v3.l
; GFX11-TRUE16-NEXT:    v_or_b16 v2.l, v2.h, v3.h
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v3, 0xffff, v5
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v5, 16, v6
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v6, 0xffff, v0
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v0, v3, v5
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v1, v1, v4
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v2, v6, v2
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr7_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr7_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr6_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr6_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr8_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr10_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr5_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr4_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr5_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr4_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr3_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr3_hi16
; GFX11-TRUE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-TRUE16-NEXT:    s_cbranch_execz .LBB22_2
; GFX11-TRUE16-NEXT:  .LBB22_4: ; %cmp.true
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v0.l, v7.h, 3
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v0.h, v7.l, 3
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v1.l, v6.h, 3
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v1.h, v6.l, 3
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v2.l, v8.l, 3
; GFX11-TRUE16-NEXT:    v_and_b16 v0.l, 0xff, v0.l
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v2.h, v10.l, 3
; GFX11-TRUE16-NEXT:    v_and_b16 v0.h, 0xff, v0.h
; GFX11-TRUE16-NEXT:    v_and_b16 v1.l, 0xff, v1.l
; GFX11-TRUE16-NEXT:    v_and_b16 v1.h, 0xff, v1.h
; GFX11-TRUE16-NEXT:    v_or_b16 v0.l, v5.h, v0.l
; GFX11-TRUE16-NEXT:    v_and_b16 v2.l, 0xff, v2.l
; GFX11-TRUE16-NEXT:    v_and_b16 v2.h, 0xff, v2.h
; GFX11-TRUE16-NEXT:    v_or_b16 v0.h, v4.h, v0.h
; GFX11-TRUE16-NEXT:    v_or_b16 v1.l, v5.l, v1.l
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v0.l, 0x300, v0.l
; GFX11-TRUE16-NEXT:    v_or_b16 v1.h, v4.l, v1.h
; GFX11-TRUE16-NEXT:    v_or_b16 v2.l, v3.l, v2.l
; GFX11-TRUE16-NEXT:    v_or_b16 v2.h, v3.h, v2.h
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v3.l, 0x300, v0.h
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v5.l, v0.l
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v0.l, 0x300, v1.l
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v1.l, 0x300, v1.h
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v2.l, 0x300, v2.l
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v4.l, 0x300, v2.h
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v5, 0xffff, v5
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v6, 0xffff, v0
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v0, v5, v3
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v1, v6, v1
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v2, v2, v4
; GFX11-TRUE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-FAKE16-LABEL: bitcast_v12i8_to_v3f32:
; GFX11-FAKE16:       ; %bb.0:
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-FAKE16-NEXT:    v_dual_mov_b32 v14, v2 :: v_dual_mov_b32 v13, v0
; GFX11-FAKE16-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v12
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v16, 8, v1
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v12, 8, v3
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v15, 8, v5
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v7, 8, v7
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v3, 8, v9
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v5, 8, v11
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2
; GFX11-FAKE16-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-FAKE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_cbranch_execnz .LBB22_3
; GFX11-FAKE16-NEXT:  ; %bb.1: ; %Flow
; GFX11-FAKE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-FAKE16-NEXT:    s_cbranch_execnz .LBB22_4
; GFX11-FAKE16-NEXT:  .LBB22_2: ; %end
; GFX11-FAKE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
; GFX11-FAKE16-NEXT:  .LBB22_3: ; %cmp.false
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v0, 0xff, v13
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v1, 0xff, v14
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v2, 0xff, v4
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v4, 0xff, v6
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v6, 0xff, v8
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v8, 0xff, v10
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v0, v0, v16
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v1, v1, v12
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v2, v2, v15
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v4, v4, v7
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v3, v6, v3
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v5, v8, v5
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr13
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr14
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr6
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr8
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr10
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr16
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr12
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr15
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr7
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v1, v2, v4
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr4
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v2, v3, v5
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr3
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr5
; GFX11-FAKE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-FAKE16-NEXT:    s_cbranch_execz .LBB22_2
; GFX11-FAKE16-NEXT:  .LBB22_4: ; %cmp.true
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v0, v13, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v1, v14, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v2, v4, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v4, v6, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v6, v8, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v8, v10, 3
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v1, 0xff, v1
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v2, 0xff, v2
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v4, 0xff, v4
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v6, 0xff, v6
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v8, 0xff, v8
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v0, v16, v0
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v1, v12, v1
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v2, v15, v2
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v4, v7, v4
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v3, v3, v6
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v5, v5, v8
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v0, 0x300, v0
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v1, 0x300, v1
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v2, 0x300, v2
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v4, 0x300, v4
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v3, 0x300, v3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v5, 0x300, v5
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v1, v2, v4
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v2, v3, v5
; GFX11-FAKE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <12 x i8> %a, splat (i8 3)
  %a2 = bitcast <12 x i8> %a1 to <3 x float>
  br label %end

cmp.false:
  %a3 = bitcast <12 x i8> %a to <3 x float>
  br label %end

end:
  %phi = phi <3 x float> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <3 x float> %phi
}

define inreg <3 x float> @bitcast_v12i8_to_v3f32_scalar(<12 x i8> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v12i8_to_v3f32_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s28, 0
; SI-NEXT:    s_cbranch_scc0 .LBB23_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_and_b32 s4, s16, 0xff
; SI-NEXT:    s_lshl_b32 s5, s17, 8
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    s_and_b32 s5, s18, 0xff
; SI-NEXT:    s_lshl_b32 s5, s5, 16
; SI-NEXT:    s_lshl_b32 s6, s19, 24
; SI-NEXT:    s_and_b32 s4, s4, 0xffff
; SI-NEXT:    s_or_b32 s5, s6, s5
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    s_and_b32 s5, s20, 0xff
; SI-NEXT:    s_lshl_b32 s6, s21, 8
; SI-NEXT:    s_or_b32 s5, s5, s6
; SI-NEXT:    s_and_b32 s6, s22, 0xff
; SI-NEXT:    s_lshl_b32 s6, s6, 16
; SI-NEXT:    s_lshl_b32 s7, s23, 24
; SI-NEXT:    s_and_b32 s5, s5, 0xffff
; SI-NEXT:    s_or_b32 s6, s7, s6
; SI-NEXT:    s_or_b32 s5, s5, s6
; SI-NEXT:    s_and_b32 s6, s24, 0xff
; SI-NEXT:    s_lshl_b32 s7, s25, 8
; SI-NEXT:    s_or_b32 s6, s6, s7
; SI-NEXT:    s_and_b32 s7, s26, 0xff
; SI-NEXT:    s_lshl_b32 s7, s7, 16
; SI-NEXT:    s_lshl_b32 s8, s27, 24
; SI-NEXT:    s_and_b32 s6, s6, 0xffff
; SI-NEXT:    s_or_b32 s7, s8, s7
; SI-NEXT:    s_or_b32 s6, s6, s7
; SI-NEXT:    s_cbranch_execnz .LBB23_3
; SI-NEXT:  .LBB23_2: ; %cmp.true
; SI-NEXT:    s_add_i32 s16, s16, 3
; SI-NEXT:    s_and_b32 s4, s16, 0xff
; SI-NEXT:    s_lshl_b32 s5, s17, 8
; SI-NEXT:    s_add_i32 s18, s18, 3
; SI-NEXT:    s_or_b32 s4, s5, s4
; SI-NEXT:    s_and_b32 s6, s18, 0xff
; SI-NEXT:    s_addk_i32 s4, 0x300
; SI-NEXT:    s_lshl_b32 s5, s19, 24
; SI-NEXT:    s_lshl_b32 s6, s6, 16
; SI-NEXT:    s_and_b32 s4, s4, 0xffff
; SI-NEXT:    s_or_b32 s5, s5, s6
; SI-NEXT:    s_add_i32 s20, s20, 3
; SI-NEXT:    s_or_b32 s4, s5, s4
; SI-NEXT:    s_and_b32 s5, s20, 0xff
; SI-NEXT:    s_lshl_b32 s6, s21, 8
; SI-NEXT:    s_add_i32 s22, s22, 3
; SI-NEXT:    s_or_b32 s5, s6, s5
; SI-NEXT:    s_and_b32 s7, s22, 0xff
; SI-NEXT:    s_addk_i32 s5, 0x300
; SI-NEXT:    s_lshl_b32 s6, s23, 24
; SI-NEXT:    s_lshl_b32 s7, s7, 16
; SI-NEXT:    s_and_b32 s5, s5, 0xffff
; SI-NEXT:    s_or_b32 s6, s6, s7
; SI-NEXT:    s_add_i32 s24, s24, 3
; SI-NEXT:    s_or_b32 s5, s6, s5
; SI-NEXT:    s_and_b32 s6, s24, 0xff
; SI-NEXT:    s_lshl_b32 s7, s25, 8
; SI-NEXT:    s_add_i32 s26, s26, 3
; SI-NEXT:    s_or_b32 s6, s7, s6
; SI-NEXT:    s_and_b32 s8, s26, 0xff
; SI-NEXT:    s_addk_i32 s6, 0x300
; SI-NEXT:    s_lshl_b32 s7, s27, 24
; SI-NEXT:    s_lshl_b32 s8, s8, 16
; SI-NEXT:    s_and_b32 s6, s6, 0xffff
; SI-NEXT:    s_or_b32 s7, s7, s8
; SI-NEXT:    s_or_b32 s6, s7, s6
; SI-NEXT:    s_add_i32 s4, s4, 0x3000000
; SI-NEXT:    s_add_i32 s5, s5, 0x3000000
; SI-NEXT:    s_add_i32 s6, s6, 0x3000000
; SI-NEXT:  .LBB23_3: ; %end
; SI-NEXT:    v_mov_b32_e32 v0, s4
; SI-NEXT:    v_mov_b32_e32 v1, s5
; SI-NEXT:    v_mov_b32_e32 v2, s6
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB23_4:
; SI-NEXT:    ; implicit-def: $sgpr4_sgpr5_sgpr6
; SI-NEXT:    s_branch .LBB23_2
;
; VI-LABEL: bitcast_v12i8_to_v3f32_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s28, 0
; VI-NEXT:    s_cbranch_scc0 .LBB23_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_and_b32 s4, s16, 0xff
; VI-NEXT:    s_lshl_b32 s5, s17, 8
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_and_b32 s5, s18, 0xff
; VI-NEXT:    s_lshl_b32 s6, s19, 8
; VI-NEXT:    s_or_b32 s5, s5, s6
; VI-NEXT:    s_and_b32 s4, s4, 0xffff
; VI-NEXT:    s_lshl_b32 s5, s5, 16
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_and_b32 s5, s20, 0xff
; VI-NEXT:    s_lshl_b32 s6, s21, 8
; VI-NEXT:    s_or_b32 s5, s5, s6
; VI-NEXT:    s_and_b32 s6, s22, 0xff
; VI-NEXT:    s_lshl_b32 s7, s23, 8
; VI-NEXT:    s_or_b32 s6, s6, s7
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_lshl_b32 s6, s6, 16
; VI-NEXT:    s_or_b32 s5, s5, s6
; VI-NEXT:    s_and_b32 s6, s24, 0xff
; VI-NEXT:    s_lshl_b32 s7, s25, 8
; VI-NEXT:    s_or_b32 s6, s6, s7
; VI-NEXT:    s_and_b32 s7, s26, 0xff
; VI-NEXT:    s_lshl_b32 s8, s27, 8
; VI-NEXT:    s_or_b32 s7, s7, s8
; VI-NEXT:    s_and_b32 s6, s6, 0xffff
; VI-NEXT:    s_lshl_b32 s7, s7, 16
; VI-NEXT:    s_or_b32 s6, s6, s7
; VI-NEXT:    s_cbranch_execnz .LBB23_3
; VI-NEXT:  .LBB23_2: ; %cmp.true
; VI-NEXT:    s_add_i32 s16, s16, 3
; VI-NEXT:    s_and_b32 s4, s16, 0xff
; VI-NEXT:    s_lshl_b32 s5, s17, 8
; VI-NEXT:    s_add_i32 s18, s18, 3
; VI-NEXT:    s_or_b32 s4, s5, s4
; VI-NEXT:    s_and_b32 s5, s18, 0xff
; VI-NEXT:    s_lshl_b32 s6, s19, 8
; VI-NEXT:    s_addk_i32 s4, 0x300
; VI-NEXT:    s_or_b32 s5, s6, s5
; VI-NEXT:    s_and_b32 s4, s4, 0xffff
; VI-NEXT:    s_lshl_b32 s5, s5, 16
; VI-NEXT:    s_add_i32 s20, s20, 3
; VI-NEXT:    s_or_b32 s4, s5, s4
; VI-NEXT:    s_and_b32 s5, s20, 0xff
; VI-NEXT:    s_lshl_b32 s6, s21, 8
; VI-NEXT:    s_add_i32 s22, s22, 3
; VI-NEXT:    s_or_b32 s5, s6, s5
; VI-NEXT:    s_and_b32 s6, s22, 0xff
; VI-NEXT:    s_lshl_b32 s7, s23, 8
; VI-NEXT:    s_addk_i32 s5, 0x300
; VI-NEXT:    s_or_b32 s6, s7, s6
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_lshl_b32 s6, s6, 16
; VI-NEXT:    s_add_i32 s24, s24, 3
; VI-NEXT:    s_or_b32 s5, s6, s5
; VI-NEXT:    s_and_b32 s6, s24, 0xff
; VI-NEXT:    s_lshl_b32 s7, s25, 8
; VI-NEXT:    s_add_i32 s26, s26, 3
; VI-NEXT:    s_or_b32 s6, s7, s6
; VI-NEXT:    s_and_b32 s7, s26, 0xff
; VI-NEXT:    s_lshl_b32 s8, s27, 8
; VI-NEXT:    s_addk_i32 s6, 0x300
; VI-NEXT:    s_or_b32 s7, s8, s7
; VI-NEXT:    s_and_b32 s6, s6, 0xffff
; VI-NEXT:    s_lshl_b32 s7, s7, 16
; VI-NEXT:    s_or_b32 s6, s7, s6
; VI-NEXT:    s_add_i32 s4, s4, 0x3000000
; VI-NEXT:    s_add_i32 s5, s5, 0x3000000
; VI-NEXT:    s_add_i32 s6, s6, 0x3000000
; VI-NEXT:  .LBB23_3: ; %end
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    v_mov_b32_e32 v1, s5
; VI-NEXT:    v_mov_b32_e32 v2, s6
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB23_4:
; VI-NEXT:    ; implicit-def: $sgpr4_sgpr5_sgpr6
; VI-NEXT:    s_branch .LBB23_2
;
; GFX9-LABEL: bitcast_v12i8_to_v3f32_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s28, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB23_4
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_and_b32 s4, s16, 0xff
; GFX9-NEXT:    s_lshl_b32 s5, s17, 8
; GFX9-NEXT:    s_or_b32 s4, s4, s5
; GFX9-NEXT:    s_and_b32 s5, s18, 0xff
; GFX9-NEXT:    s_lshl_b32 s6, s19, 8
; GFX9-NEXT:    s_or_b32 s5, s5, s6
; GFX9-NEXT:    s_and_b32 s4, s4, 0xffff
; GFX9-NEXT:    s_lshl_b32 s5, s5, 16
; GFX9-NEXT:    s_or_b32 s4, s4, s5
; GFX9-NEXT:    s_and_b32 s5, s20, 0xff
; GFX9-NEXT:    s_lshl_b32 s6, s21, 8
; GFX9-NEXT:    s_or_b32 s5, s5, s6
; GFX9-NEXT:    s_and_b32 s6, s22, 0xff
; GFX9-NEXT:    s_lshl_b32 s7, s23, 8
; GFX9-NEXT:    s_or_b32 s6, s6, s7
; GFX9-NEXT:    s_and_b32 s5, s5, 0xffff
; GFX9-NEXT:    s_lshl_b32 s6, s6, 16
; GFX9-NEXT:    s_or_b32 s5, s5, s6
; GFX9-NEXT:    s_and_b32 s6, s24, 0xff
; GFX9-NEXT:    s_lshl_b32 s7, s25, 8
; GFX9-NEXT:    s_or_b32 s6, s6, s7
; GFX9-NEXT:    s_and_b32 s7, s26, 0xff
; GFX9-NEXT:    s_lshl_b32 s8, s27, 8
; GFX9-NEXT:    s_or_b32 s7, s7, s8
; GFX9-NEXT:    s_and_b32 s6, s6, 0xffff
; GFX9-NEXT:    s_lshl_b32 s7, s7, 16
; GFX9-NEXT:    s_or_b32 s6, s6, s7
; GFX9-NEXT:    s_cbranch_execnz .LBB23_3
; GFX9-NEXT:  .LBB23_2: ; %cmp.true
; GFX9-NEXT:    s_add_i32 s16, s16, 3
; GFX9-NEXT:    s_and_b32 s4, s16, 0xff
; GFX9-NEXT:    s_lshl_b32 s5, s17, 8
; GFX9-NEXT:    s_add_i32 s18, s18, 3
; GFX9-NEXT:    s_or_b32 s4, s5, s4
; GFX9-NEXT:    s_and_b32 s5, s18, 0xff
; GFX9-NEXT:    s_lshl_b32 s6, s19, 8
; GFX9-NEXT:    s_or_b32 s5, s6, s5
; GFX9-NEXT:    s_addk_i32 s4, 0x300
; GFX9-NEXT:    s_addk_i32 s5, 0x300
; GFX9-NEXT:    s_and_b32 s4, s4, 0xffff
; GFX9-NEXT:    s_lshl_b32 s5, s5, 16
; GFX9-NEXT:    s_add_i32 s20, s20, 3
; GFX9-NEXT:    s_or_b32 s4, s4, s5
; GFX9-NEXT:    s_and_b32 s5, s20, 0xff
; GFX9-NEXT:    s_lshl_b32 s6, s21, 8
; GFX9-NEXT:    s_add_i32 s22, s22, 3
; GFX9-NEXT:    s_or_b32 s5, s6, s5
; GFX9-NEXT:    s_and_b32 s6, s22, 0xff
; GFX9-NEXT:    s_lshl_b32 s7, s23, 8
; GFX9-NEXT:    s_or_b32 s6, s7, s6
; GFX9-NEXT:    s_addk_i32 s5, 0x300
; GFX9-NEXT:    s_addk_i32 s6, 0x300
; GFX9-NEXT:    s_and_b32 s5, s5, 0xffff
; GFX9-NEXT:    s_lshl_b32 s6, s6, 16
; GFX9-NEXT:    s_add_i32 s24, s24, 3
; GFX9-NEXT:    s_or_b32 s5, s5, s6
; GFX9-NEXT:    s_and_b32 s6, s24, 0xff
; GFX9-NEXT:    s_lshl_b32 s7, s25, 8
; GFX9-NEXT:    s_add_i32 s26, s26, 3
; GFX9-NEXT:    s_or_b32 s6, s7, s6
; GFX9-NEXT:    s_and_b32 s7, s26, 0xff
; GFX9-NEXT:    s_lshl_b32 s8, s27, 8
; GFX9-NEXT:    s_or_b32 s7, s8, s7
; GFX9-NEXT:    s_addk_i32 s6, 0x300
; GFX9-NEXT:    s_addk_i32 s7, 0x300
; GFX9-NEXT:    s_and_b32 s6, s6, 0xffff
; GFX9-NEXT:    s_lshl_b32 s7, s7, 16
; GFX9-NEXT:    s_or_b32 s6, s6, s7
; GFX9-NEXT:  .LBB23_3: ; %end
; GFX9-NEXT:    v_mov_b32_e32 v0, s4
; GFX9-NEXT:    v_mov_b32_e32 v1, s5
; GFX9-NEXT:    v_mov_b32_e32 v2, s6
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB23_4:
; GFX9-NEXT:    ; implicit-def: $sgpr4_sgpr5_sgpr6
; GFX9-NEXT:    s_branch .LBB23_2
;
; GFX11-LABEL: bitcast_v12i8_to_v3f32_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_cmp_lg_u32 s24, 0
; GFX11-NEXT:    s_mov_b32 s7, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB23_4
; GFX11-NEXT:  ; %bb.1: ; %cmp.false
; GFX11-NEXT:    s_and_b32 s4, s0, 0xff
; GFX11-NEXT:    s_lshl_b32 s5, s1, 8
; GFX11-NEXT:    s_and_b32 s6, s2, 0xff
; GFX11-NEXT:    s_lshl_b32 s8, s3, 8
; GFX11-NEXT:    s_or_b32 s4, s4, s5
; GFX11-NEXT:    s_or_b32 s5, s6, s8
; GFX11-NEXT:    s_and_b32 s4, s4, 0xffff
; GFX11-NEXT:    s_lshl_b32 s5, s5, 16
; GFX11-NEXT:    s_lshl_b32 s6, s17, 8
; GFX11-NEXT:    s_or_b32 s4, s4, s5
; GFX11-NEXT:    s_and_b32 s5, s16, 0xff
; GFX11-NEXT:    s_and_b32 s8, s18, 0xff
; GFX11-NEXT:    s_lshl_b32 s9, s19, 8
; GFX11-NEXT:    s_or_b32 s5, s5, s6
; GFX11-NEXT:    s_or_b32 s6, s8, s9
; GFX11-NEXT:    s_and_b32 s8, s20, 0xff
; GFX11-NEXT:    s_lshl_b32 s9, s21, 8
; GFX11-NEXT:    s_and_b32 s10, s22, 0xff
; GFX11-NEXT:    s_lshl_b32 s11, s23, 8
; GFX11-NEXT:    s_or_b32 s8, s8, s9
; GFX11-NEXT:    s_or_b32 s9, s10, s11
; GFX11-NEXT:    s_and_b32 s5, s5, 0xffff
; GFX11-NEXT:    s_lshl_b32 s6, s6, 16
; GFX11-NEXT:    s_and_b32 s8, s8, 0xffff
; GFX11-NEXT:    s_lshl_b32 s9, s9, 16
; GFX11-NEXT:    s_or_b32 s5, s5, s6
; GFX11-NEXT:    s_or_b32 s6, s8, s9
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s7
; GFX11-NEXT:    s_cbranch_vccnz .LBB23_3
; GFX11-NEXT:  .LBB23_2: ; %cmp.true
; GFX11-NEXT:    s_add_i32 s0, s0, 3
; GFX11-NEXT:    s_add_i32 s2, s2, 3
; GFX11-NEXT:    s_and_b32 s0, s0, 0xff
; GFX11-NEXT:    s_lshl_b32 s1, s1, 8
; GFX11-NEXT:    s_and_b32 s2, s2, 0xff
; GFX11-NEXT:    s_lshl_b32 s3, s3, 8
; GFX11-NEXT:    s_or_b32 s0, s1, s0
; GFX11-NEXT:    s_or_b32 s1, s3, s2
; GFX11-NEXT:    s_addk_i32 s0, 0x300
; GFX11-NEXT:    s_addk_i32 s1, 0x300
; GFX11-NEXT:    s_and_b32 s0, s0, 0xffff
; GFX11-NEXT:    s_lshl_b32 s1, s1, 16
; GFX11-NEXT:    s_add_i32 s16, s16, 3
; GFX11-NEXT:    s_or_b32 s4, s0, s1
; GFX11-NEXT:    s_and_b32 s0, s16, 0xff
; GFX11-NEXT:    s_lshl_b32 s1, s17, 8
; GFX11-NEXT:    s_add_i32 s18, s18, 3
; GFX11-NEXT:    s_or_b32 s0, s1, s0
; GFX11-NEXT:    s_and_b32 s1, s18, 0xff
; GFX11-NEXT:    s_lshl_b32 s2, s19, 8
; GFX11-NEXT:    s_add_i32 s20, s20, 3
; GFX11-NEXT:    s_add_i32 s22, s22, 3
; GFX11-NEXT:    s_or_b32 s1, s2, s1
; GFX11-NEXT:    s_and_b32 s2, s20, 0xff
; GFX11-NEXT:    s_lshl_b32 s3, s21, 8
; GFX11-NEXT:    s_and_b32 s5, s22, 0xff
; GFX11-NEXT:    s_lshl_b32 s6, s23, 8
; GFX11-NEXT:    s_or_b32 s2, s3, s2
; GFX11-NEXT:    s_or_b32 s3, s6, s5
; GFX11-NEXT:    s_addk_i32 s0, 0x300
; GFX11-NEXT:    s_addk_i32 s1, 0x300
; GFX11-NEXT:    s_addk_i32 s2, 0x300
; GFX11-NEXT:    s_addk_i32 s3, 0x300
; GFX11-NEXT:    s_and_b32 s0, s0, 0xffff
; GFX11-NEXT:    s_lshl_b32 s1, s1, 16
; GFX11-NEXT:    s_and_b32 s2, s2, 0xffff
; GFX11-NEXT:    s_lshl_b32 s3, s3, 16
; GFX11-NEXT:    s_or_b32 s5, s0, s1
; GFX11-NEXT:    s_or_b32 s6, s2, s3
; GFX11-NEXT:  .LBB23_3: ; %end
; GFX11-NEXT:    v_dual_mov_b32 v0, s4 :: v_dual_mov_b32 v1, s5
; GFX11-NEXT:    v_mov_b32_e32 v2, s6
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB23_4:
; GFX11-NEXT:    ; implicit-def: $sgpr4_sgpr5_sgpr6
; GFX11-NEXT:    s_branch .LBB23_2
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <12 x i8> %a, splat (i8 3)
  %a2 = bitcast <12 x i8> %a1 to <3 x float>
  br label %end

cmp.false:
  %a3 = bitcast <12 x i8> %a to <3 x float>
  br label %end

end:
  %phi = phi <3 x float> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <3 x float> %phi
}

define <6 x bfloat> @bitcast_v3f32_to_v6bf16(<3 x float> %a, i32 %b) {
; SI-LABEL: bitcast_v3f32_to_v6bf16:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v8, v2
; SI-NEXT:    v_mov_b32_e32 v7, v1
; SI-NEXT:    v_mov_b32_e32 v6, v0
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v3
; SI-NEXT:    ; implicit-def: $vgpr0
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    ; implicit-def: $vgpr4
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB24_3
; SI-NEXT:  ; %bb.1: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB24_4
; SI-NEXT:  .LBB24_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB24_3: ; %cmp.false
; SI-NEXT:    v_and_b32_e32 v5, 0xffff0000, v8
; SI-NEXT:    v_lshlrev_b32_e32 v4, 16, v8
; SI-NEXT:    v_and_b32_e32 v3, 0xffff0000, v7
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v7
; SI-NEXT:    v_and_b32_e32 v1, 0xffff0000, v6
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v6
; SI-NEXT:    ; implicit-def: $vgpr6
; SI-NEXT:    ; implicit-def: $vgpr7
; SI-NEXT:    ; implicit-def: $vgpr8
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB24_2
; SI-NEXT:  .LBB24_4: ; %cmp.true
; SI-NEXT:    v_add_f32_e32 v0, 1.0, v6
; SI-NEXT:    v_add_f32_e32 v1, 1.0, v7
; SI-NEXT:    v_add_f32_e32 v2, 1.0, v8
; SI-NEXT:    v_and_b32_e32 v5, 0xffff0000, v2
; SI-NEXT:    v_lshlrev_b32_e32 v4, 16, v2
; SI-NEXT:    v_and_b32_e32 v3, 0xffff0000, v1
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v1
; SI-NEXT:    v_and_b32_e32 v1, 0xffff0000, v0
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v3f32_to_v6bf16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v3
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_add_f32_e32 v2, 1.0, v2
; VI-NEXT:    v_add_f32_e32 v1, 1.0, v1
; VI-NEXT:    v_add_f32_e32 v0, 1.0, v0
; VI-NEXT:  ; %bb.2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v3f32_to_v6bf16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v3
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_add_f32_e32 v2, 1.0, v2
; GFX9-NEXT:    v_add_f32_e32 v1, 1.0, v1
; GFX9-NEXT:    v_add_f32_e32 v0, 1.0, v0
; GFX9-NEXT:  ; %bb.2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v3f32_to_v6bf16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v3
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_dual_add_f32 v2, 1.0, v2 :: v_dual_add_f32 v1, 1.0, v1
; GFX11-NEXT:    v_add_f32_e32 v0, 1.0, v0
; GFX11-NEXT:  ; %bb.2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <3 x float> %a, splat (float 1.000000e+00)
  %a2 = bitcast <3 x float> %a1 to <6 x bfloat>
  br label %end

cmp.false:
  %a3 = bitcast <3 x float> %a to <6 x bfloat>
  br label %end

end:
  %phi = phi <6 x bfloat> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <6 x bfloat> %phi
}

define inreg <6 x bfloat> @bitcast_v3f32_to_v6bf16_scalar(<3 x float> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v3f32_to_v6bf16_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s19, 0
; SI-NEXT:    s_cbranch_scc0 .LBB25_3
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_and_b32 s6, s18, 0xffff0000
; SI-NEXT:    s_lshl_b32 s7, s18, 16
; SI-NEXT:    s_and_b32 s8, s17, 0xffff0000
; SI-NEXT:    s_lshl_b32 s9, s17, 16
; SI-NEXT:    s_and_b32 s10, s16, 0xffff0000
; SI-NEXT:    s_lshl_b32 s11, s16, 16
; SI-NEXT:    s_cbranch_execnz .LBB25_4
; SI-NEXT:  .LBB25_2: ; %cmp.true
; SI-NEXT:    v_add_f32_e64 v0, s16, 1.0
; SI-NEXT:    v_add_f32_e64 v1, s17, 1.0
; SI-NEXT:    v_add_f32_e64 v2, s18, 1.0
; SI-NEXT:    v_and_b32_e32 v5, 0xffff0000, v2
; SI-NEXT:    v_lshlrev_b32_e32 v4, 16, v2
; SI-NEXT:    v_and_b32_e32 v3, 0xffff0000, v1
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v1
; SI-NEXT:    v_and_b32_e32 v1, 0xffff0000, v0
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB25_3:
; SI-NEXT:    ; implicit-def: $sgpr11
; SI-NEXT:    ; implicit-def: $sgpr10
; SI-NEXT:    ; implicit-def: $sgpr9
; SI-NEXT:    ; implicit-def: $sgpr8
; SI-NEXT:    ; implicit-def: $sgpr7
; SI-NEXT:    ; implicit-def: $sgpr6
; SI-NEXT:    s_branch .LBB25_2
; SI-NEXT:  .LBB25_4:
; SI-NEXT:    v_mov_b32_e32 v0, s11
; SI-NEXT:    v_mov_b32_e32 v1, s10
; SI-NEXT:    v_mov_b32_e32 v2, s9
; SI-NEXT:    v_mov_b32_e32 v3, s8
; SI-NEXT:    v_mov_b32_e32 v4, s7
; SI-NEXT:    v_mov_b32_e32 v5, s6
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v3f32_to_v6bf16_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s19, 0
; VI-NEXT:    s_cbranch_scc0 .LBB25_3
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB25_4
; VI-NEXT:  .LBB25_2: ; %cmp.true
; VI-NEXT:    v_add_f32_e64 v2, s18, 1.0
; VI-NEXT:    v_add_f32_e64 v1, s17, 1.0
; VI-NEXT:    v_add_f32_e64 v0, s16, 1.0
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB25_3:
; VI-NEXT:    s_branch .LBB25_2
; VI-NEXT:  .LBB25_4:
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    v_mov_b32_e32 v2, s18
; VI-NEXT:    v_mov_b32_e32 v3, s19
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v3f32_to_v6bf16_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s19, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB25_3
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB25_4
; GFX9-NEXT:  .LBB25_2: ; %cmp.true
; GFX9-NEXT:    v_add_f32_e64 v2, s18, 1.0
; GFX9-NEXT:    v_add_f32_e64 v1, s17, 1.0
; GFX9-NEXT:    v_add_f32_e64 v0, s16, 1.0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB25_3:
; GFX9-NEXT:    s_branch .LBB25_2
; GFX9-NEXT:  .LBB25_4:
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-NEXT:    v_mov_b32_e32 v3, s19
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v3f32_to_v6bf16_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_cmp_lg_u32 s3, 0
; GFX11-NEXT:    s_mov_b32 s4, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB25_3
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s4
; GFX11-NEXT:    s_cbranch_vccnz .LBB25_4
; GFX11-NEXT:  .LBB25_2: ; %cmp.true
; GFX11-NEXT:    v_add_f32_e64 v2, s2, 1.0
; GFX11-NEXT:    v_add_f32_e64 v1, s1, 1.0
; GFX11-NEXT:    v_add_f32_e64 v0, s0, 1.0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB25_3:
; GFX11-NEXT:    s_branch .LBB25_2
; GFX11-NEXT:  .LBB25_4:
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <3 x float> %a, splat (float 1.000000e+00)
  %a2 = bitcast <3 x float> %a1 to <6 x bfloat>
  br label %end

cmp.false:
  %a3 = bitcast <3 x float> %a to <6 x bfloat>
  br label %end

end:
  %phi = phi <6 x bfloat> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <6 x bfloat> %phi
}

define <3 x float> @bitcast_v6bf16_to_v3f32(<6 x bfloat> %a, i32 %b) {
; SI-LABEL: bitcast_v6bf16_to_v3f32:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v6
; SI-NEXT:    v_mul_f32_e32 v8, 1.0, v1
; SI-NEXT:    v_mul_f32_e32 v9, 1.0, v0
; SI-NEXT:    v_mul_f32_e32 v6, 1.0, v3
; SI-NEXT:    v_mul_f32_e32 v7, 1.0, v2
; SI-NEXT:    v_mul_f32_e32 v3, 1.0, v5
; SI-NEXT:    v_mul_f32_e32 v4, 1.0, v4
; SI-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB26_3
; SI-NEXT:  ; %bb.1: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB26_4
; SI-NEXT:  .LBB26_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB26_3: ; %cmp.false
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v8
; SI-NEXT:    v_lshrrev_b32_e32 v1, 16, v6
; SI-NEXT:    v_lshrrev_b32_e32 v2, 16, v3
; SI-NEXT:    v_alignbit_b32 v0, v0, v9, 16
; SI-NEXT:    v_alignbit_b32 v1, v1, v7, 16
; SI-NEXT:    v_alignbit_b32 v2, v2, v4, 16
; SI-NEXT:    ; implicit-def: $vgpr9
; SI-NEXT:    ; implicit-def: $vgpr8
; SI-NEXT:    ; implicit-def: $vgpr7
; SI-NEXT:    ; implicit-def: $vgpr6
; SI-NEXT:    ; implicit-def: $vgpr4
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB26_2
; SI-NEXT:  .LBB26_4: ; %cmp.true
; SI-NEXT:    v_and_b32_e32 v1, 0xffff0000, v8
; SI-NEXT:    v_and_b32_e32 v0, 0xffff0000, v9
; SI-NEXT:    v_add_f32_e32 v1, 0x40c00000, v1
; SI-NEXT:    v_add_f32_e32 v0, 0x40c00000, v0
; SI-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_and_b32_e32 v2, 0xffff0000, v6
; SI-NEXT:    v_alignbit_b32 v0, v1, v0, 16
; SI-NEXT:    v_and_b32_e32 v1, 0xffff0000, v7
; SI-NEXT:    v_add_f32_e32 v2, 0x40c00000, v2
; SI-NEXT:    v_add_f32_e32 v1, 0x40c00000, v1
; SI-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_and_b32_e32 v3, 0xffff0000, v3
; SI-NEXT:    v_alignbit_b32 v1, v2, v1, 16
; SI-NEXT:    v_and_b32_e32 v2, 0xffff0000, v4
; SI-NEXT:    v_add_f32_e32 v3, 0x40c00000, v3
; SI-NEXT:    v_add_f32_e32 v2, 0x40c00000, v2
; SI-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; SI-NEXT:    v_alignbit_b32 v2, v3, v2, 16
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v6bf16_to_v3f32:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v3
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB26_2
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_lshlrev_b32_e32 v3, 16, v2
; VI-NEXT:    v_add_f32_e32 v3, 0x40c00000, v3
; VI-NEXT:    v_bfe_u32 v4, v3, 16, 1
; VI-NEXT:    v_add_u32_e32 v4, vcc, v4, v3
; VI-NEXT:    v_add_u32_e32 v4, vcc, 0x7fff, v4
; VI-NEXT:    v_and_b32_e32 v2, 0xffff0000, v2
; VI-NEXT:    v_or_b32_e32 v5, 0x400000, v3
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v3, v3
; VI-NEXT:    v_add_f32_e32 v2, 0x40c00000, v2
; VI-NEXT:    v_cndmask_b32_e32 v3, v4, v5, vcc
; VI-NEXT:    v_bfe_u32 v4, v2, 16, 1
; VI-NEXT:    s_movk_i32 s6, 0x7fff
; VI-NEXT:    v_add_u32_e32 v4, vcc, v4, v2
; VI-NEXT:    v_add_u32_e32 v4, vcc, s6, v4
; VI-NEXT:    v_or_b32_e32 v5, 0x400000, v2
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; VI-NEXT:    v_cndmask_b32_e32 v2, v4, v5, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; VI-NEXT:    v_alignbit_b32 v2, v2, v3, 16
; VI-NEXT:    v_lshlrev_b32_e32 v3, 16, v1
; VI-NEXT:    v_add_f32_e32 v3, 0x40c00000, v3
; VI-NEXT:    v_bfe_u32 v4, v3, 16, 1
; VI-NEXT:    v_add_u32_e32 v4, vcc, v4, v3
; VI-NEXT:    v_add_u32_e32 v4, vcc, s6, v4
; VI-NEXT:    v_and_b32_e32 v1, 0xffff0000, v1
; VI-NEXT:    v_or_b32_e32 v5, 0x400000, v3
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v3, v3
; VI-NEXT:    v_add_f32_e32 v1, 0x40c00000, v1
; VI-NEXT:    v_cndmask_b32_e32 v3, v4, v5, vcc
; VI-NEXT:    v_bfe_u32 v4, v1, 16, 1
; VI-NEXT:    v_add_u32_e32 v4, vcc, v4, v1
; VI-NEXT:    v_add_u32_e32 v4, vcc, s6, v4
; VI-NEXT:    v_or_b32_e32 v5, 0x400000, v1
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; VI-NEXT:    v_cndmask_b32_e32 v1, v4, v5, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; VI-NEXT:    v_alignbit_b32 v1, v1, v3, 16
; VI-NEXT:    v_lshlrev_b32_e32 v3, 16, v0
; VI-NEXT:    v_add_f32_e32 v3, 0x40c00000, v3
; VI-NEXT:    v_bfe_u32 v4, v3, 16, 1
; VI-NEXT:    v_add_u32_e32 v4, vcc, v4, v3
; VI-NEXT:    v_add_u32_e32 v4, vcc, s6, v4
; VI-NEXT:    v_and_b32_e32 v0, 0xffff0000, v0
; VI-NEXT:    v_or_b32_e32 v5, 0x400000, v3
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v3, v3
; VI-NEXT:    v_add_f32_e32 v0, 0x40c00000, v0
; VI-NEXT:    v_cndmask_b32_e32 v3, v4, v5, vcc
; VI-NEXT:    v_bfe_u32 v4, v0, 16, 1
; VI-NEXT:    v_add_u32_e32 v4, vcc, v4, v0
; VI-NEXT:    v_add_u32_e32 v4, vcc, 0x7fff, v4
; VI-NEXT:    v_or_b32_e32 v5, 0x400000, v0
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v0, v0
; VI-NEXT:    v_cndmask_b32_e32 v0, v4, v5, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; VI-NEXT:    v_alignbit_b32 v0, v0, v3, 16
; VI-NEXT:  .LBB26_2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v6bf16_to_v3f32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v3
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB26_2
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_and_b32_e32 v3, 0xffff0000, v2
; GFX9-NEXT:    v_add_f32_e32 v3, 0x40c00000, v3
; GFX9-NEXT:    v_bfe_u32 v4, v3, 16, 1
; GFX9-NEXT:    s_movk_i32 s6, 0x7fff
; GFX9-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX9-NEXT:    v_add3_u32 v4, v4, v3, s6
; GFX9-NEXT:    v_or_b32_e32 v5, 0x400000, v3
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v3, v3
; GFX9-NEXT:    v_add_f32_e32 v2, 0x40c00000, v2
; GFX9-NEXT:    v_cndmask_b32_e32 v3, v4, v5, vcc
; GFX9-NEXT:    v_bfe_u32 v4, v2, 16, 1
; GFX9-NEXT:    v_add3_u32 v4, v4, v2, s6
; GFX9-NEXT:    v_or_b32_e32 v5, 0x400000, v2
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; GFX9-NEXT:    v_cndmask_b32_e32 v2, v4, v5, vcc
; GFX9-NEXT:    s_mov_b32 s7, 0x7060302
; GFX9-NEXT:    v_perm_b32 v2, v3, v2, s7
; GFX9-NEXT:    v_and_b32_e32 v3, 0xffff0000, v1
; GFX9-NEXT:    v_add_f32_e32 v3, 0x40c00000, v3
; GFX9-NEXT:    v_bfe_u32 v4, v3, 16, 1
; GFX9-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX9-NEXT:    v_add3_u32 v4, v4, v3, s6
; GFX9-NEXT:    v_or_b32_e32 v5, 0x400000, v3
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v3, v3
; GFX9-NEXT:    v_add_f32_e32 v1, 0x40c00000, v1
; GFX9-NEXT:    v_cndmask_b32_e32 v3, v4, v5, vcc
; GFX9-NEXT:    v_bfe_u32 v4, v1, 16, 1
; GFX9-NEXT:    v_add3_u32 v4, v4, v1, s6
; GFX9-NEXT:    v_or_b32_e32 v5, 0x400000, v1
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v4, v5, vcc
; GFX9-NEXT:    v_perm_b32 v1, v3, v1, s7
; GFX9-NEXT:    v_and_b32_e32 v3, 0xffff0000, v0
; GFX9-NEXT:    v_add_f32_e32 v3, 0x40c00000, v3
; GFX9-NEXT:    v_bfe_u32 v4, v3, 16, 1
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX9-NEXT:    v_add3_u32 v4, v4, v3, s6
; GFX9-NEXT:    v_or_b32_e32 v5, 0x400000, v3
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v3, v3
; GFX9-NEXT:    v_add_f32_e32 v0, 0x40c00000, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v3, v4, v5, vcc
; GFX9-NEXT:    v_bfe_u32 v4, v0, 16, 1
; GFX9-NEXT:    v_add3_u32 v4, v4, v0, s6
; GFX9-NEXT:    v_or_b32_e32 v5, 0x400000, v0
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v0, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v4, v5, vcc
; GFX9-NEXT:    v_perm_b32 v0, v3, v0, s7
; GFX9-NEXT:  .LBB26_2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-TRUE16-LABEL: bitcast_v6bf16_to_v3f32:
; GFX11-TRUE16:       ; %bb.0:
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-TRUE16-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-TRUE16-NEXT:    v_cmpx_ne_u32_e32 0, v3
; GFX11-TRUE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-TRUE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-TRUE16-NEXT:    s_cbranch_execz .LBB26_2
; GFX11-TRUE16-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v4, 0xffff0000, v1
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-TRUE16-NEXT:    v_dual_add_f32 v4, 0x40c00000, v4 :: v_dual_lshlrev_b32 v3, 16, v2
; GFX11-TRUE16-NEXT:    v_add_f32_e32 v3, 0x40c00000, v3
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-TRUE16-NEXT:    v_bfe_u32 v10, v4, 16, 1
; GFX11-TRUE16-NEXT:    v_bfe_u32 v6, v3, 16, 1
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v8, 0x400000, v3
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v3, v3
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-TRUE16-NEXT:    v_add3_u32 v6, v6, v3, 0x7fff
; GFX11-TRUE16-NEXT:    v_dual_cndmask_b32 v3, v6, v8 :: v_dual_and_b32 v2, 0xffff0000, v2
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX11-TRUE16-NEXT:    v_dual_add_f32 v2, 0x40c00000, v2 :: v_dual_lshlrev_b32 v1, 16, v1
; GFX11-TRUE16-NEXT:    v_add3_u32 v8, v10, v4, 0x7fff
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v3.l, v3.h
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX11-TRUE16-NEXT:    v_bfe_u32 v7, v2, 16, 1
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v9, 0x400000, v2
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v2, v2
; GFX11-TRUE16-NEXT:    v_add3_u32 v7, v7, v2, 0x7fff
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v5, 0xffff0000, v0
; GFX11-TRUE16-NEXT:    v_dual_add_f32 v1, 0x40c00000, v1 :: v_dual_lshlrev_b32 v0, 16, v0
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX11-TRUE16-NEXT:    v_cndmask_b32_e32 v2, v7, v9, vcc_lo
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v9, 0x400000, v4
; GFX11-TRUE16-NEXT:    v_add_f32_e32 v0, 0x40c00000, v0
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_bfe_u32 v6, v1, 16, 1
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v10, 0x400000, v1
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v1, v1
; GFX11-TRUE16-NEXT:    v_bfi_b32 v2, 0xffff, v3, v2
; GFX11-TRUE16-NEXT:    v_bfe_u32 v7, v0, 16, 1
; GFX11-TRUE16-NEXT:    v_add3_u32 v6, v6, v1, 0x7fff
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v12, 0x400000, v0
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-TRUE16-NEXT:    v_add3_u32 v7, v7, v0, 0x7fff
; GFX11-TRUE16-NEXT:    v_cndmask_b32_e32 v1, v6, v10, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v0, v0
; GFX11-TRUE16-NEXT:    v_add_f32_e32 v5, 0x40c00000, v5
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v1.l, v1.h
; GFX11-TRUE16-NEXT:    v_cndmask_b32_e32 v0, v7, v12, vcc_lo
; GFX11-TRUE16-NEXT:    v_bfe_u32 v11, v5, 16, 1
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v4, v4
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v10, 0x400000, v5
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v0.l, v0.h
; GFX11-TRUE16-NEXT:    v_add3_u32 v6, v11, v5, 0x7fff
; GFX11-TRUE16-NEXT:    v_cndmask_b32_e32 v4, v8, v9, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v5, v5
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-TRUE16-NEXT:    v_cndmask_b32_e32 v5, v6, v10, vcc_lo
; GFX11-TRUE16-NEXT:    v_bfi_b32 v1, 0xffff, v1, v4
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-TRUE16-NEXT:    v_bfi_b32 v0, 0xffff, v0, v5
; GFX11-TRUE16-NEXT:  .LBB26_2: ; %end
; GFX11-TRUE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-FAKE16-LABEL: bitcast_v6bf16_to_v3f32:
; GFX11-FAKE16:       ; %bb.0:
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-FAKE16-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-FAKE16-NEXT:    v_cmpx_ne_u32_e32 0, v3
; GFX11-FAKE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-FAKE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-FAKE16-NEXT:    s_cbranch_execz .LBB26_2
; GFX11-FAKE16-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v3, 0xffff0000, v2
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_dual_add_f32 v3, 0x40c00000, v3 :: v_dual_lshlrev_b32 v2, 16, v2
; GFX11-FAKE16-NEXT:    v_add_f32_e32 v2, 0x40c00000, v2
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_2) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_bfe_u32 v6, v3, 16, 1
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v8, 0x400000, v3
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v3, v3
; GFX11-FAKE16-NEXT:    v_bfe_u32 v7, v2, 16, 1
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v9, 0x400000, v2
; GFX11-FAKE16-NEXT:    v_add3_u32 v6, v6, v3, 0x7fff
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v4, 0xffff0000, v1
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX11-FAKE16-NEXT:    v_add3_u32 v7, v7, v2, 0x7fff
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v3, v6, v8, vcc_lo
; GFX11-FAKE16-NEXT:    v_add_f32_e32 v4, 0x40c00000, v4
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v2, v2
; GFX11-FAKE16-NEXT:    v_add_f32_e32 v1, 0x40c00000, v1
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_bfe_u32 v10, v4, 16, 1
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v2, v7, v9, vcc_lo
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v7, 0x400000, v4
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v4, v4
; GFX11-FAKE16-NEXT:    v_bfe_u32 v8, v1, 16, 1
; GFX11-FAKE16-NEXT:    v_add3_u32 v6, v10, v4, 0x7fff
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v5, 0xffff0000, v0
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX11-FAKE16-NEXT:    v_perm_b32 v2, v3, v2, 0x7060302
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_3) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v4, v6, v7 :: v_dual_add_f32 v5, 0x40c00000, v5
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v1, v1
; GFX11-FAKE16-NEXT:    v_add3_u32 v7, v8, v1, 0x7fff
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v8, 0x400000, v1
; GFX11-FAKE16-NEXT:    v_bfe_u32 v9, v5, 16, 1
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v10, 0x400000, v5
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v1, v7, v8, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v5, v5
; GFX11-FAKE16-NEXT:    v_add3_u32 v9, v9, v5, 0x7fff
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_dual_add_f32 v0, 0x40c00000, v0 :: v_dual_cndmask_b32 v5, v9, v10
; GFX11-FAKE16-NEXT:    v_bfe_u32 v6, v0, 16, 1
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v11, 0x400000, v0
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v0, v0
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_add3_u32 v6, v6, v0, 0x7fff
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v6, v11, vcc_lo
; GFX11-FAKE16-NEXT:    v_perm_b32 v1, v4, v1, 0x7060302
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_perm_b32 v0, v5, v0, 0x7060302
; GFX11-FAKE16-NEXT:  .LBB26_2: ; %end
; GFX11-FAKE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <6 x bfloat> %a, splat (bfloat 0xR40C0)
  %a2 = bitcast <6 x bfloat> %a1 to <3 x float>
  br label %end

cmp.false:
  %a3 = bitcast <6 x bfloat> %a to <3 x float>
  br label %end

end:
  %phi = phi <3 x float> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <3 x float> %phi
}

define inreg <3 x float> @bitcast_v6bf16_to_v3f32_scalar(<6 x bfloat> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v6bf16_to_v3f32_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s22, 0
; SI-NEXT:    v_mul_f32_e64 v7, 1.0, s17
; SI-NEXT:    v_mul_f32_e64 v8, 1.0, s16
; SI-NEXT:    v_mul_f32_e64 v5, 1.0, s19
; SI-NEXT:    v_mul_f32_e64 v6, 1.0, s18
; SI-NEXT:    v_mul_f32_e64 v3, 1.0, s21
; SI-NEXT:    v_mul_f32_e64 v4, 1.0, s20
; SI-NEXT:    s_cbranch_scc0 .LBB27_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v7
; SI-NEXT:    v_lshrrev_b32_e32 v1, 16, v5
; SI-NEXT:    v_lshrrev_b32_e32 v2, 16, v3
; SI-NEXT:    v_alignbit_b32 v0, v0, v8, 16
; SI-NEXT:    v_alignbit_b32 v1, v1, v6, 16
; SI-NEXT:    v_alignbit_b32 v2, v2, v4, 16
; SI-NEXT:    s_cbranch_execnz .LBB27_3
; SI-NEXT:  .LBB27_2: ; %cmp.true
; SI-NEXT:    v_and_b32_e32 v1, 0xffff0000, v7
; SI-NEXT:    v_and_b32_e32 v0, 0xffff0000, v8
; SI-NEXT:    v_add_f32_e32 v1, 0x40c00000, v1
; SI-NEXT:    v_add_f32_e32 v0, 0x40c00000, v0
; SI-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_and_b32_e32 v2, 0xffff0000, v5
; SI-NEXT:    v_alignbit_b32 v0, v1, v0, 16
; SI-NEXT:    v_and_b32_e32 v1, 0xffff0000, v6
; SI-NEXT:    v_add_f32_e32 v2, 0x40c00000, v2
; SI-NEXT:    v_add_f32_e32 v1, 0x40c00000, v1
; SI-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_and_b32_e32 v3, 0xffff0000, v3
; SI-NEXT:    v_alignbit_b32 v1, v2, v1, 16
; SI-NEXT:    v_and_b32_e32 v2, 0xffff0000, v4
; SI-NEXT:    v_add_f32_e32 v3, 0x40c00000, v3
; SI-NEXT:    v_add_f32_e32 v2, 0x40c00000, v2
; SI-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; SI-NEXT:    v_alignbit_b32 v2, v3, v2, 16
; SI-NEXT:  .LBB27_3: ; %end
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB27_4:
; SI-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2
; SI-NEXT:    s_branch .LBB27_2
;
; VI-LABEL: bitcast_v6bf16_to_v3f32_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s19, 0
; VI-NEXT:    s_cbranch_scc0 .LBB27_3
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB27_4
; VI-NEXT:  .LBB27_2: ; %cmp.true
; VI-NEXT:    s_lshl_b32 s4, s18, 16
; VI-NEXT:    v_mov_b32_e32 v0, 0x40c00000
; VI-NEXT:    v_add_f32_e32 v1, s4, v0
; VI-NEXT:    v_bfe_u32 v2, v1, 16, 1
; VI-NEXT:    v_add_u32_e32 v2, vcc, v2, v1
; VI-NEXT:    v_add_u32_e32 v2, vcc, 0x7fff, v2
; VI-NEXT:    v_or_b32_e32 v3, 0x400000, v1
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; VI-NEXT:    s_and_b32 s4, s18, 0xffff0000
; VI-NEXT:    v_cndmask_b32_e32 v1, v2, v3, vcc
; VI-NEXT:    v_add_f32_e32 v2, s4, v0
; VI-NEXT:    v_bfe_u32 v3, v2, 16, 1
; VI-NEXT:    v_add_u32_e32 v3, vcc, v3, v2
; VI-NEXT:    v_add_u32_e32 v3, vcc, 0x7fff, v3
; VI-NEXT:    v_or_b32_e32 v4, 0x400000, v2
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; VI-NEXT:    v_cndmask_b32_e32 v2, v3, v4, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; VI-NEXT:    s_lshl_b32 s4, s17, 16
; VI-NEXT:    v_alignbit_b32 v2, v2, v1, 16
; VI-NEXT:    v_add_f32_e32 v1, s4, v0
; VI-NEXT:    v_bfe_u32 v3, v1, 16, 1
; VI-NEXT:    v_add_u32_e32 v3, vcc, v3, v1
; VI-NEXT:    v_add_u32_e32 v3, vcc, 0x7fff, v3
; VI-NEXT:    v_or_b32_e32 v4, 0x400000, v1
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; VI-NEXT:    s_and_b32 s4, s17, 0xffff0000
; VI-NEXT:    v_cndmask_b32_e32 v1, v3, v4, vcc
; VI-NEXT:    v_add_f32_e32 v3, s4, v0
; VI-NEXT:    v_bfe_u32 v4, v3, 16, 1
; VI-NEXT:    v_add_u32_e32 v4, vcc, v4, v3
; VI-NEXT:    v_add_u32_e32 v4, vcc, 0x7fff, v4
; VI-NEXT:    v_or_b32_e32 v5, 0x400000, v3
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v3, v3
; VI-NEXT:    v_cndmask_b32_e32 v3, v4, v5, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; VI-NEXT:    s_lshl_b32 s4, s16, 16
; VI-NEXT:    v_alignbit_b32 v1, v3, v1, 16
; VI-NEXT:    v_add_f32_e32 v3, s4, v0
; VI-NEXT:    v_bfe_u32 v4, v3, 16, 1
; VI-NEXT:    v_add_u32_e32 v4, vcc, v4, v3
; VI-NEXT:    v_add_u32_e32 v4, vcc, 0x7fff, v4
; VI-NEXT:    s_and_b32 s4, s16, 0xffff0000
; VI-NEXT:    v_or_b32_e32 v5, 0x400000, v3
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v3, v3
; VI-NEXT:    v_add_f32_e32 v0, s4, v0
; VI-NEXT:    v_cndmask_b32_e32 v3, v4, v5, vcc
; VI-NEXT:    v_bfe_u32 v4, v0, 16, 1
; VI-NEXT:    v_add_u32_e32 v4, vcc, v4, v0
; VI-NEXT:    v_add_u32_e32 v4, vcc, 0x7fff, v4
; VI-NEXT:    v_or_b32_e32 v5, 0x400000, v0
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v0, v0
; VI-NEXT:    v_cndmask_b32_e32 v0, v4, v5, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; VI-NEXT:    v_alignbit_b32 v0, v0, v3, 16
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB27_3:
; VI-NEXT:    s_branch .LBB27_2
; VI-NEXT:  .LBB27_4:
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    v_mov_b32_e32 v2, s18
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v6bf16_to_v3f32_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s19, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB27_3
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB27_4
; GFX9-NEXT:  .LBB27_2: ; %cmp.true
; GFX9-NEXT:    s_pack_lh_b32_b16 s4, 0, s18
; GFX9-NEXT:    v_mov_b32_e32 v0, 0x40c00000
; GFX9-NEXT:    v_add_f32_e32 v1, s4, v0
; GFX9-NEXT:    v_bfe_u32 v2, v1, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v2, v2, v1
; GFX9-NEXT:    v_add_u32_e32 v2, 0x7fff, v2
; GFX9-NEXT:    v_or_b32_e32 v3, 0x400000, v1
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; GFX9-NEXT:    s_lshl_b32 s4, s18, 16
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v2, v3, vcc
; GFX9-NEXT:    v_add_f32_e32 v2, s4, v0
; GFX9-NEXT:    v_bfe_u32 v3, v2, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v3, v3, v2
; GFX9-NEXT:    v_add_u32_e32 v3, 0x7fff, v3
; GFX9-NEXT:    v_or_b32_e32 v4, 0x400000, v2
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; GFX9-NEXT:    v_cndmask_b32_e32 v2, v3, v4, vcc
; GFX9-NEXT:    v_mov_b32_e32 v3, 0xffff
; GFX9-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX9-NEXT:    v_and_b32_sdwa v2, v3, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-NEXT:    s_pack_lh_b32_b16 s4, 0, s17
; GFX9-NEXT:    v_lshl_or_b32 v2, v1, 16, v2
; GFX9-NEXT:    v_add_f32_e32 v1, s4, v0
; GFX9-NEXT:    v_bfe_u32 v4, v1, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v4, v4, v1
; GFX9-NEXT:    v_add_u32_e32 v4, 0x7fff, v4
; GFX9-NEXT:    v_or_b32_e32 v5, 0x400000, v1
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; GFX9-NEXT:    s_lshl_b32 s4, s17, 16
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v4, v5, vcc
; GFX9-NEXT:    v_add_f32_e32 v4, s4, v0
; GFX9-NEXT:    v_bfe_u32 v5, v4, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v5, v5, v4
; GFX9-NEXT:    v_add_u32_e32 v5, 0x7fff, v5
; GFX9-NEXT:    v_or_b32_e32 v6, 0x400000, v4
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v4, v4
; GFX9-NEXT:    v_cndmask_b32_e32 v4, v5, v6, vcc
; GFX9-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX9-NEXT:    v_and_b32_sdwa v4, v3, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-NEXT:    s_pack_lh_b32_b16 s4, 0, s16
; GFX9-NEXT:    v_lshl_or_b32 v1, v1, 16, v4
; GFX9-NEXT:    v_add_f32_e32 v4, s4, v0
; GFX9-NEXT:    v_bfe_u32 v5, v4, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v5, v5, v4
; GFX9-NEXT:    s_lshl_b32 s4, s16, 16
; GFX9-NEXT:    v_add_u32_e32 v5, 0x7fff, v5
; GFX9-NEXT:    v_or_b32_e32 v6, 0x400000, v4
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v4, v4
; GFX9-NEXT:    v_add_f32_e32 v0, s4, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v4, v5, v6, vcc
; GFX9-NEXT:    v_bfe_u32 v5, v0, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v5, v5, v0
; GFX9-NEXT:    v_add_u32_e32 v5, 0x7fff, v5
; GFX9-NEXT:    v_or_b32_e32 v6, 0x400000, v0
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v0, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v5, v6, vcc
; GFX9-NEXT:    v_lshrrev_b32_e32 v4, 16, v4
; GFX9-NEXT:    v_and_b32_sdwa v0, v3, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-NEXT:    v_lshl_or_b32 v0, v4, 16, v0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB27_3:
; GFX9-NEXT:    s_branch .LBB27_2
; GFX9-NEXT:  .LBB27_4:
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v6bf16_to_v3f32_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_cmp_lg_u32 s3, 0
; GFX11-NEXT:    s_mov_b32 s3, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB27_3
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s3
; GFX11-NEXT:    s_cbranch_vccnz .LBB27_4
; GFX11-NEXT:  .LBB27_2: ; %cmp.true
; GFX11-NEXT:    s_pack_lh_b32_b16 s3, 0, s2
; GFX11-NEXT:    s_lshl_b32 s2, s2, 16
; GFX11-NEXT:    v_add_f32_e64 v0, 0x40c00000, s3
; GFX11-NEXT:    v_add_f32_e64 v1, 0x40c00000, s2
; GFX11-NEXT:    s_pack_lh_b32_b16 s2, 0, s0
; GFX11-NEXT:    s_lshl_b32 s0, s0, 16
; GFX11-NEXT:    s_pack_lh_b32_b16 s3, 0, s1
; GFX11-NEXT:    v_bfe_u32 v2, v0, 16, 1
; GFX11-NEXT:    v_bfe_u32 v3, v1, 16, 1
; GFX11-NEXT:    v_or_b32_e32 v8, 0x400000, v0
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v0, v0
; GFX11-NEXT:    v_add_f32_e64 v7, 0x40c00000, s0
; GFX11-NEXT:    v_or_b32_e32 v9, 0x400000, v1
; GFX11-NEXT:    v_add_nc_u32_e32 v3, v3, v1
; GFX11-NEXT:    v_add_f32_e64 v4, 0x40c00000, s3
; GFX11-NEXT:    s_lshl_b32 s1, s1, 16
; GFX11-NEXT:    v_or_b32_e32 v12, 0x400000, v7
; GFX11-NEXT:    v_add_f32_e64 v5, 0x40c00000, s1
; GFX11-NEXT:    v_add_nc_u32_e32 v3, 0x7fff, v3
; GFX11-NEXT:    v_add_nc_u32_e32 v2, v2, v0
; GFX11-NEXT:    v_bfe_u32 v10, v4, 16, 1
; GFX11-NEXT:    v_add_f32_e64 v6, 0x40c00000, s2
; GFX11-NEXT:    v_or_b32_e32 v11, 0x400000, v5
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_nc_u32_e32 v2, 0x7fff, v2
; GFX11-NEXT:    v_cndmask_b32_e32 v0, v2, v8, vcc_lo
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v1, v1
; GFX11-NEXT:    v_bfe_u32 v2, v5, 16, 1
; GFX11-NEXT:    v_bfe_u32 v8, v7, 16, 1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_4)
; GFX11-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; GFX11-NEXT:    v_cndmask_b32_e32 v1, v3, v9, vcc_lo
; GFX11-NEXT:    v_add_nc_u32_e32 v3, v10, v4
; GFX11-NEXT:    v_or_b32_e32 v10, 0x400000, v4
; GFX11-NEXT:    v_bfe_u32 v9, v6, 16, 1
; GFX11-NEXT:    v_add_nc_u32_e32 v8, v8, v7
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v5, v5
; GFX11-NEXT:    v_add_nc_u32_e32 v3, 0x7fff, v3
; GFX11-NEXT:    v_add_nc_u32_e32 v2, v2, v5
; GFX11-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX11-NEXT:    v_add_nc_u32_e32 v8, 0x7fff, v8
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_add_nc_u32_e32 v2, 0x7fff, v2
; GFX11-NEXT:    v_add_nc_u32_e32 v9, v9, v6
; GFX11-NEXT:    v_dual_cndmask_b32 v2, v2, v11 :: v_dual_and_b32 v1, 0xffff, v1
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v7, v7
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(VALU_DEP_4)
; GFX11-NEXT:    v_add_nc_u32_e32 v5, 0x7fff, v9
; GFX11-NEXT:    v_or_b32_e32 v9, 0x400000, v6
; GFX11-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX11-NEXT:    v_cndmask_b32_e32 v7, v8, v12, vcc_lo
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v4, v4
; GFX11-NEXT:    v_cndmask_b32_e32 v3, v3, v10, vcc_lo
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v6, v6
; GFX11-NEXT:    v_and_b32_e32 v6, 0xffff, v2
; GFX11-NEXT:    v_lshl_or_b32 v2, v0, 16, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; GFX11-NEXT:    v_cndmask_b32_e32 v4, v5, v9, vcc_lo
; GFX11-NEXT:    v_lshrrev_b32_e32 v5, 16, v7
; GFX11-NEXT:    v_lshl_or_b32 v1, v3, 16, v6
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_lshrrev_b32_e32 v4, 16, v4
; GFX11-NEXT:    v_and_b32_e32 v5, 0xffff, v5
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_lshl_or_b32 v0, v4, 16, v5
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB27_3:
; GFX11-NEXT:    s_branch .LBB27_2
; GFX11-NEXT:  .LBB27_4:
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_mov_b32_e32 v2, s2
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <6 x bfloat> %a, splat (bfloat 0xR40C0)
  %a2 = bitcast <6 x bfloat> %a1 to <3 x float>
  br label %end

cmp.false:
  %a3 = bitcast <6 x bfloat> %a to <3 x float>
  br label %end

end:
  %phi = phi <3 x float> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <3 x float> %phi
}

define <6 x half> @bitcast_v3f32_to_v6f16(<3 x float> %a, i32 %b) {
; SI-LABEL: bitcast_v3f32_to_v6f16:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v8, v2
; SI-NEXT:    v_mov_b32_e32 v7, v1
; SI-NEXT:    v_mov_b32_e32 v6, v0
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v3
; SI-NEXT:    ; implicit-def: $vgpr0
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    ; implicit-def: $vgpr4
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB28_3
; SI-NEXT:  ; %bb.1: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB28_4
; SI-NEXT:  .LBB28_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB28_3: ; %cmp.false
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v8
; SI-NEXT:    v_cvt_f32_f16_e32 v5, v0
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v7
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v0
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v6
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v0
; SI-NEXT:    v_cvt_f32_f16_e32 v4, v8
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v7
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v6
; SI-NEXT:    ; implicit-def: $vgpr6
; SI-NEXT:    ; implicit-def: $vgpr7
; SI-NEXT:    ; implicit-def: $vgpr8
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB28_2
; SI-NEXT:  .LBB28_4: ; %cmp.true
; SI-NEXT:    v_add_f32_e32 v1, 1.0, v6
; SI-NEXT:    v_add_f32_e32 v3, 1.0, v7
; SI-NEXT:    v_add_f32_e32 v5, 1.0, v8
; SI-NEXT:    v_cvt_f32_f16_e32 v4, v5
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v3
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v1
; SI-NEXT:    v_lshrrev_b32_e32 v5, 16, v5
; SI-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; SI-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_cvt_f32_f16_e32 v5, v5
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v3
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v3f32_to_v6f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v3
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_add_f32_e32 v2, 1.0, v2
; VI-NEXT:    v_add_f32_e32 v1, 1.0, v1
; VI-NEXT:    v_add_f32_e32 v0, 1.0, v0
; VI-NEXT:  ; %bb.2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v3f32_to_v6f16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v3
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_add_f32_e32 v2, 1.0, v2
; GFX9-NEXT:    v_add_f32_e32 v1, 1.0, v1
; GFX9-NEXT:    v_add_f32_e32 v0, 1.0, v0
; GFX9-NEXT:  ; %bb.2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v3f32_to_v6f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v3
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_dual_add_f32 v2, 1.0, v2 :: v_dual_add_f32 v1, 1.0, v1
; GFX11-NEXT:    v_add_f32_e32 v0, 1.0, v0
; GFX11-NEXT:  ; %bb.2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <3 x float> %a, splat (float 1.000000e+00)
  %a2 = bitcast <3 x float> %a1 to <6 x half>
  br label %end

cmp.false:
  %a3 = bitcast <3 x float> %a to <6 x half>
  br label %end

end:
  %phi = phi <6 x half> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <6 x half> %phi
}

define inreg <6 x half> @bitcast_v3f32_to_v6f16_scalar(<3 x float> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v3f32_to_v6f16_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s19, 0
; SI-NEXT:    s_cbranch_scc0 .LBB29_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_lshr_b32 s4, s18, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v5, s4
; SI-NEXT:    s_lshr_b32 s4, s17, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v3, s4
; SI-NEXT:    s_lshr_b32 s4, s16, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v1, s4
; SI-NEXT:    v_cvt_f32_f16_e32 v4, s18
; SI-NEXT:    v_cvt_f32_f16_e32 v2, s17
; SI-NEXT:    v_cvt_f32_f16_e32 v0, s16
; SI-NEXT:    s_cbranch_execnz .LBB29_3
; SI-NEXT:  .LBB29_2: ; %cmp.true
; SI-NEXT:    v_add_f32_e64 v1, s16, 1.0
; SI-NEXT:    v_add_f32_e64 v3, s17, 1.0
; SI-NEXT:    v_add_f32_e64 v5, s18, 1.0
; SI-NEXT:    v_cvt_f32_f16_e32 v4, v5
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v3
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v1
; SI-NEXT:    v_lshrrev_b32_e32 v5, 16, v5
; SI-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; SI-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_cvt_f32_f16_e32 v5, v5
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v3
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SI-NEXT:  .LBB29_3: ; %end
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB29_4:
; SI-NEXT:    ; implicit-def: $vgpr0
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    ; implicit-def: $vgpr4
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    s_branch .LBB29_2
;
; VI-LABEL: bitcast_v3f32_to_v6f16_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s19, 0
; VI-NEXT:    s_cbranch_scc0 .LBB29_3
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB29_4
; VI-NEXT:  .LBB29_2: ; %cmp.true
; VI-NEXT:    v_add_f32_e64 v2, s18, 1.0
; VI-NEXT:    v_add_f32_e64 v1, s17, 1.0
; VI-NEXT:    v_add_f32_e64 v0, s16, 1.0
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB29_3:
; VI-NEXT:    s_branch .LBB29_2
; VI-NEXT:  .LBB29_4:
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    v_mov_b32_e32 v2, s18
; VI-NEXT:    v_mov_b32_e32 v3, s19
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v3f32_to_v6f16_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s19, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB29_3
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB29_4
; GFX9-NEXT:  .LBB29_2: ; %cmp.true
; GFX9-NEXT:    v_add_f32_e64 v2, s18, 1.0
; GFX9-NEXT:    v_add_f32_e64 v1, s17, 1.0
; GFX9-NEXT:    v_add_f32_e64 v0, s16, 1.0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB29_3:
; GFX9-NEXT:    s_branch .LBB29_2
; GFX9-NEXT:  .LBB29_4:
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-NEXT:    v_mov_b32_e32 v3, s19
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v3f32_to_v6f16_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_cmp_lg_u32 s3, 0
; GFX11-NEXT:    s_mov_b32 s4, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB29_3
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s4
; GFX11-NEXT:    s_cbranch_vccnz .LBB29_4
; GFX11-NEXT:  .LBB29_2: ; %cmp.true
; GFX11-NEXT:    v_add_f32_e64 v2, s2, 1.0
; GFX11-NEXT:    v_add_f32_e64 v1, s1, 1.0
; GFX11-NEXT:    v_add_f32_e64 v0, s0, 1.0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB29_3:
; GFX11-NEXT:    s_branch .LBB29_2
; GFX11-NEXT:  .LBB29_4:
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <3 x float> %a, splat (float 1.000000e+00)
  %a2 = bitcast <3 x float> %a1 to <6 x half>
  br label %end

cmp.false:
  %a3 = bitcast <3 x float> %a to <6 x half>
  br label %end

end:
  %phi = phi <6 x half> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <6 x half> %phi
}

define <3 x float> @bitcast_v6f16_to_v3f32(<6 x half> %a, i32 %b) {
; SI-LABEL: bitcast_v6f16_to_v3f32:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v10, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v9, v0
; SI-NEXT:    v_cvt_f16_f32_e32 v8, v3
; SI-NEXT:    v_cvt_f16_f32_e32 v7, v2
; SI-NEXT:    v_cvt_f16_f32_e32 v5, v5
; SI-NEXT:    v_cvt_f16_f32_e32 v3, v4
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v6
; SI-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB30_3
; SI-NEXT:  ; %bb.1: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB30_4
; SI-NEXT:  .LBB30_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB30_3: ; %cmp.false
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v10
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v8
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v5
; SI-NEXT:    v_or_b32_e32 v0, v9, v0
; SI-NEXT:    v_or_b32_e32 v1, v7, v1
; SI-NEXT:    v_or_b32_e32 v2, v3, v2
; SI-NEXT:    ; implicit-def: $vgpr10
; SI-NEXT:    ; implicit-def: $vgpr9
; SI-NEXT:    ; implicit-def: $vgpr8
; SI-NEXT:    ; implicit-def: $vgpr7
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB30_2
; SI-NEXT:  .LBB30_4: ; %cmp.true
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v10
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v9
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v8
; SI-NEXT:    v_cvt_f32_f16_e32 v4, v7
; SI-NEXT:    v_add_f32_e32 v0, 0x38000000, v0
; SI-NEXT:    v_add_f32_e32 v1, 0x38000000, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-NEXT:    v_add_f32_e32 v2, 0x38000000, v2
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v3
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v2
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v5
; SI-NEXT:    v_add_f32_e32 v4, 0x38000000, v4
; SI-NEXT:    v_add_f32_e32 v3, 0x38000000, v3
; SI-NEXT:    v_cvt_f16_f32_e32 v4, v4
; SI-NEXT:    v_add_f32_e32 v2, 0x38000000, v2
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_or_b32_e32 v1, v4, v1
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_or_b32_e32 v2, v3, v2
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v6f16_to_v3f32:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v3
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB30_2
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_mov_b32_e32 v3, 0x200
; VI-NEXT:    v_add_f16_sdwa v4, v2, v3 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v2, 0x200, v2
; VI-NEXT:    v_or_b32_e32 v2, v2, v4
; VI-NEXT:    v_add_f16_sdwa v4, v1, v3 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v1, 0x200, v1
; VI-NEXT:    v_add_f16_sdwa v3, v0, v3 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v0, 0x200, v0
; VI-NEXT:    v_or_b32_e32 v1, v1, v4
; VI-NEXT:    v_or_b32_e32 v0, v0, v3
; VI-NEXT:  .LBB30_2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v6f16_to_v3f32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v3
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    s_movk_i32 s6, 0x200
; GFX9-NEXT:    v_pk_add_f16 v2, v2, s6 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v1, v1, s6 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v0, v0, s6 op_sel_hi:[1,0]
; GFX9-NEXT:  ; %bb.2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v6f16_to_v3f32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v3
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_pk_add_f16 v2, 0x200, v2 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v1, 0x200, v1 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v0, 0x200, v0 op_sel_hi:[0,1]
; GFX11-NEXT:  ; %bb.2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <6 x half> %a, splat (half 0xH0200)
  %a2 = bitcast <6 x half> %a1 to <3 x float>
  br label %end

cmp.false:
  %a3 = bitcast <6 x half> %a to <3 x float>
  br label %end

end:
  %phi = phi <3 x float> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <3 x float> %phi
}

define inreg <3 x float> @bitcast_v6f16_to_v3f32_scalar(<6 x half> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v6f16_to_v3f32_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v8, s17
; SI-NEXT:    v_cvt_f16_f32_e32 v7, s16
; SI-NEXT:    v_cvt_f16_f32_e32 v6, s19
; SI-NEXT:    v_cvt_f16_f32_e32 v5, s18
; SI-NEXT:    v_cvt_f16_f32_e32 v4, s21
; SI-NEXT:    v_cvt_f16_f32_e32 v3, s20
; SI-NEXT:    s_cmp_lg_u32 s22, 0
; SI-NEXT:    s_cbranch_scc0 .LBB31_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v8
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v6
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v4
; SI-NEXT:    v_or_b32_e32 v0, v7, v0
; SI-NEXT:    v_or_b32_e32 v1, v5, v1
; SI-NEXT:    v_or_b32_e32 v2, v3, v2
; SI-NEXT:    s_cbranch_execnz .LBB31_3
; SI-NEXT:  .LBB31_2: ; %cmp.true
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v8
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v7
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v6
; SI-NEXT:    v_cvt_f32_f16_e32 v5, v5
; SI-NEXT:    v_add_f32_e32 v0, 0x38000000, v0
; SI-NEXT:    v_add_f32_e32 v1, 0x38000000, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-NEXT:    v_add_f32_e32 v2, 0x38000000, v2
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v3
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v2
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v4
; SI-NEXT:    v_add_f32_e32 v4, 0x38000000, v5
; SI-NEXT:    v_add_f32_e32 v3, 0x38000000, v3
; SI-NEXT:    v_cvt_f16_f32_e32 v4, v4
; SI-NEXT:    v_add_f32_e32 v2, 0x38000000, v2
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_or_b32_e32 v1, v4, v1
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_or_b32_e32 v2, v3, v2
; SI-NEXT:  .LBB31_3: ; %end
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB31_4:
; SI-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2
; SI-NEXT:    s_branch .LBB31_2
;
; VI-LABEL: bitcast_v6f16_to_v3f32_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s19, 0
; VI-NEXT:    s_cbranch_scc0 .LBB31_3
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB31_4
; VI-NEXT:  .LBB31_2: ; %cmp.true
; VI-NEXT:    s_lshr_b32 s4, s18, 16
; VI-NEXT:    v_mov_b32_e32 v0, 0x200
; VI-NEXT:    v_mov_b32_e32 v1, s4
; VI-NEXT:    v_add_f16_sdwa v1, v1, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v2, s18, v0
; VI-NEXT:    s_lshr_b32 s4, s17, 16
; VI-NEXT:    v_or_b32_e32 v2, v2, v1
; VI-NEXT:    v_mov_b32_e32 v1, s4
; VI-NEXT:    v_add_f16_sdwa v1, v1, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v3, s17, v0
; VI-NEXT:    s_lshr_b32 s4, s16, 16
; VI-NEXT:    v_or_b32_e32 v1, v3, v1
; VI-NEXT:    v_mov_b32_e32 v3, s4
; VI-NEXT:    v_add_f16_sdwa v3, v3, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v0, s16, v0
; VI-NEXT:    v_or_b32_e32 v0, v0, v3
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB31_3:
; VI-NEXT:    s_branch .LBB31_2
; VI-NEXT:  .LBB31_4:
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    v_mov_b32_e32 v2, s18
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v6f16_to_v3f32_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s19, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB31_3
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB31_4
; GFX9-NEXT:  .LBB31_2: ; %cmp.true
; GFX9-NEXT:    v_mov_b32_e32 v0, 0x200
; GFX9-NEXT:    v_pk_add_f16 v2, s18, v0 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v1, s17, v0 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v0, s16, v0 op_sel_hi:[1,0]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB31_3:
; GFX9-NEXT:    s_branch .LBB31_2
; GFX9-NEXT:  .LBB31_4:
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v6f16_to_v3f32_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_cmp_lg_u32 s3, 0
; GFX11-NEXT:    s_mov_b32 s3, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB31_3
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s3
; GFX11-NEXT:    s_cbranch_vccnz .LBB31_4
; GFX11-NEXT:  .LBB31_2: ; %cmp.true
; GFX11-NEXT:    v_pk_add_f16 v2, 0x200, s2 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v1, 0x200, s1 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v0, 0x200, s0 op_sel_hi:[0,1]
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB31_3:
; GFX11-NEXT:    s_branch .LBB31_2
; GFX11-NEXT:  .LBB31_4:
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_mov_b32_e32 v2, s2
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <6 x half> %a, splat (half 0xH0200)
  %a2 = bitcast <6 x half> %a1 to <3 x float>
  br label %end

cmp.false:
  %a3 = bitcast <6 x half> %a to <3 x float>
  br label %end

end:
  %phi = phi <3 x float> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <3 x float> %phi
}

define <6 x i16> @bitcast_v3f32_to_v6i16(<3 x float> %a, i32 %b) {
; SI-LABEL: bitcast_v3f32_to_v6i16:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v4, v2
; SI-NEXT:    v_mov_b32_e32 v2, v1
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v3
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB32_3
; SI-NEXT:  ; %bb.1: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB32_4
; SI-NEXT:  .LBB32_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB32_3: ; %cmp.false
; SI-NEXT:    v_alignbit_b32 v5, s4, v4, 16
; SI-NEXT:    v_alignbit_b32 v1, v2, v0, 16
; SI-NEXT:    v_lshrrev_b32_e32 v3, 16, v2
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB32_2
; SI-NEXT:  .LBB32_4: ; %cmp.true
; SI-NEXT:    v_add_f32_e32 v4, 1.0, v4
; SI-NEXT:    v_add_f32_e32 v2, 1.0, v2
; SI-NEXT:    v_add_f32_e32 v0, 1.0, v0
; SI-NEXT:    v_alignbit_b32 v1, v2, v0, 16
; SI-NEXT:    v_alignbit_b32 v5, s4, v4, 16
; SI-NEXT:    v_lshrrev_b32_e32 v3, 16, v2
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v3f32_to_v6i16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v3
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_add_f32_e32 v2, 1.0, v2
; VI-NEXT:    v_add_f32_e32 v1, 1.0, v1
; VI-NEXT:    v_add_f32_e32 v0, 1.0, v0
; VI-NEXT:  ; %bb.2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v3f32_to_v6i16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v3
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_add_f32_e32 v2, 1.0, v2
; GFX9-NEXT:    v_add_f32_e32 v1, 1.0, v1
; GFX9-NEXT:    v_add_f32_e32 v0, 1.0, v0
; GFX9-NEXT:  ; %bb.2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v3f32_to_v6i16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v3
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_dual_add_f32 v2, 1.0, v2 :: v_dual_add_f32 v1, 1.0, v1
; GFX11-NEXT:    v_add_f32_e32 v0, 1.0, v0
; GFX11-NEXT:  ; %bb.2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <3 x float> %a, splat (float 1.000000e+00)
  %a2 = bitcast <3 x float> %a1 to <6 x i16>
  br label %end

cmp.false:
  %a3 = bitcast <3 x float> %a to <6 x i16>
  br label %end

end:
  %phi = phi <6 x i16> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <6 x i16> %phi
}

define inreg <6 x i16> @bitcast_v3f32_to_v6i16_scalar(<3 x float> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v3f32_to_v6i16_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s19, 0
; SI-NEXT:    s_cbranch_scc0 .LBB33_3
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    v_mov_b32_e32 v0, s18
; SI-NEXT:    v_alignbit_b32 v5, s4, v0, 16
; SI-NEXT:    v_mov_b32_e32 v0, s16
; SI-NEXT:    v_alignbit_b32 v1, s17, v0, 16
; SI-NEXT:    s_lshr_b32 s6, s17, 16
; SI-NEXT:    s_cbranch_execnz .LBB33_4
; SI-NEXT:  .LBB33_2: ; %cmp.true
; SI-NEXT:    v_add_f32_e64 v4, s18, 1.0
; SI-NEXT:    v_add_f32_e64 v2, s17, 1.0
; SI-NEXT:    v_add_f32_e64 v0, s16, 1.0
; SI-NEXT:    v_alignbit_b32 v1, v2, v0, 16
; SI-NEXT:    v_alignbit_b32 v5, s4, v4, 16
; SI-NEXT:    v_lshrrev_b32_e32 v3, 16, v2
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB33_3:
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    ; implicit-def: $sgpr6
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    s_branch .LBB33_2
; SI-NEXT:  .LBB33_4:
; SI-NEXT:    v_mov_b32_e32 v0, s16
; SI-NEXT:    v_mov_b32_e32 v2, s17
; SI-NEXT:    v_mov_b32_e32 v4, s18
; SI-NEXT:    v_mov_b32_e32 v3, s6
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v3f32_to_v6i16_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s19, 0
; VI-NEXT:    s_cbranch_scc0 .LBB33_3
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB33_4
; VI-NEXT:  .LBB33_2: ; %cmp.true
; VI-NEXT:    v_add_f32_e64 v2, s18, 1.0
; VI-NEXT:    v_add_f32_e64 v1, s17, 1.0
; VI-NEXT:    v_add_f32_e64 v0, s16, 1.0
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB33_3:
; VI-NEXT:    s_branch .LBB33_2
; VI-NEXT:  .LBB33_4:
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    v_mov_b32_e32 v2, s18
; VI-NEXT:    v_mov_b32_e32 v3, s19
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v3f32_to_v6i16_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s19, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB33_3
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB33_4
; GFX9-NEXT:  .LBB33_2: ; %cmp.true
; GFX9-NEXT:    v_add_f32_e64 v2, s18, 1.0
; GFX9-NEXT:    v_add_f32_e64 v1, s17, 1.0
; GFX9-NEXT:    v_add_f32_e64 v0, s16, 1.0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB33_3:
; GFX9-NEXT:    s_branch .LBB33_2
; GFX9-NEXT:  .LBB33_4:
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-NEXT:    v_mov_b32_e32 v3, s19
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v3f32_to_v6i16_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_cmp_lg_u32 s3, 0
; GFX11-NEXT:    s_mov_b32 s4, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB33_3
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s4
; GFX11-NEXT:    s_cbranch_vccnz .LBB33_4
; GFX11-NEXT:  .LBB33_2: ; %cmp.true
; GFX11-NEXT:    v_add_f32_e64 v2, s2, 1.0
; GFX11-NEXT:    v_add_f32_e64 v1, s1, 1.0
; GFX11-NEXT:    v_add_f32_e64 v0, s0, 1.0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB33_3:
; GFX11-NEXT:    s_branch .LBB33_2
; GFX11-NEXT:  .LBB33_4:
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <3 x float> %a, splat (float 1.000000e+00)
  %a2 = bitcast <3 x float> %a1 to <6 x i16>
  br label %end

cmp.false:
  %a3 = bitcast <3 x float> %a to <6 x i16>
  br label %end

end:
  %phi = phi <6 x i16> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <6 x i16> %phi
}

define <3 x float> @bitcast_v6i16_to_v3f32(<6 x i16> %a, i32 %b) {
; SI-LABEL: bitcast_v6i16_to_v3f32:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v8, v2
; SI-NEXT:    v_mov_b32_e32 v7, v0
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v6
; SI-NEXT:    v_lshlrev_b32_e32 v9, 16, v1
; SI-NEXT:    v_lshlrev_b32_e32 v6, 16, v3
; SI-NEXT:    v_lshlrev_b32_e32 v3, 16, v5
; SI-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB34_3
; SI-NEXT:  ; %bb.1: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB34_4
; SI-NEXT:  .LBB34_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB34_3: ; %cmp.false
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v7
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v8
; SI-NEXT:    v_and_b32_e32 v2, 0xffff, v4
; SI-NEXT:    v_or_b32_e32 v0, v0, v9
; SI-NEXT:    v_or_b32_e32 v1, v1, v6
; SI-NEXT:    v_or_b32_e32 v2, v2, v3
; SI-NEXT:    ; implicit-def: $vgpr7
; SI-NEXT:    ; implicit-def: $vgpr9
; SI-NEXT:    ; implicit-def: $vgpr8
; SI-NEXT:    ; implicit-def: $vgpr6
; SI-NEXT:    ; implicit-def: $vgpr4
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB34_2
; SI-NEXT:  .LBB34_4: ; %cmp.true
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v7
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v8
; SI-NEXT:    v_add_i32_e32 v2, vcc, 3, v4
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; SI-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; SI-NEXT:    v_or_b32_e32 v0, v9, v0
; SI-NEXT:    v_or_b32_e32 v1, v6, v1
; SI-NEXT:    v_or_b32_e32 v2, v3, v2
; SI-NEXT:    v_add_i32_e32 v0, vcc, 0x30000, v0
; SI-NEXT:    v_add_i32_e32 v1, vcc, 0x30000, v1
; SI-NEXT:    v_add_i32_e32 v2, vcc, 0x30000, v2
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v6i16_to_v3f32:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v3
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB34_2
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_mov_b32_e32 v4, 3
; VI-NEXT:    v_add_u16_e32 v3, 3, v2
; VI-NEXT:    v_add_u16_sdwa v2, v2, v4 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v2, v3, v2
; VI-NEXT:    v_add_u16_e32 v3, 3, v1
; VI-NEXT:    v_add_u16_sdwa v1, v1, v4 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v1, v3, v1
; VI-NEXT:    v_add_u16_e32 v3, 3, v0
; VI-NEXT:    v_add_u16_sdwa v0, v0, v4 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v0, v3, v0
; VI-NEXT:  .LBB34_2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v6i16_to_v3f32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v3
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_pk_add_u16 v2, v2, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v1, v1, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v0, v0, 3 op_sel_hi:[1,0]
; GFX9-NEXT:  ; %bb.2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v6i16_to_v3f32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v3
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_pk_add_u16 v2, v2, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v1, v1, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v0, v0, 3 op_sel_hi:[1,0]
; GFX11-NEXT:  ; %bb.2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <6 x i16> %a, splat (i16 3)
  %a2 = bitcast <6 x i16> %a1 to <3 x float>
  br label %end

cmp.false:
  %a3 = bitcast <6 x i16> %a to <3 x float>
  br label %end

end:
  %phi = phi <3 x float> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <3 x float> %phi
}

define inreg <3 x float> @bitcast_v6i16_to_v3f32_scalar(<6 x i16> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v6i16_to_v3f32_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s22, 0
; SI-NEXT:    s_cbranch_scc0 .LBB35_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_and_b32 s4, s16, 0xffff
; SI-NEXT:    s_lshl_b32 s5, s17, 16
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    s_and_b32 s5, s18, 0xffff
; SI-NEXT:    s_lshl_b32 s6, s19, 16
; SI-NEXT:    s_or_b32 s5, s5, s6
; SI-NEXT:    s_and_b32 s6, s20, 0xffff
; SI-NEXT:    s_lshl_b32 s7, s21, 16
; SI-NEXT:    s_or_b32 s6, s6, s7
; SI-NEXT:    s_cbranch_execnz .LBB35_3
; SI-NEXT:  .LBB35_2: ; %cmp.true
; SI-NEXT:    s_add_i32 s16, s16, 3
; SI-NEXT:    s_and_b32 s4, s16, 0xffff
; SI-NEXT:    s_lshl_b32 s5, s17, 16
; SI-NEXT:    s_add_i32 s18, s18, 3
; SI-NEXT:    s_or_b32 s4, s5, s4
; SI-NEXT:    s_and_b32 s5, s18, 0xffff
; SI-NEXT:    s_lshl_b32 s6, s19, 16
; SI-NEXT:    s_add_i32 s20, s20, 3
; SI-NEXT:    s_or_b32 s5, s6, s5
; SI-NEXT:    s_and_b32 s6, s20, 0xffff
; SI-NEXT:    s_lshl_b32 s7, s21, 16
; SI-NEXT:    s_or_b32 s6, s7, s6
; SI-NEXT:    s_add_i32 s4, s4, 0x30000
; SI-NEXT:    s_add_i32 s5, s5, 0x30000
; SI-NEXT:    s_add_i32 s6, s6, 0x30000
; SI-NEXT:  .LBB35_3: ; %end
; SI-NEXT:    v_mov_b32_e32 v0, s4
; SI-NEXT:    v_mov_b32_e32 v1, s5
; SI-NEXT:    v_mov_b32_e32 v2, s6
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB35_4:
; SI-NEXT:    ; implicit-def: $sgpr4_sgpr5_sgpr6
; SI-NEXT:    s_branch .LBB35_2
;
; VI-LABEL: bitcast_v6i16_to_v3f32_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s19, 0
; VI-NEXT:    s_cbranch_scc0 .LBB35_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB35_3
; VI-NEXT:  .LBB35_2: ; %cmp.true
; VI-NEXT:    s_add_i32 s5, s18, 3
; VI-NEXT:    s_and_b32 s4, s18, 0xffff0000
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_add_i32 s5, s17, 3
; VI-NEXT:    s_add_i32 s18, s4, 0x30000
; VI-NEXT:    s_and_b32 s4, s17, 0xffff0000
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_add_i32 s5, s16, 3
; VI-NEXT:    s_add_i32 s17, s4, 0x30000
; VI-NEXT:    s_and_b32 s4, s16, 0xffff0000
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_add_i32 s16, s4, 0x30000
; VI-NEXT:  .LBB35_3: ; %end
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    v_mov_b32_e32 v2, s18
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB35_4:
; VI-NEXT:    s_branch .LBB35_2
;
; GFX9-LABEL: bitcast_v6i16_to_v3f32_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s19, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB35_3
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB35_4
; GFX9-NEXT:  .LBB35_2: ; %cmp.true
; GFX9-NEXT:    v_pk_add_u16 v2, s18, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v1, s17, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v0, s16, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB35_3:
; GFX9-NEXT:    s_branch .LBB35_2
; GFX9-NEXT:  .LBB35_4:
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v6i16_to_v3f32_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_cmp_lg_u32 s3, 0
; GFX11-NEXT:    s_mov_b32 s3, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB35_3
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s3
; GFX11-NEXT:    s_cbranch_vccnz .LBB35_4
; GFX11-NEXT:  .LBB35_2: ; %cmp.true
; GFX11-NEXT:    v_pk_add_u16 v2, s2, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v1, s1, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v0, s0, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB35_3:
; GFX11-NEXT:    s_branch .LBB35_2
; GFX11-NEXT:  .LBB35_4:
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_mov_b32_e32 v2, s2
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <6 x i16> %a, splat (i16 3)
  %a2 = bitcast <6 x i16> %a1 to <3 x float>
  br label %end

cmp.false:
  %a3 = bitcast <6 x i16> %a to <3 x float>
  br label %end

end:
  %phi = phi <3 x float> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <3 x float> %phi
}

define <6 x bfloat> @bitcast_v12i8_to_v6bf16(<12 x i8> %a, i32 %b) {
; SI-LABEL: bitcast_v12i8_to_v6bf16:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v14, v1
; SI-NEXT:    v_mov_b32_e32 v13, v0
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v12
; SI-NEXT:    v_lshlrev_b32_e32 v15, 24, v3
; SI-NEXT:    v_lshlrev_b32_e32 v17, 8, v5
; SI-NEXT:    v_lshlrev_b32_e32 v7, 24, v7
; SI-NEXT:    v_lshlrev_b32_e32 v16, 24, v11
; SI-NEXT:    ; implicit-def: $vgpr0
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    ; implicit-def: $vgpr12
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    ; implicit-def: $vgpr11
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB36_2
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v13
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 24, v14
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v2
; SI-NEXT:    v_and_b32_e32 v2, 0xff, v4
; SI-NEXT:    v_or_b32_e32 v2, v2, v17
; SI-NEXT:    v_lshlrev_b32_e32 v12, 16, v2
; SI-NEXT:    v_and_b32_e32 v2, 0xff, v6
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_or_b32_e32 v3, v7, v2
; SI-NEXT:    v_and_b32_e32 v2, 0xff, v8
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_lshlrev_b32_e32 v4, 24, v9
; SI-NEXT:    v_or_b32_e32 v11, v4, v2
; SI-NEXT:    v_and_b32_e32 v2, 0xff, v10
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_or_b32_e32 v1, v15, v1
; SI-NEXT:    v_or_b32_e32 v5, v16, v2
; SI-NEXT:    ; implicit-def: $vgpr13
; SI-NEXT:    ; implicit-def: $vgpr14
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    ; implicit-def: $vgpr4
; SI-NEXT:    ; implicit-def: $vgpr6
; SI-NEXT:    ; implicit-def: $vgpr8
; SI-NEXT:    ; implicit-def: $vgpr9
; SI-NEXT:    ; implicit-def: $vgpr10
; SI-NEXT:    ; implicit-def: $vgpr15
; SI-NEXT:    ; implicit-def: $vgpr17
; SI-NEXT:    ; implicit-def: $vgpr7
; SI-NEXT:    ; implicit-def: $vgpr16
; SI-NEXT:  .LBB36_2: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB36_4
; SI-NEXT:  ; %bb.3: ; %cmp.true
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v8
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 8, v9
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v10
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v1
; SI-NEXT:    v_add_i32_e32 v0, vcc, 0x300, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v1, v16, v1
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    s_mov_b32 s7, 0x3000000
; SI-NEXT:    v_add_i32_e32 v8, vcc, s7, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v4
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v0
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v6
; SI-NEXT:    s_movk_i32 s6, 0x300
; SI-NEXT:    v_or_b32_e32 v0, v17, v0
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v1
; SI-NEXT:    v_add_i32_e32 v0, vcc, s6, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v1, v7, v1
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    v_add_i32_e32 v4, vcc, s7, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v13
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 8, v14
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v2
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v1
; SI-NEXT:    v_add_i32_e32 v0, vcc, s6, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v1, v15, v1
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 0x3000000, v0
; SI-NEXT:    v_and_b32_e32 v1, 0xffff0000, v0
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; SI-NEXT:    v_and_b32_e32 v3, 0xffff0000, v4
; SI-NEXT:    v_lshlrev_b32_e32 v12, 16, v4
; SI-NEXT:    v_and_b32_e32 v5, 0xffff0000, v8
; SI-NEXT:    v_lshlrev_b32_e32 v11, 16, v8
; SI-NEXT:  .LBB36_4: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    v_mov_b32_e32 v2, v12
; SI-NEXT:    v_mov_b32_e32 v4, v11
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v12i8_to_v6bf16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v14, v2
; VI-NEXT:    v_mov_b32_e32 v13, v0
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v12
; VI-NEXT:    v_lshlrev_b16_e32 v17, 8, v1
; VI-NEXT:    v_lshlrev_b16_e32 v16, 8, v3
; VI-NEXT:    v_lshlrev_b16_e32 v15, 8, v5
; VI-NEXT:    v_lshlrev_b16_e32 v12, 8, v7
; VI-NEXT:    v_lshlrev_b16_e32 v7, 8, v9
; VI-NEXT:    v_lshlrev_b16_e32 v5, 8, v11
; VI-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_cbranch_execnz .LBB36_3
; VI-NEXT:  ; %bb.1: ; %Flow
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execnz .LBB36_4
; VI-NEXT:  .LBB36_2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB36_3: ; %cmp.false
; VI-NEXT:    v_or_b32_sdwa v0, v13, v17 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v14, v16 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v4, v15 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v2, v6, v12 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v2, v8, v7 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v3, v10, v5 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v2, v2, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    ; implicit-def: $vgpr13
; VI-NEXT:    ; implicit-def: $vgpr14
; VI-NEXT:    ; implicit-def: $vgpr4
; VI-NEXT:    ; implicit-def: $vgpr6
; VI-NEXT:    ; implicit-def: $vgpr8
; VI-NEXT:    ; implicit-def: $vgpr10
; VI-NEXT:    ; implicit-def: $vgpr17
; VI-NEXT:    ; implicit-def: $vgpr16
; VI-NEXT:    ; implicit-def: $vgpr15
; VI-NEXT:    ; implicit-def: $vgpr12
; VI-NEXT:    ; implicit-def: $vgpr7
; VI-NEXT:    ; implicit-def: $vgpr5
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB36_2
; VI-NEXT:  .LBB36_4: ; %cmp.true
; VI-NEXT:    v_add_u16_e32 v0, 3, v13
; VI-NEXT:    v_add_u16_e32 v1, 3, v14
; VI-NEXT:    v_or_b32_sdwa v0, v17, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_or_b32_sdwa v1, v16, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_mov_b32_e32 v2, 0x300
; VI-NEXT:    v_add_u16_e32 v0, 0x300, v0
; VI-NEXT:    v_add_u16_sdwa v1, v1, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v0, v0, v1
; VI-NEXT:    v_add_u16_e32 v1, 3, v4
; VI-NEXT:    v_add_u16_e32 v3, 3, v6
; VI-NEXT:    v_or_b32_sdwa v1, v15, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_or_b32_sdwa v3, v12, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_add_u16_e32 v1, 0x300, v1
; VI-NEXT:    v_add_u16_sdwa v3, v3, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v1, v1, v3
; VI-NEXT:    v_add_u16_e32 v3, 3, v8
; VI-NEXT:    v_add_u16_e32 v4, 3, v10
; VI-NEXT:    v_or_b32_sdwa v3, v7, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_or_b32_sdwa v4, v5, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_add_u16_e32 v3, 0x300, v3
; VI-NEXT:    v_add_u16_sdwa v2, v4, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v2, v3, v2
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v12i8_to_v6bf16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v14, v2
; GFX9-NEXT:    v_mov_b32_e32 v13, v0
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v12
; GFX9-NEXT:    v_lshlrev_b16_e32 v17, 8, v1
; GFX9-NEXT:    v_lshlrev_b16_e32 v16, 8, v3
; GFX9-NEXT:    v_lshlrev_b16_e32 v15, 8, v5
; GFX9-NEXT:    v_lshlrev_b16_e32 v12, 8, v7
; GFX9-NEXT:    v_lshlrev_b16_e32 v7, 8, v9
; GFX9-NEXT:    v_lshlrev_b16_e32 v5, 8, v11
; GFX9-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_cbranch_execnz .LBB36_3
; GFX9-NEXT:  ; %bb.1: ; %Flow
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:    s_cbranch_execnz .LBB36_4
; GFX9-NEXT:  .LBB36_2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB36_3: ; %cmp.false
; GFX9-NEXT:    v_or_b32_sdwa v0, v13, v17 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v1, v14, v16 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v1, v4, v15 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v2, v6, v12 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v2, v8, v7 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v3, v10, v5 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v2, v2, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    ; implicit-def: $vgpr13
; GFX9-NEXT:    ; implicit-def: $vgpr14
; GFX9-NEXT:    ; implicit-def: $vgpr4
; GFX9-NEXT:    ; implicit-def: $vgpr6
; GFX9-NEXT:    ; implicit-def: $vgpr8
; GFX9-NEXT:    ; implicit-def: $vgpr10
; GFX9-NEXT:    ; implicit-def: $vgpr17
; GFX9-NEXT:    ; implicit-def: $vgpr16
; GFX9-NEXT:    ; implicit-def: $vgpr15
; GFX9-NEXT:    ; implicit-def: $vgpr12
; GFX9-NEXT:    ; implicit-def: $vgpr7
; GFX9-NEXT:    ; implicit-def: $vgpr5
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB36_2
; GFX9-NEXT:  .LBB36_4: ; %cmp.true
; GFX9-NEXT:    v_add_u16_e32 v0, 3, v13
; GFX9-NEXT:    v_add_u16_e32 v1, 3, v14
; GFX9-NEXT:    v_or_b32_sdwa v0, v17, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    s_movk_i32 s6, 0x300
; GFX9-NEXT:    v_or_b32_sdwa v1, v16, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u16_e32 v0, 0x300, v0
; GFX9-NEXT:    v_add_u16_sdwa v1, v1, s6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX9-NEXT:    v_add_u16_e32 v1, 3, v4
; GFX9-NEXT:    v_add_u16_e32 v2, 3, v6
; GFX9-NEXT:    v_or_b32_sdwa v1, v15, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_or_b32_sdwa v2, v12, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u16_e32 v1, 0x300, v1
; GFX9-NEXT:    v_add_u16_sdwa v2, v2, s6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_e32 v1, v1, v2
; GFX9-NEXT:    v_add_u16_e32 v2, 3, v8
; GFX9-NEXT:    v_add_u16_e32 v3, 3, v10
; GFX9-NEXT:    v_or_b32_sdwa v2, v7, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_or_b32_sdwa v3, v5, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u16_e32 v2, 0x300, v2
; GFX9-NEXT:    v_add_u16_sdwa v3, v3, s6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_e32 v2, v2, v3
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-TRUE16-LABEL: bitcast_v12i8_to_v6bf16:
; GFX11-TRUE16:       ; %bb.0:
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v9.h, v9.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v10.h, v7.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v7.l, v6.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v7.h, v4.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v8.h, v2.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v9.l, v0.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v6.h, 8, v1.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v5.h, 8, v3.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v6.l, 8, v5.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v5.l, 8, v10.h
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v4.l, 8, v9.h
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v4.h, 8, v11.l
; GFX11-TRUE16-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3
; GFX11-TRUE16-NEXT:    v_cmpx_ne_u32_e32 0, v12
; GFX11-TRUE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-TRUE16-NEXT:    s_cbranch_execnz .LBB36_3
; GFX11-TRUE16-NEXT:  ; %bb.1: ; %Flow
; GFX11-TRUE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-TRUE16-NEXT:    s_cbranch_execnz .LBB36_4
; GFX11-TRUE16-NEXT:  .LBB36_2: ; %end
; GFX11-TRUE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
; GFX11-TRUE16-NEXT:  .LBB36_3: ; %cmp.false
; GFX11-TRUE16-NEXT:    v_and_b16 v0.l, 0xff, v9.l
; GFX11-TRUE16-NEXT:    v_and_b16 v0.h, 0xff, v8.h
; GFX11-TRUE16-NEXT:    v_and_b16 v1.l, 0xff, v7.h
; GFX11-TRUE16-NEXT:    v_and_b16 v1.h, 0xff, v7.l
; GFX11-TRUE16-NEXT:    v_and_b16 v2.l, 0xff, v8.l
; GFX11-TRUE16-NEXT:    v_or_b16 v0.l, v0.l, v6.h
; GFX11-TRUE16-NEXT:    v_and_b16 v2.h, 0xff, v10.l
; GFX11-TRUE16-NEXT:    v_or_b16 v3.l, v0.h, v5.h
; GFX11-TRUE16-NEXT:    v_or_b16 v1.l, v1.l, v6.l
; GFX11-TRUE16-NEXT:    v_or_b16 v5.l, v1.h, v5.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v6.l, v0.l
; GFX11-TRUE16-NEXT:    v_or_b16 v0.l, v2.l, v4.l
; GFX11-TRUE16-NEXT:    v_or_b16 v2.l, v2.h, v4.h
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v4, 0xffff, v6
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v6, 0xffff, v0
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v0, v4, v3
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v1, v1, v5
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v2, v6, v2
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr9_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr8_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr7_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr7_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr8_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr10_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr6_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr5_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr6_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr5_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr4_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr4_hi16
; GFX11-TRUE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-TRUE16-NEXT:    s_cbranch_execz .LBB36_2
; GFX11-TRUE16-NEXT:  .LBB36_4: ; %cmp.true
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v0.l, v9.l, 3
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v0.h, v8.h, 3
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v1.l, v7.h, 3
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v1.h, v7.l, 3
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v2.l, v8.l, 3
; GFX11-TRUE16-NEXT:    v_and_b16 v0.l, 0xff, v0.l
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v2.h, v10.l, 3
; GFX11-TRUE16-NEXT:    v_and_b16 v0.h, 0xff, v0.h
; GFX11-TRUE16-NEXT:    v_and_b16 v1.l, 0xff, v1.l
; GFX11-TRUE16-NEXT:    v_and_b16 v1.h, 0xff, v1.h
; GFX11-TRUE16-NEXT:    v_or_b16 v0.l, v6.h, v0.l
; GFX11-TRUE16-NEXT:    v_and_b16 v2.l, 0xff, v2.l
; GFX11-TRUE16-NEXT:    v_and_b16 v2.h, 0xff, v2.h
; GFX11-TRUE16-NEXT:    v_or_b16 v0.h, v5.h, v0.h
; GFX11-TRUE16-NEXT:    v_or_b16 v1.l, v6.l, v1.l
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v0.l, 0x300, v0.l
; GFX11-TRUE16-NEXT:    v_or_b16 v1.h, v5.l, v1.h
; GFX11-TRUE16-NEXT:    v_or_b16 v2.l, v4.l, v2.l
; GFX11-TRUE16-NEXT:    v_or_b16 v2.h, v4.h, v2.h
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v3.l, 0x300, v0.h
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v5.l, v0.l
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v0.l, 0x300, v1.l
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v1.l, 0x300, v1.h
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v2.l, 0x300, v2.l
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v4.l, 0x300, v2.h
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v5, 0xffff, v5
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v6, 0xffff, v0
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v0, v5, v3
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v1, v6, v1
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v2, v2, v4
; GFX11-TRUE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-FAKE16-LABEL: bitcast_v12i8_to_v6bf16:
; GFX11-FAKE16:       ; %bb.0:
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-FAKE16-NEXT:    v_dual_mov_b32 v14, v2 :: v_dual_mov_b32 v13, v0
; GFX11-FAKE16-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v12
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v17, 8, v1
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v15, 8, v3
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v16, 8, v5
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v12, 8, v7
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v5, 8, v9
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v7, 8, v11
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3
; GFX11-FAKE16-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-FAKE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_cbranch_execnz .LBB36_3
; GFX11-FAKE16-NEXT:  ; %bb.1: ; %Flow
; GFX11-FAKE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-FAKE16-NEXT:    s_cbranch_execnz .LBB36_4
; GFX11-FAKE16-NEXT:  .LBB36_2: ; %end
; GFX11-FAKE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
; GFX11-FAKE16-NEXT:  .LBB36_3: ; %cmp.false
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v0, 0xff, v13
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v1, 0xff, v14
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v2, 0xff, v4
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v3, 0xff, v6
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v4, 0xff, v8
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v6, 0xff, v10
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v0, v0, v17
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v1, v1, v15
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v2, v2, v16
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v3, v3, v12
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v4, v4, v5
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v5, v6, v7
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v4, 0xffff, v4
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr13
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr14
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr6
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr8
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr10
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr17
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr15
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr16
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr12
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr7
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v1, v2, v3
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v2, v4, v5
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr4
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr5
; GFX11-FAKE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-FAKE16-NEXT:    s_cbranch_execz .LBB36_2
; GFX11-FAKE16-NEXT:  .LBB36_4: ; %cmp.true
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v0, v13, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v1, v14, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v2, v4, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v3, v6, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v4, v8, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v6, v10, 3
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v1, 0xff, v1
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v2, 0xff, v2
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v3, 0xff, v3
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v4, 0xff, v4
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v6, 0xff, v6
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v0, v17, v0
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v1, v15, v1
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v2, v16, v2
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v3, v12, v3
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v4, v5, v4
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v5, v7, v6
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v0, 0x300, v0
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v1, 0x300, v1
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v2, 0x300, v2
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v3, 0x300, v3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v4, 0x300, v4
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v5, 0x300, v5
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v4, 0xffff, v4
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v1, v2, v3
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v2, v4, v5
; GFX11-FAKE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <12 x i8> %a, splat (i8 3)
  %a2 = bitcast <12 x i8> %a1 to <6 x bfloat>
  br label %end

cmp.false:
  %a3 = bitcast <12 x i8> %a to <6 x bfloat>
  br label %end

end:
  %phi = phi <6 x bfloat> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <6 x bfloat> %phi
}

define inreg <6 x bfloat> @bitcast_v12i8_to_v6bf16_scalar(<12 x i8> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v12i8_to_v6bf16_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s28, 0
; SI-NEXT:    s_cbranch_scc0 .LBB37_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_and_b32 s4, s16, 0xff
; SI-NEXT:    s_lshl_b32 s4, s4, 16
; SI-NEXT:    s_lshl_b32 s5, s17, 24
; SI-NEXT:    s_or_b32 s6, s5, s4
; SI-NEXT:    s_and_b32 s4, s18, 0xff
; SI-NEXT:    s_lshl_b32 s4, s4, 16
; SI-NEXT:    s_lshl_b32 s5, s19, 24
; SI-NEXT:    s_or_b32 s7, s5, s4
; SI-NEXT:    s_and_b32 s4, s20, 0xff
; SI-NEXT:    s_lshl_b32 s5, s21, 8
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    s_lshl_b32 s8, s4, 16
; SI-NEXT:    s_and_b32 s4, s22, 0xff
; SI-NEXT:    s_lshl_b32 s4, s4, 16
; SI-NEXT:    s_lshl_b32 s5, s23, 24
; SI-NEXT:    s_or_b32 s9, s5, s4
; SI-NEXT:    s_and_b32 s4, s24, 0xff
; SI-NEXT:    s_lshl_b32 s4, s4, 16
; SI-NEXT:    s_lshl_b32 s5, s25, 24
; SI-NEXT:    s_or_b32 s10, s5, s4
; SI-NEXT:    s_and_b32 s4, s26, 0xff
; SI-NEXT:    s_lshl_b32 s4, s4, 16
; SI-NEXT:    s_lshl_b32 s5, s27, 24
; SI-NEXT:    s_or_b32 s11, s5, s4
; SI-NEXT:    s_cbranch_execnz .LBB37_3
; SI-NEXT:  .LBB37_2: ; %cmp.true
; SI-NEXT:    s_add_i32 s24, s24, 3
; SI-NEXT:    s_and_b32 s4, s24, 0xff
; SI-NEXT:    s_lshl_b32 s5, s25, 8
; SI-NEXT:    s_add_i32 s26, s26, 3
; SI-NEXT:    s_or_b32 s4, s5, s4
; SI-NEXT:    s_and_b32 s6, s26, 0xff
; SI-NEXT:    s_addk_i32 s4, 0x300
; SI-NEXT:    s_lshl_b32 s5, s27, 24
; SI-NEXT:    s_lshl_b32 s6, s6, 16
; SI-NEXT:    s_and_b32 s4, s4, 0xffff
; SI-NEXT:    s_or_b32 s5, s5, s6
; SI-NEXT:    s_add_i32 s20, s20, 3
; SI-NEXT:    s_or_b32 s4, s5, s4
; SI-NEXT:    s_and_b32 s5, s20, 0xff
; SI-NEXT:    s_lshl_b32 s6, s21, 8
; SI-NEXT:    s_add_i32 s22, s22, 3
; SI-NEXT:    s_or_b32 s5, s6, s5
; SI-NEXT:    s_and_b32 s7, s22, 0xff
; SI-NEXT:    s_addk_i32 s5, 0x300
; SI-NEXT:    s_lshl_b32 s6, s23, 24
; SI-NEXT:    s_lshl_b32 s7, s7, 16
; SI-NEXT:    s_and_b32 s5, s5, 0xffff
; SI-NEXT:    s_or_b32 s6, s6, s7
; SI-NEXT:    s_add_i32 s16, s16, 3
; SI-NEXT:    s_or_b32 s5, s6, s5
; SI-NEXT:    s_and_b32 s6, s16, 0xff
; SI-NEXT:    s_lshl_b32 s7, s17, 8
; SI-NEXT:    s_add_i32 s18, s18, 3
; SI-NEXT:    s_or_b32 s6, s7, s6
; SI-NEXT:    s_and_b32 s8, s18, 0xff
; SI-NEXT:    s_addk_i32 s6, 0x300
; SI-NEXT:    s_lshl_b32 s7, s19, 24
; SI-NEXT:    s_lshl_b32 s8, s8, 16
; SI-NEXT:    s_and_b32 s6, s6, 0xffff
; SI-NEXT:    s_or_b32 s7, s7, s8
; SI-NEXT:    s_or_b32 s6, s7, s6
; SI-NEXT:    s_add_i32 s4, s4, 0x3000000
; SI-NEXT:    s_add_i32 s5, s5, 0x3000000
; SI-NEXT:    s_add_i32 s6, s6, 0x3000000
; SI-NEXT:    s_and_b32 s7, s6, 0xffff0000
; SI-NEXT:    s_lshl_b32 s6, s6, 16
; SI-NEXT:    s_and_b32 s9, s5, 0xffff0000
; SI-NEXT:    s_lshl_b32 s8, s5, 16
; SI-NEXT:    s_and_b32 s11, s4, 0xffff0000
; SI-NEXT:    s_lshl_b32 s10, s4, 16
; SI-NEXT:  .LBB37_3: ; %end
; SI-NEXT:    v_mov_b32_e32 v0, s6
; SI-NEXT:    v_mov_b32_e32 v1, s7
; SI-NEXT:    v_mov_b32_e32 v2, s8
; SI-NEXT:    v_mov_b32_e32 v3, s9
; SI-NEXT:    v_mov_b32_e32 v4, s10
; SI-NEXT:    v_mov_b32_e32 v5, s11
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB37_4:
; SI-NEXT:    ; implicit-def: $sgpr6
; SI-NEXT:    ; implicit-def: $sgpr7
; SI-NEXT:    ; implicit-def: $sgpr8
; SI-NEXT:    ; implicit-def: $sgpr9
; SI-NEXT:    ; implicit-def: $sgpr10
; SI-NEXT:    ; implicit-def: $sgpr11
; SI-NEXT:    s_branch .LBB37_2
;
; VI-LABEL: bitcast_v12i8_to_v6bf16_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s28, 0
; VI-NEXT:    s_cbranch_scc0 .LBB37_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_and_b32 s4, s16, 0xff
; VI-NEXT:    s_lshl_b32 s5, s17, 8
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_and_b32 s5, s18, 0xff
; VI-NEXT:    s_lshl_b32 s6, s19, 8
; VI-NEXT:    s_or_b32 s5, s5, s6
; VI-NEXT:    s_and_b32 s4, s4, 0xffff
; VI-NEXT:    s_lshl_b32 s5, s5, 16
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_and_b32 s5, s20, 0xff
; VI-NEXT:    s_lshl_b32 s6, s21, 8
; VI-NEXT:    s_or_b32 s5, s5, s6
; VI-NEXT:    s_and_b32 s6, s22, 0xff
; VI-NEXT:    s_lshl_b32 s7, s23, 8
; VI-NEXT:    s_or_b32 s6, s6, s7
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_lshl_b32 s6, s6, 16
; VI-NEXT:    s_or_b32 s5, s5, s6
; VI-NEXT:    s_and_b32 s6, s24, 0xff
; VI-NEXT:    s_lshl_b32 s7, s25, 8
; VI-NEXT:    s_or_b32 s6, s6, s7
; VI-NEXT:    s_and_b32 s7, s26, 0xff
; VI-NEXT:    s_lshl_b32 s8, s27, 8
; VI-NEXT:    s_or_b32 s7, s7, s8
; VI-NEXT:    s_and_b32 s6, s6, 0xffff
; VI-NEXT:    s_lshl_b32 s7, s7, 16
; VI-NEXT:    s_or_b32 s6, s6, s7
; VI-NEXT:    s_cbranch_execnz .LBB37_3
; VI-NEXT:  .LBB37_2: ; %cmp.true
; VI-NEXT:    s_add_i32 s16, s16, 3
; VI-NEXT:    s_and_b32 s4, s16, 0xff
; VI-NEXT:    s_lshl_b32 s5, s17, 8
; VI-NEXT:    s_add_i32 s18, s18, 3
; VI-NEXT:    s_or_b32 s4, s5, s4
; VI-NEXT:    s_and_b32 s5, s18, 0xff
; VI-NEXT:    s_lshl_b32 s6, s19, 8
; VI-NEXT:    s_addk_i32 s4, 0x300
; VI-NEXT:    s_or_b32 s5, s6, s5
; VI-NEXT:    s_and_b32 s4, s4, 0xffff
; VI-NEXT:    s_lshl_b32 s5, s5, 16
; VI-NEXT:    s_add_i32 s20, s20, 3
; VI-NEXT:    s_or_b32 s4, s5, s4
; VI-NEXT:    s_and_b32 s5, s20, 0xff
; VI-NEXT:    s_lshl_b32 s6, s21, 8
; VI-NEXT:    s_add_i32 s22, s22, 3
; VI-NEXT:    s_or_b32 s5, s6, s5
; VI-NEXT:    s_and_b32 s6, s22, 0xff
; VI-NEXT:    s_lshl_b32 s7, s23, 8
; VI-NEXT:    s_addk_i32 s5, 0x300
; VI-NEXT:    s_or_b32 s6, s7, s6
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_lshl_b32 s6, s6, 16
; VI-NEXT:    s_add_i32 s24, s24, 3
; VI-NEXT:    s_or_b32 s5, s6, s5
; VI-NEXT:    s_and_b32 s6, s24, 0xff
; VI-NEXT:    s_lshl_b32 s7, s25, 8
; VI-NEXT:    s_add_i32 s26, s26, 3
; VI-NEXT:    s_or_b32 s6, s7, s6
; VI-NEXT:    s_and_b32 s7, s26, 0xff
; VI-NEXT:    s_lshl_b32 s8, s27, 8
; VI-NEXT:    s_addk_i32 s6, 0x300
; VI-NEXT:    s_or_b32 s7, s8, s7
; VI-NEXT:    s_and_b32 s6, s6, 0xffff
; VI-NEXT:    s_lshl_b32 s7, s7, 16
; VI-NEXT:    s_or_b32 s6, s7, s6
; VI-NEXT:    s_add_i32 s4, s4, 0x3000000
; VI-NEXT:    s_add_i32 s5, s5, 0x3000000
; VI-NEXT:    s_add_i32 s6, s6, 0x3000000
; VI-NEXT:  .LBB37_3: ; %end
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    v_mov_b32_e32 v1, s5
; VI-NEXT:    v_mov_b32_e32 v2, s6
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB37_4:
; VI-NEXT:    ; implicit-def: $sgpr4_sgpr5_sgpr6_sgpr7
; VI-NEXT:    s_branch .LBB37_2
;
; GFX9-LABEL: bitcast_v12i8_to_v6bf16_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s28, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB37_4
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_and_b32 s4, s16, 0xff
; GFX9-NEXT:    s_lshl_b32 s5, s17, 8
; GFX9-NEXT:    s_or_b32 s4, s4, s5
; GFX9-NEXT:    s_and_b32 s5, s18, 0xff
; GFX9-NEXT:    s_lshl_b32 s6, s19, 8
; GFX9-NEXT:    s_or_b32 s5, s5, s6
; GFX9-NEXT:    s_and_b32 s4, s4, 0xffff
; GFX9-NEXT:    s_lshl_b32 s5, s5, 16
; GFX9-NEXT:    s_or_b32 s4, s4, s5
; GFX9-NEXT:    s_and_b32 s5, s20, 0xff
; GFX9-NEXT:    s_lshl_b32 s6, s21, 8
; GFX9-NEXT:    s_or_b32 s5, s5, s6
; GFX9-NEXT:    s_and_b32 s6, s22, 0xff
; GFX9-NEXT:    s_lshl_b32 s7, s23, 8
; GFX9-NEXT:    s_or_b32 s6, s6, s7
; GFX9-NEXT:    s_and_b32 s5, s5, 0xffff
; GFX9-NEXT:    s_lshl_b32 s6, s6, 16
; GFX9-NEXT:    s_or_b32 s5, s5, s6
; GFX9-NEXT:    s_and_b32 s6, s24, 0xff
; GFX9-NEXT:    s_lshl_b32 s7, s25, 8
; GFX9-NEXT:    s_or_b32 s6, s6, s7
; GFX9-NEXT:    s_and_b32 s7, s26, 0xff
; GFX9-NEXT:    s_lshl_b32 s8, s27, 8
; GFX9-NEXT:    s_or_b32 s7, s7, s8
; GFX9-NEXT:    s_and_b32 s6, s6, 0xffff
; GFX9-NEXT:    s_lshl_b32 s7, s7, 16
; GFX9-NEXT:    s_or_b32 s6, s6, s7
; GFX9-NEXT:    s_cbranch_execnz .LBB37_3
; GFX9-NEXT:  .LBB37_2: ; %cmp.true
; GFX9-NEXT:    s_add_i32 s16, s16, 3
; GFX9-NEXT:    s_and_b32 s4, s16, 0xff
; GFX9-NEXT:    s_lshl_b32 s5, s17, 8
; GFX9-NEXT:    s_add_i32 s18, s18, 3
; GFX9-NEXT:    s_or_b32 s4, s5, s4
; GFX9-NEXT:    s_and_b32 s5, s18, 0xff
; GFX9-NEXT:    s_lshl_b32 s6, s19, 8
; GFX9-NEXT:    s_or_b32 s5, s6, s5
; GFX9-NEXT:    s_addk_i32 s4, 0x300
; GFX9-NEXT:    s_addk_i32 s5, 0x300
; GFX9-NEXT:    s_and_b32 s4, s4, 0xffff
; GFX9-NEXT:    s_lshl_b32 s5, s5, 16
; GFX9-NEXT:    s_add_i32 s20, s20, 3
; GFX9-NEXT:    s_or_b32 s4, s4, s5
; GFX9-NEXT:    s_and_b32 s5, s20, 0xff
; GFX9-NEXT:    s_lshl_b32 s6, s21, 8
; GFX9-NEXT:    s_add_i32 s22, s22, 3
; GFX9-NEXT:    s_or_b32 s5, s6, s5
; GFX9-NEXT:    s_and_b32 s6, s22, 0xff
; GFX9-NEXT:    s_lshl_b32 s7, s23, 8
; GFX9-NEXT:    s_or_b32 s6, s7, s6
; GFX9-NEXT:    s_addk_i32 s5, 0x300
; GFX9-NEXT:    s_addk_i32 s6, 0x300
; GFX9-NEXT:    s_and_b32 s5, s5, 0xffff
; GFX9-NEXT:    s_lshl_b32 s6, s6, 16
; GFX9-NEXT:    s_add_i32 s24, s24, 3
; GFX9-NEXT:    s_or_b32 s5, s5, s6
; GFX9-NEXT:    s_and_b32 s6, s24, 0xff
; GFX9-NEXT:    s_lshl_b32 s7, s25, 8
; GFX9-NEXT:    s_add_i32 s26, s26, 3
; GFX9-NEXT:    s_or_b32 s6, s7, s6
; GFX9-NEXT:    s_and_b32 s7, s26, 0xff
; GFX9-NEXT:    s_lshl_b32 s8, s27, 8
; GFX9-NEXT:    s_or_b32 s7, s8, s7
; GFX9-NEXT:    s_addk_i32 s6, 0x300
; GFX9-NEXT:    s_addk_i32 s7, 0x300
; GFX9-NEXT:    s_and_b32 s6, s6, 0xffff
; GFX9-NEXT:    s_lshl_b32 s7, s7, 16
; GFX9-NEXT:    s_or_b32 s6, s6, s7
; GFX9-NEXT:  .LBB37_3: ; %end
; GFX9-NEXT:    v_mov_b32_e32 v0, s4
; GFX9-NEXT:    v_mov_b32_e32 v1, s5
; GFX9-NEXT:    v_mov_b32_e32 v2, s6
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB37_4:
; GFX9-NEXT:    ; implicit-def: $sgpr4_sgpr5_sgpr6_sgpr7
; GFX9-NEXT:    s_branch .LBB37_2
;
; GFX11-LABEL: bitcast_v12i8_to_v6bf16_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_cmp_lg_u32 s24, 0
; GFX11-NEXT:    s_mov_b32 s8, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB37_4
; GFX11-NEXT:  ; %bb.1: ; %cmp.false
; GFX11-NEXT:    s_and_b32 s4, s0, 0xff
; GFX11-NEXT:    s_lshl_b32 s5, s1, 8
; GFX11-NEXT:    s_and_b32 s6, s2, 0xff
; GFX11-NEXT:    s_lshl_b32 s7, s3, 8
; GFX11-NEXT:    s_or_b32 s4, s4, s5
; GFX11-NEXT:    s_or_b32 s5, s6, s7
; GFX11-NEXT:    s_and_b32 s4, s4, 0xffff
; GFX11-NEXT:    s_lshl_b32 s5, s5, 16
; GFX11-NEXT:    s_lshl_b32 s6, s17, 8
; GFX11-NEXT:    s_or_b32 s4, s4, s5
; GFX11-NEXT:    s_and_b32 s5, s16, 0xff
; GFX11-NEXT:    s_and_b32 s7, s18, 0xff
; GFX11-NEXT:    s_lshl_b32 s9, s19, 8
; GFX11-NEXT:    s_or_b32 s5, s5, s6
; GFX11-NEXT:    s_or_b32 s6, s7, s9
; GFX11-NEXT:    s_and_b32 s7, s20, 0xff
; GFX11-NEXT:    s_lshl_b32 s9, s21, 8
; GFX11-NEXT:    s_and_b32 s10, s22, 0xff
; GFX11-NEXT:    s_lshl_b32 s11, s23, 8
; GFX11-NEXT:    s_or_b32 s7, s7, s9
; GFX11-NEXT:    s_or_b32 s9, s10, s11
; GFX11-NEXT:    s_and_b32 s5, s5, 0xffff
; GFX11-NEXT:    s_lshl_b32 s6, s6, 16
; GFX11-NEXT:    s_and_b32 s7, s7, 0xffff
; GFX11-NEXT:    s_lshl_b32 s9, s9, 16
; GFX11-NEXT:    s_or_b32 s5, s5, s6
; GFX11-NEXT:    s_or_b32 s6, s7, s9
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s8
; GFX11-NEXT:    s_cbranch_vccnz .LBB37_3
; GFX11-NEXT:  .LBB37_2: ; %cmp.true
; GFX11-NEXT:    s_add_i32 s0, s0, 3
; GFX11-NEXT:    s_add_i32 s2, s2, 3
; GFX11-NEXT:    s_and_b32 s0, s0, 0xff
; GFX11-NEXT:    s_lshl_b32 s1, s1, 8
; GFX11-NEXT:    s_and_b32 s2, s2, 0xff
; GFX11-NEXT:    s_lshl_b32 s3, s3, 8
; GFX11-NEXT:    s_or_b32 s0, s1, s0
; GFX11-NEXT:    s_or_b32 s1, s3, s2
; GFX11-NEXT:    s_addk_i32 s0, 0x300
; GFX11-NEXT:    s_addk_i32 s1, 0x300
; GFX11-NEXT:    s_and_b32 s0, s0, 0xffff
; GFX11-NEXT:    s_lshl_b32 s1, s1, 16
; GFX11-NEXT:    s_add_i32 s16, s16, 3
; GFX11-NEXT:    s_or_b32 s4, s0, s1
; GFX11-NEXT:    s_and_b32 s0, s16, 0xff
; GFX11-NEXT:    s_lshl_b32 s1, s17, 8
; GFX11-NEXT:    s_add_i32 s18, s18, 3
; GFX11-NEXT:    s_or_b32 s0, s1, s0
; GFX11-NEXT:    s_and_b32 s1, s18, 0xff
; GFX11-NEXT:    s_lshl_b32 s2, s19, 8
; GFX11-NEXT:    s_add_i32 s20, s20, 3
; GFX11-NEXT:    s_add_i32 s22, s22, 3
; GFX11-NEXT:    s_or_b32 s1, s2, s1
; GFX11-NEXT:    s_and_b32 s2, s20, 0xff
; GFX11-NEXT:    s_lshl_b32 s3, s21, 8
; GFX11-NEXT:    s_and_b32 s5, s22, 0xff
; GFX11-NEXT:    s_lshl_b32 s6, s23, 8
; GFX11-NEXT:    s_or_b32 s2, s3, s2
; GFX11-NEXT:    s_or_b32 s3, s6, s5
; GFX11-NEXT:    s_addk_i32 s0, 0x300
; GFX11-NEXT:    s_addk_i32 s1, 0x300
; GFX11-NEXT:    s_addk_i32 s2, 0x300
; GFX11-NEXT:    s_addk_i32 s3, 0x300
; GFX11-NEXT:    s_and_b32 s0, s0, 0xffff
; GFX11-NEXT:    s_lshl_b32 s1, s1, 16
; GFX11-NEXT:    s_and_b32 s2, s2, 0xffff
; GFX11-NEXT:    s_lshl_b32 s3, s3, 16
; GFX11-NEXT:    s_or_b32 s5, s0, s1
; GFX11-NEXT:    s_or_b32 s6, s2, s3
; GFX11-NEXT:  .LBB37_3: ; %end
; GFX11-NEXT:    v_dual_mov_b32 v0, s4 :: v_dual_mov_b32 v1, s5
; GFX11-NEXT:    v_mov_b32_e32 v2, s6
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB37_4:
; GFX11-NEXT:    ; implicit-def: $sgpr4_sgpr5_sgpr6_sgpr7
; GFX11-NEXT:    s_branch .LBB37_2
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <12 x i8> %a, splat (i8 3)
  %a2 = bitcast <12 x i8> %a1 to <6 x bfloat>
  br label %end

cmp.false:
  %a3 = bitcast <12 x i8> %a to <6 x bfloat>
  br label %end

end:
  %phi = phi <6 x bfloat> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <6 x bfloat> %phi
}

define <12 x i8> @bitcast_v6bf16_to_v12i8(<6 x bfloat> %a, i32 %b) {
; SI-LABEL: bitcast_v6bf16_to_v12i8:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v6
; SI-NEXT:    v_mul_f32_e32 v16, 1.0, v1
; SI-NEXT:    v_mul_f32_e32 v17, 1.0, v0
; SI-NEXT:    v_mul_f32_e32 v14, 1.0, v3
; SI-NEXT:    v_mul_f32_e32 v15, 1.0, v2
; SI-NEXT:    v_mul_f32_e32 v12, 1.0, v5
; SI-NEXT:    v_mul_f32_e32 v13, 1.0, v4
; SI-NEXT:    ; implicit-def: $vgpr0
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    ; implicit-def: $vgpr4
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    ; implicit-def: $vgpr6
; SI-NEXT:    ; implicit-def: $vgpr7
; SI-NEXT:    ; implicit-def: $vgpr8
; SI-NEXT:    ; implicit-def: $vgpr9
; SI-NEXT:    ; implicit-def: $vgpr10
; SI-NEXT:    ; implicit-def: $vgpr11
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB38_3
; SI-NEXT:  ; %bb.1: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB38_4
; SI-NEXT:  .LBB38_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB38_3: ; %cmp.false
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v16
; SI-NEXT:    v_lshrrev_b32_e32 v6, 16, v14
; SI-NEXT:    v_lshrrev_b32_e32 v10, 16, v12
; SI-NEXT:    v_alignbit_b32 v0, v0, v17, 16
; SI-NEXT:    v_alignbit_b32 v4, v6, v15, 16
; SI-NEXT:    v_alignbit_b32 v8, v10, v13, 16
; SI-NEXT:    v_alignbit_b32 v3, v4, v0, 24
; SI-NEXT:    v_alignbit_b32 v2, v4, v0, 16
; SI-NEXT:    v_alignbit_b32 v1, v4, v0, 8
; SI-NEXT:    v_lshrrev_b32_e32 v7, 24, v14
; SI-NEXT:    v_lshrrev_b32_e32 v11, 24, v12
; SI-NEXT:    v_lshrrev_b32_e32 v5, 8, v4
; SI-NEXT:    v_lshrrev_b32_e32 v9, 8, v8
; SI-NEXT:    ; implicit-def: $vgpr17
; SI-NEXT:    ; implicit-def: $vgpr16
; SI-NEXT:    ; implicit-def: $vgpr15
; SI-NEXT:    ; implicit-def: $vgpr14
; SI-NEXT:    ; implicit-def: $vgpr13
; SI-NEXT:    ; implicit-def: $vgpr12
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB38_2
; SI-NEXT:  .LBB38_4: ; %cmp.true
; SI-NEXT:    v_and_b32_e32 v1, 0xffff0000, v16
; SI-NEXT:    v_and_b32_e32 v0, 0xffff0000, v17
; SI-NEXT:    v_add_f32_e32 v1, 0x40c00000, v1
; SI-NEXT:    v_add_f32_e32 v0, 0x40c00000, v0
; SI-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_and_b32_e32 v2, 0xffff0000, v14
; SI-NEXT:    v_alignbit_b32 v0, v1, v0, 16
; SI-NEXT:    v_and_b32_e32 v1, 0xffff0000, v15
; SI-NEXT:    v_add_f32_e32 v7, 0x40c00000, v2
; SI-NEXT:    v_add_f32_e32 v1, 0x40c00000, v1
; SI-NEXT:    v_lshrrev_b32_e32 v6, 16, v7
; SI-NEXT:    v_and_b32_e32 v2, 0xffff0000, v12
; SI-NEXT:    v_alignbit_b32 v4, v6, v1, 16
; SI-NEXT:    v_and_b32_e32 v1, 0xffff0000, v13
; SI-NEXT:    v_add_f32_e32 v11, 0x40c00000, v2
; SI-NEXT:    v_add_f32_e32 v1, 0x40c00000, v1
; SI-NEXT:    v_lshrrev_b32_e32 v10, 16, v11
; SI-NEXT:    v_alignbit_b32 v8, v10, v1, 16
; SI-NEXT:    v_alignbit_b32 v3, v4, v0, 24
; SI-NEXT:    v_alignbit_b32 v2, v4, v0, 16
; SI-NEXT:    v_alignbit_b32 v1, v4, v0, 8
; SI-NEXT:    v_lshrrev_b32_e32 v5, 8, v4
; SI-NEXT:    v_lshrrev_b32_e32 v9, 8, v8
; SI-NEXT:    v_lshrrev_b32_e32 v7, 24, v7
; SI-NEXT:    v_lshrrev_b32_e32 v11, 24, v11
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v6bf16_to_v12i8:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v13, v2
; VI-NEXT:    v_mov_b32_e32 v16, v1
; VI-NEXT:    v_mov_b32_e32 v15, v0
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v3
; VI-NEXT:    ; implicit-def: $vgpr1
; VI-NEXT:    ; implicit-def: $vgpr2
; VI-NEXT:    ; implicit-def: $vgpr3
; VI-NEXT:    ; implicit-def: $vgpr5
; VI-NEXT:    ; implicit-def: $vgpr6
; VI-NEXT:    ; implicit-def: $vgpr7
; VI-NEXT:    ; implicit-def: $vgpr9
; VI-NEXT:    ; implicit-def: $vgpr10
; VI-NEXT:    ; implicit-def: $vgpr11
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB38_2
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    v_lshrrev_b32_e32 v10, 16, v13
; VI-NEXT:    v_lshrrev_b32_e32 v9, 8, v13
; VI-NEXT:    v_lshrrev_b32_e32 v7, 24, v16
; VI-NEXT:    v_lshrrev_b32_e32 v6, 16, v16
; VI-NEXT:    v_lshrrev_b32_e32 v5, 8, v16
; VI-NEXT:    v_lshrrev_b32_e32 v2, 16, v15
; VI-NEXT:    v_lshrrev_b64 v[11:12], 24, v[13:14]
; VI-NEXT:    v_lshrrev_b64 v[3:4], 24, v[15:16]
; VI-NEXT:    v_lshrrev_b32_e32 v1, 8, v15
; VI-NEXT:  .LBB38_2: ; %Flow
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB38_4
; VI-NEXT:  ; %bb.3: ; %cmp.true
; VI-NEXT:    v_lshlrev_b32_e32 v0, 16, v16
; VI-NEXT:    v_add_f32_e32 v0, 0x40c00000, v0
; VI-NEXT:    v_bfe_u32 v1, v0, 16, 1
; VI-NEXT:    v_add_u32_e32 v1, vcc, v1, v0
; VI-NEXT:    v_add_u32_e32 v1, vcc, 0x7fff, v1
; VI-NEXT:    v_or_b32_e32 v2, 0x400000, v0
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v0, v0
; VI-NEXT:    v_cndmask_b32_e32 v0, v1, v2, vcc
; VI-NEXT:    v_and_b32_e32 v1, 0xffff0000, v16
; VI-NEXT:    v_add_f32_e32 v1, 0x40c00000, v1
; VI-NEXT:    v_bfe_u32 v2, v1, 16, 1
; VI-NEXT:    s_movk_i32 s6, 0x7fff
; VI-NEXT:    v_add_u32_e32 v2, vcc, v2, v1
; VI-NEXT:    v_add_u32_e32 v2, vcc, s6, v2
; VI-NEXT:    v_or_b32_e32 v3, 0x400000, v1
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; VI-NEXT:    v_cndmask_b32_e32 v1, v2, v3, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; VI-NEXT:    v_alignbit_b32 v16, v1, v0, 16
; VI-NEXT:    v_lshlrev_b32_e32 v0, 16, v15
; VI-NEXT:    v_add_f32_e32 v0, 0x40c00000, v0
; VI-NEXT:    v_bfe_u32 v1, v0, 16, 1
; VI-NEXT:    v_add_u32_e32 v1, vcc, v1, v0
; VI-NEXT:    v_add_u32_e32 v1, vcc, s6, v1
; VI-NEXT:    v_or_b32_e32 v2, 0x400000, v0
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v0, v0
; VI-NEXT:    v_cndmask_b32_e32 v0, v1, v2, vcc
; VI-NEXT:    v_and_b32_e32 v1, 0xffff0000, v15
; VI-NEXT:    v_add_f32_e32 v1, 0x40c00000, v1
; VI-NEXT:    v_bfe_u32 v2, v1, 16, 1
; VI-NEXT:    v_add_u32_e32 v2, vcc, v2, v1
; VI-NEXT:    v_add_u32_e32 v2, vcc, s6, v2
; VI-NEXT:    v_or_b32_e32 v3, 0x400000, v1
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; VI-NEXT:    v_cndmask_b32_e32 v1, v2, v3, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; VI-NEXT:    v_alignbit_b32 v15, v1, v0, 16
; VI-NEXT:    v_lshlrev_b32_e32 v0, 16, v13
; VI-NEXT:    v_add_f32_e32 v0, 0x40c00000, v0
; VI-NEXT:    v_bfe_u32 v1, v0, 16, 1
; VI-NEXT:    v_add_u32_e32 v1, vcc, v1, v0
; VI-NEXT:    v_add_u32_e32 v1, vcc, s6, v1
; VI-NEXT:    v_or_b32_e32 v2, 0x400000, v0
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v0, v0
; VI-NEXT:    v_cndmask_b32_e32 v0, v1, v2, vcc
; VI-NEXT:    v_and_b32_e32 v1, 0xffff0000, v13
; VI-NEXT:    v_add_f32_e32 v1, 0x40c00000, v1
; VI-NEXT:    v_bfe_u32 v2, v1, 16, 1
; VI-NEXT:    v_add_u32_e32 v2, vcc, v2, v1
; VI-NEXT:    v_add_u32_e32 v2, vcc, s6, v2
; VI-NEXT:    v_or_b32_e32 v3, 0x400000, v1
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; VI-NEXT:    v_cndmask_b32_e32 v1, v2, v3, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; VI-NEXT:    v_alignbit_b32 v13, v1, v0, 16
; VI-NEXT:    v_mov_b32_e32 v14, 0x7fc07fc0
; VI-NEXT:    v_lshrrev_b64 v[3:4], 24, v[15:16]
; VI-NEXT:    v_lshrrev_b64 v[11:12], 24, v[13:14]
; VI-NEXT:    v_lshrrev_b32_e32 v10, 16, v13
; VI-NEXT:    v_lshrrev_b32_e32 v9, 8, v13
; VI-NEXT:    v_lshrrev_b32_e32 v7, 24, v16
; VI-NEXT:    v_lshrrev_b32_e32 v6, 16, v16
; VI-NEXT:    v_lshrrev_b32_e32 v5, 8, v16
; VI-NEXT:    v_lshrrev_b32_e32 v2, 16, v15
; VI-NEXT:    v_lshrrev_b32_e32 v1, 8, v15
; VI-NEXT:  .LBB38_4: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    v_mov_b32_e32 v0, v15
; VI-NEXT:    v_mov_b32_e32 v4, v16
; VI-NEXT:    v_mov_b32_e32 v8, v13
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v6bf16_to_v12i8:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v8, v2
; GFX9-NEXT:    v_mov_b32_e32 v14, v1
; GFX9-NEXT:    v_mov_b32_e32 v13, v0
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v3
; GFX9-NEXT:    ; implicit-def: $vgpr1
; GFX9-NEXT:    ; implicit-def: $vgpr2
; GFX9-NEXT:    ; implicit-def: $vgpr3
; GFX9-NEXT:    ; implicit-def: $vgpr5
; GFX9-NEXT:    ; implicit-def: $vgpr6
; GFX9-NEXT:    ; implicit-def: $vgpr7
; GFX9-NEXT:    ; implicit-def: $vgpr9
; GFX9-NEXT:    ; implicit-def: $vgpr10
; GFX9-NEXT:    ; implicit-def: $vgpr11
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB38_2
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    v_lshrrev_b32_e32 v9, 8, v8
; GFX9-NEXT:    v_lshrrev_b32_e32 v10, 16, v8
; GFX9-NEXT:    v_lshrrev_b32_e32 v7, 24, v14
; GFX9-NEXT:    v_lshrrev_b32_e32 v6, 16, v14
; GFX9-NEXT:    v_lshrrev_b32_e32 v5, 8, v14
; GFX9-NEXT:    v_lshrrev_b32_e32 v2, 16, v13
; GFX9-NEXT:    v_lshrrev_b64 v[11:12], 24, v[8:9]
; GFX9-NEXT:    v_lshrrev_b64 v[3:4], 24, v[13:14]
; GFX9-NEXT:    v_lshrrev_b32_e32 v1, 8, v13
; GFX9-NEXT:  .LBB38_2: ; %Flow
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB38_4
; GFX9-NEXT:  ; %bb.3: ; %cmp.true
; GFX9-NEXT:    v_and_b32_e32 v0, 0xffff0000, v14
; GFX9-NEXT:    v_add_f32_e32 v0, 0x40c00000, v0
; GFX9-NEXT:    v_bfe_u32 v1, v0, 16, 1
; GFX9-NEXT:    s_movk_i32 s6, 0x7fff
; GFX9-NEXT:    v_add3_u32 v1, v1, v0, s6
; GFX9-NEXT:    v_or_b32_e32 v2, 0x400000, v0
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v0, v0
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 16, v14
; GFX9-NEXT:    v_add_f32_e32 v0, 0x40c00000, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v2, v1, v2, vcc
; GFX9-NEXT:    v_bfe_u32 v1, v0, 16, 1
; GFX9-NEXT:    v_add3_u32 v1, v1, v0, s6
; GFX9-NEXT:    v_or_b32_e32 v3, 0x400000, v0
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v0, v0
; GFX9-NEXT:    v_and_b32_e32 v0, 0xffff0000, v13
; GFX9-NEXT:    v_add_f32_e32 v0, 0x40c00000, v0
; GFX9-NEXT:    v_bfe_u32 v4, v0, 16, 1
; GFX9-NEXT:    v_cndmask_b32_e32 v3, v1, v3, vcc
; GFX9-NEXT:    v_add3_u32 v4, v4, v0, s6
; GFX9-NEXT:    v_or_b32_e32 v5, 0x400000, v0
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v0, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v4, v5, vcc
; GFX9-NEXT:    v_lshlrev_b32_e32 v4, 16, v13
; GFX9-NEXT:    v_add_f32_e32 v4, 0x40c00000, v4
; GFX9-NEXT:    v_bfe_u32 v5, v4, 16, 1
; GFX9-NEXT:    v_add3_u32 v5, v5, v4, s6
; GFX9-NEXT:    v_or_b32_e32 v6, 0x400000, v4
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v4, v4
; GFX9-NEXT:    v_cndmask_b32_e32 v4, v5, v6, vcc
; GFX9-NEXT:    v_and_b32_e32 v5, 0xffff0000, v8
; GFX9-NEXT:    v_add_f32_e32 v5, 0x40c00000, v5
; GFX9-NEXT:    v_bfe_u32 v6, v5, 16, 1
; GFX9-NEXT:    v_add3_u32 v6, v6, v5, s6
; GFX9-NEXT:    v_or_b32_e32 v7, 0x400000, v5
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v5, v5
; GFX9-NEXT:    v_cndmask_b32_e32 v5, v6, v7, vcc
; GFX9-NEXT:    v_lshlrev_b32_e32 v6, 16, v8
; GFX9-NEXT:    v_add_f32_e32 v6, 0x40c00000, v6
; GFX9-NEXT:    v_bfe_u32 v7, v6, 16, 1
; GFX9-NEXT:    v_add3_u32 v7, v7, v6, s6
; GFX9-NEXT:    v_or_b32_e32 v8, 0x400000, v6
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v6, v6
; GFX9-NEXT:    s_mov_b32 s7, 0x7060302
; GFX9-NEXT:    v_cndmask_b32_e32 v7, v7, v8, vcc
; GFX9-NEXT:    v_perm_b32 v1, v2, v3, s7
; GFX9-NEXT:    v_perm_b32 v0, v0, v4, s7
; GFX9-NEXT:    v_perm_b32 v11, v5, v7, s7
; GFX9-NEXT:    v_mov_b32_e32 v12, 0x7fc07fc0
; GFX9-NEXT:    v_lshrrev_b32_e32 v14, 16, v3
; GFX9-NEXT:    v_lshrrev_b32_e32 v13, 16, v4
; GFX9-NEXT:    v_lshrrev_b64 v[3:4], 24, v[0:1]
; GFX9-NEXT:    v_lshrrev_b32_e32 v10, 16, v11
; GFX9-NEXT:    v_lshrrev_b32_e32 v9, 8, v11
; GFX9-NEXT:    v_lshrrev_b64 v[11:12], 24, v[11:12]
; GFX9-NEXT:    v_lshrrev_b32_e32 v6, 16, v2
; GFX9-NEXT:    v_lshrrev_b32_e32 v8, 16, v7
; GFX9-NEXT:    v_lshrrev_b32_e32 v7, 24, v1
; GFX9-NEXT:    v_lshrrev_b32_e32 v5, 8, v1
; GFX9-NEXT:    v_lshrrev_b32_e32 v2, 16, v0
; GFX9-NEXT:    v_lshrrev_b32_e32 v1, 8, v0
; GFX9-NEXT:  .LBB38_4: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    v_mov_b32_e32 v0, v13
; GFX9-NEXT:    v_mov_b32_e32 v4, v14
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-TRUE16-LABEL: bitcast_v6bf16_to_v12i8:
; GFX11-TRUE16:       ; %bb.0:
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-TRUE16-NEXT:    v_dual_mov_b32 v10, v2 :: v_dual_mov_b32 v13, v1
; GFX11-TRUE16-NEXT:    v_mov_b32_e32 v12, v0
; GFX11-TRUE16-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr0_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr1_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr14_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr4_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr5_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr6_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr7_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr8_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr9_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr16_lo16
; GFX11-TRUE16-NEXT:    v_cmpx_ne_u32_e32 0, v3
; GFX11-TRUE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-TRUE16-NEXT:    s_cbranch_execz .LBB38_2
; GFX11-TRUE16-NEXT:  ; %bb.1: ; %cmp.false
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v9, 8, v10
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v7, 24, v13
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v5, 8, v13
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v1, 8, v12
; GFX11-TRUE16-NEXT:    v_lshrrev_b64 v[16:17], 24, v[10:11]
; GFX11-TRUE16-NEXT:    v_lshrrev_b64 v[14:15], 24, v[12:13]
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v0.h, v12.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v4.h, v13.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v6.h, v13.h
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v8.h, v10.l
; GFX11-TRUE16-NEXT:  .LBB38_2: ; %Flow
; GFX11-TRUE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-TRUE16-NEXT:    s_cbranch_execz .LBB38_4
; GFX11-TRUE16-NEXT:  ; %bb.3: ; %cmp.true
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v12
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v0, 16, v13
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v4, 0xffff0000, v10
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v5, 16, v10
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-TRUE16-NEXT:    v_dual_add_f32 v3, 0x40c00000, v3 :: v_dual_add_f32 v0, 0x40c00000, v0
; GFX11-TRUE16-NEXT:    v_add_f32_e32 v5, 0x40c00000, v5
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX11-TRUE16-NEXT:    v_bfe_u32 v6, v0, 16, 1
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v8, 0x400000, v0
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v0, v0
; GFX11-TRUE16-NEXT:    v_add3_u32 v6, v6, v0, 0x7fff
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v1, 0xffff0000, v13
; GFX11-TRUE16-NEXT:    v_bfe_u32 v0, v3, 16, 1
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v13, 0x400000, v5
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_add3_u32 v0, v0, v3, 0x7fff
; GFX11-TRUE16-NEXT:    v_add_f32_e32 v1, 0x40c00000, v1
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_1)
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v9, 0x400000, v1
; GFX11-TRUE16-NEXT:    v_add_f32_e32 v7, 0x40c00000, v4
; GFX11-TRUE16-NEXT:    v_bfe_u32 v4, v1, 16, 1
; GFX11-TRUE16-NEXT:    v_add3_u32 v11, v4, v1, 0x7fff
; GFX11-TRUE16-NEXT:    v_cndmask_b32_e32 v4, v6, v8, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v1, v1
; GFX11-TRUE16-NEXT:    v_bfe_u32 v8, v5, 16, 1
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_4) | instid1(VALU_DEP_3)
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v1.l, v4.h
; GFX11-TRUE16-NEXT:    v_cndmask_b32_e32 v6, v11, v9, vcc_lo
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v11, 0x400000, v3
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v3, v3
; GFX11-TRUE16-NEXT:    v_add3_u32 v8, v8, v5, 0x7fff
; GFX11-TRUE16-NEXT:    v_cndmask_b32_e32 v0, v0, v11, vcc_lo
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v11, 0x400000, v7
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v2, 0xffff0000, v12
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v5, v5
; GFX11-TRUE16-NEXT:    v_bfe_u32 v12, v7, 16, 1
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v5.l, v0.h
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_1) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_add_f32_e32 v2, 0x40c00000, v2
; GFX11-TRUE16-NEXT:    v_cndmask_b32_e32 v8, v8, v13, vcc_lo
; GFX11-TRUE16-NEXT:    v_add3_u32 v3, v12, v7, 0x7fff
; GFX11-TRUE16-NEXT:    v_bfi_b32 v13, 0xffff, v1, v6
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX11-TRUE16-NEXT:    v_bfe_u32 v10, v2, 16, 1
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v9, 0x400000, v2
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v2, v2
; GFX11-TRUE16-NEXT:    v_add3_u32 v10, v10, v2, 0x7fff
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-TRUE16-NEXT:    v_cndmask_b32_e32 v2, v10, v9, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v7, v7
; GFX11-TRUE16-NEXT:    v_bfi_b32 v12, 0xffff, v5, v2
; GFX11-TRUE16-NEXT:    v_cndmask_b32_e32 v3, v3, v11, vcc_lo
; GFX11-TRUE16-NEXT:    v_mov_b32_e32 v11, 0x7fc07fc0
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v7.l, v8.h
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v5, 8, v13
; GFX11-TRUE16-NEXT:    v_lshrrev_b64 v[14:15], 24, v[12:13]
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v1, 8, v12
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-TRUE16-NEXT:    v_bfi_b32 v10, 0xffff, v7, v3
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v7, 24, v13
; GFX11-TRUE16-NEXT:    v_lshrrev_b64 v[16:17], 24, v[10:11]
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v9, 8, v10
; GFX11-TRUE16-NEXT:  .LBB38_4: ; %end
; GFX11-TRUE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v0.l, v0.h
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v2.l, v12.h
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v3.l, v14.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v4.l, v4.h
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v6.l, v6.h
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v8.l, v8.h
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v10.l, v10.h
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v11.l, v16.l
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-FAKE16-LABEL: bitcast_v6bf16_to_v12i8:
; GFX11-FAKE16:       ; %bb.0:
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-FAKE16-NEXT:    v_dual_mov_b32 v8, v2 :: v_dual_mov_b32 v13, v0
; GFX11-FAKE16-NEXT:    v_mov_b32_e32 v14, v1
; GFX11-FAKE16-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v3
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr1
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr2
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr3
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr5
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr6
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr7
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr9
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr10
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr11
; GFX11-FAKE16-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-FAKE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_cbranch_execz .LBB38_2
; GFX11-FAKE16-NEXT:  ; %bb.1: ; %cmp.false
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v9, 8, v8
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v10, 16, v8
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v7, 24, v14
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v6, 16, v14
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v5, 8, v14
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v2, 16, v13
; GFX11-FAKE16-NEXT:    v_lshrrev_b64 v[11:12], 24, v[8:9]
; GFX11-FAKE16-NEXT:    v_lshrrev_b64 v[3:4], 24, v[13:14]
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 8, v13
; GFX11-FAKE16-NEXT:  .LBB38_2: ; %Flow
; GFX11-FAKE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-FAKE16-NEXT:    s_cbranch_execz .LBB38_4
; GFX11-FAKE16-NEXT:  ; %bb.3: ; %cmp.true
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v1, 16, v14
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v5, 16, v8
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v2, 0xffff0000, v13
; GFX11-FAKE16-NEXT:    v_dual_mov_b32 v12, 0x7fc07fc0 :: v_dual_lshlrev_b32 v3, 16, v13
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_add_f32_e32 v1, 0x40c00000, v1
; GFX11-FAKE16-NEXT:    v_dual_add_f32 v5, 0x40c00000, v5 :: v_dual_add_f32 v2, 0x40c00000, v2
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_bfe_u32 v7, v1, 16, 1
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v9, 0x400000, v1
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v11, 0x400000, v5
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v4, 0xffff0000, v8
; GFX11-FAKE16-NEXT:    v_add_f32_e32 v3, 0x40c00000, v3
; GFX11-FAKE16-NEXT:    v_add3_u32 v7, v7, v1, 0x7fff
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v0, 0xffff0000, v14
; GFX11-FAKE16-NEXT:    v_bfe_u32 v10, v2, 16, 1
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_add_f32_e32 v0, 0x40c00000, v0
; GFX11-FAKE16-NEXT:    v_bfe_u32 v6, v0, 16, 1
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v8, 0x400000, v0
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v0, v0
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_add3_u32 v6, v6, v0, 0x7fff
; GFX11-FAKE16-NEXT:    v_add_f32_e32 v0, 0x40c00000, v4
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v4, 0x400000, v2
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v6, v6, v8, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v1, v1
; GFX11-FAKE16-NEXT:    v_add3_u32 v1, v10, v2, 0x7fff
; GFX11-FAKE16-NEXT:    v_bfe_u32 v8, v3, 16, 1
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v10, 0x400000, v0
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v7, v7, v9, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v2, v2
; GFX11-FAKE16-NEXT:    v_bfe_u32 v9, v0, 16, 1
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v14, 16, v7
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v2, v1, v4, vcc_lo
; GFX11-FAKE16-NEXT:    v_add3_u32 v4, v8, v3, 0x7fff
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v8, 0x400000, v3
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v3, v3
; GFX11-FAKE16-NEXT:    v_bfe_u32 v1, v5, 16, 1
; GFX11-FAKE16-NEXT:    v_add3_u32 v9, v9, v0, 0x7fff
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_1) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v3, v4, v8, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v0, v0
; GFX11-FAKE16-NEXT:    v_add3_u32 v1, v1, v5, 0x7fff
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_3) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_perm_b32 v0, v2, v3, 0x7060302
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v4, v9, v10, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v5, v5
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v13, 16, v3
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v2, 16, v0
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v5, v1, v11, vcc_lo
; GFX11-FAKE16-NEXT:    v_perm_b32 v1, v6, v7, 0x7060302
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v6, 16, v6
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_perm_b32 v11, v4, v5, 0x7060302
; GFX11-FAKE16-NEXT:    v_lshrrev_b64 v[3:4], 24, v[0:1]
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v8, 16, v5
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v7, 24, v1
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v5, 8, v1
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v10, 16, v11
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v9, 8, v11
; GFX11-FAKE16-NEXT:    v_lshrrev_b64 v[11:12], 24, v[11:12]
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 8, v0
; GFX11-FAKE16-NEXT:  .LBB38_4: ; %end
; GFX11-FAKE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-FAKE16-NEXT:    v_mov_b32_e32 v0, v13
; GFX11-FAKE16-NEXT:    v_mov_b32_e32 v4, v14
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <6 x bfloat> %a, splat (bfloat 0xR40C0)
  %a2 = bitcast <6 x bfloat> %a1 to <12 x i8>
  br label %end

cmp.false:
  %a3 = bitcast <6 x bfloat> %a to <12 x i8>
  br label %end

end:
  %phi = phi <12 x i8> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <12 x i8> %phi
}

define inreg <12 x i8> @bitcast_v6bf16_to_v12i8_scalar(<6 x bfloat> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v6bf16_to_v12i8_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s22, 0
; SI-NEXT:    v_mul_f32_e64 v16, 1.0, s17
; SI-NEXT:    v_mul_f32_e64 v17, 1.0, s16
; SI-NEXT:    v_mul_f32_e64 v14, 1.0, s19
; SI-NEXT:    v_mul_f32_e64 v15, 1.0, s18
; SI-NEXT:    v_mul_f32_e64 v12, 1.0, s21
; SI-NEXT:    v_mul_f32_e64 v13, 1.0, s20
; SI-NEXT:    s_cbranch_scc0 .LBB39_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v16
; SI-NEXT:    v_lshrrev_b32_e32 v6, 16, v14
; SI-NEXT:    v_lshrrev_b32_e32 v10, 16, v12
; SI-NEXT:    v_alignbit_b32 v0, v0, v17, 16
; SI-NEXT:    v_alignbit_b32 v4, v6, v15, 16
; SI-NEXT:    v_alignbit_b32 v8, v10, v13, 16
; SI-NEXT:    v_alignbit_b32 v3, v4, v0, 24
; SI-NEXT:    v_alignbit_b32 v2, v4, v0, 16
; SI-NEXT:    v_alignbit_b32 v1, v4, v0, 8
; SI-NEXT:    v_lshrrev_b32_e32 v7, 24, v14
; SI-NEXT:    v_lshrrev_b32_e32 v11, 24, v12
; SI-NEXT:    v_lshrrev_b32_e32 v5, 8, v4
; SI-NEXT:    v_lshrrev_b32_e32 v9, 8, v8
; SI-NEXT:    s_cbranch_execnz .LBB39_3
; SI-NEXT:  .LBB39_2: ; %cmp.true
; SI-NEXT:    v_and_b32_e32 v1, 0xffff0000, v16
; SI-NEXT:    v_and_b32_e32 v0, 0xffff0000, v17
; SI-NEXT:    v_add_f32_e32 v1, 0x40c00000, v1
; SI-NEXT:    v_add_f32_e32 v0, 0x40c00000, v0
; SI-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_and_b32_e32 v2, 0xffff0000, v14
; SI-NEXT:    v_alignbit_b32 v0, v1, v0, 16
; SI-NEXT:    v_and_b32_e32 v1, 0xffff0000, v15
; SI-NEXT:    v_add_f32_e32 v7, 0x40c00000, v2
; SI-NEXT:    v_add_f32_e32 v1, 0x40c00000, v1
; SI-NEXT:    v_lshrrev_b32_e32 v6, 16, v7
; SI-NEXT:    v_and_b32_e32 v2, 0xffff0000, v12
; SI-NEXT:    v_alignbit_b32 v4, v6, v1, 16
; SI-NEXT:    v_and_b32_e32 v1, 0xffff0000, v13
; SI-NEXT:    v_add_f32_e32 v11, 0x40c00000, v2
; SI-NEXT:    v_add_f32_e32 v1, 0x40c00000, v1
; SI-NEXT:    v_lshrrev_b32_e32 v10, 16, v11
; SI-NEXT:    v_alignbit_b32 v8, v10, v1, 16
; SI-NEXT:    v_alignbit_b32 v3, v4, v0, 24
; SI-NEXT:    v_alignbit_b32 v2, v4, v0, 16
; SI-NEXT:    v_alignbit_b32 v1, v4, v0, 8
; SI-NEXT:    v_lshrrev_b32_e32 v5, 8, v4
; SI-NEXT:    v_lshrrev_b32_e32 v9, 8, v8
; SI-NEXT:    v_lshrrev_b32_e32 v7, 24, v7
; SI-NEXT:    v_lshrrev_b32_e32 v11, 24, v11
; SI-NEXT:  .LBB39_3: ; %end
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB39_4:
; SI-NEXT:    ; implicit-def: $vgpr0
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    ; implicit-def: $vgpr4
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    ; implicit-def: $vgpr6
; SI-NEXT:    ; implicit-def: $vgpr7
; SI-NEXT:    ; implicit-def: $vgpr8
; SI-NEXT:    ; implicit-def: $vgpr9
; SI-NEXT:    ; implicit-def: $vgpr10
; SI-NEXT:    ; implicit-def: $vgpr11
; SI-NEXT:    s_branch .LBB39_2
;
; VI-LABEL: bitcast_v6bf16_to_v12i8_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s19, 0
; VI-NEXT:    s_cbranch_scc0 .LBB39_3
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_lshr_b32 s19, s16, 8
; VI-NEXT:    s_lshr_b32 s10, s18, 16
; VI-NEXT:    s_lshr_b32 s11, s18, 8
; VI-NEXT:    s_lshr_b32 s12, s17, 24
; VI-NEXT:    s_lshr_b32 s13, s17, 16
; VI-NEXT:    s_lshr_b32 s15, s17, 8
; VI-NEXT:    s_lshr_b32 s14, s16, 16
; VI-NEXT:    s_lshr_b64 s[6:7], s[18:19], 24
; VI-NEXT:    s_lshr_b64 s[4:5], s[16:17], 24
; VI-NEXT:    s_cbranch_execnz .LBB39_4
; VI-NEXT:  .LBB39_2: ; %cmp.true
; VI-NEXT:    s_lshl_b32 s4, s17, 16
; VI-NEXT:    v_mov_b32_e32 v0, 0x40c00000
; VI-NEXT:    v_add_f32_e32 v1, s4, v0
; VI-NEXT:    v_bfe_u32 v2, v1, 16, 1
; VI-NEXT:    v_add_u32_e32 v2, vcc, v2, v1
; VI-NEXT:    v_add_u32_e32 v2, vcc, 0x7fff, v2
; VI-NEXT:    v_or_b32_e32 v3, 0x400000, v1
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; VI-NEXT:    s_and_b32 s4, s17, 0xffff0000
; VI-NEXT:    v_cndmask_b32_e32 v1, v2, v3, vcc
; VI-NEXT:    v_add_f32_e32 v2, s4, v0
; VI-NEXT:    v_bfe_u32 v3, v2, 16, 1
; VI-NEXT:    v_add_u32_e32 v3, vcc, v3, v2
; VI-NEXT:    v_add_u32_e32 v3, vcc, 0x7fff, v3
; VI-NEXT:    v_or_b32_e32 v4, 0x400000, v2
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; VI-NEXT:    v_cndmask_b32_e32 v2, v3, v4, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; VI-NEXT:    s_lshl_b32 s4, s16, 16
; VI-NEXT:    v_alignbit_b32 v15, v2, v1, 16
; VI-NEXT:    v_add_f32_e32 v1, s4, v0
; VI-NEXT:    v_bfe_u32 v2, v1, 16, 1
; VI-NEXT:    v_add_u32_e32 v2, vcc, v2, v1
; VI-NEXT:    v_add_u32_e32 v2, vcc, 0x7fff, v2
; VI-NEXT:    v_or_b32_e32 v3, 0x400000, v1
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; VI-NEXT:    s_and_b32 s4, s16, 0xffff0000
; VI-NEXT:    v_cndmask_b32_e32 v1, v2, v3, vcc
; VI-NEXT:    v_add_f32_e32 v2, s4, v0
; VI-NEXT:    v_bfe_u32 v3, v2, 16, 1
; VI-NEXT:    v_add_u32_e32 v3, vcc, v3, v2
; VI-NEXT:    v_add_u32_e32 v3, vcc, 0x7fff, v3
; VI-NEXT:    v_or_b32_e32 v4, 0x400000, v2
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; VI-NEXT:    v_cndmask_b32_e32 v2, v3, v4, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; VI-NEXT:    s_lshl_b32 s4, s18, 16
; VI-NEXT:    v_alignbit_b32 v14, v2, v1, 16
; VI-NEXT:    v_add_f32_e32 v1, s4, v0
; VI-NEXT:    v_bfe_u32 v2, v1, 16, 1
; VI-NEXT:    v_add_u32_e32 v2, vcc, v2, v1
; VI-NEXT:    v_add_u32_e32 v2, vcc, 0x7fff, v2
; VI-NEXT:    s_and_b32 s4, s18, 0xffff0000
; VI-NEXT:    v_or_b32_e32 v3, 0x400000, v1
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; VI-NEXT:    v_add_f32_e32 v0, s4, v0
; VI-NEXT:    v_cndmask_b32_e32 v1, v2, v3, vcc
; VI-NEXT:    v_bfe_u32 v2, v0, 16, 1
; VI-NEXT:    v_add_u32_e32 v2, vcc, v2, v0
; VI-NEXT:    v_add_u32_e32 v2, vcc, 0x7fff, v2
; VI-NEXT:    v_or_b32_e32 v3, 0x400000, v0
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v0, v0
; VI-NEXT:    v_cndmask_b32_e32 v0, v2, v3, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; VI-NEXT:    v_alignbit_b32 v8, v0, v1, 16
; VI-NEXT:    v_mov_b32_e32 v9, 0x7fc07fc0
; VI-NEXT:    v_lshrrev_b64 v[3:4], 24, v[14:15]
; VI-NEXT:    v_lshrrev_b64 v[11:12], 24, v[8:9]
; VI-NEXT:    v_lshrrev_b32_e32 v10, 16, v8
; VI-NEXT:    v_lshrrev_b32_e32 v13, 8, v8
; VI-NEXT:    v_lshrrev_b32_e32 v7, 24, v15
; VI-NEXT:    v_lshrrev_b32_e32 v6, 16, v15
; VI-NEXT:    v_lshrrev_b32_e32 v5, 8, v15
; VI-NEXT:    v_lshrrev_b32_e32 v2, 16, v14
; VI-NEXT:    v_lshrrev_b32_e32 v1, 8, v14
; VI-NEXT:    s_branch .LBB39_5
; VI-NEXT:  .LBB39_3:
; VI-NEXT:    ; implicit-def: $sgpr19
; VI-NEXT:    ; implicit-def: $sgpr14
; VI-NEXT:    ; implicit-def: $sgpr4
; VI-NEXT:    ; implicit-def: $sgpr15
; VI-NEXT:    ; implicit-def: $sgpr13
; VI-NEXT:    ; implicit-def: $sgpr12
; VI-NEXT:    ; implicit-def: $sgpr11
; VI-NEXT:    ; implicit-def: $sgpr10
; VI-NEXT:    ; implicit-def: $sgpr6
; VI-NEXT:    s_branch .LBB39_2
; VI-NEXT:  .LBB39_4:
; VI-NEXT:    v_mov_b32_e32 v14, s16
; VI-NEXT:    v_mov_b32_e32 v15, s17
; VI-NEXT:    v_mov_b32_e32 v8, s18
; VI-NEXT:    v_mov_b32_e32 v1, s19
; VI-NEXT:    v_mov_b32_e32 v2, s14
; VI-NEXT:    v_mov_b32_e32 v5, s15
; VI-NEXT:    v_mov_b32_e32 v6, s13
; VI-NEXT:    v_mov_b32_e32 v7, s12
; VI-NEXT:    v_mov_b32_e32 v13, s11
; VI-NEXT:    v_mov_b32_e32 v10, s10
; VI-NEXT:    v_mov_b32_e32 v11, s6
; VI-NEXT:    v_mov_b32_e32 v3, s4
; VI-NEXT:  .LBB39_5: ; %end
; VI-NEXT:    v_mov_b32_e32 v0, v14
; VI-NEXT:    v_mov_b32_e32 v4, v15
; VI-NEXT:    v_mov_b32_e32 v9, v13
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v6bf16_to_v12i8_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s19, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB39_3
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_lshr_b32 s19, s17, 16
; GFX9-NEXT:    s_lshr_b32 s15, s18, 16
; GFX9-NEXT:    s_lshr_b32 s14, s18, 8
; GFX9-NEXT:    s_lshr_b32 s10, s17, 24
; GFX9-NEXT:    s_lshr_b32 s11, s17, 8
; GFX9-NEXT:    s_lshr_b32 s13, s16, 16
; GFX9-NEXT:    s_lshr_b32 s12, s16, 8
; GFX9-NEXT:    s_lshr_b64 s[6:7], s[18:19], 24
; GFX9-NEXT:    s_lshr_b64 s[4:5], s[16:17], 24
; GFX9-NEXT:    s_cbranch_execnz .LBB39_4
; GFX9-NEXT:  .LBB39_2: ; %cmp.true
; GFX9-NEXT:    s_pack_lh_b32_b16 s4, 0, s17
; GFX9-NEXT:    v_mov_b32_e32 v3, 0x40c00000
; GFX9-NEXT:    v_add_f32_e32 v0, s4, v3
; GFX9-NEXT:    v_bfe_u32 v1, v0, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v1, v1, v0
; GFX9-NEXT:    v_add_u32_e32 v1, 0x7fff, v1
; GFX9-NEXT:    v_or_b32_e32 v2, 0x400000, v0
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v0, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v1, v2, vcc
; GFX9-NEXT:    s_lshl_b32 s4, s17, 16
; GFX9-NEXT:    v_lshrrev_b32_e32 v6, 16, v0
; GFX9-NEXT:    v_add_f32_e32 v0, s4, v3
; GFX9-NEXT:    v_bfe_u32 v1, v0, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v1, v1, v0
; GFX9-NEXT:    v_add_u32_e32 v1, 0x7fff, v1
; GFX9-NEXT:    v_or_b32_e32 v2, 0x400000, v0
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v0, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v1, v2, vcc
; GFX9-NEXT:    v_lshrrev_b32_e32 v13, 16, v0
; GFX9-NEXT:    v_and_b32_e32 v0, 0xffff, v13
; GFX9-NEXT:    s_pack_lh_b32_b16 s4, 0, s16
; GFX9-NEXT:    v_lshl_or_b32 v2, v6, 16, v0
; GFX9-NEXT:    v_add_f32_e32 v0, s4, v3
; GFX9-NEXT:    v_bfe_u32 v1, v0, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v1, v1, v0
; GFX9-NEXT:    v_add_u32_e32 v1, 0x7fff, v1
; GFX9-NEXT:    v_or_b32_e32 v4, 0x400000, v0
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v0, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v1, v4, vcc
; GFX9-NEXT:    s_lshl_b32 s4, s16, 16
; GFX9-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; GFX9-NEXT:    v_add_f32_e32 v0, s4, v3
; GFX9-NEXT:    v_bfe_u32 v4, v0, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v4, v4, v0
; GFX9-NEXT:    v_add_u32_e32 v4, 0x7fff, v4
; GFX9-NEXT:    v_or_b32_e32 v5, 0x400000, v0
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v0, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v4, v5, vcc
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; GFX9-NEXT:    v_and_b32_e32 v4, 0xffff, v0
; GFX9-NEXT:    s_pack_lh_b32_b16 s4, 0, s18
; GFX9-NEXT:    v_lshl_or_b32 v1, v1, 16, v4
; GFX9-NEXT:    v_add_f32_e32 v4, s4, v3
; GFX9-NEXT:    v_bfe_u32 v5, v4, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v5, v5, v4
; GFX9-NEXT:    s_lshl_b32 s4, s18, 16
; GFX9-NEXT:    v_add_u32_e32 v5, 0x7fff, v5
; GFX9-NEXT:    v_or_b32_e32 v7, 0x400000, v4
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v4, v4
; GFX9-NEXT:    v_add_f32_e32 v3, s4, v3
; GFX9-NEXT:    v_cndmask_b32_e32 v4, v5, v7, vcc
; GFX9-NEXT:    v_bfe_u32 v5, v3, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v5, v5, v3
; GFX9-NEXT:    v_add_u32_e32 v5, 0x7fff, v5
; GFX9-NEXT:    v_or_b32_e32 v7, 0x400000, v3
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v3, v3
; GFX9-NEXT:    v_cndmask_b32_e32 v3, v5, v7, vcc
; GFX9-NEXT:    v_lshrrev_b32_e32 v8, 16, v3
; GFX9-NEXT:    v_lshrrev_b32_e32 v4, 16, v4
; GFX9-NEXT:    v_and_b32_e32 v3, 0xffff, v8
; GFX9-NEXT:    v_lshl_or_b32 v11, v4, 16, v3
; GFX9-NEXT:    v_mov_b32_e32 v12, 0x7fc07fc0
; GFX9-NEXT:    v_lshrrev_b64 v[3:4], 24, v[1:2]
; GFX9-NEXT:    v_lshrrev_b32_e32 v10, 16, v11
; GFX9-NEXT:    v_lshrrev_b32_e32 v9, 8, v11
; GFX9-NEXT:    v_lshrrev_b64 v[11:12], 24, v[11:12]
; GFX9-NEXT:    v_lshrrev_b32_e32 v7, 24, v2
; GFX9-NEXT:    v_lshrrev_b32_e32 v5, 8, v2
; GFX9-NEXT:    v_lshrrev_b32_e32 v2, 16, v1
; GFX9-NEXT:    v_lshrrev_b32_e32 v1, 8, v1
; GFX9-NEXT:    v_mov_b32_e32 v4, v13
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB39_3:
; GFX9-NEXT:    ; implicit-def: $sgpr12
; GFX9-NEXT:    ; implicit-def: $sgpr13
; GFX9-NEXT:    ; implicit-def: $sgpr4
; GFX9-NEXT:    ; implicit-def: $sgpr11
; GFX9-NEXT:    ; implicit-def: $sgpr19
; GFX9-NEXT:    ; implicit-def: $sgpr10
; GFX9-NEXT:    ; implicit-def: $sgpr14
; GFX9-NEXT:    ; implicit-def: $sgpr15
; GFX9-NEXT:    ; implicit-def: $sgpr6
; GFX9-NEXT:    s_branch .LBB39_2
; GFX9-NEXT:  .LBB39_4:
; GFX9-NEXT:    v_mov_b32_e32 v8, s18
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v6, s19
; GFX9-NEXT:    v_mov_b32_e32 v10, s15
; GFX9-NEXT:    v_mov_b32_e32 v9, s14
; GFX9-NEXT:    v_mov_b32_e32 v2, s13
; GFX9-NEXT:    v_mov_b32_e32 v1, s12
; GFX9-NEXT:    v_mov_b32_e32 v7, s10
; GFX9-NEXT:    v_mov_b32_e32 v5, s11
; GFX9-NEXT:    v_mov_b32_e32 v11, s6
; GFX9-NEXT:    v_mov_b32_e32 v3, s4
; GFX9-NEXT:    v_mov_b32_e32 v4, s17
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v6bf16_to_v12i8_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_cmp_lg_u32 s3, 0
; GFX11-NEXT:    s_mov_b32 s3, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB39_3
; GFX11-NEXT:  ; %bb.1: ; %cmp.false
; GFX11-NEXT:    s_lshr_b32 s13, s2, 16
; GFX11-NEXT:    s_lshr_b32 s12, s2, 8
; GFX11-NEXT:    s_lshr_b32 s8, s1, 24
; GFX11-NEXT:    s_lshr_b32 s14, s1, 16
; GFX11-NEXT:    s_lshr_b32 s9, s1, 8
; GFX11-NEXT:    s_lshr_b32 s11, s0, 16
; GFX11-NEXT:    s_lshr_b32 s10, s0, 8
; GFX11-NEXT:    s_lshr_b64 s[6:7], s[2:3], 24
; GFX11-NEXT:    s_lshr_b64 s[4:5], s[0:1], 24
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s3
; GFX11-NEXT:    s_cbranch_vccnz .LBB39_4
; GFX11-NEXT:  .LBB39_2: ; %cmp.true
; GFX11-NEXT:    s_pack_lh_b32_b16 s3, 0, s1
; GFX11-NEXT:    s_lshl_b32 s1, s1, 16
; GFX11-NEXT:    v_add_f32_e64 v0, 0x40c00000, s3
; GFX11-NEXT:    v_add_f32_e64 v1, 0x40c00000, s1
; GFX11-NEXT:    s_pack_lh_b32_b16 s3, 0, s0
; GFX11-NEXT:    s_lshl_b32 s0, s0, 16
; GFX11-NEXT:    s_pack_lh_b32_b16 s1, 0, s2
; GFX11-NEXT:    v_bfe_u32 v2, v0, 16, 1
; GFX11-NEXT:    v_bfe_u32 v3, v1, 16, 1
; GFX11-NEXT:    v_or_b32_e32 v6, 0x400000, v0
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v0, v0
; GFX11-NEXT:    v_or_b32_e32 v9, 0x400000, v1
; GFX11-NEXT:    v_add_f32_e64 v5, 0x40c00000, s0
; GFX11-NEXT:    v_add_nc_u32_e32 v3, v3, v1
; GFX11-NEXT:    s_lshl_b32 s2, s2, 16
; GFX11-NEXT:    v_add_f32_e64 v4, 0x40c00000, s3
; GFX11-NEXT:    v_add_f32_e64 v8, 0x40c00000, s2
; GFX11-NEXT:    v_add_f32_e64 v7, 0x40c00000, s1
; GFX11-NEXT:    v_add_nc_u32_e32 v3, 0x7fff, v3
; GFX11-NEXT:    v_add_nc_u32_e32 v2, v2, v0
; GFX11-NEXT:    v_bfe_u32 v10, v4, 16, 1
; GFX11-NEXT:    v_or_b32_e32 v11, 0x400000, v8
; GFX11-NEXT:    v_mov_b32_e32 v12, 0x7fc07fc0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_nc_u32_e32 v2, 0x7fff, v2
; GFX11-NEXT:    v_cndmask_b32_e32 v0, v2, v6, vcc_lo
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v1, v1
; GFX11-NEXT:    v_bfe_u32 v2, v5, 16, 1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_4) | instid1(VALU_DEP_4)
; GFX11-NEXT:    v_lshrrev_b32_e32 v6, 16, v0
; GFX11-NEXT:    v_cndmask_b32_e32 v1, v3, v9, vcc_lo
; GFX11-NEXT:    v_bfe_u32 v0, v8, 16, 1
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v5, v5
; GFX11-NEXT:    v_or_b32_e32 v9, 0x400000, v4
; GFX11-NEXT:    v_lshrrev_b32_e32 v13, 16, v1
; GFX11-NEXT:    v_add_nc_u32_e32 v1, v2, v5
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_nc_u32_e32 v1, 0x7fff, v1
; GFX11-NEXT:    v_add_nc_u32_e32 v0, v0, v8
; GFX11-NEXT:    v_add_nc_u32_e32 v0, 0x7fff, v0
; GFX11-NEXT:    v_add_nc_u32_e32 v3, v10, v4
; GFX11-NEXT:    v_or_b32_e32 v10, 0x400000, v5
; GFX11-NEXT:    v_or_b32_e32 v5, 0x400000, v7
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-NEXT:    v_cndmask_b32_e32 v1, v1, v10, vcc_lo
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v8, v8
; GFX11-NEXT:    v_cndmask_b32_e32 v8, v0, v11, vcc_lo
; GFX11-NEXT:    v_add_nc_u32_e32 v2, 0x7fff, v3
; GFX11-NEXT:    v_bfe_u32 v3, v7, 16, 1
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v4, v4
; GFX11-NEXT:    v_lshrrev_b32_e32 v0, 16, v1
; GFX11-NEXT:    v_lshrrev_b32_e32 v8, 16, v8
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_dual_cndmask_b32 v2, v2, v9 :: v_dual_add_nc_u32 v3, v3, v7
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v7, v7
; GFX11-NEXT:    v_and_b32_e32 v9, 0xffff, v8
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-NEXT:    v_add_nc_u32_e32 v3, 0x7fff, v3
; GFX11-NEXT:    v_lshrrev_b32_e32 v4, 16, v2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_cndmask_b32_e32 v1, v3, v5, vcc_lo
; GFX11-NEXT:    v_and_b32_e32 v3, 0xffff, v13
; GFX11-NEXT:    v_and_b32_e32 v5, 0xffff, v0
; GFX11-NEXT:    v_lshrrev_b32_e32 v7, 16, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_lshl_or_b32 v2, v6, 16, v3
; GFX11-NEXT:    v_lshl_or_b32 v1, v4, 16, v5
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_lshl_or_b32 v11, v7, 16, v9
; GFX11-NEXT:    v_lshrrev_b32_e32 v7, 24, v2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX11-NEXT:    v_lshrrev_b64 v[3:4], 24, v[1:2]
; GFX11-NEXT:    v_lshrrev_b32_e32 v5, 8, v2
; GFX11-NEXT:    v_lshrrev_b32_e32 v2, 16, v1
; GFX11-NEXT:    v_lshrrev_b32_e32 v10, 16, v11
; GFX11-NEXT:    v_lshrrev_b32_e32 v9, 8, v11
; GFX11-NEXT:    v_lshrrev_b64 v[11:12], 24, v[11:12]
; GFX11-NEXT:    v_lshrrev_b32_e32 v1, 8, v1
; GFX11-NEXT:    v_mov_b32_e32 v4, v13
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB39_3:
; GFX11-NEXT:    ; implicit-def: $sgpr10
; GFX11-NEXT:    ; implicit-def: $sgpr11
; GFX11-NEXT:    ; implicit-def: $sgpr4
; GFX11-NEXT:    ; implicit-def: $sgpr9
; GFX11-NEXT:    ; implicit-def: $sgpr14
; GFX11-NEXT:    ; implicit-def: $sgpr8
; GFX11-NEXT:    ; implicit-def: $sgpr12
; GFX11-NEXT:    ; implicit-def: $sgpr13
; GFX11-NEXT:    ; implicit-def: $sgpr6
; GFX11-NEXT:    s_branch .LBB39_2
; GFX11-NEXT:  .LBB39_4:
; GFX11-NEXT:    v_dual_mov_b32 v8, s2 :: v_dual_mov_b32 v9, s12
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s10
; GFX11-NEXT:    v_dual_mov_b32 v6, s14 :: v_dual_mov_b32 v7, s8
; GFX11-NEXT:    v_dual_mov_b32 v10, s13 :: v_dual_mov_b32 v5, s9
; GFX11-NEXT:    v_dual_mov_b32 v2, s11 :: v_dual_mov_b32 v11, s6
; GFX11-NEXT:    v_dual_mov_b32 v3, s4 :: v_dual_mov_b32 v4, s1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <6 x bfloat> %a, splat (bfloat 0xR40C0)
  %a2 = bitcast <6 x bfloat> %a1 to <12 x i8>
  br label %end

cmp.false:
  %a3 = bitcast <6 x bfloat> %a to <12 x i8>
  br label %end

end:
  %phi = phi <12 x i8> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <12 x i8> %phi
}

define <6 x half> @bitcast_v12i8_to_v6f16(<12 x i8> %a, i32 %b) {
; SI-LABEL: bitcast_v12i8_to_v6f16:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v13, v2
; SI-NEXT:    v_mov_b32_e32 v14, v0
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v12
; SI-NEXT:    v_lshlrev_b32_e32 v12, 8, v1
; SI-NEXT:    v_lshlrev_b32_e32 v15, 8, v3
; SI-NEXT:    v_lshlrev_b32_e32 v16, 8, v5
; SI-NEXT:    v_lshlrev_b32_e32 v7, 8, v7
; SI-NEXT:    v_lshlrev_b32_e32 v17, 8, v9
; SI-NEXT:    v_lshlrev_b32_e32 v11, 8, v11
; SI-NEXT:    ; implicit-def: $vgpr0
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    ; implicit-def: $vgpr9
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB40_2
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    v_and_b32_e32 v2, 0xff, v4
; SI-NEXT:    v_and_b32_e32 v4, 0xff, v8
; SI-NEXT:    v_or_b32_e32 v4, v4, v17
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v14
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v13
; SI-NEXT:    v_and_b32_e32 v3, 0xff, v6
; SI-NEXT:    v_cvt_f32_f16_e32 v9, v4
; SI-NEXT:    v_and_b32_e32 v4, 0xff, v10
; SI-NEXT:    v_or_b32_e32 v0, v0, v12
; SI-NEXT:    v_or_b32_e32 v1, v1, v15
; SI-NEXT:    v_or_b32_e32 v2, v2, v16
; SI-NEXT:    v_or_b32_e32 v3, v3, v7
; SI-NEXT:    v_or_b32_e32 v4, v4, v11
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v3
; SI-NEXT:    v_cvt_f32_f16_e32 v5, v4
; SI-NEXT:    ; implicit-def: $vgpr14
; SI-NEXT:    ; implicit-def: $vgpr13
; SI-NEXT:    ; implicit-def: $vgpr4
; SI-NEXT:    ; implicit-def: $vgpr6
; SI-NEXT:    ; implicit-def: $vgpr8
; SI-NEXT:    ; implicit-def: $vgpr10
; SI-NEXT:    ; implicit-def: $vgpr12
; SI-NEXT:    ; implicit-def: $vgpr15
; SI-NEXT:    ; implicit-def: $vgpr16
; SI-NEXT:    ; implicit-def: $vgpr7
; SI-NEXT:    ; implicit-def: $vgpr17
; SI-NEXT:    ; implicit-def: $vgpr11
; SI-NEXT:  .LBB40_2: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB40_4
; SI-NEXT:  ; %bb.3: ; %cmp.true
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v10
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v0
; SI-NEXT:    v_or_b32_e32 v0, v11, v0
; SI-NEXT:    v_add_i32_e32 v5, vcc, 0x300, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v8
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v0
; SI-NEXT:    s_movk_i32 s6, 0x300
; SI-NEXT:    v_or_b32_e32 v0, v17, v0
; SI-NEXT:    v_add_i32_e32 v8, vcc, s6, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v6
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v0
; SI-NEXT:    v_or_b32_e32 v0, v7, v0
; SI-NEXT:    v_add_i32_e32 v3, vcc, s6, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v4
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v0
; SI-NEXT:    v_or_b32_e32 v0, v16, v0
; SI-NEXT:    v_add_i32_e32 v2, vcc, s6, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v13
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v0
; SI-NEXT:    v_or_b32_e32 v0, v15, v0
; SI-NEXT:    v_add_i32_e32 v1, vcc, 0x300, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v14
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v0
; SI-NEXT:    v_or_b32_e32 v0, v12, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 0x300, v0
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v3
; SI-NEXT:    v_cvt_f32_f16_e32 v9, v8
; SI-NEXT:    v_cvt_f32_f16_e32 v5, v5
; SI-NEXT:  .LBB40_4: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    v_mov_b32_e32 v4, v9
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v12i8_to_v6f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v14, v2
; VI-NEXT:    v_mov_b32_e32 v13, v0
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v12
; VI-NEXT:    v_lshlrev_b16_e32 v17, 8, v1
; VI-NEXT:    v_lshlrev_b16_e32 v16, 8, v3
; VI-NEXT:    v_lshlrev_b16_e32 v15, 8, v5
; VI-NEXT:    v_lshlrev_b16_e32 v12, 8, v7
; VI-NEXT:    v_lshlrev_b16_e32 v7, 8, v9
; VI-NEXT:    v_lshlrev_b16_e32 v5, 8, v11
; VI-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_cbranch_execnz .LBB40_3
; VI-NEXT:  ; %bb.1: ; %Flow
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execnz .LBB40_4
; VI-NEXT:  .LBB40_2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB40_3: ; %cmp.false
; VI-NEXT:    v_or_b32_sdwa v0, v13, v17 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v14, v16 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v4, v15 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v2, v6, v12 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v2, v8, v7 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v3, v10, v5 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v2, v2, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    ; implicit-def: $vgpr13
; VI-NEXT:    ; implicit-def: $vgpr14
; VI-NEXT:    ; implicit-def: $vgpr4
; VI-NEXT:    ; implicit-def: $vgpr6
; VI-NEXT:    ; implicit-def: $vgpr8
; VI-NEXT:    ; implicit-def: $vgpr10
; VI-NEXT:    ; implicit-def: $vgpr17
; VI-NEXT:    ; implicit-def: $vgpr16
; VI-NEXT:    ; implicit-def: $vgpr15
; VI-NEXT:    ; implicit-def: $vgpr12
; VI-NEXT:    ; implicit-def: $vgpr7
; VI-NEXT:    ; implicit-def: $vgpr5
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB40_2
; VI-NEXT:  .LBB40_4: ; %cmp.true
; VI-NEXT:    v_add_u16_e32 v0, 3, v13
; VI-NEXT:    v_add_u16_e32 v1, 3, v14
; VI-NEXT:    v_or_b32_sdwa v0, v17, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_or_b32_sdwa v1, v16, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_mov_b32_e32 v2, 0x300
; VI-NEXT:    v_add_u16_e32 v0, 0x300, v0
; VI-NEXT:    v_add_u16_sdwa v1, v1, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v0, v0, v1
; VI-NEXT:    v_add_u16_e32 v1, 3, v4
; VI-NEXT:    v_add_u16_e32 v3, 3, v6
; VI-NEXT:    v_or_b32_sdwa v1, v15, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_or_b32_sdwa v3, v12, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_add_u16_e32 v1, 0x300, v1
; VI-NEXT:    v_add_u16_sdwa v3, v3, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v1, v1, v3
; VI-NEXT:    v_add_u16_e32 v3, 3, v8
; VI-NEXT:    v_add_u16_e32 v4, 3, v10
; VI-NEXT:    v_or_b32_sdwa v3, v7, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_or_b32_sdwa v4, v5, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_add_u16_e32 v3, 0x300, v3
; VI-NEXT:    v_add_u16_sdwa v2, v4, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v2, v3, v2
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v12i8_to_v6f16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v14, v2
; GFX9-NEXT:    v_mov_b32_e32 v13, v0
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v12
; GFX9-NEXT:    v_lshlrev_b16_e32 v17, 8, v1
; GFX9-NEXT:    v_lshlrev_b16_e32 v16, 8, v3
; GFX9-NEXT:    v_lshlrev_b16_e32 v15, 8, v5
; GFX9-NEXT:    v_lshlrev_b16_e32 v12, 8, v7
; GFX9-NEXT:    v_lshlrev_b16_e32 v7, 8, v9
; GFX9-NEXT:    v_lshlrev_b16_e32 v5, 8, v11
; GFX9-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_cbranch_execnz .LBB40_3
; GFX9-NEXT:  ; %bb.1: ; %Flow
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:    s_cbranch_execnz .LBB40_4
; GFX9-NEXT:  .LBB40_2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB40_3: ; %cmp.false
; GFX9-NEXT:    v_or_b32_sdwa v0, v13, v17 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v1, v14, v16 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v1, v4, v15 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v2, v6, v12 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v2, v8, v7 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v3, v10, v5 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v2, v2, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    ; implicit-def: $vgpr13
; GFX9-NEXT:    ; implicit-def: $vgpr14
; GFX9-NEXT:    ; implicit-def: $vgpr4
; GFX9-NEXT:    ; implicit-def: $vgpr6
; GFX9-NEXT:    ; implicit-def: $vgpr8
; GFX9-NEXT:    ; implicit-def: $vgpr10
; GFX9-NEXT:    ; implicit-def: $vgpr17
; GFX9-NEXT:    ; implicit-def: $vgpr16
; GFX9-NEXT:    ; implicit-def: $vgpr15
; GFX9-NEXT:    ; implicit-def: $vgpr12
; GFX9-NEXT:    ; implicit-def: $vgpr7
; GFX9-NEXT:    ; implicit-def: $vgpr5
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB40_2
; GFX9-NEXT:  .LBB40_4: ; %cmp.true
; GFX9-NEXT:    v_add_u16_e32 v0, 3, v13
; GFX9-NEXT:    v_add_u16_e32 v1, 3, v14
; GFX9-NEXT:    v_or_b32_sdwa v0, v17, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    s_movk_i32 s6, 0x300
; GFX9-NEXT:    v_or_b32_sdwa v1, v16, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u16_e32 v0, 0x300, v0
; GFX9-NEXT:    v_add_u16_sdwa v1, v1, s6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX9-NEXT:    v_add_u16_e32 v1, 3, v4
; GFX9-NEXT:    v_add_u16_e32 v2, 3, v6
; GFX9-NEXT:    v_or_b32_sdwa v1, v15, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_or_b32_sdwa v2, v12, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u16_e32 v1, 0x300, v1
; GFX9-NEXT:    v_add_u16_sdwa v2, v2, s6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_e32 v1, v1, v2
; GFX9-NEXT:    v_add_u16_e32 v2, 3, v8
; GFX9-NEXT:    v_add_u16_e32 v3, 3, v10
; GFX9-NEXT:    v_or_b32_sdwa v2, v7, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_or_b32_sdwa v3, v5, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u16_e32 v2, 0x300, v2
; GFX9-NEXT:    v_add_u16_sdwa v3, v3, s6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_e32 v2, v2, v3
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-TRUE16-LABEL: bitcast_v12i8_to_v6f16:
; GFX11-TRUE16:       ; %bb.0:
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v9.h, v9.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v10.h, v7.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v7.l, v6.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v7.h, v4.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v8.h, v2.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v9.l, v0.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v6.h, 8, v1.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v5.h, 8, v3.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v6.l, 8, v5.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v5.l, 8, v10.h
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v4.l, 8, v9.h
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v4.h, 8, v11.l
; GFX11-TRUE16-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3
; GFX11-TRUE16-NEXT:    v_cmpx_ne_u32_e32 0, v12
; GFX11-TRUE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-TRUE16-NEXT:    s_cbranch_execnz .LBB40_3
; GFX11-TRUE16-NEXT:  ; %bb.1: ; %Flow
; GFX11-TRUE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-TRUE16-NEXT:    s_cbranch_execnz .LBB40_4
; GFX11-TRUE16-NEXT:  .LBB40_2: ; %end
; GFX11-TRUE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
; GFX11-TRUE16-NEXT:  .LBB40_3: ; %cmp.false
; GFX11-TRUE16-NEXT:    v_and_b16 v0.l, 0xff, v9.l
; GFX11-TRUE16-NEXT:    v_and_b16 v0.h, 0xff, v8.h
; GFX11-TRUE16-NEXT:    v_and_b16 v1.l, 0xff, v7.h
; GFX11-TRUE16-NEXT:    v_and_b16 v1.h, 0xff, v7.l
; GFX11-TRUE16-NEXT:    v_and_b16 v2.l, 0xff, v8.l
; GFX11-TRUE16-NEXT:    v_or_b16 v0.l, v0.l, v6.h
; GFX11-TRUE16-NEXT:    v_and_b16 v2.h, 0xff, v10.l
; GFX11-TRUE16-NEXT:    v_or_b16 v3.l, v0.h, v5.h
; GFX11-TRUE16-NEXT:    v_or_b16 v1.l, v1.l, v6.l
; GFX11-TRUE16-NEXT:    v_or_b16 v5.l, v1.h, v5.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v6.l, v0.l
; GFX11-TRUE16-NEXT:    v_or_b16 v0.l, v2.l, v4.l
; GFX11-TRUE16-NEXT:    v_or_b16 v2.l, v2.h, v4.h
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v4, 0xffff, v6
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v6, 0xffff, v0
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v0, v4, v3
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v1, v1, v5
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v2, v6, v2
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr9_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr8_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr7_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr7_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr8_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr10_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr6_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr5_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr6_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr5_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr4_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr4_hi16
; GFX11-TRUE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-TRUE16-NEXT:    s_cbranch_execz .LBB40_2
; GFX11-TRUE16-NEXT:  .LBB40_4: ; %cmp.true
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v0.l, v9.l, 3
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v0.h, v8.h, 3
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v1.l, v7.h, 3
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v1.h, v7.l, 3
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v2.l, v8.l, 3
; GFX11-TRUE16-NEXT:    v_and_b16 v0.l, 0xff, v0.l
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v2.h, v10.l, 3
; GFX11-TRUE16-NEXT:    v_and_b16 v0.h, 0xff, v0.h
; GFX11-TRUE16-NEXT:    v_and_b16 v1.l, 0xff, v1.l
; GFX11-TRUE16-NEXT:    v_and_b16 v1.h, 0xff, v1.h
; GFX11-TRUE16-NEXT:    v_or_b16 v0.l, v6.h, v0.l
; GFX11-TRUE16-NEXT:    v_and_b16 v2.l, 0xff, v2.l
; GFX11-TRUE16-NEXT:    v_and_b16 v2.h, 0xff, v2.h
; GFX11-TRUE16-NEXT:    v_or_b16 v0.h, v5.h, v0.h
; GFX11-TRUE16-NEXT:    v_or_b16 v1.l, v6.l, v1.l
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v0.l, 0x300, v0.l
; GFX11-TRUE16-NEXT:    v_or_b16 v1.h, v5.l, v1.h
; GFX11-TRUE16-NEXT:    v_or_b16 v2.l, v4.l, v2.l
; GFX11-TRUE16-NEXT:    v_or_b16 v2.h, v4.h, v2.h
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v3.l, 0x300, v0.h
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v5.l, v0.l
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v0.l, 0x300, v1.l
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v1.l, 0x300, v1.h
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v2.l, 0x300, v2.l
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v4.l, 0x300, v2.h
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v5, 0xffff, v5
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v6, 0xffff, v0
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v0, v5, v3
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v1, v6, v1
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v2, v2, v4
; GFX11-TRUE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-FAKE16-LABEL: bitcast_v12i8_to_v6f16:
; GFX11-FAKE16:       ; %bb.0:
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-FAKE16-NEXT:    v_dual_mov_b32 v14, v2 :: v_dual_mov_b32 v13, v0
; GFX11-FAKE16-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v12
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v17, 8, v1
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v15, 8, v3
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v16, 8, v5
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v12, 8, v7
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v5, 8, v9
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v7, 8, v11
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3
; GFX11-FAKE16-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-FAKE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_cbranch_execnz .LBB40_3
; GFX11-FAKE16-NEXT:  ; %bb.1: ; %Flow
; GFX11-FAKE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-FAKE16-NEXT:    s_cbranch_execnz .LBB40_4
; GFX11-FAKE16-NEXT:  .LBB40_2: ; %end
; GFX11-FAKE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
; GFX11-FAKE16-NEXT:  .LBB40_3: ; %cmp.false
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v0, 0xff, v13
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v1, 0xff, v14
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v2, 0xff, v4
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v3, 0xff, v6
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v4, 0xff, v8
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v6, 0xff, v10
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v0, v0, v17
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v1, v1, v15
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v2, v2, v16
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v3, v3, v12
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v4, v4, v5
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v5, v6, v7
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v4, 0xffff, v4
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr13
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr14
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr6
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr8
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr10
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr17
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr15
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr16
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr12
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr7
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v1, v2, v3
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v2, v4, v5
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr4
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr5
; GFX11-FAKE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-FAKE16-NEXT:    s_cbranch_execz .LBB40_2
; GFX11-FAKE16-NEXT:  .LBB40_4: ; %cmp.true
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v0, v13, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v1, v14, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v2, v4, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v3, v6, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v4, v8, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v6, v10, 3
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v1, 0xff, v1
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v2, 0xff, v2
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v3, 0xff, v3
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v4, 0xff, v4
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v6, 0xff, v6
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v0, v17, v0
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v1, v15, v1
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v2, v16, v2
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v3, v12, v3
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v4, v5, v4
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v5, v7, v6
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v0, 0x300, v0
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v1, 0x300, v1
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v2, 0x300, v2
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v3, 0x300, v3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v4, 0x300, v4
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v5, 0x300, v5
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v4, 0xffff, v4
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v1, v2, v3
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v2, v4, v5
; GFX11-FAKE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <12 x i8> %a, splat (i8 3)
  %a2 = bitcast <12 x i8> %a1 to <6 x half>
  br label %end

cmp.false:
  %a3 = bitcast <12 x i8> %a to <6 x half>
  br label %end

end:
  %phi = phi <6 x half> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <6 x half> %phi
}

define inreg <6 x half> @bitcast_v12i8_to_v6f16_scalar(<12 x i8> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v12i8_to_v6f16_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s28, 0
; SI-NEXT:    s_cbranch_scc0 .LBB41_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_and_b32 s4, s16, 0xff
; SI-NEXT:    s_lshl_b32 s5, s17, 8
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    v_cvt_f32_f16_e32 v0, s4
; SI-NEXT:    s_and_b32 s4, s18, 0xff
; SI-NEXT:    s_lshl_b32 s5, s19, 8
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    v_cvt_f32_f16_e32 v1, s4
; SI-NEXT:    s_and_b32 s4, s20, 0xff
; SI-NEXT:    s_lshl_b32 s5, s21, 8
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    v_cvt_f32_f16_e32 v2, s4
; SI-NEXT:    s_and_b32 s4, s22, 0xff
; SI-NEXT:    s_lshl_b32 s5, s23, 8
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    v_cvt_f32_f16_e32 v3, s4
; SI-NEXT:    s_and_b32 s4, s24, 0xff
; SI-NEXT:    s_lshl_b32 s5, s25, 8
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    v_cvt_f32_f16_e32 v4, s4
; SI-NEXT:    s_and_b32 s4, s26, 0xff
; SI-NEXT:    s_lshl_b32 s5, s27, 8
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    v_cvt_f32_f16_e32 v5, s4
; SI-NEXT:    s_cbranch_execnz .LBB41_3
; SI-NEXT:  .LBB41_2: ; %cmp.true
; SI-NEXT:    s_add_i32 s26, s26, 3
; SI-NEXT:    s_and_b32 s4, s26, 0xff
; SI-NEXT:    s_lshl_b32 s5, s27, 8
; SI-NEXT:    s_add_i32 s24, s24, 3
; SI-NEXT:    s_or_b32 s4, s5, s4
; SI-NEXT:    s_and_b32 s5, s24, 0xff
; SI-NEXT:    s_lshl_b32 s6, s25, 8
; SI-NEXT:    s_add_i32 s22, s22, 3
; SI-NEXT:    s_or_b32 s5, s6, s5
; SI-NEXT:    s_and_b32 s6, s22, 0xff
; SI-NEXT:    s_lshl_b32 s7, s23, 8
; SI-NEXT:    s_add_i32 s20, s20, 3
; SI-NEXT:    s_or_b32 s6, s7, s6
; SI-NEXT:    s_and_b32 s7, s20, 0xff
; SI-NEXT:    s_lshl_b32 s8, s21, 8
; SI-NEXT:    s_add_i32 s18, s18, 3
; SI-NEXT:    s_or_b32 s7, s8, s7
; SI-NEXT:    s_and_b32 s8, s18, 0xff
; SI-NEXT:    s_lshl_b32 s9, s19, 8
; SI-NEXT:    s_add_i32 s16, s16, 3
; SI-NEXT:    s_or_b32 s8, s9, s8
; SI-NEXT:    s_and_b32 s9, s16, 0xff
; SI-NEXT:    s_lshl_b32 s10, s17, 8
; SI-NEXT:    s_or_b32 s9, s10, s9
; SI-NEXT:    s_addk_i32 s4, 0x300
; SI-NEXT:    s_addk_i32 s5, 0x300
; SI-NEXT:    s_addk_i32 s6, 0x300
; SI-NEXT:    s_addk_i32 s7, 0x300
; SI-NEXT:    s_addk_i32 s8, 0x300
; SI-NEXT:    s_addk_i32 s9, 0x300
; SI-NEXT:    v_cvt_f32_f16_e32 v0, s9
; SI-NEXT:    v_cvt_f32_f16_e32 v1, s8
; SI-NEXT:    v_cvt_f32_f16_e32 v2, s7
; SI-NEXT:    v_cvt_f32_f16_e32 v3, s6
; SI-NEXT:    v_cvt_f32_f16_e32 v4, s5
; SI-NEXT:    v_cvt_f32_f16_e32 v5, s4
; SI-NEXT:  .LBB41_3: ; %end
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB41_4:
; SI-NEXT:    ; implicit-def: $vgpr0
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    ; implicit-def: $vgpr4
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    s_branch .LBB41_2
;
; VI-LABEL: bitcast_v12i8_to_v6f16_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s28, 0
; VI-NEXT:    s_cbranch_scc0 .LBB41_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_and_b32 s4, s16, 0xff
; VI-NEXT:    s_lshl_b32 s5, s17, 8
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_and_b32 s5, s18, 0xff
; VI-NEXT:    s_lshl_b32 s6, s19, 8
; VI-NEXT:    s_or_b32 s5, s5, s6
; VI-NEXT:    s_and_b32 s4, s4, 0xffff
; VI-NEXT:    s_lshl_b32 s5, s5, 16
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_and_b32 s5, s20, 0xff
; VI-NEXT:    s_lshl_b32 s6, s21, 8
; VI-NEXT:    s_or_b32 s5, s5, s6
; VI-NEXT:    s_and_b32 s6, s22, 0xff
; VI-NEXT:    s_lshl_b32 s7, s23, 8
; VI-NEXT:    s_or_b32 s6, s6, s7
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_lshl_b32 s6, s6, 16
; VI-NEXT:    s_or_b32 s5, s5, s6
; VI-NEXT:    s_and_b32 s6, s24, 0xff
; VI-NEXT:    s_lshl_b32 s7, s25, 8
; VI-NEXT:    s_or_b32 s6, s6, s7
; VI-NEXT:    s_and_b32 s7, s26, 0xff
; VI-NEXT:    s_lshl_b32 s8, s27, 8
; VI-NEXT:    s_or_b32 s7, s7, s8
; VI-NEXT:    s_and_b32 s6, s6, 0xffff
; VI-NEXT:    s_lshl_b32 s7, s7, 16
; VI-NEXT:    s_or_b32 s6, s6, s7
; VI-NEXT:    s_cbranch_execnz .LBB41_3
; VI-NEXT:  .LBB41_2: ; %cmp.true
; VI-NEXT:    s_add_i32 s16, s16, 3
; VI-NEXT:    s_and_b32 s4, s16, 0xff
; VI-NEXT:    s_lshl_b32 s5, s17, 8
; VI-NEXT:    s_add_i32 s18, s18, 3
; VI-NEXT:    s_or_b32 s4, s5, s4
; VI-NEXT:    s_and_b32 s5, s18, 0xff
; VI-NEXT:    s_lshl_b32 s6, s19, 8
; VI-NEXT:    s_addk_i32 s4, 0x300
; VI-NEXT:    s_or_b32 s5, s6, s5
; VI-NEXT:    s_and_b32 s4, s4, 0xffff
; VI-NEXT:    s_lshl_b32 s5, s5, 16
; VI-NEXT:    s_add_i32 s20, s20, 3
; VI-NEXT:    s_or_b32 s4, s5, s4
; VI-NEXT:    s_and_b32 s5, s20, 0xff
; VI-NEXT:    s_lshl_b32 s6, s21, 8
; VI-NEXT:    s_add_i32 s22, s22, 3
; VI-NEXT:    s_or_b32 s5, s6, s5
; VI-NEXT:    s_and_b32 s6, s22, 0xff
; VI-NEXT:    s_lshl_b32 s7, s23, 8
; VI-NEXT:    s_addk_i32 s5, 0x300
; VI-NEXT:    s_or_b32 s6, s7, s6
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_lshl_b32 s6, s6, 16
; VI-NEXT:    s_add_i32 s24, s24, 3
; VI-NEXT:    s_or_b32 s5, s6, s5
; VI-NEXT:    s_and_b32 s6, s24, 0xff
; VI-NEXT:    s_lshl_b32 s7, s25, 8
; VI-NEXT:    s_add_i32 s26, s26, 3
; VI-NEXT:    s_or_b32 s6, s7, s6
; VI-NEXT:    s_and_b32 s7, s26, 0xff
; VI-NEXT:    s_lshl_b32 s8, s27, 8
; VI-NEXT:    s_addk_i32 s6, 0x300
; VI-NEXT:    s_or_b32 s7, s8, s7
; VI-NEXT:    s_and_b32 s6, s6, 0xffff
; VI-NEXT:    s_lshl_b32 s7, s7, 16
; VI-NEXT:    s_or_b32 s6, s7, s6
; VI-NEXT:    s_add_i32 s4, s4, 0x3000000
; VI-NEXT:    s_add_i32 s5, s5, 0x3000000
; VI-NEXT:    s_add_i32 s6, s6, 0x3000000
; VI-NEXT:  .LBB41_3: ; %end
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    v_mov_b32_e32 v1, s5
; VI-NEXT:    v_mov_b32_e32 v2, s6
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB41_4:
; VI-NEXT:    ; implicit-def: $sgpr4_sgpr5_sgpr6_sgpr7
; VI-NEXT:    s_branch .LBB41_2
;
; GFX9-LABEL: bitcast_v12i8_to_v6f16_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s28, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB41_4
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_and_b32 s4, s16, 0xff
; GFX9-NEXT:    s_lshl_b32 s5, s17, 8
; GFX9-NEXT:    s_or_b32 s4, s4, s5
; GFX9-NEXT:    s_and_b32 s5, s18, 0xff
; GFX9-NEXT:    s_lshl_b32 s6, s19, 8
; GFX9-NEXT:    s_or_b32 s5, s5, s6
; GFX9-NEXT:    s_and_b32 s4, s4, 0xffff
; GFX9-NEXT:    s_lshl_b32 s5, s5, 16
; GFX9-NEXT:    s_or_b32 s4, s4, s5
; GFX9-NEXT:    s_and_b32 s5, s20, 0xff
; GFX9-NEXT:    s_lshl_b32 s6, s21, 8
; GFX9-NEXT:    s_or_b32 s5, s5, s6
; GFX9-NEXT:    s_and_b32 s6, s22, 0xff
; GFX9-NEXT:    s_lshl_b32 s7, s23, 8
; GFX9-NEXT:    s_or_b32 s6, s6, s7
; GFX9-NEXT:    s_and_b32 s5, s5, 0xffff
; GFX9-NEXT:    s_lshl_b32 s6, s6, 16
; GFX9-NEXT:    s_or_b32 s5, s5, s6
; GFX9-NEXT:    s_and_b32 s6, s24, 0xff
; GFX9-NEXT:    s_lshl_b32 s7, s25, 8
; GFX9-NEXT:    s_or_b32 s6, s6, s7
; GFX9-NEXT:    s_and_b32 s7, s26, 0xff
; GFX9-NEXT:    s_lshl_b32 s8, s27, 8
; GFX9-NEXT:    s_or_b32 s7, s7, s8
; GFX9-NEXT:    s_and_b32 s6, s6, 0xffff
; GFX9-NEXT:    s_lshl_b32 s7, s7, 16
; GFX9-NEXT:    s_or_b32 s6, s6, s7
; GFX9-NEXT:    s_cbranch_execnz .LBB41_3
; GFX9-NEXT:  .LBB41_2: ; %cmp.true
; GFX9-NEXT:    s_add_i32 s16, s16, 3
; GFX9-NEXT:    s_and_b32 s4, s16, 0xff
; GFX9-NEXT:    s_lshl_b32 s5, s17, 8
; GFX9-NEXT:    s_add_i32 s18, s18, 3
; GFX9-NEXT:    s_or_b32 s4, s5, s4
; GFX9-NEXT:    s_and_b32 s5, s18, 0xff
; GFX9-NEXT:    s_lshl_b32 s6, s19, 8
; GFX9-NEXT:    s_or_b32 s5, s6, s5
; GFX9-NEXT:    s_addk_i32 s4, 0x300
; GFX9-NEXT:    s_addk_i32 s5, 0x300
; GFX9-NEXT:    s_and_b32 s4, s4, 0xffff
; GFX9-NEXT:    s_lshl_b32 s5, s5, 16
; GFX9-NEXT:    s_add_i32 s20, s20, 3
; GFX9-NEXT:    s_or_b32 s4, s4, s5
; GFX9-NEXT:    s_and_b32 s5, s20, 0xff
; GFX9-NEXT:    s_lshl_b32 s6, s21, 8
; GFX9-NEXT:    s_add_i32 s22, s22, 3
; GFX9-NEXT:    s_or_b32 s5, s6, s5
; GFX9-NEXT:    s_and_b32 s6, s22, 0xff
; GFX9-NEXT:    s_lshl_b32 s7, s23, 8
; GFX9-NEXT:    s_or_b32 s6, s7, s6
; GFX9-NEXT:    s_addk_i32 s5, 0x300
; GFX9-NEXT:    s_addk_i32 s6, 0x300
; GFX9-NEXT:    s_and_b32 s5, s5, 0xffff
; GFX9-NEXT:    s_lshl_b32 s6, s6, 16
; GFX9-NEXT:    s_add_i32 s24, s24, 3
; GFX9-NEXT:    s_or_b32 s5, s5, s6
; GFX9-NEXT:    s_and_b32 s6, s24, 0xff
; GFX9-NEXT:    s_lshl_b32 s7, s25, 8
; GFX9-NEXT:    s_add_i32 s26, s26, 3
; GFX9-NEXT:    s_or_b32 s6, s7, s6
; GFX9-NEXT:    s_and_b32 s7, s26, 0xff
; GFX9-NEXT:    s_lshl_b32 s8, s27, 8
; GFX9-NEXT:    s_or_b32 s7, s8, s7
; GFX9-NEXT:    s_addk_i32 s6, 0x300
; GFX9-NEXT:    s_addk_i32 s7, 0x300
; GFX9-NEXT:    s_and_b32 s6, s6, 0xffff
; GFX9-NEXT:    s_lshl_b32 s7, s7, 16
; GFX9-NEXT:    s_or_b32 s6, s6, s7
; GFX9-NEXT:  .LBB41_3: ; %end
; GFX9-NEXT:    v_mov_b32_e32 v0, s4
; GFX9-NEXT:    v_mov_b32_e32 v1, s5
; GFX9-NEXT:    v_mov_b32_e32 v2, s6
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB41_4:
; GFX9-NEXT:    ; implicit-def: $sgpr4_sgpr5_sgpr6_sgpr7
; GFX9-NEXT:    s_branch .LBB41_2
;
; GFX11-LABEL: bitcast_v12i8_to_v6f16_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_cmp_lg_u32 s24, 0
; GFX11-NEXT:    s_mov_b32 s8, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB41_4
; GFX11-NEXT:  ; %bb.1: ; %cmp.false
; GFX11-NEXT:    s_and_b32 s4, s0, 0xff
; GFX11-NEXT:    s_lshl_b32 s5, s1, 8
; GFX11-NEXT:    s_and_b32 s6, s2, 0xff
; GFX11-NEXT:    s_lshl_b32 s7, s3, 8
; GFX11-NEXT:    s_or_b32 s4, s4, s5
; GFX11-NEXT:    s_or_b32 s5, s6, s7
; GFX11-NEXT:    s_and_b32 s4, s4, 0xffff
; GFX11-NEXT:    s_lshl_b32 s5, s5, 16
; GFX11-NEXT:    s_lshl_b32 s6, s17, 8
; GFX11-NEXT:    s_or_b32 s4, s4, s5
; GFX11-NEXT:    s_and_b32 s5, s16, 0xff
; GFX11-NEXT:    s_and_b32 s7, s18, 0xff
; GFX11-NEXT:    s_lshl_b32 s9, s19, 8
; GFX11-NEXT:    s_or_b32 s5, s5, s6
; GFX11-NEXT:    s_or_b32 s6, s7, s9
; GFX11-NEXT:    s_and_b32 s7, s20, 0xff
; GFX11-NEXT:    s_lshl_b32 s9, s21, 8
; GFX11-NEXT:    s_and_b32 s10, s22, 0xff
; GFX11-NEXT:    s_lshl_b32 s11, s23, 8
; GFX11-NEXT:    s_or_b32 s7, s7, s9
; GFX11-NEXT:    s_or_b32 s9, s10, s11
; GFX11-NEXT:    s_and_b32 s5, s5, 0xffff
; GFX11-NEXT:    s_lshl_b32 s6, s6, 16
; GFX11-NEXT:    s_and_b32 s7, s7, 0xffff
; GFX11-NEXT:    s_lshl_b32 s9, s9, 16
; GFX11-NEXT:    s_or_b32 s5, s5, s6
; GFX11-NEXT:    s_or_b32 s6, s7, s9
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s8
; GFX11-NEXT:    s_cbranch_vccnz .LBB41_3
; GFX11-NEXT:  .LBB41_2: ; %cmp.true
; GFX11-NEXT:    s_add_i32 s0, s0, 3
; GFX11-NEXT:    s_add_i32 s2, s2, 3
; GFX11-NEXT:    s_and_b32 s0, s0, 0xff
; GFX11-NEXT:    s_lshl_b32 s1, s1, 8
; GFX11-NEXT:    s_and_b32 s2, s2, 0xff
; GFX11-NEXT:    s_lshl_b32 s3, s3, 8
; GFX11-NEXT:    s_or_b32 s0, s1, s0
; GFX11-NEXT:    s_or_b32 s1, s3, s2
; GFX11-NEXT:    s_addk_i32 s0, 0x300
; GFX11-NEXT:    s_addk_i32 s1, 0x300
; GFX11-NEXT:    s_and_b32 s0, s0, 0xffff
; GFX11-NEXT:    s_lshl_b32 s1, s1, 16
; GFX11-NEXT:    s_add_i32 s16, s16, 3
; GFX11-NEXT:    s_or_b32 s4, s0, s1
; GFX11-NEXT:    s_and_b32 s0, s16, 0xff
; GFX11-NEXT:    s_lshl_b32 s1, s17, 8
; GFX11-NEXT:    s_add_i32 s18, s18, 3
; GFX11-NEXT:    s_or_b32 s0, s1, s0
; GFX11-NEXT:    s_and_b32 s1, s18, 0xff
; GFX11-NEXT:    s_lshl_b32 s2, s19, 8
; GFX11-NEXT:    s_add_i32 s20, s20, 3
; GFX11-NEXT:    s_add_i32 s22, s22, 3
; GFX11-NEXT:    s_or_b32 s1, s2, s1
; GFX11-NEXT:    s_and_b32 s2, s20, 0xff
; GFX11-NEXT:    s_lshl_b32 s3, s21, 8
; GFX11-NEXT:    s_and_b32 s5, s22, 0xff
; GFX11-NEXT:    s_lshl_b32 s6, s23, 8
; GFX11-NEXT:    s_or_b32 s2, s3, s2
; GFX11-NEXT:    s_or_b32 s3, s6, s5
; GFX11-NEXT:    s_addk_i32 s0, 0x300
; GFX11-NEXT:    s_addk_i32 s1, 0x300
; GFX11-NEXT:    s_addk_i32 s2, 0x300
; GFX11-NEXT:    s_addk_i32 s3, 0x300
; GFX11-NEXT:    s_and_b32 s0, s0, 0xffff
; GFX11-NEXT:    s_lshl_b32 s1, s1, 16
; GFX11-NEXT:    s_and_b32 s2, s2, 0xffff
; GFX11-NEXT:    s_lshl_b32 s3, s3, 16
; GFX11-NEXT:    s_or_b32 s5, s0, s1
; GFX11-NEXT:    s_or_b32 s6, s2, s3
; GFX11-NEXT:  .LBB41_3: ; %end
; GFX11-NEXT:    v_dual_mov_b32 v0, s4 :: v_dual_mov_b32 v1, s5
; GFX11-NEXT:    v_mov_b32_e32 v2, s6
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB41_4:
; GFX11-NEXT:    ; implicit-def: $sgpr4_sgpr5_sgpr6_sgpr7
; GFX11-NEXT:    s_branch .LBB41_2
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <12 x i8> %a, splat (i8 3)
  %a2 = bitcast <12 x i8> %a1 to <6 x half>
  br label %end

cmp.false:
  %a3 = bitcast <12 x i8> %a to <6 x half>
  br label %end

end:
  %phi = phi <6 x half> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <6 x half> %phi
}

define <12 x i8> @bitcast_v6f16_to_v12i8(<6 x half> %a, i32 %b) {
; SI-LABEL: bitcast_v6f16_to_v12i8:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v7, v6
; SI-NEXT:    v_cvt_f16_f32_e32 v15, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v14, v0
; SI-NEXT:    v_cvt_f16_f32_e32 v6, v3
; SI-NEXT:    v_cvt_f16_f32_e32 v13, v2
; SI-NEXT:    v_cvt_f16_f32_e32 v10, v5
; SI-NEXT:    v_cvt_f16_f32_e32 v12, v4
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v7
; SI-NEXT:    ; implicit-def: $vgpr0
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    ; implicit-def: $vgpr4
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    ; implicit-def: $vgpr7
; SI-NEXT:    ; implicit-def: $vgpr8
; SI-NEXT:    ; implicit-def: $vgpr9
; SI-NEXT:    ; implicit-def: $vgpr11
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB42_3
; SI-NEXT:  ; %bb.1: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB42_4
; SI-NEXT:  .LBB42_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB42_3: ; %cmp.false
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v15
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v6
; SI-NEXT:    v_lshlrev_b32_e32 v7, 16, v10
; SI-NEXT:    v_or_b32_e32 v0, v14, v0
; SI-NEXT:    v_or_b32_e32 v4, v13, v1
; SI-NEXT:    v_or_b32_e32 v8, v12, v7
; SI-NEXT:    v_alignbit_b32 v3, v4, v0, 24
; SI-NEXT:    v_alignbit_b32 v2, v4, v0, 16
; SI-NEXT:    v_alignbit_b32 v1, v4, v0, 8
; SI-NEXT:    v_lshrrev_b32_e32 v5, 8, v4
; SI-NEXT:    v_lshrrev_b32_e32 v9, 8, v8
; SI-NEXT:    v_bfe_u32 v7, v6, 8, 8
; SI-NEXT:    v_bfe_u32 v11, v10, 8, 8
; SI-NEXT:    ; implicit-def: $vgpr15
; SI-NEXT:    ; implicit-def: $vgpr14
; SI-NEXT:    ; implicit-def: $vgpr13
; SI-NEXT:    ; implicit-def: $vgpr12
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB42_2
; SI-NEXT:  .LBB42_4: ; %cmp.true
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v15
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v14
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v6
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v13
; SI-NEXT:    v_add_f32_e32 v0, 0x38000000, v0
; SI-NEXT:    v_add_f32_e32 v1, 0x38000000, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-NEXT:    v_add_f32_e32 v2, 0x38000000, v2
; SI-NEXT:    v_cvt_f16_f32_e32 v6, v2
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v10
; SI-NEXT:    v_add_f32_e32 v2, 0x38000000, v3
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v12
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NEXT:    v_add_f32_e32 v1, 0x38000000, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v10, v1
; SI-NEXT:    v_add_f32_e32 v1, 0x38000000, v3
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-NEXT:    v_lshlrev_b32_e32 v3, 16, v6
; SI-NEXT:    v_or_b32_e32 v4, v2, v3
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v10
; SI-NEXT:    v_or_b32_e32 v8, v1, v2
; SI-NEXT:    v_alignbit_b32 v3, v4, v0, 24
; SI-NEXT:    v_alignbit_b32 v2, v4, v0, 16
; SI-NEXT:    v_alignbit_b32 v1, v4, v0, 8
; SI-NEXT:    v_lshrrev_b32_e32 v5, 8, v4
; SI-NEXT:    v_lshrrev_b32_e32 v9, 8, v8
; SI-NEXT:    v_bfe_u32 v7, v6, 8, 8
; SI-NEXT:    v_bfe_u32 v11, v10, 8, 8
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v6f16_to_v12i8:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v8, v2
; VI-NEXT:    v_mov_b32_e32 v14, v1
; VI-NEXT:    v_mov_b32_e32 v13, v0
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v3
; VI-NEXT:    v_lshrrev_b32_e32 v10, 16, v8
; VI-NEXT:    v_lshrrev_b32_e32 v6, 16, v14
; VI-NEXT:    v_lshrrev_b32_e32 v2, 16, v13
; VI-NEXT:    ; implicit-def: $vgpr1
; VI-NEXT:    ; implicit-def: $vgpr3
; VI-NEXT:    ; implicit-def: $vgpr5
; VI-NEXT:    ; implicit-def: $vgpr7
; VI-NEXT:    ; implicit-def: $vgpr9
; VI-NEXT:    ; implicit-def: $vgpr11
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    v_lshrrev_b32_e32 v9, 8, v8
; VI-NEXT:    v_lshrrev_b32_e32 v7, 24, v14
; VI-NEXT:    v_lshrrev_b32_e32 v5, 8, v14
; VI-NEXT:    v_lshrrev_b64 v[11:12], 24, v[8:9]
; VI-NEXT:    v_lshrrev_b64 v[3:4], 24, v[13:14]
; VI-NEXT:    v_lshrrev_b32_e32 v1, 8, v13
; VI-NEXT:  ; %bb.2: ; %Flow
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB42_4
; VI-NEXT:  ; %bb.3: ; %cmp.true
; VI-NEXT:    v_mov_b32_e32 v3, 0x200
; VI-NEXT:    v_add_f16_sdwa v6, v14, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_e32 v0, 16, v6
; VI-NEXT:    v_add_f16_e32 v14, 0x200, v14
; VI-NEXT:    v_add_f16_sdwa v2, v13, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_sdwa v10, v8, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v1, v14, v0
; VI-NEXT:    v_lshlrev_b32_e32 v0, 16, v2
; VI-NEXT:    v_add_f16_e32 v13, 0x200, v13
; VI-NEXT:    v_lshlrev_b32_e32 v3, 16, v10
; VI-NEXT:    v_add_f16_e32 v8, 0x200, v8
; VI-NEXT:    v_or_b32_e32 v0, v13, v0
; VI-NEXT:    v_or_b32_e32 v11, v8, v3
; VI-NEXT:    v_mov_b32_e32 v12, 0x7e007e00
; VI-NEXT:    v_lshrrev_b64 v[3:4], 24, v[0:1]
; VI-NEXT:    v_lshrrev_b32_e32 v9, 8, v11
; VI-NEXT:    v_lshrrev_b64 v[11:12], 24, v[11:12]
; VI-NEXT:    v_lshrrev_b32_e32 v5, 8, v1
; VI-NEXT:    v_lshrrev_b32_e32 v1, 8, v0
; VI-NEXT:    v_bfe_u32 v7, v6, 8, 8
; VI-NEXT:  .LBB42_4: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    v_mov_b32_e32 v0, v13
; VI-NEXT:    v_mov_b32_e32 v4, v14
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v6f16_to_v12i8:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v13, v2
; GFX9-NEXT:    v_mov_b32_e32 v16, v1
; GFX9-NEXT:    v_mov_b32_e32 v15, v0
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v3
; GFX9-NEXT:    ; implicit-def: $vgpr1
; GFX9-NEXT:    ; implicit-def: $vgpr2
; GFX9-NEXT:    ; implicit-def: $vgpr3
; GFX9-NEXT:    ; implicit-def: $vgpr5
; GFX9-NEXT:    ; implicit-def: $vgpr6
; GFX9-NEXT:    ; implicit-def: $vgpr7
; GFX9-NEXT:    ; implicit-def: $vgpr9
; GFX9-NEXT:    ; implicit-def: $vgpr10
; GFX9-NEXT:    ; implicit-def: $vgpr11
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB42_2
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    v_lshrrev_b32_e32 v10, 16, v13
; GFX9-NEXT:    v_lshrrev_b32_e32 v9, 8, v13
; GFX9-NEXT:    v_lshrrev_b32_e32 v7, 24, v16
; GFX9-NEXT:    v_lshrrev_b32_e32 v6, 16, v16
; GFX9-NEXT:    v_lshrrev_b32_e32 v5, 8, v16
; GFX9-NEXT:    v_lshrrev_b32_e32 v2, 16, v15
; GFX9-NEXT:    v_lshrrev_b64 v[11:12], 24, v[13:14]
; GFX9-NEXT:    v_lshrrev_b64 v[3:4], 24, v[15:16]
; GFX9-NEXT:    v_lshrrev_b32_e32 v1, 8, v15
; GFX9-NEXT:  .LBB42_2: ; %Flow
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB42_4
; GFX9-NEXT:  ; %bb.3: ; %cmp.true
; GFX9-NEXT:    s_movk_i32 s6, 0x200
; GFX9-NEXT:    v_pk_add_f16 v16, v16, s6 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v15, v15, s6 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v13, v13, s6 op_sel_hi:[1,0]
; GFX9-NEXT:    v_mov_b32_e32 v14, 0x7e007e00
; GFX9-NEXT:    v_lshrrev_b64 v[3:4], 24, v[15:16]
; GFX9-NEXT:    v_lshrrev_b64 v[11:12], 24, v[13:14]
; GFX9-NEXT:    v_lshrrev_b32_e32 v10, 16, v13
; GFX9-NEXT:    v_lshrrev_b32_e32 v9, 8, v13
; GFX9-NEXT:    v_lshrrev_b32_e32 v7, 24, v16
; GFX9-NEXT:    v_lshrrev_b32_e32 v6, 16, v16
; GFX9-NEXT:    v_lshrrev_b32_e32 v5, 8, v16
; GFX9-NEXT:    v_lshrrev_b32_e32 v2, 16, v15
; GFX9-NEXT:    v_lshrrev_b32_e32 v1, 8, v15
; GFX9-NEXT:  .LBB42_4: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    v_mov_b32_e32 v0, v15
; GFX9-NEXT:    v_mov_b32_e32 v4, v16
; GFX9-NEXT:    v_mov_b32_e32 v8, v13
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-TRUE16-LABEL: bitcast_v6f16_to_v12i8:
; GFX11-TRUE16:       ; %bb.0:
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-TRUE16-NEXT:    v_dual_mov_b32 v10, v2 :: v_dual_mov_b32 v13, v1
; GFX11-TRUE16-NEXT:    v_mov_b32_e32 v12, v0
; GFX11-TRUE16-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v3
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr1_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr3_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr5_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr7_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr9_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr14_lo16
; GFX11-TRUE16-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-TRUE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-TRUE16-NEXT:  ; %bb.1: ; %cmp.false
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v9, 8, v10
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v7, 24, v13
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v5, 8, v13
; GFX11-TRUE16-NEXT:    v_lshrrev_b64 v[14:15], 24, v[10:11]
; GFX11-TRUE16-NEXT:    v_lshrrev_b64 v[3:4], 24, v[12:13]
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v1, 8, v12
; GFX11-TRUE16-NEXT:  ; %bb.2: ; %Flow
; GFX11-TRUE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-TRUE16-NEXT:    s_cbranch_execz .LBB42_4
; GFX11-TRUE16-NEXT:  ; %bb.3: ; %cmp.true
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v13, 0x200, v13 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v12, 0x200, v12 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v10, 0x200, v10 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:    v_mov_b32_e32 v11, 0x7e007e00
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v7, 24, v13
; GFX11-TRUE16-NEXT:    v_lshrrev_b64 v[3:4], 24, v[12:13]
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v9, 8, v10
; GFX11-TRUE16-NEXT:    v_lshrrev_b64 v[14:15], 24, v[10:11]
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v5, 8, v13
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v1, 8, v12
; GFX11-TRUE16-NEXT:  .LBB42_4: ; %end
; GFX11-TRUE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v0.l, v12.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v2.l, v12.h
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v4.l, v13.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v6.l, v13.h
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v8.l, v10.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v10.l, v10.h
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v11.l, v14.l
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-FAKE16-LABEL: bitcast_v6f16_to_v12i8:
; GFX11-FAKE16:       ; %bb.0:
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-FAKE16-NEXT:    v_dual_mov_b32 v13, v2 :: v_dual_mov_b32 v16, v1
; GFX11-FAKE16-NEXT:    v_mov_b32_e32 v15, v0
; GFX11-FAKE16-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v3
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr1
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr2
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr3
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr5
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr6
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr7
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr9
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr10
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr11
; GFX11-FAKE16-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-FAKE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_cbranch_execz .LBB42_2
; GFX11-FAKE16-NEXT:  ; %bb.1: ; %cmp.false
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v10, 16, v13
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v9, 8, v13
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v7, 24, v16
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v6, 16, v16
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v5, 8, v16
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v2, 16, v15
; GFX11-FAKE16-NEXT:    v_lshrrev_b64 v[11:12], 24, v[13:14]
; GFX11-FAKE16-NEXT:    v_lshrrev_b64 v[3:4], 24, v[15:16]
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 8, v15
; GFX11-FAKE16-NEXT:  .LBB42_2: ; %Flow
; GFX11-FAKE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-FAKE16-NEXT:    s_cbranch_execz .LBB42_4
; GFX11-FAKE16-NEXT:  ; %bb.3: ; %cmp.true
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v16, 0x200, v16 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v15, 0x200, v15 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v13, 0x200, v13 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:    v_mov_b32_e32 v14, 0x7e007e00
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v7, 24, v16
; GFX11-FAKE16-NEXT:    v_lshrrev_b64 v[3:4], 24, v[15:16]
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v10, 16, v13
; GFX11-FAKE16-NEXT:    v_lshrrev_b64 v[11:12], 24, v[13:14]
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v9, 8, v13
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v6, 16, v16
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v5, 8, v16
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v2, 16, v15
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 8, v15
; GFX11-FAKE16-NEXT:  .LBB42_4: ; %end
; GFX11-FAKE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-FAKE16-NEXT:    v_mov_b32_e32 v0, v15
; GFX11-FAKE16-NEXT:    v_mov_b32_e32 v4, v16
; GFX11-FAKE16-NEXT:    v_mov_b32_e32 v8, v13
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <6 x half> %a, splat (half 0xH0200)
  %a2 = bitcast <6 x half> %a1 to <12 x i8>
  br label %end

cmp.false:
  %a3 = bitcast <6 x half> %a to <12 x i8>
  br label %end

end:
  %phi = phi <12 x i8> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <12 x i8> %phi
}

define inreg <12 x i8> @bitcast_v6f16_to_v12i8_scalar(<6 x half> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v6f16_to_v12i8_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v15, s17
; SI-NEXT:    v_cvt_f16_f32_e32 v14, s16
; SI-NEXT:    v_cvt_f16_f32_e32 v6, s19
; SI-NEXT:    v_cvt_f16_f32_e32 v13, s18
; SI-NEXT:    v_cvt_f16_f32_e32 v10, s21
; SI-NEXT:    v_cvt_f16_f32_e32 v12, s20
; SI-NEXT:    s_cmp_lg_u32 s22, 0
; SI-NEXT:    s_cbranch_scc0 .LBB43_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v15
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v6
; SI-NEXT:    v_lshlrev_b32_e32 v7, 16, v10
; SI-NEXT:    v_or_b32_e32 v0, v14, v0
; SI-NEXT:    v_or_b32_e32 v4, v13, v1
; SI-NEXT:    v_or_b32_e32 v8, v12, v7
; SI-NEXT:    v_alignbit_b32 v3, v4, v0, 24
; SI-NEXT:    v_alignbit_b32 v2, v4, v0, 16
; SI-NEXT:    v_alignbit_b32 v1, v4, v0, 8
; SI-NEXT:    v_lshrrev_b32_e32 v5, 8, v4
; SI-NEXT:    v_lshrrev_b32_e32 v9, 8, v8
; SI-NEXT:    v_bfe_u32 v7, v6, 8, 8
; SI-NEXT:    v_bfe_u32 v11, v10, 8, 8
; SI-NEXT:    s_cbranch_execnz .LBB43_3
; SI-NEXT:  .LBB43_2: ; %cmp.true
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v15
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v14
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v6
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v13
; SI-NEXT:    v_add_f32_e32 v0, 0x38000000, v0
; SI-NEXT:    v_add_f32_e32 v1, 0x38000000, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-NEXT:    v_add_f32_e32 v2, 0x38000000, v2
; SI-NEXT:    v_cvt_f16_f32_e32 v6, v2
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v10
; SI-NEXT:    v_add_f32_e32 v2, 0x38000000, v3
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v12
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NEXT:    v_add_f32_e32 v1, 0x38000000, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v10, v1
; SI-NEXT:    v_add_f32_e32 v1, 0x38000000, v3
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-NEXT:    v_lshlrev_b32_e32 v3, 16, v6
; SI-NEXT:    v_or_b32_e32 v4, v2, v3
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v10
; SI-NEXT:    v_or_b32_e32 v8, v1, v2
; SI-NEXT:    v_alignbit_b32 v3, v4, v0, 24
; SI-NEXT:    v_alignbit_b32 v2, v4, v0, 16
; SI-NEXT:    v_alignbit_b32 v1, v4, v0, 8
; SI-NEXT:    v_lshrrev_b32_e32 v5, 8, v4
; SI-NEXT:    v_lshrrev_b32_e32 v9, 8, v8
; SI-NEXT:    v_bfe_u32 v7, v6, 8, 8
; SI-NEXT:    v_bfe_u32 v11, v10, 8, 8
; SI-NEXT:  .LBB43_3: ; %end
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB43_4:
; SI-NEXT:    ; implicit-def: $vgpr0
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    ; implicit-def: $vgpr4
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    ; implicit-def: $vgpr7
; SI-NEXT:    ; implicit-def: $vgpr8
; SI-NEXT:    ; implicit-def: $vgpr9
; SI-NEXT:    ; implicit-def: $vgpr11
; SI-NEXT:    s_branch .LBB43_2
;
; VI-LABEL: bitcast_v6f16_to_v12i8_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s19, 0
; VI-NEXT:    s_cbranch_scc0 .LBB43_3
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_lshr_b32 s19, s16, 16
; VI-NEXT:    s_lshr_b32 s14, s18, 16
; VI-NEXT:    s_lshr_b32 s11, s18, 8
; VI-NEXT:    s_lshr_b32 s13, s17, 24
; VI-NEXT:    s_lshr_b32 s15, s17, 16
; VI-NEXT:    s_lshr_b32 s10, s17, 8
; VI-NEXT:    s_lshr_b32 s12, s16, 8
; VI-NEXT:    s_lshr_b64 s[6:7], s[18:19], 24
; VI-NEXT:    s_lshr_b64 s[4:5], s[16:17], 24
; VI-NEXT:    s_cbranch_execnz .LBB43_4
; VI-NEXT:  .LBB43_2: ; %cmp.true
; VI-NEXT:    s_lshr_b32 s4, s17, 16
; VI-NEXT:    v_mov_b32_e32 v1, 0x200
; VI-NEXT:    v_add_f16_e32 v6, s4, v1
; VI-NEXT:    s_lshr_b32 s4, s16, 16
; VI-NEXT:    v_lshlrev_b32_e32 v0, 16, v6
; VI-NEXT:    v_add_f16_e32 v13, s17, v1
; VI-NEXT:    v_add_f16_e32 v2, s4, v1
; VI-NEXT:    s_lshr_b32 s4, s18, 16
; VI-NEXT:    v_or_b32_e32 v12, v13, v0
; VI-NEXT:    v_lshlrev_b32_e32 v3, 16, v2
; VI-NEXT:    v_add_f16_e32 v0, s16, v1
; VI-NEXT:    v_add_f16_e32 v10, s4, v1
; VI-NEXT:    v_or_b32_e32 v11, v0, v3
; VI-NEXT:    v_lshlrev_b32_e32 v3, 16, v10
; VI-NEXT:    v_add_f16_e32 v8, s18, v1
; VI-NEXT:    v_or_b32_e32 v14, v8, v3
; VI-NEXT:    v_mov_b32_e32 v15, 0x7e007e00
; VI-NEXT:    v_lshrrev_b64 v[3:4], 24, v[11:12]
; VI-NEXT:    v_lshrrev_b32_e32 v5, 8, v12
; VI-NEXT:    v_lshrrev_b32_e32 v1, 8, v11
; VI-NEXT:    v_lshrrev_b64 v[11:12], 24, v[14:15]
; VI-NEXT:    v_lshrrev_b32_e32 v9, 8, v14
; VI-NEXT:    v_bfe_u32 v7, v6, 8, 8
; VI-NEXT:    v_mov_b32_e32 v4, v13
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB43_3:
; VI-NEXT:    ; implicit-def: $sgpr12
; VI-NEXT:    ; implicit-def: $sgpr19
; VI-NEXT:    ; implicit-def: $sgpr4
; VI-NEXT:    ; implicit-def: $sgpr10
; VI-NEXT:    ; implicit-def: $sgpr15
; VI-NEXT:    ; implicit-def: $sgpr13
; VI-NEXT:    ; implicit-def: $sgpr11
; VI-NEXT:    ; implicit-def: $sgpr14
; VI-NEXT:    ; implicit-def: $sgpr6
; VI-NEXT:    s_branch .LBB43_2
; VI-NEXT:  .LBB43_4:
; VI-NEXT:    v_mov_b32_e32 v2, s19
; VI-NEXT:    v_mov_b32_e32 v6, s15
; VI-NEXT:    v_mov_b32_e32 v10, s14
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v8, s18
; VI-NEXT:    v_mov_b32_e32 v7, s13
; VI-NEXT:    v_mov_b32_e32 v9, s11
; VI-NEXT:    v_mov_b32_e32 v1, s12
; VI-NEXT:    v_mov_b32_e32 v5, s10
; VI-NEXT:    v_mov_b32_e32 v11, s6
; VI-NEXT:    v_mov_b32_e32 v3, s4
; VI-NEXT:    v_mov_b32_e32 v4, s17
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v6f16_to_v12i8_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s19, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB43_3
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_lshr_b32 s19, s16, 8
; GFX9-NEXT:    s_lshr_b32 s10, s18, 16
; GFX9-NEXT:    s_lshr_b32 s11, s18, 8
; GFX9-NEXT:    s_lshr_b32 s12, s17, 24
; GFX9-NEXT:    s_lshr_b32 s13, s17, 16
; GFX9-NEXT:    s_lshr_b32 s15, s17, 8
; GFX9-NEXT:    s_lshr_b32 s14, s16, 16
; GFX9-NEXT:    s_lshr_b64 s[6:7], s[18:19], 24
; GFX9-NEXT:    s_lshr_b64 s[4:5], s[16:17], 24
; GFX9-NEXT:    s_cbranch_execnz .LBB43_4
; GFX9-NEXT:  .LBB43_2: ; %cmp.true
; GFX9-NEXT:    v_mov_b32_e32 v0, 0x200
; GFX9-NEXT:    v_pk_add_f16 v15, s17, v0 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v14, s16, v0 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v8, s18, v0 op_sel_hi:[1,0]
; GFX9-NEXT:    v_mov_b32_e32 v9, 0x7e007e00
; GFX9-NEXT:    v_lshrrev_b64 v[3:4], 24, v[14:15]
; GFX9-NEXT:    v_lshrrev_b64 v[11:12], 24, v[8:9]
; GFX9-NEXT:    v_lshrrev_b32_e32 v10, 16, v8
; GFX9-NEXT:    v_lshrrev_b32_e32 v13, 8, v8
; GFX9-NEXT:    v_lshrrev_b32_e32 v7, 24, v15
; GFX9-NEXT:    v_lshrrev_b32_e32 v6, 16, v15
; GFX9-NEXT:    v_lshrrev_b32_e32 v5, 8, v15
; GFX9-NEXT:    v_lshrrev_b32_e32 v2, 16, v14
; GFX9-NEXT:    v_lshrrev_b32_e32 v1, 8, v14
; GFX9-NEXT:    s_branch .LBB43_5
; GFX9-NEXT:  .LBB43_3:
; GFX9-NEXT:    ; implicit-def: $sgpr19
; GFX9-NEXT:    ; implicit-def: $sgpr14
; GFX9-NEXT:    ; implicit-def: $sgpr4
; GFX9-NEXT:    ; implicit-def: $sgpr15
; GFX9-NEXT:    ; implicit-def: $sgpr13
; GFX9-NEXT:    ; implicit-def: $sgpr12
; GFX9-NEXT:    ; implicit-def: $sgpr11
; GFX9-NEXT:    ; implicit-def: $sgpr10
; GFX9-NEXT:    ; implicit-def: $sgpr6
; GFX9-NEXT:    s_branch .LBB43_2
; GFX9-NEXT:  .LBB43_4:
; GFX9-NEXT:    v_mov_b32_e32 v14, s16
; GFX9-NEXT:    v_mov_b32_e32 v15, s17
; GFX9-NEXT:    v_mov_b32_e32 v8, s18
; GFX9-NEXT:    v_mov_b32_e32 v1, s19
; GFX9-NEXT:    v_mov_b32_e32 v2, s14
; GFX9-NEXT:    v_mov_b32_e32 v5, s15
; GFX9-NEXT:    v_mov_b32_e32 v6, s13
; GFX9-NEXT:    v_mov_b32_e32 v7, s12
; GFX9-NEXT:    v_mov_b32_e32 v13, s11
; GFX9-NEXT:    v_mov_b32_e32 v10, s10
; GFX9-NEXT:    v_mov_b32_e32 v11, s6
; GFX9-NEXT:    v_mov_b32_e32 v3, s4
; GFX9-NEXT:  .LBB43_5: ; %end
; GFX9-NEXT:    v_mov_b32_e32 v0, v14
; GFX9-NEXT:    v_mov_b32_e32 v4, v15
; GFX9-NEXT:    v_mov_b32_e32 v9, v13
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v6f16_to_v12i8_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_cmp_lg_u32 s3, 0
; GFX11-NEXT:    s_mov_b32 s3, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB43_3
; GFX11-NEXT:  ; %bb.1: ; %cmp.false
; GFX11-NEXT:    s_lshr_b32 s8, s2, 16
; GFX11-NEXT:    s_lshr_b32 s9, s2, 8
; GFX11-NEXT:    s_lshr_b32 s10, s1, 24
; GFX11-NEXT:    s_lshr_b32 s11, s1, 16
; GFX11-NEXT:    s_lshr_b32 s13, s1, 8
; GFX11-NEXT:    s_lshr_b32 s12, s0, 16
; GFX11-NEXT:    s_lshr_b32 s14, s0, 8
; GFX11-NEXT:    s_lshr_b64 s[6:7], s[2:3], 24
; GFX11-NEXT:    s_lshr_b64 s[4:5], s[0:1], 24
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s3
; GFX11-NEXT:    s_cbranch_vccnz .LBB43_4
; GFX11-NEXT:  .LBB43_2: ; %cmp.true
; GFX11-NEXT:    v_pk_add_f16 v15, 0x200, s1 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v14, 0x200, s0 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v8, 0x200, s2 op_sel_hi:[0,1]
; GFX11-NEXT:    v_mov_b32_e32 v9, 0x7e007e00
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-NEXT:    v_lshrrev_b32_e32 v7, 24, v15
; GFX11-NEXT:    v_lshrrev_b64 v[3:4], 24, v[14:15]
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-NEXT:    v_lshrrev_b32_e32 v10, 16, v8
; GFX11-NEXT:    v_lshrrev_b64 v[11:12], 24, v[8:9]
; GFX11-NEXT:    v_lshrrev_b32_e32 v13, 8, v8
; GFX11-NEXT:    v_lshrrev_b32_e32 v6, 16, v15
; GFX11-NEXT:    v_lshrrev_b32_e32 v5, 8, v15
; GFX11-NEXT:    v_lshrrev_b32_e32 v2, 16, v14
; GFX11-NEXT:    v_lshrrev_b32_e32 v1, 8, v14
; GFX11-NEXT:    s_branch .LBB43_5
; GFX11-NEXT:  .LBB43_3:
; GFX11-NEXT:    ; implicit-def: $sgpr14
; GFX11-NEXT:    ; implicit-def: $sgpr12
; GFX11-NEXT:    ; implicit-def: $sgpr4
; GFX11-NEXT:    ; implicit-def: $sgpr13
; GFX11-NEXT:    ; implicit-def: $sgpr11
; GFX11-NEXT:    ; implicit-def: $sgpr10
; GFX11-NEXT:    ; implicit-def: $sgpr9
; GFX11-NEXT:    ; implicit-def: $sgpr8
; GFX11-NEXT:    ; implicit-def: $sgpr6
; GFX11-NEXT:    s_branch .LBB43_2
; GFX11-NEXT:  .LBB43_4:
; GFX11-NEXT:    v_dual_mov_b32 v14, s0 :: v_dual_mov_b32 v15, s1
; GFX11-NEXT:    v_dual_mov_b32 v8, s2 :: v_dual_mov_b32 v1, s14
; GFX11-NEXT:    v_dual_mov_b32 v2, s12 :: v_dual_mov_b32 v5, s13
; GFX11-NEXT:    v_dual_mov_b32 v6, s11 :: v_dual_mov_b32 v7, s10
; GFX11-NEXT:    v_dual_mov_b32 v13, s9 :: v_dual_mov_b32 v10, s8
; GFX11-NEXT:    v_mov_b32_e32 v11, s6
; GFX11-NEXT:    v_mov_b32_e32 v3, s4
; GFX11-NEXT:  .LBB43_5: ; %end
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX11-NEXT:    v_dual_mov_b32 v0, v14 :: v_dual_mov_b32 v9, v13
; GFX11-NEXT:    v_mov_b32_e32 v4, v15
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <6 x half> %a, splat (half 0xH0200)
  %a2 = bitcast <6 x half> %a1 to <12 x i8>
  br label %end

cmp.false:
  %a3 = bitcast <6 x half> %a to <12 x i8>
  br label %end

end:
  %phi = phi <12 x i8> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <12 x i8> %phi
}

define <6 x i16> @bitcast_v12i8_to_v6i16(<12 x i8> %a, i32 %b) {
; SI-LABEL: bitcast_v12i8_to_v6i16:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v14, v4
; SI-NEXT:    v_mov_b32_e32 v15, v2
; SI-NEXT:    v_mov_b32_e32 v13, v0
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v12
; SI-NEXT:    v_lshlrev_b32_e32 v16, 8, v5
; SI-NEXT:    v_lshlrev_b32_e32 v12, 24, v7
; SI-NEXT:    v_lshlrev_b32_e32 v17, 24, v3
; SI-NEXT:    v_lshlrev_b32_e32 v18, 8, v1
; SI-NEXT:    v_lshlrev_b32_e32 v9, 8, v9
; SI-NEXT:    v_lshlrev_b32_e32 v7, 24, v11
; SI-NEXT:    ; implicit-def: $vgpr0
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    ; implicit-def: $vgpr4
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB44_3
; SI-NEXT:  ; %bb.1: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB44_4
; SI-NEXT:  .LBB44_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB44_3: ; %cmp.false
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v14
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v6
; SI-NEXT:    v_or_b32_e32 v0, v0, v16
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v3, v12, v1
; SI-NEXT:    v_or_b32_e32 v2, v0, v3
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v15
; SI-NEXT:    v_and_b32_e32 v4, 0xff, v13
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; SI-NEXT:    v_or_b32_e32 v4, v4, v18
; SI-NEXT:    v_or_b32_e32 v0, v17, v0
; SI-NEXT:    v_and_b32_e32 v4, 0xffff, v4
; SI-NEXT:    v_alignbit_b32 v1, v2, v0, 16
; SI-NEXT:    v_or_b32_e32 v0, v4, v0
; SI-NEXT:    v_and_b32_e32 v4, 0xff, v8
; SI-NEXT:    v_and_b32_e32 v5, 0xff, v10
; SI-NEXT:    v_or_b32_e32 v4, v4, v9
; SI-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; SI-NEXT:    v_and_b32_e32 v4, 0xffff, v4
; SI-NEXT:    v_or_b32_e32 v5, v7, v5
; SI-NEXT:    v_or_b32_e32 v4, v4, v5
; SI-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; SI-NEXT:    v_lshrrev_b32_e32 v5, 16, v5
; SI-NEXT:    ; implicit-def: $vgpr13
; SI-NEXT:    ; implicit-def: $vgpr15
; SI-NEXT:    ; implicit-def: $vgpr14
; SI-NEXT:    ; implicit-def: $vgpr6
; SI-NEXT:    ; implicit-def: $vgpr8
; SI-NEXT:    ; implicit-def: $vgpr10
; SI-NEXT:    ; implicit-def: $vgpr16
; SI-NEXT:    ; implicit-def: $vgpr12
; SI-NEXT:    ; implicit-def: $vgpr17
; SI-NEXT:    ; implicit-def: $vgpr18
; SI-NEXT:    ; implicit-def: $vgpr9
; SI-NEXT:    ; implicit-def: $vgpr7
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB44_2
; SI-NEXT:  .LBB44_4: ; %cmp.true
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v13
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v0
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v15
; SI-NEXT:    v_or_b32_e32 v0, v18, v0
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v1
; SI-NEXT:    v_add_i32_e32 v0, vcc, 0x300, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v1, v17, v1
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v14
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v1
; SI-NEXT:    v_add_i32_e32 v2, vcc, 3, v6
; SI-NEXT:    s_movk_i32 s6, 0x300
; SI-NEXT:    v_or_b32_e32 v1, v16, v1
; SI-NEXT:    v_and_b32_e32 v2, 0xff, v2
; SI-NEXT:    v_add_i32_e32 v1, vcc, s6, v1
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; SI-NEXT:    v_or_b32_e32 v2, v12, v2
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    v_add_i32_e32 v2, vcc, 0x3000000, v1
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v8
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v1
; SI-NEXT:    v_add_i32_e32 v3, vcc, 3, v10
; SI-NEXT:    v_or_b32_e32 v1, v9, v1
; SI-NEXT:    v_and_b32_e32 v3, 0xff, v3
; SI-NEXT:    v_add_i32_e32 v1, vcc, 0x300, v1
; SI-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; SI-NEXT:    v_or_b32_e32 v3, v7, v3
; SI-NEXT:    s_mov_b32 s7, 0x3000000
; SI-NEXT:    v_or_b32_e32 v1, v3, v1
; SI-NEXT:    v_add_i32_e32 v0, vcc, s7, v0
; SI-NEXT:    v_add_i32_e32 v4, vcc, 0x3000000, v1
; SI-NEXT:    v_alignbit_b32 v1, v2, v0, 16
; SI-NEXT:    v_lshrrev_b32_e32 v3, 16, v2
; SI-NEXT:    v_lshrrev_b32_e32 v5, 16, v4
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v12i8_to_v6i16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v14, v2
; VI-NEXT:    v_mov_b32_e32 v13, v0
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v12
; VI-NEXT:    v_lshlrev_b16_e32 v17, 8, v1
; VI-NEXT:    v_lshlrev_b16_e32 v16, 8, v3
; VI-NEXT:    v_lshlrev_b16_e32 v15, 8, v5
; VI-NEXT:    v_lshlrev_b16_e32 v12, 8, v7
; VI-NEXT:    v_lshlrev_b16_e32 v7, 8, v9
; VI-NEXT:    v_lshlrev_b16_e32 v5, 8, v11
; VI-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_cbranch_execnz .LBB44_3
; VI-NEXT:  ; %bb.1: ; %Flow
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execnz .LBB44_4
; VI-NEXT:  .LBB44_2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB44_3: ; %cmp.false
; VI-NEXT:    v_or_b32_sdwa v0, v13, v17 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v14, v16 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v4, v15 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v2, v6, v12 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v2, v8, v7 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v3, v10, v5 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v2, v2, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    ; implicit-def: $vgpr13
; VI-NEXT:    ; implicit-def: $vgpr14
; VI-NEXT:    ; implicit-def: $vgpr4
; VI-NEXT:    ; implicit-def: $vgpr6
; VI-NEXT:    ; implicit-def: $vgpr8
; VI-NEXT:    ; implicit-def: $vgpr10
; VI-NEXT:    ; implicit-def: $vgpr17
; VI-NEXT:    ; implicit-def: $vgpr16
; VI-NEXT:    ; implicit-def: $vgpr15
; VI-NEXT:    ; implicit-def: $vgpr12
; VI-NEXT:    ; implicit-def: $vgpr7
; VI-NEXT:    ; implicit-def: $vgpr5
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB44_2
; VI-NEXT:  .LBB44_4: ; %cmp.true
; VI-NEXT:    v_add_u16_e32 v0, 3, v13
; VI-NEXT:    v_add_u16_e32 v1, 3, v14
; VI-NEXT:    v_or_b32_sdwa v0, v17, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_or_b32_sdwa v1, v16, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_mov_b32_e32 v2, 0x300
; VI-NEXT:    v_add_u16_e32 v0, 0x300, v0
; VI-NEXT:    v_add_u16_sdwa v1, v1, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v0, v0, v1
; VI-NEXT:    v_add_u16_e32 v1, 3, v4
; VI-NEXT:    v_add_u16_e32 v3, 3, v6
; VI-NEXT:    v_or_b32_sdwa v1, v15, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_or_b32_sdwa v3, v12, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_add_u16_e32 v1, 0x300, v1
; VI-NEXT:    v_add_u16_sdwa v3, v3, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v1, v1, v3
; VI-NEXT:    v_add_u16_e32 v3, 3, v8
; VI-NEXT:    v_add_u16_e32 v4, 3, v10
; VI-NEXT:    v_or_b32_sdwa v3, v7, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_or_b32_sdwa v4, v5, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_add_u16_e32 v3, 0x300, v3
; VI-NEXT:    v_add_u16_sdwa v2, v4, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v2, v3, v2
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v12i8_to_v6i16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v14, v2
; GFX9-NEXT:    v_mov_b32_e32 v13, v0
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v12
; GFX9-NEXT:    v_lshlrev_b16_e32 v17, 8, v1
; GFX9-NEXT:    v_lshlrev_b16_e32 v16, 8, v3
; GFX9-NEXT:    v_lshlrev_b16_e32 v15, 8, v5
; GFX9-NEXT:    v_lshlrev_b16_e32 v12, 8, v7
; GFX9-NEXT:    v_lshlrev_b16_e32 v7, 8, v9
; GFX9-NEXT:    v_lshlrev_b16_e32 v5, 8, v11
; GFX9-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_cbranch_execnz .LBB44_3
; GFX9-NEXT:  ; %bb.1: ; %Flow
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:    s_cbranch_execnz .LBB44_4
; GFX9-NEXT:  .LBB44_2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB44_3: ; %cmp.false
; GFX9-NEXT:    v_or_b32_sdwa v0, v13, v17 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v1, v14, v16 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v1, v4, v15 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v2, v6, v12 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v2, v8, v7 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v3, v10, v5 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v2, v2, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    ; implicit-def: $vgpr13
; GFX9-NEXT:    ; implicit-def: $vgpr14
; GFX9-NEXT:    ; implicit-def: $vgpr4
; GFX9-NEXT:    ; implicit-def: $vgpr6
; GFX9-NEXT:    ; implicit-def: $vgpr8
; GFX9-NEXT:    ; implicit-def: $vgpr10
; GFX9-NEXT:    ; implicit-def: $vgpr17
; GFX9-NEXT:    ; implicit-def: $vgpr16
; GFX9-NEXT:    ; implicit-def: $vgpr15
; GFX9-NEXT:    ; implicit-def: $vgpr12
; GFX9-NEXT:    ; implicit-def: $vgpr7
; GFX9-NEXT:    ; implicit-def: $vgpr5
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB44_2
; GFX9-NEXT:  .LBB44_4: ; %cmp.true
; GFX9-NEXT:    v_add_u16_e32 v0, 3, v13
; GFX9-NEXT:    v_add_u16_e32 v1, 3, v14
; GFX9-NEXT:    v_or_b32_sdwa v0, v17, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    s_movk_i32 s6, 0x300
; GFX9-NEXT:    v_or_b32_sdwa v1, v16, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u16_e32 v0, 0x300, v0
; GFX9-NEXT:    v_add_u16_sdwa v1, v1, s6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX9-NEXT:    v_add_u16_e32 v1, 3, v4
; GFX9-NEXT:    v_add_u16_e32 v2, 3, v6
; GFX9-NEXT:    v_or_b32_sdwa v1, v15, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_or_b32_sdwa v2, v12, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u16_e32 v1, 0x300, v1
; GFX9-NEXT:    v_add_u16_sdwa v2, v2, s6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_e32 v1, v1, v2
; GFX9-NEXT:    v_add_u16_e32 v2, 3, v8
; GFX9-NEXT:    v_add_u16_e32 v3, 3, v10
; GFX9-NEXT:    v_or_b32_sdwa v2, v7, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_or_b32_sdwa v3, v5, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u16_e32 v2, 0x300, v2
; GFX9-NEXT:    v_add_u16_sdwa v3, v3, s6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_e32 v2, v2, v3
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-TRUE16-LABEL: bitcast_v12i8_to_v6i16:
; GFX11-TRUE16:       ; %bb.0:
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v9.h, v9.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v10.h, v7.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v7.l, v6.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v7.h, v4.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v8.h, v2.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v9.l, v0.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v6.h, 8, v1.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v5.h, 8, v3.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v6.l, 8, v5.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v5.l, 8, v10.h
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v4.l, 8, v9.h
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v4.h, 8, v11.l
; GFX11-TRUE16-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3
; GFX11-TRUE16-NEXT:    v_cmpx_ne_u32_e32 0, v12
; GFX11-TRUE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-TRUE16-NEXT:    s_cbranch_execnz .LBB44_3
; GFX11-TRUE16-NEXT:  ; %bb.1: ; %Flow
; GFX11-TRUE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-TRUE16-NEXT:    s_cbranch_execnz .LBB44_4
; GFX11-TRUE16-NEXT:  .LBB44_2: ; %end
; GFX11-TRUE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
; GFX11-TRUE16-NEXT:  .LBB44_3: ; %cmp.false
; GFX11-TRUE16-NEXT:    v_and_b16 v0.l, 0xff, v9.l
; GFX11-TRUE16-NEXT:    v_and_b16 v0.h, 0xff, v8.h
; GFX11-TRUE16-NEXT:    v_and_b16 v1.l, 0xff, v7.h
; GFX11-TRUE16-NEXT:    v_and_b16 v1.h, 0xff, v7.l
; GFX11-TRUE16-NEXT:    v_and_b16 v2.l, 0xff, v8.l
; GFX11-TRUE16-NEXT:    v_or_b16 v0.l, v0.l, v6.h
; GFX11-TRUE16-NEXT:    v_and_b16 v2.h, 0xff, v10.l
; GFX11-TRUE16-NEXT:    v_or_b16 v3.l, v0.h, v5.h
; GFX11-TRUE16-NEXT:    v_or_b16 v1.l, v1.l, v6.l
; GFX11-TRUE16-NEXT:    v_or_b16 v5.l, v1.h, v5.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v6.l, v0.l
; GFX11-TRUE16-NEXT:    v_or_b16 v0.l, v2.l, v4.l
; GFX11-TRUE16-NEXT:    v_or_b16 v2.l, v2.h, v4.h
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v4, 0xffff, v6
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v6, 0xffff, v0
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v0, v4, v3
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v1, v1, v5
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v2, v6, v2
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr9_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr8_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr7_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr7_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr8_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr10_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr6_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr5_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr6_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr5_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr4_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr4_hi16
; GFX11-TRUE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-TRUE16-NEXT:    s_cbranch_execz .LBB44_2
; GFX11-TRUE16-NEXT:  .LBB44_4: ; %cmp.true
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v0.l, v9.l, 3
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v0.h, v8.h, 3
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v1.l, v7.h, 3
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v1.h, v7.l, 3
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v2.l, v8.l, 3
; GFX11-TRUE16-NEXT:    v_and_b16 v0.l, 0xff, v0.l
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v2.h, v10.l, 3
; GFX11-TRUE16-NEXT:    v_and_b16 v0.h, 0xff, v0.h
; GFX11-TRUE16-NEXT:    v_and_b16 v1.l, 0xff, v1.l
; GFX11-TRUE16-NEXT:    v_and_b16 v1.h, 0xff, v1.h
; GFX11-TRUE16-NEXT:    v_or_b16 v0.l, v6.h, v0.l
; GFX11-TRUE16-NEXT:    v_and_b16 v2.l, 0xff, v2.l
; GFX11-TRUE16-NEXT:    v_and_b16 v2.h, 0xff, v2.h
; GFX11-TRUE16-NEXT:    v_or_b16 v0.h, v5.h, v0.h
; GFX11-TRUE16-NEXT:    v_or_b16 v1.l, v6.l, v1.l
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v0.l, 0x300, v0.l
; GFX11-TRUE16-NEXT:    v_or_b16 v1.h, v5.l, v1.h
; GFX11-TRUE16-NEXT:    v_or_b16 v2.l, v4.l, v2.l
; GFX11-TRUE16-NEXT:    v_or_b16 v2.h, v4.h, v2.h
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v3.l, 0x300, v0.h
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v5.l, v0.l
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v0.l, 0x300, v1.l
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v1.l, 0x300, v1.h
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v2.l, 0x300, v2.l
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v4.l, 0x300, v2.h
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v5, 0xffff, v5
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v6, 0xffff, v0
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v0, v5, v3
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v1, v6, v1
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v2, v2, v4
; GFX11-TRUE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-FAKE16-LABEL: bitcast_v12i8_to_v6i16:
; GFX11-FAKE16:       ; %bb.0:
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-FAKE16-NEXT:    v_dual_mov_b32 v14, v2 :: v_dual_mov_b32 v13, v0
; GFX11-FAKE16-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v12
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v17, 8, v1
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v15, 8, v3
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v16, 8, v5
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v12, 8, v7
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v5, 8, v9
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v7, 8, v11
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3
; GFX11-FAKE16-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-FAKE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_cbranch_execnz .LBB44_3
; GFX11-FAKE16-NEXT:  ; %bb.1: ; %Flow
; GFX11-FAKE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-FAKE16-NEXT:    s_cbranch_execnz .LBB44_4
; GFX11-FAKE16-NEXT:  .LBB44_2: ; %end
; GFX11-FAKE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
; GFX11-FAKE16-NEXT:  .LBB44_3: ; %cmp.false
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v0, 0xff, v13
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v1, 0xff, v14
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v2, 0xff, v4
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v3, 0xff, v6
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v4, 0xff, v8
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v6, 0xff, v10
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v0, v0, v17
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v1, v1, v15
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v2, v2, v16
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v3, v3, v12
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v4, v4, v5
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v5, v6, v7
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v4, 0xffff, v4
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr13
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr14
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr6
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr8
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr10
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr17
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr15
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr16
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr12
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr7
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v1, v2, v3
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v2, v4, v5
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr4
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr5
; GFX11-FAKE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-FAKE16-NEXT:    s_cbranch_execz .LBB44_2
; GFX11-FAKE16-NEXT:  .LBB44_4: ; %cmp.true
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v0, v13, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v1, v14, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v2, v4, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v3, v6, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v4, v8, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v6, v10, 3
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v1, 0xff, v1
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v2, 0xff, v2
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v3, 0xff, v3
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v4, 0xff, v4
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v6, 0xff, v6
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v0, v17, v0
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v1, v15, v1
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v2, v16, v2
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v3, v12, v3
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v4, v5, v4
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v5, v7, v6
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v0, 0x300, v0
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v1, 0x300, v1
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v2, 0x300, v2
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v3, 0x300, v3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v4, 0x300, v4
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v5, 0x300, v5
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v4, 0xffff, v4
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v1, v2, v3
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v2, v4, v5
; GFX11-FAKE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <12 x i8> %a, splat (i8 3)
  %a2 = bitcast <12 x i8> %a1 to <6 x i16>
  br label %end

cmp.false:
  %a3 = bitcast <12 x i8> %a to <6 x i16>
  br label %end

end:
  %phi = phi <6 x i16> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <6 x i16> %phi
}

define inreg <6 x i16> @bitcast_v12i8_to_v6i16_scalar(<12 x i8> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v12i8_to_v6i16_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s28, 0
; SI-NEXT:    s_cbranch_scc0 .LBB45_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_and_b32 s4, s20, 0xff
; SI-NEXT:    s_lshl_b32 s5, s21, 8
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    s_and_b32 s5, s22, 0xff
; SI-NEXT:    s_lshl_b32 s5, s5, 16
; SI-NEXT:    s_lshl_b32 s6, s23, 24
; SI-NEXT:    s_and_b32 s4, s4, 0xffff
; SI-NEXT:    s_or_b32 s5, s6, s5
; SI-NEXT:    s_or_b32 s7, s4, s5
; SI-NEXT:    s_and_b32 s4, s18, 0xff
; SI-NEXT:    s_lshl_b32 s4, s4, 16
; SI-NEXT:    s_lshl_b32 s6, s19, 24
; SI-NEXT:    s_or_b32 s4, s6, s4
; SI-NEXT:    s_and_b32 s6, s16, 0xff
; SI-NEXT:    s_lshl_b32 s8, s17, 8
; SI-NEXT:    s_or_b32 s6, s6, s8
; SI-NEXT:    s_and_b32 s6, s6, 0xffff
; SI-NEXT:    v_mov_b32_e32 v0, s4
; SI-NEXT:    s_or_b32 s6, s6, s4
; SI-NEXT:    s_and_b32 s4, s24, 0xff
; SI-NEXT:    s_lshl_b32 s8, s25, 8
; SI-NEXT:    s_or_b32 s4, s4, s8
; SI-NEXT:    s_and_b32 s8, s26, 0xff
; SI-NEXT:    s_lshl_b32 s8, s8, 16
; SI-NEXT:    s_lshl_b32 s9, s27, 24
; SI-NEXT:    s_and_b32 s4, s4, 0xffff
; SI-NEXT:    s_or_b32 s10, s9, s8
; SI-NEXT:    v_alignbit_b32 v1, s7, v0, 16
; SI-NEXT:    s_or_b32 s8, s4, s10
; SI-NEXT:    s_lshr_b32 s9, s5, 16
; SI-NEXT:    s_lshr_b32 s10, s10, 16
; SI-NEXT:    s_cbranch_execnz .LBB45_3
; SI-NEXT:  .LBB45_2: ; %cmp.true
; SI-NEXT:    s_add_i32 s16, s16, 3
; SI-NEXT:    s_and_b32 s4, s16, 0xff
; SI-NEXT:    s_lshl_b32 s5, s17, 8
; SI-NEXT:    s_add_i32 s18, s18, 3
; SI-NEXT:    s_or_b32 s4, s5, s4
; SI-NEXT:    s_and_b32 s6, s18, 0xff
; SI-NEXT:    s_addk_i32 s4, 0x300
; SI-NEXT:    s_lshl_b32 s5, s19, 24
; SI-NEXT:    s_lshl_b32 s6, s6, 16
; SI-NEXT:    s_and_b32 s4, s4, 0xffff
; SI-NEXT:    s_or_b32 s5, s5, s6
; SI-NEXT:    s_or_b32 s4, s5, s4
; SI-NEXT:    s_add_i32 s20, s20, 3
; SI-NEXT:    s_add_i32 s6, s4, 0x3000000
; SI-NEXT:    s_and_b32 s4, s20, 0xff
; SI-NEXT:    s_lshl_b32 s5, s21, 8
; SI-NEXT:    s_add_i32 s22, s22, 3
; SI-NEXT:    s_or_b32 s4, s5, s4
; SI-NEXT:    s_and_b32 s7, s22, 0xff
; SI-NEXT:    s_addk_i32 s4, 0x300
; SI-NEXT:    s_lshl_b32 s5, s23, 24
; SI-NEXT:    s_lshl_b32 s7, s7, 16
; SI-NEXT:    s_and_b32 s4, s4, 0xffff
; SI-NEXT:    s_or_b32 s5, s5, s7
; SI-NEXT:    s_or_b32 s4, s5, s4
; SI-NEXT:    s_add_i32 s24, s24, 3
; SI-NEXT:    s_add_i32 s7, s4, 0x3000000
; SI-NEXT:    s_and_b32 s4, s24, 0xff
; SI-NEXT:    s_lshl_b32 s5, s25, 8
; SI-NEXT:    s_add_i32 s26, s26, 3
; SI-NEXT:    s_or_b32 s4, s5, s4
; SI-NEXT:    s_and_b32 s8, s26, 0xff
; SI-NEXT:    s_addk_i32 s4, 0x300
; SI-NEXT:    s_lshl_b32 s5, s27, 24
; SI-NEXT:    s_lshl_b32 s8, s8, 16
; SI-NEXT:    s_and_b32 s4, s4, 0xffff
; SI-NEXT:    s_or_b32 s5, s5, s8
; SI-NEXT:    s_or_b32 s4, s5, s4
; SI-NEXT:    s_add_i32 s8, s4, 0x3000000
; SI-NEXT:    v_mov_b32_e32 v0, s6
; SI-NEXT:    v_alignbit_b32 v1, s7, v0, 16
; SI-NEXT:    s_lshr_b32 s9, s7, 16
; SI-NEXT:    s_lshr_b32 s10, s8, 16
; SI-NEXT:  .LBB45_3: ; %end
; SI-NEXT:    v_mov_b32_e32 v0, s6
; SI-NEXT:    v_mov_b32_e32 v2, s7
; SI-NEXT:    v_mov_b32_e32 v3, s9
; SI-NEXT:    v_mov_b32_e32 v4, s8
; SI-NEXT:    v_mov_b32_e32 v5, s10
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB45_4:
; SI-NEXT:    ; implicit-def: $sgpr6
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    ; implicit-def: $sgpr7
; SI-NEXT:    ; implicit-def: $sgpr9
; SI-NEXT:    ; implicit-def: $sgpr8
; SI-NEXT:    ; implicit-def: $sgpr10
; SI-NEXT:    s_branch .LBB45_2
;
; VI-LABEL: bitcast_v12i8_to_v6i16_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s28, 0
; VI-NEXT:    s_cbranch_scc0 .LBB45_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_and_b32 s4, s16, 0xff
; VI-NEXT:    s_lshl_b32 s5, s17, 8
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_and_b32 s5, s18, 0xff
; VI-NEXT:    s_lshl_b32 s6, s19, 8
; VI-NEXT:    s_or_b32 s5, s5, s6
; VI-NEXT:    s_and_b32 s4, s4, 0xffff
; VI-NEXT:    s_lshl_b32 s5, s5, 16
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_and_b32 s5, s20, 0xff
; VI-NEXT:    s_lshl_b32 s6, s21, 8
; VI-NEXT:    s_or_b32 s5, s5, s6
; VI-NEXT:    s_and_b32 s6, s22, 0xff
; VI-NEXT:    s_lshl_b32 s7, s23, 8
; VI-NEXT:    s_or_b32 s6, s6, s7
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_lshl_b32 s6, s6, 16
; VI-NEXT:    s_or_b32 s5, s5, s6
; VI-NEXT:    s_and_b32 s6, s24, 0xff
; VI-NEXT:    s_lshl_b32 s7, s25, 8
; VI-NEXT:    s_or_b32 s6, s6, s7
; VI-NEXT:    s_and_b32 s7, s26, 0xff
; VI-NEXT:    s_lshl_b32 s8, s27, 8
; VI-NEXT:    s_or_b32 s7, s7, s8
; VI-NEXT:    s_and_b32 s6, s6, 0xffff
; VI-NEXT:    s_lshl_b32 s7, s7, 16
; VI-NEXT:    s_or_b32 s6, s6, s7
; VI-NEXT:    s_cbranch_execnz .LBB45_3
; VI-NEXT:  .LBB45_2: ; %cmp.true
; VI-NEXT:    s_add_i32 s16, s16, 3
; VI-NEXT:    s_and_b32 s4, s16, 0xff
; VI-NEXT:    s_lshl_b32 s5, s17, 8
; VI-NEXT:    s_add_i32 s18, s18, 3
; VI-NEXT:    s_or_b32 s4, s5, s4
; VI-NEXT:    s_and_b32 s5, s18, 0xff
; VI-NEXT:    s_lshl_b32 s6, s19, 8
; VI-NEXT:    s_addk_i32 s4, 0x300
; VI-NEXT:    s_or_b32 s5, s6, s5
; VI-NEXT:    s_and_b32 s4, s4, 0xffff
; VI-NEXT:    s_lshl_b32 s5, s5, 16
; VI-NEXT:    s_add_i32 s20, s20, 3
; VI-NEXT:    s_or_b32 s4, s5, s4
; VI-NEXT:    s_and_b32 s5, s20, 0xff
; VI-NEXT:    s_lshl_b32 s6, s21, 8
; VI-NEXT:    s_add_i32 s22, s22, 3
; VI-NEXT:    s_or_b32 s5, s6, s5
; VI-NEXT:    s_and_b32 s6, s22, 0xff
; VI-NEXT:    s_lshl_b32 s7, s23, 8
; VI-NEXT:    s_addk_i32 s5, 0x300
; VI-NEXT:    s_or_b32 s6, s7, s6
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_lshl_b32 s6, s6, 16
; VI-NEXT:    s_add_i32 s24, s24, 3
; VI-NEXT:    s_or_b32 s5, s6, s5
; VI-NEXT:    s_and_b32 s6, s24, 0xff
; VI-NEXT:    s_lshl_b32 s7, s25, 8
; VI-NEXT:    s_add_i32 s26, s26, 3
; VI-NEXT:    s_or_b32 s6, s7, s6
; VI-NEXT:    s_and_b32 s7, s26, 0xff
; VI-NEXT:    s_lshl_b32 s8, s27, 8
; VI-NEXT:    s_addk_i32 s6, 0x300
; VI-NEXT:    s_or_b32 s7, s8, s7
; VI-NEXT:    s_and_b32 s6, s6, 0xffff
; VI-NEXT:    s_lshl_b32 s7, s7, 16
; VI-NEXT:    s_or_b32 s6, s7, s6
; VI-NEXT:    s_add_i32 s4, s4, 0x3000000
; VI-NEXT:    s_add_i32 s5, s5, 0x3000000
; VI-NEXT:    s_add_i32 s6, s6, 0x3000000
; VI-NEXT:  .LBB45_3: ; %end
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    v_mov_b32_e32 v1, s5
; VI-NEXT:    v_mov_b32_e32 v2, s6
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB45_4:
; VI-NEXT:    ; implicit-def: $sgpr4_sgpr5_sgpr6_sgpr7
; VI-NEXT:    s_branch .LBB45_2
;
; GFX9-LABEL: bitcast_v12i8_to_v6i16_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s28, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB45_4
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_and_b32 s4, s16, 0xff
; GFX9-NEXT:    s_lshl_b32 s5, s17, 8
; GFX9-NEXT:    s_or_b32 s4, s4, s5
; GFX9-NEXT:    s_and_b32 s5, s18, 0xff
; GFX9-NEXT:    s_lshl_b32 s6, s19, 8
; GFX9-NEXT:    s_or_b32 s5, s5, s6
; GFX9-NEXT:    s_and_b32 s4, s4, 0xffff
; GFX9-NEXT:    s_lshl_b32 s5, s5, 16
; GFX9-NEXT:    s_or_b32 s4, s4, s5
; GFX9-NEXT:    s_and_b32 s5, s20, 0xff
; GFX9-NEXT:    s_lshl_b32 s6, s21, 8
; GFX9-NEXT:    s_or_b32 s5, s5, s6
; GFX9-NEXT:    s_and_b32 s6, s22, 0xff
; GFX9-NEXT:    s_lshl_b32 s7, s23, 8
; GFX9-NEXT:    s_or_b32 s6, s6, s7
; GFX9-NEXT:    s_and_b32 s5, s5, 0xffff
; GFX9-NEXT:    s_lshl_b32 s6, s6, 16
; GFX9-NEXT:    s_or_b32 s5, s5, s6
; GFX9-NEXT:    s_and_b32 s6, s24, 0xff
; GFX9-NEXT:    s_lshl_b32 s7, s25, 8
; GFX9-NEXT:    s_or_b32 s6, s6, s7
; GFX9-NEXT:    s_and_b32 s7, s26, 0xff
; GFX9-NEXT:    s_lshl_b32 s8, s27, 8
; GFX9-NEXT:    s_or_b32 s7, s7, s8
; GFX9-NEXT:    s_and_b32 s6, s6, 0xffff
; GFX9-NEXT:    s_lshl_b32 s7, s7, 16
; GFX9-NEXT:    s_or_b32 s6, s6, s7
; GFX9-NEXT:    s_cbranch_execnz .LBB45_3
; GFX9-NEXT:  .LBB45_2: ; %cmp.true
; GFX9-NEXT:    s_add_i32 s16, s16, 3
; GFX9-NEXT:    s_and_b32 s4, s16, 0xff
; GFX9-NEXT:    s_lshl_b32 s5, s17, 8
; GFX9-NEXT:    s_add_i32 s18, s18, 3
; GFX9-NEXT:    s_or_b32 s4, s5, s4
; GFX9-NEXT:    s_and_b32 s5, s18, 0xff
; GFX9-NEXT:    s_lshl_b32 s6, s19, 8
; GFX9-NEXT:    s_or_b32 s5, s6, s5
; GFX9-NEXT:    s_addk_i32 s4, 0x300
; GFX9-NEXT:    s_addk_i32 s5, 0x300
; GFX9-NEXT:    s_and_b32 s4, s4, 0xffff
; GFX9-NEXT:    s_lshl_b32 s5, s5, 16
; GFX9-NEXT:    s_add_i32 s20, s20, 3
; GFX9-NEXT:    s_or_b32 s4, s4, s5
; GFX9-NEXT:    s_and_b32 s5, s20, 0xff
; GFX9-NEXT:    s_lshl_b32 s6, s21, 8
; GFX9-NEXT:    s_add_i32 s22, s22, 3
; GFX9-NEXT:    s_or_b32 s5, s6, s5
; GFX9-NEXT:    s_and_b32 s6, s22, 0xff
; GFX9-NEXT:    s_lshl_b32 s7, s23, 8
; GFX9-NEXT:    s_or_b32 s6, s7, s6
; GFX9-NEXT:    s_addk_i32 s5, 0x300
; GFX9-NEXT:    s_addk_i32 s6, 0x300
; GFX9-NEXT:    s_and_b32 s5, s5, 0xffff
; GFX9-NEXT:    s_lshl_b32 s6, s6, 16
; GFX9-NEXT:    s_add_i32 s24, s24, 3
; GFX9-NEXT:    s_or_b32 s5, s5, s6
; GFX9-NEXT:    s_and_b32 s6, s24, 0xff
; GFX9-NEXT:    s_lshl_b32 s7, s25, 8
; GFX9-NEXT:    s_add_i32 s26, s26, 3
; GFX9-NEXT:    s_or_b32 s6, s7, s6
; GFX9-NEXT:    s_and_b32 s7, s26, 0xff
; GFX9-NEXT:    s_lshl_b32 s8, s27, 8
; GFX9-NEXT:    s_or_b32 s7, s8, s7
; GFX9-NEXT:    s_addk_i32 s6, 0x300
; GFX9-NEXT:    s_addk_i32 s7, 0x300
; GFX9-NEXT:    s_and_b32 s6, s6, 0xffff
; GFX9-NEXT:    s_lshl_b32 s7, s7, 16
; GFX9-NEXT:    s_or_b32 s6, s6, s7
; GFX9-NEXT:  .LBB45_3: ; %end
; GFX9-NEXT:    v_mov_b32_e32 v0, s4
; GFX9-NEXT:    v_mov_b32_e32 v1, s5
; GFX9-NEXT:    v_mov_b32_e32 v2, s6
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB45_4:
; GFX9-NEXT:    ; implicit-def: $sgpr4_sgpr5_sgpr6_sgpr7
; GFX9-NEXT:    s_branch .LBB45_2
;
; GFX11-LABEL: bitcast_v12i8_to_v6i16_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_cmp_lg_u32 s24, 0
; GFX11-NEXT:    s_mov_b32 s8, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB45_4
; GFX11-NEXT:  ; %bb.1: ; %cmp.false
; GFX11-NEXT:    s_and_b32 s4, s0, 0xff
; GFX11-NEXT:    s_lshl_b32 s5, s1, 8
; GFX11-NEXT:    s_and_b32 s6, s2, 0xff
; GFX11-NEXT:    s_lshl_b32 s7, s3, 8
; GFX11-NEXT:    s_or_b32 s4, s4, s5
; GFX11-NEXT:    s_or_b32 s5, s6, s7
; GFX11-NEXT:    s_and_b32 s4, s4, 0xffff
; GFX11-NEXT:    s_lshl_b32 s5, s5, 16
; GFX11-NEXT:    s_lshl_b32 s6, s17, 8
; GFX11-NEXT:    s_or_b32 s4, s4, s5
; GFX11-NEXT:    s_and_b32 s5, s16, 0xff
; GFX11-NEXT:    s_and_b32 s7, s18, 0xff
; GFX11-NEXT:    s_lshl_b32 s9, s19, 8
; GFX11-NEXT:    s_or_b32 s5, s5, s6
; GFX11-NEXT:    s_or_b32 s6, s7, s9
; GFX11-NEXT:    s_and_b32 s7, s20, 0xff
; GFX11-NEXT:    s_lshl_b32 s9, s21, 8
; GFX11-NEXT:    s_and_b32 s10, s22, 0xff
; GFX11-NEXT:    s_lshl_b32 s11, s23, 8
; GFX11-NEXT:    s_or_b32 s7, s7, s9
; GFX11-NEXT:    s_or_b32 s9, s10, s11
; GFX11-NEXT:    s_and_b32 s5, s5, 0xffff
; GFX11-NEXT:    s_lshl_b32 s6, s6, 16
; GFX11-NEXT:    s_and_b32 s7, s7, 0xffff
; GFX11-NEXT:    s_lshl_b32 s9, s9, 16
; GFX11-NEXT:    s_or_b32 s5, s5, s6
; GFX11-NEXT:    s_or_b32 s6, s7, s9
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s8
; GFX11-NEXT:    s_cbranch_vccnz .LBB45_3
; GFX11-NEXT:  .LBB45_2: ; %cmp.true
; GFX11-NEXT:    s_add_i32 s0, s0, 3
; GFX11-NEXT:    s_add_i32 s2, s2, 3
; GFX11-NEXT:    s_and_b32 s0, s0, 0xff
; GFX11-NEXT:    s_lshl_b32 s1, s1, 8
; GFX11-NEXT:    s_and_b32 s2, s2, 0xff
; GFX11-NEXT:    s_lshl_b32 s3, s3, 8
; GFX11-NEXT:    s_or_b32 s0, s1, s0
; GFX11-NEXT:    s_or_b32 s1, s3, s2
; GFX11-NEXT:    s_addk_i32 s0, 0x300
; GFX11-NEXT:    s_addk_i32 s1, 0x300
; GFX11-NEXT:    s_and_b32 s0, s0, 0xffff
; GFX11-NEXT:    s_lshl_b32 s1, s1, 16
; GFX11-NEXT:    s_add_i32 s16, s16, 3
; GFX11-NEXT:    s_or_b32 s4, s0, s1
; GFX11-NEXT:    s_and_b32 s0, s16, 0xff
; GFX11-NEXT:    s_lshl_b32 s1, s17, 8
; GFX11-NEXT:    s_add_i32 s18, s18, 3
; GFX11-NEXT:    s_or_b32 s0, s1, s0
; GFX11-NEXT:    s_and_b32 s1, s18, 0xff
; GFX11-NEXT:    s_lshl_b32 s2, s19, 8
; GFX11-NEXT:    s_add_i32 s20, s20, 3
; GFX11-NEXT:    s_add_i32 s22, s22, 3
; GFX11-NEXT:    s_or_b32 s1, s2, s1
; GFX11-NEXT:    s_and_b32 s2, s20, 0xff
; GFX11-NEXT:    s_lshl_b32 s3, s21, 8
; GFX11-NEXT:    s_and_b32 s5, s22, 0xff
; GFX11-NEXT:    s_lshl_b32 s6, s23, 8
; GFX11-NEXT:    s_or_b32 s2, s3, s2
; GFX11-NEXT:    s_or_b32 s3, s6, s5
; GFX11-NEXT:    s_addk_i32 s0, 0x300
; GFX11-NEXT:    s_addk_i32 s1, 0x300
; GFX11-NEXT:    s_addk_i32 s2, 0x300
; GFX11-NEXT:    s_addk_i32 s3, 0x300
; GFX11-NEXT:    s_and_b32 s0, s0, 0xffff
; GFX11-NEXT:    s_lshl_b32 s1, s1, 16
; GFX11-NEXT:    s_and_b32 s2, s2, 0xffff
; GFX11-NEXT:    s_lshl_b32 s3, s3, 16
; GFX11-NEXT:    s_or_b32 s5, s0, s1
; GFX11-NEXT:    s_or_b32 s6, s2, s3
; GFX11-NEXT:  .LBB45_3: ; %end
; GFX11-NEXT:    v_dual_mov_b32 v0, s4 :: v_dual_mov_b32 v1, s5
; GFX11-NEXT:    v_mov_b32_e32 v2, s6
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB45_4:
; GFX11-NEXT:    ; implicit-def: $sgpr4_sgpr5_sgpr6_sgpr7
; GFX11-NEXT:    s_branch .LBB45_2
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <12 x i8> %a, splat (i8 3)
  %a2 = bitcast <12 x i8> %a1 to <6 x i16>
  br label %end

cmp.false:
  %a3 = bitcast <12 x i8> %a to <6 x i16>
  br label %end

end:
  %phi = phi <6 x i16> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <6 x i16> %phi
}

define <12 x i8> @bitcast_v6i16_to_v12i8(<6 x i16> %a, i32 %b) {
; SI-LABEL: bitcast_v6i16_to_v12i8:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v15, v5
; SI-NEXT:    v_mov_b32_e32 v16, v3
; SI-NEXT:    v_mov_b32_e32 v12, v4
; SI-NEXT:    v_mov_b32_e32 v13, v2
; SI-NEXT:    v_mov_b32_e32 v14, v0
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v6
; SI-NEXT:    v_lshlrev_b32_e32 v19, 16, v1
; SI-NEXT:    v_lshlrev_b32_e32 v18, 16, v16
; SI-NEXT:    v_lshlrev_b32_e32 v17, 16, v15
; SI-NEXT:    ; implicit-def: $vgpr0
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    ; implicit-def: $vgpr4
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    ; implicit-def: $vgpr6
; SI-NEXT:    ; implicit-def: $vgpr7
; SI-NEXT:    ; implicit-def: $vgpr8
; SI-NEXT:    ; implicit-def: $vgpr9
; SI-NEXT:    ; implicit-def: $vgpr10
; SI-NEXT:    ; implicit-def: $vgpr11
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB46_3
; SI-NEXT:  ; %bb.1: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB46_4
; SI-NEXT:  .LBB46_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB46_3: ; %cmp.false
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v14
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v13
; SI-NEXT:    v_and_b32_e32 v6, 0xffff, v12
; SI-NEXT:    v_or_b32_e32 v0, v0, v19
; SI-NEXT:    v_or_b32_e32 v4, v1, v18
; SI-NEXT:    v_or_b32_e32 v8, v6, v17
; SI-NEXT:    v_alignbit_b32 v3, v4, v0, 24
; SI-NEXT:    v_alignbit_b32 v2, v4, v0, 16
; SI-NEXT:    v_alignbit_b32 v1, v4, v0, 8
; SI-NEXT:    v_lshrrev_b32_e32 v5, 8, v4
; SI-NEXT:    v_lshrrev_b32_e32 v9, 8, v8
; SI-NEXT:    v_and_b32_e32 v6, 0xffff, v16
; SI-NEXT:    v_and_b32_e32 v10, 0xffff, v15
; SI-NEXT:    v_bfe_u32 v7, v16, 8, 8
; SI-NEXT:    v_bfe_u32 v11, v15, 8, 8
; SI-NEXT:    ; implicit-def: $vgpr14
; SI-NEXT:    ; implicit-def: $vgpr19
; SI-NEXT:    ; implicit-def: $vgpr13
; SI-NEXT:    ; implicit-def: $vgpr18
; SI-NEXT:    ; implicit-def: $vgpr12
; SI-NEXT:    ; implicit-def: $vgpr17
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB46_2
; SI-NEXT:  .LBB46_4: ; %cmp.true
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v13
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; SI-NEXT:    s_mov_b32 s6, 0x30000
; SI-NEXT:    v_or_b32_e32 v1, v18, v1
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v14
; SI-NEXT:    v_add_i32_e32 v4, vcc, s6, v1
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v12
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; SI-NEXT:    v_or_b32_e32 v0, v19, v0
; SI-NEXT:    v_or_b32_e32 v1, v17, v1
; SI-NEXT:    v_add_i32_e32 v0, vcc, 0x30000, v0
; SI-NEXT:    v_add_i32_e32 v8, vcc, 0x30000, v1
; SI-NEXT:    v_alignbit_b32 v3, v4, v0, 24
; SI-NEXT:    v_alignbit_b32 v2, v4, v0, 16
; SI-NEXT:    v_alignbit_b32 v1, v4, v0, 8
; SI-NEXT:    v_lshrrev_b32_e32 v7, 24, v4
; SI-NEXT:    v_lshrrev_b32_e32 v6, 16, v4
; SI-NEXT:    v_lshrrev_b32_e32 v5, 8, v4
; SI-NEXT:    v_lshrrev_b32_e32 v11, 24, v8
; SI-NEXT:    v_lshrrev_b32_e32 v10, 16, v8
; SI-NEXT:    v_lshrrev_b32_e32 v9, 8, v8
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v6i16_to_v12i8:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v3
; VI-NEXT:    v_lshrrev_b32_e32 v10, 16, v2
; VI-NEXT:    v_lshrrev_b32_e32 v6, 16, v1
; VI-NEXT:    v_lshrrev_b32_e32 v13, 16, v0
; VI-NEXT:    ; implicit-def: $vgpr16
; VI-NEXT:    ; implicit-def: $vgpr15
; VI-NEXT:    ; implicit-def: $vgpr3
; VI-NEXT:    ; implicit-def: $vgpr14
; VI-NEXT:    ; implicit-def: $vgpr5
; VI-NEXT:    ; implicit-def: $vgpr7
; VI-NEXT:    ; implicit-def: $vgpr8
; VI-NEXT:    ; implicit-def: $vgpr9
; VI-NEXT:    ; implicit-def: $vgpr11
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB46_2
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    v_lshrrev_b32_e32 v9, 8, v2
; VI-NEXT:    v_lshrrev_b32_e32 v7, 24, v1
; VI-NEXT:    v_lshrrev_b32_e32 v5, 8, v1
; VI-NEXT:    v_lshrrev_b32_e32 v15, 8, v0
; VI-NEXT:    v_lshrrev_b64 v[11:12], 24, v[2:3]
; VI-NEXT:    v_lshrrev_b64 v[3:4], 24, v[0:1]
; VI-NEXT:    v_mov_b32_e32 v16, v0
; VI-NEXT:    v_mov_b32_e32 v14, v1
; VI-NEXT:    v_mov_b32_e32 v8, v2
; VI-NEXT:    ; implicit-def: $vgpr1
; VI-NEXT:    ; implicit-def: $vgpr2
; VI-NEXT:  .LBB46_2: ; %Flow
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB46_4
; VI-NEXT:  ; %bb.3: ; %cmp.true
; VI-NEXT:    v_mov_b32_e32 v3, 3
; VI-NEXT:    v_add_u16_sdwa v6, v1, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_u16_sdwa v13, v0, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_u16_e32 v14, 3, v1
; VI-NEXT:    v_lshlrev_b32_e32 v1, 16, v6
; VI-NEXT:    v_add_u16_e32 v16, 3, v0
; VI-NEXT:    v_lshlrev_b32_e32 v0, 16, v13
; VI-NEXT:    v_or_b32_e32 v1, v14, v1
; VI-NEXT:    v_or_b32_e32 v0, v16, v0
; VI-NEXT:    v_add_u16_sdwa v10, v2, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_u16_e32 v8, 3, v2
; VI-NEXT:    v_lshlrev_b32_e32 v2, 16, v10
; VI-NEXT:    v_lshrrev_b64 v[3:4], 24, v[0:1]
; VI-NEXT:    v_or_b32_e32 v2, v8, v2
; VI-NEXT:    v_lshrrev_b64 v[11:12], 24, v[2:3]
; VI-NEXT:    v_lshrrev_b32_e32 v9, 8, v2
; VI-NEXT:    v_lshrrev_b32_e32 v5, 8, v1
; VI-NEXT:    v_lshrrev_b32_e32 v15, 8, v0
; VI-NEXT:    v_bfe_u32 v7, v6, 8, 8
; VI-NEXT:  .LBB46_4: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    v_mov_b32_e32 v0, v16
; VI-NEXT:    v_mov_b32_e32 v1, v15
; VI-NEXT:    v_mov_b32_e32 v2, v13
; VI-NEXT:    v_mov_b32_e32 v4, v14
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v6i16_to_v12i8:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v8, v2
; GFX9-NEXT:    v_mov_b32_e32 v14, v1
; GFX9-NEXT:    v_mov_b32_e32 v13, v0
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v3
; GFX9-NEXT:    ; implicit-def: $vgpr1
; GFX9-NEXT:    ; implicit-def: $vgpr2
; GFX9-NEXT:    ; implicit-def: $vgpr3
; GFX9-NEXT:    ; implicit-def: $vgpr5
; GFX9-NEXT:    ; implicit-def: $vgpr6
; GFX9-NEXT:    ; implicit-def: $vgpr7
; GFX9-NEXT:    ; implicit-def: $vgpr9
; GFX9-NEXT:    ; implicit-def: $vgpr10
; GFX9-NEXT:    ; implicit-def: $vgpr11
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB46_2
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    v_lshrrev_b32_e32 v9, 8, v8
; GFX9-NEXT:    v_lshrrev_b32_e32 v10, 16, v8
; GFX9-NEXT:    v_lshrrev_b32_e32 v7, 24, v14
; GFX9-NEXT:    v_lshrrev_b32_e32 v6, 16, v14
; GFX9-NEXT:    v_lshrrev_b32_e32 v5, 8, v14
; GFX9-NEXT:    v_lshrrev_b32_e32 v2, 16, v13
; GFX9-NEXT:    v_lshrrev_b64 v[11:12], 24, v[8:9]
; GFX9-NEXT:    v_lshrrev_b64 v[3:4], 24, v[13:14]
; GFX9-NEXT:    v_lshrrev_b32_e32 v1, 8, v13
; GFX9-NEXT:  .LBB46_2: ; %Flow
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB46_4
; GFX9-NEXT:  ; %bb.3: ; %cmp.true
; GFX9-NEXT:    v_pk_add_u16 v8, v8, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v14, v14, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v13, v13, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_lshrrev_b32_e32 v9, 8, v8
; GFX9-NEXT:    v_lshrrev_b64 v[3:4], 24, v[13:14]
; GFX9-NEXT:    v_lshrrev_b64 v[11:12], 24, v[8:9]
; GFX9-NEXT:    v_lshrrev_b32_e32 v10, 16, v8
; GFX9-NEXT:    v_lshrrev_b32_e32 v7, 24, v14
; GFX9-NEXT:    v_lshrrev_b32_e32 v6, 16, v14
; GFX9-NEXT:    v_lshrrev_b32_e32 v5, 8, v14
; GFX9-NEXT:    v_lshrrev_b32_e32 v2, 16, v13
; GFX9-NEXT:    v_lshrrev_b32_e32 v1, 8, v13
; GFX9-NEXT:  .LBB46_4: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    v_mov_b32_e32 v0, v13
; GFX9-NEXT:    v_mov_b32_e32 v4, v14
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-TRUE16-LABEL: bitcast_v6i16_to_v12i8:
; GFX11-TRUE16:       ; %bb.0:
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-TRUE16-NEXT:    v_dual_mov_b32 v10, v2 :: v_dual_mov_b32 v11, v0
; GFX11-TRUE16-NEXT:    v_mov_b32_e32 v12, v1
; GFX11-TRUE16-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v3
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr1_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr3_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr5_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr7_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr9_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr13_lo16
; GFX11-TRUE16-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-TRUE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-TRUE16-NEXT:  ; %bb.1: ; %cmp.false
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v9, 8, v10
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v7, 24, v12
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v5, 8, v12
; GFX11-TRUE16-NEXT:    v_lshrrev_b64 v[13:14], 24, v[10:11]
; GFX11-TRUE16-NEXT:    v_lshrrev_b64 v[3:4], 24, v[11:12]
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v1, 8, v11
; GFX11-TRUE16-NEXT:  ; %bb.2: ; %Flow
; GFX11-TRUE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-TRUE16-NEXT:    s_cbranch_execz .LBB46_4
; GFX11-TRUE16-NEXT:  ; %bb.3: ; %cmp.true
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v12, v12, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v11, v11, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v10, v10, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v7, 24, v12
; GFX11-TRUE16-NEXT:    v_lshrrev_b64 v[3:4], 24, v[11:12]
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX11-TRUE16-NEXT:    v_lshrrev_b64 v[13:14], 24, v[10:11]
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v9, 8, v10
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v5, 8, v12
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v1, 8, v11
; GFX11-TRUE16-NEXT:  .LBB46_4: ; %end
; GFX11-TRUE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v0.l, v11.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v2.l, v11.h
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v4.l, v12.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v6.l, v12.h
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v8.l, v10.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v10.l, v10.h
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v11.l, v13.l
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-FAKE16-LABEL: bitcast_v6i16_to_v12i8:
; GFX11-FAKE16:       ; %bb.0:
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-FAKE16-NEXT:    v_dual_mov_b32 v8, v2 :: v_dual_mov_b32 v13, v0
; GFX11-FAKE16-NEXT:    v_mov_b32_e32 v14, v1
; GFX11-FAKE16-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v3
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr1
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr2
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr3
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr5
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr6
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr7
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr9
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr10
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr11
; GFX11-FAKE16-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-FAKE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_cbranch_execz .LBB46_2
; GFX11-FAKE16-NEXT:  ; %bb.1: ; %cmp.false
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v9, 8, v8
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v10, 16, v8
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v7, 24, v14
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v6, 16, v14
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v5, 8, v14
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v2, 16, v13
; GFX11-FAKE16-NEXT:    v_lshrrev_b64 v[11:12], 24, v[8:9]
; GFX11-FAKE16-NEXT:    v_lshrrev_b64 v[3:4], 24, v[13:14]
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 8, v13
; GFX11-FAKE16-NEXT:  .LBB46_2: ; %Flow
; GFX11-FAKE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-FAKE16-NEXT:    s_cbranch_execz .LBB46_4
; GFX11-FAKE16-NEXT:  ; %bb.3: ; %cmp.true
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v8, v8, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v14, v14, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v13, v13, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v9, 8, v8
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v10, 16, v8
; GFX11-FAKE16-NEXT:    v_lshrrev_b64 v[3:4], 24, v[13:14]
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v7, 24, v14
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v6, 16, v14
; GFX11-FAKE16-NEXT:    v_lshrrev_b64 v[11:12], 24, v[8:9]
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v5, 8, v14
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v2, 16, v13
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 8, v13
; GFX11-FAKE16-NEXT:  .LBB46_4: ; %end
; GFX11-FAKE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-FAKE16-NEXT:    v_mov_b32_e32 v0, v13
; GFX11-FAKE16-NEXT:    v_mov_b32_e32 v4, v14
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <6 x i16> %a, splat (i16 3)
  %a2 = bitcast <6 x i16> %a1 to <12 x i8>
  br label %end

cmp.false:
  %a3 = bitcast <6 x i16> %a to <12 x i8>
  br label %end

end:
  %phi = phi <12 x i8> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <12 x i8> %phi
}

define inreg <12 x i8> @bitcast_v6i16_to_v12i8_scalar(<6 x i16> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v6i16_to_v12i8_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s22, 0
; SI-NEXT:    s_cbranch_scc0 .LBB47_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_and_b32 s4, s16, 0xffff
; SI-NEXT:    s_lshl_b32 s5, s17, 16
; SI-NEXT:    s_or_b32 s6, s4, s5
; SI-NEXT:    s_and_b32 s4, s18, 0xffff
; SI-NEXT:    s_lshl_b32 s5, s19, 16
; SI-NEXT:    s_or_b32 s7, s4, s5
; SI-NEXT:    s_and_b32 s4, s20, 0xffff
; SI-NEXT:    s_lshl_b32 s5, s21, 16
; SI-NEXT:    v_mov_b32_e32 v0, s6
; SI-NEXT:    s_or_b32 s8, s4, s5
; SI-NEXT:    v_alignbit_b32 v3, s7, v0, 24
; SI-NEXT:    v_alignbit_b32 v2, s7, v0, 16
; SI-NEXT:    v_alignbit_b32 v1, s7, v0, 8
; SI-NEXT:    s_lshr_b32 s9, s7, 8
; SI-NEXT:    s_lshr_b32 s12, s8, 8
; SI-NEXT:    s_and_b32 s10, s19, 0xffff
; SI-NEXT:    s_and_b32 s13, s21, 0xffff
; SI-NEXT:    s_bfe_u32 s11, s19, 0x80008
; SI-NEXT:    s_bfe_u32 s14, s21, 0x80008
; SI-NEXT:    s_cbranch_execnz .LBB47_3
; SI-NEXT:  .LBB47_2: ; %cmp.true
; SI-NEXT:    s_add_i32 s16, s16, 3
; SI-NEXT:    s_and_b32 s4, s16, 0xffff
; SI-NEXT:    s_lshl_b32 s5, s17, 16
; SI-NEXT:    s_or_b32 s4, s5, s4
; SI-NEXT:    s_add_i32 s18, s18, 3
; SI-NEXT:    s_add_i32 s6, s4, 0x30000
; SI-NEXT:    s_and_b32 s4, s18, 0xffff
; SI-NEXT:    s_lshl_b32 s5, s19, 16
; SI-NEXT:    s_or_b32 s4, s5, s4
; SI-NEXT:    s_add_i32 s20, s20, 3
; SI-NEXT:    s_add_i32 s7, s4, 0x30000
; SI-NEXT:    s_and_b32 s4, s20, 0xffff
; SI-NEXT:    s_lshl_b32 s5, s21, 16
; SI-NEXT:    s_or_b32 s4, s5, s4
; SI-NEXT:    s_add_i32 s8, s4, 0x30000
; SI-NEXT:    v_mov_b32_e32 v0, s6
; SI-NEXT:    v_alignbit_b32 v3, s7, v0, 24
; SI-NEXT:    v_alignbit_b32 v2, s7, v0, 16
; SI-NEXT:    v_alignbit_b32 v1, s7, v0, 8
; SI-NEXT:    s_lshr_b32 s11, s7, 24
; SI-NEXT:    s_lshr_b32 s10, s7, 16
; SI-NEXT:    s_lshr_b32 s9, s7, 8
; SI-NEXT:    s_lshr_b32 s14, s8, 24
; SI-NEXT:    s_lshr_b32 s13, s8, 16
; SI-NEXT:    s_lshr_b32 s12, s8, 8
; SI-NEXT:  .LBB47_3: ; %end
; SI-NEXT:    v_mov_b32_e32 v0, s6
; SI-NEXT:    v_mov_b32_e32 v4, s7
; SI-NEXT:    v_mov_b32_e32 v5, s9
; SI-NEXT:    v_mov_b32_e32 v6, s10
; SI-NEXT:    v_mov_b32_e32 v7, s11
; SI-NEXT:    v_mov_b32_e32 v8, s8
; SI-NEXT:    v_mov_b32_e32 v9, s12
; SI-NEXT:    v_mov_b32_e32 v10, s13
; SI-NEXT:    v_mov_b32_e32 v11, s14
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB47_4:
; SI-NEXT:    ; implicit-def: $sgpr6
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    ; implicit-def: $sgpr7
; SI-NEXT:    ; implicit-def: $sgpr9
; SI-NEXT:    ; implicit-def: $sgpr10
; SI-NEXT:    ; implicit-def: $sgpr11
; SI-NEXT:    ; implicit-def: $sgpr8
; SI-NEXT:    ; implicit-def: $sgpr12
; SI-NEXT:    ; implicit-def: $sgpr13
; SI-NEXT:    ; implicit-def: $sgpr14
; SI-NEXT:    s_branch .LBB47_2
;
; VI-LABEL: bitcast_v6i16_to_v12i8_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s19, 0
; VI-NEXT:    s_cbranch_scc0 .LBB47_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_lshr_b32 s19, s16, 8
; VI-NEXT:    s_lshr_b32 s10, s18, 16
; VI-NEXT:    s_lshr_b32 s11, s18, 8
; VI-NEXT:    s_lshr_b32 s12, s17, 24
; VI-NEXT:    s_lshr_b32 s13, s17, 16
; VI-NEXT:    s_lshr_b32 s14, s17, 8
; VI-NEXT:    s_lshr_b32 s15, s16, 16
; VI-NEXT:    s_lshr_b64 s[6:7], s[18:19], 24
; VI-NEXT:    s_lshr_b64 s[4:5], s[16:17], 24
; VI-NEXT:    s_cbranch_execnz .LBB47_3
; VI-NEXT:  .LBB47_2: ; %cmp.true
; VI-NEXT:    s_add_i32 s5, s17, 3
; VI-NEXT:    s_and_b32 s4, s17, 0xffff0000
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_add_i32 s5, s16, 3
; VI-NEXT:    s_add_i32 s17, s4, 0x30000
; VI-NEXT:    s_and_b32 s4, s16, 0xffff0000
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_add_i32 s5, s18, 3
; VI-NEXT:    s_add_i32 s16, s4, 0x30000
; VI-NEXT:    s_and_b32 s4, s18, 0xffff0000
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_add_i32 s18, s4, 0x30000
; VI-NEXT:    s_lshr_b32 s19, s16, 8
; VI-NEXT:    s_lshr_b64 s[4:5], s[16:17], 24
; VI-NEXT:    s_lshr_b32 s10, s18, 16
; VI-NEXT:    s_lshr_b32 s11, s18, 8
; VI-NEXT:    s_lshr_b32 s12, s17, 24
; VI-NEXT:    s_lshr_b32 s13, s17, 16
; VI-NEXT:    s_lshr_b32 s14, s17, 8
; VI-NEXT:    s_lshr_b32 s15, s16, 16
; VI-NEXT:    s_lshr_b64 s[6:7], s[18:19], 24
; VI-NEXT:  .LBB47_3: ; %end
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s19
; VI-NEXT:    v_mov_b32_e32 v2, s15
; VI-NEXT:    v_mov_b32_e32 v3, s4
; VI-NEXT:    v_mov_b32_e32 v4, s17
; VI-NEXT:    v_mov_b32_e32 v5, s14
; VI-NEXT:    v_mov_b32_e32 v6, s13
; VI-NEXT:    v_mov_b32_e32 v7, s12
; VI-NEXT:    v_mov_b32_e32 v8, s18
; VI-NEXT:    v_mov_b32_e32 v9, s11
; VI-NEXT:    v_mov_b32_e32 v10, s10
; VI-NEXT:    v_mov_b32_e32 v11, s6
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB47_4:
; VI-NEXT:    ; implicit-def: $sgpr19
; VI-NEXT:    ; implicit-def: $sgpr15
; VI-NEXT:    ; implicit-def: $sgpr4
; VI-NEXT:    ; implicit-def: $sgpr14
; VI-NEXT:    ; implicit-def: $sgpr13
; VI-NEXT:    ; implicit-def: $sgpr12
; VI-NEXT:    ; implicit-def: $sgpr11
; VI-NEXT:    ; implicit-def: $sgpr10
; VI-NEXT:    ; implicit-def: $sgpr6
; VI-NEXT:    s_branch .LBB47_2
;
; GFX9-LABEL: bitcast_v6i16_to_v12i8_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s19, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB47_3
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_lshr_b32 s19, s16, 8
; GFX9-NEXT:    s_lshr_b32 s10, s18, 16
; GFX9-NEXT:    s_lshr_b32 s11, s18, 8
; GFX9-NEXT:    s_lshr_b32 s12, s17, 24
; GFX9-NEXT:    s_lshr_b32 s13, s17, 16
; GFX9-NEXT:    s_lshr_b32 s15, s17, 8
; GFX9-NEXT:    s_lshr_b32 s14, s16, 16
; GFX9-NEXT:    s_lshr_b64 s[6:7], s[18:19], 24
; GFX9-NEXT:    s_lshr_b64 s[4:5], s[16:17], 24
; GFX9-NEXT:    s_cbranch_execnz .LBB47_4
; GFX9-NEXT:  .LBB47_2: ; %cmp.true
; GFX9-NEXT:    v_pk_add_u16 v8, s18, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v14, s17, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v13, s16, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_lshrrev_b32_e32 v9, 8, v8
; GFX9-NEXT:    v_lshrrev_b64 v[3:4], 24, v[13:14]
; GFX9-NEXT:    v_lshrrev_b64 v[11:12], 24, v[8:9]
; GFX9-NEXT:    v_lshrrev_b32_e32 v10, 16, v8
; GFX9-NEXT:    v_lshrrev_b32_e32 v7, 24, v14
; GFX9-NEXT:    v_lshrrev_b32_e32 v6, 16, v14
; GFX9-NEXT:    v_lshrrev_b32_e32 v5, 8, v14
; GFX9-NEXT:    v_lshrrev_b32_e32 v2, 16, v13
; GFX9-NEXT:    v_lshrrev_b32_e32 v1, 8, v13
; GFX9-NEXT:    s_branch .LBB47_5
; GFX9-NEXT:  .LBB47_3:
; GFX9-NEXT:    ; implicit-def: $sgpr19
; GFX9-NEXT:    ; implicit-def: $sgpr14
; GFX9-NEXT:    ; implicit-def: $sgpr4
; GFX9-NEXT:    ; implicit-def: $sgpr15
; GFX9-NEXT:    ; implicit-def: $sgpr13
; GFX9-NEXT:    ; implicit-def: $sgpr12
; GFX9-NEXT:    ; implicit-def: $sgpr11
; GFX9-NEXT:    ; implicit-def: $sgpr10
; GFX9-NEXT:    ; implicit-def: $sgpr6
; GFX9-NEXT:    s_branch .LBB47_2
; GFX9-NEXT:  .LBB47_4:
; GFX9-NEXT:    v_mov_b32_e32 v13, s16
; GFX9-NEXT:    v_mov_b32_e32 v14, s17
; GFX9-NEXT:    v_mov_b32_e32 v8, s18
; GFX9-NEXT:    v_mov_b32_e32 v1, s19
; GFX9-NEXT:    v_mov_b32_e32 v2, s14
; GFX9-NEXT:    v_mov_b32_e32 v5, s15
; GFX9-NEXT:    v_mov_b32_e32 v6, s13
; GFX9-NEXT:    v_mov_b32_e32 v7, s12
; GFX9-NEXT:    v_mov_b32_e32 v9, s11
; GFX9-NEXT:    v_mov_b32_e32 v10, s10
; GFX9-NEXT:    v_mov_b32_e32 v11, s6
; GFX9-NEXT:    v_mov_b32_e32 v3, s4
; GFX9-NEXT:  .LBB47_5: ; %end
; GFX9-NEXT:    v_mov_b32_e32 v0, v13
; GFX9-NEXT:    v_mov_b32_e32 v4, v14
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v6i16_to_v12i8_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_cmp_lg_u32 s3, 0
; GFX11-NEXT:    s_mov_b32 s3, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB47_3
; GFX11-NEXT:  ; %bb.1: ; %cmp.false
; GFX11-NEXT:    s_lshr_b32 s8, s2, 16
; GFX11-NEXT:    s_lshr_b32 s9, s2, 8
; GFX11-NEXT:    s_lshr_b32 s10, s1, 24
; GFX11-NEXT:    s_lshr_b32 s11, s1, 16
; GFX11-NEXT:    s_lshr_b32 s13, s1, 8
; GFX11-NEXT:    s_lshr_b32 s12, s0, 16
; GFX11-NEXT:    s_lshr_b32 s14, s0, 8
; GFX11-NEXT:    s_lshr_b64 s[6:7], s[2:3], 24
; GFX11-NEXT:    s_lshr_b64 s[4:5], s[0:1], 24
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s3
; GFX11-NEXT:    s_cbranch_vccnz .LBB47_4
; GFX11-NEXT:  .LBB47_2: ; %cmp.true
; GFX11-NEXT:    v_pk_add_u16 v8, s2, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v14, s1, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v13, s0, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_lshrrev_b32_e32 v9, 8, v8
; GFX11-NEXT:    v_lshrrev_b32_e32 v10, 16, v8
; GFX11-NEXT:    v_lshrrev_b64 v[3:4], 24, v[13:14]
; GFX11-NEXT:    v_lshrrev_b32_e32 v7, 24, v14
; GFX11-NEXT:    v_lshrrev_b32_e32 v6, 16, v14
; GFX11-NEXT:    v_lshrrev_b64 v[11:12], 24, v[8:9]
; GFX11-NEXT:    v_lshrrev_b32_e32 v5, 8, v14
; GFX11-NEXT:    v_lshrrev_b32_e32 v2, 16, v13
; GFX11-NEXT:    v_lshrrev_b32_e32 v1, 8, v13
; GFX11-NEXT:    s_branch .LBB47_5
; GFX11-NEXT:  .LBB47_3:
; GFX11-NEXT:    ; implicit-def: $sgpr14
; GFX11-NEXT:    ; implicit-def: $sgpr12
; GFX11-NEXT:    ; implicit-def: $sgpr4
; GFX11-NEXT:    ; implicit-def: $sgpr13
; GFX11-NEXT:    ; implicit-def: $sgpr11
; GFX11-NEXT:    ; implicit-def: $sgpr10
; GFX11-NEXT:    ; implicit-def: $sgpr9
; GFX11-NEXT:    ; implicit-def: $sgpr8
; GFX11-NEXT:    ; implicit-def: $sgpr6
; GFX11-NEXT:    s_branch .LBB47_2
; GFX11-NEXT:  .LBB47_4:
; GFX11-NEXT:    v_dual_mov_b32 v13, s0 :: v_dual_mov_b32 v14, s1
; GFX11-NEXT:    v_dual_mov_b32 v8, s2 :: v_dual_mov_b32 v1, s14
; GFX11-NEXT:    v_dual_mov_b32 v2, s12 :: v_dual_mov_b32 v5, s13
; GFX11-NEXT:    v_dual_mov_b32 v6, s11 :: v_dual_mov_b32 v7, s10
; GFX11-NEXT:    v_dual_mov_b32 v9, s9 :: v_dual_mov_b32 v10, s8
; GFX11-NEXT:    v_mov_b32_e32 v11, s6
; GFX11-NEXT:    v_mov_b32_e32 v3, s4
; GFX11-NEXT:  .LBB47_5: ; %end
; GFX11-NEXT:    v_mov_b32_e32 v0, v13
; GFX11-NEXT:    v_mov_b32_e32 v4, v14
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <6 x i16> %a, splat (i16 3)
  %a2 = bitcast <6 x i16> %a1 to <12 x i8>
  br label %end

cmp.false:
  %a3 = bitcast <6 x i16> %a to <12 x i8>
  br label %end

end:
  %phi = phi <12 x i8> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <12 x i8> %phi
}

define <6 x half> @bitcast_v6bf16_to_v6f16(<6 x bfloat> %a, i32 %b) {
; SI-LABEL: bitcast_v6bf16_to_v6f16:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v6
; SI-NEXT:    v_mul_f32_e32 v6, 1.0, v0
; SI-NEXT:    v_mul_f32_e32 v7, 1.0, v1
; SI-NEXT:    v_mul_f32_e32 v8, 1.0, v2
; SI-NEXT:    v_mul_f32_e32 v9, 1.0, v3
; SI-NEXT:    v_mul_f32_e32 v10, 1.0, v4
; SI-NEXT:    v_mul_f32_e32 v11, 1.0, v5
; SI-NEXT:    ; implicit-def: $vgpr0
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    ; implicit-def: $vgpr4
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB48_3
; SI-NEXT:  ; %bb.1: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB48_4
; SI-NEXT:  .LBB48_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB48_3: ; %cmp.false
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v6
; SI-NEXT:    v_lshrrev_b32_e32 v1, 16, v7
; SI-NEXT:    v_lshrrev_b32_e32 v2, 16, v8
; SI-NEXT:    v_lshrrev_b32_e32 v3, 16, v9
; SI-NEXT:    v_lshrrev_b32_e32 v4, 16, v10
; SI-NEXT:    v_lshrrev_b32_e32 v5, 16, v11
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v3
; SI-NEXT:    v_cvt_f32_f16_e32 v4, v4
; SI-NEXT:    v_cvt_f32_f16_e32 v5, v5
; SI-NEXT:    ; implicit-def: $vgpr11
; SI-NEXT:    ; implicit-def: $vgpr10
; SI-NEXT:    ; implicit-def: $vgpr9
; SI-NEXT:    ; implicit-def: $vgpr8
; SI-NEXT:    ; implicit-def: $vgpr7
; SI-NEXT:    ; implicit-def: $vgpr6
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB48_2
; SI-NEXT:  .LBB48_4: ; %cmp.true
; SI-NEXT:    v_and_b32_e32 v0, 0xffff0000, v11
; SI-NEXT:    v_add_f32_e32 v0, 0x40c00000, v0
; SI-NEXT:    v_lshrrev_b32_e32 v5, 16, v0
; SI-NEXT:    v_and_b32_e32 v0, 0xffff0000, v10
; SI-NEXT:    v_add_f32_e32 v0, 0x40c00000, v0
; SI-NEXT:    v_lshrrev_b32_e32 v4, 16, v0
; SI-NEXT:    v_and_b32_e32 v0, 0xffff0000, v9
; SI-NEXT:    v_add_f32_e32 v0, 0x40c00000, v0
; SI-NEXT:    v_lshrrev_b32_e32 v3, 16, v0
; SI-NEXT:    v_and_b32_e32 v0, 0xffff0000, v8
; SI-NEXT:    v_add_f32_e32 v0, 0x40c00000, v0
; SI-NEXT:    v_lshrrev_b32_e32 v2, 16, v0
; SI-NEXT:    v_and_b32_e32 v0, 0xffff0000, v7
; SI-NEXT:    v_add_f32_e32 v0, 0x40c00000, v0
; SI-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; SI-NEXT:    v_and_b32_e32 v0, 0xffff0000, v6
; SI-NEXT:    v_add_f32_e32 v0, 0x40c00000, v0
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v3
; SI-NEXT:    v_cvt_f32_f16_e32 v4, v4
; SI-NEXT:    v_cvt_f32_f16_e32 v5, v5
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v6bf16_to_v6f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v3
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB48_2
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_lshlrev_b32_e32 v3, 16, v0
; VI-NEXT:    v_add_f32_e32 v3, 0x40c00000, v3
; VI-NEXT:    v_bfe_u32 v4, v3, 16, 1
; VI-NEXT:    v_add_u32_e32 v4, vcc, v4, v3
; VI-NEXT:    v_add_u32_e32 v4, vcc, 0x7fff, v4
; VI-NEXT:    v_and_b32_e32 v0, 0xffff0000, v0
; VI-NEXT:    v_or_b32_e32 v5, 0x400000, v3
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v3, v3
; VI-NEXT:    v_add_f32_e32 v0, 0x40c00000, v0
; VI-NEXT:    v_cndmask_b32_e32 v3, v4, v5, vcc
; VI-NEXT:    v_bfe_u32 v4, v0, 16, 1
; VI-NEXT:    s_movk_i32 s6, 0x7fff
; VI-NEXT:    v_add_u32_e32 v4, vcc, v4, v0
; VI-NEXT:    v_add_u32_e32 v4, vcc, s6, v4
; VI-NEXT:    v_or_b32_e32 v5, 0x400000, v0
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v0, v0
; VI-NEXT:    v_cndmask_b32_e32 v0, v4, v5, vcc
; VI-NEXT:    v_lshlrev_b32_e32 v4, 16, v1
; VI-NEXT:    v_add_f32_e32 v4, 0x40c00000, v4
; VI-NEXT:    v_bfe_u32 v5, v4, 16, 1
; VI-NEXT:    v_add_u32_e32 v5, vcc, v5, v4
; VI-NEXT:    v_add_u32_e32 v5, vcc, s6, v5
; VI-NEXT:    v_and_b32_e32 v1, 0xffff0000, v1
; VI-NEXT:    v_or_b32_e32 v6, 0x400000, v4
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v4, v4
; VI-NEXT:    v_add_f32_e32 v1, 0x40c00000, v1
; VI-NEXT:    v_cndmask_b32_e32 v4, v5, v6, vcc
; VI-NEXT:    v_bfe_u32 v5, v1, 16, 1
; VI-NEXT:    v_add_u32_e32 v5, vcc, v5, v1
; VI-NEXT:    v_add_u32_e32 v5, vcc, s6, v5
; VI-NEXT:    v_or_b32_e32 v6, 0x400000, v1
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; VI-NEXT:    v_cndmask_b32_e32 v1, v5, v6, vcc
; VI-NEXT:    v_lshlrev_b32_e32 v5, 16, v2
; VI-NEXT:    v_add_f32_e32 v5, 0x40c00000, v5
; VI-NEXT:    v_bfe_u32 v6, v5, 16, 1
; VI-NEXT:    v_add_u32_e32 v6, vcc, v6, v5
; VI-NEXT:    v_add_u32_e32 v6, vcc, s6, v6
; VI-NEXT:    v_and_b32_e32 v2, 0xffff0000, v2
; VI-NEXT:    v_or_b32_e32 v7, 0x400000, v5
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v5, v5
; VI-NEXT:    v_add_f32_e32 v2, 0x40c00000, v2
; VI-NEXT:    v_cndmask_b32_e32 v5, v6, v7, vcc
; VI-NEXT:    v_bfe_u32 v6, v2, 16, 1
; VI-NEXT:    v_add_u32_e32 v6, vcc, v6, v2
; VI-NEXT:    v_add_u32_e32 v6, vcc, 0x7fff, v6
; VI-NEXT:    v_or_b32_e32 v7, 0x400000, v2
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; VI-NEXT:    v_cndmask_b32_e32 v2, v6, v7, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; VI-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; VI-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; VI-NEXT:    v_alignbit_b32 v2, v2, v5, 16
; VI-NEXT:    v_alignbit_b32 v1, v1, v4, 16
; VI-NEXT:    v_alignbit_b32 v0, v0, v3, 16
; VI-NEXT:  .LBB48_2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v6bf16_to_v6f16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v3
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB48_2
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_and_b32_e32 v3, 0xffff0000, v0
; GFX9-NEXT:    v_add_f32_e32 v3, 0x40c00000, v3
; GFX9-NEXT:    v_bfe_u32 v4, v3, 16, 1
; GFX9-NEXT:    s_movk_i32 s6, 0x7fff
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX9-NEXT:    v_add3_u32 v4, v4, v3, s6
; GFX9-NEXT:    v_or_b32_e32 v5, 0x400000, v3
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v3, v3
; GFX9-NEXT:    v_add_f32_e32 v0, 0x40c00000, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v3, v4, v5, vcc
; GFX9-NEXT:    v_bfe_u32 v4, v0, 16, 1
; GFX9-NEXT:    v_add3_u32 v4, v4, v0, s6
; GFX9-NEXT:    v_or_b32_e32 v5, 0x400000, v0
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v0, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v4, v5, vcc
; GFX9-NEXT:    v_and_b32_e32 v4, 0xffff0000, v1
; GFX9-NEXT:    v_add_f32_e32 v4, 0x40c00000, v4
; GFX9-NEXT:    v_bfe_u32 v5, v4, 16, 1
; GFX9-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX9-NEXT:    v_add3_u32 v5, v5, v4, s6
; GFX9-NEXT:    v_or_b32_e32 v6, 0x400000, v4
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v4, v4
; GFX9-NEXT:    v_add_f32_e32 v1, 0x40c00000, v1
; GFX9-NEXT:    v_cndmask_b32_e32 v4, v5, v6, vcc
; GFX9-NEXT:    v_bfe_u32 v5, v1, 16, 1
; GFX9-NEXT:    v_add3_u32 v5, v5, v1, s6
; GFX9-NEXT:    v_or_b32_e32 v6, 0x400000, v1
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v5, v6, vcc
; GFX9-NEXT:    v_and_b32_e32 v5, 0xffff0000, v2
; GFX9-NEXT:    v_add_f32_e32 v5, 0x40c00000, v5
; GFX9-NEXT:    v_bfe_u32 v6, v5, 16, 1
; GFX9-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX9-NEXT:    v_add3_u32 v6, v6, v5, s6
; GFX9-NEXT:    v_or_b32_e32 v7, 0x400000, v5
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v5, v5
; GFX9-NEXT:    v_add_f32_e32 v2, 0x40c00000, v2
; GFX9-NEXT:    v_cndmask_b32_e32 v5, v6, v7, vcc
; GFX9-NEXT:    v_bfe_u32 v6, v2, 16, 1
; GFX9-NEXT:    v_add3_u32 v6, v6, v2, s6
; GFX9-NEXT:    v_or_b32_e32 v7, 0x400000, v2
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; GFX9-NEXT:    v_cndmask_b32_e32 v2, v6, v7, vcc
; GFX9-NEXT:    s_mov_b32 s6, 0x7060302
; GFX9-NEXT:    v_perm_b32 v2, v5, v2, s6
; GFX9-NEXT:    v_perm_b32 v1, v4, v1, s6
; GFX9-NEXT:    v_perm_b32 v0, v3, v0, s6
; GFX9-NEXT:  .LBB48_2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-TRUE16-LABEL: bitcast_v6bf16_to_v6f16:
; GFX11-TRUE16:       ; %bb.0:
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-TRUE16-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-TRUE16-NEXT:    v_cmpx_ne_u32_e32 0, v3
; GFX11-TRUE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-TRUE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-TRUE16-NEXT:    s_cbranch_execz .LBB48_2
; GFX11-TRUE16-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v3, 0xffff0000, v0
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v5, 0xffff0000, v2
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-TRUE16-NEXT:    v_dual_add_f32 v3, 0x40c00000, v3 :: v_dual_add_f32 v0, 0x40c00000, v0
; GFX11-TRUE16-NEXT:    v_bfe_u32 v6, v3, 16, 1
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v8, 0x400000, v3
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v3, v3
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_bfe_u32 v7, v0, 16, 1
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v9, 0x400000, v0
; GFX11-TRUE16-NEXT:    v_add3_u32 v6, v6, v3, 0x7fff
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v4, 0xffff0000, v1
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX11-TRUE16-NEXT:    v_add3_u32 v7, v7, v0, 0x7fff
; GFX11-TRUE16-NEXT:    v_cndmask_b32_e32 v3, v6, v8, vcc_lo
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_dual_add_f32 v4, 0x40c00000, v4 :: v_dual_add_f32 v1, 0x40c00000, v1
; GFX11-TRUE16-NEXT:    v_add_f32_e32 v2, 0x40c00000, v2
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v0, v0
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_bfe_u32 v10, v4, 16, 1
; GFX11-TRUE16-NEXT:    v_bfe_u32 v6, v1, 16, 1
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_bfe_u32 v8, v2, 16, 1
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v12, 0x400000, v2
; GFX11-TRUE16-NEXT:    v_cndmask_b32_e32 v0, v7, v9, vcc_lo
; GFX11-TRUE16-NEXT:    v_add3_u32 v7, v10, v4, 0x7fff
; GFX11-TRUE16-NEXT:    v_add3_u32 v6, v6, v1, 0x7fff
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v10, 0x400000, v1
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v1, v1
; GFX11-TRUE16-NEXT:    v_add3_u32 v8, v8, v2, 0x7fff
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v0.l, v0.h
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX11-TRUE16-NEXT:    v_cndmask_b32_e32 v1, v6, v10, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v2, v2
; GFX11-TRUE16-NEXT:    v_bfi_b32 v0, 0xffff, v0, v3
; GFX11-TRUE16-NEXT:    v_dual_cndmask_b32 v2, v8, v12 :: v_dual_add_f32 v5, 0x40c00000, v5
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v9, 0x400000, v4
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v4, v4
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v2.l, v2.h
; GFX11-TRUE16-NEXT:    v_bfe_u32 v11, v5, 16, 1
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v10, 0x400000, v5
; GFX11-TRUE16-NEXT:    v_cndmask_b32_e32 v4, v7, v9, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v5, v5
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v1.l, v1.h
; GFX11-TRUE16-NEXT:    v_add3_u32 v6, v11, v5, 0x7fff
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-TRUE16-NEXT:    v_bfi_b32 v1, 0xffff, v1, v4
; GFX11-TRUE16-NEXT:    v_cndmask_b32_e32 v5, v6, v10, vcc_lo
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-TRUE16-NEXT:    v_bfi_b32 v2, 0xffff, v2, v5
; GFX11-TRUE16-NEXT:  .LBB48_2: ; %end
; GFX11-TRUE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-FAKE16-LABEL: bitcast_v6bf16_to_v6f16:
; GFX11-FAKE16:       ; %bb.0:
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-FAKE16-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-FAKE16-NEXT:    v_cmpx_ne_u32_e32 0, v3
; GFX11-FAKE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-FAKE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-FAKE16-NEXT:    s_cbranch_execz .LBB48_2
; GFX11-FAKE16-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v5, 0xffff0000, v2
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_add_f32_e32 v5, 0x40c00000, v5
; GFX11-FAKE16-NEXT:    v_bfe_u32 v11, v5, 16, 1
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v12, 0x400000, v5
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_add3_u32 v11, v11, v5, 0x7fff
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v4, 0xffff0000, v1
; GFX11-FAKE16-NEXT:    v_add_f32_e32 v4, 0x40c00000, v4
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_bfe_u32 v8, v4, 16, 1
; GFX11-FAKE16-NEXT:    v_add3_u32 v8, v8, v4, 0x7fff
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v3, 0xffff0000, v0
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_dual_add_f32 v3, 0x40c00000, v3 :: v_dual_lshlrev_b32 v0, 16, v0
; GFX11-FAKE16-NEXT:    v_dual_add_f32 v0, 0x40c00000, v0 :: v_dual_lshlrev_b32 v1, 16, v1
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_bfe_u32 v6, v3, 16, 1
; GFX11-FAKE16-NEXT:    v_add_f32_e32 v1, 0x40c00000, v1
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v9, 0x400000, v3
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v3, v3
; GFX11-FAKE16-NEXT:    v_bfe_u32 v7, v0, 16, 1
; GFX11-FAKE16-NEXT:    v_add3_u32 v6, v6, v3, 0x7fff
; GFX11-FAKE16-NEXT:    v_add_f32_e32 v2, 0x40c00000, v2
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v10, 0x400000, v0
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_add3_u32 v7, v7, v0, 0x7fff
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v3, v6, v9, vcc_lo
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v6, 0x400000, v4
; GFX11-FAKE16-NEXT:    v_bfe_u32 v9, v1, 16, 1
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v4, v4
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v13, 0x400000, v2
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v4, v8, v6, vcc_lo
; GFX11-FAKE16-NEXT:    v_add3_u32 v8, v9, v1, 0x7fff
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v9, 0x400000, v1
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v1, v1
; GFX11-FAKE16-NEXT:    v_bfe_u32 v6, v2, 16, 1
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v1, v8, v9, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v5, v5
; GFX11-FAKE16-NEXT:    v_add3_u32 v6, v6, v2, 0x7fff
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v5, v11, v12, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v2, v2
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v2, v6, v13, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v0, v0
; GFX11-FAKE16-NEXT:    v_perm_b32 v2, v5, v2, 0x7060302
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v7, v10, vcc_lo
; GFX11-FAKE16-NEXT:    v_perm_b32 v1, v4, v1, 0x7060302
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_perm_b32 v0, v3, v0, 0x7060302
; GFX11-FAKE16-NEXT:  .LBB48_2: ; %end
; GFX11-FAKE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <6 x bfloat> %a, splat (bfloat 0xR40C0)
  %a2 = bitcast <6 x bfloat> %a1 to <6 x half>
  br label %end

cmp.false:
  %a3 = bitcast <6 x bfloat> %a to <6 x half>
  br label %end

end:
  %phi = phi <6 x half> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <6 x half> %phi
}

define inreg <6 x half> @bitcast_v6bf16_to_v6f16_scalar(<6 x bfloat> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v6bf16_to_v6f16_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s22, 0
; SI-NEXT:    v_mul_f32_e64 v6, 1.0, s16
; SI-NEXT:    v_mul_f32_e64 v7, 1.0, s17
; SI-NEXT:    v_mul_f32_e64 v8, 1.0, s18
; SI-NEXT:    v_mul_f32_e64 v9, 1.0, s19
; SI-NEXT:    v_mul_f32_e64 v10, 1.0, s20
; SI-NEXT:    v_mul_f32_e64 v11, 1.0, s21
; SI-NEXT:    s_cbranch_scc0 .LBB49_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v6
; SI-NEXT:    v_lshrrev_b32_e32 v1, 16, v7
; SI-NEXT:    v_lshrrev_b32_e32 v2, 16, v8
; SI-NEXT:    v_lshrrev_b32_e32 v3, 16, v9
; SI-NEXT:    v_lshrrev_b32_e32 v4, 16, v10
; SI-NEXT:    v_lshrrev_b32_e32 v5, 16, v11
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v3
; SI-NEXT:    v_cvt_f32_f16_e32 v4, v4
; SI-NEXT:    v_cvt_f32_f16_e32 v5, v5
; SI-NEXT:    s_cbranch_execnz .LBB49_3
; SI-NEXT:  .LBB49_2: ; %cmp.true
; SI-NEXT:    v_and_b32_e32 v0, 0xffff0000, v11
; SI-NEXT:    v_add_f32_e32 v0, 0x40c00000, v0
; SI-NEXT:    v_lshrrev_b32_e32 v5, 16, v0
; SI-NEXT:    v_and_b32_e32 v0, 0xffff0000, v10
; SI-NEXT:    v_add_f32_e32 v0, 0x40c00000, v0
; SI-NEXT:    v_lshrrev_b32_e32 v4, 16, v0
; SI-NEXT:    v_and_b32_e32 v0, 0xffff0000, v9
; SI-NEXT:    v_add_f32_e32 v0, 0x40c00000, v0
; SI-NEXT:    v_lshrrev_b32_e32 v3, 16, v0
; SI-NEXT:    v_and_b32_e32 v0, 0xffff0000, v8
; SI-NEXT:    v_add_f32_e32 v0, 0x40c00000, v0
; SI-NEXT:    v_lshrrev_b32_e32 v2, 16, v0
; SI-NEXT:    v_and_b32_e32 v0, 0xffff0000, v7
; SI-NEXT:    v_add_f32_e32 v0, 0x40c00000, v0
; SI-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; SI-NEXT:    v_and_b32_e32 v0, 0xffff0000, v6
; SI-NEXT:    v_add_f32_e32 v0, 0x40c00000, v0
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v3
; SI-NEXT:    v_cvt_f32_f16_e32 v4, v4
; SI-NEXT:    v_cvt_f32_f16_e32 v5, v5
; SI-NEXT:  .LBB49_3: ; %end
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB49_4:
; SI-NEXT:    ; implicit-def: $vgpr0
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    ; implicit-def: $vgpr4
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    s_branch .LBB49_2
;
; VI-LABEL: bitcast_v6bf16_to_v6f16_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s19, 0
; VI-NEXT:    s_cbranch_scc0 .LBB49_3
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB49_4
; VI-NEXT:  .LBB49_2: ; %cmp.true
; VI-NEXT:    s_lshl_b32 s4, s16, 16
; VI-NEXT:    v_mov_b32_e32 v0, 0x40c00000
; VI-NEXT:    v_add_f32_e32 v1, s4, v0
; VI-NEXT:    v_bfe_u32 v2, v1, 16, 1
; VI-NEXT:    v_add_u32_e32 v2, vcc, v2, v1
; VI-NEXT:    v_add_u32_e32 v2, vcc, 0x7fff, v2
; VI-NEXT:    s_and_b32 s4, s16, 0xffff0000
; VI-NEXT:    v_or_b32_e32 v3, 0x400000, v1
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; VI-NEXT:    v_add_f32_e32 v1, s4, v0
; VI-NEXT:    v_cndmask_b32_e32 v3, v2, v3, vcc
; VI-NEXT:    v_bfe_u32 v2, v1, 16, 1
; VI-NEXT:    v_add_u32_e32 v2, vcc, v2, v1
; VI-NEXT:    v_add_u32_e32 v2, vcc, 0x7fff, v2
; VI-NEXT:    v_or_b32_e32 v4, 0x400000, v1
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; VI-NEXT:    v_cndmask_b32_e32 v1, v2, v4, vcc
; VI-NEXT:    s_lshl_b32 s4, s17, 16
; VI-NEXT:    v_lshrrev_b32_e32 v4, 16, v1
; VI-NEXT:    v_add_f32_e32 v1, s4, v0
; VI-NEXT:    v_bfe_u32 v2, v1, 16, 1
; VI-NEXT:    v_add_u32_e32 v2, vcc, v2, v1
; VI-NEXT:    v_add_u32_e32 v2, vcc, 0x7fff, v2
; VI-NEXT:    v_or_b32_e32 v5, 0x400000, v1
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; VI-NEXT:    s_and_b32 s4, s17, 0xffff0000
; VI-NEXT:    v_cndmask_b32_e32 v1, v2, v5, vcc
; VI-NEXT:    v_add_f32_e32 v2, s4, v0
; VI-NEXT:    v_bfe_u32 v5, v2, 16, 1
; VI-NEXT:    v_add_u32_e32 v5, vcc, v5, v2
; VI-NEXT:    v_add_u32_e32 v5, vcc, 0x7fff, v5
; VI-NEXT:    v_or_b32_e32 v6, 0x400000, v2
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; VI-NEXT:    v_cndmask_b32_e32 v2, v5, v6, vcc
; VI-NEXT:    s_lshl_b32 s4, s18, 16
; VI-NEXT:    v_lshrrev_b32_e32 v5, 16, v2
; VI-NEXT:    v_add_f32_e32 v2, s4, v0
; VI-NEXT:    v_bfe_u32 v6, v2, 16, 1
; VI-NEXT:    v_add_u32_e32 v6, vcc, v6, v2
; VI-NEXT:    v_add_u32_e32 v6, vcc, 0x7fff, v6
; VI-NEXT:    s_and_b32 s4, s18, 0xffff0000
; VI-NEXT:    v_or_b32_e32 v7, 0x400000, v2
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; VI-NEXT:    v_add_f32_e32 v0, s4, v0
; VI-NEXT:    v_cndmask_b32_e32 v2, v6, v7, vcc
; VI-NEXT:    v_bfe_u32 v6, v0, 16, 1
; VI-NEXT:    v_add_u32_e32 v6, vcc, v6, v0
; VI-NEXT:    v_add_u32_e32 v6, vcc, 0x7fff, v6
; VI-NEXT:    v_or_b32_e32 v7, 0x400000, v0
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v0, v0
; VI-NEXT:    v_cndmask_b32_e32 v0, v6, v7, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; VI-NEXT:    v_alignbit_b32 v2, v0, v2, 16
; VI-NEXT:    v_alignbit_b32 v1, v5, v1, 16
; VI-NEXT:    v_alignbit_b32 v0, v4, v3, 16
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB49_3:
; VI-NEXT:    s_branch .LBB49_2
; VI-NEXT:  .LBB49_4:
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    v_mov_b32_e32 v2, s18
; VI-NEXT:    v_mov_b32_e32 v3, s19
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v6bf16_to_v6f16_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s19, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB49_3
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB49_4
; GFX9-NEXT:  .LBB49_2: ; %cmp.true
; GFX9-NEXT:    s_pack_lh_b32_b16 s4, 0, s16
; GFX9-NEXT:    v_mov_b32_e32 v0, 0x40c00000
; GFX9-NEXT:    v_add_f32_e32 v1, s4, v0
; GFX9-NEXT:    v_bfe_u32 v2, v1, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v2, v2, v1
; GFX9-NEXT:    v_add_u32_e32 v2, 0x7fff, v2
; GFX9-NEXT:    v_or_b32_e32 v3, 0x400000, v1
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v2, v3, vcc
; GFX9-NEXT:    s_lshl_b32 s4, s16, 16
; GFX9-NEXT:    v_lshrrev_b32_e32 v3, 16, v1
; GFX9-NEXT:    v_add_f32_e32 v1, s4, v0
; GFX9-NEXT:    v_bfe_u32 v2, v1, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v2, v2, v1
; GFX9-NEXT:    s_pack_lh_b32_b16 s4, 0, s17
; GFX9-NEXT:    v_add_u32_e32 v2, 0x7fff, v2
; GFX9-NEXT:    v_or_b32_e32 v4, 0x400000, v1
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; GFX9-NEXT:    v_add_f32_e32 v1, s4, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v4, v2, v4, vcc
; GFX9-NEXT:    v_bfe_u32 v2, v1, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v2, v2, v1
; GFX9-NEXT:    v_add_u32_e32 v2, 0x7fff, v2
; GFX9-NEXT:    v_or_b32_e32 v5, 0x400000, v1
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; GFX9-NEXT:    s_lshl_b32 s4, s17, 16
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v2, v5, vcc
; GFX9-NEXT:    v_add_f32_e32 v2, s4, v0
; GFX9-NEXT:    v_bfe_u32 v5, v2, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v5, v5, v2
; GFX9-NEXT:    s_pack_lh_b32_b16 s4, 0, s18
; GFX9-NEXT:    v_add_u32_e32 v5, 0x7fff, v5
; GFX9-NEXT:    v_or_b32_e32 v6, 0x400000, v2
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; GFX9-NEXT:    v_add_f32_e32 v2, s4, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v5, v5, v6, vcc
; GFX9-NEXT:    v_bfe_u32 v6, v2, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v6, v6, v2
; GFX9-NEXT:    s_lshl_b32 s4, s18, 16
; GFX9-NEXT:    v_add_u32_e32 v6, 0x7fff, v6
; GFX9-NEXT:    v_or_b32_e32 v7, 0x400000, v2
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; GFX9-NEXT:    v_add_f32_e32 v0, s4, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v2, v6, v7, vcc
; GFX9-NEXT:    v_bfe_u32 v6, v0, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v6, v6, v0
; GFX9-NEXT:    v_add_u32_e32 v6, 0x7fff, v6
; GFX9-NEXT:    v_or_b32_e32 v7, 0x400000, v0
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v0, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v6, v7, vcc
; GFX9-NEXT:    v_mov_b32_e32 v6, 0xffff
; GFX9-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX9-NEXT:    v_and_b32_sdwa v0, v6, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX9-NEXT:    v_lshl_or_b32 v2, v2, 16, v0
; GFX9-NEXT:    v_and_b32_sdwa v0, v6, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-NEXT:    v_lshl_or_b32 v1, v1, 16, v0
; GFX9-NEXT:    v_and_b32_sdwa v0, v6, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-NEXT:    v_lshl_or_b32 v0, v3, 16, v0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB49_3:
; GFX9-NEXT:    s_branch .LBB49_2
; GFX9-NEXT:  .LBB49_4:
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-NEXT:    v_mov_b32_e32 v3, s19
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v6bf16_to_v6f16_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_cmp_lg_u32 s3, 0
; GFX11-NEXT:    s_mov_b32 s4, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB49_3
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s4
; GFX11-NEXT:    s_cbranch_vccnz .LBB49_4
; GFX11-NEXT:  .LBB49_2: ; %cmp.true
; GFX11-NEXT:    s_pack_lh_b32_b16 s3, 0, s0
; GFX11-NEXT:    s_lshl_b32 s0, s0, 16
; GFX11-NEXT:    v_add_f32_e64 v0, 0x40c00000, s3
; GFX11-NEXT:    v_add_f32_e64 v2, 0x40c00000, s0
; GFX11-NEXT:    s_pack_lh_b32_b16 s3, 0, s1
; GFX11-NEXT:    s_lshl_b32 s1, s1, 16
; GFX11-NEXT:    s_pack_lh_b32_b16 s4, 0, s2
; GFX11-NEXT:    v_add_f32_e64 v4, 0x40c00000, s1
; GFX11-NEXT:    v_bfe_u32 v6, v2, 16, 1
; GFX11-NEXT:    s_lshl_b32 s2, s2, 16
; GFX11-NEXT:    v_bfe_u32 v1, v0, 16, 1
; GFX11-NEXT:    v_add_f32_e64 v7, 0x40c00000, s2
; GFX11-NEXT:    v_or_b32_e32 v11, 0x400000, v4
; GFX11-NEXT:    v_add_nc_u32_e32 v6, v6, v2
; GFX11-NEXT:    v_or_b32_e32 v9, 0x400000, v2
; GFX11-NEXT:    v_add_f32_e64 v3, 0x40c00000, s3
; GFX11-NEXT:    v_or_b32_e32 v12, 0x400000, v7
; GFX11-NEXT:    v_or_b32_e32 v8, 0x400000, v0
; GFX11-NEXT:    v_add_nc_u32_e32 v6, 0x7fff, v6
; GFX11-NEXT:    v_add_nc_u32_e32 v1, v1, v0
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v0, v0
; GFX11-NEXT:    v_bfe_u32 v10, v3, 16, 1
; GFX11-NEXT:    v_add_f32_e64 v5, 0x40c00000, s4
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_add_nc_u32_e32 v1, 0x7fff, v1
; GFX11-NEXT:    v_add_nc_u32_e32 v10, v10, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_3) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_cndmask_b32_e32 v0, v1, v8, vcc_lo
; GFX11-NEXT:    v_bfe_u32 v1, v4, 16, 1
; GFX11-NEXT:    v_bfe_u32 v8, v7, 16, 1
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v2, v2
; GFX11-NEXT:    v_dual_cndmask_b32 v2, v6, v9 :: v_dual_add_nc_u32 v1, v1, v4
; GFX11-NEXT:    v_add_nc_u32_e32 v6, 0x7fff, v10
; GFX11-NEXT:    v_or_b32_e32 v10, 0x400000, v3
; GFX11-NEXT:    v_add_nc_u32_e32 v8, v8, v7
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_4)
; GFX11-NEXT:    v_add_nc_u32_e32 v1, 0x7fff, v1
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v4, v4
; GFX11-NEXT:    v_bfe_u32 v9, v5, 16, 1
; GFX11-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX11-NEXT:    v_add_nc_u32_e32 v8, 0x7fff, v8
; GFX11-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; GFX11-NEXT:    v_cndmask_b32_e32 v1, v1, v11, vcc_lo
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v7, v7
; GFX11-NEXT:    v_add_nc_u32_e32 v9, v9, v5
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_2) | instid1(VALU_DEP_4)
; GFX11-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX11-NEXT:    v_cndmask_b32_e32 v7, v8, v12, vcc_lo
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v3, v3
; GFX11-NEXT:    v_add_nc_u32_e32 v4, 0x7fff, v9
; GFX11-NEXT:    v_or_b32_e32 v9, 0x400000, v5
; GFX11-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX11-NEXT:    v_cndmask_b32_e32 v3, v6, v10, vcc_lo
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v5, v5
; GFX11-NEXT:    v_lshrrev_b32_e32 v5, 16, v7
; GFX11-NEXT:    v_and_b32_e32 v6, 0xffff, v2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_1) | instid1(VALU_DEP_4)
; GFX11-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; GFX11-NEXT:    v_cndmask_b32_e32 v4, v4, v9, vcc_lo
; GFX11-NEXT:    v_and_b32_e32 v5, 0xffff, v5
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-NEXT:    v_lshl_or_b32 v0, v0, 16, v6
; GFX11-NEXT:    v_lshl_or_b32 v1, v3, 16, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_lshrrev_b32_e32 v4, 16, v4
; GFX11-NEXT:    v_lshl_or_b32 v2, v4, 16, v5
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB49_3:
; GFX11-NEXT:    s_branch .LBB49_2
; GFX11-NEXT:  .LBB49_4:
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <6 x bfloat> %a, splat (bfloat 0xR40C0)
  %a2 = bitcast <6 x bfloat> %a1 to <6 x half>
  br label %end

cmp.false:
  %a3 = bitcast <6 x bfloat> %a to <6 x half>
  br label %end

end:
  %phi = phi <6 x half> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <6 x half> %phi
}

define <6 x bfloat> @bitcast_v6f16_to_v6bf16(<6 x half> %a, i32 %b) {
; SI-LABEL: bitcast_v6f16_to_v6bf16:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v7, v0
; SI-NEXT:    v_cvt_f16_f32_e32 v8, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v9, v2
; SI-NEXT:    v_cvt_f16_f32_e32 v10, v3
; SI-NEXT:    v_cvt_f16_f32_e32 v11, v4
; SI-NEXT:    v_cvt_f16_f32_e32 v12, v5
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v6
; SI-NEXT:    ; implicit-def: $vgpr0
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    ; implicit-def: $vgpr4
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB50_3
; SI-NEXT:  ; %bb.1: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB50_4
; SI-NEXT:  .LBB50_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB50_3: ; %cmp.false
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v7
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v8
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v9
; SI-NEXT:    v_lshlrev_b32_e32 v3, 16, v10
; SI-NEXT:    v_lshlrev_b32_e32 v4, 16, v11
; SI-NEXT:    v_lshlrev_b32_e32 v5, 16, v12
; SI-NEXT:    ; implicit-def: $vgpr12
; SI-NEXT:    ; implicit-def: $vgpr11
; SI-NEXT:    ; implicit-def: $vgpr10
; SI-NEXT:    ; implicit-def: $vgpr9
; SI-NEXT:    ; implicit-def: $vgpr8
; SI-NEXT:    ; implicit-def: $vgpr7
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB50_2
; SI-NEXT:  .LBB50_4: ; %cmp.true
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v12
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v11
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v8
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v7
; SI-NEXT:    v_add_f32_e32 v0, 0x38000000, v0
; SI-NEXT:    v_add_f32_e32 v1, 0x38000000, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v5, v0
; SI-NEXT:    v_cvt_f16_f32_e32 v4, v1
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v10
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v9
; SI-NEXT:    v_add_f32_e32 v2, 0x38000000, v2
; SI-NEXT:    v_add_f32_e32 v3, 0x38000000, v3
; SI-NEXT:    v_add_f32_e32 v0, 0x38000000, v0
; SI-NEXT:    v_add_f32_e32 v1, 0x38000000, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NEXT:    v_cvt_f16_f32_e32 v6, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v7, v0
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v3
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v2
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v6
; SI-NEXT:    v_lshlrev_b32_e32 v3, 16, v7
; SI-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; SI-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v6f16_to_v6bf16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v3
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB50_2
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_mov_b32_e32 v4, 0x200
; VI-NEXT:    v_add_f16_e32 v3, 0x200, v0
; VI-NEXT:    v_add_f16_sdwa v0, v0, v4 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v5, 0x200, v1
; VI-NEXT:    v_add_f16_sdwa v1, v1, v4 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v6, 0x200, v2
; VI-NEXT:    v_add_f16_sdwa v2, v2, v4 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v2, v6, v2
; VI-NEXT:    v_or_b32_e32 v1, v5, v1
; VI-NEXT:    v_or_b32_e32 v0, v3, v0
; VI-NEXT:  .LBB50_2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v6f16_to_v6bf16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v3
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    s_movk_i32 s6, 0x200
; GFX9-NEXT:    v_pk_add_f16 v2, v2, s6 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v1, v1, s6 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v0, v0, s6 op_sel_hi:[1,0]
; GFX9-NEXT:  ; %bb.2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v6f16_to_v6bf16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v3
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_pk_add_f16 v2, 0x200, v2 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v1, 0x200, v1 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v0, 0x200, v0 op_sel_hi:[0,1]
; GFX11-NEXT:  ; %bb.2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <6 x half> %a, splat (half 0xH0200)
  %a2 = bitcast <6 x half> %a1 to <6 x bfloat>
  br label %end

cmp.false:
  %a3 = bitcast <6 x half> %a to <6 x bfloat>
  br label %end

end:
  %phi = phi <6 x bfloat> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <6 x bfloat> %phi
}

define inreg <6 x bfloat> @bitcast_v6f16_to_v6bf16_scalar(<6 x half> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v6f16_to_v6bf16_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v6, s16
; SI-NEXT:    v_cvt_f16_f32_e32 v7, s17
; SI-NEXT:    v_cvt_f16_f32_e32 v8, s18
; SI-NEXT:    v_cvt_f16_f32_e32 v9, s19
; SI-NEXT:    v_cvt_f16_f32_e32 v10, s20
; SI-NEXT:    v_cvt_f16_f32_e32 v11, s21
; SI-NEXT:    s_cmp_lg_u32 s22, 0
; SI-NEXT:    s_cbranch_scc0 .LBB51_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v6
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v7
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v8
; SI-NEXT:    v_lshlrev_b32_e32 v3, 16, v9
; SI-NEXT:    v_lshlrev_b32_e32 v4, 16, v10
; SI-NEXT:    v_lshlrev_b32_e32 v5, 16, v11
; SI-NEXT:    s_cbranch_execnz .LBB51_3
; SI-NEXT:  .LBB51_2: ; %cmp.true
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v11
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v10
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v7
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v6
; SI-NEXT:    v_add_f32_e32 v0, 0x38000000, v0
; SI-NEXT:    v_add_f32_e32 v1, 0x38000000, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v5, v0
; SI-NEXT:    v_cvt_f16_f32_e32 v4, v1
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v9
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v8
; SI-NEXT:    v_add_f32_e32 v2, 0x38000000, v2
; SI-NEXT:    v_add_f32_e32 v3, 0x38000000, v3
; SI-NEXT:    v_add_f32_e32 v0, 0x38000000, v0
; SI-NEXT:    v_add_f32_e32 v1, 0x38000000, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NEXT:    v_cvt_f16_f32_e32 v6, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v7, v0
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v3
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v2
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v6
; SI-NEXT:    v_lshlrev_b32_e32 v3, 16, v7
; SI-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; SI-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; SI-NEXT:  .LBB51_3: ; %end
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB51_4:
; SI-NEXT:    ; implicit-def: $vgpr0
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    ; implicit-def: $vgpr4
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    s_branch .LBB51_2
;
; VI-LABEL: bitcast_v6f16_to_v6bf16_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s19, 0
; VI-NEXT:    s_cbranch_scc0 .LBB51_3
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB51_4
; VI-NEXT:  .LBB51_2: ; %cmp.true
; VI-NEXT:    s_lshr_b32 s4, s16, 16
; VI-NEXT:    v_mov_b32_e32 v1, s4
; VI-NEXT:    s_lshr_b32 s4, s17, 16
; VI-NEXT:    v_mov_b32_e32 v2, s4
; VI-NEXT:    s_lshr_b32 s4, s18, 16
; VI-NEXT:    v_mov_b32_e32 v0, 0x200
; VI-NEXT:    v_mov_b32_e32 v6, s4
; VI-NEXT:    v_add_f16_e32 v3, s16, v0
; VI-NEXT:    v_add_f16_sdwa v4, v1, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v1, s17, v0
; VI-NEXT:    v_add_f16_sdwa v5, v2, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v2, s18, v0
; VI-NEXT:    v_add_f16_sdwa v0, v6, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v2, v2, v0
; VI-NEXT:    v_or_b32_e32 v1, v1, v5
; VI-NEXT:    v_or_b32_e32 v0, v3, v4
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB51_3:
; VI-NEXT:    s_branch .LBB51_2
; VI-NEXT:  .LBB51_4:
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    v_mov_b32_e32 v2, s18
; VI-NEXT:    v_mov_b32_e32 v3, s19
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v6f16_to_v6bf16_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s19, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB51_3
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB51_4
; GFX9-NEXT:  .LBB51_2: ; %cmp.true
; GFX9-NEXT:    v_mov_b32_e32 v0, 0x200
; GFX9-NEXT:    v_pk_add_f16 v2, s18, v0 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v1, s17, v0 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v0, s16, v0 op_sel_hi:[1,0]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB51_3:
; GFX9-NEXT:    s_branch .LBB51_2
; GFX9-NEXT:  .LBB51_4:
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-NEXT:    v_mov_b32_e32 v3, s19
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v6f16_to_v6bf16_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_cmp_lg_u32 s3, 0
; GFX11-NEXT:    s_mov_b32 s4, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB51_3
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s4
; GFX11-NEXT:    s_cbranch_vccnz .LBB51_4
; GFX11-NEXT:  .LBB51_2: ; %cmp.true
; GFX11-NEXT:    v_pk_add_f16 v2, 0x200, s2 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v1, 0x200, s1 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v0, 0x200, s0 op_sel_hi:[0,1]
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB51_3:
; GFX11-NEXT:    s_branch .LBB51_2
; GFX11-NEXT:  .LBB51_4:
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <6 x half> %a, splat (half 0xH0200)
  %a2 = bitcast <6 x half> %a1 to <6 x bfloat>
  br label %end

cmp.false:
  %a3 = bitcast <6 x half> %a to <6 x bfloat>
  br label %end

end:
  %phi = phi <6 x bfloat> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <6 x bfloat> %phi
}

define <6 x i16> @bitcast_v6bf16_to_v6i16(<6 x bfloat> %a, i32 %b) {
; SI-LABEL: bitcast_v6bf16_to_v6i16:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v6
; SI-NEXT:    v_mul_f32_e32 v11, 1.0, v0
; SI-NEXT:    v_mul_f32_e32 v10, 1.0, v1
; SI-NEXT:    v_mul_f32_e32 v7, 1.0, v2
; SI-NEXT:    v_mul_f32_e32 v6, 1.0, v3
; SI-NEXT:    v_mul_f32_e32 v9, 1.0, v4
; SI-NEXT:    v_mul_f32_e32 v8, 1.0, v5
; SI-NEXT:    ; implicit-def: $vgpr0
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    ; implicit-def: $vgpr4
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB52_3
; SI-NEXT:  ; %bb.1: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB52_4
; SI-NEXT:  .LBB52_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB52_3: ; %cmp.false
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v11
; SI-NEXT:    v_lshrrev_b32_e32 v1, 16, v10
; SI-NEXT:    v_lshrrev_b32_e32 v2, 16, v7
; SI-NEXT:    v_lshrrev_b32_e32 v3, 16, v6
; SI-NEXT:    v_lshrrev_b32_e32 v4, 16, v9
; SI-NEXT:    v_lshrrev_b32_e32 v5, 16, v8
; SI-NEXT:    ; implicit-def: $vgpr11
; SI-NEXT:    ; implicit-def: $vgpr10
; SI-NEXT:    ; implicit-def: $vgpr9
; SI-NEXT:    ; implicit-def: $vgpr8
; SI-NEXT:    ; implicit-def: $vgpr7
; SI-NEXT:    ; implicit-def: $vgpr6
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB52_2
; SI-NEXT:  .LBB52_4: ; %cmp.true
; SI-NEXT:    v_and_b32_e32 v1, 0xffff0000, v10
; SI-NEXT:    v_and_b32_e32 v0, 0xffff0000, v11
; SI-NEXT:    v_add_f32_e32 v1, 0x40c00000, v1
; SI-NEXT:    v_add_f32_e32 v0, 0x40c00000, v0
; SI-NEXT:    v_lshrrev_b32_e32 v2, 16, v1
; SI-NEXT:    v_and_b32_e32 v3, 0xffff0000, v8
; SI-NEXT:    v_alignbit_b32 v0, v2, v0, 16
; SI-NEXT:    v_and_b32_e32 v2, 0xffff0000, v9
; SI-NEXT:    v_add_f32_e32 v3, 0x40c00000, v3
; SI-NEXT:    v_add_f32_e32 v2, 0x40c00000, v2
; SI-NEXT:    v_lshrrev_b32_e32 v5, 16, v3
; SI-NEXT:    v_and_b32_e32 v3, 0xffff0000, v6
; SI-NEXT:    v_alignbit_b32 v4, v5, v2, 16
; SI-NEXT:    v_and_b32_e32 v2, 0xffff0000, v7
; SI-NEXT:    v_add_f32_e32 v3, 0x40c00000, v3
; SI-NEXT:    v_add_f32_e32 v2, 0x40c00000, v2
; SI-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; SI-NEXT:    v_alignbit_b32 v2, v3, v2, 16
; SI-NEXT:    v_and_b32_e32 v1, 0xffff0000, v1
; SI-NEXT:    v_alignbit_b32 v1, v2, v1, 16
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v6bf16_to_v6i16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v3
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB52_2
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_lshlrev_b32_e32 v3, 16, v0
; VI-NEXT:    v_add_f32_e32 v3, 0x40c00000, v3
; VI-NEXT:    v_bfe_u32 v4, v3, 16, 1
; VI-NEXT:    v_add_u32_e32 v4, vcc, v4, v3
; VI-NEXT:    v_add_u32_e32 v4, vcc, 0x7fff, v4
; VI-NEXT:    v_and_b32_e32 v0, 0xffff0000, v0
; VI-NEXT:    v_or_b32_e32 v5, 0x400000, v3
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v3, v3
; VI-NEXT:    v_add_f32_e32 v0, 0x40c00000, v0
; VI-NEXT:    v_cndmask_b32_e32 v3, v4, v5, vcc
; VI-NEXT:    v_bfe_u32 v4, v0, 16, 1
; VI-NEXT:    s_movk_i32 s6, 0x7fff
; VI-NEXT:    v_add_u32_e32 v4, vcc, v4, v0
; VI-NEXT:    v_add_u32_e32 v4, vcc, s6, v4
; VI-NEXT:    v_or_b32_e32 v5, 0x400000, v0
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v0, v0
; VI-NEXT:    v_cndmask_b32_e32 v0, v4, v5, vcc
; VI-NEXT:    v_lshlrev_b32_e32 v4, 16, v1
; VI-NEXT:    v_add_f32_e32 v4, 0x40c00000, v4
; VI-NEXT:    v_bfe_u32 v5, v4, 16, 1
; VI-NEXT:    v_add_u32_e32 v5, vcc, v5, v4
; VI-NEXT:    v_add_u32_e32 v5, vcc, s6, v5
; VI-NEXT:    v_and_b32_e32 v1, 0xffff0000, v1
; VI-NEXT:    v_or_b32_e32 v6, 0x400000, v4
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v4, v4
; VI-NEXT:    v_add_f32_e32 v1, 0x40c00000, v1
; VI-NEXT:    v_cndmask_b32_e32 v4, v5, v6, vcc
; VI-NEXT:    v_bfe_u32 v5, v1, 16, 1
; VI-NEXT:    v_add_u32_e32 v5, vcc, v5, v1
; VI-NEXT:    v_add_u32_e32 v5, vcc, s6, v5
; VI-NEXT:    v_or_b32_e32 v6, 0x400000, v1
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; VI-NEXT:    v_cndmask_b32_e32 v1, v5, v6, vcc
; VI-NEXT:    v_lshlrev_b32_e32 v5, 16, v2
; VI-NEXT:    v_add_f32_e32 v5, 0x40c00000, v5
; VI-NEXT:    v_bfe_u32 v6, v5, 16, 1
; VI-NEXT:    v_add_u32_e32 v6, vcc, v6, v5
; VI-NEXT:    v_add_u32_e32 v6, vcc, s6, v6
; VI-NEXT:    v_and_b32_e32 v2, 0xffff0000, v2
; VI-NEXT:    v_or_b32_e32 v7, 0x400000, v5
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v5, v5
; VI-NEXT:    v_add_f32_e32 v2, 0x40c00000, v2
; VI-NEXT:    v_cndmask_b32_e32 v5, v6, v7, vcc
; VI-NEXT:    v_bfe_u32 v6, v2, 16, 1
; VI-NEXT:    v_add_u32_e32 v6, vcc, v6, v2
; VI-NEXT:    v_add_u32_e32 v6, vcc, 0x7fff, v6
; VI-NEXT:    v_or_b32_e32 v7, 0x400000, v2
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; VI-NEXT:    v_cndmask_b32_e32 v2, v6, v7, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; VI-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; VI-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; VI-NEXT:    v_alignbit_b32 v2, v2, v5, 16
; VI-NEXT:    v_alignbit_b32 v1, v1, v4, 16
; VI-NEXT:    v_alignbit_b32 v0, v0, v3, 16
; VI-NEXT:  .LBB52_2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v6bf16_to_v6i16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v3
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB52_2
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_and_b32_e32 v3, 0xffff0000, v0
; GFX9-NEXT:    v_add_f32_e32 v3, 0x40c00000, v3
; GFX9-NEXT:    v_bfe_u32 v4, v3, 16, 1
; GFX9-NEXT:    s_movk_i32 s6, 0x7fff
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX9-NEXT:    v_add3_u32 v4, v4, v3, s6
; GFX9-NEXT:    v_or_b32_e32 v5, 0x400000, v3
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v3, v3
; GFX9-NEXT:    v_add_f32_e32 v0, 0x40c00000, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v3, v4, v5, vcc
; GFX9-NEXT:    v_bfe_u32 v4, v0, 16, 1
; GFX9-NEXT:    v_add3_u32 v4, v4, v0, s6
; GFX9-NEXT:    v_or_b32_e32 v5, 0x400000, v0
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v0, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v4, v5, vcc
; GFX9-NEXT:    v_and_b32_e32 v4, 0xffff0000, v1
; GFX9-NEXT:    v_add_f32_e32 v4, 0x40c00000, v4
; GFX9-NEXT:    v_bfe_u32 v5, v4, 16, 1
; GFX9-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX9-NEXT:    v_add3_u32 v5, v5, v4, s6
; GFX9-NEXT:    v_or_b32_e32 v6, 0x400000, v4
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v4, v4
; GFX9-NEXT:    v_add_f32_e32 v1, 0x40c00000, v1
; GFX9-NEXT:    v_cndmask_b32_e32 v4, v5, v6, vcc
; GFX9-NEXT:    v_bfe_u32 v5, v1, 16, 1
; GFX9-NEXT:    v_add3_u32 v5, v5, v1, s6
; GFX9-NEXT:    v_or_b32_e32 v6, 0x400000, v1
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v5, v6, vcc
; GFX9-NEXT:    v_and_b32_e32 v5, 0xffff0000, v2
; GFX9-NEXT:    v_add_f32_e32 v5, 0x40c00000, v5
; GFX9-NEXT:    v_bfe_u32 v6, v5, 16, 1
; GFX9-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX9-NEXT:    v_add3_u32 v6, v6, v5, s6
; GFX9-NEXT:    v_or_b32_e32 v7, 0x400000, v5
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v5, v5
; GFX9-NEXT:    v_add_f32_e32 v2, 0x40c00000, v2
; GFX9-NEXT:    v_cndmask_b32_e32 v5, v6, v7, vcc
; GFX9-NEXT:    v_bfe_u32 v6, v2, 16, 1
; GFX9-NEXT:    v_add3_u32 v6, v6, v2, s6
; GFX9-NEXT:    v_or_b32_e32 v7, 0x400000, v2
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; GFX9-NEXT:    v_cndmask_b32_e32 v2, v6, v7, vcc
; GFX9-NEXT:    s_mov_b32 s6, 0x7060302
; GFX9-NEXT:    v_perm_b32 v2, v5, v2, s6
; GFX9-NEXT:    v_perm_b32 v1, v4, v1, s6
; GFX9-NEXT:    v_perm_b32 v0, v3, v0, s6
; GFX9-NEXT:  .LBB52_2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-TRUE16-LABEL: bitcast_v6bf16_to_v6i16:
; GFX11-TRUE16:       ; %bb.0:
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-TRUE16-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-TRUE16-NEXT:    v_cmpx_ne_u32_e32 0, v3
; GFX11-TRUE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-TRUE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-TRUE16-NEXT:    s_cbranch_execz .LBB52_2
; GFX11-TRUE16-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v5, 16, v2
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v2, 0xffff0000, v2
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v0
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-TRUE16-NEXT:    v_dual_add_f32 v5, 0x40c00000, v5 :: v_dual_add_f32 v2, 0x40c00000, v2
; GFX11-TRUE16-NEXT:    v_dual_add_f32 v3, 0x40c00000, v3 :: v_dual_lshlrev_b32 v4, 16, v1
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-TRUE16-NEXT:    v_bfe_u32 v11, v5, 16, 1
; GFX11-TRUE16-NEXT:    v_bfe_u32 v12, v2, 16, 1
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_add_f32_e32 v4, 0x40c00000, v4
; GFX11-TRUE16-NEXT:    v_bfe_u32 v6, v3, 16, 1
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v8, 0x400000, v3
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v3, v3
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_bfe_u32 v9, v4, 16, 1
; GFX11-TRUE16-NEXT:    v_add3_u32 v6, v6, v3, 0x7fff
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-TRUE16-NEXT:    v_cndmask_b32_e32 v3, v6, v8, vcc_lo
; GFX11-TRUE16-NEXT:    v_add3_u32 v6, v9, v4, 0x7fff
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v8, 0x400000, v4
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v4, v4
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v1, 0xffff0000, v1
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-TRUE16-NEXT:    v_dual_cndmask_b32 v4, v6, v8 :: v_dual_add_f32 v1, 0x40c00000, v1
; GFX11-TRUE16-NEXT:    v_add3_u32 v8, v11, v5, 0x7fff
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v5, v5
; GFX11-TRUE16-NEXT:    v_add3_u32 v11, v12, v2, 0x7fff
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v12, 0x400000, v2
; GFX11-TRUE16-NEXT:    v_bfe_u32 v9, v1, 16, 1
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v13, 0x400000, v1
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v4, 16, v4
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-TRUE16-NEXT:    v_add3_u32 v6, v9, v1, 0x7fff
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v9, 0x400000, v5
; GFX11-TRUE16-NEXT:    v_dual_cndmask_b32 v5, v8, v9 :: v_dual_and_b32 v0, 0xffff0000, v0
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-TRUE16-NEXT:    v_add_f32_e32 v0, 0x40c00000, v0
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v2, v2
; GFX11-TRUE16-NEXT:    v_bfe_u32 v7, v0, 16, 1
; GFX11-TRUE16-NEXT:    v_cndmask_b32_e32 v2, v11, v12, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v1, v1
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v10, 0x400000, v0
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX11-TRUE16-NEXT:    v_add3_u32 v7, v7, v0, 0x7fff
; GFX11-TRUE16-NEXT:    v_cndmask_b32_e32 v1, v6, v13, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v0, v0
; GFX11-TRUE16-NEXT:    v_cndmask_b32_e32 v0, v7, v10, vcc_lo
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v0.l, v2.h
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v2, 16, v5
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v1.l, v1.h
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v5.l, v0.h
; GFX11-TRUE16-NEXT:    v_lshl_or_b32 v2, v0, 16, v2
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-TRUE16-NEXT:    v_lshl_or_b32 v1, v1, 16, v4
; GFX11-TRUE16-NEXT:    v_lshl_or_b32 v0, v5, 16, v3
; GFX11-TRUE16-NEXT:  .LBB52_2: ; %end
; GFX11-TRUE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-FAKE16-LABEL: bitcast_v6bf16_to_v6i16:
; GFX11-FAKE16:       ; %bb.0:
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-FAKE16-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-FAKE16-NEXT:    v_cmpx_ne_u32_e32 0, v3
; GFX11-FAKE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-FAKE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-FAKE16-NEXT:    s_cbranch_execz .LBB52_2
; GFX11-FAKE16-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v5, 0xffff0000, v2
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_add_f32_e32 v5, 0x40c00000, v5
; GFX11-FAKE16-NEXT:    v_bfe_u32 v11, v5, 16, 1
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v12, 0x400000, v5
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_add3_u32 v11, v11, v5, 0x7fff
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v4, 0xffff0000, v1
; GFX11-FAKE16-NEXT:    v_add_f32_e32 v4, 0x40c00000, v4
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_bfe_u32 v8, v4, 16, 1
; GFX11-FAKE16-NEXT:    v_add3_u32 v8, v8, v4, 0x7fff
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v3, 0xffff0000, v0
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_dual_add_f32 v3, 0x40c00000, v3 :: v_dual_lshlrev_b32 v0, 16, v0
; GFX11-FAKE16-NEXT:    v_dual_add_f32 v0, 0x40c00000, v0 :: v_dual_lshlrev_b32 v1, 16, v1
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_bfe_u32 v6, v3, 16, 1
; GFX11-FAKE16-NEXT:    v_add_f32_e32 v1, 0x40c00000, v1
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v9, 0x400000, v3
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v3, v3
; GFX11-FAKE16-NEXT:    v_bfe_u32 v7, v0, 16, 1
; GFX11-FAKE16-NEXT:    v_add3_u32 v6, v6, v3, 0x7fff
; GFX11-FAKE16-NEXT:    v_add_f32_e32 v2, 0x40c00000, v2
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v10, 0x400000, v0
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_add3_u32 v7, v7, v0, 0x7fff
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v3, v6, v9, vcc_lo
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v6, 0x400000, v4
; GFX11-FAKE16-NEXT:    v_bfe_u32 v9, v1, 16, 1
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v4, v4
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v13, 0x400000, v2
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v4, v8, v6, vcc_lo
; GFX11-FAKE16-NEXT:    v_add3_u32 v8, v9, v1, 0x7fff
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v9, 0x400000, v1
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v1, v1
; GFX11-FAKE16-NEXT:    v_bfe_u32 v6, v2, 16, 1
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v1, v8, v9, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v5, v5
; GFX11-FAKE16-NEXT:    v_add3_u32 v6, v6, v2, 0x7fff
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v5, v11, v12, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v2, v2
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v2, v6, v13, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v0, v0
; GFX11-FAKE16-NEXT:    v_perm_b32 v2, v5, v2, 0x7060302
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v7, v10, vcc_lo
; GFX11-FAKE16-NEXT:    v_perm_b32 v1, v4, v1, 0x7060302
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_perm_b32 v0, v3, v0, 0x7060302
; GFX11-FAKE16-NEXT:  .LBB52_2: ; %end
; GFX11-FAKE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <6 x bfloat> %a, splat (bfloat 0xR40C0)
  %a2 = bitcast <6 x bfloat> %a1 to <6 x i16>
  br label %end

cmp.false:
  %a3 = bitcast <6 x bfloat> %a to <6 x i16>
  br label %end

end:
  %phi = phi <6 x i16> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <6 x i16> %phi
}

define inreg <6 x i16> @bitcast_v6bf16_to_v6i16_scalar(<6 x bfloat> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v6bf16_to_v6i16_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s22, 0
; SI-NEXT:    v_mul_f32_e64 v11, 1.0, s16
; SI-NEXT:    v_mul_f32_e64 v10, 1.0, s17
; SI-NEXT:    v_mul_f32_e64 v7, 1.0, s18
; SI-NEXT:    v_mul_f32_e64 v6, 1.0, s19
; SI-NEXT:    v_mul_f32_e64 v9, 1.0, s20
; SI-NEXT:    v_mul_f32_e64 v8, 1.0, s21
; SI-NEXT:    s_cbranch_scc0 .LBB53_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v11
; SI-NEXT:    v_lshrrev_b32_e32 v1, 16, v10
; SI-NEXT:    v_lshrrev_b32_e32 v2, 16, v7
; SI-NEXT:    v_lshrrev_b32_e32 v3, 16, v6
; SI-NEXT:    v_lshrrev_b32_e32 v4, 16, v9
; SI-NEXT:    v_lshrrev_b32_e32 v5, 16, v8
; SI-NEXT:    s_cbranch_execnz .LBB53_3
; SI-NEXT:  .LBB53_2: ; %cmp.true
; SI-NEXT:    v_and_b32_e32 v1, 0xffff0000, v10
; SI-NEXT:    v_and_b32_e32 v0, 0xffff0000, v11
; SI-NEXT:    v_add_f32_e32 v1, 0x40c00000, v1
; SI-NEXT:    v_add_f32_e32 v0, 0x40c00000, v0
; SI-NEXT:    v_lshrrev_b32_e32 v2, 16, v1
; SI-NEXT:    v_and_b32_e32 v3, 0xffff0000, v8
; SI-NEXT:    v_alignbit_b32 v0, v2, v0, 16
; SI-NEXT:    v_and_b32_e32 v2, 0xffff0000, v9
; SI-NEXT:    v_add_f32_e32 v3, 0x40c00000, v3
; SI-NEXT:    v_add_f32_e32 v2, 0x40c00000, v2
; SI-NEXT:    v_lshrrev_b32_e32 v5, 16, v3
; SI-NEXT:    v_and_b32_e32 v3, 0xffff0000, v6
; SI-NEXT:    v_alignbit_b32 v4, v5, v2, 16
; SI-NEXT:    v_and_b32_e32 v2, 0xffff0000, v7
; SI-NEXT:    v_add_f32_e32 v3, 0x40c00000, v3
; SI-NEXT:    v_add_f32_e32 v2, 0x40c00000, v2
; SI-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; SI-NEXT:    v_alignbit_b32 v2, v3, v2, 16
; SI-NEXT:    v_and_b32_e32 v1, 0xffff0000, v1
; SI-NEXT:    v_alignbit_b32 v1, v2, v1, 16
; SI-NEXT:  .LBB53_3: ; %end
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB53_4:
; SI-NEXT:    ; implicit-def: $vgpr0
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    ; implicit-def: $vgpr4
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    s_branch .LBB53_2
;
; VI-LABEL: bitcast_v6bf16_to_v6i16_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s19, 0
; VI-NEXT:    s_cbranch_scc0 .LBB53_3
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB53_4
; VI-NEXT:  .LBB53_2: ; %cmp.true
; VI-NEXT:    s_lshl_b32 s4, s16, 16
; VI-NEXT:    v_mov_b32_e32 v0, 0x40c00000
; VI-NEXT:    v_add_f32_e32 v1, s4, v0
; VI-NEXT:    v_bfe_u32 v2, v1, 16, 1
; VI-NEXT:    v_add_u32_e32 v2, vcc, v2, v1
; VI-NEXT:    v_add_u32_e32 v2, vcc, 0x7fff, v2
; VI-NEXT:    s_and_b32 s4, s16, 0xffff0000
; VI-NEXT:    v_or_b32_e32 v3, 0x400000, v1
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; VI-NEXT:    v_add_f32_e32 v1, s4, v0
; VI-NEXT:    v_cndmask_b32_e32 v3, v2, v3, vcc
; VI-NEXT:    v_bfe_u32 v2, v1, 16, 1
; VI-NEXT:    v_add_u32_e32 v2, vcc, v2, v1
; VI-NEXT:    v_add_u32_e32 v2, vcc, 0x7fff, v2
; VI-NEXT:    v_or_b32_e32 v4, 0x400000, v1
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; VI-NEXT:    v_cndmask_b32_e32 v1, v2, v4, vcc
; VI-NEXT:    s_lshl_b32 s4, s17, 16
; VI-NEXT:    v_lshrrev_b32_e32 v4, 16, v1
; VI-NEXT:    v_add_f32_e32 v1, s4, v0
; VI-NEXT:    v_bfe_u32 v2, v1, 16, 1
; VI-NEXT:    v_add_u32_e32 v2, vcc, v2, v1
; VI-NEXT:    v_add_u32_e32 v2, vcc, 0x7fff, v2
; VI-NEXT:    v_or_b32_e32 v5, 0x400000, v1
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; VI-NEXT:    s_and_b32 s4, s17, 0xffff0000
; VI-NEXT:    v_cndmask_b32_e32 v1, v2, v5, vcc
; VI-NEXT:    v_add_f32_e32 v2, s4, v0
; VI-NEXT:    v_bfe_u32 v5, v2, 16, 1
; VI-NEXT:    v_add_u32_e32 v5, vcc, v5, v2
; VI-NEXT:    v_add_u32_e32 v5, vcc, 0x7fff, v5
; VI-NEXT:    v_or_b32_e32 v6, 0x400000, v2
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; VI-NEXT:    v_cndmask_b32_e32 v2, v5, v6, vcc
; VI-NEXT:    s_lshl_b32 s4, s18, 16
; VI-NEXT:    v_lshrrev_b32_e32 v5, 16, v2
; VI-NEXT:    v_add_f32_e32 v2, s4, v0
; VI-NEXT:    v_bfe_u32 v6, v2, 16, 1
; VI-NEXT:    v_add_u32_e32 v6, vcc, v6, v2
; VI-NEXT:    v_add_u32_e32 v6, vcc, 0x7fff, v6
; VI-NEXT:    s_and_b32 s4, s18, 0xffff0000
; VI-NEXT:    v_or_b32_e32 v7, 0x400000, v2
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; VI-NEXT:    v_add_f32_e32 v0, s4, v0
; VI-NEXT:    v_cndmask_b32_e32 v2, v6, v7, vcc
; VI-NEXT:    v_bfe_u32 v6, v0, 16, 1
; VI-NEXT:    v_add_u32_e32 v6, vcc, v6, v0
; VI-NEXT:    v_add_u32_e32 v6, vcc, 0x7fff, v6
; VI-NEXT:    v_or_b32_e32 v7, 0x400000, v0
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v0, v0
; VI-NEXT:    v_cndmask_b32_e32 v0, v6, v7, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; VI-NEXT:    v_alignbit_b32 v2, v0, v2, 16
; VI-NEXT:    v_alignbit_b32 v1, v5, v1, 16
; VI-NEXT:    v_alignbit_b32 v0, v4, v3, 16
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB53_3:
; VI-NEXT:    s_branch .LBB53_2
; VI-NEXT:  .LBB53_4:
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    v_mov_b32_e32 v2, s18
; VI-NEXT:    v_mov_b32_e32 v3, s19
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v6bf16_to_v6i16_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s19, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB53_3
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB53_4
; GFX9-NEXT:  .LBB53_2: ; %cmp.true
; GFX9-NEXT:    s_pack_lh_b32_b16 s4, 0, s16
; GFX9-NEXT:    v_mov_b32_e32 v0, 0x40c00000
; GFX9-NEXT:    v_add_f32_e32 v1, s4, v0
; GFX9-NEXT:    v_bfe_u32 v2, v1, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v2, v2, v1
; GFX9-NEXT:    s_lshl_b32 s4, s16, 16
; GFX9-NEXT:    v_add_u32_e32 v2, 0x7fff, v2
; GFX9-NEXT:    v_or_b32_e32 v3, 0x400000, v1
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; GFX9-NEXT:    v_add_f32_e32 v1, s4, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v3, v2, v3, vcc
; GFX9-NEXT:    v_bfe_u32 v2, v1, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v2, v2, v1
; GFX9-NEXT:    s_pack_lh_b32_b16 s4, 0, s17
; GFX9-NEXT:    v_add_u32_e32 v2, 0x7fff, v2
; GFX9-NEXT:    v_or_b32_e32 v4, 0x400000, v1
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; GFX9-NEXT:    v_add_f32_e32 v1, s4, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v4, v2, v4, vcc
; GFX9-NEXT:    v_bfe_u32 v2, v1, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v2, v2, v1
; GFX9-NEXT:    v_add_u32_e32 v2, 0x7fff, v2
; GFX9-NEXT:    v_or_b32_e32 v5, 0x400000, v1
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; GFX9-NEXT:    s_lshl_b32 s4, s17, 16
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v2, v5, vcc
; GFX9-NEXT:    v_add_f32_e32 v2, s4, v0
; GFX9-NEXT:    v_bfe_u32 v5, v2, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v5, v5, v2
; GFX9-NEXT:    s_pack_lh_b32_b16 s4, 0, s18
; GFX9-NEXT:    v_add_u32_e32 v5, 0x7fff, v5
; GFX9-NEXT:    v_or_b32_e32 v6, 0x400000, v2
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; GFX9-NEXT:    v_add_f32_e32 v2, s4, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v5, v5, v6, vcc
; GFX9-NEXT:    v_bfe_u32 v6, v2, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v6, v6, v2
; GFX9-NEXT:    s_lshl_b32 s4, s18, 16
; GFX9-NEXT:    v_add_u32_e32 v6, 0x7fff, v6
; GFX9-NEXT:    v_or_b32_e32 v7, 0x400000, v2
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; GFX9-NEXT:    v_add_f32_e32 v0, s4, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v2, v6, v7, vcc
; GFX9-NEXT:    v_bfe_u32 v6, v0, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v6, v6, v0
; GFX9-NEXT:    v_add_u32_e32 v6, 0x7fff, v6
; GFX9-NEXT:    v_or_b32_e32 v7, 0x400000, v0
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v0, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v6, v7, vcc
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; GFX9-NEXT:    v_mov_b32_e32 v6, 0xffff0000
; GFX9-NEXT:    v_and_or_b32 v2, v2, v6, v0
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 16, v5
; GFX9-NEXT:    v_and_or_b32 v1, v1, v6, v0
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 16, v4
; GFX9-NEXT:    v_and_or_b32 v0, v3, v6, v0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB53_3:
; GFX9-NEXT:    s_branch .LBB53_2
; GFX9-NEXT:  .LBB53_4:
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-NEXT:    v_mov_b32_e32 v3, s19
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v6bf16_to_v6i16_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_cmp_lg_u32 s3, 0
; GFX11-NEXT:    s_mov_b32 s4, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB53_3
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s4
; GFX11-NEXT:    s_cbranch_vccnz .LBB53_4
; GFX11-NEXT:  .LBB53_2: ; %cmp.true
; GFX11-NEXT:    s_pack_lh_b32_b16 s3, 0, s0
; GFX11-NEXT:    s_lshl_b32 s0, s0, 16
; GFX11-NEXT:    v_add_f32_e64 v0, 0x40c00000, s3
; GFX11-NEXT:    v_add_f32_e64 v1, 0x40c00000, s0
; GFX11-NEXT:    s_pack_lh_b32_b16 s3, 0, s1
; GFX11-NEXT:    s_lshl_b32 s1, s1, 16
; GFX11-NEXT:    v_add_f32_e64 v3, 0x40c00000, s3
; GFX11-NEXT:    v_bfe_u32 v2, v0, 16, 1
; GFX11-NEXT:    v_bfe_u32 v4, v1, 16, 1
; GFX11-NEXT:    v_or_b32_e32 v9, 0x400000, v1
; GFX11-NEXT:    s_pack_lh_b32_b16 s0, 0, s2
; GFX11-NEXT:    s_lshl_b32 s2, s2, 16
; GFX11-NEXT:    v_add_f32_e64 v5, 0x40c00000, s1
; GFX11-NEXT:    v_add_nc_u32_e32 v4, v4, v1
; GFX11-NEXT:    v_add_f32_e64 v6, 0x40c00000, s2
; GFX11-NEXT:    v_bfe_u32 v7, v3, 16, 1
; GFX11-NEXT:    v_or_b32_e32 v8, 0x400000, v0
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v0, v0
; GFX11-NEXT:    v_add_nc_u32_e32 v4, 0x7fff, v4
; GFX11-NEXT:    v_add_nc_u32_e32 v2, v2, v0
; GFX11-NEXT:    v_bfe_u32 v10, v6, 16, 1
; GFX11-NEXT:    v_or_b32_e32 v11, 0x400000, v5
; GFX11-NEXT:    v_or_b32_e32 v12, 0x400000, v6
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_nc_u32_e32 v2, 0x7fff, v2
; GFX11-NEXT:    v_dual_cndmask_b32 v0, v2, v8 :: v_dual_add_nc_u32 v7, v7, v3
; GFX11-NEXT:    v_bfe_u32 v2, v5, 16, 1
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v1, v1
; GFX11-NEXT:    v_add_f32_e64 v8, 0x40c00000, s0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_4)
; GFX11-NEXT:    v_dual_cndmask_b32 v1, v4, v9 :: v_dual_add_nc_u32 v4, 0x7fff, v7
; GFX11-NEXT:    v_add_nc_u32_e32 v9, v10, v6
; GFX11-NEXT:    v_or_b32_e32 v10, 0x400000, v3
; GFX11-NEXT:    v_add_nc_u32_e32 v2, v2, v5
; GFX11-NEXT:    v_bfe_u32 v7, v8, 16, 1
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v5, v5
; GFX11-NEXT:    v_add_nc_u32_e32 v9, 0x7fff, v9
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_nc_u32_e32 v2, 0x7fff, v2
; GFX11-NEXT:    v_dual_cndmask_b32 v2, v2, v11 :: v_dual_add_nc_u32 v7, v7, v8
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v6, v6
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-NEXT:    v_add_nc_u32_e32 v5, 0x7fff, v7
; GFX11-NEXT:    v_or_b32_e32 v7, 0x400000, v8
; GFX11-NEXT:    v_cndmask_b32_e32 v6, v9, v12, vcc_lo
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v3, v3
; GFX11-NEXT:    v_cndmask_b32_e32 v3, v4, v10, vcc_lo
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v8, v8
; GFX11-NEXT:    v_cndmask_b32_e32 v4, v5, v7, vcc_lo
; GFX11-NEXT:    v_lshrrev_b32_e32 v5, 16, v6
; GFX11-NEXT:    v_lshrrev_b32_e32 v6, 16, v2
; GFX11-NEXT:    v_lshrrev_b32_e32 v7, 16, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_and_or_b32 v2, 0xffff0000, v4, v5
; GFX11-NEXT:    v_and_or_b32 v1, 0xffff0000, v3, v6
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX11-NEXT:    v_and_or_b32 v0, 0xffff0000, v0, v7
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB53_3:
; GFX11-NEXT:    s_branch .LBB53_2
; GFX11-NEXT:  .LBB53_4:
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <6 x bfloat> %a, splat (bfloat 0xR40C0)
  %a2 = bitcast <6 x bfloat> %a1 to <6 x i16>
  br label %end

cmp.false:
  %a3 = bitcast <6 x bfloat> %a to <6 x i16>
  br label %end

end:
  %phi = phi <6 x i16> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <6 x i16> %phi
}

define <6 x bfloat> @bitcast_v6i16_to_v6bf16(<6 x i16> %a, i32 %b) {
; SI-LABEL: bitcast_v6i16_to_v6bf16:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v9, v4
; SI-NEXT:    v_mov_b32_e32 v7, v2
; SI-NEXT:    v_mov_b32_e32 v8, v0
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v6
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; SI-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; SI-NEXT:    ; implicit-def: $vgpr0
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    ; implicit-def: $vgpr4
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB54_3
; SI-NEXT:  ; %bb.1: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB54_4
; SI-NEXT:  .LBB54_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB54_3: ; %cmp.false
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v8
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v7
; SI-NEXT:    v_lshlrev_b32_e32 v4, 16, v9
; SI-NEXT:    ; implicit-def: $vgpr9
; SI-NEXT:    ; implicit-def: $vgpr7
; SI-NEXT:    ; implicit-def: $vgpr8
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB54_2
; SI-NEXT:  .LBB54_4: ; %cmp.true
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v9
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v0, v5, v0
; SI-NEXT:    v_add_i32_e32 v4, vcc, 0x30000, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v7
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v0, v3, v0
; SI-NEXT:    v_add_i32_e32 v2, vcc, 0x30000, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v8
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 0x30000, v0
; SI-NEXT:    v_and_b32_e32 v1, 0xffff0000, v0
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; SI-NEXT:    v_and_b32_e32 v3, 0xffff0000, v2
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_and_b32_e32 v5, 0xffff0000, v4
; SI-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v6i16_to_v6bf16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v3
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB54_2
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_mov_b32_e32 v3, 3
; VI-NEXT:    v_add_u16_sdwa v4, v0, v3 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_u16_sdwa v5, v1, v3 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_u16_sdwa v3, v2, v3 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_u16_e32 v2, 3, v2
; VI-NEXT:    v_add_u16_e32 v1, 3, v1
; VI-NEXT:    v_add_u16_e32 v0, 3, v0
; VI-NEXT:    v_or_b32_e32 v2, v2, v3
; VI-NEXT:    v_or_b32_e32 v1, v1, v5
; VI-NEXT:    v_or_b32_e32 v0, v0, v4
; VI-NEXT:  .LBB54_2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v6i16_to_v6bf16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v3
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_pk_add_u16 v2, v2, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v1, v1, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v0, v0, 3 op_sel_hi:[1,0]
; GFX9-NEXT:  ; %bb.2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v6i16_to_v6bf16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v3
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_pk_add_u16 v2, v2, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v1, v1, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v0, v0, 3 op_sel_hi:[1,0]
; GFX11-NEXT:  ; %bb.2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <6 x i16> %a, splat (i16 3)
  %a2 = bitcast <6 x i16> %a1 to <6 x bfloat>
  br label %end

cmp.false:
  %a3 = bitcast <6 x i16> %a to <6 x bfloat>
  br label %end

end:
  %phi = phi <6 x bfloat> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <6 x bfloat> %phi
}

define inreg <6 x bfloat> @bitcast_v6i16_to_v6bf16_scalar(<6 x i16> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v6i16_to_v6bf16_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s22, 0
; SI-NEXT:    s_cbranch_scc0 .LBB55_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_lshl_b32 s6, s16, 16
; SI-NEXT:    s_lshl_b32 s7, s17, 16
; SI-NEXT:    s_lshl_b32 s8, s18, 16
; SI-NEXT:    s_lshl_b32 s9, s19, 16
; SI-NEXT:    s_lshl_b32 s11, s20, 16
; SI-NEXT:    s_lshl_b32 s10, s21, 16
; SI-NEXT:    s_cbranch_execnz .LBB55_3
; SI-NEXT:  .LBB55_2: ; %cmp.true
; SI-NEXT:    s_add_i32 s20, s20, 3
; SI-NEXT:    s_and_b32 s4, s20, 0xffff
; SI-NEXT:    s_lshl_b32 s5, s21, 16
; SI-NEXT:    s_add_i32 s18, s18, 3
; SI-NEXT:    s_or_b32 s4, s5, s4
; SI-NEXT:    s_and_b32 s5, s18, 0xffff
; SI-NEXT:    s_lshl_b32 s6, s19, 16
; SI-NEXT:    s_add_i32 s16, s16, 3
; SI-NEXT:    s_or_b32 s5, s6, s5
; SI-NEXT:    s_and_b32 s6, s16, 0xffff
; SI-NEXT:    s_lshl_b32 s7, s17, 16
; SI-NEXT:    s_or_b32 s6, s7, s6
; SI-NEXT:    s_add_i32 s4, s4, 0x30000
; SI-NEXT:    s_add_i32 s5, s5, 0x30000
; SI-NEXT:    s_add_i32 s6, s6, 0x30000
; SI-NEXT:    s_and_b32 s7, s6, 0xffff0000
; SI-NEXT:    s_lshl_b32 s6, s6, 16
; SI-NEXT:    s_and_b32 s9, s5, 0xffff0000
; SI-NEXT:    s_lshl_b32 s8, s5, 16
; SI-NEXT:    s_and_b32 s10, s4, 0xffff0000
; SI-NEXT:    s_lshl_b32 s11, s4, 16
; SI-NEXT:  .LBB55_3: ; %end
; SI-NEXT:    v_mov_b32_e32 v0, s6
; SI-NEXT:    v_mov_b32_e32 v1, s7
; SI-NEXT:    v_mov_b32_e32 v2, s8
; SI-NEXT:    v_mov_b32_e32 v3, s9
; SI-NEXT:    v_mov_b32_e32 v4, s11
; SI-NEXT:    v_mov_b32_e32 v5, s10
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB55_4:
; SI-NEXT:    ; implicit-def: $sgpr6
; SI-NEXT:    ; implicit-def: $sgpr7
; SI-NEXT:    ; implicit-def: $sgpr8
; SI-NEXT:    ; implicit-def: $sgpr9
; SI-NEXT:    ; implicit-def: $sgpr11
; SI-NEXT:    ; implicit-def: $sgpr10
; SI-NEXT:    s_branch .LBB55_2
;
; VI-LABEL: bitcast_v6i16_to_v6bf16_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s19, 0
; VI-NEXT:    s_cbranch_scc0 .LBB55_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB55_3
; VI-NEXT:  .LBB55_2: ; %cmp.true
; VI-NEXT:    s_add_i32 s5, s16, 3
; VI-NEXT:    s_add_i32 s7, s17, 3
; VI-NEXT:    s_add_i32 s9, s18, 3
; VI-NEXT:    s_and_b32 s4, s16, 0xffff0000
; VI-NEXT:    s_and_b32 s6, s17, 0xffff0000
; VI-NEXT:    s_and_b32 s8, s18, 0xffff0000
; VI-NEXT:    s_and_b32 s9, s9, 0xffff
; VI-NEXT:    s_and_b32 s7, s7, 0xffff
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_or_b32 s8, s8, s9
; VI-NEXT:    s_or_b32 s6, s6, s7
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_add_i32 s18, s8, 0x30000
; VI-NEXT:    s_add_i32 s17, s6, 0x30000
; VI-NEXT:    s_add_i32 s16, s4, 0x30000
; VI-NEXT:  .LBB55_3: ; %end
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    v_mov_b32_e32 v2, s18
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB55_4:
; VI-NEXT:    s_branch .LBB55_2
;
; GFX9-LABEL: bitcast_v6i16_to_v6bf16_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s19, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB55_3
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB55_4
; GFX9-NEXT:  .LBB55_2: ; %cmp.true
; GFX9-NEXT:    v_pk_add_u16 v2, s18, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v1, s17, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v0, s16, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB55_3:
; GFX9-NEXT:    s_branch .LBB55_2
; GFX9-NEXT:  .LBB55_4:
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-NEXT:    v_mov_b32_e32 v3, s19
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v6i16_to_v6bf16_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_cmp_lg_u32 s3, 0
; GFX11-NEXT:    s_mov_b32 s4, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB55_3
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s4
; GFX11-NEXT:    s_cbranch_vccnz .LBB55_4
; GFX11-NEXT:  .LBB55_2: ; %cmp.true
; GFX11-NEXT:    v_pk_add_u16 v2, s2, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v1, s1, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v0, s0, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB55_3:
; GFX11-NEXT:    s_branch .LBB55_2
; GFX11-NEXT:  .LBB55_4:
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <6 x i16> %a, splat (i16 3)
  %a2 = bitcast <6 x i16> %a1 to <6 x bfloat>
  br label %end

cmp.false:
  %a3 = bitcast <6 x i16> %a to <6 x bfloat>
  br label %end

end:
  %phi = phi <6 x bfloat> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <6 x bfloat> %phi
}

define <6 x i16> @bitcast_v6f16_to_v6i16(<6 x half> %a, i32 %b) {
; SI-LABEL: bitcast_v6f16_to_v6i16:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; SI-NEXT:    v_cvt_f16_f32_e32 v4, v4
; SI-NEXT:    v_cvt_f16_f32_e32 v5, v5
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v6
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB56_2
; SI-NEXT:  ; %bb.1: ; %cmp.true
; SI-NEXT:    v_cvt_f32_f16_e32 v5, v5
; SI-NEXT:    v_cvt_f32_f16_e32 v4, v4
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v3
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NEXT:    v_add_f32_e32 v5, 0x38000000, v5
; SI-NEXT:    v_cvt_f16_f32_e32 v5, v5
; SI-NEXT:    v_add_f32_e32 v4, 0x38000000, v4
; SI-NEXT:    v_add_f32_e32 v3, 0x38000000, v3
; SI-NEXT:    v_add_f32_e32 v1, 0x38000000, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v4, v4
; SI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; SI-NEXT:    v_add_f32_e32 v2, 0x38000000, v2
; SI-NEXT:    v_add_f32_e32 v0, 0x38000000, v0
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-NEXT:    v_lshlrev_b32_e32 v6, 16, v5
; SI-NEXT:    v_or_b32_e32 v4, v4, v6
; SI-NEXT:    v_lshlrev_b32_e32 v6, 16, v3
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_or_b32_e32 v2, v2, v6
; SI-NEXT:    v_or_b32_e32 v0, v0, v1
; SI-NEXT:    v_alignbit_b32 v1, v2, v1, 16
; SI-NEXT:  .LBB56_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v6f16_to_v6i16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v3
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB56_2
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_mov_b32_e32 v4, 0x200
; VI-NEXT:    v_add_f16_e32 v3, 0x200, v0
; VI-NEXT:    v_add_f16_sdwa v0, v0, v4 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v5, 0x200, v1
; VI-NEXT:    v_add_f16_sdwa v1, v1, v4 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v6, 0x200, v2
; VI-NEXT:    v_add_f16_sdwa v2, v2, v4 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v2, v6, v2
; VI-NEXT:    v_or_b32_e32 v1, v5, v1
; VI-NEXT:    v_or_b32_e32 v0, v3, v0
; VI-NEXT:  .LBB56_2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v6f16_to_v6i16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v3
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    s_movk_i32 s6, 0x200
; GFX9-NEXT:    v_pk_add_f16 v2, v2, s6 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v1, v1, s6 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v0, v0, s6 op_sel_hi:[1,0]
; GFX9-NEXT:  ; %bb.2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v6f16_to_v6i16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v3
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_pk_add_f16 v2, 0x200, v2 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v1, 0x200, v1 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v0, 0x200, v0 op_sel_hi:[0,1]
; GFX11-NEXT:  ; %bb.2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <6 x half> %a, splat (half 0xH0200)
  %a2 = bitcast <6 x half> %a1 to <6 x i16>
  br label %end

cmp.false:
  %a3 = bitcast <6 x half> %a to <6 x i16>
  br label %end

end:
  %phi = phi <6 x i16> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <6 x i16> %phi
}

define inreg <6 x i16> @bitcast_v6f16_to_v6i16_scalar(<6 x half> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v6f16_to_v6i16_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v0, s16
; SI-NEXT:    v_cvt_f16_f32_e32 v1, s17
; SI-NEXT:    v_cvt_f16_f32_e32 v2, s18
; SI-NEXT:    v_cvt_f16_f32_e32 v3, s19
; SI-NEXT:    v_cvt_f16_f32_e32 v4, s20
; SI-NEXT:    v_cvt_f16_f32_e32 v5, s21
; SI-NEXT:    s_cmp_lg_u32 s22, 0
; SI-NEXT:    s_cbranch_scc0 .LBB57_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_cbranch_execnz .LBB57_3
; SI-NEXT:  .LBB57_2: ; %cmp.true
; SI-NEXT:    v_cvt_f32_f16_e32 v5, v5
; SI-NEXT:    v_cvt_f32_f16_e32 v4, v4
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v3
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NEXT:    v_add_f32_e32 v5, 0x38000000, v5
; SI-NEXT:    v_cvt_f16_f32_e32 v5, v5
; SI-NEXT:    v_add_f32_e32 v4, 0x38000000, v4
; SI-NEXT:    v_add_f32_e32 v3, 0x38000000, v3
; SI-NEXT:    v_add_f32_e32 v1, 0x38000000, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v4, v4
; SI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; SI-NEXT:    v_add_f32_e32 v2, 0x38000000, v2
; SI-NEXT:    v_add_f32_e32 v0, 0x38000000, v0
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-NEXT:    v_lshlrev_b32_e32 v6, 16, v5
; SI-NEXT:    v_or_b32_e32 v4, v4, v6
; SI-NEXT:    v_lshlrev_b32_e32 v6, 16, v3
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_or_b32_e32 v2, v2, v6
; SI-NEXT:    v_or_b32_e32 v0, v0, v1
; SI-NEXT:    v_alignbit_b32 v1, v2, v1, 16
; SI-NEXT:  .LBB57_3: ; %end
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB57_4:
; SI-NEXT:    s_branch .LBB57_2
;
; VI-LABEL: bitcast_v6f16_to_v6i16_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s19, 0
; VI-NEXT:    s_cbranch_scc0 .LBB57_3
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB57_4
; VI-NEXT:  .LBB57_2: ; %cmp.true
; VI-NEXT:    s_lshr_b32 s4, s16, 16
; VI-NEXT:    v_mov_b32_e32 v1, s4
; VI-NEXT:    s_lshr_b32 s4, s17, 16
; VI-NEXT:    v_mov_b32_e32 v2, s4
; VI-NEXT:    s_lshr_b32 s4, s18, 16
; VI-NEXT:    v_mov_b32_e32 v0, 0x200
; VI-NEXT:    v_mov_b32_e32 v6, s4
; VI-NEXT:    v_add_f16_e32 v3, s16, v0
; VI-NEXT:    v_add_f16_sdwa v4, v1, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v1, s17, v0
; VI-NEXT:    v_add_f16_sdwa v5, v2, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v2, s18, v0
; VI-NEXT:    v_add_f16_sdwa v0, v6, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v2, v2, v0
; VI-NEXT:    v_or_b32_e32 v1, v1, v5
; VI-NEXT:    v_or_b32_e32 v0, v3, v4
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB57_3:
; VI-NEXT:    s_branch .LBB57_2
; VI-NEXT:  .LBB57_4:
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    v_mov_b32_e32 v2, s18
; VI-NEXT:    v_mov_b32_e32 v3, s19
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v6f16_to_v6i16_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s19, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB57_3
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB57_4
; GFX9-NEXT:  .LBB57_2: ; %cmp.true
; GFX9-NEXT:    v_mov_b32_e32 v0, 0x200
; GFX9-NEXT:    v_pk_add_f16 v2, s18, v0 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v1, s17, v0 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v0, s16, v0 op_sel_hi:[1,0]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB57_3:
; GFX9-NEXT:    s_branch .LBB57_2
; GFX9-NEXT:  .LBB57_4:
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-NEXT:    v_mov_b32_e32 v3, s19
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v6f16_to_v6i16_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_cmp_lg_u32 s3, 0
; GFX11-NEXT:    s_mov_b32 s4, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB57_3
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s4
; GFX11-NEXT:    s_cbranch_vccnz .LBB57_4
; GFX11-NEXT:  .LBB57_2: ; %cmp.true
; GFX11-NEXT:    v_pk_add_f16 v2, 0x200, s2 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v1, 0x200, s1 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v0, 0x200, s0 op_sel_hi:[0,1]
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB57_3:
; GFX11-NEXT:    s_branch .LBB57_2
; GFX11-NEXT:  .LBB57_4:
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <6 x half> %a, splat (half 0xH0200)
  %a2 = bitcast <6 x half> %a1 to <6 x i16>
  br label %end

cmp.false:
  %a3 = bitcast <6 x half> %a to <6 x i16>
  br label %end

end:
  %phi = phi <6 x i16> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <6 x i16> %phi
}

define <6 x half> @bitcast_v6i16_to_v6f16(<6 x i16> %a, i32 %b) {
; SI-LABEL: bitcast_v6i16_to_v6f16:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v12, v5
; SI-NEXT:    v_mov_b32_e32 v7, v4
; SI-NEXT:    v_mov_b32_e32 v8, v3
; SI-NEXT:    v_mov_b32_e32 v9, v2
; SI-NEXT:    v_mov_b32_e32 v10, v1
; SI-NEXT:    v_mov_b32_e32 v11, v0
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v6
; SI-NEXT:    ; implicit-def: $vgpr0
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    ; implicit-def: $vgpr4
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB58_3
; SI-NEXT:  ; %bb.1: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB58_4
; SI-NEXT:  .LBB58_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB58_3: ; %cmp.false
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v11
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v10
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v9
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v8
; SI-NEXT:    v_cvt_f32_f16_e32 v4, v7
; SI-NEXT:    v_cvt_f32_f16_e32 v5, v12
; SI-NEXT:    ; implicit-def: $vgpr12
; SI-NEXT:    ; implicit-def: $vgpr7
; SI-NEXT:    ; implicit-def: $vgpr8
; SI-NEXT:    ; implicit-def: $vgpr9
; SI-NEXT:    ; implicit-def: $vgpr10
; SI-NEXT:    ; implicit-def: $vgpr11
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB58_2
; SI-NEXT:  .LBB58_4: ; %cmp.true
; SI-NEXT:    v_add_i32_e32 v5, vcc, 3, v12
; SI-NEXT:    v_add_i32_e32 v4, vcc, 3, v7
; SI-NEXT:    v_add_i32_e32 v3, vcc, 3, v8
; SI-NEXT:    v_add_i32_e32 v2, vcc, 3, v9
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v10
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v11
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v3
; SI-NEXT:    v_cvt_f32_f16_e32 v4, v4
; SI-NEXT:    v_cvt_f32_f16_e32 v5, v5
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v6i16_to_v6f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v3
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB58_2
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_mov_b32_e32 v3, 3
; VI-NEXT:    v_add_u16_sdwa v4, v0, v3 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_u16_sdwa v5, v1, v3 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_u16_sdwa v3, v2, v3 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_u16_e32 v2, 3, v2
; VI-NEXT:    v_add_u16_e32 v1, 3, v1
; VI-NEXT:    v_add_u16_e32 v0, 3, v0
; VI-NEXT:    v_or_b32_e32 v2, v2, v3
; VI-NEXT:    v_or_b32_e32 v1, v1, v5
; VI-NEXT:    v_or_b32_e32 v0, v0, v4
; VI-NEXT:  .LBB58_2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v6i16_to_v6f16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v3
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_pk_add_u16 v2, v2, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v1, v1, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v0, v0, 3 op_sel_hi:[1,0]
; GFX9-NEXT:  ; %bb.2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v6i16_to_v6f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v3
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_pk_add_u16 v2, v2, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v1, v1, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v0, v0, 3 op_sel_hi:[1,0]
; GFX11-NEXT:  ; %bb.2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <6 x i16> %a, splat (i16 3)
  %a2 = bitcast <6 x i16> %a1 to <6 x half>
  br label %end

cmp.false:
  %a3 = bitcast <6 x i16> %a to <6 x half>
  br label %end

end:
  %phi = phi <6 x half> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <6 x half> %phi
}

define inreg <6 x half> @bitcast_v6i16_to_v6f16_scalar(<6 x i16> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v6i16_to_v6f16_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s22, 0
; SI-NEXT:    s_cbranch_scc0 .LBB59_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    v_cvt_f32_f16_e32 v0, s16
; SI-NEXT:    v_cvt_f32_f16_e32 v1, s17
; SI-NEXT:    v_cvt_f32_f16_e32 v2, s18
; SI-NEXT:    v_cvt_f32_f16_e32 v3, s19
; SI-NEXT:    v_cvt_f32_f16_e32 v4, s20
; SI-NEXT:    v_cvt_f32_f16_e32 v5, s21
; SI-NEXT:    s_cbranch_execnz .LBB59_3
; SI-NEXT:  .LBB59_2: ; %cmp.true
; SI-NEXT:    s_add_i32 s21, s21, 3
; SI-NEXT:    s_add_i32 s20, s20, 3
; SI-NEXT:    s_add_i32 s19, s19, 3
; SI-NEXT:    s_add_i32 s18, s18, 3
; SI-NEXT:    s_add_i32 s17, s17, 3
; SI-NEXT:    s_add_i32 s16, s16, 3
; SI-NEXT:    v_cvt_f32_f16_e32 v0, s16
; SI-NEXT:    v_cvt_f32_f16_e32 v1, s17
; SI-NEXT:    v_cvt_f32_f16_e32 v2, s18
; SI-NEXT:    v_cvt_f32_f16_e32 v3, s19
; SI-NEXT:    v_cvt_f32_f16_e32 v4, s20
; SI-NEXT:    v_cvt_f32_f16_e32 v5, s21
; SI-NEXT:  .LBB59_3: ; %end
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB59_4:
; SI-NEXT:    ; implicit-def: $vgpr0
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    ; implicit-def: $vgpr4
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    s_branch .LBB59_2
;
; VI-LABEL: bitcast_v6i16_to_v6f16_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s19, 0
; VI-NEXT:    s_cbranch_scc0 .LBB59_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB59_3
; VI-NEXT:  .LBB59_2: ; %cmp.true
; VI-NEXT:    s_add_i32 s5, s16, 3
; VI-NEXT:    s_add_i32 s7, s17, 3
; VI-NEXT:    s_add_i32 s9, s18, 3
; VI-NEXT:    s_and_b32 s4, s16, 0xffff0000
; VI-NEXT:    s_and_b32 s6, s17, 0xffff0000
; VI-NEXT:    s_and_b32 s8, s18, 0xffff0000
; VI-NEXT:    s_and_b32 s9, s9, 0xffff
; VI-NEXT:    s_and_b32 s7, s7, 0xffff
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_or_b32 s8, s8, s9
; VI-NEXT:    s_or_b32 s6, s6, s7
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_add_i32 s18, s8, 0x30000
; VI-NEXT:    s_add_i32 s17, s6, 0x30000
; VI-NEXT:    s_add_i32 s16, s4, 0x30000
; VI-NEXT:  .LBB59_3: ; %end
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    v_mov_b32_e32 v2, s18
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB59_4:
; VI-NEXT:    s_branch .LBB59_2
;
; GFX9-LABEL: bitcast_v6i16_to_v6f16_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s19, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB59_3
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB59_4
; GFX9-NEXT:  .LBB59_2: ; %cmp.true
; GFX9-NEXT:    v_pk_add_u16 v2, s18, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v1, s17, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v0, s16, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB59_3:
; GFX9-NEXT:    s_branch .LBB59_2
; GFX9-NEXT:  .LBB59_4:
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-NEXT:    v_mov_b32_e32 v3, s19
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v6i16_to_v6f16_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_cmp_lg_u32 s3, 0
; GFX11-NEXT:    s_mov_b32 s4, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB59_3
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s4
; GFX11-NEXT:    s_cbranch_vccnz .LBB59_4
; GFX11-NEXT:  .LBB59_2: ; %cmp.true
; GFX11-NEXT:    v_pk_add_u16 v2, s2, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v1, s1, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v0, s0, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB59_3:
; GFX11-NEXT:    s_branch .LBB59_2
; GFX11-NEXT:  .LBB59_4:
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <6 x i16> %a, splat (i16 3)
  %a2 = bitcast <6 x i16> %a1 to <6 x half>
  br label %end

cmp.false:
  %a3 = bitcast <6 x i16> %a to <6 x half>
  br label %end

end:
  %phi = phi <6 x half> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <6 x half> %phi
}
