; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-unknown-unknown | FileCheck %s --check-prefix=X64
; RUN: llc < %s -mtriple=i686-unknown-unknown | FileCheck %s --check-prefix=X86

; These test cases are inspired by C++2a std::midpoint().
; See https://bugs.llvm.org/show_bug.cgi?id=40965

; ---------------------------------------------------------------------------- ;
; 32-bit width
; ---------------------------------------------------------------------------- ;

; Values come from regs

define i32 @scalar_i32_signed_reg_reg(i32 %a1, i32 %a2) nounwind {
; X64-LABEL: scalar_i32_signed_reg_reg:
; X64:       # %bb.0:
; X64-NEXT:    xorl %ecx, %ecx
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    subl %esi, %eax
; X64-NEXT:    setle %cl
; X64-NEXT:    leal -1(%rcx,%rcx), %ecx
; X64-NEXT:    subl %edi, %esi
; X64-NEXT:    cmovgel %esi, %eax
; X64-NEXT:    shrl %eax
; X64-NEXT:    imull %ecx, %eax
; X64-NEXT:    addl %edi, %eax
; X64-NEXT:    retq
;
; X86-LABEL: scalar_i32_signed_reg_reg:
; X86:       # %bb.0:
; X86-NEXT:    pushl %esi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    xorl %eax, %eax
; X86-NEXT:    cmpl %esi, %ecx
; X86-NEXT:    setle %al
; X86-NEXT:    leal -1(%eax,%eax), %edx
; X86-NEXT:    movl %ecx, %eax
; X86-NEXT:    subl %esi, %eax
; X86-NEXT:    jg .LBB0_2
; X86-NEXT:  # %bb.1:
; X86-NEXT:    subl %ecx, %esi
; X86-NEXT:    movl %esi, %eax
; X86-NEXT:  .LBB0_2:
; X86-NEXT:    shrl %eax
; X86-NEXT:    imull %edx, %eax
; X86-NEXT:    addl %ecx, %eax
; X86-NEXT:    popl %esi
; X86-NEXT:    retl
  %t3 = icmp sgt i32 %a1, %a2 ; signed
  %t4 = select i1 %t3, i32 -1, i32 1
  %t5 = select i1 %t3, i32 %a2, i32 %a1
  %t6 = select i1 %t3, i32 %a1, i32 %a2
  %t7 = sub i32 %t6, %t5
  %t8 = lshr i32 %t7, 1
  %t9 = mul nsw i32 %t8, %t4 ; signed
  %a10 = add nsw i32 %t9, %a1 ; signed
  ret i32 %a10
}

define i32 @scalar_i32_unsigned_reg_reg(i32 %a1, i32 %a2) nounwind {
; X64-LABEL: scalar_i32_unsigned_reg_reg:
; X64:       # %bb.0:
; X64-NEXT:    xorl %ecx, %ecx
; X64-NEXT:    cmpl %edi, %esi
; X64-NEXT:    sbbl %ecx, %ecx
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    subl %esi, %eax
; X64-NEXT:    subl %edi, %esi
; X64-NEXT:    cmovael %esi, %eax
; X64-NEXT:    orl $1, %ecx
; X64-NEXT:    shrl %eax
; X64-NEXT:    imull %ecx, %eax
; X64-NEXT:    addl %edi, %eax
; X64-NEXT:    retq
;
; X86-LABEL: scalar_i32_unsigned_reg_reg:
; X86:       # %bb.0:
; X86-NEXT:    pushl %edi
; X86-NEXT:    pushl %esi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X86-NEXT:    xorl %edx, %edx
; X86-NEXT:    movl %edi, %esi
; X86-NEXT:    subl %ecx, %esi
; X86-NEXT:    sbbl %edx, %edx
; X86-NEXT:    orl $1, %edx
; X86-NEXT:    movl %ecx, %eax
; X86-NEXT:    subl %edi, %eax
; X86-NEXT:    ja .LBB1_2
; X86-NEXT:  # %bb.1:
; X86-NEXT:    movl %esi, %eax
; X86-NEXT:  .LBB1_2:
; X86-NEXT:    shrl %eax
; X86-NEXT:    imull %edx, %eax
; X86-NEXT:    addl %ecx, %eax
; X86-NEXT:    popl %esi
; X86-NEXT:    popl %edi
; X86-NEXT:    retl
  %t3 = icmp ugt i32 %a1, %a2
  %t4 = select i1 %t3, i32 -1, i32 1
  %t5 = select i1 %t3, i32 %a2, i32 %a1
  %t6 = select i1 %t3, i32 %a1, i32 %a2
  %t7 = sub i32 %t6, %t5
  %t8 = lshr i32 %t7, 1
  %t9 = mul i32 %t8, %t4
  %a10 = add i32 %t9, %a1
  ret i32 %a10
}

; Values are loaded. Only check signed case.

define i32 @scalar_i32_signed_mem_reg(ptr %a1_addr, i32 %a2) nounwind {
; X64-LABEL: scalar_i32_signed_mem_reg:
; X64:       # %bb.0:
; X64-NEXT:    movl (%rdi), %ecx
; X64-NEXT:    xorl %edx, %edx
; X64-NEXT:    movl %ecx, %eax
; X64-NEXT:    subl %esi, %eax
; X64-NEXT:    setle %dl
; X64-NEXT:    leal -1(%rdx,%rdx), %edx
; X64-NEXT:    subl %ecx, %esi
; X64-NEXT:    cmovgel %esi, %eax
; X64-NEXT:    shrl %eax
; X64-NEXT:    imull %edx, %eax
; X64-NEXT:    addl %ecx, %eax
; X64-NEXT:    retq
;
; X86-LABEL: scalar_i32_signed_mem_reg:
; X86:       # %bb.0:
; X86-NEXT:    pushl %esi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl (%eax), %ecx
; X86-NEXT:    xorl %eax, %eax
; X86-NEXT:    cmpl %edx, %ecx
; X86-NEXT:    setle %al
; X86-NEXT:    leal -1(%eax,%eax), %esi
; X86-NEXT:    movl %ecx, %eax
; X86-NEXT:    subl %edx, %eax
; X86-NEXT:    jg .LBB2_2
; X86-NEXT:  # %bb.1:
; X86-NEXT:    subl %ecx, %edx
; X86-NEXT:    movl %edx, %eax
; X86-NEXT:  .LBB2_2:
; X86-NEXT:    shrl %eax
; X86-NEXT:    imull %esi, %eax
; X86-NEXT:    addl %ecx, %eax
; X86-NEXT:    popl %esi
; X86-NEXT:    retl
  %a1 = load i32, ptr %a1_addr
  %t3 = icmp sgt i32 %a1, %a2 ; signed
  %t4 = select i1 %t3, i32 -1, i32 1
  %t5 = select i1 %t3, i32 %a2, i32 %a1
  %t6 = select i1 %t3, i32 %a1, i32 %a2
  %t7 = sub i32 %t6, %t5
  %t8 = lshr i32 %t7, 1
  %t9 = mul nsw i32 %t8, %t4 ; signed
  %a10 = add nsw i32 %t9, %a1 ; signed
  ret i32 %a10
}

define i32 @scalar_i32_signed_reg_mem(i32 %a1, ptr %a2_addr) nounwind {
; X64-LABEL: scalar_i32_signed_reg_mem:
; X64:       # %bb.0:
; X64-NEXT:    movl (%rsi), %eax
; X64-NEXT:    xorl %ecx, %ecx
; X64-NEXT:    movl %edi, %edx
; X64-NEXT:    subl %eax, %edx
; X64-NEXT:    setle %cl
; X64-NEXT:    leal -1(%rcx,%rcx), %ecx
; X64-NEXT:    subl %edi, %eax
; X64-NEXT:    cmovll %edx, %eax
; X64-NEXT:    shrl %eax
; X64-NEXT:    imull %ecx, %eax
; X64-NEXT:    addl %edi, %eax
; X64-NEXT:    retq
;
; X86-LABEL: scalar_i32_signed_reg_mem:
; X86:       # %bb.0:
; X86-NEXT:    pushl %esi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl (%eax), %esi
; X86-NEXT:    xorl %eax, %eax
; X86-NEXT:    cmpl %esi, %ecx
; X86-NEXT:    setle %al
; X86-NEXT:    leal -1(%eax,%eax), %edx
; X86-NEXT:    movl %ecx, %eax
; X86-NEXT:    subl %esi, %eax
; X86-NEXT:    jg .LBB3_2
; X86-NEXT:  # %bb.1:
; X86-NEXT:    subl %ecx, %esi
; X86-NEXT:    movl %esi, %eax
; X86-NEXT:  .LBB3_2:
; X86-NEXT:    shrl %eax
; X86-NEXT:    imull %edx, %eax
; X86-NEXT:    addl %ecx, %eax
; X86-NEXT:    popl %esi
; X86-NEXT:    retl
  %a2 = load i32, ptr %a2_addr
  %t3 = icmp sgt i32 %a1, %a2 ; signed
  %t4 = select i1 %t3, i32 -1, i32 1
  %t5 = select i1 %t3, i32 %a2, i32 %a1
  %t6 = select i1 %t3, i32 %a1, i32 %a2
  %t7 = sub i32 %t6, %t5
  %t8 = lshr i32 %t7, 1
  %t9 = mul nsw i32 %t8, %t4 ; signed
  %a10 = add nsw i32 %t9, %a1 ; signed
  ret i32 %a10
}

define i32 @scalar_i32_signed_mem_mem(ptr %a1_addr, ptr %a2_addr) nounwind {
; X64-LABEL: scalar_i32_signed_mem_mem:
; X64:       # %bb.0:
; X64-NEXT:    movl (%rdi), %ecx
; X64-NEXT:    movl (%rsi), %eax
; X64-NEXT:    xorl %edx, %edx
; X64-NEXT:    movl %ecx, %esi
; X64-NEXT:    subl %eax, %esi
; X64-NEXT:    setle %dl
; X64-NEXT:    leal -1(%rdx,%rdx), %edx
; X64-NEXT:    subl %ecx, %eax
; X64-NEXT:    cmovll %esi, %eax
; X64-NEXT:    shrl %eax
; X64-NEXT:    imull %edx, %eax
; X64-NEXT:    addl %ecx, %eax
; X64-NEXT:    retq
;
; X86-LABEL: scalar_i32_signed_mem_mem:
; X86:       # %bb.0:
; X86-NEXT:    pushl %esi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl (%ecx), %ecx
; X86-NEXT:    movl (%eax), %esi
; X86-NEXT:    xorl %eax, %eax
; X86-NEXT:    cmpl %esi, %ecx
; X86-NEXT:    setle %al
; X86-NEXT:    leal -1(%eax,%eax), %edx
; X86-NEXT:    movl %ecx, %eax
; X86-NEXT:    subl %esi, %eax
; X86-NEXT:    jg .LBB4_2
; X86-NEXT:  # %bb.1:
; X86-NEXT:    subl %ecx, %esi
; X86-NEXT:    movl %esi, %eax
; X86-NEXT:  .LBB4_2:
; X86-NEXT:    shrl %eax
; X86-NEXT:    imull %edx, %eax
; X86-NEXT:    addl %ecx, %eax
; X86-NEXT:    popl %esi
; X86-NEXT:    retl
  %a1 = load i32, ptr %a1_addr
  %a2 = load i32, ptr %a2_addr
  %t3 = icmp sgt i32 %a1, %a2 ; signed
  %t4 = select i1 %t3, i32 -1, i32 1
  %t5 = select i1 %t3, i32 %a2, i32 %a1
  %t6 = select i1 %t3, i32 %a1, i32 %a2
  %t7 = sub i32 %t6, %t5
  %t8 = lshr i32 %t7, 1
  %t9 = mul nsw i32 %t8, %t4 ; signed
  %a10 = add nsw i32 %t9, %a1 ; signed
  ret i32 %a10
}

; ---------------------------------------------------------------------------- ;
; 64-bit width
; ---------------------------------------------------------------------------- ;

; Values come from regs

define i64 @scalar_i64_signed_reg_reg(i64 %a1, i64 %a2) nounwind {
; X64-LABEL: scalar_i64_signed_reg_reg:
; X64:       # %bb.0:
; X64-NEXT:    xorl %ecx, %ecx
; X64-NEXT:    movq %rdi, %rax
; X64-NEXT:    subq %rsi, %rax
; X64-NEXT:    setle %cl
; X64-NEXT:    leaq -1(%rcx,%rcx), %rcx
; X64-NEXT:    subq %rdi, %rsi
; X64-NEXT:    cmovgeq %rsi, %rax
; X64-NEXT:    shrq %rax
; X64-NEXT:    imulq %rcx, %rax
; X64-NEXT:    addq %rdi, %rax
; X64-NEXT:    retq
;
; X86-LABEL: scalar_i64_signed_reg_reg:
; X86:       # %bb.0:
; X86-NEXT:    pushl %ebp
; X86-NEXT:    pushl %ebx
; X86-NEXT:    pushl %edi
; X86-NEXT:    pushl %esi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    cmpl %esi, %edx
; X86-NEXT:    movl %ecx, %eax
; X86-NEXT:    sbbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    setl %al
; X86-NEXT:    movzbl %al, %edi
; X86-NEXT:    negl %edi
; X86-NEXT:    movl %edi, %ebx
; X86-NEXT:    orl $1, %ebx
; X86-NEXT:    movl %esi, %eax
; X86-NEXT:    subl %edx, %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ebp
; X86-NEXT:    sbbl %ecx, %ebp
; X86-NEXT:    subl %esi, %edx
; X86-NEXT:    sbbl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    jl .LBB5_2
; X86-NEXT:  # %bb.1:
; X86-NEXT:    movl %edx, %eax
; X86-NEXT:    movl %ecx, %ebp
; X86-NEXT:  .LBB5_2:
; X86-NEXT:    shrdl $1, %ebp, %eax
; X86-NEXT:    shrl %ebp
; X86-NEXT:    imull %eax, %edi
; X86-NEXT:    mull %ebx
; X86-NEXT:    addl %edi, %edx
; X86-NEXT:    imull %ebx, %ebp
; X86-NEXT:    addl %ebp, %edx
; X86-NEXT:    addl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    adcl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    popl %esi
; X86-NEXT:    popl %edi
; X86-NEXT:    popl %ebx
; X86-NEXT:    popl %ebp
; X86-NEXT:    retl
  %t3 = icmp sgt i64 %a1, %a2 ; signed
  %t4 = select i1 %t3, i64 -1, i64 1
  %t5 = select i1 %t3, i64 %a2, i64 %a1
  %t6 = select i1 %t3, i64 %a1, i64 %a2
  %t7 = sub i64 %t6, %t5
  %t8 = lshr i64 %t7, 1
  %t9 = mul nsw i64 %t8, %t4 ; signed
  %a10 = add nsw i64 %t9, %a1 ; signed
  ret i64 %a10
}

define i64 @scalar_i64_unsigned_reg_reg(i64 %a1, i64 %a2) nounwind {
; X64-LABEL: scalar_i64_unsigned_reg_reg:
; X64:       # %bb.0:
; X64-NEXT:    xorl %ecx, %ecx
; X64-NEXT:    cmpq %rdi, %rsi
; X64-NEXT:    sbbq %rcx, %rcx
; X64-NEXT:    movq %rdi, %rax
; X64-NEXT:    subq %rsi, %rax
; X64-NEXT:    subq %rdi, %rsi
; X64-NEXT:    cmovaeq %rsi, %rax
; X64-NEXT:    orq $1, %rcx
; X64-NEXT:    shrq %rax
; X64-NEXT:    imulq %rcx, %rax
; X64-NEXT:    addq %rdi, %rax
; X64-NEXT:    retq
;
; X86-LABEL: scalar_i64_unsigned_reg_reg:
; X86:       # %bb.0:
; X86-NEXT:    pushl %ebp
; X86-NEXT:    pushl %ebx
; X86-NEXT:    pushl %edi
; X86-NEXT:    pushl %esi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ebp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    xorl %edx, %edx
; X86-NEXT:    cmpl %eax, %ebp
; X86-NEXT:    sbbl %ecx, %esi
; X86-NEXT:    movl $0, %ebx
; X86-NEXT:    sbbl %ebx, %ebx
; X86-NEXT:    movl %ebx, %edi
; X86-NEXT:    orl $1, %edi
; X86-NEXT:    movl %eax, %esi
; X86-NEXT:    subl %ebp, %esi
; X86-NEXT:    movl %ecx, %eax
; X86-NEXT:    sbbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    sbbl %edx, %edx
; X86-NEXT:    xorl %edx, %eax
; X86-NEXT:    xorl %edx, %esi
; X86-NEXT:    subl %edx, %esi
; X86-NEXT:    sbbl %edx, %eax
; X86-NEXT:    movl %eax, %ebp
; X86-NEXT:    shldl $31, %esi, %eax
; X86-NEXT:    imull %eax, %ebx
; X86-NEXT:    mull %edi
; X86-NEXT:    addl %ebx, %edx
; X86-NEXT:    shrl %ebp
; X86-NEXT:    imull %edi, %ebp
; X86-NEXT:    addl %ebp, %edx
; X86-NEXT:    addl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    adcl %ecx, %edx
; X86-NEXT:    popl %esi
; X86-NEXT:    popl %edi
; X86-NEXT:    popl %ebx
; X86-NEXT:    popl %ebp
; X86-NEXT:    retl
  %t3 = icmp ugt i64 %a1, %a2
  %t4 = select i1 %t3, i64 -1, i64 1
  %t5 = select i1 %t3, i64 %a2, i64 %a1
  %t6 = select i1 %t3, i64 %a1, i64 %a2
  %t7 = sub i64 %t6, %t5
  %t8 = lshr i64 %t7, 1
  %t9 = mul i64 %t8, %t4
  %a10 = add i64 %t9, %a1
  ret i64 %a10
}

; Values are loaded. Only check signed case.

define i64 @scalar_i64_signed_mem_reg(ptr %a1_addr, i64 %a2) nounwind {
; X64-LABEL: scalar_i64_signed_mem_reg:
; X64:       # %bb.0:
; X64-NEXT:    movq (%rdi), %rcx
; X64-NEXT:    xorl %edx, %edx
; X64-NEXT:    movq %rcx, %rax
; X64-NEXT:    subq %rsi, %rax
; X64-NEXT:    setle %dl
; X64-NEXT:    leaq -1(%rdx,%rdx), %rdx
; X64-NEXT:    subq %rcx, %rsi
; X64-NEXT:    cmovgeq %rsi, %rax
; X64-NEXT:    shrq %rax
; X64-NEXT:    imulq %rdx, %rax
; X64-NEXT:    addq %rcx, %rax
; X64-NEXT:    retq
;
; X86-LABEL: scalar_i64_signed_mem_reg:
; X86:       # %bb.0:
; X86-NEXT:    pushl %ebp
; X86-NEXT:    pushl %ebx
; X86-NEXT:    pushl %edi
; X86-NEXT:    pushl %esi
; X86-NEXT:    subl $12, %esp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl (%eax), %ebx
; X86-NEXT:    movl 4(%eax), %esi
; X86-NEXT:    cmpl %ebx, %edx
; X86-NEXT:    movl %ecx, %eax
; X86-NEXT:    sbbl %esi, %eax
; X86-NEXT:    setl %al
; X86-NEXT:    movzbl %al, %edi
; X86-NEXT:    negl %edi
; X86-NEXT:    movl %edi, %eax
; X86-NEXT:    orl $1, %eax
; X86-NEXT:    movl %eax, (%esp) # 4-byte Spill
; X86-NEXT:    movl %ebx, %eax
; X86-NEXT:    subl %edx, %eax
; X86-NEXT:    movl %esi, %ebp
; X86-NEXT:    sbbl %ecx, %ebp
; X86-NEXT:    movl %ebx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    subl %ebx, %edx
; X86-NEXT:    movl %esi, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    sbbl %esi, %ecx
; X86-NEXT:    jl .LBB7_2
; X86-NEXT:  # %bb.1:
; X86-NEXT:    movl %edx, %eax
; X86-NEXT:    movl %ecx, %ebp
; X86-NEXT:  .LBB7_2:
; X86-NEXT:    shrdl $1, %ebp, %eax
; X86-NEXT:    shrl %ebp
; X86-NEXT:    imull %eax, %edi
; X86-NEXT:    movl (%esp), %ecx # 4-byte Reload
; X86-NEXT:    mull %ecx
; X86-NEXT:    addl %edi, %edx
; X86-NEXT:    imull %ecx, %ebp
; X86-NEXT:    addl %ebp, %edx
; X86-NEXT:    addl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 4-byte Folded Reload
; X86-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %edx # 4-byte Folded Reload
; X86-NEXT:    addl $12, %esp
; X86-NEXT:    popl %esi
; X86-NEXT:    popl %edi
; X86-NEXT:    popl %ebx
; X86-NEXT:    popl %ebp
; X86-NEXT:    retl
  %a1 = load i64, ptr %a1_addr
  %t3 = icmp sgt i64 %a1, %a2 ; signed
  %t4 = select i1 %t3, i64 -1, i64 1
  %t5 = select i1 %t3, i64 %a2, i64 %a1
  %t6 = select i1 %t3, i64 %a1, i64 %a2
  %t7 = sub i64 %t6, %t5
  %t8 = lshr i64 %t7, 1
  %t9 = mul nsw i64 %t8, %t4 ; signed
  %a10 = add nsw i64 %t9, %a1 ; signed
  ret i64 %a10
}

define i64 @scalar_i64_signed_reg_mem(i64 %a1, ptr %a2_addr) nounwind {
; X64-LABEL: scalar_i64_signed_reg_mem:
; X64:       # %bb.0:
; X64-NEXT:    movq (%rsi), %rax
; X64-NEXT:    xorl %ecx, %ecx
; X64-NEXT:    movq %rdi, %rdx
; X64-NEXT:    subq %rax, %rdx
; X64-NEXT:    setle %cl
; X64-NEXT:    leaq -1(%rcx,%rcx), %rcx
; X64-NEXT:    subq %rdi, %rax
; X64-NEXT:    cmovlq %rdx, %rax
; X64-NEXT:    shrq %rax
; X64-NEXT:    imulq %rcx, %rax
; X64-NEXT:    addq %rdi, %rax
; X64-NEXT:    retq
;
; X86-LABEL: scalar_i64_signed_reg_mem:
; X86:       # %bb.0:
; X86-NEXT:    pushl %ebp
; X86-NEXT:    pushl %ebx
; X86-NEXT:    pushl %edi
; X86-NEXT:    pushl %esi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl (%eax), %edx
; X86-NEXT:    movl 4(%eax), %ecx
; X86-NEXT:    cmpl %esi, %edx
; X86-NEXT:    movl %ecx, %eax
; X86-NEXT:    sbbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    setl %al
; X86-NEXT:    movzbl %al, %edi
; X86-NEXT:    negl %edi
; X86-NEXT:    movl %edi, %ebx
; X86-NEXT:    orl $1, %ebx
; X86-NEXT:    movl %esi, %eax
; X86-NEXT:    subl %edx, %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ebp
; X86-NEXT:    sbbl %ecx, %ebp
; X86-NEXT:    subl %esi, %edx
; X86-NEXT:    sbbl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    jl .LBB8_2
; X86-NEXT:  # %bb.1:
; X86-NEXT:    movl %edx, %eax
; X86-NEXT:    movl %ecx, %ebp
; X86-NEXT:  .LBB8_2:
; X86-NEXT:    shrdl $1, %ebp, %eax
; X86-NEXT:    shrl %ebp
; X86-NEXT:    imull %eax, %edi
; X86-NEXT:    mull %ebx
; X86-NEXT:    addl %edi, %edx
; X86-NEXT:    imull %ebx, %ebp
; X86-NEXT:    addl %ebp, %edx
; X86-NEXT:    addl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    adcl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    popl %esi
; X86-NEXT:    popl %edi
; X86-NEXT:    popl %ebx
; X86-NEXT:    popl %ebp
; X86-NEXT:    retl
  %a2 = load i64, ptr %a2_addr
  %t3 = icmp sgt i64 %a1, %a2 ; signed
  %t4 = select i1 %t3, i64 -1, i64 1
  %t5 = select i1 %t3, i64 %a2, i64 %a1
  %t6 = select i1 %t3, i64 %a1, i64 %a2
  %t7 = sub i64 %t6, %t5
  %t8 = lshr i64 %t7, 1
  %t9 = mul nsw i64 %t8, %t4 ; signed
  %a10 = add nsw i64 %t9, %a1 ; signed
  ret i64 %a10
}

define i64 @scalar_i64_signed_mem_mem(ptr %a1_addr, ptr %a2_addr) nounwind {
; X64-LABEL: scalar_i64_signed_mem_mem:
; X64:       # %bb.0:
; X64-NEXT:    movq (%rdi), %rcx
; X64-NEXT:    movq (%rsi), %rax
; X64-NEXT:    xorl %edx, %edx
; X64-NEXT:    movq %rcx, %rsi
; X64-NEXT:    subq %rax, %rsi
; X64-NEXT:    setle %dl
; X64-NEXT:    leaq -1(%rdx,%rdx), %rdx
; X64-NEXT:    subq %rcx, %rax
; X64-NEXT:    cmovlq %rsi, %rax
; X64-NEXT:    shrq %rax
; X64-NEXT:    imulq %rdx, %rax
; X64-NEXT:    addq %rcx, %rax
; X64-NEXT:    retq
;
; X86-LABEL: scalar_i64_signed_mem_mem:
; X86:       # %bb.0:
; X86-NEXT:    pushl %ebp
; X86-NEXT:    pushl %ebx
; X86-NEXT:    pushl %edi
; X86-NEXT:    pushl %esi
; X86-NEXT:    subl $12, %esp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl (%ecx), %ebx
; X86-NEXT:    movl 4(%ecx), %esi
; X86-NEXT:    movl (%eax), %edx
; X86-NEXT:    movl 4(%eax), %ecx
; X86-NEXT:    cmpl %ebx, %edx
; X86-NEXT:    movl %ecx, %eax
; X86-NEXT:    sbbl %esi, %eax
; X86-NEXT:    setl %al
; X86-NEXT:    movzbl %al, %edi
; X86-NEXT:    negl %edi
; X86-NEXT:    movl %edi, %eax
; X86-NEXT:    orl $1, %eax
; X86-NEXT:    movl %eax, (%esp) # 4-byte Spill
; X86-NEXT:    movl %ebx, %eax
; X86-NEXT:    subl %edx, %eax
; X86-NEXT:    movl %esi, %ebp
; X86-NEXT:    sbbl %ecx, %ebp
; X86-NEXT:    movl %ebx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    subl %ebx, %edx
; X86-NEXT:    movl %esi, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    sbbl %esi, %ecx
; X86-NEXT:    jl .LBB9_2
; X86-NEXT:  # %bb.1:
; X86-NEXT:    movl %edx, %eax
; X86-NEXT:    movl %ecx, %ebp
; X86-NEXT:  .LBB9_2:
; X86-NEXT:    shrdl $1, %ebp, %eax
; X86-NEXT:    shrl %ebp
; X86-NEXT:    imull %eax, %edi
; X86-NEXT:    movl (%esp), %ecx # 4-byte Reload
; X86-NEXT:    mull %ecx
; X86-NEXT:    addl %edi, %edx
; X86-NEXT:    imull %ecx, %ebp
; X86-NEXT:    addl %ebp, %edx
; X86-NEXT:    addl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 4-byte Folded Reload
; X86-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %edx # 4-byte Folded Reload
; X86-NEXT:    addl $12, %esp
; X86-NEXT:    popl %esi
; X86-NEXT:    popl %edi
; X86-NEXT:    popl %ebx
; X86-NEXT:    popl %ebp
; X86-NEXT:    retl
  %a1 = load i64, ptr %a1_addr
  %a2 = load i64, ptr %a2_addr
  %t3 = icmp sgt i64 %a1, %a2 ; signed
  %t4 = select i1 %t3, i64 -1, i64 1
  %t5 = select i1 %t3, i64 %a2, i64 %a1
  %t6 = select i1 %t3, i64 %a1, i64 %a2
  %t7 = sub i64 %t6, %t5
  %t8 = lshr i64 %t7, 1
  %t9 = mul nsw i64 %t8, %t4 ; signed
  %a10 = add nsw i64 %t9, %a1 ; signed
  ret i64 %a10
}

; ---------------------------------------------------------------------------- ;
; 16-bit width
; ---------------------------------------------------------------------------- ;

; Values come from regs

define i16 @scalar_i16_signed_reg_reg(i16 %a1, i16 %a2) nounwind {
; X64-LABEL: scalar_i16_signed_reg_reg:
; X64:       # %bb.0:
; X64-NEXT:    xorl %eax, %eax
; X64-NEXT:    cmpw %si, %di
; X64-NEXT:    setle %al
; X64-NEXT:    leal -1(%rax,%rax), %ecx
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    subl %esi, %eax
; X64-NEXT:    movswl %di, %edx
; X64-NEXT:    movswl %si, %esi
; X64-NEXT:    subl %edx, %esi
; X64-NEXT:    cmovll %eax, %esi
; X64-NEXT:    movzwl %si, %eax
; X64-NEXT:    shrl %eax
; X64-NEXT:    imull %ecx, %eax
; X64-NEXT:    addl %edi, %eax
; X64-NEXT:    # kill: def $ax killed $ax killed $eax
; X64-NEXT:    retq
;
; X86-LABEL: scalar_i16_signed_reg_reg:
; X86:       # %bb.0:
; X86-NEXT:    pushl %ebx
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl %ecx, %eax
; X86-NEXT:    subw %dx, %ax
; X86-NEXT:    jg .LBB10_2
; X86-NEXT:  # %bb.1:
; X86-NEXT:    negl %eax
; X86-NEXT:  .LBB10_2:
; X86-NEXT:    xorl %ebx, %ebx
; X86-NEXT:    cmpw %dx, %cx
; X86-NEXT:    setle %bl
; X86-NEXT:    leal -1(%ebx,%ebx), %edx
; X86-NEXT:    movzwl %ax, %eax
; X86-NEXT:    shrl %eax
; X86-NEXT:    imull %edx, %eax
; X86-NEXT:    addl %ecx, %eax
; X86-NEXT:    # kill: def $ax killed $ax killed $eax
; X86-NEXT:    popl %ebx
; X86-NEXT:    retl
  %t3 = icmp sgt i16 %a1, %a2 ; signed
  %t4 = select i1 %t3, i16 -1, i16 1
  %t5 = select i1 %t3, i16 %a2, i16 %a1
  %t6 = select i1 %t3, i16 %a1, i16 %a2
  %t7 = sub i16 %t6, %t5
  %t8 = lshr i16 %t7, 1
  %t9 = mul nsw i16 %t8, %t4 ; signed
  %a10 = add nsw i16 %t9, %a1 ; signed
  ret i16 %a10
}

define i16 @scalar_i16_unsigned_reg_reg(i16 %a1, i16 %a2) nounwind {
; X64-LABEL: scalar_i16_unsigned_reg_reg:
; X64:       # %bb.0:
; X64-NEXT:    xorl %ecx, %ecx
; X64-NEXT:    cmpw %di, %si
; X64-NEXT:    sbbl %ecx, %ecx
; X64-NEXT:    orl $1, %ecx
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    subl %esi, %eax
; X64-NEXT:    movzwl %di, %edx
; X64-NEXT:    movzwl %si, %esi
; X64-NEXT:    subl %edx, %esi
; X64-NEXT:    cmovbl %eax, %esi
; X64-NEXT:    movzwl %si, %eax
; X64-NEXT:    shrl %eax
; X64-NEXT:    imull %ecx, %eax
; X64-NEXT:    addl %edi, %eax
; X64-NEXT:    # kill: def $ax killed $ax killed $eax
; X64-NEXT:    retq
;
; X86-LABEL: scalar_i16_unsigned_reg_reg:
; X86:       # %bb.0:
; X86-NEXT:    pushl %esi
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl %ecx, %eax
; X86-NEXT:    subw %dx, %ax
; X86-NEXT:    ja .LBB11_2
; X86-NEXT:  # %bb.1:
; X86-NEXT:    negl %eax
; X86-NEXT:  .LBB11_2:
; X86-NEXT:    xorl %esi, %esi
; X86-NEXT:    cmpw %cx, %dx
; X86-NEXT:    sbbl %esi, %esi
; X86-NEXT:    orl $1, %esi
; X86-NEXT:    movzwl %ax, %eax
; X86-NEXT:    shrl %eax
; X86-NEXT:    imull %esi, %eax
; X86-NEXT:    addl %ecx, %eax
; X86-NEXT:    # kill: def $ax killed $ax killed $eax
; X86-NEXT:    popl %esi
; X86-NEXT:    retl
  %t3 = icmp ugt i16 %a1, %a2
  %t4 = select i1 %t3, i16 -1, i16 1
  %t5 = select i1 %t3, i16 %a2, i16 %a1
  %t6 = select i1 %t3, i16 %a1, i16 %a2
  %t7 = sub i16 %t6, %t5
  %t8 = lshr i16 %t7, 1
  %t9 = mul i16 %t8, %t4
  %a10 = add i16 %t9, %a1
  ret i16 %a10
}

; Values are loaded. Only check signed case.

define i16 @scalar_i16_signed_mem_reg(ptr %a1_addr, i16 %a2) nounwind {
; X64-LABEL: scalar_i16_signed_mem_reg:
; X64:       # %bb.0:
; X64-NEXT:    movswl (%rdi), %ecx
; X64-NEXT:    xorl %eax, %eax
; X64-NEXT:    cmpw %si, %cx
; X64-NEXT:    setle %al
; X64-NEXT:    leal -1(%rax,%rax), %edx
; X64-NEXT:    movl %ecx, %eax
; X64-NEXT:    subl %esi, %eax
; X64-NEXT:    movswl %si, %esi
; X64-NEXT:    subl %ecx, %esi
; X64-NEXT:    cmovll %eax, %esi
; X64-NEXT:    movzwl %si, %eax
; X64-NEXT:    shrl %eax
; X64-NEXT:    imull %edx, %eax
; X64-NEXT:    addl %ecx, %eax
; X64-NEXT:    # kill: def $ax killed $ax killed $eax
; X64-NEXT:    retq
;
; X86-LABEL: scalar_i16_signed_mem_reg:
; X86:       # %bb.0:
; X86-NEXT:    pushl %ebx
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movzwl (%eax), %ecx
; X86-NEXT:    movl %ecx, %eax
; X86-NEXT:    subw %dx, %ax
; X86-NEXT:    jg .LBB12_2
; X86-NEXT:  # %bb.1:
; X86-NEXT:    negl %eax
; X86-NEXT:  .LBB12_2:
; X86-NEXT:    xorl %ebx, %ebx
; X86-NEXT:    cmpw %dx, %cx
; X86-NEXT:    setle %bl
; X86-NEXT:    leal -1(%ebx,%ebx), %edx
; X86-NEXT:    movzwl %ax, %eax
; X86-NEXT:    shrl %eax
; X86-NEXT:    imull %edx, %eax
; X86-NEXT:    addl %ecx, %eax
; X86-NEXT:    # kill: def $ax killed $ax killed $eax
; X86-NEXT:    popl %ebx
; X86-NEXT:    retl
  %a1 = load i16, ptr %a1_addr
  %t3 = icmp sgt i16 %a1, %a2 ; signed
  %t4 = select i1 %t3, i16 -1, i16 1
  %t5 = select i1 %t3, i16 %a2, i16 %a1
  %t6 = select i1 %t3, i16 %a1, i16 %a2
  %t7 = sub i16 %t6, %t5
  %t8 = lshr i16 %t7, 1
  %t9 = mul nsw i16 %t8, %t4 ; signed
  %a10 = add nsw i16 %t9, %a1 ; signed
  ret i16 %a10
}

define i16 @scalar_i16_signed_reg_mem(i16 %a1, ptr %a2_addr) nounwind {
; X64-LABEL: scalar_i16_signed_reg_mem:
; X64:       # %bb.0:
; X64-NEXT:    movswl (%rsi), %eax
; X64-NEXT:    xorl %ecx, %ecx
; X64-NEXT:    cmpw %ax, %di
; X64-NEXT:    setle %cl
; X64-NEXT:    leal -1(%rcx,%rcx), %ecx
; X64-NEXT:    movl %edi, %edx
; X64-NEXT:    subl %eax, %edx
; X64-NEXT:    movswl %di, %esi
; X64-NEXT:    subl %esi, %eax
; X64-NEXT:    cmovll %edx, %eax
; X64-NEXT:    movzwl %ax, %eax
; X64-NEXT:    shrl %eax
; X64-NEXT:    imull %ecx, %eax
; X64-NEXT:    addl %edi, %eax
; X64-NEXT:    # kill: def $ax killed $ax killed $eax
; X64-NEXT:    retq
;
; X86-LABEL: scalar_i16_signed_reg_mem:
; X86:       # %bb.0:
; X86-NEXT:    pushl %ebx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movzwl (%eax), %edx
; X86-NEXT:    movl %ecx, %eax
; X86-NEXT:    subw %dx, %ax
; X86-NEXT:    jg .LBB13_2
; X86-NEXT:  # %bb.1:
; X86-NEXT:    negl %eax
; X86-NEXT:  .LBB13_2:
; X86-NEXT:    xorl %ebx, %ebx
; X86-NEXT:    cmpw %dx, %cx
; X86-NEXT:    setle %bl
; X86-NEXT:    leal -1(%ebx,%ebx), %edx
; X86-NEXT:    movzwl %ax, %eax
; X86-NEXT:    shrl %eax
; X86-NEXT:    imull %edx, %eax
; X86-NEXT:    addl %ecx, %eax
; X86-NEXT:    # kill: def $ax killed $ax killed $eax
; X86-NEXT:    popl %ebx
; X86-NEXT:    retl
  %a2 = load i16, ptr %a2_addr
  %t3 = icmp sgt i16 %a1, %a2 ; signed
  %t4 = select i1 %t3, i16 -1, i16 1
  %t5 = select i1 %t3, i16 %a2, i16 %a1
  %t6 = select i1 %t3, i16 %a1, i16 %a2
  %t7 = sub i16 %t6, %t5
  %t8 = lshr i16 %t7, 1
  %t9 = mul nsw i16 %t8, %t4 ; signed
  %a10 = add nsw i16 %t9, %a1 ; signed
  ret i16 %a10
}

define i16 @scalar_i16_signed_mem_mem(ptr %a1_addr, ptr %a2_addr) nounwind {
; X64-LABEL: scalar_i16_signed_mem_mem:
; X64:       # %bb.0:
; X64-NEXT:    movswl (%rdi), %ecx
; X64-NEXT:    movswl (%rsi), %eax
; X64-NEXT:    xorl %edx, %edx
; X64-NEXT:    cmpw %ax, %cx
; X64-NEXT:    setle %dl
; X64-NEXT:    leal -1(%rdx,%rdx), %edx
; X64-NEXT:    movl %ecx, %esi
; X64-NEXT:    subl %eax, %esi
; X64-NEXT:    subl %ecx, %eax
; X64-NEXT:    cmovll %esi, %eax
; X64-NEXT:    movzwl %ax, %eax
; X64-NEXT:    shrl %eax
; X64-NEXT:    imull %edx, %eax
; X64-NEXT:    addl %ecx, %eax
; X64-NEXT:    # kill: def $ax killed $ax killed $eax
; X64-NEXT:    retq
;
; X86-LABEL: scalar_i16_signed_mem_mem:
; X86:       # %bb.0:
; X86-NEXT:    pushl %ebx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movzwl (%ecx), %ecx
; X86-NEXT:    movzwl (%eax), %edx
; X86-NEXT:    movl %ecx, %eax
; X86-NEXT:    subw %dx, %ax
; X86-NEXT:    jg .LBB14_2
; X86-NEXT:  # %bb.1:
; X86-NEXT:    negl %eax
; X86-NEXT:  .LBB14_2:
; X86-NEXT:    xorl %ebx, %ebx
; X86-NEXT:    cmpw %dx, %cx
; X86-NEXT:    setle %bl
; X86-NEXT:    leal -1(%ebx,%ebx), %edx
; X86-NEXT:    movzwl %ax, %eax
; X86-NEXT:    shrl %eax
; X86-NEXT:    imull %edx, %eax
; X86-NEXT:    addl %ecx, %eax
; X86-NEXT:    # kill: def $ax killed $ax killed $eax
; X86-NEXT:    popl %ebx
; X86-NEXT:    retl
  %a1 = load i16, ptr %a1_addr
  %a2 = load i16, ptr %a2_addr
  %t3 = icmp sgt i16 %a1, %a2 ; signed
  %t4 = select i1 %t3, i16 -1, i16 1
  %t5 = select i1 %t3, i16 %a2, i16 %a1
  %t6 = select i1 %t3, i16 %a1, i16 %a2
  %t7 = sub i16 %t6, %t5
  %t8 = lshr i16 %t7, 1
  %t9 = mul nsw i16 %t8, %t4 ; signed
  %a10 = add nsw i16 %t9, %a1 ; signed
  ret i16 %a10
}

; ---------------------------------------------------------------------------- ;
; 8-bit width
; ---------------------------------------------------------------------------- ;

; Values come from regs

define i8 @scalar_i8_signed_reg_reg(i8 %a1, i8 %a2) nounwind {
; X64-LABEL: scalar_i8_signed_reg_reg:
; X64:       # %bb.0:
; X64-NEXT:    cmpb %sil, %dil
; X64-NEXT:    setg %cl
; X64-NEXT:    negb %cl
; X64-NEXT:    orb $1, %cl
; X64-NEXT:    movsbl %dil, %edx
; X64-NEXT:    subl %esi, %edi
; X64-NEXT:    movsbl %sil, %eax
; X64-NEXT:    subl %edx, %eax
; X64-NEXT:    cmovll %edi, %eax
; X64-NEXT:    shrb %al
; X64-NEXT:    # kill: def $al killed $al killed $eax
; X64-NEXT:    mulb %cl
; X64-NEXT:    addb %dl, %al
; X64-NEXT:    retq
;
; X86-LABEL: scalar_i8_signed_reg_reg:
; X86:       # %bb.0:
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movb {{[0-9]+}}(%esp), %ah
; X86-NEXT:    cmpb %ah, %cl
; X86-NEXT:    setg %dl
; X86-NEXT:    negb %dl
; X86-NEXT:    orb $1, %dl
; X86-NEXT:    movb %cl, %al
; X86-NEXT:    subb %ah, %al
; X86-NEXT:    jg .LBB15_2
; X86-NEXT:  # %bb.1:
; X86-NEXT:    subb %cl, %ah
; X86-NEXT:    movb %ah, %al
; X86-NEXT:  .LBB15_2:
; X86-NEXT:    shrb %al
; X86-NEXT:    mulb %dl
; X86-NEXT:    addb %cl, %al
; X86-NEXT:    retl
  %t3 = icmp sgt i8 %a1, %a2 ; signed
  %t4 = select i1 %t3, i8 -1, i8 1
  %t5 = select i1 %t3, i8 %a2, i8 %a1
  %t6 = select i1 %t3, i8 %a1, i8 %a2
  %t7 = sub i8 %t6, %t5
  %t8 = lshr i8 %t7, 1
  %t9 = mul nsw i8 %t8, %t4 ; signed
  %a10 = add nsw i8 %t9, %a1 ; signed
  ret i8 %a10
}

define i8 @scalar_i8_unsigned_reg_reg(i8 %a1, i8 %a2) nounwind {
; X64-LABEL: scalar_i8_unsigned_reg_reg:
; X64:       # %bb.0:
; X64-NEXT:    xorl %ecx, %ecx
; X64-NEXT:    cmpb %dil, %sil
; X64-NEXT:    sbbl %ecx, %ecx
; X64-NEXT:    orb $1, %cl
; X64-NEXT:    movzbl %dil, %edx
; X64-NEXT:    subl %esi, %edi
; X64-NEXT:    movzbl %sil, %eax
; X64-NEXT:    subl %edx, %eax
; X64-NEXT:    cmovbl %edi, %eax
; X64-NEXT:    shrb %al
; X64-NEXT:    # kill: def $al killed $al killed $eax
; X64-NEXT:    mulb %cl
; X64-NEXT:    addb %dl, %al
; X64-NEXT:    retq
;
; X86-LABEL: scalar_i8_unsigned_reg_reg:
; X86:       # %bb.0:
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movb {{[0-9]+}}(%esp), %ch
; X86-NEXT:    xorl %edx, %edx
; X86-NEXT:    movb %ch, %ah
; X86-NEXT:    subb %cl, %ah
; X86-NEXT:    sbbl %edx, %edx
; X86-NEXT:    orb $1, %dl
; X86-NEXT:    movb %cl, %al
; X86-NEXT:    subb %ch, %al
; X86-NEXT:    ja .LBB16_2
; X86-NEXT:  # %bb.1:
; X86-NEXT:    movb %ah, %al
; X86-NEXT:  .LBB16_2:
; X86-NEXT:    shrb %al
; X86-NEXT:    mulb %dl
; X86-NEXT:    addb %cl, %al
; X86-NEXT:    retl
  %t3 = icmp ugt i8 %a1, %a2
  %t4 = select i1 %t3, i8 -1, i8 1
  %t5 = select i1 %t3, i8 %a2, i8 %a1
  %t6 = select i1 %t3, i8 %a1, i8 %a2
  %t7 = sub i8 %t6, %t5
  %t8 = lshr i8 %t7, 1
  %t9 = mul i8 %t8, %t4
  %a10 = add i8 %t9, %a1
  ret i8 %a10
}

; Values are loaded. Only check signed case.

define i8 @scalar_i8_signed_mem_reg(ptr %a1_addr, i8 %a2) nounwind {
; X64-LABEL: scalar_i8_signed_mem_reg:
; X64:       # %bb.0:
; X64-NEXT:    movsbl (%rdi), %ecx
; X64-NEXT:    cmpb %sil, %cl
; X64-NEXT:    setg %dl
; X64-NEXT:    negb %dl
; X64-NEXT:    orb $1, %dl
; X64-NEXT:    movl %ecx, %edi
; X64-NEXT:    subl %esi, %edi
; X64-NEXT:    movsbl %sil, %eax
; X64-NEXT:    subl %ecx, %eax
; X64-NEXT:    cmovll %edi, %eax
; X64-NEXT:    shrb %al
; X64-NEXT:    # kill: def $al killed $al killed $eax
; X64-NEXT:    mulb %dl
; X64-NEXT:    addb %cl, %al
; X64-NEXT:    retq
;
; X86-LABEL: scalar_i8_signed_mem_reg:
; X86:       # %bb.0:
; X86-NEXT:    movb {{[0-9]+}}(%esp), %ah
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movzbl (%ecx), %ecx
; X86-NEXT:    cmpb %ah, %cl
; X86-NEXT:    setg %dl
; X86-NEXT:    negb %dl
; X86-NEXT:    orb $1, %dl
; X86-NEXT:    movb %cl, %al
; X86-NEXT:    subb %ah, %al
; X86-NEXT:    jg .LBB17_2
; X86-NEXT:  # %bb.1:
; X86-NEXT:    subb %cl, %ah
; X86-NEXT:    movb %ah, %al
; X86-NEXT:  .LBB17_2:
; X86-NEXT:    shrb %al
; X86-NEXT:    mulb %dl
; X86-NEXT:    addb %cl, %al
; X86-NEXT:    retl
  %a1 = load i8, ptr %a1_addr
  %t3 = icmp sgt i8 %a1, %a2 ; signed
  %t4 = select i1 %t3, i8 -1, i8 1
  %t5 = select i1 %t3, i8 %a2, i8 %a1
  %t6 = select i1 %t3, i8 %a1, i8 %a2
  %t7 = sub i8 %t6, %t5
  %t8 = lshr i8 %t7, 1
  %t9 = mul nsw i8 %t8, %t4 ; signed
  %a10 = add nsw i8 %t9, %a1 ; signed
  ret i8 %a10
}

define i8 @scalar_i8_signed_reg_mem(i8 %a1, ptr %a2_addr) nounwind {
; X64-LABEL: scalar_i8_signed_reg_mem:
; X64:       # %bb.0:
; X64-NEXT:    movsbl (%rsi), %eax
; X64-NEXT:    cmpb %al, %dil
; X64-NEXT:    setg %cl
; X64-NEXT:    negb %cl
; X64-NEXT:    orb $1, %cl
; X64-NEXT:    movsbl %dil, %edx
; X64-NEXT:    subl %eax, %edi
; X64-NEXT:    subl %edx, %eax
; X64-NEXT:    cmovll %edi, %eax
; X64-NEXT:    shrb %al
; X64-NEXT:    # kill: def $al killed $al killed $eax
; X64-NEXT:    mulb %cl
; X64-NEXT:    addb %dl, %al
; X64-NEXT:    retq
;
; X86-LABEL: scalar_i8_signed_reg_mem:
; X86:       # %bb.0:
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movb (%eax), %ah
; X86-NEXT:    cmpb %ah, %cl
; X86-NEXT:    setg %dl
; X86-NEXT:    negb %dl
; X86-NEXT:    orb $1, %dl
; X86-NEXT:    movb %cl, %al
; X86-NEXT:    subb %ah, %al
; X86-NEXT:    jg .LBB18_2
; X86-NEXT:  # %bb.1:
; X86-NEXT:    subb %cl, %ah
; X86-NEXT:    movb %ah, %al
; X86-NEXT:  .LBB18_2:
; X86-NEXT:    shrb %al
; X86-NEXT:    mulb %dl
; X86-NEXT:    addb %cl, %al
; X86-NEXT:    retl
  %a2 = load i8, ptr %a2_addr
  %t3 = icmp sgt i8 %a1, %a2 ; signed
  %t4 = select i1 %t3, i8 -1, i8 1
  %t5 = select i1 %t3, i8 %a2, i8 %a1
  %t6 = select i1 %t3, i8 %a1, i8 %a2
  %t7 = sub i8 %t6, %t5
  %t8 = lshr i8 %t7, 1
  %t9 = mul nsw i8 %t8, %t4 ; signed
  %a10 = add nsw i8 %t9, %a1 ; signed
  ret i8 %a10
}

define i8 @scalar_i8_signed_mem_mem(ptr %a1_addr, ptr %a2_addr) nounwind {
; X64-LABEL: scalar_i8_signed_mem_mem:
; X64:       # %bb.0:
; X64-NEXT:    movsbl (%rdi), %ecx
; X64-NEXT:    movsbl (%rsi), %eax
; X64-NEXT:    cmpb %al, %cl
; X64-NEXT:    setg %dl
; X64-NEXT:    negb %dl
; X64-NEXT:    orb $1, %dl
; X64-NEXT:    movl %ecx, %esi
; X64-NEXT:    subl %eax, %esi
; X64-NEXT:    subl %ecx, %eax
; X64-NEXT:    cmovll %esi, %eax
; X64-NEXT:    shrb %al
; X64-NEXT:    # kill: def $al killed $al killed $eax
; X64-NEXT:    mulb %dl
; X64-NEXT:    addb %cl, %al
; X64-NEXT:    retq
;
; X86-LABEL: scalar_i8_signed_mem_mem:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movzbl (%ecx), %ecx
; X86-NEXT:    movb (%eax), %ah
; X86-NEXT:    cmpb %ah, %cl
; X86-NEXT:    setg %dl
; X86-NEXT:    negb %dl
; X86-NEXT:    orb $1, %dl
; X86-NEXT:    movb %cl, %al
; X86-NEXT:    subb %ah, %al
; X86-NEXT:    jg .LBB19_2
; X86-NEXT:  # %bb.1:
; X86-NEXT:    subb %cl, %ah
; X86-NEXT:    movb %ah, %al
; X86-NEXT:  .LBB19_2:
; X86-NEXT:    shrb %al
; X86-NEXT:    mulb %dl
; X86-NEXT:    addb %cl, %al
; X86-NEXT:    retl
  %a1 = load i8, ptr %a1_addr
  %a2 = load i8, ptr %a2_addr
  %t3 = icmp sgt i8 %a1, %a2 ; signed
  %t4 = select i1 %t3, i8 -1, i8 1
  %t5 = select i1 %t3, i8 %a2, i8 %a1
  %t6 = select i1 %t3, i8 %a1, i8 %a2
  %t7 = sub i8 %t6, %t5
  %t8 = lshr i8 %t7, 1
  %t9 = mul nsw i8 %t8, %t4 ; signed
  %a10 = add nsw i8 %t9, %a1 ; signed
  ret i8 %a10
}
