; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -passes=simplifycfg -sink-common-insts -simplifycfg-require-and-preserve-domtree=1 -S < %s | FileCheck %s

define ptr @test_sink_gep(i1 %c, ptr %p) {
; CHECK-LABEL: @test_sink_gep(
; CHECK-NEXT:  join:
; CHECK-NEXT:    [[GEP2:%.*]] = getelementptr i32, ptr [[P:%.*]], i64 1
; CHECK-NEXT:    ret ptr [[GEP2]]
;
  br i1 %c, label %if, label %else

if:
  %gep1 = getelementptr i32, ptr %p, i64 1
  br label %join

else:
  %gep2 = getelementptr i32, ptr %p, i64 1
  br label %join

join:
  %phi = phi ptr [ %gep1, %if ], [ %gep2, %else]
  ret ptr %phi
}

define ptr @test_sink_gep_different_types(i1 %c, ptr %p) {
; CHECK-LABEL: @test_sink_gep_different_types(
; CHECK-NEXT:  join:
; CHECK-NEXT:    [[GEP1:%.*]] = getelementptr i32, ptr [[P:%.*]], i64 1
; CHECK-NEXT:    [[GEP2:%.*]] = getelementptr i64, ptr [[P]], i64 1
; CHECK-NEXT:    [[PHI:%.*]] = select i1 [[C:%.*]], ptr [[GEP1]], ptr [[GEP2]]
; CHECK-NEXT:    ret ptr [[PHI]]
;
  br i1 %c, label %if, label %else

if:
  %gep1 = getelementptr i32, ptr %p, i64 1
  br label %join

else:
  %gep2 = getelementptr i64, ptr %p, i64 1
  br label %join

join:
  %phi = phi ptr [ %gep1, %if ], [ %gep2, %else]
  ret ptr %phi
}

define void @test_cond_store_merge(i1 %arg, i1 %arg2, ptr %p) {
; CHECK-LABEL: @test_cond_store_merge(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    br i1 [[ARG:%.*]], label [[BB2:%.*]], label [[BB3:%.*]]
; CHECK:       bb2:
; CHECK-NEXT:    store i64 0, ptr [[P:%.*]], align 32
; CHECK-NEXT:    br label [[BB3]]
; CHECK:       bb3:
; CHECK-NEXT:    br i1 [[ARG2:%.*]], label [[BB4:%.*]], label [[BB5:%.*]]
; CHECK:       bb4:
; CHECK-NEXT:    store double 0.000000e+00, ptr [[P]], align 32
; CHECK-NEXT:    br label [[BB5]]
; CHECK:       bb5:
; CHECK-NEXT:    ret void
;
bb:
  br i1 %arg, label %bb2, label %bb3

bb2:                                              ; preds = %bb
  store i64 0, ptr %p, align 32
  br label %bb3

bb3:                                              ; preds = %bb2, %bb
  br i1 %arg2, label %bb4, label %bb5

bb4:                                              ; preds = %bb3
  store double 0.000000e+00, ptr %p, align 32
  br label %bb5

bb5:                                              ; preds = %bb4, %bb3
  ret void
}
