; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512f,+avx512dq | FileCheck %s --check-prefix=AVX512
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512f,+avx512dq,+avx512vl | FileCheck %s --check-prefix=AVX512VL

define <16 x i16> @PR156256(<16 x i32> %a, <16 x i32> %b) {
; AVX512-LABEL: PR156256:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpcmpnleud %zmm1, %zmm0, %k0
; AVX512-NEXT:    vpmovm2d %k0, %zmm0
; AVX512-NEXT:    vpmovdw %zmm0, %ymm0
; AVX512-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX512-NEXT:    retq
;
; AVX512VL-LABEL: PR156256:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpcmpnleud %zmm1, %zmm0, %k0
; AVX512VL-NEXT:    vpmovm2d %k0, %zmm0
; AVX512VL-NEXT:    vpmovdw %zmm0, %ymm0
; AVX512VL-NEXT:    vpandd {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to8}, %ymm0, %ymm0
; AVX512VL-NEXT:    retq
  %icmp = icmp ugt <16 x i32> %a, %b
  %sext = sext <16 x i1> %icmp to <16 x i16>
  %and = and <16 x i16> %sext, splat (i16 16256)
  ret <16 x i16> %and
}
