
#ifndef ASSERT_OCTAVE_H
#define ASSERT_OCTAVE_H

#include <octave/oct.h>
namespace cgreen
{
  //! This is a custom function modeled after 'assert()' from GNU Octave
  //!
  //! It compares two Octave Matrices, and produces a readible error if
  //! a difference between two elements exceeds TOL
  #define assert_matrix_equal_with_tol(A, B, TOL) \
          assert_matrix_equal_with_tol_ ((A), #A,(B), #B, (TOL))

  //! This is the underlying function called by assert_matrix_equal_with_tol macro
  void assert_matrix_equal_with_tol_ (const Matrix &a, const char* name_a,
                                      const Matrix &b, const char* name_b,
                                      double tol);
}
#endif
