#include <octave/oct.h>
#include <octave/octave.h>
#include <cgreen/cgreen.h>

#include "../../Permute_random_fcn.h"

using namespace cgreen;

double data_random [] = {1,2,3,4,5,6,7,8,9,10};

Ensure (exch_moves_element_from_n1_and_places_it_in_n2)
{
  Matrix mat (10,1);
  memcpy (mat.fortran_vec (), data_random, sizeof (data_random));
  Permute_random_fcn perm_f (&mat, Matrix ());
  octave_idx_type n1, n2;
  perm_f.permute (n1, n2);

  // Perform test
  double value_n1 = mat(n1), value_n2 = mat(n2);
  perm_f.exch (n1, n2);
  assert_that_double (mat(n1), is_equal_to_double (value_n2));
  assert_that_double (mat(n2), is_equal_to_double (value_n1));
}

Ensure (when_exclude_covers_all_indexes_constructor_raises_error)
{
  Matrix mat (10,1);
  memcpy (mat.fortran_vec (), data_random, sizeof (data_random));
  mat = mat - 1;

  // Perform test
  Permute_random_fcn perm_f (&mat, mat);
  assert_that (error_state, is_true);
}

Ensure (exclude_values_out_of_bounds_raise_error)
{
  Matrix mat (10,1);
  Matrix exclude (2,1);
  exclude(0) = 1;
  exclude(1) = 10;

  // Perform test
  Permute_random_fcn perm_f (&mat, exclude);
  assert_that (error_state, is_true);
}

void prepare_permute_random()
{
  // Launch octave interpreter
  // This is required for the constructor to work
  string_vector argv (2);
  argv(0) = "embedded";
  argv(1) = "-q";

  octave_main (2, argv.c_str_vec (), 1);

  // Discard error messages to have less clutter
  discard_error_messages = true;

  // seed the random generator
  srand (time (NULL));
}

TestSuite *permute_random_tests ()
{
  TestSuite *suite = create_test_suite ();
  set_setup (suite, prepare_permute_random);
  add_test (suite, exch_moves_element_from_n1_and_places_it_in_n2);
  add_test (suite, when_exclude_covers_all_indexes_constructor_raises_error);
  add_test (suite, exclude_values_out_of_bounds_raise_error);
  return suite;
}
