#include <cmath>
#include "normal.h"

void rms (const Matrix &x, double &sc, double &sd)
{
  sc = 0;
  const double *x_ptr = x.fortran_vec ();
  for (octave_idx_type i = 0; i < x.rows (); i++)
    sc += x_ptr[i];
  sc = sc / (double) x.rows ();
  sd = 0;
  for (octave_idx_type i = 0; i < x.rows (); i++)
    sd += (x_ptr[i] - sc) * (x_ptr[i] - sc);
  sd = sqrt (sd / (double) x.rows ());
}

void normal1 (Matrix &x, double &sc, double &sd)
{
  rms (x, sc, sd);

  if (sd == 0.0)
    error_with_id ("Octave:tisean", "zero variance cannot normalize");
  else
    x = (x - sc) / sd;
}
