/*
 * This file was generated automatically by ExtUtils::ParseXS version 3.51 from the
 * contents of Tooltip.xs. Do not edit this file, edit Tooltip.xs instead.
 *
 *    ANY CHANGES MADE HERE WILL BE LOST!
 *
 */

#line 1 "Tooltip.xs"
    /*
    ###########################################################################
    # (@)PACKAGE:Win32::GUI::Tooltip
    #
    # $Id: Tooltip.xs,v 1.11 2010/04/08 21:26:48 jwgui Exp $
    #
    ###########################################################################
    */

#include "GUI.h"

void 
Tooltip_onPreCreate(NOTXSPROC LPPERLWIN32GUI_CREATESTRUCT perlcs) {

    perlcs->cs.lpszClass = TOOLTIPS_CLASS;
    perlcs->cs.style = TTS_ALWAYSTIP;
    perlcs->cs.dwExStyle = WS_EX_TOPMOST;
}

BOOL
Tooltip_onParseOption(NOTXSPROC char *option, SV* value, LPPERLWIN32GUI_CREATESTRUCT perlcs) {
    BOOL retval = TRUE;

    if BitmaskOptionValue("-alwaystip", perlcs->cs.style, TTS_ALWAYSTIP)
    } else if BitmaskOptionValue("-noprefix", perlcs->cs.style, TTS_NOPREFIX )    
    } else if BitmaskOptionValue("-noanimate", perlcs->cs.style, TTS_NOANIMATE )    
    } else if BitmaskOptionValue("-noface", perlcs->cs.style, TTS_NOFADE )    
    } else if BitmaskOptionValue("-balloon", perlcs->cs.style, TTS_BALLOON )    
    } else retval= FALSE;

    return retval;
}

void 
Tooltip_onPostCreate(NOTXSPROC HWND myhandle, LPPERLWIN32GUI_CREATESTRUCT perlcs) {

    if(perlcs->clrForeground != CLR_INVALID) {
        SendMessage(myhandle, TTM_SETTIPTEXTCOLOR, (WPARAM) perlcs->clrForeground, (LPARAM) 0);
        perlcs->clrForeground = CLR_INVALID;  // Don't Store
    }
    if(perlcs->clrBackground != CLR_INVALID) {
        SendMessage(myhandle, TTM_SETTIPBKCOLOR, (WPARAM) perlcs->clrBackground, (LPARAM) 0);
        perlcs->clrBackground = CLR_INVALID;  // Don't Store
    }
}

BOOL
Tooltip_onParseEvent(NOTXSPROC char *name, int* eventID) {

    BOOL retval = TRUE;

         if Parse_Event("NeedText",    PERLWIN32GUI_NEM_CONTROL1)
    else if Parse_Event("Pop",         PERLWIN32GUI_NEM_CONTROL2)
    else if Parse_Event("Show",        PERLWIN32GUI_NEM_CONTROL3)
    else retval = FALSE;

    return retval;
}

int
Tooltip_onEvent (NOTXSPROC LPPERLWIN32GUI_USERDATA perlud, UINT uMsg, WPARAM wParam, LPARAM lParam) {

    int PerlResult = 1;

    if ( uMsg == WM_NOTIFY ) {

        LPNMHDR notify = (LPNMHDR) lParam;

        switch(notify->code) {

        case TTN_NEEDTEXT :
            /*
             * (@)EVENT:NeedText(TOOL,FLAG)
             * Sent when a tooltip window needs to get the text for a tool
             * created with C<< -needtext => 1 >>.
             *
             * TOOL is the identifier of the tool: it is the window handle
             * of the tool if FLAG is TRUE, otherwise it is the tool ID.
             *
             * Return a string from the event handler containing the text
             * to be displayed.
             * (@)APPLIES_TO:Tooltip
             */
            {
            LPTOOLTIPTEXT lptt = (LPTOOLTIPTEXT) lParam;
            lptt->lpszText = (LPTSTR) DoEvent_NeedText(NOTXSCALL perlud, PERLWIN32GUI_NEM_CONTROL1, "NeedText",
                    PERLWIN32GUI_ARGTYPE_LONG, (LONG)lptt->hdr.idFrom,
                    PERLWIN32GUI_ARGTYPE_LONG, (LONG)(lptt->uFlags & TTF_IDISHWND ? 1 : 0),
                    -1);

            PerlResult = 1;
            }
            break;
        case TTN_POP:
            /*
             * (@)EVENT:Pop(TOOL,FLAG)
             * Sent whenever a tooltip window has just been hidden
             *
             * TOOL is the identifier of the tool: it is the window handle
             * of the tool if FLAG is TRUE, otherwise it is the tool ID.
             * (@)APPLIES_TO:Tooltip
             */
            PerlResult = DoEvent(NOTXSCALL perlud, PERLWIN32GUI_NEM_CONTROL2, "Pop",
                    PERLWIN32GUI_ARGTYPE_LONG, (LONG) wParam,
                    PERLWIN32GUI_ARGTYPE_LONG, (LONG)(IsWindow((HWND)wParam) ? 1 : 0),
                    -1);
            break;
        case TTN_SHOW:
            /*
             * (@)EVENT:Show(TOOL,FLAG)
             * Sent whenever a tooltip window is just about to be displayed
             *
             * TOOL is the identifier of the tool: it is the window handle
             * of the tool if FLAG is TRUE, otherwise it is the tool ID.
             * (@)APPLIES_TO:Tooltip
             */
            PerlResult = DoEvent(NOTXSCALL perlud, PERLWIN32GUI_NEM_CONTROL3, "Show",
                    PERLWIN32GUI_ARGTYPE_LONG, (LONG) wParam,
                    PERLWIN32GUI_ARGTYPE_LONG, (LONG)(IsWindow((HWND)wParam) ? 1 : 0),
                    -1);
            break;
        }
    }

    return PerlResult;
}

/* Given an SV* that we expect to be a TOOL (see documentation)
 * populate the hwnd and uId members of the passed TOOLINFO
 * structure
 */
void
ToolInfoFromTool(NOTXSPROC HWND handle, SV* tool, TOOLINFO *ti) {
    AV*  array;
    I32  alen;
    SV** value;

    if(SvROK(tool) && SvTYPE(SvRV(tool)) == SVt_PVAV) {
        /* Tool is an array reference */
        array = (AV*)SvRV(tool);
        alen  = av_len(array);
        if(alen > -1) {
            value = av_fetch(array, 0, 0);
            if(value) {
                ti->hwnd = handle_From(NOTXSCALL *value);
            } else {
                CROAK("Problem with TOOL array reference, index 0");
            }
            if(alen > 0) {
                value = av_fetch(array, 1, 0);
                if(value) {
                    ti->uId = INT2PTR(UINT_PTR, SvIV(*value));
                } else {
                    CROAK("Problem with TOOL array reference, index 1");
                }
            } else {
                ti->uId = (UINT_PTR)(ti->hwnd);
            }
        } else {
            CROAK("TOOL array refence is empty");
        }
    } else {
        /* Tool is Window or ID */
        /* This is broken, as there is nothing stopping IDs and window
         * handles clashing, but kept for
         * (1) backwards compatability
         * (2) allowing the most common simple case of WINDOW */
        ti->uId  = (UINT_PTR)(handle_From(NOTXSCALL tool));
        if(IsWindow((HWND)ti->uId)) {
            ti->hwnd = (HWND)ti->uId;
        } else {
            ti->hwnd = (HWND)GetWindowLongPtr(handle, GWLP_HWNDPARENT);
        }
    }

    return;
}

#line 189 "Tooltip.c"
#ifndef PERL_UNUSED_VAR
#  define PERL_UNUSED_VAR(var) if (0) var = var
#endif

#ifndef dVAR
#  define dVAR		dNOOP
#endif


/* This stuff is not part of the API! You have been warned. */
#ifndef PERL_VERSION_DECIMAL
#  define PERL_VERSION_DECIMAL(r,v,s) (r*1000000 + v*1000 + s)
#endif
#ifndef PERL_DECIMAL_VERSION
#  define PERL_DECIMAL_VERSION \
	  PERL_VERSION_DECIMAL(PERL_REVISION,PERL_VERSION,PERL_SUBVERSION)
#endif
#ifndef PERL_VERSION_GE
#  define PERL_VERSION_GE(r,v,s) \
	  (PERL_DECIMAL_VERSION >= PERL_VERSION_DECIMAL(r,v,s))
#endif
#ifndef PERL_VERSION_LE
#  define PERL_VERSION_LE(r,v,s) \
	  (PERL_DECIMAL_VERSION <= PERL_VERSION_DECIMAL(r,v,s))
#endif

/* XS_INTERNAL is the explicit static-linkage variant of the default
 * XS macro.
 *
 * XS_EXTERNAL is the same as XS_INTERNAL except it does not include
 * "STATIC", ie. it exports XSUB symbols. You probably don't want that
 * for anything but the BOOT XSUB.
 *
 * See XSUB.h in core!
 */


/* TODO: This might be compatible further back than 5.10.0. */
#if PERL_VERSION_GE(5, 10, 0) && PERL_VERSION_LE(5, 15, 1)
#  undef XS_EXTERNAL
#  undef XS_INTERNAL
#  if defined(__CYGWIN__) && defined(USE_DYNAMIC_LOADING)
#    define XS_EXTERNAL(name) __declspec(dllexport) XSPROTO(name)
#    define XS_INTERNAL(name) STATIC XSPROTO(name)
#  endif
#  if defined(__SYMBIAN32__)
#    define XS_EXTERNAL(name) EXPORT_C XSPROTO(name)
#    define XS_INTERNAL(name) EXPORT_C STATIC XSPROTO(name)
#  endif
#  ifndef XS_EXTERNAL
#    if defined(HASATTRIBUTE_UNUSED) && !defined(__cplusplus)
#      define XS_EXTERNAL(name) void name(pTHX_ CV* cv __attribute__unused__)
#      define XS_INTERNAL(name) STATIC void name(pTHX_ CV* cv __attribute__unused__)
#    else
#      ifdef __cplusplus
#        define XS_EXTERNAL(name) extern "C" XSPROTO(name)
#        define XS_INTERNAL(name) static XSPROTO(name)
#      else
#        define XS_EXTERNAL(name) XSPROTO(name)
#        define XS_INTERNAL(name) STATIC XSPROTO(name)
#      endif
#    endif
#  endif
#endif

/* perl >= 5.10.0 && perl <= 5.15.1 */


/* The XS_EXTERNAL macro is used for functions that must not be static
 * like the boot XSUB of a module. If perl didn't have an XS_EXTERNAL
 * macro defined, the best we can do is assume XS is the same.
 * Dito for XS_INTERNAL.
 */
#ifndef XS_EXTERNAL
#  define XS_EXTERNAL(name) XS(name)
#endif
#ifndef XS_INTERNAL
#  define XS_INTERNAL(name) XS(name)
#endif

/* Now, finally, after all this mess, we want an ExtUtils::ParseXS
 * internal macro that we're free to redefine for varying linkage due
 * to the EXPORT_XSUB_SYMBOLS XS keyword. This is internal, use
 * XS_EXTERNAL(name) or XS_INTERNAL(name) in your code if you need to!
 */

#undef XS_EUPXS
#if defined(PERL_EUPXS_ALWAYS_EXPORT)
#  define XS_EUPXS(name) XS_EXTERNAL(name)
#else
   /* default to internal */
#  define XS_EUPXS(name) XS_INTERNAL(name)
#endif

#ifndef PERL_ARGS_ASSERT_CROAK_XS_USAGE
#define PERL_ARGS_ASSERT_CROAK_XS_USAGE assert(cv); assert(params)

/* prototype to pass -Wmissing-prototypes */
STATIC void
S_croak_xs_usage(const CV *const cv, const char *const params);

STATIC void
S_croak_xs_usage(const CV *const cv, const char *const params)
{
    const GV *const gv = CvGV(cv);

    PERL_ARGS_ASSERT_CROAK_XS_USAGE;

    if (gv) {
        const char *const gvname = GvNAME(gv);
        const HV *const stash = GvSTASH(gv);
        const char *const hvname = stash ? HvNAME(stash) : NULL;

        if (hvname)
	    Perl_croak_nocontext("Usage: %s::%s(%s)", hvname, gvname, params);
        else
	    Perl_croak_nocontext("Usage: %s(%s)", gvname, params);
    } else {
        /* Pants. I don't think that it should be possible to get here. */
	Perl_croak_nocontext("Usage: CODE(0x%" UVxf ")(%s)", PTR2UV(cv), params);
    }
}
#undef  PERL_ARGS_ASSERT_CROAK_XS_USAGE

#define croak_xs_usage        S_croak_xs_usage

#endif

/* NOTE: the prototype of newXSproto() is different in versions of perls,
 * so we define a portable version of newXSproto()
 */
#ifdef newXS_flags
#define newXSproto_portable(name, c_impl, file, proto) newXS_flags(name, c_impl, file, proto, 0)
#else
#define newXSproto_portable(name, c_impl, file, proto) (PL_Sv=(SV*)newXS(name, c_impl, file), sv_setpv(PL_Sv, proto), (CV*)PL_Sv)
#endif /* !defined(newXS_flags) */

#if PERL_VERSION_LE(5, 21, 5)
#  define newXS_deffile(a,b) Perl_newXS(aTHX_ a,b,file)
#else
#  define newXS_deffile(a,b) Perl_newXS_deffile(aTHX_ a,b)
#endif

#line 333 "Tooltip.c"
#pragma message( "*** PACKAGE Win32::GUI::Tooltip..." )

XS_EUPXS(XS_Win32__GUI__Tooltip_Activate); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Win32__GUI__Tooltip_Activate)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "handle, value=TRUE");
    {
	HWND	handle;
	WPARAM	value;
	LRESULT	RETVAL;
	dXSTARG;

    if(SvROK(ST(0))) {
        SV** out=hv_fetch((HV*)SvRV(ST(0)), "-handle", 7, 0);
        if(out != NULL)
            handle = INT2PTR(HWND,SvIV(*out));
        else
            handle = NULL;
    } else
       handle = INT2PTR(HWND,SvIV(ST(0)))
;

	if (items < 2)
	    value = TRUE;
	else {
	    value = (WPARAM)SvUV(ST(1))
;
	}
#line 194 "Tooltip.xs"
    RETVAL = SendMessage(handle, TTM_ACTIVATE, value, 0);
#line 366 "Tooltip.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Win32__GUI__Tooltip_AddTool); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Win32__GUI__Tooltip_AddTool)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items < 1)
       croak_xs_usage(cv,  "handle, ...");
    {
	HWND	handle;
#line 260 "Tooltip.xs"
    TOOLINFO ti;
#line 385 "Tooltip.c"
	BOOL	RETVAL;
	dXSTARG;

    if(SvROK(ST(0))) {
        SV** out=hv_fetch((HV*)SvRV(ST(0)), "-handle", 7, 0);
        if(out != NULL)
            handle = INT2PTR(HWND,SvIV(*out));
        else
            handle = NULL;
    } else
       handle = INT2PTR(HWND,SvIV(ST(0)))
;
#line 262 "Tooltip.xs"
    ZeroMemory(&ti, sizeof(TOOLINFO));
    ti.cbSize = sizeof(TOOLINFO);
    ti.hwnd = (HWND) GetWindowLongPtr(handle, GWLP_HWNDPARENT);
    ParseTooltipOptions(NOTXSCALL sp, mark, ax, items, 1, &ti);
    RETVAL = SendMessage(handle, TTM_ADDTOOL, 0, (LPARAM) &ti);
#line 404 "Tooltip.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Win32__GUI__Tooltip_Adjustrect); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Win32__GUI__Tooltip_Adjustrect)
{
    dVAR; dXSARGS;
    if (items < 5 || items > 6)
       croak_xs_usage(cv,  "handle, left, top, right, bottom, larger=1");
    {
	HWND	handle;
	LONG	left = (LONG)SvIV(ST(1))
;
	LONG	top = (LONG)SvIV(ST(2))
;
	LONG	right = (LONG)SvIV(ST(3))
;
	LONG	bottom = (LONG)SvIV(ST(4))
;
	BOOL	larger;
#line 291 "Tooltip.xs"
    RECT r;
#line 431 "Tooltip.c"

    if(SvROK(ST(0))) {
        SV** out=hv_fetch((HV*)SvRV(ST(0)), "-handle", 7, 0);
        if(out != NULL)
            handle = INT2PTR(HWND,SvIV(*out));
        else
            handle = NULL;
    } else
       handle = INT2PTR(HWND,SvIV(ST(0)))
;

	if (items < 6)
	    larger = 1;
	else {
	    larger = (BOOL)SvIV(ST(5))
;
	}
#line 293 "Tooltip.xs"
    r.left   = left;
    r.top    = top;
    r.right  = right;
    r.bottom = bottom;

    if(SendMessage(handle,TTM_ADJUSTRECT,(WPARAM)larger,(LPARAM)&r)) {
        EXTEND(SP, 4);
        XST_mIV(0, r.left);
        XST_mIV(1, r.top);
        XST_mIV(2, r.right);
        XST_mIV(3, r.bottom);
        XSRETURN(4);
    }
    XSRETURN_EMPTY;
#line 464 "Tooltip.c"
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Win32__GUI__Tooltip_DelTool); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Win32__GUI__Tooltip_DelTool)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 2)
       croak_xs_usage(cv,  "handle, tool");
    {
	HWND	handle;
	SV*	tool = ST(1)
;
#line 340 "Tooltip.xs"
    TOOLINFO ti;
#line 483 "Tooltip.c"
	BOOL	RETVAL;
	dXSTARG;

    if(SvROK(ST(0))) {
        SV** out=hv_fetch((HV*)SvRV(ST(0)), "-handle", 7, 0);
        if(out != NULL)
            handle = INT2PTR(HWND,SvIV(*out));
        else
            handle = NULL;
    } else
       handle = INT2PTR(HWND,SvIV(ST(0)))
;
#line 342 "Tooltip.xs"
    ZeroMemory(&ti, sizeof(TOOLINFO));
    ti.cbSize = sizeof(TOOLINFO);
    ToolInfoFromTool(NOTXSCALL handle, tool, &ti);
    RETVAL = SendMessage(handle, TTM_DELTOOL, 0, (LPARAM) &ti);
#line 501 "Tooltip.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Win32__GUI__Tooltip_EnumTools); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Win32__GUI__Tooltip_EnumTools)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "handle, enum_id, bufsize=0");
    {
	HWND	handle;
	HWND	enum_id;
	int	bufsize;
#line 391 "Tooltip.xs"
    TOOLINFO ti;
    int count = 0;
    LPSTR tip = NULL;
    AV* rect;
#line 524 "Tooltip.c"

    if(SvROK(ST(0))) {
        SV** out=hv_fetch((HV*)SvRV(ST(0)), "-handle", 7, 0);
        if(out != NULL)
            handle = INT2PTR(HWND,SvIV(*out));
        else
            handle = NULL;
    } else
       handle = INT2PTR(HWND,SvIV(ST(0)))
;

    if(SvROK(ST(1))) {
        SV** out=hv_fetch((HV*)SvRV(ST(1)), "-handle", 7, 0);
        if(out != NULL)
            enum_id = INT2PTR(HWND,SvIV(*out));
        else
            enum_id = NULL;
    } else
       enum_id = INT2PTR(HWND,SvIV(ST(1)))
;

	if (items < 3)
	    bufsize = 0;
	else {
	    bufsize = (int)SvIV(ST(2))
;
	}
#line 396 "Tooltip.xs"
    ZeroMemory(&ti, sizeof(TOOLINFO));
    ti.cbSize = sizeof(TOOLINFO);
    if (bufsize > 0) {
        Newz(0, tip, bufsize, CHAR);
        ti.lpszText = tip;
    }
    if (SendMessage(handle, TTM_ENUMTOOLS, (WPARAM) enum_id, (LPARAM) &ti)) {
        if(tip) {
            /* ensure tip is NULL terminated, even if we overran the buffer
             * to minimise damage - of course it may already be too late
             */
            tip[bufsize-1] = 0;
        }
        EXTEND(SP, 12);
        XST_mPV(count++, "-window");
        if(ti.uFlags & TTF_IDISHWND) {
            XST_mIV(count++, PTR2IV(ti.uId));
        } else {
            XST_mIV(count++, PTR2IV(ti.hwnd));
            XST_mPV(count++, "-id");
            XST_mIV(count++, ti.uId);
            XST_mPV(count++, "-rect");
            rect = newAV();
            av_push(rect,newSViv(ti.rect.left));
            av_push(rect,newSViv(ti.rect.top));
            av_push(rect,newSViv(ti.rect.right));
            av_push(rect,newSViv(ti.rect.bottom));
            ST(count++) = sv_2mortal(newRV_noinc((SV*)rect));
        }
        if (ti.lpszText != NULL) {
            if (ti.lpszText == LPSTR_TEXTCALLBACK) {
                XST_mPV(count++, "-needtext");
                XST_mIV(count++, 1);
            } else if (IS_INTRESOURCE(ti.lpszText)) {
                XST_mPV(count++, "-text");
                XST_mIV(count++, PTR2IV(ti.lpszText));
                XST_mPV(count++, "-hinst");
                XST_mIV(count++, PTR2IV(ti.hinst));
            } else {
                XST_mPV(count++, "-text");
                XST_mPV(count++, ti.lpszText);
            }
        }
        XST_mPV(count++, "-flag");  /* TODO: Decode flags? */
        XST_mIV(count++, ti.uFlags);
    }
    if(tip)
        Safefree(tip);
    XSRETURN(count);
#line 602 "Tooltip.c"
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Win32__GUI__Tooltip_GetBubbleSize); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Win32__GUI__Tooltip_GetBubbleSize)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "handle, tool");
    {
	HWND	handle;
	SV*	tool = ST(1)
;
#line 477 "Tooltip.xs"
    TOOLINFO ti;
    LRESULT r;
#line 621 "Tooltip.c"

    if(SvROK(ST(0))) {
        SV** out=hv_fetch((HV*)SvRV(ST(0)), "-handle", 7, 0);
        if(out != NULL)
            handle = INT2PTR(HWND,SvIV(*out));
        else
            handle = NULL;
    } else
       handle = INT2PTR(HWND,SvIV(ST(0)))
;
#line 480 "Tooltip.xs"
    ZeroMemory(&ti, sizeof(TOOLINFO));
    ti.cbSize = sizeof(TOOLINFO);
    ToolInfoFromTool(NOTXSCALL handle, tool, &ti);

    if(SendMessage(handle,TTM_GETTOOLINFO,0,(LPARAM)&ti)) {
        if(r = SendMessage(handle,TTM_GETBUBBLESIZE,0,(LPARAM)&ti)) {  /* TODO: why crash? */
            EXTEND(SP, 2);
            XST_mIV(0, LOWORD(r));  /* width */
            XST_mIV(1, HIWORD(r));  /* height */
            XSRETURN(2);
        }
    }
    XSRETURN_EMPTY;
#line 646 "Tooltip.c"
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Win32__GUI__Tooltip_GetCurrentTool); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Win32__GUI__Tooltip_GetCurrentTool)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "handle, bufsize=0");
    {
	HWND	handle;
	int	bufsize;
#line 514 "Tooltip.xs"
    TOOLINFO ti;
    int count = 0;
    LPSTR tip = NULL;
    AV* rect;
#line 666 "Tooltip.c"

    if(SvROK(ST(0))) {
        SV** out=hv_fetch((HV*)SvRV(ST(0)), "-handle", 7, 0);
        if(out != NULL)
            handle = INT2PTR(HWND,SvIV(*out));
        else
            handle = NULL;
    } else
       handle = INT2PTR(HWND,SvIV(ST(0)))
;

	if (items < 2)
	    bufsize = 0;
	else {
	    bufsize = (int)SvIV(ST(1))
;
	}
#line 519 "Tooltip.xs"
    ZeroMemory(&ti, sizeof(TOOLINFO));
    ti.cbSize = sizeof(TOOLINFO);
    if (bufsize > 0) {
        Newz(0, tip, bufsize, CHAR);
        ti.lpszText = tip;
    }
    if (SendMessage(handle, TTM_GETCURRENTTOOL, (WPARAM) 0, (LPARAM) &ti)) {
        if(tip) {
            /* ensure tip is NULL terminated, even if we overran the buffer
             * to minimise damage - of course it may already be too late
             */
            tip[bufsize-1] = 0;
        }
        EXTEND(SP, 12);
        XST_mPV(count++, "-window");
        if(ti.uFlags & TTF_IDISHWND) {
            XST_mIV(count++, PTR2IV(ti.uId));
        } else {
            XST_mIV(count++, PTR2IV(ti.hwnd));
            XST_mPV(count++, "-id");
            XST_mIV(count++, ti.uId);
            XST_mPV(count++, "-rect");
            rect = newAV();
            av_push(rect,newSViv(ti.rect.left));
            av_push(rect,newSViv(ti.rect.top));
            av_push(rect,newSViv(ti.rect.right));
            av_push(rect,newSViv(ti.rect.bottom));
            ST(count++) = sv_2mortal(newRV_noinc((SV*)rect));
        }
        if (ti.lpszText != NULL) {
            if (ti.lpszText == LPSTR_TEXTCALLBACK) {
                XST_mPV(count++, "-needtext");
                XST_mIV(count++, 1);
            } else if (IS_INTRESOURCE(ti.lpszText)) {
                XST_mPV(count++, "-text");
                XST_mIV(count++, PTR2IV(ti.lpszText));
                XST_mPV(count++, "-hinst");
                XST_mIV(count++, PTR2IV(ti.hinst));
            } else {
                XST_mPV(count++, "-text");
                XST_mPV(count++, ti.lpszText);
            }
        }
        XST_mPV(count++, "-flag");  /* TODO: Decode flags? */
        XST_mIV(count++, ti.uFlags);
    }
    if(tip)
        Safefree(tip);
    XSRETURN(count);
#line 734 "Tooltip.c"
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Win32__GUI__Tooltip_GetDelayTime); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Win32__GUI__Tooltip_GetDelayTime)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "handle, flag=TTDT_INITIAL");
    {
	HWND	handle;
	WPARAM	flag;
	LRESULT	RETVAL;
	dXSTARG;

    if(SvROK(ST(0))) {
        SV** out=hv_fetch((HV*)SvRV(ST(0)), "-handle", 7, 0);
        if(out != NULL)
            handle = INT2PTR(HWND,SvIV(*out));
        else
            handle = NULL;
    } else
       handle = INT2PTR(HWND,SvIV(ST(0)))
;

	if (items < 2)
	    flag = TTDT_INITIAL;
	else {
	    flag = (WPARAM)SvUV(ST(1))
;
	}
#line 592 "Tooltip.xs"
    RETVAL = SendMessage(handle, TTM_GETDELAYTIME, flag, 0);
#line 770 "Tooltip.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Win32__GUI__Tooltip_GetMargin); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Win32__GUI__Tooltip_GetMargin)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "handle");
    {
	HWND	handle;
#line 608 "Tooltip.xs"
    RECT rect;
#line 788 "Tooltip.c"

    if(SvROK(ST(0))) {
        SV** out=hv_fetch((HV*)SvRV(ST(0)), "-handle", 7, 0);
        if(out != NULL)
            handle = INT2PTR(HWND,SvIV(*out));
        else
            handle = NULL;
    } else
       handle = INT2PTR(HWND,SvIV(ST(0)))
;
#line 610 "Tooltip.xs"
    SendMessage(handle, TTM_GETMARGIN, 0, (LPARAM) &rect);
    EXTEND(SP, 4);
    XST_mIV(0, rect.left);
    XST_mIV(1, rect.top);
    XST_mIV(2, rect.right);
    XST_mIV(3, rect.bottom);
    XSRETURN(4);
#line 807 "Tooltip.c"
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Win32__GUI__Tooltip_GetMaxTipWidth); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Win32__GUI__Tooltip_GetMaxTipWidth)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "handle");
    {
	HWND	handle;
	INT	RETVAL;
	dXSTARG;

    if(SvROK(ST(0))) {
        SV** out=hv_fetch((HV*)SvRV(ST(0)), "-handle", 7, 0);
        if(out != NULL)
            handle = INT2PTR(HWND,SvIV(*out));
        else
            handle = NULL;
    } else
       handle = INT2PTR(HWND,SvIV(ST(0)))
;
#line 628 "Tooltip.xs"
    RETVAL = (INT)SendMessage(handle, TTM_GETMAXTIPWIDTH, 0, 0);
#line 835 "Tooltip.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Win32__GUI__Tooltip_GetText); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Win32__GUI__Tooltip_GetText)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "handle, tool, bufsize=0");
    {
	HWND	handle;
	SV*	tool = ST(1)
;
	int	bufsize;
#line 671 "Tooltip.xs"
    TOOLINFO ti;
    LPSTR tip = NULL;
#line 857 "Tooltip.c"

    if(SvROK(ST(0))) {
        SV** out=hv_fetch((HV*)SvRV(ST(0)), "-handle", 7, 0);
        if(out != NULL)
            handle = INT2PTR(HWND,SvIV(*out));
        else
            handle = NULL;
    } else
       handle = INT2PTR(HWND,SvIV(ST(0)))
;

	if (items < 3)
	    bufsize = 0;
	else {
	    bufsize = (int)SvIV(ST(2))
;
	}
#line 674 "Tooltip.xs"
    ZeroMemory(&ti, sizeof(TOOLINFO));
    ti.cbSize = sizeof(TOOLINFO);
    ToolInfoFromTool(NOTXSCALL handle, tool, &ti);

    if (bufsize > 0) {
        Newz(0, tip, bufsize, CHAR);
        ti.lpszText = tip;
    } else {
        W32G_WARN("Calling GetText with a zero buffersize won't do anything useful");
    }

    SendMessage(handle, TTM_GETTEXT, 0, (LPARAM) &ti);

    if(tip) {
        /* ensure tip is NULL terminated, even if we overran the buffer
         * to minimise damage - of course it may already be too late
         */
        tip[bufsize-1] = 0;
    }

    EXTEND(SP, 1);
    if (ti.lpszText != NULL) {
        if (ti.lpszText == LPSTR_TEXTCALLBACK) {
            /* Don't get here: needtext is called and string returned */
        } else if (IS_INTRESOURCE(ti.lpszText)) {
            /* TODO: handle resource id, if necessary */
            W32G_WARN("Resource identifiers not handled - please report this");
        } else {
            XST_mPV(0, ti.lpszText);
        }
    } else {
        XST_mNO(0); /* 0 in numeric context, empty string in string context */
    }
    if(tip)
        Safefree(tip);
    XSRETURN(1);
#line 912 "Tooltip.c"
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Win32__GUI__Tooltip_GetTipBkColor); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Win32__GUI__Tooltip_GetTipBkColor)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "handle");
    {
	HWND	handle;
	COLORREF	RETVAL;
	dXSTARG;

    if(SvROK(ST(0))) {
        SV** out=hv_fetch((HV*)SvRV(ST(0)), "-handle", 7, 0);
        if(out != NULL)
            handle = INT2PTR(HWND,SvIV(*out));
        else
            handle = NULL;
    } else
       handle = INT2PTR(HWND,SvIV(ST(0)))
;
#line 718 "Tooltip.xs"
    RETVAL = (COLORREF) SendMessage(handle, TTM_GETTIPBKCOLOR, 0, 0);
#line 940 "Tooltip.c"
	XSprePUSH;
	PUSHi((IV) RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Win32__GUI__Tooltip_GetTipTextColor); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Win32__GUI__Tooltip_GetTipTextColor)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "handle");
    {
	HWND	handle;
	COLORREF	RETVAL;
	dXSTARG;

    if(SvROK(ST(0))) {
        SV** out=hv_fetch((HV*)SvRV(ST(0)), "-handle", 7, 0);
        if(out != NULL)
            handle = INT2PTR(HWND,SvIV(*out));
        else
            handle = NULL;
    } else
       handle = INT2PTR(HWND,SvIV(ST(0)))
;
#line 729 "Tooltip.xs"
    RETVAL = (COLORREF) SendMessage(handle, TTM_GETTIPTEXTCOLOR, 0, 0);
#line 970 "Tooltip.c"
	XSprePUSH;
	PUSHi((IV) RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Win32__GUI__Tooltip_GetToolCount); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Win32__GUI__Tooltip_GetToolCount)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 1)
       croak_xs_usage(cv,  "handle");
    {
	HWND	handle;
	LRESULT	RETVAL;
	dXSTARG;

    if(SvROK(ST(0))) {
        SV** out=hv_fetch((HV*)SvRV(ST(0)), "-handle", 7, 0);
        if(out != NULL)
            handle = INT2PTR(HWND,SvIV(*out));
        else
            handle = NULL;
    } else
       handle = INT2PTR(HWND,SvIV(ST(0)))
;
#line 743 "Tooltip.xs"
    RETVAL = SendMessage(handle, TTM_GETTOOLCOUNT, 0, 0);
#line 1001 "Tooltip.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Win32__GUI__Tooltip_GetToolInfo); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Win32__GUI__Tooltip_GetToolInfo)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "handle, tool, bufsize=0");
    {
	HWND	handle;
	SV*	tool = ST(1)
;
	int	bufsize;
#line 787 "Tooltip.xs"
    TOOLINFO ti;
    int count = 0;
    LPSTR tip = NULL;
    AV* rect;
#line 1025 "Tooltip.c"

    if(SvROK(ST(0))) {
        SV** out=hv_fetch((HV*)SvRV(ST(0)), "-handle", 7, 0);
        if(out != NULL)
            handle = INT2PTR(HWND,SvIV(*out));
        else
            handle = NULL;
    } else
       handle = INT2PTR(HWND,SvIV(ST(0)))
;

	if (items < 3)
	    bufsize = 0;
	else {
	    bufsize = (int)SvIV(ST(2))
;
	}
#line 792 "Tooltip.xs"
    ZeroMemory(&ti, sizeof(TOOLINFO));
    ti.cbSize = sizeof(TOOLINFO);
    ToolInfoFromTool(NOTXSCALL handle, tool, &ti);
    if (bufsize > 0) {
        Newz(0, tip, bufsize, CHAR);
        ti.lpszText = tip;
    }
    if (SendMessage(handle, TTM_GETTOOLINFO, (WPARAM) 0, (LPARAM) &ti)) {
        if(tip) {
            /* ensure tip is NULL terminated, even if we overran the buffer
             * to minimise damage - of course it may already be too late
             */
            tip[bufsize-1] = 0;
        }
        EXTEND(SP, 12);
        XST_mPV(count++, "-window");
        if(ti.uFlags & TTF_IDISHWND) {
            XST_mIV(count++, PTR2IV(ti.uId));
        } else {
            XST_mIV(count++, PTR2IV(ti.hwnd));
            XST_mPV(count++, "-id");
            XST_mIV(count++, ti.uId);
            XST_mPV(count++, "-rect");
            rect = newAV();
            av_push(rect,newSViv(ti.rect.left));
            av_push(rect,newSViv(ti.rect.top));
            av_push(rect,newSViv(ti.rect.right));
            av_push(rect,newSViv(ti.rect.bottom));
            ST(count++) = sv_2mortal(newRV_noinc((SV*)rect));
        }
        if (ti.lpszText != NULL) {
            if (ti.lpszText == LPSTR_TEXTCALLBACK) {
                XST_mPV(count++, "-needtext");
                XST_mIV(count++, 1);
            } else if (IS_INTRESOURCE(ti.lpszText)) {
                XST_mPV(count++, "-text");
                XST_mIV(count++, PTR2IV(ti.lpszText));
                XST_mPV(count++, "-hinst");
                XST_mIV(count++, PTR2IV(ti.hinst));
            } else {
                XST_mPV(count++, "-text");
                XST_mPV(count++, ti.lpszText);
            }
        }
        XST_mPV(count++, "-flag");  /* TODO: Decode flags? */
        XST_mIV(count++, ti.uFlags);
    }
    if(tip)
        Safefree(tip);
    XSRETURN(count);
#line 1094 "Tooltip.c"
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Win32__GUI__Tooltip_HitTest); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Win32__GUI__Tooltip_HitTest)
{
    dVAR; dXSARGS;
    if (items < 4 || items > 5)
       croak_xs_usage(cv,  "handle, window, x, y, bufsize=0");
    {
	HWND	handle;
	HWND	window;
	LONG	x = (LONG)SvIV(ST(2))
;
	LONG	y = (LONG)SvIV(ST(3))
;
	int	bufsize;
#line 868 "Tooltip.xs"
    TTHITTESTINFO hti;
    int count = 0;
    LPSTR tip = NULL;
    AV* rect;
#line 1119 "Tooltip.c"

    if(SvROK(ST(0))) {
        SV** out=hv_fetch((HV*)SvRV(ST(0)), "-handle", 7, 0);
        if(out != NULL)
            handle = INT2PTR(HWND,SvIV(*out));
        else
            handle = NULL;
    } else
       handle = INT2PTR(HWND,SvIV(ST(0)))
;

    if(SvROK(ST(1))) {
        SV** out=hv_fetch((HV*)SvRV(ST(1)), "-handle", 7, 0);
        if(out != NULL)
            window = INT2PTR(HWND,SvIV(*out));
        else
            window = NULL;
    } else
       window = INT2PTR(HWND,SvIV(ST(1)))
;

	if (items < 5)
	    bufsize = 0;
	else {
	    bufsize = (int)SvIV(ST(4))
;
	}
#line 873 "Tooltip.xs"
    ZeroMemory(&hti, sizeof(TTHITTESTINFO));
    hti.pt.x = x; hti.pt.y = y;
    hti.ti.cbSize = sizeof(TOOLINFO);
    hti.hwnd = window;
    if (bufsize > 0) {
        Newz(0, tip, bufsize, CHAR);
        hti.ti.lpszText = tip;
    }
    if (SendMessage(handle, TTM_HITTEST, (WPARAM) 0, (LPARAM) &hti)) {
        if(tip) {
            /* ensure tip is NULL terminated, even if we overran the buffer
             * to minimise damage - of course it may already be too late
             */
            tip[bufsize-1] = 0;
        }
        EXTEND(SP, 12);
        XST_mPV(count++, "-window");
        if(hti.ti.uFlags & TTF_IDISHWND) {
            XST_mIV(count++, PTR2IV(hti.ti.uId));
        } else {
            XST_mIV(count++, PTR2IV(hti.ti.hwnd));
            XST_mPV(count++, "-id");
            XST_mIV(count++, hti.ti.uId);
            XST_mPV(count++, "-rect");
            rect = newAV();
            av_push(rect,newSViv(hti.ti.rect.left));
            av_push(rect,newSViv(hti.ti.rect.top));
            av_push(rect,newSViv(hti.ti.rect.right));
            av_push(rect,newSViv(hti.ti.rect.bottom));
            ST(count++) = sv_2mortal(newRV_noinc((SV*)rect));
        }
        if (hti.ti.lpszText != NULL) {
            if (hti.ti.lpszText == LPSTR_TEXTCALLBACK) {
                XST_mPV(count++, "-needtext");
                XST_mIV(count++, 1);
            } else if (IS_INTRESOURCE(hti.ti.lpszText)) {
                XST_mPV(count++, "-text");
                XST_mIV(count++, PTR2IV(hti.ti.lpszText));
                XST_mPV(count++, "-hinst");
                XST_mIV(count++, PTR2IV(hti.ti.hinst));
            } else {
                XST_mPV(count++, "-text");
                XST_mPV(count++, hti.ti.lpszText);
            }
        }
        XST_mPV(count++, "-flag");  /* TODO: Decode flags? */
        XST_mIV(count++, hti.ti.uFlags);
    }
    if(tip)
        Safefree(tip);
    XSRETURN(count);
#line 1199 "Tooltip.c"
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Win32__GUI__Tooltip_NewToolRect); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Win32__GUI__Tooltip_NewToolRect)
{
    dVAR; dXSARGS;
    if (items != 6)
       croak_xs_usage(cv,  "handle, tool, left, top, right, bottom");
    {
	HWND	handle;
	SV*	tool = ST(1)
;
	LONG	left = (LONG)SvIV(ST(2))
;
	LONG	top = (LONG)SvIV(ST(3))
;
	LONG	right = (LONG)SvIV(ST(4))
;
	LONG	bottom = (LONG)SvIV(ST(5))
;
#line 960 "Tooltip.xs"
    TOOLINFO ti;
#line 1225 "Tooltip.c"
	LRESULT	RETVAL;
	dXSTARG;

    if(SvROK(ST(0))) {
        SV** out=hv_fetch((HV*)SvRV(ST(0)), "-handle", 7, 0);
        if(out != NULL)
            handle = INT2PTR(HWND,SvIV(*out));
        else
            handle = NULL;
    } else
       handle = INT2PTR(HWND,SvIV(ST(0)))
;
#line 962 "Tooltip.xs"
    ZeroMemory(&ti, sizeof(TOOLINFO));
    ti.cbSize = sizeof(TOOLINFO);
    ToolInfoFromTool(NOTXSCALL handle, tool, &ti);
    ti.rect.left   = left;
    ti.rect.top    = top;
    ti.rect.right  = right;
    ti.rect.bottom = bottom;
    RETVAL = SendMessage(handle, TTM_NEWTOOLRECT, (WPARAM) 0, (LPARAM) &ti);
#line 1247 "Tooltip.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Win32__GUI__Tooltip_Pop); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Win32__GUI__Tooltip_Pop)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "handle");
    {
	HWND	handle;
	LRESULT	RETVAL;
	dXSTARG;

    if(SvROK(ST(0))) {
        SV** out=hv_fetch((HV*)SvRV(ST(0)), "-handle", 7, 0);
        if(out != NULL)
            handle = INT2PTR(HWND,SvIV(*out));
        else
            handle = NULL;
    } else
       handle = INT2PTR(HWND,SvIV(ST(0)))
;
#line 980 "Tooltip.xs"
    RETVAL = SendMessage(handle, TTM_POP, 0, 0);
#line 1277 "Tooltip.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Win32__GUI__Tooltip_SetDelayTime); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Win32__GUI__Tooltip_SetDelayTime)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "handle, time, flag=TTDT_INITIAL");
    {
	HWND	handle;
	WPARAM	time = (WPARAM)SvUV(ST(1))
;
	WPARAM	flag;
	LRESULT	RETVAL;
	dXSTARG;

    if(SvROK(ST(0))) {
        SV** out=hv_fetch((HV*)SvRV(ST(0)), "-handle", 7, 0);
        if(out != NULL)
            handle = INT2PTR(HWND,SvIV(*out));
        else
            handle = NULL;
    } else
       handle = INT2PTR(HWND,SvIV(ST(0)))
;

	if (items < 3)
	    flag = TTDT_INITIAL;
	else {
	    flag = (WPARAM)SvUV(ST(2))
;
	}
#line 1016 "Tooltip.xs"
    RETVAL = SendMessage(handle, TTM_SETDELAYTIME, flag, (LPARAM) MAKELONG(time,0));
#line 1317 "Tooltip.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Win32__GUI__Tooltip_SetMargin); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Win32__GUI__Tooltip_SetMargin)
{
    dVAR; dXSARGS;
    if (items != 5)
       croak_xs_usage(cv,  "handle, left, top, right, bottom");
    {
	HWND	handle;
	int	left = (int)SvIV(ST(1))
;
	int	top = (int)SvIV(ST(2))
;
	int	right = (int)SvIV(ST(3))
;
	int	bottom = (int)SvIV(ST(4))
;
#line 1033 "Tooltip.xs"
    RECT myRect;
#line 1343 "Tooltip.c"
	LRESULT	RETVAL;
	dXSTARG;

    if(SvROK(ST(0))) {
        SV** out=hv_fetch((HV*)SvRV(ST(0)), "-handle", 7, 0);
        if(out != NULL)
            handle = INT2PTR(HWND,SvIV(*out));
        else
            handle = NULL;
    } else
       handle = INT2PTR(HWND,SvIV(ST(0)))
;
#line 1035 "Tooltip.xs"
    myRect.left   = left;
    myRect.top    = top;
    myRect.right  = right;
    myRect.bottom = bottom;
    RETVAL = SendMessage(handle, TTM_SETMARGIN, (WPARAM) 0, (LPARAM) &myRect);
#line 1362 "Tooltip.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Win32__GUI__Tooltip_SetMaxTipWidth); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Win32__GUI__Tooltip_SetMaxTipWidth)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "handle, width");
    {
	HWND	handle;
	WPARAM	width = (WPARAM)SvUV(ST(1))
;
	INT	RETVAL;
	dXSTARG;

    if(SvROK(ST(0))) {
        SV** out=hv_fetch((HV*)SvRV(ST(0)), "-handle", 7, 0);
        if(out != NULL)
            handle = INT2PTR(HWND,SvIV(*out));
        else
            handle = NULL;
    } else
       handle = INT2PTR(HWND,SvIV(ST(0)))
;
#line 1061 "Tooltip.xs"
    RETVAL = (INT)SendMessage(handle, TTM_SETMAXTIPWIDTH, 0, (LPARAM) width);
#line 1394 "Tooltip.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Win32__GUI__Tooltip_SetTipBkColor); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Win32__GUI__Tooltip_SetTipBkColor)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "handle, color");
    {
	HWND	handle;
	COLORREF    color = SvCOLORREF(NOTXSCALL ST(1))
;
	LRESULT	RETVAL;
	dXSTARG;

    if(SvROK(ST(0))) {
        SV** out=hv_fetch((HV*)SvRV(ST(0)), "-handle", 7, 0);
        if(out != NULL)
            handle = INT2PTR(HWND,SvIV(*out));
        else
            handle = NULL;
    } else
       handle = INT2PTR(HWND,SvIV(ST(0)))
;
#line 1073 "Tooltip.xs"
    RETVAL = SendMessage(handle, TTM_SETTIPBKCOLOR, (WPARAM) color, 0);
#line 1426 "Tooltip.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Win32__GUI__Tooltip_SetTipTextColor); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Win32__GUI__Tooltip_SetTipTextColor)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "handle, color");
    {
	HWND	handle;
	COLORREF    color = SvCOLORREF(NOTXSCALL ST(1))
;
	LRESULT	RETVAL;
	dXSTARG;

    if(SvROK(ST(0))) {
        SV** out=hv_fetch((HV*)SvRV(ST(0)), "-handle", 7, 0);
        if(out != NULL)
            handle = INT2PTR(HWND,SvIV(*out));
        else
            handle = NULL;
    } else
       handle = INT2PTR(HWND,SvIV(ST(0)))
;
#line 1085 "Tooltip.xs"
    RETVAL = SendMessage(handle, TTM_SETTIPTEXTCOLOR, (WPARAM) color, 0);
#line 1458 "Tooltip.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Win32__GUI__Tooltip_SetTitle); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Win32__GUI__Tooltip_SetTitle)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "handle, title, icon=\"none\"");
    {
	HWND	handle;
	LPCSTR	title = (LPCSTR)SvPV_nolen(ST(1))
;
	LPCSTR	icon;
#line 1103 "Tooltip.xs"
	UINT i;
#line 1479 "Tooltip.c"
	LRESULT	RETVAL;
	dXSTARG;

    if(SvROK(ST(0))) {
        SV** out=hv_fetch((HV*)SvRV(ST(0)), "-handle", 7, 0);
        if(out != NULL)
            handle = INT2PTR(HWND,SvIV(*out));
        else
            handle = NULL;
    } else
       handle = INT2PTR(HWND,SvIV(ST(0)))
;

	if (items < 3)
	    icon = "none";
	else {
	    icon = (LPCSTR)SvPV_nolen(ST(2))
;
	}
#line 1105 "Tooltip.xs"
	if(strcmp(icon, "error") == 0) {
		i = 3;
	} else if(strcmp(icon, "warning") == 0) {
		i = 2;
	} else if(strcmp(icon, "info") == 0) {
		i = 1;
	} else if(strcmp(icon, "none") == 0) {
		i = 0;
	} else {
		W32G_WARN("Invalid icon specification (%s): using 'none'",icon);
		i = 0;
	}
	RETVAL = SendMessage(handle, TTM_SETTITLE, (WPARAM)i, (LPARAM)title);
#line 1513 "Tooltip.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Win32__GUI__Tooltip_SetToolInfo); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Win32__GUI__Tooltip_SetToolInfo)
{
    dVAR; dXSARGS;
    if (items < 1)
       croak_xs_usage(cv,  "handle, ...");
    {
	HWND	handle;
#line 1138 "Tooltip.xs"
    TOOLINFO ti;
#line 1531 "Tooltip.c"
	LRESULT	RETVAL;
	dXSTARG;

    if(SvROK(ST(0))) {
        SV** out=hv_fetch((HV*)SvRV(ST(0)), "-handle", 7, 0);
        if(out != NULL)
            handle = INT2PTR(HWND,SvIV(*out));
        else
            handle = NULL;
    } else
       handle = INT2PTR(HWND,SvIV(ST(0)))
;
#line 1140 "Tooltip.xs"
    ZeroMemory(&ti, sizeof(TOOLINFO));
    ti.cbSize = sizeof(TOOLINFO);
    ti.hwnd = (HWND) GetWindowLongPtr(handle, GWLP_HWNDPARENT);
    ParseTooltipOptions(NOTXSCALL sp, mark, ax, items, 1, &ti);
    RETVAL = SendMessage(handle, TTM_SETTOOLINFO, 0, (LPARAM) &ti);
#line 1550 "Tooltip.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Win32__GUI__Tooltip_TrackActivate); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Win32__GUI__Tooltip_TrackActivate)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "handle, tool, flag=1");
    {
	HWND	handle;
	SV*	tool = ST(1)
;
	BOOL	flag;
#line 1181 "Tooltip.xs"
    TOOLINFO ti;
#line 1571 "Tooltip.c"
	LRESULT	RETVAL;
	dXSTARG;

    if(SvROK(ST(0))) {
        SV** out=hv_fetch((HV*)SvRV(ST(0)), "-handle", 7, 0);
        if(out != NULL)
            handle = INT2PTR(HWND,SvIV(*out));
        else
            handle = NULL;
    } else
       handle = INT2PTR(HWND,SvIV(ST(0)))
;

	if (items < 3)
	    flag = 1;
	else {
	    flag = (BOOL)SvIV(ST(2))
;
	}
#line 1183 "Tooltip.xs"
    ZeroMemory(&ti, sizeof(TOOLINFO));
    ti.cbSize = sizeof(TOOLINFO);
    ToolInfoFromTool(NOTXSCALL handle, tool, &ti);
    RETVAL = SendMessage(handle, TTM_TRACKACTIVATE, (WPARAM) flag, (LPARAM) &ti);
#line 1596 "Tooltip.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Win32__GUI__Tooltip_TrackPosition); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Win32__GUI__Tooltip_TrackPosition)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "handle, x, y");
    {
	HWND	handle;
	UINT	x = (UINT)SvUV(ST(1))
;
	UINT	y = (UINT)SvUV(ST(2))
;
	LRESULT	RETVAL;
	dXSTARG;

    if(SvROK(ST(0))) {
        SV** out=hv_fetch((HV*)SvRV(ST(0)), "-handle", 7, 0);
        if(out != NULL)
            handle = INT2PTR(HWND,SvIV(*out));
        else
            handle = NULL;
    } else
       handle = INT2PTR(HWND,SvIV(ST(0)))
;
#line 1201 "Tooltip.xs"
    RETVAL = SendMessage(handle, TTM_TRACKPOSITION, 0, (LPARAM) MAKELONG(x, y));
#line 1630 "Tooltip.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Win32__GUI__Tooltip_Update); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Win32__GUI__Tooltip_Update)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "handle");
    {
	HWND	handle;
	LRESULT	RETVAL;
	dXSTARG;

    if(SvROK(ST(0))) {
        SV** out=hv_fetch((HV*)SvRV(ST(0)), "-handle", 7, 0);
        if(out != NULL)
            handle = INT2PTR(HWND,SvIV(*out));
        else
            handle = NULL;
    } else
       handle = INT2PTR(HWND,SvIV(ST(0)))
;
#line 1212 "Tooltip.xs"
    RETVAL = SendMessage(handle, TTM_UPDATE, 0, 0);
#line 1660 "Tooltip.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Win32__GUI__Tooltip_UpdateTipText); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Win32__GUI__Tooltip_UpdateTipText)
{
    dVAR; dXSARGS;
    if (items < 3 || items > 4)
       croak_xs_usage(cv,  "handle, tool, string_or_resid, instance=NULL");
    {
	HWND	handle;
	SV*	tool = ST(1)
;
	SV*	string_or_resid = ST(2)
;
	HINSTANCE	instance;
#line 1247 "Tooltip.xs"
    TOOLINFO ti;
#line 1683 "Tooltip.c"
	LRESULT	RETVAL;
	dXSTARG;

    if(SvROK(ST(0))) {
        SV** out=hv_fetch((HV*)SvRV(ST(0)), "-handle", 7, 0);
        if(out != NULL)
            handle = INT2PTR(HWND,SvIV(*out));
        else
            handle = NULL;
    } else
       handle = INT2PTR(HWND,SvIV(ST(0)))
;

	if (items < 4)
	    instance = NULL;
	else {
	    instance = INT2PTR(HINSTANCE,SvIV(ST(3)))
;
	}
#line 1249 "Tooltip.xs"
    ZeroMemory(&ti, sizeof(TOOLINFO));
    ti.cbSize = sizeof(TOOLINFO);
    ToolInfoFromTool(NOTXSCALL handle, tool, &ti);
    ti.lpszText = SvIOK(string_or_resid) ?
            MAKEINTRESOURCE(SvIV(string_or_resid)) : SvPV_nolen(string_or_resid);
    ti.hinst    = instance;
    RETVAL = SendMessage(handle, TTM_UPDATETIPTEXT, 0, (LPARAM) &ti);
#line 1711 "Tooltip.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

#ifdef __cplusplus
extern "C" {
#endif
XS_EXTERNAL(boot_Win32__GUI__Tooltip); /* prototype to pass -Wmissing-prototypes */
XS_EXTERNAL(boot_Win32__GUI__Tooltip)
{
#if PERL_VERSION_LE(5, 21, 5)
    dVAR; dXSARGS;
#else
    dVAR; dXSBOOTARGSXSAPIVERCHK;
#endif
#if PERL_VERSION_LE(5, 8, 999) /* PERL_VERSION_LT is 5.33+ */
    char* file = __FILE__;
#else
    const char* file = __FILE__;
#endif

    PERL_UNUSED_VAR(file);

    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(items); /* -W */
#if PERL_VERSION_LE(5, 21, 5)
    XS_VERSION_BOOTCHECK;
#  ifdef XS_APIVERSION_BOOTCHECK
    XS_APIVERSION_BOOTCHECK;
#  endif
#endif

        newXS_deffile("Win32::GUI::Tooltip::Activate", XS_Win32__GUI__Tooltip_Activate);
        cv = newXS_deffile("Win32::GUI::Tooltip::Add", XS_Win32__GUI__Tooltip_AddTool);
        XSANY.any_i32 = 1;
        cv = newXS_deffile("Win32::GUI::Tooltip::AddTool", XS_Win32__GUI__Tooltip_AddTool);
        XSANY.any_i32 = 0;
        newXS_deffile("Win32::GUI::Tooltip::Adjustrect", XS_Win32__GUI__Tooltip_Adjustrect);
        cv = newXS_deffile("Win32::GUI::Tooltip::Del", XS_Win32__GUI__Tooltip_DelTool);
        XSANY.any_i32 = 1;
        cv = newXS_deffile("Win32::GUI::Tooltip::DelTool", XS_Win32__GUI__Tooltip_DelTool);
        XSANY.any_i32 = 0;
        newXS_deffile("Win32::GUI::Tooltip::EnumTools", XS_Win32__GUI__Tooltip_EnumTools);
        newXS_deffile("Win32::GUI::Tooltip::GetBubbleSize", XS_Win32__GUI__Tooltip_GetBubbleSize);
        newXS_deffile("Win32::GUI::Tooltip::GetCurrentTool", XS_Win32__GUI__Tooltip_GetCurrentTool);
        newXS_deffile("Win32::GUI::Tooltip::GetDelayTime", XS_Win32__GUI__Tooltip_GetDelayTime);
        newXS_deffile("Win32::GUI::Tooltip::GetMargin", XS_Win32__GUI__Tooltip_GetMargin);
        newXS_deffile("Win32::GUI::Tooltip::GetMaxTipWidth", XS_Win32__GUI__Tooltip_GetMaxTipWidth);
        newXS_deffile("Win32::GUI::Tooltip::GetText", XS_Win32__GUI__Tooltip_GetText);
        newXS_deffile("Win32::GUI::Tooltip::GetTipBkColor", XS_Win32__GUI__Tooltip_GetTipBkColor);
        newXS_deffile("Win32::GUI::Tooltip::GetTipTextColor", XS_Win32__GUI__Tooltip_GetTipTextColor);
        cv = newXS_deffile("Win32::GUI::Tooltip::Count", XS_Win32__GUI__Tooltip_GetToolCount);
        XSANY.any_i32 = 1;
        cv = newXS_deffile("Win32::GUI::Tooltip::GetToolCount", XS_Win32__GUI__Tooltip_GetToolCount);
        XSANY.any_i32 = 0;
        newXS_deffile("Win32::GUI::Tooltip::GetToolInfo", XS_Win32__GUI__Tooltip_GetToolInfo);
        newXS_deffile("Win32::GUI::Tooltip::HitTest", XS_Win32__GUI__Tooltip_HitTest);
        newXS_deffile("Win32::GUI::Tooltip::NewToolRect", XS_Win32__GUI__Tooltip_NewToolRect);
        newXS_deffile("Win32::GUI::Tooltip::Pop", XS_Win32__GUI__Tooltip_Pop);
        newXS_deffile("Win32::GUI::Tooltip::SetDelayTime", XS_Win32__GUI__Tooltip_SetDelayTime);
        newXS_deffile("Win32::GUI::Tooltip::SetMargin", XS_Win32__GUI__Tooltip_SetMargin);
        newXS_deffile("Win32::GUI::Tooltip::SetMaxTipWidth", XS_Win32__GUI__Tooltip_SetMaxTipWidth);
        newXS_deffile("Win32::GUI::Tooltip::SetTipBkColor", XS_Win32__GUI__Tooltip_SetTipBkColor);
        newXS_deffile("Win32::GUI::Tooltip::SetTipTextColor", XS_Win32__GUI__Tooltip_SetTipTextColor);
        newXS_deffile("Win32::GUI::Tooltip::SetTitle", XS_Win32__GUI__Tooltip_SetTitle);
        newXS_deffile("Win32::GUI::Tooltip::SetToolInfo", XS_Win32__GUI__Tooltip_SetToolInfo);
        newXS_deffile("Win32::GUI::Tooltip::TrackActivate", XS_Win32__GUI__Tooltip_TrackActivate);
        newXS_deffile("Win32::GUI::Tooltip::TrackPosition", XS_Win32__GUI__Tooltip_TrackPosition);
        newXS_deffile("Win32::GUI::Tooltip::Update", XS_Win32__GUI__Tooltip_Update);
        newXS_deffile("Win32::GUI::Tooltip::UpdateTipText", XS_Win32__GUI__Tooltip_UpdateTipText);
#if PERL_VERSION_LE(5, 21, 5)
#  if PERL_VERSION_GE(5, 9, 0)
    if (PL_unitcheckav)
        call_list(PL_scopestack_ix, PL_unitcheckav);
#  endif
    XSRETURN_YES;
#else
    Perl_xs_boot_epilog(aTHX_ ax);
#endif
}

#ifdef __cplusplus
}
#endif
