/*
 * Interface wrapper code.
 *
 * Generated by SIP 4.19.24
 *
 *     Copyright: (c) 2020 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_core.h"

        #include <wx/palette.h>

        #include <wx/object.h>
        #include <wx/object.h>
        #include <wx/object.h>
        // a helper function to be used in the Create method and one of the Ctors
        bool _paletteCreateHelper(wxPalette* self,
                                  PyObject* red, PyObject* green, PyObject* blue) {
            bool rval = false;
            wxPyThreadBlocker blocker;
            char* errMsg = "Expected a sequence of integer objects";
        
            if (!PySequence_Check(red) || !PySequence_Check(green) || !PySequence_Check(blue)) {
                PyErr_SetString(PyExc_TypeError, errMsg);
                return rval;
            }
        
            Py_ssize_t count = PySequence_Size(red);
            if (PySequence_Size(green) != count || PySequence_Size(blue) != count) {
                PyErr_SetString(PyExc_ValueError, "Sequence lengths must be equal");
                return rval;
            }
        
            unsigned char* redArray = new unsigned char[count];
            unsigned char* greenArray = new unsigned char[count];
            unsigned char* blueArray = new unsigned char[count];
        
            for (Py_ssize_t i = 0; i < count; i++) {
                PyObject* redItem = PySequence_ITEM(red, i);
                PyObject* greenItem = PySequence_ITEM(green, i);
                PyObject* blueItem = PySequence_ITEM(blue, i);
                if (!wxPyInt_Check(redItem) || !wxPyInt_Check(greenItem) || !wxPyInt_Check(blueItem)) {
                    PyErr_SetString(PyExc_TypeError, errMsg);
                    goto pch_exit;
                }
        
                long redLong = wxPyInt_AsLong(redItem);
                long greenLong = wxPyInt_AsLong(greenItem);
                long blueLong = wxPyInt_AsLong(blueItem);
                Py_DECREF(redItem);
                Py_DECREF(greenItem);
                Py_DECREF(blueItem);
                if (redLong < 0 || redLong > 255 || greenLong < 0 || greenLong > 255 || blueLong < 0 || blueLong > 255) {
                    PyErr_SetString(PyExc_ValueError, "Sequence values must be in the 0..255 range");
                    goto pch_exit;
                }
                redArray[i] = redLong;
                greenArray[i] = greenLong;
                blueArray[i] = blueLong;
            }
        
            rval = self->Create(count, redArray, greenArray, blueArray);
        
        pch_exit:
            delete[] redArray;
            delete[] greenArray;
            delete[] blueArray;
            return rval;
        }
    wxPalette* _wxPalette_ctor(PyObject* red, PyObject* green, PyObject* blue)
    {
        wxPalette* pal = new wxPalette;
        _paletteCreateHelper(pal, red, green, blue);
        if (PyErr_Occurred()) {
            delete pal;
            return NULL;
        }
        return pal;
    }
    PyObject* _wxPalette_Create(wxPalette* self, PyObject* red, PyObject* green, PyObject* blue)
    {
        bool rval = _paletteCreateHelper(self, red, green, blue);
        wxPyThreadBlocker blocker;
        if (PyErr_Occurred())
            return NULL;
        if (rval)
            Py_RETURN_TRUE;
        else
            Py_RETURN_FALSE;
    }
    PyObject* _wxPalette_GetRGB(wxPalette* self, int pixel)
    {
        unsigned char red;
        unsigned char green;
        unsigned char blue;
        wxPyThreadBlocker blocker;
        if (!self->GetRGB(pixel, &red, &green, &blue)) {
            PyErr_SetString(PyExc_IndexError, "Pixel out of range");
            return NULL;
        }
        PyObject* rv = PyTuple_New(3);
        PyTuple_SetItem(rv, 0, wxPyInt_FromLong(red));
        PyTuple_SetItem(rv, 1, wxPyInt_FromLong(green));
        PyTuple_SetItem(rv, 2, wxPyInt_FromLong(blue));
        return rv;
    }


PyDoc_STRVAR(doc_wxPalette_Create, "Create(red, green, blue) -> bool\n"
"\n"
"Creates a palette from 3 sequences of integers, one for each red, blue\n"
"or green component.\n"
"\n"
":param red: A sequence of integer values in the range 0..255\n"
"inclusive.\n"
":param green: A sequence of integer values in the range 0..255\n"
"inclusive.\n"
":param blue: A sequence of integer values in the range 0..255\n"
"inclusive.\n"
"\n"
".. note:: All sequences must be the same length.");

extern "C" {static PyObject *meth_wxPalette_Create(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPalette_Create(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        PyObject * red;
        PyObject * green;
        PyObject * blue;
         ::wxPalette *sipCpp;

        static const char *sipKwdList[] = {
            sipName_red,
            sipName_green,
            sipName_blue,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BP0P0P0", &sipSelf, sipType_wxPalette, &sipCpp, &red, &green, &blue))
        {
            PyObject * sipRes = SIP_NULLPTR;
            int sipIsErr = 0;

        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxPalette_Create(sipCpp, red, green, blue);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            return sipRes;
        }
    }

    sipNoMethod(sipParseErr, sipName_Palette, sipName_Create, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPalette_GetColoursCount, "GetColoursCount() -> int\n"
"\n"
"Returns number of entries in palette.");

extern "C" {static PyObject *meth_wxPalette_GetColoursCount(PyObject *, PyObject *);}
static PyObject *meth_wxPalette_GetColoursCount(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxPalette *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPalette, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetColoursCount();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Palette, sipName_GetColoursCount, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPalette_GetPixel, "GetPixel(red, green, blue) -> int\n"
"\n"
"Returns a pixel value (index into the palette) for the given RGB\n"
"values.");

extern "C" {static PyObject *meth_wxPalette_GetPixel(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPalette_GetPixel(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        unsigned char red;
        unsigned char green;
        unsigned char blue;
        const  ::wxPalette *sipCpp;

        static const char *sipKwdList[] = {
            sipName_red,
            sipName_green,
            sipName_blue,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BMMM", &sipSelf, sipType_wxPalette, &sipCpp, &red, &green, &blue))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetPixel(red,green,blue);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Palette, sipName_GetPixel, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPalette_GetRGB, "GetRGB(pixel) -> (red, green, blue)\n"
"\n"
"Returns RGB values for a given palette index.");

extern "C" {static PyObject *meth_wxPalette_GetRGB(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPalette_GetRGB(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int pixel;
         ::wxPalette *sipCpp;

        static const char *sipKwdList[] = {
            sipName_pixel,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi", &sipSelf, sipType_wxPalette, &sipCpp, &pixel))
        {
            PyObject * sipRes = SIP_NULLPTR;
            int sipIsErr = 0;

        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxPalette_GetRGB(sipCpp, pixel);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            return sipRes;
        }
    }

    sipNoMethod(sipParseErr, sipName_Palette, sipName_GetRGB, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPalette_IsOk, "IsOk() -> bool\n"
"\n"
"Returns true if palette data is present.");

extern "C" {static PyObject *meth_wxPalette_IsOk(PyObject *, PyObject *);}
static PyObject *meth_wxPalette_IsOk(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxPalette *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPalette, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsOk();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Palette, sipName_IsOk, SIP_NULLPTR);

    return SIP_NULLPTR;
}


/* Cast a pointer to a type somewhere in its inheritance hierarchy. */
extern "C" {static void *cast_wxPalette(void *, const sipTypeDef *);}
static void *cast_wxPalette(void *sipCppV, const sipTypeDef *targetType)
{
     ::wxPalette *sipCpp = reinterpret_cast< ::wxPalette *>(sipCppV);

    if (targetType == sipType_wxGDIObject)
        return static_cast< ::wxGDIObject *>(sipCpp);

    if (targetType == sipType_wxObject)
        return static_cast< ::wxObject *>(sipCpp);

    return sipCppV;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxPalette(void *, int);}
static void release_wxPalette(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::wxPalette *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void *array_wxPalette(Py_ssize_t);}
static void *array_wxPalette(Py_ssize_t sipNrElem)
{
    return new  ::wxPalette[sipNrElem];
}


extern "C" {static void assign_wxPalette(void *, SIP_SSIZE_T, void *);}
static void assign_wxPalette(void *sipDst, SIP_SSIZE_T sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::wxPalette *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::wxPalette *>(sipSrc);
}


extern "C" {static void *copy_wxPalette(const void *, SIP_SSIZE_T);}
static void *copy_wxPalette(const void *sipSrc, SIP_SSIZE_T sipSrcIdx)
{
    return new  ::wxPalette(reinterpret_cast<const  ::wxPalette *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_wxPalette(sipSimpleWrapper *);}
static void dealloc_wxPalette(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxPalette(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_wxPalette(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxPalette(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
     ::wxPalette *sipCpp = SIP_NULLPTR;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, ""))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxPalette();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            return sipCpp;
        }
    }

    {
        const  ::wxPalette* palette;

        static const char *sipKwdList[] = {
            sipName_palette,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J9", sipType_wxPalette, &palette))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxPalette(*palette);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            return sipCpp;
        }
    }

    {
        PyObject * red;
        PyObject * green;
        PyObject * blue;

        static const char *sipKwdList[] = {
            sipName_red,
            sipName_green,
            sipName_blue,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "P0P0P0", &red, &green, &blue))
        {
        PyErr_Clear();
        sipCpp = _wxPalette_ctor(red, green, blue);

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


/* Define this type's super-types. */
static sipEncodedTypeDef supers_wxPalette[] = {{211, 255, 1}};


static PyMethodDef methods_wxPalette[] = {
    {SIP_MLNAME_CAST(sipName_Create), SIP_MLMETH_CAST(meth_wxPalette_Create), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPalette_Create)},
    {SIP_MLNAME_CAST(sipName_GetColoursCount), meth_wxPalette_GetColoursCount, METH_VARARGS, SIP_MLDOC_CAST(doc_wxPalette_GetColoursCount)},
    {SIP_MLNAME_CAST(sipName_GetPixel), SIP_MLMETH_CAST(meth_wxPalette_GetPixel), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPalette_GetPixel)},
    {SIP_MLNAME_CAST(sipName_GetRGB), SIP_MLMETH_CAST(meth_wxPalette_GetRGB), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPalette_GetRGB)},
    {SIP_MLNAME_CAST(sipName_IsOk), meth_wxPalette_IsOk, METH_VARARGS, SIP_MLDOC_CAST(doc_wxPalette_IsOk)}
};

sipVariableDef variables_wxPalette[] = {
    {PropertyVariable, sipName_RGB, &methods_wxPalette[3], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_ColoursCount, &methods_wxPalette[1], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
};

PyDoc_STRVAR(doc_wxPalette, "Palette()\n"
"Palette(palette)\n"
"Palette(red, green, blue)\n"
"\n"
"A palette is a table that maps pixel values to RGB colours.");


sipClassTypeDef sipTypeDef__core_wxPalette = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_SCC|SIP_TYPE_CLASS,
        sipNameNr_wxPalette,
        {SIP_NULLPTR},
        SIP_NULLPTR
    },
    {
        sipNameNr_Palette,
        {0, 0, 1},
        5, methods_wxPalette,
        0, SIP_NULLPTR,
        2, variables_wxPalette,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_wxPalette,
    -1,
    -1,
    supers_wxPalette,
    SIP_NULLPTR,
    init_type_wxPalette,
    SIP_NULLPTR,
    SIP_NULLPTR,
#if PY_MAJOR_VERSION >= 3
    SIP_NULLPTR,
    SIP_NULLPTR,
#else
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
#endif
    dealloc_wxPalette,
    assign_wxPalette,
    array_wxPalette,
    copy_wxPalette,
    release_wxPalette,
    cast_wxPalette,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR
};
