/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSCSSImportRule.h"

#include "CSSImportRule.h"
#include "CSSStyleSheet.h"
#include "JSCSSStyleSheet.h"
#include "JSMediaList.h"
#include "KURL.h"
#include "MediaList.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSCSSImportRuleTableValues[] =
{
    { "href", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSImportRuleHref), (intptr_t)0, NoIntrinsic },
    { "media", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSImportRuleMedia), (intptr_t)0, NoIntrinsic },
    { "styleSheet", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSImportRuleStyleSheet), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSImportRuleConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSCSSImportRuleTable = { 8, 7, JSCSSImportRuleTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSCSSImportRuleConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSCSSImportRuleConstructorTable = { 1, 0, JSCSSImportRuleConstructorTableValues, 0 };
const ClassInfo JSCSSImportRuleConstructor::s_info = { "CSSImportRuleConstructor", &Base::s_info, &JSCSSImportRuleConstructorTable, 0, CREATE_METHOD_TABLE(JSCSSImportRuleConstructor) };

JSCSSImportRuleConstructor::JSCSSImportRuleConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSCSSImportRuleConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSCSSImportRulePrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSCSSImportRuleConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSCSSImportRuleConstructor, JSDOMWrapper>(exec, &JSCSSImportRuleConstructorTable, jsCast<JSCSSImportRuleConstructor*>(cell), propertyName, slot);
}

bool JSCSSImportRuleConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSCSSImportRuleConstructor, JSDOMWrapper>(exec, &JSCSSImportRuleConstructorTable, jsCast<JSCSSImportRuleConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSCSSImportRulePrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSCSSImportRulePrototypeTable = { 1, 0, JSCSSImportRulePrototypeTableValues, 0 };
const ClassInfo JSCSSImportRulePrototype::s_info = { "CSSImportRulePrototype", &Base::s_info, &JSCSSImportRulePrototypeTable, 0, CREATE_METHOD_TABLE(JSCSSImportRulePrototype) };

JSObject* JSCSSImportRulePrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSCSSImportRule>(exec, globalObject);
}

const ClassInfo JSCSSImportRule::s_info = { "CSSImportRule", &Base::s_info, &JSCSSImportRuleTable, 0 , CREATE_METHOD_TABLE(JSCSSImportRule) };

JSCSSImportRule::JSCSSImportRule(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<CSSImportRule> impl)
    : JSCSSRule(structure, globalObject, impl)
{
}

void JSCSSImportRule::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSCSSImportRule::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSCSSImportRulePrototype::create(exec->globalData(), globalObject, JSCSSImportRulePrototype::createStructure(exec->globalData(), globalObject, JSCSSRulePrototype::self(exec, globalObject)));
}

bool JSCSSImportRule::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSCSSImportRule* thisObject = jsCast<JSCSSImportRule*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSCSSImportRule, Base>(exec, &JSCSSImportRuleTable, thisObject, propertyName, slot);
}

bool JSCSSImportRule::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSCSSImportRule* thisObject = jsCast<JSCSSImportRule*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSCSSImportRule, Base>(exec, &JSCSSImportRuleTable, thisObject, propertyName, descriptor);
}

JSValue jsCSSImportRuleHref(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSCSSImportRule* castedThis = jsCast<JSCSSImportRule*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    CSSImportRule* impl = static_cast<CSSImportRule*>(castedThis->impl());
    JSValue result = jsStringOrNull(exec, impl->href());
    return result;
}


JSValue jsCSSImportRuleMedia(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSCSSImportRule* castedThis = jsCast<JSCSSImportRule*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    CSSImportRule* impl = static_cast<CSSImportRule*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->media()));
    return result;
}


JSValue jsCSSImportRuleStyleSheet(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSCSSImportRule* castedThis = jsCast<JSCSSImportRule*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    CSSImportRule* impl = static_cast<CSSImportRule*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->styleSheet()));
    return result;
}


JSValue jsCSSImportRuleConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSCSSImportRule* domObject = jsCast<JSCSSImportRule*>(asObject(slotBase));
    return JSCSSImportRule::getConstructor(exec, domObject->globalObject());
}

JSValue JSCSSImportRule::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSCSSImportRuleConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}


}
