/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_TIMING)

#include "JSPerformanceNavigation.h"

#include "PerformanceNavigation.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSPerformanceNavigationTableValues[] =
{
    { "type", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPerformanceNavigationType), (intptr_t)0, NoIntrinsic },
    { "redirectCount", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPerformanceNavigationRedirectCount), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSPerformanceNavigationTable = { 5, 3, JSPerformanceNavigationTableValues, 0 };
/* Hash table for prototype */

static const HashTableValue JSPerformanceNavigationPrototypeTableValues[] =
{
    { "TYPE_NAVIGATE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPerformanceNavigationTYPE_NAVIGATE), (intptr_t)0, NoIntrinsic },
    { "TYPE_RELOAD", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPerformanceNavigationTYPE_RELOAD), (intptr_t)0, NoIntrinsic },
    { "TYPE_BACK_FORWARD", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPerformanceNavigationTYPE_BACK_FORWARD), (intptr_t)0, NoIntrinsic },
    { "TYPE_RESERVED", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPerformanceNavigationTYPE_RESERVED), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSPerformanceNavigationPrototypeTable = { 9, 7, JSPerformanceNavigationPrototypeTableValues, 0 };
const ClassInfo JSPerformanceNavigationPrototype::s_info = { "PerformanceNavigationPrototype", &Base::s_info, &JSPerformanceNavigationPrototypeTable, 0, CREATE_METHOD_TABLE(JSPerformanceNavigationPrototype) };

JSObject* JSPerformanceNavigationPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSPerformanceNavigation>(exec, globalObject);
}

bool JSPerformanceNavigationPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSPerformanceNavigationPrototype* thisObject = jsCast<JSPerformanceNavigationPrototype*>(cell);
    return getStaticValueSlot<JSPerformanceNavigationPrototype, JSObject>(exec, &JSPerformanceNavigationPrototypeTable, thisObject, propertyName, slot);
}

bool JSPerformanceNavigationPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSPerformanceNavigationPrototype* thisObject = jsCast<JSPerformanceNavigationPrototype*>(object);
    return getStaticValueDescriptor<JSPerformanceNavigationPrototype, JSObject>(exec, &JSPerformanceNavigationPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSPerformanceNavigation::s_info = { "PerformanceNavigation", &Base::s_info, &JSPerformanceNavigationTable, 0 , CREATE_METHOD_TABLE(JSPerformanceNavigation) };

JSPerformanceNavigation::JSPerformanceNavigation(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<PerformanceNavigation> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSPerformanceNavigation::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSPerformanceNavigation::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSPerformanceNavigationPrototype::create(exec->globalData(), globalObject, JSPerformanceNavigationPrototype::createStructure(globalObject->globalData(), globalObject, globalObject->objectPrototype()));
}

void JSPerformanceNavigation::destroy(JSC::JSCell* cell)
{
    JSPerformanceNavigation* thisObject = static_cast<JSPerformanceNavigation*>(cell);
    thisObject->JSPerformanceNavigation::~JSPerformanceNavigation();
}

JSPerformanceNavigation::~JSPerformanceNavigation()
{
    releaseImplIfNotNull();
}

bool JSPerformanceNavigation::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSPerformanceNavigation* thisObject = jsCast<JSPerformanceNavigation*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSPerformanceNavigation, Base>(exec, &JSPerformanceNavigationTable, thisObject, propertyName, slot);
}

bool JSPerformanceNavigation::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSPerformanceNavigation* thisObject = jsCast<JSPerformanceNavigation*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSPerformanceNavigation, Base>(exec, &JSPerformanceNavigationTable, thisObject, propertyName, descriptor);
}

JSValue jsPerformanceNavigationType(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSPerformanceNavigation* castedThis = jsCast<JSPerformanceNavigation*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    PerformanceNavigation* impl = static_cast<PerformanceNavigation*>(castedThis->impl());
    JSValue result = jsNumber(impl->type());
    return result;
}


JSValue jsPerformanceNavigationRedirectCount(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSPerformanceNavigation* castedThis = jsCast<JSPerformanceNavigation*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    PerformanceNavigation* impl = static_cast<PerformanceNavigation*>(castedThis->impl());
    JSValue result = jsNumber(impl->redirectCount());
    return result;
}


// Constant getters

JSValue jsPerformanceNavigationTYPE_NAVIGATE(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(0));
}

JSValue jsPerformanceNavigationTYPE_RELOAD(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(1));
}

JSValue jsPerformanceNavigationTYPE_BACK_FORWARD(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(2));
}

JSValue jsPerformanceNavigationTYPE_RESERVED(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(255));
}

static inline bool isObservable(JSPerformanceNavigation* jsPerformanceNavigation)
{
    if (jsPerformanceNavigation->hasCustomProperties())
        return true;
    return false;
}

bool JSPerformanceNavigationOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSPerformanceNavigation* jsPerformanceNavigation = jsCast<JSPerformanceNavigation*>(handle.get().asCell());
    if (!isObservable(jsPerformanceNavigation))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSPerformanceNavigationOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSPerformanceNavigation* jsPerformanceNavigation = jsCast<JSPerformanceNavigation*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsPerformanceNavigation->impl(), jsPerformanceNavigation);
    jsPerformanceNavigation->releaseImpl();
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, PerformanceNavigation* impl)
{
    return wrap<JSPerformanceNavigation>(exec, globalObject, impl);
}

PerformanceNavigation* toPerformanceNavigation(JSC::JSValue value)
{
    return value.inherits(&JSPerformanceNavigation::s_info) ? jsCast<JSPerformanceNavigation*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(WEB_TIMING)
