/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGL)

#include "JSWebGLContextAttributes.h"

#include "WebGLContextAttributes.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSWebGLContextAttributesTableValues[] =
{
    { "alpha", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebGLContextAttributesAlpha), (intptr_t)setJSWebGLContextAttributesAlpha, NoIntrinsic },
    { "depth", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebGLContextAttributesDepth), (intptr_t)setJSWebGLContextAttributesDepth, NoIntrinsic },
    { "stencil", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebGLContextAttributesStencil), (intptr_t)setJSWebGLContextAttributesStencil, NoIntrinsic },
    { "antialias", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebGLContextAttributesAntialias), (intptr_t)setJSWebGLContextAttributesAntialias, NoIntrinsic },
    { "premultipliedAlpha", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebGLContextAttributesPremultipliedAlpha), (intptr_t)setJSWebGLContextAttributesPremultipliedAlpha, NoIntrinsic },
    { "preserveDrawingBuffer", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebGLContextAttributesPreserveDrawingBuffer), (intptr_t)setJSWebGLContextAttributesPreserveDrawingBuffer, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSWebGLContextAttributesTable = { 16, 15, JSWebGLContextAttributesTableValues, 0 };
/* Hash table for prototype */

static const HashTableValue JSWebGLContextAttributesPrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSWebGLContextAttributesPrototypeTable = { 1, 0, JSWebGLContextAttributesPrototypeTableValues, 0 };
const ClassInfo JSWebGLContextAttributesPrototype::s_info = { "WebGLContextAttributesPrototype", &Base::s_info, &JSWebGLContextAttributesPrototypeTable, 0, CREATE_METHOD_TABLE(JSWebGLContextAttributesPrototype) };

JSObject* JSWebGLContextAttributesPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSWebGLContextAttributes>(exec, globalObject);
}

const ClassInfo JSWebGLContextAttributes::s_info = { "WebGLContextAttributes", &Base::s_info, &JSWebGLContextAttributesTable, 0 , CREATE_METHOD_TABLE(JSWebGLContextAttributes) };

JSWebGLContextAttributes::JSWebGLContextAttributes(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<WebGLContextAttributes> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSWebGLContextAttributes::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSWebGLContextAttributes::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSWebGLContextAttributesPrototype::create(exec->globalData(), globalObject, JSWebGLContextAttributesPrototype::createStructure(globalObject->globalData(), globalObject, globalObject->objectPrototype()));
}

void JSWebGLContextAttributes::destroy(JSC::JSCell* cell)
{
    JSWebGLContextAttributes* thisObject = static_cast<JSWebGLContextAttributes*>(cell);
    thisObject->JSWebGLContextAttributes::~JSWebGLContextAttributes();
}

JSWebGLContextAttributes::~JSWebGLContextAttributes()
{
    releaseImplIfNotNull();
}

bool JSWebGLContextAttributes::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSWebGLContextAttributes* thisObject = jsCast<JSWebGLContextAttributes*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSWebGLContextAttributes, Base>(exec, &JSWebGLContextAttributesTable, thisObject, propertyName, slot);
}

bool JSWebGLContextAttributes::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSWebGLContextAttributes* thisObject = jsCast<JSWebGLContextAttributes*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSWebGLContextAttributes, Base>(exec, &JSWebGLContextAttributesTable, thisObject, propertyName, descriptor);
}

JSValue jsWebGLContextAttributesAlpha(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWebGLContextAttributes* castedThis = jsCast<JSWebGLContextAttributes*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    WebGLContextAttributes* impl = static_cast<WebGLContextAttributes*>(castedThis->impl());
    JSValue result = jsBoolean(impl->alpha());
    return result;
}


JSValue jsWebGLContextAttributesDepth(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWebGLContextAttributes* castedThis = jsCast<JSWebGLContextAttributes*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    WebGLContextAttributes* impl = static_cast<WebGLContextAttributes*>(castedThis->impl());
    JSValue result = jsBoolean(impl->depth());
    return result;
}


JSValue jsWebGLContextAttributesStencil(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWebGLContextAttributes* castedThis = jsCast<JSWebGLContextAttributes*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    WebGLContextAttributes* impl = static_cast<WebGLContextAttributes*>(castedThis->impl());
    JSValue result = jsBoolean(impl->stencil());
    return result;
}


JSValue jsWebGLContextAttributesAntialias(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWebGLContextAttributes* castedThis = jsCast<JSWebGLContextAttributes*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    WebGLContextAttributes* impl = static_cast<WebGLContextAttributes*>(castedThis->impl());
    JSValue result = jsBoolean(impl->antialias());
    return result;
}


JSValue jsWebGLContextAttributesPremultipliedAlpha(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWebGLContextAttributes* castedThis = jsCast<JSWebGLContextAttributes*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    WebGLContextAttributes* impl = static_cast<WebGLContextAttributes*>(castedThis->impl());
    JSValue result = jsBoolean(impl->premultipliedAlpha());
    return result;
}


JSValue jsWebGLContextAttributesPreserveDrawingBuffer(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWebGLContextAttributes* castedThis = jsCast<JSWebGLContextAttributes*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    WebGLContextAttributes* impl = static_cast<WebGLContextAttributes*>(castedThis->impl());
    JSValue result = jsBoolean(impl->preserveDrawingBuffer());
    return result;
}


void JSWebGLContextAttributes::put(JSCell* cell, ExecState* exec, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    JSWebGLContextAttributes* thisObject = jsCast<JSWebGLContextAttributes*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    lookupPut<JSWebGLContextAttributes, Base>(exec, propertyName, value, &JSWebGLContextAttributesTable, thisObject, slot);
}

void setJSWebGLContextAttributesAlpha(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSWebGLContextAttributes* castedThis = jsCast<JSWebGLContextAttributes*>(thisObject);
    WebGLContextAttributes* impl = static_cast<WebGLContextAttributes*>(castedThis->impl());
    impl->setAlpha(value.toBoolean(exec));
}


void setJSWebGLContextAttributesDepth(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSWebGLContextAttributes* castedThis = jsCast<JSWebGLContextAttributes*>(thisObject);
    WebGLContextAttributes* impl = static_cast<WebGLContextAttributes*>(castedThis->impl());
    impl->setDepth(value.toBoolean(exec));
}


void setJSWebGLContextAttributesStencil(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSWebGLContextAttributes* castedThis = jsCast<JSWebGLContextAttributes*>(thisObject);
    WebGLContextAttributes* impl = static_cast<WebGLContextAttributes*>(castedThis->impl());
    impl->setStencil(value.toBoolean(exec));
}


void setJSWebGLContextAttributesAntialias(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSWebGLContextAttributes* castedThis = jsCast<JSWebGLContextAttributes*>(thisObject);
    WebGLContextAttributes* impl = static_cast<WebGLContextAttributes*>(castedThis->impl());
    impl->setAntialias(value.toBoolean(exec));
}


void setJSWebGLContextAttributesPremultipliedAlpha(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSWebGLContextAttributes* castedThis = jsCast<JSWebGLContextAttributes*>(thisObject);
    WebGLContextAttributes* impl = static_cast<WebGLContextAttributes*>(castedThis->impl());
    impl->setPremultipliedAlpha(value.toBoolean(exec));
}


void setJSWebGLContextAttributesPreserveDrawingBuffer(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSWebGLContextAttributes* castedThis = jsCast<JSWebGLContextAttributes*>(thisObject);
    WebGLContextAttributes* impl = static_cast<WebGLContextAttributes*>(castedThis->impl());
    impl->setPreserveDrawingBuffer(value.toBoolean(exec));
}


static inline bool isObservable(JSWebGLContextAttributes* jsWebGLContextAttributes)
{
    if (jsWebGLContextAttributes->hasCustomProperties())
        return true;
    return false;
}

bool JSWebGLContextAttributesOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSWebGLContextAttributes* jsWebGLContextAttributes = jsCast<JSWebGLContextAttributes*>(handle.get().asCell());
    if (!isObservable(jsWebGLContextAttributes))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSWebGLContextAttributesOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSWebGLContextAttributes* jsWebGLContextAttributes = jsCast<JSWebGLContextAttributes*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsWebGLContextAttributes->impl(), jsWebGLContextAttributes);
    jsWebGLContextAttributes->releaseImpl();
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, WebGLContextAttributes* impl)
{
    return wrap<JSWebGLContextAttributes>(exec, globalObject, impl);
}

WebGLContextAttributes* toWebGLContextAttributes(JSC::JSValue value)
{
    return value.inherits(&JSWebGLContextAttributes::s_info) ? jsCast<JSWebGLContextAttributes*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(WEBGL)
