/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSHTMLButtonElement.h"

#include "ExceptionCode.h"
#include "HTMLButtonElement.h"
#include "HTMLFormElement.h"
#include "HTMLNames.h"
#include "JSDOMBinding.h"
#include "JSHTMLFormElement.h"
#include "JSNodeList.h"
#include "JSValidityState.h"
#include "KURL.h"
#include "NameNodeList.h"
#include "NodeList.h"
#include "ValidityState.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSHTMLButtonElementTableValues[] =
{
    { "autofocus", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLButtonElementAutofocus), (intptr_t)setJSHTMLButtonElementAutofocus, NoIntrinsic },
    { "disabled", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLButtonElementDisabled), (intptr_t)setJSHTMLButtonElementDisabled, NoIntrinsic },
    { "form", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLButtonElementForm), (intptr_t)0, NoIntrinsic },
    { "formAction", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLButtonElementFormAction), (intptr_t)setJSHTMLButtonElementFormAction, NoIntrinsic },
    { "formEnctype", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLButtonElementFormEnctype), (intptr_t)setJSHTMLButtonElementFormEnctype, NoIntrinsic },
    { "formMethod", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLButtonElementFormMethod), (intptr_t)setJSHTMLButtonElementFormMethod, NoIntrinsic },
    { "formNoValidate", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLButtonElementFormNoValidate), (intptr_t)setJSHTMLButtonElementFormNoValidate, NoIntrinsic },
    { "formTarget", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLButtonElementFormTarget), (intptr_t)setJSHTMLButtonElementFormTarget, NoIntrinsic },
    { "name", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLButtonElementName), (intptr_t)setJSHTMLButtonElementName, NoIntrinsic },
    { "type", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLButtonElementType), (intptr_t)setJSHTMLButtonElementType, NoIntrinsic },
    { "value", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLButtonElementValue), (intptr_t)setJSHTMLButtonElementValue, NoIntrinsic },
    { "willValidate", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLButtonElementWillValidate), (intptr_t)0, NoIntrinsic },
    { "validity", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLButtonElementValidity), (intptr_t)0, NoIntrinsic },
    { "validationMessage", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLButtonElementValidationMessage), (intptr_t)0, NoIntrinsic },
    { "labels", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLButtonElementLabels), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLButtonElementConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLButtonElementTable = { 35, 31, JSHTMLButtonElementTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSHTMLButtonElementConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLButtonElementConstructorTable = { 1, 0, JSHTMLButtonElementConstructorTableValues, 0 };
const ClassInfo JSHTMLButtonElementConstructor::s_info = { "HTMLButtonElementConstructor", &Base::s_info, &JSHTMLButtonElementConstructorTable, 0, CREATE_METHOD_TABLE(JSHTMLButtonElementConstructor) };

JSHTMLButtonElementConstructor::JSHTMLButtonElementConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSHTMLButtonElementConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSHTMLButtonElementPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSHTMLButtonElementConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLButtonElementConstructor, JSDOMWrapper>(exec, &JSHTMLButtonElementConstructorTable, jsCast<JSHTMLButtonElementConstructor*>(cell), propertyName, slot);
}

bool JSHTMLButtonElementConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSHTMLButtonElementConstructor, JSDOMWrapper>(exec, &JSHTMLButtonElementConstructorTable, jsCast<JSHTMLButtonElementConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSHTMLButtonElementPrototypeTableValues[] =
{
    { "checkValidity", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsHTMLButtonElementPrototypeFunctionCheckValidity), (intptr_t)0, NoIntrinsic },
    { "setCustomValidity", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsHTMLButtonElementPrototypeFunctionSetCustomValidity), (intptr_t)1, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLButtonElementPrototypeTable = { 4, 3, JSHTMLButtonElementPrototypeTableValues, 0 };
const ClassInfo JSHTMLButtonElementPrototype::s_info = { "HTMLButtonElementPrototype", &Base::s_info, &JSHTMLButtonElementPrototypeTable, 0, CREATE_METHOD_TABLE(JSHTMLButtonElementPrototype) };

JSObject* JSHTMLButtonElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSHTMLButtonElement>(exec, globalObject);
}

bool JSHTMLButtonElementPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSHTMLButtonElementPrototype* thisObject = jsCast<JSHTMLButtonElementPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, &JSHTMLButtonElementPrototypeTable, thisObject, propertyName, slot);
}

bool JSHTMLButtonElementPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSHTMLButtonElementPrototype* thisObject = jsCast<JSHTMLButtonElementPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, &JSHTMLButtonElementPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSHTMLButtonElement::s_info = { "HTMLButtonElement", &Base::s_info, &JSHTMLButtonElementTable, 0 , CREATE_METHOD_TABLE(JSHTMLButtonElement) };

JSHTMLButtonElement::JSHTMLButtonElement(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<HTMLButtonElement> impl)
    : JSHTMLElement(structure, globalObject, impl)
{
}

void JSHTMLButtonElement::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSHTMLButtonElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSHTMLButtonElementPrototype::create(exec->globalData(), globalObject, JSHTMLButtonElementPrototype::createStructure(exec->globalData(), globalObject, JSHTMLElementPrototype::self(exec, globalObject)));
}

bool JSHTMLButtonElement::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSHTMLButtonElement* thisObject = jsCast<JSHTMLButtonElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSHTMLButtonElement, Base>(exec, &JSHTMLButtonElementTable, thisObject, propertyName, slot);
}

bool JSHTMLButtonElement::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSHTMLButtonElement* thisObject = jsCast<JSHTMLButtonElement*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSHTMLButtonElement, Base>(exec, &JSHTMLButtonElementTable, thisObject, propertyName, descriptor);
}

JSValue jsHTMLButtonElementAutofocus(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLButtonElement* castedThis = jsCast<JSHTMLButtonElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLButtonElement* impl = static_cast<HTMLButtonElement*>(castedThis->impl());
    JSValue result = jsBoolean(impl->hasAttribute(WebCore::HTMLNames::autofocusAttr));
    return result;
}


JSValue jsHTMLButtonElementDisabled(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLButtonElement* castedThis = jsCast<JSHTMLButtonElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLButtonElement* impl = static_cast<HTMLButtonElement*>(castedThis->impl());
    JSValue result = jsBoolean(impl->hasAttribute(WebCore::HTMLNames::disabledAttr));
    return result;
}


JSValue jsHTMLButtonElementForm(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLButtonElement* castedThis = jsCast<JSHTMLButtonElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLButtonElement* impl = static_cast<HTMLButtonElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->form()));
    return result;
}


JSValue jsHTMLButtonElementFormAction(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLButtonElement* castedThis = jsCast<JSHTMLButtonElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLButtonElement* impl = static_cast<HTMLButtonElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->getURLAttribute(WebCore::HTMLNames::formactionAttr));
    return result;
}


JSValue jsHTMLButtonElementFormEnctype(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLButtonElement* castedThis = jsCast<JSHTMLButtonElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLButtonElement* impl = static_cast<HTMLButtonElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->formEnctype());
    return result;
}


JSValue jsHTMLButtonElementFormMethod(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLButtonElement* castedThis = jsCast<JSHTMLButtonElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLButtonElement* impl = static_cast<HTMLButtonElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->formMethod());
    return result;
}


JSValue jsHTMLButtonElementFormNoValidate(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLButtonElement* castedThis = jsCast<JSHTMLButtonElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLButtonElement* impl = static_cast<HTMLButtonElement*>(castedThis->impl());
    JSValue result = jsBoolean(impl->hasAttribute(WebCore::HTMLNames::formnovalidateAttr));
    return result;
}


JSValue jsHTMLButtonElementFormTarget(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLButtonElement* castedThis = jsCast<JSHTMLButtonElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLButtonElement* impl = static_cast<HTMLButtonElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->getAttribute(WebCore::HTMLNames::formtargetAttr));
    return result;
}


JSValue jsHTMLButtonElementName(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLButtonElement* castedThis = jsCast<JSHTMLButtonElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLButtonElement* impl = static_cast<HTMLButtonElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->getAttribute(WebCore::HTMLNames::nameAttr));
    return result;
}


JSValue jsHTMLButtonElementType(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLButtonElement* castedThis = jsCast<JSHTMLButtonElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLButtonElement* impl = static_cast<HTMLButtonElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->type());
    return result;
}


JSValue jsHTMLButtonElementValue(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLButtonElement* castedThis = jsCast<JSHTMLButtonElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLButtonElement* impl = static_cast<HTMLButtonElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->getAttribute(WebCore::HTMLNames::valueAttr));
    return result;
}


JSValue jsHTMLButtonElementWillValidate(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLButtonElement* castedThis = jsCast<JSHTMLButtonElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLButtonElement* impl = static_cast<HTMLButtonElement*>(castedThis->impl());
    JSValue result = jsBoolean(impl->willValidate());
    return result;
}


JSValue jsHTMLButtonElementValidity(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLButtonElement* castedThis = jsCast<JSHTMLButtonElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLButtonElement* impl = static_cast<HTMLButtonElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->validity()));
    return result;
}


JSValue jsHTMLButtonElementValidationMessage(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLButtonElement* castedThis = jsCast<JSHTMLButtonElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLButtonElement* impl = static_cast<HTMLButtonElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->validationMessage());
    return result;
}


JSValue jsHTMLButtonElementLabels(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLButtonElement* castedThis = jsCast<JSHTMLButtonElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLButtonElement* impl = static_cast<HTMLButtonElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->labels()));
    return result;
}


JSValue jsHTMLButtonElementConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLButtonElement* domObject = jsCast<JSHTMLButtonElement*>(asObject(slotBase));
    return JSHTMLButtonElement::getConstructor(exec, domObject->globalObject());
}

void JSHTMLButtonElement::put(JSCell* cell, ExecState* exec, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    JSHTMLButtonElement* thisObject = jsCast<JSHTMLButtonElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    lookupPut<JSHTMLButtonElement, Base>(exec, propertyName, value, &JSHTMLButtonElementTable, thisObject, slot);
}

void setJSHTMLButtonElementAutofocus(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLButtonElement* castedThis = jsCast<JSHTMLButtonElement*>(thisObject);
    HTMLButtonElement* impl = static_cast<HTMLButtonElement*>(castedThis->impl());
    impl->setBooleanAttribute(WebCore::HTMLNames::autofocusAttr, value.toBoolean(exec));
}


void setJSHTMLButtonElementDisabled(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLButtonElement* castedThis = jsCast<JSHTMLButtonElement*>(thisObject);
    HTMLButtonElement* impl = static_cast<HTMLButtonElement*>(castedThis->impl());
    impl->setBooleanAttribute(WebCore::HTMLNames::disabledAttr, value.toBoolean(exec));
}


void setJSHTMLButtonElementFormAction(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLButtonElement* castedThis = jsCast<JSHTMLButtonElement*>(thisObject);
    HTMLButtonElement* impl = static_cast<HTMLButtonElement*>(castedThis->impl());
    impl->setAttribute(WebCore::HTMLNames::formactionAttr, valueToStringWithNullCheck(exec, value));
}


void setJSHTMLButtonElementFormEnctype(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLButtonElement* castedThis = jsCast<JSHTMLButtonElement*>(thisObject);
    HTMLButtonElement* impl = static_cast<HTMLButtonElement*>(castedThis->impl());
    impl->setFormEnctype(valueToStringWithNullCheck(exec, value));
}


void setJSHTMLButtonElementFormMethod(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLButtonElement* castedThis = jsCast<JSHTMLButtonElement*>(thisObject);
    HTMLButtonElement* impl = static_cast<HTMLButtonElement*>(castedThis->impl());
    impl->setFormMethod(valueToStringWithNullCheck(exec, value));
}


void setJSHTMLButtonElementFormNoValidate(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLButtonElement* castedThis = jsCast<JSHTMLButtonElement*>(thisObject);
    HTMLButtonElement* impl = static_cast<HTMLButtonElement*>(castedThis->impl());
    impl->setBooleanAttribute(WebCore::HTMLNames::formnovalidateAttr, value.toBoolean(exec));
}


void setJSHTMLButtonElementFormTarget(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLButtonElement* castedThis = jsCast<JSHTMLButtonElement*>(thisObject);
    HTMLButtonElement* impl = static_cast<HTMLButtonElement*>(castedThis->impl());
    impl->setAttribute(WebCore::HTMLNames::formtargetAttr, valueToStringWithNullCheck(exec, value));
}


void setJSHTMLButtonElementName(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLButtonElement* castedThis = jsCast<JSHTMLButtonElement*>(thisObject);
    HTMLButtonElement* impl = static_cast<HTMLButtonElement*>(castedThis->impl());
    impl->setAttribute(WebCore::HTMLNames::nameAttr, valueToStringWithNullCheck(exec, value));
}


void setJSHTMLButtonElementType(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLButtonElement* castedThis = jsCast<JSHTMLButtonElement*>(thisObject);
    HTMLButtonElement* impl = static_cast<HTMLButtonElement*>(castedThis->impl());
    impl->setType(valueToStringWithNullCheck(exec, value));
}


void setJSHTMLButtonElementValue(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLButtonElement* castedThis = jsCast<JSHTMLButtonElement*>(thisObject);
    HTMLButtonElement* impl = static_cast<HTMLButtonElement*>(castedThis->impl());
    impl->setAttribute(WebCore::HTMLNames::valueAttr, valueToStringWithNullCheck(exec, value));
}


JSValue JSHTMLButtonElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLButtonElementConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsHTMLButtonElementPrototypeFunctionCheckValidity(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSHTMLButtonElement::s_info))
        return throwVMTypeError(exec);
    JSHTMLButtonElement* castedThis = jsCast<JSHTMLButtonElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSHTMLButtonElement::s_info);
    HTMLButtonElement* impl = static_cast<HTMLButtonElement*>(castedThis->impl());

    JSC::JSValue result = jsBoolean(impl->checkValidity());
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsHTMLButtonElementPrototypeFunctionSetCustomValidity(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSHTMLButtonElement::s_info))
        return throwVMTypeError(exec);
    JSHTMLButtonElement* castedThis = jsCast<JSHTMLButtonElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSHTMLButtonElement::s_info);
    HTMLButtonElement* impl = static_cast<HTMLButtonElement*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    const String& error(valueToStringWithUndefinedOrNullCheck(exec, MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setCustomValidity(error);
    return JSValue::encode(jsUndefined());
}


}
