/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSHTMLHRElement.h"

#include "HTMLHRElement.h"
#include "HTMLNames.h"
#include "KURL.h"
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSHTMLHRElementTableValues[] =
{
    { "align", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLHRElementAlign), (intptr_t)setJSHTMLHRElementAlign, NoIntrinsic },
    { "noShade", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLHRElementNoShade), (intptr_t)setJSHTMLHRElementNoShade, NoIntrinsic },
    { "size", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLHRElementSize), (intptr_t)setJSHTMLHRElementSize, NoIntrinsic },
    { "width", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLHRElementWidth), (intptr_t)setJSHTMLHRElementWidth, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLHRElementConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLHRElementTable = { 17, 15, JSHTMLHRElementTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSHTMLHRElementConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLHRElementConstructorTable = { 1, 0, JSHTMLHRElementConstructorTableValues, 0 };
const ClassInfo JSHTMLHRElementConstructor::s_info = { "HTMLHRElementConstructor", &Base::s_info, &JSHTMLHRElementConstructorTable, 0, CREATE_METHOD_TABLE(JSHTMLHRElementConstructor) };

JSHTMLHRElementConstructor::JSHTMLHRElementConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSHTMLHRElementConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSHTMLHRElementPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSHTMLHRElementConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLHRElementConstructor, JSDOMWrapper>(exec, &JSHTMLHRElementConstructorTable, jsCast<JSHTMLHRElementConstructor*>(cell), propertyName, slot);
}

bool JSHTMLHRElementConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSHTMLHRElementConstructor, JSDOMWrapper>(exec, &JSHTMLHRElementConstructorTable, jsCast<JSHTMLHRElementConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSHTMLHRElementPrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLHRElementPrototypeTable = { 1, 0, JSHTMLHRElementPrototypeTableValues, 0 };
const ClassInfo JSHTMLHRElementPrototype::s_info = { "HTMLHRElementPrototype", &Base::s_info, &JSHTMLHRElementPrototypeTable, 0, CREATE_METHOD_TABLE(JSHTMLHRElementPrototype) };

JSObject* JSHTMLHRElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSHTMLHRElement>(exec, globalObject);
}

const ClassInfo JSHTMLHRElement::s_info = { "HTMLHRElement", &Base::s_info, &JSHTMLHRElementTable, 0 , CREATE_METHOD_TABLE(JSHTMLHRElement) };

JSHTMLHRElement::JSHTMLHRElement(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<HTMLHRElement> impl)
    : JSHTMLElement(structure, globalObject, impl)
{
}

void JSHTMLHRElement::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSHTMLHRElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSHTMLHRElementPrototype::create(exec->globalData(), globalObject, JSHTMLHRElementPrototype::createStructure(exec->globalData(), globalObject, JSHTMLElementPrototype::self(exec, globalObject)));
}

bool JSHTMLHRElement::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSHTMLHRElement* thisObject = jsCast<JSHTMLHRElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSHTMLHRElement, Base>(exec, &JSHTMLHRElementTable, thisObject, propertyName, slot);
}

bool JSHTMLHRElement::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSHTMLHRElement* thisObject = jsCast<JSHTMLHRElement*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSHTMLHRElement, Base>(exec, &JSHTMLHRElementTable, thisObject, propertyName, descriptor);
}

JSValue jsHTMLHRElementAlign(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLHRElement* castedThis = jsCast<JSHTMLHRElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLHRElement* impl = static_cast<HTMLHRElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->getAttribute(WebCore::HTMLNames::alignAttr));
    return result;
}


JSValue jsHTMLHRElementNoShade(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLHRElement* castedThis = jsCast<JSHTMLHRElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLHRElement* impl = static_cast<HTMLHRElement*>(castedThis->impl());
    JSValue result = jsBoolean(impl->hasAttribute(WebCore::HTMLNames::noshadeAttr));
    return result;
}


JSValue jsHTMLHRElementSize(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLHRElement* castedThis = jsCast<JSHTMLHRElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLHRElement* impl = static_cast<HTMLHRElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->getAttribute(WebCore::HTMLNames::sizeAttr));
    return result;
}


JSValue jsHTMLHRElementWidth(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLHRElement* castedThis = jsCast<JSHTMLHRElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLHRElement* impl = static_cast<HTMLHRElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->getAttribute(WebCore::HTMLNames::widthAttr));
    return result;
}


JSValue jsHTMLHRElementConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLHRElement* domObject = jsCast<JSHTMLHRElement*>(asObject(slotBase));
    return JSHTMLHRElement::getConstructor(exec, domObject->globalObject());
}

void JSHTMLHRElement::put(JSCell* cell, ExecState* exec, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    JSHTMLHRElement* thisObject = jsCast<JSHTMLHRElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    lookupPut<JSHTMLHRElement, Base>(exec, propertyName, value, &JSHTMLHRElementTable, thisObject, slot);
}

void setJSHTMLHRElementAlign(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLHRElement* castedThis = jsCast<JSHTMLHRElement*>(thisObject);
    HTMLHRElement* impl = static_cast<HTMLHRElement*>(castedThis->impl());
    impl->setAttribute(WebCore::HTMLNames::alignAttr, valueToStringWithNullCheck(exec, value));
}


void setJSHTMLHRElementNoShade(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLHRElement* castedThis = jsCast<JSHTMLHRElement*>(thisObject);
    HTMLHRElement* impl = static_cast<HTMLHRElement*>(castedThis->impl());
    impl->setBooleanAttribute(WebCore::HTMLNames::noshadeAttr, value.toBoolean(exec));
}


void setJSHTMLHRElementSize(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLHRElement* castedThis = jsCast<JSHTMLHRElement*>(thisObject);
    HTMLHRElement* impl = static_cast<HTMLHRElement*>(castedThis->impl());
    impl->setAttribute(WebCore::HTMLNames::sizeAttr, valueToStringWithNullCheck(exec, value));
}


void setJSHTMLHRElementWidth(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLHRElement* castedThis = jsCast<JSHTMLHRElement*>(thisObject);
    HTMLHRElement* impl = static_cast<HTMLHRElement*>(castedThis->impl());
    impl->setAttribute(WebCore::HTMLNames::widthAttr, valueToStringWithNullCheck(exec, value));
}


JSValue JSHTMLHRElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLHRElementConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}


}
