/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG)

#include "JSSVGAnimatedAngle.h"

#include "JSSVGAngle.h"
#include "SVGAngle.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSSVGAnimatedAngleTableValues[] =
{
    { "baseVal", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGAnimatedAngleBaseVal), (intptr_t)0, NoIntrinsic },
    { "animVal", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGAnimatedAngleAnimVal), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGAnimatedAngleConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGAnimatedAngleTable = { 8, 7, JSSVGAnimatedAngleTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSSVGAnimatedAngleConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGAnimatedAngleConstructorTable = { 1, 0, JSSVGAnimatedAngleConstructorTableValues, 0 };
const ClassInfo JSSVGAnimatedAngleConstructor::s_info = { "SVGAnimatedAngleConstructor", &Base::s_info, &JSSVGAnimatedAngleConstructorTable, 0, CREATE_METHOD_TABLE(JSSVGAnimatedAngleConstructor) };

JSSVGAnimatedAngleConstructor::JSSVGAnimatedAngleConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSSVGAnimatedAngleConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSSVGAnimatedAnglePrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSSVGAnimatedAngleConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGAnimatedAngleConstructor, JSDOMWrapper>(exec, &JSSVGAnimatedAngleConstructorTable, jsCast<JSSVGAnimatedAngleConstructor*>(cell), propertyName, slot);
}

bool JSSVGAnimatedAngleConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGAnimatedAngleConstructor, JSDOMWrapper>(exec, &JSSVGAnimatedAngleConstructorTable, jsCast<JSSVGAnimatedAngleConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSSVGAnimatedAnglePrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGAnimatedAnglePrototypeTable = { 1, 0, JSSVGAnimatedAnglePrototypeTableValues, 0 };
const ClassInfo JSSVGAnimatedAnglePrototype::s_info = { "SVGAnimatedAnglePrototype", &Base::s_info, &JSSVGAnimatedAnglePrototypeTable, 0, CREATE_METHOD_TABLE(JSSVGAnimatedAnglePrototype) };

JSObject* JSSVGAnimatedAnglePrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGAnimatedAngle>(exec, globalObject);
}

const ClassInfo JSSVGAnimatedAngle::s_info = { "SVGAnimatedAngle", &Base::s_info, &JSSVGAnimatedAngleTable, 0 , CREATE_METHOD_TABLE(JSSVGAnimatedAngle) };

JSSVGAnimatedAngle::JSSVGAnimatedAngle(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGAnimatedAngle> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSSVGAnimatedAngle::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSSVGAnimatedAngle::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSSVGAnimatedAnglePrototype::create(exec->globalData(), globalObject, JSSVGAnimatedAnglePrototype::createStructure(globalObject->globalData(), globalObject, globalObject->objectPrototype()));
}

void JSSVGAnimatedAngle::destroy(JSC::JSCell* cell)
{
    JSSVGAnimatedAngle* thisObject = static_cast<JSSVGAnimatedAngle*>(cell);
    thisObject->JSSVGAnimatedAngle::~JSSVGAnimatedAngle();
}

JSSVGAnimatedAngle::~JSSVGAnimatedAngle()
{
    releaseImplIfNotNull();
}

bool JSSVGAnimatedAngle::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGAnimatedAngle* thisObject = jsCast<JSSVGAnimatedAngle*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSSVGAnimatedAngle, Base>(exec, &JSSVGAnimatedAngleTable, thisObject, propertyName, slot);
}

bool JSSVGAnimatedAngle::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGAnimatedAngle* thisObject = jsCast<JSSVGAnimatedAngle*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSSVGAnimatedAngle, Base>(exec, &JSSVGAnimatedAngleTable, thisObject, propertyName, descriptor);
}

JSValue jsSVGAnimatedAngleBaseVal(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGAnimatedAngle* castedThis = jsCast<JSSVGAnimatedAngle*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGAnimatedAngle* impl = static_cast<SVGAnimatedAngle*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(static_cast<SVGPropertyTearOff<SVGAngle>*>(impl->baseVal())));
    return result;
}


JSValue jsSVGAnimatedAngleAnimVal(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGAnimatedAngle* castedThis = jsCast<JSSVGAnimatedAngle*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGAnimatedAngle* impl = static_cast<SVGAnimatedAngle*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(static_cast<SVGPropertyTearOff<SVGAngle>*>(impl->animVal())));
    return result;
}


JSValue jsSVGAnimatedAngleConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGAnimatedAngle* domObject = jsCast<JSSVGAnimatedAngle*>(asObject(slotBase));
    return JSSVGAnimatedAngle::getConstructor(exec, domObject->globalObject());
}

JSValue JSSVGAnimatedAngle::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGAnimatedAngleConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

static inline bool isObservable(JSSVGAnimatedAngle* jsSVGAnimatedAngle)
{
    if (jsSVGAnimatedAngle->hasCustomProperties())
        return true;
    return false;
}

bool JSSVGAnimatedAngleOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSSVGAnimatedAngle* jsSVGAnimatedAngle = jsCast<JSSVGAnimatedAngle*>(handle.get().asCell());
    if (!isObservable(jsSVGAnimatedAngle))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSSVGAnimatedAngleOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSSVGAnimatedAngle* jsSVGAnimatedAngle = jsCast<JSSVGAnimatedAngle*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsSVGAnimatedAngle->impl(), jsSVGAnimatedAngle);
    jsSVGAnimatedAngle->releaseImpl();
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, SVGAnimatedAngle* impl)
{
    return wrap<JSSVGAnimatedAngle>(exec, globalObject, impl);
}

SVGAnimatedAngle* toSVGAnimatedAngle(JSC::JSValue value)
{
    return value.inherits(&JSSVGAnimatedAngle::s_info) ? jsCast<JSSVGAnimatedAngle*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(SVG)
