/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG)

#include "JSSVGDescElement.h"

#include "CSSStyleDeclaration.h"
#include "CSSValue.h"
#include "ExceptionCode.h"
#include "JSCSSStyleDeclaration.h"
#include "JSCSSValue.h"
#include "JSDOMBinding.h"
#include "JSSVGAnimatedString.h"
#include "KURL.h"
#include "SVGDescElement.h"
#include "StylePropertySet.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSSVGDescElementTableValues[] =
{
    { "xmllang", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGDescElementXmllang), (intptr_t)setJSSVGDescElementXmllang, NoIntrinsic },
    { "xmlspace", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGDescElementXmlspace), (intptr_t)setJSSVGDescElementXmlspace, NoIntrinsic },
    { "className", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGDescElementClassName), (intptr_t)0, NoIntrinsic },
    { "style", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGDescElementStyle), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGDescElementConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGDescElementTable = { 16, 15, JSSVGDescElementTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSSVGDescElementConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGDescElementConstructorTable = { 1, 0, JSSVGDescElementConstructorTableValues, 0 };
const ClassInfo JSSVGDescElementConstructor::s_info = { "SVGDescElementConstructor", &Base::s_info, &JSSVGDescElementConstructorTable, 0, CREATE_METHOD_TABLE(JSSVGDescElementConstructor) };

JSSVGDescElementConstructor::JSSVGDescElementConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSSVGDescElementConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSSVGDescElementPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSSVGDescElementConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGDescElementConstructor, JSDOMWrapper>(exec, &JSSVGDescElementConstructorTable, jsCast<JSSVGDescElementConstructor*>(cell), propertyName, slot);
}

bool JSSVGDescElementConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGDescElementConstructor, JSDOMWrapper>(exec, &JSSVGDescElementConstructorTable, jsCast<JSSVGDescElementConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSSVGDescElementPrototypeTableValues[] =
{
    { "getPresentationAttribute", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGDescElementPrototypeFunctionGetPresentationAttribute), (intptr_t)1, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGDescElementPrototypeTable = { 2, 1, JSSVGDescElementPrototypeTableValues, 0 };
const ClassInfo JSSVGDescElementPrototype::s_info = { "SVGDescElementPrototype", &Base::s_info, &JSSVGDescElementPrototypeTable, 0, CREATE_METHOD_TABLE(JSSVGDescElementPrototype) };

JSObject* JSSVGDescElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGDescElement>(exec, globalObject);
}

bool JSSVGDescElementPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGDescElementPrototype* thisObject = jsCast<JSSVGDescElementPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, &JSSVGDescElementPrototypeTable, thisObject, propertyName, slot);
}

bool JSSVGDescElementPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGDescElementPrototype* thisObject = jsCast<JSSVGDescElementPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, &JSSVGDescElementPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSSVGDescElement::s_info = { "SVGDescElement", &Base::s_info, &JSSVGDescElementTable, 0 , CREATE_METHOD_TABLE(JSSVGDescElement) };

JSSVGDescElement::JSSVGDescElement(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGDescElement> impl)
    : JSSVGElement(structure, globalObject, impl)
{
}

void JSSVGDescElement::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSSVGDescElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSSVGDescElementPrototype::create(exec->globalData(), globalObject, JSSVGDescElementPrototype::createStructure(exec->globalData(), globalObject, JSSVGElementPrototype::self(exec, globalObject)));
}

bool JSSVGDescElement::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGDescElement* thisObject = jsCast<JSSVGDescElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSSVGDescElement, Base>(exec, &JSSVGDescElementTable, thisObject, propertyName, slot);
}

bool JSSVGDescElement::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGDescElement* thisObject = jsCast<JSSVGDescElement*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSSVGDescElement, Base>(exec, &JSSVGDescElementTable, thisObject, propertyName, descriptor);
}

JSValue jsSVGDescElementXmllang(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGDescElement* castedThis = jsCast<JSSVGDescElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGDescElement* impl = static_cast<SVGDescElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->xmllang());
    return result;
}


JSValue jsSVGDescElementXmlspace(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGDescElement* castedThis = jsCast<JSSVGDescElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGDescElement* impl = static_cast<SVGDescElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->xmlspace());
    return result;
}


JSValue jsSVGDescElementClassName(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGDescElement* castedThis = jsCast<JSSVGDescElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGDescElement* impl = static_cast<SVGDescElement*>(castedThis->impl());
    RefPtr<SVGAnimatedString> obj = impl->classNameAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGDescElementStyle(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGDescElement* castedThis = jsCast<JSSVGDescElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGDescElement* impl = static_cast<SVGDescElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->style()));
    return result;
}


JSValue jsSVGDescElementConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGDescElement* domObject = jsCast<JSSVGDescElement*>(asObject(slotBase));
    return JSSVGDescElement::getConstructor(exec, domObject->globalObject());
}

void JSSVGDescElement::put(JSCell* cell, ExecState* exec, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    JSSVGDescElement* thisObject = jsCast<JSSVGDescElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    lookupPut<JSSVGDescElement, Base>(exec, propertyName, value, &JSSVGDescElementTable, thisObject, slot);
}

void setJSSVGDescElementXmllang(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSSVGDescElement* castedThis = jsCast<JSSVGDescElement*>(thisObject);
    SVGDescElement* impl = static_cast<SVGDescElement*>(castedThis->impl());
    impl->setXmllang(value.isEmpty() ? String() : value.toString(exec)->value(exec));
}


void setJSSVGDescElementXmlspace(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSSVGDescElement* castedThis = jsCast<JSSVGDescElement*>(thisObject);
    SVGDescElement* impl = static_cast<SVGDescElement*>(castedThis->impl());
    impl->setXmlspace(value.isEmpty() ? String() : value.toString(exec)->value(exec));
}


JSValue JSSVGDescElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGDescElementConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsSVGDescElementPrototypeFunctionGetPresentationAttribute(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGDescElement::s_info))
        return throwVMTypeError(exec);
    JSSVGDescElement* castedThis = jsCast<JSSVGDescElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGDescElement::s_info);
    SVGDescElement* impl = static_cast<SVGDescElement*>(castedThis->impl());
    const String& name(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->getPresentationAttribute(name)));
    return JSValue::encode(result);
}


}

#endif // ENABLE(SVG)
