/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGL)

#include "JSWebGLTexture.h"

#include "WebGLTexture.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSWebGLTextureTableValues[] =
{
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebGLTextureConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSWebGLTextureTable = { 2, 1, JSWebGLTextureTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSWebGLTextureConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSWebGLTextureConstructorTable = { 1, 0, JSWebGLTextureConstructorTableValues, 0 };
const ClassInfo JSWebGLTextureConstructor::s_info = { "WebGLTextureConstructor", &Base::s_info, &JSWebGLTextureConstructorTable, 0, CREATE_METHOD_TABLE(JSWebGLTextureConstructor) };

JSWebGLTextureConstructor::JSWebGLTextureConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSWebGLTextureConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSWebGLTexturePrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSWebGLTextureConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSWebGLTextureConstructor, JSDOMWrapper>(exec, &JSWebGLTextureConstructorTable, jsCast<JSWebGLTextureConstructor*>(cell), propertyName, slot);
}

bool JSWebGLTextureConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSWebGLTextureConstructor, JSDOMWrapper>(exec, &JSWebGLTextureConstructorTable, jsCast<JSWebGLTextureConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSWebGLTexturePrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSWebGLTexturePrototypeTable = { 1, 0, JSWebGLTexturePrototypeTableValues, 0 };
const ClassInfo JSWebGLTexturePrototype::s_info = { "WebGLTexturePrototype", &Base::s_info, &JSWebGLTexturePrototypeTable, 0, CREATE_METHOD_TABLE(JSWebGLTexturePrototype) };

JSObject* JSWebGLTexturePrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSWebGLTexture>(exec, globalObject);
}

const ClassInfo JSWebGLTexture::s_info = { "WebGLTexture", &Base::s_info, &JSWebGLTextureTable, 0 , CREATE_METHOD_TABLE(JSWebGLTexture) };

JSWebGLTexture::JSWebGLTexture(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<WebGLTexture> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSWebGLTexture::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSWebGLTexture::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSWebGLTexturePrototype::create(exec->globalData(), globalObject, JSWebGLTexturePrototype::createStructure(globalObject->globalData(), globalObject, globalObject->objectPrototype()));
}

void JSWebGLTexture::destroy(JSC::JSCell* cell)
{
    JSWebGLTexture* thisObject = static_cast<JSWebGLTexture*>(cell);
    thisObject->JSWebGLTexture::~JSWebGLTexture();
}

JSWebGLTexture::~JSWebGLTexture()
{
    releaseImplIfNotNull();
}

bool JSWebGLTexture::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSWebGLTexture* thisObject = jsCast<JSWebGLTexture*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSWebGLTexture, Base>(exec, &JSWebGLTextureTable, thisObject, propertyName, slot);
}

bool JSWebGLTexture::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSWebGLTexture* thisObject = jsCast<JSWebGLTexture*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSWebGLTexture, Base>(exec, &JSWebGLTextureTable, thisObject, propertyName, descriptor);
}

JSValue jsWebGLTextureConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWebGLTexture* domObject = jsCast<JSWebGLTexture*>(asObject(slotBase));
    return JSWebGLTexture::getConstructor(exec, domObject->globalObject());
}

JSValue JSWebGLTexture::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSWebGLTextureConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

static inline bool isObservable(JSWebGLTexture* jsWebGLTexture)
{
    if (jsWebGLTexture->hasCustomProperties())
        return true;
    return false;
}

bool JSWebGLTextureOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSWebGLTexture* jsWebGLTexture = jsCast<JSWebGLTexture*>(handle.get().asCell());
    if (!isObservable(jsWebGLTexture))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSWebGLTextureOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSWebGLTexture* jsWebGLTexture = jsCast<JSWebGLTexture*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsWebGLTexture->impl(), jsWebGLTexture);
    jsWebGLTexture->releaseImpl();
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, WebGLTexture* impl)
{
    return wrap<JSWebGLTexture>(exec, globalObject, impl);
}

WebGLTexture* toWebGLTexture(JSC::JSValue value)
{
    return value.inherits(&JSWebGLTexture::s_info) ? jsCast<JSWebGLTexture*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(WEBGL)
