/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSXMLSerializer.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSNode.h"
#include "KURL.h"
#include "XMLSerializer.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSXMLSerializerTableValues[] =
{
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsXMLSerializerConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSXMLSerializerTable = { 2, 1, JSXMLSerializerTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSXMLSerializerConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSXMLSerializerConstructorTable = { 1, 0, JSXMLSerializerConstructorTableValues, 0 };
const ClassInfo JSXMLSerializerConstructor::s_info = { "XMLSerializerConstructor", &Base::s_info, &JSXMLSerializerConstructorTable, 0, CREATE_METHOD_TABLE(JSXMLSerializerConstructor) };

JSXMLSerializerConstructor::JSXMLSerializerConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSXMLSerializerConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSXMLSerializerPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->globalData(), exec->propertyNames().length, jsNumber(0), ReadOnly | DontDelete | DontEnum);
}

bool JSXMLSerializerConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSXMLSerializerConstructor, JSDOMWrapper>(exec, &JSXMLSerializerConstructorTable, jsCast<JSXMLSerializerConstructor*>(cell), propertyName, slot);
}

bool JSXMLSerializerConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSXMLSerializerConstructor, JSDOMWrapper>(exec, &JSXMLSerializerConstructorTable, jsCast<JSXMLSerializerConstructor*>(object), propertyName, descriptor);
}

EncodedJSValue JSC_HOST_CALL JSXMLSerializerConstructor::constructJSXMLSerializer(ExecState* exec)
{
    JSXMLSerializerConstructor* castedThis = jsCast<JSXMLSerializerConstructor*>(exec->callee());
    RefPtr<XMLSerializer> object = XMLSerializer::create();
    return JSValue::encode(asObject(toJS(exec, castedThis->globalObject(), object.get())));
}

ConstructType JSXMLSerializerConstructor::getConstructData(JSCell*, ConstructData& constructData)
{
    constructData.native.function = constructJSXMLSerializer;
    return ConstructTypeHost;
}

/* Hash table for prototype */

static const HashTableValue JSXMLSerializerPrototypeTableValues[] =
{
    { "serializeToString", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsXMLSerializerPrototypeFunctionSerializeToString), (intptr_t)1, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSXMLSerializerPrototypeTable = { 2, 1, JSXMLSerializerPrototypeTableValues, 0 };
const ClassInfo JSXMLSerializerPrototype::s_info = { "XMLSerializerPrototype", &Base::s_info, &JSXMLSerializerPrototypeTable, 0, CREATE_METHOD_TABLE(JSXMLSerializerPrototype) };

JSObject* JSXMLSerializerPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSXMLSerializer>(exec, globalObject);
}

bool JSXMLSerializerPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSXMLSerializerPrototype* thisObject = jsCast<JSXMLSerializerPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, &JSXMLSerializerPrototypeTable, thisObject, propertyName, slot);
}

bool JSXMLSerializerPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSXMLSerializerPrototype* thisObject = jsCast<JSXMLSerializerPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, &JSXMLSerializerPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSXMLSerializer::s_info = { "XMLSerializer", &Base::s_info, &JSXMLSerializerTable, 0 , CREATE_METHOD_TABLE(JSXMLSerializer) };

JSXMLSerializer::JSXMLSerializer(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<XMLSerializer> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSXMLSerializer::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSXMLSerializer::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSXMLSerializerPrototype::create(exec->globalData(), globalObject, JSXMLSerializerPrototype::createStructure(globalObject->globalData(), globalObject, globalObject->objectPrototype()));
}

void JSXMLSerializer::destroy(JSC::JSCell* cell)
{
    JSXMLSerializer* thisObject = static_cast<JSXMLSerializer*>(cell);
    thisObject->JSXMLSerializer::~JSXMLSerializer();
}

JSXMLSerializer::~JSXMLSerializer()
{
    releaseImplIfNotNull();
}

bool JSXMLSerializer::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSXMLSerializer* thisObject = jsCast<JSXMLSerializer*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSXMLSerializer, Base>(exec, &JSXMLSerializerTable, thisObject, propertyName, slot);
}

bool JSXMLSerializer::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSXMLSerializer* thisObject = jsCast<JSXMLSerializer*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSXMLSerializer, Base>(exec, &JSXMLSerializerTable, thisObject, propertyName, descriptor);
}

JSValue jsXMLSerializerConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSXMLSerializer* domObject = jsCast<JSXMLSerializer*>(asObject(slotBase));
    return JSXMLSerializer::getConstructor(exec, domObject->globalObject());
}

JSValue JSXMLSerializer::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSXMLSerializerConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsXMLSerializerPrototypeFunctionSerializeToString(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSXMLSerializer::s_info))
        return throwVMTypeError(exec);
    JSXMLSerializer* castedThis = jsCast<JSXMLSerializer*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSXMLSerializer::s_info);
    XMLSerializer* impl = static_cast<XMLSerializer*>(castedThis->impl());
    ExceptionCode ec = 0;
    Node* node(toNode(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsStringWithCache(exec, impl->serializeToString(node, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

static inline bool isObservable(JSXMLSerializer* jsXMLSerializer)
{
    if (jsXMLSerializer->hasCustomProperties())
        return true;
    return false;
}

bool JSXMLSerializerOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSXMLSerializer* jsXMLSerializer = jsCast<JSXMLSerializer*>(handle.get().asCell());
    if (!isObservable(jsXMLSerializer))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSXMLSerializerOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSXMLSerializer* jsXMLSerializer = jsCast<JSXMLSerializer*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsXMLSerializer->impl(), jsXMLSerializer);
    jsXMLSerializer->releaseImpl();
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, XMLSerializer* impl)
{
    return wrap<JSXMLSerializer>(exec, globalObject, impl);
}

XMLSerializer* toXMLSerializer(JSC::JSValue value)
{
    return value.inherits(&JSXMLSerializer::s_info) ? jsCast<JSXMLSerializer*>(asObject(value))->impl() : 0;
}

}
