/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSMouseEvent.h"

#include "Clipboard.h"
#include "EventTarget.h"
#include "ExceptionCode.h"
#include "JSClipboard.h"
#include "JSDOMBinding.h"
#include "JSDOMWindow.h"
#include "JSEventTarget.h"
#include "JSNode.h"
#include "MouseEvent.h"
#include "Node.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSMouseEventTableValues[] =
{
    { "screenX", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMouseEventScreenX), (intptr_t)0, NoIntrinsic },
    { "screenY", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMouseEventScreenY), (intptr_t)0, NoIntrinsic },
    { "clientX", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMouseEventClientX), (intptr_t)0, NoIntrinsic },
    { "clientY", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMouseEventClientY), (intptr_t)0, NoIntrinsic },
#if ENABLE(POINTER_LOCK)
    { "webkitMovementX", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMouseEventWebkitMovementX), (intptr_t)0, NoIntrinsic },
#endif
#if ENABLE(POINTER_LOCK)
    { "webkitMovementY", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMouseEventWebkitMovementY), (intptr_t)0, NoIntrinsic },
#endif
    { "ctrlKey", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMouseEventCtrlKey), (intptr_t)0, NoIntrinsic },
    { "shiftKey", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMouseEventShiftKey), (intptr_t)0, NoIntrinsic },
    { "altKey", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMouseEventAltKey), (intptr_t)0, NoIntrinsic },
    { "metaKey", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMouseEventMetaKey), (intptr_t)0, NoIntrinsic },
    { "button", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMouseEventButton), (intptr_t)0, NoIntrinsic },
    { "relatedTarget", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMouseEventRelatedTarget), (intptr_t)0, NoIntrinsic },
    { "offsetX", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMouseEventOffsetX), (intptr_t)0, NoIntrinsic },
    { "offsetY", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMouseEventOffsetY), (intptr_t)0, NoIntrinsic },
    { "x", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMouseEventX), (intptr_t)0, NoIntrinsic },
    { "y", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMouseEventY), (intptr_t)0, NoIntrinsic },
    { "fromElement", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMouseEventFromElement), (intptr_t)0, NoIntrinsic },
    { "toElement", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMouseEventToElement), (intptr_t)0, NoIntrinsic },
    { "dataTransfer", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMouseEventDataTransfer), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMouseEventConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSMouseEventTable = { 65, 63, JSMouseEventTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSMouseEventConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSMouseEventConstructorTable = { 1, 0, JSMouseEventConstructorTableValues, 0 };
const ClassInfo JSMouseEventConstructor::s_info = { "MouseEventConstructor", &Base::s_info, &JSMouseEventConstructorTable, 0, CREATE_METHOD_TABLE(JSMouseEventConstructor) };

JSMouseEventConstructor::JSMouseEventConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSMouseEventConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSMouseEventPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSMouseEventConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSMouseEventConstructor, JSDOMWrapper>(exec, &JSMouseEventConstructorTable, jsCast<JSMouseEventConstructor*>(cell), propertyName, slot);
}

bool JSMouseEventConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSMouseEventConstructor, JSDOMWrapper>(exec, &JSMouseEventConstructorTable, jsCast<JSMouseEventConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSMouseEventPrototypeTableValues[] =
{
    { "initMouseEvent", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsMouseEventPrototypeFunctionInitMouseEvent), (intptr_t)15, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSMouseEventPrototypeTable = { 2, 1, JSMouseEventPrototypeTableValues, 0 };
const ClassInfo JSMouseEventPrototype::s_info = { "MouseEventPrototype", &Base::s_info, &JSMouseEventPrototypeTable, 0, CREATE_METHOD_TABLE(JSMouseEventPrototype) };

JSObject* JSMouseEventPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSMouseEvent>(exec, globalObject);
}

bool JSMouseEventPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSMouseEventPrototype* thisObject = jsCast<JSMouseEventPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, &JSMouseEventPrototypeTable, thisObject, propertyName, slot);
}

bool JSMouseEventPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSMouseEventPrototype* thisObject = jsCast<JSMouseEventPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, &JSMouseEventPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSMouseEvent::s_info = { "MouseEvent", &Base::s_info, &JSMouseEventTable, 0 , CREATE_METHOD_TABLE(JSMouseEvent) };

JSMouseEvent::JSMouseEvent(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<MouseEvent> impl)
    : JSUIEvent(structure, globalObject, impl)
{
}

void JSMouseEvent::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSMouseEvent::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSMouseEventPrototype::create(exec->globalData(), globalObject, JSMouseEventPrototype::createStructure(exec->globalData(), globalObject, JSUIEventPrototype::self(exec, globalObject)));
}

bool JSMouseEvent::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSMouseEvent* thisObject = jsCast<JSMouseEvent*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSMouseEvent, Base>(exec, &JSMouseEventTable, thisObject, propertyName, slot);
}

bool JSMouseEvent::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSMouseEvent* thisObject = jsCast<JSMouseEvent*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSMouseEvent, Base>(exec, &JSMouseEventTable, thisObject, propertyName, descriptor);
}

JSValue jsMouseEventScreenX(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSMouseEvent* castedThis = jsCast<JSMouseEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    MouseEvent* impl = static_cast<MouseEvent*>(castedThis->impl());
    JSValue result = jsNumber(impl->screenX());
    return result;
}


JSValue jsMouseEventScreenY(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSMouseEvent* castedThis = jsCast<JSMouseEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    MouseEvent* impl = static_cast<MouseEvent*>(castedThis->impl());
    JSValue result = jsNumber(impl->screenY());
    return result;
}


JSValue jsMouseEventClientX(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSMouseEvent* castedThis = jsCast<JSMouseEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    MouseEvent* impl = static_cast<MouseEvent*>(castedThis->impl());
    JSValue result = jsNumber(impl->clientX());
    return result;
}


JSValue jsMouseEventClientY(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSMouseEvent* castedThis = jsCast<JSMouseEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    MouseEvent* impl = static_cast<MouseEvent*>(castedThis->impl());
    JSValue result = jsNumber(impl->clientY());
    return result;
}


#if ENABLE(POINTER_LOCK)
JSValue jsMouseEventWebkitMovementX(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSMouseEvent* castedThis = jsCast<JSMouseEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    MouseEvent* impl = static_cast<MouseEvent*>(castedThis->impl());
    JSValue result = jsNumber(impl->webkitMovementX());
    return result;
}

#endif

#if ENABLE(POINTER_LOCK)
JSValue jsMouseEventWebkitMovementY(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSMouseEvent* castedThis = jsCast<JSMouseEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    MouseEvent* impl = static_cast<MouseEvent*>(castedThis->impl());
    JSValue result = jsNumber(impl->webkitMovementY());
    return result;
}

#endif

JSValue jsMouseEventCtrlKey(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSMouseEvent* castedThis = jsCast<JSMouseEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    MouseEvent* impl = static_cast<MouseEvent*>(castedThis->impl());
    JSValue result = jsBoolean(impl->ctrlKey());
    return result;
}


JSValue jsMouseEventShiftKey(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSMouseEvent* castedThis = jsCast<JSMouseEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    MouseEvent* impl = static_cast<MouseEvent*>(castedThis->impl());
    JSValue result = jsBoolean(impl->shiftKey());
    return result;
}


JSValue jsMouseEventAltKey(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSMouseEvent* castedThis = jsCast<JSMouseEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    MouseEvent* impl = static_cast<MouseEvent*>(castedThis->impl());
    JSValue result = jsBoolean(impl->altKey());
    return result;
}


JSValue jsMouseEventMetaKey(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSMouseEvent* castedThis = jsCast<JSMouseEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    MouseEvent* impl = static_cast<MouseEvent*>(castedThis->impl());
    JSValue result = jsBoolean(impl->metaKey());
    return result;
}


JSValue jsMouseEventButton(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSMouseEvent* castedThis = jsCast<JSMouseEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    MouseEvent* impl = static_cast<MouseEvent*>(castedThis->impl());
    JSValue result = jsNumber(impl->button());
    return result;
}


JSValue jsMouseEventRelatedTarget(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSMouseEvent* castedThis = jsCast<JSMouseEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    MouseEvent* impl = static_cast<MouseEvent*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->relatedTarget()));
    return result;
}


JSValue jsMouseEventOffsetX(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSMouseEvent* castedThis = jsCast<JSMouseEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    MouseEvent* impl = static_cast<MouseEvent*>(castedThis->impl());
    JSValue result = jsNumber(impl->offsetX());
    return result;
}


JSValue jsMouseEventOffsetY(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSMouseEvent* castedThis = jsCast<JSMouseEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    MouseEvent* impl = static_cast<MouseEvent*>(castedThis->impl());
    JSValue result = jsNumber(impl->offsetY());
    return result;
}


JSValue jsMouseEventX(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSMouseEvent* castedThis = jsCast<JSMouseEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    MouseEvent* impl = static_cast<MouseEvent*>(castedThis->impl());
    JSValue result = jsNumber(impl->x());
    return result;
}


JSValue jsMouseEventY(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSMouseEvent* castedThis = jsCast<JSMouseEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    MouseEvent* impl = static_cast<MouseEvent*>(castedThis->impl());
    JSValue result = jsNumber(impl->y());
    return result;
}


JSValue jsMouseEventFromElement(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSMouseEvent* castedThis = jsCast<JSMouseEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    MouseEvent* impl = static_cast<MouseEvent*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->fromElement()));
    return result;
}


JSValue jsMouseEventToElement(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSMouseEvent* castedThis = jsCast<JSMouseEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    MouseEvent* impl = static_cast<MouseEvent*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->toElement()));
    return result;
}


JSValue jsMouseEventDataTransfer(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSMouseEvent* castedThis = jsCast<JSMouseEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    MouseEvent* impl = static_cast<MouseEvent*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->dataTransfer()));
    return result;
}


JSValue jsMouseEventConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSMouseEvent* domObject = jsCast<JSMouseEvent*>(asObject(slotBase));
    return JSMouseEvent::getConstructor(exec, domObject->globalObject());
}

JSValue JSMouseEvent::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSMouseEventConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsMouseEventPrototypeFunctionInitMouseEvent(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSMouseEvent::s_info))
        return throwVMTypeError(exec);
    JSMouseEvent* castedThis = jsCast<JSMouseEvent*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSMouseEvent::s_info);
    MouseEvent* impl = static_cast<MouseEvent*>(castedThis->impl());
    const String& type(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    bool canBubble(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    bool cancelable(MAYBE_MISSING_PARAMETER(exec, 2, DefaultIsUndefined).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    DOMWindow* view(toDOMWindow(MAYBE_MISSING_PARAMETER(exec, 3, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int detail(MAYBE_MISSING_PARAMETER(exec, 4, DefaultIsUndefined).toInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int screenX(MAYBE_MISSING_PARAMETER(exec, 5, DefaultIsUndefined).toInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int screenY(MAYBE_MISSING_PARAMETER(exec, 6, DefaultIsUndefined).toInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int clientX(MAYBE_MISSING_PARAMETER(exec, 7, DefaultIsUndefined).toInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int clientY(MAYBE_MISSING_PARAMETER(exec, 8, DefaultIsUndefined).toInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    bool ctrlKey(MAYBE_MISSING_PARAMETER(exec, 9, DefaultIsUndefined).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    bool altKey(MAYBE_MISSING_PARAMETER(exec, 10, DefaultIsUndefined).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    bool shiftKey(MAYBE_MISSING_PARAMETER(exec, 11, DefaultIsUndefined).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    bool metaKey(MAYBE_MISSING_PARAMETER(exec, 12, DefaultIsUndefined).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    unsigned short button(MAYBE_MISSING_PARAMETER(exec, 13, DefaultIsUndefined).toUInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    EventTarget* relatedTarget(toEventTarget(MAYBE_MISSING_PARAMETER(exec, 14, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->initMouseEvent(type, canBubble, cancelable, view, detail, screenX, screenY, clientX, clientY, ctrlKey, altKey, shiftKey, metaKey, button, relatedTarget);
    return JSValue::encode(jsUndefined());
}


}
