/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(TOUCH_EVENTS)

#include "JSTouchList.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSTouch.h"
#include "Touch.h"
#include "TouchList.h"
#include <runtime/Error.h>
#include <runtime/PropertyNameArray.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSTouchListTableValues[] =
{
    { "length", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTouchListLength), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTouchListConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSTouchListTable = { 5, 3, JSTouchListTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSTouchListConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSTouchListConstructorTable = { 1, 0, JSTouchListConstructorTableValues, 0 };
const ClassInfo JSTouchListConstructor::s_info = { "TouchListConstructor", &Base::s_info, &JSTouchListConstructorTable, 0, CREATE_METHOD_TABLE(JSTouchListConstructor) };

JSTouchListConstructor::JSTouchListConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSTouchListConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSTouchListPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSTouchListConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSTouchListConstructor, JSDOMWrapper>(exec, &JSTouchListConstructorTable, jsCast<JSTouchListConstructor*>(cell), propertyName, slot);
}

bool JSTouchListConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSTouchListConstructor, JSDOMWrapper>(exec, &JSTouchListConstructorTable, jsCast<JSTouchListConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSTouchListPrototypeTableValues[] =
{
    { "item", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsTouchListPrototypeFunctionItem), (intptr_t)1, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSTouchListPrototypeTable = { 2, 1, JSTouchListPrototypeTableValues, 0 };
const ClassInfo JSTouchListPrototype::s_info = { "TouchListPrototype", &Base::s_info, &JSTouchListPrototypeTable, 0, CREATE_METHOD_TABLE(JSTouchListPrototype) };

JSObject* JSTouchListPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSTouchList>(exec, globalObject);
}

bool JSTouchListPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSTouchListPrototype* thisObject = jsCast<JSTouchListPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, &JSTouchListPrototypeTable, thisObject, propertyName, slot);
}

bool JSTouchListPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSTouchListPrototype* thisObject = jsCast<JSTouchListPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, &JSTouchListPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSTouchList::s_info = { "TouchList", &Base::s_info, &JSTouchListTable, 0 , CREATE_METHOD_TABLE(JSTouchList) };

JSTouchList::JSTouchList(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<TouchList> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSTouchList::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSTouchList::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSTouchListPrototype::create(exec->globalData(), globalObject, JSTouchListPrototype::createStructure(globalObject->globalData(), globalObject, globalObject->objectPrototype()));
}

void JSTouchList::destroy(JSC::JSCell* cell)
{
    JSTouchList* thisObject = static_cast<JSTouchList*>(cell);
    thisObject->JSTouchList::~JSTouchList();
}

JSTouchList::~JSTouchList()
{
    releaseImplIfNotNull();
}

bool JSTouchList::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSTouchList* thisObject = jsCast<JSTouchList*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    const HashEntry* entry = getStaticValueSlotEntryWithoutCaching<JSTouchList>(exec, propertyName);
    if (entry) {
        slot.setCustom(thisObject, entry->propertyGetter());
        return true;
    }
    unsigned index = propertyName.asIndex();
    if (index != PropertyName::NotAnIndex && index < static_cast<TouchList*>(thisObject->impl())->length()) {
        slot.setCustomIndex(thisObject, index, indexGetter);
        return true;
    }
    return getStaticValueSlot<JSTouchList, Base>(exec, &JSTouchListTable, thisObject, propertyName, slot);
}

bool JSTouchList::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSTouchList* thisObject = jsCast<JSTouchList*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    const HashEntry* entry = JSTouchListTable.entry(exec, propertyName);
    if (entry) {
        PropertySlot slot;
        slot.setCustom(thisObject, entry->propertyGetter());
        descriptor.setDescriptor(slot.getValue(exec, propertyName), entry->attributes());
        return true;
    }
    unsigned index = propertyName.asIndex();
    if (index != PropertyName::NotAnIndex && index < static_cast<TouchList*>(thisObject->impl())->length()) {
        PropertySlot slot;
        slot.setCustomIndex(thisObject, index, indexGetter);
        descriptor.setDescriptor(slot.getValue(exec, propertyName), DontDelete | ReadOnly);
        return true;
    }
    return getStaticValueDescriptor<JSTouchList, Base>(exec, &JSTouchListTable, thisObject, propertyName, descriptor);
}

bool JSTouchList::getOwnPropertySlotByIndex(JSCell* cell, ExecState* exec, unsigned index, PropertySlot& slot)
{
    JSTouchList* thisObject = jsCast<JSTouchList*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    if (index < static_cast<TouchList*>(thisObject->impl())->length()) {
        slot.setCustomIndex(thisObject, index, thisObject->indexGetter);
        return true;
    }
    return Base::getOwnPropertySlotByIndex(thisObject, exec, index, slot);
}

JSValue jsTouchListLength(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSTouchList* castedThis = jsCast<JSTouchList*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    TouchList* impl = static_cast<TouchList*>(castedThis->impl());
    JSValue result = jsNumber(impl->length());
    return result;
}


JSValue jsTouchListConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSTouchList* domObject = jsCast<JSTouchList*>(asObject(slotBase));
    return JSTouchList::getConstructor(exec, domObject->globalObject());
}

void JSTouchList::getOwnPropertyNames(JSObject* object, ExecState* exec, PropertyNameArray& propertyNames, EnumerationMode mode)
{
    JSTouchList* thisObject = jsCast<JSTouchList*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    for (unsigned i = 0; i < static_cast<TouchList*>(thisObject->impl())->length(); ++i)
        propertyNames.add(Identifier::from(exec, i));
     Base::getOwnPropertyNames(thisObject, exec, propertyNames, mode);
}

JSValue JSTouchList::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSTouchListConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsTouchListPrototypeFunctionItem(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSTouchList::s_info))
        return throwVMTypeError(exec);
    JSTouchList* castedThis = jsCast<JSTouchList*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSTouchList::s_info);
    TouchList* impl = static_cast<TouchList*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    unsigned index(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toUInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->item(index)));
    return JSValue::encode(result);
}


JSValue JSTouchList::indexGetter(ExecState* exec, JSValue slotBase, unsigned index)
{
    JSTouchList* thisObj = jsCast<JSTouchList*>(asObject(slotBase));
    ASSERT_GC_OBJECT_INHERITS(thisObj, &s_info);
    return toJS(exec, thisObj->globalObject(), static_cast<TouchList*>(thisObj->impl())->item(index));
}

static inline bool isObservable(JSTouchList* jsTouchList)
{
    if (jsTouchList->hasCustomProperties())
        return true;
    return false;
}

bool JSTouchListOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSTouchList* jsTouchList = jsCast<JSTouchList*>(handle.get().asCell());
    if (!isObservable(jsTouchList))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSTouchListOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSTouchList* jsTouchList = jsCast<JSTouchList*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsTouchList->impl(), jsTouchList);
    jsTouchList->releaseImpl();
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, TouchList* impl)
{
    return wrap<JSTouchList>(exec, globalObject, impl);
}

TouchList* toTouchList(JSC::JSValue value)
{
    return value.inherits(&JSTouchList::s_info) ? jsCast<JSTouchList*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(TOUCH_EVENTS)
