// File is generated by Source/WebCore/inspector/CodeGeneratorInspector.py

// Copyright (c) 2011 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef InspectorTypeBuilder_h
#define InspectorTypeBuilder_h

#if ENABLE(INSPECTOR)

#include "InspectorValues.h"
#include <wtf/Assertions.h>
#include <wtf/PassRefPtr.h>

namespace WebCore {

namespace TypeBuilder {

template<typename T>
class OptOutput {
public:
    OptOutput() : m_assigned(false) { }

    void operator=(T value)
    {
        m_value = value;
        m_assigned = true;
    }

    bool isAssigned() { return m_assigned; }

    T getValue()
    {
        ASSERT(isAssigned());
        return m_value;
    }

private:
    T m_value;
    bool m_assigned;

    WTF_MAKE_NONCOPYABLE(OptOutput);
};


// A small transient wrapper around int type, that can be used as a funciton parameter type
// cleverly disallowing C++ implicit casts from float or double.
class ExactlyInt {
public:
    template<typename T>
    ExactlyInt(T t) : m_value(cast_to_int<T>(t)) {}

    ExactlyInt() {}

    operator int() { return m_value; }
private:
    int m_value;

    template<typename T>
    static int cast_to_int(T) { return T::default_case_cast_is_not_supported(); }
};

template<>
inline int ExactlyInt::cast_to_int<int>(int i) { return i; }

template<>
inline int ExactlyInt::cast_to_int<unsigned int>(unsigned int i) { return i; }

class RuntimeCastHelper {
public:
#if !ASSERT_DISABLED
    template<InspectorValue::Type TYPE>
    static void assertType(InspectorValue* value)
    {
        ASSERT(value->type() == TYPE);
    }
    static void assertAny(InspectorValue*);
    static void assertInt(InspectorValue* value);
#endif
};


// This class provides "Traits" type for the input type T. It is programmed using C++ template specialization
// technique. By default it simply takes "ItemTraits" type from T, but it doesn't work with the base types.
template<typename T>
struct ArrayItemHelper {
    typedef typename T::ItemTraits Traits;
};

template<typename T>
class Array : public InspectorArrayBase {
private:
    Array() { }

    InspectorArray* openAccessors() {
        COMPILE_ASSERT(sizeof(InspectorArray) == sizeof(Array<T>), cannot_cast);
        return static_cast<InspectorArray*>(static_cast<InspectorArrayBase*>(this));
    }

public:
    void addItem(PassRefPtr<T> value)
    {
        ArrayItemHelper<T>::Traits::pushRefPtr(this->openAccessors(), value);
    }

    void addItem(T value)
    {
        ArrayItemHelper<T>::Traits::pushRaw(this->openAccessors(), value);
    }

    static PassRefPtr<Array<T> > create()
    {
        return adoptRef(new Array<T>());
    }

    static PassRefPtr<Array<T> > runtimeCast(PassRefPtr<InspectorValue> value)
    {
        RefPtr<InspectorArray> array;
        bool castRes = value->asArray(&array);
        ASSERT_UNUSED(castRes, castRes);
#if !ASSERT_DISABLED
        assertCorrectValue(array.get());
#endif  // !ASSERT_DISABLED
        COMPILE_ASSERT(sizeof(Array<T>) == sizeof(InspectorArray), type_cast_problem);
        return static_cast<Array<T>*>(static_cast<InspectorArrayBase*>(array.get()));
    }

#if !ASSERT_DISABLED
    static void assertCorrectValue(InspectorValue* value)
    {
        RefPtr<InspectorArray> array;
        bool castRes = value->asArray(&array);
        ASSERT_UNUSED(castRes, castRes);
        for (unsigned i = 0; i < array->length(); i++)
            ArrayItemHelper<T>::Traits::template assertCorrectValue<T>(array->get(i).get());
    }

#endif // !ASSERT_DISABLED
};

struct StructItemTraits {
    static void pushRefPtr(InspectorArray* array, PassRefPtr<InspectorValue> value)
    {
        array->pushValue(value);
    }

#if !ASSERT_DISABLED
    template<typename T>
    static void assertCorrectValue(InspectorValue* value) {
        T::assertCorrectValue(value);
    }
#endif  // !ASSERT_DISABLED
};

template<>
struct ArrayItemHelper<String> {
    struct Traits {
        static void pushRaw(InspectorArray* array, const String& value)
        {
            array->pushString(value);
        }

#if !ASSERT_DISABLED
        template<typename T>
        static void assertCorrectValue(InspectorValue* value) {
            RuntimeCastHelper::assertType<InspectorValue::TypeString>(value);
        }
#endif  // !ASSERT_DISABLED
    };
};

template<>
struct ArrayItemHelper<int> {
    struct Traits {
        static void pushRaw(InspectorArray* array, int value)
        {
            array->pushInt(value);
        }

#if !ASSERT_DISABLED
        template<typename T>
        static void assertCorrectValue(InspectorValue* value) {
            RuntimeCastHelper::assertInt(value);
        }
#endif  // !ASSERT_DISABLED
    };
};

template<>
struct ArrayItemHelper<double> {
    struct Traits {
        static void pushRaw(InspectorArray* array, double value)
        {
            array->pushNumber(value);
        }

#if !ASSERT_DISABLED
        template<typename T>
        static void assertCorrectValue(InspectorValue* value) {
            RuntimeCastHelper::assertType<InspectorValue::TypeNumber>(value);
        }
#endif  // !ASSERT_DISABLED
    };
};

template<>
struct ArrayItemHelper<bool> {
    struct Traits {
        static void pushRaw(InspectorArray* array, bool value)
        {
            array->pushBoolean(value);
        }

#if !ASSERT_DISABLED
        template<typename T>
        static void assertCorrectValue(InspectorValue* value) {
            RuntimeCastHelper::assertType<InspectorValue::TypeBoolean>(value);
        }
#endif  // !ASSERT_DISABLED
    };
};

template<>
struct ArrayItemHelper<InspectorValue> {
    struct Traits {
        static void pushRefPtr(InspectorArray* array, PassRefPtr<InspectorValue> value)
        {
            array->pushValue(value);
        }

#if !ASSERT_DISABLED
        template<typename T>
        static void assertCorrectValue(InspectorValue* value) {
            RuntimeCastHelper::assertAny(value);
        }
#endif  // !ASSERT_DISABLED
    };
};

template<>
struct ArrayItemHelper<InspectorObject> {
    struct Traits {
        static void pushRefPtr(InspectorArray* array, PassRefPtr<InspectorValue> value)
        {
            array->pushValue(value);
        }

#if !ASSERT_DISABLED
        template<typename T>
        static void assertCorrectValue(InspectorValue* value) {
            RuntimeCastHelper::assertType<InspectorValue::TypeObject>(value);
        }
#endif  // !ASSERT_DISABLED
    };
};

template<>
struct ArrayItemHelper<InspectorArray> {
    struct Traits {
        static void pushRefPtr(InspectorArray* array, PassRefPtr<InspectorArray> value)
        {
            array->pushArray(value);
        }

#if !ASSERT_DISABLED
        template<typename T>
        static void assertCorrectValue(InspectorValue* value) {
            RuntimeCastHelper::assertType<InspectorValue::TypeArray>(value);
        }
#endif  // !ASSERT_DISABLED
    };
};

template<typename T>
struct ArrayItemHelper<TypeBuilder::Array<T> > {
    struct Traits {
        static void pushRefPtr(InspectorArray* array, PassRefPtr<TypeBuilder::Array<T> > value)
        {
            array->pushValue(value);
        }

#if !ASSERT_DISABLED
        template<typename S>
        static void assertCorrectValue(InspectorValue* value) {
            S::assertCorrectValue(value);
        }
#endif  // !ASSERT_DISABLED
    };
};

// Forward declarations.
namespace Runtime {
class ObjectPreview;
class PropertyPreview;
} // Runtime

namespace Console {
class CallFrame;
} // Console

#if ENABLE(INDEXED_DATABASE)
namespace IndexedDB {
class ObjectStore;
class ObjectStoreIndex;
class KeyPath;
} // IndexedDB

#endif // ENABLE(INDEXED_DATABASE)
namespace CSS {
class RuleMatch;
class CSSRule;
class SourceRange;
class CSSStyle;
class CSSProperty;
class CSSMedia;
} // CSS

#if ENABLE(JAVASCRIPT_DEBUGGER)
namespace Debugger {
class Location;
class Scope;
} // Debugger

#endif // ENABLE(JAVASCRIPT_DEBUGGER)
// End of forward declarations.

// Typedefs.
namespace Page {
/* Unique script identifier. */
typedef String ScriptIdentifier;

} // Page

namespace Runtime {
/* Unique object identifier. */
typedef String RemoteObjectId;

} // Runtime

namespace Network {
/* Unique loader identifier. */
typedef String LoaderId;

/* Unique frame identifier. */
typedef String FrameId;

/* Unique request identifier. */
typedef String RequestId;

} // Network

#if ENABLE(SQL_DATABASE)
namespace Database {
/* Unique identifier of Database object. */
typedef String DatabaseId;

} // Database

#endif // ENABLE(SQL_DATABASE)
namespace CSS {
typedef String StyleSheetId;

} // CSS

#if ENABLE(JAVASCRIPT_DEBUGGER)
namespace Debugger {
/* Breakpoint identifier. */
typedef String BreakpointId;

/* Unique script identifier. */
typedef String ScriptId;

/* Call frame identifier. */
typedef String CallFrameId;

} // Debugger

#endif // ENABLE(JAVASCRIPT_DEBUGGER)
#if ENABLE(JAVASCRIPT_DEBUGGER)
namespace Profiler {
/* Heap snashot object id. */
typedef String HeapSnapshotObjectId;

} // Profiler

#endif // ENABLE(JAVASCRIPT_DEBUGGER)
namespace HeapProfiler {
/* Heap snashot object id. */
typedef String HeapSnapshotObjectId;

} // HeapProfiler

namespace Canvas {
/* Unique resource identifier. */
typedef String ResourceId;

/* Unique trace log identifier. */
typedef String TraceLogId;

} // Canvas

namespace LayerTree {
/* Unique RenderLayer identifier. */
typedef String LayerId;

/* Unique PseudoElement identifier. */
typedef String PseudoElementId;

} // LayerTree

// End of typedefs.



String getEnumConstantValue(int code);

namespace Memory {
class MemoryBlock : public InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        NameSet = 1 << 0,
        AllFieldsSet = (NameSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*MemoryBlock*/InspectorObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class MemoryBlock;
    public:

        Builder<STATE | NameSet>& setName(const String& value)
        {
            COMPILE_ASSERT(!(STATE & NameSet), property_name_already_set);
            m_result->setString("name", value);
            return castState<NameSet>();
        }

        operator RefPtr<MemoryBlock>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(MemoryBlock) == sizeof(InspectorObject), cannot_cast);
            return *reinterpret_cast<RefPtr<MemoryBlock>*>(&m_result);
        }

        PassRefPtr<MemoryBlock> release()
        {
            return RefPtr<MemoryBlock>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<MemoryBlock> result = MemoryBlock::create()
     *     .setName(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;

    void setSize(double value)
    {
        this->setNumber("size", value);
    }

    void setChildren(PassRefPtr<TypeBuilder::Array<TypeBuilder::Memory::MemoryBlock> > value)
    {
        this->setValue("children", value);
    }
};

} // Memory

namespace Page {
/* Resource type as it was perceived by the rendering engine. */
struct ResourceType {
    enum Enum {
        Document = 0,
        Stylesheet = 1,
        Image = 2,
        Font = 3,
        Script = 4,
        XHR = 5,
        WebSocket = 6,
        Other = 7,
    };
}; // struct ResourceType

/* Information about the Frame on the page. */
class Frame : public InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        IdSet = 1 << 0,
        LoaderIdSet = 1 << 1,
        UrlSet = 1 << 2,
        SecurityOriginSet = 1 << 3,
        MimeTypeSet = 1 << 4,
        AllFieldsSet = (IdSet | LoaderIdSet | UrlSet | SecurityOriginSet | MimeTypeSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*Frame*/InspectorObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class Frame;
    public:

        Builder<STATE | IdSet>& setId(const String& value)
        {
            COMPILE_ASSERT(!(STATE & IdSet), property_id_already_set);
            m_result->setString("id", value);
            return castState<IdSet>();
        }

        Builder<STATE | LoaderIdSet>& setLoaderId(const TypeBuilder::Network::LoaderId& value)
        {
            COMPILE_ASSERT(!(STATE & LoaderIdSet), property_loaderId_already_set);
            m_result->setString("loaderId", value);
            return castState<LoaderIdSet>();
        }

        Builder<STATE | UrlSet>& setUrl(const String& value)
        {
            COMPILE_ASSERT(!(STATE & UrlSet), property_url_already_set);
            m_result->setString("url", value);
            return castState<UrlSet>();
        }

        Builder<STATE | SecurityOriginSet>& setSecurityOrigin(const String& value)
        {
            COMPILE_ASSERT(!(STATE & SecurityOriginSet), property_securityOrigin_already_set);
            m_result->setString("securityOrigin", value);
            return castState<SecurityOriginSet>();
        }

        Builder<STATE | MimeTypeSet>& setMimeType(const String& value)
        {
            COMPILE_ASSERT(!(STATE & MimeTypeSet), property_mimeType_already_set);
            m_result->setString("mimeType", value);
            return castState<MimeTypeSet>();
        }

        operator RefPtr<Frame>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(Frame) == sizeof(InspectorObject), cannot_cast);
            return *reinterpret_cast<RefPtr<Frame>*>(&m_result);
        }

        PassRefPtr<Frame> release()
        {
            return RefPtr<Frame>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<Frame> result = Frame::create()
     *     .setId(...)
     *     .setLoaderId(...)
     *     .setUrl(...)
     *     .setSecurityOrigin(...)
     *     .setMimeType(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;

    void setParentId(const String& value)
    {
        this->setString("parentId", value);
    }

    void setName(const String& value)
    {
        this->setString("name", value);
    }
};

/* Information about the Frame hierarchy along with their cached resources. */
class FrameResourceTree : public InspectorObjectBase {
public:
    // Named after property name 'resources' while generating FrameResourceTree.
    class Resources : public InspectorObjectBase {
    public:
        enum {
            NoFieldsSet = 0,
            UrlSet = 1 << 0,
            TypeSet = 1 << 1,
            MimeTypeSet = 1 << 2,
            AllFieldsSet = (UrlSet | TypeSet | MimeTypeSet)
        };

        template<int STATE>
        class Builder {
        private:
            RefPtr<InspectorObject> m_result;

            template<int STEP> Builder<STATE | STEP>& castState()
            {
                return *reinterpret_cast<Builder<STATE | STEP>*>(this);
            }

            Builder(PassRefPtr</*Resources*/InspectorObject> ptr)
            {
                COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
                m_result = ptr;
            }
            friend class Resources;
        public:
    
            Builder<STATE | UrlSet>& setUrl(const String& value)
            {
                COMPILE_ASSERT(!(STATE & UrlSet), property_url_already_set);
                m_result->setString("url", value);
                return castState<UrlSet>();
            }
    
            Builder<STATE | TypeSet>& setType(TypeBuilder::Page::ResourceType::Enum value)
            {
                COMPILE_ASSERT(!(STATE & TypeSet), property_type_already_set);
                m_result->setString("type", TypeBuilder::getEnumConstantValue(value));
                return castState<TypeSet>();
            }
    
            Builder<STATE | MimeTypeSet>& setMimeType(const String& value)
            {
                COMPILE_ASSERT(!(STATE & MimeTypeSet), property_mimeType_already_set);
                m_result->setString("mimeType", value);
                return castState<MimeTypeSet>();
            }
    
            operator RefPtr<Resources>& ()
            {
                COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
                COMPILE_ASSERT(sizeof(Resources) == sizeof(InspectorObject), cannot_cast);
                return *reinterpret_cast<RefPtr<Resources>*>(&m_result);
            }

            PassRefPtr<Resources> release()
            {
                return RefPtr<Resources>(*this).release();
            }
        };

        /*
         * Synthetic constructor:
         * RefPtr<Resources> result = Resources::create()
         *     .setUrl(...)
         *     .setType(...)
         *     .setMimeType(...);
         */
        static Builder<NoFieldsSet> create()
        {
            return Builder<NoFieldsSet>(InspectorObject::create());
        }
        typedef TypeBuilder::StructItemTraits ItemTraits;

        void setFailed(bool value)
        {
            this->setBoolean("failed", value);
        }

        void setCanceled(bool value)
        {
            this->setBoolean("canceled", value);
        }

        void setSourceMapURL(const String& value)
        {
            this->setString("sourceMapURL", value);
        }
    };

    enum {
        NoFieldsSet = 0,
        FrameSet = 1 << 0,
        ResourcesSet = 1 << 1,
        AllFieldsSet = (FrameSet | ResourcesSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*FrameResourceTree*/InspectorObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class FrameResourceTree;
    public:

        Builder<STATE | FrameSet>& setFrame(PassRefPtr<TypeBuilder::Page::Frame> value)
        {
            COMPILE_ASSERT(!(STATE & FrameSet), property_frame_already_set);
            m_result->setValue("frame", value);
            return castState<FrameSet>();
        }

        Builder<STATE | ResourcesSet>& setResources(PassRefPtr<TypeBuilder::Array<Resources> > value)
        {
            COMPILE_ASSERT(!(STATE & ResourcesSet), property_resources_already_set);
            m_result->setValue("resources", value);
            return castState<ResourcesSet>();
        }

        operator RefPtr<FrameResourceTree>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(FrameResourceTree) == sizeof(InspectorObject), cannot_cast);
            return *reinterpret_cast<RefPtr<FrameResourceTree>*>(&m_result);
        }

        PassRefPtr<FrameResourceTree> release()
        {
            return RefPtr<FrameResourceTree>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<FrameResourceTree> result = FrameResourceTree::create()
     *     .setFrame(...)
     *     .setResources(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;

    void setChildFrames(PassRefPtr<TypeBuilder::Array<TypeBuilder::Page::FrameResourceTree> > value)
    {
        this->setValue("childFrames", value);
    }
};

/* Search match for resource. */
class SearchMatch : public InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        LineNumberSet = 1 << 0,
        LineContentSet = 1 << 1,
        AllFieldsSet = (LineNumberSet | LineContentSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*SearchMatch*/InspectorObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class SearchMatch;
    public:

        Builder<STATE | LineNumberSet>& setLineNumber(double value)
        {
            COMPILE_ASSERT(!(STATE & LineNumberSet), property_lineNumber_already_set);
            m_result->setNumber("lineNumber", value);
            return castState<LineNumberSet>();
        }

        Builder<STATE | LineContentSet>& setLineContent(const String& value)
        {
            COMPILE_ASSERT(!(STATE & LineContentSet), property_lineContent_already_set);
            m_result->setString("lineContent", value);
            return castState<LineContentSet>();
        }

        operator RefPtr<SearchMatch>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(SearchMatch) == sizeof(InspectorObject), cannot_cast);
            return *reinterpret_cast<RefPtr<SearchMatch>*>(&m_result);
        }

        PassRefPtr<SearchMatch> release()
        {
            return RefPtr<SearchMatch>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<SearchMatch> result = SearchMatch::create()
     *     .setLineNumber(...)
     *     .setLineContent(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;
};

/* Search result for resource. */
class SearchResult : public InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        UrlSet = 1 << 0,
        FrameIdSet = 1 << 1,
        MatchesCountSet = 1 << 2,
        AllFieldsSet = (UrlSet | FrameIdSet | MatchesCountSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*SearchResult*/InspectorObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class SearchResult;
    public:

        Builder<STATE | UrlSet>& setUrl(const String& value)
        {
            COMPILE_ASSERT(!(STATE & UrlSet), property_url_already_set);
            m_result->setString("url", value);
            return castState<UrlSet>();
        }

        Builder<STATE | FrameIdSet>& setFrameId(const TypeBuilder::Network::FrameId& value)
        {
            COMPILE_ASSERT(!(STATE & FrameIdSet), property_frameId_already_set);
            m_result->setString("frameId", value);
            return castState<FrameIdSet>();
        }

        Builder<STATE | MatchesCountSet>& setMatchesCount(double value)
        {
            COMPILE_ASSERT(!(STATE & MatchesCountSet), property_matchesCount_already_set);
            m_result->setNumber("matchesCount", value);
            return castState<MatchesCountSet>();
        }

        operator RefPtr<SearchResult>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(SearchResult) == sizeof(InspectorObject), cannot_cast);
            return *reinterpret_cast<RefPtr<SearchResult>*>(&m_result);
        }

        PassRefPtr<SearchResult> release()
        {
            return RefPtr<SearchResult>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<SearchResult> result = SearchResult::create()
     *     .setUrl(...)
     *     .setFrameId(...)
     *     .setMatchesCount(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;
};

/* Cookie object */
class Cookie : public InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        NameSet = 1 << 0,
        ValueSet = 1 << 1,
        DomainSet = 1 << 2,
        PathSet = 1 << 3,
        ExpiresSet = 1 << 4,
        SizeSet = 1 << 5,
        HttpOnlySet = 1 << 6,
        SecureSet = 1 << 7,
        SessionSet = 1 << 8,
        AllFieldsSet = (NameSet | ValueSet | DomainSet | PathSet | ExpiresSet | SizeSet | HttpOnlySet | SecureSet | SessionSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*Cookie*/InspectorObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class Cookie;
    public:

        Builder<STATE | NameSet>& setName(const String& value)
        {
            COMPILE_ASSERT(!(STATE & NameSet), property_name_already_set);
            m_result->setString("name", value);
            return castState<NameSet>();
        }

        Builder<STATE | ValueSet>& setValue(const String& value)
        {
            COMPILE_ASSERT(!(STATE & ValueSet), property_value_already_set);
            m_result->setString("value", value);
            return castState<ValueSet>();
        }

        Builder<STATE | DomainSet>& setDomain(const String& value)
        {
            COMPILE_ASSERT(!(STATE & DomainSet), property_domain_already_set);
            m_result->setString("domain", value);
            return castState<DomainSet>();
        }

        Builder<STATE | PathSet>& setPath(const String& value)
        {
            COMPILE_ASSERT(!(STATE & PathSet), property_path_already_set);
            m_result->setString("path", value);
            return castState<PathSet>();
        }

        Builder<STATE | ExpiresSet>& setExpires(double value)
        {
            COMPILE_ASSERT(!(STATE & ExpiresSet), property_expires_already_set);
            m_result->setNumber("expires", value);
            return castState<ExpiresSet>();
        }

        Builder<STATE | SizeSet>& setSize(int value)
        {
            COMPILE_ASSERT(!(STATE & SizeSet), property_size_already_set);
            m_result->setNumber("size", value);
            return castState<SizeSet>();
        }

        Builder<STATE | HttpOnlySet>& setHttpOnly(bool value)
        {
            COMPILE_ASSERT(!(STATE & HttpOnlySet), property_httpOnly_already_set);
            m_result->setBoolean("httpOnly", value);
            return castState<HttpOnlySet>();
        }

        Builder<STATE | SecureSet>& setSecure(bool value)
        {
            COMPILE_ASSERT(!(STATE & SecureSet), property_secure_already_set);
            m_result->setBoolean("secure", value);
            return castState<SecureSet>();
        }

        Builder<STATE | SessionSet>& setSession(bool value)
        {
            COMPILE_ASSERT(!(STATE & SessionSet), property_session_already_set);
            m_result->setBoolean("session", value);
            return castState<SessionSet>();
        }

        operator RefPtr<Cookie>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(Cookie) == sizeof(InspectorObject), cannot_cast);
            return *reinterpret_cast<RefPtr<Cookie>*>(&m_result);
        }

        PassRefPtr<Cookie> release()
        {
            return RefPtr<Cookie>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<Cookie> result = Cookie::create()
     *     .setName(...)
     *     .setValue(...)
     *     .setDomain(...)
     *     .setPath(...)
     *     .setExpires(...)
     *     .setSize(...)
     *     .setHttpOnly(...)
     *     .setSecure(...)
     *     .setSession(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;
};

} // Page

namespace Runtime {
/* Mirror object referencing original JavaScript object. */
class RemoteObject : public InspectorObjectBase {
public:
    // Named after property name 'type' while generating RemoteObject.
    struct Type {
        enum Enum {
            Object = 8,
            Function = 9,
            Undefined = 10,
            String = 11,
            Number = 12,
            Boolean = 13,
        };
#if !ASSERT_DISABLED
        static void assertCorrectValue(InspectorValue* value);
#endif  // !ASSERT_DISABLED
    }; // struct Type

    // Named after property name 'subtype' while generating RemoteObject.
    struct Subtype {
        enum Enum {
            Array = 14,
            Null = 15,
            Node = 16,
            Regexp = 17,
            Date = 18,
        };
#if !ASSERT_DISABLED
        static void assertCorrectValue(InspectorValue* value);
#endif  // !ASSERT_DISABLED
    }; // struct Subtype

    enum {
        NoFieldsSet = 0,
        TypeSet = 1 << 0,
        AllFieldsSet = (TypeSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*RemoteObject*/InspectorObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class RemoteObject;
    public:

        Builder<STATE | TypeSet>& setType(Type::Enum value)
        {
            COMPILE_ASSERT(!(STATE & TypeSet), property_type_already_set);
            m_result->setString("type", TypeBuilder::getEnumConstantValue(value));
            return castState<TypeSet>();
        }

        operator RefPtr<RemoteObject>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(RemoteObject) == sizeof(InspectorObject), cannot_cast);
            return *reinterpret_cast<RefPtr<RemoteObject>*>(&m_result);
        }

        PassRefPtr<RemoteObject> release()
        {
            return RefPtr<RemoteObject>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<RemoteObject> result = RemoteObject::create()
     *     .setType(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;

    void setSubtype(Subtype::Enum value)
    {
        this->setString("subtype", TypeBuilder::getEnumConstantValue(value));
    }

    void setClassName(const String& value)
    {
        this->setString("className", value);
    }

    void setValue(PassRefPtr<InspectorValue> value)
    {
        this->setValue("value", value);
    }
    using InspectorObjectBase::setValue;


    void setDescription(const String& value)
    {
        this->setString("description", value);
    }

    void setObjectId(const TypeBuilder::Runtime::RemoteObjectId& value)
    {
        this->setString("objectId", value);
    }

    void setPreview(PassRefPtr<TypeBuilder::Runtime::ObjectPreview> value)
    {
        this->setValue("preview", value);
    }
    static PassRefPtr<RemoteObject> runtimeCast(PassRefPtr<InspectorValue> value)
    {
        RefPtr<InspectorObject> object;
        bool castRes = value->asObject(&object);
        ASSERT_UNUSED(castRes, castRes);
#if !ASSERT_DISABLED
        assertCorrectValue(object.get());
#endif  // !ASSERT_DISABLED
        COMPILE_ASSERT(sizeof(RemoteObject) == sizeof(InspectorObjectBase), type_cast_problem);
        return static_cast<RemoteObject*>(static_cast<InspectorObjectBase*>(object.get()));
    }

#if !ASSERT_DISABLED
    static void assertCorrectValue(InspectorValue* value);
#endif  // !ASSERT_DISABLED
};

/* Object containing abbreviated remote object value. */
class ObjectPreview : public InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        LosslessSet = 1 << 0,
        OverflowSet = 1 << 1,
        PropertiesSet = 1 << 2,
        AllFieldsSet = (LosslessSet | OverflowSet | PropertiesSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*ObjectPreview*/InspectorObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class ObjectPreview;
    public:

        Builder<STATE | LosslessSet>& setLossless(bool value)
        {
            COMPILE_ASSERT(!(STATE & LosslessSet), property_lossless_already_set);
            m_result->setBoolean("lossless", value);
            return castState<LosslessSet>();
        }

        Builder<STATE | OverflowSet>& setOverflow(bool value)
        {
            COMPILE_ASSERT(!(STATE & OverflowSet), property_overflow_already_set);
            m_result->setBoolean("overflow", value);
            return castState<OverflowSet>();
        }

        Builder<STATE | PropertiesSet>& setProperties(PassRefPtr<TypeBuilder::Array<TypeBuilder::Runtime::PropertyPreview> > value)
        {
            COMPILE_ASSERT(!(STATE & PropertiesSet), property_properties_already_set);
            m_result->setValue("properties", value);
            return castState<PropertiesSet>();
        }

        operator RefPtr<ObjectPreview>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(ObjectPreview) == sizeof(InspectorObject), cannot_cast);
            return *reinterpret_cast<RefPtr<ObjectPreview>*>(&m_result);
        }

        PassRefPtr<ObjectPreview> release()
        {
            return RefPtr<ObjectPreview>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<ObjectPreview> result = ObjectPreview::create()
     *     .setLossless(...)
     *     .setOverflow(...)
     *     .setProperties(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;
#if !ASSERT_DISABLED
    static void assertCorrectValue(InspectorValue* value);
#endif  // !ASSERT_DISABLED
};

class PropertyPreview : public InspectorObjectBase {
public:
    // Named after property name 'type' while generating PropertyPreview.
    struct Type {
        enum Enum {
            Object = 8,
            Function = 9,
            Undefined = 10,
            String = 11,
            Number = 12,
            Boolean = 13,
        };
#if !ASSERT_DISABLED
        static void assertCorrectValue(InspectorValue* value);
#endif  // !ASSERT_DISABLED
    }; // struct Type

    // Named after property name 'subtype' while generating PropertyPreview.
    struct Subtype {
        enum Enum {
            Array = 14,
            Null = 15,
            Node = 16,
            Regexp = 17,
            Date = 18,
        };
#if !ASSERT_DISABLED
        static void assertCorrectValue(InspectorValue* value);
#endif  // !ASSERT_DISABLED
    }; // struct Subtype

    enum {
        NoFieldsSet = 0,
        NameSet = 1 << 0,
        TypeSet = 1 << 1,
        AllFieldsSet = (NameSet | TypeSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*PropertyPreview*/InspectorObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class PropertyPreview;
    public:

        Builder<STATE | NameSet>& setName(const String& value)
        {
            COMPILE_ASSERT(!(STATE & NameSet), property_name_already_set);
            m_result->setString("name", value);
            return castState<NameSet>();
        }

        Builder<STATE | TypeSet>& setType(Type::Enum value)
        {
            COMPILE_ASSERT(!(STATE & TypeSet), property_type_already_set);
            m_result->setString("type", TypeBuilder::getEnumConstantValue(value));
            return castState<TypeSet>();
        }

        operator RefPtr<PropertyPreview>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(PropertyPreview) == sizeof(InspectorObject), cannot_cast);
            return *reinterpret_cast<RefPtr<PropertyPreview>*>(&m_result);
        }

        PassRefPtr<PropertyPreview> release()
        {
            return RefPtr<PropertyPreview>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<PropertyPreview> result = PropertyPreview::create()
     *     .setName(...)
     *     .setType(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;

    void setValue(const String& value)
    {
        this->setString("value", value);
    }
    using InspectorObjectBase::setValue;


    void setValuePreview(PassRefPtr<TypeBuilder::Runtime::ObjectPreview> value)
    {
        this->setValue("valuePreview", value);
    }

    void setSubtype(Subtype::Enum value)
    {
        this->setString("subtype", TypeBuilder::getEnumConstantValue(value));
    }
#if !ASSERT_DISABLED
    static void assertCorrectValue(InspectorValue* value);
#endif  // !ASSERT_DISABLED
};

/* Object property descriptor. */
class PropertyDescriptor : public InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        NameSet = 1 << 0,
        ConfigurableSet = 1 << 1,
        EnumerableSet = 1 << 2,
        AllFieldsSet = (NameSet | ConfigurableSet | EnumerableSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*PropertyDescriptor*/InspectorObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class PropertyDescriptor;
    public:

        Builder<STATE | NameSet>& setName(const String& value)
        {
            COMPILE_ASSERT(!(STATE & NameSet), property_name_already_set);
            m_result->setString("name", value);
            return castState<NameSet>();
        }

        Builder<STATE | ConfigurableSet>& setConfigurable(bool value)
        {
            COMPILE_ASSERT(!(STATE & ConfigurableSet), property_configurable_already_set);
            m_result->setBoolean("configurable", value);
            return castState<ConfigurableSet>();
        }

        Builder<STATE | EnumerableSet>& setEnumerable(bool value)
        {
            COMPILE_ASSERT(!(STATE & EnumerableSet), property_enumerable_already_set);
            m_result->setBoolean("enumerable", value);
            return castState<EnumerableSet>();
        }

        operator RefPtr<PropertyDescriptor>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(PropertyDescriptor) == sizeof(InspectorObject), cannot_cast);
            return *reinterpret_cast<RefPtr<PropertyDescriptor>*>(&m_result);
        }

        PassRefPtr<PropertyDescriptor> release()
        {
            return RefPtr<PropertyDescriptor>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<PropertyDescriptor> result = PropertyDescriptor::create()
     *     .setName(...)
     *     .setConfigurable(...)
     *     .setEnumerable(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;

    void setValue(PassRefPtr<TypeBuilder::Runtime::RemoteObject> value)
    {
        this->setValue("value", value);
    }
    using InspectorObjectBase::setValue;


    void setWritable(bool value)
    {
        this->setBoolean("writable", value);
    }

    void setGet(PassRefPtr<TypeBuilder::Runtime::RemoteObject> value)
    {
        this->setValue("get", value);
    }

    void setSet(PassRefPtr<TypeBuilder::Runtime::RemoteObject> value)
    {
        this->setValue("set", value);
    }

    void setWasThrown(bool value)
    {
        this->setBoolean("wasThrown", value);
    }

    void setIsOwn(bool value)
    {
        this->setBoolean("isOwn", value);
    }
    static PassRefPtr<PropertyDescriptor> runtimeCast(PassRefPtr<InspectorValue> value)
    {
        RefPtr<InspectorObject> object;
        bool castRes = value->asObject(&object);
        ASSERT_UNUSED(castRes, castRes);
#if !ASSERT_DISABLED
        assertCorrectValue(object.get());
#endif  // !ASSERT_DISABLED
        COMPILE_ASSERT(sizeof(PropertyDescriptor) == sizeof(InspectorObjectBase), type_cast_problem);
        return static_cast<PropertyDescriptor*>(static_cast<InspectorObjectBase*>(object.get()));
    }

#if !ASSERT_DISABLED
    static void assertCorrectValue(InspectorValue* value);
#endif  // !ASSERT_DISABLED
};

/* Object internal property descriptor. This property isn't normally visible in JavaScript code. */
class InternalPropertyDescriptor : public InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        NameSet = 1 << 0,
        AllFieldsSet = (NameSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*InternalPropertyDescriptor*/InspectorObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class InternalPropertyDescriptor;
    public:

        Builder<STATE | NameSet>& setName(const String& value)
        {
            COMPILE_ASSERT(!(STATE & NameSet), property_name_already_set);
            m_result->setString("name", value);
            return castState<NameSet>();
        }

        operator RefPtr<InternalPropertyDescriptor>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(InternalPropertyDescriptor) == sizeof(InspectorObject), cannot_cast);
            return *reinterpret_cast<RefPtr<InternalPropertyDescriptor>*>(&m_result);
        }

        PassRefPtr<InternalPropertyDescriptor> release()
        {
            return RefPtr<InternalPropertyDescriptor>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<InternalPropertyDescriptor> result = InternalPropertyDescriptor::create()
     *     .setName(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;

    void setValue(PassRefPtr<TypeBuilder::Runtime::RemoteObject> value)
    {
        this->setValue("value", value);
    }
    using InspectorObjectBase::setValue;

    static PassRefPtr<InternalPropertyDescriptor> runtimeCast(PassRefPtr<InspectorValue> value)
    {
        RefPtr<InspectorObject> object;
        bool castRes = value->asObject(&object);
        ASSERT_UNUSED(castRes, castRes);
#if !ASSERT_DISABLED
        assertCorrectValue(object.get());
#endif  // !ASSERT_DISABLED
        COMPILE_ASSERT(sizeof(InternalPropertyDescriptor) == sizeof(InspectorObjectBase), type_cast_problem);
        return static_cast<InternalPropertyDescriptor*>(static_cast<InspectorObjectBase*>(object.get()));
    }

#if !ASSERT_DISABLED
    static void assertCorrectValue(InspectorValue* value);
#endif  // !ASSERT_DISABLED
};

/* Represents function call argument. Either remote object id <code>objectId</code> or primitive <code>value</code> or neither of (for undefined) them should be specified. */
class CallArgument : public InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        AllFieldsSet = 0
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*CallArgument*/InspectorObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class CallArgument;
    public:

        operator RefPtr<CallArgument>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(CallArgument) == sizeof(InspectorObject), cannot_cast);
            return *reinterpret_cast<RefPtr<CallArgument>*>(&m_result);
        }

        PassRefPtr<CallArgument> release()
        {
            return RefPtr<CallArgument>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<CallArgument> result = CallArgument::create();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;

    void setValue(PassRefPtr<InspectorValue> value)
    {
        this->setValue("value", value);
    }
    using InspectorObjectBase::setValue;


    void setObjectId(const TypeBuilder::Runtime::RemoteObjectId& value)
    {
        this->setString("objectId", value);
    }
};

/* Description of an isolated world. */
class ExecutionContextDescription : public InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        IdSet = 1 << 0,
        IsPageContextSet = 1 << 1,
        NameSet = 1 << 2,
        FrameIdSet = 1 << 3,
        AllFieldsSet = (IdSet | IsPageContextSet | NameSet | FrameIdSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*ExecutionContextDescription*/InspectorObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class ExecutionContextDescription;
    public:

        Builder<STATE | IdSet>& setId(int value)
        {
            COMPILE_ASSERT(!(STATE & IdSet), property_id_already_set);
            m_result->setNumber("id", value);
            return castState<IdSet>();
        }

        Builder<STATE | IsPageContextSet>& setIsPageContext(bool value)
        {
            COMPILE_ASSERT(!(STATE & IsPageContextSet), property_isPageContext_already_set);
            m_result->setBoolean("isPageContext", value);
            return castState<IsPageContextSet>();
        }

        Builder<STATE | NameSet>& setName(const String& value)
        {
            COMPILE_ASSERT(!(STATE & NameSet), property_name_already_set);
            m_result->setString("name", value);
            return castState<NameSet>();
        }

        Builder<STATE | FrameIdSet>& setFrameId(const TypeBuilder::Network::FrameId& value)
        {
            COMPILE_ASSERT(!(STATE & FrameIdSet), property_frameId_already_set);
            m_result->setString("frameId", value);
            return castState<FrameIdSet>();
        }

        operator RefPtr<ExecutionContextDescription>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(ExecutionContextDescription) == sizeof(InspectorObject), cannot_cast);
            return *reinterpret_cast<RefPtr<ExecutionContextDescription>*>(&m_result);
        }

        PassRefPtr<ExecutionContextDescription> release()
        {
            return RefPtr<ExecutionContextDescription>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<ExecutionContextDescription> result = ExecutionContextDescription::create()
     *     .setId(...)
     *     .setIsPageContext(...)
     *     .setName(...)
     *     .setFrameId(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;
};

/* Syntax error type: "none" for no error, "irrecoverable" for unrecoverable errors, "unterminated-literal" for when there is an unterminated literal, "recoverable" for when the expression is unfinished but valid so far. */
struct SyntaxErrorType {
    enum Enum {
        None = 19,
        Irrecoverable = 20,
        Unterminated_literal = 21,
        Recoverable = 22,
    };
}; // struct SyntaxErrorType

/* Range of an error in source code. */
class ErrorRange : public InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        StartOffsetSet = 1 << 0,
        EndOffsetSet = 1 << 1,
        AllFieldsSet = (StartOffsetSet | EndOffsetSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*ErrorRange*/InspectorObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class ErrorRange;
    public:

        Builder<STATE | StartOffsetSet>& setStartOffset(int value)
        {
            COMPILE_ASSERT(!(STATE & StartOffsetSet), property_startOffset_already_set);
            m_result->setNumber("startOffset", value);
            return castState<StartOffsetSet>();
        }

        Builder<STATE | EndOffsetSet>& setEndOffset(int value)
        {
            COMPILE_ASSERT(!(STATE & EndOffsetSet), property_endOffset_already_set);
            m_result->setNumber("endOffset", value);
            return castState<EndOffsetSet>();
        }

        operator RefPtr<ErrorRange>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(ErrorRange) == sizeof(InspectorObject), cannot_cast);
            return *reinterpret_cast<RefPtr<ErrorRange>*>(&m_result);
        }

        PassRefPtr<ErrorRange> release()
        {
            return RefPtr<ErrorRange>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<ErrorRange> result = ErrorRange::create()
     *     .setStartOffset(...)
     *     .setEndOffset(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;
};

} // Runtime

namespace Console {
/* Console message. */
class ConsoleMessage : public InspectorObjectBase {
public:
    // Named after property name 'source' while generating ConsoleMessage.
    struct Source {
        enum Enum {
            Xml = 23,
            Javascript = 24,
            Network = 25,
            Console_api = 26,
            Storage = 27,
            Appcache = 28,
            Rendering = 29,
            Css = 30,
            Security = 31,
            Other = 32,
        };
    }; // struct Source

    // Named after property name 'level' while generating ConsoleMessage.
    struct Level {
        enum Enum {
            Log = 33,
            Warning = 34,
            Error = 35,
            Debug = 36,
        };
    }; // struct Level

    // Named after property name 'type' while generating ConsoleMessage.
    struct Type {
        enum Enum {
            Log = 33,
            Dir = 37,
            Dirxml = 38,
            Table = 39,
            Trace = 40,
            Clear = 41,
            StartGroup = 42,
            StartGroupCollapsed = 43,
            EndGroup = 44,
            Assert = 45,
            Timing = 46,
            Profile = 47,
            ProfileEnd = 48,
        };
    }; // struct Type

    enum {
        NoFieldsSet = 0,
        SourceSet = 1 << 0,
        LevelSet = 1 << 1,
        TextSet = 1 << 2,
        AllFieldsSet = (SourceSet | LevelSet | TextSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*ConsoleMessage*/InspectorObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class ConsoleMessage;
    public:

        Builder<STATE | SourceSet>& setSource(Source::Enum value)
        {
            COMPILE_ASSERT(!(STATE & SourceSet), property_source_already_set);
            m_result->setString("source", TypeBuilder::getEnumConstantValue(value));
            return castState<SourceSet>();
        }

        Builder<STATE | LevelSet>& setLevel(Level::Enum value)
        {
            COMPILE_ASSERT(!(STATE & LevelSet), property_level_already_set);
            m_result->setString("level", TypeBuilder::getEnumConstantValue(value));
            return castState<LevelSet>();
        }

        Builder<STATE | TextSet>& setText(const String& value)
        {
            COMPILE_ASSERT(!(STATE & TextSet), property_text_already_set);
            m_result->setString("text", value);
            return castState<TextSet>();
        }

        operator RefPtr<ConsoleMessage>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(ConsoleMessage) == sizeof(InspectorObject), cannot_cast);
            return *reinterpret_cast<RefPtr<ConsoleMessage>*>(&m_result);
        }

        PassRefPtr<ConsoleMessage> release()
        {
            return RefPtr<ConsoleMessage>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<ConsoleMessage> result = ConsoleMessage::create()
     *     .setSource(...)
     *     .setLevel(...)
     *     .setText(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;

    void setType(Type::Enum value)
    {
        this->setString("type", TypeBuilder::getEnumConstantValue(value));
    }

    void setUrl(const String& value)
    {
        this->setString("url", value);
    }

    void setLine(int value)
    {
        this->setNumber("line", value);
    }

    void setColumn(int value)
    {
        this->setNumber("column", value);
    }

    void setRepeatCount(int value)
    {
        this->setNumber("repeatCount", value);
    }

    void setParameters(PassRefPtr<TypeBuilder::Array<TypeBuilder::Runtime::RemoteObject> > value)
    {
        this->setValue("parameters", value);
    }

    void setStackTrace(PassRefPtr<TypeBuilder::Array<TypeBuilder::Console::CallFrame> > value)
    {
        this->setValue("stackTrace", value);
    }

    void setNetworkRequestId(const TypeBuilder::Network::RequestId& value)
    {
        this->setString("networkRequestId", value);
    }
};

/* Stack entry for console errors and assertions. */
class CallFrame : public InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        FunctionNameSet = 1 << 0,
        UrlSet = 1 << 1,
        LineNumberSet = 1 << 2,
        ColumnNumberSet = 1 << 3,
        AllFieldsSet = (FunctionNameSet | UrlSet | LineNumberSet | ColumnNumberSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*CallFrame*/InspectorObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class CallFrame;
    public:

        Builder<STATE | FunctionNameSet>& setFunctionName(const String& value)
        {
            COMPILE_ASSERT(!(STATE & FunctionNameSet), property_functionName_already_set);
            m_result->setString("functionName", value);
            return castState<FunctionNameSet>();
        }

        Builder<STATE | UrlSet>& setUrl(const String& value)
        {
            COMPILE_ASSERT(!(STATE & UrlSet), property_url_already_set);
            m_result->setString("url", value);
            return castState<UrlSet>();
        }

        Builder<STATE | LineNumberSet>& setLineNumber(int value)
        {
            COMPILE_ASSERT(!(STATE & LineNumberSet), property_lineNumber_already_set);
            m_result->setNumber("lineNumber", value);
            return castState<LineNumberSet>();
        }

        Builder<STATE | ColumnNumberSet>& setColumnNumber(int value)
        {
            COMPILE_ASSERT(!(STATE & ColumnNumberSet), property_columnNumber_already_set);
            m_result->setNumber("columnNumber", value);
            return castState<ColumnNumberSet>();
        }

        operator RefPtr<CallFrame>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(CallFrame) == sizeof(InspectorObject), cannot_cast);
            return *reinterpret_cast<RefPtr<CallFrame>*>(&m_result);
        }

        PassRefPtr<CallFrame> release()
        {
            return RefPtr<CallFrame>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<CallFrame> result = CallFrame::create()
     *     .setFunctionName(...)
     *     .setUrl(...)
     *     .setLineNumber(...)
     *     .setColumnNumber(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;
};

} // Console

namespace Network {
/* Timing information for the request. */
class ResourceTiming : public InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        RequestTimeSet = 1 << 0,
        ProxyStartSet = 1 << 1,
        ProxyEndSet = 1 << 2,
        DnsStartSet = 1 << 3,
        DnsEndSet = 1 << 4,
        ConnectStartSet = 1 << 5,
        ConnectEndSet = 1 << 6,
        SslStartSet = 1 << 7,
        SslEndSet = 1 << 8,
        SendStartSet = 1 << 9,
        SendEndSet = 1 << 10,
        ReceiveHeadersEndSet = 1 << 11,
        AllFieldsSet = (RequestTimeSet | ProxyStartSet | ProxyEndSet | DnsStartSet | DnsEndSet | ConnectStartSet | ConnectEndSet | SslStartSet | SslEndSet | SendStartSet | SendEndSet | ReceiveHeadersEndSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*ResourceTiming*/InspectorObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class ResourceTiming;
    public:

        Builder<STATE | RequestTimeSet>& setRequestTime(double value)
        {
            COMPILE_ASSERT(!(STATE & RequestTimeSet), property_requestTime_already_set);
            m_result->setNumber("requestTime", value);
            return castState<RequestTimeSet>();
        }

        Builder<STATE | ProxyStartSet>& setProxyStart(double value)
        {
            COMPILE_ASSERT(!(STATE & ProxyStartSet), property_proxyStart_already_set);
            m_result->setNumber("proxyStart", value);
            return castState<ProxyStartSet>();
        }

        Builder<STATE | ProxyEndSet>& setProxyEnd(double value)
        {
            COMPILE_ASSERT(!(STATE & ProxyEndSet), property_proxyEnd_already_set);
            m_result->setNumber("proxyEnd", value);
            return castState<ProxyEndSet>();
        }

        Builder<STATE | DnsStartSet>& setDnsStart(double value)
        {
            COMPILE_ASSERT(!(STATE & DnsStartSet), property_dnsStart_already_set);
            m_result->setNumber("dnsStart", value);
            return castState<DnsStartSet>();
        }

        Builder<STATE | DnsEndSet>& setDnsEnd(double value)
        {
            COMPILE_ASSERT(!(STATE & DnsEndSet), property_dnsEnd_already_set);
            m_result->setNumber("dnsEnd", value);
            return castState<DnsEndSet>();
        }

        Builder<STATE | ConnectStartSet>& setConnectStart(double value)
        {
            COMPILE_ASSERT(!(STATE & ConnectStartSet), property_connectStart_already_set);
            m_result->setNumber("connectStart", value);
            return castState<ConnectStartSet>();
        }

        Builder<STATE | ConnectEndSet>& setConnectEnd(double value)
        {
            COMPILE_ASSERT(!(STATE & ConnectEndSet), property_connectEnd_already_set);
            m_result->setNumber("connectEnd", value);
            return castState<ConnectEndSet>();
        }

        Builder<STATE | SslStartSet>& setSslStart(double value)
        {
            COMPILE_ASSERT(!(STATE & SslStartSet), property_sslStart_already_set);
            m_result->setNumber("sslStart", value);
            return castState<SslStartSet>();
        }

        Builder<STATE | SslEndSet>& setSslEnd(double value)
        {
            COMPILE_ASSERT(!(STATE & SslEndSet), property_sslEnd_already_set);
            m_result->setNumber("sslEnd", value);
            return castState<SslEndSet>();
        }

        Builder<STATE | SendStartSet>& setSendStart(double value)
        {
            COMPILE_ASSERT(!(STATE & SendStartSet), property_sendStart_already_set);
            m_result->setNumber("sendStart", value);
            return castState<SendStartSet>();
        }

        Builder<STATE | SendEndSet>& setSendEnd(double value)
        {
            COMPILE_ASSERT(!(STATE & SendEndSet), property_sendEnd_already_set);
            m_result->setNumber("sendEnd", value);
            return castState<SendEndSet>();
        }

        Builder<STATE | ReceiveHeadersEndSet>& setReceiveHeadersEnd(double value)
        {
            COMPILE_ASSERT(!(STATE & ReceiveHeadersEndSet), property_receiveHeadersEnd_already_set);
            m_result->setNumber("receiveHeadersEnd", value);
            return castState<ReceiveHeadersEndSet>();
        }

        operator RefPtr<ResourceTiming>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(ResourceTiming) == sizeof(InspectorObject), cannot_cast);
            return *reinterpret_cast<RefPtr<ResourceTiming>*>(&m_result);
        }

        PassRefPtr<ResourceTiming> release()
        {
            return RefPtr<ResourceTiming>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<ResourceTiming> result = ResourceTiming::create()
     *     .setRequestTime(...)
     *     .setProxyStart(...)
     *     .setProxyEnd(...)
     *     .setDnsStart(...)
     *     .setDnsEnd(...)
     *     .setConnectStart(...)
     *     .setConnectEnd(...)
     *     .setSslStart(...)
     *     .setSslEnd(...)
     *     .setSendStart(...)
     *     .setSendEnd(...)
     *     .setReceiveHeadersEnd(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;
};

/* HTTP request data. */
class Request : public InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        UrlSet = 1 << 0,
        MethodSet = 1 << 1,
        HeadersSet = 1 << 2,
        AllFieldsSet = (UrlSet | MethodSet | HeadersSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*Request*/InspectorObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class Request;
    public:

        Builder<STATE | UrlSet>& setUrl(const String& value)
        {
            COMPILE_ASSERT(!(STATE & UrlSet), property_url_already_set);
            m_result->setString("url", value);
            return castState<UrlSet>();
        }

        Builder<STATE | MethodSet>& setMethod(const String& value)
        {
            COMPILE_ASSERT(!(STATE & MethodSet), property_method_already_set);
            m_result->setString("method", value);
            return castState<MethodSet>();
        }

        Builder<STATE | HeadersSet>& setHeaders(PassRefPtr<InspectorObject> value)
        {
            COMPILE_ASSERT(!(STATE & HeadersSet), property_headers_already_set);
            m_result->setValue("headers", value);
            return castState<HeadersSet>();
        }

        operator RefPtr<Request>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(Request) == sizeof(InspectorObject), cannot_cast);
            return *reinterpret_cast<RefPtr<Request>*>(&m_result);
        }

        PassRefPtr<Request> release()
        {
            return RefPtr<Request>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<Request> result = Request::create()
     *     .setUrl(...)
     *     .setMethod(...)
     *     .setHeaders(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;

    void setPostData(const String& value)
    {
        this->setString("postData", value);
    }
};

/* HTTP response data. */
class Response : public InspectorObject {
public:
    enum {
        NoFieldsSet = 0,
        UrlSet = 1 << 0,
        StatusSet = 1 << 1,
        StatusTextSet = 1 << 2,
        HeadersSet = 1 << 3,
        MimeTypeSet = 1 << 4,
        ConnectionReusedSet = 1 << 5,
        ConnectionIdSet = 1 << 6,
        AllFieldsSet = (UrlSet | StatusSet | StatusTextSet | HeadersSet | MimeTypeSet | ConnectionReusedSet | ConnectionIdSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*Response*/InspectorObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class Response;
    public:

        Builder<STATE | UrlSet>& setUrl(const String& value)
        {
            COMPILE_ASSERT(!(STATE & UrlSet), property_url_already_set);
            m_result->setString("url", value);
            return castState<UrlSet>();
        }

        Builder<STATE | StatusSet>& setStatus(double value)
        {
            COMPILE_ASSERT(!(STATE & StatusSet), property_status_already_set);
            m_result->setNumber("status", value);
            return castState<StatusSet>();
        }

        Builder<STATE | StatusTextSet>& setStatusText(const String& value)
        {
            COMPILE_ASSERT(!(STATE & StatusTextSet), property_statusText_already_set);
            m_result->setString("statusText", value);
            return castState<StatusTextSet>();
        }

        Builder<STATE | HeadersSet>& setHeaders(PassRefPtr<InspectorObject> value)
        {
            COMPILE_ASSERT(!(STATE & HeadersSet), property_headers_already_set);
            m_result->setValue("headers", value);
            return castState<HeadersSet>();
        }

        Builder<STATE | MimeTypeSet>& setMimeType(const String& value)
        {
            COMPILE_ASSERT(!(STATE & MimeTypeSet), property_mimeType_already_set);
            m_result->setString("mimeType", value);
            return castState<MimeTypeSet>();
        }

        Builder<STATE | ConnectionReusedSet>& setConnectionReused(bool value)
        {
            COMPILE_ASSERT(!(STATE & ConnectionReusedSet), property_connectionReused_already_set);
            m_result->setBoolean("connectionReused", value);
            return castState<ConnectionReusedSet>();
        }

        Builder<STATE | ConnectionIdSet>& setConnectionId(double value)
        {
            COMPILE_ASSERT(!(STATE & ConnectionIdSet), property_connectionId_already_set);
            m_result->setNumber("connectionId", value);
            return castState<ConnectionIdSet>();
        }

        operator RefPtr<Response>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(Response) == sizeof(InspectorObject), cannot_cast);
            return *reinterpret_cast<RefPtr<Response>*>(&m_result);
        }

        PassRefPtr<Response> release()
        {
            return RefPtr<Response>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<Response> result = Response::create()
     *     .setUrl(...)
     *     .setStatus(...)
     *     .setStatusText(...)
     *     .setHeaders(...)
     *     .setMimeType(...)
     *     .setConnectionReused(...)
     *     .setConnectionId(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;

    void setHeadersText(const String& value)
    {
        this->setString("headersText", value);
    }

    void setRequestHeaders(PassRefPtr<InspectorObject> value)
    {
        this->setValue("requestHeaders", value);
    }

    void setRequestHeadersText(const String& value)
    {
        this->setString("requestHeadersText", value);
    }

    void setFromDiskCache(bool value)
    {
        this->setBoolean("fromDiskCache", value);
    }

    void setTiming(PassRefPtr<TypeBuilder::Network::ResourceTiming> value)
    {
        this->setValue("timing", value);
    }

    // Property names for type generated as open.
    static const char* Url;
    static const char* Status;
    static const char* StatusText;
    static const char* Headers;
    static const char* MimeType;
    static const char* ConnectionReused;
    static const char* ConnectionId;
    static const char* HeadersText;
    static const char* RequestHeaders;
    static const char* RequestHeadersText;
    static const char* FromDiskCache;
    static const char* Timing;
};

/* WebSocket request data. */
class WebSocketRequest : public InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        HeadersSet = 1 << 0,
        AllFieldsSet = (HeadersSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*WebSocketRequest*/InspectorObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class WebSocketRequest;
    public:

        Builder<STATE | HeadersSet>& setHeaders(PassRefPtr<InspectorObject> value)
        {
            COMPILE_ASSERT(!(STATE & HeadersSet), property_headers_already_set);
            m_result->setValue("headers", value);
            return castState<HeadersSet>();
        }

        operator RefPtr<WebSocketRequest>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(WebSocketRequest) == sizeof(InspectorObject), cannot_cast);
            return *reinterpret_cast<RefPtr<WebSocketRequest>*>(&m_result);
        }

        PassRefPtr<WebSocketRequest> release()
        {
            return RefPtr<WebSocketRequest>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<WebSocketRequest> result = WebSocketRequest::create()
     *     .setHeaders(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;
};

/* WebSocket response data. */
class WebSocketResponse : public InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        StatusSet = 1 << 0,
        StatusTextSet = 1 << 1,
        HeadersSet = 1 << 2,
        AllFieldsSet = (StatusSet | StatusTextSet | HeadersSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*WebSocketResponse*/InspectorObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class WebSocketResponse;
    public:

        Builder<STATE | StatusSet>& setStatus(double value)
        {
            COMPILE_ASSERT(!(STATE & StatusSet), property_status_already_set);
            m_result->setNumber("status", value);
            return castState<StatusSet>();
        }

        Builder<STATE | StatusTextSet>& setStatusText(const String& value)
        {
            COMPILE_ASSERT(!(STATE & StatusTextSet), property_statusText_already_set);
            m_result->setString("statusText", value);
            return castState<StatusTextSet>();
        }

        Builder<STATE | HeadersSet>& setHeaders(PassRefPtr<InspectorObject> value)
        {
            COMPILE_ASSERT(!(STATE & HeadersSet), property_headers_already_set);
            m_result->setValue("headers", value);
            return castState<HeadersSet>();
        }

        operator RefPtr<WebSocketResponse>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(WebSocketResponse) == sizeof(InspectorObject), cannot_cast);
            return *reinterpret_cast<RefPtr<WebSocketResponse>*>(&m_result);
        }

        PassRefPtr<WebSocketResponse> release()
        {
            return RefPtr<WebSocketResponse>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<WebSocketResponse> result = WebSocketResponse::create()
     *     .setStatus(...)
     *     .setStatusText(...)
     *     .setHeaders(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;
};

/* WebSocket frame data. */
class WebSocketFrame : public InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        OpcodeSet = 1 << 0,
        MaskSet = 1 << 1,
        PayloadDataSet = 1 << 2,
        AllFieldsSet = (OpcodeSet | MaskSet | PayloadDataSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*WebSocketFrame*/InspectorObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class WebSocketFrame;
    public:

        Builder<STATE | OpcodeSet>& setOpcode(double value)
        {
            COMPILE_ASSERT(!(STATE & OpcodeSet), property_opcode_already_set);
            m_result->setNumber("opcode", value);
            return castState<OpcodeSet>();
        }

        Builder<STATE | MaskSet>& setMask(bool value)
        {
            COMPILE_ASSERT(!(STATE & MaskSet), property_mask_already_set);
            m_result->setBoolean("mask", value);
            return castState<MaskSet>();
        }

        Builder<STATE | PayloadDataSet>& setPayloadData(const String& value)
        {
            COMPILE_ASSERT(!(STATE & PayloadDataSet), property_payloadData_already_set);
            m_result->setString("payloadData", value);
            return castState<PayloadDataSet>();
        }

        operator RefPtr<WebSocketFrame>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(WebSocketFrame) == sizeof(InspectorObject), cannot_cast);
            return *reinterpret_cast<RefPtr<WebSocketFrame>*>(&m_result);
        }

        PassRefPtr<WebSocketFrame> release()
        {
            return RefPtr<WebSocketFrame>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<WebSocketFrame> result = WebSocketFrame::create()
     *     .setOpcode(...)
     *     .setMask(...)
     *     .setPayloadData(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;
};

/* Information about the cached resource. */
class CachedResource : public InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        UrlSet = 1 << 0,
        TypeSet = 1 << 1,
        BodySizeSet = 1 << 2,
        AllFieldsSet = (UrlSet | TypeSet | BodySizeSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*CachedResource*/InspectorObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class CachedResource;
    public:

        Builder<STATE | UrlSet>& setUrl(const String& value)
        {
            COMPILE_ASSERT(!(STATE & UrlSet), property_url_already_set);
            m_result->setString("url", value);
            return castState<UrlSet>();
        }

        Builder<STATE | TypeSet>& setType(TypeBuilder::Page::ResourceType::Enum value)
        {
            COMPILE_ASSERT(!(STATE & TypeSet), property_type_already_set);
            m_result->setString("type", TypeBuilder::getEnumConstantValue(value));
            return castState<TypeSet>();
        }

        Builder<STATE | BodySizeSet>& setBodySize(double value)
        {
            COMPILE_ASSERT(!(STATE & BodySizeSet), property_bodySize_already_set);
            m_result->setNumber("bodySize", value);
            return castState<BodySizeSet>();
        }

        operator RefPtr<CachedResource>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(CachedResource) == sizeof(InspectorObject), cannot_cast);
            return *reinterpret_cast<RefPtr<CachedResource>*>(&m_result);
        }

        PassRefPtr<CachedResource> release()
        {
            return RefPtr<CachedResource>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<CachedResource> result = CachedResource::create()
     *     .setUrl(...)
     *     .setType(...)
     *     .setBodySize(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;

    void setResponse(PassRefPtr<TypeBuilder::Network::Response> value)
    {
        this->setValue("response", value);
    }

    void setSourceMapURL(const String& value)
    {
        this->setString("sourceMapURL", value);
    }
};

/* Information about the request initiator. */
class Initiator : public InspectorObjectBase {
public:
    // Named after property name 'type' while generating Initiator.
    struct Type {
        enum Enum {
            Parser = 49,
            Script = 50,
            Other = 32,
        };
    }; // struct Type

    enum {
        NoFieldsSet = 0,
        TypeSet = 1 << 0,
        AllFieldsSet = (TypeSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*Initiator*/InspectorObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class Initiator;
    public:

        Builder<STATE | TypeSet>& setType(Type::Enum value)
        {
            COMPILE_ASSERT(!(STATE & TypeSet), property_type_already_set);
            m_result->setString("type", TypeBuilder::getEnumConstantValue(value));
            return castState<TypeSet>();
        }

        operator RefPtr<Initiator>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(Initiator) == sizeof(InspectorObject), cannot_cast);
            return *reinterpret_cast<RefPtr<Initiator>*>(&m_result);
        }

        PassRefPtr<Initiator> release()
        {
            return RefPtr<Initiator>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<Initiator> result = Initiator::create()
     *     .setType(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;

    void setStackTrace(PassRefPtr<TypeBuilder::Array<TypeBuilder::Console::CallFrame> > value)
    {
        this->setValue("stackTrace", value);
    }

    void setUrl(const String& value)
    {
        this->setString("url", value);
    }

    void setLineNumber(double value)
    {
        this->setNumber("lineNumber", value);
    }
};

} // Network

#if ENABLE(SQL_DATABASE)
namespace Database {
/* Database object. */
class Database : public InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        IdSet = 1 << 0,
        DomainSet = 1 << 1,
        NameSet = 1 << 2,
        VersionSet = 1 << 3,
        AllFieldsSet = (IdSet | DomainSet | NameSet | VersionSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*Database*/InspectorObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class Database;
    public:

        Builder<STATE | IdSet>& setId(const TypeBuilder::Database::DatabaseId& value)
        {
            COMPILE_ASSERT(!(STATE & IdSet), property_id_already_set);
            m_result->setString("id", value);
            return castState<IdSet>();
        }

        Builder<STATE | DomainSet>& setDomain(const String& value)
        {
            COMPILE_ASSERT(!(STATE & DomainSet), property_domain_already_set);
            m_result->setString("domain", value);
            return castState<DomainSet>();
        }

        Builder<STATE | NameSet>& setName(const String& value)
        {
            COMPILE_ASSERT(!(STATE & NameSet), property_name_already_set);
            m_result->setString("name", value);
            return castState<NameSet>();
        }

        Builder<STATE | VersionSet>& setVersion(const String& value)
        {
            COMPILE_ASSERT(!(STATE & VersionSet), property_version_already_set);
            m_result->setString("version", value);
            return castState<VersionSet>();
        }

        operator RefPtr<Database>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(Database) == sizeof(InspectorObject), cannot_cast);
            return *reinterpret_cast<RefPtr<Database>*>(&m_result);
        }

        PassRefPtr<Database> release()
        {
            return RefPtr<Database>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<Database> result = Database::create()
     *     .setId(...)
     *     .setDomain(...)
     *     .setName(...)
     *     .setVersion(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;
};

/* Database error. */
class Error : public InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        MessageSet = 1 << 0,
        CodeSet = 1 << 1,
        AllFieldsSet = (MessageSet | CodeSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*Error*/InspectorObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class Error;
    public:

        Builder<STATE | MessageSet>& setMessage(const String& value)
        {
            COMPILE_ASSERT(!(STATE & MessageSet), property_message_already_set);
            m_result->setString("message", value);
            return castState<MessageSet>();
        }

        Builder<STATE | CodeSet>& setCode(int value)
        {
            COMPILE_ASSERT(!(STATE & CodeSet), property_code_already_set);
            m_result->setNumber("code", value);
            return castState<CodeSet>();
        }

        operator RefPtr<Error>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(Error) == sizeof(InspectorObject), cannot_cast);
            return *reinterpret_cast<RefPtr<Error>*>(&m_result);
        }

        PassRefPtr<Error> release()
        {
            return RefPtr<Error>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<Error> result = Error::create()
     *     .setMessage(...)
     *     .setCode(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;
};

} // Database

#endif // ENABLE(SQL_DATABASE)
#if ENABLE(INDEXED_DATABASE)
namespace IndexedDB {
/* Database with an array of object stores. */
class DatabaseWithObjectStores : public InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        NameSet = 1 << 0,
        VersionSet = 1 << 1,
        IntVersionSet = 1 << 2,
        ObjectStoresSet = 1 << 3,
        AllFieldsSet = (NameSet | VersionSet | IntVersionSet | ObjectStoresSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*DatabaseWithObjectStores*/InspectorObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class DatabaseWithObjectStores;
    public:

        Builder<STATE | NameSet>& setName(const String& value)
        {
            COMPILE_ASSERT(!(STATE & NameSet), property_name_already_set);
            m_result->setString("name", value);
            return castState<NameSet>();
        }

        Builder<STATE | VersionSet>& setVersion(const String& value)
        {
            COMPILE_ASSERT(!(STATE & VersionSet), property_version_already_set);
            m_result->setString("version", value);
            return castState<VersionSet>();
        }

        Builder<STATE | IntVersionSet>& setIntVersion(int value)
        {
            COMPILE_ASSERT(!(STATE & IntVersionSet), property_intVersion_already_set);
            m_result->setNumber("intVersion", value);
            return castState<IntVersionSet>();
        }

        Builder<STATE | ObjectStoresSet>& setObjectStores(PassRefPtr<TypeBuilder::Array<TypeBuilder::IndexedDB::ObjectStore> > value)
        {
            COMPILE_ASSERT(!(STATE & ObjectStoresSet), property_objectStores_already_set);
            m_result->setValue("objectStores", value);
            return castState<ObjectStoresSet>();
        }

        operator RefPtr<DatabaseWithObjectStores>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(DatabaseWithObjectStores) == sizeof(InspectorObject), cannot_cast);
            return *reinterpret_cast<RefPtr<DatabaseWithObjectStores>*>(&m_result);
        }

        PassRefPtr<DatabaseWithObjectStores> release()
        {
            return RefPtr<DatabaseWithObjectStores>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<DatabaseWithObjectStores> result = DatabaseWithObjectStores::create()
     *     .setName(...)
     *     .setVersion(...)
     *     .setIntVersion(...)
     *     .setObjectStores(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;
};

/* Object store. */
class ObjectStore : public InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        NameSet = 1 << 0,
        KeyPathSet = 1 << 1,
        AutoIncrementSet = 1 << 2,
        IndexesSet = 1 << 3,
        AllFieldsSet = (NameSet | KeyPathSet | AutoIncrementSet | IndexesSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*ObjectStore*/InspectorObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class ObjectStore;
    public:

        Builder<STATE | NameSet>& setName(const String& value)
        {
            COMPILE_ASSERT(!(STATE & NameSet), property_name_already_set);
            m_result->setString("name", value);
            return castState<NameSet>();
        }

        Builder<STATE | KeyPathSet>& setKeyPath(PassRefPtr<TypeBuilder::IndexedDB::KeyPath> value)
        {
            COMPILE_ASSERT(!(STATE & KeyPathSet), property_keyPath_already_set);
            m_result->setValue("keyPath", value);
            return castState<KeyPathSet>();
        }

        Builder<STATE | AutoIncrementSet>& setAutoIncrement(bool value)
        {
            COMPILE_ASSERT(!(STATE & AutoIncrementSet), property_autoIncrement_already_set);
            m_result->setBoolean("autoIncrement", value);
            return castState<AutoIncrementSet>();
        }

        Builder<STATE | IndexesSet>& setIndexes(PassRefPtr<TypeBuilder::Array<TypeBuilder::IndexedDB::ObjectStoreIndex> > value)
        {
            COMPILE_ASSERT(!(STATE & IndexesSet), property_indexes_already_set);
            m_result->setValue("indexes", value);
            return castState<IndexesSet>();
        }

        operator RefPtr<ObjectStore>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(ObjectStore) == sizeof(InspectorObject), cannot_cast);
            return *reinterpret_cast<RefPtr<ObjectStore>*>(&m_result);
        }

        PassRefPtr<ObjectStore> release()
        {
            return RefPtr<ObjectStore>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<ObjectStore> result = ObjectStore::create()
     *     .setName(...)
     *     .setKeyPath(...)
     *     .setAutoIncrement(...)
     *     .setIndexes(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;
};

/* Object store index. */
class ObjectStoreIndex : public InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        NameSet = 1 << 0,
        KeyPathSet = 1 << 1,
        UniqueSet = 1 << 2,
        MultiEntrySet = 1 << 3,
        AllFieldsSet = (NameSet | KeyPathSet | UniqueSet | MultiEntrySet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*ObjectStoreIndex*/InspectorObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class ObjectStoreIndex;
    public:

        Builder<STATE | NameSet>& setName(const String& value)
        {
            COMPILE_ASSERT(!(STATE & NameSet), property_name_already_set);
            m_result->setString("name", value);
            return castState<NameSet>();
        }

        Builder<STATE | KeyPathSet>& setKeyPath(PassRefPtr<TypeBuilder::IndexedDB::KeyPath> value)
        {
            COMPILE_ASSERT(!(STATE & KeyPathSet), property_keyPath_already_set);
            m_result->setValue("keyPath", value);
            return castState<KeyPathSet>();
        }

        Builder<STATE | UniqueSet>& setUnique(bool value)
        {
            COMPILE_ASSERT(!(STATE & UniqueSet), property_unique_already_set);
            m_result->setBoolean("unique", value);
            return castState<UniqueSet>();
        }

        Builder<STATE | MultiEntrySet>& setMultiEntry(bool value)
        {
            COMPILE_ASSERT(!(STATE & MultiEntrySet), property_multiEntry_already_set);
            m_result->setBoolean("multiEntry", value);
            return castState<MultiEntrySet>();
        }

        operator RefPtr<ObjectStoreIndex>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(ObjectStoreIndex) == sizeof(InspectorObject), cannot_cast);
            return *reinterpret_cast<RefPtr<ObjectStoreIndex>*>(&m_result);
        }

        PassRefPtr<ObjectStoreIndex> release()
        {
            return RefPtr<ObjectStoreIndex>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<ObjectStoreIndex> result = ObjectStoreIndex::create()
     *     .setName(...)
     *     .setKeyPath(...)
     *     .setUnique(...)
     *     .setMultiEntry(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;
};

/* Key. */
class Key : public InspectorObjectBase {
public:
    // Named after property name 'type' while generating Key.
    struct Type {
        enum Enum {
            Number = 12,
            String = 11,
            Date = 18,
            Array = 14,
        };
    }; // struct Type

    enum {
        NoFieldsSet = 0,
        TypeSet = 1 << 0,
        AllFieldsSet = (TypeSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*Key*/InspectorObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class Key;
    public:

        Builder<STATE | TypeSet>& setType(Type::Enum value)
        {
            COMPILE_ASSERT(!(STATE & TypeSet), property_type_already_set);
            m_result->setString("type", TypeBuilder::getEnumConstantValue(value));
            return castState<TypeSet>();
        }

        operator RefPtr<Key>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(Key) == sizeof(InspectorObject), cannot_cast);
            return *reinterpret_cast<RefPtr<Key>*>(&m_result);
        }

        PassRefPtr<Key> release()
        {
            return RefPtr<Key>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<Key> result = Key::create()
     *     .setType(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;

    void setNumber(double value)
    {
        this->setNumber("number", value);
    }
    using InspectorObjectBase::setNumber;


    void setString(const String& value)
    {
        this->setString("string", value);
    }
    using InspectorObjectBase::setString;


    void setDate(double value)
    {
        this->setNumber("date", value);
    }

    void setArray(PassRefPtr<TypeBuilder::Array<TypeBuilder::IndexedDB::Key> > value)
    {
        this->setValue("array", value);
    }
    using InspectorObjectBase::setArray;

};

/* Key range. */
class KeyRange : public InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        LowerOpenSet = 1 << 0,
        UpperOpenSet = 1 << 1,
        AllFieldsSet = (LowerOpenSet | UpperOpenSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*KeyRange*/InspectorObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class KeyRange;
    public:

        Builder<STATE | LowerOpenSet>& setLowerOpen(bool value)
        {
            COMPILE_ASSERT(!(STATE & LowerOpenSet), property_lowerOpen_already_set);
            m_result->setBoolean("lowerOpen", value);
            return castState<LowerOpenSet>();
        }

        Builder<STATE | UpperOpenSet>& setUpperOpen(bool value)
        {
            COMPILE_ASSERT(!(STATE & UpperOpenSet), property_upperOpen_already_set);
            m_result->setBoolean("upperOpen", value);
            return castState<UpperOpenSet>();
        }

        operator RefPtr<KeyRange>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(KeyRange) == sizeof(InspectorObject), cannot_cast);
            return *reinterpret_cast<RefPtr<KeyRange>*>(&m_result);
        }

        PassRefPtr<KeyRange> release()
        {
            return RefPtr<KeyRange>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<KeyRange> result = KeyRange::create()
     *     .setLowerOpen(...)
     *     .setUpperOpen(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;

    void setLower(PassRefPtr<TypeBuilder::IndexedDB::Key> value)
    {
        this->setValue("lower", value);
    }

    void setUpper(PassRefPtr<TypeBuilder::IndexedDB::Key> value)
    {
        this->setValue("upper", value);
    }
};

/* Data entry. */
class DataEntry : public InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        KeySet = 1 << 0,
        PrimaryKeySet = 1 << 1,
        ValueSet = 1 << 2,
        AllFieldsSet = (KeySet | PrimaryKeySet | ValueSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*DataEntry*/InspectorObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class DataEntry;
    public:

        Builder<STATE | KeySet>& setKey(PassRefPtr<TypeBuilder::Runtime::RemoteObject> value)
        {
            COMPILE_ASSERT(!(STATE & KeySet), property_key_already_set);
            m_result->setValue("key", value);
            return castState<KeySet>();
        }

        Builder<STATE | PrimaryKeySet>& setPrimaryKey(PassRefPtr<TypeBuilder::Runtime::RemoteObject> value)
        {
            COMPILE_ASSERT(!(STATE & PrimaryKeySet), property_primaryKey_already_set);
            m_result->setValue("primaryKey", value);
            return castState<PrimaryKeySet>();
        }

        Builder<STATE | ValueSet>& setValue(PassRefPtr<TypeBuilder::Runtime::RemoteObject> value)
        {
            COMPILE_ASSERT(!(STATE & ValueSet), property_value_already_set);
            m_result->setValue("value", value);
            return castState<ValueSet>();
        }

        operator RefPtr<DataEntry>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(DataEntry) == sizeof(InspectorObject), cannot_cast);
            return *reinterpret_cast<RefPtr<DataEntry>*>(&m_result);
        }

        PassRefPtr<DataEntry> release()
        {
            return RefPtr<DataEntry>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<DataEntry> result = DataEntry::create()
     *     .setKey(...)
     *     .setPrimaryKey(...)
     *     .setValue(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;
};

/* Key path. */
class KeyPath : public InspectorObjectBase {
public:
    // Named after property name 'type' while generating KeyPath.
    struct Type {
        enum Enum {
            Null = 15,
            String = 11,
            Array = 14,
        };
    }; // struct Type

    enum {
        NoFieldsSet = 0,
        TypeSet = 1 << 0,
        AllFieldsSet = (TypeSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*KeyPath*/InspectorObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class KeyPath;
    public:

        Builder<STATE | TypeSet>& setType(Type::Enum value)
        {
            COMPILE_ASSERT(!(STATE & TypeSet), property_type_already_set);
            m_result->setString("type", TypeBuilder::getEnumConstantValue(value));
            return castState<TypeSet>();
        }

        operator RefPtr<KeyPath>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(KeyPath) == sizeof(InspectorObject), cannot_cast);
            return *reinterpret_cast<RefPtr<KeyPath>*>(&m_result);
        }

        PassRefPtr<KeyPath> release()
        {
            return RefPtr<KeyPath>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<KeyPath> result = KeyPath::create()
     *     .setType(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;

    void setString(const String& value)
    {
        this->setString("string", value);
    }
    using InspectorObjectBase::setString;


    void setArray(PassRefPtr<TypeBuilder::Array<String> > value)
    {
        this->setValue("array", value);
    }
    using InspectorObjectBase::setArray;

};

} // IndexedDB

#endif // ENABLE(INDEXED_DATABASE)
namespace DOMStorage {
/* DOM Storage identifier. */
class StorageId : public InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        SecurityOriginSet = 1 << 0,
        IsLocalStorageSet = 1 << 1,
        AllFieldsSet = (SecurityOriginSet | IsLocalStorageSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*StorageId*/InspectorObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class StorageId;
    public:

        Builder<STATE | SecurityOriginSet>& setSecurityOrigin(const String& value)
        {
            COMPILE_ASSERT(!(STATE & SecurityOriginSet), property_securityOrigin_already_set);
            m_result->setString("securityOrigin", value);
            return castState<SecurityOriginSet>();
        }

        Builder<STATE | IsLocalStorageSet>& setIsLocalStorage(bool value)
        {
            COMPILE_ASSERT(!(STATE & IsLocalStorageSet), property_isLocalStorage_already_set);
            m_result->setBoolean("isLocalStorage", value);
            return castState<IsLocalStorageSet>();
        }

        operator RefPtr<StorageId>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(StorageId) == sizeof(InspectorObject), cannot_cast);
            return *reinterpret_cast<RefPtr<StorageId>*>(&m_result);
        }

        PassRefPtr<StorageId> release()
        {
            return RefPtr<StorageId>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<StorageId> result = StorageId::create()
     *     .setSecurityOrigin(...)
     *     .setIsLocalStorage(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;
};

} // DOMStorage

namespace ApplicationCache {
/* Detailed application cache resource information. */
class ApplicationCacheResource : public InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        UrlSet = 1 << 0,
        SizeSet = 1 << 1,
        TypeSet = 1 << 2,
        AllFieldsSet = (UrlSet | SizeSet | TypeSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*ApplicationCacheResource*/InspectorObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class ApplicationCacheResource;
    public:

        Builder<STATE | UrlSet>& setUrl(const String& value)
        {
            COMPILE_ASSERT(!(STATE & UrlSet), property_url_already_set);
            m_result->setString("url", value);
            return castState<UrlSet>();
        }

        Builder<STATE | SizeSet>& setSize(int value)
        {
            COMPILE_ASSERT(!(STATE & SizeSet), property_size_already_set);
            m_result->setNumber("size", value);
            return castState<SizeSet>();
        }

        Builder<STATE | TypeSet>& setType(const String& value)
        {
            COMPILE_ASSERT(!(STATE & TypeSet), property_type_already_set);
            m_result->setString("type", value);
            return castState<TypeSet>();
        }

        operator RefPtr<ApplicationCacheResource>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(ApplicationCacheResource) == sizeof(InspectorObject), cannot_cast);
            return *reinterpret_cast<RefPtr<ApplicationCacheResource>*>(&m_result);
        }

        PassRefPtr<ApplicationCacheResource> release()
        {
            return RefPtr<ApplicationCacheResource>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<ApplicationCacheResource> result = ApplicationCacheResource::create()
     *     .setUrl(...)
     *     .setSize(...)
     *     .setType(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;
};

/* Detailed application cache information. */
class ApplicationCache : public InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        ManifestURLSet = 1 << 0,
        SizeSet = 1 << 1,
        CreationTimeSet = 1 << 2,
        UpdateTimeSet = 1 << 3,
        ResourcesSet = 1 << 4,
        AllFieldsSet = (ManifestURLSet | SizeSet | CreationTimeSet | UpdateTimeSet | ResourcesSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*ApplicationCache*/InspectorObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class ApplicationCache;
    public:

        Builder<STATE | ManifestURLSet>& setManifestURL(const String& value)
        {
            COMPILE_ASSERT(!(STATE & ManifestURLSet), property_manifestURL_already_set);
            m_result->setString("manifestURL", value);
            return castState<ManifestURLSet>();
        }

        Builder<STATE | SizeSet>& setSize(double value)
        {
            COMPILE_ASSERT(!(STATE & SizeSet), property_size_already_set);
            m_result->setNumber("size", value);
            return castState<SizeSet>();
        }

        Builder<STATE | CreationTimeSet>& setCreationTime(double value)
        {
            COMPILE_ASSERT(!(STATE & CreationTimeSet), property_creationTime_already_set);
            m_result->setNumber("creationTime", value);
            return castState<CreationTimeSet>();
        }

        Builder<STATE | UpdateTimeSet>& setUpdateTime(double value)
        {
            COMPILE_ASSERT(!(STATE & UpdateTimeSet), property_updateTime_already_set);
            m_result->setNumber("updateTime", value);
            return castState<UpdateTimeSet>();
        }

        Builder<STATE | ResourcesSet>& setResources(PassRefPtr<TypeBuilder::Array<TypeBuilder::ApplicationCache::ApplicationCacheResource> > value)
        {
            COMPILE_ASSERT(!(STATE & ResourcesSet), property_resources_already_set);
            m_result->setValue("resources", value);
            return castState<ResourcesSet>();
        }

        operator RefPtr<ApplicationCache>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(ApplicationCache) == sizeof(InspectorObject), cannot_cast);
            return *reinterpret_cast<RefPtr<ApplicationCache>*>(&m_result);
        }

        PassRefPtr<ApplicationCache> release()
        {
            return RefPtr<ApplicationCache>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<ApplicationCache> result = ApplicationCache::create()
     *     .setManifestURL(...)
     *     .setSize(...)
     *     .setCreationTime(...)
     *     .setUpdateTime(...)
     *     .setResources(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;
};

/* Frame identifier - manifest URL pair. */
class FrameWithManifest : public InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        FrameIdSet = 1 << 0,
        ManifestURLSet = 1 << 1,
        StatusSet = 1 << 2,
        AllFieldsSet = (FrameIdSet | ManifestURLSet | StatusSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*FrameWithManifest*/InspectorObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class FrameWithManifest;
    public:

        Builder<STATE | FrameIdSet>& setFrameId(const TypeBuilder::Network::FrameId& value)
        {
            COMPILE_ASSERT(!(STATE & FrameIdSet), property_frameId_already_set);
            m_result->setString("frameId", value);
            return castState<FrameIdSet>();
        }

        Builder<STATE | ManifestURLSet>& setManifestURL(const String& value)
        {
            COMPILE_ASSERT(!(STATE & ManifestURLSet), property_manifestURL_already_set);
            m_result->setString("manifestURL", value);
            return castState<ManifestURLSet>();
        }

        Builder<STATE | StatusSet>& setStatus(int value)
        {
            COMPILE_ASSERT(!(STATE & StatusSet), property_status_already_set);
            m_result->setNumber("status", value);
            return castState<StatusSet>();
        }

        operator RefPtr<FrameWithManifest>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(FrameWithManifest) == sizeof(InspectorObject), cannot_cast);
            return *reinterpret_cast<RefPtr<FrameWithManifest>*>(&m_result);
        }

        PassRefPtr<FrameWithManifest> release()
        {
            return RefPtr<FrameWithManifest>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<FrameWithManifest> result = FrameWithManifest::create()
     *     .setFrameId(...)
     *     .setManifestURL(...)
     *     .setStatus(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;
};

} // ApplicationCache

#if ENABLE(FILE_SYSTEM)
namespace FileSystem {
/* Represents a browser side file or directory. */
class Entry : public InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        UrlSet = 1 << 0,
        NameSet = 1 << 1,
        IsDirectorySet = 1 << 2,
        AllFieldsSet = (UrlSet | NameSet | IsDirectorySet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*Entry*/InspectorObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class Entry;
    public:

        Builder<STATE | UrlSet>& setUrl(const String& value)
        {
            COMPILE_ASSERT(!(STATE & UrlSet), property_url_already_set);
            m_result->setString("url", value);
            return castState<UrlSet>();
        }

        Builder<STATE | NameSet>& setName(const String& value)
        {
            COMPILE_ASSERT(!(STATE & NameSet), property_name_already_set);
            m_result->setString("name", value);
            return castState<NameSet>();
        }

        Builder<STATE | IsDirectorySet>& setIsDirectory(bool value)
        {
            COMPILE_ASSERT(!(STATE & IsDirectorySet), property_isDirectory_already_set);
            m_result->setBoolean("isDirectory", value);
            return castState<IsDirectorySet>();
        }

        operator RefPtr<Entry>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(Entry) == sizeof(InspectorObject), cannot_cast);
            return *reinterpret_cast<RefPtr<Entry>*>(&m_result);
        }

        PassRefPtr<Entry> release()
        {
            return RefPtr<Entry>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<Entry> result = Entry::create()
     *     .setUrl(...)
     *     .setName(...)
     *     .setIsDirectory(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;

    void setMimeType(const String& value)
    {
        this->setString("mimeType", value);
    }

    void setResourceType(TypeBuilder::Page::ResourceType::Enum value)
    {
        this->setString("resourceType", TypeBuilder::getEnumConstantValue(value));
    }

    void setIsTextFile(bool value)
    {
        this->setBoolean("isTextFile", value);
    }
};

/* Represents metadata of a file or entry. */
class Metadata : public InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        ModificationTimeSet = 1 << 0,
        SizeSet = 1 << 1,
        AllFieldsSet = (ModificationTimeSet | SizeSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*Metadata*/InspectorObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class Metadata;
    public:

        Builder<STATE | ModificationTimeSet>& setModificationTime(double value)
        {
            COMPILE_ASSERT(!(STATE & ModificationTimeSet), property_modificationTime_already_set);
            m_result->setNumber("modificationTime", value);
            return castState<ModificationTimeSet>();
        }

        Builder<STATE | SizeSet>& setSize(double value)
        {
            COMPILE_ASSERT(!(STATE & SizeSet), property_size_already_set);
            m_result->setNumber("size", value);
            return castState<SizeSet>();
        }

        operator RefPtr<Metadata>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(Metadata) == sizeof(InspectorObject), cannot_cast);
            return *reinterpret_cast<RefPtr<Metadata>*>(&m_result);
        }

        PassRefPtr<Metadata> release()
        {
            return RefPtr<Metadata>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<Metadata> result = Metadata::create()
     *     .setModificationTime(...)
     *     .setSize(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;
};

} // FileSystem

#endif // ENABLE(FILE_SYSTEM)
namespace DOM {
/* DOM interaction is implemented in terms of mirror objects that represent the actual DOM nodes. DOMNode is a base node mirror type. */
class Node : public InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        NodeIdSet = 1 << 0,
        NodeTypeSet = 1 << 1,
        NodeNameSet = 1 << 2,
        LocalNameSet = 1 << 3,
        NodeValueSet = 1 << 4,
        AllFieldsSet = (NodeIdSet | NodeTypeSet | NodeNameSet | LocalNameSet | NodeValueSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*Node*/InspectorObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class Node;
    public:

        Builder<STATE | NodeIdSet>& setNodeId(int value)
        {
            COMPILE_ASSERT(!(STATE & NodeIdSet), property_nodeId_already_set);
            m_result->setNumber("nodeId", value);
            return castState<NodeIdSet>();
        }

        Builder<STATE | NodeTypeSet>& setNodeType(int value)
        {
            COMPILE_ASSERT(!(STATE & NodeTypeSet), property_nodeType_already_set);
            m_result->setNumber("nodeType", value);
            return castState<NodeTypeSet>();
        }

        Builder<STATE | NodeNameSet>& setNodeName(const String& value)
        {
            COMPILE_ASSERT(!(STATE & NodeNameSet), property_nodeName_already_set);
            m_result->setString("nodeName", value);
            return castState<NodeNameSet>();
        }

        Builder<STATE | LocalNameSet>& setLocalName(const String& value)
        {
            COMPILE_ASSERT(!(STATE & LocalNameSet), property_localName_already_set);
            m_result->setString("localName", value);
            return castState<LocalNameSet>();
        }

        Builder<STATE | NodeValueSet>& setNodeValue(const String& value)
        {
            COMPILE_ASSERT(!(STATE & NodeValueSet), property_nodeValue_already_set);
            m_result->setString("nodeValue", value);
            return castState<NodeValueSet>();
        }

        operator RefPtr<Node>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(Node) == sizeof(InspectorObject), cannot_cast);
            return *reinterpret_cast<RefPtr<Node>*>(&m_result);
        }

        PassRefPtr<Node> release()
        {
            return RefPtr<Node>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<Node> result = Node::create()
     *     .setNodeId(...)
     *     .setNodeType(...)
     *     .setNodeName(...)
     *     .setLocalName(...)
     *     .setNodeValue(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;

    void setChildNodeCount(int value)
    {
        this->setNumber("childNodeCount", value);
    }

    void setChildren(PassRefPtr<TypeBuilder::Array<TypeBuilder::DOM::Node> > value)
    {
        this->setValue("children", value);
    }

    void setAttributes(PassRefPtr<TypeBuilder::Array<String> > value)
    {
        this->setValue("attributes", value);
    }

    void setDocumentURL(const String& value)
    {
        this->setString("documentURL", value);
    }

    void setBaseURL(const String& value)
    {
        this->setString("baseURL", value);
    }

    void setPublicId(const String& value)
    {
        this->setString("publicId", value);
    }

    void setSystemId(const String& value)
    {
        this->setString("systemId", value);
    }

    void setInternalSubset(const String& value)
    {
        this->setString("internalSubset", value);
    }

    void setXmlVersion(const String& value)
    {
        this->setString("xmlVersion", value);
    }

    void setName(const String& value)
    {
        this->setString("name", value);
    }

    void setValue(const String& value)
    {
        this->setString("value", value);
    }
    using InspectorObjectBase::setValue;


    void setFrameId(const TypeBuilder::Network::FrameId& value)
    {
        this->setString("frameId", value);
    }

    void setContentDocument(PassRefPtr<TypeBuilder::DOM::Node> value)
    {
        this->setValue("contentDocument", value);
    }

    void setShadowRoots(PassRefPtr<TypeBuilder::Array<TypeBuilder::DOM::Node> > value)
    {
        this->setValue("shadowRoots", value);
    }

    void setTemplateContent(PassRefPtr<TypeBuilder::DOM::Node> value)
    {
        this->setValue("templateContent", value);
    }
};

/* DOM interaction is implemented in terms of mirror objects that represent the actual DOM nodes. DOMNode is a base node mirror type. */
class EventListener : public InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        TypeSet = 1 << 0,
        UseCaptureSet = 1 << 1,
        IsAttributeSet = 1 << 2,
        NodeIdSet = 1 << 3,
        HandlerBodySet = 1 << 4,
        AllFieldsSet = (TypeSet | UseCaptureSet | IsAttributeSet | NodeIdSet | HandlerBodySet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*EventListener*/InspectorObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class EventListener;
    public:

        Builder<STATE | TypeSet>& setType(const String& value)
        {
            COMPILE_ASSERT(!(STATE & TypeSet), property_type_already_set);
            m_result->setString("type", value);
            return castState<TypeSet>();
        }

        Builder<STATE | UseCaptureSet>& setUseCapture(bool value)
        {
            COMPILE_ASSERT(!(STATE & UseCaptureSet), property_useCapture_already_set);
            m_result->setBoolean("useCapture", value);
            return castState<UseCaptureSet>();
        }

        Builder<STATE | IsAttributeSet>& setIsAttribute(bool value)
        {
            COMPILE_ASSERT(!(STATE & IsAttributeSet), property_isAttribute_already_set);
            m_result->setBoolean("isAttribute", value);
            return castState<IsAttributeSet>();
        }

        Builder<STATE | NodeIdSet>& setNodeId(int value)
        {
            COMPILE_ASSERT(!(STATE & NodeIdSet), property_nodeId_already_set);
            m_result->setNumber("nodeId", value);
            return castState<NodeIdSet>();
        }

        Builder<STATE | HandlerBodySet>& setHandlerBody(const String& value)
        {
            COMPILE_ASSERT(!(STATE & HandlerBodySet), property_handlerBody_already_set);
            m_result->setString("handlerBody", value);
            return castState<HandlerBodySet>();
        }

        operator RefPtr<EventListener>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(EventListener) == sizeof(InspectorObject), cannot_cast);
            return *reinterpret_cast<RefPtr<EventListener>*>(&m_result);
        }

        PassRefPtr<EventListener> release()
        {
            return RefPtr<EventListener>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<EventListener> result = EventListener::create()
     *     .setType(...)
     *     .setUseCapture(...)
     *     .setIsAttribute(...)
     *     .setNodeId(...)
     *     .setHandlerBody(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;

    void setLocation(PassRefPtr<TypeBuilder::Debugger::Location> value)
    {
        this->setValue("location", value);
    }

    void setSourceName(const String& value)
    {
        this->setString("sourceName", value);
    }

    void setHandler(PassRefPtr<TypeBuilder::Runtime::RemoteObject> value)
    {
        this->setValue("handler", value);
    }
};

/* A structure holding an RGBA color. */
// Type originally was named 'RGBA'.
class Rgba : public InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        RSet = 1 << 0,
        GSet = 1 << 1,
        BSet = 1 << 2,
        AllFieldsSet = (RSet | GSet | BSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*Rgba*/InspectorObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class Rgba;
    public:

        Builder<STATE | RSet>& setR(int value)
        {
            COMPILE_ASSERT(!(STATE & RSet), property_r_already_set);
            m_result->setNumber("r", value);
            return castState<RSet>();
        }

        Builder<STATE | GSet>& setG(int value)
        {
            COMPILE_ASSERT(!(STATE & GSet), property_g_already_set);
            m_result->setNumber("g", value);
            return castState<GSet>();
        }

        Builder<STATE | BSet>& setB(int value)
        {
            COMPILE_ASSERT(!(STATE & BSet), property_b_already_set);
            m_result->setNumber("b", value);
            return castState<BSet>();
        }

        operator RefPtr<Rgba>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(Rgba) == sizeof(InspectorObject), cannot_cast);
            return *reinterpret_cast<RefPtr<Rgba>*>(&m_result);
        }

        PassRefPtr<Rgba> release()
        {
            return RefPtr<Rgba>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<Rgba> result = Rgba::create()
     *     .setR(...)
     *     .setG(...)
     *     .setB(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;

    void setA(double value)
    {
        this->setNumber("a", value);
    }
};

/* Configuration data for the highlighting of page elements. */
class HighlightConfig : public InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        AllFieldsSet = 0
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*HighlightConfig*/InspectorObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class HighlightConfig;
    public:

        operator RefPtr<HighlightConfig>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(HighlightConfig) == sizeof(InspectorObject), cannot_cast);
            return *reinterpret_cast<RefPtr<HighlightConfig>*>(&m_result);
        }

        PassRefPtr<HighlightConfig> release()
        {
            return RefPtr<HighlightConfig>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<HighlightConfig> result = HighlightConfig::create();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;

    void setShowInfo(bool value)
    {
        this->setBoolean("showInfo", value);
    }

    void setContentColor(PassRefPtr<TypeBuilder::DOM::Rgba> value)
    {
        this->setValue("contentColor", value);
    }

    void setPaddingColor(PassRefPtr<TypeBuilder::DOM::Rgba> value)
    {
        this->setValue("paddingColor", value);
    }

    void setBorderColor(PassRefPtr<TypeBuilder::DOM::Rgba> value)
    {
        this->setValue("borderColor", value);
    }

    void setMarginColor(PassRefPtr<TypeBuilder::DOM::Rgba> value)
    {
        this->setValue("marginColor", value);
    }
};

} // DOM

namespace CSS {
/* This object identifies a CSS style in a unique way. */
class CSSStyleId : public InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        StyleSheetIdSet = 1 << 0,
        OrdinalSet = 1 << 1,
        AllFieldsSet = (StyleSheetIdSet | OrdinalSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*CSSStyleId*/InspectorObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class CSSStyleId;
    public:

        Builder<STATE | StyleSheetIdSet>& setStyleSheetId(const TypeBuilder::CSS::StyleSheetId& value)
        {
            COMPILE_ASSERT(!(STATE & StyleSheetIdSet), property_styleSheetId_already_set);
            m_result->setString("styleSheetId", value);
            return castState<StyleSheetIdSet>();
        }

        Builder<STATE | OrdinalSet>& setOrdinal(int value)
        {
            COMPILE_ASSERT(!(STATE & OrdinalSet), property_ordinal_already_set);
            m_result->setNumber("ordinal", value);
            return castState<OrdinalSet>();
        }

        operator RefPtr<CSSStyleId>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(CSSStyleId) == sizeof(InspectorObject), cannot_cast);
            return *reinterpret_cast<RefPtr<CSSStyleId>*>(&m_result);
        }

        PassRefPtr<CSSStyleId> release()
        {
            return RefPtr<CSSStyleId>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<CSSStyleId> result = CSSStyleId::create()
     *     .setStyleSheetId(...)
     *     .setOrdinal(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;
};

/* Stylesheet type: "user" for user stylesheets, "user-agent" for user-agent stylesheets, "inspector" for stylesheets created by the inspector (i.e. those holding the "via inspector" rules), "regular" for regular stylesheets. */
struct StyleSheetOrigin {
    enum Enum {
        User = 51,
        User_agent = 52,
        Inspector = 53,
        Regular = 54,
    };
}; // struct StyleSheetOrigin

/* This object identifies a CSS rule in a unique way. */
class CSSRuleId : public InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        StyleSheetIdSet = 1 << 0,
        OrdinalSet = 1 << 1,
        AllFieldsSet = (StyleSheetIdSet | OrdinalSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*CSSRuleId*/InspectorObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class CSSRuleId;
    public:

        Builder<STATE | StyleSheetIdSet>& setStyleSheetId(const TypeBuilder::CSS::StyleSheetId& value)
        {
            COMPILE_ASSERT(!(STATE & StyleSheetIdSet), property_styleSheetId_already_set);
            m_result->setString("styleSheetId", value);
            return castState<StyleSheetIdSet>();
        }

        Builder<STATE | OrdinalSet>& setOrdinal(int value)
        {
            COMPILE_ASSERT(!(STATE & OrdinalSet), property_ordinal_already_set);
            m_result->setNumber("ordinal", value);
            return castState<OrdinalSet>();
        }

        operator RefPtr<CSSRuleId>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(CSSRuleId) == sizeof(InspectorObject), cannot_cast);
            return *reinterpret_cast<RefPtr<CSSRuleId>*>(&m_result);
        }

        PassRefPtr<CSSRuleId> release()
        {
            return RefPtr<CSSRuleId>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<CSSRuleId> result = CSSRuleId::create()
     *     .setStyleSheetId(...)
     *     .setOrdinal(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;
};

/* CSS rule collection for a single pseudo style. */
class PseudoIdMatches : public InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        PseudoIdSet = 1 << 0,
        MatchesSet = 1 << 1,
        AllFieldsSet = (PseudoIdSet | MatchesSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*PseudoIdMatches*/InspectorObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class PseudoIdMatches;
    public:

        Builder<STATE | PseudoIdSet>& setPseudoId(int value)
        {
            COMPILE_ASSERT(!(STATE & PseudoIdSet), property_pseudoId_already_set);
            m_result->setNumber("pseudoId", value);
            return castState<PseudoIdSet>();
        }

        Builder<STATE | MatchesSet>& setMatches(PassRefPtr<TypeBuilder::Array<TypeBuilder::CSS::RuleMatch> > value)
        {
            COMPILE_ASSERT(!(STATE & MatchesSet), property_matches_already_set);
            m_result->setValue("matches", value);
            return castState<MatchesSet>();
        }

        operator RefPtr<PseudoIdMatches>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(PseudoIdMatches) == sizeof(InspectorObject), cannot_cast);
            return *reinterpret_cast<RefPtr<PseudoIdMatches>*>(&m_result);
        }

        PassRefPtr<PseudoIdMatches> release()
        {
            return RefPtr<PseudoIdMatches>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<PseudoIdMatches> result = PseudoIdMatches::create()
     *     .setPseudoId(...)
     *     .setMatches(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;
};

/* CSS rule collection for a single pseudo style. */
class InheritedStyleEntry : public InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        MatchedCSSRulesSet = 1 << 0,
        AllFieldsSet = (MatchedCSSRulesSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*InheritedStyleEntry*/InspectorObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class InheritedStyleEntry;
    public:

        Builder<STATE | MatchedCSSRulesSet>& setMatchedCSSRules(PassRefPtr<TypeBuilder::Array<TypeBuilder::CSS::RuleMatch> > value)
        {
            COMPILE_ASSERT(!(STATE & MatchedCSSRulesSet), property_matchedCSSRules_already_set);
            m_result->setValue("matchedCSSRules", value);
            return castState<MatchedCSSRulesSet>();
        }

        operator RefPtr<InheritedStyleEntry>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(InheritedStyleEntry) == sizeof(InspectorObject), cannot_cast);
            return *reinterpret_cast<RefPtr<InheritedStyleEntry>*>(&m_result);
        }

        PassRefPtr<InheritedStyleEntry> release()
        {
            return RefPtr<InheritedStyleEntry>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<InheritedStyleEntry> result = InheritedStyleEntry::create()
     *     .setMatchedCSSRules(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;

    void setInlineStyle(PassRefPtr<TypeBuilder::CSS::CSSStyle> value)
    {
        this->setValue("inlineStyle", value);
    }
};

/* Match data for a CSS rule. */
class RuleMatch : public InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        RuleSet = 1 << 0,
        MatchingSelectorsSet = 1 << 1,
        AllFieldsSet = (RuleSet | MatchingSelectorsSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*RuleMatch*/InspectorObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class RuleMatch;
    public:

        Builder<STATE | RuleSet>& setRule(PassRefPtr<TypeBuilder::CSS::CSSRule> value)
        {
            COMPILE_ASSERT(!(STATE & RuleSet), property_rule_already_set);
            m_result->setValue("rule", value);
            return castState<RuleSet>();
        }

        Builder<STATE | MatchingSelectorsSet>& setMatchingSelectors(PassRefPtr<TypeBuilder::Array<int> > value)
        {
            COMPILE_ASSERT(!(STATE & MatchingSelectorsSet), property_matchingSelectors_already_set);
            m_result->setValue("matchingSelectors", value);
            return castState<MatchingSelectorsSet>();
        }

        operator RefPtr<RuleMatch>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(RuleMatch) == sizeof(InspectorObject), cannot_cast);
            return *reinterpret_cast<RefPtr<RuleMatch>*>(&m_result);
        }

        PassRefPtr<RuleMatch> release()
        {
            return RefPtr<RuleMatch>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<RuleMatch> result = RuleMatch::create()
     *     .setRule(...)
     *     .setMatchingSelectors(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;
};

/* Selector list data. */
class SelectorList : public InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        SelectorsSet = 1 << 0,
        TextSet = 1 << 1,
        AllFieldsSet = (SelectorsSet | TextSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*SelectorList*/InspectorObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class SelectorList;
    public:

        Builder<STATE | SelectorsSet>& setSelectors(PassRefPtr<TypeBuilder::Array<String> > value)
        {
            COMPILE_ASSERT(!(STATE & SelectorsSet), property_selectors_already_set);
            m_result->setValue("selectors", value);
            return castState<SelectorsSet>();
        }

        Builder<STATE | TextSet>& setText(const String& value)
        {
            COMPILE_ASSERT(!(STATE & TextSet), property_text_already_set);
            m_result->setString("text", value);
            return castState<TextSet>();
        }

        operator RefPtr<SelectorList>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(SelectorList) == sizeof(InspectorObject), cannot_cast);
            return *reinterpret_cast<RefPtr<SelectorList>*>(&m_result);
        }

        PassRefPtr<SelectorList> release()
        {
            return RefPtr<SelectorList>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<SelectorList> result = SelectorList::create()
     *     .setSelectors(...)
     *     .setText(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;

    void setRange(PassRefPtr<TypeBuilder::CSS::SourceRange> value)
    {
        this->setValue("range", value);
    }
};

/* CSS style information for a DOM style attribute. */
class CSSStyleAttribute : public InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        NameSet = 1 << 0,
        StyleSet = 1 << 1,
        AllFieldsSet = (NameSet | StyleSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*CSSStyleAttribute*/InspectorObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class CSSStyleAttribute;
    public:

        Builder<STATE | NameSet>& setName(const String& value)
        {
            COMPILE_ASSERT(!(STATE & NameSet), property_name_already_set);
            m_result->setString("name", value);
            return castState<NameSet>();
        }

        Builder<STATE | StyleSet>& setStyle(PassRefPtr<TypeBuilder::CSS::CSSStyle> value)
        {
            COMPILE_ASSERT(!(STATE & StyleSet), property_style_already_set);
            m_result->setValue("style", value);
            return castState<StyleSet>();
        }

        operator RefPtr<CSSStyleAttribute>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(CSSStyleAttribute) == sizeof(InspectorObject), cannot_cast);
            return *reinterpret_cast<RefPtr<CSSStyleAttribute>*>(&m_result);
        }

        PassRefPtr<CSSStyleAttribute> release()
        {
            return RefPtr<CSSStyleAttribute>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<CSSStyleAttribute> result = CSSStyleAttribute::create()
     *     .setName(...)
     *     .setStyle(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;
};

/* CSS stylesheet metainformation. */
class CSSStyleSheetHeader : public InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        StyleSheetIdSet = 1 << 0,
        FrameIdSet = 1 << 1,
        SourceURLSet = 1 << 2,
        OriginSet = 1 << 3,
        TitleSet = 1 << 4,
        DisabledSet = 1 << 5,
        AllFieldsSet = (StyleSheetIdSet | FrameIdSet | SourceURLSet | OriginSet | TitleSet | DisabledSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*CSSStyleSheetHeader*/InspectorObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class CSSStyleSheetHeader;
    public:

        Builder<STATE | StyleSheetIdSet>& setStyleSheetId(const TypeBuilder::CSS::StyleSheetId& value)
        {
            COMPILE_ASSERT(!(STATE & StyleSheetIdSet), property_styleSheetId_already_set);
            m_result->setString("styleSheetId", value);
            return castState<StyleSheetIdSet>();
        }

        Builder<STATE | FrameIdSet>& setFrameId(const TypeBuilder::Network::FrameId& value)
        {
            COMPILE_ASSERT(!(STATE & FrameIdSet), property_frameId_already_set);
            m_result->setString("frameId", value);
            return castState<FrameIdSet>();
        }

        Builder<STATE | SourceURLSet>& setSourceURL(const String& value)
        {
            COMPILE_ASSERT(!(STATE & SourceURLSet), property_sourceURL_already_set);
            m_result->setString("sourceURL", value);
            return castState<SourceURLSet>();
        }

        Builder<STATE | OriginSet>& setOrigin(TypeBuilder::CSS::StyleSheetOrigin::Enum value)
        {
            COMPILE_ASSERT(!(STATE & OriginSet), property_origin_already_set);
            m_result->setString("origin", TypeBuilder::getEnumConstantValue(value));
            return castState<OriginSet>();
        }

        Builder<STATE | TitleSet>& setTitle(const String& value)
        {
            COMPILE_ASSERT(!(STATE & TitleSet), property_title_already_set);
            m_result->setString("title", value);
            return castState<TitleSet>();
        }

        Builder<STATE | DisabledSet>& setDisabled(bool value)
        {
            COMPILE_ASSERT(!(STATE & DisabledSet), property_disabled_already_set);
            m_result->setBoolean("disabled", value);
            return castState<DisabledSet>();
        }

        operator RefPtr<CSSStyleSheetHeader>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(CSSStyleSheetHeader) == sizeof(InspectorObject), cannot_cast);
            return *reinterpret_cast<RefPtr<CSSStyleSheetHeader>*>(&m_result);
        }

        PassRefPtr<CSSStyleSheetHeader> release()
        {
            return RefPtr<CSSStyleSheetHeader>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<CSSStyleSheetHeader> result = CSSStyleSheetHeader::create()
     *     .setStyleSheetId(...)
     *     .setFrameId(...)
     *     .setSourceURL(...)
     *     .setOrigin(...)
     *     .setTitle(...)
     *     .setDisabled(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;
};

/* CSS stylesheet contents. */
class CSSStyleSheetBody : public InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        StyleSheetIdSet = 1 << 0,
        RulesSet = 1 << 1,
        AllFieldsSet = (StyleSheetIdSet | RulesSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*CSSStyleSheetBody*/InspectorObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class CSSStyleSheetBody;
    public:

        Builder<STATE | StyleSheetIdSet>& setStyleSheetId(const TypeBuilder::CSS::StyleSheetId& value)
        {
            COMPILE_ASSERT(!(STATE & StyleSheetIdSet), property_styleSheetId_already_set);
            m_result->setString("styleSheetId", value);
            return castState<StyleSheetIdSet>();
        }

        Builder<STATE | RulesSet>& setRules(PassRefPtr<TypeBuilder::Array<TypeBuilder::CSS::CSSRule> > value)
        {
            COMPILE_ASSERT(!(STATE & RulesSet), property_rules_already_set);
            m_result->setValue("rules", value);
            return castState<RulesSet>();
        }

        operator RefPtr<CSSStyleSheetBody>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(CSSStyleSheetBody) == sizeof(InspectorObject), cannot_cast);
            return *reinterpret_cast<RefPtr<CSSStyleSheetBody>*>(&m_result);
        }

        PassRefPtr<CSSStyleSheetBody> release()
        {
            return RefPtr<CSSStyleSheetBody>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<CSSStyleSheetBody> result = CSSStyleSheetBody::create()
     *     .setStyleSheetId(...)
     *     .setRules(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;

    void setText(const String& value)
    {
        this->setString("text", value);
    }
};

/* CSS rule representation. */
class CSSRule : public InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        SelectorListSet = 1 << 0,
        SourceLineSet = 1 << 1,
        OriginSet = 1 << 2,
        StyleSet = 1 << 3,
        AllFieldsSet = (SelectorListSet | SourceLineSet | OriginSet | StyleSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*CSSRule*/InspectorObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class CSSRule;
    public:

        Builder<STATE | SelectorListSet>& setSelectorList(PassRefPtr<TypeBuilder::CSS::SelectorList> value)
        {
            COMPILE_ASSERT(!(STATE & SelectorListSet), property_selectorList_already_set);
            m_result->setValue("selectorList", value);
            return castState<SelectorListSet>();
        }

        Builder<STATE | SourceLineSet>& setSourceLine(int value)
        {
            COMPILE_ASSERT(!(STATE & SourceLineSet), property_sourceLine_already_set);
            m_result->setNumber("sourceLine", value);
            return castState<SourceLineSet>();
        }

        Builder<STATE | OriginSet>& setOrigin(TypeBuilder::CSS::StyleSheetOrigin::Enum value)
        {
            COMPILE_ASSERT(!(STATE & OriginSet), property_origin_already_set);
            m_result->setString("origin", TypeBuilder::getEnumConstantValue(value));
            return castState<OriginSet>();
        }

        Builder<STATE | StyleSet>& setStyle(PassRefPtr<TypeBuilder::CSS::CSSStyle> value)
        {
            COMPILE_ASSERT(!(STATE & StyleSet), property_style_already_set);
            m_result->setValue("style", value);
            return castState<StyleSet>();
        }

        operator RefPtr<CSSRule>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(CSSRule) == sizeof(InspectorObject), cannot_cast);
            return *reinterpret_cast<RefPtr<CSSRule>*>(&m_result);
        }

        PassRefPtr<CSSRule> release()
        {
            return RefPtr<CSSRule>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<CSSRule> result = CSSRule::create()
     *     .setSelectorList(...)
     *     .setSourceLine(...)
     *     .setOrigin(...)
     *     .setStyle(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;

    void setRuleId(PassRefPtr<TypeBuilder::CSS::CSSRuleId> value)
    {
        this->setValue("ruleId", value);
    }

    void setSourceURL(const String& value)
    {
        this->setString("sourceURL", value);
    }

    void setMedia(PassRefPtr<TypeBuilder::Array<TypeBuilder::CSS::CSSMedia> > value)
    {
        this->setValue("media", value);
    }
};

/* Text range within a resource. */
class SourceRange : public InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        StartLineSet = 1 << 0,
        StartColumnSet = 1 << 1,
        EndLineSet = 1 << 2,
        EndColumnSet = 1 << 3,
        AllFieldsSet = (StartLineSet | StartColumnSet | EndLineSet | EndColumnSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*SourceRange*/InspectorObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class SourceRange;
    public:

        Builder<STATE | StartLineSet>& setStartLine(int value)
        {
            COMPILE_ASSERT(!(STATE & StartLineSet), property_startLine_already_set);
            m_result->setNumber("startLine", value);
            return castState<StartLineSet>();
        }

        Builder<STATE | StartColumnSet>& setStartColumn(int value)
        {
            COMPILE_ASSERT(!(STATE & StartColumnSet), property_startColumn_already_set);
            m_result->setNumber("startColumn", value);
            return castState<StartColumnSet>();
        }

        Builder<STATE | EndLineSet>& setEndLine(int value)
        {
            COMPILE_ASSERT(!(STATE & EndLineSet), property_endLine_already_set);
            m_result->setNumber("endLine", value);
            return castState<EndLineSet>();
        }

        Builder<STATE | EndColumnSet>& setEndColumn(int value)
        {
            COMPILE_ASSERT(!(STATE & EndColumnSet), property_endColumn_already_set);
            m_result->setNumber("endColumn", value);
            return castState<EndColumnSet>();
        }

        operator RefPtr<SourceRange>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(SourceRange) == sizeof(InspectorObject), cannot_cast);
            return *reinterpret_cast<RefPtr<SourceRange>*>(&m_result);
        }

        PassRefPtr<SourceRange> release()
        {
            return RefPtr<SourceRange>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<SourceRange> result = SourceRange::create()
     *     .setStartLine(...)
     *     .setStartColumn(...)
     *     .setEndLine(...)
     *     .setEndColumn(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;
};

class ShorthandEntry : public InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        NameSet = 1 << 0,
        ValueSet = 1 << 1,
        AllFieldsSet = (NameSet | ValueSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*ShorthandEntry*/InspectorObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class ShorthandEntry;
    public:

        Builder<STATE | NameSet>& setName(const String& value)
        {
            COMPILE_ASSERT(!(STATE & NameSet), property_name_already_set);
            m_result->setString("name", value);
            return castState<NameSet>();
        }

        Builder<STATE | ValueSet>& setValue(const String& value)
        {
            COMPILE_ASSERT(!(STATE & ValueSet), property_value_already_set);
            m_result->setString("value", value);
            return castState<ValueSet>();
        }

        operator RefPtr<ShorthandEntry>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(ShorthandEntry) == sizeof(InspectorObject), cannot_cast);
            return *reinterpret_cast<RefPtr<ShorthandEntry>*>(&m_result);
        }

        PassRefPtr<ShorthandEntry> release()
        {
            return RefPtr<ShorthandEntry>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<ShorthandEntry> result = ShorthandEntry::create()
     *     .setName(...)
     *     .setValue(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;
};

class CSSPropertyInfo : public InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        NameSet = 1 << 0,
        AllFieldsSet = (NameSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*CSSPropertyInfo*/InspectorObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class CSSPropertyInfo;
    public:

        Builder<STATE | NameSet>& setName(const String& value)
        {
            COMPILE_ASSERT(!(STATE & NameSet), property_name_already_set);
            m_result->setString("name", value);
            return castState<NameSet>();
        }

        operator RefPtr<CSSPropertyInfo>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(CSSPropertyInfo) == sizeof(InspectorObject), cannot_cast);
            return *reinterpret_cast<RefPtr<CSSPropertyInfo>*>(&m_result);
        }

        PassRefPtr<CSSPropertyInfo> release()
        {
            return RefPtr<CSSPropertyInfo>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<CSSPropertyInfo> result = CSSPropertyInfo::create()
     *     .setName(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;

    void setLonghands(PassRefPtr<TypeBuilder::Array<String> > value)
    {
        this->setValue("longhands", value);
    }
};

class CSSComputedStyleProperty : public InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        NameSet = 1 << 0,
        ValueSet = 1 << 1,
        AllFieldsSet = (NameSet | ValueSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*CSSComputedStyleProperty*/InspectorObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class CSSComputedStyleProperty;
    public:

        Builder<STATE | NameSet>& setName(const String& value)
        {
            COMPILE_ASSERT(!(STATE & NameSet), property_name_already_set);
            m_result->setString("name", value);
            return castState<NameSet>();
        }

        Builder<STATE | ValueSet>& setValue(const String& value)
        {
            COMPILE_ASSERT(!(STATE & ValueSet), property_value_already_set);
            m_result->setString("value", value);
            return castState<ValueSet>();
        }

        operator RefPtr<CSSComputedStyleProperty>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(CSSComputedStyleProperty) == sizeof(InspectorObject), cannot_cast);
            return *reinterpret_cast<RefPtr<CSSComputedStyleProperty>*>(&m_result);
        }

        PassRefPtr<CSSComputedStyleProperty> release()
        {
            return RefPtr<CSSComputedStyleProperty>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<CSSComputedStyleProperty> result = CSSComputedStyleProperty::create()
     *     .setName(...)
     *     .setValue(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;
};

/* CSS style representation. */
class CSSStyle : public InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        CssPropertiesSet = 1 << 0,
        ShorthandEntriesSet = 1 << 1,
        AllFieldsSet = (CssPropertiesSet | ShorthandEntriesSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*CSSStyle*/InspectorObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class CSSStyle;
    public:

        Builder<STATE | CssPropertiesSet>& setCssProperties(PassRefPtr<TypeBuilder::Array<TypeBuilder::CSS::CSSProperty> > value)
        {
            COMPILE_ASSERT(!(STATE & CssPropertiesSet), property_cssProperties_already_set);
            m_result->setValue("cssProperties", value);
            return castState<CssPropertiesSet>();
        }

        Builder<STATE | ShorthandEntriesSet>& setShorthandEntries(PassRefPtr<TypeBuilder::Array<TypeBuilder::CSS::ShorthandEntry> > value)
        {
            COMPILE_ASSERT(!(STATE & ShorthandEntriesSet), property_shorthandEntries_already_set);
            m_result->setValue("shorthandEntries", value);
            return castState<ShorthandEntriesSet>();
        }

        operator RefPtr<CSSStyle>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(CSSStyle) == sizeof(InspectorObject), cannot_cast);
            return *reinterpret_cast<RefPtr<CSSStyle>*>(&m_result);
        }

        PassRefPtr<CSSStyle> release()
        {
            return RefPtr<CSSStyle>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<CSSStyle> result = CSSStyle::create()
     *     .setCssProperties(...)
     *     .setShorthandEntries(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;

    void setStyleId(PassRefPtr<TypeBuilder::CSS::CSSStyleId> value)
    {
        this->setValue("styleId", value);
    }

    void setCssText(const String& value)
    {
        this->setString("cssText", value);
    }

    void setRange(PassRefPtr<TypeBuilder::CSS::SourceRange> value)
    {
        this->setValue("range", value);
    }

    void setWidth(const String& value)
    {
        this->setString("width", value);
    }

    void setHeight(const String& value)
    {
        this->setString("height", value);
    }
};

/* CSS style effective visual dimensions and source offsets. */
class CSSProperty : public InspectorObject {
public:
    // Named after property name 'status' while generating CSSProperty.
    struct Status {
        enum Enum {
            Active = 55,
            Inactive = 56,
            Disabled = 57,
            Style = 58,
        };
    }; // struct Status

    enum {
        NoFieldsSet = 0,
        NameSet = 1 << 0,
        ValueSet = 1 << 1,
        AllFieldsSet = (NameSet | ValueSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*CSSProperty*/InspectorObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class CSSProperty;
    public:

        Builder<STATE | NameSet>& setName(const String& value)
        {
            COMPILE_ASSERT(!(STATE & NameSet), property_name_already_set);
            m_result->setString("name", value);
            return castState<NameSet>();
        }

        Builder<STATE | ValueSet>& setValue(const String& value)
        {
            COMPILE_ASSERT(!(STATE & ValueSet), property_value_already_set);
            m_result->setString("value", value);
            return castState<ValueSet>();
        }

        operator RefPtr<CSSProperty>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(CSSProperty) == sizeof(InspectorObject), cannot_cast);
            return *reinterpret_cast<RefPtr<CSSProperty>*>(&m_result);
        }

        PassRefPtr<CSSProperty> release()
        {
            return RefPtr<CSSProperty>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<CSSProperty> result = CSSProperty::create()
     *     .setName(...)
     *     .setValue(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;

    void setPriority(const String& value)
    {
        this->setString("priority", value);
    }

    void setImplicit(bool value)
    {
        this->setBoolean("implicit", value);
    }

    void setText(const String& value)
    {
        this->setString("text", value);
    }

    void setParsedOk(bool value)
    {
        this->setBoolean("parsedOk", value);
    }

    void setStatus(Status::Enum value)
    {
        this->setString("status", TypeBuilder::getEnumConstantValue(value));
    }

    void setRange(PassRefPtr<TypeBuilder::CSS::SourceRange> value)
    {
        this->setValue("range", value);
    }

    // Property names for type generated as open.
    static const char* Name;
    static const char* Value;
    static const char* Priority;
    static const char* Implicit;
    static const char* Text;
    static const char* ParsedOk;
    static const char* Status;
    static const char* Range;
};

/* CSS media query descriptor. */
class CSSMedia : public InspectorObjectBase {
public:
    // Named after property name 'source' while generating CSSMedia.
    struct Source {
        enum Enum {
            MediaRule = 59,
            ImportRule = 60,
            LinkedSheet = 61,
            InlineSheet = 62,
        };
    }; // struct Source

    enum {
        NoFieldsSet = 0,
        TextSet = 1 << 0,
        SourceSet = 1 << 1,
        AllFieldsSet = (TextSet | SourceSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*CSSMedia*/InspectorObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class CSSMedia;
    public:

        Builder<STATE | TextSet>& setText(const String& value)
        {
            COMPILE_ASSERT(!(STATE & TextSet), property_text_already_set);
            m_result->setString("text", value);
            return castState<TextSet>();
        }

        Builder<STATE | SourceSet>& setSource(Source::Enum value)
        {
            COMPILE_ASSERT(!(STATE & SourceSet), property_source_already_set);
            m_result->setString("source", TypeBuilder::getEnumConstantValue(value));
            return castState<SourceSet>();
        }

        operator RefPtr<CSSMedia>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(CSSMedia) == sizeof(InspectorObject), cannot_cast);
            return *reinterpret_cast<RefPtr<CSSMedia>*>(&m_result);
        }

        PassRefPtr<CSSMedia> release()
        {
            return RefPtr<CSSMedia>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<CSSMedia> result = CSSMedia::create()
     *     .setText(...)
     *     .setSource(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;

    void setSourceURL(const String& value)
    {
        this->setString("sourceURL", value);
    }

    void setSourceLine(int value)
    {
        this->setNumber("sourceLine", value);
    }
};

/* CSS selector profile entry. */
class SelectorProfileEntry : public InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        SelectorSet = 1 << 0,
        UrlSet = 1 << 1,
        LineNumberSet = 1 << 2,
        TimeSet = 1 << 3,
        HitCountSet = 1 << 4,
        MatchCountSet = 1 << 5,
        AllFieldsSet = (SelectorSet | UrlSet | LineNumberSet | TimeSet | HitCountSet | MatchCountSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*SelectorProfileEntry*/InspectorObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class SelectorProfileEntry;
    public:

        Builder<STATE | SelectorSet>& setSelector(const String& value)
        {
            COMPILE_ASSERT(!(STATE & SelectorSet), property_selector_already_set);
            m_result->setString("selector", value);
            return castState<SelectorSet>();
        }

        Builder<STATE | UrlSet>& setUrl(const String& value)
        {
            COMPILE_ASSERT(!(STATE & UrlSet), property_url_already_set);
            m_result->setString("url", value);
            return castState<UrlSet>();
        }

        Builder<STATE | LineNumberSet>& setLineNumber(int value)
        {
            COMPILE_ASSERT(!(STATE & LineNumberSet), property_lineNumber_already_set);
            m_result->setNumber("lineNumber", value);
            return castState<LineNumberSet>();
        }

        Builder<STATE | TimeSet>& setTime(double value)
        {
            COMPILE_ASSERT(!(STATE & TimeSet), property_time_already_set);
            m_result->setNumber("time", value);
            return castState<TimeSet>();
        }

        Builder<STATE | HitCountSet>& setHitCount(int value)
        {
            COMPILE_ASSERT(!(STATE & HitCountSet), property_hitCount_already_set);
            m_result->setNumber("hitCount", value);
            return castState<HitCountSet>();
        }

        Builder<STATE | MatchCountSet>& setMatchCount(int value)
        {
            COMPILE_ASSERT(!(STATE & MatchCountSet), property_matchCount_already_set);
            m_result->setNumber("matchCount", value);
            return castState<MatchCountSet>();
        }

        operator RefPtr<SelectorProfileEntry>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(SelectorProfileEntry) == sizeof(InspectorObject), cannot_cast);
            return *reinterpret_cast<RefPtr<SelectorProfileEntry>*>(&m_result);
        }

        PassRefPtr<SelectorProfileEntry> release()
        {
            return RefPtr<SelectorProfileEntry>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<SelectorProfileEntry> result = SelectorProfileEntry::create()
     *     .setSelector(...)
     *     .setUrl(...)
     *     .setLineNumber(...)
     *     .setTime(...)
     *     .setHitCount(...)
     *     .setMatchCount(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;
};

class SelectorProfile : public InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        TotalTimeSet = 1 << 0,
        DataSet = 1 << 1,
        AllFieldsSet = (TotalTimeSet | DataSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*SelectorProfile*/InspectorObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class SelectorProfile;
    public:

        Builder<STATE | TotalTimeSet>& setTotalTime(double value)
        {
            COMPILE_ASSERT(!(STATE & TotalTimeSet), property_totalTime_already_set);
            m_result->setNumber("totalTime", value);
            return castState<TotalTimeSet>();
        }

        Builder<STATE | DataSet>& setData(PassRefPtr<TypeBuilder::Array<TypeBuilder::CSS::SelectorProfileEntry> > value)
        {
            COMPILE_ASSERT(!(STATE & DataSet), property_data_already_set);
            m_result->setValue("data", value);
            return castState<DataSet>();
        }

        operator RefPtr<SelectorProfile>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(SelectorProfile) == sizeof(InspectorObject), cannot_cast);
            return *reinterpret_cast<RefPtr<SelectorProfile>*>(&m_result);
        }

        PassRefPtr<SelectorProfile> release()
        {
            return RefPtr<SelectorProfile>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<SelectorProfile> result = SelectorProfile::create()
     *     .setTotalTime(...)
     *     .setData(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;
};

/* This object represents a region that flows from a Named Flow. */
class Region : public InspectorObjectBase {
public:
    // Named after property name 'regionOverset' while generating Region.
    struct RegionOverset {
        enum Enum {
            Overset = 63,
            Fit = 64,
            Empty = 65,
        };
    }; // struct RegionOverset

    enum {
        NoFieldsSet = 0,
        RegionOversetSet = 1 << 0,
        NodeIdSet = 1 << 1,
        AllFieldsSet = (RegionOversetSet | NodeIdSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*Region*/InspectorObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class Region;
    public:

        Builder<STATE | RegionOversetSet>& setRegionOverset(RegionOverset::Enum value)
        {
            COMPILE_ASSERT(!(STATE & RegionOversetSet), property_regionOverset_already_set);
            m_result->setString("regionOverset", TypeBuilder::getEnumConstantValue(value));
            return castState<RegionOversetSet>();
        }

        Builder<STATE | NodeIdSet>& setNodeId(int value)
        {
            COMPILE_ASSERT(!(STATE & NodeIdSet), property_nodeId_already_set);
            m_result->setNumber("nodeId", value);
            return castState<NodeIdSet>();
        }

        operator RefPtr<Region>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(Region) == sizeof(InspectorObject), cannot_cast);
            return *reinterpret_cast<RefPtr<Region>*>(&m_result);
        }

        PassRefPtr<Region> release()
        {
            return RefPtr<Region>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<Region> result = Region::create()
     *     .setRegionOverset(...)
     *     .setNodeId(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;
};

/* This object represents a Named Flow. */
class NamedFlow : public InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        DocumentNodeIdSet = 1 << 0,
        NameSet = 1 << 1,
        OversetSet = 1 << 2,
        ContentSet = 1 << 3,
        RegionsSet = 1 << 4,
        AllFieldsSet = (DocumentNodeIdSet | NameSet | OversetSet | ContentSet | RegionsSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*NamedFlow*/InspectorObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class NamedFlow;
    public:

        Builder<STATE | DocumentNodeIdSet>& setDocumentNodeId(int value)
        {
            COMPILE_ASSERT(!(STATE & DocumentNodeIdSet), property_documentNodeId_already_set);
            m_result->setNumber("documentNodeId", value);
            return castState<DocumentNodeIdSet>();
        }

        Builder<STATE | NameSet>& setName(const String& value)
        {
            COMPILE_ASSERT(!(STATE & NameSet), property_name_already_set);
            m_result->setString("name", value);
            return castState<NameSet>();
        }

        Builder<STATE | OversetSet>& setOverset(bool value)
        {
            COMPILE_ASSERT(!(STATE & OversetSet), property_overset_already_set);
            m_result->setBoolean("overset", value);
            return castState<OversetSet>();
        }

        Builder<STATE | ContentSet>& setContent(PassRefPtr<TypeBuilder::Array<int> > value)
        {
            COMPILE_ASSERT(!(STATE & ContentSet), property_content_already_set);
            m_result->setValue("content", value);
            return castState<ContentSet>();
        }

        Builder<STATE | RegionsSet>& setRegions(PassRefPtr<TypeBuilder::Array<TypeBuilder::CSS::Region> > value)
        {
            COMPILE_ASSERT(!(STATE & RegionsSet), property_regions_already_set);
            m_result->setValue("regions", value);
            return castState<RegionsSet>();
        }

        operator RefPtr<NamedFlow>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(NamedFlow) == sizeof(InspectorObject), cannot_cast);
            return *reinterpret_cast<RefPtr<NamedFlow>*>(&m_result);
        }

        PassRefPtr<NamedFlow> release()
        {
            return RefPtr<NamedFlow>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<NamedFlow> result = NamedFlow::create()
     *     .setDocumentNodeId(...)
     *     .setName(...)
     *     .setOverset(...)
     *     .setContent(...)
     *     .setRegions(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;
};

} // CSS

namespace Timeline {
/* Current values of DOM counters. */
class DOMCounters : public InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        DocumentsSet = 1 << 0,
        NodesSet = 1 << 1,
        JsEventListenersSet = 1 << 2,
        AllFieldsSet = (DocumentsSet | NodesSet | JsEventListenersSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*DOMCounters*/InspectorObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class DOMCounters;
    public:

        Builder<STATE | DocumentsSet>& setDocuments(int value)
        {
            COMPILE_ASSERT(!(STATE & DocumentsSet), property_documents_already_set);
            m_result->setNumber("documents", value);
            return castState<DocumentsSet>();
        }

        Builder<STATE | NodesSet>& setNodes(int value)
        {
            COMPILE_ASSERT(!(STATE & NodesSet), property_nodes_already_set);
            m_result->setNumber("nodes", value);
            return castState<NodesSet>();
        }

        Builder<STATE | JsEventListenersSet>& setJsEventListeners(int value)
        {
            COMPILE_ASSERT(!(STATE & JsEventListenersSet), property_jsEventListeners_already_set);
            m_result->setNumber("jsEventListeners", value);
            return castState<JsEventListenersSet>();
        }

        operator RefPtr<DOMCounters>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(DOMCounters) == sizeof(InspectorObject), cannot_cast);
            return *reinterpret_cast<RefPtr<DOMCounters>*>(&m_result);
        }

        PassRefPtr<DOMCounters> release()
        {
            return RefPtr<DOMCounters>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<DOMCounters> result = DOMCounters::create()
     *     .setDocuments(...)
     *     .setNodes(...)
     *     .setJsEventListeners(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;
#if !ASSERT_DISABLED
    static void assertCorrectValue(InspectorValue* value);
#endif  // !ASSERT_DISABLED
};

/* Timeline record contains information about the recorded activity. */
class TimelineEvent : public InspectorObject {
public:
    enum {
        NoFieldsSet = 0,
        TypeSet = 1 << 0,
        DataSet = 1 << 1,
        AllFieldsSet = (TypeSet | DataSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*TimelineEvent*/InspectorObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class TimelineEvent;
    public:

        Builder<STATE | TypeSet>& setType(const String& value)
        {
            COMPILE_ASSERT(!(STATE & TypeSet), property_type_already_set);
            m_result->setString("type", value);
            return castState<TypeSet>();
        }

        Builder<STATE | DataSet>& setData(PassRefPtr<InspectorObject> value)
        {
            COMPILE_ASSERT(!(STATE & DataSet), property_data_already_set);
            m_result->setValue("data", value);
            return castState<DataSet>();
        }

        operator RefPtr<TimelineEvent>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(TimelineEvent) == sizeof(InspectorObject), cannot_cast);
            return *reinterpret_cast<RefPtr<TimelineEvent>*>(&m_result);
        }

        PassRefPtr<TimelineEvent> release()
        {
            return RefPtr<TimelineEvent>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<TimelineEvent> result = TimelineEvent::create()
     *     .setType(...)
     *     .setData(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;

    void setThread(const String& value)
    {
        this->setString("thread", value);
    }

    void setChildren(PassRefPtr<TypeBuilder::Array<TypeBuilder::Timeline::TimelineEvent> > value)
    {
        this->setValue("children", value);
    }

    void setCounters(PassRefPtr<TypeBuilder::Timeline::DOMCounters> value)
    {
        this->setValue("counters", value);
    }

    void setUsedHeapSize(int value)
    {
        this->setNumber("usedHeapSize", value);
    }

    void setNativeHeapStatistics(PassRefPtr<InspectorObject> value)
    {
        this->setValue("nativeHeapStatistics", value);
    }
    static PassRefPtr<TimelineEvent> runtimeCast(PassRefPtr<InspectorValue> value)
    {
        RefPtr<InspectorObject> object;
        bool castRes = value->asObject(&object);
        ASSERT_UNUSED(castRes, castRes);
#if !ASSERT_DISABLED
        assertCorrectValue(object.get());
#endif  // !ASSERT_DISABLED
        COMPILE_ASSERT(sizeof(TimelineEvent) == sizeof(InspectorObjectBase), type_cast_problem);
        return static_cast<TimelineEvent*>(static_cast<InspectorObjectBase*>(object.get()));
    }

#if !ASSERT_DISABLED
    static void assertCorrectValue(InspectorValue* value);
#endif  // !ASSERT_DISABLED

    // Property names for type generated as open.
    static const char* Type;
    static const char* Data;
    static const char* Thread;
    static const char* Children;
    static const char* Counters;
    static const char* UsedHeapSize;
    static const char* NativeHeapStatistics;
};

} // Timeline

#if ENABLE(JAVASCRIPT_DEBUGGER)
namespace Debugger {
/* Location in the source code. */
class Location : public InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        ScriptIdSet = 1 << 0,
        LineNumberSet = 1 << 1,
        AllFieldsSet = (ScriptIdSet | LineNumberSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*Location*/InspectorObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class Location;
    public:

        Builder<STATE | ScriptIdSet>& setScriptId(const TypeBuilder::Debugger::ScriptId& value)
        {
            COMPILE_ASSERT(!(STATE & ScriptIdSet), property_scriptId_already_set);
            m_result->setString("scriptId", value);
            return castState<ScriptIdSet>();
        }

        Builder<STATE | LineNumberSet>& setLineNumber(int value)
        {
            COMPILE_ASSERT(!(STATE & LineNumberSet), property_lineNumber_already_set);
            m_result->setNumber("lineNumber", value);
            return castState<LineNumberSet>();
        }

        operator RefPtr<Location>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(Location) == sizeof(InspectorObject), cannot_cast);
            return *reinterpret_cast<RefPtr<Location>*>(&m_result);
        }

        PassRefPtr<Location> release()
        {
            return RefPtr<Location>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<Location> result = Location::create()
     *     .setScriptId(...)
     *     .setLineNumber(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;

    void setColumnNumber(int value)
    {
        this->setNumber("columnNumber", value);
    }
#if !ASSERT_DISABLED
    static void assertCorrectValue(InspectorValue* value);
#endif  // !ASSERT_DISABLED
};

/* Information about the function. */
class FunctionDetails : public InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        LocationSet = 1 << 0,
        AllFieldsSet = (LocationSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*FunctionDetails*/InspectorObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class FunctionDetails;
    public:

        Builder<STATE | LocationSet>& setLocation(PassRefPtr<TypeBuilder::Debugger::Location> value)
        {
            COMPILE_ASSERT(!(STATE & LocationSet), property_location_already_set);
            m_result->setValue("location", value);
            return castState<LocationSet>();
        }

        operator RefPtr<FunctionDetails>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(FunctionDetails) == sizeof(InspectorObject), cannot_cast);
            return *reinterpret_cast<RefPtr<FunctionDetails>*>(&m_result);
        }

        PassRefPtr<FunctionDetails> release()
        {
            return RefPtr<FunctionDetails>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<FunctionDetails> result = FunctionDetails::create()
     *     .setLocation(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;

    void setName(const String& value)
    {
        this->setString("name", value);
    }

    void setDisplayName(const String& value)
    {
        this->setString("displayName", value);
    }

    void setInferredName(const String& value)
    {
        this->setString("inferredName", value);
    }

    void setScopeChain(PassRefPtr<TypeBuilder::Array<TypeBuilder::Debugger::Scope> > value)
    {
        this->setValue("scopeChain", value);
    }
    static PassRefPtr<FunctionDetails> runtimeCast(PassRefPtr<InspectorValue> value)
    {
        RefPtr<InspectorObject> object;
        bool castRes = value->asObject(&object);
        ASSERT_UNUSED(castRes, castRes);
#if !ASSERT_DISABLED
        assertCorrectValue(object.get());
#endif  // !ASSERT_DISABLED
        COMPILE_ASSERT(sizeof(FunctionDetails) == sizeof(InspectorObjectBase), type_cast_problem);
        return static_cast<FunctionDetails*>(static_cast<InspectorObjectBase*>(object.get()));
    }

#if !ASSERT_DISABLED
    static void assertCorrectValue(InspectorValue* value);
#endif  // !ASSERT_DISABLED
};

/* JavaScript call frame. Array of call frames form the call stack. */
class CallFrame : public InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        CallFrameIdSet = 1 << 0,
        FunctionNameSet = 1 << 1,
        LocationSet = 1 << 2,
        ScopeChainSet = 1 << 3,
        ThisSet = 1 << 4,
        AllFieldsSet = (CallFrameIdSet | FunctionNameSet | LocationSet | ScopeChainSet | ThisSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*CallFrame*/InspectorObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class CallFrame;
    public:

        Builder<STATE | CallFrameIdSet>& setCallFrameId(const TypeBuilder::Debugger::CallFrameId& value)
        {
            COMPILE_ASSERT(!(STATE & CallFrameIdSet), property_callFrameId_already_set);
            m_result->setString("callFrameId", value);
            return castState<CallFrameIdSet>();
        }

        Builder<STATE | FunctionNameSet>& setFunctionName(const String& value)
        {
            COMPILE_ASSERT(!(STATE & FunctionNameSet), property_functionName_already_set);
            m_result->setString("functionName", value);
            return castState<FunctionNameSet>();
        }

        Builder<STATE | LocationSet>& setLocation(PassRefPtr<TypeBuilder::Debugger::Location> value)
        {
            COMPILE_ASSERT(!(STATE & LocationSet), property_location_already_set);
            m_result->setValue("location", value);
            return castState<LocationSet>();
        }

        Builder<STATE | ScopeChainSet>& setScopeChain(PassRefPtr<TypeBuilder::Array<TypeBuilder::Debugger::Scope> > value)
        {
            COMPILE_ASSERT(!(STATE & ScopeChainSet), property_scopeChain_already_set);
            m_result->setValue("scopeChain", value);
            return castState<ScopeChainSet>();
        }

        Builder<STATE | ThisSet>& setThis(PassRefPtr<TypeBuilder::Runtime::RemoteObject> value)
        {
            COMPILE_ASSERT(!(STATE & ThisSet), property_this_already_set);
            m_result->setValue("this", value);
            return castState<ThisSet>();
        }

        operator RefPtr<CallFrame>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(CallFrame) == sizeof(InspectorObject), cannot_cast);
            return *reinterpret_cast<RefPtr<CallFrame>*>(&m_result);
        }

        PassRefPtr<CallFrame> release()
        {
            return RefPtr<CallFrame>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<CallFrame> result = CallFrame::create()
     *     .setCallFrameId(...)
     *     .setFunctionName(...)
     *     .setLocation(...)
     *     .setScopeChain(...)
     *     .setThis(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;
    static PassRefPtr<CallFrame> runtimeCast(PassRefPtr<InspectorValue> value)
    {
        RefPtr<InspectorObject> object;
        bool castRes = value->asObject(&object);
        ASSERT_UNUSED(castRes, castRes);
#if !ASSERT_DISABLED
        assertCorrectValue(object.get());
#endif  // !ASSERT_DISABLED
        COMPILE_ASSERT(sizeof(CallFrame) == sizeof(InspectorObjectBase), type_cast_problem);
        return static_cast<CallFrame*>(static_cast<InspectorObjectBase*>(object.get()));
    }

#if !ASSERT_DISABLED
    static void assertCorrectValue(InspectorValue* value);
#endif  // !ASSERT_DISABLED
};

/* Scope description. */
class Scope : public InspectorObjectBase {
public:
    // Named after property name 'type' while generating Scope.
    struct Type {
        enum Enum {
            Global = 66,
            Local = 67,
            With = 68,
            Closure = 69,
            Catch = 70,
        };
#if !ASSERT_DISABLED
        static void assertCorrectValue(InspectorValue* value);
#endif  // !ASSERT_DISABLED
    }; // struct Type

    enum {
        NoFieldsSet = 0,
        TypeSet = 1 << 0,
        ObjectSet = 1 << 1,
        AllFieldsSet = (TypeSet | ObjectSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*Scope*/InspectorObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class Scope;
    public:

        Builder<STATE | TypeSet>& setType(Type::Enum value)
        {
            COMPILE_ASSERT(!(STATE & TypeSet), property_type_already_set);
            m_result->setString("type", TypeBuilder::getEnumConstantValue(value));
            return castState<TypeSet>();
        }

        Builder<STATE | ObjectSet>& setObject(PassRefPtr<TypeBuilder::Runtime::RemoteObject> value)
        {
            COMPILE_ASSERT(!(STATE & ObjectSet), property_object_already_set);
            m_result->setValue("object", value);
            return castState<ObjectSet>();
        }

        operator RefPtr<Scope>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(Scope) == sizeof(InspectorObject), cannot_cast);
            return *reinterpret_cast<RefPtr<Scope>*>(&m_result);
        }

        PassRefPtr<Scope> release()
        {
            return RefPtr<Scope>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<Scope> result = Scope::create()
     *     .setType(...)
     *     .setObject(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;
#if !ASSERT_DISABLED
    static void assertCorrectValue(InspectorValue* value);
#endif  // !ASSERT_DISABLED
};

} // Debugger

#endif // ENABLE(JAVASCRIPT_DEBUGGER)
#if ENABLE(JAVASCRIPT_DEBUGGER)
namespace DOMDebugger {
/* DOM breakpoint type. */
struct DOMBreakpointType {
    enum Enum {
        Subtree_modified = 71,
        Attribute_modified = 72,
        Node_removed = 73,
    };
}; // struct DOMBreakpointType

} // DOMDebugger

#endif // ENABLE(JAVASCRIPT_DEBUGGER)
#if ENABLE(JAVASCRIPT_DEBUGGER)
namespace Profiler {
/* Profile header. */
class ProfileHeader : public InspectorObjectBase {
public:
    // Named after property name 'typeId' while generating ProfileHeader.
    struct TypeId {
        enum Enum {
            CPU = 74,
            CSS = 75,
            HEAP = 76,
        };
    }; // struct TypeId

    enum {
        NoFieldsSet = 0,
        TypeIdSet = 1 << 0,
        TitleSet = 1 << 1,
        UidSet = 1 << 2,
        AllFieldsSet = (TypeIdSet | TitleSet | UidSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*ProfileHeader*/InspectorObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class ProfileHeader;
    public:

        Builder<STATE | TypeIdSet>& setTypeId(TypeId::Enum value)
        {
            COMPILE_ASSERT(!(STATE & TypeIdSet), property_typeId_already_set);
            m_result->setString("typeId", TypeBuilder::getEnumConstantValue(value));
            return castState<TypeIdSet>();
        }

        Builder<STATE | TitleSet>& setTitle(const String& value)
        {
            COMPILE_ASSERT(!(STATE & TitleSet), property_title_already_set);
            m_result->setString("title", value);
            return castState<TitleSet>();
        }

        Builder<STATE | UidSet>& setUid(int value)
        {
            COMPILE_ASSERT(!(STATE & UidSet), property_uid_already_set);
            m_result->setNumber("uid", value);
            return castState<UidSet>();
        }

        operator RefPtr<ProfileHeader>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(ProfileHeader) == sizeof(InspectorObject), cannot_cast);
            return *reinterpret_cast<RefPtr<ProfileHeader>*>(&m_result);
        }

        PassRefPtr<ProfileHeader> release()
        {
            return RefPtr<ProfileHeader>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<ProfileHeader> result = ProfileHeader::create()
     *     .setTypeId(...)
     *     .setTitle(...)
     *     .setUid(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;

    void setMaxJSObjectId(int value)
    {
        this->setNumber("maxJSObjectId", value);
    }
};

/* CPU Profile node. Holds callsite information, execution statistics and child nodes. */
class CPUProfileNode : public InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        FunctionNameSet = 1 << 0,
        UrlSet = 1 << 1,
        LineNumberSet = 1 << 2,
        TotalTimeSet = 1 << 3,
        SelfTimeSet = 1 << 4,
        NumberOfCallsSet = 1 << 5,
        VisibleSet = 1 << 6,
        CallUIDSet = 1 << 7,
        ChildrenSet = 1 << 8,
        AllFieldsSet = (FunctionNameSet | UrlSet | LineNumberSet | TotalTimeSet | SelfTimeSet | NumberOfCallsSet | VisibleSet | CallUIDSet | ChildrenSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*CPUProfileNode*/InspectorObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class CPUProfileNode;
    public:

        Builder<STATE | FunctionNameSet>& setFunctionName(const String& value)
        {
            COMPILE_ASSERT(!(STATE & FunctionNameSet), property_functionName_already_set);
            m_result->setString("functionName", value);
            return castState<FunctionNameSet>();
        }

        Builder<STATE | UrlSet>& setUrl(const String& value)
        {
            COMPILE_ASSERT(!(STATE & UrlSet), property_url_already_set);
            m_result->setString("url", value);
            return castState<UrlSet>();
        }

        Builder<STATE | LineNumberSet>& setLineNumber(int value)
        {
            COMPILE_ASSERT(!(STATE & LineNumberSet), property_lineNumber_already_set);
            m_result->setNumber("lineNumber", value);
            return castState<LineNumberSet>();
        }

        Builder<STATE | TotalTimeSet>& setTotalTime(double value)
        {
            COMPILE_ASSERT(!(STATE & TotalTimeSet), property_totalTime_already_set);
            m_result->setNumber("totalTime", value);
            return castState<TotalTimeSet>();
        }

        Builder<STATE | SelfTimeSet>& setSelfTime(double value)
        {
            COMPILE_ASSERT(!(STATE & SelfTimeSet), property_selfTime_already_set);
            m_result->setNumber("selfTime", value);
            return castState<SelfTimeSet>();
        }

        Builder<STATE | NumberOfCallsSet>& setNumberOfCalls(int value)
        {
            COMPILE_ASSERT(!(STATE & NumberOfCallsSet), property_numberOfCalls_already_set);
            m_result->setNumber("numberOfCalls", value);
            return castState<NumberOfCallsSet>();
        }

        Builder<STATE | VisibleSet>& setVisible(bool value)
        {
            COMPILE_ASSERT(!(STATE & VisibleSet), property_visible_already_set);
            m_result->setBoolean("visible", value);
            return castState<VisibleSet>();
        }

        Builder<STATE | CallUIDSet>& setCallUID(double value)
        {
            COMPILE_ASSERT(!(STATE & CallUIDSet), property_callUID_already_set);
            m_result->setNumber("callUID", value);
            return castState<CallUIDSet>();
        }

        Builder<STATE | ChildrenSet>& setChildren(PassRefPtr<TypeBuilder::Array<TypeBuilder::Profiler::CPUProfileNode> > value)
        {
            COMPILE_ASSERT(!(STATE & ChildrenSet), property_children_already_set);
            m_result->setValue("children", value);
            return castState<ChildrenSet>();
        }

        operator RefPtr<CPUProfileNode>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(CPUProfileNode) == sizeof(InspectorObject), cannot_cast);
            return *reinterpret_cast<RefPtr<CPUProfileNode>*>(&m_result);
        }

        PassRefPtr<CPUProfileNode> release()
        {
            return RefPtr<CPUProfileNode>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<CPUProfileNode> result = CPUProfileNode::create()
     *     .setFunctionName(...)
     *     .setUrl(...)
     *     .setLineNumber(...)
     *     .setTotalTime(...)
     *     .setSelfTime(...)
     *     .setNumberOfCalls(...)
     *     .setVisible(...)
     *     .setCallUID(...)
     *     .setChildren(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;

    void setId(int value)
    {
        this->setNumber("id", value);
    }
};

/* Profile. */
class CPUProfile : public InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        AllFieldsSet = 0
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*CPUProfile*/InspectorObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class CPUProfile;
    public:

        operator RefPtr<CPUProfile>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(CPUProfile) == sizeof(InspectorObject), cannot_cast);
            return *reinterpret_cast<RefPtr<CPUProfile>*>(&m_result);
        }

        PassRefPtr<CPUProfile> release()
        {
            return RefPtr<CPUProfile>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<CPUProfile> result = CPUProfile::create();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;

    void setHead(PassRefPtr<TypeBuilder::Profiler::CPUProfileNode> value)
    {
        this->setValue("head", value);
    }

    void setIdleTime(double value)
    {
        this->setNumber("idleTime", value);
    }

    void setSamples(PassRefPtr<TypeBuilder::Array<int> > value)
    {
        this->setValue("samples", value);
    }
};

} // Profiler

#endif // ENABLE(JAVASCRIPT_DEBUGGER)
namespace HeapProfiler {
/* Profile header. */
class ProfileHeader : public InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        TitleSet = 1 << 0,
        UidSet = 1 << 1,
        AllFieldsSet = (TitleSet | UidSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*ProfileHeader*/InspectorObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class ProfileHeader;
    public:

        Builder<STATE | TitleSet>& setTitle(const String& value)
        {
            COMPILE_ASSERT(!(STATE & TitleSet), property_title_already_set);
            m_result->setString("title", value);
            return castState<TitleSet>();
        }

        Builder<STATE | UidSet>& setUid(int value)
        {
            COMPILE_ASSERT(!(STATE & UidSet), property_uid_already_set);
            m_result->setNumber("uid", value);
            return castState<UidSet>();
        }

        operator RefPtr<ProfileHeader>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(ProfileHeader) == sizeof(InspectorObject), cannot_cast);
            return *reinterpret_cast<RefPtr<ProfileHeader>*>(&m_result);
        }

        PassRefPtr<ProfileHeader> release()
        {
            return RefPtr<ProfileHeader>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<ProfileHeader> result = ProfileHeader::create()
     *     .setTitle(...)
     *     .setUid(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;

    void setMaxJSObjectId(int value)
    {
        this->setNumber("maxJSObjectId", value);
    }
};

} // HeapProfiler

namespace Canvas {
class ResourceInfo : public InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        IdSet = 1 << 0,
        DescriptionSet = 1 << 1,
        AllFieldsSet = (IdSet | DescriptionSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*ResourceInfo*/InspectorObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class ResourceInfo;
    public:

        Builder<STATE | IdSet>& setId(const TypeBuilder::Canvas::ResourceId& value)
        {
            COMPILE_ASSERT(!(STATE & IdSet), property_id_already_set);
            m_result->setString("id", value);
            return castState<IdSet>();
        }

        Builder<STATE | DescriptionSet>& setDescription(const String& value)
        {
            COMPILE_ASSERT(!(STATE & DescriptionSet), property_description_already_set);
            m_result->setString("description", value);
            return castState<DescriptionSet>();
        }

        operator RefPtr<ResourceInfo>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(ResourceInfo) == sizeof(InspectorObject), cannot_cast);
            return *reinterpret_cast<RefPtr<ResourceInfo>*>(&m_result);
        }

        PassRefPtr<ResourceInfo> release()
        {
            return RefPtr<ResourceInfo>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<ResourceInfo> result = ResourceInfo::create()
     *     .setId(...)
     *     .setDescription(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;
    static PassRefPtr<ResourceInfo> runtimeCast(PassRefPtr<InspectorValue> value)
    {
        RefPtr<InspectorObject> object;
        bool castRes = value->asObject(&object);
        ASSERT_UNUSED(castRes, castRes);
#if !ASSERT_DISABLED
        assertCorrectValue(object.get());
#endif  // !ASSERT_DISABLED
        COMPILE_ASSERT(sizeof(ResourceInfo) == sizeof(InspectorObjectBase), type_cast_problem);
        return static_cast<ResourceInfo*>(static_cast<InspectorObjectBase*>(object.get()));
    }

#if !ASSERT_DISABLED
    static void assertCorrectValue(InspectorValue* value);
#endif  // !ASSERT_DISABLED
};

class ResourceState : public InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        IdSet = 1 << 0,
        TraceLogIdSet = 1 << 1,
        AllFieldsSet = (IdSet | TraceLogIdSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*ResourceState*/InspectorObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class ResourceState;
    public:

        Builder<STATE | IdSet>& setId(const TypeBuilder::Canvas::ResourceId& value)
        {
            COMPILE_ASSERT(!(STATE & IdSet), property_id_already_set);
            m_result->setString("id", value);
            return castState<IdSet>();
        }

        Builder<STATE | TraceLogIdSet>& setTraceLogId(const TypeBuilder::Canvas::TraceLogId& value)
        {
            COMPILE_ASSERT(!(STATE & TraceLogIdSet), property_traceLogId_already_set);
            m_result->setString("traceLogId", value);
            return castState<TraceLogIdSet>();
        }

        operator RefPtr<ResourceState>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(ResourceState) == sizeof(InspectorObject), cannot_cast);
            return *reinterpret_cast<RefPtr<ResourceState>*>(&m_result);
        }

        PassRefPtr<ResourceState> release()
        {
            return RefPtr<ResourceState>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<ResourceState> result = ResourceState::create()
     *     .setId(...)
     *     .setTraceLogId(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;

    void setImageURL(const String& value)
    {
        this->setString("imageURL", value);
    }
    static PassRefPtr<ResourceState> runtimeCast(PassRefPtr<InspectorValue> value)
    {
        RefPtr<InspectorObject> object;
        bool castRes = value->asObject(&object);
        ASSERT_UNUSED(castRes, castRes);
#if !ASSERT_DISABLED
        assertCorrectValue(object.get());
#endif  // !ASSERT_DISABLED
        COMPILE_ASSERT(sizeof(ResourceState) == sizeof(InspectorObjectBase), type_cast_problem);
        return static_cast<ResourceState*>(static_cast<InspectorObjectBase*>(object.get()));
    }

#if !ASSERT_DISABLED
    static void assertCorrectValue(InspectorValue* value);
#endif  // !ASSERT_DISABLED
};

class CallArgument : public InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        DescriptionSet = 1 << 0,
        AllFieldsSet = (DescriptionSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*CallArgument*/InspectorObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class CallArgument;
    public:

        Builder<STATE | DescriptionSet>& setDescription(const String& value)
        {
            COMPILE_ASSERT(!(STATE & DescriptionSet), property_description_already_set);
            m_result->setString("description", value);
            return castState<DescriptionSet>();
        }

        operator RefPtr<CallArgument>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(CallArgument) == sizeof(InspectorObject), cannot_cast);
            return *reinterpret_cast<RefPtr<CallArgument>*>(&m_result);
        }

        PassRefPtr<CallArgument> release()
        {
            return RefPtr<CallArgument>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<CallArgument> result = CallArgument::create()
     *     .setDescription(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;
#if !ASSERT_DISABLED
    static void assertCorrectValue(InspectorValue* value);
#endif  // !ASSERT_DISABLED
};

class Call : public InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        ContextIdSet = 1 << 0,
        AllFieldsSet = (ContextIdSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*Call*/InspectorObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class Call;
    public:

        Builder<STATE | ContextIdSet>& setContextId(const TypeBuilder::Canvas::ResourceId& value)
        {
            COMPILE_ASSERT(!(STATE & ContextIdSet), property_contextId_already_set);
            m_result->setString("contextId", value);
            return castState<ContextIdSet>();
        }

        operator RefPtr<Call>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(Call) == sizeof(InspectorObject), cannot_cast);
            return *reinterpret_cast<RefPtr<Call>*>(&m_result);
        }

        PassRefPtr<Call> release()
        {
            return RefPtr<Call>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<Call> result = Call::create()
     *     .setContextId(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;

    void setFunctionName(const String& value)
    {
        this->setString("functionName", value);
    }

    void setArguments(PassRefPtr<TypeBuilder::Array<TypeBuilder::Canvas::CallArgument> > value)
    {
        this->setValue("arguments", value);
    }

    void setResult(PassRefPtr<TypeBuilder::Canvas::CallArgument> value)
    {
        this->setValue("result", value);
    }

    void setIsDrawingCall(bool value)
    {
        this->setBoolean("isDrawingCall", value);
    }

    void setIsFrameEndCall(bool value)
    {
        this->setBoolean("isFrameEndCall", value);
    }

    void setProperty(const String& value)
    {
        this->setString("property", value);
    }

    void setValue(PassRefPtr<TypeBuilder::Canvas::CallArgument> value)
    {
        this->setValue("value", value);
    }
    using InspectorObjectBase::setValue;


    void setSourceURL(const String& value)
    {
        this->setString("sourceURL", value);
    }

    void setLineNumber(int value)
    {
        this->setNumber("lineNumber", value);
    }

    void setColumnNumber(int value)
    {
        this->setNumber("columnNumber", value);
    }
#if !ASSERT_DISABLED
    static void assertCorrectValue(InspectorValue* value);
#endif  // !ASSERT_DISABLED
};

class TraceLog : public InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        IdSet = 1 << 0,
        CallsSet = 1 << 1,
        StartOffsetSet = 1 << 2,
        AliveSet = 1 << 3,
        TotalAvailableCallsSet = 1 << 4,
        AllFieldsSet = (IdSet | CallsSet | StartOffsetSet | AliveSet | TotalAvailableCallsSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*TraceLog*/InspectorObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class TraceLog;
    public:

        Builder<STATE | IdSet>& setId(const TypeBuilder::Canvas::TraceLogId& value)
        {
            COMPILE_ASSERT(!(STATE & IdSet), property_id_already_set);
            m_result->setString("id", value);
            return castState<IdSet>();
        }

        Builder<STATE | CallsSet>& setCalls(PassRefPtr<TypeBuilder::Array<TypeBuilder::Canvas::Call> > value)
        {
            COMPILE_ASSERT(!(STATE & CallsSet), property_calls_already_set);
            m_result->setValue("calls", value);
            return castState<CallsSet>();
        }

        Builder<STATE | StartOffsetSet>& setStartOffset(int value)
        {
            COMPILE_ASSERT(!(STATE & StartOffsetSet), property_startOffset_already_set);
            m_result->setNumber("startOffset", value);
            return castState<StartOffsetSet>();
        }

        Builder<STATE | AliveSet>& setAlive(bool value)
        {
            COMPILE_ASSERT(!(STATE & AliveSet), property_alive_already_set);
            m_result->setBoolean("alive", value);
            return castState<AliveSet>();
        }

        Builder<STATE | TotalAvailableCallsSet>& setTotalAvailableCalls(double value)
        {
            COMPILE_ASSERT(!(STATE & TotalAvailableCallsSet), property_totalAvailableCalls_already_set);
            m_result->setNumber("totalAvailableCalls", value);
            return castState<TotalAvailableCallsSet>();
        }

        operator RefPtr<TraceLog>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(TraceLog) == sizeof(InspectorObject), cannot_cast);
            return *reinterpret_cast<RefPtr<TraceLog>*>(&m_result);
        }

        PassRefPtr<TraceLog> release()
        {
            return RefPtr<TraceLog>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<TraceLog> result = TraceLog::create()
     *     .setId(...)
     *     .setCalls(...)
     *     .setStartOffset(...)
     *     .setAlive(...)
     *     .setTotalAvailableCalls(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;
    static PassRefPtr<TraceLog> runtimeCast(PassRefPtr<InspectorValue> value)
    {
        RefPtr<InspectorObject> object;
        bool castRes = value->asObject(&object);
        ASSERT_UNUSED(castRes, castRes);
#if !ASSERT_DISABLED
        assertCorrectValue(object.get());
#endif  // !ASSERT_DISABLED
        COMPILE_ASSERT(sizeof(TraceLog) == sizeof(InspectorObjectBase), type_cast_problem);
        return static_cast<TraceLog*>(static_cast<InspectorObjectBase*>(object.get()));
    }

#if !ASSERT_DISABLED
    static void assertCorrectValue(InspectorValue* value);
#endif  // !ASSERT_DISABLED
};

} // Canvas

namespace LayerTree {
/* A rectangle. */
class IntRect : public InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        XSet = 1 << 0,
        YSet = 1 << 1,
        WidthSet = 1 << 2,
        HeightSet = 1 << 3,
        AllFieldsSet = (XSet | YSet | WidthSet | HeightSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*IntRect*/InspectorObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class IntRect;
    public:

        Builder<STATE | XSet>& setX(int value)
        {
            COMPILE_ASSERT(!(STATE & XSet), property_x_already_set);
            m_result->setNumber("x", value);
            return castState<XSet>();
        }

        Builder<STATE | YSet>& setY(int value)
        {
            COMPILE_ASSERT(!(STATE & YSet), property_y_already_set);
            m_result->setNumber("y", value);
            return castState<YSet>();
        }

        Builder<STATE | WidthSet>& setWidth(int value)
        {
            COMPILE_ASSERT(!(STATE & WidthSet), property_width_already_set);
            m_result->setNumber("width", value);
            return castState<WidthSet>();
        }

        Builder<STATE | HeightSet>& setHeight(int value)
        {
            COMPILE_ASSERT(!(STATE & HeightSet), property_height_already_set);
            m_result->setNumber("height", value);
            return castState<HeightSet>();
        }

        operator RefPtr<IntRect>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(IntRect) == sizeof(InspectorObject), cannot_cast);
            return *reinterpret_cast<RefPtr<IntRect>*>(&m_result);
        }

        PassRefPtr<IntRect> release()
        {
            return RefPtr<IntRect>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<IntRect> result = IntRect::create()
     *     .setX(...)
     *     .setY(...)
     *     .setWidth(...)
     *     .setHeight(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;
};

/* Information about a compositing layer. */
class Layer : public InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        LayerIdSet = 1 << 0,
        NodeIdSet = 1 << 1,
        BoundsSet = 1 << 2,
        PaintCountSet = 1 << 3,
        MemorySet = 1 << 4,
        CompositedBoundsSet = 1 << 5,
        AllFieldsSet = (LayerIdSet | NodeIdSet | BoundsSet | PaintCountSet | MemorySet | CompositedBoundsSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*Layer*/InspectorObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class Layer;
    public:

        Builder<STATE | LayerIdSet>& setLayerId(const TypeBuilder::LayerTree::LayerId& value)
        {
            COMPILE_ASSERT(!(STATE & LayerIdSet), property_layerId_already_set);
            m_result->setString("layerId", value);
            return castState<LayerIdSet>();
        }

        Builder<STATE | NodeIdSet>& setNodeId(int value)
        {
            COMPILE_ASSERT(!(STATE & NodeIdSet), property_nodeId_already_set);
            m_result->setNumber("nodeId", value);
            return castState<NodeIdSet>();
        }

        Builder<STATE | BoundsSet>& setBounds(PassRefPtr<TypeBuilder::LayerTree::IntRect> value)
        {
            COMPILE_ASSERT(!(STATE & BoundsSet), property_bounds_already_set);
            m_result->setValue("bounds", value);
            return castState<BoundsSet>();
        }

        Builder<STATE | PaintCountSet>& setPaintCount(int value)
        {
            COMPILE_ASSERT(!(STATE & PaintCountSet), property_paintCount_already_set);
            m_result->setNumber("paintCount", value);
            return castState<PaintCountSet>();
        }

        Builder<STATE | MemorySet>& setMemory(int value)
        {
            COMPILE_ASSERT(!(STATE & MemorySet), property_memory_already_set);
            m_result->setNumber("memory", value);
            return castState<MemorySet>();
        }

        Builder<STATE | CompositedBoundsSet>& setCompositedBounds(PassRefPtr<TypeBuilder::LayerTree::IntRect> value)
        {
            COMPILE_ASSERT(!(STATE & CompositedBoundsSet), property_compositedBounds_already_set);
            m_result->setValue("compositedBounds", value);
            return castState<CompositedBoundsSet>();
        }

        operator RefPtr<Layer>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(Layer) == sizeof(InspectorObject), cannot_cast);
            return *reinterpret_cast<RefPtr<Layer>*>(&m_result);
        }

        PassRefPtr<Layer> release()
        {
            return RefPtr<Layer>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<Layer> result = Layer::create()
     *     .setLayerId(...)
     *     .setNodeId(...)
     *     .setBounds(...)
     *     .setPaintCount(...)
     *     .setMemory(...)
     *     .setCompositedBounds(...);
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;

    void setIsInShadowTree(bool value)
    {
        this->setBoolean("isInShadowTree", value);
    }

    void setIsReflection(bool value)
    {
        this->setBoolean("isReflection", value);
    }

    void setIsGeneratedContent(bool value)
    {
        this->setBoolean("isGeneratedContent", value);
    }

    void setIsAnonymous(bool value)
    {
        this->setBoolean("isAnonymous", value);
    }

    void setPseudoElementId(const TypeBuilder::LayerTree::PseudoElementId& value)
    {
        this->setString("pseudoElementId", value);
    }

    void setPseudoElement(const String& value)
    {
        this->setString("pseudoElement", value);
    }
};

/* An object containing the reasons why the layer was composited as properties. */
class CompositingReasons : public InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        AllFieldsSet = 0
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(PassRefPtr</*CompositingReasons*/InspectorObject> ptr)
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
            m_result = ptr;
        }
        friend class CompositingReasons;
    public:

        operator RefPtr<CompositingReasons>& ()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(CompositingReasons) == sizeof(InspectorObject), cannot_cast);
            return *reinterpret_cast<RefPtr<CompositingReasons>*>(&m_result);
        }

        PassRefPtr<CompositingReasons> release()
        {
            return RefPtr<CompositingReasons>(*this).release();
        }
    };

    /*
     * Synthetic constructor:
     * RefPtr<CompositingReasons> result = CompositingReasons::create();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }
    typedef TypeBuilder::StructItemTraits ItemTraits;

    void setTransform3D(bool value)
    {
        this->setBoolean("transform3D", value);
    }

    void setVideo(bool value)
    {
        this->setBoolean("video", value);
    }

    void setCanvas(bool value)
    {
        this->setBoolean("canvas", value);
    }

    void setPlugin(bool value)
    {
        this->setBoolean("plugin", value);
    }

    void setIFrame(bool value)
    {
        this->setBoolean("iFrame", value);
    }

    void setBackfaceVisibilityHidden(bool value)
    {
        this->setBoolean("backfaceVisibilityHidden", value);
    }

    void setClipsCompositingDescendants(bool value)
    {
        this->setBoolean("clipsCompositingDescendants", value);
    }

    void setAnimation(bool value)
    {
        this->setBoolean("animation", value);
    }

    void setFilters(bool value)
    {
        this->setBoolean("filters", value);
    }

    void setPositionFixed(bool value)
    {
        this->setBoolean("positionFixed", value);
    }

    void setPositionSticky(bool value)
    {
        this->setBoolean("positionSticky", value);
    }

    void setOverflowScrollingTouch(bool value)
    {
        this->setBoolean("overflowScrollingTouch", value);
    }

    void setStacking(bool value)
    {
        this->setBoolean("stacking", value);
    }

    void setOverlap(bool value)
    {
        this->setBoolean("overlap", value);
    }

    void setNegativeZIndexChildren(bool value)
    {
        this->setBoolean("negativeZIndexChildren", value);
    }

    void setTransformWithCompositedDescendants(bool value)
    {
        this->setBoolean("transformWithCompositedDescendants", value);
    }

    void setOpacityWithCompositedDescendants(bool value)
    {
        this->setBoolean("opacityWithCompositedDescendants", value);
    }

    void setMaskWithCompositedDescendants(bool value)
    {
        this->setBoolean("maskWithCompositedDescendants", value);
    }

    void setReflectionWithCompositedDescendants(bool value)
    {
        this->setBoolean("reflectionWithCompositedDescendants", value);
    }

    void setFilterWithCompositedDescendants(bool value)
    {
        this->setBoolean("filterWithCompositedDescendants", value);
    }

    void setBlendingWithCompositedDescendants(bool value)
    {
        this->setBoolean("blendingWithCompositedDescendants", value);
    }

    void setPerspective(bool value)
    {
        this->setBoolean("perspective", value);
    }

    void setPreserve3D(bool value)
    {
        this->setBoolean("preserve3D", value);
    }

    void setRoot(bool value)
    {
        this->setBoolean("root", value);
    }
};

} // LayerTree


} // namespace TypeBuilder


} // namespace WebCore

#endif // ENABLE(INSPECTOR)

#endif // !defined(InspectorTypeBuilder_h)

