/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(VIDEO_TRACK)

#include "JSAudioTrackList.h"

#include "AudioTrack.h"
#include "AudioTrackList.h"
#include "Element.h"
#include "Event.h"
#include "EventListener.h"
#include "ExceptionCode.h"
#include "JSAudioTrack.h"
#include "JSDOMBinding.h"
#include "JSEvent.h"
#include "JSEventListener.h"
#include "JSNodeCustom.h"
#include <runtime/Error.h>
#include <runtime/PropertyNameArray.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSAudioTrackListTableValues[] =
{
    { "length", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAudioTrackListLength), (intptr_t)0, NoIntrinsic },
    { "onchange", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAudioTrackListOnchange), (intptr_t)setJSAudioTrackListOnchange, NoIntrinsic },
    { "onaddtrack", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAudioTrackListOnaddtrack), (intptr_t)setJSAudioTrackListOnaddtrack, NoIntrinsic },
    { "onremovetrack", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAudioTrackListOnremovetrack), (intptr_t)setJSAudioTrackListOnremovetrack, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSAudioTrackListTable = { 9, 7, JSAudioTrackListTableValues, 0 };
/* Hash table for prototype */

static const HashTableValue JSAudioTrackListPrototypeTableValues[] =
{
    { "item", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsAudioTrackListPrototypeFunctionItem), (intptr_t)1, NoIntrinsic },
    { "getTrackById", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsAudioTrackListPrototypeFunctionGetTrackById), (intptr_t)1, NoIntrinsic },
    { "addEventListener", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsAudioTrackListPrototypeFunctionAddEventListener), (intptr_t)2, NoIntrinsic },
    { "removeEventListener", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsAudioTrackListPrototypeFunctionRemoveEventListener), (intptr_t)2, NoIntrinsic },
    { "dispatchEvent", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsAudioTrackListPrototypeFunctionDispatchEvent), (intptr_t)1, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSAudioTrackListPrototypeTable = { 16, 15, JSAudioTrackListPrototypeTableValues, 0 };
const ClassInfo JSAudioTrackListPrototype::s_info = { "AudioTrackListPrototype", &Base::s_info, &JSAudioTrackListPrototypeTable, 0, CREATE_METHOD_TABLE(JSAudioTrackListPrototype) };

JSObject* JSAudioTrackListPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSAudioTrackList>(exec, globalObject);
}

bool JSAudioTrackListPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSAudioTrackListPrototype* thisObject = jsCast<JSAudioTrackListPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, &JSAudioTrackListPrototypeTable, thisObject, propertyName, slot);
}

bool JSAudioTrackListPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSAudioTrackListPrototype* thisObject = jsCast<JSAudioTrackListPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, &JSAudioTrackListPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSAudioTrackList::s_info = { "AudioTrackList", &Base::s_info, &JSAudioTrackListTable, 0 , CREATE_METHOD_TABLE(JSAudioTrackList) };

JSAudioTrackList::JSAudioTrackList(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<AudioTrackList> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSAudioTrackList::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSAudioTrackList::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSAudioTrackListPrototype::create(exec->vm(), globalObject, JSAudioTrackListPrototype::createStructure(globalObject->vm(), globalObject, globalObject->objectPrototype()));
}

void JSAudioTrackList::destroy(JSC::JSCell* cell)
{
    JSAudioTrackList* thisObject = static_cast<JSAudioTrackList*>(cell);
    thisObject->JSAudioTrackList::~JSAudioTrackList();
}

JSAudioTrackList::~JSAudioTrackList()
{
    releaseImplIfNotNull();
}

bool JSAudioTrackList::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSAudioTrackList* thisObject = jsCast<JSAudioTrackList*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    const HashEntry* entry = getStaticValueSlotEntryWithoutCaching<JSAudioTrackList>(exec, propertyName);
    if (entry) {
        slot.setCustom(thisObject, entry->propertyGetter());
        return true;
    }
    unsigned index = propertyName.asIndex();
    if (index != PropertyName::NotAnIndex && index < static_cast<AudioTrackList*>(thisObject->impl())->length()) {
        slot.setCustomIndex(thisObject, index, indexGetter);
        return true;
    }
    return getStaticValueSlot<JSAudioTrackList, Base>(exec, &JSAudioTrackListTable, thisObject, propertyName, slot);
}

bool JSAudioTrackList::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSAudioTrackList* thisObject = jsCast<JSAudioTrackList*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    const HashEntry* entry = JSAudioTrackListTable.entry(exec, propertyName);
    if (entry) {
        PropertySlot slot;
        slot.setCustom(thisObject, entry->propertyGetter());
        descriptor.setDescriptor(slot.getValue(exec, propertyName), entry->attributes());
        return true;
    }
    unsigned index = propertyName.asIndex();
    if (index != PropertyName::NotAnIndex && index < static_cast<AudioTrackList*>(thisObject->impl())->length()) {
        PropertySlot slot;
        slot.setCustomIndex(thisObject, index, indexGetter);
        descriptor.setDescriptor(slot.getValue(exec, propertyName), DontDelete | ReadOnly);
        return true;
    }
    return getStaticValueDescriptor<JSAudioTrackList, Base>(exec, &JSAudioTrackListTable, thisObject, propertyName, descriptor);
}

bool JSAudioTrackList::getOwnPropertySlotByIndex(JSCell* cell, ExecState* exec, unsigned index, PropertySlot& slot)
{
    JSAudioTrackList* thisObject = jsCast<JSAudioTrackList*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    if (index < static_cast<AudioTrackList*>(thisObject->impl())->length()) {
        slot.setCustomIndex(thisObject, index, thisObject->indexGetter);
        return true;
    }
    return Base::getOwnPropertySlotByIndex(thisObject, exec, index, slot);
}

JSValue jsAudioTrackListLength(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSAudioTrackList* castedThis = jsCast<JSAudioTrackList*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    AudioTrackList* impl = static_cast<AudioTrackList*>(castedThis->impl());
    JSValue result = jsNumber(impl->length());
    return result;
}


JSValue jsAudioTrackListOnchange(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSAudioTrackList* castedThis = jsCast<JSAudioTrackList*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    AudioTrackList* impl = static_cast<AudioTrackList*>(castedThis->impl());
    if (EventListener* listener = impl->onchange()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsAudioTrackListOnaddtrack(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSAudioTrackList* castedThis = jsCast<JSAudioTrackList*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    AudioTrackList* impl = static_cast<AudioTrackList*>(castedThis->impl());
    if (EventListener* listener = impl->onaddtrack()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsAudioTrackListOnremovetrack(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSAudioTrackList* castedThis = jsCast<JSAudioTrackList*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    AudioTrackList* impl = static_cast<AudioTrackList*>(castedThis->impl());
    if (EventListener* listener = impl->onremovetrack()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


void JSAudioTrackList::put(JSCell* cell, ExecState* exec, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    JSAudioTrackList* thisObject = jsCast<JSAudioTrackList*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    lookupPut<JSAudioTrackList, Base>(exec, propertyName, value, &JSAudioTrackListTable, thisObject, slot);
}

void setJSAudioTrackListOnchange(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSAudioTrackList* castedThis = jsCast<JSAudioTrackList*>(thisObject);
    AudioTrackList* impl = static_cast<AudioTrackList*>(castedThis->impl());
    impl->setOnchange(createJSAttributeEventListener(exec, value, thisObject));
}


void setJSAudioTrackListOnaddtrack(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSAudioTrackList* castedThis = jsCast<JSAudioTrackList*>(thisObject);
    AudioTrackList* impl = static_cast<AudioTrackList*>(castedThis->impl());
    impl->setOnaddtrack(createJSAttributeEventListener(exec, value, thisObject));
}


void setJSAudioTrackListOnremovetrack(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSAudioTrackList* castedThis = jsCast<JSAudioTrackList*>(thisObject);
    AudioTrackList* impl = static_cast<AudioTrackList*>(castedThis->impl());
    impl->setOnremovetrack(createJSAttributeEventListener(exec, value, thisObject));
}


void JSAudioTrackList::getOwnPropertyNames(JSObject* object, ExecState* exec, PropertyNameArray& propertyNames, EnumerationMode mode)
{
    JSAudioTrackList* thisObject = jsCast<JSAudioTrackList*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    for (unsigned i = 0; i < static_cast<AudioTrackList*>(thisObject->impl())->length(); ++i)
        propertyNames.add(Identifier::from(exec, i));
     Base::getOwnPropertyNames(thisObject, exec, propertyNames, mode);
}

EncodedJSValue JSC_HOST_CALL jsAudioTrackListPrototypeFunctionItem(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSAudioTrackList::s_info))
        return throwVMTypeError(exec);
    JSAudioTrackList* castedThis = jsCast<JSAudioTrackList*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSAudioTrackList::s_info);
    AudioTrackList* impl = static_cast<AudioTrackList*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    unsigned index(toUInt32(exec, exec->argument(0), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->item(index)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsAudioTrackListPrototypeFunctionGetTrackById(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSAudioTrackList::s_info))
        return throwVMTypeError(exec);
    JSAudioTrackList* castedThis = jsCast<JSAudioTrackList*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSAudioTrackList::s_info);
    AudioTrackList* impl = static_cast<AudioTrackList*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    const String& id(exec->argument(0).isEmpty() ? String() : exec->argument(0).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->getTrackById(id)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsAudioTrackListPrototypeFunctionAddEventListener(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSAudioTrackList::s_info))
        return throwVMTypeError(exec);
    JSAudioTrackList* castedThis = jsCast<JSAudioTrackList*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSAudioTrackList::s_info);
    AudioTrackList* impl = static_cast<AudioTrackList*>(castedThis->impl());
    JSValue listener = exec->argument(1);
    if (!listener.isObject())
        return JSValue::encode(jsUndefined());
    impl->addEventListener(exec->argument(0).toString(exec)->value(exec), JSEventListener::create(asObject(listener), castedThis, false, currentWorld(exec)), exec->argument(2).toBoolean(exec));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsAudioTrackListPrototypeFunctionRemoveEventListener(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSAudioTrackList::s_info))
        return throwVMTypeError(exec);
    JSAudioTrackList* castedThis = jsCast<JSAudioTrackList*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSAudioTrackList::s_info);
    AudioTrackList* impl = static_cast<AudioTrackList*>(castedThis->impl());
    JSValue listener = exec->argument(1);
    if (!listener.isObject())
        return JSValue::encode(jsUndefined());
    impl->removeEventListener(exec->argument(0).toString(exec)->value(exec), JSEventListener::create(asObject(listener), castedThis, false, currentWorld(exec)).get(), exec->argument(2).toBoolean(exec));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsAudioTrackListPrototypeFunctionDispatchEvent(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSAudioTrackList::s_info))
        return throwVMTypeError(exec);
    JSAudioTrackList* castedThis = jsCast<JSAudioTrackList*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSAudioTrackList::s_info);
    AudioTrackList* impl = static_cast<AudioTrackList*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Event* evt(toEvent(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsBoolean(impl->dispatchEvent(evt, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}


JSValue JSAudioTrackList::indexGetter(ExecState* exec, JSValue slotBase, unsigned index)
{
    JSAudioTrackList* thisObj = jsCast<JSAudioTrackList*>(asObject(slotBase));
    ASSERT_GC_OBJECT_INHERITS(thisObj, &s_info);
    return toJS(exec, thisObj->globalObject(), static_cast<AudioTrackList*>(thisObj->impl())->item(index));
}

static inline bool isObservable(JSAudioTrackList* jsAudioTrackList)
{
    if (jsAudioTrackList->hasCustomProperties())
        return true;
    if (jsAudioTrackList->impl()->hasEventListeners())
        return true;
    return false;
}

bool JSAudioTrackListOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSAudioTrackList* jsAudioTrackList = jsCast<JSAudioTrackList*>(handle.get().asCell());
    if (jsAudioTrackList->impl()->isFiringEventListeners())
        return true;
    if (!isObservable(jsAudioTrackList))
        return false;
    Element* element = jsAudioTrackList->impl()->element();
    if (!element)
        return false;
    void* root = WebCore::root(element);
    return visitor.containsOpaqueRoot(root);
}

void JSAudioTrackListOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSAudioTrackList* jsAudioTrackList = jsCast<JSAudioTrackList*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsAudioTrackList->impl(), jsAudioTrackList);
    jsAudioTrackList->releaseImpl();
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7AudioTrackList@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore14AudioTrackListE[]; }
#endif
#endif
JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, AudioTrackList* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSAudioTrackList>(exec, impl))
        return result;

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = *(reinterpret_cast<void**>(impl));
#if PLATFORM(WIN)
    void* expectedVTablePointer = reinterpret_cast<void*>(__identifier("??_7AudioTrackList@WebCore@@6B@"));
#else
    void* expectedVTablePointer = &_ZTVN7WebCore14AudioTrackListE[2];
#if COMPILER(CLANG) && COMPILER_SUPPORTS(CXX_STATIC_ASSERT)
    // If this fails AudioTrackList does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    COMPILE_ASSERT(__is_polymorphic(AudioTrackList), AudioTrackList_is_not_polymorphic);
#endif
#endif
    // If you hit this assertion you either have a use after free bug, or
    // AudioTrackList has subclasses. If AudioTrackList has subclasses that get passed
    // to toJS() we currently require AudioTrackList you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    ReportMemoryCost<AudioTrackList>::reportMemoryCost(exec, impl);
    return createNewWrapper<JSAudioTrackList>(exec, globalObject, impl);
}

AudioTrackList* toAudioTrackList(JSC::JSValue value)
{
    return value.inherits(&JSAudioTrackList::s_info) ? jsCast<JSAudioTrackList*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(VIDEO_TRACK)
