/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGL)

#include "JSEXTDrawBuffers.h"

#include "EXTDrawBuffers.h"
#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table for prototype */

static const HashTableValue JSEXTDrawBuffersPrototypeTableValues[] =
{
    { "COLOR_ATTACHMENT0_EXT", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEXTDrawBuffersCOLOR_ATTACHMENT0_EXT), (intptr_t)0, NoIntrinsic },
    { "COLOR_ATTACHMENT1_EXT", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEXTDrawBuffersCOLOR_ATTACHMENT1_EXT), (intptr_t)0, NoIntrinsic },
    { "COLOR_ATTACHMENT2_EXT", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEXTDrawBuffersCOLOR_ATTACHMENT2_EXT), (intptr_t)0, NoIntrinsic },
    { "COLOR_ATTACHMENT3_EXT", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEXTDrawBuffersCOLOR_ATTACHMENT3_EXT), (intptr_t)0, NoIntrinsic },
    { "COLOR_ATTACHMENT4_EXT", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEXTDrawBuffersCOLOR_ATTACHMENT4_EXT), (intptr_t)0, NoIntrinsic },
    { "COLOR_ATTACHMENT5_EXT", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEXTDrawBuffersCOLOR_ATTACHMENT5_EXT), (intptr_t)0, NoIntrinsic },
    { "COLOR_ATTACHMENT6_EXT", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEXTDrawBuffersCOLOR_ATTACHMENT6_EXT), (intptr_t)0, NoIntrinsic },
    { "COLOR_ATTACHMENT7_EXT", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEXTDrawBuffersCOLOR_ATTACHMENT7_EXT), (intptr_t)0, NoIntrinsic },
    { "COLOR_ATTACHMENT8_EXT", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEXTDrawBuffersCOLOR_ATTACHMENT8_EXT), (intptr_t)0, NoIntrinsic },
    { "COLOR_ATTACHMENT9_EXT", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEXTDrawBuffersCOLOR_ATTACHMENT9_EXT), (intptr_t)0, NoIntrinsic },
    { "COLOR_ATTACHMENT10_EXT", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEXTDrawBuffersCOLOR_ATTACHMENT10_EXT), (intptr_t)0, NoIntrinsic },
    { "COLOR_ATTACHMENT11_EXT", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEXTDrawBuffersCOLOR_ATTACHMENT11_EXT), (intptr_t)0, NoIntrinsic },
    { "COLOR_ATTACHMENT12_EXT", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEXTDrawBuffersCOLOR_ATTACHMENT12_EXT), (intptr_t)0, NoIntrinsic },
    { "COLOR_ATTACHMENT13_EXT", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEXTDrawBuffersCOLOR_ATTACHMENT13_EXT), (intptr_t)0, NoIntrinsic },
    { "COLOR_ATTACHMENT14_EXT", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEXTDrawBuffersCOLOR_ATTACHMENT14_EXT), (intptr_t)0, NoIntrinsic },
    { "COLOR_ATTACHMENT15_EXT", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEXTDrawBuffersCOLOR_ATTACHMENT15_EXT), (intptr_t)0, NoIntrinsic },
    { "DRAW_BUFFER0_EXT", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEXTDrawBuffersDRAW_BUFFER0_EXT), (intptr_t)0, NoIntrinsic },
    { "DRAW_BUFFER1_EXT", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEXTDrawBuffersDRAW_BUFFER1_EXT), (intptr_t)0, NoIntrinsic },
    { "DRAW_BUFFER2_EXT", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEXTDrawBuffersDRAW_BUFFER2_EXT), (intptr_t)0, NoIntrinsic },
    { "DRAW_BUFFER3_EXT", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEXTDrawBuffersDRAW_BUFFER3_EXT), (intptr_t)0, NoIntrinsic },
    { "DRAW_BUFFER4_EXT", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEXTDrawBuffersDRAW_BUFFER4_EXT), (intptr_t)0, NoIntrinsic },
    { "DRAW_BUFFER5_EXT", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEXTDrawBuffersDRAW_BUFFER5_EXT), (intptr_t)0, NoIntrinsic },
    { "DRAW_BUFFER6_EXT", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEXTDrawBuffersDRAW_BUFFER6_EXT), (intptr_t)0, NoIntrinsic },
    { "DRAW_BUFFER7_EXT", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEXTDrawBuffersDRAW_BUFFER7_EXT), (intptr_t)0, NoIntrinsic },
    { "DRAW_BUFFER8_EXT", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEXTDrawBuffersDRAW_BUFFER8_EXT), (intptr_t)0, NoIntrinsic },
    { "DRAW_BUFFER9_EXT", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEXTDrawBuffersDRAW_BUFFER9_EXT), (intptr_t)0, NoIntrinsic },
    { "DRAW_BUFFER10_EXT", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEXTDrawBuffersDRAW_BUFFER10_EXT), (intptr_t)0, NoIntrinsic },
    { "DRAW_BUFFER11_EXT", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEXTDrawBuffersDRAW_BUFFER11_EXT), (intptr_t)0, NoIntrinsic },
    { "DRAW_BUFFER12_EXT", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEXTDrawBuffersDRAW_BUFFER12_EXT), (intptr_t)0, NoIntrinsic },
    { "DRAW_BUFFER13_EXT", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEXTDrawBuffersDRAW_BUFFER13_EXT), (intptr_t)0, NoIntrinsic },
    { "DRAW_BUFFER14_EXT", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEXTDrawBuffersDRAW_BUFFER14_EXT), (intptr_t)0, NoIntrinsic },
    { "DRAW_BUFFER15_EXT", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEXTDrawBuffersDRAW_BUFFER15_EXT), (intptr_t)0, NoIntrinsic },
    { "MAX_COLOR_ATTACHMENTS_EXT", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEXTDrawBuffersMAX_COLOR_ATTACHMENTS_EXT), (intptr_t)0, NoIntrinsic },
    { "MAX_DRAW_BUFFERS_EXT", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEXTDrawBuffersMAX_DRAW_BUFFERS_EXT), (intptr_t)0, NoIntrinsic },
    { "drawBuffersEXT", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsEXTDrawBuffersPrototypeFunctionDrawBuffersEXT), (intptr_t)1, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSEXTDrawBuffersPrototypeTable = { 131, 127, JSEXTDrawBuffersPrototypeTableValues, 0 };
const ClassInfo JSEXTDrawBuffersPrototype::s_info = { "EXTDrawBuffersPrototype", &Base::s_info, &JSEXTDrawBuffersPrototypeTable, 0, CREATE_METHOD_TABLE(JSEXTDrawBuffersPrototype) };

JSObject* JSEXTDrawBuffersPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSEXTDrawBuffers>(exec, globalObject);
}

bool JSEXTDrawBuffersPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSEXTDrawBuffersPrototype* thisObject = jsCast<JSEXTDrawBuffersPrototype*>(cell);
    return getStaticPropertySlot<JSEXTDrawBuffersPrototype, JSObject>(exec, &JSEXTDrawBuffersPrototypeTable, thisObject, propertyName, slot);
}

bool JSEXTDrawBuffersPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSEXTDrawBuffersPrototype* thisObject = jsCast<JSEXTDrawBuffersPrototype*>(object);
    return getStaticPropertyDescriptor<JSEXTDrawBuffersPrototype, JSObject>(exec, &JSEXTDrawBuffersPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSEXTDrawBuffers::s_info = { "EXTDrawBuffers", &Base::s_info, 0, 0 , CREATE_METHOD_TABLE(JSEXTDrawBuffers) };

JSEXTDrawBuffers::JSEXTDrawBuffers(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<EXTDrawBuffers> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSEXTDrawBuffers::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSEXTDrawBuffers::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSEXTDrawBuffersPrototype::create(exec->vm(), globalObject, JSEXTDrawBuffersPrototype::createStructure(globalObject->vm(), globalObject, globalObject->objectPrototype()));
}

void JSEXTDrawBuffers::destroy(JSC::JSCell* cell)
{
    JSEXTDrawBuffers* thisObject = static_cast<JSEXTDrawBuffers*>(cell);
    thisObject->JSEXTDrawBuffers::~JSEXTDrawBuffers();
}

JSEXTDrawBuffers::~JSEXTDrawBuffers()
{
    releaseImplIfNotNull();
}

EncodedJSValue JSC_HOST_CALL jsEXTDrawBuffersPrototypeFunctionDrawBuffersEXT(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSEXTDrawBuffers::s_info))
        return throwVMTypeError(exec);
    JSEXTDrawBuffers* castedThis = jsCast<JSEXTDrawBuffers*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSEXTDrawBuffers::s_info);
    EXTDrawBuffers* impl = static_cast<EXTDrawBuffers*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    Vector<unsigned> buffers(toNativeArray<unsigned>(exec, exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->drawBuffersEXT(buffers);
    return JSValue::encode(jsUndefined());
}

// Constant getters

JSValue jsEXTDrawBuffersCOLOR_ATTACHMENT0_EXT(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(0x8CE0));
}

JSValue jsEXTDrawBuffersCOLOR_ATTACHMENT1_EXT(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(0x8CE1));
}

JSValue jsEXTDrawBuffersCOLOR_ATTACHMENT2_EXT(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(0x8CE2));
}

JSValue jsEXTDrawBuffersCOLOR_ATTACHMENT3_EXT(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(0x8CE3));
}

JSValue jsEXTDrawBuffersCOLOR_ATTACHMENT4_EXT(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(0x8CE4));
}

JSValue jsEXTDrawBuffersCOLOR_ATTACHMENT5_EXT(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(0x8CE5));
}

JSValue jsEXTDrawBuffersCOLOR_ATTACHMENT6_EXT(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(0x8CE6));
}

JSValue jsEXTDrawBuffersCOLOR_ATTACHMENT7_EXT(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(0x8CE7));
}

JSValue jsEXTDrawBuffersCOLOR_ATTACHMENT8_EXT(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(0x8CE8));
}

JSValue jsEXTDrawBuffersCOLOR_ATTACHMENT9_EXT(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(0x8CE9));
}

JSValue jsEXTDrawBuffersCOLOR_ATTACHMENT10_EXT(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(0x8CEA));
}

JSValue jsEXTDrawBuffersCOLOR_ATTACHMENT11_EXT(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(0x8CEB));
}

JSValue jsEXTDrawBuffersCOLOR_ATTACHMENT12_EXT(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(0x8CEC));
}

JSValue jsEXTDrawBuffersCOLOR_ATTACHMENT13_EXT(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(0x8CED));
}

JSValue jsEXTDrawBuffersCOLOR_ATTACHMENT14_EXT(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(0x8CEE));
}

JSValue jsEXTDrawBuffersCOLOR_ATTACHMENT15_EXT(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(0x8CEF));
}

JSValue jsEXTDrawBuffersDRAW_BUFFER0_EXT(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(0x8825));
}

JSValue jsEXTDrawBuffersDRAW_BUFFER1_EXT(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(0x8826));
}

JSValue jsEXTDrawBuffersDRAW_BUFFER2_EXT(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(0x8827));
}

JSValue jsEXTDrawBuffersDRAW_BUFFER3_EXT(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(0x8828));
}

JSValue jsEXTDrawBuffersDRAW_BUFFER4_EXT(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(0x8829));
}

JSValue jsEXTDrawBuffersDRAW_BUFFER5_EXT(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(0x882A));
}

JSValue jsEXTDrawBuffersDRAW_BUFFER6_EXT(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(0x882B));
}

JSValue jsEXTDrawBuffersDRAW_BUFFER7_EXT(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(0x882C));
}

JSValue jsEXTDrawBuffersDRAW_BUFFER8_EXT(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(0x882D));
}

JSValue jsEXTDrawBuffersDRAW_BUFFER9_EXT(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(0x882E));
}

JSValue jsEXTDrawBuffersDRAW_BUFFER10_EXT(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(0x882F));
}

JSValue jsEXTDrawBuffersDRAW_BUFFER11_EXT(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(0x8830));
}

JSValue jsEXTDrawBuffersDRAW_BUFFER12_EXT(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(0x8831));
}

JSValue jsEXTDrawBuffersDRAW_BUFFER13_EXT(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(0x8832));
}

JSValue jsEXTDrawBuffersDRAW_BUFFER14_EXT(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(0x8833));
}

JSValue jsEXTDrawBuffersDRAW_BUFFER15_EXT(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(0x8834));
}

JSValue jsEXTDrawBuffersMAX_COLOR_ATTACHMENTS_EXT(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(0x8CDF));
}

JSValue jsEXTDrawBuffersMAX_DRAW_BUFFERS_EXT(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(0x8824));
}

static inline bool isObservable(JSEXTDrawBuffers* jsEXTDrawBuffers)
{
    if (jsEXTDrawBuffers->hasCustomProperties())
        return true;
    return false;
}

bool JSEXTDrawBuffersOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSEXTDrawBuffers* jsEXTDrawBuffers = jsCast<JSEXTDrawBuffers*>(handle.get().asCell());
    if (!isObservable(jsEXTDrawBuffers))
        return false;
    WebGLRenderingContext* root = jsEXTDrawBuffers->impl()->context();
    return visitor.containsOpaqueRoot(root);
}

void JSEXTDrawBuffersOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSEXTDrawBuffers* jsEXTDrawBuffers = jsCast<JSEXTDrawBuffers*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsEXTDrawBuffers->impl(), jsEXTDrawBuffers);
    jsEXTDrawBuffers->releaseImpl();
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7EXTDrawBuffers@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore14EXTDrawBuffersE[]; }
#endif
#endif
JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, EXTDrawBuffers* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSEXTDrawBuffers>(exec, impl))
        return result;

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = *(reinterpret_cast<void**>(impl));
#if PLATFORM(WIN)
    void* expectedVTablePointer = reinterpret_cast<void*>(__identifier("??_7EXTDrawBuffers@WebCore@@6B@"));
#else
    void* expectedVTablePointer = &_ZTVN7WebCore14EXTDrawBuffersE[2];
#if COMPILER(CLANG) && COMPILER_SUPPORTS(CXX_STATIC_ASSERT)
    // If this fails EXTDrawBuffers does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    COMPILE_ASSERT(__is_polymorphic(EXTDrawBuffers), EXTDrawBuffers_is_not_polymorphic);
#endif
#endif
    // If you hit this assertion you either have a use after free bug, or
    // EXTDrawBuffers has subclasses. If EXTDrawBuffers has subclasses that get passed
    // to toJS() we currently require EXTDrawBuffers you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    ReportMemoryCost<EXTDrawBuffers>::reportMemoryCost(exec, impl);
    return createNewWrapper<JSEXTDrawBuffers>(exec, globalObject, impl);
}

EXTDrawBuffers* toEXTDrawBuffers(JSC::JSValue value)
{
    return value.inherits(&JSEXTDrawBuffers::s_info) ? jsCast<JSEXTDrawBuffers*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(WEBGL)
