/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSHTMLCanvasElement.h"

#include "HTMLCanvasElement.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSHTMLCanvasElementTableValues[] =
{
    { "width", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLCanvasElementWidth), (intptr_t)setJSHTMLCanvasElementWidth, NoIntrinsic },
    { "height", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLCanvasElementHeight), (intptr_t)setJSHTMLCanvasElementHeight, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLCanvasElementConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLCanvasElementTable = { 9, 7, JSHTMLCanvasElementTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSHTMLCanvasElementConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLCanvasElementConstructorTable = { 1, 0, JSHTMLCanvasElementConstructorTableValues, 0 };
const ClassInfo JSHTMLCanvasElementConstructor::s_info = { "HTMLCanvasElementConstructor", &Base::s_info, &JSHTMLCanvasElementConstructorTable, 0, CREATE_METHOD_TABLE(JSHTMLCanvasElementConstructor) };

JSHTMLCanvasElementConstructor::JSHTMLCanvasElementConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSHTMLCanvasElementConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSHTMLCanvasElementPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(0), ReadOnly | DontDelete | DontEnum);
}

bool JSHTMLCanvasElementConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLCanvasElementConstructor, JSDOMWrapper>(exec, &JSHTMLCanvasElementConstructorTable, jsCast<JSHTMLCanvasElementConstructor*>(cell), propertyName, slot);
}

bool JSHTMLCanvasElementConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSHTMLCanvasElementConstructor, JSDOMWrapper>(exec, &JSHTMLCanvasElementConstructorTable, jsCast<JSHTMLCanvasElementConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSHTMLCanvasElementPrototypeTableValues[] =
{
    { "toDataURL", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsHTMLCanvasElementPrototypeFunctionToDataURL), (intptr_t)0, NoIntrinsic },
    { "getContext", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsHTMLCanvasElementPrototypeFunctionGetContext), (intptr_t)0, NoIntrinsic },
    { "supportsContext", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsHTMLCanvasElementPrototypeFunctionSupportsContext), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLCanvasElementPrototypeTable = { 9, 7, JSHTMLCanvasElementPrototypeTableValues, 0 };
const ClassInfo JSHTMLCanvasElementPrototype::s_info = { "HTMLCanvasElementPrototype", &Base::s_info, &JSHTMLCanvasElementPrototypeTable, 0, CREATE_METHOD_TABLE(JSHTMLCanvasElementPrototype) };

JSObject* JSHTMLCanvasElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSHTMLCanvasElement>(exec, globalObject);
}

bool JSHTMLCanvasElementPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSHTMLCanvasElementPrototype* thisObject = jsCast<JSHTMLCanvasElementPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, &JSHTMLCanvasElementPrototypeTable, thisObject, propertyName, slot);
}

bool JSHTMLCanvasElementPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSHTMLCanvasElementPrototype* thisObject = jsCast<JSHTMLCanvasElementPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, &JSHTMLCanvasElementPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSHTMLCanvasElement::s_info = { "HTMLCanvasElement", &Base::s_info, &JSHTMLCanvasElementTable, 0 , CREATE_METHOD_TABLE(JSHTMLCanvasElement) };

JSHTMLCanvasElement::JSHTMLCanvasElement(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<HTMLCanvasElement> impl)
    : JSHTMLElement(structure, globalObject, impl)
{
}

void JSHTMLCanvasElement::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSHTMLCanvasElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSHTMLCanvasElementPrototype::create(exec->vm(), globalObject, JSHTMLCanvasElementPrototype::createStructure(exec->vm(), globalObject, JSHTMLElementPrototype::self(exec, globalObject)));
}

bool JSHTMLCanvasElement::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSHTMLCanvasElement* thisObject = jsCast<JSHTMLCanvasElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSHTMLCanvasElement, Base>(exec, &JSHTMLCanvasElementTable, thisObject, propertyName, slot);
}

bool JSHTMLCanvasElement::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSHTMLCanvasElement* thisObject = jsCast<JSHTMLCanvasElement*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSHTMLCanvasElement, Base>(exec, &JSHTMLCanvasElementTable, thisObject, propertyName, descriptor);
}

JSValue jsHTMLCanvasElementWidth(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLCanvasElement* castedThis = jsCast<JSHTMLCanvasElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLCanvasElement* impl = static_cast<HTMLCanvasElement*>(castedThis->impl());
    JSValue result = jsNumber(impl->width());
    return result;
}


JSValue jsHTMLCanvasElementHeight(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLCanvasElement* castedThis = jsCast<JSHTMLCanvasElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLCanvasElement* impl = static_cast<HTMLCanvasElement*>(castedThis->impl());
    JSValue result = jsNumber(impl->height());
    return result;
}


JSValue jsHTMLCanvasElementConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLCanvasElement* domObject = jsCast<JSHTMLCanvasElement*>(asObject(slotBase));
    return JSHTMLCanvasElement::getConstructor(exec, domObject->globalObject());
}

void JSHTMLCanvasElement::put(JSCell* cell, ExecState* exec, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    JSHTMLCanvasElement* thisObject = jsCast<JSHTMLCanvasElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    lookupPut<JSHTMLCanvasElement, Base>(exec, propertyName, value, &JSHTMLCanvasElementTable, thisObject, slot);
}

void setJSHTMLCanvasElementWidth(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLCanvasElement* castedThis = jsCast<JSHTMLCanvasElement*>(thisObject);
    HTMLCanvasElement* impl = static_cast<HTMLCanvasElement*>(castedThis->impl());
    int nativeValue(toInt32(exec, value, NormalConversion));
    if (exec->hadException())
        return;
    impl->setWidth(nativeValue);
}


void setJSHTMLCanvasElementHeight(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLCanvasElement* castedThis = jsCast<JSHTMLCanvasElement*>(thisObject);
    HTMLCanvasElement* impl = static_cast<HTMLCanvasElement*>(castedThis->impl());
    int nativeValue(toInt32(exec, value, NormalConversion));
    if (exec->hadException())
        return;
    impl->setHeight(nativeValue);
}


JSValue JSHTMLCanvasElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLCanvasElementConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsHTMLCanvasElementPrototypeFunctionToDataURL(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSHTMLCanvasElement::s_info))
        return throwVMTypeError(exec);
    JSHTMLCanvasElement* castedThis = jsCast<JSHTMLCanvasElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSHTMLCanvasElement::s_info);
    return JSValue::encode(castedThis->toDataURL(exec));
}

EncodedJSValue JSC_HOST_CALL jsHTMLCanvasElementPrototypeFunctionGetContext(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSHTMLCanvasElement::s_info))
        return throwVMTypeError(exec);
    JSHTMLCanvasElement* castedThis = jsCast<JSHTMLCanvasElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSHTMLCanvasElement::s_info);
    return JSValue::encode(castedThis->getContext(exec));
}

EncodedJSValue JSC_HOST_CALL jsHTMLCanvasElementPrototypeFunctionSupportsContext(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSHTMLCanvasElement::s_info))
        return throwVMTypeError(exec);
    JSHTMLCanvasElement* castedThis = jsCast<JSHTMLCanvasElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSHTMLCanvasElement::s_info);
    return JSValue::encode(castedThis->supportsContext(exec));
}

HTMLCanvasElement* toHTMLCanvasElement(JSC::JSValue value)
{
    return value.inherits(&JSHTMLCanvasElement::s_info) ? jsCast<JSHTMLCanvasElement*>(asObject(value))->impl() : 0;
}

}
