/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSHistory.h"

#include "ExceptionCode.h"
#include "History.h"
#include "JSDOMBinding.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSHistoryTableValues[] =
{
    { "length", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHistoryLength), (intptr_t)0, NoIntrinsic },
    { "state", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHistoryState), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHistoryConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHistoryTable = { 9, 7, JSHistoryTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSHistoryConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHistoryConstructorTable = { 1, 0, JSHistoryConstructorTableValues, 0 };
const ClassInfo JSHistoryConstructor::s_info = { "HistoryConstructor", &Base::s_info, &JSHistoryConstructorTable, 0, CREATE_METHOD_TABLE(JSHistoryConstructor) };

JSHistoryConstructor::JSHistoryConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSHistoryConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSHistoryPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(0), ReadOnly | DontDelete | DontEnum);
}

bool JSHistoryConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHistoryConstructor, JSDOMWrapper>(exec, &JSHistoryConstructorTable, jsCast<JSHistoryConstructor*>(cell), propertyName, slot);
}

bool JSHistoryConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSHistoryConstructor, JSDOMWrapper>(exec, &JSHistoryConstructorTable, jsCast<JSHistoryConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSHistoryPrototypeTableValues[] =
{
    { "back", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsHistoryPrototypeFunctionBack), (intptr_t)0, NoIntrinsic },
    { "forward", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsHistoryPrototypeFunctionForward), (intptr_t)0, NoIntrinsic },
    { "go", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsHistoryPrototypeFunctionGo), (intptr_t)0, NoIntrinsic },
    { "pushState", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsHistoryPrototypeFunctionPushState), (intptr_t)2, NoIntrinsic },
    { "replaceState", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsHistoryPrototypeFunctionReplaceState), (intptr_t)2, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHistoryPrototypeTable = { 17, 15, JSHistoryPrototypeTableValues, 0 };
const ClassInfo JSHistoryPrototype::s_info = { "HistoryPrototype", &Base::s_info, &JSHistoryPrototypeTable, 0, CREATE_METHOD_TABLE(JSHistoryPrototype) };

JSObject* JSHistoryPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSHistory>(exec, globalObject);
}

bool JSHistoryPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSHistoryPrototype* thisObject = jsCast<JSHistoryPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, &JSHistoryPrototypeTable, thisObject, propertyName, slot);
}

bool JSHistoryPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSHistoryPrototype* thisObject = jsCast<JSHistoryPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, &JSHistoryPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSHistory::s_info = { "History", &Base::s_info, &JSHistoryTable, 0 , CREATE_METHOD_TABLE(JSHistory) };

JSHistory::JSHistory(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<History> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSHistory::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSHistory::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSHistoryPrototype::create(exec->vm(), globalObject, JSHistoryPrototype::createStructure(globalObject->vm(), globalObject, globalObject->objectPrototype()));
}

void JSHistory::destroy(JSC::JSCell* cell)
{
    JSHistory* thisObject = static_cast<JSHistory*>(cell);
    thisObject->JSHistory::~JSHistory();
}

JSHistory::~JSHistory()
{
    releaseImplIfNotNull();
}

bool JSHistory::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSHistory* thisObject = jsCast<JSHistory*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    if (thisObject->getOwnPropertySlotDelegate(exec, propertyName, slot))
        return true;
    return getStaticValueSlot<JSHistory, Base>(exec, &JSHistoryTable, thisObject, propertyName, slot);
}

bool JSHistory::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSHistory* thisObject = jsCast<JSHistory*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    if (thisObject->getOwnPropertyDescriptorDelegate(exec, propertyName, descriptor))
        return true;
    return getStaticValueDescriptor<JSHistory, Base>(exec, &JSHistoryTable, thisObject, propertyName, descriptor);
}

bool JSHistory::getOwnPropertySlotByIndex(JSCell* cell, ExecState* exec, unsigned index, PropertySlot& slot)
{
    JSHistory* thisObject = jsCast<JSHistory*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    PropertyName propertyName = Identifier::from(exec, index);
    if (thisObject->getOwnPropertySlotDelegate(exec, propertyName, slot))
        return true;
    return Base::getOwnPropertySlotByIndex(thisObject, exec, index, slot);
}

JSValue jsHistoryLength(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHistory* castedThis = jsCast<JSHistory*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    History* impl = static_cast<History*>(castedThis->impl());
    JSValue result = jsNumber(impl->length());
    return result;
}


JSValue jsHistoryState(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHistory* castedThis = jsCast<JSHistory*>(asObject(slotBase));
    return castedThis->state(exec);
}


JSValue jsHistoryConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHistory* domObject = jsCast<JSHistory*>(asObject(slotBase));
    return JSHistory::getConstructor(exec, domObject->globalObject());
}

void JSHistory::put(JSCell* cell, ExecState* exec, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    JSHistory* thisObject = jsCast<JSHistory*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    if (thisObject->putDelegate(exec, propertyName, value, slot))
        return;
    Base::put(thisObject, exec, propertyName, value, slot);
}

void JSHistory::putByIndex(JSCell* cell, ExecState* exec, unsigned index, JSValue value, bool shouldThrow)
{
    JSHistory* thisObject = jsCast<JSHistory*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    PropertyName propertyName = Identifier::from(exec, index);
    PutPropertySlot slot(shouldThrow);
    if (thisObject->putDelegate(exec, propertyName, value, slot))
        return;
    Base::putByIndex(cell, exec, index, value, shouldThrow);
}

JSValue JSHistory::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHistoryConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsHistoryPrototypeFunctionBack(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSHistory::s_info))
        return throwVMTypeError(exec);
    JSHistory* castedThis = jsCast<JSHistory*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSHistory::s_info);
    History* impl = static_cast<History*>(castedThis->impl());
    ScriptExecutionContext* scriptContext = jsCast<JSDOMGlobalObject*>(exec->lexicalGlobalObject())->scriptExecutionContext();
    if (!scriptContext)
        return JSValue::encode(jsUndefined());
    impl->back(scriptContext);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsHistoryPrototypeFunctionForward(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSHistory::s_info))
        return throwVMTypeError(exec);
    JSHistory* castedThis = jsCast<JSHistory*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSHistory::s_info);
    History* impl = static_cast<History*>(castedThis->impl());
    ScriptExecutionContext* scriptContext = jsCast<JSDOMGlobalObject*>(exec->lexicalGlobalObject())->scriptExecutionContext();
    if (!scriptContext)
        return JSValue::encode(jsUndefined());
    impl->forward(scriptContext);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsHistoryPrototypeFunctionGo(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSHistory::s_info))
        return throwVMTypeError(exec);
    JSHistory* castedThis = jsCast<JSHistory*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSHistory::s_info);
    History* impl = static_cast<History*>(castedThis->impl());
    ScriptExecutionContext* scriptContext = jsCast<JSDOMGlobalObject*>(exec->lexicalGlobalObject())->scriptExecutionContext();
    if (!scriptContext)
        return JSValue::encode(jsUndefined());
    int distance(toInt32(exec, exec->argument(0), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->go(scriptContext, distance);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsHistoryPrototypeFunctionPushState(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSHistory::s_info))
        return throwVMTypeError(exec);
    JSHistory* castedThis = jsCast<JSHistory*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSHistory::s_info);
    return JSValue::encode(castedThis->pushState(exec));
}

EncodedJSValue JSC_HOST_CALL jsHistoryPrototypeFunctionReplaceState(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSHistory::s_info))
        return throwVMTypeError(exec);
    JSHistory* castedThis = jsCast<JSHistory*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSHistory::s_info);
    return JSValue::encode(castedThis->replaceState(exec));
}

void JSHistory::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    JSHistory* thisObject = jsCast<JSHistory*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    COMPILE_ASSERT(StructureFlags & OverridesVisitChildren, OverridesVisitChildrenWithoutSettingFlag);
    ASSERT(thisObject->structure()->typeInfo().overridesVisitChildren());
    Base::visitChildren(thisObject, visitor);
    visitor.append(&thisObject->m_state);
}

static inline bool isObservable(JSHistory* jsHistory)
{
    if (jsHistory->hasCustomProperties())
        return true;
    return false;
}

bool JSHistoryOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSHistory* jsHistory = jsCast<JSHistory*>(handle.get().asCell());
    if (!isObservable(jsHistory))
        return false;
    Frame* root = jsHistory->impl()->frame();
    if (!root)
        return false;
    return visitor.containsOpaqueRoot(root);
}

void JSHistoryOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSHistory* jsHistory = jsCast<JSHistory*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsHistory->impl(), jsHistory);
    jsHistory->releaseImpl();
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7History@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore7HistoryE[]; }
#endif
#endif
JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, History* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSHistory>(exec, impl))
        return result;

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = *(reinterpret_cast<void**>(impl));
#if PLATFORM(WIN)
    void* expectedVTablePointer = reinterpret_cast<void*>(__identifier("??_7History@WebCore@@6B@"));
#else
    void* expectedVTablePointer = &_ZTVN7WebCore7HistoryE[2];
#if COMPILER(CLANG) && COMPILER_SUPPORTS(CXX_STATIC_ASSERT)
    // If this fails History does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    COMPILE_ASSERT(__is_polymorphic(History), History_is_not_polymorphic);
#endif
#endif
    // If you hit this assertion you either have a use after free bug, or
    // History has subclasses. If History has subclasses that get passed
    // to toJS() we currently require History you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    ReportMemoryCost<History>::reportMemoryCost(exec, impl);
    return createNewWrapper<JSHistory>(exec, globalObject, impl);
}

History* toHistory(JSC::JSValue value)
{
    return value.inherits(&JSHistory::s_info) ? jsCast<JSHistory*>(asObject(value))->impl() : 0;
}

}
