/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG)

#include "JSSVGRectElement.h"

#include "JSSVGAnimatedLength.h"
#include "SVGRectElement.h"
#include <wtf/GetPtr.h>

#if ENABLE(SVG)
#include "JSSVGAnimatedBoolean.h"
#endif

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSSVGRectElementTableValues[] =
{
    { "x", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGRectElementX), (intptr_t)0, NoIntrinsic },
    { "y", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGRectElementY), (intptr_t)0, NoIntrinsic },
    { "width", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGRectElementWidth), (intptr_t)0, NoIntrinsic },
    { "height", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGRectElementHeight), (intptr_t)0, NoIntrinsic },
    { "rx", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGRectElementRx), (intptr_t)0, NoIntrinsic },
    { "ry", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGRectElementRy), (intptr_t)0, NoIntrinsic },
#if ENABLE(SVG)
    { "externalResourcesRequired", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGRectElementExternalResourcesRequired), (intptr_t)0, NoIntrinsic },
#endif
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGRectElementConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGRectElementTable = { 19, 15, JSSVGRectElementTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSSVGRectElementConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGRectElementConstructorTable = { 1, 0, JSSVGRectElementConstructorTableValues, 0 };
const ClassInfo JSSVGRectElementConstructor::s_info = { "SVGRectElementConstructor", &Base::s_info, &JSSVGRectElementConstructorTable, 0, CREATE_METHOD_TABLE(JSSVGRectElementConstructor) };

JSSVGRectElementConstructor::JSSVGRectElementConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSSVGRectElementConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSSVGRectElementPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(0), ReadOnly | DontDelete | DontEnum);
}

bool JSSVGRectElementConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGRectElementConstructor, JSDOMWrapper>(exec, &JSSVGRectElementConstructorTable, jsCast<JSSVGRectElementConstructor*>(cell), propertyName, slot);
}

bool JSSVGRectElementConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGRectElementConstructor, JSDOMWrapper>(exec, &JSSVGRectElementConstructorTable, jsCast<JSSVGRectElementConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSSVGRectElementPrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGRectElementPrototypeTable = { 1, 0, JSSVGRectElementPrototypeTableValues, 0 };
const ClassInfo JSSVGRectElementPrototype::s_info = { "SVGRectElementPrototype", &Base::s_info, &JSSVGRectElementPrototypeTable, 0, CREATE_METHOD_TABLE(JSSVGRectElementPrototype) };

JSObject* JSSVGRectElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGRectElement>(exec, globalObject);
}

const ClassInfo JSSVGRectElement::s_info = { "SVGRectElement", &Base::s_info, &JSSVGRectElementTable, 0 , CREATE_METHOD_TABLE(JSSVGRectElement) };

JSSVGRectElement::JSSVGRectElement(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGRectElement> impl)
    : JSSVGGraphicsElement(structure, globalObject, impl)
{
}

void JSSVGRectElement::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSSVGRectElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSSVGRectElementPrototype::create(exec->vm(), globalObject, JSSVGRectElementPrototype::createStructure(exec->vm(), globalObject, JSSVGGraphicsElementPrototype::self(exec, globalObject)));
}

bool JSSVGRectElement::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGRectElement* thisObject = jsCast<JSSVGRectElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSSVGRectElement, Base>(exec, &JSSVGRectElementTable, thisObject, propertyName, slot);
}

bool JSSVGRectElement::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGRectElement* thisObject = jsCast<JSSVGRectElement*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSSVGRectElement, Base>(exec, &JSSVGRectElementTable, thisObject, propertyName, descriptor);
}

JSValue jsSVGRectElementX(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGRectElement* castedThis = jsCast<JSSVGRectElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGRectElement* impl = static_cast<SVGRectElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = impl->xAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGRectElementY(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGRectElement* castedThis = jsCast<JSSVGRectElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGRectElement* impl = static_cast<SVGRectElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = impl->yAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGRectElementWidth(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGRectElement* castedThis = jsCast<JSSVGRectElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGRectElement* impl = static_cast<SVGRectElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = impl->widthAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGRectElementHeight(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGRectElement* castedThis = jsCast<JSSVGRectElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGRectElement* impl = static_cast<SVGRectElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = impl->heightAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGRectElementRx(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGRectElement* castedThis = jsCast<JSSVGRectElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGRectElement* impl = static_cast<SVGRectElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = impl->rxAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGRectElementRy(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGRectElement* castedThis = jsCast<JSSVGRectElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGRectElement* impl = static_cast<SVGRectElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = impl->ryAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


#if ENABLE(SVG)
JSValue jsSVGRectElementExternalResourcesRequired(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGRectElement* castedThis = jsCast<JSSVGRectElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGRectElement* impl = static_cast<SVGRectElement*>(castedThis->impl());
    RefPtr<SVGAnimatedBoolean> obj = impl->externalResourcesRequiredAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}

#endif

JSValue jsSVGRectElementConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGRectElement* domObject = jsCast<JSSVGRectElement*>(asObject(slotBase));
    return JSSVGRectElement::getConstructor(exec, domObject->globalObject());
}

JSValue JSSVGRectElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGRectElementConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}


}

#endif // ENABLE(SVG)
