/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WORKERS)

#include "JSWorkerGlobalScope.h"

#include "DOMFileSystemSync.h"
#include "Database.h"
#include "DatabaseSync.h"
#include "EntrySync.h"
#include "Event.h"
#include "EventListener.h"
#include "ExceptionCode.h"
#include "JSArrayBuffer.h"
#include "JSBlob.h"
#include "JSDOMBinding.h"
#include "JSDataView.h"
#include "JSDatabaseCallback.h"
#include "JSEntryCallback.h"
#include "JSErrorCallback.h"
#include "JSErrorHandler.h"
#include "JSEvent.h"
#include "JSEventListener.h"
#include "JSEventSource.h"
#include "JSFileSystemCallback.h"
#include "JSFloat32Array.h"
#include "JSFloat64Array.h"
#include "JSInt16Array.h"
#include "JSInt32Array.h"
#include "JSInt8Array.h"
#include "JSMessageEvent.h"
#include "JSUint16Array.h"
#include "JSUint32Array.h"
#include "JSUint8Array.h"
#include "JSUint8ClampedArray.h"
#include "JSWorkerGlobalScope.h"
#include "JSWorkerLocation.h"
#include "JSWorkerNavigator.h"
#include "JSXMLHttpRequest.h"
#include "RuntimeEnabledFeatures.h"
#include "WorkerGlobalScope.h"
#include "WorkerGlobalScopeFileSystem.h"
#include "WorkerGlobalScopeIndexedDatabase.h"
#include "WorkerGlobalScopeNotifications.h"
#include "WorkerGlobalScopeWebDatabase.h"
#include "WorkerLocation.h"
#include "WorkerNavigator.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

#if ENABLE(BLOB)
#include "JSDOMURL.h"
#include "JSFileReader.h"
#include "JSFileReaderSync.h"
#endif

#if ENABLE(CHANNEL_MESSAGING)
#include "JSMessageChannel.h"
#endif

#if ENABLE(FILE_SYSTEM)
#include "JSDOMFileSystemSync.h"
#include "JSEntrySync.h"
#include "JSFileError.h"
#include "JSFileException.h"
#endif

#if ENABLE(INDEXED_DATABASE)
#include "IDBFactory.h"
#include "JSIDBCursor.h"
#include "JSIDBCursorWithValue.h"
#include "JSIDBDatabase.h"
#include "JSIDBFactory.h"
#include "JSIDBIndex.h"
#include "JSIDBKeyRange.h"
#include "JSIDBObjectStore.h"
#include "JSIDBOpenDBRequest.h"
#include "JSIDBRequest.h"
#include "JSIDBTransaction.h"
#include "JSIDBVersionChangeEvent.h"
#endif

#if ENABLE(LEGACY_NOTIFICATIONS) || ENABLE(NOTIFICATIONS)
#include "JSNotificationCenter.h"
#include "NotificationCenter.h"
#endif

#if ENABLE(SQL_DATABASE)
#include "JSDatabase.h"
#include "JSDatabaseSync.h"
#endif

#if ENABLE(WEB_SOCKETS)
#include "JSWebSocket.h"
#endif

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSWorkerGlobalScopeTableValues[] =
{
    { "self", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerGlobalScopeSelf), (intptr_t)setJSWorkerGlobalScopeSelf, NoIntrinsic },
    { "location", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerGlobalScopeLocation), (intptr_t)setJSWorkerGlobalScopeLocation, NoIntrinsic },
    { "onerror", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerGlobalScopeOnerror), (intptr_t)setJSWorkerGlobalScopeOnerror, NoIntrinsic },
    { "onoffline", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerGlobalScopeOnoffline), (intptr_t)setJSWorkerGlobalScopeOnoffline, NoIntrinsic },
    { "ononline", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerGlobalScopeOnonline), (intptr_t)setJSWorkerGlobalScopeOnonline, NoIntrinsic },
    { "navigator", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerGlobalScopeNavigator), (intptr_t)setJSWorkerGlobalScopeNavigator, NoIntrinsic },
#if ENABLE(BLOB)
    { "webkitURL", DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerGlobalScopeWebkitURLConstructor), (intptr_t)setJSWorkerGlobalScopeWebkitURLConstructor, NoIntrinsic },
#endif
#if ENABLE(WEB_SOCKETS)
    { "WebSocket", DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerGlobalScopeWebSocketConstructor), (intptr_t)setJSWorkerGlobalScopeWebSocketConstructor, NoIntrinsic },
#endif
#if ENABLE(CHANNEL_MESSAGING)
    { "MessageChannel", DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerGlobalScopeMessageChannelConstructor), (intptr_t)setJSWorkerGlobalScopeMessageChannelConstructor, NoIntrinsic },
#endif
    { "MessageEvent", DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerGlobalScopeMessageEventConstructor), (intptr_t)setJSWorkerGlobalScopeMessageEventConstructor, NoIntrinsic },
    { "Blob", DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerGlobalScopeBlobConstructor), (intptr_t)setJSWorkerGlobalScopeBlobConstructor, NoIntrinsic },
#if ENABLE(BLOB)
    { "FileReader", DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerGlobalScopeFileReaderConstructor), (intptr_t)setJSWorkerGlobalScopeFileReaderConstructor, NoIntrinsic },
#endif
#if ENABLE(BLOB)
    { "FileReaderSync", DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerGlobalScopeFileReaderSyncConstructor), (intptr_t)setJSWorkerGlobalScopeFileReaderSyncConstructor, NoIntrinsic },
#endif
#if ENABLE(BLOB)
    { "URL", DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerGlobalScopeURLConstructor), (intptr_t)setJSWorkerGlobalScopeURLConstructor, NoIntrinsic },
#endif
    { "ArrayBuffer", DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerGlobalScopeArrayBufferConstructor), (intptr_t)setJSWorkerGlobalScopeArrayBufferConstructor, NoIntrinsic },
    { "DataView", DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerGlobalScopeDataViewConstructor), (intptr_t)setJSWorkerGlobalScopeDataViewConstructor, NoIntrinsic },
    { "Float32Array", DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerGlobalScopeFloat32ArrayConstructor), (intptr_t)setJSWorkerGlobalScopeFloat32ArrayConstructor, NoIntrinsic },
    { "Float64Array", DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerGlobalScopeFloat64ArrayConstructor), (intptr_t)setJSWorkerGlobalScopeFloat64ArrayConstructor, NoIntrinsic },
    { "Int16Array", DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerGlobalScopeInt16ArrayConstructor), (intptr_t)setJSWorkerGlobalScopeInt16ArrayConstructor, NoIntrinsic },
    { "Int32Array", DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerGlobalScopeInt32ArrayConstructor), (intptr_t)setJSWorkerGlobalScopeInt32ArrayConstructor, NoIntrinsic },
    { "Int8Array", DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerGlobalScopeInt8ArrayConstructor), (intptr_t)setJSWorkerGlobalScopeInt8ArrayConstructor, NoIntrinsic },
    { "Uint16Array", DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerGlobalScopeUint16ArrayConstructor), (intptr_t)setJSWorkerGlobalScopeUint16ArrayConstructor, NoIntrinsic },
    { "Uint32Array", DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerGlobalScopeUint32ArrayConstructor), (intptr_t)setJSWorkerGlobalScopeUint32ArrayConstructor, NoIntrinsic },
    { "Uint8Array", DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerGlobalScopeUint8ArrayConstructor), (intptr_t)setJSWorkerGlobalScopeUint8ArrayConstructor, NoIntrinsic },
    { "Uint8ClampedArray", DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerGlobalScopeUint8ClampedArrayConstructor), (intptr_t)setJSWorkerGlobalScopeUint8ClampedArrayConstructor, NoIntrinsic },
    { "EventSource", DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerGlobalScopeEventSourceConstructor), (intptr_t)setJSWorkerGlobalScopeEventSourceConstructor, NoIntrinsic },
#if ENABLE(WORKERS)
    { "WorkerGlobalScope", DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerGlobalScopeWorkerGlobalScopeConstructor), (intptr_t)setJSWorkerGlobalScopeWorkerGlobalScopeConstructor, NoIntrinsic },
#endif
#if ENABLE(WORKERS)
    { "WorkerLocation", DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerGlobalScopeWorkerLocationConstructor), (intptr_t)setJSWorkerGlobalScopeWorkerLocationConstructor, NoIntrinsic },
#endif
    { "XMLHttpRequest", DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerGlobalScopeXMLHttpRequestConstructor), (intptr_t)setJSWorkerGlobalScopeXMLHttpRequestConstructor, NoIntrinsic },
#if ENABLE(FILE_SYSTEM)
    { "FileError", DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerGlobalScopeFileErrorConstructor), (intptr_t)setJSWorkerGlobalScopeFileErrorConstructor, NoIntrinsic },
#endif
#if ENABLE(FILE_SYSTEM)
    { "FileException", DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerGlobalScopeFileExceptionConstructor), (intptr_t)setJSWorkerGlobalScopeFileExceptionConstructor, NoIntrinsic },
#endif
#if ENABLE(INDEXED_DATABASE)
    { "webkitIndexedDB", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerGlobalScopeWebkitIndexedDB), (intptr_t)0, NoIntrinsic },
#endif
#if ENABLE(INDEXED_DATABASE)
    { "webkitIDBCursor", DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerGlobalScopeWebkitIDBCursorConstructor), (intptr_t)setJSWorkerGlobalScopeWebkitIDBCursorConstructor, NoIntrinsic },
#endif
#if ENABLE(INDEXED_DATABASE)
    { "webkitIDBDatabase", DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerGlobalScopeWebkitIDBDatabaseConstructor), (intptr_t)setJSWorkerGlobalScopeWebkitIDBDatabaseConstructor, NoIntrinsic },
#endif
#if ENABLE(INDEXED_DATABASE)
    { "webkitIDBFactory", DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerGlobalScopeWebkitIDBFactoryConstructor), (intptr_t)setJSWorkerGlobalScopeWebkitIDBFactoryConstructor, NoIntrinsic },
#endif
#if ENABLE(INDEXED_DATABASE)
    { "webkitIDBIndex", DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerGlobalScopeWebkitIDBIndexConstructor), (intptr_t)setJSWorkerGlobalScopeWebkitIDBIndexConstructor, NoIntrinsic },
#endif
#if ENABLE(INDEXED_DATABASE)
    { "webkitIDBKeyRange", DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerGlobalScopeWebkitIDBKeyRangeConstructor), (intptr_t)setJSWorkerGlobalScopeWebkitIDBKeyRangeConstructor, NoIntrinsic },
#endif
#if ENABLE(INDEXED_DATABASE)
    { "webkitIDBObjectStore", DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerGlobalScopeWebkitIDBObjectStoreConstructor), (intptr_t)setJSWorkerGlobalScopeWebkitIDBObjectStoreConstructor, NoIntrinsic },
#endif
#if ENABLE(INDEXED_DATABASE)
    { "webkitIDBRequest", DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerGlobalScopeWebkitIDBRequestConstructor), (intptr_t)setJSWorkerGlobalScopeWebkitIDBRequestConstructor, NoIntrinsic },
#endif
#if ENABLE(INDEXED_DATABASE)
    { "webkitIDBTransaction", DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerGlobalScopeWebkitIDBTransactionConstructor), (intptr_t)setJSWorkerGlobalScopeWebkitIDBTransactionConstructor, NoIntrinsic },
#endif
#if ENABLE(INDEXED_DATABASE)
    { "indexedDB", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerGlobalScopeIndexedDB), (intptr_t)0, NoIntrinsic },
#endif
#if ENABLE(INDEXED_DATABASE)
    { "IDBCursor", DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerGlobalScopeIDBCursorConstructor), (intptr_t)setJSWorkerGlobalScopeIDBCursorConstructor, NoIntrinsic },
#endif
#if ENABLE(INDEXED_DATABASE)
    { "IDBCursorWithValue", DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerGlobalScopeIDBCursorWithValueConstructor), (intptr_t)setJSWorkerGlobalScopeIDBCursorWithValueConstructor, NoIntrinsic },
#endif
#if ENABLE(INDEXED_DATABASE)
    { "IDBDatabase", DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerGlobalScopeIDBDatabaseConstructor), (intptr_t)setJSWorkerGlobalScopeIDBDatabaseConstructor, NoIntrinsic },
#endif
#if ENABLE(INDEXED_DATABASE)
    { "IDBFactory", DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerGlobalScopeIDBFactoryConstructor), (intptr_t)setJSWorkerGlobalScopeIDBFactoryConstructor, NoIntrinsic },
#endif
#if ENABLE(INDEXED_DATABASE)
    { "IDBIndex", DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerGlobalScopeIDBIndexConstructor), (intptr_t)setJSWorkerGlobalScopeIDBIndexConstructor, NoIntrinsic },
#endif
#if ENABLE(INDEXED_DATABASE)
    { "IDBKeyRange", DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerGlobalScopeIDBKeyRangeConstructor), (intptr_t)setJSWorkerGlobalScopeIDBKeyRangeConstructor, NoIntrinsic },
#endif
#if ENABLE(INDEXED_DATABASE)
    { "IDBObjectStore", DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerGlobalScopeIDBObjectStoreConstructor), (intptr_t)setJSWorkerGlobalScopeIDBObjectStoreConstructor, NoIntrinsic },
#endif
#if ENABLE(INDEXED_DATABASE)
    { "IDBOpenDBRequest", DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerGlobalScopeIDBOpenDBRequestConstructor), (intptr_t)setJSWorkerGlobalScopeIDBOpenDBRequestConstructor, NoIntrinsic },
#endif
#if ENABLE(INDEXED_DATABASE)
    { "IDBRequest", DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerGlobalScopeIDBRequestConstructor), (intptr_t)setJSWorkerGlobalScopeIDBRequestConstructor, NoIntrinsic },
#endif
#if ENABLE(INDEXED_DATABASE)
    { "IDBTransaction", DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerGlobalScopeIDBTransactionConstructor), (intptr_t)setJSWorkerGlobalScopeIDBTransactionConstructor, NoIntrinsic },
#endif
#if ENABLE(INDEXED_DATABASE)
    { "IDBVersionChangeEvent", DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerGlobalScopeIDBVersionChangeEventConstructor), (intptr_t)setJSWorkerGlobalScopeIDBVersionChangeEventConstructor, NoIntrinsic },
#endif
#if ENABLE(LEGACY_NOTIFICATIONS) || ENABLE(NOTIFICATIONS)
    { "webkitNotifications", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerGlobalScopeWebkitNotifications), (intptr_t)0, NoIntrinsic },
#endif
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerGlobalScopeConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSWorkerGlobalScopeTable = { 140, 127, JSWorkerGlobalScopeTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSWorkerGlobalScopeConstructorTableValues[] =
{
#if ENABLE(FILE_SYSTEM)
    { "TEMPORARY", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerGlobalScopeTEMPORARY), (intptr_t)0, NoIntrinsic },
#endif
#if ENABLE(FILE_SYSTEM)
    { "PERSISTENT", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerGlobalScopePERSISTENT), (intptr_t)0, NoIntrinsic },
#endif
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSWorkerGlobalScopeConstructorTable = { 5, 3, JSWorkerGlobalScopeConstructorTableValues, 0 };

#if ENABLE(FILE_SYSTEM)
COMPILE_ASSERT(0 == WorkerGlobalScopeFileSystem::TEMPORARY, WorkerGlobalScopeEnumTEMPORARYIsWrongUseDoNotCheckConstants);
#endif
#if ENABLE(FILE_SYSTEM)
COMPILE_ASSERT(1 == WorkerGlobalScopeFileSystem::PERSISTENT, WorkerGlobalScopeEnumPERSISTENTIsWrongUseDoNotCheckConstants);
#endif

static const HashTable* getJSWorkerGlobalScopeConstructorTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->vm(), &JSWorkerGlobalScopeConstructorTable);
}

const ClassInfo JSWorkerGlobalScopeConstructor::s_info = { "WorkerGlobalScopeConstructor", &Base::s_info, 0, getJSWorkerGlobalScopeConstructorTable, CREATE_METHOD_TABLE(JSWorkerGlobalScopeConstructor) };

JSWorkerGlobalScopeConstructor::JSWorkerGlobalScopeConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSWorkerGlobalScopeConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, globalObject->prototype(), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(0), ReadOnly | DontDelete | DontEnum);
}

bool JSWorkerGlobalScopeConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSWorkerGlobalScopeConstructor, JSDOMWrapper>(exec, getJSWorkerGlobalScopeConstructorTable(exec), jsCast<JSWorkerGlobalScopeConstructor*>(cell), propertyName, slot);
}

bool JSWorkerGlobalScopeConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSWorkerGlobalScopeConstructor, JSDOMWrapper>(exec, getJSWorkerGlobalScopeConstructorTable(exec), jsCast<JSWorkerGlobalScopeConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSWorkerGlobalScopePrototypeTableValues[] =
{
#if ENABLE(FILE_SYSTEM)
    { "TEMPORARY", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerGlobalScopeTEMPORARY), (intptr_t)0, NoIntrinsic },
#endif
#if ENABLE(FILE_SYSTEM)
    { "PERSISTENT", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerGlobalScopePERSISTENT), (intptr_t)0, NoIntrinsic },
#endif
    { "close", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsWorkerGlobalScopePrototypeFunctionClose), (intptr_t)0, NoIntrinsic },
    { "importScripts", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsWorkerGlobalScopePrototypeFunctionImportScripts), (intptr_t)0, NoIntrinsic },
    { "addEventListener", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsWorkerGlobalScopePrototypeFunctionAddEventListener), (intptr_t)2, NoIntrinsic },
    { "removeEventListener", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsWorkerGlobalScopePrototypeFunctionRemoveEventListener), (intptr_t)2, NoIntrinsic },
    { "dispatchEvent", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsWorkerGlobalScopePrototypeFunctionDispatchEvent), (intptr_t)1, NoIntrinsic },
#if ENABLE(FILE_SYSTEM)
    { "webkitRequestFileSystem", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsWorkerGlobalScopePrototypeFunctionWebkitRequestFileSystem), (intptr_t)2, NoIntrinsic },
#endif
#if ENABLE(FILE_SYSTEM)
    { "webkitRequestFileSystemSync", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsWorkerGlobalScopePrototypeFunctionWebkitRequestFileSystemSync), (intptr_t)2, NoIntrinsic },
#endif
#if ENABLE(FILE_SYSTEM)
    { "webkitResolveLocalFileSystemURL", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsWorkerGlobalScopePrototypeFunctionWebkitResolveLocalFileSystemURL), (intptr_t)2, NoIntrinsic },
#endif
#if ENABLE(FILE_SYSTEM)
    { "webkitResolveLocalFileSystemSyncURL", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsWorkerGlobalScopePrototypeFunctionWebkitResolveLocalFileSystemSyncURL), (intptr_t)1, NoIntrinsic },
#endif
#if ENABLE(SQL_DATABASE)
    { "openDatabase", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsWorkerGlobalScopePrototypeFunctionOpenDatabase), (intptr_t)4, NoIntrinsic },
#endif
#if ENABLE(SQL_DATABASE)
    { "openDatabaseSync", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsWorkerGlobalScopePrototypeFunctionOpenDatabaseSync), (intptr_t)4, NoIntrinsic },
#endif
    { "setTimeout", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsWorkerGlobalScopePrototypeFunctionSetTimeout), (intptr_t)1, NoIntrinsic },
    { "clearTimeout", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsWorkerGlobalScopePrototypeFunctionClearTimeout), (intptr_t)0, NoIntrinsic },
    { "setInterval", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsWorkerGlobalScopePrototypeFunctionSetInterval), (intptr_t)1, NoIntrinsic },
    { "clearInterval", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsWorkerGlobalScopePrototypeFunctionClearInterval), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSWorkerGlobalScopePrototypeTable = { 68, 63, JSWorkerGlobalScopePrototypeTableValues, 0 };
static const HashTable* getJSWorkerGlobalScopePrototypeTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->vm(), &JSWorkerGlobalScopePrototypeTable);
}

const ClassInfo JSWorkerGlobalScopePrototype::s_info = { "WorkerGlobalScopePrototype", &Base::s_info, 0, getJSWorkerGlobalScopePrototypeTable, CREATE_METHOD_TABLE(JSWorkerGlobalScopePrototype) };

bool JSWorkerGlobalScopePrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSWorkerGlobalScopePrototype* thisObject = jsCast<JSWorkerGlobalScopePrototype*>(cell);
    return getStaticPropertySlot<JSWorkerGlobalScopePrototype, JSObject>(exec, getJSWorkerGlobalScopePrototypeTable(exec), thisObject, propertyName, slot);
}

bool JSWorkerGlobalScopePrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSWorkerGlobalScopePrototype* thisObject = jsCast<JSWorkerGlobalScopePrototype*>(object);
    return getStaticPropertyDescriptor<JSWorkerGlobalScopePrototype, JSObject>(exec, getJSWorkerGlobalScopePrototypeTable(exec), thisObject, propertyName, descriptor);
}

static const HashTable* getJSWorkerGlobalScopeTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->vm(), &JSWorkerGlobalScopeTable);
}

const ClassInfo JSWorkerGlobalScope::s_info = { "WorkerGlobalScope", &Base::s_info, 0, getJSWorkerGlobalScopeTable , CREATE_METHOD_TABLE(JSWorkerGlobalScope) };

JSWorkerGlobalScope::JSWorkerGlobalScope(VM& vm, Structure* structure, PassRefPtr<WorkerGlobalScope> impl)
    : JSWorkerGlobalScopeBase(vm, structure, impl)
{
}

bool JSWorkerGlobalScope::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSWorkerGlobalScope* thisObject = jsCast<JSWorkerGlobalScope*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    if (thisObject->getOwnPropertySlotDelegate(exec, propertyName, slot))
        return true;
    return getStaticValueSlot<JSWorkerGlobalScope, Base>(exec, getJSWorkerGlobalScopeTable(exec), thisObject, propertyName, slot);
}

bool JSWorkerGlobalScope::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSWorkerGlobalScope* thisObject = jsCast<JSWorkerGlobalScope*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    if (thisObject->getOwnPropertyDescriptorDelegate(exec, propertyName, descriptor))
        return true;
    return getStaticValueDescriptor<JSWorkerGlobalScope, Base>(exec, getJSWorkerGlobalScopeTable(exec), thisObject, propertyName, descriptor);
}

bool JSWorkerGlobalScope::getOwnPropertySlotByIndex(JSCell* cell, ExecState* exec, unsigned index, PropertySlot& slot)
{
    JSWorkerGlobalScope* thisObject = jsCast<JSWorkerGlobalScope*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    PropertyName propertyName = Identifier::from(exec, index);
    if (thisObject->getOwnPropertySlotDelegate(exec, propertyName, slot))
        return true;
    return Base::getOwnPropertySlotByIndex(thisObject, exec, index, slot);
}

JSValue jsWorkerGlobalScopeSelf(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWorkerGlobalScope* castedThis = jsCast<JSWorkerGlobalScope*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    WorkerGlobalScope* impl = static_cast<WorkerGlobalScope*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->self()));
    return result;
}


JSValue jsWorkerGlobalScopeLocation(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWorkerGlobalScope* castedThis = jsCast<JSWorkerGlobalScope*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    WorkerGlobalScope* impl = static_cast<WorkerGlobalScope*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->location()));
    return result;
}


JSValue jsWorkerGlobalScopeOnerror(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWorkerGlobalScope* castedThis = jsCast<JSWorkerGlobalScope*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    WorkerGlobalScope* impl = static_cast<WorkerGlobalScope*>(castedThis->impl());
    if (EventListener* listener = impl->onerror()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsWorkerGlobalScopeOnoffline(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWorkerGlobalScope* castedThis = jsCast<JSWorkerGlobalScope*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    WorkerGlobalScope* impl = static_cast<WorkerGlobalScope*>(castedThis->impl());
    if (EventListener* listener = impl->onoffline()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsWorkerGlobalScopeOnonline(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWorkerGlobalScope* castedThis = jsCast<JSWorkerGlobalScope*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    WorkerGlobalScope* impl = static_cast<WorkerGlobalScope*>(castedThis->impl());
    if (EventListener* listener = impl->ononline()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsWorkerGlobalScopeNavigator(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWorkerGlobalScope* castedThis = jsCast<JSWorkerGlobalScope*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    WorkerGlobalScope* impl = static_cast<WorkerGlobalScope*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->navigator()));
    return result;
}


#if ENABLE(BLOB)
JSValue jsWorkerGlobalScopeWebkitURLConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWorkerGlobalScope* castedThis = jsCast<JSWorkerGlobalScope*>(asObject(slotBase));
    return JSDOMURL::getConstructor(exec, castedThis->globalObject());
}

#endif

#if ENABLE(WEB_SOCKETS)
JSValue jsWorkerGlobalScopeWebSocketConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWorkerGlobalScope* castedThis = jsCast<JSWorkerGlobalScope*>(asObject(slotBase));
    if (!RuntimeEnabledFeatures::webSocketEnabled())
        return jsUndefined();
    return JSWebSocket::getConstructor(exec, castedThis->globalObject());
}

#endif

#if ENABLE(CHANNEL_MESSAGING)
JSValue jsWorkerGlobalScopeMessageChannelConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWorkerGlobalScope* castedThis = jsCast<JSWorkerGlobalScope*>(asObject(slotBase));
    return JSMessageChannel::getConstructor(exec, castedThis->globalObject());
}

#endif

JSValue jsWorkerGlobalScopeMessageEventConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWorkerGlobalScope* castedThis = jsCast<JSWorkerGlobalScope*>(asObject(slotBase));
    return JSMessageEvent::getConstructor(exec, castedThis->globalObject());
}


JSValue jsWorkerGlobalScopeBlobConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWorkerGlobalScope* castedThis = jsCast<JSWorkerGlobalScope*>(asObject(slotBase));
    return JSBlob::getConstructor(exec, castedThis->globalObject());
}


#if ENABLE(BLOB)
JSValue jsWorkerGlobalScopeFileReaderConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWorkerGlobalScope* castedThis = jsCast<JSWorkerGlobalScope*>(asObject(slotBase));
    return JSFileReader::getConstructor(exec, castedThis->globalObject());
}

#endif

#if ENABLE(BLOB)
JSValue jsWorkerGlobalScopeFileReaderSyncConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWorkerGlobalScope* castedThis = jsCast<JSWorkerGlobalScope*>(asObject(slotBase));
    return JSFileReaderSync::getConstructor(exec, castedThis->globalObject());
}

#endif

#if ENABLE(BLOB)
JSValue jsWorkerGlobalScopeURLConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWorkerGlobalScope* castedThis = jsCast<JSWorkerGlobalScope*>(asObject(slotBase));
    return JSDOMURL::getConstructor(exec, castedThis->globalObject());
}

#endif

JSValue jsWorkerGlobalScopeArrayBufferConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWorkerGlobalScope* castedThis = jsCast<JSWorkerGlobalScope*>(asObject(slotBase));
    return JSArrayBuffer::getConstructor(exec, castedThis->globalObject());
}


JSValue jsWorkerGlobalScopeDataViewConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWorkerGlobalScope* castedThis = jsCast<JSWorkerGlobalScope*>(asObject(slotBase));
    return JSDataView::getConstructor(exec, castedThis->globalObject());
}


JSValue jsWorkerGlobalScopeFloat32ArrayConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWorkerGlobalScope* castedThis = jsCast<JSWorkerGlobalScope*>(asObject(slotBase));
    return JSFloat32Array::getConstructor(exec, castedThis->globalObject());
}


JSValue jsWorkerGlobalScopeFloat64ArrayConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWorkerGlobalScope* castedThis = jsCast<JSWorkerGlobalScope*>(asObject(slotBase));
    return JSFloat64Array::getConstructor(exec, castedThis->globalObject());
}


JSValue jsWorkerGlobalScopeInt16ArrayConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWorkerGlobalScope* castedThis = jsCast<JSWorkerGlobalScope*>(asObject(slotBase));
    return JSInt16Array::getConstructor(exec, castedThis->globalObject());
}


JSValue jsWorkerGlobalScopeInt32ArrayConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWorkerGlobalScope* castedThis = jsCast<JSWorkerGlobalScope*>(asObject(slotBase));
    return JSInt32Array::getConstructor(exec, castedThis->globalObject());
}


JSValue jsWorkerGlobalScopeInt8ArrayConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWorkerGlobalScope* castedThis = jsCast<JSWorkerGlobalScope*>(asObject(slotBase));
    return JSInt8Array::getConstructor(exec, castedThis->globalObject());
}


JSValue jsWorkerGlobalScopeUint16ArrayConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWorkerGlobalScope* castedThis = jsCast<JSWorkerGlobalScope*>(asObject(slotBase));
    return JSUint16Array::getConstructor(exec, castedThis->globalObject());
}


JSValue jsWorkerGlobalScopeUint32ArrayConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWorkerGlobalScope* castedThis = jsCast<JSWorkerGlobalScope*>(asObject(slotBase));
    return JSUint32Array::getConstructor(exec, castedThis->globalObject());
}


JSValue jsWorkerGlobalScopeUint8ArrayConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWorkerGlobalScope* castedThis = jsCast<JSWorkerGlobalScope*>(asObject(slotBase));
    return JSUint8Array::getConstructor(exec, castedThis->globalObject());
}


JSValue jsWorkerGlobalScopeUint8ClampedArrayConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWorkerGlobalScope* castedThis = jsCast<JSWorkerGlobalScope*>(asObject(slotBase));
    return JSUint8ClampedArray::getConstructor(exec, castedThis->globalObject());
}


JSValue jsWorkerGlobalScopeEventSourceConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWorkerGlobalScope* castedThis = jsCast<JSWorkerGlobalScope*>(asObject(slotBase));
    return JSEventSource::getConstructor(exec, castedThis->globalObject());
}


#if ENABLE(WORKERS)
JSValue jsWorkerGlobalScopeWorkerGlobalScopeConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWorkerGlobalScope* castedThis = jsCast<JSWorkerGlobalScope*>(asObject(slotBase));
    return JSWorkerGlobalScope::getConstructor(exec, castedThis->globalObject());
}

#endif

#if ENABLE(WORKERS)
JSValue jsWorkerGlobalScopeWorkerLocationConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWorkerGlobalScope* castedThis = jsCast<JSWorkerGlobalScope*>(asObject(slotBase));
    return JSWorkerLocation::getConstructor(exec, castedThis->globalObject());
}

#endif

JSValue jsWorkerGlobalScopeXMLHttpRequestConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWorkerGlobalScope* castedThis = jsCast<JSWorkerGlobalScope*>(asObject(slotBase));
    return JSXMLHttpRequest::getConstructor(exec, castedThis->globalObject());
}


#if ENABLE(FILE_SYSTEM)
JSValue jsWorkerGlobalScopeFileErrorConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWorkerGlobalScope* castedThis = jsCast<JSWorkerGlobalScope*>(asObject(slotBase));
    return JSFileError::getConstructor(exec, castedThis->globalObject());
}

#endif

#if ENABLE(FILE_SYSTEM)
JSValue jsWorkerGlobalScopeFileExceptionConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWorkerGlobalScope* castedThis = jsCast<JSWorkerGlobalScope*>(asObject(slotBase));
    return JSFileException::getConstructor(exec, castedThis->globalObject());
}

#endif

#if ENABLE(INDEXED_DATABASE)
JSValue jsWorkerGlobalScopeWebkitIndexedDB(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWorkerGlobalScope* castedThis = jsCast<JSWorkerGlobalScope*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    WorkerGlobalScope* impl = static_cast<WorkerGlobalScope*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(WorkerGlobalScopeIndexedDatabase::indexedDB(impl)));
    return result;
}

#endif

#if ENABLE(INDEXED_DATABASE)
JSValue jsWorkerGlobalScopeWebkitIDBCursorConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWorkerGlobalScope* castedThis = jsCast<JSWorkerGlobalScope*>(asObject(slotBase));
    return JSIDBCursor::getConstructor(exec, castedThis->globalObject());
}

#endif

#if ENABLE(INDEXED_DATABASE)
JSValue jsWorkerGlobalScopeWebkitIDBDatabaseConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWorkerGlobalScope* castedThis = jsCast<JSWorkerGlobalScope*>(asObject(slotBase));
    return JSIDBDatabase::getConstructor(exec, castedThis->globalObject());
}

#endif

#if ENABLE(INDEXED_DATABASE)
JSValue jsWorkerGlobalScopeWebkitIDBFactoryConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWorkerGlobalScope* castedThis = jsCast<JSWorkerGlobalScope*>(asObject(slotBase));
    return JSIDBFactory::getConstructor(exec, castedThis->globalObject());
}

#endif

#if ENABLE(INDEXED_DATABASE)
JSValue jsWorkerGlobalScopeWebkitIDBIndexConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWorkerGlobalScope* castedThis = jsCast<JSWorkerGlobalScope*>(asObject(slotBase));
    return JSIDBIndex::getConstructor(exec, castedThis->globalObject());
}

#endif

#if ENABLE(INDEXED_DATABASE)
JSValue jsWorkerGlobalScopeWebkitIDBKeyRangeConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWorkerGlobalScope* castedThis = jsCast<JSWorkerGlobalScope*>(asObject(slotBase));
    return JSIDBKeyRange::getConstructor(exec, castedThis->globalObject());
}

#endif

#if ENABLE(INDEXED_DATABASE)
JSValue jsWorkerGlobalScopeWebkitIDBObjectStoreConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWorkerGlobalScope* castedThis = jsCast<JSWorkerGlobalScope*>(asObject(slotBase));
    return JSIDBObjectStore::getConstructor(exec, castedThis->globalObject());
}

#endif

#if ENABLE(INDEXED_DATABASE)
JSValue jsWorkerGlobalScopeWebkitIDBRequestConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWorkerGlobalScope* castedThis = jsCast<JSWorkerGlobalScope*>(asObject(slotBase));
    return JSIDBRequest::getConstructor(exec, castedThis->globalObject());
}

#endif

#if ENABLE(INDEXED_DATABASE)
JSValue jsWorkerGlobalScopeWebkitIDBTransactionConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWorkerGlobalScope* castedThis = jsCast<JSWorkerGlobalScope*>(asObject(slotBase));
    return JSIDBTransaction::getConstructor(exec, castedThis->globalObject());
}

#endif

#if ENABLE(INDEXED_DATABASE)
JSValue jsWorkerGlobalScopeIndexedDB(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWorkerGlobalScope* castedThis = jsCast<JSWorkerGlobalScope*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    WorkerGlobalScope* impl = static_cast<WorkerGlobalScope*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(WorkerGlobalScopeIndexedDatabase::indexedDB(impl)));
    return result;
}

#endif

#if ENABLE(INDEXED_DATABASE)
JSValue jsWorkerGlobalScopeIDBCursorConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWorkerGlobalScope* castedThis = jsCast<JSWorkerGlobalScope*>(asObject(slotBase));
    return JSIDBCursor::getConstructor(exec, castedThis->globalObject());
}

#endif

#if ENABLE(INDEXED_DATABASE)
JSValue jsWorkerGlobalScopeIDBCursorWithValueConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWorkerGlobalScope* castedThis = jsCast<JSWorkerGlobalScope*>(asObject(slotBase));
    return JSIDBCursorWithValue::getConstructor(exec, castedThis->globalObject());
}

#endif

#if ENABLE(INDEXED_DATABASE)
JSValue jsWorkerGlobalScopeIDBDatabaseConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWorkerGlobalScope* castedThis = jsCast<JSWorkerGlobalScope*>(asObject(slotBase));
    return JSIDBDatabase::getConstructor(exec, castedThis->globalObject());
}

#endif

#if ENABLE(INDEXED_DATABASE)
JSValue jsWorkerGlobalScopeIDBFactoryConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWorkerGlobalScope* castedThis = jsCast<JSWorkerGlobalScope*>(asObject(slotBase));
    return JSIDBFactory::getConstructor(exec, castedThis->globalObject());
}

#endif

#if ENABLE(INDEXED_DATABASE)
JSValue jsWorkerGlobalScopeIDBIndexConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWorkerGlobalScope* castedThis = jsCast<JSWorkerGlobalScope*>(asObject(slotBase));
    return JSIDBIndex::getConstructor(exec, castedThis->globalObject());
}

#endif

#if ENABLE(INDEXED_DATABASE)
JSValue jsWorkerGlobalScopeIDBKeyRangeConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWorkerGlobalScope* castedThis = jsCast<JSWorkerGlobalScope*>(asObject(slotBase));
    return JSIDBKeyRange::getConstructor(exec, castedThis->globalObject());
}

#endif

#if ENABLE(INDEXED_DATABASE)
JSValue jsWorkerGlobalScopeIDBObjectStoreConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWorkerGlobalScope* castedThis = jsCast<JSWorkerGlobalScope*>(asObject(slotBase));
    return JSIDBObjectStore::getConstructor(exec, castedThis->globalObject());
}

#endif

#if ENABLE(INDEXED_DATABASE)
JSValue jsWorkerGlobalScopeIDBOpenDBRequestConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWorkerGlobalScope* castedThis = jsCast<JSWorkerGlobalScope*>(asObject(slotBase));
    return JSIDBOpenDBRequest::getConstructor(exec, castedThis->globalObject());
}

#endif

#if ENABLE(INDEXED_DATABASE)
JSValue jsWorkerGlobalScopeIDBRequestConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWorkerGlobalScope* castedThis = jsCast<JSWorkerGlobalScope*>(asObject(slotBase));
    return JSIDBRequest::getConstructor(exec, castedThis->globalObject());
}

#endif

#if ENABLE(INDEXED_DATABASE)
JSValue jsWorkerGlobalScopeIDBTransactionConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWorkerGlobalScope* castedThis = jsCast<JSWorkerGlobalScope*>(asObject(slotBase));
    return JSIDBTransaction::getConstructor(exec, castedThis->globalObject());
}

#endif

#if ENABLE(INDEXED_DATABASE)
JSValue jsWorkerGlobalScopeIDBVersionChangeEventConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWorkerGlobalScope* castedThis = jsCast<JSWorkerGlobalScope*>(asObject(slotBase));
    return JSIDBVersionChangeEvent::getConstructor(exec, castedThis->globalObject());
}

#endif

#if ENABLE(LEGACY_NOTIFICATIONS) || ENABLE(NOTIFICATIONS)
JSValue jsWorkerGlobalScopeWebkitNotifications(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWorkerGlobalScope* castedThis = jsCast<JSWorkerGlobalScope*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    WorkerGlobalScope* impl = static_cast<WorkerGlobalScope*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(WorkerGlobalScopeNotifications::webkitNotifications(impl)));
    return result;
}

#endif

JSValue jsWorkerGlobalScopeConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWorkerGlobalScope* domObject = jsCast<JSWorkerGlobalScope*>(asObject(slotBase));
    return JSWorkerGlobalScope::getConstructor(exec, domObject->globalObject());
}

void JSWorkerGlobalScope::put(JSCell* cell, ExecState* exec, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    JSWorkerGlobalScope* thisObject = jsCast<JSWorkerGlobalScope*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    lookupPut<JSWorkerGlobalScope, Base>(exec, propertyName, value, getJSWorkerGlobalScopeTable(exec), thisObject, slot);
}

void setJSWorkerGlobalScopeSelf(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    // Shadowing a built-in object
    jsCast<JSWorkerGlobalScope*>(thisObject)->putDirect(exec->vm(), Identifier(exec, "self"), value);
}


void setJSWorkerGlobalScopeLocation(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    // Shadowing a built-in object
    jsCast<JSWorkerGlobalScope*>(thisObject)->putDirect(exec->vm(), Identifier(exec, "location"), value);
}


void setJSWorkerGlobalScopeOnerror(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSWorkerGlobalScope* castedThis = jsCast<JSWorkerGlobalScope*>(thisObject);
    WorkerGlobalScope* impl = static_cast<WorkerGlobalScope*>(castedThis->impl());
    impl->setOnerror(createJSErrorHandler(exec, value, thisObject));
}


void setJSWorkerGlobalScopeOnoffline(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSWorkerGlobalScope* castedThis = jsCast<JSWorkerGlobalScope*>(thisObject);
    WorkerGlobalScope* impl = static_cast<WorkerGlobalScope*>(castedThis->impl());
    impl->setOnoffline(createJSAttributeEventListener(exec, value, thisObject));
}


void setJSWorkerGlobalScopeOnonline(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSWorkerGlobalScope* castedThis = jsCast<JSWorkerGlobalScope*>(thisObject);
    WorkerGlobalScope* impl = static_cast<WorkerGlobalScope*>(castedThis->impl());
    impl->setOnonline(createJSAttributeEventListener(exec, value, thisObject));
}


void setJSWorkerGlobalScopeNavigator(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    // Shadowing a built-in object
    jsCast<JSWorkerGlobalScope*>(thisObject)->putDirect(exec->vm(), Identifier(exec, "navigator"), value);
}


#if ENABLE(BLOB)
void setJSWorkerGlobalScopeWebkitURLConstructor(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    // Shadowing a built-in constructor
    jsCast<JSWorkerGlobalScope*>(thisObject)->putDirect(exec->vm(), Identifier(exec, "webkitURL"), value);
}

#endif

#if ENABLE(WEB_SOCKETS)
void setJSWorkerGlobalScopeWebSocketConstructor(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    // Shadowing a built-in constructor
    jsCast<JSWorkerGlobalScope*>(thisObject)->putDirect(exec->vm(), Identifier(exec, "WebSocket"), value);
}

#endif

#if ENABLE(CHANNEL_MESSAGING)
void setJSWorkerGlobalScopeMessageChannelConstructor(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    // Shadowing a built-in constructor
    jsCast<JSWorkerGlobalScope*>(thisObject)->putDirect(exec->vm(), Identifier(exec, "MessageChannel"), value);
}

#endif

void setJSWorkerGlobalScopeMessageEventConstructor(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    // Shadowing a built-in constructor
    jsCast<JSWorkerGlobalScope*>(thisObject)->putDirect(exec->vm(), Identifier(exec, "MessageEvent"), value);
}


void setJSWorkerGlobalScopeBlobConstructor(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    // Shadowing a built-in constructor
    jsCast<JSWorkerGlobalScope*>(thisObject)->putDirect(exec->vm(), Identifier(exec, "Blob"), value);
}


#if ENABLE(BLOB)
void setJSWorkerGlobalScopeFileReaderConstructor(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    // Shadowing a built-in constructor
    jsCast<JSWorkerGlobalScope*>(thisObject)->putDirect(exec->vm(), Identifier(exec, "FileReader"), value);
}

#endif

#if ENABLE(BLOB)
void setJSWorkerGlobalScopeFileReaderSyncConstructor(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    // Shadowing a built-in constructor
    jsCast<JSWorkerGlobalScope*>(thisObject)->putDirect(exec->vm(), Identifier(exec, "FileReaderSync"), value);
}

#endif

#if ENABLE(BLOB)
void setJSWorkerGlobalScopeURLConstructor(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    // Shadowing a built-in constructor
    jsCast<JSWorkerGlobalScope*>(thisObject)->putDirect(exec->vm(), Identifier(exec, "URL"), value);
}

#endif

void setJSWorkerGlobalScopeArrayBufferConstructor(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    // Shadowing a built-in constructor
    jsCast<JSWorkerGlobalScope*>(thisObject)->putDirect(exec->vm(), Identifier(exec, "ArrayBuffer"), value);
}


void setJSWorkerGlobalScopeDataViewConstructor(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    // Shadowing a built-in constructor
    jsCast<JSWorkerGlobalScope*>(thisObject)->putDirect(exec->vm(), Identifier(exec, "DataView"), value);
}


void setJSWorkerGlobalScopeFloat32ArrayConstructor(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    // Shadowing a built-in constructor
    jsCast<JSWorkerGlobalScope*>(thisObject)->putDirect(exec->vm(), Identifier(exec, "Float32Array"), value);
}


void setJSWorkerGlobalScopeFloat64ArrayConstructor(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    // Shadowing a built-in constructor
    jsCast<JSWorkerGlobalScope*>(thisObject)->putDirect(exec->vm(), Identifier(exec, "Float64Array"), value);
}


void setJSWorkerGlobalScopeInt16ArrayConstructor(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    // Shadowing a built-in constructor
    jsCast<JSWorkerGlobalScope*>(thisObject)->putDirect(exec->vm(), Identifier(exec, "Int16Array"), value);
}


void setJSWorkerGlobalScopeInt32ArrayConstructor(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    // Shadowing a built-in constructor
    jsCast<JSWorkerGlobalScope*>(thisObject)->putDirect(exec->vm(), Identifier(exec, "Int32Array"), value);
}


void setJSWorkerGlobalScopeInt8ArrayConstructor(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    // Shadowing a built-in constructor
    jsCast<JSWorkerGlobalScope*>(thisObject)->putDirect(exec->vm(), Identifier(exec, "Int8Array"), value);
}


void setJSWorkerGlobalScopeUint16ArrayConstructor(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    // Shadowing a built-in constructor
    jsCast<JSWorkerGlobalScope*>(thisObject)->putDirect(exec->vm(), Identifier(exec, "Uint16Array"), value);
}


void setJSWorkerGlobalScopeUint32ArrayConstructor(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    // Shadowing a built-in constructor
    jsCast<JSWorkerGlobalScope*>(thisObject)->putDirect(exec->vm(), Identifier(exec, "Uint32Array"), value);
}


void setJSWorkerGlobalScopeUint8ArrayConstructor(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    // Shadowing a built-in constructor
    jsCast<JSWorkerGlobalScope*>(thisObject)->putDirect(exec->vm(), Identifier(exec, "Uint8Array"), value);
}


void setJSWorkerGlobalScopeUint8ClampedArrayConstructor(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    // Shadowing a built-in constructor
    jsCast<JSWorkerGlobalScope*>(thisObject)->putDirect(exec->vm(), Identifier(exec, "Uint8ClampedArray"), value);
}


void setJSWorkerGlobalScopeEventSourceConstructor(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    // Shadowing a built-in constructor
    jsCast<JSWorkerGlobalScope*>(thisObject)->putDirect(exec->vm(), Identifier(exec, "EventSource"), value);
}


#if ENABLE(WORKERS)
void setJSWorkerGlobalScopeWorkerGlobalScopeConstructor(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    // Shadowing a built-in constructor
    jsCast<JSWorkerGlobalScope*>(thisObject)->putDirect(exec->vm(), Identifier(exec, "WorkerGlobalScope"), value);
}

#endif

#if ENABLE(WORKERS)
void setJSWorkerGlobalScopeWorkerLocationConstructor(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    // Shadowing a built-in constructor
    jsCast<JSWorkerGlobalScope*>(thisObject)->putDirect(exec->vm(), Identifier(exec, "WorkerLocation"), value);
}

#endif

void setJSWorkerGlobalScopeXMLHttpRequestConstructor(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    // Shadowing a built-in constructor
    jsCast<JSWorkerGlobalScope*>(thisObject)->putDirect(exec->vm(), Identifier(exec, "XMLHttpRequest"), value);
}


#if ENABLE(FILE_SYSTEM)
void setJSWorkerGlobalScopeFileErrorConstructor(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    // Shadowing a built-in constructor
    jsCast<JSWorkerGlobalScope*>(thisObject)->putDirect(exec->vm(), Identifier(exec, "FileError"), value);
}

#endif

#if ENABLE(FILE_SYSTEM)
void setJSWorkerGlobalScopeFileExceptionConstructor(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    // Shadowing a built-in constructor
    jsCast<JSWorkerGlobalScope*>(thisObject)->putDirect(exec->vm(), Identifier(exec, "FileException"), value);
}

#endif

#if ENABLE(INDEXED_DATABASE)
void setJSWorkerGlobalScopeWebkitIDBCursorConstructor(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    // Shadowing a built-in constructor
    jsCast<JSWorkerGlobalScope*>(thisObject)->putDirect(exec->vm(), Identifier(exec, "webkitIDBCursor"), value);
}

#endif

#if ENABLE(INDEXED_DATABASE)
void setJSWorkerGlobalScopeWebkitIDBDatabaseConstructor(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    // Shadowing a built-in constructor
    jsCast<JSWorkerGlobalScope*>(thisObject)->putDirect(exec->vm(), Identifier(exec, "webkitIDBDatabase"), value);
}

#endif

#if ENABLE(INDEXED_DATABASE)
void setJSWorkerGlobalScopeWebkitIDBFactoryConstructor(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    // Shadowing a built-in constructor
    jsCast<JSWorkerGlobalScope*>(thisObject)->putDirect(exec->vm(), Identifier(exec, "webkitIDBFactory"), value);
}

#endif

#if ENABLE(INDEXED_DATABASE)
void setJSWorkerGlobalScopeWebkitIDBIndexConstructor(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    // Shadowing a built-in constructor
    jsCast<JSWorkerGlobalScope*>(thisObject)->putDirect(exec->vm(), Identifier(exec, "webkitIDBIndex"), value);
}

#endif

#if ENABLE(INDEXED_DATABASE)
void setJSWorkerGlobalScopeWebkitIDBKeyRangeConstructor(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    // Shadowing a built-in constructor
    jsCast<JSWorkerGlobalScope*>(thisObject)->putDirect(exec->vm(), Identifier(exec, "webkitIDBKeyRange"), value);
}

#endif

#if ENABLE(INDEXED_DATABASE)
void setJSWorkerGlobalScopeWebkitIDBObjectStoreConstructor(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    // Shadowing a built-in constructor
    jsCast<JSWorkerGlobalScope*>(thisObject)->putDirect(exec->vm(), Identifier(exec, "webkitIDBObjectStore"), value);
}

#endif

#if ENABLE(INDEXED_DATABASE)
void setJSWorkerGlobalScopeWebkitIDBRequestConstructor(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    // Shadowing a built-in constructor
    jsCast<JSWorkerGlobalScope*>(thisObject)->putDirect(exec->vm(), Identifier(exec, "webkitIDBRequest"), value);
}

#endif

#if ENABLE(INDEXED_DATABASE)
void setJSWorkerGlobalScopeWebkitIDBTransactionConstructor(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    // Shadowing a built-in constructor
    jsCast<JSWorkerGlobalScope*>(thisObject)->putDirect(exec->vm(), Identifier(exec, "webkitIDBTransaction"), value);
}

#endif

#if ENABLE(INDEXED_DATABASE)
void setJSWorkerGlobalScopeIDBCursorConstructor(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    // Shadowing a built-in constructor
    jsCast<JSWorkerGlobalScope*>(thisObject)->putDirect(exec->vm(), Identifier(exec, "IDBCursor"), value);
}

#endif

#if ENABLE(INDEXED_DATABASE)
void setJSWorkerGlobalScopeIDBCursorWithValueConstructor(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    // Shadowing a built-in constructor
    jsCast<JSWorkerGlobalScope*>(thisObject)->putDirect(exec->vm(), Identifier(exec, "IDBCursorWithValue"), value);
}

#endif

#if ENABLE(INDEXED_DATABASE)
void setJSWorkerGlobalScopeIDBDatabaseConstructor(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    // Shadowing a built-in constructor
    jsCast<JSWorkerGlobalScope*>(thisObject)->putDirect(exec->vm(), Identifier(exec, "IDBDatabase"), value);
}

#endif

#if ENABLE(INDEXED_DATABASE)
void setJSWorkerGlobalScopeIDBFactoryConstructor(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    // Shadowing a built-in constructor
    jsCast<JSWorkerGlobalScope*>(thisObject)->putDirect(exec->vm(), Identifier(exec, "IDBFactory"), value);
}

#endif

#if ENABLE(INDEXED_DATABASE)
void setJSWorkerGlobalScopeIDBIndexConstructor(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    // Shadowing a built-in constructor
    jsCast<JSWorkerGlobalScope*>(thisObject)->putDirect(exec->vm(), Identifier(exec, "IDBIndex"), value);
}

#endif

#if ENABLE(INDEXED_DATABASE)
void setJSWorkerGlobalScopeIDBKeyRangeConstructor(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    // Shadowing a built-in constructor
    jsCast<JSWorkerGlobalScope*>(thisObject)->putDirect(exec->vm(), Identifier(exec, "IDBKeyRange"), value);
}

#endif

#if ENABLE(INDEXED_DATABASE)
void setJSWorkerGlobalScopeIDBObjectStoreConstructor(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    // Shadowing a built-in constructor
    jsCast<JSWorkerGlobalScope*>(thisObject)->putDirect(exec->vm(), Identifier(exec, "IDBObjectStore"), value);
}

#endif

#if ENABLE(INDEXED_DATABASE)
void setJSWorkerGlobalScopeIDBOpenDBRequestConstructor(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    // Shadowing a built-in constructor
    jsCast<JSWorkerGlobalScope*>(thisObject)->putDirect(exec->vm(), Identifier(exec, "IDBOpenDBRequest"), value);
}

#endif

#if ENABLE(INDEXED_DATABASE)
void setJSWorkerGlobalScopeIDBRequestConstructor(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    // Shadowing a built-in constructor
    jsCast<JSWorkerGlobalScope*>(thisObject)->putDirect(exec->vm(), Identifier(exec, "IDBRequest"), value);
}

#endif

#if ENABLE(INDEXED_DATABASE)
void setJSWorkerGlobalScopeIDBTransactionConstructor(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    // Shadowing a built-in constructor
    jsCast<JSWorkerGlobalScope*>(thisObject)->putDirect(exec->vm(), Identifier(exec, "IDBTransaction"), value);
}

#endif

#if ENABLE(INDEXED_DATABASE)
void setJSWorkerGlobalScopeIDBVersionChangeEventConstructor(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    // Shadowing a built-in constructor
    jsCast<JSWorkerGlobalScope*>(thisObject)->putDirect(exec->vm(), Identifier(exec, "IDBVersionChangeEvent"), value);
}

#endif

JSValue JSWorkerGlobalScope::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSWorkerGlobalScopeConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsWorkerGlobalScopePrototypeFunctionClose(ExecState* exec)
{
    JSWorkerGlobalScope* castedThis = toJSWorkerGlobalScope(exec->hostThisValue().toThisObject(exec));
    if (!castedThis)
        return throwVMTypeError(exec);
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSWorkerGlobalScope::s_info);
    WorkerGlobalScope* impl = static_cast<WorkerGlobalScope*>(castedThis->impl());
    impl->close();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWorkerGlobalScopePrototypeFunctionImportScripts(ExecState* exec)
{
    JSWorkerGlobalScope* castedThis = toJSWorkerGlobalScope(exec->hostThisValue().toThisObject(exec));
    if (!castedThis)
        return throwVMTypeError(exec);
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSWorkerGlobalScope::s_info);
    return JSValue::encode(castedThis->importScripts(exec));
}

EncodedJSValue JSC_HOST_CALL jsWorkerGlobalScopePrototypeFunctionAddEventListener(ExecState* exec)
{
    JSWorkerGlobalScope* castedThis = toJSWorkerGlobalScope(exec->hostThisValue().toThisObject(exec));
    if (!castedThis)
        return throwVMTypeError(exec);
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSWorkerGlobalScope::s_info);
    WorkerGlobalScope* impl = static_cast<WorkerGlobalScope*>(castedThis->impl());
    JSValue listener = exec->argument(1);
    if (!listener.isObject())
        return JSValue::encode(jsUndefined());
    impl->addEventListener(exec->argument(0).toString(exec)->value(exec), JSEventListener::create(asObject(listener), castedThis, false, currentWorld(exec)), exec->argument(2).toBoolean(exec));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWorkerGlobalScopePrototypeFunctionRemoveEventListener(ExecState* exec)
{
    JSWorkerGlobalScope* castedThis = toJSWorkerGlobalScope(exec->hostThisValue().toThisObject(exec));
    if (!castedThis)
        return throwVMTypeError(exec);
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSWorkerGlobalScope::s_info);
    WorkerGlobalScope* impl = static_cast<WorkerGlobalScope*>(castedThis->impl());
    JSValue listener = exec->argument(1);
    if (!listener.isObject())
        return JSValue::encode(jsUndefined());
    impl->removeEventListener(exec->argument(0).toString(exec)->value(exec), JSEventListener::create(asObject(listener), castedThis, false, currentWorld(exec)).get(), exec->argument(2).toBoolean(exec));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWorkerGlobalScopePrototypeFunctionDispatchEvent(ExecState* exec)
{
    JSWorkerGlobalScope* castedThis = toJSWorkerGlobalScope(exec->hostThisValue().toThisObject(exec));
    if (!castedThis)
        return throwVMTypeError(exec);
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSWorkerGlobalScope::s_info);
    WorkerGlobalScope* impl = static_cast<WorkerGlobalScope*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Event* evt(toEvent(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsBoolean(impl->dispatchEvent(evt, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

#if ENABLE(FILE_SYSTEM)
EncodedJSValue JSC_HOST_CALL jsWorkerGlobalScopePrototypeFunctionWebkitRequestFileSystem(ExecState* exec)
{
    JSWorkerGlobalScope* castedThis = toJSWorkerGlobalScope(exec->hostThisValue().toThisObject(exec));
    if (!castedThis)
        return throwVMTypeError(exec);
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSWorkerGlobalScope::s_info);
    WorkerGlobalScope* impl = static_cast<WorkerGlobalScope*>(castedThis->impl());
    if (exec->argumentCount() < 2)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    unsigned short type(toUInt32(exec, exec->argument(0), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    long long size(toInt64(exec, exec->argument(1), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    RefPtr<FileSystemCallback> successCallback;
    if (exec->argumentCount() > 2 && !exec->argument(2).isUndefinedOrNull()) {
        if (!exec->argument(2).isFunction())
            return throwVMTypeError(exec);
        successCallback = JSFileSystemCallback::create(asObject(exec->argument(2)), castedThis->globalObject());
    }
    RefPtr<ErrorCallback> errorCallback;
    if (exec->argumentCount() > 3 && !exec->argument(3).isUndefinedOrNull()) {
        if (!exec->argument(3).isFunction())
            return throwVMTypeError(exec);
        errorCallback = JSErrorCallback::create(asObject(exec->argument(3)), castedThis->globalObject());
    }
    WorkerGlobalScopeFileSystem::webkitRequestFileSystem(impl, type, size, successCallback, errorCallback);
    return JSValue::encode(jsUndefined());
}

#endif

#if ENABLE(FILE_SYSTEM)
EncodedJSValue JSC_HOST_CALL jsWorkerGlobalScopePrototypeFunctionWebkitRequestFileSystemSync(ExecState* exec)
{
    JSWorkerGlobalScope* castedThis = toJSWorkerGlobalScope(exec->hostThisValue().toThisObject(exec));
    if (!castedThis)
        return throwVMTypeError(exec);
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSWorkerGlobalScope::s_info);
    WorkerGlobalScope* impl = static_cast<WorkerGlobalScope*>(castedThis->impl());
    if (exec->argumentCount() < 2)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    unsigned short type(toUInt32(exec, exec->argument(0), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    long long size(toInt64(exec, exec->argument(1), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(WorkerGlobalScopeFileSystem::webkitRequestFileSystemSync(impl, type, size, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

#endif

#if ENABLE(FILE_SYSTEM)
EncodedJSValue JSC_HOST_CALL jsWorkerGlobalScopePrototypeFunctionWebkitResolveLocalFileSystemURL(ExecState* exec)
{
    JSWorkerGlobalScope* castedThis = toJSWorkerGlobalScope(exec->hostThisValue().toThisObject(exec));
    if (!castedThis)
        return throwVMTypeError(exec);
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSWorkerGlobalScope::s_info);
    WorkerGlobalScope* impl = static_cast<WorkerGlobalScope*>(castedThis->impl());
    if (exec->argumentCount() < 2)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    const String& url(exec->argument(0).isEmpty() ? String() : exec->argument(0).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    if (exec->argumentCount() <= 1 || !exec->argument(1).isFunction())
        return throwVMTypeError(exec);
    RefPtr<EntryCallback> successCallback = JSEntryCallback::create(asObject(exec->argument(1)), castedThis->globalObject());
    RefPtr<ErrorCallback> errorCallback;
    if (exec->argumentCount() > 2 && !exec->argument(2).isUndefinedOrNull()) {
        if (!exec->argument(2).isFunction())
            return throwVMTypeError(exec);
        errorCallback = JSErrorCallback::create(asObject(exec->argument(2)), castedThis->globalObject());
    }
    WorkerGlobalScopeFileSystem::webkitResolveLocalFileSystemURL(impl, url, successCallback, errorCallback);
    return JSValue::encode(jsUndefined());
}

#endif

#if ENABLE(FILE_SYSTEM)
EncodedJSValue JSC_HOST_CALL jsWorkerGlobalScopePrototypeFunctionWebkitResolveLocalFileSystemSyncURL(ExecState* exec)
{
    JSWorkerGlobalScope* castedThis = toJSWorkerGlobalScope(exec->hostThisValue().toThisObject(exec));
    if (!castedThis)
        return throwVMTypeError(exec);
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSWorkerGlobalScope::s_info);
    WorkerGlobalScope* impl = static_cast<WorkerGlobalScope*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    const String& url(exec->argument(0).isEmpty() ? String() : exec->argument(0).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(WorkerGlobalScopeFileSystem::webkitResolveLocalFileSystemSyncURL(impl, url, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

#endif

#if ENABLE(SQL_DATABASE)
EncodedJSValue JSC_HOST_CALL jsWorkerGlobalScopePrototypeFunctionOpenDatabase(ExecState* exec)
{
    JSWorkerGlobalScope* castedThis = toJSWorkerGlobalScope(exec->hostThisValue().toThisObject(exec));
    if (!castedThis)
        return throwVMTypeError(exec);
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSWorkerGlobalScope::s_info);
    WorkerGlobalScope* impl = static_cast<WorkerGlobalScope*>(castedThis->impl());
    if (exec->argumentCount() < 4)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    const String& name(exec->argument(0).isEmpty() ? String() : exec->argument(0).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    const String& version(exec->argument(1).isEmpty() ? String() : exec->argument(1).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    const String& displayName(exec->argument(2).isEmpty() ? String() : exec->argument(2).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    unsigned estimatedSize(toUInt32(exec, exec->argument(3), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    RefPtr<DatabaseCallback> creationCallback;
    if (exec->argumentCount() > 4 && !exec->argument(4).isUndefinedOrNull()) {
        if (!exec->argument(4).isFunction())
            return throwVMTypeError(exec);
        creationCallback = JSDatabaseCallback::create(asObject(exec->argument(4)), castedThis->globalObject());
    }

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(WorkerGlobalScopeWebDatabase::openDatabase(impl, name, version, displayName, estimatedSize, creationCallback, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

#endif

#if ENABLE(SQL_DATABASE)
EncodedJSValue JSC_HOST_CALL jsWorkerGlobalScopePrototypeFunctionOpenDatabaseSync(ExecState* exec)
{
    JSWorkerGlobalScope* castedThis = toJSWorkerGlobalScope(exec->hostThisValue().toThisObject(exec));
    if (!castedThis)
        return throwVMTypeError(exec);
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSWorkerGlobalScope::s_info);
    WorkerGlobalScope* impl = static_cast<WorkerGlobalScope*>(castedThis->impl());
    if (exec->argumentCount() < 4)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    const String& name(exec->argument(0).isEmpty() ? String() : exec->argument(0).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    const String& version(exec->argument(1).isEmpty() ? String() : exec->argument(1).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    const String& displayName(exec->argument(2).isEmpty() ? String() : exec->argument(2).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    unsigned estimatedSize(toUInt32(exec, exec->argument(3), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    RefPtr<DatabaseCallback> creationCallback;
    if (exec->argumentCount() > 4 && !exec->argument(4).isUndefinedOrNull()) {
        if (!exec->argument(4).isFunction())
            return throwVMTypeError(exec);
        creationCallback = JSDatabaseCallback::create(asObject(exec->argument(4)), castedThis->globalObject());
    }

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(WorkerGlobalScopeWebDatabase::openDatabaseSync(impl, name, version, displayName, estimatedSize, creationCallback, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

#endif

EncodedJSValue JSC_HOST_CALL jsWorkerGlobalScopePrototypeFunctionSetTimeout(ExecState* exec)
{
    JSWorkerGlobalScope* castedThis = toJSWorkerGlobalScope(exec->hostThisValue().toThisObject(exec));
    if (!castedThis)
        return throwVMTypeError(exec);
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSWorkerGlobalScope::s_info);
    return JSValue::encode(castedThis->setTimeout(exec));
}

EncodedJSValue JSC_HOST_CALL jsWorkerGlobalScopePrototypeFunctionClearTimeout(ExecState* exec)
{
    JSWorkerGlobalScope* castedThis = toJSWorkerGlobalScope(exec->hostThisValue().toThisObject(exec));
    if (!castedThis)
        return throwVMTypeError(exec);
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSWorkerGlobalScope::s_info);
    WorkerGlobalScope* impl = static_cast<WorkerGlobalScope*>(castedThis->impl());
    int handle(toInt32(exec, exec->argument(0), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->clearTimeout(handle);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWorkerGlobalScopePrototypeFunctionSetInterval(ExecState* exec)
{
    JSWorkerGlobalScope* castedThis = toJSWorkerGlobalScope(exec->hostThisValue().toThisObject(exec));
    if (!castedThis)
        return throwVMTypeError(exec);
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSWorkerGlobalScope::s_info);
    return JSValue::encode(castedThis->setInterval(exec));
}

EncodedJSValue JSC_HOST_CALL jsWorkerGlobalScopePrototypeFunctionClearInterval(ExecState* exec)
{
    JSWorkerGlobalScope* castedThis = toJSWorkerGlobalScope(exec->hostThisValue().toThisObject(exec));
    if (!castedThis)
        return throwVMTypeError(exec);
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSWorkerGlobalScope::s_info);
    WorkerGlobalScope* impl = static_cast<WorkerGlobalScope*>(castedThis->impl());
    int handle(toInt32(exec, exec->argument(0), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->clearInterval(handle);
    return JSValue::encode(jsUndefined());
}

// Constant getters

#if ENABLE(FILE_SYSTEM)
JSValue jsWorkerGlobalScopeTEMPORARY(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(0));
}

#endif
#if ENABLE(FILE_SYSTEM)
JSValue jsWorkerGlobalScopePERSISTENT(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(1));
}

#endif

}

#endif // ENABLE(WORKERS)
