#!/usr/bin/perl
# Author: Todd Larason <jtl@molehill.org>
# $XFree86: xc/programs/xterm/vttests/256colors2.pl,v 1.2 2002/03/26 01:46:43 dickey Exp $
# Adapted for Cygwin by Andrew Schulman <andrex.e.schulman@gmail.com>

# System colors

print "System colors:\n";
for ($color = 0; $color < 8; $color++) {
    print "\x1b[48;5;${color}m  ";
}
print "\x1b[0m\n";
for ($color = 8; $color < 16; $color++) {
    print "\x1b[48;5;${color}m  ";
}
print "\x1b[0m\n\n";

# Color cube

print "Color cube, 6x6x6:\n";
for ($green = 0; $green < 6; $green++) {
    for ($red = 0; $red < 6; $red++) {
	for ($blue = 0; $blue < 6; $blue++) {
	    $color = 16 + ($red * 36) + ($green * 6) + $blue;
	    print "\x1b[48;5;${color}m  ";
	}
	print "\x1b[0m ";
    }
    print "\n";
}


# Grayscale ramp

print "\nGrayscale ramp:\n";
for ($color = 232; $color < 256; $color++) {
    print "\x1b[48;5;${color}m  ";
}
print "\x1b[0m\n";

# Interpretation

print <<END;

If your terminal supports
this many colors:                  8    16    256

Then you'll see about this many
distinct shades of color above:
System colors ..................   8    16   8-16
Color squares (each) ...........   3    10     36
Greyscale ramp (incl. black) ...   1     4     25

See /usr/share/doc/screen/README.Cygwin for information about 256-color
terminal support in Cygwin.
END
