// generated by makecode.pl
#include "dbusclientinterface.h"
#include "dbus/dbusserialization.h"
#include "dbus/dbuscpp/dbusobjectinterface.h"
#include "dbus/dbuscpp/dbusmessagereader.h"
#include "dbus/dbuscpp/dbusmessagewriter.h"
#include <sstream>
class PrivateDBusClientInterface : public DBusObjectInterface {
private:
    DBusClientInterface& impl;
    typedef void (PrivateDBusClientInterface::*handlerFunction)
        (DBusMessage* msg, DBusConnection* conn);
    std::map<std::string, handlerFunction> handlers;
    DBusHandlerResult handleCall(DBusConnection*c,DBusMessage* m);
    std::string getIntrospectionXML();
    void setFilters(DBusMessage* msg, DBusConnection* conn);
    void getStatus(DBusMessage* msg, DBusConnection* conn);
    void getFieldNames(DBusMessage* msg, DBusConnection* conn);
    void countHits(DBusMessage* msg, DBusConnection* conn);
    void getHits(DBusMessage* msg, DBusConnection* conn);
    void getFilters(DBusMessage* msg, DBusConnection* conn);
    void getBackEnds(DBusMessage* msg, DBusConnection* conn);
    void countKeywords(DBusMessage* msg, DBusConnection* conn);
    void stopDaemon(DBusMessage* msg, DBusConnection* conn);
    void indexFile(DBusMessage* msg, DBusConnection* conn);
    void getIndexedDirectories(DBusMessage* msg, DBusConnection* conn);
    void startIndexing(DBusMessage* msg, DBusConnection* conn);
    void getKeywords(DBusMessage* msg, DBusConnection* conn);
    void stopIndexing(DBusMessage* msg, DBusConnection* conn);
    void setIndexedDirectories(DBusMessage* msg, DBusConnection* conn);
    void getIndexedFiles(DBusMessage* msg, DBusConnection* conn);
    void getHistogram(DBusMessage* msg, DBusConnection* conn);
public:
    PrivateDBusClientInterface(DBusClientInterface& i);
};
PrivateDBusClientInterface::PrivateDBusClientInterface(DBusClientInterface& i)
        :DBusObjectInterface("vandenoever.strigi"), impl(i) {
    handlers["setFilters"] = &PrivateDBusClientInterface::setFilters;
    handlers["getStatus"] = &PrivateDBusClientInterface::getStatus;
    handlers["getFieldNames"] = &PrivateDBusClientInterface::getFieldNames;
    handlers["countHits"] = &PrivateDBusClientInterface::countHits;
    handlers["getHits"] = &PrivateDBusClientInterface::getHits;
    handlers["getFilters"] = &PrivateDBusClientInterface::getFilters;
    handlers["getBackEnds"] = &PrivateDBusClientInterface::getBackEnds;
    handlers["countKeywords"] = &PrivateDBusClientInterface::countKeywords;
    handlers["stopDaemon"] = &PrivateDBusClientInterface::stopDaemon;
    handlers["indexFile"] = &PrivateDBusClientInterface::indexFile;
    handlers["getIndexedDirectories"] = &PrivateDBusClientInterface::getIndexedDirectories;
    handlers["startIndexing"] = &PrivateDBusClientInterface::startIndexing;
    handlers["getKeywords"] = &PrivateDBusClientInterface::getKeywords;
    handlers["stopIndexing"] = &PrivateDBusClientInterface::stopIndexing;
    handlers["setIndexedDirectories"] = &PrivateDBusClientInterface::setIndexedDirectories;
    handlers["getIndexedFiles"] = &PrivateDBusClientInterface::getIndexedFiles;
    handlers["getHistogram"] = &PrivateDBusClientInterface::getHistogram;
}
DBusHandlerResult
PrivateDBusClientInterface::handleCall(DBusConnection*connection, DBusMessage* msg) {
    std::map<std::string, handlerFunction>::const_iterator h;
    const char* i = getInterfaceName().c_str();
    for (h = handlers.begin(); h != handlers.end(); ++h) {
        if (dbus_message_is_method_call(msg, i, h->first.c_str())) {
            (this->*h->second)(msg, connection);
            return DBUS_HANDLER_RESULT_HANDLED;
        }
    }
    return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
}
std::string
PrivateDBusClientInterface::getIntrospectionXML() {
    std::ostringstream xml;
    xml << "  <interface name='"+getInterfaceName()+"'>\n"
    << "    <method name='setFilters'>\n"
    << "      <arg name='rules' type='a(bs)' direction='in'/>\n"
    << "    </method>\n"
    << "    <method name='getStatus'>\n"
    << "      <arg name='out' type='a{ss}' direction='out'/>\n"
    << "    </method>\n"
    << "    <method name='getFieldNames'>\n"
    << "      <arg name='out' type='as' direction='out'/>\n"
    << "    </method>\n"
    << "    <method name='countHits'>\n"
    << "      <arg name='query' type='s' direction='in'/>\n"
    << "      <arg name='out' type='i' direction='out'/>\n"
    << "    </method>\n"
    << "    <method name='getHits'>\n"
    << "      <arg name='query' type='s' direction='in'/>\n"
    << "      <arg name='max' type='u' direction='in'/>\n"
    << "      <arg name='offset' type='u' direction='in'/>\n"
    << "      <arg name='out' type='a(sdsssxxa{sas})' direction='out'/>\n"
    << "    </method>\n"
    << "    <method name='getFilters'>\n"
    << "      <arg name='out' type='a(bs)' direction='out'/>\n"
    << "    </method>\n"
    << "    <method name='getBackEnds'>\n"
    << "      <arg name='out' type='as' direction='out'/>\n"
    << "    </method>\n"
    << "    <method name='countKeywords'>\n"
    << "      <arg name='keywordprefix' type='s' direction='in'/>\n"
    << "      <arg name='fieldnames' type='as' direction='in'/>\n"
    << "      <arg name='out' type='i' direction='out'/>\n"
    << "    </method>\n"
    << "    <method name='stopDaemon'>\n"
    << "      <arg name='out' type='s' direction='out'/>\n"
    << "    </method>\n"
    << "    <method name='indexFile'>\n"
    << "      <arg name='path' type='s' direction='in'/>\n"
    << "      <arg name='mtime' type='t' direction='in'/>\n"
    << "      <arg name='content' type='ay' direction='in'/>\n"
    << "    </method>\n"
    << "    <method name='getIndexedDirectories'>\n"
    << "      <arg name='out' type='as' direction='out'/>\n"
    << "    </method>\n"
    << "    <method name='startIndexing'>\n"
    << "      <arg name='out' type='s' direction='out'/>\n"
    << "    </method>\n"
    << "    <method name='getKeywords'>\n"
    << "      <arg name='keywordmatch' type='s' direction='in'/>\n"
    << "      <arg name='fieldnames' type='as' direction='in'/>\n"
    << "      <arg name='max' type='u' direction='in'/>\n"
    << "      <arg name='offset' type='u' direction='in'/>\n"
    << "      <arg name='out' type='as' direction='out'/>\n"
    << "    </method>\n"
    << "    <method name='stopIndexing'>\n"
    << "      <arg name='out' type='s' direction='out'/>\n"
    << "    </method>\n"
    << "    <method name='setIndexedDirectories'>\n"
    << "      <arg name='d' type='as' direction='in'/>\n"
    << "      <arg name='out' type='s' direction='out'/>\n"
    << "    </method>\n"
    << "    <method name='getIndexedFiles'>\n"
    << "      <arg name='out' type='as' direction='out'/>\n"
    << "    </method>\n"
    << "    <method name='getHistogram'>\n"
    << "      <arg name='query' type='s' direction='in'/>\n"
    << "      <arg name='field' type='s' direction='in'/>\n"
    << "      <arg name='labeltype' type='s' direction='in'/>\n"
    << "      <arg name='out' type='a(su)' direction='out'/>\n"
    << "    </method>\n"
    << "  </interface>\n";
    return xml.str();
}
void
PrivateDBusClientInterface::setFilters(DBusMessage* msg, DBusConnection* conn) {
    DBusMessageWriter writer(conn, msg);
    try {
        DBusMessageReader reader(msg);
        std::vector<std::pair<bool,std::string> > rules;
        reader >> rules;
        if (!reader.isOk()) {
            writer.setError("Invalid input.");
        } else if (!reader.atEnd()) {
            writer.setError("Too many arguments.");
        } else {
            impl.setFilters(rules);
        }
    } catch (const std::exception& e) {
        writer.setError(e.what());
    } catch (...) {
        writer.setError("");
    }
}
void
PrivateDBusClientInterface::getStatus(DBusMessage* msg, DBusConnection* conn) {
    DBusMessageWriter writer(conn, msg);
    try {
        DBusMessageReader reader(msg);
        if (!reader.isOk()) {
            writer.setError("Invalid input.");
        } else if (!reader.atEnd()) {
            writer.setError("Too many arguments.");
        } else {
            writer << impl.getStatus();
        }
    } catch (const std::exception& e) {
        writer.setError(e.what());
    } catch (...) {
        writer.setError("");
    }
}
void
PrivateDBusClientInterface::getFieldNames(DBusMessage* msg, DBusConnection* conn) {
    DBusMessageWriter writer(conn, msg);
    try {
        DBusMessageReader reader(msg);
        if (!reader.isOk()) {
            writer.setError("Invalid input.");
        } else if (!reader.atEnd()) {
            writer.setError("Too many arguments.");
        } else {
            writer << impl.getFieldNames();
        }
    } catch (const std::exception& e) {
        writer.setError(e.what());
    } catch (...) {
        writer.setError("");
    }
}
void
PrivateDBusClientInterface::countHits(DBusMessage* msg, DBusConnection* conn) {
    DBusMessageWriter writer(conn, msg);
    try {
        DBusMessageReader reader(msg);
        std::string query;
        reader >> query;
        if (!reader.isOk()) {
            writer.setError("Invalid input.");
        } else if (!reader.atEnd()) {
            writer.setError("Too many arguments.");
        } else {
            writer << impl.countHits(query);
        }
    } catch (const std::exception& e) {
        writer.setError(e.what());
    } catch (...) {
        writer.setError("");
    }
}
void
PrivateDBusClientInterface::getHits(DBusMessage* msg, DBusConnection* conn) {
    DBusMessageWriter writer(conn, msg);
    try {
        DBusMessageReader reader(msg);
        std::string query;
        uint32_t max;
        uint32_t offset;
        reader >> query >> max >> offset;
        if (!reader.isOk()) {
            writer.setError("Invalid input.");
        } else if (!reader.atEnd()) {
            writer.setError("Too many arguments.");
        } else {
            writer << impl.getHits(query,max,offset);
        }
    } catch (const std::exception& e) {
        writer.setError(e.what());
    } catch (...) {
        writer.setError("");
    }
}
void
PrivateDBusClientInterface::getFilters(DBusMessage* msg, DBusConnection* conn) {
    DBusMessageWriter writer(conn, msg);
    try {
        DBusMessageReader reader(msg);
        if (!reader.isOk()) {
            writer.setError("Invalid input.");
        } else if (!reader.atEnd()) {
            writer.setError("Too many arguments.");
        } else {
            writer << impl.getFilters();
        }
    } catch (const std::exception& e) {
        writer.setError(e.what());
    } catch (...) {
        writer.setError("");
    }
}
void
PrivateDBusClientInterface::getBackEnds(DBusMessage* msg, DBusConnection* conn) {
    DBusMessageWriter writer(conn, msg);
    try {
        DBusMessageReader reader(msg);
        if (!reader.isOk()) {
            writer.setError("Invalid input.");
        } else if (!reader.atEnd()) {
            writer.setError("Too many arguments.");
        } else {
            writer << impl.getBackEnds();
        }
    } catch (const std::exception& e) {
        writer.setError(e.what());
    } catch (...) {
        writer.setError("");
    }
}
void
PrivateDBusClientInterface::countKeywords(DBusMessage* msg, DBusConnection* conn) {
    DBusMessageWriter writer(conn, msg);
    try {
        DBusMessageReader reader(msg);
        std::string keywordprefix;
        std::vector<std::string> fieldnames;
        reader >> keywordprefix >> fieldnames;
        if (!reader.isOk()) {
            writer.setError("Invalid input.");
        } else if (!reader.atEnd()) {
            writer.setError("Too many arguments.");
        } else {
            writer << impl.countKeywords(keywordprefix,fieldnames);
        }
    } catch (const std::exception& e) {
        writer.setError(e.what());
    } catch (...) {
        writer.setError("");
    }
}
void
PrivateDBusClientInterface::stopDaemon(DBusMessage* msg, DBusConnection* conn) {
    DBusMessageWriter writer(conn, msg);
    try {
        DBusMessageReader reader(msg);
        if (!reader.isOk()) {
            writer.setError("Invalid input.");
        } else if (!reader.atEnd()) {
            writer.setError("Too many arguments.");
        } else {
            writer << impl.stopDaemon();
        }
    } catch (const std::exception& e) {
        writer.setError(e.what());
    } catch (...) {
        writer.setError("");
    }
}
void
PrivateDBusClientInterface::indexFile(DBusMessage* msg, DBusConnection* conn) {
    DBusMessageWriter writer(conn, msg);
    try {
        DBusMessageReader reader(msg);
        std::string path;
        uint64_t mtime;
        std::vector<char> content;
        reader >> path >> mtime >> content;
        if (!reader.isOk()) {
            writer.setError("Invalid input.");
        } else if (!reader.atEnd()) {
            writer.setError("Too many arguments.");
        } else {
            impl.indexFile(path,mtime,content);
        }
    } catch (const std::exception& e) {
        writer.setError(e.what());
    } catch (...) {
        writer.setError("");
    }
}
void
PrivateDBusClientInterface::getIndexedDirectories(DBusMessage* msg, DBusConnection* conn) {
    DBusMessageWriter writer(conn, msg);
    try {
        DBusMessageReader reader(msg);
        if (!reader.isOk()) {
            writer.setError("Invalid input.");
        } else if (!reader.atEnd()) {
            writer.setError("Too many arguments.");
        } else {
            writer << impl.getIndexedDirectories();
        }
    } catch (const std::exception& e) {
        writer.setError(e.what());
    } catch (...) {
        writer.setError("");
    }
}
void
PrivateDBusClientInterface::startIndexing(DBusMessage* msg, DBusConnection* conn) {
    DBusMessageWriter writer(conn, msg);
    try {
        DBusMessageReader reader(msg);
        if (!reader.isOk()) {
            writer.setError("Invalid input.");
        } else if (!reader.atEnd()) {
            writer.setError("Too many arguments.");
        } else {
            writer << impl.startIndexing();
        }
    } catch (const std::exception& e) {
        writer.setError(e.what());
    } catch (...) {
        writer.setError("");
    }
}
void
PrivateDBusClientInterface::getKeywords(DBusMessage* msg, DBusConnection* conn) {
    DBusMessageWriter writer(conn, msg);
    try {
        DBusMessageReader reader(msg);
        std::string keywordmatch;
        std::vector<std::string> fieldnames;
        uint32_t max;
        uint32_t offset;
        reader >> keywordmatch >> fieldnames >> max >> offset;
        if (!reader.isOk()) {
            writer.setError("Invalid input.");
        } else if (!reader.atEnd()) {
            writer.setError("Too many arguments.");
        } else {
            writer << impl.getKeywords(keywordmatch,fieldnames,max,offset);
        }
    } catch (const std::exception& e) {
        writer.setError(e.what());
    } catch (...) {
        writer.setError("");
    }
}
void
PrivateDBusClientInterface::stopIndexing(DBusMessage* msg, DBusConnection* conn) {
    DBusMessageWriter writer(conn, msg);
    try {
        DBusMessageReader reader(msg);
        if (!reader.isOk()) {
            writer.setError("Invalid input.");
        } else if (!reader.atEnd()) {
            writer.setError("Too many arguments.");
        } else {
            writer << impl.stopIndexing();
        }
    } catch (const std::exception& e) {
        writer.setError(e.what());
    } catch (...) {
        writer.setError("");
    }
}
void
PrivateDBusClientInterface::setIndexedDirectories(DBusMessage* msg, DBusConnection* conn) {
    DBusMessageWriter writer(conn, msg);
    try {
        DBusMessageReader reader(msg);
        std::set<std::string> d;
        reader >> d;
        if (!reader.isOk()) {
            writer.setError("Invalid input.");
        } else if (!reader.atEnd()) {
            writer.setError("Too many arguments.");
        } else {
            writer << impl.setIndexedDirectories(d);
        }
    } catch (const std::exception& e) {
        writer.setError(e.what());
    } catch (...) {
        writer.setError("");
    }
}
void
PrivateDBusClientInterface::getIndexedFiles(DBusMessage* msg, DBusConnection* conn) {
    DBusMessageWriter writer(conn, msg);
    try {
        DBusMessageReader reader(msg);
        if (!reader.isOk()) {
            writer.setError("Invalid input.");
        } else if (!reader.atEnd()) {
            writer.setError("Too many arguments.");
        } else {
            writer << impl.getIndexedFiles();
        }
    } catch (const std::exception& e) {
        writer.setError(e.what());
    } catch (...) {
        writer.setError("");
    }
}
void
PrivateDBusClientInterface::getHistogram(DBusMessage* msg, DBusConnection* conn) {
    DBusMessageWriter writer(conn, msg);
    try {
        DBusMessageReader reader(msg);
        std::string query;
        std::string field;
        std::string labeltype;
        reader >> query >> field >> labeltype;
        if (!reader.isOk()) {
            writer.setError("Invalid input.");
        } else if (!reader.atEnd()) {
            writer.setError("Too many arguments.");
        } else {
            writer << impl.getHistogram(query,field,labeltype);
        }
    } catch (const std::exception& e) {
        writer.setError(e.what());
    } catch (...) {
        writer.setError("");
    }
}
DBusClientInterface::DBusClientInterface(const std::string& on, DBusConnection* c, ClientInterface* i) 
        :ClientInterface(i), object(on), conn(c), iface(new PrivateDBusClientInterface(*this)) {}
DBusClientInterface::~DBusClientInterface() {
    delete iface;
}
