#include "_gen/svc.h"

#include <telepathy-glib/dbus.h>
#include "_gen/signals-marshal.h"

static const DBusGObjectInfo _haze_svc_connection_interface_mail_notification_object_info;

struct _HazeSvcConnectionInterfaceMailNotificationClass {
    GTypeInterface parent_class;
    haze_svc_connection_interface_mail_notification_subscribe_impl subscribe;
    haze_svc_connection_interface_mail_notification_unsubscribe_impl unsubscribe;
    haze_svc_connection_interface_mail_notification_request_inbox_url_impl request_inbox_url;
    haze_svc_connection_interface_mail_notification_request_mail_url_impl request_mail_url;
};

enum {
    SIGNAL_CONNECTION_INTERFACE_MAIL_NOTIFICATION_MailsReceived,
    SIGNAL_CONNECTION_INTERFACE_MAIL_NOTIFICATION_UnreadMailsChanged,
    N_CONNECTION_INTERFACE_MAIL_NOTIFICATION_SIGNALS
};
static guint connection_interface_mail_notification_signals[N_CONNECTION_INTERFACE_MAIL_NOTIFICATION_SIGNALS] = {0};

static void haze_svc_connection_interface_mail_notification_base_init (gpointer klass);

GType
haze_svc_connection_interface_mail_notification_get_type (void)
{
  static GType type = 0;

  if (G_UNLIKELY (type == 0))
    {
      static const GTypeInfo info = {
        sizeof (HazeSvcConnectionInterfaceMailNotificationClass),
        haze_svc_connection_interface_mail_notification_base_init, /* base_init */
        NULL, /* base_finalize */
        NULL, /* class_init */
        NULL, /* class_finalize */
        NULL, /* class_data */
        0,
        0, /* n_preallocs */
        NULL /* instance_init */
      };

      type = g_type_register_static (G_TYPE_INTERFACE,
          "HazeSvcConnectionInterfaceMailNotification", &info, 0);
    }

  return type;
}

/**
 * haze_svc_connection_interface_mail_notification_subscribe_impl:
 * @self: The object implementing this interface
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * Subscribe on interface org.freedesktop.Telepathy.Connection.Interface.MailNotification.DRAFT.
 */
static void
haze_svc_connection_interface_mail_notification_subscribe (HazeSvcConnectionInterfaceMailNotification *self,
    DBusGMethodInvocation *context)
{
  haze_svc_connection_interface_mail_notification_subscribe_impl impl = (HAZE_SVC_CONNECTION_INTERFACE_MAIL_NOTIFICATION_GET_CLASS (self)->subscribe);

  if (impl != NULL)
    {
      (impl) (self,
        context);
    }
  else
    {
      tp_dbus_g_method_return_not_implemented (context);
    }
}

/**
 * haze_svc_connection_interface_mail_notification_implement_subscribe:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the Subscribe D-Bus method
 *
 * Register an implementation for the Subscribe method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
void
haze_svc_connection_interface_mail_notification_implement_subscribe (HazeSvcConnectionInterfaceMailNotificationClass *klass, haze_svc_connection_interface_mail_notification_subscribe_impl impl)
{
  klass->subscribe = impl;
}

/**
 * haze_svc_connection_interface_mail_notification_unsubscribe_impl:
 * @self: The object implementing this interface
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * Unsubscribe on interface org.freedesktop.Telepathy.Connection.Interface.MailNotification.DRAFT.
 */
static void
haze_svc_connection_interface_mail_notification_unsubscribe (HazeSvcConnectionInterfaceMailNotification *self,
    DBusGMethodInvocation *context)
{
  haze_svc_connection_interface_mail_notification_unsubscribe_impl impl = (HAZE_SVC_CONNECTION_INTERFACE_MAIL_NOTIFICATION_GET_CLASS (self)->unsubscribe);

  if (impl != NULL)
    {
      (impl) (self,
        context);
    }
  else
    {
      tp_dbus_g_method_return_not_implemented (context);
    }
}

/**
 * haze_svc_connection_interface_mail_notification_implement_unsubscribe:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the Unsubscribe D-Bus method
 *
 * Register an implementation for the Unsubscribe method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
void
haze_svc_connection_interface_mail_notification_implement_unsubscribe (HazeSvcConnectionInterfaceMailNotificationClass *klass, haze_svc_connection_interface_mail_notification_unsubscribe_impl impl)
{
  klass->unsubscribe = impl;
}

/**
 * haze_svc_connection_interface_mail_notification_request_inbox_url_impl:
 * @self: The object implementing this interface
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * RequestInboxURL on interface org.freedesktop.Telepathy.Connection.Interface.MailNotification.DRAFT.
 */
static void
haze_svc_connection_interface_mail_notification_request_inbox_url (HazeSvcConnectionInterfaceMailNotification *self,
    DBusGMethodInvocation *context)
{
  haze_svc_connection_interface_mail_notification_request_inbox_url_impl impl = (HAZE_SVC_CONNECTION_INTERFACE_MAIL_NOTIFICATION_GET_CLASS (self)->request_inbox_url);

  if (impl != NULL)
    {
      (impl) (self,
        context);
    }
  else
    {
      tp_dbus_g_method_return_not_implemented (context);
    }
}

/**
 * haze_svc_connection_interface_mail_notification_implement_request_inbox_url:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the RequestInboxURL D-Bus method
 *
 * Register an implementation for the RequestInboxURL method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
void
haze_svc_connection_interface_mail_notification_implement_request_inbox_url (HazeSvcConnectionInterfaceMailNotificationClass *klass, haze_svc_connection_interface_mail_notification_request_inbox_url_impl impl)
{
  klass->request_inbox_url = impl;
}

/**
 * haze_svc_connection_interface_mail_notification_request_mail_url_impl:
 * @self: The object implementing this interface
 * @in_ID: const gchar * (FIXME, generate documentation)
 * @in_URL_Data: const GValue * (FIXME, generate documentation)
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * RequestMailURL on interface org.freedesktop.Telepathy.Connection.Interface.MailNotification.DRAFT.
 */
static void
haze_svc_connection_interface_mail_notification_request_mail_url (HazeSvcConnectionInterfaceMailNotification *self,
    const gchar *in_ID,
    const GValue *in_URL_Data,
    DBusGMethodInvocation *context)
{
  haze_svc_connection_interface_mail_notification_request_mail_url_impl impl = (HAZE_SVC_CONNECTION_INTERFACE_MAIL_NOTIFICATION_GET_CLASS (self)->request_mail_url);

  if (impl != NULL)
    {
      (impl) (self,
        in_ID,
        in_URL_Data,
        context);
    }
  else
    {
      tp_dbus_g_method_return_not_implemented (context);
    }
}

/**
 * haze_svc_connection_interface_mail_notification_implement_request_mail_url:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the RequestMailURL D-Bus method
 *
 * Register an implementation for the RequestMailURL method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
void
haze_svc_connection_interface_mail_notification_implement_request_mail_url (HazeSvcConnectionInterfaceMailNotificationClass *klass, haze_svc_connection_interface_mail_notification_request_mail_url_impl impl)
{
  klass->request_mail_url = impl;
}

/**
 * haze_svc_connection_interface_mail_notification_emit_mails_received:
 * @instance: The object implementing this interface
 * @arg_Mails: const GPtrArray * (FIXME, generate documentation)
 *
 * Type-safe wrapper around g_signal_emit to emit the
 * MailsReceived signal on interface org.freedesktop.Telepathy.Connection.Interface.MailNotification.DRAFT.
 */
void
haze_svc_connection_interface_mail_notification_emit_mails_received (gpointer instance,
    const GPtrArray *arg_Mails)
{
  g_assert (instance != NULL);
  g_assert (G_TYPE_CHECK_INSTANCE_TYPE (instance, HAZE_TYPE_SVC_CONNECTION_INTERFACE_MAIL_NOTIFICATION));
  g_signal_emit (instance,
      connection_interface_mail_notification_signals[SIGNAL_CONNECTION_INTERFACE_MAIL_NOTIFICATION_MailsReceived],
      0,
      arg_Mails);
}

/**
 * haze_svc_connection_interface_mail_notification_emit_unread_mails_changed:
 * @instance: The object implementing this interface
 * @arg_Count: guint  (FIXME, generate documentation)
 * @arg_Mails_Added: const GPtrArray * (FIXME, generate documentation)
 * @arg_Mails_Removed: const gchar ** (FIXME, generate documentation)
 *
 * Type-safe wrapper around g_signal_emit to emit the
 * UnreadMailsChanged signal on interface org.freedesktop.Telepathy.Connection.Interface.MailNotification.DRAFT.
 */
void
haze_svc_connection_interface_mail_notification_emit_unread_mails_changed (gpointer instance,
    guint arg_Count,
    const GPtrArray *arg_Mails_Added,
    const gchar **arg_Mails_Removed)
{
  g_assert (instance != NULL);
  g_assert (G_TYPE_CHECK_INSTANCE_TYPE (instance, HAZE_TYPE_SVC_CONNECTION_INTERFACE_MAIL_NOTIFICATION));
  g_signal_emit (instance,
      connection_interface_mail_notification_signals[SIGNAL_CONNECTION_INTERFACE_MAIL_NOTIFICATION_UnreadMailsChanged],
      0,
      arg_Count,
      arg_Mails_Added,
      arg_Mails_Removed);
}

static inline void
haze_svc_connection_interface_mail_notification_base_init_once (gpointer klass G_GNUC_UNUSED)
{
  static TpDBusPropertiesMixinPropInfo properties[5] = {
      { 0, TP_DBUS_PROPERTIES_MIXIN_FLAG_READ, "u", 0, NULL, NULL }, /* MailNotificationFlags */
      { 0, TP_DBUS_PROPERTIES_MIXIN_FLAG_READ, "u", 0, NULL, NULL }, /* UnreadMailCount */
      { 0, TP_DBUS_PROPERTIES_MIXIN_FLAG_READ, "aa{sv}", 0, NULL, NULL }, /* UnreadMails */
      { 0, TP_DBUS_PROPERTIES_MIXIN_FLAG_READ, "s", 0, NULL, NULL }, /* MailAddress */
      { 0, 0, NULL, 0, NULL, NULL }
  };
  static TpDBusPropertiesMixinIfaceInfo interface =
      { 0, properties, NULL, NULL };

  dbus_g_object_type_install_info (haze_svc_connection_interface_mail_notification_get_type (),
      &_haze_svc_connection_interface_mail_notification_object_info);

  interface.dbus_interface = g_quark_from_static_string ("org.freedesktop.Telepathy.Connection.Interface.MailNotification.DRAFT");
  properties[0].name = g_quark_from_static_string ("MailNotificationFlags");
  properties[0].type = G_TYPE_UINT;
  properties[1].name = g_quark_from_static_string ("UnreadMailCount");
  properties[1].type = G_TYPE_UINT;
  properties[2].name = g_quark_from_static_string ("UnreadMails");
  properties[2].type = (dbus_g_type_get_collection ("GPtrArray", (dbus_g_type_get_map ("GHashTable", G_TYPE_STRING, G_TYPE_VALUE))));
  properties[3].name = g_quark_from_static_string ("MailAddress");
  properties[3].type = G_TYPE_STRING;
  tp_svc_interface_set_dbus_properties_info (HAZE_TYPE_SVC_CONNECTION_INTERFACE_MAIL_NOTIFICATION, &interface);

  /**
   * HazeSvcConnectionInterfaceMailNotification::mails-received:
   * @arg_Mails: const GPtrArray * (FIXME, generate documentation)
   *
   * The MailsReceived D-Bus signal is emitted whenever this GObject signal is.
   */
  connection_interface_mail_notification_signals[SIGNAL_CONNECTION_INTERFACE_MAIL_NOTIFICATION_MailsReceived] =
  g_signal_new ("mails-received",
      G_OBJECT_CLASS_TYPE (klass),
      G_SIGNAL_RUN_LAST|G_SIGNAL_DETAILED,
      0,
      NULL, NULL,
      g_cclosure_marshal_VOID__BOXED,
      G_TYPE_NONE,
      1,
      (dbus_g_type_get_collection ("GPtrArray", (dbus_g_type_get_map ("GHashTable", G_TYPE_STRING, G_TYPE_VALUE)))));

  /**
   * HazeSvcConnectionInterfaceMailNotification::unread-mails-changed:
   * @arg_Count: guint  (FIXME, generate documentation)
   * @arg_Mails_Added: const GPtrArray * (FIXME, generate documentation)
   * @arg_Mails_Removed: const gchar ** (FIXME, generate documentation)
   *
   * The UnreadMailsChanged D-Bus signal is emitted whenever this GObject signal is.
   */
  connection_interface_mail_notification_signals[SIGNAL_CONNECTION_INTERFACE_MAIL_NOTIFICATION_UnreadMailsChanged] =
  g_signal_new ("unread-mails-changed",
      G_OBJECT_CLASS_TYPE (klass),
      G_SIGNAL_RUN_LAST|G_SIGNAL_DETAILED,
      0,
      NULL, NULL,
      _haze_ext_marshal_VOID__UINT_BOXED_BOXED,
      G_TYPE_NONE,
      3,
      G_TYPE_UINT,
      (dbus_g_type_get_collection ("GPtrArray", (dbus_g_type_get_map ("GHashTable", G_TYPE_STRING, G_TYPE_VALUE)))),
      G_TYPE_STRV);

}
static void
haze_svc_connection_interface_mail_notification_base_init (gpointer klass)
{
  static gboolean initialized = FALSE;

  if (!initialized)
    {
      initialized = TRUE;
      haze_svc_connection_interface_mail_notification_base_init_once (klass);
    }
}
static const DBusGMethodInfo _haze_svc_connection_interface_mail_notification_methods[] = {
  { (GCallback) haze_svc_connection_interface_mail_notification_subscribe, g_cclosure_marshal_VOID__POINTER, 0 },
  { (GCallback) haze_svc_connection_interface_mail_notification_unsubscribe, g_cclosure_marshal_VOID__POINTER, 83 },
  { (GCallback) haze_svc_connection_interface_mail_notification_request_inbox_url, g_cclosure_marshal_VOID__POINTER, 168 },
  { (GCallback) haze_svc_connection_interface_mail_notification_request_mail_url, _haze_ext_marshal_VOID__STRING_BOXED_POINTER, 277 },
};

static const DBusGObjectInfo _haze_svc_connection_interface_mail_notification_object_info = {
  0,
  _haze_svc_connection_interface_mail_notification_methods,
  4,
"org.freedesktop.Telepathy.Connection.Interface.MailNotification.DRAFT\0Subscribe\0A\0\0org.freedesktop.Telepathy.Connection.Interface.MailNotification.DRAFT\0Unsubscribe\0A\0\0org.freedesktop.Telepathy.Connection.Interface.MailNotification.DRAFT\0RequestInboxURL\0A\0URL\0O\0F\0N\0(sua(ss))\0\0org.freedesktop.Telepathy.Connection.Interface.MailNotification.DRAFT\0RequestMailURL\0A\0ID\0I\0s\0URL_Data\0I\0v\0URL\0O\0F\0N\0(sua(ss))\0\0\0",
"org.freedesktop.Telepathy.Connection.Interface.MailNotification.DRAFT\0MailsReceived\0org.freedesktop.Telepathy.Connection.Interface.MailNotification.DRAFT\0UnreadMailsChanged\0\0",
"\0\0",
};


