#define IN_TP_QT_HEADER
#include "TelepathyQt/call-content.h"

namespace Tp
{
namespace Client
{

CallContentInterface::CallContentInterface(const QString& busName, const QString& objectPath, QObject *parent)
    : Tp::AbstractInterface(busName, objectPath, staticInterfaceName(), QDBusConnection::sessionBus(), parent)
{
}

CallContentInterface::CallContentInterface(const QDBusConnection& connection, const QString& busName, const QString& objectPath, QObject *parent)
    : Tp::AbstractInterface(busName, objectPath, staticInterfaceName(), connection, parent)
{
}

CallContentInterface::CallContentInterface(Tp::DBusProxy *proxy)
    : Tp::AbstractInterface(proxy, staticInterfaceName())
{
}

void CallContentInterface::invalidate(Tp::DBusProxy *proxy,
        const QString &error, const QString &message)
{
    disconnect(this, SIGNAL(StreamsAdded(const Tp::ObjectPathList&)), NULL, NULL);
    disconnect(this, SIGNAL(StreamsRemoved(const Tp::ObjectPathList&, const Tp::CallStateReason&)), NULL, NULL);

    Tp::AbstractInterface::invalidate(proxy, error, message);
}

CallContentInterfaceAudioControlInterface::CallContentInterfaceAudioControlInterface(const QString& busName, const QString& objectPath, QObject *parent)
    : Tp::AbstractInterface(busName, objectPath, staticInterfaceName(), QDBusConnection::sessionBus(), parent)
{
}

CallContentInterfaceAudioControlInterface::CallContentInterfaceAudioControlInterface(const QDBusConnection& connection, const QString& busName, const QString& objectPath, QObject *parent)
    : Tp::AbstractInterface(busName, objectPath, staticInterfaceName(), connection, parent)
{
}

CallContentInterfaceAudioControlInterface::CallContentInterfaceAudioControlInterface(Tp::DBusProxy *proxy)
    : Tp::AbstractInterface(proxy, staticInterfaceName())
{
}

CallContentInterfaceAudioControlInterface::CallContentInterfaceAudioControlInterface(const Tp::Client::CallContentInterface& mainInterface)
    : Tp::AbstractInterface(mainInterface.service(), mainInterface.path(), staticInterfaceName(), mainInterface.connection(), mainInterface.parent())
{
}

CallContentInterfaceAudioControlInterface::CallContentInterfaceAudioControlInterface(const Tp::Client::CallContentInterface& mainInterface, QObject *parent)
    : Tp::AbstractInterface(mainInterface.service(), mainInterface.path(), staticInterfaceName(), mainInterface.connection(), parent)
{
}

void CallContentInterfaceAudioControlInterface::invalidate(Tp::DBusProxy *proxy,
        const QString &error, const QString &message)
{

    Tp::AbstractInterface::invalidate(proxy, error, message);
}

CallContentInterfaceDTMFInterface::CallContentInterfaceDTMFInterface(const QString& busName, const QString& objectPath, QObject *parent)
    : Tp::AbstractInterface(busName, objectPath, staticInterfaceName(), QDBusConnection::sessionBus(), parent)
{
}

CallContentInterfaceDTMFInterface::CallContentInterfaceDTMFInterface(const QDBusConnection& connection, const QString& busName, const QString& objectPath, QObject *parent)
    : Tp::AbstractInterface(busName, objectPath, staticInterfaceName(), connection, parent)
{
}

CallContentInterfaceDTMFInterface::CallContentInterfaceDTMFInterface(Tp::DBusProxy *proxy)
    : Tp::AbstractInterface(proxy, staticInterfaceName())
{
}

CallContentInterfaceDTMFInterface::CallContentInterfaceDTMFInterface(const Tp::Client::CallContentInterface& mainInterface)
    : Tp::AbstractInterface(mainInterface.service(), mainInterface.path(), staticInterfaceName(), mainInterface.connection(), mainInterface.parent())
{
}

CallContentInterfaceDTMFInterface::CallContentInterfaceDTMFInterface(const Tp::Client::CallContentInterface& mainInterface, QObject *parent)
    : Tp::AbstractInterface(mainInterface.service(), mainInterface.path(), staticInterfaceName(), mainInterface.connection(), parent)
{
}

void CallContentInterfaceDTMFInterface::invalidate(Tp::DBusProxy *proxy,
        const QString &error, const QString &message)
{
    disconnect(this, SIGNAL(TonesDeferred(const QString&)), NULL, NULL);
    disconnect(this, SIGNAL(SendingTones(const QString&)), NULL, NULL);
    disconnect(this, SIGNAL(StoppedTones(bool)), NULL, NULL);

    Tp::AbstractInterface::invalidate(proxy, error, message);
}

CallContentInterfaceMediaInterface::CallContentInterfaceMediaInterface(const QString& busName, const QString& objectPath, QObject *parent)
    : Tp::AbstractInterface(busName, objectPath, staticInterfaceName(), QDBusConnection::sessionBus(), parent)
{
}

CallContentInterfaceMediaInterface::CallContentInterfaceMediaInterface(const QDBusConnection& connection, const QString& busName, const QString& objectPath, QObject *parent)
    : Tp::AbstractInterface(busName, objectPath, staticInterfaceName(), connection, parent)
{
}

CallContentInterfaceMediaInterface::CallContentInterfaceMediaInterface(Tp::DBusProxy *proxy)
    : Tp::AbstractInterface(proxy, staticInterfaceName())
{
}

CallContentInterfaceMediaInterface::CallContentInterfaceMediaInterface(const Tp::Client::CallContentInterface& mainInterface)
    : Tp::AbstractInterface(mainInterface.service(), mainInterface.path(), staticInterfaceName(), mainInterface.connection(), mainInterface.parent())
{
}

CallContentInterfaceMediaInterface::CallContentInterfaceMediaInterface(const Tp::Client::CallContentInterface& mainInterface, QObject *parent)
    : Tp::AbstractInterface(mainInterface.service(), mainInterface.path(), staticInterfaceName(), mainInterface.connection(), parent)
{
}

void CallContentInterfaceMediaInterface::invalidate(Tp::DBusProxy *proxy,
        const QString &error, const QString &message)
{
    disconnect(this, SIGNAL(NewMediaDescriptionOffer(const QDBusObjectPath&, const QVariantMap&)), NULL, NULL);
    disconnect(this, SIGNAL(MediaDescriptionOfferDone()), NULL, NULL);
    disconnect(this, SIGNAL(LocalMediaDescriptionChanged(const QVariantMap&)), NULL, NULL);
    disconnect(this, SIGNAL(RemoteMediaDescriptionsChanged(const Tp::ContactMediaDescriptionPropertiesMap&)), NULL, NULL);
    disconnect(this, SIGNAL(MediaDescriptionsRemoved(const Tp::UIntList&)), NULL, NULL);
    disconnect(this, SIGNAL(DTMFChangeRequested(uchar, uint)), NULL, NULL);

    Tp::AbstractInterface::invalidate(proxy, error, message);
}

CallContentInterfaceVideoControlInterface::CallContentInterfaceVideoControlInterface(const QString& busName, const QString& objectPath, QObject *parent)
    : Tp::AbstractInterface(busName, objectPath, staticInterfaceName(), QDBusConnection::sessionBus(), parent)
{
}

CallContentInterfaceVideoControlInterface::CallContentInterfaceVideoControlInterface(const QDBusConnection& connection, const QString& busName, const QString& objectPath, QObject *parent)
    : Tp::AbstractInterface(busName, objectPath, staticInterfaceName(), connection, parent)
{
}

CallContentInterfaceVideoControlInterface::CallContentInterfaceVideoControlInterface(Tp::DBusProxy *proxy)
    : Tp::AbstractInterface(proxy, staticInterfaceName())
{
}

CallContentInterfaceVideoControlInterface::CallContentInterfaceVideoControlInterface(const Tp::Client::CallContentInterface& mainInterface)
    : Tp::AbstractInterface(mainInterface.service(), mainInterface.path(), staticInterfaceName(), mainInterface.connection(), mainInterface.parent())
{
}

CallContentInterfaceVideoControlInterface::CallContentInterfaceVideoControlInterface(const Tp::Client::CallContentInterface& mainInterface, QObject *parent)
    : Tp::AbstractInterface(mainInterface.service(), mainInterface.path(), staticInterfaceName(), mainInterface.connection(), parent)
{
}

void CallContentInterfaceVideoControlInterface::invalidate(Tp::DBusProxy *proxy,
        const QString &error, const QString &message)
{
    disconnect(this, SIGNAL(KeyFrameRequested()), NULL, NULL);
    disconnect(this, SIGNAL(VideoResolutionChanged(const Tp::VideoResolution&)), NULL, NULL);
    disconnect(this, SIGNAL(BitrateChanged(uint)), NULL, NULL);
    disconnect(this, SIGNAL(FramerateChanged(uint)), NULL, NULL);
    disconnect(this, SIGNAL(MTUChanged(uint)), NULL, NULL);

    Tp::AbstractInterface::invalidate(proxy, error, message);
}
}
}
