#include "TelepathyQt/_gen/svc-connection-manager.h"

#include "TelepathyQt/_gen/svc-connection-manager.moc.hpp"

#include <TelepathyQt/Constants>
#include <TelepathyQt/MethodInvocationContext>

namespace Tp
{
namespace Service
{

ConnectionManagerAdaptor::ConnectionManagerAdaptor(const QDBusConnection& bus, QObject* adaptee, QObject* parent)
    : Tp::AbstractAdaptor(bus, adaptee, parent)
{
    connect(adaptee, SIGNAL(newConnection(const QString&, const QDBusObjectPath&, const QString&)), SIGNAL(NewConnection(const QString&, const QDBusObjectPath&, const QString&)));
}

ConnectionManagerAdaptor::~ConnectionManagerAdaptor()
{
}

Tp::ProtocolPropertiesMap ConnectionManagerAdaptor::Protocols() const
{
    return qvariant_cast< Tp::ProtocolPropertiesMap >(adaptee()->property("protocols"));
}

QStringList ConnectionManagerAdaptor::Interfaces() const
{
    return qvariant_cast< QStringList >(adaptee()->property("interfaces"));
}

Tp::ParamSpecList ConnectionManagerAdaptor::GetParameters(const QString& protocol, const QDBusMessage& dbusMessage)
{
    if (adaptee()->metaObject()->indexOfMethod("getParameters(QString,Tp::Service::ConnectionManagerAdaptor::GetParametersContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return Tp::ParamSpecList();
    }

    GetParametersContextPtr ctx = GetParametersContextPtr(
            new Tp::MethodInvocationContext< Tp::ParamSpecList >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "getParameters",
        Q_ARG(QString, protocol),
        Q_ARG(Tp::Service::ConnectionManagerAdaptor::GetParametersContextPtr, ctx));
    return Tp::ParamSpecList();
}

QStringList ConnectionManagerAdaptor::ListProtocols(const QDBusMessage& dbusMessage)
{
    if (adaptee()->metaObject()->indexOfMethod("listProtocols(Tp::Service::ConnectionManagerAdaptor::ListProtocolsContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return QStringList();
    }

    ListProtocolsContextPtr ctx = ListProtocolsContextPtr(
            new Tp::MethodInvocationContext< QStringList >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "listProtocols",
        Q_ARG(Tp::Service::ConnectionManagerAdaptor::ListProtocolsContextPtr, ctx));
    return QStringList();
}

QString ConnectionManagerAdaptor::RequestConnection(const QString& protocol, const QVariantMap& parameters, const QDBusMessage& dbusMessage, QDBusObjectPath& objectPath)
{
    if (adaptee()->metaObject()->indexOfMethod("requestConnection(QString,QVariantMap,Tp::Service::ConnectionManagerAdaptor::RequestConnectionContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return QString();
    }

    RequestConnectionContextPtr ctx = RequestConnectionContextPtr(
            new Tp::MethodInvocationContext< QString, QDBusObjectPath >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "requestConnection",
        Q_ARG(QString, protocol), Q_ARG(QVariantMap, parameters),
        Q_ARG(Tp::Service::ConnectionManagerAdaptor::RequestConnectionContextPtr, ctx));
    return QString();
}

ProtocolAdaptor::ProtocolAdaptor(const QDBusConnection& bus, QObject* adaptee, QObject* parent)
    : Tp::AbstractAdaptor(bus, adaptee, parent)
{
}

ProtocolAdaptor::~ProtocolAdaptor()
{
}

QStringList ProtocolAdaptor::Interfaces() const
{
    return qvariant_cast< QStringList >(adaptee()->property("interfaces"));
}

Tp::ParamSpecList ProtocolAdaptor::Parameters() const
{
    return qvariant_cast< Tp::ParamSpecList >(adaptee()->property("parameters"));
}

QStringList ProtocolAdaptor::ConnectionInterfaces() const
{
    return qvariant_cast< QStringList >(adaptee()->property("connectionInterfaces"));
}

Tp::RequestableChannelClassList ProtocolAdaptor::RequestableChannelClasses() const
{
    return qvariant_cast< Tp::RequestableChannelClassList >(adaptee()->property("requestableChannelClasses"));
}

QString ProtocolAdaptor::VCardField() const
{
    return qvariant_cast< QString >(adaptee()->property("vcardField"));
}

QString ProtocolAdaptor::EnglishName() const
{
    return qvariant_cast< QString >(adaptee()->property("englishName"));
}

QString ProtocolAdaptor::Icon() const
{
    return qvariant_cast< QString >(adaptee()->property("icon"));
}

QStringList ProtocolAdaptor::AuthenticationTypes() const
{
    return qvariant_cast< QStringList >(adaptee()->property("authenticationTypes"));
}

QString ProtocolAdaptor::IdentifyAccount(const QVariantMap& parameters, const QDBusMessage& dbusMessage)
{
    if (adaptee()->metaObject()->indexOfMethod("identifyAccount(QVariantMap,Tp::Service::ProtocolAdaptor::IdentifyAccountContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return QString();
    }

    IdentifyAccountContextPtr ctx = IdentifyAccountContextPtr(
            new Tp::MethodInvocationContext< QString >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "identifyAccount",
        Q_ARG(QVariantMap, parameters),
        Q_ARG(Tp::Service::ProtocolAdaptor::IdentifyAccountContextPtr, ctx));
    return QString();
}

QString ProtocolAdaptor::NormalizeContact(const QString& contactID, const QDBusMessage& dbusMessage)
{
    if (adaptee()->metaObject()->indexOfMethod("normalizeContact(QString,Tp::Service::ProtocolAdaptor::NormalizeContactContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return QString();
    }

    NormalizeContactContextPtr ctx = NormalizeContactContextPtr(
            new Tp::MethodInvocationContext< QString >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "normalizeContact",
        Q_ARG(QString, contactID),
        Q_ARG(Tp::Service::ProtocolAdaptor::NormalizeContactContextPtr, ctx));
    return QString();
}

ProtocolInterfaceAddressingAdaptor::ProtocolInterfaceAddressingAdaptor(const QDBusConnection& bus, QObject* adaptee, QObject* parent)
    : Tp::AbstractAdaptor(bus, adaptee, parent)
{
}

ProtocolInterfaceAddressingAdaptor::~ProtocolInterfaceAddressingAdaptor()
{
}

QStringList ProtocolInterfaceAddressingAdaptor::AddressableVCardFields() const
{
    return qvariant_cast< QStringList >(adaptee()->property("addressableVCardFields"));
}

QStringList ProtocolInterfaceAddressingAdaptor::AddressableURISchemes() const
{
    return qvariant_cast< QStringList >(adaptee()->property("addressableURISchemes"));
}

QString ProtocolInterfaceAddressingAdaptor::NormalizeVCardAddress(const QString& VCardField, const QString& VCardAddress, const QDBusMessage& dbusMessage)
{
    if (adaptee()->metaObject()->indexOfMethod("normalizeVCardAddress(QString,QString,Tp::Service::ProtocolInterfaceAddressingAdaptor::NormalizeVCardAddressContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return QString();
    }

    NormalizeVCardAddressContextPtr ctx = NormalizeVCardAddressContextPtr(
            new Tp::MethodInvocationContext< QString >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "normalizeVCardAddress",
        Q_ARG(QString, VCardField), Q_ARG(QString, VCardAddress),
        Q_ARG(Tp::Service::ProtocolInterfaceAddressingAdaptor::NormalizeVCardAddressContextPtr, ctx));
    return QString();
}

QString ProtocolInterfaceAddressingAdaptor::NormalizeContactURI(const QString& URI, const QDBusMessage& dbusMessage)
{
    if (adaptee()->metaObject()->indexOfMethod("normalizeContactURI(QString,Tp::Service::ProtocolInterfaceAddressingAdaptor::NormalizeContactURIContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return QString();
    }

    NormalizeContactURIContextPtr ctx = NormalizeContactURIContextPtr(
            new Tp::MethodInvocationContext< QString >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "normalizeContactURI",
        Q_ARG(QString, URI),
        Q_ARG(Tp::Service::ProtocolInterfaceAddressingAdaptor::NormalizeContactURIContextPtr, ctx));
    return QString();
}

ProtocolInterfaceAvatarsAdaptor::ProtocolInterfaceAvatarsAdaptor(const QDBusConnection& bus, QObject* adaptee, QObject* parent)
    : Tp::AbstractAdaptor(bus, adaptee, parent)
{
}

ProtocolInterfaceAvatarsAdaptor::~ProtocolInterfaceAvatarsAdaptor()
{
}

QStringList ProtocolInterfaceAvatarsAdaptor::SupportedAvatarMIMETypes() const
{
    return qvariant_cast< QStringList >(adaptee()->property("supportedAvatarMIMETypes"));
}

uint ProtocolInterfaceAvatarsAdaptor::MinimumAvatarHeight() const
{
    return qvariant_cast< uint >(adaptee()->property("minimumAvatarHeight"));
}

uint ProtocolInterfaceAvatarsAdaptor::MinimumAvatarWidth() const
{
    return qvariant_cast< uint >(adaptee()->property("minimumAvatarWidth"));
}

uint ProtocolInterfaceAvatarsAdaptor::RecommendedAvatarHeight() const
{
    return qvariant_cast< uint >(adaptee()->property("recommendedAvatarHeight"));
}

uint ProtocolInterfaceAvatarsAdaptor::RecommendedAvatarWidth() const
{
    return qvariant_cast< uint >(adaptee()->property("recommendedAvatarWidth"));
}

uint ProtocolInterfaceAvatarsAdaptor::MaximumAvatarHeight() const
{
    return qvariant_cast< uint >(adaptee()->property("maximumAvatarHeight"));
}

uint ProtocolInterfaceAvatarsAdaptor::MaximumAvatarWidth() const
{
    return qvariant_cast< uint >(adaptee()->property("maximumAvatarWidth"));
}

uint ProtocolInterfaceAvatarsAdaptor::MaximumAvatarBytes() const
{
    return qvariant_cast< uint >(adaptee()->property("maximumAvatarBytes"));
}

ProtocolInterfacePresenceAdaptor::ProtocolInterfacePresenceAdaptor(const QDBusConnection& bus, QObject* adaptee, QObject* parent)
    : Tp::AbstractAdaptor(bus, adaptee, parent)
{
}

ProtocolInterfacePresenceAdaptor::~ProtocolInterfacePresenceAdaptor()
{
}

Tp::SimpleStatusSpecMap ProtocolInterfacePresenceAdaptor::Statuses() const
{
    return qvariant_cast< Tp::SimpleStatusSpecMap >(adaptee()->property("statuses"));
}

}
}