/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSFloat32Array.h"

#include "ExceptionCode.h"
#include "JSArrayBufferViewHelper.h"
#include "JSDOMBinding.h"
#include "JSFloat32Array.h"
#include <runtime/Error.h>
#include <runtime/PropertyNameArray.h>
#include <wtf/Float32Array.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSFloat32ArrayTableValues[] =
{
    { "length", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFloat32ArrayLength), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFloat32ArrayConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSFloat32ArrayTable = { 5, 3, JSFloat32ArrayTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSFloat32ArrayConstructorTableValues[] =
{
    { "BYTES_PER_ELEMENT", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFloat32ArrayBYTES_PER_ELEMENT), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSFloat32ArrayConstructorTable = { 2, 1, JSFloat32ArrayConstructorTableValues, 0 };
EncodedJSValue JSC_HOST_CALL JSFloat32ArrayConstructor::constructJSFloat32Array(ExecState* exec)
{
    JSFloat32ArrayConstructor* jsConstructor = jsCast<JSFloat32ArrayConstructor*>(exec->callee());
    RefPtr<Float32Array> array = constructArrayBufferView<Float32Array, float>(exec);
    if (!array.get())
        // Exception has already been thrown.
        return JSValue::encode(JSValue());
    return JSValue::encode(asObject(toJS(exec, jsConstructor->globalObject(), array.get())));
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, Float32Array* object)
{
    return toJSArrayBufferView<JSFloat32Array>(exec, globalObject, object);
}

void JSFloat32Array::indexSetter(JSC::ExecState* exec, unsigned index, JSC::JSValue value)
{
    impl()->set(index, value.toNumber(exec));
}

static const HashTable* getJSFloat32ArrayConstructorTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->globalData(), &JSFloat32ArrayConstructorTable);
}

const ClassInfo JSFloat32ArrayConstructor::s_info = { "Float32ArrayConstructor", &Base::s_info, 0, getJSFloat32ArrayConstructorTable, CREATE_METHOD_TABLE(JSFloat32ArrayConstructor) };

JSFloat32ArrayConstructor::JSFloat32ArrayConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSFloat32ArrayConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSFloat32ArrayPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->globalData(), exec->propertyNames().length, jsNumber(1), ReadOnly | DontDelete | DontEnum);
}

bool JSFloat32ArrayConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSFloat32ArrayConstructor, JSDOMWrapper>(exec, getJSFloat32ArrayConstructorTable(exec), jsCast<JSFloat32ArrayConstructor*>(cell), propertyName, slot);
}

bool JSFloat32ArrayConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSFloat32ArrayConstructor, JSDOMWrapper>(exec, getJSFloat32ArrayConstructorTable(exec), jsCast<JSFloat32ArrayConstructor*>(object), propertyName, descriptor);
}

ConstructType JSFloat32ArrayConstructor::getConstructData(JSCell*, ConstructData& constructData)
{
    constructData.native.function = constructJSFloat32Array;
    return ConstructTypeHost;
}

/* Hash table for prototype */

static const HashTableValue JSFloat32ArrayPrototypeTableValues[] =
{
    { "BYTES_PER_ELEMENT", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFloat32ArrayBYTES_PER_ELEMENT), (intptr_t)0, NoIntrinsic },
    { "subarray", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsFloat32ArrayPrototypeFunctionSubarray), (intptr_t)2, NoIntrinsic },
    { "set", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsFloat32ArrayPrototypeFunctionSet), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSFloat32ArrayPrototypeTable = { 8, 7, JSFloat32ArrayPrototypeTableValues, 0 };
static const HashTable* getJSFloat32ArrayPrototypeTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->globalData(), &JSFloat32ArrayPrototypeTable);
}

const ClassInfo JSFloat32ArrayPrototype::s_info = { "Float32ArrayPrototype", &Base::s_info, 0, getJSFloat32ArrayPrototypeTable, CREATE_METHOD_TABLE(JSFloat32ArrayPrototype) };

JSObject* JSFloat32ArrayPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSFloat32Array>(exec, globalObject);
}

bool JSFloat32ArrayPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSFloat32ArrayPrototype* thisObject = jsCast<JSFloat32ArrayPrototype*>(cell);
    return getStaticPropertySlot<JSFloat32ArrayPrototype, JSObject>(exec, getJSFloat32ArrayPrototypeTable(exec), thisObject, propertyName, slot);
}

bool JSFloat32ArrayPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSFloat32ArrayPrototype* thisObject = jsCast<JSFloat32ArrayPrototype*>(object);
    return getStaticPropertyDescriptor<JSFloat32ArrayPrototype, JSObject>(exec, getJSFloat32ArrayPrototypeTable(exec), thisObject, propertyName, descriptor);
}

static const HashTable* getJSFloat32ArrayTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->globalData(), &JSFloat32ArrayTable);
}

const ClassInfo JSFloat32Array::s_info = { "Float32Array", &Base::s_info, 0, getJSFloat32ArrayTable , CREATE_METHOD_TABLE(JSFloat32Array) };

JSFloat32Array::JSFloat32Array(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<Float32Array> impl)
    : JSArrayBufferView(structure, globalObject, impl)
{
}

void JSFloat32Array::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    TypedArrayDescriptor descriptor(&JSFloat32Array::s_info, OBJECT_OFFSETOF(JSFloat32Array, m_storage), OBJECT_OFFSETOF(JSFloat32Array, m_storageLength));
    globalData.registerTypedArrayDescriptor(impl(), descriptor);
    m_storage = impl()->data();
    m_storageLength = impl()->length();
    ASSERT(inherits(&s_info));
}

JSObject* JSFloat32Array::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSFloat32ArrayPrototype::create(exec->globalData(), globalObject, JSFloat32ArrayPrototype::createStructure(exec->globalData(), globalObject, JSArrayBufferViewPrototype::self(exec, globalObject)));
}

bool JSFloat32Array::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSFloat32Array* thisObject = jsCast<JSFloat32Array*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    unsigned index = propertyName.asIndex();
    if (index != PropertyName::NotAnIndex && index < static_cast<Float32Array*>(thisObject->impl())->length()) {
        slot.setValue(thisObject->getByIndex(exec, index));
        return true;
    }
    return getStaticValueSlot<JSFloat32Array, Base>(exec, getJSFloat32ArrayTable(exec), thisObject, propertyName, slot);
}

bool JSFloat32Array::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSFloat32Array* thisObject = jsCast<JSFloat32Array*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    unsigned index = propertyName.asIndex();
    if (index != PropertyName::NotAnIndex && index < static_cast<Float32Array*>(thisObject->impl())->length()) {
        descriptor.setDescriptor(thisObject->getByIndex(exec, index), DontDelete);
        return true;
    }
    return getStaticValueDescriptor<JSFloat32Array, Base>(exec, getJSFloat32ArrayTable(exec), thisObject, propertyName, descriptor);
}

bool JSFloat32Array::getOwnPropertySlotByIndex(JSCell* cell, ExecState* exec, unsigned index, PropertySlot& slot)
{
    JSFloat32Array* thisObject = jsCast<JSFloat32Array*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    if (index < static_cast<Float32Array*>(thisObject->impl())->length()) {
        slot.setValue(thisObject->getByIndex(exec, index));
        return true;
    }
    return Base::getOwnPropertySlotByIndex(thisObject, exec, index, slot);
}

JSValue jsFloat32ArrayLength(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSFloat32Array* castedThis = jsCast<JSFloat32Array*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Float32Array* impl = static_cast<Float32Array*>(castedThis->impl());
    JSValue result = jsNumber(impl->length());
    return result;
}


JSValue jsFloat32ArrayConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSFloat32Array* domObject = jsCast<JSFloat32Array*>(asObject(slotBase));
    return JSFloat32Array::getConstructor(exec, domObject->globalObject());
}

void JSFloat32Array::put(JSCell* cell, ExecState* exec, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    JSFloat32Array* thisObject = jsCast<JSFloat32Array*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    unsigned index = propertyName.asIndex();
    if (index != PropertyName::NotAnIndex) {
        thisObject->indexSetter(exec, index, value);
        return;
    }
    Base::put(thisObject, exec, propertyName, value, slot);
}

void JSFloat32Array::putByIndex(JSCell* cell, ExecState* exec, unsigned index, JSValue value, bool shouldThrow)
{
    JSFloat32Array* thisObject = jsCast<JSFloat32Array*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    if (index <= MAX_ARRAY_INDEX) {
        UNUSED_PARAM(shouldThrow);
        thisObject->indexSetter(exec, index, value);
        return;
    }
    Base::putByIndex(cell, exec, index, value, shouldThrow);
}

void JSFloat32Array::getOwnPropertyNames(JSObject* object, ExecState* exec, PropertyNameArray& propertyNames, EnumerationMode mode)
{
    JSFloat32Array* thisObject = jsCast<JSFloat32Array*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    for (unsigned i = 0; i < static_cast<Float32Array*>(thisObject->impl())->length(); ++i)
        propertyNames.add(Identifier::from(exec, i));
     Base::getOwnPropertyNames(thisObject, exec, propertyNames, mode);
}

JSValue JSFloat32Array::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSFloat32ArrayConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsFloat32ArrayPrototypeFunctionSubarray(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSFloat32Array::s_info))
        return throwVMTypeError(exec);
    JSFloat32Array* castedThis = jsCast<JSFloat32Array*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSFloat32Array::s_info);
    Float32Array* impl = static_cast<Float32Array*>(castedThis->impl());
    int start(exec->argument(0).toInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    size_t argsCount = exec->argumentCount();
    if (argsCount <= 1) {

        JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->subarray(start)));
        return JSValue::encode(result);
    }

    int end(exec->argument(1).toInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->subarray(start, end)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsFloat32ArrayPrototypeFunctionSet(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSFloat32Array::s_info))
        return throwVMTypeError(exec);
    JSFloat32Array* castedThis = jsCast<JSFloat32Array*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSFloat32Array::s_info);
    return JSValue::encode(setWebGLArrayHelper<Float32Array, float>(exec, castedThis->impl()));
}

// Constant getters

JSValue jsFloat32ArrayBYTES_PER_ELEMENT(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(4));
}


JSValue JSFloat32Array::getByIndex(ExecState*, unsigned index)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    double result = static_cast<Float32Array*>(impl())->item(index);
    if (std::isnan(result))
        return jsNaN();
    return JSValue(result);
}

Float32Array* toFloat32Array(JSC::JSValue value)
{
    return value.inherits(&JSFloat32Array::s_info) ? jsCast<JSFloat32Array*>(asObject(value))->impl() : 0;
}

}
